/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class AutoFilter12Record
extends StandardRecord {
    public static final short sid = 2174;
    private byte[] _frtRefHeader = new byte[12];
    private short _iEntry;
    private int _fHideArrow;
    private int _ft;
    private int _cft;
    private int _cCriteria;
    private int _cDateGroupings;
    private short _flags;
    private int _unused2;
    private int _idList;
    private byte[] _guidSview = new byte[16];
    private AF12Criteria[] _rgCriteria;
    private static final BitField opt_A = new BitField(49152);
    private static final BitField opt_B = new BitField(8192);

    public AutoFilter12Record() {
    }

    public AutoFilter12Record(RecordInputStream in) {
        in.read(this._frtRefHeader, 0, 12);
        this._iEntry = in.readShort();
        this._fHideArrow = in.readInt();
        this._ft = in.readInt();
        this._cft = in.readInt();
        this._cCriteria = in.readInt();
        this._cDateGroupings = in.readInt();
        this._flags = in.readShort();
        this._unused2 = in.readInt();
        this._idList = in.readInt();
        in.read(this._guidSview, 0, 16);
        if (this._ft != 0) {
            // empty if block
        }
        if (this._cDateGroupings != 0) {
            // empty if block
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AUTOFILTER12]\n");
        buffer.append("    ._frtRefHeader          = ").append(HexDump.toHex(this._frtRefHeader)).append("\n");
        buffer.append("    ._iEntry                = ").append(this._iEntry).append("\n");
        buffer.append("    ._fHideArrow            = ").append(this._fHideArrow).append("\n");
        buffer.append("    ._ft                    = ").append(this._ft).append("\n");
        buffer.append("    ._cft                   = ").append(this._cft).append("\n");
        buffer.append("    ._cCriteria             = ").append(this._cCriteria).append("\n");
        buffer.append("    ._cDateGroupings        = ").append(this._cDateGroupings).append("\n");
        buffer.append("    ._flags                 = ").append(this._flags).append("\n");
        buffer.append("        .A                  = ").append(opt_A.getShortRawValue(this._flags)).append("\n");
        buffer.append("        .B                  = ").append(opt_B.getShortRawValue(this._flags)).append("\n");
        buffer.append("    ._idList                = ").append(this._idList).append("\n");
        buffer.append("    ._guidSview             = ").append(HexDump.toHex(this._guidSview)).append("\n");
        buffer.append("[/AUTOFILTER12]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
    }

    @Override
    protected int getDataSize() {
        return 2;
    }

    @Override
    public short getSid() {
        return 2174;
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    public int getCCriteria() {
        return this._cCriteria;
    }

    public class AF12Criteria {
        byte[] doper = new byte[10];
        String str;
        int length;
    }
}

