/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xwpf.model;

import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.zkoss.poi.xwpf.model.XWPFParagraphDecorator;
import org.zkoss.poi.xwpf.usermodel.XWPFComment;
import org.zkoss.poi.xwpf.usermodel.XWPFParagraph;

public class XWPFCommentsDecorator
extends XWPFParagraphDecorator {
    private StringBuffer commentText = new StringBuffer();

    public XWPFCommentsDecorator(XWPFParagraphDecorator nextDecorator) {
        this(nextDecorator.paragraph, nextDecorator);
    }

    public XWPFCommentsDecorator(XWPFParagraph paragraph, XWPFParagraphDecorator nextDecorator) {
        super(paragraph, nextDecorator);
        for (CTMarkupRange anchor : paragraph.getCTP().getCommentRangeStartList()) {
            XWPFComment comment = paragraph.getDocument().getCommentByID(anchor.getId().toString());
            if (comment == null) continue;
            this.commentText.append("\tComment by " + comment.getAuthor() + ": " + comment.getText());
        }
    }

    public String getCommentText() {
        return this.commentText.toString();
    }

    @Override
    public String getText() {
        return super.getText() + this.commentText;
    }
}

