/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record;

import java.util.Arrays;
import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.common.FtrHeader;
import org.zkoss.poi.hssf.record.common.UnicodeString;
import org.zkoss.poi.hssf.record.cont.ContinuableRecord;
import org.zkoss.poi.hssf.record.cont.ContinuableRecordOutput;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;

public final class HeaderFooterRecord
extends ContinuableRecord {
    private static final byte[] BLANK_GUID = new byte[16];
    private static final BitField fHFDiffOddEven = BitFieldFactory.getInstance(1);
    private static final BitField fHFDiffFirst = BitFieldFactory.getInstance(2);
    private static final BitField fHFScaleWidthDoc = BitFieldFactory.getInstance(4);
    private static final BitField fHFAlignMargins = BitFieldFactory.getInstance(8);
    private FtrHeader futureHeader;
    byte[] guidSView = new byte[16];
    private short bits;
    private short cchHeaderEven;
    private short cchFooterEven;
    private short cchHeaderFirst;
    private short cchFooterFirst;
    private UnicodeString strHeaderEven;
    private UnicodeString strFooterEven;
    private UnicodeString strHeaderFirst;
    private UnicodeString strFooterFirst;
    public static final short sid = 2204;

    public HeaderFooterRecord() {
        this.futureHeader = new FtrHeader();
        this.futureHeader.setRecordType((short)2204);
    }

    public HeaderFooterRecord(RecordInputStream in) {
        this.futureHeader = new FtrHeader(in);
        in.read(this.guidSView, 0, 16);
        this.bits = in.readShort();
        this.cchHeaderEven = in.readShort();
        this.cchFooterEven = in.readShort();
        this.cchHeaderFirst = in.readShort();
        this.cchFooterFirst = in.readShort();
        if (this.cchHeaderEven > 0) {
            this.strHeaderEven = new UnicodeString(in);
        }
        if (this.cchFooterEven > 0) {
            this.strFooterEven = new UnicodeString(in);
        }
        if (this.cchHeaderFirst > 0) {
            this.strHeaderFirst = new UnicodeString(in);
        }
        if (this.cchFooterFirst > 0) {
            this.strFooterFirst = new UnicodeString(in);
        }
    }

    @Override
    public short getSid() {
        return 2204;
    }

    public byte[] getGuid() {
        return this.guidSView;
    }

    public void setGuid(byte[] guid) {
        this.guidSView = Arrays.copyOf(guid, 16);
    }

    public boolean isCurrentSheet() {
        return Arrays.equals(this.getGuid(), BLANK_GUID);
    }

    public boolean isDiffOddEven() {
        return fHFDiffOddEven.isSet(this.bits);
    }

    public void setDiffOddEven(boolean flag) {
        this.bits = (short)fHFDiffOddEven.setBoolean(this.bits, flag);
        if (!flag) {
            this.setHeaderEven(null);
            this.setFooterEven(null);
        }
    }

    public boolean isDiffFirst() {
        return fHFDiffFirst.isSet(this.bits);
    }

    public void setDiffFirst(boolean flag) {
        this.bits = (short)fHFDiffFirst.setBoolean(this.bits, flag);
        if (!flag) {
            this.setHeaderFirst(null);
            this.setFooterFirst(null);
        }
    }

    public boolean isScaleWithDoc() {
        return fHFScaleWidthDoc.isSet(this.bits);
    }

    public void setScaleWithDoc(boolean flag) {
        this.bits = (short)fHFScaleWidthDoc.setBoolean(this.bits, flag);
    }

    public boolean isAlignMargins() {
        return fHFAlignMargins.isSet(this.bits);
    }

    public void setAlignMargins(boolean flag) {
        this.bits = (short)fHFAlignMargins.setBoolean(this.bits, flag);
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public String getHeaderEven() {
        return this.strHeaderEven == null ? "" : this.strHeaderEven.getString();
    }

    public void setHeaderEven(String str) {
        boolean empty = this.isEmpty(str);
        this.strHeaderEven = empty ? null : new UnicodeString(str);
        this.cchHeaderEven = empty ? (short)0 : this.strHeaderEven.getCharCountShort();
    }

    public String getFooterEven() {
        return this.strFooterEven == null ? "" : this.strFooterEven.getString();
    }

    public void setFooterEven(String str) {
        boolean empty = this.isEmpty(str);
        this.strFooterEven = empty ? null : new UnicodeString(str);
        this.cchFooterEven = empty ? (short)0 : this.strFooterEven.getCharCountShort();
    }

    public String getHeaderFirst() {
        return this.strHeaderFirst == null ? "" : this.strHeaderFirst.getString();
    }

    public void setHeaderFirst(String str) {
        boolean empty = this.isEmpty(str);
        this.strHeaderFirst = empty ? null : new UnicodeString(str);
        this.cchHeaderFirst = empty ? (short)0 : this.strHeaderFirst.getCharCountShort();
    }

    public String getFooterFirst() {
        return this.strFooterFirst == null ? "" : this.strFooterFirst.getString();
    }

    public void setFooterFirst(String str) {
        boolean empty = this.isEmpty(str);
        this.strFooterFirst = empty ? null : new UnicodeString(str);
        this.cchFooterFirst = empty ? (short)0 : this.strFooterFirst.getCharCountShort();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HEADERFOOTER]\n");
        buffer.append(this.futureHeader.toString());
        buffer.append("    .guidSView  = ").append(HexDump.toHex(this.guidSView)).append("\n");
        buffer.append("    .bits       = ").append(Integer.toHexString(this.bits)).append("\n");
        buffer.append("       .fHFDiffOddEven      = ").append(this.isDiffOddEven()).append("\n");
        buffer.append("       .fHFDiffFirst        = ").append(this.isDiffFirst()).append("\n");
        buffer.append("       .fHFScaleWithDoc     = ").append(this.isScaleWithDoc()).append("\n");
        buffer.append("       .fHFAlignMargins     = ").append(this.isAlignMargins()).append("\n");
        buffer.append("    .cchHeaderEven  = ").append(Integer.toString(this.cchHeaderEven)).append("\n");
        buffer.append("    .cchFooterEven  = ").append(Integer.toString(this.cchFooterEven)).append("\n");
        buffer.append("    .cchHeaderFirst = ").append(Integer.toString(this.cchHeaderFirst)).append("\n");
        buffer.append("    .cchFooterFirst = ").append(Integer.toString(this.cchFooterFirst)).append("\n");
        buffer.append("    .strHeaderEven  = ").append(this.strHeaderEven == null ? "(n/a)" : this.strHeaderEven.getDebugInfo()).append("\n");
        buffer.append("    .strFooterEven  = ").append(this.strFooterEven == null ? "(n/a)" : this.strFooterEven.getDebugInfo()).append("\n");
        buffer.append("    .strHeaderFirst = ").append(this.strHeaderFirst == null ? "(n/a)" : this.strHeaderFirst.getDebugInfo()).append("\n");
        buffer.append("    .strFooterFirst = ").append(this.strFooterFirst == null ? "(n/a)" : this.strFooterFirst.getDebugInfo()).append("\n");
        buffer.append("[/HEADERFOOTER]\n");
        return buffer.toString();
    }

    @Override
    public Object clone() {
        return this.cloneViaReserialise();
    }

    @Override
    protected void serialize(ContinuableRecordOutput out) {
        this.futureHeader.serialize(out);
        out.write(this.guidSView);
        out.writeShort(this.bits);
        out.writeShort(this.cchHeaderEven);
        out.writeShort(this.cchFooterEven);
        out.writeShort(this.cchHeaderFirst);
        out.writeShort(this.cchFooterFirst);
        if (this.cchHeaderEven > 0) {
            this.strHeaderEven.serialize(out);
        }
        if (this.cchFooterEven > 0) {
            this.strFooterEven.serialize(out);
        }
        if (this.cchHeaderFirst > 0) {
            this.strHeaderFirst.serialize(out);
        }
        if (this.cchFooterFirst > 0) {
            this.strFooterFirst.serialize(out);
        }
    }
}

