/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.theme;

import java.io.IOException;
import java.util.Properties;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.MAttachment;
import org.compiere.model.MClientInfo;
import org.compiere.model.MImage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUserDefTheme;
import org.compiere.model.MUserDefThemeDetail;
import org.compiere.model.SystemProperties;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;

public final class ThemeManager {
    public static final String ZK_PREFIX_FOR_CLASSPATH_RESOURCE = "/web";
    public static final String ZK_URL_PREFIX_FOR_CLASSPATH_RESOURCE = "~./";
    private static CLogger log = CLogger.getCLogger(ThemeManager.class);
    private static String m_theme = "iceblue_c";
    private static String m_brokenTheme = null;
    public static String THEME_PATH_PREFIX = "~./theme/";
    private static final CCache<String, Boolean> s_themeHasCustomCSSCache = new CCache(null, "ThemeHasCustomCSSCache", 2, 0, false, 0);

    public static String getLargeLogo() {
        String theme = ThemeManager.getTheme();
        String def = THEME_PATH_PREFIX + theme + "/images/login-logo.png";
        return MSysConfig.getValue((String)"ZK_LOGO_LARGE", (String)def);
    }

    public static String getSmallLogo() {
        String theme = ThemeManager.getTheme();
        String def = THEME_PATH_PREFIX + theme + "/images/header-logo.png";
        String url = MSysConfig.getValue((String)"ZK_LOGO_SMALL", null);
        if (url == null) {
            url = MSysConfig.getValue((String)"WEBUI_LOGOURL", (String)def);
        }
        return url;
    }

    public static String getTheme() {
        String theme = SystemProperties.getZkTheme();
        if (Util.isEmpty((String)theme)) {
            theme = MSysConfig.getValue((String)"ZK_THEME", (String)"iceblue_c");
        }
        if (theme.equals(m_brokenTheme)) {
            theme = "iceblue_c";
        } else if (!theme.equals(m_theme)) {
            if (!"iceblue_c".equals(theme)) {
                Object themeCSSURL = ThemeManager.getStyleSheet(theme);
                if (ThemeManager.class.getResource(ThemeManager.toClassPathResourcePath((String)themeCSSURL)) == null) {
                    themeCSSURL = "/theme/" + theme + "/css/theme.css.dsp";
                    if (ThemeManager.class.getResource(ThemeManager.toClassPathResourcePath((String)themeCSSURL)) != null) {
                        THEME_PATH_PREFIX = "/theme/";
                    } else {
                        log.warning("The theme " + theme + " does not exist or is not properly configured, falling back to iceblue_c");
                        m_brokenTheme = theme;
                        THEME_PATH_PREFIX = "~./theme/";
                        theme = "iceblue_c";
                    }
                }
            } else {
                THEME_PATH_PREFIX = "~./theme/";
            }
            m_theme = theme;
        }
        return theme;
    }

    public static String getStyleSheet() {
        return ThemeManager.getStyleSheet(ThemeManager.getTheme());
    }

    public static String getStyleSheet(String theme) {
        return THEME_PATH_PREFIX + theme + "/css/theme.css.dsp";
    }

    public static String getUserDefineStyleSheet() {
        MUserDefTheme userDef = MUserDefTheme.getBestMatch((Properties)Env.getCtx(), (String)ThemeManager.getTheme());
        if (userDef != null && !Util.isEmpty((String)userDef.getStylesheet())) {
            String styleSheet = userDef.getStylesheet();
            if (styleSheet.toLowerCase().startsWith("https://")) {
                return styleSheet;
            }
            if (MAttachment.isAttachmentURLPath((String)styleSheet)) {
                return MAttachment.getStyleSheetAttachmentURLFromPath(null, (String)styleSheet);
            }
            return THEME_PATH_PREFIX + ThemeManager.getTheme() + styleSheet;
        }
        return null;
    }

    public static String getStyleSheetByBrowser() {
        return THEME_PATH_PREFIX + ThemeManager.getTheme() + "/css/theme*.css.dsp*";
    }

    public static String getPreference() {
        return THEME_PATH_PREFIX + ThemeManager.getTheme() + "/preference.zul";
    }

    public static String getBrowserTitle() {
        return AEnv.getDesktop().getWebApp().getAppName();
    }

    public static String getBrowserIcon() {
        String theme = ThemeManager.getTheme();
        String def = THEME_PATH_PREFIX + theme + "/images/icon.png";
        return MSysConfig.getValue((String)"ZK_BROWSER_ICON", (String)def);
    }

    public static String getThemeResource(String name) {
        MUserDefThemeDetail userDef = MUserDefThemeDetail.get((Properties)Env.getCtx(), (String)ThemeManager.getTheme(), (String)name);
        if (userDef != null && !Util.isEmpty((String)userDef.getNewValue())) {
            name = userDef.getNewValue();
            if (name.startsWith("https://")) {
                return name;
            }
            if (MAttachment.isAttachmentURLPath((String)name)) {
                return MAttachment.getImageAttachmentURLFromPath(null, (String)name);
            }
        }
        StringBuilder builder = new StringBuilder(THEME_PATH_PREFIX);
        builder.append(ThemeManager.getTheme());
        builder.append("/").append(name);
        String url = builder.toString().intern();
        return url;
    }

    public static Image getClientWebLogo() throws IOException {
        MClientInfo cinfo = MClientInfo.get((Properties)Env.getCtx());
        if (cinfo.getLogoWeb_ID() > 0) {
            MImage mImage = MImage.get((Properties)Env.getCtx(), (int)cinfo.getLogoWeb_ID());
            if (mImage.getData() != null) {
                return new AImage(mImage.getName(), mImage.getData());
            }
            return null;
        }
        return null;
    }

    public static Boolean isThemeHasCustomCSSFragment() {
        String theme = ThemeManager.getTheme();
        Boolean flag = (Boolean)s_themeHasCustomCSSCache.get((Object)theme);
        if (flag != null) {
            return flag;
        }
        String customCSSURL = THEME_PATH_PREFIX + theme + "/css/fragment/custom.css.dsp";
        flag = ThemeManager.class.getResource(ThemeManager.toClassPathResourcePath(customCSSURL)) == null ? Boolean.FALSE : Boolean.TRUE;
        s_themeHasCustomCSSCache.put((Object)theme, (Object)flag);
        return flag;
    }

    public static boolean isUseCSSForWindowSize() {
        return "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_CSS_FOR_WINDOW_SIZE"));
    }

    public static boolean isUseFontIconForImage() {
        return "Y".equals(Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"));
    }

    public static String toClassPathResourcePath(String zkResourceURL) {
        if (zkResourceURL == null) {
            return zkResourceURL;
        }
        if (!zkResourceURL.startsWith(ZK_URL_PREFIX_FOR_CLASSPATH_RESOURCE)) {
            return zkResourceURL;
        }
        return ZK_PREFIX_FOR_CLASSPATH_RESOURCE + zkResourceURL.substring(2);
    }

    public static String getIconSclass(String imagePath) {
        Object iconSclass = null;
        if (!Util.isEmpty((String)imagePath, (boolean)true)) {
            iconSclass = imagePath.substring(imagePath.lastIndexOf("/") + 1, imagePath.lastIndexOf("."));
            if (((String)iconSclass).length() > 2) {
                iconSclass = ((String)iconSclass).startsWith("m") && Character.isUpperCase(((String)iconSclass).charAt(1)) ? ((String)iconSclass).substring(1) : iconSclass;
            }
            iconSclass = ((String)iconSclass).replaceAll("(\\d\\d)$", "");
            iconSclass = "z-icon-" + (String)iconSclass;
        }
        return iconSclass;
    }
}

