/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.ckez;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkforge.ckez.CkezFileWriter;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;

public class CKeditor
extends AbstractComponent {
    private static final Logger logger = LoggerFactory.getLogger(CKeditor.class);
    private static String _fileBrowserTempl = "~./ckez/html/browse.zul";
    private static String _fileUploadHandlePage = "";
    private String _value = "";
    private String _width = "100%";
    private String _height = "";
    private String _toolbar;
    private String _customPath;
    private Map<String, Object> _config;
    private String _filebrowserBrowseUrl;
    private String _filebrowserImageBrowseUrl;
    private String _filebrowserFlashBrowseUrl;
    private String _filebrowserUploadUrl;
    private String _filebrowserImageUploadUrl;
    private String _filebrowserFlashUploadUrl;
    private CkezFileWriter fileWriter;
    private String _txtByClient;
    private String _hflex;
    private String _vflex;
    private boolean _autoHeight;
    private boolean _resizable = true;
    private static final CkezFileWriter _defWriter;

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(this._value)) {
            this._value = value;
            if (this._txtByClient == null || !Objects.equals((Object)this._txtByClient, (Object)value)) {
                this._txtByClient = null;
                this.smartUpdate("value", value);
            }
        }
    }

    public String getToolbar() {
        return this._toolbar;
    }

    public void setToolbar(String toolbar) {
        if (toolbar != null && Strings.isEmpty((String)toolbar)) {
            toolbar = null;
        }
        if (!Objects.equals((Object)toolbar, (Object)this._toolbar)) {
            this._toolbar = toolbar;
            this.smartUpdate("toolbar", toolbar);
        }
    }

    public String getWidth() {
        return this._width;
    }

    public void setWidth(String width) {
        if (width != null && Strings.isEmpty((String)width)) {
            width = null;
        }
        if (!Objects.equals((Object)width, (Object)this._width)) {
            this._width = width;
            this.smartUpdate("width", width);
        }
    }

    public String getHeight() {
        return this._height;
    }

    public void setHeight(String height) {
        if (height != null && Strings.isEmpty((String)height)) {
            height = null;
        }
        if (!Objects.equals((Object)height, (Object)this._height)) {
            this._height = height;
            this.smartUpdate("height", height);
        }
    }

    public void setVflex(String flex) {
        if (flex != null && Strings.isEmpty((String)flex)) {
            flex = null;
        }
        if (!Objects.equals((Object)this._vflex, (Object)flex)) {
            this._vflex = flex;
            this.smartUpdate("vflex", flex);
        }
    }

    public String getVflex() {
        return this._vflex;
    }

    public void setHflex(String flex) {
        if (flex != null && Strings.isEmpty((String)flex)) {
            flex = null;
        }
        if (!Objects.equals((Object)this._hflex, (Object)flex)) {
            this._hflex = flex;
            this.smartUpdate("hflex", flex);
        }
    }

    public String getHflex() {
        return this._hflex;
    }

    public boolean isAutoHeight() {
        return this._autoHeight;
    }

    public void setAutoHeight(boolean autoHeight) {
        if (this._autoHeight != autoHeight) {
            this._autoHeight = autoHeight;
            this.smartUpdate("autoHeight", this._autoHeight);
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        if (this._resizable != resizable) {
            this._resizable = resizable;
            this.smartUpdate("resizable", this._resizable);
        }
    }

    public void setCustomConfigurationsPath(String url) {
        if (!Objects.equals((Object)this._customPath, (Object)url)) {
            this._customPath = url;
            this.smartUpdate("customConfigurationsPath", this.getEncodedURL(this._customPath));
        }
    }

    public String getCustomConfigurationsPath() {
        return this._customPath;
    }

    public void setConfig(Map<String, Object> config) {
        if (config != null) {
            this._config = config;
            this.smartUpdate("config", this._config);
        }
    }

    public Map<String, Object> getConfig() {
        return this._config;
    }

    public void setFilebrowserBrowseUrl(String filebrowserBrowseUrl) {
        if (!Objects.equals((Object)this._filebrowserBrowseUrl, (Object)filebrowserBrowseUrl)) {
            this._filebrowserBrowseUrl = filebrowserBrowseUrl;
            this.smartUpdate("filebrowserBrowseUrl", filebrowserBrowseUrl);
        }
    }

    public String getFilebrowserBrowseUrl() {
        return this._filebrowserBrowseUrl;
    }

    public void setFilebrowserImageBrowseUrl(String filebrowserImageBrowseUrl) {
        if (!Objects.equals((Object)this._filebrowserImageBrowseUrl, (Object)filebrowserImageBrowseUrl)) {
            this._filebrowserImageBrowseUrl = filebrowserImageBrowseUrl;
            this.smartUpdate("filebrowserImageBrowseUrl", filebrowserImageBrowseUrl);
        }
    }

    public String getFilebrowserImageBrowseUrl() {
        return this._filebrowserImageBrowseUrl;
    }

    public void setFilebrowserFlashBrowseUrl(String filebrowserFlashBrowseUrl) {
        if (!Objects.equals((Object)this._filebrowserFlashBrowseUrl, (Object)filebrowserFlashBrowseUrl)) {
            this._filebrowserFlashBrowseUrl = filebrowserFlashBrowseUrl;
            this.smartUpdate("filebrowserFlashBrowseUrl", filebrowserFlashBrowseUrl);
        }
    }

    public String getFilebrowserFlashBrowseUrl() {
        return this._filebrowserFlashBrowseUrl;
    }

    public String getFilebrowserUploadUrl() {
        return this._filebrowserUploadUrl;
    }

    public void setFilebrowserUploadUrl(String filebrowserUploadUrl) {
        if (!Objects.equals((Object)this._filebrowserUploadUrl, (Object)filebrowserUploadUrl)) {
            this._filebrowserUploadUrl = filebrowserUploadUrl;
            this.smartUpdate("filebrowserUploadUrl", filebrowserUploadUrl);
        }
    }

    public String getFilebrowserImageUploadUrl() {
        return this._filebrowserImageUploadUrl;
    }

    public void setFilebrowserImageUploadUrl(String filebrowserImageUploadUrl) {
        if (!Objects.equals((Object)this._filebrowserImageUploadUrl, (Object)filebrowserImageUploadUrl)) {
            this._filebrowserImageUploadUrl = filebrowserImageUploadUrl;
            this.smartUpdate("filebrowserImageUploadUrl", filebrowserImageUploadUrl);
        }
    }

    public String getFilebrowserFlashUploadUrl() {
        return this._filebrowserFlashUploadUrl;
    }

    public void setFilebrowserFlashUploadUrl(String filebrowserFlashUploadUrl) {
        if (!Objects.equals((Object)this._filebrowserFlashUploadUrl, (Object)filebrowserFlashUploadUrl)) {
            this._filebrowserFlashUploadUrl = filebrowserFlashUploadUrl;
            this.smartUpdate("filebrowserFlashUploadUrl", filebrowserFlashUploadUrl);
        }
    }

    private String getEncodedURL(String path) {
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(path) : "";
    }

    public CkezFileWriter getFileWriter() {
        return this.fileWriter;
    }

    public void setFileWriter(CkezFileWriter fileWriter) {
        this.fileWriter = fileWriter;
    }

    String writeFileItem(String uploadUrl, String realPath, FileItem item, String type) {
        return (this.fileWriter != null ? this.fileWriter : _defWriter).writeFileItem(uploadUrl, realPath, item, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            String value;
            InputEvent evt = InputEvent.getInputEvent((AuRequest)request, (Object)this._value);
            this._txtByClient = value = evt.getValue();
            try {
                String oldval = this._value;
                this.setValue(value);
                if (oldval == this._value) {
                    return;
                }
            }
            finally {
                this._txtByClient = null;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onSave")) {
            InputEvent evt = InputEvent.getInputEvent((AuRequest)request, (Object)this._value);
            this.setValue(evt.getValue());
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onChanging")) {
            Events.postEvent((Event)InputEvent.getInputEvent((AuRequest)request, (Object)this._value));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "value", this._value);
        if (!"100%".equals(this._width)) {
            this.render(renderer, "width", this._width);
        }
        if (this._height != null) {
            this.render(renderer, "height", this._height);
        }
        this.render(renderer, "customConfigurationsPath", this.getEncodedURL(this._customPath));
        this.render(renderer, "config", this._config);
        this.render(renderer, "toolbar", this._toolbar);
        this.render(renderer, "autoHeight", this._autoHeight);
        this.render(renderer, "resizable", this._resizable);
        if (!Strings.isBlank((String)this._filebrowserBrowseUrl)) {
            this.render(renderer, "filebrowserBrowseUrl", this._filebrowserBrowseUrl);
        }
        if (!Strings.isBlank((String)this._filebrowserImageBrowseUrl)) {
            this.render(renderer, "filebrowserImageBrowseUrl", this._filebrowserImageBrowseUrl);
        }
        if (!Strings.isBlank((String)this._filebrowserFlashBrowseUrl)) {
            this.render(renderer, "filebrowserFlashBrowseUrl", this._filebrowserFlashBrowseUrl);
        }
        if (!Strings.isBlank((String)this._filebrowserUploadUrl)) {
            this.render(renderer, "filebrowserUploadUrl", this._filebrowserUploadUrl);
        }
        if (!Strings.isBlank((String)this._filebrowserImageUploadUrl)) {
            this.render(renderer, "filebrowserImageUploadUrl", this._filebrowserImageUploadUrl);
        }
        if (!Strings.isBlank((String)this._filebrowserFlashUploadUrl)) {
            this.render(renderer, "filebrowserFlashUploadUrl", this._filebrowserFlashUploadUrl);
        }
        if (this._hflex != null) {
            this.render(renderer, "hflex", this._hflex);
        }
        if (this._vflex != null) {
            this.render(renderer, "vflex", this._vflex);
        }
        this.render(renderer, "fileBrowserTempl", this.getEncodedURL(_fileBrowserTempl));
        this.render(renderer, "fileUploadTempl", this.getEncodedURL(_fileUploadHandlePage));
    }

    public boolean isChildable() {
        return false;
    }

    public static void setFileBrowserTemplate(String uri) {
        if (Strings.isEmpty((String)uri)) {
            throw new IllegalArgumentException("empty");
        }
        _fileBrowserTempl = uri;
    }

    public static String getFileBrowserTemplate() {
        return _fileBrowserTempl;
    }

    public static void setFileUploadHandlePage(String uri) {
        if (Strings.isEmpty((String)uri)) {
            throw new IllegalArgumentException("empty");
        }
        _fileUploadHandlePage = uri;
    }

    public static String getFileUploadHandlePage() {
        return _fileUploadHandlePage;
    }

    static {
        CKeditor.addClientEvent(CKeditor.class, (String)"onChange", (int)16385);
        CKeditor.addClientEvent(CKeditor.class, (String)"onChanging", (int)4096);
        CKeditor.addClientEvent(CKeditor.class, (String)"onSave", (int)16385);
        _defWriter = new CkezFileWriter(){

            @Override
            public String writeFileItem(String uploadUrl, String realPath, FileItem item, String type) {
                String fileName = item.getName();
                if (Strings.isEmpty((String)fileName)) {
                    throw new UiException("Empty filename: " + fileName);
                }
                fileName = FilenameUtils.getName((String)fileName);
                File file = new File(realPath + "/" + fileName);
                if (!file.getParentFile().exists()) {
                    throw new UiException("Folder not found: " + realPath);
                }
                try {
                    item.write(file);
                }
                catch (Exception e) {
                    throw new UiException("Failed to write file item", (Throwable)e);
                }
                return uploadUrl + "/" + fileName;
            }
        };
    }

    private class EncodedURL
    implements DeferredValue {
        private String path;

        public EncodedURL(String path) {
            this.path = path;
        }

        public Object getValue() {
            return CKeditor.this.getEncodedURL(this.path);
        }
    }
}

