/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.FolderBrowser;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.util.Statistic;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zhtml.Pre;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Textarea;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Monitor;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Image;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;

public class AboutWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -5590393631865037228L;
    private static final CLogger log = CLogger.getCLogger(AboutWindow.class);
    private Checkbox bErrorsOnly;
    private Listbox logTable;
    private Tabbox tabbox;
    protected Tabpanels tabPanels;
    protected Button btnDownload;
    protected Button btnErrorEmail;
    protected Button btnViewLog;
    protected Tab tabLog;
    protected Tab tabPlugins;
    protected Button btnAdempiereLog;
    protected Button btnReloadLogProps;
    protected Button btnGC;
    private Listbox levelListBox;

    public AboutWindow() {
        this.init();
    }

    private void init() {
        this.setPosition("center");
        this.setTitle(ThemeManager.getBrowserTitle());
        this.setSclass("popup-dialog about-window");
        this.setClosable(true);
        this.setMaximizable(true);
        this.setSizable(true);
        this.tabbox = new Tabbox();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        Tabs tabs = new Tabs();
        tabs.setParent((Component)this.tabbox);
        this.tabPanels = new Tabpanels();
        this.tabPanels.setParent((Component)this.tabbox);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabPanels, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabPanels, "1");
        this.initTabs(tabs);
        Button btnOk = ButtonFactory.createNamedButton("Ok");
        btnOk.addEventListener("onClick", this);
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)borderlayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)borderlayout, "1");
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        centerPane.setAutoscroll(true);
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.tabbox);
        South southPane = new South();
        southPane.setStyle("text-align: right");
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)btnOk);
        this.setBorder("normal");
        if (ClientInfo.maxWidth(700) || ClientInfo.maxHeight(500)) {
            this.setMaximized(true);
            this.setSizable(false);
            this.setMaximizable(false);
        } else if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 800);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 600);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setShadow(true);
        this.setAttribute("mode", "highlighted");
    }

    protected void initTabs(Tabs tabs) {
        Tab tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"About"));
        tab.setParent((Component)tabs);
        Tabpanel tabPanel = this.createAbout();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Credits"));
        tab.setParent((Component)tabs);
        tabPanel = this.createCredit();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Info"));
        tab.setParent((Component)tabs);
        tabPanel = this.createInfo();
        tabPanel.setParent((Component)this.tabPanels);
        tab = new Tab();
        tab.setLabel("Errors");
        this.tabLog = tab;
        tab.setParent((Component)tabs);
        tabPanel = this.createTrace();
        tabPanel.setParent((Component)this.tabPanels);
    }

    protected Tabpanel createTrace() {
        Level level;
        Tabpanel tabPanel = new Tabpanel();
        Vbox vbox = new Vbox();
        LayoutUtils.addSclass("about-trace-panel", (HtmlBasedComponent)vbox);
        vbox.setParent((Component)tabPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "1");
        Hbox hbox = new Hbox();
        hbox.setAlign("center");
        hbox.setPack("start");
        Label levelLabel = new Label("Trace Level:");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)levelLabel, "100%");
        hbox.appendChild((Component)levelLabel);
        this.levelListBox = ListboxFactory.newDropdownListbox();
        this.levelListBox.addEventListener("onSelect", this);
        hbox.appendChild((Component)this.levelListBox);
        Level[] levelArray = CLogMgt.LEVELS;
        int n = CLogMgt.LEVELS.length;
        int n2 = 0;
        while (n2 < n) {
            level = levelArray[n2];
            this.levelListBox.appendItem(level.getName(), level);
            ++n2;
        }
        level = CLogMgt.getLevel();
        int i = 0;
        while (i < CLogMgt.LEVELS.length) {
            if (CLogMgt.LEVELS[i].intValue() == level.intValue()) {
                this.levelListBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        this.levelListBox.setEnabled(false);
        if (user.isAdministrator()) {
            if (Env.getAD_Client_ID((Properties)Env.getCtx()) == 0) {
                this.levelListBox.setEnabled(true);
                this.levelListBox.setTooltiptext("Set trace level. Warning: this will effect all session not just the current session");
                levelLabel.setTooltiptext("Set trace level. Warning: this will effect all session not just the current session");
                this.btnAdempiereLog = new Button("iDempiere Log");
                this.btnAdempiereLog.setTooltiptext("Download iDempiere log file from server");
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnAdempiereLog);
                this.btnAdempiereLog.addEventListener("onClick", this);
                hbox.appendChild((Component)new Space());
                hbox.appendChild((Component)this.btnAdempiereLog);
                ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
                ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "0");
                vbox.appendChild((Component)hbox);
                hbox = new Hbox();
                hbox.setAlign("center");
                hbox.setPack("start");
                this.btnReloadLogProps = new Button("Reload Log Props");
                this.btnReloadLogProps.setTooltiptext("Reload the configuration of log levels from idempiere.properties file");
                LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnReloadLogProps);
                this.btnReloadLogProps.addEventListener("onClick", this);
                hbox.appendChild((Component)new Space());
                hbox.appendChild((Component)this.btnReloadLogProps);
            }
            this.btnGC = new Button("Garbage Collect");
            this.btnGC.setTooltiptext("Perform a Garbage Collection on the JVM");
            LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnGC);
            this.btnGC.addEventListener("onClick", this);
            hbox.appendChild((Component)new Space());
            hbox.appendChild((Component)this.btnGC);
        }
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "0");
        vbox.appendChild((Component)hbox);
        hbox = new Hbox();
        hbox.setAlign("center");
        hbox.setPack("start");
        this.bErrorsOnly = new Checkbox();
        this.bErrorsOnly.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ErrorsOnly"));
        this.bErrorsOnly.setChecked(true);
        this.bErrorsOnly.addEventListener("onCheck", this);
        hbox.appendChild((Component)this.bErrorsOnly);
        hbox.appendChild((Component)new Space());
        this.btnDownload = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveFile"));
        this.btnDownload.setIconSclass("z-icon-Save");
        this.btnDownload.setTooltiptext("Download session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnDownload);
        this.btnDownload.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnDownload);
        this.btnErrorEmail = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"SendEMail"));
        this.btnErrorEmail.setIconSclass("z-icon-SendMail");
        this.btnErrorEmail.setTooltiptext("Email session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnErrorEmail);
        this.btnErrorEmail.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnErrorEmail);
        this.btnViewLog = new Button(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"View")));
        this.btnViewLog.setIconSclass("z-icon-File");
        this.btnViewLog.setTooltiptext("View session log");
        LayoutUtils.addSclass("txt-btn", (HtmlBasedComponent)this.btnViewLog);
        this.btnViewLog.addEventListener("onClick", this);
        hbox.appendChild((Component)this.btnViewLog);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)hbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)hbox, "0");
        vbox.appendChild((Component)hbox);
        if (ClientInfo.maxWidth(700) || ClientInfo.maxHeight(500)) {
            this.btnDownload.setLabel("");
            this.btnErrorEmail.setLabel("");
            this.btnViewLog.setLabel("");
        }
        Vector columnNames = CLogErrorBuffer.get((boolean)true).getColumnNames(Env.getCtx());
        this.logTable = new Listbox();
        ListHead listHead = new ListHead();
        listHead.setParent((Component)this.logTable);
        listHead.setSizable(true);
        for (Object obj : columnNames) {
            ListHeader header = new ListHeader(obj.toString());
            ZKUpdateUtil.setHflex((HtmlBasedComponent)header, "1");
            listHead.appendChild((Component)header);
        }
        vbox.appendChild((Component)this.logTable);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.logTable, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.logTable, "1");
        this.updateLogTable();
        return tabPanel;
    }

    private void updateLogTable() {
        Vector data = CLogErrorBuffer.get((boolean)true).getLogData(this.bErrorsOnly.isChecked());
        SimpleListModel model = new SimpleListModel(data);
        int[] nArray = new int[6];
        nArray[3] = 200;
        nArray[5] = 200;
        model.setMaxLength(nArray);
        this.logTable.setItemRenderer(model);
        this.logTable.setModel((ListModel)model);
        if (this.bErrorsOnly.isSelected()) {
            this.tabLog.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Errors") + " (" + data.size() + ")");
        } else {
            this.tabLog.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"TraceInfo") + " (" + data.size() + ")");
        }
    }

    protected Tabpanel createInfo() {
        Tabpanel tabPanel = new Tabpanel();
        Div div = new Div();
        LayoutUtils.addSclass("about-info-panel", (HtmlBasedComponent)div);
        div.setParent((Component)tabPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "100%");
        Pre pre = new Pre();
        pre.setParent((Component)div);
        Text text = new Text(CLogMgt.getInfo(null).toString());
        text.setParent((Component)pre);
        if (Env.getAD_Client_ID((Properties)Env.getCtx()) == 0 && MRole.getDefault().isAccessAdvanced()) {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                Monitor monitor = this.getDesktop().getWebApp().getConfiguration().getMonitor();
                if (monitor != null && monitor instanceof Statistic) {
                    Statistic stat = (Statistic)monitor;
                    StringBuilder info = new StringBuilder(text.getValue());
                    info.append("\n");
                    info.append("Desktop: ").append("#Created=").append(stat.getTotalDesktopCount()).append(" #Active=").append(stat.getActiveDesktopCount());
                    info.append("\n");
                    info.append("Session: ").append("#Created=").append(stat.getTotalSessionCount()).append(" #Active=").append(stat.getActiveSessionCount());
                    text.setValue(info.toString());
                }
            });
        }
        return tabPanel;
    }

    protected Tabpanel createCredit() {
        Tabpanel tabPanel = new Tabpanel();
        String fileName = Adempiere.getAdempiereHome() + File.separator + "Credits.html";
        File file = new File(fileName);
        AMedia media = null;
        try {
            media = new AMedia(file.getName(), "html", "text/html", file, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warning("File " + fileName + " not found");
        }
        Iframe iframe = new Iframe();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)iframe, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)iframe, "100%");
        iframe.setStyle("overflow: auto;");
        iframe.setId("creditsFrame");
        iframe.setParent((Component)tabPanel);
        iframe.setSrc(null);
        if (media != null) {
            iframe.setContent((Media)media);
        }
        return tabPanel;
    }

    protected Tabpanel createAbout() {
        Tabpanel tabPanel = new Tabpanel();
        Vbox vb = new Vbox();
        LayoutUtils.addSclass("about-main-panel", (HtmlBasedComponent)vb);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)vb, "100%");
        vb.setAlign("center");
        vb.setPack("center");
        vb.setParent((Component)tabPanel);
        Vbox vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-logo", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        Image image = new Image(ThemeManager.getLargeLogo());
        image.setParent((Component)vbox);
        vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-version", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vbox, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        Text text = new Text(Adempiere.getSubtitle());
        text.setParent((Component)vbox);
        Separator separator = new Separator();
        separator.setParent((Component)vbox);
        text = new Text(Adempiere.getVersion());
        text.setParent((Component)vbox);
        vbox = new Vbox();
        LayoutUtils.addSclass("about-main-panel-links", (HtmlBasedComponent)vbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)vb, "100%");
        vbox.setAlign("center");
        vbox.setParent((Component)vb);
        separator = new Separator();
        separator.setParent((Component)vbox);
        ToolBarButton link = new ToolBarButton();
        link.setLabel("Project Site");
        link.setHref("http://www.idempiere.org");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        separator = new Separator();
        separator.setParent((Component)vbox);
        link = new ToolBarButton();
        link.setLabel("Community Wiki");
        link.setHref("http://wiki.idempiere.org");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        separator = new Separator();
        separator.setParent((Component)vbox);
        link = new ToolBarButton();
        link.setLabel("Functional Forums");
        link.setHref("http://groups.google.com/group/idempiere");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        separator = new Separator();
        separator.setParent((Component)vbox);
        link = new ToolBarButton();
        link.setLabel("Online Support");
        link.setHref("https://mattermost.idempiere.org");
        link.setTarget("_blank");
        link.setParent((Component)vbox);
        return tabPanel;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.bErrorsOnly) {
            this.updateLogTable();
        } else if (event.getTarget() == this.btnDownload) {
            this.downloadLog();
        } else if (event.getTarget() == this.btnViewLog) {
            this.viewLog();
        } else if (event.getTarget() == this.btnErrorEmail) {
            this.cmd_errorEMail();
        } else if (event.getTarget() == this.btnAdempiereLog) {
            this.downloadAdempiereLogFile();
        } else if (event.getTarget() == this.btnReloadLogProps) {
            this.reloadLogProps();
        } else if (event.getTarget() == this.btnGC) {
            this.garbageCollection();
        } else if (event.getTarget() == this.levelListBox) {
            this.setTraceLevel();
        } else if ("onClick".equals(event.getName())) {
            this.detach();
        }
    }

    private void reloadLogProps() {
        String globalLevel;
        Properties props = new Properties();
        String propertyFileName = Ini.getFileName((boolean)false);
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(propertyFileName);
                props.load(fis);
            }
            catch (Exception e) {
                throw new AdempiereException("Could not load properties file, cause: " + e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        if (!Util.isEmpty((String)(globalLevel = props.getProperty("TraceLevel"))) && !Util.isEmpty((String)(globalLevel = SecureEngine.decrypt((String)globalLevel, (int)0)))) {
            CLogMgt.setLevel((String)globalLevel);
            Level level = CLogMgt.getLevel();
            int i = 0;
            while (i < CLogMgt.LEVELS.length) {
                if (CLogMgt.LEVELS[i].intValue() == level.intValue()) {
                    this.levelListBox.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        for (Object key : props.keySet()) {
            String level;
            String s;
            if (!(key instanceof String) || !(s = (String)key).endsWith(".TraceLevel") || Util.isEmpty((String)(level = props.getProperty(s))) || Util.isEmpty((String)(level = SecureEngine.decrypt((String)level, (int)0)))) continue;
            s = s.substring(0, s.length() - ".TraceLevel".length());
            CLogMgt.setLevel((String)s, (String)level);
        }
    }

    private void garbageCollection() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemoryBefore = runtime.totalMemory() - runtime.freeMemory();
        System.runFinalization();
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        long usedMemoryAfter = runtime.totalMemory() - runtime.freeMemory();
        long freedMemory = usedMemoryAfter - usedMemoryBefore;
        String msg = String.format("Memory: total %,d, before gc: %,d, after gc %,d, freed by gc %,d bytes%n", runtime.totalMemory(), usedMemoryBefore, usedMemoryAfter, freedMemory);
        log.warning(msg);
        msg = String.format("Memory in bytes:<ul><li>Total = %,d</li><li>Used before gc = %,d</li><li>Used after gc = %,d</li><li>Freed by gc = %,d</li></ul>", runtime.totalMemory(), usedMemoryBefore, usedMemoryAfter, freedMemory);
        Dialog.info(0, "", msg, "JVM Garbage Collection");
    }

    private void setTraceLevel() {
        ListItem item = this.levelListBox.getSelectedItem();
        if (item != null && item.getValue() != null) {
            Level level = (Level)item.getValue();
            CLogMgt.setLevel((Level)level);
            Ini.setProperty((String)"TraceLevel", (String)CLogMgt.getLevel().getName());
            Ini.saveProperties((boolean)false);
        }
    }

    private void downloadAdempiereLogFile() {
        String path = Ini.getAdempiereHome() + File.separator + "log";
        final FolderBrowser fileBrowser = new FolderBrowser(path, false);
        fileBrowser.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                File file;
                String selected = fileBrowser.getPath();
                if (selected != null && selected.trim().length() > 0 && (file = new File(selected)).exists() && file.isFile() && file.canRead()) {
                    try {
                        AMedia media = new AMedia(file, "text/plain", null);
                        Filedownload.save((Media)media);
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
            }
        });
    }

    private void downloadLog() {
        String log = CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isChecked());
        AMedia media = new AMedia("trace.log", null, "text/plain", log.getBytes());
        Filedownload.save((Media)media);
    }

    private void viewLog() {
        String log = CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), this.bErrorsOnly.isChecked());
        Window w = new Window();
        w.setAttribute("mode", "highlighted");
        w.setTitle("View Log");
        w.setBorder("normal");
        w.setClosable(true);
        w.setMaximizable(true);
        w.setSizable(true);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)w, 600);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)w, 500);
        Textarea textbox = new Textarea();
        textbox.setDynamicProperty("readonly", (Object)"true");
        textbox.setStyle("width:99%; height: 99%; margin: auto; display: inline-block;");
        w.appendChild((Component)textbox);
        textbox.setValue(log);
        AEnv.showCenterScreen(w);
    }

    private void cmd_errorEMail() {
        this.detach();
        FeedbackManager.emailSupport(this.bErrorsOnly.isSelected());
    }
}

