/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.adempiere.base.AnnotationBasedFactory;
import org.adempiere.webui.factory.IFormFactory;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;

public abstract class AnnotationBasedFormFactory
extends AnnotationBasedFactory
implements IFormFactory {
    private final Map<String, String> classCache = new HashMap<String, String>();
    private final Map<String, Constructor<?>[]> constructorCache = new ConcurrentHashMap<String, Constructor<?>[]>();
    private BundleContext bundleContext = null;
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedFormFactory.class);

    @Override
    public ADForm newFormInstance(String formName) {
        this.blockWhileScanning();
        ADForm form = null;
        String realClassName = this.classCache.get(formName);
        if (realClassName != null) {
            Constructor<?> constructor = this.getConstructor(formName);
            try {
                Object formObject = constructor.newInstance(new Object[0]);
                if (formObject != null) {
                    if (formObject instanceof ADForm) {
                        form = (ADForm)formObject;
                    } else if (formObject instanceof IFormController) {
                        IFormController controller = (IFormController)formObject;
                        form = controller.getForm();
                        form.setICustomForm(controller);
                    }
                }
            }
            catch (Exception e) {
                s_log.log(Level.WARNING, e.getMessage(), (Throwable)e);
            }
            if (form == null) {
                this.constructorCache.put(realClassName, new Constructor[0]);
            }
        }
        return form;
    }

    public Constructor<?> getConstructor(String formName) {
        String className = this.classCache.get(formName);
        Constructor<?>[] constructors = null;
        if (className != null && (constructors = this.constructorCache.get(className)) == null) {
            ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(className);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructors = constructor != null ? new Constructor[]{constructor} : new Constructor[]{};
                this.constructorCache.put(className, constructors);
            }
            catch (Exception e) {
                s_log.log(Level.WARNING, e.getMessage(), (Throwable)e);
                constructors = new Constructor[]{};
                this.constructorCache.put(className, constructors);
            }
        }
        if (constructors != null && constructors.length == 1) {
            return constructors[0];
        }
        return null;
    }

    protected abstract String[] getPackages();

    @Activate
    public void activate(ComponentContext context) throws ClassNotFoundException {
        long start = System.currentTimeMillis();
        this.bundleContext = context.getBundleContext();
        ClassLoader classLoader = ((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning().acceptPackagesNonRecursive(this.getPackages());
        ClassGraph.ScanResultProcessor scanResultProcessor = scanResult -> {
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Form.class)) {
                if (classInfo.isAbstract()) continue;
                String className = classInfo.getName();
                AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Form.class);
                String alternateName = (String)annotationInfo.getParameterValues().getValue("name");
                this.classCache.put(className, className);
                if (Util.isEmpty((String)alternateName, (boolean)true)) continue;
                this.classCache.put(alternateName, className);
            }
            long end = System.currentTimeMillis();
            s_log.info(() -> this.getClass().getSimpleName() + " loaded " + this.classCache.size() + " classes in " + (float)(end - start) / 1000.0f + "s");
            this.signalScanCompletion(true);
        };
        graph.scanAsync(this.getExecutorService(), this.getMaxThreads(), scanResultProcessor, this.getScanFailureHandler());
    }
}

