/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.AutoComplete;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.DrillEvent;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.grid.AbstractWQuickEntry;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.adempiere.webui.window.WLocationDialog;
import org.compiere.Adempiere;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.compiere.model.Lookup;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MColumn;
import org.compiere.model.MLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MLookup;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Menuitem;

public class WTableDirEditor
extends WEditor
implements ListDataListener,
ContextMenuListener,
IZoomableEditor {
    private static final String UP_PRESSED_OVERRIDE_SCRIPT = "function(evt) {   if (!this.isOpen()) this.open();   this.$upPressed_(evt);}";
    private static final String DOWN_PRESSED_OVERRIDE_SCRIPT = "function(evt) {   if (!this.isOpen()) this.open();   this.$dnPressed_(evt);}";
    public static final String[] LISTENER_EVENTS = new String[]{"onSelect"};
    private static final CLogger logger = CLogger.getCLogger(WTableDirEditor.class);
    private Lookup lookup;
    private Object oldValue;
    private String m_tableName = null;
    private String m_keyColumnName = null;
    public static final String SHORT_LIST_EVENT = "SHORT_LIST";
    protected boolean onlyShortListItems;
    private CCacheListener tableCacheListener;
    private boolean onselecting = false;
    private boolean retainSelectedValueAfterRefresh = true;

    public WTableDirEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WTableDirEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)(gridField.isAutocomplete() ? new EditorAutoComplete() : new EditorCombobox()), gridField, tableEditor, editorConfiguration);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        this.lookup = gridField.getLookup();
        this.init();
    }

    public WTableDirEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        this(lookup, label, description, mandatory, readonly, updateable, false);
    }

    public WTableDirEditor(Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable, boolean autocomplete) {
        this((Component)(autocomplete ? new EditorAutoComplete() : new EditorCombobox()), lookup, label, description, mandatory, readonly, updateable);
    }

    private WTableDirEditor(Component comp, Lookup lookup, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super(comp, label, description, mandatory, readonly, updateable);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        super.setColumnName(lookup.getColumnName());
        this.init();
    }

    public WTableDirEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        this(columnName, mandatory, isReadOnly, isUpdateable, lookup, false);
    }

    public WTableDirEditor(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup, boolean autocomplete) {
        this((Component)(autocomplete ? new EditorAutoComplete() : new EditorCombobox()), columnName, mandatory, isReadOnly, isUpdateable, lookup);
    }

    private WTableDirEditor(Component comp, String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, Lookup lookup) {
        super(comp, columnName, null, null, mandatory, isReadOnly, isUpdateable);
        ((ITableDirEditor)((Object)this.getComponent())).setEditor(this);
        if (lookup == null) {
            throw new IllegalArgumentException("Lookup cannot be null");
        }
        this.lookup = lookup;
        this.init();
    }

    private void init() {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.getComponent(), "200px");
        this.getComponent().setAutocomplete(true);
        this.getComponent().setAutodrop(false);
        this.getComponent().setInstantSelect(false);
        this.getComponent().addEventListener("onBlur", this);
        if (!(this.getComponent() instanceof EditorAutoComplete)) {
            this.getComponent().addScrollSelectedIntoViewListener();
        }
        if (MSysConfig.getBooleanValue((String)"ZK_AUTO_SAVE_CHANGES", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
            this.getComponent().setWidgetOverride("dnPressed_", DOWN_PRESSED_OVERRIDE_SCRIPT);
            this.getComponent().setWidgetOverride("upPressed_", UP_PRESSED_OVERRIDE_SCRIPT);
        }
        boolean zoom = false;
        if (this.lookup != null) {
            this.lookup.addListDataListener((ListDataListener)this);
            this.lookup.setMandatory(this.isMandatory());
            if (this.lookup.getDisplayType() == 17 && Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_Role_ID") == 0 || this.lookup.getDisplayType() != 17) {
                zoom = true;
            }
            if (this.isReadWrite()) {
                this.lookup.refresh();
            } else {
                this.refreshList();
            }
        }
        String tableName_temp = this.lookup.getColumnName();
        int posPoint = tableName_temp.indexOf(".");
        String tableName = tableName_temp.substring(0, posPoint);
        boolean enableDrill = false;
        if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getColumnName().endsWith("_ID") && MRole.getDefault().isCanReport(this.getGridField().getGridTab().getAD_Table_ID())) {
            enableDrill = true;
        }
        this.popupMenu = tableName.toUpperCase().equals("C_BPARTNER_LOCATION") ? new WEditorPopupMenu(true, true, this.isShowPreference(), false, false, true, enableDrill, this.lookup) : new WEditorPopupMenu(zoom, true, this.isShowPreference(), false, false, false, enableDrill, this.lookup);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            MTable table2;
            boolean isShortListAvailable = false;
            if (this.lookup != null && (this.lookup.getDisplayType() == 19 || this.lookup.getDisplayType() == 18) && (isShortListAvailable = (table2 = MTable.get((Properties)Env.getCtx(), (String)tableName)).columnExistsInDB("IsShortList"))) {
                this.onlyShortListItems = true;
                this.lookup.setShortList(true);
                this.getLabel().setText(">" + this.getGridField().getHeader() + "<");
                this.actionRefresh();
                Menuitem searchMode = new Menuitem();
                searchMode.setAttribute("EVENT", (Object)SHORT_LIST_EVENT);
                searchMode.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ShortListSwitchSearchMode"));
                if (ThemeManager.isUseFontIconForImage()) {
                    searchMode.setIconSclass("z-icon-Lock");
                } else {
                    searchMode.setImage(ThemeManager.getThemeResource("images/Lock16.png"));
                }
                searchMode.addEventListener("onClick", (EventListener)this.popupMenu);
                this.popupMenu.appendChild((Component)searchMode);
            }
        }
        if (this.gridField != null) {
            this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    private void createCacheListener() {
        String columnName;
        int dotIndex;
        if (this.lookup != null && (dotIndex = (columnName = this.lookup.getColumnName()).indexOf(".")) > 0) {
            String tableName = columnName.substring(0, dotIndex);
            this.tableCacheListener = new CCacheListener(tableName, this);
        }
    }

    @Override
    public String getDisplay() {
        String display = null;
        Comboitem selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            display = selItem.getLabel();
        }
        return display;
    }

    @Override
    public Object getValue() {
        Object retVal = null;
        Comboitem selItem = this.getComponent().getSelectedItem();
        if (selItem != null) {
            retVal = selItem.getValue();
            if (retVal instanceof Integer && (Integer)retVal == -1) {
                retVal = null;
            } else if (retVal instanceof String && "".equals(retVal)) {
                retVal = null;
            }
        }
        return retVal;
    }

    @Override
    public void setValue(Object value) {
        if (this.onselecting) {
            return;
        }
        if (value != null && (value instanceof Integer || value instanceof String || value instanceof Timestamp || value instanceof BigDecimal)) {
            this.getComponent().setValue(value);
            if (!this.getComponent().isSelected(value)) {
                Object curValue = this.oldValue;
                this.oldValue = value;
                if (this.isReadWrite() && this.lookup != null) {
                    this.lookup.refresh();
                } else {
                    this.refreshList();
                }
                if (!(this.getComponent().isSelected(value) || !(value instanceof Integer) || this.gridField == null || this.gridField.getDisplayType() == 13 || this.gridTab != null && this.gridTab.getTableModel().isImporting())) {
                    String refTable;
                    MColumn col;
                    MRole role = MRole.getDefault((Properties)Env.getCtx(), (boolean)false);
                    int refTableID = -1;
                    if (this.gridTab != null && (col = MColumn.get((Properties)Env.getCtx(), (int)this.gridField.getAD_Column_ID())).get_ID() > 0 && (refTable = col.getReferenceTableName()) != null) {
                        MTable table2 = MTable.get((Properties)Env.getCtx(), (String)refTable);
                        refTableID = table2.getAD_Table_ID();
                    }
                    if (refTableID > 0 && !role.isRecordAccess(refTableID, ((Integer)value).intValue(), false)) {
                        this.oldValue = value;
                        this.setReadWrite(false);
                        this.gridField.setLockedRecord(true);
                    } else {
                        this.getComponent().setValue(null);
                        if (curValue == null) {
                            curValue = value;
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), curValue, null);
                        super.fireValueChange(changeEvent);
                        this.oldValue = null;
                        if (this.gridField != null) {
                            this.gridField.setLockedRecord(false);
                        }
                    }
                }
            } else {
                this.oldValue = value;
                if (this.gridField != null) {
                    this.gridField.setLockedRecord(false);
                }
            }
        } else {
            this.getComponent().setValue(null);
            this.getComponent().setSelectedItem(null);
            this.oldValue = value;
            if (this.gridField != null) {
                this.gridField.setLockedRecord(false);
            }
            if (this.getComponent() instanceof EditorAutoComplete && this.gridField != null) {
                this.updateStyle();
            }
        }
        this.popupMenu.showDrillAssistant(value != null);
    }

    public Combobox getComponent() {
        return (Combobox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
        this.getComponent().setButtonVisible(readWrite);
    }

    private void refreshList() {
        if (this.getComponent().getItemCount() > 0) {
            this.getComponent().removeAllItems();
        }
        if (this.isReadWrite()) {
            if (this.lookup != null) {
                NamePair pair;
                int size = this.lookup.getSize();
                boolean found = false;
                int i = 0;
                while (i < size) {
                    Object obj = this.lookup.getElementAt(i);
                    if (obj instanceof KeyNamePair) {
                        lookupKNPair = (KeyNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName().length() == 0 ? " " : lookupKNPair.getName(), lookupKNPair.getKey());
                        if (!found && this.oldValue != null && this.oldValue instanceof Integer && lookupKNPair.getKey() == ((Integer)this.oldValue).intValue()) {
                            found = true;
                        }
                    } else if (obj instanceof ValueNamePair) {
                        lookupKNPair = (ValueNamePair)obj;
                        this.getComponent().appendItem(lookupKNPair.getName().length() == 0 ? " " : lookupKNPair.getName(), lookupKNPair.getValue());
                        if (!found && this.oldValue != null && lookupKNPair.getValue().equals(this.oldValue.toString())) {
                            found = true;
                        }
                    } else if (obj instanceof MLocator) {
                        lookupKNPair = (MLocator)obj;
                        this.getComponent().appendItem(lookupKNPair.getValue().length() == 0 ? " " : lookupKNPair.getValue(), lookupKNPair.getM_Locator_ID());
                        if (!found && this.oldValue != null && lookupKNPair.getM_Locator_ID() == ((Integer)this.oldValue).intValue()) {
                            found = true;
                        }
                    }
                    ++i;
                }
                if (!found && this.oldValue != null && this.isRetainSelectedValueAfterRefresh() && (pair = this.lookup.getDirect(this.oldValue, false, true)) != null) {
                    if (pair instanceof KeyNamePair) {
                        int key = ((KeyNamePair)pair).getKey();
                        this.getComponent().appendItem(pair.getName(), key);
                    } else if (pair instanceof ValueNamePair) {
                        ValueNamePair valueNamePair = (ValueNamePair)pair;
                        this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                    }
                }
            }
        } else if (this.lookup != null) {
            NamePair pair;
            GridTable gt;
            String trxName = null;
            if (this.gridField != null && this.gridField.getGridTab() != null && this.gridField.getGridTab().getTableModel() != null && (gt = this.gridField.getGridTab().getTableModel()).isImporting()) {
                trxName = gt.get_TrxName();
            }
            if ((pair = this.lookup.getDirect(this.oldValue, false, false, trxName)) != null) {
                if (pair instanceof KeyNamePair) {
                    int key = ((KeyNamePair)pair).getKey();
                    this.getComponent().appendItem(pair.getName(), key);
                } else if (pair instanceof ValueNamePair) {
                    ValueNamePair valueNamePair = (ValueNamePair)pair;
                    this.getComponent().appendItem(valueNamePair.getName(), valueNamePair.getValue());
                }
            }
        }
        if (this.getComponent() instanceof EditorAutoComplete) {
            EditorAutoComplete editor = (EditorAutoComplete)this.getComponent();
            editor.setDict(null);
            editor.setValues(null);
            editor.setDescription(null);
            String[] dict = new String[this.getComponent().getItemCount()];
            Object[] values = new Object[this.getComponent().getItemCount()];
            String[] description = new String[this.getComponent().getItemCount()];
            int i = 0;
            while (i < dict.length) {
                Comboitem item = this.getComponent().getItemAtIndex(i);
                dict[i] = item.getLabel();
                values[i] = item.getValue();
                ++i;
            }
            editor.setDict(dict, false);
            editor.setDescription(description);
            editor.setValues(values);
        }
        this.getComponent().setValue(this.oldValue);
    }

    public void onEvent(Event event) {
        if ("onSelect".equalsIgnoreCase(event.getName())) {
            try {
                this.onselecting = true;
                Object newValue = this.getValue();
                if (this.isValueChange(newValue)) {
                    try {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(true);
                        }
                        ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                        super.fireValueChange(changeEvent);
                        this.oldValue = newValue;
                        this.getComponent().setValue(newValue);
                    }
                    finally {
                        if (this.gridField != null) {
                            this.gridField.setLookupEditorSettingValue(false);
                        }
                    }
                }
                if (newValue != null && !MSysConfig.getBooleanValue((String)"ZK_AUTO_SAVE_CHANGES", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))) {
                    this.focusNext();
                }
            }
            finally {
                this.onselecting = false;
            }
            Events.echoEvent((String)"onPostSelect", (Component)this.getComponent(), null);
        } else if ("onBlur".equalsIgnoreCase(event.getName())) {
            Object newValue;
            Comboitem item = this.getComponent().getSelectedItem();
            if (item == null) {
                this.setValue(this.oldValue);
            } else if (Util.isEmpty((String)item.getLabel(), (boolean)true) && this.isValueChange(newValue = this.getValue())) {
                try {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(true);
                    }
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
                    super.fireValueChange(changeEvent);
                    this.oldValue = newValue;
                }
                finally {
                    if (this.gridField != null) {
                        this.gridField.setLookupEditorSettingValue(false);
                    }
                }
            }
        } else if (event.getName().equals("onPostSelect") && this.getComponent().isOpen()) {
            this.getComponent().select();
            this.getComponent().setOpen(false);
            this.getComponent().setOpen(true);
        }
    }

    private boolean isValueChange(Object newValue) {
        return this.oldValue == null && newValue != null || this.oldValue != null && newValue == null || this.oldValue != null && newValue != null && !this.oldValue.equals(newValue);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshList();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    public void actionRefresh() {
        if (this.lookup != null) {
            Object curValue = this.getValue();
            if (this.isReadWrite()) {
                if (this.lookup instanceof MLookup) {
                    ((MLookup)this.lookup).refreshItemsAndCache();
                } else {
                    this.lookup.refresh();
                }
            } else {
                this.refreshList();
            }
            if (curValue != null) {
                this.setValue(curValue);
            }
        }
    }

    @Override
    public void actionZoom() {
        AEnv.actionZoom(this.lookup, this.getValue());
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    protected void actionDrill() {
        if (this.getGridField() == null || this.getGridField().getGridTab() == null) {
            return;
        }
        if (this.m_tableName == null) {
            this.setTableAndKeyColumn();
        }
        if (this.m_keyColumnName == null) {
            this.m_keyColumnName = this.getGridField().getColumnName();
        }
        if (!this.m_keyColumnName.endsWith("_ID")) {
            return;
        }
        MQuery query = new MQuery(this.m_tableName);
        query.addRestriction(this.m_keyColumnName, "=", this.oldValue);
        int windowNo = this.getGridField().getGridTab().getWindowNo();
        DrillEvent.DrillData data = new DrillEvent.DrillData(query, this.m_keyColumnName, this.oldValue, null, null);
        AEnv.actionDrill(data, windowNo);
    }

    private void setTableAndKeyColumn() {
        if (this.lookup != null && this.lookup instanceof MLookup) {
            this.m_keyColumnName = ((MLookup)this.lookup).getColumnName();
            if (this.m_keyColumnName.contains(".")) {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.indexOf("."));
                this.m_keyColumnName = this.m_keyColumnName.substring(this.m_keyColumnName.indexOf(".") + 1);
            } else {
                this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
            }
        } else if (this.getGridField() != null && this.getGridField().getGridTab() != null && this.getGridField().getAD_Column_ID() > 0) {
            MColumn column = MColumn.get((Properties)Env.getCtx(), (int)this.getGridField().getAD_Column_ID());
            this.m_tableName = column.getReferenceTableName();
            MTable table2 = MTable.get((Properties)Env.getCtx(), (String)this.m_tableName);
            this.m_keyColumnName = table2.getKeyColumns()[0];
        } else {
            this.m_keyColumnName = this.getColumnName();
            this.m_tableName = this.m_keyColumnName.substring(0, this.m_keyColumnName.length() - 3);
        }
    }

    protected void actionQuickEntry(boolean newRecord) {
        if (!this.getComponent().isEnabled()) {
            return;
        }
        int tabNo = this.gridField != null && this.gridField.getGridTab() != null ? this.gridField.getGridTab().getTabNo() : 0;
        final AbstractWQuickEntry vqe = Extensions.getQuickEntry(this.lookup.getWindowNo(), tabNo, this.lookup.getZoom());
        int Record_ID = 0;
        Object value = this.getValue();
        if (!newRecord) {
            if (value instanceof Integer) {
                Record_ID = (Integer)value;
            } else if (!Util.isEmpty((String)value.toString(), (boolean)true)) {
                Record_ID = Integer.parseInt(value.toString());
            }
        }
        vqe.loadRecord(Record_ID);
        final int finalRecord_ID = Record_ID;
        vqe.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int result = vqe.getRecord_ID();
                if (result == 0 && result == finalRecord_ID) {
                    return;
                }
                Integer newValue = result;
                WTableDirEditor.this.lookup.getDirect((Object)newValue, false, true);
                WTableDirEditor.this.setValue(result);
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, WTableDirEditor.this.getColumnName(), WTableDirEditor.this.oldValue, newValue);
                WTableDirEditor.this.fireValueChange(changeEvent);
                WTableDirEditor.this.oldValue = newValue;
            }
        });
        vqe.setVisible(true);
        AEnv.showWindow(vqe);
    }

    protected void actionLocation() {
        int BPLocation_ID = 0;
        Object value = this.getValue();
        if (value instanceof Integer) {
            BPLocation_ID = (Integer)value;
        } else if (value != null) {
            BPLocation_ID = Integer.parseInt(value.toString());
        }
        if (BPLocation_ID > 0) {
            MBPartnerLocation bpl = new MBPartnerLocation(Env.getCtx(), BPLocation_ID, null);
            MLocation location = new MLocation(Env.getCtx(), bpl.getC_Location_ID(), null);
            WLocationDialog vbp = new WLocationDialog(Msg.getMsg((Properties)Env.getCtx(), (String)"Location"), location);
            vbp.setVisible(true);
            AEnv.showWindow(vbp);
        }
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("REQUERY".equals(evt.getContextEvent())) {
            this.actionRefresh();
        } else if ("ZOOM".equals(evt.getContextEvent())) {
            this.actionZoom();
        } else {
            if ("VALUE_PREFERENCE".equals(evt.getContextEvent())) {
                if (this.isShowPreference()) {
                    ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue(), this.getDisplay());
                }
                return;
            }
            if ("NEW_RECORD".equals(evt.getContextEvent())) {
                this.actionQuickEntry(true);
            } else if ("UPDATE_RECORD".equals(evt.getContextEvent())) {
                this.actionQuickEntry(false);
            } else if ("CHANGE_LOG".equals(evt.getContextEvent())) {
                WFieldRecordInfo.start(this.gridField);
            } else if ("SHOW_LOCATION".equals(evt.getContextEvent())) {
                this.actionLocation();
            } else if (SHORT_LIST_EVENT.equals(evt.getContextEvent())) {
                String champ = this.getGridField().getHeader();
                if (this.onlyShortListItems) {
                    this.onlyShortListItems = false;
                    this.lookup.setShortList(false);
                    this.actionRefresh();
                    this.getLabel().setText(champ);
                } else {
                    this.onlyShortListItems = true;
                    this.lookup.setShortList(true);
                    this.actionRefresh();
                    this.getLabel().setText(">" + champ + "<");
                }
            } else if ("DRILL".equals(evt.getContextEvent())) {
                this.actionDrill();
            }
        }
    }

    @Override
    public void dynamicDisplay(Properties ctx) {
        if (this.lookup instanceof MLookup) {
            ((MLookup)this.lookup).getLookupInfo().ctx = ctx;
        }
        if (this.lookup != null && (!this.lookup.isValidated() || !this.lookup.isLoaded() || this.isReadWrite() && this.lookup.getSize() != this.getComponent().getItemCount())) {
            this.actionRefresh();
        }
        super.dynamicDisplay(ctx);
    }

    @Override
    public String getDisplayTextForGridView(Object value) {
        String separator;
        String s = super.getDisplayTextForGridView(value);
        if (s != null && ClientInfo.isMobile() && MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_LINE_BREAK_AS_IDENTIFIER_SEPARATOR", (boolean)true) && !Util.isEmpty((String)(separator = MSysConfig.getValue((String)"IDENTIFIER_SEPARATOR", null, (int)Env.getAD_Client_ID((Properties)Env.getCtx()))), (boolean)true) && s.indexOf(separator) >= 0) {
            s = s.replace(separator, "\n");
        }
        return s;
    }

    public boolean isRetainSelectedValueAfterRefresh() {
        return this.retainSelectedValueAfterRefresh;
    }

    public void setRetainSelectedValueAfterRefresh(boolean retainSelectedValueAfterRefresh) {
        this.retainSelectedValueAfterRefresh = retainSelectedValueAfterRefresh;
    }

    private static class CCacheListener
    extends CCache<String, Object> {
        private static final long serialVersionUID = 7813673017009600392L;
        private WTableDirEditor editor;
        private Future<?> refreshTask = null;

        protected CCacheListener(String tableName, WTableDirEditor editor) {
            super(tableName, tableName + "|CCacheListener", 0, 0, false);
            this.editor = editor;
        }

        public int reset() {
            this.scheduleRefreshTask();
            return 0;
        }

        public int reset(int recordId) {
            this.scheduleRefreshTask();
            return 0;
        }

        public void newRecord(int record_ID) {
            this.scheduleRefreshTask();
        }

        private void scheduleRefreshTask() {
            if (this.refreshTask != null && !this.refreshTask.isDone() && !this.refreshTask.isCancelled()) {
                this.refreshTask.cancel(true);
                this.refreshTask = null;
            }
            this.refreshTask = Adempiere.getThreadPoolExecutor().schedule(() -> this.refreshLookupList(), 500L, TimeUnit.MILLISECONDS);
        }

        private void refreshLookupList() {
            if (this.editor.getComponent().getDesktop() == null || !this.editor.isReadWrite()) {
                return;
            }
            Desktop desktop = this.editor.getComponent().getDesktop();
            boolean alive = false;
            if (desktop.isAlive() && desktop.getSession() != null) {
                SessionCtrl ctrl = (SessionCtrl)desktop.getSession();
                boolean bl = alive = !ctrl.isInvalidated();
            }
            if (!alive) {
                ((ITableDirEditor)((Object)this.editor.getComponent())).cleanup();
                return;
            }
            Executions.schedule((Desktop)desktop, (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) {
                    try {
                        if (editor.isReadWrite()) {
                            editor.actionRefresh();
                        }
                    }
                    catch (Exception exception) {}
                }
            }, (Event)new Event("onResetLookupList"));
        }

        public int size() {
            return 1;
        }
    }

    private static class EditorAutoComplete
    extends AutoComplete
    implements ITableDirEditor {
        private static final long serialVersionUID = 8435677226644775152L;
        protected WTableDirEditor editor;
        private DesktopCleanup listener = null;

        protected EditorAutoComplete() {
        }

        public void setPage(Page page) {
            super.setPage(page);
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (this.editor.tableCacheListener == null) {
                this.editor.createCacheListener();
                if (this.listener == null) {
                    this.listener = new DesktopCleanup(){

                        public void cleanup(Desktop desktop) throws Exception {
                            this.cleanup();
                        }
                    };
                    newpage.getDesktop().addListener((Object)this.listener);
                }
            }
        }

        @Override
        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            if (this.listener != null && page.getDesktop() != null) {
                page.getDesktop().removeListener((Object)this.listener);
            }
            this.cleanup();
        }

        @Override
        public void cleanup() {
            if (this.editor.tableCacheListener != null) {
                CacheMgt.get().unregister((CacheInterface)this.editor.tableCacheListener);
                this.editor.tableCacheListener = null;
            }
        }

        @Override
        public void setEditor(WTableDirEditor editor) {
            this.editor = editor;
        }

        @Override
        public void setValue(String value) {
            this.setText(value);
            if (Util.isEmpty((String)value, (boolean)true)) {
                this.refresh("");
            }
        }
    }

    private static class EditorCombobox
    extends Combobox
    implements ITableDirEditor {
        private static final long serialVersionUID = 9087317631313577239L;
        private WTableDirEditor editor;
        private DesktopCleanup listener = null;

        protected EditorCombobox() {
        }

        public void setPage(Page page) {
            super.setPage(page);
        }

        public void onPageAttached(Page newpage, Page oldpage) {
            super.onPageAttached(newpage, oldpage);
            if (this.editor.tableCacheListener == null) {
                this.editor.createCacheListener();
                if (this.listener == null) {
                    this.listener = new DesktopCleanup(){

                        public void cleanup(Desktop desktop) throws Exception {
                            this.cleanup();
                        }
                    };
                    newpage.getDesktop().addListener((Object)this.listener);
                }
            }
        }

        @Override
        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            if (this.listener != null && page.getDesktop() != null) {
                page.getDesktop().removeListener((Object)this.listener);
            }
            this.cleanup();
        }

        @Override
        public void cleanup() {
            if (this.editor.tableCacheListener != null) {
                CacheMgt.get().unregister((CacheInterface)this.editor.tableCacheListener);
                this.editor.tableCacheListener = null;
            }
        }

        @Override
        public void setEditor(WTableDirEditor editor) {
            this.editor = editor;
        }
    }

    private static interface ITableDirEditor {
        public void setEditor(WTableDirEditor var1);

        public void cleanup();
    }
}

