/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WImageEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WImageURLDialog;
import org.compiere.model.GridField;
import org.compiere.model.MAttachment;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Html;
import org.zkoss.zul.Image;
import org.zkoss.zul.Window;

public class WImageURLEditor
extends WEditor {
    private static final String[] LISTENER_EVENTS = new String[]{"onClick"};
    private boolean m_mandatory;
    private boolean readwrite;
    private String oldValue;
    private String contextPath = null;
    private static final CLogger log = CLogger.getCLogger(WImageEditor.class);

    public WImageURLEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WImageURLEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Image(){
            private static final long serialVersionUID = 8492629361709791256L;

            public void onPageAttached(Page newpage, Page oldpage) {
                Component p2;
                super.onPageAttached(newpage, oldpage);
                if (newpage != null && this.getParent() != null && (p2 = this.getParent()) instanceof Cell) {
                    Cell cell = (Cell)p2;
                    LayoutUtils.addSclass("image-field-cell", (HtmlBasedComponent)cell);
                }
            }
        }, gridField, tableEditor, editorConfiguration);
        this.getComponent().addCallback("afterPageAttached", (Callback & Serializable)t -> {
            if (this.contextPath == null && Executions.getCurrent() != null) {
                this.contextPath = Executions.getCurrent().getContextPath();
            }
        });
        this.init();
    }

    public Image getComponent() {
        return (Image)this.component;
    }

    private void init() {
        this.getComponent().setSrc(null);
        this.getComponent().setSclass("image-field");
        if (Executions.getCurrent() != null) {
            this.contextPath = Executions.getCurrent().getContextPath();
        }
    }

    @Override
    public String getDisplay() {
        return this.getValue() != null ? this.getValue().toString() : null;
    }

    @Override
    public Object getValue() {
        return this.oldValue;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadWrite() {
        return this.readwrite;
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.readwrite = readWrite;
        if (this.readwrite) {
            LayoutUtils.removeSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        } else {
            LayoutUtils.addSclass("image-field-readonly", (HtmlBasedComponent)this.getComponent());
        }
    }

    @Override
    public void setValue(Object value) {
        String newValue;
        String string = newValue = value != null ? value.toString() : null;
        if (Util.isEmpty((String)newValue, (boolean)true)) {
            this.oldValue = null;
            this.getComponent().setSrc(null);
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "width");
            ZkCssHelper.removeStyle((HtmlBasedComponent)this.getComponent(), "height");
            LayoutUtils.removeSclass("thumbnail", (HtmlBasedComponent)this.getComponent());
            LayoutUtils.removeSclass("image-fit", (HtmlBasedComponent)this.getComponent());
            this.getComponent().setClientAttribute("onmouseenter", null);
            this.getComponent().setClientAttribute("onmouseleave", null);
            this.getComponent().invalidate();
            return;
        }
        String width = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_WIDTH", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
        String height = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_HEIGHT", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
        String style = "width:" + width + ";height:" + height;
        ZkCssHelper.appendStyle((HtmlBasedComponent)this.getComponent(), style);
        LayoutUtils.addSclass("thumbnail", (HtmlBasedComponent)this.getComponent());
        LayoutUtils.addSclass("image-fit", (HtmlBasedComponent)this.getComponent());
        this.getComponent().setClientAttribute("onmouseenter", "idempiere.showFullSizeImage(event)");
        this.getComponent().setClientAttribute("onmouseleave", "idempiere.hideFullSizeImage(event)");
        this.getComponent().invalidate();
        if (log.isLoggable(Level.FINE)) {
            log.fine(value.toString());
        }
        if (MAttachment.isAttachmentURLPath((String)newValue)) {
            String url = MAttachment.getImageAttachmentURLFromPath(null, (String)newValue);
            this.getComponent().setSrc(url);
        } else {
            this.getComponent().setSrc(newValue);
        }
        this.oldValue = newValue;
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName()) && this.readwrite) {
            String script = "jq('#" + this.getComponent().getUuid() + "').trigger('mouseleave');";
            Clients.evalJavaScript((String)script);
            final WImageURLDialog dialog = new WImageURLDialog(this);
            dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    if (!dialog.isCancel()) {
                        String newValue = dialog.getValue();
                        WImageURLEditor.this.setValue(newValue);
                        ValueChangeEvent vce = new ValueChangeEvent(WImageURLEditor.this, WImageURLEditor.this.gridField.getColumnName(), WImageURLEditor.this.oldValue, newValue);
                        WImageURLEditor.this.fireValueChange(vce);
                        WImageURLEditor.this.oldValue = newValue;
                    }
                }
            });
            dialog.setPage(this.getComponent().getPage());
            dialog.setVflex("min");
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)dialog, 500);
            LayoutUtils.openPopupWindow((Component)this.getComponent(), (Window)dialog, "after_start");
            dialog.focus();
        }
    }

    @Override
    public void fillHorizontal() {
    }

    @Override
    public Component getDisplayComponent() {
        return new Html();
    }

    @Override
    public String getDisplayTextForGridView(GridRowCtx gridRowCtx, Object value) {
        String url;
        String string = url = value != null ? value.toString() : null;
        if (!Util.isEmpty((String)url, (boolean)true)) {
            String width = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_WIDTH", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
            String height = MSysConfig.getIntValue((String)"ZK_THUMBNAIL_IMAGE_HEIGHT", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) + "px";
            if (MAttachment.isAttachmentURLPath((String)url)) {
                if (this.contextPath == null && Executions.getCurrent() != null) {
                    this.contextPath = Executions.getCurrent().getContextPath();
                }
                url = MAttachment.getImageAttachmentURLFromPath((String)this.contextPath, (String)url);
            }
            StringBuilder builder = new StringBuilder("<img src='");
            builder.append(url).append("' style='width:").append(width).append(";").append("height:").append(height).append("' ").append("class='thumbnail image-fit' ").append("onmouseenter='idempiere.showFullSizeImage(event)' onmouseleave='idempiere.hideFullSizeImage(event)'/>");
            return builder.toString();
        }
        return "<span class='no-image'/>";
    }
}

