/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.adempiere.base.event.EventManager;
import org.adempiere.model.MBroadcastMessage;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.component.Anchorchildren;
import org.adempiere.webui.component.Anchorlayout;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.desktop.DashboardController;
import org.adempiere.webui.desktop.TabbedDesktop;
import org.adempiere.webui.event.MenuListener;
import org.adempiere.webui.event.ZKBroadCastManager;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.BroadcastMessageWindow;
import org.adempiere.webui.panel.HeaderPanel;
import org.adempiere.webui.panel.HelpController;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.panel.TimeoutPanel;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.UserPreference;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MPreference;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.MTreeFavorite;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebUtil;
import org.idempiere.broadcast.BroadCastMsg;
import org.idempiere.broadcast.BroadcastMsgUtil;
import org.idempiere.broadcast.IBroadcastMsgPopup;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.EventQueues;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.East;
import org.zkoss.zul.Image;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.Popup;
import org.zkoss.zul.West;

public class DefaultDesktop
extends TabbedDesktop
implements MenuListener,
Serializable,
EventListener<org.zkoss.zk.ui.event.Event>,
EventHandler,
DesktopCleanup {
    private static final long serialVersionUID = 1019213060161640026L;
    private static final String IMAGES_UPARROW_PNG = "images/collapse-header.png";
    private static final String IMAGES_DOWNARROW_PNG = "images/expand-header.png";
    private static final String IMAGES_CONTEXT_HELP_PNG = "images/Help16.png";
    private static final String IMAGES_THREELINE_MENU_PNG = "images/threelines.png";
    private static final String POPUP_OPEN_ATTR = "popup.open";
    private static final String HOME_TAB_RENDER_ATTR = "homeTab.render";
    private static final String HELP_CONTROLLER_WIDTH_PREFERENCE = "HelpController.Width";
    private static final String SIDE_CONTROLLER_WIDTH_PREFERENCE = "SideController.Width";
    private static final CLogger logger = CLogger.getCLogger(DefaultDesktop.class);
    private Borderlayout layout;
    private int noCount;
    private Tabpanel homeTab;
    private DashboardController dashboardController = new DashboardController();
    private DashboardController sideController = new DashboardController();
    private HeaderPanel pnlHead;
    private Desktop m_desktop = null;
    private HelpController helpController = new HelpController();
    private ToolBarButton max;
    private ToolBarButton contextHelp;
    private ToolBarButton showHeader;
    private Component headerContainer;
    private Window headerPopup;
    private Image logo;
    private boolean mobile;
    private Popup eastPopup;
    private Popup westPopup;
    private ToolBarButton westBtn;
    private GridTab gridTab;
    private boolean isQuickInfoOpen = true;
    private static final String autoHideMenuScript = "(function(){try{let w=zk.Widget.$('#{0}');let t=zk.Widget.$('#{1}');let e=new Object;e.target=t;w._docClick(e);}catch(error){}})()";

    public DefaultDesktop() {
        this.m_desktop = AEnv.getDesktop();
        this.m_desktop.addListener((Object)this);
        this.bindEventManager();
        try {
            ZKBroadCastManager.getBroadCastMgr();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        EventQueue queue = EventQueues.lookup((String)"ActivitiesEventQueue", (boolean)true);
        queue.subscribe((EventListener)this);
    }

    @Override
    protected Component doCreatePart(Component parent) {
        boolean headerCollapsed;
        boolean helpCollapsed;
        PageDefinition pagedef = Executions.getCurrent().getPageDefinition(ThemeManager.getThemeResource("zul/desktop/desktop.zul"));
        Component page = Executions.createComponents((PageDefinition)pagedef, (Component)parent, null);
        this.layout = (Borderlayout)page.getFellow("layout");
        this.headerContainer = page.getFellow("northBody");
        this.pnlHead = (HeaderPanel)this.headerContainer.getFellow("header");
        West w = this.layout.getWest();
        w.addEventListener("onOpen", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                OpenEvent oe = (OpenEvent)event;
                DefaultDesktop.this.updateMenuCollapsedPreference(!oe.isOpen());
            }
        });
        w.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                West w;
                if ("left".equals(event.getSwipeDirection()) && (w = (West)event.getTarget()).isOpen()) {
                    w.setOpen(false);
                    LayoutUtils.addSclass("slide", (HtmlBasedComponent)w);
                    DefaultDesktop.this.updateMenuCollapsedPreference(true);
                }
            }
        });
        w.addEventListener("onSize", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                West west = (West)event.getTarget();
                DefaultDesktop.this.updateSideControllerWidthPreference(west.getWidth());
            }
        });
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        boolean menuCollapsed = pref.isPropertyBool("MenuCollapsed");
        w.setOpen(!menuCollapsed);
        if (!w.isOpen()) {
            LayoutUtils.addSclass("slide", (HtmlBasedComponent)w);
        }
        this.mobile = ClientInfo.isMobile();
        w.setCollapsible(true);
        LayoutUtils.addSlideSclass((LayoutRegion)w);
        if (this.mobile) {
            w.setOpen(false);
        }
        East e = this.layout.getEast();
        e.addEventListener("onOpen", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                OpenEvent oe = (OpenEvent)event;
                DefaultDesktop.this.isQuickInfoOpen = oe.isOpen();
                DefaultDesktop.this.updateHelpCollapsedPreference(!oe.isOpen());
                Tabbox comp = DefaultDesktop.this.windowContainer.getComponent();
                if (comp != null) {
                    DefaultDesktop.this.contextHelp.setVisible(!oe.isOpen());
                    if (!oe.isOpen()) {
                        DefaultDesktop.this.layout.getEast().setVisible(false);
                    }
                }
            }
        });
        e.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                East e;
                if ("right".equals(event.getSwipeDirection()) && (e = (East)event.getTarget()).isOpen()) {
                    e.setOpen(false);
                    LayoutUtils.addSclass("slide", (HtmlBasedComponent)e);
                    DefaultDesktop.this.updateHelpCollapsedPreference(true);
                }
            }
        });
        e.addEventListener("onSize", (EventListener)new EventListener<org.zkoss.zk.ui.event.Event>(){

            public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                East east = (East)event.getTarget();
                DefaultDesktop.this.updateHelpWidthPreference(east.getWidth());
            }
        });
        String westWidth = this.getWestWidthPreference();
        String eastWidth = this.getEastWidthPreference();
        if (westWidth != null || eastWidth != null) {
            if (westWidth != null && eastWidth != null) {
                ClientInfo browserInfo = this.getClientInfo();
                int browserWidth = browserInfo.desktopWidth;
                int wWidth = Integer.valueOf(westWidth.replace("px", ""));
                int eWidth = Integer.valueOf(eastWidth.replace("px", ""));
                if (eWidth + wWidth <= browserWidth) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)w, westWidth);
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)e, eastWidth);
                }
            } else if (westWidth != null) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)w, westWidth);
            } else if (eastWidth != null) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)e, eastWidth);
            }
        }
        e.setVisible(!(helpCollapsed = pref.isPropertyBool("HelpCollapsed")));
        this.helpController.render((Component)e, this);
        if (this.mobile) {
            e.setVisible(false);
            e.setOpen(false);
            Component content = e.getFirstChild();
            this.eastPopup = new Popup();
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-remove");
            btn.addEventListener("onClick", evt -> {
                this.eastPopup.close();
                this.isQuickInfoOpen = false;
            });
            this.eastPopup.appendChild((Component)btn);
            btn.setStyle("position: absolute; top: 20px; right: 0px; padding: 2px 0px;");
            this.eastPopup.setStyle("padding-top: 20px;");
            this.eastPopup.appendChild(content);
            this.eastPopup.setPage(this.getComponent().getPage());
            this.eastPopup.setHeight("100%");
            this.helpController.setupFieldTooltip();
            this.eastPopup.addEventListener("onOpen", oe -> {
                this.isQuickInfoOpen = oe.isOpen();
            });
            this.westPopup = new Popup();
            this.westPopup.setStyle("padding-top: 10px;");
            this.westPopup.setPage(this.getComponent().getPage());
            this.westPopup.setHeight("100%");
            this.westPopup.addEventListener("onOpen", oe -> {
                if (oe.isOpen()) {
                    this.westPopup.setAttribute(POPUP_OPEN_ATTR, (Object)Boolean.TRUE);
                } else {
                    this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
                }
            });
        }
        Center windowArea = this.layout.getCenter();
        this.windowContainer.createPart(windowArea);
        this.homeTab = new Tabpanel();
        this.windowContainer.addWindow((Component)this.homeTab, Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Home")), false, null);
        this.homeTab.getLinkedTab().setSclass("desktop-hometab");
        ((Tab)this.homeTab.getLinkedTab()).setDisableDraggDrop(true);
        this.homeTab.setSclass("desktop-home-tabpanel");
        BusyDialog busyDialog = new BusyDialog();
        busyDialog.setShadow(false);
        this.homeTab.appendChild((Component)busyDialog);
        this.registerWindow(this.homeTab);
        BroadcastMessageWindow messageWindow = new BroadcastMessageWindow(this.pnlHead);
        BroadcastMsgUtil.showPendingMessage((int)Env.getAD_User_ID((Properties)Env.getCtx()), (IBroadcastMsgPopup)messageWindow);
        if (!this.layout.getDesktop().isServerPushEnabled()) {
            this.layout.getDesktop().enableServerPush(true);
        }
        Executions.schedule((Desktop)this.layout.getDesktop(), event -> {
            this.renderHomeTab();
            this.automaticOpen(Env.getCtx());
        }, (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("onRenderHomeTab"));
        ToolBar toolbar = this.windowContainer.getToobar();
        if (!this.mobile) {
            this.showHeader = new ToolBarButton(){

                public void onPageDetached(Page page) {
                    super.onPageDetached(page);
                    if (DefaultDesktop.this.headerPopup != null) {
                        DefaultDesktop.this.headerPopup.setPage(null);
                    }
                }
            };
            toolbar.appendChild((Component)this.showHeader);
            if (ThemeManager.isUseFontIconForImage()) {
                this.showHeader.setIconSclass("z-icon-ThreeLineMenu");
            } else {
                this.showHeader.setImage(ThemeManager.getThemeResource(IMAGES_THREELINE_MENU_PNG));
            }
            this.showHeader.addEventListener("onClick", this);
            this.showHeader.setSclass("window-container-toolbar-btn");
            this.showHeader.setVisible(false);
            this.max = new ToolBarButton();
            toolbar.appendChild((Component)this.max);
            if (ThemeManager.isUseFontIconForImage()) {
                this.max.setIconSclass("z-icon-Collapsing");
            } else {
                this.max.setImage(ThemeManager.getThemeResource(IMAGES_UPARROW_PNG));
            }
            this.max.addEventListener("onClick", this);
            this.max.setSclass("window-container-toolbar-btn");
        }
        this.contextHelp = new ToolBarButton();
        toolbar.appendChild((Component)this.contextHelp);
        if (ThemeManager.isUseFontIconForImage()) {
            this.contextHelp.setIconSclass("z-icon-Help");
        } else {
            this.contextHelp.setImage(ThemeManager.getThemeResource(IMAGES_CONTEXT_HELP_PNG));
        }
        this.contextHelp.addEventListener("onClick", this);
        this.contextHelp.setSclass("window-container-toolbar-btn context-help-btn");
        this.contextHelp.setTooltiptext(Util.cleanAmp((String)Msg.getElement((Properties)Env.getCtx(), (String)"AD_CtxHelp_ID")));
        this.contextHelp.setVisible(!e.isVisible());
        this.isQuickInfoOpen = e.isVisible();
        if (!this.mobile && (headerCollapsed = pref.isPropertyBool("HeaderCollapsed"))) {
            this.collapseHeader();
        }
        if (this.mobile) {
            this.westBtn = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                this.westBtn.setIconSclass("z-icon-ThreeLineMenu");
            } else {
                this.westBtn.setImage(ThemeManager.getThemeResource(IMAGES_THREELINE_MENU_PNG));
            }
            this.westBtn.addEventListener("onClick", this);
            this.westBtn.setSclass("window-container-toolbar-btn");
            this.westBtn.setStyle("cursor: pointer; padding: 0px; margin: 0px;");
        }
        return this.layout;
    }

    private String getWestWidthPreference() {
        String width = Env.getPreference((Properties)Env.getCtx(), (int)0, (String)SIDE_CONTROLLER_WIDTH_PREFERENCE, (boolean)false);
        if (!Util.isEmpty((String)width)) {
            ClientInfo browserInfo = this.getClientInfo();
            int browserWidth = browserInfo.desktopWidth;
            int prefWidth = Integer.valueOf(width.replace("px", ""));
            if (prefWidth <= browserWidth) {
                return width;
            }
        }
        return null;
    }

    protected void updateSideControllerWidthPreference(String width) {
        if (width != null) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), " Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{SIDE_CONTROLLER_WIDTH_PREFERENCE, userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_User_ID(userId);
                preference.setAttribute(SIDE_CONTROLLER_WIDTH_PREFERENCE);
            }
            preference.setValue(width);
            preference.saveEx();
        }
    }

    private String getEastWidthPreference() {
        String width = Env.getPreference((Properties)Env.getCtx(), (int)0, (String)HELP_CONTROLLER_WIDTH_PREFERENCE, (boolean)false);
        if (!Util.isEmpty((String)width)) {
            ClientInfo browserInfo = this.getClientInfo();
            int browserWidth = browserInfo.desktopWidth;
            int prefWidth = Integer.valueOf(width.replace("px", ""));
            if (prefWidth <= browserWidth) {
                return width;
            }
        }
        return null;
    }

    protected void updateHelpWidthPreference(String width) {
        if (width != null) {
            Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)195), " Attribute=? AND AD_User_ID=? AND AD_Process_ID IS NULL AND PreferenceFor = 'W'", null);
            int userId = Env.getAD_User_ID((Properties)Env.getCtx());
            MPreference preference = (MPreference)query.setOnlyActiveRecords(true).setApplyAccessFilter(true).setClient_ID().setParameters(new Object[]{HELP_CONTROLLER_WIDTH_PREFERENCE, userId}).first();
            if (preference == null || preference.getAD_Preference_ID() <= 0) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_User_ID(userId);
                preference.setAttribute(HELP_CONTROLLER_WIDTH_PREFERENCE);
            }
            preference.setValue(width);
            preference.saveEx();
        }
    }

    private void updateMenuCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("MenuCollapsed", collapsed);
        pref.savePreference();
    }

    private void updateHelpCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("HelpCollapsed", collapsed);
        pref.savePreference();
    }

    private void updateHeaderCollapsedPreference(boolean collapsed) {
        UserPreference pref = SessionManager.getSessionApplication().getUserPreference();
        pref.setProperty("HeaderCollapsed", collapsed);
        pref.savePreference();
    }

    @Override
    public void renderHomeTab() {
        this.homeTab.getChildren().clear();
        this.dashboardController.render((Component)this.homeTab, this, true);
        if (this.homeTab.getFirstChild() != null) {
            ITabOnSelectHandler handler = () -> this.invalidateDashboardPanel(this.homeTab.getFirstChild().getChildren());
            this.homeTab.getFirstChild().setAttribute("TabOnSelectHandler", (Object)handler);
        }
        this.homeTab.setAttribute(HOME_TAB_RENDER_ATTR, Boolean.TRUE);
        West w = this.layout.getWest();
        West side = null;
        if (this.mobile) {
            this.westPopup.getChildren().clear();
            side = this.westPopup;
            w.setVisible(false);
            if (this.westBtn.getParent() == null) {
                Component menuSearchPanel = this.pnlHead.getFellow("menuLookup");
                menuSearchPanel.getParent().insertBefore((Component)this.westBtn, menuSearchPanel);
            }
            this.setSidePopupWidth(this.westPopup);
            this.setSidePopupWidth(this.eastPopup);
        } else {
            w.getChildren().clear();
            side = w;
        }
        this.sideController.render((Component)side, this, false);
        if (this.mobile) {
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-remove");
            btn.addEventListener("onClick", evt -> {
                this.westPopup.close();
                this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
            });
            this.westPopup.appendChild((Component)btn);
            btn.setStyle("position: absolute; top: 10px; right: 0px; padding: 2px 0px;");
        }
        this.logo = this.pnlHead.getLogo();
        if (this.mobile && this.logo != null) {
            Anchorchildren ac = new Anchorchildren();
            ac.appendChild((Component)this.logo);
            ac.setStyle("padding: 4px;");
            Anchorlayout layout = (Anchorlayout)side.getFirstChild();
            layout.insertBefore((Component)ac, layout.getFirstChild());
        }
        if (this.mobile) {
            this.pnlHead.invalidate();
        }
        this.homeTab.invalidate();
    }

    private void invalidateDashboardPanel(List<Component> childrens) {
        for (Component children : childrens) {
            if (children instanceof DashboardPanel) {
                children.invalidate();
                continue;
            }
            this.invalidateDashboardPanel(children.getChildren());
        }
    }

    protected void setSidePopupWidth(Popup popup) {
        if (ClientInfo.minWidth(1200)) {
            popup.setWidth("30%");
        } else if (ClientInfo.minWidth(1000)) {
            popup.setWidth("40%");
        } else if (ClientInfo.minWidth(700)) {
            popup.setWidth("50%");
        } else if (ClientInfo.minWidth(500)) {
            popup.setWidth("60%");
        } else if (ClientInfo.minWidth(400)) {
            popup.setWidth("70%");
        } else {
            popup.setWidth("80%");
        }
    }

    public void onEvent(org.zkoss.zk.ui.event.Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            int menuId;
            ToolBarButton btn;
            if (comp == this.max) {
                if (this.layout.getNorth().isVisible()) {
                    this.collapseHeader();
                } else {
                    this.restoreHeader();
                }
            } else if (comp == this.showHeader) {
                this.showHeader.setPressed(true);
                if (this.pnlHead.getParent() != this.headerPopup) {
                    this.headerPopup.appendChild((Component)this.pnlHead);
                }
                LayoutUtils.openPopupWindow((Component)this.showHeader, (org.zkoss.zul.Window)this.headerPopup, "after_start");
            } else if (comp == this.contextHelp) {
                if (this.mobile && this.eastPopup != null) {
                    this.eastPopup.open((Component)this.layout.getCenter(), "overlap_end");
                    this.isQuickInfoOpen = true;
                    this.updateHelpQuickInfo(this.gridTab);
                } else {
                    this.layout.getEast().setVisible(true);
                    this.layout.getEast().setOpen(true);
                    LayoutUtils.removeSclass("slide", (HtmlBasedComponent)this.layout.getEast());
                    this.contextHelp.setVisible(false);
                    this.updateHelpCollapsedPreference(false);
                    this.isQuickInfoOpen = true;
                    this.updateHelpQuickInfo(this.gridTab);
                }
            } else if (comp == this.westBtn) {
                this.westPopup.open((Component)this.layout.getNorth(), "overlap_start");
                this.westPopup.setAttribute(POPUP_OPEN_ATTR, (Object)Boolean.TRUE);
            } else if (comp instanceof ToolBarButton && (btn = (ToolBarButton)comp).getAttribute("AD_Menu_ID") != null && (menuId = ((Integer)btn.getAttribute("AD_Menu_ID")).intValue()) > 0) {
                this.onMenuSelected(menuId);
            }
        } else if (eventName.equals("onActivitiesChanged")) {
            Integer count = (Integer)event.getData();
            boolean change = false;
            if (count != null && count != this.noCount) {
                this.noCount = count;
                change = true;
            }
            if (change) {
                this.updateUI();
            }
        }
    }

    protected void restoreHeader() {
        this.layout.getNorth().setVisible(true);
        if (ThemeManager.isUseFontIconForImage()) {
            this.max.setIconSclass("z-icon-Collapsing");
        } else {
            this.max.setImage(ThemeManager.getThemeResource(IMAGES_UPARROW_PNG));
        }
        this.showHeader.setVisible(false);
        this.pnlHead.detach();
        this.headerContainer.appendChild((Component)this.pnlHead);
        Clients.resize((Component)this.pnlHead);
        this.updateHeaderCollapsedPreference(false);
    }

    protected void collapseHeader() {
        this.layout.getNorth().setVisible(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.max.setIconSclass("z-icon-Expanding");
        } else {
            this.max.setImage(ThemeManager.getThemeResource(IMAGES_DOWNARROW_PNG));
        }
        this.showHeader.setVisible(true);
        this.pnlHead.detach();
        if (this.headerPopup == null) {
            this.headerPopup = new Window();
            this.headerPopup.setSclass("desktop-header-popup");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.headerPopup, "true");
            this.headerPopup.setVisible(false);
            this.headerPopup.addEventListener("onOpen", (EventListener)new EventListener<OpenEvent>(){

                public void onEvent(OpenEvent event) throws Exception {
                    if (!event.isOpen() && DefaultDesktop.this.showHeader.isPressed()) {
                        DefaultDesktop.this.showHeader.setPressed(false);
                    }
                }
            });
        }
        this.headerPopup.appendChild((Component)this.pnlHead);
        this.updateHeaderCollapsedPreference(true);
    }

    @Override
    public void setPage(Page page) {
        if (this.page != page) {
            this.layout.setPage(page);
            this.page = page;
            if (this.dashboardController != null) {
                this.dashboardController.onSetPage(page, this.layout.getDesktop());
            }
            if (this.sideController != null) {
                this.sideController.onSetPage(page, this.layout.getDesktop());
            }
        }
    }

    @Override
    public Component getComponent() {
        return this.layout;
    }

    @Override
    public void logout() {
        this.logout(null);
    }

    @Override
    public void logout(Callback<Boolean> callback) {
        if (this.layout != null && this.layout.getDesktop() != null && Executions.getCurrent() != null && Executions.getCurrent().getNativeRequest() != null) {
            int end;
            List tabs = this.windowContainer.getComponent().getTabs().getChildren();
            int i = end = tabs.size() - 1;
            while (i >= 0) {
                ((Tab)((Object)tabs.get(i))).close();
                --i;
            }
            AEnv.detachInputElement((Component)this.layout);
            this.layout.setVisible(false);
            Executions.schedule((Desktop)this.layout.getDesktop(), e -> this.asyncLogout(callback), (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("onAsyncLogout"));
        } else {
            this.asyncLogout(callback);
        }
    }

    private void asyncLogout(Callback<Boolean> callback) {
        this.unbindEventManager();
        if (this.dashboardController != null) {
            this.dashboardController.onLogOut();
            this.dashboardController = null;
        }
        if (this.sideController != null) {
            this.sideController.onLogOut();
            this.sideController = null;
        }
        if (callback != null) {
            if (this.layout != null && this.layout.getDesktop() != null && Executions.getCurrent() != null && Executions.getCurrent().getNativeRequest() != null) {
                Executions.schedule((Desktop)this.layout.getDesktop(), e -> callback.onCallback((Object)Boolean.TRUE), (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("onAsyncLogoutCallback"));
            } else {
                callback.onCallback((Object)Boolean.TRUE);
            }
        }
        this.layout = null;
        this.pnlHead = null;
        this.max = null;
        this.m_desktop = null;
    }

    public void updateUI() {
        this.windowContainer.setTabTitle(0, Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Home")) + " (" + this.noCount + ")", null);
    }

    private void autoHideMenu() {
        if (this.mobile) {
            if (this.westPopup.getAttribute(POPUP_OPEN_ATTR) != null) {
                this.westPopup.close();
                this.westPopup.removeAttribute(POPUP_OPEN_ATTR);
            }
            this.pnlHead.closeSearchPopup();
        } else if (this.layout.getWest().isCollapsible() && !this.layout.getWest().isOpen()) {
            String id = this.layout.getWest().getUuid();
            Tab tab = this.windowContainer.getSelectedTab();
            if (tab != null) {
                String tabId = tab.getUuid();
                String script = autoHideMenuScript.replace("{0}", id);
                script = script.replace("{1}", tabId);
                AuScript aus = new AuScript((Component)this.layout.getWest(), script);
                Clients.response((String)"autoHideWest", (AuResponse)aus);
            }
        }
    }

    @Override
    protected void preOpenNewTab() {
        this.autoHideMenu();
    }

    public void bindEventManager() {
        EventManager.getInstance().register("idempiere/broadcastMsg", (EventHandler)this);
    }

    public void unbindEventManager() {
        EventManager.getInstance().unregister((EventHandler)this);
    }

    public void handleEvent(Event event) {
        String eventName = event.getTopic();
        if (eventName.equals("idempiere/broadcastMsg")) {
            EventListener<org.zkoss.zk.ui.event.Event> listner = new EventListener<org.zkoss.zk.ui.event.Event>(){

                public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
                    BroadCastMsg msg = (BroadCastMsg)event.getData();
                    MBroadcastMessage mbMessage = null;
                    switch (msg.getEventId()) {
                        case 2: {
                            mbMessage = MBroadcastMessage.get((Properties)Env.getCtx(), (int)msg.getIntData());
                            if (mbMessage == null) {
                                return;
                            }
                            String currSession = Integer.toString(Env.getContextAsInt((Properties)Env.getCtx(), (String)"AD_Session_ID"));
                            if (!currSession.equals(msg.getTarget())) break;
                            BroadcastMessageWindow testMessageWindow = new BroadcastMessageWindow(DefaultDesktop.this.pnlHead);
                            testMessageWindow.appendMessage(mbMessage, true);
                            testMessageWindow = null;
                            break;
                        }
                        case 1: {
                            mbMessage = MBroadcastMessage.get((Properties)Env.getCtx(), (int)msg.getIntData());
                            if (mbMessage == null) {
                                return;
                            }
                            if (!mbMessage.isValidUserforMessage()) break;
                            BroadcastMessageWindow messageWindow = new BroadcastMessageWindow(DefaultDesktop.this.pnlHead);
                            messageWindow.appendMessage(mbMessage, false);
                            break;
                        }
                        case 3: {
                            String currSession = Integer.toString(Env.getContextAsInt((Properties)Env.getCtx(), (String)"AD_Session_ID"));
                            if (!currSession.equalsIgnoreCase(msg.getTarget())) break;
                            new TimeoutPanel(DefaultDesktop.this.pnlHead, msg.getIntData());
                            break;
                        }
                        case 4: {
                            String currSession = WebUtil.getServerName();
                            if (!currSession.equalsIgnoreCase(msg.getTarget())) break;
                            new TimeoutPanel(DefaultDesktop.this.pnlHead, msg.getIntData());
                        }
                    }
                }
            };
            Executions.schedule((Desktop)this.m_desktop, (EventListener)listner, (org.zkoss.zk.ui.event.Event)new org.zkoss.zk.ui.event.Event("OnBroadcast", null, event.getProperty("event.data")));
        }
    }

    public void cleanup(Desktop desktop) throws Exception {
        this.unbindEventManager();
    }

    @Override
    public void updateHelpContext(String ctxType, int recordId) {
        this.updateHelpContext(ctxType, recordId, null);
    }

    @Override
    public void updateHelpContext(String ctxType, int recordId, InfoPanel infoPanel) {
        if (recordId == 200000 && "F".equals(ctxType)) {
            return;
        }
        Clients.response((AuResponse)new AuScript("zWatch.fire('onFieldTooltip', this);"));
        this.helpController.renderCtxHelp(ctxType, recordId);
        GridTab gridTab = null;
        Component window = this.getActiveWindow();
        ADWindow adwindow = ADWindow.findADWindow(window);
        if (adwindow != null) {
            gridTab = adwindow.getADWindowContent().getActiveGridTab();
        }
        if ("I".equals(ctxType)) {
            this.updateHelpQuickInfo(infoPanel);
        } else {
            this.updateHelpQuickInfo(gridTab);
        }
    }

    @Override
    public void updateHelpTooltip(GridField gridField) {
        this.helpController.renderToolTip(gridField);
    }

    @Override
    public void updateHelpTooltip(String hdr, String desc, String help, String otherContent, String entityType) {
        this.helpController.renderToolTip(hdr, desc, help, otherContent, entityType);
    }

    @Override
    public void updateHelpQuickInfo(InfoPanel infoPanel) {
        if (this.isQuickInfoOpen) {
            this.helpController.renderQuickInfo(infoPanel);
        }
    }

    @Override
    public void updateHelpQuickInfo(GridTab gridTab) {
        this.gridTab = gridTab;
        if (this.isQuickInfoOpen) {
            this.helpController.renderQuickInfo(gridTab);
        }
    }

    @Override
    public ProcessDialog openProcessDialog(int processId, boolean soTrx) {
        ProcessDialog pd = super.openProcessDialog(processId, soTrx);
        this.updateHelpContext("P", processId);
        return pd;
    }

    @Override
    public ADForm openForm(int formId) {
        ADForm form = super.openForm(formId);
        this.updateHelpContext("F", formId);
        return form;
    }

    @Override
    public void openWorkflow(int workflow_ID) {
        super.openWorkflow(workflow_ID);
        this.updateHelpContext("W", workflow_ID);
    }

    @Override
    public void openTask(int taskId) {
        super.openTask(taskId);
        this.updateHelpContext("K", taskId);
    }

    @Override
    public boolean isPendingWindow() {
        List<Object> windows = this.getWindows();
        if (windows != null) {
            int idx = 0;
            while (idx < windows.size()) {
                Object ad = windows.get(idx);
                if (ad != null && ad instanceof ADWindow && ((ADWindow)ad).getADWindowContent() != null && ((ADWindow)ad).getADWindowContent().isPendingChanges()) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    @Override
    public void onMenuSelected(int menuId) {
        super.onMenuSelected(menuId);
        if (this.showHeader != null && this.showHeader.isVisible()) {
            String script = "(function(){let w=zk.Widget.$('#" + this.layout.getUuid() + "'); zWatch.fire('onFloatUp', w);})()";
            Clients.response((AuResponse)new AuScript(script));
        }
    }

    protected int getMenuID() {
        int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
        int AD_Tree_ID = DB.getSQLValue(null, (String)"SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", (int)AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        return AD_Tree_ID;
    }

    private void automaticOpen(Properties ctx) {
        if (this.isActionURL()) {
            return;
        }
        StringBuilder sql = new StringBuilder("SELECT m.Action, COALESCE(m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_InfoWindow_ID), m.AD_Menu_ID ").append(" FROM AD_Tree_Favorite_Node tfn ").append(" INNER JOIN AD_Menu m ON (tfn.AD_Menu_ID = m.AD_Menu_ID) ").append(" WHERE tfn.AD_Tree_Favorite_ID = ").append(MTreeFavorite.getFavoriteTreeID((int)Env.getAD_User_ID((Properties)Env.getCtx()))).append(" AND tfn.IsActive = 'Y' AND tfn.LoginOpenSeqNo >= 0 ").append(" ORDER BY tfn.LoginOpenSeqNo ");
        List rows = DB.getSQLArrayObjectsEx(null, (String)sql.toString(), (Object[])new Object[0]);
        if (rows != null && rows.size() > 0) {
            for (List row : rows) {
                Boolean access;
                String action = (String)row.get(0);
                int recordID = ((BigDecimal)row.get(1)).intValue();
                int menuID = ((BigDecimal)row.get(2)).intValue();
                if (action.equals("X")) {
                    access = MRole.getDefault().getFormAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openForm(recordID);
                    continue;
                }
                if (action.equals("I")) {
                    access = MRole.getDefault().getInfoAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openInfo(recordID);
                    continue;
                }
                if (action.equals("P") || action.equals("R")) {
                    access = MRole.getDefault().getProcessAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openProcessDialog(recordID, DB.getSQLValueStringEx(null, (String)"SELECT IsSOTrx FROM AD_Menu WHERE AD_Menu_ID = ?", (Object[])new Object[]{menuID}).equals("Y"));
                    continue;
                }
                if (action.equals("T")) {
                    access = MRole.getDefault().getTaskAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openTask(recordID);
                    continue;
                }
                if (action.equals("W")) {
                    access = MRole.getDefault().getWindowAccess(recordID);
                    if (access == null || !access.booleanValue()) continue;
                    SessionManager.getAppDesktop().openWindow(recordID, null);
                    continue;
                }
                if (!action.equals("F") || (access = MRole.getDefault().getWorkflowAccess(recordID)) == null || !access.booleanValue()) continue;
                SessionManager.getAppDesktop().openWorkflow(recordID);
            }
        }
    }

    @Override
    public void setClientInfo(ClientInfo clientInfo) {
        super.setClientInfo(clientInfo);
        if (clientInfo.tablet && this.homeTab != null && this.homeTab.getAttribute(HOME_TAB_RENDER_ATTR) != null) {
            this.dashboardController.updateLayout(clientInfo);
            this.updateSideLayout();
        }
    }

    private void updateSideLayout() {
        if (this.westPopup != null && this.westPopup.getChildren().size() > 1) {
            this.setSidePopupWidth(this.westPopup);
        }
        if (this.eastPopup != null && this.eastPopup.getChildren().size() > 1) {
            this.setSidePopupWidth(this.eastPopup);
        }
    }

    private boolean isActionURL() {
        String[] strs;
        ConcurrentHashMap parameters = new ConcurrentHashMap(Executions.getCurrent().getParameterMap());
        String action = "";
        if (parameters != null && (strs = (String[])parameters.get("Action")) != null && strs.length == 1 && strs[0] != null) {
            action = strs[0];
        }
        return !Util.isEmpty((String)action);
    }
}

