/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListCell;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.WTableColumn;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.TableValueChangeEvent;
import org.adempiere.webui.event.TableValueChangeListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.SelectableIDColumn;
import org.compiere.minigrid.UUIDColumn;
import org.compiere.model.MImage;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.MSort;
import org.compiere.util.Util;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.impl.InputElement;

public class WListItemRenderer
implements ListitemRenderer<Object>,
EventListener<Event>,
ListitemRendererExt {
    protected ArrayList<TableValueChangeListener> m_listeners = new ArrayList();
    private Set<ListItem> m_selectedItems = new HashSet<ListItem>();
    private ArrayList<WTableColumn> m_tableColumns = new ArrayList();
    private ArrayList<ListHeader> m_headers = new ArrayList();
    private Listbox listBox;
    private EventListener<Event> cellListener;

    public WListItemRenderer() {
    }

    public WListItemRenderer(List<? extends String> columnNames) {
        for (String string : columnNames) {
            WTableColumn tableColumn = new WTableColumn();
            tableColumn.setHeaderValue(Util.cleanAmp((String)string));
            this.m_tableColumns.add(tableColumn);
        }
    }

    public WTableColumn getColumn(int columnIndex) {
        try {
            return this.m_tableColumns.get(columnIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("There is no WTableColumn at column " + columnIndex);
        }
    }

    public void render(Listitem item, Object data, int index) throws Exception {
        this.render((ListItem)item, data, index);
    }

    private void render(ListItem item, Object data, int index) {
        Listcell listcell = null;
        int colIndex = 0;
        int rowIndex = item.getIndex();
        WListbox table = null;
        if (item.getListbox() instanceof WListbox) {
            table = (WListbox)item.getListbox();
        }
        if (!(data instanceof List)) {
            throw new IllegalArgumentException("A model element was not a list");
        }
        if (this.listBox == null || this.listBox != item.getListbox()) {
            this.listBox = item.getListbox();
        }
        if (this.cellListener == null) {
            this.cellListener = new CellListener();
        }
        for (Object field : (List)data) {
            listcell = this.getCellComponent(table, field, rowIndex, colIndex);
            listcell.setParent((Component)item);
            listcell.addEventListener("onDoubleClick", this.cellListener);
            if (this.m_tableColumns != null && this.m_tableColumns.size() == ++colIndex) break;
        }
    }

    protected Listcell getCellComponent(WListbox table, Object value, int rowIndex, int columnIndex) {
        WEditor editor;
        boolean isCellEditable;
        ListCell listcell = new ListCell();
        WTableColumn column = null;
        if (this.m_tableColumns.size() > columnIndex && (column = this.getColumn(columnIndex)) != null && column.getHeaderValue() != null) {
            listcell.setClientAttribute("instanceName", column.getHeaderValue().toString());
        }
        boolean bl = isCellEditable = table != null ? table.isCellEditable(rowIndex, columnIndex) : false;
        if (column != null && column.getEditorProvider() != null && (editor = column.getEditorProvider().apply(new WTableColumn.EditorProviderParameters(table, rowIndex, columnIndex, value))) != null) {
            editor.setValue(value);
            if (isCellEditable) {
                editor.setReadWrite(true);
                editor.setTableEditor(true);
                editor.addValueChangeListener(evt -> this.onValueChange(evt));
                listcell.appendChild(editor.getComponent());
            } else {
                editor.setReadWrite(false);
                Component displayComponent = editor.getDisplayComponent();
                if (displayComponent != null && displayComponent instanceof Html) {
                    String text = editor.getDisplayTextForGridView(value);
                    ((Html)displayComponent).setContent(text);
                    listcell.appendChild(displayComponent);
                } else if (displayComponent != null && displayComponent instanceof Label) {
                    String text = editor.getDisplay();
                    ((Label)displayComponent).setValue(text);
                    listcell.appendChild(displayComponent);
                } else if (displayComponent != null && displayComponent instanceof InputElement) {
                    String text = editor.getDisplay();
                    ((InputElement)displayComponent).setText(text);
                    ((InputElement)displayComponent).setReadonly(true);
                    listcell.appendChild(displayComponent);
                } else {
                    listcell.appendChild(editor.getComponent());
                }
            }
            return listcell;
        }
        if (value != null) {
            if (value instanceof Boolean) {
                listcell.setValue(Boolean.valueOf(value.toString()));
                if (table != null && columnIndex == 0) {
                    table.setCheckmark(false);
                }
                Checkbox checkbox = new Checkbox();
                checkbox.setChecked(Boolean.valueOf(value.toString()));
                if (isCellEditable) {
                    checkbox.setEnabled(true);
                    checkbox.addEventListener("onCheck", this);
                } else {
                    checkbox.setEnabled(false);
                }
                listcell.appendChild((Component)checkbox);
                ZkCssHelper.appendStyle((HtmlBasedComponent)listcell, "text-align:center");
            } else if (value instanceof Number) {
                if (this.m_tableColumns != null && columnIndex < this.m_tableColumns.size() && this.m_tableColumns.get(columnIndex).getColumnClass() != null && this.m_tableColumns.get(columnIndex).getColumnClass().getName().equals(MImage.class.getName()) && value instanceof Integer) {
                    MImage mImage = MImage.get((Properties)Env.getCtx(), (int)((Integer)value));
                    AImage img = null;
                    byte[] data = mImage.getData();
                    if (data != null && data.length > 0) {
                        try {
                            img = new AImage(null, data);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    org.zkoss.zul.Image image = new org.zkoss.zul.Image();
                    image.setContent(img);
                    image.setStyle("width: 48px; height: 48px;");
                    listcell.appendChild((Component)image);
                    listcell.setStyle("text-align: center;");
                } else {
                    Language lang = AEnv.getLanguage(Env.getCtx());
                    int displayType = value instanceof BigDecimal || value instanceof Double || value instanceof Float ? 12 : 11;
                    DecimalFormat format = DisplayType.getNumberFormat((int)displayType, (Language)lang);
                    listcell.setValue(value.toString());
                    if (isCellEditable) {
                        NumberBox numberbox = new NumberBox(false);
                        numberbox.getDecimalbox().setFormat(format.toPattern());
                        numberbox.getDecimalbox().setLocale(lang.getLocale());
                        numberbox.setFormat(format);
                        numberbox.setValue(value);
                        numberbox.setEnabled(true);
                        numberbox.setStyle("text-align:right; width: 96%;" + listcell.getStyle());
                        numberbox.addEventListener("onChange", this);
                        listcell.appendChild((Component)numberbox);
                        if (ClientInfo.isMobile()) {
                            numberbox.getButton().setVisible(false);
                        }
                    } else {
                        listcell.setLabel(format.format(value));
                        ZkCssHelper.appendStyle((HtmlBasedComponent)listcell, "text-align: right");
                    }
                }
            } else if (value instanceof Timestamp) {
                int refId = 0;
                if (this.m_tableColumns != null && columnIndex < this.m_tableColumns.size()) {
                    refId = this.m_tableColumns.get(columnIndex).getAD_Reference_ID();
                }
                if (refId == 0) {
                    refId = 15;
                }
                SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)refId, (Language)AEnv.getLanguage(Env.getCtx()));
                listcell.setValue(dateFormat.format((Timestamp)value));
                if (isCellEditable) {
                    Datebox datebox = new Datebox();
                    datebox.setValue(new Date(((Timestamp)value).getTime()));
                    datebox.addEventListener("onChange", this);
                    listcell.appendChild((Component)datebox);
                } else {
                    listcell.setLabel(dateFormat.format((Timestamp)value));
                    ZkCssHelper.appendStyle((HtmlBasedComponent)listcell, "margin: auto");
                }
            } else if (value instanceof String) {
                if (this.m_tableColumns != null && columnIndex < this.m_tableColumns.size() && this.m_tableColumns.get(columnIndex).getColumnClass() != null && this.m_tableColumns.get(columnIndex).getColumnClass().getName().equals(MImage.class.getName())) {
                    try {
                        URL url = new URL(value.toString());
                        AImage aImage = new AImage(url);
                        org.zkoss.zul.Image image = new org.zkoss.zul.Image();
                        image.setContent((Image)aImage);
                        image.setStyle("width: 16px; height: 16px; display: block;");
                        listcell.appendChild((Component)image);
                        listcell.setStyle("text-align: center;");
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    listcell.setValue(value.toString());
                    if (isCellEditable) {
                        Textbox textbox = new Textbox();
                        textbox.setValue(value.toString());
                        textbox.addEventListener("onChange", this);
                        ZkCssHelper.appendStyle((HtmlBasedComponent)textbox, "width: 96%;");
                        listcell.appendChild((Component)textbox);
                    } else {
                        listcell.setLabel(value.toString());
                    }
                }
            } else if (value instanceof IDColumn || value instanceof UUIDColumn) {
                if (value instanceof IDColumn) {
                    listcell.setValue(((IDColumn)value).getRecord_ID());
                } else {
                    listcell.setValue(((UUIDColumn)value).getRecord_UU());
                }
                if (!table.isCheckmark()) {
                    table.setCheckmark(true);
                    table.removeEventListener("onSelect", this);
                    table.addEventListener("onSelect", this);
                }
            } else {
                listcell.setLabel(value.toString());
                listcell.setValue(value.toString());
            }
        } else {
            listcell.setLabel("");
            listcell.setValue("");
        }
        return listcell;
    }

    private void onValueChange(ValueChangeEvent evt) {
        WEditor editor = (WEditor)evt.getSource();
        Component component = editor.getComponent();
        int row = this.getRowPosition(component);
        int col = this.getColumnPosition(component);
        WTableColumn tableColumn = this.getColumn(col);
        TableValueChangeEvent vcEvent = new TableValueChangeEvent(component, tableColumn.getHeaderValue().toString(), row, col, evt.getOldValue(), evt.getNewValue());
        this.fireTableValueChange(vcEvent);
    }

    public void updateColumn(int index, String header) {
        WTableColumn tableColumn = this.getColumn(index);
        tableColumn.setHeaderValue(Util.cleanAmp((String)header));
    }

    public void addColumn(String header) {
        this.addColumn(header, null);
    }

    public void addColumn(String header, String description) {
        this.addColumn(header, description, 0);
    }

    public void addColumn(String header, String description, int AD_Reference_ID) {
        WTableColumn tableColumn = new WTableColumn();
        tableColumn.setHeaderValue(Util.cleanAmp((String)header));
        tableColumn.setTooltipText(description);
        tableColumn.setAD_Reference_ID(AD_Reference_ID);
        this.m_tableColumns.add(tableColumn);
    }

    public int getNoColumns() {
        return this.m_tableColumns.size();
    }

    @Deprecated(forRemoval=true, since="11")
    public void setRO(int colIndex, Boolean readOnly) {
    }

    private Component getListHeaderComponent(Object headerValue, String tooltipText, int headerIndex, Class<?> classType) {
        ListHeader header = null;
        String headerText = headerValue.toString();
        if (this.m_headers.size() <= headerIndex || this.m_headers.get(headerIndex) == null) {
            if (classType != null && (classType.isAssignableFrom(IDColumn.class) || classType.isAssignableFrom(UUIDColumn.class))) {
                header = new ListHeader("");
                ZKUpdateUtil.setWidth((HtmlBasedComponent)header, "30px");
                header.setAlign("center");
                header.setValign("middle");
            } else {
                Comparator<Object> ascComparator = this.getColumnComparator(true, headerIndex);
                Comparator<Object> dscComparator = this.getColumnComparator(false, headerIndex);
                header = new ListHeader(headerText);
                if (!Util.isEmpty((String)tooltipText)) {
                    header.setTooltiptext(tooltipText);
                }
                header.setSort("auto");
                header.setSortAscending(ascComparator);
                header.setSortDescending(dscComparator);
                int width = headerText.trim().length() * 9;
                if (width > 300) {
                    width = 300;
                } else if (classType != null) {
                    if (classType.equals(String.class)) {
                        if (width > 0 && width < 180) {
                            width = 180;
                        }
                    } else if (classType.equals(IDColumn.class) || classType.equals(UUIDColumn.class)) {
                        header.setSort("none");
                        if (width < 30) {
                            width = 30;
                        }
                    } else if (classType.isAssignableFrom(Boolean.class)) {
                        if (width > 0 && width < 30) {
                            width = 30;
                        }
                    } else if (width > 0 && width < 100) {
                        width = 100;
                    }
                } else if (width > 0 && width < 100) {
                    width = 100;
                }
                header.setStyle("min-width: " + width + "px");
            }
            ZKUpdateUtil.setHflex((HtmlBasedComponent)header, "min");
            this.m_headers.add(header);
        } else {
            header = this.m_headers.get(headerIndex);
            if (!header.getLabel().equals(headerText)) {
                header.setLabel(headerText);
            }
        }
        return header;
    }

    public void setListHeader(int index, ListHeader header) {
        int size = this.m_headers.size();
        if (size <= index) {
            while (size <= index) {
                if (size == index) {
                    this.m_headers.add(header);
                } else {
                    this.m_headers.add(null);
                }
                ++size;
            }
        } else {
            this.m_headers.set(index, header);
        }
    }

    public ListHeader getListHeader(int index) {
        if (this.m_headers.size() <= index) {
            return null;
        }
        return this.m_headers.get(index);
    }

    protected Comparator<Object> getColumnComparator(boolean ascending, int columnIndex) {
        return new ColumnComparator(ascending, columnIndex);
    }

    public void renderListHead(ListHead head) {
        int columnIndex = 0;
        while (columnIndex < this.m_tableColumns.size()) {
            WTableColumn column = this.m_tableColumns.get(columnIndex);
            Component header = this.getListHeaderComponent(column.getHeaderValue(), column.getTooltipText(), columnIndex, column.getColumnClass());
            head.appendChild(header);
            ++columnIndex;
        }
        head.setSizable(true);
    }

    public void onEvent(Event event) throws Exception {
        WListbox table;
        int col = -1;
        int row = -1;
        Object value = null;
        TableValueChangeEvent vcEvent = null;
        Component source = event.getTarget();
        if (this.isWithinListCell(source)) {
            row = this.getRowPosition(source);
            col = this.getColumnPosition(source);
            WTableColumn tableColumn = this.m_tableColumns.get(col);
            if (source instanceof Checkbox) {
                value = ((Checkbox)source).isChecked();
            } else if (source instanceof Decimalbox) {
                value = ((Decimalbox)source).getValue();
            } else if (source instanceof Datebox) {
                if (((Datebox)source).getValue() != null) {
                    value = new Timestamp(((Datebox)source).getValue().getTime());
                }
            } else if (source instanceof Textbox) {
                value = ((Textbox)source).getValue();
            }
            if (value != null) {
                vcEvent = new TableValueChangeEvent(source, tableColumn.getHeaderValue().toString(), row, col, value, value);
                this.fireTableValueChange(vcEvent);
            }
        } else if (event.getTarget() instanceof WListbox && "onSelect".equals(event.getName()) && (table = (WListbox)event.getTarget()).isCheckmark()) {
            int cnt = table.getRowCount();
            if (cnt == 0 || !(table.getValueAt(0, 0) instanceof IDColumn) && !(table.getValueAt(0, 0) instanceof UUIDColumn)) {
                return;
            }
            WTableColumn tableColumn = this.m_tableColumns.get(0);
            int i = 0;
            while (i < cnt) {
                SelectableIDColumn idcolumn = (SelectableIDColumn)table.getValueAt(i, 0);
                ListItem item = table.getItemAtIndex(i);
                value = item.isSelected();
                Boolean old = idcolumn.isSelected();
                if (!old.equals(value)) {
                    vcEvent = new TableValueChangeEvent(source, tableColumn.getHeaderValue().toString(), i, 0, old, value);
                    this.fireTableValueChange(vcEvent);
                }
                ++i;
            }
        }
    }

    private boolean isWithinListCell(Component source) {
        if (source instanceof Listcell) {
            return true;
        }
        Component c = source.getParent();
        while (c != null) {
            if (c instanceof Listcell) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    protected int getRowPosition(Component source) {
        int row = -1;
        Listcell cell = this.findListcell(source);
        ListItem item = (ListItem)cell.getParent();
        row = item.getIndex();
        return row;
    }

    private Listcell findListcell(Component source) {
        if (source instanceof Listcell) {
            return (Listcell)source;
        }
        Component c = source.getParent();
        while (c != null) {
            if (c instanceof Listcell) {
                return (Listcell)c;
            }
            c = c.getParent();
        }
        return null;
    }

    protected int getColumnPosition(Component source) {
        int col = -1;
        Listcell cell = this.findListcell(source);
        col = cell.getColumnIndex();
        return col;
    }

    public void clearColumns() {
        this.m_tableColumns.clear();
    }

    public void clearSelection() {
        this.m_selectedItems.clear();
    }

    public void addTableValueChangeListener(TableValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.m_listeners.add(listener);
    }

    public void removeTableValueChangeListener(TableValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.m_listeners.remove(listener);
    }

    private void fireTableValueChange(TableValueChangeEvent event) {
        for (TableValueChangeListener listener : this.m_listeners) {
            listener.tableValueChange(event);
        }
    }

    public int getControls() {
        return 1;
    }

    public Listcell newListcell(Listitem item) {
        ListCell cell = new ListCell();
        cell.applyProperties();
        return cell;
    }

    public Listitem newListitem(Listbox listbox) {
        ListItem item = new ListItem();
        item.applyProperties();
        return item;
    }

    public void setColumnHeader(int index, String header) {
        if (index >= 0 && index < this.m_tableColumns.size()) {
            this.m_tableColumns.get(index).setHeaderValue(Util.cleanAmp((String)header));
        }
    }

    public void setColumnClass(int index, Class<?> classType) {
        if (index >= 0 && index < this.m_tableColumns.size()) {
            this.m_tableColumns.get(index).setColumnClass(classType);
        }
    }

    public List<WTableColumn> getTableColumns() {
        return Collections.unmodifiableList(this.m_tableColumns);
    }

    class CellListener
    implements EventListener<Event> {
        public void onEvent(Event event) throws Exception {
            if (WListItemRenderer.this.listBox != null && "onDoubleClick".equals(event.getName())) {
                Event evt = new Event("onDoubleClick", (Component)WListItemRenderer.this.listBox);
                Events.sendEvent((Component)WListItemRenderer.this.listBox, (Event)evt);
                Clients.evalJavaScript((String)"jq('img.fullsize-image').remove();");
            }
        }
    }

    public static class ColumnComparator
    implements Comparator<Object> {
        private int columnIndex;
        private MSort sort;

        public ColumnComparator(boolean ascending, int columnIndex) {
            this.columnIndex = columnIndex;
            this.sort = new MSort(0, null);
            this.sort.setSortAsc(ascending);
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object item1 = ((List)o1).get(this.columnIndex);
            Object item2 = ((List)o2).get(this.columnIndex);
            return this.sort.compare(item1, item2);
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }
    }
}

