/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph;

import java.awt.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.adempiere.apps.graph.GraphColumn;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.model.GoalModel;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.compiere.model.Lookup;
import org.compiere.model.MGoal;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMeasure;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.A;
import org.zkoss.zhtml.Br;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.East;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;

public class WGraph
extends Div
implements IdSpace {
    private static final long serialVersionUID = -975989183542113080L;
    private static final String ZOOM_KEY = "queryZoom";
    private boolean m_hideTitle;
    private Panel panel;
    private boolean m_renderTable = false;
    private boolean m_renderChart = true;
    private Point m_point0_0 = null;
    private static final CLogger log = CLogger.getCLogger(WGraph.class);
    private String m_Y_TargetLabel = null;
    protected ArrayList<GraphColumn> list = new ArrayList();
    private boolean m_chartSelection;
    private int zoomFactor = 0;
    private MGoal m_goal;
    private String m_xAxisLabel;
    private String m_yAxisLabel;
    protected DecimalFormat format = DisplayType.getNumberFormat((int)12);

    public WGraph() {
        this.panel = new Panel();
    }

    public WGraph(MGoal goal) {
        this(goal, 0, false, false, false, true);
    }

    public WGraph(MGoal goal, int zoom, boolean chartSelection, boolean hideTitle, boolean renderTable, boolean renderChart) {
        this();
        this.setGoal(goal);
        this.m_chartSelection = chartSelection;
        this.zoomFactor = zoom;
        this.m_hideTitle = hideTitle;
        this.m_renderTable = renderTable;
        this.m_renderChart = renderChart;
        this.loadData();
        this.render();
    }

    public void setGoal(MGoal goal) {
        this.m_goal = goal;
        this.m_yAxisLabel = goal.getName();
        this.m_xAxisLabel = goal.getXAxisText();
    }

    public boolean isChartSelection() {
        return this.m_chartSelection;
    }

    public void setChartSelection(boolean chartSelection) {
        this.m_chartSelection = chartSelection;
    }

    public void render() {
        Borderlayout layout = null;
        this.getChildren().clear();
        if (this.m_renderTable && this.m_renderChart) {
            layout = new Borderlayout();
            this.appendChild((Component)layout);
            layout.setStyle("height: 100%; width: 100%; position: relative;");
            Center center = new Center();
            layout.appendChild((Component)center);
            center.appendChild((Component)this.panel);
        } else {
            this.appendChild((Component)this.panel);
        }
        if (this.m_renderChart) {
            this.renderChart(null);
        }
        if (this.m_renderTable) {
            if (this.m_renderChart) {
                East east = new East();
                east.setAutoscroll(true);
                if (ClientInfo.maxWidth(999)) {
                    east.setOpen(false);
                    east.setSplittable(true);
                    east.setCollapsible(true);
                }
                layout.appendChild((Component)east);
                this.renderTable((Component)east);
            } else {
                Panelchildren pc = this.panel.getPanelchildren();
                if (pc == null) {
                    pc = new Panelchildren();
                    this.panel.appendChild((Component)pc);
                } else {
                    pc.getChildren().clear();
                }
                this.renderTable((Component)pc);
            }
        }
    }

    private void loadData() {
        MMeasure measure = this.m_goal.getMeasure();
        if (measure == null) {
            log.warning("No Measure for " + String.valueOf(this.m_goal));
            return;
        }
        this.list = measure.getGraphColumnList(this.m_goal);
        if (this.m_renderChart && this.m_chartSelection) {
            Toolbar toolbar = new Toolbar();
            this.panel.appendChild((Component)toolbar);
            int AD_Reference_Value_ID = DB.getSQLValue(null, (String)"SELECT AD_Reference_ID FROM AD_Reference WHERE Name = ?", (String)"PA_Goal ChartType");
            MLookupInfo info = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)AD_Reference_Value_ID);
            MLookup mLookup = new MLookup(info, 0);
            WTableDirEditor editor = new WTableDirEditor("ChartType", false, false, true, (Lookup)mLookup);
            toolbar.appendChild((Component)editor.getComponent());
            editor.addValueChangeListener(new ValueChangeListener(){

                @Override
                public void valueChange(ValueChangeEvent evt) {
                    Object value = evt.getNewValue();
                    if (value == null || value.toString().trim().length() == 0) {
                        return;
                    }
                    WGraph.this.renderChart(value.toString());
                }
            });
        }
    }

    private void renderChart(String type) {
        int width = 560;
        int height = 400;
        if (ClientInfo.maxWidth(width - 1)) {
            width = ClientInfo.get().desktopWidth;
            height = (int)((float)width * 0.71428573f);
        }
        if (this.panel.getPanelchildren() != null) {
            this.panel.getPanelchildren().getChildren().clear();
        } else {
            Panelchildren pc = new Panelchildren();
            this.panel.appendChild((Component)pc);
        }
        this.panel.getPanelchildren().setStyle("overflow: auto;");
        GoalModel goalModel = new GoalModel();
        goalModel.goal = this.m_goal;
        goalModel.chartType = type != null ? type : this.m_goal.getChartType();
        goalModel.columnList = Collections.unmodifiableList(this.list);
        goalModel.showTitle = !this.m_hideTitle;
        goalModel.xAxisLabel = this.m_xAxisLabel;
        goalModel.yAxisLabel = this.m_yAxisLabel;
        goalModel.zoomFactor = this.zoomFactor;
        List<IChartRendererService> list = Extensions.getChartRendererServices();
        for (IChartRendererService renderer : list) {
            if (renderer.renderPerformanceGraph((Component)this.panel.getPanelchildren(), width, height, goalModel)) break;
        }
    }

    public Point getPoint0_0() {
        return this.m_point0_0;
    }

    public String getX_AxisLabel() {
        return this.m_xAxisLabel;
    }

    public void setX_AxisLabel(String axisLabel) {
        this.m_xAxisLabel = axisLabel;
    }

    public String getY_AxisLabel() {
        return this.m_yAxisLabel;
    }

    public void setY_AxisLabel(String axisLabel) {
        this.m_yAxisLabel = axisLabel;
    }

    public String getY_TargetLabel() {
        return this.m_Y_TargetLabel;
    }

    public void setY_TargetLabel(String targetLabel, double target) {
        this.m_Y_TargetLabel = targetLabel;
    }

    public int getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(int zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public boolean isRenderTable() {
        return this.m_renderTable;
    }

    public void setRenderTable(boolean mRenderTable) {
        this.m_renderTable = mRenderTable;
    }

    public boolean isRenderChart() {
        return this.m_renderChart;
    }

    public void setRenderChart(boolean mRenderChart) {
        this.m_renderChart = mRenderChart;
    }

    public GraphColumn[] getGraphColumnList() {
        GraphColumn[] array = new GraphColumn[this.list.size()];
        int i = 0;
        while (i < this.list.size()) {
            array[i] = this.list.get(i);
            ++i;
        }
        return array;
    }

    private void renderTable(Component parent) {
        Div div = new Div();
        this.appendChild((Component)div);
        div.setSclass("pa-content");
        parent.appendChild((Component)div);
        Table table2 = new Table();
        table2.setSclass("pa-dataGrid");
        div.appendChild((Component)table2);
        Tr tr2 = new Tr();
        table2.appendChild((Component)tr2);
        Td td2 = new Td();
        td2.setSclass("pa-label");
        tr2.appendChild((Component)td2);
        Text text = new Text(Msg.getElement((Properties)Env.getCtx(), (String)"MeasureTarget"));
        td2.appendChild((Component)text);
        td2 = new Td();
        td2.setDynamicProperty("colspan", (Object)"2");
        td2.setSclass("pa-tdcontent");
        tr2.appendChild((Component)td2);
        text = new Text(this.format.format(this.m_goal.getMeasureTarget().setScale(2, RoundingMode.HALF_UP)));
        td2.appendChild((Component)text);
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        td2.setSclass("pa-label");
        tr2.appendChild((Component)td2);
        text = new Text(Msg.getElement((Properties)Env.getCtx(), (String)"MeasureActual"));
        td2.appendChild((Component)text);
        td2 = new Td();
        td2.setDynamicProperty("colspan", (Object)"2");
        td2.setSclass("pa-tdcontent");
        tr2.appendChild((Component)td2);
        text = new Text(this.format.format(this.m_goal.getMeasureActual().setScale(2, RoundingMode.HALF_UP)));
        td2.appendChild((Component)text);
        GraphColumn[] bList = this.getGraphColumnList();
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        tr2.appendChild((Component)td2);
        td2.setDynamicProperty("rowspan", (Object)bList.length);
        td2.setSclass("pa-label");
        td2.setDynamicProperty("valign", (Object)"top");
        text = new Text(this.m_goal.getXAxisText());
        td2.appendChild((Component)text);
        int k = 0;
        while (k < bList.length) {
            GraphColumn bgc = bList[k];
            if (k > 0) {
                tr2 = new Tr();
                table2.appendChild((Component)tr2);
            }
            td2 = new Td();
            td2.setSclass("pa-tdlabel");
            tr2.appendChild((Component)td2);
            text = new Text(bgc.getLabel());
            td2.appendChild((Component)text);
            td2 = new Td();
            td2.setSclass("pa-tdvalue");
            tr2.appendChild((Component)td2);
            BigDecimal value = BigDecimal.valueOf(bgc.getValue());
            if (bgc.getMQuery(this.m_goal) != null) {
                A a2 = new A();
                a2.setSclass("pa-hrefNode");
                td2.appendChild((Component)a2);
                a2.setId(ZOOM_KEY + k);
                a2.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        Component comp = event.getTarget();
                        String id = comp.getId();
                        if (id.startsWith(WGraph.ZOOM_KEY)) {
                            String ss = id.substring(WGraph.ZOOM_KEY.length());
                            int index = Integer.parseInt(String.valueOf(ss));
                            GraphColumn[] colList = WGraph.this.getGraphColumnList();
                            if (index >= 0 && index < colList.length) {
                                AEnv.zoom(colList[index].getMQuery(WGraph.this.m_goal));
                            }
                        }
                    }
                });
                a2.setDynamicProperty("href", (Object)"javascript:;");
                text = new Text(this.format.format(value.setScale(2, RoundingMode.HALF_UP)));
                a2.appendChild((Component)text);
            } else {
                text = new Text(this.format.format(value.setScale(2, RoundingMode.HALF_UP)));
            }
            ++k;
        }
        tr2 = new Tr();
        table2.appendChild((Component)tr2);
        td2 = new Td();
        td2.setDynamicProperty("colspan", (Object)"3");
        tr2.appendChild((Component)td2);
        text = new Text(this.m_goal.getDescription());
        td2.appendChild((Component)text);
        Br br = new Br();
        td2.appendChild((Component)br);
        text = new Text(this.stripHtml(this.m_goal.getColorSchema().getDescription(), false));
        td2.appendChild((Component)text);
    }

    private String stripHtml(String htmlString, boolean all) {
        if (!Util.isEmpty((String)htmlString, (boolean)true)) {
            htmlString = htmlString.replace("<html>", "").replace("</html>", "").replace("<body>", "").replace("</body>", "").replace("<head>", "").replace("</head>", "");
            if (all) {
                htmlString = htmlString.replace(">", "&gt;").replace("<", "&lt;");
            }
        }
        return htmlString;
    }
}

