/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ProcessInfoDialog;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.idempiere.apps.form.BOMDrop;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Center;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Layout;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

@Form(name="org.compiere.apps.form.VBOMDrop")
public class WBOMDrop
extends ADForm
implements EventListener<Event>,
ValueChangeListener {
    private static final long serialVersionUID = -525234460800183807L;
    private static final String FEATURE_GROUP_KEY_ATTR = "FeatureGroupKey";
    private static final String OPTION_PRODUCT_KEY_ATTR = "OptionProductKey";
    private MProduct m_product;
    private BigDecimal m_qty = Env.ONE;
    private static final CLogger log = CLogger.getCLogger(WBOMDrop.class);
    private ArrayList<org.zkoss.zul.Checkbox> m_selectorList = new ArrayList();
    private ArrayList<Decimalbox> m_qtyList = new ArrayList();
    private ArrayList<Integer> m_productList = new ArrayList();
    private ArrayList<Layout> m_childPanelList = new ArrayList();
    private ArrayList<Layout> m_productPanelList = new ArrayList();
    private HashMap<String, Radiogroup> m_alternativeGroups = new HashMap();
    private Borderlayout borderLayout;
    private Groupbox selectionGroupbox = new Groupbox();
    private Grid selectionPanel = GridFactory.newGridLayout();
    private WSearchEditor fieldProduct;
    private Decimalbox productQty = new Decimalbox();
    private Listbox orderField = new Listbox();
    private Listbox invoiceField = new Listbox();
    private Listbox projectField = new Listbox();
    private Groupbox centerGroupbox = new Groupbox();
    private int indend = 20;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BOMDrop bomDrop = new BOMDrop();
    private HashMap<String, Component> m_parentContainerMap = new HashMap();
    private Map<String, Groupbox> m_featureGroup = new HashMap<String, Groupbox>();
    private List<String> m_selectedOtions = new ArrayList<String>();
    private List<String> m_unselectedOtions = new ArrayList<String>();
    private int maxBomDeep = 0;

    @Override
    protected void initForm() {
        try {
            Env.setContext((Properties)Env.getCtx(), (int)this.getWindowNo(), (String)"IsSOTrx", (String)"");
            this.borderLayout = new Borderlayout();
            this.appendChild((Component)this.borderLayout);
            this.borderLayout.setHeight("100%");
            this.borderLayout.setWidth("100%");
            this.confirmPanel = new ConfirmPanel(true);
            this.borderLayout.appendSouth((Component)this.confirmPanel);
            this.borderLayout.getSouth().setStyle("padding-top: 3px;");
            this.createSelectionPanel(true, true, true);
            Center center = new Center();
            center.setVflex("1");
            center.setAutoscroll(true);
            this.borderLayout.appendChild((Component)center);
            center.appendChild((Component)this.centerGroupbox);
            this.centerGroupbox.setWidth("100%");
            this.centerGroupbox.setHeight("auto");
            this.createMainPanel();
            this.confirmPanel.addActionListener("onClick", this);
            this.setBorder(false);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.selectionPanel != null) {
            this.selectionPanel.getChildren().clear();
        }
        this.selectionPanel = null;
        if (this.m_selectorList != null) {
            this.m_selectorList.clear();
        }
        this.m_selectorList = null;
        if (this.m_productList != null) {
            this.m_productList.clear();
        }
        this.m_productList = null;
        if (this.m_qtyList != null) {
            this.m_qtyList.clear();
        }
        this.m_qtyList = null;
        if (this.m_childPanelList != null) {
            this.m_childPanelList.clear();
        }
        this.m_childPanelList = null;
        if (this.m_productPanelList != null) {
            this.m_productPanelList.clear();
        }
        this.m_productPanelList = null;
        if (this.m_alternativeGroups != null) {
            this.m_alternativeGroups.clear();
        }
        this.m_alternativeGroups = null;
    }

    private void createSelectionPanel(boolean order, boolean invoice, boolean project) throws Exception {
        Caption caption = new Caption(Msg.translate((Properties)Env.getCtx(), (String)"Selection"));
        this.selectionGroupbox.appendChild((Component)caption);
        this.selectionGroupbox.appendChild((Component)this.selectionPanel);
        this.borderLayout.appendNorth((Component)this.selectionGroupbox);
        MLookup productLookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)MColumn.getColumn_ID((String)"M_Product", (String)"M_Product_ID"), (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"M_Product_ID", (int)0, (boolean)false, (String)"M_Product.IsBOM='Y' AND M_Product.IsVerified='Y' AND M_Product.IsActive='Y' ");
        this.fieldProduct = new WSearchEditor("M_Product_ID", true, false, true, (Lookup)productLookup);
        this.fieldProduct.addValueChangeListener(this);
        Rows rows = this.selectionPanel.newRows();
        Row boxProductQty = rows.newRow();
        Label lblProduct = new Label(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        Label lblQty = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        this.productQty.setValue(Env.ONE);
        this.productQty.addEventListener("onChange", (EventListener)this);
        this.fieldProduct.fillHorizontal();
        boxProductQty.appendChild(lblProduct.rightAlign());
        boxProductQty.appendChild((Component)this.fieldProduct.getComponent());
        boxProductQty.appendChild(lblQty.rightAlign());
        boxProductQty.appendChild((Component)this.productQty);
        KeyNamePair[] keyNamePair = null;
        if (order) {
            keyNamePair = this.getOrders();
            this.orderField.setRows(1);
            this.orderField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.orderField, "99%");
            int i = 0;
            while (i < keyNamePair.length) {
                this.orderField.addItem(keyNamePair[i]);
                ++i;
            }
            Label lblOrder = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID"));
            Row boxOrder = rows.newRow();
            this.orderField.addEventListener("onSelect", this);
            boxOrder.appendChild(lblOrder.rightAlign());
            boxOrder.appendChild((Component)this.orderField);
            boxOrder.appendChild((Component)new Space());
            boxOrder.appendChild((Component)new Space());
        }
        if (invoice) {
            this.invoiceField.setRows(1);
            this.invoiceField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceField, "99%");
            keyNamePair = this.getInvoices();
            int i = 0;
            while (i < keyNamePair.length) {
                this.invoiceField.addItem(keyNamePair[i]);
                ++i;
            }
            Label lblInvoice = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
            Row boxInvoices = rows.newRow();
            this.invoiceField.addEventListener("onSelect", this);
            boxInvoices.appendChild(lblInvoice.rightAlign());
            boxInvoices.appendChild((Component)this.invoiceField);
            boxInvoices.appendChild((Component)new Space());
            boxInvoices.appendChild((Component)new Space());
        }
        if (project) {
            this.projectField.setRows(1);
            this.projectField.setMold("select");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.projectField, "99%");
            keyNamePair = this.getProjects();
            int i = 0;
            while (i < keyNamePair.length) {
                this.projectField.addItem(keyNamePair[i]);
                ++i;
            }
            Label lblProject = new Label(Msg.translate((Properties)Env.getCtx(), (String)"C_Project_ID"));
            Row boxProject = rows.newRow();
            this.projectField.addEventListener("onSelect", this);
            boxProject.appendChild(lblProject.rightAlign());
            boxProject.appendChild((Component)this.projectField);
            boxProject.appendChild((Component)new Space());
            boxProject.appendChild((Component)new Space());
        }
        this.confirmPanel.setEnabled("Ok", false);
    }

    private KeyNamePair[] getOrders() {
        return this.bomDrop.getDraftOrders(null);
    }

    private KeyNamePair[] getProjects() {
        return this.bomDrop.getNonServiceProjects(null);
    }

    private KeyNamePair[] getInvoices() {
        return this.bomDrop.getDraftInvoices(null);
    }

    private void createMainPanel() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(": " + String.valueOf(this.m_product));
        }
        this.m_selectorList.clear();
        this.m_productList.clear();
        this.m_qtyList.clear();
        this.m_alternativeGroups.clear();
        this.m_childPanelList.clear();
        this.m_productPanelList.clear();
        this.m_parentContainerMap.clear();
        this.m_featureGroup.clear();
        Caption title = new Caption(Msg.getMsg((Properties)Env.getCtx(), (String)"SelectProduct"));
        this.centerGroupbox.getChildren().clear();
        this.centerGroupbox.appendChild((Component)title);
        if (this.m_product != null && this.m_product.get_ID() > 0) {
            title.setLabel(this.m_product.getName());
            if (this.m_product.getDescription() != null && this.m_product.getDescription().length() > 0) {
                title.setTooltiptext(this.m_product.getDescription());
            }
            this.maxBomDeep = this.bomDrop.getMaxBOMDeep(this.m_product);
            this.bomDrop.addBOMLines(this.m_product, this.m_qty, b -> this.addBOMLine((BOMDrop.BOMLine)b));
            this.updateBOMChildVisibility();
            this.m_parentContainerMap.clear();
        }
    }

    private void addBOMLine(BOMDrop.BOMLine bomLine) {
        MProduct product = bomLine.getProductBOMLine().getProduct();
        MProduct parentProduct = bomLine.getParentProduct();
        Groupbox parentPanel = null;
        if (bomLine.getBOMLevel() == 0) {
            parentPanel = this.centerGroupbox;
        } else {
            String key = parentProduct.get_ID() + "_" + (bomLine.getBOMLevel() - 1);
            parentPanel = this.m_parentContainerMap.get(key);
        }
        Layout productPanel = this.addDisplay(parentProduct.getM_Product_ID(), product.getM_Product_ID(), bomLine.getBOMType(), product.getName(), bomLine.getLineQty(), (Component)parentPanel, bomLine.getBOMLevel(), bomLine.getFeature());
        this.m_productPanelList.add(productPanel);
        if (product.isBOM() && product.isVerified()) {
            Vlayout childPanel = this.createVlayoutPanel("100%");
            this.m_childPanelList.add((Layout)childPanel);
            String key = product.get_ID() + "_" + bomLine.getBOMLevel();
            this.m_parentContainerMap.put(key, (Component)childPanel);
        } else {
            this.m_childPanelList.add(null);
        }
    }

    private Layout addDisplay(int parentM_Product_ID, int M_Product_ID, String bomType, String name, BigDecimal lineQty, Component parentPanel, int bomLevel, String feature) {
        String key;
        boolean isMandatory;
        if (log.isLoggable(Level.FINE)) {
            log.fine("M_Product_ID=" + M_Product_ID + ",Type=" + bomType + ",Name=" + name + ",Qty=" + String.valueOf(lineQty));
        }
        boolean selected = false;
        Hlayout productPanel = this.createHlayoutPanel("100%");
        Vlayout outerProductPanel = new Vlayout();
        outerProductPanel.appendChild((Component)productPanel);
        Div selectPanel = this.createDivPanel(25);
        Checkbox checkbox = null;
        selected = isMandatory = "CO".equals(bomType) || "PH".equals(bomType) || "PK".equals(bomType) || "TL".equals(bomType);
        String optionKey = parentM_Product_ID + "_" + M_Product_ID;
        if (!"VA".equals(bomType)) {
            checkbox = new Checkbox();
            checkbox.setChecked(selected);
            checkbox.setDisabled(isMandatory);
            if (!isMandatory) {
                if (this.m_selectedOtions.contains(optionKey)) {
                    checkbox.setChecked(true);
                } else if (this.m_unselectedOtions.contains(optionKey)) {
                    checkbox.setChecked(false);
                }
                selected = checkbox.isChecked();
            }
        } else {
            checkbox = new Radio();
        }
        checkbox.setAttribute(OPTION_PRODUCT_KEY_ATTR, optionKey);
        selectPanel.appendChild((Component)checkbox);
        this.m_selectorList.add(checkbox);
        productPanel.appendChild((Component)selectPanel);
        if (!checkbox.isDisabled()) {
            checkbox.addEventListener("onCheck", this);
        }
        Div rightInden = this.createDivPanel((this.maxBomDeep - bomLevel) * this.indend);
        productPanel.appendChild((Component)rightInden);
        this.m_productList.add(M_Product_ID);
        Div namePanel = this.createDivPanel(200);
        Label label = new Label(name);
        HtmlBasedComponent c = (HtmlBasedComponent)label.rightAlign();
        c.setStyle(c.getStyle() + ";margin-right: 5px");
        namePanel.appendChild((Component)c);
        productPanel.appendChild((Component)namePanel);
        Div qtyPanel = this.createDivPanel(200);
        Decimalbox qty = new Decimalbox();
        qty.setValue(lineQty);
        qtyPanel.appendChild((Component)qty);
        productPanel.appendChild((Component)qtyPanel);
        this.m_qtyList.add(qty);
        Hlayout outerContainer = this.createHlayoutPanel("100%");
        outerContainer.setStyle("margin-top:3px;");
        outerContainer.setValign("middle");
        parentPanel.appendChild((Component)outerContainer);
        if (!parentPanel.equals(this.centerGroupbox)) {
            Div cellInden = this.createDivPanel(this.indend);
            outerContainer.appendChild((Component)cellInden);
        }
        Groupbox featureGroup = null;
        if (!Util.isEmpty((String)feature, (boolean)true) && (featureGroup = this.m_featureGroup.get(key = bomLevel + "|" + feature)) == null) {
            featureGroup = new Groupbox();
            featureGroup.setAttribute(FEATURE_GROUP_KEY_ATTR, (Object)key);
            featureGroup.appendChild((Component)new Caption(feature));
            this.m_featureGroup.put(key, featureGroup);
        }
        if (!"VA".equals(bomType)) {
            if (featureGroup != null) {
                if (featureGroup.getParent() == null) {
                    outerContainer.appendChild((Component)featureGroup);
                }
                featureGroup.appendChild((Component)outerProductPanel);
            } else {
                outerContainer.appendChild((Component)outerProductPanel);
            }
        } else {
            String groupName = String.valueOf(parentM_Product_ID) + "_" + bomType + "_" + parentPanel.toString();
            if (featureGroup != null) {
                groupName = groupName + "_" + String.valueOf(featureGroup.getAttribute(FEATURE_GROUP_KEY_ATTR));
            }
            Radiogroup radioGroup = this.m_alternativeGroups.get(groupName);
            boolean first = false;
            if (radioGroup == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("RadioGroup=" + groupName);
                }
                radioGroup = new Radiogroup();
                this.m_alternativeGroups.put(groupName, radioGroup);
                first = true;
                if (featureGroup != null) {
                    if (featureGroup.getParent() == null) {
                        outerContainer.appendChild((Component)featureGroup);
                    }
                    featureGroup.appendChild((Component)radioGroup);
                } else {
                    outerContainer.appendChild((Component)radioGroup);
                }
            } else {
                outerProductPanel.setStyle("margin-top:3px;");
            }
            radioGroup.appendChild((Component)outerProductPanel);
            if (this.m_selectedOtions.contains(optionKey)) {
                selected = true;
                checkbox.setChecked(true);
            } else if (this.m_unselectedOtions.contains(optionKey)) {
                selected = false;
                checkbox.setChecked(false);
            } else if (first) {
                selected = true;
                checkbox.setChecked(true);
                this.m_selectedOtions.add(optionKey);
            } else {
                selected = false;
                checkbox.setChecked(false);
                this.m_unselectedOtions.add(optionKey);
            }
        }
        qty.setReadonly(!selected);
        return outerProductPanel;
    }

    private Div createDivPanel(int width) {
        Div divPanel = new Div();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)divPanel, String.format("%1$spx", width));
        divPanel.setStyle("padding-right:0;padding-left:0");
        return divPanel;
    }

    private Hlayout createHlayoutPanel(String width) {
        Hlayout layout = new Hlayout();
        layout.setSpacing("0");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, width);
        return layout;
    }

    private Vlayout createVlayoutPanel(String width) {
        Vlayout layout = new Vlayout();
        layout.setSpacing("0");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, width);
        return layout;
    }

    @Override
    public void onEvent(Event e) throws Exception {
        Component source;
        super.onEvent(e);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(e.getName());
        }
        if ((source = e.getTarget()) instanceof org.zkoss.zul.Checkbox) {
            org.zkoss.zul.Checkbox checkbox = (org.zkoss.zul.Checkbox)source;
            int index = this.m_selectorList.indexOf(checkbox);
            this.m_qtyList.get(index).setReadonly(!checkbox.isChecked());
            if (checkbox instanceof Radio) {
                Radiogroup group = ((Radio)checkbox).getRadiogroup();
                List lsRadio = group.getItems();
                for (Radio radio : lsRadio) {
                    if (checkbox.equals(radio)) continue;
                    radio.setChecked(false);
                    index = this.m_selectorList.indexOf(radio);
                    this.m_qtyList.get(index).setReadonly(true);
                    this.m_selectedOtions.remove(radio.getAttribute(OPTION_PRODUCT_KEY_ATTR));
                    this.m_unselectedOtions.add((String)radio.getAttribute(OPTION_PRODUCT_KEY_ATTR));
                }
            }
            this.updateBOMChildVisibility();
            if (checkbox.isChecked()) {
                this.m_selectedOtions.add((String)checkbox.getAttribute(OPTION_PRODUCT_KEY_ATTR));
                this.m_unselectedOtions.remove(checkbox.getAttribute(OPTION_PRODUCT_KEY_ATTR));
            } else {
                this.m_unselectedOtions.add((String)checkbox.getAttribute(OPTION_PRODUCT_KEY_ATTR));
                this.m_selectedOtions.remove(checkbox.getAttribute(OPTION_PRODUCT_KEY_ATTR));
            }
        } else if (source == this.productQty) {
            this.m_qty = this.productQty.getValue();
            if (this.m_product != null && this.m_product.get_ID() > 0) {
                this.createMainPanel();
            }
        } else if (source == this.orderField) {
            boolean valid;
            ListItem listitem = this.orderField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.invoiceField != null) {
                this.invoiceField.setEnabled(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setEnabled(!valid);
            }
        } else if (source == this.invoiceField) {
            boolean valid;
            ListItem listitem = this.invoiceField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setEnabled(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setEnabled(!valid);
            }
        } else if (source == this.projectField) {
            boolean valid;
            ListItem listitem = this.projectField.getSelectedItem();
            KeyNamePair pp = null;
            if (listitem != null) {
                pp = listitem.toKeyNamePair();
            }
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setEnabled(!valid);
            }
            if (this.invoiceField != null) {
                this.invoiceField.setEnabled(!valid);
            }
        } else if (((Object)((Object)this.confirmPanel.getButton("Ok"))).equals(e.getTarget())) {
            if (this.onSave()) {
                SessionManager.getAppDesktop().closeActiveWindow();
                return;
            }
        } else if (((Object)((Object)this.confirmPanel.getButton("Cancel"))).equals(e.getTarget())) {
            SessionManager.getAppDesktop().closeActiveWindow();
            return;
        }
        this.enableSave();
    }

    private void enableSave() {
        boolean OK;
        boolean bl = OK = this.m_product != null;
        if (OK) {
            ListItem listitem;
            KeyNamePair pp = null;
            if (this.orderField != null && (listitem = this.orderField.getSelectedItem()) != null) {
                pp = listitem.toKeyNamePair();
            }
            if ((pp == null || pp.getKey() <= 0) && this.invoiceField != null && (listitem = this.invoiceField.getSelectedItem()) != null) {
                pp = listitem.toKeyNamePair();
            }
            if ((pp == null || pp.getKey() <= 0) && this.projectField != null && (listitem = this.projectField.getSelectedItem()) != null) {
                pp = listitem.toKeyNamePair();
            }
            OK = pp != null && pp.getKey() > 0;
        }
        this.confirmPanel.setEnabled("Ok", OK);
    }

    private void onProductChanged(Object productFieldValue) {
        int id;
        int n = id = productFieldValue != null && productFieldValue instanceof Integer ? (Integer)productFieldValue : 0;
        if (this.m_product == null || this.m_product.get_ID() != id) {
            this.m_product = id > 0 ? MProduct.get((Properties)Env.getCtx(), (int)id) : null;
        }
        this.createMainPanel();
        this.enableSave();
    }

    protected void updateBOMChildVisibility() {
        int index = 0;
        for (org.zkoss.zul.Checkbox checkbox : this.m_selectorList) {
            index = this.m_selectorList.indexOf(checkbox);
            Layout childPanel = this.m_childPanelList.get(index);
            Layout productPanel = this.m_productPanelList.get(index);
            if (childPanel != null && checkbox.isChecked() && !productPanel.getChildren().contains(childPanel)) {
                productPanel.appendChild((Component)childPanel);
                continue;
            }
            if (childPanel == null || checkbox.isChecked() || !productPanel.getChildren().contains(childPanel)) continue;
            childPanel.detach();
        }
    }

    private boolean onSave() {
        String trxName = Trx.createTrxName((String)"BDP");
        localTrx.setDisplayName(this.getClass().getName() + "_onSave");
        try (Trx localTrx = Trx.get((String)trxName, (boolean)true);){
            if (this.cmd_save(localTrx)) {
                localTrx.commit();
                return true;
            }
            localTrx.rollback();
            return false;
        }
    }

    private boolean cmd_save(Trx trx) {
        ListItem listitem = this.orderField.getSelectedItem();
        KeyNamePair pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveOrder(pp.getKey(), trx);
        }
        listitem = this.invoiceField.getSelectedItem();
        pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveInvoice(pp.getKey(), trx);
        }
        listitem = this.projectField.getSelectedItem();
        pp = null;
        if (listitem != null) {
            pp = listitem.toKeyNamePair();
        }
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveProject(pp.getKey(), trx);
        }
        log.log(Level.SEVERE, "Nothing selected");
        return false;
    }

    private boolean cmd_saveOrder(int C_Order_ID, Trx trx) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Order_ID=" + C_Order_ID);
        }
        ArrayList<BOMDrop.SelectedItem> selectedItems = new ArrayList<BOMDrop.SelectedItem>();
        try {
            int i = 0;
            while (i < this.m_selectorList.size()) {
                if (this.m_selectorList.get(i).getPage() != null && this.m_selectorList.get(i).isChecked()) {
                    BigDecimal qty = this.m_qtyList.get(i).getValue();
                    int M_Product_ID = this.m_productList.get(i);
                    MProduct product = MProduct.get((int)M_Product_ID);
                    if (!product.isBOM() || !product.isVerified()) {
                        selectedItems.add(new BOMDrop.SelectedItem(M_Product_ID, qty));
                    }
                }
                ++i;
            }
            MOrder order = this.bomDrop.saveOrderLines(C_Order_ID, selectedItems, trx.getTrxName());
            String summary = Msg.translate((Properties)Env.getCtx(), (String)"C_Order_ID") + " : " + order.getDocumentInfo() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + selectedItems.size();
            ProcessInfo pi = new ProcessInfo(this.getFormName(), 0);
            pi.addLog(0, 0, null, null, summary, 259, order.getC_Order_ID());
            ProcessInfoDialog dialog = new ProcessInfoDialog(pi, false);
            dialog.setAutoCloseAfterZoom(true);
            dialog.setPage(this.getPage());
            dialog.doHighlighted();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            if (trx != null) {
                trx.rollback();
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new AdempiereException(e.getMessage());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + selectedItems.size());
        }
        return true;
    }

    private boolean cmd_saveInvoice(int C_Invoice_ID, Trx trx) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Invoice_ID=" + C_Invoice_ID);
        }
        ArrayList<BOMDrop.SelectedItem> selectedItems = new ArrayList<BOMDrop.SelectedItem>();
        try {
            int i = 0;
            while (i < this.m_selectorList.size()) {
                if (this.m_selectorList.get(i).getPage() != null && this.m_selectorList.get(i).isChecked()) {
                    BigDecimal qty = this.m_qtyList.get(i).getValue();
                    int M_Product_ID = this.m_productList.get(i);
                    MProduct product = MProduct.get((int)M_Product_ID);
                    if (!product.isBOM() || !product.isVerified()) {
                        selectedItems.add(new BOMDrop.SelectedItem(M_Product_ID, qty));
                    }
                }
                ++i;
            }
            MInvoice invoice = this.bomDrop.saveInvoiceLines(C_Invoice_ID, selectedItems, trx.getTrxName());
            String summary = Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID") + " : " + invoice.getDocumentInfo() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + selectedItems.size();
            ProcessInfo pi = new ProcessInfo(this.getFormName(), 0);
            pi.addLog(0, 0, null, null, summary, 318, invoice.getC_Invoice_ID());
            ProcessInfoDialog dialog = new ProcessInfoDialog(pi, false);
            dialog.setAutoCloseAfterZoom(true);
            dialog.setPage(this.getPage());
            dialog.doHighlighted();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Line not saved");
            if (trx != null) {
                trx.rollback();
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new AdempiereException(e.getMessage());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + selectedItems.size());
        }
        return true;
    }

    private boolean cmd_saveProject(int C_Project_ID, Trx trx) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_Project_ID=" + C_Project_ID);
        }
        ArrayList<BOMDrop.SelectedItem> selectedItems = new ArrayList<BOMDrop.SelectedItem>();
        try {
            int i = 0;
            while (i < this.m_selectorList.size()) {
                if (this.m_selectorList.get(i).getPage() != null && this.m_selectorList.get(i).isChecked()) {
                    BigDecimal qty = this.m_qtyList.get(i).getValue();
                    int M_Product_ID = this.m_productList.get(i);
                    MProduct product = MProduct.get((int)M_Product_ID);
                    if (!product.isBOM() || !product.isVerified()) {
                        selectedItems.add(new BOMDrop.SelectedItem(M_Product_ID, qty));
                    }
                }
                ++i;
            }
            MProject project = this.bomDrop.saveProjectLines(C_Project_ID, selectedItems, trx.getTrxName());
            String summary = Msg.translate((Properties)Env.getCtx(), (String)"C_Project_ID") + " : " + project.getName() + " , " + Msg.translate((Properties)Env.getCtx(), (String)"NoOfLines") + " " + Msg.translate((Properties)Env.getCtx(), (String)"Inserted") + " = " + selectedItems.size();
            ProcessInfo pi = new ProcessInfo(this.getFormName(), 0);
            pi.addLog(0, 0, null, null, summary, 203, project.getC_Project_ID());
            ProcessInfoDialog dialog = new ProcessInfoDialog(pi, false);
            dialog.setAutoCloseAfterZoom(true);
            dialog.setPage(this.getPage());
            dialog.doHighlighted();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Line not saved");
            if (trx != null) {
                trx.rollback();
            }
            throw e instanceof RuntimeException ? (RuntimeException)e : new AdempiereException(e.getMessage());
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + selectedItems.size());
        }
        return true;
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        this.m_selectedOtions.clear();
        this.m_unselectedOtions.clear();
        this.onProductChanged(evt.getNewValue());
    }
}

