-- IDEMPIERE-3862 ORACLE - Update datatype NVARCHAR2 to VARCHAR2

-- Script to change the core tables and columns

-- Dropping functional based indexes and indexes unique where one of the columns to be modified is part
DROP INDEX AD_COLUMN_FKCONSTRAINTNAME;
DROP INDEX AD_COLUMN_NAME;
DROP INDEX AD_ELEMENT_UPPERCOLUMNNAME;
DROP INDEX AD_IMPFORMAT_NAME;
DROP INDEX AD_INFOWINDOW_UNIQUE_NAME;
DROP INDEX AD_ORG_VALUE;
ALTER TABLE AD_PACKAGE_UUID_MAP DROP CONSTRAINT AD_PACKAGE_UUID_MAP_CTST_IDX;
DROP INDEX AD_PREFERENCE_ATTRIBUTE;
DROP INDEX AD_PRINTCOLOR_NAME;
DROP INDEX AD_PRINTFONT_NAME;
DROP INDEX AD_PRINTFORMAT_NAME;
DROP INDEX AD_PRINTPAPER_NAME;
DROP INDEX AD_REF_LIST_NAME;
DROP INDEX AD_REF_LIST_VALUE;
ALTER TABLE AD_REPLICATIONSTRATEGY DROP CONSTRAINT AD_REPLICATIONSTRATEGY_VALUE;
ALTER TABLE AD_SEQUENCE_AUDIT DROP CONSTRAINT AD_SEQUENCE_AUDIT_KEY;
DROP INDEX AD_SYSCONFIG_ORG_NAME;
DROP INDEX AD_TABLE_NAME;
DROP INDEX AD_TABLEINDEX_NAME;
DROP INDEX AD_TASK_NAME;
DROP INDEX AD_TREE_NAME;
DROP INDEX AD_WINDOW_NAME;
DROP INDEX AD_WORKFLOW_NAME;
DROP INDEX ASP_CLIENTEXCEPTION_UNQ;
DROP INDEX CM_CSTAGE_ELEMENT_NAME;
DROP INDEX C_ACCTSCHEMA_NAME;
DROP INDEX C_ACTIVITY_VALUE;
DROP INDEX C_BPARTNER_VALUE;
DROP INDEX C_BP_GROUP_VALUE;
DROP INDEX C_CALENDAR_NAME;
DROP INDEX C_CAMPAIGN_VALUE;
DROP INDEX C_CHANNEL_NAME;
DROP INDEX C_CHARGE_NAME;
DROP INDEX C_CYCLE_NAME;
DROP INDEX C_DOCTYPE_NAME;
DROP INDEX C_ELEMENT_NAME;
DROP INDEX C_ELEMENTVALUE_VALUE;
DROP INDEX C_INVOICE_DOCUMENTNO;
DROP INDEX C_INVOICE_DOCUMENTNO_TARGET;
DROP INDEX C_ORDER_DOCUMENTNO;
DROP INDEX CORDERSOURCE_VALUE;
DROP INDEX C_PAYMENTTERM_NAME;
DROP INDEX C_PROJECT_VALUE;
DROP INDEX C_REGION_NAME;
DROP INDEX C_SALESREGION_VALUE;
DROP INDEX C_TAX_NAME;
DROP INDEX C_TAXCATEGORY_NAME;
DROP INDEX C_UOM_NAME;
DROP INDEX C_UOM_CONVERSION_PRODUCT;
DROP INDEX FACT_ACCT_TRUNC_DATEACCT;
DROP INDEX GL_BUDGET_NAME;
DROP INDEX GL_CATEGORY_NAME;
DROP INDEX GL_JOURNAL_DOCNO;
DROP INDEX GL_JOURNALBATCH_DOCNO;
DROP INDEX HR_CONTRACT_VALUE;
DROP INDEX HR_DEPARTMENT_VALUE;
DROP INDEX HR_JOB_VALUE;
DROP INDEX M_EDI_TRX;
ALTER TABLE M_FREIGHTCATEGORY DROP CONSTRAINT M_FREIGHTCAT_VALUE;
DROP INDEX M_FREIGHTCAT_VALUE;
DROP INDEX M_LOCATION_WHERE;
DROP INDEX M_PRICELIST_NAME;
DROP INDEX M_PRODUCT_VALUE;
DROP INDEX M_PRODUCTPRICEVENDORBREAK_UNQ;
DROP INDEX M_PRODUCT_CATEGORY_VALUE;
DROP INDEX M_PRODUCT_PO_VENDORPRODNO;
ALTER TABLE M_SHIPPERCFG DROP CONSTRAINT X_SHIPPER_UNIQUE_COLUMNS;
ALTER TABLE M_SHIPPERLABELSCFG DROP CONSTRAINT X_SHIPPERLABELS_UNIQUE_COLUMNS;
ALTER TABLE M_SHIPPERPACKAGINGCFG DROP CONSTRAINT X_SHIPPERPACK_UNIQUE_COLUMNS;
ALTER TABLE M_SHIPPERPICKUPTYPESCFG DROP CONSTRAINT X_SHIPPERPICKT_UNIQUE_COLUMNS;
ALTER TABLE M_SHIPPINGPROCESSORCFG DROP CONSTRAINT X_SHIPPINGPROC_UNIQUE_COLUMNS;
DROP INDEX M_WAREHOUSE_NAME;
DROP INDEX PPPRODUCTBOMUNIQUE;
DROP INDEX R_KNOWNISSUE_ALT;
DROP INDEX R_ISSUEUSER_EMAIL;
ALTER TABLE U_POSTERMINAL DROP CONSTRAINT U_POSTERMINAL_VALUE;
DROP INDEX WS_WEBSERVICETYPE_VALUE_IDX;
DROP INDEX W_CLICKCOUNT_TARGETURL;
DROP INDEX W_COUNTERCOUNT_PAGEURL;

-- Converting all VARCHAR2...BYTE to VARCHAR2..CHAR

-- Processing table AD_BROADCASTMESSAGE_TRL
ALTER TABLE AD_BROADCASTMESSAGE_TRL MODIFY (AD_BROADCASTMESSAGE_TRL_UU VARCHAR2(36 CHAR),AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_CHART
ALTER TABLE AD_CHART MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_CHARTDATASOURCE
ALTER TABLE AD_CHARTDATASOURCE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_CHART_TRL
ALTER TABLE AD_CHART_TRL MODIFY (AD_CHART_TRL_UU VARCHAR2(36 CHAR),AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_CLIENT
ALTER TABLE AD_CLIENT MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_COLOR_TRL
ALTER TABLE AD_COLOR_TRL MODIFY (AD_COLOR_TRL_UU VARCHAR2(36 CHAR),AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_COLUMN
ALTER TABLE AD_COLUMN MODIFY (COLUMNSQL VARCHAR2(4000 CHAR),ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_COLUMN_TRL
ALTER TABLE AD_COLUMN_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_CTXHELPMSG_TRL
ALTER TABLE AD_CTXHELPMSG_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_CTXHELPSUGGESTION
ALTER TABLE AD_CTXHELPSUGGESTION MODIFY (AD_CTXHELPSUGGESTION_UU VARCHAR2(36 CHAR),AD_LANGUAGE VARCHAR2(6 CHAR),MSGTEXT VARCHAR2(2000 CHAR));

-- Processing table AD_DESKTOP_TRL
ALTER TABLE AD_DESKTOP_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_ELEMENT
ALTER TABLE AD_ELEMENT MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_ELEMENT_TRL
ALTER TABLE AD_ELEMENT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_ENTITYTYPE
ALTER TABLE AD_ENTITYTYPE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_ERROR
ALTER TABLE AD_ERROR MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_FIELD
ALTER TABLE AD_FIELD MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_FIELDGROUP
ALTER TABLE AD_FIELDGROUP MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_FIELDGROUP_TRL
ALTER TABLE AD_FIELDGROUP_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_FIELDSUGGESTION
ALTER TABLE AD_FIELDSUGGESTION MODIFY (AD_FIELDSUGGESTION_UU VARCHAR2(36 CHAR),AD_LANGUAGE VARCHAR2(6 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table AD_FIELD_TRL
ALTER TABLE AD_FIELD_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_FORM
ALTER TABLE AD_FORM MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_FORM_TRL
ALTER TABLE AD_FORM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_HOUSEKEEPING
ALTER TABLE AD_HOUSEKEEPING MODIFY (TABLENAME VARCHAR2(40 CHAR));

-- Processing table AD_IMAGE
ALTER TABLE AD_IMAGE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_IMPORTTEMPLATE
ALTER TABLE AD_IMPORTTEMPLATE MODIFY (AD_IMPORTTEMPLATE_UU VARCHAR2(36 CHAR),CHARACTERSET VARCHAR2(20 CHAR),CSVALIASHEADER VARCHAR2(2000 CHAR),CSVHEADER VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table AD_IMPORTTEMPLATEACCESS
ALTER TABLE AD_IMPORTTEMPLATEACCESS MODIFY (AD_IMPORTTEMPLATEACCESS_UU VARCHAR2(36 CHAR));

-- Processing table AD_INDEXCOLUMN
ALTER TABLE AD_INDEXCOLUMN MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_INFOCOLUMN
ALTER TABLE AD_INFOCOLUMN MODIFY (DEFAULTVALUE VARCHAR2(2000 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),INPUTFIELDVALIDATION VARCHAR2(2000 CHAR));

-- Processing table AD_INFOCOLUMN_TRL
ALTER TABLE AD_INFOCOLUMN_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_INFOPROCESS
ALTER TABLE AD_INFOPROCESS MODIFY (AD_INFOPROCESS_UU VARCHAR2(36 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),IMAGEURL VARCHAR2(120 CHAR),LAYOUTTYPE VARCHAR2(10 CHAR));

-- Processing table AD_INFORELATED
ALTER TABLE AD_INFORELATED MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_INFOWINDOW
ALTER TABLE AD_INFOWINDOW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_INFOWINDOW_TRL
ALTER TABLE AD_INFOWINDOW_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_LANGUAGE
ALTER TABLE AD_LANGUAGE MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_MENU
ALTER TABLE AD_MENU MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_MENU_TRL
ALTER TABLE AD_MENU_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_MESSAGE
ALTER TABLE AD_MESSAGE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_MESSAGE_TRL
ALTER TABLE AD_MESSAGE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_MIGRATIONSCRIPT
ALTER TABLE AD_MIGRATIONSCRIPT MODIFY (DESCRIPTION VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PROJECTNAME VARCHAR2(60 CHAR),REFERENCE VARCHAR2(2000 CHAR),URL VARCHAR2(2000 CHAR));

-- Processing table AD_MODELVALIDATOR
ALTER TABLE AD_MODELVALIDATOR MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_MODIFICATION
ALTER TABLE AD_MODIFICATION MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_ORGINFO
ALTER TABLE AD_ORGINFO MODIFY (RECEIPTFOOTERMSG VARCHAR2(1023 CHAR),TAXID VARCHAR2(20 CHAR));

-- Processing table AD_PACKAGE_EXP_DETAIL
ALTER TABLE AD_PACKAGE_EXP_DETAIL MODIFY (SQLSTATEMENT VARCHAR2(4000 CHAR));

-- Processing table AD_PASSWORD_HISTORY
ALTER TABLE AD_PASSWORD_HISTORY MODIFY (AD_PASSWORD_HISTORY_UU VARCHAR2(36 CHAR),PASSWORD VARCHAR2(1024 CHAR),SALT VARCHAR2(16 CHAR));

-- Processing table AD_PINSTANCE
ALTER TABLE AD_PINSTANCE MODIFY (NOTIFICATIONTYPE VARCHAR2(2 CHAR),REPORTTYPE VARCHAR2(5 CHAR));

-- Processing table AD_PINSTANCE_PARA
ALTER TABLE AD_PINSTANCE_PARA MODIFY (INFO VARCHAR2(4000 CHAR),INFO_TO VARCHAR2(4000 CHAR),P_STRING VARCHAR2(4000 CHAR),P_STRING_TO VARCHAR2(4000 CHAR));

-- Processing table AD_POSTIT
ALTER TABLE AD_POSTIT MODIFY (AD_POSTIT_UU VARCHAR2(36 CHAR),TEXT VARCHAR2(2000 CHAR));

-- Processing table AD_PRINTCOLOR_TRL
ALTER TABLE AD_PRINTCOLOR_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),AD_PRINTCOLOR_TRL_UU VARCHAR2(36 CHAR));

-- Processing table AD_PRINTFORMAT
ALTER TABLE AD_PRINTFORMAT MODIFY (ARGS VARCHAR2(480 CHAR),CLASSNAME VARCHAR2(240 CHAR));

-- Processing table AD_PRINTFORMATITEM
ALTER TABLE AD_PRINTFORMATITEM MODIFY (DISPLAYLOGIC VARCHAR2(2000 CHAR));

-- Processing table AD_PRINTFORMATITEM_TRL
ALTER TABLE AD_PRINTFORMATITEM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_PRINTFORMAT_TRL
ALTER TABLE AD_PRINTFORMAT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),AD_PRINTFORMAT_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table AD_PRINTLABELLINE_TRL
ALTER TABLE AD_PRINTLABELLINE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_PROCESS
ALTER TABLE AD_PROCESS MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_PROCESS_PARA
ALTER TABLE AD_PROCESS_PARA MODIFY (ENTITYTYPE VARCHAR2(40 CHAR),MANDATORYLOGIC VARCHAR2(2000 CHAR));

-- Processing table AD_PROCESS_PARA_TRL
ALTER TABLE AD_PROCESS_PARA_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_PROCESS_TRL
ALTER TABLE AD_PROCESS_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_REFERENCE
ALTER TABLE AD_REFERENCE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REFERENCE_TRL
ALTER TABLE AD_REFERENCE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_REF_LIST
ALTER TABLE AD_REF_LIST MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REF_LIST_TRL
ALTER TABLE AD_REF_LIST_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_REF_TABLE
ALTER TABLE AD_REF_TABLE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REPLICATIONSTRATEGY
ALTER TABLE AD_REPLICATIONSTRATEGY MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REPLICATIONTABLE
ALTER TABLE AD_REPLICATIONTABLE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REPORTVIEW
ALTER TABLE AD_REPORTVIEW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_REPORTVIEW_COLUMN
ALTER TABLE AD_REPORTVIEW_COLUMN MODIFY (AD_REPORTVIEW_COLUMN_UU VARCHAR2(36 CHAR));

-- Processing table AD_ROLE
ALTER TABLE AD_ROLE MODIFY (ROLETYPE VARCHAR2(2 CHAR));

-- Processing table AD_RULE
ALTER TABLE AD_RULE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_SCHEDULER
ALTER TABLE AD_SCHEDULER MODIFY (REPORTOUTPUTTYPE VARCHAR2(4 CHAR));

-- Processing table AD_SEARCHDEFINITION
ALTER TABLE AD_SEARCHDEFINITION MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_SEQUENCE
ALTER TABLE AD_SEQUENCE MODIFY (NAME VARCHAR2(60 CHAR));

-- Processing table AD_SEQUENCE_NO
ALTER TABLE AD_SEQUENCE_NO MODIFY (CALENDARYEARMONTH VARCHAR2(6 CHAR));

-- Processing table AD_SESSION
ALTER TABLE AD_SESSION MODIFY (WEBSESSION VARCHAR2(40 CHAR));

-- Processing table AD_STATUSLINE
ALTER TABLE AD_STATUSLINE MODIFY (AD_STATUSLINE_UU VARCHAR2(36 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR),SQLSTATEMENT VARCHAR2(2000 CHAR));

-- Processing table AD_STATUSLINEUSEDIN
ALTER TABLE AD_STATUSLINEUSEDIN MODIFY (AD_STATUSLINEUSEDIN_UU VARCHAR2(36 CHAR));

-- Processing table AD_STYLE
ALTER TABLE AD_STYLE MODIFY (AD_STYLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table AD_STYLELINE
ALTER TABLE AD_STYLELINE MODIFY (AD_STYLELINE_UU VARCHAR2(36 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),INLINESTYLE VARCHAR2(2000 CHAR),THEME VARCHAR2(60 CHAR));

-- Processing table AD_SYSCONFIG
ALTER TABLE AD_SYSCONFIG MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_TAB
ALTER TABLE AD_TAB MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_TABLE
ALTER TABLE AD_TABLE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR),TABLENAME VARCHAR2(40 CHAR));

-- Processing table AD_TABLEINDEX
ALTER TABLE AD_TABLEINDEX MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_TABLE_SCRIPTVALIDATOR
ALTER TABLE AD_TABLE_SCRIPTVALIDATOR MODIFY (EVENTMODELVALIDATOR VARCHAR2(4 CHAR));

-- Processing table AD_TABLE_TRL
ALTER TABLE AD_TABLE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_TAB_TRL
ALTER TABLE AD_TAB_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_TASK
ALTER TABLE AD_TASK MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_TASK_TRL
ALTER TABLE AD_TASK_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_TOOLBARBUTTON
ALTER TABLE AD_TOOLBARBUTTON MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_USERDEF_PROC
ALTER TABLE AD_USERDEF_PROC MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),AD_USERDEF_PROC_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table AD_USERDEF_PROC_PARAMETER
ALTER TABLE AD_USERDEF_PROC_PARAMETER MODIFY (AD_USERDEF_PROC_PARAMETER_UU VARCHAR2(36 CHAR),DEFAULTVALUE VARCHAR2(2000 CHAR),DEFAULTVALUE2 VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),MANDATORYLOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),PLACEHOLDER2 VARCHAR2(255 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),VALUEMAX VARCHAR2(20 CHAR),VALUEMIN VARCHAR2(20 CHAR),VFORMAT VARCHAR2(40 CHAR));

-- Processing table AD_USERDEF_WIN
ALTER TABLE AD_USERDEF_WIN MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_USERMAIL
ALTER TABLE AD_USERMAIL MODIFY (DELIVERYCONFIRMATION VARCHAR2(120 CHAR),EMAILFROM VARCHAR2(255 CHAR),MESSAGEID VARCHAR2(120 CHAR),RECIPIENTBCC VARCHAR2(2000 CHAR),RECIPIENTCC VARCHAR2(2000 CHAR),RECIPIENTTO VARCHAR2(2000 CHAR));

-- Processing table AD_USERPREFERENCE
ALTER TABLE AD_USERPREFERENCE MODIFY (AD_USERPREFERENCE_UU VARCHAR2(36 CHAR),MIGRATIONSCRIPTCOMMENT VARCHAR2(255 CHAR));

-- Processing table AD_VAL_RULE
ALTER TABLE AD_VAL_RULE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_VIEWCOLUMN
ALTER TABLE AD_VIEWCOLUMN MODIFY (COLUMNSQL VARCHAR2(2000 CHAR),ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_VIEWCOMPONENT
ALTER TABLE AD_VIEWCOMPONENT MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WF_ACTIVITYAPPROVER
ALTER TABLE AD_WF_ACTIVITYAPPROVER MODIFY (AD_WF_ACTIVITYAPPROVER_UU VARCHAR2(36 CHAR));

-- Processing table AD_WF_NEXTCONDITION
ALTER TABLE AD_WF_NEXTCONDITION MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WF_NODE
ALTER TABLE AD_WF_NODE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WF_NODENEXT
ALTER TABLE AD_WF_NODENEXT MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WF_NODE_PARA
ALTER TABLE AD_WF_NODE_PARA MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WF_NODE_TRL
ALTER TABLE AD_WF_NODE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_WF_RESPONSIBLE
ALTER TABLE AD_WF_RESPONSIBLE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WINDOW
ALTER TABLE AD_WINDOW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WINDOW_TRL
ALTER TABLE AD_WINDOW_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_WORKBENCH
ALTER TABLE AD_WORKBENCH MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WORKBENCHWINDOW
ALTER TABLE AD_WORKBENCHWINDOW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WORKBENCH_TRL
ALTER TABLE AD_WORKBENCH_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_WORKFLOW
ALTER TABLE AD_WORKFLOW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table AD_WORKFLOW_TRL
ALTER TABLE AD_WORKFLOW_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table AD_ZOOMCONDITION
ALTER TABLE AD_ZOOMCONDITION MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table A_ASSET_ACCT
ALTER TABLE A_ASSET_ACCT MODIFY (A_DEPRECIATION_MANUAL_PERIOD VARCHAR2(2 CHAR),A_DISPOSAL_GAIN VARCHAR2(10 CHAR),A_DISPOSAL_LOSS VARCHAR2(40 CHAR),A_DISPOSAL_REVENUE VARCHAR2(40 CHAR),A_REVAL_ACCUMDEP_OFFSET_CUR VARCHAR2(22 CHAR),A_REVAL_ACCUMDEP_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_CAL_METHOD VARCHAR2(3 CHAR),A_REVAL_COST_OFFSET VARCHAR2(22 CHAR),A_REVAL_COST_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_DEPEXP_OFFSET VARCHAR2(22 CHAR));

-- Processing table A_ASSET_CHANGE
ALTER TABLE A_ASSET_CHANGE MODIFY (A_ASSET_SPREAD_TYPE VARCHAR2(10 CHAR),A_DEPRECIATION_CALC_TYPE VARCHAR2(10 CHAR),A_DISPOSAL_LOSS VARCHAR2(22 CHAR),A_DISPOSAL_REVENUE VARCHAR2(22 CHAR),CONVENTIONTYPE VARCHAR2(10 CHAR),DEPRECIATIONTYPE VARCHAR2(10 CHAR));

-- Processing table A_ASSET_DELIVERY
ALTER TABLE A_ASSET_DELIVERY MODIFY (DELIVERYCONFIRMATION VARCHAR2(120 CHAR),MESSAGEID VARCHAR2(120 CHAR));

-- Processing table A_ASSET_GROUP_ACCT
ALTER TABLE A_ASSET_GROUP_ACCT MODIFY (A_ASSET_SPREAD_TYPE VARCHAR2(10 CHAR),A_DEPRECIATION_CALC_TYPE VARCHAR2(10 CHAR),A_DEPRECIATION_MANUAL_PERIOD VARCHAR2(2 CHAR),A_DISPOSAL_GAIN VARCHAR2(10 CHAR),A_DISPOSAL_LOSS VARCHAR2(22 CHAR),A_DISPOSAL_REVENUE VARCHAR2(22 CHAR),A_REVAL_ACCUMDEP_OFFSET_CUR VARCHAR2(22 CHAR),A_REVAL_ACCUMDEP_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_COST_OFFSET VARCHAR2(22 CHAR),A_REVAL_COST_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_DEPEXP_OFFSET VARCHAR2(22 CHAR),CONVENTIONTYPE VARCHAR2(10 CHAR),DEPRECIATIONTYPE VARCHAR2(10 CHAR));

-- Processing table A_ASSET_GROUP_TRL
ALTER TABLE A_ASSET_GROUP_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),A_ASSET_GROUP_TRL_UU VARCHAR2(36 CHAR));

-- Processing table A_ASSET_TRANSFER
ALTER TABLE A_ASSET_TRANSFER MODIFY (A_ACCUMDEPRECIATION_ACCT_NEW VARCHAR2(22 CHAR),A_ASSET_ACCT_NEW VARCHAR2(22 CHAR),A_DEPRECIATION_ACCT_NEW VARCHAR2(22 CHAR),A_DISPOSAL_LOSS_NEW VARCHAR2(22 CHAR),A_DISPOSAL_REVENUE_NEW VARCHAR2(22 CHAR));

-- Processing table CM_BROADCASTSERVER
ALTER TABLE CM_BROADCASTSERVER MODIFY (IP_ADDRESS VARCHAR2(20 CHAR));

-- Processing table CM_CONTAINER_ELEMENT_TRL
ALTER TABLE CM_CONTAINER_ELEMENT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table CM_CONTAINER_TRL
ALTER TABLE CM_CONTAINER_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table CM_CSTAGE_ELEMENT_TRL
ALTER TABLE CM_CSTAGE_ELEMENT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table CM_CSTAGE_TRL
ALTER TABLE CM_CSTAGE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table CM_MEDIA_SERVER
ALTER TABLE CM_MEDIA_SERVER MODIFY (FOLDER VARCHAR2(60 CHAR),IP_ADDRESS VARCHAR2(20 CHAR),PASSWORD VARCHAR2(40 CHAR),USERNAME VARCHAR2(40 CHAR));

-- Processing table CM_NEWSCHANNEL
ALTER TABLE CM_NEWSCHANNEL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table CM_WEBACCESSLOG
ALTER TABLE CM_WEBACCESSLOG MODIFY (IP_ADDRESS VARCHAR2(20 CHAR));

-- Processing table CREATE$JAVA$LOB$TABLE
ALTER TABLE CREATE$JAVA$LOB$TABLE MODIFY (NAME VARCHAR2(700 CHAR));

-- Processing table C_ACTIVITY_TRL
ALTER TABLE C_ACTIVITY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_ACTIVITY_TRL_UU VARCHAR2(36 CHAR));

-- Processing table C_ADDRESSTRANSACTION
ALTER TABLE C_ADDRESSTRANSACTION MODIFY (ADDRESS5 VARCHAR2(60 CHAR),COMMENTS VARCHAR2(2000 CHAR));

-- Processing table C_BPARTNER
ALTER TABLE C_BPARTNER MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),TAXID VARCHAR2(20 CHAR));

-- Processing table C_BP_BANKACCOUNT
ALTER TABLE C_BP_BANKACCOUNT MODIFY (CREDITCARDVV VARCHAR2(4 CHAR),IBAN VARCHAR2(40 CHAR));

-- Processing table C_CAMPAIGN_TRL
ALTER TABLE C_CAMPAIGN_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_CAMPAIGN_TRL_UU VARCHAR2(36 CHAR));

-- Processing table C_CHARGE_TRL
ALTER TABLE C_CHARGE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_CITY
ALTER TABLE C_CITY MODIFY (AREACODE VARCHAR2(10 CHAR),COORDINATES VARCHAR2(15 CHAR),LOCODE VARCHAR2(10 CHAR),POSTAL VARCHAR2(10 CHAR));

-- Processing table C_COUNTRY
ALTER TABLE C_COUNTRY MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),LOOKUPCLASSNAME VARCHAR2(255 CHAR),LOOKUPCLIENTID VARCHAR2(50 CHAR),LOOKUPPASSWORD VARCHAR2(50 CHAR),LOOKUPURL VARCHAR2(100 CHAR));

-- Processing table C_COUNTRYGROUP
ALTER TABLE C_COUNTRYGROUP MODIFY (C_COUNTRYGROUP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));

-- Processing table C_COUNTRYGROUPCOUNTRY
ALTER TABLE C_COUNTRYGROUPCOUNTRY MODIFY (C_COUNTRYGROUPCOUNTRY_UU VARCHAR2(36 CHAR));

-- Processing table C_COUNTRYGROUP_TRL
ALTER TABLE C_COUNTRYGROUP_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_COUNTRYGROUP_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table C_COUNTRY_TRL
ALTER TABLE C_COUNTRY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_CURRENCY_TRL
ALTER TABLE C_CURRENCY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_DOCTYPE_TRL
ALTER TABLE C_DOCTYPE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_DUNNINGLEVEL_TRL
ALTER TABLE C_DUNNINGLEVEL_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_ELEMENTVALUE_TRL
ALTER TABLE C_ELEMENTVALUE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_GREETING_TRL
ALTER TABLE C_GREETING_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_LOCATION
ALTER TABLE C_LOCATION MODIFY (ADDRESS5 VARCHAR2(60 CHAR),COMMENTS VARCHAR2(2000 CHAR),POSTAL VARCHAR2(10 CHAR),POSTAL_ADD VARCHAR2(10 CHAR));

-- Processing table C_PAYMENT
ALTER TABLE C_PAYMENT MODIFY (CREDITCARDVV VARCHAR2(4 CHAR),IBAN VARCHAR2(40 CHAR),SWIFTCODE VARCHAR2(20 CHAR),SWIPE VARCHAR2(80 CHAR));

-- Processing table C_PAYMENTTERM_TRL
ALTER TABLE C_PAYMENTTERM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_PAYMENTTRANSACTION
ALTER TABLE C_PAYMENTTRANSACTION MODIFY (IBAN VARCHAR2(40 CHAR),SWIFTCODE VARCHAR2(20 CHAR));

-- Processing table C_POSPAYMENT
ALTER TABLE C_POSPAYMENT MODIFY (IBAN VARCHAR2(40 CHAR),SWIFTCODE VARCHAR2(20 CHAR));

-- Processing table C_RECURRINGGROUP
ALTER TABLE C_RECURRINGGROUP MODIFY (C_RECURRINGGROUP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));

-- Processing table C_REGION_TRL
ALTER TABLE C_REGION_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_REGION_TRL_UU VARCHAR2(36 CHAR));

-- Processing table C_REVENUERECOG_SERVICE
ALTER TABLE C_REVENUERECOG_SERVICE MODIFY (C_REVENUERECOG_SERVICE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));

-- Processing table C_SALESREGION_TRL
ALTER TABLE C_SALESREGION_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_SALESREGION_TRL_UU VARCHAR2(36 CHAR));

-- Processing table C_SALESSTAGE_TRL
ALTER TABLE C_SALESSTAGE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),C_SALESSTAGE_TRL_UU VARCHAR2(36 CHAR));

-- Processing table C_TAXCATEGORY_TRL
ALTER TABLE C_TAXCATEGORY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_TAXPOSTAL
ALTER TABLE C_TAXPOSTAL MODIFY (POSTAL VARCHAR2(10 CHAR),POSTAL_TO VARCHAR2(10 CHAR));

-- Processing table C_TAX_TRL
ALTER TABLE C_TAX_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_UOM_TRL
ALTER TABLE C_UOM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table C_YEAR
ALTER TABLE C_YEAR MODIFY (FISCALYEAR VARCHAR2(10 CHAR));

-- Processing table GL_CATEGORY_TRL
ALTER TABLE GL_CATEGORY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),GL_CATEGORY_TRL_UU VARCHAR2(36 CHAR));

-- Processing table I_ASSET
ALTER TABLE I_ASSET MODIFY (A_ASSET_SPREAD_TYPE VARCHAR2(10 CHAR),A_DEPRECIATION_CALC_TYPE VARCHAR2(10 CHAR),A_DISPOSAL_LOSS VARCHAR2(22 CHAR),A_DISPOSAL_REVENUE VARCHAR2(22 CHAR),A_REVAL_ACCUMDEP_OFFSET_CUR VARCHAR2(22 CHAR),A_REVAL_ACCUMDEP_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_COST_OFFSET VARCHAR2(22 CHAR),A_REVAL_COST_OFFSET_PRIOR VARCHAR2(22 CHAR),A_REVAL_DEPEXP_OFFSET VARCHAR2(22 CHAR),CONVENTIONTYPE VARCHAR2(10 CHAR),DEPRECIATIONTYPE VARCHAR2(10 CHAR));

-- Processing table I_BANKSTATEMENT
ALTER TABLE I_BANKSTATEMENT MODIFY (IBAN VARCHAR2(40 CHAR),TRXTYPE VARCHAR2(20 CHAR));

-- Processing table I_BPARTNER
ALTER TABLE I_BPARTNER MODIFY (POSTAL VARCHAR2(10 CHAR),POSTAL_ADD VARCHAR2(10 CHAR),TAXID VARCHAR2(20 CHAR));

-- Processing table I_FIXEDASSET
ALTER TABLE I_FIXEDASSET MODIFY (ACCTSCHEMANAME VARCHAR2(120 CHAR),ISO_CODE VARCHAR2(3 CHAR));

-- Processing table I_GLJOURNAL
ALTER TABLE I_GLJOURNAL MODIFY (SKU VARCHAR2(30 CHAR),UPC VARCHAR2(30 CHAR));

-- Processing table I_INVENTORY
ALTER TABLE I_INVENTORY MODIFY (UPC VARCHAR2(30 CHAR));

-- Processing table I_INVOICE
ALTER TABLE I_INVOICE MODIFY (POSTAL VARCHAR2(10 CHAR));

-- Processing table I_ORDER
ALTER TABLE I_ORDER MODIFY (POSTAL VARCHAR2(10 CHAR));

-- Processing table I_PAYMENT
ALTER TABLE I_PAYMENT MODIFY (CREDITCARDVV VARCHAR2(4 CHAR),IBAN VARCHAR2(40 CHAR),SWIFTCODE VARCHAR2(20 CHAR),SWIPE VARCHAR2(80 CHAR));

-- Processing table I_PRODUCT
ALTER TABLE I_PRODUCT MODIFY (SKU VARCHAR2(30 CHAR),UPC VARCHAR2(30 CHAR));

-- Processing table JAVA$CLASS$MD5$TABLE
ALTER TABLE JAVA$CLASS$MD5$TABLE MODIFY (NAME VARCHAR2(200 CHAR));

-- Processing table K_SYNONYM
ALTER TABLE K_SYNONYM MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table M_ATTRIBUTE
ALTER TABLE M_ATTRIBUTE MODIFY (DATEFORMAT VARCHAR2(20 CHAR));

-- Processing table M_DISCOUNTSCHEMALINE
ALTER TABLE M_DISCOUNTSCHEMALINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR));

-- Processing table M_LOCATORTYPE
ALTER TABLE M_LOCATORTYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_LOCATORTYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));

-- Processing table M_PRICELIST_TRL
ALTER TABLE M_PRICELIST_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),M_PRICELIST_TRL_UU VARCHAR2(36 CHAR));

-- Processing table M_PRICELIST_VERSION_TRL
ALTER TABLE M_PRICELIST_VERSION_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),M_PRICELIST_VERSION_TRL_UU VARCHAR2(36 CHAR));

-- Processing table M_PRODUCT
ALTER TABLE M_PRODUCT MODIFY (SKU VARCHAR2(30 CHAR),UPC VARCHAR2(30 CHAR));

-- Processing table M_PRODUCTION
ALTER TABLE M_PRODUCTION MODIFY (DOCSTATUS VARCHAR2(2 CHAR));

-- Processing table M_PRODUCT_CATEGORY_TRL
ALTER TABLE M_PRODUCT_CATEGORY_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),M_PRODUCT_CATEGORY_TRL_UU VARCHAR2(36 CHAR));

-- Processing table M_PRODUCT_TRL
ALTER TABLE M_PRODUCT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PA_COLORSCHEMA
ALTER TABLE PA_COLORSCHEMA MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table PA_DASHBOARDCONTENT_TRL
ALTER TABLE PA_DASHBOARDCONTENT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PA_DOCUMENTSTATUS
ALTER TABLE PA_DOCUMENTSTATUS MODIFY (DESCRIPTION VARCHAR2(255 CHAR),ENTITYTYPE VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR),PA_DOCUMENTSTATUS_UU VARCHAR2(36 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));

-- Processing table PA_DOCUMENTSTATUS_TRL
ALTER TABLE PA_DOCUMENTSTATUS_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),NAME VARCHAR2(60 CHAR),PA_DOCUMENTSTATUS_TRL_UU VARCHAR2(36 CHAR));

-- Processing table PA_MEASURECALC
ALTER TABLE PA_MEASURECALC MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table PA_REPORTCOLUMN_TRL
ALTER TABLE PA_REPORTCOLUMN_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(255 CHAR),PA_REPORTCOLUMN_TRL_UU VARCHAR2(36 CHAR));

-- Processing table PA_REPORTLINE_TRL
ALTER TABLE PA_REPORTLINE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(255 CHAR),PA_REPORTLINE_TRL_UU VARCHAR2(36 CHAR));

-- Processing table PP_ORDER_BOMLINE_TRL
ALTER TABLE PP_ORDER_BOMLINE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_ORDER_BOM_TRL
ALTER TABLE PP_ORDER_BOM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_ORDER_NODE
ALTER TABLE PP_ORDER_NODE MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table PP_ORDER_NODENEXT
ALTER TABLE PP_ORDER_NODENEXT MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table PP_ORDER_NODE_TRL
ALTER TABLE PP_ORDER_NODE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_ORDER_WORKFLOW
ALTER TABLE PP_ORDER_WORKFLOW MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table PP_ORDER_WORKFLOW_TRL
ALTER TABLE PP_ORDER_WORKFLOW_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_PRODUCT_BOMLINE_TRL
ALTER TABLE PP_PRODUCT_BOMLINE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_PRODUCT_BOM_TRL
ALTER TABLE PP_PRODUCT_BOM_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table PP_WF_NODE_PRODUCT
ALTER TABLE PP_WF_NODE_PRODUCT MODIFY (ENTITYTYPE VARCHAR2(40 CHAR));

-- Processing table R_MAILTEXT_TRL
ALTER TABLE R_MAILTEXT_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table TEST
ALTER TABLE TEST MODIFY (COLOR VARCHAR2(7 CHAR));

-- Processing table T_BOMLINE
ALTER TABLE T_BOMLINE MODIFY (COST VARCHAR2(22 CHAR));

-- Processing table T_MOVECLIENT
ALTER TABLE T_MOVECLIENT MODIFY (TABLENAME VARCHAR2(40 CHAR));

-- Processing table T_SELECTION
ALTER TABLE T_SELECTION MODIFY (VIEWID VARCHAR2(2000 CHAR));

-- Processing table T_SELECTION_INFOWINDOW
ALTER TABLE T_SELECTION_INFOWINDOW MODIFY (COLUMNNAME VARCHAR2(255 CHAR),INFO VARCHAR2(60 CHAR),VALUE_STRING VARCHAR2(255 CHAR),VIEWID VARCHAR2(2000 CHAR));

-- Processing table U_WEBMENU
ALTER TABLE U_WEBMENU MODIFY (POSITION VARCHAR2(10 CHAR));

-- Processing table W_MAILMSG_TRL
ALTER TABLE W_MAILMSG_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Processing table W_STORE_TRL
ALTER TABLE W_STORE_TRL MODIFY (AD_LANGUAGE VARCHAR2(6 CHAR));

-- Converting all NVARCHAR2 to VARCHAR2..CHAR

-- Processing table AD_ACCESSLOG
ALTER TABLE AD_ACCESSLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
UPDATE AD_ACCESSLOG SET tmp_col_1_tmp=AD_ACCESSLOG_UU,AD_ACCESSLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_4_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_5_tmp=REPLY,REPLY=NULL,tmp_col_6_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_ACCESSLOG MODIFY (AD_ACCESSLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(60 CHAR),REPLY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_ACCESSLOG SET AD_ACCESSLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REMOTE_ADDR=tmp_col_3_tmp,REMOTE_HOST=tmp_col_4_tmp,REPLY=tmp_col_5_tmp,TEXTMSG=tmp_col_6_tmp;
ALTER TABLE AD_ACCESSLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_ALERT
ALTER TABLE AD_ALERT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ALERT MODIFY (ALERTMESSAGE NVARCHAR2(2000) NULL,ALERTSUBJECT NVARCHAR2(255) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_ALERT SET tmp_col_1_tmp=AD_ALERT_UU,AD_ALERT_UU=NULL,tmp_col_2_tmp=ALERTMESSAGE,ALERTMESSAGE=NULL,tmp_col_3_tmp=ALERTSUBJECT,ALERTSUBJECT=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ALERT MODIFY (AD_ALERT_UU VARCHAR2(36 CHAR),ALERTMESSAGE VARCHAR2(2000 CHAR),ALERTSUBJECT VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ALERT SET AD_ALERT_UU=tmp_col_1_tmp,ALERTMESSAGE=tmp_col_2_tmp,ALERTSUBJECT=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,HELP=tmp_col_5_tmp,NAME=tmp_col_6_tmp;
ALTER TABLE AD_ALERT MODIFY (ALERTMESSAGE VARCHAR2(2000 CHAR) NOT NULL,ALERTSUBJECT VARCHAR2(255 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ALERT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_ALERTPROCESSOR
ALTER TABLE AD_ALERTPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ALERTPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ALERTPROCESSOR SET tmp_col_1_tmp=AD_ALERTPROCESSOR_UU,AD_ALERTPROCESSOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ALERTPROCESSOR MODIFY (AD_ALERTPROCESSOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ALERTPROCESSOR SET AD_ALERTPROCESSOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_ALERTPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ALERTPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_ALERTPROCESSORLOG
ALTER TABLE AD_ALERTPROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE AD_ALERTPROCESSORLOG SET tmp_col_1_tmp=AD_ALERTPROCESSORLOG_UU,AD_ALERTPROCESSORLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_ALERTPROCESSORLOG MODIFY (AD_ALERTPROCESSORLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_ALERTPROCESSORLOG SET AD_ALERTPROCESSORLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE AD_ALERTPROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_ALERTRECIPIENT
ALTER TABLE AD_ALERTRECIPIENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_ALERTRECIPIENT SET tmp_col_1_tmp=AD_ALERTRECIPIENT_UU,AD_ALERTRECIPIENT_UU=NULL;
ALTER TABLE AD_ALERTRECIPIENT MODIFY (AD_ALERTRECIPIENT_UU VARCHAR2(36 CHAR));
UPDATE AD_ALERTRECIPIENT SET AD_ALERTRECIPIENT_UU=tmp_col_1_tmp;
ALTER TABLE AD_ALERTRECIPIENT DROP (tmp_col_1_tmp);

-- Processing table AD_ALERTRULE
ALTER TABLE AD_ALERTRULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_ALERTRULE MODIFY (FROMCLAUSE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL,SELECTCLAUSE NVARCHAR2(2000) NULL);
UPDATE AD_ALERTRULE SET tmp_col_1_tmp=AD_ALERTRULE_UU,AD_ALERTRULE_UU=NULL,tmp_col_2_tmp=ERRORMSG,ERRORMSG=NULL,tmp_col_3_tmp=FROMCLAUSE,FROMCLAUSE=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_6_tmp=POSTPROCESSING,POSTPROCESSING=NULL,tmp_col_7_tmp=PREPROCESSING,PREPROCESSING=NULL,tmp_col_8_tmp=SELECTCLAUSE,SELECTCLAUSE=NULL,tmp_col_9_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_ALERTRULE MODIFY (AD_ALERTRULE_UU VARCHAR2(36 CHAR),ERRORMSG VARCHAR2(2000 CHAR),FROMCLAUSE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),POSTPROCESSING VARCHAR2(2000 CHAR),PREPROCESSING VARCHAR2(2000 CHAR),SELECTCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_ALERTRULE SET AD_ALERTRULE_UU=tmp_col_1_tmp,ERRORMSG=tmp_col_2_tmp,FROMCLAUSE=tmp_col_3_tmp,NAME=tmp_col_4_tmp,OTHERCLAUSE=tmp_col_5_tmp,POSTPROCESSING=tmp_col_6_tmp,PREPROCESSING=tmp_col_7_tmp,SELECTCLAUSE=tmp_col_8_tmp,WHERECLAUSE=tmp_col_9_tmp;
ALTER TABLE AD_ALERTRULE MODIFY (FROMCLAUSE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,SELECTCLAUSE VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_ALERTRULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table AD_ARCHIVE
ALTER TABLE AD_ARCHIVE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ARCHIVE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ARCHIVE SET tmp_col_1_tmp=AD_ARCHIVE_UU,AD_ARCHIVE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ARCHIVE MODIFY (AD_ARCHIVE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ARCHIVE SET AD_ARCHIVE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_ARCHIVE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ARCHIVE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_ATTACHMENT
ALTER TABLE AD_ATTACHMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ATTACHMENT MODIFY (TITLE NVARCHAR2(60) NULL);
UPDATE AD_ATTACHMENT SET tmp_col_1_tmp=AD_ATTACHMENT_UU,AD_ATTACHMENT_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL,tmp_col_3_tmp=TITLE,TITLE=NULL;
ALTER TABLE AD_ATTACHMENT MODIFY (AD_ATTACHMENT_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE AD_ATTACHMENT SET AD_ATTACHMENT_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp,TITLE=tmp_col_3_tmp;
ALTER TABLE AD_ATTACHMENT MODIFY (TITLE VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ATTACHMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_ATTACHMENTNOTE
ALTER TABLE AD_ATTACHMENTNOTE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ATTACHMENTNOTE MODIFY (TEXTMSG NVARCHAR2(2000) NULL,TITLE NVARCHAR2(60) NULL);
UPDATE AD_ATTACHMENTNOTE SET tmp_col_1_tmp=AD_ATTACHMENTNOTE_UU,AD_ATTACHMENTNOTE_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL,tmp_col_3_tmp=TITLE,TITLE=NULL;
ALTER TABLE AD_ATTACHMENTNOTE MODIFY (AD_ATTACHMENTNOTE_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE AD_ATTACHMENTNOTE SET AD_ATTACHMENTNOTE_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp,TITLE=tmp_col_3_tmp;
ALTER TABLE AD_ATTACHMENTNOTE MODIFY (TEXTMSG VARCHAR2(2000 CHAR) NOT NULL,TITLE VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ATTACHMENTNOTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_ATTRIBUTE
ALTER TABLE AD_ATTRIBUTE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(20 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ATTRIBUTE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ATTRIBUTE SET tmp_col_1_tmp=AD_ATTRIBUTE_UU,AD_ATTRIBUTE_UU=NULL,tmp_col_2_tmp=CALLOUT,CALLOUT=NULL,tmp_col_3_tmp=DEFAULTVALUE,DEFAULTVALUE=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_6_tmp=HELP,HELP=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=VALUEMAX,VALUEMAX=NULL,tmp_col_9_tmp=VALUEMIN,VALUEMIN=NULL,tmp_col_10_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_ATTRIBUTE MODIFY (AD_ATTRIBUTE_UU VARCHAR2(36 CHAR),CALLOUT VARCHAR2(60 CHAR),DEFAULTVALUE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUEMAX VARCHAR2(20 CHAR),VALUEMIN VARCHAR2(20 CHAR),VFORMAT VARCHAR2(60 CHAR));
UPDATE AD_ATTRIBUTE SET AD_ATTRIBUTE_UU=tmp_col_1_tmp,CALLOUT=tmp_col_2_tmp,DEFAULTVALUE=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,DISPLAYLOGIC=tmp_col_5_tmp,HELP=tmp_col_6_tmp,NAME=tmp_col_7_tmp,VALUEMAX=tmp_col_8_tmp,VALUEMIN=tmp_col_9_tmp,VFORMAT=tmp_col_10_tmp;
ALTER TABLE AD_ATTRIBUTE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ATTRIBUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_ATTRIBUTE_VALUE
ALTER TABLE AD_ATTRIBUTE_VALUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_ATTRIBUTE_VALUE SET tmp_col_1_tmp=AD_ATTRIBUTE_VALUE_UU,AD_ATTRIBUTE_VALUE_UU=NULL,tmp_col_2_tmp=V_STRING,V_STRING=NULL;
ALTER TABLE AD_ATTRIBUTE_VALUE MODIFY (AD_ATTRIBUTE_VALUE_UU VARCHAR2(36 CHAR),V_STRING VARCHAR2(2000 CHAR));
UPDATE AD_ATTRIBUTE_VALUE SET AD_ATTRIBUTE_VALUE_UU=tmp_col_1_tmp,V_STRING=tmp_col_2_tmp;
ALTER TABLE AD_ATTRIBUTE_VALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_BROADCASTMESSAGE
ALTER TABLE AD_BROADCASTMESSAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(32 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_BROADCASTMESSAGE MODIFY (BROADCASTFREQUENCY NVARCHAR2(60) NULL,BROADCASTMESSAGE NVARCHAR2(2000) NULL,BROADCASTTYPE NVARCHAR2(32) NULL,TARGET NVARCHAR2(60) NULL);
UPDATE AD_BROADCASTMESSAGE SET tmp_col_1_tmp=AD_BROADCASTMESSAGE_UU,AD_BROADCASTMESSAGE_UU=NULL,tmp_col_2_tmp=BROADCASTFREQUENCY,BROADCASTFREQUENCY=NULL,tmp_col_3_tmp=BROADCASTMESSAGE,BROADCASTMESSAGE=NULL,tmp_col_4_tmp=BROADCASTTYPE,BROADCASTTYPE=NULL,tmp_col_5_tmp=TARGET,TARGET=NULL;
ALTER TABLE AD_BROADCASTMESSAGE MODIFY (AD_BROADCASTMESSAGE_UU VARCHAR2(36 CHAR),BROADCASTFREQUENCY VARCHAR2(60 CHAR),BROADCASTMESSAGE VARCHAR2(2000 CHAR),BROADCASTTYPE VARCHAR2(32 CHAR),TARGET VARCHAR2(60 CHAR));
UPDATE AD_BROADCASTMESSAGE SET AD_BROADCASTMESSAGE_UU=tmp_col_1_tmp,BROADCASTFREQUENCY=tmp_col_2_tmp,BROADCASTMESSAGE=tmp_col_3_tmp,BROADCASTTYPE=tmp_col_4_tmp,TARGET=tmp_col_5_tmp;
ALTER TABLE AD_BROADCASTMESSAGE MODIFY (BROADCASTFREQUENCY VARCHAR2(60 CHAR) NOT NULL,BROADCASTMESSAGE VARCHAR2(2000 CHAR) NOT NULL,BROADCASTTYPE VARCHAR2(32 CHAR) NOT NULL,TARGET VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_BROADCASTMESSAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_BROADCASTMESSAGE_TRL
ALTER TABLE AD_BROADCASTMESSAGE_TRL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_BROADCASTMESSAGE_TRL MODIFY (BROADCASTMESSAGE NVARCHAR2(2000) NULL);
UPDATE AD_BROADCASTMESSAGE_TRL SET tmp_col_1_tmp=BROADCASTMESSAGE,BROADCASTMESSAGE=NULL;
ALTER TABLE AD_BROADCASTMESSAGE_TRL MODIFY (BROADCASTMESSAGE VARCHAR2(2000 CHAR));
UPDATE AD_BROADCASTMESSAGE_TRL SET BROADCASTMESSAGE=tmp_col_1_tmp;
ALTER TABLE AD_BROADCASTMESSAGE_TRL MODIFY (BROADCASTMESSAGE VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_BROADCASTMESSAGE_TRL DROP (tmp_col_1_tmp);

-- Processing table AD_CHANGELOG
ALTER TABLE AD_CHANGELOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
UPDATE AD_CHANGELOG SET tmp_col_1_tmp=AD_CHANGELOG_UU,AD_CHANGELOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NEWVALUE,NEWVALUE=NULL,tmp_col_4_tmp=OLDVALUE,OLDVALUE=NULL,tmp_col_5_tmp=TRXNAME,TRXNAME=NULL;
ALTER TABLE AD_CHANGELOG MODIFY (AD_CHANGELOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NEWVALUE VARCHAR2(2000 CHAR),OLDVALUE VARCHAR2(2000 CHAR),TRXNAME VARCHAR2(60 CHAR));
UPDATE AD_CHANGELOG SET AD_CHANGELOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NEWVALUE=tmp_col_3_tmp,OLDVALUE=tmp_col_4_tmp,TRXNAME=tmp_col_5_tmp;
ALTER TABLE AD_CHANGELOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_CHART
ALTER TABLE AD_CHART ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_CHART MODIFY (CHARTTYPE NVARCHAR2(2) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_CHART SET tmp_col_1_tmp=AD_CHART_UU,AD_CHART_UU=NULL,tmp_col_2_tmp=CHARTTYPE,CHARTTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DOMAINLABEL,DOMAINLABEL=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=RANGELABEL,RANGELABEL=NULL;
ALTER TABLE AD_CHART MODIFY (AD_CHART_UU VARCHAR2(36 CHAR),CHARTTYPE VARCHAR2(2 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOMAINLABEL VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),RANGELABEL VARCHAR2(60 CHAR));
UPDATE AD_CHART SET AD_CHART_UU=tmp_col_1_tmp,CHARTTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DOMAINLABEL=tmp_col_4_tmp,NAME=tmp_col_5_tmp,RANGELABEL=tmp_col_6_tmp;
ALTER TABLE AD_CHART MODIFY (CHARTTYPE VARCHAR2(2 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_CHART DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_CHARTDATASOURCE
ALTER TABLE AD_CHARTDATASOURCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_CHARTDATASOURCE MODIFY (FROMCLAUSE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL,VALUECOLUMN NVARCHAR2(60) NULL,WHERECLAUSE NVARCHAR2(2000) NULL);
UPDATE AD_CHARTDATASOURCE SET tmp_col_1_tmp=AD_CHARTDATASOURCE_UU,AD_CHARTDATASOURCE_UU=NULL,tmp_col_2_tmp=CATEGORYCOLUMN,CATEGORYCOLUMN=NULL,tmp_col_3_tmp=DATECOLUMN,DATECOLUMN=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=FROMCLAUSE,FROMCLAUSE=NULL,tmp_col_6_tmp=KEYCOLUMN,KEYCOLUMN=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=SERIESCOLUMN,SERIESCOLUMN=NULL,tmp_col_9_tmp=VALUECOLUMN,VALUECOLUMN=NULL,tmp_col_10_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_CHARTDATASOURCE MODIFY (AD_CHARTDATASOURCE_UU VARCHAR2(36 CHAR),CATEGORYCOLUMN VARCHAR2(60 CHAR),DATECOLUMN VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FROMCLAUSE VARCHAR2(2000 CHAR),KEYCOLUMN VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),SERIESCOLUMN VARCHAR2(60 CHAR),VALUECOLUMN VARCHAR2(60 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR) DEFAULT 'WHERE ...' );
UPDATE AD_CHARTDATASOURCE SET AD_CHARTDATASOURCE_UU=tmp_col_1_tmp,CATEGORYCOLUMN=tmp_col_2_tmp,DATECOLUMN=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,FROMCLAUSE=tmp_col_5_tmp,KEYCOLUMN=tmp_col_6_tmp,NAME=tmp_col_7_tmp,SERIESCOLUMN=tmp_col_8_tmp,VALUECOLUMN=tmp_col_9_tmp,WHERECLAUSE=tmp_col_10_tmp;
ALTER TABLE AD_CHARTDATASOURCE MODIFY (FROMCLAUSE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,VALUECOLUMN VARCHAR2(60 CHAR) NOT NULL,WHERECLAUSE VARCHAR2(2000 CHAR) DEFAULT 'WHERE ...'  NOT NULL);
ALTER TABLE AD_CHARTDATASOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_CHART_TRL
ALTER TABLE AD_CHART_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_CHART_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_CHART_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOMAINLABEL,DOMAINLABEL=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=RANGELABEL,RANGELABEL=NULL;
ALTER TABLE AD_CHART_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOMAINLABEL VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),RANGELABEL VARCHAR2(60 CHAR));
UPDATE AD_CHART_TRL SET DESCRIPTION=tmp_col_1_tmp,DOMAINLABEL=tmp_col_2_tmp,NAME=tmp_col_3_tmp,RANGELABEL=tmp_col_4_tmp;
ALTER TABLE AD_CHART_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_CHART_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_CLIENT
ALTER TABLE AD_CLIENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(255 CHAR),tmp_col_14_tmp VARCHAR2(40 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_CLIENT MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_CLIENT SET tmp_col_1_tmp=AD_CLIENT_UU,AD_CLIENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTDIR,DOCUMENTDIR=NULL,tmp_col_4_tmp=LDAPQUERY,LDAPQUERY=NULL,tmp_col_5_tmp=MODELVALIDATIONCLASSES,MODELVALIDATIONCLASSES=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=REQUESTEMAIL,REQUESTEMAIL=NULL,tmp_col_8_tmp=REQUESTFOLDER,REQUESTFOLDER=NULL,tmp_col_9_tmp=REQUESTUSER,REQUESTUSER=NULL,tmp_col_10_tmp=REQUESTUSERPW,REQUESTUSERPW=NULL,tmp_col_11_tmp=SMTPHOST,SMTPHOST=NULL,tmp_col_12_tmp=UNIXARCHIVEPATH,UNIXARCHIVEPATH=NULL,tmp_col_13_tmp=UNIXATTACHMENTPATH,UNIXATTACHMENTPATH=NULL,tmp_col_14_tmp=VALUE,VALUE=NULL,tmp_col_15_tmp=WINDOWSARCHIVEPATH,WINDOWSARCHIVEPATH=NULL,tmp_col_16_tmp=WINDOWSATTACHMENTPATH,WINDOWSATTACHMENTPATH=NULL;
ALTER TABLE AD_CLIENT MODIFY (AD_CLIENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTDIR VARCHAR2(60 CHAR),LDAPQUERY VARCHAR2(255 CHAR),MODELVALIDATIONCLASSES VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),REQUESTEMAIL VARCHAR2(60 CHAR),REQUESTFOLDER VARCHAR2(20 CHAR),REQUESTUSER VARCHAR2(60 CHAR),REQUESTUSERPW VARCHAR2(255 CHAR),SMTPHOST VARCHAR2(60 CHAR),UNIXARCHIVEPATH VARCHAR2(255 CHAR),UNIXATTACHMENTPATH VARCHAR2(255 CHAR),VALUE VARCHAR2(40 CHAR),WINDOWSARCHIVEPATH VARCHAR2(255 CHAR),WINDOWSATTACHMENTPATH VARCHAR2(255 CHAR));
UPDATE AD_CLIENT SET AD_CLIENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTDIR=tmp_col_3_tmp,LDAPQUERY=tmp_col_4_tmp,MODELVALIDATIONCLASSES=tmp_col_5_tmp,NAME=tmp_col_6_tmp,REQUESTEMAIL=tmp_col_7_tmp,REQUESTFOLDER=tmp_col_8_tmp,REQUESTUSER=tmp_col_9_tmp,REQUESTUSERPW=tmp_col_10_tmp,SMTPHOST=tmp_col_11_tmp,UNIXARCHIVEPATH=tmp_col_12_tmp,UNIXATTACHMENTPATH=tmp_col_13_tmp,VALUE=tmp_col_14_tmp,WINDOWSARCHIVEPATH=tmp_col_15_tmp,WINDOWSATTACHMENTPATH=tmp_col_16_tmp;
ALTER TABLE AD_CLIENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_CLIENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp);

-- Processing table AD_CLIENTINFO
ALTER TABLE AD_CLIENTINFO ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_CLIENTINFO SET tmp_col_1_tmp=AD_CLIENTINFO_UU,AD_CLIENTINFO_UU=NULL;
ALTER TABLE AD_CLIENTINFO MODIFY (AD_CLIENTINFO_UU VARCHAR2(36 CHAR));
UPDATE AD_CLIENTINFO SET AD_CLIENTINFO_UU=tmp_col_1_tmp;
ALTER TABLE AD_CLIENTINFO DROP (tmp_col_1_tmp);

-- Processing table AD_CLIENTSHARE
ALTER TABLE AD_CLIENTSHARE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_CLIENTSHARE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_CLIENTSHARE SET tmp_col_1_tmp=AD_CLIENTSHARE_UU,AD_CLIENTSHARE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_CLIENTSHARE MODIFY (AD_CLIENTSHARE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_CLIENTSHARE SET AD_CLIENTSHARE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_CLIENTSHARE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_CLIENTSHARE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_COLOR
ALTER TABLE AD_COLOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_COLOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_COLOR SET tmp_col_1_tmp=AD_COLOR_UU,AD_COLOR_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE AD_COLOR MODIFY (AD_COLOR_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_COLOR SET AD_COLOR_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE AD_COLOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_COLOR DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_COLOR_TRL
ALTER TABLE AD_COLOR_TRL ADD (tmp_col_1_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_COLOR_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_COLOR_TRL SET tmp_col_1_tmp=NAME,NAME=NULL;
ALTER TABLE AD_COLOR_TRL MODIFY (NAME VARCHAR2(60 CHAR));
UPDATE AD_COLOR_TRL SET NAME=tmp_col_1_tmp;
ALTER TABLE AD_COLOR_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_COLOR_TRL DROP (tmp_col_1_tmp);

-- Processing table AD_COLUMN
ALTER TABLE AD_COLUMN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(30 CHAR),tmp_col_7_tmp VARCHAR2(22 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(2000 CHAR),tmp_col_14_tmp VARCHAR2(20 CHAR),tmp_col_15_tmp VARCHAR2(20 CHAR),tmp_col_16_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_COLUMN MODIFY (COLUMNNAME NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_COLUMN SET tmp_col_1_tmp=AD_COLUMN_UU,AD_COLUMN_UU=NULL,tmp_col_2_tmp=CALLOUT,CALLOUT=NULL,tmp_col_3_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_4_tmp=DEFAULTVALUE,DEFAULTVALUE=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=FKCONSTRAINTNAME,FKCONSTRAINTNAME=NULL,tmp_col_7_tmp=FORMATPATTERN,FORMATPATTERN=NULL,tmp_col_8_tmp=HELP,HELP=NULL,tmp_col_9_tmp=INFOFACTORYCLASS,INFOFACTORYCLASS=NULL,tmp_col_10_tmp=MANDATORYLOGIC,MANDATORYLOGIC=NULL,tmp_col_11_tmp=NAME,NAME=NULL,tmp_col_12_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_13_tmp=READONLYLOGIC,READONLYLOGIC=NULL,tmp_col_14_tmp=VALUEMAX,VALUEMAX=NULL,tmp_col_15_tmp=VALUEMIN,VALUEMIN=NULL,tmp_col_16_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_COLUMN MODIFY (AD_COLUMN_UU VARCHAR2(36 CHAR),CALLOUT VARCHAR2(255 CHAR),COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL ,DEFAULTVALUE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FKCONSTRAINTNAME VARCHAR2(30 CHAR),FORMATPATTERN VARCHAR2(22 CHAR),HELP VARCHAR2(2000 CHAR),INFOFACTORYCLASS VARCHAR2(255 CHAR),MANDATORYLOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),VALUEMAX VARCHAR2(20 CHAR),VALUEMIN VARCHAR2(20 CHAR),VFORMAT VARCHAR2(255 CHAR));
UPDATE AD_COLUMN SET AD_COLUMN_UU=tmp_col_1_tmp,CALLOUT=tmp_col_2_tmp,COLUMNNAME=tmp_col_3_tmp,DEFAULTVALUE=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,FKCONSTRAINTNAME=tmp_col_6_tmp,FORMATPATTERN=tmp_col_7_tmp,HELP=tmp_col_8_tmp,INFOFACTORYCLASS=tmp_col_9_tmp,MANDATORYLOGIC=tmp_col_10_tmp,NAME=tmp_col_11_tmp,PLACEHOLDER=tmp_col_12_tmp,READONLYLOGIC=tmp_col_13_tmp,VALUEMAX=tmp_col_14_tmp,VALUEMIN=tmp_col_15_tmp,VFORMAT=tmp_col_16_tmp;
ALTER TABLE AD_COLUMN MODIFY (COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_COLUMN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp);

-- Processing table AD_COLUMN_ACCESS
ALTER TABLE AD_COLUMN_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_COLUMN_ACCESS SET tmp_col_1_tmp=AD_COLUMN_ACCESS_UU,AD_COLUMN_ACCESS_UU=NULL;
ALTER TABLE AD_COLUMN_ACCESS MODIFY (AD_COLUMN_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_COLUMN_ACCESS SET AD_COLUMN_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_COLUMN_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_COLUMN_TRL
ALTER TABLE AD_COLUMN_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_COLUMN_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_COLUMN_TRL SET tmp_col_1_tmp=AD_COLUMN_TRL_UU,AD_COLUMN_TRL_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PLACEHOLDER,PLACEHOLDER=NULL;
ALTER TABLE AD_COLUMN_TRL MODIFY (AD_COLUMN_TRL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR));
UPDATE AD_COLUMN_TRL SET AD_COLUMN_TRL_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PLACEHOLDER=tmp_col_3_tmp;
ALTER TABLE AD_COLUMN_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_COLUMN_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_CTXHELP
ALTER TABLE AD_CTXHELP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR));
ALTER TABLE AD_CTXHELP MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE AD_CTXHELP SET tmp_col_1_tmp=AD_CTXHELP_UU,AD_CTXHELP_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_CTXHELP MODIFY (AD_CTXHELP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR));
UPDATE AD_CTXHELP SET AD_CTXHELP_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_CTXHELP MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE AD_CTXHELP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_CTXHELPMSG
ALTER TABLE AD_CTXHELPMSG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_CTXHELPMSG MODIFY (MSGTEXT NVARCHAR2(2000) NULL);
UPDATE AD_CTXHELPMSG SET tmp_col_1_tmp=AD_CTXHELPMSG_UU,AD_CTXHELPMSG_UU=NULL,tmp_col_2_tmp=MSGTEXT,MSGTEXT=NULL;
ALTER TABLE AD_CTXHELPMSG MODIFY (AD_CTXHELPMSG_UU VARCHAR2(36 CHAR),MSGTEXT VARCHAR2(2000 CHAR));
UPDATE AD_CTXHELPMSG SET AD_CTXHELPMSG_UU=tmp_col_1_tmp,MSGTEXT=tmp_col_2_tmp;
ALTER TABLE AD_CTXHELPMSG MODIFY (MSGTEXT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_CTXHELPMSG DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_CTXHELPMSG_TRL
ALTER TABLE AD_CTXHELPMSG_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_CTXHELPMSG_TRL MODIFY (MSGTEXT NVARCHAR2(2000) NULL);
UPDATE AD_CTXHELPMSG_TRL SET tmp_col_1_tmp=AD_CTXHELPMSG_TRL_UU,AD_CTXHELPMSG_TRL_UU=NULL,tmp_col_2_tmp=MSGTEXT,MSGTEXT=NULL;
ALTER TABLE AD_CTXHELPMSG_TRL MODIFY (AD_CTXHELPMSG_TRL_UU VARCHAR2(36 CHAR),MSGTEXT VARCHAR2(2000 CHAR));
UPDATE AD_CTXHELPMSG_TRL SET AD_CTXHELPMSG_TRL_UU=tmp_col_1_tmp,MSGTEXT=tmp_col_2_tmp;
ALTER TABLE AD_CTXHELPMSG_TRL MODIFY (MSGTEXT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_CTXHELPMSG_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_DESKTOP
ALTER TABLE AD_DESKTOP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_DESKTOP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_DESKTOP SET tmp_col_1_tmp=AD_DESKTOP_UU,AD_DESKTOP_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_DESKTOP MODIFY (AD_DESKTOP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_DESKTOP SET AD_DESKTOP_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_DESKTOP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_DESKTOP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_DESKTOPWORKBENCH
ALTER TABLE AD_DESKTOPWORKBENCH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_DESKTOPWORKBENCH SET tmp_col_1_tmp=AD_DESKTOPWORKBENCH_UU,AD_DESKTOPWORKBENCH_UU=NULL;
ALTER TABLE AD_DESKTOPWORKBENCH MODIFY (AD_DESKTOPWORKBENCH_UU VARCHAR2(36 CHAR));
UPDATE AD_DESKTOPWORKBENCH SET AD_DESKTOPWORKBENCH_UU=tmp_col_1_tmp;
ALTER TABLE AD_DESKTOPWORKBENCH DROP (tmp_col_1_tmp);

-- Processing table AD_DESKTOP_TRL
ALTER TABLE AD_DESKTOP_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_DESKTOP_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_DESKTOP_TRL SET tmp_col_1_tmp=AD_DESKTOP_TRL_UU,AD_DESKTOP_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_DESKTOP_TRL MODIFY (AD_DESKTOP_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_DESKTOP_TRL SET AD_DESKTOP_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_DESKTOP_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_DESKTOP_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_DOCUMENT_ACTION_ACCESS
ALTER TABLE AD_DOCUMENT_ACTION_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_DOCUMENT_ACTION_ACCESS SET tmp_col_1_tmp=AD_DOCUMENT_ACTION_ACCESS_UU,AD_DOCUMENT_ACTION_ACCESS_UU=NULL;
ALTER TABLE AD_DOCUMENT_ACTION_ACCESS MODIFY (AD_DOCUMENT_ACTION_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_DOCUMENT_ACTION_ACCESS SET AD_DOCUMENT_ACTION_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_DOCUMENT_ACTION_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_ELEMENT
ALTER TABLE AD_ELEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ELEMENT MODIFY (COLUMNNAME NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE AD_ELEMENT SET tmp_col_1_tmp=AD_ELEMENT_UU,AD_ELEMENT_UU=NULL,tmp_col_2_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_7_tmp=PO_DESCRIPTION,PO_DESCRIPTION=NULL,tmp_col_8_tmp=PO_HELP,PO_HELP=NULL,tmp_col_9_tmp=PO_NAME,PO_NAME=NULL,tmp_col_10_tmp=PO_PRINTNAME,PO_PRINTNAME=NULL,tmp_col_11_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE AD_ELEMENT MODIFY (AD_ELEMENT_UU VARCHAR2(36 CHAR),COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL ,DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,PLACEHOLDER VARCHAR2(255 CHAR),PO_DESCRIPTION VARCHAR2(255 CHAR),PO_HELP VARCHAR2(2000 CHAR),PO_NAME VARCHAR2(60 CHAR),PO_PRINTNAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE AD_ELEMENT SET AD_ELEMENT_UU=tmp_col_1_tmp,COLUMNNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PLACEHOLDER=tmp_col_6_tmp,PO_DESCRIPTION=tmp_col_7_tmp,PO_HELP=tmp_col_8_tmp,PO_NAME=tmp_col_9_tmp,PO_PRINTNAME=tmp_col_10_tmp,PRINTNAME=tmp_col_11_tmp;
ALTER TABLE AD_ELEMENT MODIFY (COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL,PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp);

-- Processing table AD_ELEMENT_TRL
ALTER TABLE AD_ELEMENT_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ELEMENT_TRL MODIFY (NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE AD_ELEMENT_TRL SET tmp_col_1_tmp=AD_ELEMENT_TRL_UU,AD_ELEMENT_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_6_tmp=PO_DESCRIPTION,PO_DESCRIPTION=NULL,tmp_col_7_tmp=PO_HELP,PO_HELP=NULL,tmp_col_8_tmp=PO_NAME,PO_NAME=NULL,tmp_col_9_tmp=PO_PRINTNAME,PO_PRINTNAME=NULL,tmp_col_10_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE AD_ELEMENT_TRL MODIFY (AD_ELEMENT_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),PO_DESCRIPTION VARCHAR2(255 CHAR),PO_HELP VARCHAR2(2000 CHAR),PO_NAME VARCHAR2(60 CHAR),PO_PRINTNAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE AD_ELEMENT_TRL SET AD_ELEMENT_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PLACEHOLDER=tmp_col_5_tmp,PO_DESCRIPTION=tmp_col_6_tmp,PO_HELP=tmp_col_7_tmp,PO_NAME=tmp_col_8_tmp,PO_PRINTNAME=tmp_col_9_tmp,PRINTNAME=tmp_col_10_tmp;
ALTER TABLE AD_ELEMENT_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ELEMENT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_ENTITYTYPE
ALTER TABLE AD_ENTITYTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_ENTITYTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ENTITYTYPE SET tmp_col_1_tmp=AD_ENTITYTYPE_UU,AD_ENTITYTYPE_UU=NULL,tmp_col_2_tmp=CLASSPATH,CLASSPATH=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=MODELPACKAGE,MODELPACKAGE=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_ENTITYTYPE MODIFY (AD_ENTITYTYPE_UU VARCHAR2(36 CHAR),CLASSPATH VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),MODELPACKAGE VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VERSION VARCHAR2(20 CHAR));
UPDATE AD_ENTITYTYPE SET AD_ENTITYTYPE_UU=tmp_col_1_tmp,CLASSPATH=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,MODELPACKAGE=tmp_col_5_tmp,NAME=tmp_col_6_tmp,VERSION=tmp_col_7_tmp;
ALTER TABLE AD_ENTITYTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ENTITYTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_ERROR
ALTER TABLE AD_ERROR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ERROR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ERROR SET tmp_col_1_tmp=AD_ERROR_UU,AD_ERROR_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ERROR MODIFY (AD_ERROR_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ERROR SET AD_ERROR_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_ERROR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ERROR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_FIELD
ALTER TABLE AD_FIELD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_FIELD MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FIELD SET tmp_col_1_tmp=AD_FIELD_UU,AD_FIELD_UU=NULL,tmp_col_2_tmp=DEFAULTVALUE,DEFAULTVALUE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=INFOFACTORYCLASS,INFOFACTORYCLASS=NULL,tmp_col_7_tmp=MANDATORYLOGIC,MANDATORYLOGIC=NULL,tmp_col_8_tmp=NAME,NAME=NULL,tmp_col_9_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_10_tmp=READONLYLOGIC,READONLYLOGIC=NULL,tmp_col_11_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_FIELD MODIFY (AD_FIELD_UU VARCHAR2(36 CHAR),DEFAULTVALUE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),INFOFACTORYCLASS VARCHAR2(255 CHAR),MANDATORYLOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),VFORMAT VARCHAR2(255 CHAR));
UPDATE AD_FIELD SET AD_FIELD_UU=tmp_col_1_tmp,DEFAULTVALUE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DISPLAYLOGIC=tmp_col_4_tmp,HELP=tmp_col_5_tmp,INFOFACTORYCLASS=tmp_col_6_tmp,MANDATORYLOGIC=tmp_col_7_tmp,NAME=tmp_col_8_tmp,PLACEHOLDER=tmp_col_9_tmp,READONLYLOGIC=tmp_col_10_tmp,VFORMAT=tmp_col_11_tmp;
ALTER TABLE AD_FIELD MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FIELD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp);

-- Processing table AD_FIELDGROUP
ALTER TABLE AD_FIELDGROUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_FIELDGROUP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FIELDGROUP SET tmp_col_1_tmp=AD_FIELDGROUP_UU,AD_FIELDGROUP_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE AD_FIELDGROUP MODIFY (AD_FIELDGROUP_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_FIELDGROUP SET AD_FIELDGROUP_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE AD_FIELDGROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FIELDGROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_FIELDGROUP_TRL
ALTER TABLE AD_FIELDGROUP_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_FIELDGROUP_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FIELDGROUP_TRL SET tmp_col_1_tmp=AD_FIELDGROUP_TRL_UU,AD_FIELDGROUP_TRL_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE AD_FIELDGROUP_TRL MODIFY (AD_FIELDGROUP_TRL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_FIELDGROUP_TRL SET AD_FIELDGROUP_TRL_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE AD_FIELDGROUP_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FIELDGROUP_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_FIELD_TRL
ALTER TABLE AD_FIELD_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_FIELD_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FIELD_TRL SET tmp_col_1_tmp=AD_FIELD_TRL_UU,AD_FIELD_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PLACEHOLDER,PLACEHOLDER=NULL;
ALTER TABLE AD_FIELD_TRL MODIFY (AD_FIELD_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR));
UPDATE AD_FIELD_TRL SET AD_FIELD_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PLACEHOLDER=tmp_col_5_tmp;
ALTER TABLE AD_FIELD_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FIELD_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_FIND
ALTER TABLE AD_FIND ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_FIND MODIFY (VALUE NVARCHAR2(40) NULL);
UPDATE AD_FIND SET tmp_col_1_tmp=AD_FIND_UU,AD_FIND_UU=NULL,tmp_col_2_tmp=VALUE,VALUE=NULL,tmp_col_3_tmp=VALUE2,VALUE2=NULL;
ALTER TABLE AD_FIND MODIFY (AD_FIND_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR),VALUE2 VARCHAR2(40 CHAR));
UPDATE AD_FIND SET AD_FIND_UU=tmp_col_1_tmp,VALUE=tmp_col_2_tmp,VALUE2=tmp_col_3_tmp;
ALTER TABLE AD_FIND MODIFY (VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_FIND DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_FORM
ALTER TABLE AD_FORM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_FORM MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FORM SET tmp_col_1_tmp=AD_FORM_UU,AD_FORM_UU=NULL,tmp_col_2_tmp=CLASSNAME,CLASSNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=JSPURL,JSPURL=NULL,tmp_col_6_tmp=NAME,NAME=NULL;
ALTER TABLE AD_FORM MODIFY (AD_FORM_UU VARCHAR2(36 CHAR),CLASSNAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),JSPURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_FORM SET AD_FORM_UU=tmp_col_1_tmp,CLASSNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,JSPURL=tmp_col_5_tmp,NAME=tmp_col_6_tmp;
ALTER TABLE AD_FORM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FORM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_FORM_ACCESS
ALTER TABLE AD_FORM_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_FORM_ACCESS SET tmp_col_1_tmp=AD_FORM_ACCESS_UU,AD_FORM_ACCESS_UU=NULL;
ALTER TABLE AD_FORM_ACCESS MODIFY (AD_FORM_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_FORM_ACCESS SET AD_FORM_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_FORM_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_FORM_TRL
ALTER TABLE AD_FORM_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_FORM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_FORM_TRL SET tmp_col_1_tmp=AD_FORM_TRL_UU,AD_FORM_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_FORM_TRL MODIFY (AD_FORM_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_FORM_TRL SET AD_FORM_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_FORM_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_FORM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_HOUSEKEEPING
ALTER TABLE AD_HOUSEKEEPING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_HOUSEKEEPING MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_HOUSEKEEPING SET tmp_col_1_tmp=AD_HOUSEKEEPING_UU,AD_HOUSEKEEPING_UU=NULL,tmp_col_2_tmp=BACKUPFOLDER,BACKUPFOLDER=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL,tmp_col_7_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_HOUSEKEEPING MODIFY (AD_HOUSEKEEPING_UU VARCHAR2(36 CHAR),BACKUPFOLDER VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),WHERECLAUSE VARCHAR2(255 CHAR));
UPDATE AD_HOUSEKEEPING SET AD_HOUSEKEEPING_UU=tmp_col_1_tmp,BACKUPFOLDER=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,VALUE=tmp_col_6_tmp,WHERECLAUSE=tmp_col_7_tmp;
ALTER TABLE AD_HOUSEKEEPING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_HOUSEKEEPING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_IMAGE
ALTER TABLE AD_IMAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_IMAGE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_IMAGE SET tmp_col_1_tmp=AD_IMAGE_UU,AD_IMAGE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_IMAGE MODIFY (AD_IMAGE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_IMAGE SET AD_IMAGE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,IMAGEURL=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_IMAGE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_IMAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_IMPFORMAT
ALTER TABLE AD_IMPFORMAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(1 CHAR));
ALTER TABLE AD_IMPFORMAT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_IMPFORMAT SET tmp_col_1_tmp=AD_IMPFORMAT_UU,AD_IMPFORMAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=SEPARATORCHAR,SEPARATORCHAR=NULL;
ALTER TABLE AD_IMPFORMAT MODIFY (AD_IMPFORMAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),SEPARATORCHAR VARCHAR2(1 CHAR));
UPDATE AD_IMPFORMAT SET AD_IMPFORMAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,SEPARATORCHAR=tmp_col_4_tmp;
ALTER TABLE AD_IMPFORMAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_IMPFORMAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_IMPFORMAT_ROW
ALTER TABLE AD_IMPFORMAT_ROW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_IMPFORMAT_ROW MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_IMPFORMAT_ROW SET tmp_col_1_tmp=AD_IMPFORMAT_ROW_UU,AD_IMPFORMAT_ROW_UU=NULL,tmp_col_2_tmp=CALLOUT,CALLOUT=NULL,tmp_col_3_tmp=CONSTANTVALUE,CONSTANTVALUE=NULL,tmp_col_4_tmp=DATAFORMAT,DATAFORMAT=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=SCRIPT,SCRIPT=NULL;
ALTER TABLE AD_IMPFORMAT_ROW MODIFY (AD_IMPFORMAT_ROW_UU VARCHAR2(36 CHAR),CALLOUT VARCHAR2(60 CHAR),CONSTANTVALUE VARCHAR2(60 CHAR),DATAFORMAT VARCHAR2(20 CHAR),NAME VARCHAR2(60 CHAR),SCRIPT VARCHAR2(2000 CHAR));
UPDATE AD_IMPFORMAT_ROW SET AD_IMPFORMAT_ROW_UU=tmp_col_1_tmp,CALLOUT=tmp_col_2_tmp,CONSTANTVALUE=tmp_col_3_tmp,DATAFORMAT=tmp_col_4_tmp,NAME=tmp_col_5_tmp,SCRIPT=tmp_col_6_tmp;
ALTER TABLE AD_IMPFORMAT_ROW MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_IMPFORMAT_ROW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_INDEXCOLUMN
ALTER TABLE AD_INDEXCOLUMN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE AD_INDEXCOLUMN SET tmp_col_1_tmp=AD_INDEXCOLUMN_UU,AD_INDEXCOLUMN_UU=NULL,tmp_col_2_tmp=COLUMNSQL,COLUMNSQL=NULL;
ALTER TABLE AD_INDEXCOLUMN MODIFY (AD_INDEXCOLUMN_UU VARCHAR2(36 CHAR),COLUMNSQL VARCHAR2(255 CHAR));
UPDATE AD_INDEXCOLUMN SET AD_INDEXCOLUMN_UU=tmp_col_1_tmp,COLUMNSQL=tmp_col_2_tmp;
ALTER TABLE AD_INDEXCOLUMN DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_INFOCOLUMN
ALTER TABLE AD_INFOCOLUMN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(10 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_INFOCOLUMN MODIFY (COLUMNNAME NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL,SELECTCLAUSE NVARCHAR2(2000) NULL);
UPDATE AD_INFOCOLUMN SET tmp_col_1_tmp=AD_INFOCOLUMN_UU,AD_INFOCOLUMN_UU=NULL,tmp_col_2_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_8_tmp=QUERYFUNCTION,QUERYFUNCTION=NULL,tmp_col_9_tmp=QUERYOPERATOR,QUERYOPERATOR=NULL,tmp_col_10_tmp=SELECTCLAUSE,SELECTCLAUSE=NULL;
ALTER TABLE AD_INFOCOLUMN MODIFY (AD_INFOCOLUMN_UU VARCHAR2(36 CHAR),COLUMNNAME VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),QUERYFUNCTION VARCHAR2(255 CHAR),QUERYOPERATOR VARCHAR2(10 CHAR),SELECTCLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_INFOCOLUMN SET AD_INFOCOLUMN_UU=tmp_col_1_tmp,COLUMNNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DISPLAYLOGIC=tmp_col_4_tmp,HELP=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PLACEHOLDER=tmp_col_7_tmp,QUERYFUNCTION=tmp_col_8_tmp,QUERYOPERATOR=tmp_col_9_tmp,SELECTCLAUSE=tmp_col_10_tmp;
ALTER TABLE AD_INFOCOLUMN MODIFY (COLUMNNAME VARCHAR2(30 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,SELECTCLAUSE VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_INFOCOLUMN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_INFOCOLUMN_TRL
ALTER TABLE AD_INFOCOLUMN_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_INFOCOLUMN_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_INFOCOLUMN_TRL SET tmp_col_1_tmp=AD_INFOCOLUMN_TRL_UU,AD_INFOCOLUMN_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PLACEHOLDER,PLACEHOLDER=NULL;
ALTER TABLE AD_INFOCOLUMN_TRL MODIFY (AD_INFOCOLUMN_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR));
UPDATE AD_INFOCOLUMN_TRL SET AD_INFOCOLUMN_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PLACEHOLDER=tmp_col_5_tmp;
ALTER TABLE AD_INFOCOLUMN_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_INFOCOLUMN_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_INFORELATED
ALTER TABLE AD_INFORELATED ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_INFORELATED MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_INFORELATED SET tmp_col_1_tmp=AD_INFORELATED_UU,AD_INFORELATED_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_INFORELATED MODIFY (AD_INFORELATED_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_INFORELATED SET AD_INFORELATED_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_INFORELATED MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_INFORELATED DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_INFOWINDOW
ALTER TABLE AD_INFOWINDOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_INFOWINDOW MODIFY (FROMCLAUSE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_INFOWINDOW SET tmp_col_1_tmp=AD_INFOWINDOW_UU,AD_INFOWINDOW_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FROMCLAUSE,FROMCLAUSE=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=ORDERBYCLAUSE,ORDERBYCLAUSE=NULL,tmp_col_8_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_9_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_INFOWINDOW MODIFY (AD_INFOWINDOW_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FROMCLAUSE VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR),ORDERBYCLAUSE VARCHAR2(2000 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_INFOWINDOW SET AD_INFOWINDOW_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FROMCLAUSE=tmp_col_3_tmp,HELP=tmp_col_4_tmp,IMAGEURL=tmp_col_5_tmp,NAME=tmp_col_6_tmp,ORDERBYCLAUSE=tmp_col_7_tmp,OTHERCLAUSE=tmp_col_8_tmp,WHERECLAUSE=tmp_col_9_tmp;
ALTER TABLE AD_INFOWINDOW MODIFY (FROMCLAUSE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_INFOWINDOW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table AD_INFOWINDOW_ACCESS
ALTER TABLE AD_INFOWINDOW_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_INFOWINDOW_ACCESS SET tmp_col_1_tmp=AD_INFOWINDOW_ACCESS_UU,AD_INFOWINDOW_ACCESS_UU=NULL;
ALTER TABLE AD_INFOWINDOW_ACCESS MODIFY (AD_INFOWINDOW_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_INFOWINDOW_ACCESS SET AD_INFOWINDOW_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_INFOWINDOW_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_INFOWINDOW_TRL
ALTER TABLE AD_INFOWINDOW_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_INFOWINDOW_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_INFOWINDOW_TRL SET tmp_col_1_tmp=AD_INFOWINDOW_TRL_UU,AD_INFOWINDOW_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_INFOWINDOW_TRL MODIFY (AD_INFOWINDOW_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_INFOWINDOW_TRL SET AD_INFOWINDOW_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_INFOWINDOW_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_INFOWINDOW_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_ISSUE
ALTER TABLE AD_ISSUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(120 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(10 CHAR),tmp_col_14_tmp VARCHAR2(60 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(120 CHAR),tmp_col_17_tmp VARCHAR2(30 CHAR),tmp_col_18_tmp VARCHAR2(2000 CHAR),tmp_col_19_tmp VARCHAR2(255 CHAR),tmp_col_20_tmp VARCHAR2(60 CHAR),tmp_col_21_tmp VARCHAR2(2000 CHAR),tmp_col_22_tmp VARCHAR2(255 CHAR),tmp_col_23_tmp VARCHAR2(60 CHAR),tmp_col_24_tmp VARCHAR2(60 CHAR),tmp_col_25_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_ISSUE MODIFY (ISSUESUMMARY NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL,RELEASENO NVARCHAR2(10) NULL,USERNAME NVARCHAR2(60) NULL,VERSION NVARCHAR2(40) NULL);
UPDATE AD_ISSUE SET tmp_col_1_tmp=AD_ISSUE_UU,AD_ISSUE_UU=NULL,tmp_col_2_tmp=COMMENTS,COMMENTS=NULL,tmp_col_3_tmp=DATABASEINFO,DATABASEINFO=NULL,tmp_col_4_tmp=DBADDRESS,DBADDRESS=NULL,tmp_col_5_tmp=ERRORTRACE,ERRORTRACE=NULL,tmp_col_6_tmp=ISSUESUMMARY,ISSUESUMMARY=NULL,tmp_col_7_tmp=JAVAINFO,JAVAINFO=NULL,tmp_col_8_tmp=LOCAL_HOST,LOCAL_HOST=NULL,tmp_col_9_tmp=LOGGERNAME,LOGGERNAME=NULL,tmp_col_10_tmp=NAME,NAME=NULL,tmp_col_11_tmp=OPERATINGSYSTEMINFO,OPERATINGSYSTEMINFO=NULL,tmp_col_12_tmp=PROFILEINFO,PROFILEINFO=NULL,tmp_col_13_tmp=RELEASENO,RELEASENO=NULL,tmp_col_14_tmp=RELEASETAG,RELEASETAG=NULL,tmp_col_15_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_16_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_17_tmp=REQUESTDOCUMENTNO,REQUESTDOCUMENTNO=NULL,tmp_col_18_tmp=RESPONSETEXT,RESPONSETEXT=NULL,tmp_col_19_tmp=SOURCECLASSNAME,SOURCECLASSNAME=NULL,tmp_col_20_tmp=SOURCEMETHODNAME,SOURCEMETHODNAME=NULL,tmp_col_21_tmp=STACKTRACE,STACKTRACE=NULL,tmp_col_22_tmp=STATISTICSINFO,STATISTICSINFO=NULL,tmp_col_23_tmp=SUPPORTEMAIL,SUPPORTEMAIL=NULL,tmp_col_24_tmp=USERNAME,USERNAME=NULL,tmp_col_25_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_ISSUE MODIFY (AD_ISSUE_UU VARCHAR2(36 CHAR),COMMENTS VARCHAR2(2000 CHAR),DATABASEINFO VARCHAR2(255 CHAR),DBADDRESS VARCHAR2(255 CHAR),ERRORTRACE VARCHAR2(2000 CHAR),ISSUESUMMARY VARCHAR2(2000 CHAR) DEFAULT NULL ,JAVAINFO VARCHAR2(255 CHAR),LOCAL_HOST VARCHAR2(120 CHAR),LOGGERNAME VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),OPERATINGSYSTEMINFO VARCHAR2(255 CHAR),PROFILEINFO VARCHAR2(255 CHAR),RELEASENO VARCHAR2(10 CHAR) DEFAULT '.' ,RELEASETAG VARCHAR2(60 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR),REQUESTDOCUMENTNO VARCHAR2(30 CHAR),RESPONSETEXT VARCHAR2(2000 CHAR),SOURCECLASSNAME VARCHAR2(255 CHAR),SOURCEMETHODNAME VARCHAR2(60 CHAR),STACKTRACE VARCHAR2(2000 CHAR),STATISTICSINFO VARCHAR2(255 CHAR),SUPPORTEMAIL VARCHAR2(60 CHAR),USERNAME VARCHAR2(60 CHAR),VERSION VARCHAR2(40 CHAR));
UPDATE AD_ISSUE SET AD_ISSUE_UU=tmp_col_1_tmp,COMMENTS=tmp_col_2_tmp,DATABASEINFO=tmp_col_3_tmp,DBADDRESS=tmp_col_4_tmp,ERRORTRACE=tmp_col_5_tmp,ISSUESUMMARY=tmp_col_6_tmp,JAVAINFO=tmp_col_7_tmp,LOCAL_HOST=tmp_col_8_tmp,LOGGERNAME=tmp_col_9_tmp,NAME=tmp_col_10_tmp,OPERATINGSYSTEMINFO=tmp_col_11_tmp,PROFILEINFO=tmp_col_12_tmp,RELEASENO=tmp_col_13_tmp,RELEASETAG=tmp_col_14_tmp,REMOTE_ADDR=tmp_col_15_tmp,REMOTE_HOST=tmp_col_16_tmp,REQUESTDOCUMENTNO=tmp_col_17_tmp,RESPONSETEXT=tmp_col_18_tmp,SOURCECLASSNAME=tmp_col_19_tmp,SOURCEMETHODNAME=tmp_col_20_tmp,STACKTRACE=tmp_col_21_tmp,STATISTICSINFO=tmp_col_22_tmp,SUPPORTEMAIL=tmp_col_23_tmp,USERNAME=tmp_col_24_tmp,VERSION=tmp_col_25_tmp;
ALTER TABLE AD_ISSUE MODIFY (ISSUESUMMARY VARCHAR2(2000 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,RELEASENO VARCHAR2(10 CHAR) DEFAULT '.'  NOT NULL,USERNAME VARCHAR2(60 CHAR) NOT NULL,VERSION VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_ISSUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp,tmp_col_25_tmp);

-- Processing table AD_LABELPRINTER
ALTER TABLE AD_LABELPRINTER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_LABELPRINTER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_LABELPRINTER SET tmp_col_1_tmp=AD_LABELPRINTER_UU,AD_LABELPRINTER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_LABELPRINTER MODIFY (AD_LABELPRINTER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_LABELPRINTER SET AD_LABELPRINTER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_LABELPRINTER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_LABELPRINTER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_LABELPRINTERFUNCTION
ALTER TABLE AD_LABELPRINTERFUNCTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_LABELPRINTERFUNCTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_LABELPRINTERFUNCTION SET tmp_col_1_tmp=AD_LABELPRINTERFUNCTION_UU,AD_LABELPRINTERFUNCTION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FUNCTIONPREFIX,FUNCTIONPREFIX=NULL,tmp_col_4_tmp=FUNCTIONSUFFIX,FUNCTIONSUFFIX=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=XYSEPARATOR,XYSEPARATOR=NULL;
ALTER TABLE AD_LABELPRINTERFUNCTION MODIFY (AD_LABELPRINTERFUNCTION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FUNCTIONPREFIX VARCHAR2(40 CHAR),FUNCTIONSUFFIX VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR),XYSEPARATOR VARCHAR2(20 CHAR));
UPDATE AD_LABELPRINTERFUNCTION SET AD_LABELPRINTERFUNCTION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FUNCTIONPREFIX=tmp_col_3_tmp,FUNCTIONSUFFIX=tmp_col_4_tmp,NAME=tmp_col_5_tmp,XYSEPARATOR=tmp_col_6_tmp;
ALTER TABLE AD_LABELPRINTERFUNCTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_LABELPRINTERFUNCTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_LANGUAGE
ALTER TABLE AD_LANGUAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_LANGUAGE MODIFY (NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE AD_LANGUAGE SET tmp_col_1_tmp=AD_LANGUAGE_UU,AD_LANGUAGE_UU=NULL,tmp_col_2_tmp=DATEPATTERN,DATEPATTERN=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PRINTNAME,PRINTNAME=NULL,tmp_col_5_tmp=TIMEPATTERN,TIMEPATTERN=NULL;
ALTER TABLE AD_LANGUAGE MODIFY (AD_LANGUAGE_UU VARCHAR2(36 CHAR),DATEPATTERN VARCHAR2(20 CHAR),NAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR) DEFAULT NULL ,TIMEPATTERN VARCHAR2(20 CHAR));
UPDATE AD_LANGUAGE SET AD_LANGUAGE_UU=tmp_col_1_tmp,DATEPATTERN=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PRINTNAME=tmp_col_4_tmp,TIMEPATTERN=tmp_col_5_tmp;
ALTER TABLE AD_LANGUAGE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PRINTNAME VARCHAR2(60 CHAR) DEFAULT NULL	NOT NULL);
ALTER TABLE AD_LANGUAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_LDAPACCESS
ALTER TABLE AD_LDAPACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE AD_LDAPACCESS SET tmp_col_1_tmp=AD_LDAPACCESS_UU,AD_LDAPACCESS_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=SUMMARY,SUMMARY=NULL;
ALTER TABLE AD_LDAPACCESS MODIFY (AD_LDAPACCESS_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),SUMMARY VARCHAR2(2000 CHAR));
UPDATE AD_LDAPACCESS SET AD_LDAPACCESS_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,SUMMARY=tmp_col_3_tmp;
ALTER TABLE AD_LDAPACCESS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_LDAPPROCESSOR
ALTER TABLE AD_LDAPPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_LDAPPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_LDAPPROCESSOR SET tmp_col_1_tmp=AD_LDAPPROCESSOR_UU,AD_LDAPPROCESSOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_LDAPPROCESSOR MODIFY (AD_LDAPPROCESSOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_LDAPPROCESSOR SET AD_LDAPPROCESSOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_LDAPPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_LDAPPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_LDAPPROCESSORLOG
ALTER TABLE AD_LDAPPROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE AD_LDAPPROCESSORLOG SET tmp_col_1_tmp=AD_LDAPPROCESSORLOG_UU,AD_LDAPPROCESSORLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_LDAPPROCESSORLOG MODIFY (AD_LDAPPROCESSORLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_LDAPPROCESSORLOG SET AD_LDAPPROCESSORLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE AD_LDAPPROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_MENU
ALTER TABLE AD_MENU ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_MENU MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_MENU SET tmp_col_1_tmp=AD_MENU_UU,AD_MENU_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_MENU MODIFY (AD_MENU_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_MENU SET AD_MENU_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_MENU MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_MENU DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_MENU_TRL
ALTER TABLE AD_MENU_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_MENU_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_MENU_TRL SET tmp_col_1_tmp=AD_MENU_TRL_UU,AD_MENU_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_MENU_TRL MODIFY (AD_MENU_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_MENU_TRL SET AD_MENU_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_MENU_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_MENU_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_MESSAGE
ALTER TABLE AD_MESSAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_MESSAGE MODIFY (MSGTEXT NVARCHAR2(2000) NULL,VALUE NVARCHAR2(255) NULL);
UPDATE AD_MESSAGE SET tmp_col_1_tmp=AD_MESSAGE_UU,AD_MESSAGE_UU=NULL,tmp_col_2_tmp=MSGTEXT,MSGTEXT=NULL,tmp_col_3_tmp=MSGTIP,MSGTIP=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_MESSAGE MODIFY (AD_MESSAGE_UU VARCHAR2(36 CHAR),MSGTEXT VARCHAR2(2000 CHAR),MSGTIP VARCHAR2(2000 CHAR),VALUE VARCHAR2(255 CHAR));
UPDATE AD_MESSAGE SET AD_MESSAGE_UU=tmp_col_1_tmp,MSGTEXT=tmp_col_2_tmp,MSGTIP=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE AD_MESSAGE MODIFY (MSGTEXT VARCHAR2(2000 CHAR) NOT NULL,VALUE VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE AD_MESSAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_MESSAGE_TRL
ALTER TABLE AD_MESSAGE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_MESSAGE_TRL MODIFY (MSGTEXT NVARCHAR2(2000) NULL);
UPDATE AD_MESSAGE_TRL SET tmp_col_1_tmp=AD_MESSAGE_TRL_UU,AD_MESSAGE_TRL_UU=NULL,tmp_col_2_tmp=MSGTEXT,MSGTEXT=NULL,tmp_col_3_tmp=MSGTIP,MSGTIP=NULL;
ALTER TABLE AD_MESSAGE_TRL MODIFY (AD_MESSAGE_TRL_UU VARCHAR2(36 CHAR),MSGTEXT VARCHAR2(2000 CHAR),MSGTIP VARCHAR2(2000 CHAR));
UPDATE AD_MESSAGE_TRL SET AD_MESSAGE_TRL_UU=tmp_col_1_tmp,MSGTEXT=tmp_col_2_tmp,MSGTIP=tmp_col_3_tmp;
ALTER TABLE AD_MESSAGE_TRL MODIFY (MSGTEXT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_MESSAGE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_MIGRATIONSCRIPT
ALTER TABLE AD_MIGRATIONSCRIPT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(500 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR));
ALTER TABLE AD_MIGRATIONSCRIPT MODIFY (FILENAME NVARCHAR2(500) NULL,RELEASENO NVARCHAR2(10) NULL);
UPDATE AD_MIGRATIONSCRIPT SET tmp_col_1_tmp=AD_MIGRATIONSCRIPT_UU,AD_MIGRATIONSCRIPT_UU=NULL,tmp_col_2_tmp=DEVELOPERNAME,DEVELOPERNAME=NULL,tmp_col_3_tmp=FILENAME,FILENAME=NULL,tmp_col_4_tmp=RELEASENO,RELEASENO=NULL;
ALTER TABLE AD_MIGRATIONSCRIPT MODIFY (AD_MIGRATIONSCRIPT_UU VARCHAR2(36 CHAR),DEVELOPERNAME VARCHAR2(60 CHAR),FILENAME VARCHAR2(500 CHAR),RELEASENO VARCHAR2(10 CHAR) DEFAULT NULL );
UPDATE AD_MIGRATIONSCRIPT SET AD_MIGRATIONSCRIPT_UU=tmp_col_1_tmp,DEVELOPERNAME=tmp_col_2_tmp,FILENAME=tmp_col_3_tmp,RELEASENO=tmp_col_4_tmp;
ALTER TABLE AD_MIGRATIONSCRIPT MODIFY (FILENAME VARCHAR2(500 CHAR) NOT NULL,RELEASENO VARCHAR2(10 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE AD_MIGRATIONSCRIPT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_MODELVALIDATOR
ALTER TABLE AD_MODELVALIDATOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_MODELVALIDATOR MODIFY (MODELVALIDATIONCLASS NVARCHAR2(255) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_MODELVALIDATOR SET tmp_col_1_tmp=AD_MODELVALIDATOR_UU,AD_MODELVALIDATOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=MODELVALIDATIONCLASS,MODELVALIDATIONCLASS=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE AD_MODELVALIDATOR MODIFY (AD_MODELVALIDATOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),MODELVALIDATIONCLASS VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_MODELVALIDATOR SET AD_MODELVALIDATOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,MODELVALIDATIONCLASS=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE AD_MODELVALIDATOR MODIFY (MODELVALIDATIONCLASS VARCHAR2(255 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_MODELVALIDATOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_MODIFICATION
ALTER TABLE AD_MODIFICATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_MODIFICATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_MODIFICATION SET tmp_col_1_tmp=AD_MODIFICATION_UU,AD_MODIFICATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_MODIFICATION MODIFY (AD_MODIFICATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VERSION VARCHAR2(20 CHAR));
UPDATE AD_MODIFICATION SET AD_MODIFICATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VERSION=tmp_col_5_tmp;
ALTER TABLE AD_MODIFICATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_MODIFICATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_NOTE
ALTER TABLE AD_NOTE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
UPDATE AD_NOTE SET tmp_col_1_tmp=AD_NOTE_UU,AD_NOTE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_NOTE MODIFY (AD_NOTE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(255 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_NOTE SET AD_NOTE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,TEXTMSG=tmp_col_4_tmp;
ALTER TABLE AD_NOTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_ORG
ALTER TABLE AD_ORG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_ORG MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_ORG SET tmp_col_1_tmp=AD_ORG_UU,AD_ORG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_ORG MODIFY (AD_ORG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_ORG SET AD_ORG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE AD_ORG MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_ORG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_ORGINFO
ALTER TABLE AD_ORGINFO ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
UPDATE AD_ORGINFO SET tmp_col_1_tmp=AD_ORGINFO_UU,AD_ORGINFO_UU=NULL,tmp_col_2_tmp=EMAIL,EMAIL=NULL,tmp_col_3_tmp=FAX,FAX=NULL,tmp_col_4_tmp=PHONE,PHONE=NULL,tmp_col_5_tmp=PHONE2,PHONE2=NULL;
ALTER TABLE AD_ORGINFO MODIFY (AD_ORGINFO_UU VARCHAR2(36 CHAR),EMAIL VARCHAR2(60 CHAR),FAX VARCHAR2(40 CHAR),PHONE VARCHAR2(40 CHAR),PHONE2 VARCHAR2(40 CHAR));
UPDATE AD_ORGINFO SET AD_ORGINFO_UU=tmp_col_1_tmp,EMAIL=tmp_col_2_tmp,FAX=tmp_col_3_tmp,PHONE=tmp_col_4_tmp,PHONE2=tmp_col_5_tmp;
ALTER TABLE AD_ORGINFO DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_ORGTYPE
ALTER TABLE AD_ORGTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ORGTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ORGTYPE SET tmp_col_1_tmp=AD_ORGTYPE_UU,AD_ORGTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ORGTYPE MODIFY (AD_ORGTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ORGTYPE SET AD_ORGTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_ORGTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ORGTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PACKAGE_EXP
ALTER TABLE AD_PACKAGE_EXP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(1 CHAR),tmp_col_3_tmp VARCHAR2(1000 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(1000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(20 CHAR),tmp_col_10_tmp VARCHAR2(30 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_PACKAGE_EXP MODIFY (NAME NVARCHAR2(60) NULL,PK_VERSION NVARCHAR2(20) NULL);
UPDATE AD_PACKAGE_EXP SET tmp_col_1_tmp=AD_PACKAGE_EXP_UU,AD_PACKAGE_EXP_UU=NULL,tmp_col_2_tmp=AD_PACKAGE_TYPE,AD_PACKAGE_TYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=EMAIL,EMAIL=NULL,tmp_col_5_tmp=FILE_DIRECTORY,FILE_DIRECTORY=NULL,tmp_col_6_tmp=INSTRUCTIONS,INSTRUCTIONS=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=PK_VERSION,PK_VERSION=NULL,tmp_col_9_tmp=RELEASENO,RELEASENO=NULL,tmp_col_10_tmp=USERNAME,USERNAME=NULL,tmp_col_11_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_PACKAGE_EXP MODIFY (AD_PACKAGE_EXP_UU VARCHAR2(36 CHAR),AD_PACKAGE_TYPE VARCHAR2(1 CHAR),DESCRIPTION VARCHAR2(1000 CHAR),EMAIL VARCHAR2(30 CHAR),FILE_DIRECTORY VARCHAR2(255 CHAR),INSTRUCTIONS VARCHAR2(1000 CHAR),NAME VARCHAR2(60 CHAR),PK_VERSION VARCHAR2(20 CHAR),RELEASENO VARCHAR2(20 CHAR),USERNAME VARCHAR2(30 CHAR),VERSION VARCHAR2(20 CHAR));
UPDATE AD_PACKAGE_EXP SET AD_PACKAGE_EXP_UU=tmp_col_1_tmp,AD_PACKAGE_TYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,EMAIL=tmp_col_4_tmp,FILE_DIRECTORY=tmp_col_5_tmp,INSTRUCTIONS=tmp_col_6_tmp,NAME=tmp_col_7_tmp,PK_VERSION=tmp_col_8_tmp,RELEASENO=tmp_col_9_tmp,USERNAME=tmp_col_10_tmp,VERSION=tmp_col_11_tmp;
ALTER TABLE AD_PACKAGE_EXP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PK_VERSION VARCHAR2(20 CHAR) NOT NULL);
ALTER TABLE AD_PACKAGE_EXP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp);

-- Processing table AD_PACKAGE_EXP_COMMON
ALTER TABLE AD_PACKAGE_EXP_COMMON ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(1000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(10 CHAR));
UPDATE AD_PACKAGE_EXP_COMMON SET tmp_col_1_tmp=AD_PACKAGE_EXP_COMMON_UU,AD_PACKAGE_EXP_COMMON_UU=NULL,tmp_col_2_tmp=DBTYPE,DBTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DESTINATION_DIRECTORY,DESTINATION_DIRECTORY=NULL,tmp_col_5_tmp=FILENAME,FILENAME=NULL,tmp_col_6_tmp=FILE_DIRECTORY,FILE_DIRECTORY=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=NAME2,NAME2=NULL,tmp_col_9_tmp=SQLSTATEMENT,SQLSTATEMENT=NULL,tmp_col_10_tmp=TARGET_DIRECTORY,TARGET_DIRECTORY=NULL,tmp_col_11_tmp=TYPE,TYPE=NULL;
ALTER TABLE AD_PACKAGE_EXP_COMMON MODIFY (AD_PACKAGE_EXP_COMMON_UU VARCHAR2(36 CHAR),DBTYPE VARCHAR2(22 CHAR),DESCRIPTION VARCHAR2(1000 CHAR),DESTINATION_DIRECTORY VARCHAR2(255 CHAR),FILENAME VARCHAR2(255 CHAR),FILE_DIRECTORY VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),NAME2 VARCHAR2(60 CHAR),SQLSTATEMENT VARCHAR2(255 CHAR),TARGET_DIRECTORY VARCHAR2(255 CHAR),TYPE VARCHAR2(10 CHAR));
UPDATE AD_PACKAGE_EXP_COMMON SET AD_PACKAGE_EXP_COMMON_UU=tmp_col_1_tmp,DBTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DESTINATION_DIRECTORY=tmp_col_4_tmp,FILENAME=tmp_col_5_tmp,FILE_DIRECTORY=tmp_col_6_tmp,NAME=tmp_col_7_tmp,NAME2=tmp_col_8_tmp,SQLSTATEMENT=tmp_col_9_tmp,TARGET_DIRECTORY=tmp_col_10_tmp,TYPE=tmp_col_11_tmp;
ALTER TABLE AD_PACKAGE_EXP_COMMON DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp);

-- Processing table AD_PACKAGE_EXP_DETAIL
ALTER TABLE AD_PACKAGE_EXP_DETAIL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(22 CHAR),tmp_col_5_tmp VARCHAR2(1000 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(10 CHAR));
ALTER TABLE AD_PACKAGE_EXP_DETAIL MODIFY (TYPE NVARCHAR2(10) NULL);
UPDATE AD_PACKAGE_EXP_DETAIL SET tmp_col_1_tmp=AD_PACKAGE_CODE_NEW,AD_PACKAGE_CODE_NEW=NULL,tmp_col_2_tmp=AD_PACKAGE_CODE_OLD,AD_PACKAGE_CODE_OLD=NULL,tmp_col_3_tmp=AD_PACKAGE_EXP_DETAIL_UU,AD_PACKAGE_EXP_DETAIL_UU=NULL,tmp_col_4_tmp=DBTYPE,DBTYPE=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=DESTINATION_DIRECTORY,DESTINATION_DIRECTORY=NULL,tmp_col_7_tmp=DESTINATION_FILENAME,DESTINATION_FILENAME=NULL,tmp_col_8_tmp=FILENAME,FILENAME=NULL,tmp_col_9_tmp=FILE_DIRECTORY,FILE_DIRECTORY=NULL,tmp_col_10_tmp=NAME2,NAME2=NULL,tmp_col_11_tmp=RELEASENO,RELEASENO=NULL,tmp_col_12_tmp=TARGET_DIRECTORY,TARGET_DIRECTORY=NULL,tmp_col_13_tmp=TYPE,TYPE=NULL;
ALTER TABLE AD_PACKAGE_EXP_DETAIL MODIFY (AD_PACKAGE_CODE_NEW VARCHAR2(2000 CHAR),AD_PACKAGE_CODE_OLD VARCHAR2(2000 CHAR),AD_PACKAGE_EXP_DETAIL_UU VARCHAR2(36 CHAR),DBTYPE VARCHAR2(22 CHAR),DESCRIPTION VARCHAR2(1000 CHAR),DESTINATION_DIRECTORY VARCHAR2(255 CHAR),DESTINATION_FILENAME VARCHAR2(255 CHAR),FILENAME VARCHAR2(255 CHAR),FILE_DIRECTORY VARCHAR2(255 CHAR),NAME2 VARCHAR2(60 CHAR),RELEASENO VARCHAR2(20 CHAR),TARGET_DIRECTORY VARCHAR2(255 CHAR),TYPE VARCHAR2(10 CHAR));
UPDATE AD_PACKAGE_EXP_DETAIL SET AD_PACKAGE_CODE_NEW=tmp_col_1_tmp,AD_PACKAGE_CODE_OLD=tmp_col_2_tmp,AD_PACKAGE_EXP_DETAIL_UU=tmp_col_3_tmp,DBTYPE=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,DESTINATION_DIRECTORY=tmp_col_6_tmp,DESTINATION_FILENAME=tmp_col_7_tmp,FILENAME=tmp_col_8_tmp,FILE_DIRECTORY=tmp_col_9_tmp,NAME2=tmp_col_10_tmp,RELEASENO=tmp_col_11_tmp,TARGET_DIRECTORY=tmp_col_12_tmp,TYPE=tmp_col_13_tmp;
ALTER TABLE AD_PACKAGE_EXP_DETAIL MODIFY (TYPE VARCHAR2(10 CHAR) NOT NULL);
ALTER TABLE AD_PACKAGE_EXP_DETAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table AD_PACKAGE_IMP
ALTER TABLE AD_PACKAGE_IMP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(25 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(1000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(22 CHAR),tmp_col_9_tmp VARCHAR2(20 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(25 CHAR),tmp_col_12_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_PACKAGE_IMP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PACKAGE_IMP SET tmp_col_1_tmp=AD_PACKAGE_IMP_UU,AD_PACKAGE_IMP_UU=NULL,tmp_col_2_tmp=CREATEDDATE,CREATEDDATE=NULL,tmp_col_3_tmp=CREATOR,CREATOR=NULL,tmp_col_4_tmp=CREATORCONTACT,CREATORCONTACT=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=EMAIL,EMAIL=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=PK_STATUS,PK_STATUS=NULL,tmp_col_9_tmp=PK_VERSION,PK_VERSION=NULL,tmp_col_10_tmp=RELEASENO,RELEASENO=NULL,tmp_col_11_tmp=UPDATEDDATE,UPDATEDDATE=NULL,tmp_col_12_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_PACKAGE_IMP MODIFY (AD_PACKAGE_IMP_UU VARCHAR2(36 CHAR),CREATEDDATE VARCHAR2(25 CHAR),CREATOR VARCHAR2(60 CHAR),CREATORCONTACT VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(1000 CHAR),EMAIL VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),PK_STATUS VARCHAR2(22 CHAR),PK_VERSION VARCHAR2(20 CHAR),RELEASENO VARCHAR2(20 CHAR),UPDATEDDATE VARCHAR2(25 CHAR),VERSION VARCHAR2(20 CHAR));
UPDATE AD_PACKAGE_IMP SET AD_PACKAGE_IMP_UU=tmp_col_1_tmp,CREATEDDATE=tmp_col_2_tmp,CREATOR=tmp_col_3_tmp,CREATORCONTACT=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,EMAIL=tmp_col_6_tmp,NAME=tmp_col_7_tmp,PK_STATUS=tmp_col_8_tmp,PK_VERSION=tmp_col_9_tmp,RELEASENO=tmp_col_10_tmp,UPDATEDDATE=tmp_col_11_tmp,VERSION=tmp_col_12_tmp;
ALTER TABLE AD_PACKAGE_IMP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PACKAGE_IMP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp);

-- Processing table AD_PACKAGE_IMP_BACKUP
ALTER TABLE AD_PACKAGE_IMP_BACKUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
UPDATE AD_PACKAGE_IMP_BACKUP SET tmp_col_1_tmp=AD_PACKAGE_IMP_BACKUP_UU,AD_PACKAGE_IMP_BACKUP_UU=NULL,tmp_col_2_tmp=AD_PACKAGE_IMP_BCK_DIR,AD_PACKAGE_IMP_BCK_DIR=NULL,tmp_col_3_tmp=AD_PACKAGE_IMP_ORG_DIR,AD_PACKAGE_IMP_ORG_DIR=NULL,tmp_col_4_tmp=COLVALUE,COLVALUE=NULL;
ALTER TABLE AD_PACKAGE_IMP_BACKUP MODIFY (AD_PACKAGE_IMP_BACKUP_UU VARCHAR2(36 CHAR),AD_PACKAGE_IMP_BCK_DIR VARCHAR2(255 CHAR),AD_PACKAGE_IMP_ORG_DIR VARCHAR2(255 CHAR),COLVALUE VARCHAR2(2000 CHAR));
UPDATE AD_PACKAGE_IMP_BACKUP SET AD_PACKAGE_IMP_BACKUP_UU=tmp_col_1_tmp,AD_PACKAGE_IMP_BCK_DIR=tmp_col_2_tmp,AD_PACKAGE_IMP_ORG_DIR=tmp_col_3_tmp,COLVALUE=tmp_col_4_tmp;
ALTER TABLE AD_PACKAGE_IMP_BACKUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_PACKAGE_IMP_DETAIL
ALTER TABLE AD_PACKAGE_IMP_DETAIL ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
UPDATE AD_PACKAGE_IMP_DETAIL SET tmp_col_1_tmp=ACTION,ACTION=NULL,tmp_col_2_tmp=AD_PACKAGE_IMP_DETAIL_UU,AD_PACKAGE_IMP_DETAIL_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=SUCCESS,SUCCESS=NULL,tmp_col_5_tmp=TABLENAME,TABLENAME=NULL,tmp_col_6_tmp=TYPE,TYPE=NULL;
ALTER TABLE AD_PACKAGE_IMP_DETAIL MODIFY (ACTION VARCHAR2(20 CHAR),AD_PACKAGE_IMP_DETAIL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(2000 CHAR),SUCCESS VARCHAR2(20 CHAR),TABLENAME VARCHAR2(60 CHAR),TYPE VARCHAR2(60 CHAR));
UPDATE AD_PACKAGE_IMP_DETAIL SET ACTION=tmp_col_1_tmp,AD_PACKAGE_IMP_DETAIL_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,SUCCESS=tmp_col_4_tmp,TABLENAME=tmp_col_5_tmp,TYPE=tmp_col_6_tmp;
ALTER TABLE AD_PACKAGE_IMP_DETAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_PACKAGE_IMP_INST
ALTER TABLE AD_PACKAGE_IMP_INST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(50 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(240 CHAR),tmp_col_8_tmp VARCHAR2(44 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(50 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR));
UPDATE AD_PACKAGE_IMP_INST SET tmp_col_1_tmp=AD_PACKAGE_IMP_INST_UU,AD_PACKAGE_IMP_INST_UU=NULL,tmp_col_2_tmp=CREATEDDATE,CREATEDDATE=NULL,tmp_col_3_tmp=CREATOR,CREATOR=NULL,tmp_col_4_tmp=CREATORCONTACT,CREATORCONTACT=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=EMAIL,EMAIL=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=PK_STATUS,PK_STATUS=NULL,tmp_col_9_tmp=PK_VERSION,PK_VERSION=NULL,tmp_col_10_tmp=RELEASENO,RELEASENO=NULL,tmp_col_11_tmp=UPDATEDDATE,UPDATEDDATE=NULL,tmp_col_12_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_PACKAGE_IMP_INST MODIFY (AD_PACKAGE_IMP_INST_UU VARCHAR2(36 CHAR),CREATEDDATE VARCHAR2(50 CHAR),CREATOR VARCHAR2(120 CHAR),CREATORCONTACT VARCHAR2(510 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),EMAIL VARCHAR2(120 CHAR),NAME VARCHAR2(240 CHAR),PK_STATUS VARCHAR2(44 CHAR),PK_VERSION VARCHAR2(40 CHAR),RELEASENO VARCHAR2(40 CHAR),UPDATEDDATE VARCHAR2(50 CHAR),VERSION VARCHAR2(40 CHAR));
UPDATE AD_PACKAGE_IMP_INST SET AD_PACKAGE_IMP_INST_UU=tmp_col_1_tmp,CREATEDDATE=tmp_col_2_tmp,CREATOR=tmp_col_3_tmp,CREATORCONTACT=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,EMAIL=tmp_col_6_tmp,NAME=tmp_col_7_tmp,PK_STATUS=tmp_col_8_tmp,PK_VERSION=tmp_col_9_tmp,RELEASENO=tmp_col_10_tmp,UPDATEDDATE=tmp_col_11_tmp,VERSION=tmp_col_12_tmp;
ALTER TABLE AD_PACKAGE_IMP_INST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp);

-- Processing table AD_PACKAGE_IMP_PROC
ALTER TABLE AD_PACKAGE_IMP_PROC ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_PACKAGE_IMP_PROC MODIFY (AD_PACKAGE_SOURCE_TYPE NVARCHAR2(10) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_PACKAGE_IMP_PROC SET tmp_col_1_tmp=AD_PACKAGE_DIR,AD_PACKAGE_DIR=NULL,tmp_col_2_tmp=AD_PACKAGE_IMP_PROC_UU,AD_PACKAGE_IMP_PROC_UU=NULL,tmp_col_3_tmp=AD_PACKAGE_SOURCE,AD_PACKAGE_SOURCE=NULL,tmp_col_4_tmp=AD_PACKAGE_SOURCE_TYPE,AD_PACKAGE_SOURCE_TYPE=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=P_MSG,P_MSG=NULL;
ALTER TABLE AD_PACKAGE_IMP_PROC MODIFY (AD_PACKAGE_DIR VARCHAR2(255 CHAR),AD_PACKAGE_IMP_PROC_UU VARCHAR2(36 CHAR),AD_PACKAGE_SOURCE VARCHAR2(255 CHAR),AD_PACKAGE_SOURCE_TYPE VARCHAR2(10 CHAR),NAME VARCHAR2(60 CHAR),P_MSG VARCHAR2(2000 CHAR));
UPDATE AD_PACKAGE_IMP_PROC SET AD_PACKAGE_DIR=tmp_col_1_tmp,AD_PACKAGE_IMP_PROC_UU=tmp_col_2_tmp,AD_PACKAGE_SOURCE=tmp_col_3_tmp,AD_PACKAGE_SOURCE_TYPE=tmp_col_4_tmp,NAME=tmp_col_5_tmp,P_MSG=tmp_col_6_tmp;
ALTER TABLE AD_PACKAGE_IMP_PROC MODIFY (AD_PACKAGE_SOURCE_TYPE VARCHAR2(10 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PACKAGE_IMP_PROC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_PACKAGE_UUID_MAP
ALTER TABLE AD_PACKAGE_UUID_MAP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE AD_PACKAGE_UUID_MAP MODIFY (AD_PACKAGE_UUID_MAP_UU NVARCHAR2(36) NULL,SOURCE_UUID NVARCHAR2(36) NULL,TARGET_UUID NVARCHAR2(36) NULL);
UPDATE AD_PACKAGE_UUID_MAP SET tmp_col_1_tmp=AD_PACKAGE_UUID_MAP_UU,AD_PACKAGE_UUID_MAP_UU=NULL,tmp_col_2_tmp=SOURCE_UUID,SOURCE_UUID=NULL,tmp_col_3_tmp=TARGET_UUID,TARGET_UUID=NULL;
ALTER TABLE AD_PACKAGE_UUID_MAP MODIFY (AD_PACKAGE_UUID_MAP_UU VARCHAR2(36 CHAR),SOURCE_UUID VARCHAR2(36 CHAR),TARGET_UUID VARCHAR2(36 CHAR));
UPDATE AD_PACKAGE_UUID_MAP SET AD_PACKAGE_UUID_MAP_UU=tmp_col_1_tmp,SOURCE_UUID=tmp_col_2_tmp,TARGET_UUID=tmp_col_3_tmp;
ALTER TABLE AD_PACKAGE_UUID_MAP MODIFY (AD_PACKAGE_UUID_MAP_UU VARCHAR2(36 CHAR) NOT NULL,SOURCE_UUID VARCHAR2(36 CHAR) NOT NULL,TARGET_UUID VARCHAR2(36 CHAR) NOT NULL);
ALTER TABLE AD_PACKAGE_UUID_MAP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PASSWORDRULE
ALTER TABLE AD_PASSWORDRULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_PASSWORDRULE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PASSWORDRULE SET tmp_col_1_tmp=AD_PASSWORDRULE_UU,AD_PASSWORDRULE_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PATHDICTIONARY,PATHDICTIONARY=NULL;
ALTER TABLE AD_PASSWORDRULE MODIFY (AD_PASSWORDRULE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,PATHDICTIONARY VARCHAR2(255 CHAR));
UPDATE AD_PASSWORDRULE SET AD_PASSWORDRULE_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PATHDICTIONARY=tmp_col_3_tmp;
ALTER TABLE AD_PASSWORDRULE MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE AD_PASSWORDRULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PINSTANCE
ALTER TABLE AD_PINSTANCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
UPDATE AD_PINSTANCE SET tmp_col_1_tmp=AD_PINSTANCE_UU,AD_PINSTANCE_UU=NULL,tmp_col_2_tmp=ERRORMSG,ERRORMSG=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PINSTANCE MODIFY (AD_PINSTANCE_UU VARCHAR2(36 CHAR),ERRORMSG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PINSTANCE SET AD_PINSTANCE_UU=tmp_col_1_tmp,ERRORMSG=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_PINSTANCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PINSTANCE_LOG
ALTER TABLE AD_PINSTANCE_LOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_PINSTANCE_LOG SET tmp_col_1_tmp=AD_PINSTANCE_LOG_UU,AD_PINSTANCE_LOG_UU=NULL,tmp_col_2_tmp=P_MSG,P_MSG=NULL;
ALTER TABLE AD_PINSTANCE_LOG MODIFY (AD_PINSTANCE_LOG_UU VARCHAR2(36 CHAR),P_MSG VARCHAR2(2000 CHAR));
UPDATE AD_PINSTANCE_LOG SET AD_PINSTANCE_LOG_UU=tmp_col_1_tmp,P_MSG=tmp_col_2_tmp;
ALTER TABLE AD_PINSTANCE_LOG DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_PINSTANCE_PARA
ALTER TABLE AD_PINSTANCE_PARA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE AD_PINSTANCE_PARA SET tmp_col_1_tmp=AD_PINSTANCE_PARA_UU,AD_PINSTANCE_PARA_UU=NULL,tmp_col_2_tmp=PARAMETERNAME,PARAMETERNAME=NULL;
ALTER TABLE AD_PINSTANCE_PARA MODIFY (AD_PINSTANCE_PARA_UU VARCHAR2(36 CHAR),PARAMETERNAME VARCHAR2(60 CHAR));
UPDATE AD_PINSTANCE_PARA SET AD_PINSTANCE_PARA_UU=tmp_col_1_tmp,PARAMETERNAME=tmp_col_2_tmp;
ALTER TABLE AD_PINSTANCE_PARA DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_PREFERENCE
ALTER TABLE AD_PREFERENCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PREFERENCE MODIFY (ATTRIBUTE NVARCHAR2(60) NULL,VALUE NVARCHAR2(60) NULL);
UPDATE AD_PREFERENCE SET tmp_col_1_tmp=AD_PREFERENCE_UU,AD_PREFERENCE_UU=NULL,tmp_col_2_tmp=ATTRIBUTE,ATTRIBUTE=NULL,tmp_col_3_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_PREFERENCE MODIFY (AD_PREFERENCE_UU VARCHAR2(36 CHAR),ATTRIBUTE VARCHAR2(60 CHAR),VALUE VARCHAR2(60 CHAR));
UPDATE AD_PREFERENCE SET AD_PREFERENCE_UU=tmp_col_1_tmp,ATTRIBUTE=tmp_col_2_tmp,VALUE=tmp_col_3_tmp;
ALTER TABLE AD_PREFERENCE MODIFY (ATTRIBUTE VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PREFERENCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTCOLOR
ALTER TABLE AD_PRINTCOLOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTCOLOR MODIFY (CODE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTCOLOR SET tmp_col_1_tmp=AD_PRINTCOLOR_UU,AD_PRINTCOLOR_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTCOLOR MODIFY (AD_PRINTCOLOR_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTCOLOR SET AD_PRINTCOLOR_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_PRINTCOLOR MODIFY (CODE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTCOLOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTCOLOR_TRL
ALTER TABLE AD_PRINTCOLOR_TRL ADD (tmp_col_1_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTCOLOR_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTCOLOR_TRL SET tmp_col_1_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTCOLOR_TRL MODIFY (NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTCOLOR_TRL SET NAME=tmp_col_1_tmp;
ALTER TABLE AD_PRINTCOLOR_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTCOLOR_TRL DROP (tmp_col_1_tmp);

-- Processing table AD_PRINTFONT
ALTER TABLE AD_PRINTFONT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTFONT MODIFY (CODE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTFONT SET tmp_col_1_tmp=AD_PRINTFONT_UU,AD_PRINTFONT_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTFONT MODIFY (AD_PRINTFONT_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTFONT SET AD_PRINTFONT_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_PRINTFONT MODIFY (CODE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTFONT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTFORM
ALTER TABLE AD_PRINTFORM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTFORM MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTFORM SET tmp_col_1_tmp=AD_PRINTFORM_UU,AD_PRINTFORM_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTFORM MODIFY (AD_PRINTFORM_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTFORM SET AD_PRINTFORM_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_PRINTFORM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTFORM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTFORMAT
ALTER TABLE AD_PRINTFORMAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_PRINTFORMAT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTFORMAT SET tmp_col_1_tmp=AD_PRINTFORMAT_UU,AD_PRINTFORMAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PRINTERNAME,PRINTERNAME=NULL;
ALTER TABLE AD_PRINTFORMAT MODIFY (AD_PRINTFORMAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PRINTERNAME VARCHAR2(40 CHAR));
UPDATE AD_PRINTFORMAT SET AD_PRINTFORMAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PRINTERNAME=tmp_col_4_tmp;
ALTER TABLE AD_PRINTFORMAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTFORMAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_PRINTFORMATITEM
ALTER TABLE AD_PRINTFORMATITEM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTFORMATITEM MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTFORMATITEM SET tmp_col_1_tmp=AD_PRINTFORMATITEM_UU,AD_PRINTFORMATITEM_UU=NULL,tmp_col_2_tmp=FORMATPATTERN,FORMATPATTERN=NULL,tmp_col_3_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PRINTNAME,PRINTNAME=NULL,tmp_col_6_tmp=PRINTNAMESUFFIX,PRINTNAMESUFFIX=NULL;
ALTER TABLE AD_PRINTFORMATITEM MODIFY (AD_PRINTFORMATITEM_UU VARCHAR2(36 CHAR),FORMATPATTERN VARCHAR2(60 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(2000 CHAR),PRINTNAMESUFFIX VARCHAR2(60 CHAR));
UPDATE AD_PRINTFORMATITEM SET AD_PRINTFORMATITEM_UU=tmp_col_1_tmp,FORMATPATTERN=tmp_col_2_tmp,IMAGEURL=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PRINTNAME=tmp_col_5_tmp,PRINTNAMESUFFIX=tmp_col_6_tmp;
ALTER TABLE AD_PRINTFORMATITEM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTFORMATITEM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_PRINTFORMATITEM_TRL
ALTER TABLE AD_PRINTFORMATITEM_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTFORMATITEM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTFORMATITEM_TRL SET tmp_col_1_tmp=AD_PRINTFORMATITEM_TRL_UU,AD_PRINTFORMATITEM_TRL_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PRINTNAME,PRINTNAME=NULL,tmp_col_4_tmp=PRINTNAMESUFFIX,PRINTNAMESUFFIX=NULL;
ALTER TABLE AD_PRINTFORMATITEM_TRL MODIFY (AD_PRINTFORMATITEM_TRL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,PRINTNAME VARCHAR2(2000 CHAR),PRINTNAMESUFFIX VARCHAR2(60 CHAR));
UPDATE AD_PRINTFORMATITEM_TRL SET AD_PRINTFORMATITEM_TRL_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PRINTNAME=tmp_col_3_tmp,PRINTNAMESUFFIX=tmp_col_4_tmp;
ALTER TABLE AD_PRINTFORMATITEM_TRL MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE AD_PRINTFORMATITEM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_PRINTGRAPH
ALTER TABLE AD_PRINTGRAPH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTGRAPH MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTGRAPH SET tmp_col_1_tmp=AD_PRINTGRAPH_UU,AD_PRINTGRAPH_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTGRAPH MODIFY (AD_PRINTGRAPH_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTGRAPH SET AD_PRINTGRAPH_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_PRINTGRAPH MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTGRAPH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTLABEL
ALTER TABLE AD_PRINTLABEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_PRINTLABEL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTLABEL SET tmp_col_1_tmp=AD_PRINTLABEL_UU,AD_PRINTLABEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PRINTERNAME,PRINTERNAME=NULL;
ALTER TABLE AD_PRINTLABEL MODIFY (AD_PRINTLABEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PRINTERNAME VARCHAR2(40 CHAR));
UPDATE AD_PRINTLABEL SET AD_PRINTLABEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PRINTERNAME=tmp_col_4_tmp;
ALTER TABLE AD_PRINTLABEL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTLABEL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_PRINTLABELLINE
ALTER TABLE AD_PRINTLABELLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTLABELLINE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTLABELLINE SET tmp_col_1_tmp=AD_PRINTLABELLINE_UU,AD_PRINTLABELLINE_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE AD_PRINTLABELLINE MODIFY (AD_PRINTLABELLINE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTLABELLINE SET AD_PRINTLABELLINE_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PRINTNAME=tmp_col_3_tmp;
ALTER TABLE AD_PRINTLABELLINE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTLABELLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_PRINTLABELLINE_TRL
ALTER TABLE AD_PRINTLABELLINE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE AD_PRINTLABELLINE_TRL SET tmp_col_1_tmp=AD_PRINTLABELLINE_TRL_UU,AD_PRINTLABELLINE_TRL_UU=NULL,tmp_col_2_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE AD_PRINTLABELLINE_TRL MODIFY (AD_PRINTLABELLINE_TRL_UU VARCHAR2(36 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTLABELLINE_TRL SET AD_PRINTLABELLINE_TRL_UU=tmp_col_1_tmp,PRINTNAME=tmp_col_2_tmp;
ALTER TABLE AD_PRINTLABELLINE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_PRINTPAPER
ALTER TABLE AD_PRINTPAPER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTPAPER MODIFY (CODE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTPAPER SET tmp_col_1_tmp=AD_PRINTPAPER_UU,AD_PRINTPAPER_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTPAPER MODIFY (AD_PRINTPAPER_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTPAPER SET AD_PRINTPAPER_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_PRINTPAPER MODIFY (CODE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTPAPER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_PRINTTABLEFORMAT
ALTER TABLE AD_PRINTTABLEFORMAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(120 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PRINTTABLEFORMAT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PRINTTABLEFORMAT SET tmp_col_1_tmp=AD_PRINTTABLEFORMAT_UU,AD_PRINTTABLEFORMAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FOOTERCENTER,FOOTERCENTER=NULL,tmp_col_4_tmp=FOOTERLEFT,FOOTERLEFT=NULL,tmp_col_5_tmp=FOOTERRIGHT,FOOTERRIGHT=NULL,tmp_col_6_tmp=HEADERCENTER,HEADERCENTER=NULL,tmp_col_7_tmp=HEADERLEFT,HEADERLEFT=NULL,tmp_col_8_tmp=HEADERRIGHT,HEADERRIGHT=NULL,tmp_col_9_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_10_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PRINTTABLEFORMAT MODIFY (AD_PRINTTABLEFORMAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FOOTERCENTER VARCHAR2(255 CHAR),FOOTERLEFT VARCHAR2(255 CHAR),FOOTERRIGHT VARCHAR2(255 CHAR),HEADERCENTER VARCHAR2(255 CHAR),HEADERLEFT VARCHAR2(255 CHAR),HEADERRIGHT VARCHAR2(255 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PRINTTABLEFORMAT SET AD_PRINTTABLEFORMAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FOOTERCENTER=tmp_col_3_tmp,FOOTERLEFT=tmp_col_4_tmp,FOOTERRIGHT=tmp_col_5_tmp,HEADERCENTER=tmp_col_6_tmp,HEADERLEFT=tmp_col_7_tmp,HEADERRIGHT=tmp_col_8_tmp,IMAGEURL=tmp_col_9_tmp,NAME=tmp_col_10_tmp;
ALTER TABLE AD_PRINTTABLEFORMAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PRINTTABLEFORMAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_PRIVATE_ACCESS
ALTER TABLE AD_PRIVATE_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_PRIVATE_ACCESS SET tmp_col_1_tmp=AD_PRIVATE_ACCESS_UU,AD_PRIVATE_ACCESS_UU=NULL;
ALTER TABLE AD_PRIVATE_ACCESS MODIFY (AD_PRIVATE_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_PRIVATE_ACCESS SET AD_PRIVATE_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_PRIVATE_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_PROCESS
ALTER TABLE AD_PROCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_PROCESS MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_PROCESS SET tmp_col_1_tmp=AD_PROCESS_UU,AD_PROCESS_UU=NULL,tmp_col_2_tmp=CLASSNAME,CLASSNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=JASPERREPORT,JASPERREPORT=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PROCEDURENAME,PROCEDURENAME=NULL,tmp_col_8_tmp=VALUE,VALUE=NULL,tmp_col_9_tmp=WORKFLOWVALUE,WORKFLOWVALUE=NULL;
ALTER TABLE AD_PROCESS MODIFY (AD_PROCESS_UU VARCHAR2(36 CHAR),CLASSNAME VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),JASPERREPORT VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PROCEDURENAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),WORKFLOWVALUE VARCHAR2(40 CHAR));
UPDATE AD_PROCESS SET AD_PROCESS_UU=tmp_col_1_tmp,CLASSNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,JASPERREPORT=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PROCEDURENAME=tmp_col_7_tmp,VALUE=tmp_col_8_tmp,WORKFLOWVALUE=tmp_col_9_tmp;
ALTER TABLE AD_PROCESS MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_PROCESS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table AD_PROCESS_ACCESS
ALTER TABLE AD_PROCESS_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_PROCESS_ACCESS SET tmp_col_1_tmp=AD_PROCESS_ACCESS_UU,AD_PROCESS_ACCESS_UU=NULL;
ALTER TABLE AD_PROCESS_ACCESS MODIFY (AD_PROCESS_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_PROCESS_ACCESS SET AD_PROCESS_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_PROCESS_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_PROCESS_PARA
ALTER TABLE AD_PROCESS_PARA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(2000 CHAR),tmp_col_12_tmp VARCHAR2(20 CHAR),tmp_col_13_tmp VARCHAR2(20 CHAR),tmp_col_14_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_PROCESS_PARA MODIFY (COLUMNNAME NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_PROCESS_PARA SET tmp_col_1_tmp=AD_PROCESS_PARA_UU,AD_PROCESS_PARA_UU=NULL,tmp_col_2_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_3_tmp=DEFAULTVALUE,DEFAULTVALUE=NULL,tmp_col_4_tmp=DEFAULTVALUE2,DEFAULTVALUE2=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_7_tmp=HELP,HELP=NULL,tmp_col_8_tmp=NAME,NAME=NULL,tmp_col_9_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_10_tmp=PLACEHOLDER2,PLACEHOLDER2=NULL,tmp_col_11_tmp=READONLYLOGIC,READONLYLOGIC=NULL,tmp_col_12_tmp=VALUEMAX,VALUEMAX=NULL,tmp_col_13_tmp=VALUEMIN,VALUEMIN=NULL,tmp_col_14_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_PROCESS_PARA MODIFY (AD_PROCESS_PARA_UU VARCHAR2(36 CHAR),COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL ,DEFAULTVALUE VARCHAR2(2000 CHAR),DEFAULTVALUE2 VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),PLACEHOLDER2 VARCHAR2(255 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),VALUEMAX VARCHAR2(20 CHAR),VALUEMIN VARCHAR2(20 CHAR),VFORMAT VARCHAR2(255 CHAR));
UPDATE AD_PROCESS_PARA SET AD_PROCESS_PARA_UU=tmp_col_1_tmp,COLUMNNAME=tmp_col_2_tmp,DEFAULTVALUE=tmp_col_3_tmp,DEFAULTVALUE2=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,DISPLAYLOGIC=tmp_col_6_tmp,HELP=tmp_col_7_tmp,NAME=tmp_col_8_tmp,PLACEHOLDER=tmp_col_9_tmp,PLACEHOLDER2=tmp_col_10_tmp,READONLYLOGIC=tmp_col_11_tmp,VALUEMAX=tmp_col_12_tmp,VALUEMIN=tmp_col_13_tmp,VFORMAT=tmp_col_14_tmp;
ALTER TABLE AD_PROCESS_PARA MODIFY (COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PROCESS_PARA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp);

-- Processing table AD_PROCESS_PARA_TRL
ALTER TABLE AD_PROCESS_PARA_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_PROCESS_PARA_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PROCESS_PARA_TRL SET tmp_col_1_tmp=AD_PROCESS_PARA_TRL_UU,AD_PROCESS_PARA_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_6_tmp=PLACEHOLDER2,PLACEHOLDER2=NULL;
ALTER TABLE AD_PROCESS_PARA_TRL MODIFY (AD_PROCESS_PARA_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),PLACEHOLDER2 VARCHAR2(255 CHAR));
UPDATE AD_PROCESS_PARA_TRL SET AD_PROCESS_PARA_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PLACEHOLDER=tmp_col_5_tmp,PLACEHOLDER2=tmp_col_6_tmp;
ALTER TABLE AD_PROCESS_PARA_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PROCESS_PARA_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_PROCESS_TRL
ALTER TABLE AD_PROCESS_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_PROCESS_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_PROCESS_TRL SET tmp_col_1_tmp=AD_PROCESS_TRL_UU,AD_PROCESS_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_PROCESS_TRL MODIFY (AD_PROCESS_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_PROCESS_TRL SET AD_PROCESS_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_PROCESS_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_PROCESS_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_RECENTITEM
ALTER TABLE AD_RECENTITEM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_RECENTITEM SET tmp_col_1_tmp=AD_RECENTITEM_UU,AD_RECENTITEM_UU=NULL;
ALTER TABLE AD_RECENTITEM MODIFY (AD_RECENTITEM_UU VARCHAR2(36 CHAR));
UPDATE AD_RECENTITEM SET AD_RECENTITEM_UU=tmp_col_1_tmp;
ALTER TABLE AD_RECENTITEM DROP (tmp_col_1_tmp);

-- Processing table AD_RECORD_ACCESS
ALTER TABLE AD_RECORD_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_RECORD_ACCESS SET tmp_col_1_tmp=AD_RECORD_ACCESS_UU,AD_RECORD_ACCESS_UU=NULL;
ALTER TABLE AD_RECORD_ACCESS MODIFY (AD_RECORD_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_RECORD_ACCESS SET AD_RECORD_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_RECORD_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_REFERENCE
ALTER TABLE AD_REFERENCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_REFERENCE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REFERENCE SET tmp_col_1_tmp=AD_REFERENCE_UU,AD_REFERENCE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_REFERENCE MODIFY (AD_REFERENCE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VFORMAT VARCHAR2(40 CHAR));
UPDATE AD_REFERENCE SET AD_REFERENCE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VFORMAT=tmp_col_5_tmp;
ALTER TABLE AD_REFERENCE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REFERENCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_REFERENCE_TRL
ALTER TABLE AD_REFERENCE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_REFERENCE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REFERENCE_TRL SET tmp_col_1_tmp=AD_REFERENCE_TRL_UU,AD_REFERENCE_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_REFERENCE_TRL MODIFY (AD_REFERENCE_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_REFERENCE_TRL SET AD_REFERENCE_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_REFERENCE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REFERENCE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_REF_LIST
ALTER TABLE AD_REF_LIST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_REF_LIST MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(60) NULL);
UPDATE AD_REF_LIST SET tmp_col_1_tmp=AD_REF_LIST_UU,AD_REF_LIST_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_REF_LIST MODIFY (AD_REF_LIST_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(60 CHAR));
UPDATE AD_REF_LIST SET AD_REF_LIST_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE AD_REF_LIST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REF_LIST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_REF_LIST_TRL
ALTER TABLE AD_REF_LIST_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_REF_LIST_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REF_LIST_TRL SET tmp_col_1_tmp=AD_REF_LIST_TRL_UU,AD_REF_LIST_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_REF_LIST_TRL MODIFY (AD_REF_LIST_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_REF_LIST_TRL SET AD_REF_LIST_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_REF_LIST_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REF_LIST_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_REF_TABLE
ALTER TABLE AD_REF_TABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE AD_REF_TABLE SET tmp_col_1_tmp=AD_REF_TABLE_UU,AD_REF_TABLE_UU=NULL,tmp_col_2_tmp=ORDERBYCLAUSE,ORDERBYCLAUSE=NULL,tmp_col_3_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_REF_TABLE MODIFY (AD_REF_TABLE_UU VARCHAR2(36 CHAR),ORDERBYCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_REF_TABLE SET AD_REF_TABLE_UU=tmp_col_1_tmp,ORDERBYCLAUSE=tmp_col_2_tmp,WHERECLAUSE=tmp_col_3_tmp;
ALTER TABLE AD_REF_TABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_REGISTRATION
ALTER TABLE AD_REGISTRATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR));
UPDATE AD_REGISTRATION SET tmp_col_1_tmp=AD_REGISTRATION_UU,AD_REGISTRATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=INDUSTRYINFO,INDUSTRYINFO=NULL,tmp_col_4_tmp=PLATFORMINFO,PLATFORMINFO=NULL,tmp_col_5_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_6_tmp=REMOTE_HOST,REMOTE_HOST=NULL;
ALTER TABLE AD_REGISTRATION MODIFY (AD_REGISTRATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),INDUSTRYINFO VARCHAR2(255 CHAR),PLATFORMINFO VARCHAR2(255 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR));
UPDATE AD_REGISTRATION SET AD_REGISTRATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,INDUSTRYINFO=tmp_col_3_tmp,PLATFORMINFO=tmp_col_4_tmp,REMOTE_ADDR=tmp_col_5_tmp,REMOTE_HOST=tmp_col_6_tmp;
ALTER TABLE AD_REGISTRATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_RELATIONTYPE
ALTER TABLE AD_RELATIONTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(50 CHAR),tmp_col_5_tmp VARCHAR2(50 CHAR));
ALTER TABLE AD_RELATIONTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_RELATIONTYPE SET tmp_col_1_tmp=AD_RELATIONTYPE_UU,AD_RELATIONTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=ROLE_SOURCE,ROLE_SOURCE=NULL,tmp_col_5_tmp=ROLE_TARGET,ROLE_TARGET=NULL;
ALTER TABLE AD_RELATIONTYPE MODIFY (AD_RELATIONTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),ROLE_SOURCE VARCHAR2(50 CHAR),ROLE_TARGET VARCHAR2(50 CHAR));
UPDATE AD_RELATIONTYPE SET AD_RELATIONTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,ROLE_SOURCE=tmp_col_4_tmp,ROLE_TARGET=tmp_col_5_tmp;
ALTER TABLE AD_RELATIONTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_RELATIONTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_REPLICATION
ALTER TABLE AD_REPLICATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(10 CHAR));
ALTER TABLE AD_REPLICATION MODIFY (HOSTADDRESS NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_REPLICATION SET tmp_col_1_tmp=AD_REPLICATION_UU,AD_REPLICATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=HOSTADDRESS,HOSTADDRESS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PREFIX,PREFIX=NULL,tmp_col_7_tmp=SUFFIX,SUFFIX=NULL;
ALTER TABLE AD_REPLICATION MODIFY (AD_REPLICATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),HOSTADDRESS VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),PREFIX VARCHAR2(10 CHAR),SUFFIX VARCHAR2(10 CHAR));
UPDATE AD_REPLICATION SET AD_REPLICATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,HOSTADDRESS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PREFIX=tmp_col_6_tmp,SUFFIX=tmp_col_7_tmp;
ALTER TABLE AD_REPLICATION MODIFY (HOSTADDRESS VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REPLICATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_REPLICATIONDOCUMENT
ALTER TABLE AD_REPLICATIONDOCUMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE AD_REPLICATIONDOCUMENT SET tmp_col_1_tmp=AD_REPLICATIONDOCUMENT_UU,AD_REPLICATIONDOCUMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE AD_REPLICATIONDOCUMENT MODIFY (AD_REPLICATIONDOCUMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE AD_REPLICATIONDOCUMENT SET AD_REPLICATIONDOCUMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE AD_REPLICATIONDOCUMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_REPLICATIONSTRATEGY
ALTER TABLE AD_REPLICATIONSTRATEGY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_REPLICATIONSTRATEGY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REPLICATIONSTRATEGY SET tmp_col_1_tmp=AD_REPLICATIONSTRATEGY_UU,AD_REPLICATIONSTRATEGY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_REPLICATIONSTRATEGY MODIFY (AD_REPLICATIONSTRATEGY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_REPLICATIONSTRATEGY SET AD_REPLICATIONSTRATEGY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE AD_REPLICATIONSTRATEGY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REPLICATIONSTRATEGY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_REPLICATIONTABLE
ALTER TABLE AD_REPLICATIONTABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE AD_REPLICATIONTABLE SET tmp_col_1_tmp=AD_REPLICATIONTABLE_UU,AD_REPLICATIONTABLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE AD_REPLICATIONTABLE MODIFY (AD_REPLICATIONTABLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE AD_REPLICATIONTABLE SET AD_REPLICATIONTABLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE AD_REPLICATIONTABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_REPLICATION_LOG
ALTER TABLE AD_REPLICATION_LOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_REPLICATION_LOG SET tmp_col_1_tmp=AD_REPLICATION_LOG_UU,AD_REPLICATION_LOG_UU=NULL,tmp_col_2_tmp=P_MSG,P_MSG=NULL;
ALTER TABLE AD_REPLICATION_LOG MODIFY (AD_REPLICATION_LOG_UU VARCHAR2(36 CHAR),P_MSG VARCHAR2(2000 CHAR));
UPDATE AD_REPLICATION_LOG SET AD_REPLICATION_LOG_UU=tmp_col_1_tmp,P_MSG=tmp_col_2_tmp;
ALTER TABLE AD_REPLICATION_LOG DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_REPLICATION_RUN
ALTER TABLE AD_REPLICATION_RUN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_REPLICATION_RUN MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REPLICATION_RUN SET tmp_col_1_tmp=AD_REPLICATION_RUN_UU,AD_REPLICATION_RUN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_REPLICATION_RUN MODIFY (AD_REPLICATION_RUN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_REPLICATION_RUN SET AD_REPLICATION_RUN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_REPLICATION_RUN MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REPLICATION_RUN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_REPORTVIEW
ALTER TABLE AD_REPORTVIEW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_REPORTVIEW MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_REPORTVIEW SET tmp_col_1_tmp=AD_REPORTVIEW_UU,AD_REPORTVIEW_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=ORDERBYCLAUSE,ORDERBYCLAUSE=NULL,tmp_col_5_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_REPORTVIEW MODIFY (AD_REPORTVIEW_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),ORDERBYCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_REPORTVIEW SET AD_REPORTVIEW_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,ORDERBYCLAUSE=tmp_col_4_tmp,WHERECLAUSE=tmp_col_5_tmp;
ALTER TABLE AD_REPORTVIEW MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REPORTVIEW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_REPORTVIEW_COL
ALTER TABLE AD_REPORTVIEW_COL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_REPORTVIEW_COL MODIFY (FUNCTIONCOLUMN NVARCHAR2(60) NULL);
UPDATE AD_REPORTVIEW_COL SET tmp_col_1_tmp=AD_REPORTVIEW_COL_UU,AD_REPORTVIEW_COL_UU=NULL,tmp_col_2_tmp=FUNCTIONCOLUMN,FUNCTIONCOLUMN=NULL;
ALTER TABLE AD_REPORTVIEW_COL MODIFY (AD_REPORTVIEW_COL_UU VARCHAR2(36 CHAR),FUNCTIONCOLUMN VARCHAR2(60 CHAR));
UPDATE AD_REPORTVIEW_COL SET AD_REPORTVIEW_COL_UU=tmp_col_1_tmp,FUNCTIONCOLUMN=tmp_col_2_tmp;
ALTER TABLE AD_REPORTVIEW_COL MODIFY (FUNCTIONCOLUMN VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_REPORTVIEW_COL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_ROLE
ALTER TABLE AD_ROLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_ROLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ROLE SET tmp_col_1_tmp=AD_ROLE_UU,AD_ROLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_ROLE MODIFY (AD_ROLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_ROLE SET AD_ROLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_ROLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ROLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_ROLE_INCLUDED
ALTER TABLE AD_ROLE_INCLUDED ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_ROLE_INCLUDED SET tmp_col_1_tmp=AD_ROLE_INCLUDED_UU,AD_ROLE_INCLUDED_UU=NULL;
ALTER TABLE AD_ROLE_INCLUDED MODIFY (AD_ROLE_INCLUDED_UU VARCHAR2(36 CHAR));
UPDATE AD_ROLE_INCLUDED SET AD_ROLE_INCLUDED_UU=tmp_col_1_tmp;
ALTER TABLE AD_ROLE_INCLUDED DROP (tmp_col_1_tmp);

-- Processing table AD_ROLE_ORGACCESS
ALTER TABLE AD_ROLE_ORGACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_ROLE_ORGACCESS SET tmp_col_1_tmp=AD_ROLE_ORGACCESS_UU,AD_ROLE_ORGACCESS_UU=NULL;
ALTER TABLE AD_ROLE_ORGACCESS MODIFY (AD_ROLE_ORGACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_ROLE_ORGACCESS SET AD_ROLE_ORGACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_ROLE_ORGACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_RULE
ALTER TABLE AD_RULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_RULE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_RULE SET tmp_col_1_tmp=AD_RULE_UU,AD_RULE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=SCRIPT,SCRIPT=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_RULE MODIFY (AD_RULE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),SCRIPT VARCHAR2(2000 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_RULE SET AD_RULE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,SCRIPT=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE AD_RULE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_RULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_SCHEDULE
ALTER TABLE AD_SCHEDULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(225 CHAR),tmp_col_4_tmp VARCHAR2(1 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_SCHEDULE MODIFY (ISACTIVE NVARCHAR2(1) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_SCHEDULE SET tmp_col_1_tmp=AD_SCHEDULE_UU,AD_SCHEDULE_UU=NULL,tmp_col_2_tmp=CRONPATTERN,CRONPATTERN=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=ISACTIVE,ISACTIVE=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=RUNONLYONIP,RUNONLYONIP=NULL;
ALTER TABLE AD_SCHEDULE MODIFY (AD_SCHEDULE_UU VARCHAR2(36 CHAR),CRONPATTERN VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(225 CHAR),ISACTIVE VARCHAR2(1 CHAR) DEFAULT 'Y' ,NAME VARCHAR2(60 CHAR) DEFAULT NULL ,RUNONLYONIP VARCHAR2(60 CHAR));
UPDATE AD_SCHEDULE SET AD_SCHEDULE_UU=tmp_col_1_tmp,CRONPATTERN=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,ISACTIVE=tmp_col_4_tmp,NAME=tmp_col_5_tmp,RUNONLYONIP=tmp_col_6_tmp;
ALTER TABLE AD_SCHEDULE MODIFY (ISACTIVE VARCHAR2(1 CHAR) DEFAULT 'Y'  NOT NULL,NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE AD_SCHEDULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_SCHEDULER
ALTER TABLE AD_SCHEDULER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_SCHEDULER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_SCHEDULER SET tmp_col_1_tmp=AD_SCHEDULER_UU,AD_SCHEDULER_UU=NULL,tmp_col_2_tmp=CRONPATTERN,CRONPATTERN=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_SCHEDULER MODIFY (AD_SCHEDULER_UU VARCHAR2(36 CHAR),CRONPATTERN VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_SCHEDULER SET AD_SCHEDULER_UU=tmp_col_1_tmp,CRONPATTERN=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_SCHEDULER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_SCHEDULER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_SCHEDULERLOG
ALTER TABLE AD_SCHEDULERLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE AD_SCHEDULERLOG SET tmp_col_1_tmp=AD_SCHEDULERLOG_UU,AD_SCHEDULERLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_SCHEDULERLOG MODIFY (AD_SCHEDULERLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_SCHEDULERLOG SET AD_SCHEDULERLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE AD_SCHEDULERLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_SCHEDULERRECIPIENT
ALTER TABLE AD_SCHEDULERRECIPIENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_SCHEDULERRECIPIENT SET tmp_col_1_tmp=AD_SCHEDULERRECIPIENT_UU,AD_SCHEDULERRECIPIENT_UU=NULL;
ALTER TABLE AD_SCHEDULERRECIPIENT MODIFY (AD_SCHEDULERRECIPIENT_UU VARCHAR2(36 CHAR));
UPDATE AD_SCHEDULERRECIPIENT SET AD_SCHEDULERRECIPIENT_UU=tmp_col_1_tmp;
ALTER TABLE AD_SCHEDULERRECIPIENT DROP (tmp_col_1_tmp);

-- Processing table AD_SCHEDULER_PARA
ALTER TABLE AD_SCHEDULER_PARA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE AD_SCHEDULER_PARA SET tmp_col_1_tmp=AD_SCHEDULER_PARA_UU,AD_SCHEDULER_PARA_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=PARAMETERDEFAULT,PARAMETERDEFAULT=NULL,tmp_col_4_tmp=PARAMETERTODEFAULT,PARAMETERTODEFAULT=NULL;
ALTER TABLE AD_SCHEDULER_PARA MODIFY (AD_SCHEDULER_PARA_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),PARAMETERDEFAULT VARCHAR2(255 CHAR),PARAMETERTODEFAULT VARCHAR2(255 CHAR));
UPDATE AD_SCHEDULER_PARA SET AD_SCHEDULER_PARA_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,PARAMETERDEFAULT=tmp_col_3_tmp,PARAMETERTODEFAULT=tmp_col_4_tmp;
ALTER TABLE AD_SCHEDULER_PARA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_SEARCHDEFINITION
ALTER TABLE AD_SEARCHDEFINITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(1 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(1 CHAR),tmp_col_7_tmp VARCHAR2(8 CHAR));
ALTER TABLE AD_SEARCHDEFINITION MODIFY (DATATYPE NVARCHAR2(1) NULL,SEARCHTYPE NVARCHAR2(1) NULL);
UPDATE AD_SEARCHDEFINITION SET tmp_col_1_tmp=AD_SEARCHDEFINITION_UU,AD_SEARCHDEFINITION_UU=NULL,tmp_col_2_tmp=DATATYPE,DATATYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=QUERY,QUERY=NULL,tmp_col_6_tmp=SEARCHTYPE,SEARCHTYPE=NULL,tmp_col_7_tmp=TRANSACTIONCODE,TRANSACTIONCODE=NULL;
ALTER TABLE AD_SEARCHDEFINITION MODIFY (AD_SEARCHDEFINITION_UU VARCHAR2(36 CHAR),DATATYPE VARCHAR2(1 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),QUERY VARCHAR2(2000 CHAR),SEARCHTYPE VARCHAR2(1 CHAR),TRANSACTIONCODE VARCHAR2(8 CHAR));
UPDATE AD_SEARCHDEFINITION SET AD_SEARCHDEFINITION_UU=tmp_col_1_tmp,DATATYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,QUERY=tmp_col_5_tmp,SEARCHTYPE=tmp_col_6_tmp,TRANSACTIONCODE=tmp_col_7_tmp;
ALTER TABLE AD_SEARCHDEFINITION MODIFY (DATATYPE VARCHAR2(1 CHAR) NOT NULL,SEARCHTYPE VARCHAR2(1 CHAR) NOT NULL);
ALTER TABLE AD_SEARCHDEFINITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_SEQUENCE
ALTER TABLE AD_SEQUENCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR));
UPDATE AD_SEQUENCE SET tmp_col_1_tmp=AD_SEQUENCE_UU,AD_SEQUENCE_UU=NULL,tmp_col_2_tmp=DATECOLUMN,DATECOLUMN=NULL,tmp_col_3_tmp=DECIMALPATTERN,DECIMALPATTERN=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=ORGCOLUMN,ORGCOLUMN=NULL,tmp_col_6_tmp=PREFIX,PREFIX=NULL,tmp_col_7_tmp=SUFFIX,SUFFIX=NULL,tmp_col_8_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_SEQUENCE MODIFY (AD_SEQUENCE_UU VARCHAR2(36 CHAR),DATECOLUMN VARCHAR2(60 CHAR),DECIMALPATTERN VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ORGCOLUMN VARCHAR2(60 CHAR),PREFIX VARCHAR2(255 CHAR),SUFFIX VARCHAR2(255 CHAR),VFORMAT VARCHAR2(40 CHAR));
UPDATE AD_SEQUENCE SET AD_SEQUENCE_UU=tmp_col_1_tmp,DATECOLUMN=tmp_col_2_tmp,DECIMALPATTERN=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,ORGCOLUMN=tmp_col_5_tmp,PREFIX=tmp_col_6_tmp,SUFFIX=tmp_col_7_tmp,VFORMAT=tmp_col_8_tmp;
ALTER TABLE AD_SEQUENCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table AD_SEQUENCE_AUDIT
ALTER TABLE AD_SEQUENCE_AUDIT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR));
ALTER TABLE AD_SEQUENCE_AUDIT MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE AD_SEQUENCE_AUDIT SET tmp_col_1_tmp=AD_SEQUENCE_AUDIT_UU,AD_SEQUENCE_AUDIT_UU=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE AD_SEQUENCE_AUDIT MODIFY (AD_SEQUENCE_AUDIT_UU VARCHAR2(36 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE AD_SEQUENCE_AUDIT SET AD_SEQUENCE_AUDIT_UU=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp;
ALTER TABLE AD_SEQUENCE_AUDIT MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE AD_SEQUENCE_AUDIT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_SEQUENCE_NO
ALTER TABLE AD_SEQUENCE_NO ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_SEQUENCE_NO SET tmp_col_1_tmp=AD_SEQUENCE_NO_UU,AD_SEQUENCE_NO_UU=NULL;
ALTER TABLE AD_SEQUENCE_NO MODIFY (AD_SEQUENCE_NO_UU VARCHAR2(36 CHAR));
UPDATE AD_SEQUENCE_NO SET AD_SEQUENCE_NO_UU=tmp_col_1_tmp;
ALTER TABLE AD_SEQUENCE_NO DROP (tmp_col_1_tmp);

-- Processing table AD_SESSION
ALTER TABLE AD_SESSION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(80 CHAR));
UPDATE AD_SESSION SET tmp_col_1_tmp=AD_SESSION_UU,AD_SESSION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_4_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_5_tmp=SERVERNAME,SERVERNAME=NULL;
ALTER TABLE AD_SESSION MODIFY (AD_SESSION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR),SERVERNAME VARCHAR2(80 CHAR));
UPDATE AD_SESSION SET AD_SESSION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REMOTE_ADDR=tmp_col_3_tmp,REMOTE_HOST=tmp_col_4_tmp,SERVERNAME=tmp_col_5_tmp;
ALTER TABLE AD_SESSION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_STORAGEPROVIDER
ALTER TABLE AD_STORAGEPROVIDER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(225 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_STORAGEPROVIDER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_STORAGEPROVIDER SET tmp_col_1_tmp=AD_STORAGEPROVIDER_UU,AD_STORAGEPROVIDER_UU=NULL,tmp_col_2_tmp=FOLDER,FOLDER=NULL,tmp_col_3_tmp=METHOD,METHOD=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PASSWORD,PASSWORD=NULL,tmp_col_6_tmp=URL,URL=NULL,tmp_col_7_tmp=USERNAME,USERNAME=NULL;
ALTER TABLE AD_STORAGEPROVIDER MODIFY (AD_STORAGEPROVIDER_UU VARCHAR2(36 CHAR),FOLDER VARCHAR2(255 CHAR),METHOD VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,PASSWORD VARCHAR2(255 CHAR),URL VARCHAR2(225 CHAR),USERNAME VARCHAR2(60 CHAR));
UPDATE AD_STORAGEPROVIDER SET AD_STORAGEPROVIDER_UU=tmp_col_1_tmp,FOLDER=tmp_col_2_tmp,METHOD=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PASSWORD=tmp_col_5_tmp,URL=tmp_col_6_tmp,USERNAME=tmp_col_7_tmp;
ALTER TABLE AD_STORAGEPROVIDER MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE AD_STORAGEPROVIDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_SYSCONFIG
ALTER TABLE AD_SYSCONFIG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(50 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_SYSCONFIG MODIFY (NAME NVARCHAR2(50) NULL,VALUE NVARCHAR2(255) NULL);
UPDATE AD_SYSCONFIG SET tmp_col_1_tmp=AD_SYSCONFIG_UU,AD_SYSCONFIG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_SYSCONFIG MODIFY (AD_SYSCONFIG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(50 CHAR),VALUE VARCHAR2(255 CHAR));
UPDATE AD_SYSCONFIG SET AD_SYSCONFIG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE AD_SYSCONFIG MODIFY (NAME VARCHAR2(50 CHAR) NOT NULL,VALUE VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE AD_SYSCONFIG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_SYSTEM
ALTER TABLE AD_SYSTEM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(20 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(10 CHAR),tmp_col_17_tmp VARCHAR2(60 CHAR),tmp_col_18_tmp VARCHAR2(255 CHAR),tmp_col_19_tmp VARCHAR2(60 CHAR),tmp_col_20_tmp VARCHAR2(60 CHAR),tmp_col_21_tmp VARCHAR2(20 CHAR));
ALTER TABLE AD_SYSTEM MODIFY (NAME NVARCHAR2(60) NULL,USERNAME NVARCHAR2(60) NULL);
UPDATE AD_SYSTEM SET tmp_col_1_tmp=AD_SYSTEM_UU,AD_SYSTEM_UU=NULL,tmp_col_2_tmp=CUSTOMPREFIX,CUSTOMPREFIX=NULL,tmp_col_3_tmp=DBADDRESS,DBADDRESS=NULL,tmp_col_4_tmp=DBINSTANCE,DBINSTANCE=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=ENCRYPTIONKEY,ENCRYPTIONKEY=NULL,tmp_col_7_tmp=INFO,INFO=NULL,tmp_col_8_tmp=LASTBUILDINFO,LASTBUILDINFO=NULL,tmp_col_9_tmp=LASTMIGRATIONSCRIPTAPPLIED,LASTMIGRATIONSCRIPTAPPLIED=NULL,tmp_col_10_tmp=LDAPDOMAIN,LDAPDOMAIN=NULL,tmp_col_11_tmp=LDAPHOST,LDAPHOST=NULL,tmp_col_12_tmp=NAME,NAME=NULL,tmp_col_13_tmp=OLDNAME,OLDNAME=NULL,tmp_col_14_tmp=PASSWORD,PASSWORD=NULL,tmp_col_15_tmp=PROFILEINFO,PROFILEINFO=NULL,tmp_col_16_tmp=RELEASENO,RELEASENO=NULL,tmp_col_17_tmp=STATISTICSINFO,STATISTICSINFO=NULL,tmp_col_18_tmp=SUMMARY,SUMMARY=NULL,tmp_col_19_tmp=SUPPORTEMAIL,SUPPORTEMAIL=NULL,tmp_col_20_tmp=USERNAME,USERNAME=NULL,tmp_col_21_tmp=VERSION,VERSION=NULL;
ALTER TABLE AD_SYSTEM MODIFY (AD_SYSTEM_UU VARCHAR2(36 CHAR),CUSTOMPREFIX VARCHAR2(60 CHAR),DBADDRESS VARCHAR2(255 CHAR),DBINSTANCE VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ENCRYPTIONKEY VARCHAR2(255 CHAR),INFO VARCHAR2(255 CHAR),LASTBUILDINFO VARCHAR2(255 CHAR),LASTMIGRATIONSCRIPTAPPLIED VARCHAR2(255 CHAR),LDAPDOMAIN VARCHAR2(255 CHAR),LDAPHOST VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),OLDNAME VARCHAR2(60 CHAR),PASSWORD VARCHAR2(20 CHAR),PROFILEINFO VARCHAR2(255 CHAR),RELEASENO VARCHAR2(10 CHAR),STATISTICSINFO VARCHAR2(60 CHAR),SUMMARY VARCHAR2(255 CHAR),SUPPORTEMAIL VARCHAR2(60 CHAR),USERNAME VARCHAR2(60 CHAR),VERSION VARCHAR2(20 CHAR));
UPDATE AD_SYSTEM SET AD_SYSTEM_UU=tmp_col_1_tmp,CUSTOMPREFIX=tmp_col_2_tmp,DBADDRESS=tmp_col_3_tmp,DBINSTANCE=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,ENCRYPTIONKEY=tmp_col_6_tmp,INFO=tmp_col_7_tmp,LASTBUILDINFO=tmp_col_8_tmp,LASTMIGRATIONSCRIPTAPPLIED=tmp_col_9_tmp,LDAPDOMAIN=tmp_col_10_tmp,LDAPHOST=tmp_col_11_tmp,NAME=tmp_col_12_tmp,OLDNAME=tmp_col_13_tmp,PASSWORD=tmp_col_14_tmp,PROFILEINFO=tmp_col_15_tmp,RELEASENO=tmp_col_16_tmp,STATISTICSINFO=tmp_col_17_tmp,SUMMARY=tmp_col_18_tmp,SUPPORTEMAIL=tmp_col_19_tmp,USERNAME=tmp_col_20_tmp,VERSION=tmp_col_21_tmp;
ALTER TABLE AD_SYSTEM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,USERNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_SYSTEM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp);

-- Processing table AD_TAB
ALTER TABLE AD_TAB ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_TAB MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TAB SET tmp_col_1_tmp=AD_TAB_UU,AD_TAB_UU=NULL,tmp_col_2_tmp=COMMITWARNING,COMMITWARNING=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=ORDERBYCLAUSE,ORDERBYCLAUSE=NULL,tmp_col_8_tmp=READONLYLOGIC,READONLYLOGIC=NULL,tmp_col_9_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_TAB MODIFY (AD_TAB_UU VARCHAR2(36 CHAR),COMMITWARNING VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),ORDERBYCLAUSE VARCHAR2(2000 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_TAB SET AD_TAB_UU=tmp_col_1_tmp,COMMITWARNING=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DISPLAYLOGIC=tmp_col_4_tmp,HELP=tmp_col_5_tmp,NAME=tmp_col_6_tmp,ORDERBYCLAUSE=tmp_col_7_tmp,READONLYLOGIC=tmp_col_8_tmp,WHERECLAUSE=tmp_col_9_tmp;
ALTER TABLE AD_TAB MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TAB DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table AD_TABLE
ALTER TABLE AD_TABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(1 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TABLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TABLE SET tmp_col_1_tmp=AD_TABLE_UU,AD_TABLE_UU=NULL,tmp_col_2_tmp=COPYCOLUMNSFROMTABLE,COPYCOLUMNSFROMTABLE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TABLE MODIFY (AD_TABLE_UU VARCHAR2(36 CHAR),COPYCOLUMNSFROMTABLE VARCHAR2(1 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TABLE SET AD_TABLE_UU=tmp_col_1_tmp,COPYCOLUMNSFROMTABLE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE AD_TABLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_TABLEINDEX
ALTER TABLE AD_TABLEINDEX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(50 CHAR));
ALTER TABLE AD_TABLEINDEX MODIFY (NAME NVARCHAR2(50) NULL);
UPDATE AD_TABLEINDEX SET tmp_col_1_tmp=AD_TABLEINDEX_UU,AD_TABLEINDEX_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TABLEINDEX MODIFY (AD_TABLEINDEX_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(50 CHAR));
UPDATE AD_TABLEINDEX SET AD_TABLEINDEX_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_TABLEINDEX MODIFY (NAME VARCHAR2(50 CHAR) NOT NULL);
ALTER TABLE AD_TABLEINDEX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_TABLE_ACCESS
ALTER TABLE AD_TABLE_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TABLE_ACCESS SET tmp_col_1_tmp=AD_TABLE_ACCESS_UU,AD_TABLE_ACCESS_UU=NULL;
ALTER TABLE AD_TABLE_ACCESS MODIFY (AD_TABLE_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_TABLE_ACCESS SET AD_TABLE_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_TABLE_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_TABLE_SCRIPTVALIDATOR
ALTER TABLE AD_TABLE_SCRIPTVALIDATOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TABLE_SCRIPTVALIDATOR SET tmp_col_1_tmp=AD_TABLE_SCRIPTVALIDATOR_UU,AD_TABLE_SCRIPTVALIDATOR_UU=NULL;
ALTER TABLE AD_TABLE_SCRIPTVALIDATOR MODIFY (AD_TABLE_SCRIPTVALIDATOR_UU VARCHAR2(36 CHAR));
UPDATE AD_TABLE_SCRIPTVALIDATOR SET AD_TABLE_SCRIPTVALIDATOR_UU=tmp_col_1_tmp;
ALTER TABLE AD_TABLE_SCRIPTVALIDATOR DROP (tmp_col_1_tmp);

-- Processing table AD_TABLE_TRL
ALTER TABLE AD_TABLE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TABLE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TABLE_TRL SET tmp_col_1_tmp=AD_TABLE_TRL_UU,AD_TABLE_TRL_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TABLE_TRL MODIFY (AD_TABLE_TRL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TABLE_TRL SET AD_TABLE_TRL_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE AD_TABLE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TABLE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_TAB_CUSTOMIZATION
ALTER TABLE AD_TAB_CUSTOMIZATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_TAB_CUSTOMIZATION MODIFY (CUSTOM NVARCHAR2(2000) NULL);
UPDATE AD_TAB_CUSTOMIZATION SET tmp_col_1_tmp=AD_TAB_CUSTOMIZATION_UU,AD_TAB_CUSTOMIZATION_UU=NULL,tmp_col_2_tmp=CUSTOM,CUSTOM=NULL;
ALTER TABLE AD_TAB_CUSTOMIZATION MODIFY (AD_TAB_CUSTOMIZATION_UU VARCHAR2(36 CHAR),CUSTOM VARCHAR2(2000 CHAR));
UPDATE AD_TAB_CUSTOMIZATION SET AD_TAB_CUSTOMIZATION_UU=tmp_col_1_tmp,CUSTOM=tmp_col_2_tmp;
ALTER TABLE AD_TAB_CUSTOMIZATION MODIFY (CUSTOM VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_TAB_CUSTOMIZATION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_TAB_TRL
ALTER TABLE AD_TAB_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TAB_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TAB_TRL SET tmp_col_1_tmp=AD_TAB_TRL_UU,AD_TAB_TRL_UU=NULL,tmp_col_2_tmp=COMMITWARNING,COMMITWARNING=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TAB_TRL MODIFY (AD_TAB_TRL_UU VARCHAR2(36 CHAR),COMMITWARNING VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TAB_TRL SET AD_TAB_TRL_UU=tmp_col_1_tmp,COMMITWARNING=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE AD_TAB_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TAB_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_TASK
ALTER TABLE AD_TASK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_TASK MODIFY (NAME NVARCHAR2(60) NULL,OS_COMMAND NVARCHAR2(2000) NULL);
UPDATE AD_TASK SET tmp_col_1_tmp=AD_TASK_UU,AD_TASK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=OS_COMMAND,OS_COMMAND=NULL;
ALTER TABLE AD_TASK MODIFY (AD_TASK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),OS_COMMAND VARCHAR2(2000 CHAR));
UPDATE AD_TASK SET AD_TASK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,OS_COMMAND=tmp_col_5_tmp;
ALTER TABLE AD_TASK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,OS_COMMAND VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE AD_TASK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_TASKINSTANCE
ALTER TABLE AD_TASKINSTANCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TASKINSTANCE SET tmp_col_1_tmp=AD_TASKINSTANCE_UU,AD_TASKINSTANCE_UU=NULL;
ALTER TABLE AD_TASKINSTANCE MODIFY (AD_TASKINSTANCE_UU VARCHAR2(36 CHAR));
UPDATE AD_TASKINSTANCE SET AD_TASKINSTANCE_UU=tmp_col_1_tmp;
ALTER TABLE AD_TASKINSTANCE DROP (tmp_col_1_tmp);

-- Processing table AD_TASK_ACCESS
ALTER TABLE AD_TASK_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TASK_ACCESS SET tmp_col_1_tmp=AD_TASK_ACCESS_UU,AD_TASK_ACCESS_UU=NULL;
ALTER TABLE AD_TASK_ACCESS MODIFY (AD_TASK_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_TASK_ACCESS SET AD_TASK_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_TASK_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_TASK_TRL
ALTER TABLE AD_TASK_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TASK_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TASK_TRL SET tmp_col_1_tmp=AD_TASK_TRL_UU,AD_TASK_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TASK_TRL MODIFY (AD_TASK_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TASK_TRL SET AD_TASK_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_TASK_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TASK_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_TOOLBARBUTTON
ALTER TABLE AD_TOOLBARBUTTON ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TOOLBARBUTTON MODIFY (COMPONENTNAME NVARCHAR2(255) NULL,NAME NVARCHAR2(60) NULL);
UPDATE AD_TOOLBARBUTTON SET tmp_col_1_tmp=ACTIONCLASSNAME,ACTIONCLASSNAME=NULL,tmp_col_2_tmp=ACTIONNAME,ACTIONNAME=NULL,tmp_col_3_tmp=AD_TOOLBARBUTTON_UU,AD_TOOLBARBUTTON_UU=NULL,tmp_col_4_tmp=CLASSNAME,CLASSNAME=NULL,tmp_col_5_tmp=COMPONENTNAME,COMPONENTNAME=NULL,tmp_col_6_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_7_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TOOLBARBUTTON MODIFY (ACTIONCLASSNAME VARCHAR2(255 CHAR),ACTIONNAME VARCHAR2(60 CHAR),AD_TOOLBARBUTTON_UU VARCHAR2(36 CHAR),CLASSNAME VARCHAR2(255 CHAR),COMPONENTNAME VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TOOLBARBUTTON SET ACTIONCLASSNAME=tmp_col_1_tmp,ACTIONNAME=tmp_col_2_tmp,AD_TOOLBARBUTTON_UU=tmp_col_3_tmp,CLASSNAME=tmp_col_4_tmp,COMPONENTNAME=tmp_col_5_tmp,DISPLAYLOGIC=tmp_col_6_tmp,NAME=tmp_col_7_tmp;
ALTER TABLE AD_TOOLBARBUTTON MODIFY (COMPONENTNAME VARCHAR2(255 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TOOLBARBUTTON DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_TOOLBARBUTTONRESTRICT
ALTER TABLE AD_TOOLBARBUTTONRESTRICT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TOOLBARBUTTONRESTRICT SET tmp_col_1_tmp=AD_TOOLBARBUTTONRESTRICT_UU,AD_TOOLBARBUTTONRESTRICT_UU=NULL;
ALTER TABLE AD_TOOLBARBUTTONRESTRICT MODIFY (AD_TOOLBARBUTTONRESTRICT_UU VARCHAR2(36 CHAR));
UPDATE AD_TOOLBARBUTTONRESTRICT SET AD_TOOLBARBUTTONRESTRICT_UU=tmp_col_1_tmp;
ALTER TABLE AD_TOOLBARBUTTONRESTRICT DROP (tmp_col_1_tmp);

-- Processing table AD_TREE
ALTER TABLE AD_TREE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_TREE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_TREE SET tmp_col_1_tmp=AD_TREE_UU,AD_TREE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_TREE MODIFY (AD_TREE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_TREE SET AD_TREE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_TREE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_TREE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_TREEBAR
ALTER TABLE AD_TREEBAR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREEBAR SET tmp_col_1_tmp=AD_TREEBAR_UU,AD_TREEBAR_UU=NULL;
ALTER TABLE AD_TREEBAR MODIFY (AD_TREEBAR_UU VARCHAR2(36 CHAR));
UPDATE AD_TREEBAR SET AD_TREEBAR_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREEBAR DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODE
ALTER TABLE AD_TREENODE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODE SET tmp_col_1_tmp=AD_TREENODE_UU,AD_TREENODE_UU=NULL;
ALTER TABLE AD_TREENODE MODIFY (AD_TREENODE_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODE SET AD_TREENODE_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODE DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEBP
ALTER TABLE AD_TREENODEBP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEBP SET tmp_col_1_tmp=AD_TREENODEBP_UU,AD_TREENODEBP_UU=NULL;
ALTER TABLE AD_TREENODEBP MODIFY (AD_TREENODEBP_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEBP SET AD_TREENODEBP_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEBP DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODECMC
ALTER TABLE AD_TREENODECMC ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMC SET tmp_col_1_tmp=AD_TREENODECMC_UU,AD_TREENODECMC_UU=NULL;
ALTER TABLE AD_TREENODECMC MODIFY (AD_TREENODECMC_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMC SET AD_TREENODECMC_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODECMC DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODECMM
ALTER TABLE AD_TREENODECMM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMM SET tmp_col_1_tmp=AD_TREENODECMM_UU,AD_TREENODECMM_UU=NULL;
ALTER TABLE AD_TREENODECMM MODIFY (AD_TREENODECMM_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMM SET AD_TREENODECMM_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODECMM DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODECMS
ALTER TABLE AD_TREENODECMS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMS SET tmp_col_1_tmp=AD_TREENODECMS_UU,AD_TREENODECMS_UU=NULL;
ALTER TABLE AD_TREENODECMS MODIFY (AD_TREENODECMS_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMS SET AD_TREENODECMS_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODECMS DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODECMT
ALTER TABLE AD_TREENODECMT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMT SET tmp_col_1_tmp=AD_TREENODECMT_UU,AD_TREENODECMT_UU=NULL;
ALTER TABLE AD_TREENODECMT MODIFY (AD_TREENODECMT_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODECMT SET AD_TREENODECMT_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODECMT DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEMM
ALTER TABLE AD_TREENODEMM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEMM SET tmp_col_1_tmp=AD_TREENODEMM_UU,AD_TREENODEMM_UU=NULL;
ALTER TABLE AD_TREENODEMM MODIFY (AD_TREENODEMM_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEMM SET AD_TREENODEMM_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEMM DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEPR
ALTER TABLE AD_TREENODEPR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEPR SET tmp_col_1_tmp=AD_TREENODEPR_UU,AD_TREENODEPR_UU=NULL;
ALTER TABLE AD_TREENODEPR MODIFY (AD_TREENODEPR_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEPR SET AD_TREENODEPR_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEPR DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEU1
ALTER TABLE AD_TREENODEU1 ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU1 SET tmp_col_1_tmp=AD_TREENODEU1_UU,AD_TREENODEU1_UU=NULL;
ALTER TABLE AD_TREENODEU1 MODIFY (AD_TREENODEU1_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU1 SET AD_TREENODEU1_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEU1 DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEU2
ALTER TABLE AD_TREENODEU2 ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU2 SET tmp_col_1_tmp=AD_TREENODEU2_UU,AD_TREENODEU2_UU=NULL;
ALTER TABLE AD_TREENODEU2 MODIFY (AD_TREENODEU2_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU2 SET AD_TREENODEU2_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEU2 DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEU3
ALTER TABLE AD_TREENODEU3 ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU3 SET tmp_col_1_tmp=AD_TREENODEU3_UU,AD_TREENODEU3_UU=NULL;
ALTER TABLE AD_TREENODEU3 MODIFY (AD_TREENODEU3_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU3 SET AD_TREENODEU3_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEU3 DROP (tmp_col_1_tmp);

-- Processing table AD_TREENODEU4
ALTER TABLE AD_TREENODEU4 ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU4 SET tmp_col_1_tmp=AD_TREENODEU4_UU,AD_TREENODEU4_UU=NULL;
ALTER TABLE AD_TREENODEU4 MODIFY (AD_TREENODEU4_UU VARCHAR2(36 CHAR));
UPDATE AD_TREENODEU4 SET AD_TREENODEU4_UU=tmp_col_1_tmp;
ALTER TABLE AD_TREENODEU4 DROP (tmp_col_1_tmp);

-- Processing table AD_USER
ALTER TABLE AD_USER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(1024 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(10 CHAR),tmp_col_14_tmp VARCHAR2(255 CHAR),tmp_col_15_tmp VARCHAR2(10 CHAR),tmp_col_16_tmp VARCHAR2(255 CHAR),tmp_col_17_tmp VARCHAR2(60 CHAR),tmp_col_18_tmp VARCHAR2(1024 CHAR),tmp_col_19_tmp VARCHAR2(40 CHAR),tmp_col_20_tmp VARCHAR2(40 CHAR),tmp_col_21_tmp VARCHAR2(16 CHAR),tmp_col_22_tmp VARCHAR2(1024 CHAR),tmp_col_23_tmp VARCHAR2(40 CHAR),tmp_col_24_tmp VARCHAR2(20 CHAR),tmp_col_25_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_USER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_USER SET tmp_col_1_tmp=AD_USER_UU,AD_USER_UU=NULL,tmp_col_2_tmp=ANSWER,ANSWER=NULL,tmp_col_3_tmp=BPNAME,BPNAME=NULL,tmp_col_4_tmp=COMMENTS,COMMENTS=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=EMAIL,EMAIL=NULL,tmp_col_7_tmp=EMAILUSER,EMAILUSER=NULL,tmp_col_8_tmp=EMAILUSERPW,EMAILUSERPW=NULL,tmp_col_9_tmp=EMAILVERIFY,EMAILVERIFY=NULL,tmp_col_10_tmp=FAX,FAX=NULL,tmp_col_11_tmp=LASTRESULT,LASTRESULT=NULL,tmp_col_12_tmp=LDAPUSER,LDAPUSER=NULL,tmp_col_13_tmp=LEADSOURCE,LEADSOURCE=NULL,tmp_col_14_tmp=LEADSOURCEDESCRIPTION,LEADSOURCEDESCRIPTION=NULL,tmp_col_15_tmp=LEADSTATUS,LEADSTATUS=NULL,tmp_col_16_tmp=LEADSTATUSDESCRIPTION,LEADSTATUSDESCRIPTION=NULL,tmp_col_17_tmp=NAME,NAME=NULL,tmp_col_18_tmp=PASSWORD,PASSWORD=NULL,tmp_col_19_tmp=PHONE,PHONE=NULL,tmp_col_20_tmp=PHONE2,PHONE2=NULL,tmp_col_21_tmp=SALT,SALT=NULL,tmp_col_22_tmp=SECURITYQUESTION,SECURITYQUESTION=NULL,tmp_col_23_tmp=TITLE,TITLE=NULL,tmp_col_24_tmp=USERPIN,USERPIN=NULL,tmp_col_25_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_USER MODIFY (AD_USER_UU VARCHAR2(36 CHAR),ANSWER VARCHAR2(1024 CHAR),BPNAME VARCHAR2(60 CHAR),COMMENTS VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EMAIL VARCHAR2(60 CHAR),EMAILUSER VARCHAR2(60 CHAR),EMAILUSERPW VARCHAR2(255 CHAR),EMAILVERIFY VARCHAR2(40 CHAR),FAX VARCHAR2(40 CHAR),LASTRESULT VARCHAR2(255 CHAR),LDAPUSER VARCHAR2(60 CHAR),LEADSOURCE VARCHAR2(10 CHAR),LEADSOURCEDESCRIPTION VARCHAR2(255 CHAR),LEADSTATUS VARCHAR2(10 CHAR),LEADSTATUSDESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PASSWORD VARCHAR2(1024 CHAR),PHONE VARCHAR2(40 CHAR),PHONE2 VARCHAR2(40 CHAR),SALT VARCHAR2(16 CHAR),SECURITYQUESTION VARCHAR2(1024 CHAR),TITLE VARCHAR2(40 CHAR),USERPIN VARCHAR2(20 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_USER SET AD_USER_UU=tmp_col_1_tmp,ANSWER=tmp_col_2_tmp,BPNAME=tmp_col_3_tmp,COMMENTS=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,EMAIL=tmp_col_6_tmp,EMAILUSER=tmp_col_7_tmp,EMAILUSERPW=tmp_col_8_tmp,EMAILVERIFY=tmp_col_9_tmp,FAX=tmp_col_10_tmp,LASTRESULT=tmp_col_11_tmp,LDAPUSER=tmp_col_12_tmp,LEADSOURCE=tmp_col_13_tmp,LEADSOURCEDESCRIPTION=tmp_col_14_tmp,LEADSTATUS=tmp_col_15_tmp,LEADSTATUSDESCRIPTION=tmp_col_16_tmp,NAME=tmp_col_17_tmp,PASSWORD=tmp_col_18_tmp,PHONE=tmp_col_19_tmp,PHONE2=tmp_col_20_tmp,SALT=tmp_col_21_tmp,SECURITYQUESTION=tmp_col_22_tmp,TITLE=tmp_col_23_tmp,USERPIN=tmp_col_24_tmp,VALUE=tmp_col_25_tmp;
ALTER TABLE AD_USER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_USER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp,tmp_col_25_tmp);

-- Processing table AD_USERBPACCESS
ALTER TABLE AD_USERBPACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_USERBPACCESS SET tmp_col_1_tmp=AD_USERBPACCESS_UU,AD_USERBPACCESS_UU=NULL;
ALTER TABLE AD_USERBPACCESS MODIFY (AD_USERBPACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_USERBPACCESS SET AD_USERBPACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_USERBPACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_USERDEF_FIELD
ALTER TABLE AD_USERDEF_FIELD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR));
UPDATE AD_USERDEF_FIELD SET tmp_col_1_tmp=AD_USERDEF_FIELD_UU,AD_USERDEF_FIELD_UU=NULL,tmp_col_2_tmp=DEFAULTVALUE,DEFAULTVALUE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DISPLAYLOGIC,DISPLAYLOGIC=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=MANDATORYLOGIC,MANDATORYLOGIC=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=PLACEHOLDER,PLACEHOLDER=NULL,tmp_col_9_tmp=READONLYLOGIC,READONLYLOGIC=NULL,tmp_col_10_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE AD_USERDEF_FIELD MODIFY (AD_USERDEF_FIELD_UU VARCHAR2(36 CHAR),DEFAULTVALUE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYLOGIC VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),MANDATORYLOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDER VARCHAR2(255 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR),VFORMAT VARCHAR2(255 CHAR));
UPDATE AD_USERDEF_FIELD SET AD_USERDEF_FIELD_UU=tmp_col_1_tmp,DEFAULTVALUE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DISPLAYLOGIC=tmp_col_4_tmp,HELP=tmp_col_5_tmp,MANDATORYLOGIC=tmp_col_6_tmp,NAME=tmp_col_7_tmp,PLACEHOLDER=tmp_col_8_tmp,READONLYLOGIC=tmp_col_9_tmp,VFORMAT=tmp_col_10_tmp;
ALTER TABLE AD_USERDEF_FIELD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table AD_USERDEF_TAB
ALTER TABLE AD_USERDEF_TAB ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE AD_USERDEF_TAB SET tmp_col_1_tmp=AD_USERDEF_TAB_UU,AD_USERDEF_TAB_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=READONLYLOGIC,READONLYLOGIC=NULL;
ALTER TABLE AD_USERDEF_TAB MODIFY (AD_USERDEF_TAB_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),READONLYLOGIC VARCHAR2(2000 CHAR));
UPDATE AD_USERDEF_TAB SET AD_USERDEF_TAB_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,READONLYLOGIC=tmp_col_5_tmp;
ALTER TABLE AD_USERDEF_TAB DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_USERDEF_WIN
ALTER TABLE AD_USERDEF_WIN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
UPDATE AD_USERDEF_WIN SET tmp_col_1_tmp=AD_USERDEF_WIN_UU,AD_USERDEF_WIN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_USERDEF_WIN MODIFY (AD_USERDEF_WIN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_USERDEF_WIN SET AD_USERDEF_WIN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_USERDEF_WIN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_USERMAIL
ALTER TABLE AD_USERMAIL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
UPDATE AD_USERMAIL SET tmp_col_1_tmp=AD_USERMAIL_UU,AD_USERMAIL_UU=NULL,tmp_col_2_tmp=MAILTEXT,MAILTEXT=NULL,tmp_col_3_tmp=SUBJECT,SUBJECT=NULL;
ALTER TABLE AD_USERMAIL MODIFY (AD_USERMAIL_UU VARCHAR2(36 CHAR),MAILTEXT VARCHAR2(2000 CHAR),SUBJECT VARCHAR2(255 CHAR));
UPDATE AD_USERMAIL SET AD_USERMAIL_UU=tmp_col_1_tmp,MAILTEXT=tmp_col_2_tmp,SUBJECT=tmp_col_3_tmp;
ALTER TABLE AD_USERMAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_USERQUERY
ALTER TABLE AD_USERQUERY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_USERQUERY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_USERQUERY SET tmp_col_1_tmp=AD_USERQUERY_UU,AD_USERQUERY_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_USERQUERY MODIFY (AD_USERQUERY_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_USERQUERY SET AD_USERQUERY_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_USERQUERY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_USERQUERY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_USER_ORGACCESS
ALTER TABLE AD_USER_ORGACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_USER_ORGACCESS SET tmp_col_1_tmp=AD_USER_ORGACCESS_UU,AD_USER_ORGACCESS_UU=NULL;
ALTER TABLE AD_USER_ORGACCESS MODIFY (AD_USER_ORGACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_USER_ORGACCESS SET AD_USER_ORGACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_USER_ORGACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_USER_ROLES
ALTER TABLE AD_USER_ROLES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_USER_ROLES SET tmp_col_1_tmp=AD_USER_ROLES_UU,AD_USER_ROLES_UU=NULL;
ALTER TABLE AD_USER_ROLES MODIFY (AD_USER_ROLES_UU VARCHAR2(36 CHAR));
UPDATE AD_USER_ROLES SET AD_USER_ROLES_UU=tmp_col_1_tmp;
ALTER TABLE AD_USER_ROLES DROP (tmp_col_1_tmp);

-- Processing table AD_USER_SUBSTITUTE
ALTER TABLE AD_USER_SUBSTITUTE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_USER_SUBSTITUTE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_USER_SUBSTITUTE SET tmp_col_1_tmp=AD_USER_SUBSTITUTE_UU,AD_USER_SUBSTITUTE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_USER_SUBSTITUTE MODIFY (AD_USER_SUBSTITUTE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_USER_SUBSTITUTE SET AD_USER_SUBSTITUTE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_USER_SUBSTITUTE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_USER_SUBSTITUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_VAL_RULE
ALTER TABLE AD_VAL_RULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_VAL_RULE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_VAL_RULE SET tmp_col_1_tmp=AD_VAL_RULE_UU,AD_VAL_RULE_UU=NULL,tmp_col_2_tmp=CODE,CODE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_VAL_RULE MODIFY (AD_VAL_RULE_UU VARCHAR2(36 CHAR),CODE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_VAL_RULE SET AD_VAL_RULE_UU=tmp_col_1_tmp,CODE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_VAL_RULE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_VAL_RULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_VIEWCOLUMN
ALTER TABLE AD_VIEWCOLUMN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_VIEWCOLUMN MODIFY (COLUMNNAME NVARCHAR2(30) NULL);
UPDATE AD_VIEWCOLUMN SET tmp_col_1_tmp=AD_VIEWCOLUMN_UU,AD_VIEWCOLUMN_UU=NULL,tmp_col_2_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL;
ALTER TABLE AD_VIEWCOLUMN MODIFY (AD_VIEWCOLUMN_UU VARCHAR2(36 CHAR),COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL ,DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE AD_VIEWCOLUMN SET AD_VIEWCOLUMN_UU=tmp_col_1_tmp,COLUMNNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp;
ALTER TABLE AD_VIEWCOLUMN MODIFY (COLUMNNAME VARCHAR2(30 CHAR) DEFAULT NULL	NOT NULL);
ALTER TABLE AD_VIEWCOLUMN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_VIEWCOMPONENT
ALTER TABLE AD_VIEWCOMPONENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(50 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_VIEWCOMPONENT MODIFY (FROMCLAUSE NVARCHAR2(2000) NULL,NAME NVARCHAR2(50) NULL);
UPDATE AD_VIEWCOMPONENT SET tmp_col_1_tmp=AD_VIEWCOMPONENT_UU,AD_VIEWCOMPONENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FROMCLAUSE,FROMCLAUSE=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_7_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE AD_VIEWCOMPONENT MODIFY (AD_VIEWCOMPONENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FROMCLAUSE VARCHAR2(2000 CHAR) DEFAULT NULL ,HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(50 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE AD_VIEWCOMPONENT SET AD_VIEWCOMPONENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FROMCLAUSE=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,OTHERCLAUSE=tmp_col_6_tmp,WHERECLAUSE=tmp_col_7_tmp;
ALTER TABLE AD_VIEWCOMPONENT MODIFY (FROMCLAUSE VARCHAR2(2000 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(50 CHAR) NOT NULL);
ALTER TABLE AD_VIEWCOMPONENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_WF_ACTIVITY
ALTER TABLE AD_WF_ACTIVITY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WF_ACTIVITY SET tmp_col_1_tmp=AD_WF_ACTIVITY_UU,AD_WF_ACTIVITY_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_WF_ACTIVITY MODIFY (AD_WF_ACTIVITY_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_WF_ACTIVITY SET AD_WF_ACTIVITY_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp;
ALTER TABLE AD_WF_ACTIVITY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_WF_ACTIVITYRESULT
ALTER TABLE AD_WF_ACTIVITYRESULT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_WF_ACTIVITYRESULT MODIFY (ATTRIBUTENAME NVARCHAR2(60) NULL);
UPDATE AD_WF_ACTIVITYRESULT SET tmp_col_1_tmp=AD_WF_ACTIVITYRESULT_UU,AD_WF_ACTIVITYRESULT_UU=NULL,tmp_col_2_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_3_tmp=ATTRIBUTEVALUE,ATTRIBUTEVALUE=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=HELP,HELP=NULL;
ALTER TABLE AD_WF_ACTIVITYRESULT MODIFY (AD_WF_ACTIVITYRESULT_UU VARCHAR2(36 CHAR),ATTRIBUTENAME VARCHAR2(60 CHAR),ATTRIBUTEVALUE VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE AD_WF_ACTIVITYRESULT SET AD_WF_ACTIVITYRESULT_UU=tmp_col_1_tmp,ATTRIBUTENAME=tmp_col_2_tmp,ATTRIBUTEVALUE=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,HELP=tmp_col_5_tmp;
ALTER TABLE AD_WF_ACTIVITYRESULT MODIFY (ATTRIBUTENAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WF_ACTIVITYRESULT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_WF_BLOCK
ALTER TABLE AD_WF_BLOCK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WF_BLOCK MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WF_BLOCK SET tmp_col_1_tmp=AD_WF_BLOCK_UU,AD_WF_BLOCK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WF_BLOCK MODIFY (AD_WF_BLOCK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WF_BLOCK SET AD_WF_BLOCK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_WF_BLOCK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WF_BLOCK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WF_EVENTAUDIT
ALTER TABLE AD_WF_EVENTAUDIT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WF_EVENTAUDIT SET tmp_col_1_tmp=AD_WF_EVENTAUDIT_UU,AD_WF_EVENTAUDIT_UU=NULL,tmp_col_2_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NEWVALUE,NEWVALUE=NULL,tmp_col_5_tmp=OLDVALUE,OLDVALUE=NULL,tmp_col_6_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_WF_EVENTAUDIT MODIFY (AD_WF_EVENTAUDIT_UU VARCHAR2(36 CHAR),ATTRIBUTENAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NEWVALUE VARCHAR2(2000 CHAR),OLDVALUE VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_WF_EVENTAUDIT SET AD_WF_EVENTAUDIT_UU=tmp_col_1_tmp,ATTRIBUTENAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NEWVALUE=tmp_col_4_tmp,OLDVALUE=tmp_col_5_tmp,TEXTMSG=tmp_col_6_tmp;
ALTER TABLE AD_WF_EVENTAUDIT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table AD_WF_NEXTCONDITION
ALTER TABLE AD_WF_NEXTCONDITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_WF_NEXTCONDITION MODIFY (VALUE NVARCHAR2(40) NULL);
UPDATE AD_WF_NEXTCONDITION SET tmp_col_1_tmp=AD_WF_NEXTCONDITION_UU,AD_WF_NEXTCONDITION_UU=NULL,tmp_col_2_tmp=VALUE,VALUE=NULL,tmp_col_3_tmp=VALUE2,VALUE2=NULL;
ALTER TABLE AD_WF_NEXTCONDITION MODIFY (AD_WF_NEXTCONDITION_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR),VALUE2 VARCHAR2(40 CHAR));
UPDATE AD_WF_NEXTCONDITION SET AD_WF_NEXTCONDITION_UU=tmp_col_1_tmp,VALUE=tmp_col_2_tmp,VALUE2=tmp_col_3_tmp;
ALTER TABLE AD_WF_NEXTCONDITION MODIFY (VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_WF_NEXTCONDITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WF_NODE
ALTER TABLE AD_WF_NODE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_WF_NODE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_WF_NODE SET tmp_col_1_tmp=AD_WF_NODE_UU,AD_WF_NODE_UU=NULL,tmp_col_2_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_3_tmp=ATTRIBUTEVALUE,ATTRIBUTEVALUE=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=EMAIL,EMAIL=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_WF_NODE MODIFY (AD_WF_NODE_UU VARCHAR2(36 CHAR),ATTRIBUTENAME VARCHAR2(60 CHAR),ATTRIBUTEVALUE VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EMAIL VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_WF_NODE SET AD_WF_NODE_UU=tmp_col_1_tmp,ATTRIBUTENAME=tmp_col_2_tmp,ATTRIBUTEVALUE=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,EMAIL=tmp_col_5_tmp,NAME=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE AD_WF_NODE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_WF_NODE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_WF_NODENEXT
ALTER TABLE AD_WF_NODENEXT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WF_NODENEXT SET tmp_col_1_tmp=AD_WF_NODENEXT_UU,AD_WF_NODENEXT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=TRANSITIONCODE,TRANSITIONCODE=NULL;
ALTER TABLE AD_WF_NODENEXT MODIFY (AD_WF_NODENEXT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),TRANSITIONCODE VARCHAR2(2000 CHAR));
UPDATE AD_WF_NODENEXT SET AD_WF_NODENEXT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,TRANSITIONCODE=tmp_col_3_tmp;
ALTER TABLE AD_WF_NODENEXT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WF_NODE_PARA
ALTER TABLE AD_WF_NODE_PARA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE AD_WF_NODE_PARA SET tmp_col_1_tmp=AD_WF_NODE_PARA_UU,AD_WF_NODE_PARA_UU=NULL,tmp_col_2_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_3_tmp=ATTRIBUTEVALUE,ATTRIBUTEVALUE=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE AD_WF_NODE_PARA MODIFY (AD_WF_NODE_PARA_UU VARCHAR2(36 CHAR),ATTRIBUTENAME VARCHAR2(60 CHAR),ATTRIBUTEVALUE VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE AD_WF_NODE_PARA SET AD_WF_NODE_PARA_UU=tmp_col_1_tmp,ATTRIBUTENAME=tmp_col_2_tmp,ATTRIBUTEVALUE=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp;
ALTER TABLE AD_WF_NODE_PARA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_WF_NODE_TRL
ALTER TABLE AD_WF_NODE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WF_NODE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WF_NODE_TRL SET tmp_col_1_tmp=AD_WF_NODE_TRL_UU,AD_WF_NODE_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WF_NODE_TRL MODIFY (AD_WF_NODE_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WF_NODE_TRL SET AD_WF_NODE_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_WF_NODE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WF_NODE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WF_PROCESS
ALTER TABLE AD_WF_PROCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WF_PROCESS SET tmp_col_1_tmp=AD_WF_PROCESS_UU,AD_WF_PROCESS_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_WF_PROCESS MODIFY (AD_WF_PROCESS_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_WF_PROCESS SET AD_WF_PROCESS_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp;
ALTER TABLE AD_WF_PROCESS DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_WF_PROCESSDATA
ALTER TABLE AD_WF_PROCESSDATA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WF_PROCESSDATA MODIFY (ATTRIBUTENAME NVARCHAR2(60) NULL);
UPDATE AD_WF_PROCESSDATA SET tmp_col_1_tmp=AD_WF_PROCESSDATA_UU,AD_WF_PROCESSDATA_UU=NULL,tmp_col_2_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_3_tmp=ATTRIBUTEVALUE,ATTRIBUTEVALUE=NULL;
ALTER TABLE AD_WF_PROCESSDATA MODIFY (AD_WF_PROCESSDATA_UU VARCHAR2(36 CHAR),ATTRIBUTENAME VARCHAR2(60 CHAR),ATTRIBUTEVALUE VARCHAR2(60 CHAR));
UPDATE AD_WF_PROCESSDATA SET AD_WF_PROCESSDATA_UU=tmp_col_1_tmp,ATTRIBUTENAME=tmp_col_2_tmp,ATTRIBUTEVALUE=tmp_col_3_tmp;
ALTER TABLE AD_WF_PROCESSDATA MODIFY (ATTRIBUTENAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WF_PROCESSDATA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WF_RESPONSIBLE
ALTER TABLE AD_WF_RESPONSIBLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WF_RESPONSIBLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WF_RESPONSIBLE SET tmp_col_1_tmp=AD_WF_RESPONSIBLE_UU,AD_WF_RESPONSIBLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WF_RESPONSIBLE MODIFY (AD_WF_RESPONSIBLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WF_RESPONSIBLE SET AD_WF_RESPONSIBLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_WF_RESPONSIBLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WF_RESPONSIBLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WINDOW
ALTER TABLE AD_WINDOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR));
ALTER TABLE AD_WINDOW MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WINDOW SET tmp_col_1_tmp=AD_WINDOW_UU,AD_WINDOW_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=TITLELOGIC,TITLELOGIC=NULL;
ALTER TABLE AD_WINDOW MODIFY (AD_WINDOW_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),TITLELOGIC VARCHAR2(255 CHAR));
UPDATE AD_WINDOW SET AD_WINDOW_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,TITLELOGIC=tmp_col_5_tmp;
ALTER TABLE AD_WINDOW MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WINDOW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_WINDOW_ACCESS
ALTER TABLE AD_WINDOW_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_WINDOW_ACCESS SET tmp_col_1_tmp=AD_WINDOW_ACCESS_UU,AD_WINDOW_ACCESS_UU=NULL;
ALTER TABLE AD_WINDOW_ACCESS MODIFY (AD_WINDOW_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_WINDOW_ACCESS SET AD_WINDOW_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_WINDOW_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_WINDOW_TRL
ALTER TABLE AD_WINDOW_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WINDOW_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WINDOW_TRL SET tmp_col_1_tmp=AD_WINDOW_TRL_UU,AD_WINDOW_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WINDOW_TRL MODIFY (AD_WINDOW_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WINDOW_TRL SET AD_WINDOW_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_WINDOW_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WINDOW_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_WIZARDPROCESS
ALTER TABLE AD_WIZARDPROCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WIZARDPROCESS SET tmp_col_1_tmp=AD_WIZARDPROCESS_UU,AD_WIZARDPROCESS_UU=NULL,tmp_col_2_tmp=NOTE,NOTE=NULL;
ALTER TABLE AD_WIZARDPROCESS MODIFY (AD_WIZARDPROCESS_UU VARCHAR2(36 CHAR),NOTE VARCHAR2(2000 CHAR));
UPDATE AD_WIZARDPROCESS SET AD_WIZARDPROCESS_UU=tmp_col_1_tmp,NOTE=tmp_col_2_tmp;
ALTER TABLE AD_WIZARDPROCESS DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table AD_WORKBENCH
ALTER TABLE AD_WORKBENCH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WORKBENCH MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WORKBENCH SET tmp_col_1_tmp=AD_WORKBENCH_UU,AD_WORKBENCH_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WORKBENCH MODIFY (AD_WORKBENCH_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WORKBENCH SET AD_WORKBENCH_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_WORKBENCH MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WORKBENCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_WORKBENCHWINDOW
ALTER TABLE AD_WORKBENCHWINDOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_WORKBENCHWINDOW SET tmp_col_1_tmp=AD_WORKBENCHWINDOW_UU,AD_WORKBENCHWINDOW_UU=NULL;
ALTER TABLE AD_WORKBENCHWINDOW MODIFY (AD_WORKBENCHWINDOW_UU VARCHAR2(36 CHAR));
UPDATE AD_WORKBENCHWINDOW SET AD_WORKBENCHWINDOW_UU=tmp_col_1_tmp;
ALTER TABLE AD_WORKBENCHWINDOW DROP (tmp_col_1_tmp);

-- Processing table AD_WORKBENCH_TRL
ALTER TABLE AD_WORKBENCH_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WORKBENCH_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WORKBENCH_TRL SET tmp_col_1_tmp=AD_WORKBENCH_TRL_UU,AD_WORKBENCH_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WORKBENCH_TRL MODIFY (AD_WORKBENCH_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WORKBENCH_TRL SET AD_WORKBENCH_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE AD_WORKBENCH_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WORKBENCH_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table AD_WORKFLOW
ALTER TABLE AD_WORKFLOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR));
ALTER TABLE AD_WORKFLOW MODIFY (AUTHOR NVARCHAR2(20) NULL,NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE AD_WORKFLOW SET tmp_col_1_tmp=AD_WORKFLOW_UU,AD_WORKFLOW_UU=NULL,tmp_col_2_tmp=AUTHOR,AUTHOR=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_5_tmp=DOCVALUELOGIC,DOCVALUELOGIC=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE AD_WORKFLOW MODIFY (AD_WORKFLOW_UU VARCHAR2(36 CHAR),AUTHOR VARCHAR2(20 CHAR) DEFAULT 'ComPiere' ,DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),DOCVALUELOGIC VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE AD_WORKFLOW SET AD_WORKFLOW_UU=tmp_col_1_tmp,AUTHOR=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DOCUMENTNO=tmp_col_4_tmp,DOCVALUELOGIC=tmp_col_5_tmp,NAME=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE AD_WORKFLOW MODIFY (AUTHOR VARCHAR2(20 CHAR) DEFAULT 'ComPiere'	NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE AD_WORKFLOW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table AD_WORKFLOWPROCESSOR
ALTER TABLE AD_WORKFLOWPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WORKFLOWPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WORKFLOWPROCESSOR SET tmp_col_1_tmp=AD_WORKFLOWPROCESSOR_UU,AD_WORKFLOWPROCESSOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WORKFLOWPROCESSOR MODIFY (AD_WORKFLOWPROCESSOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WORKFLOWPROCESSOR SET AD_WORKFLOWPROCESSOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_WORKFLOWPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WORKFLOWPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_WORKFLOWPROCESSORLOG
ALTER TABLE AD_WORKFLOWPROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE AD_WORKFLOWPROCESSORLOG SET tmp_col_1_tmp=AD_WORKFLOWPROCESSORLOG_UU,AD_WORKFLOWPROCESSORLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE AD_WORKFLOWPROCESSORLOG MODIFY (AD_WORKFLOWPROCESSORLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE AD_WORKFLOWPROCESSORLOG SET AD_WORKFLOWPROCESSORLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE AD_WORKFLOWPROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table AD_WORKFLOW_ACCESS
ALTER TABLE AD_WORKFLOW_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE AD_WORKFLOW_ACCESS SET tmp_col_1_tmp=AD_WORKFLOW_ACCESS_UU,AD_WORKFLOW_ACCESS_UU=NULL;
ALTER TABLE AD_WORKFLOW_ACCESS MODIFY (AD_WORKFLOW_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE AD_WORKFLOW_ACCESS SET AD_WORKFLOW_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE AD_WORKFLOW_ACCESS DROP (tmp_col_1_tmp);

-- Processing table AD_WORKFLOW_TRL
ALTER TABLE AD_WORKFLOW_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE AD_WORKFLOW_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_WORKFLOW_TRL SET tmp_col_1_tmp=AD_WORKFLOW_TRL_UU,AD_WORKFLOW_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE AD_WORKFLOW_TRL MODIFY (AD_WORKFLOW_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE AD_WORKFLOW_TRL SET AD_WORKFLOW_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE AD_WORKFLOW_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_WORKFLOW_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table AD_ZOOMCONDITION
ALTER TABLE AD_ZOOMCONDITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE AD_ZOOMCONDITION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE AD_ZOOMCONDITION SET tmp_col_1_tmp=AD_ZOOMCONDITION_UU,AD_ZOOMCONDITION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=WHERECLAUSE,WHERECLAUSE=NULL,tmp_col_5_tmp=ZOOMLOGIC,ZOOMLOGIC=NULL;
ALTER TABLE AD_ZOOMCONDITION MODIFY (AD_ZOOMCONDITION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR),ZOOMLOGIC VARCHAR2(2000 CHAR));
UPDATE AD_ZOOMCONDITION SET AD_ZOOMCONDITION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,WHERECLAUSE=tmp_col_4_tmp,ZOOMLOGIC=tmp_col_5_tmp;
ALTER TABLE AD_ZOOMCONDITION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE AD_ZOOMCONDITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table ASP_CLIENTEXCEPTION
ALTER TABLE ASP_CLIENTEXCEPTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_CLIENTEXCEPTION SET tmp_col_1_tmp=ASP_CLIENTEXCEPTION_UU,ASP_CLIENTEXCEPTION_UU=NULL;
ALTER TABLE ASP_CLIENTEXCEPTION MODIFY (ASP_CLIENTEXCEPTION_UU VARCHAR2(36 CHAR));
UPDATE ASP_CLIENTEXCEPTION SET ASP_CLIENTEXCEPTION_UU=tmp_col_1_tmp;
ALTER TABLE ASP_CLIENTEXCEPTION DROP (tmp_col_1_tmp);

-- Processing table ASP_CLIENTLEVEL
ALTER TABLE ASP_CLIENTLEVEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE ASP_CLIENTLEVEL SET tmp_col_1_tmp=ASP_CLIENTLEVEL_UU,ASP_CLIENTLEVEL_UU=NULL,tmp_col_2_tmp=HELP,HELP=NULL;
ALTER TABLE ASP_CLIENTLEVEL MODIFY (ASP_CLIENTLEVEL_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE ASP_CLIENTLEVEL SET ASP_CLIENTLEVEL_UU=tmp_col_1_tmp,HELP=tmp_col_2_tmp;
ALTER TABLE ASP_CLIENTLEVEL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table ASP_FIELD
ALTER TABLE ASP_FIELD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_FIELD SET tmp_col_1_tmp=ASP_FIELD_UU,ASP_FIELD_UU=NULL;
ALTER TABLE ASP_FIELD MODIFY (ASP_FIELD_UU VARCHAR2(36 CHAR));
UPDATE ASP_FIELD SET ASP_FIELD_UU=tmp_col_1_tmp;
ALTER TABLE ASP_FIELD DROP (tmp_col_1_tmp);

-- Processing table ASP_FORM
ALTER TABLE ASP_FORM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_FORM SET tmp_col_1_tmp=ASP_FORM_UU,ASP_FORM_UU=NULL;
ALTER TABLE ASP_FORM MODIFY (ASP_FORM_UU VARCHAR2(36 CHAR));
UPDATE ASP_FORM SET ASP_FORM_UU=tmp_col_1_tmp;
ALTER TABLE ASP_FORM DROP (tmp_col_1_tmp);

-- Processing table ASP_LEVEL
ALTER TABLE ASP_LEVEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE ASP_LEVEL MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE ASP_LEVEL SET tmp_col_1_tmp=ASP_LEVEL_UU,ASP_LEVEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE ASP_LEVEL MODIFY (ASP_LEVEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE ASP_LEVEL SET ASP_LEVEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE ASP_LEVEL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE ASP_LEVEL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table ASP_MODULE
ALTER TABLE ASP_MODULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE ASP_MODULE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE ASP_MODULE SET tmp_col_1_tmp=ASP_MODULE_UU,ASP_MODULE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE ASP_MODULE MODIFY (ASP_MODULE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE ASP_MODULE SET ASP_MODULE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE ASP_MODULE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE ASP_MODULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table ASP_PROCESS
ALTER TABLE ASP_PROCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_PROCESS SET tmp_col_1_tmp=ASP_PROCESS_UU,ASP_PROCESS_UU=NULL;
ALTER TABLE ASP_PROCESS MODIFY (ASP_PROCESS_UU VARCHAR2(36 CHAR));
UPDATE ASP_PROCESS SET ASP_PROCESS_UU=tmp_col_1_tmp;
ALTER TABLE ASP_PROCESS DROP (tmp_col_1_tmp);

-- Processing table ASP_PROCESS_PARA
ALTER TABLE ASP_PROCESS_PARA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_PROCESS_PARA SET tmp_col_1_tmp=ASP_PROCESS_PARA_UU,ASP_PROCESS_PARA_UU=NULL;
ALTER TABLE ASP_PROCESS_PARA MODIFY (ASP_PROCESS_PARA_UU VARCHAR2(36 CHAR));
UPDATE ASP_PROCESS_PARA SET ASP_PROCESS_PARA_UU=tmp_col_1_tmp;
ALTER TABLE ASP_PROCESS_PARA DROP (tmp_col_1_tmp);

-- Processing table ASP_REF_LIST
ALTER TABLE ASP_REF_LIST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_REF_LIST SET tmp_col_1_tmp=ASP_REF_LIST_UU,ASP_REF_LIST_UU=NULL;
ALTER TABLE ASP_REF_LIST MODIFY (ASP_REF_LIST_UU VARCHAR2(36 CHAR));
UPDATE ASP_REF_LIST SET ASP_REF_LIST_UU=tmp_col_1_tmp;
ALTER TABLE ASP_REF_LIST DROP (tmp_col_1_tmp);

-- Processing table ASP_TAB
ALTER TABLE ASP_TAB ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_TAB SET tmp_col_1_tmp=ASP_TAB_UU,ASP_TAB_UU=NULL;
ALTER TABLE ASP_TAB MODIFY (ASP_TAB_UU VARCHAR2(36 CHAR));
UPDATE ASP_TAB SET ASP_TAB_UU=tmp_col_1_tmp;
ALTER TABLE ASP_TAB DROP (tmp_col_1_tmp);

-- Processing table ASP_TASK
ALTER TABLE ASP_TASK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_TASK SET tmp_col_1_tmp=ASP_TASK_UU,ASP_TASK_UU=NULL;
ALTER TABLE ASP_TASK MODIFY (ASP_TASK_UU VARCHAR2(36 CHAR));
UPDATE ASP_TASK SET ASP_TASK_UU=tmp_col_1_tmp;
ALTER TABLE ASP_TASK DROP (tmp_col_1_tmp);

-- Processing table ASP_WINDOW
ALTER TABLE ASP_WINDOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_WINDOW SET tmp_col_1_tmp=ASP_WINDOW_UU,ASP_WINDOW_UU=NULL;
ALTER TABLE ASP_WINDOW MODIFY (ASP_WINDOW_UU VARCHAR2(36 CHAR));
UPDATE ASP_WINDOW SET ASP_WINDOW_UU=tmp_col_1_tmp;
ALTER TABLE ASP_WINDOW DROP (tmp_col_1_tmp);

-- Processing table ASP_WORKFLOW
ALTER TABLE ASP_WORKFLOW ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE ASP_WORKFLOW SET tmp_col_1_tmp=ASP_WORKFLOW_UU,ASP_WORKFLOW_UU=NULL;
ALTER TABLE ASP_WORKFLOW MODIFY (ASP_WORKFLOW_UU VARCHAR2(36 CHAR));
UPDATE ASP_WORKFLOW SET ASP_WORKFLOW_UU=tmp_col_1_tmp;
ALTER TABLE ASP_WORKFLOW DROP (tmp_col_1_tmp);

-- Processing table A_ASSET
ALTER TABLE A_ASSET ADD (tmp_col_1_tmp VARCHAR2(3 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(30 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(30 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(255 CHAR),tmp_col_14_tmp VARCHAR2(40 CHAR),tmp_col_15_tmp VARCHAR2(20 CHAR));
ALTER TABLE A_ASSET MODIFY (A_ASSETTYPE NVARCHAR2(3) NULL,A_ASSET_ACTION NVARCHAR2(2) NULL,A_ASSET_STATUS NVARCHAR2(2) NULL,NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE A_ASSET SET tmp_col_1_tmp=A_ASSETTYPE,A_ASSETTYPE=NULL,tmp_col_2_tmp=A_ASSET_ACTION,A_ASSET_ACTION=NULL,tmp_col_3_tmp=A_ASSET_STATUS,A_ASSET_STATUS=NULL,tmp_col_4_tmp=A_ASSET_UU,A_ASSET_UU=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=HELP,HELP=NULL,tmp_col_7_tmp=INVENTORYNO,INVENTORYNO=NULL,tmp_col_8_tmp=LASTMAINTENANCENOTE,LASTMAINTENANCENOTE=NULL,tmp_col_9_tmp=LOCATIONCOMMENT,LOCATIONCOMMENT=NULL,tmp_col_10_tmp=LOT,LOT=NULL,tmp_col_11_tmp=MANUFACTURER,MANUFACTURER=NULL,tmp_col_12_tmp=NAME,NAME=NULL,tmp_col_13_tmp=SERNO,SERNO=NULL,tmp_col_14_tmp=VALUE,VALUE=NULL,tmp_col_15_tmp=VERSIONNO,VERSIONNO=NULL;
ALTER TABLE A_ASSET MODIFY (A_ASSETTYPE VARCHAR2(3 CHAR) DEFAULT 'MFX' ,A_ASSET_ACTION VARCHAR2(2 CHAR) DEFAULT 'MD' ,A_ASSET_STATUS VARCHAR2(2 CHAR) DEFAULT 'NW' ,A_ASSET_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),INVENTORYNO VARCHAR2(30 CHAR),LASTMAINTENANCENOTE VARCHAR2(60 CHAR),LOCATIONCOMMENT VARCHAR2(255 CHAR),LOT VARCHAR2(255 CHAR),MANUFACTURER VARCHAR2(30 CHAR),NAME VARCHAR2(60 CHAR),SERNO VARCHAR2(255 CHAR),VALUE VARCHAR2(40 CHAR),VERSIONNO VARCHAR2(20 CHAR));
UPDATE A_ASSET SET A_ASSETTYPE=tmp_col_1_tmp,A_ASSET_ACTION=tmp_col_2_tmp,A_ASSET_STATUS=tmp_col_3_tmp,A_ASSET_UU=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,HELP=tmp_col_6_tmp,INVENTORYNO=tmp_col_7_tmp,LASTMAINTENANCENOTE=tmp_col_8_tmp,LOCATIONCOMMENT=tmp_col_9_tmp,LOT=tmp_col_10_tmp,MANUFACTURER=tmp_col_11_tmp,NAME=tmp_col_12_tmp,SERNO=tmp_col_13_tmp,VALUE=tmp_col_14_tmp,VERSIONNO=tmp_col_15_tmp;
ALTER TABLE A_ASSET MODIFY (A_ASSETTYPE VARCHAR2(3 CHAR) DEFAULT 'MFX'  NOT NULL,A_ASSET_ACTION VARCHAR2(2 CHAR) DEFAULT 'MD'  NOT NULL,A_ASSET_STATUS VARCHAR2(2 CHAR) DEFAULT 'NW'  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE A_ASSET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp);

-- Processing table A_ASSET_ACCT
ALTER TABLE A_ASSET_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE A_ASSET_ACCT SET tmp_col_1_tmp=A_ASSET_ACCT_UU,A_ASSET_ACCT_UU=NULL;
ALTER TABLE A_ASSET_ACCT MODIFY (A_ASSET_ACCT_UU VARCHAR2(36 CHAR));
UPDATE A_ASSET_ACCT SET A_ASSET_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE A_ASSET_ACCT DROP (tmp_col_1_tmp);

-- Processing table A_ASSET_ADDITION
ALTER TABLE A_ASSET_ADDITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR),tmp_col_5_tmp VARCHAR2(2 CHAR),tmp_col_6_tmp VARCHAR2(30 CHAR));
ALTER TABLE A_ASSET_ADDITION MODIFY (A_CAPVSEXP NVARCHAR2(3) NULL,A_SOURCETYPE NVARCHAR2(3) NULL,DOCSTATUS NVARCHAR2(2) NULL);
UPDATE A_ASSET_ADDITION SET tmp_col_1_tmp=A_ASSET_ADDITION_UU,A_ASSET_ADDITION_UU=NULL,tmp_col_2_tmp=A_CAPVSEXP,A_CAPVSEXP=NULL,tmp_col_3_tmp=A_SOURCETYPE,A_SOURCETYPE=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_6_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_ASSET_ADDITION MODIFY (A_ASSET_ADDITION_UU VARCHAR2(36 CHAR),A_CAPVSEXP VARCHAR2(3 CHAR) DEFAULT 'Cap' ,A_SOURCETYPE VARCHAR2(3 CHAR) DEFAULT 'INV' ,DESCRIPTION VARCHAR2(510 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE A_ASSET_ADDITION SET A_ASSET_ADDITION_UU=tmp_col_1_tmp,A_CAPVSEXP=tmp_col_2_tmp,A_SOURCETYPE=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,DOCSTATUS=tmp_col_5_tmp,DOCUMENTNO=tmp_col_6_tmp;
ALTER TABLE A_ASSET_ADDITION MODIFY (A_CAPVSEXP VARCHAR2(3 CHAR) DEFAULT 'Cap'  NOT NULL,A_SOURCETYPE VARCHAR2(3 CHAR) DEFAULT 'INV'  NOT NULL,DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'  NOT NULL);
ALTER TABLE A_ASSET_ADDITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table A_ASSET_CHANGE
ALTER TABLE A_ASSET_CHANGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR),tmp_col_4_tmp VARCHAR2(3 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR));
ALTER TABLE A_ASSET_CHANGE MODIFY (CHANGETYPE NVARCHAR2(3) NULL,TEXTDETAILS NVARCHAR2(60) NULL);
UPDATE A_ASSET_CHANGE SET tmp_col_1_tmp=A_ASSET_CHANGE_UU,A_ASSET_CHANGE_UU=NULL,tmp_col_2_tmp=A_DEPRECIATION_MANUAL_PERIOD,A_DEPRECIATION_MANUAL_PERIOD=NULL,tmp_col_3_tmp=A_REVAL_CAL_METHOD,A_REVAL_CAL_METHOD=NULL,tmp_col_4_tmp=CHANGETYPE,CHANGETYPE=NULL,tmp_col_5_tmp=LOT,LOT=NULL,tmp_col_6_tmp=POSTINGTYPE,POSTINGTYPE=NULL,tmp_col_7_tmp=SERNO,SERNO=NULL,tmp_col_8_tmp=TEXTDETAILS,TEXTDETAILS=NULL,tmp_col_9_tmp=VERSIONNO,VERSIONNO=NULL;
ALTER TABLE A_ASSET_CHANGE MODIFY (A_ASSET_CHANGE_UU VARCHAR2(36 CHAR),A_DEPRECIATION_MANUAL_PERIOD VARCHAR2(2 CHAR),A_REVAL_CAL_METHOD VARCHAR2(3 CHAR),CHANGETYPE VARCHAR2(3 CHAR) DEFAULT NULL ,LOT VARCHAR2(40 CHAR),POSTINGTYPE VARCHAR2(10 CHAR) DEFAULT 'A',SERNO VARCHAR2(40 CHAR),TEXTDETAILS VARCHAR2(60 CHAR),VERSIONNO VARCHAR2(40 CHAR));
UPDATE A_ASSET_CHANGE SET A_ASSET_CHANGE_UU=tmp_col_1_tmp,A_DEPRECIATION_MANUAL_PERIOD=tmp_col_2_tmp,A_REVAL_CAL_METHOD=tmp_col_3_tmp,CHANGETYPE=tmp_col_4_tmp,LOT=tmp_col_5_tmp,POSTINGTYPE=tmp_col_6_tmp,SERNO=tmp_col_7_tmp,TEXTDETAILS=tmp_col_8_tmp,VERSIONNO=tmp_col_9_tmp;
ALTER TABLE A_ASSET_CHANGE MODIFY (CHANGETYPE VARCHAR2(3 CHAR) DEFAULT NULL	NOT NULL,TEXTDETAILS VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_ASSET_CHANGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table A_ASSET_CLASS
ALTER TABLE A_ASSET_CLASS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE A_ASSET_CLASS MODIFY (NAME NVARCHAR2(2000) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE A_ASSET_CLASS SET tmp_col_1_tmp=A_ASSET_CLASS_UU,A_ASSET_CLASS_UU=NULL,tmp_col_2_tmp=A_VALUE_2004,A_VALUE_2004=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE A_ASSET_CLASS MODIFY (A_ASSET_CLASS_UU VARCHAR2(36 CHAR),A_VALUE_2004 VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),NAME VARCHAR2(2000 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE A_ASSET_CLASS SET A_ASSET_CLASS_UU=tmp_col_1_tmp,A_VALUE_2004=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE A_ASSET_CLASS MODIFY (NAME VARCHAR2(2000 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE A_ASSET_CLASS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_ASSET_DELIVERY
ALTER TABLE A_ASSET_DELIVERY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(120 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR));
UPDATE A_ASSET_DELIVERY SET tmp_col_1_tmp=A_ASSET_DELIVERY_UU,A_ASSET_DELIVERY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=EMAIL,EMAIL=NULL,tmp_col_4_tmp=LOT,LOT=NULL,tmp_col_5_tmp=REFERRER,REFERRER=NULL,tmp_col_6_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_7_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_8_tmp=SERNO,SERNO=NULL,tmp_col_9_tmp=URL,URL=NULL,tmp_col_10_tmp=VERSIONNO,VERSIONNO=NULL;
ALTER TABLE A_ASSET_DELIVERY MODIFY (A_ASSET_DELIVERY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EMAIL VARCHAR2(60 CHAR),LOT VARCHAR2(40 CHAR),REFERRER VARCHAR2(255 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(60 CHAR),SERNO VARCHAR2(40 CHAR),URL VARCHAR2(120 CHAR),VERSIONNO VARCHAR2(20 CHAR));
UPDATE A_ASSET_DELIVERY SET A_ASSET_DELIVERY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,EMAIL=tmp_col_3_tmp,LOT=tmp_col_4_tmp,REFERRER=tmp_col_5_tmp,REMOTE_ADDR=tmp_col_6_tmp,REMOTE_HOST=tmp_col_7_tmp,SERNO=tmp_col_8_tmp,URL=tmp_col_9_tmp,VERSIONNO=tmp_col_10_tmp;
ALTER TABLE A_ASSET_DELIVERY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table A_ASSET_DISPOSED
ALTER TABLE A_ASSET_DISPOSED ADD (tmp_col_1_tmp VARCHAR2(2 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(2 CHAR),tmp_col_5_tmp VARCHAR2(10 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(2 CHAR),tmp_col_8_tmp VARCHAR2(30 CHAR));
ALTER TABLE A_ASSET_DISPOSED MODIFY (A_ACTIVATION_METHOD NVARCHAR2(2) NULL,A_DISPOSED_METHOD NVARCHAR2(2) NULL,DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE A_ASSET_DISPOSED SET tmp_col_1_tmp=A_ACTIVATION_METHOD,A_ACTIVATION_METHOD=NULL,tmp_col_2_tmp=A_ASSET_DISPOSED_UU,A_ASSET_DISPOSED_UU=NULL,tmp_col_3_tmp=A_ASSET_STATUS,A_ASSET_STATUS=NULL,tmp_col_4_tmp=A_DISPOSED_METHOD,A_DISPOSED_METHOD=NULL,tmp_col_5_tmp=A_DISPOSED_REASON,A_DISPOSED_REASON=NULL,tmp_col_6_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_7_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_8_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_ASSET_DISPOSED MODIFY (A_ACTIVATION_METHOD VARCHAR2(2 CHAR) DEFAULT 'AA' ,A_ASSET_DISPOSED_UU VARCHAR2(36 CHAR),A_ASSET_STATUS VARCHAR2(2 CHAR),A_DISPOSED_METHOD VARCHAR2(2 CHAR),A_DISPOSED_REASON VARCHAR2(10 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR',DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE A_ASSET_DISPOSED SET A_ACTIVATION_METHOD=tmp_col_1_tmp,A_ASSET_DISPOSED_UU=tmp_col_2_tmp,A_ASSET_STATUS=tmp_col_3_tmp,A_DISPOSED_METHOD=tmp_col_4_tmp,A_DISPOSED_REASON=tmp_col_5_tmp,DESCRIPTION=tmp_col_6_tmp,DOCSTATUS=tmp_col_7_tmp,DOCUMENTNO=tmp_col_8_tmp;
ALTER TABLE A_ASSET_DISPOSED MODIFY (A_ACTIVATION_METHOD VARCHAR2(2 CHAR) DEFAULT 'AA'  NOT NULL,A_DISPOSED_METHOD VARCHAR2(2 CHAR) NOT NULL,DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE A_ASSET_DISPOSED DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table A_ASSET_GROUP
ALTER TABLE A_ASSET_GROUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_ASSET_GROUP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE A_ASSET_GROUP SET tmp_col_1_tmp=A_ASSET_GROUP_UU,A_ASSET_GROUP_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE A_ASSET_GROUP MODIFY (A_ASSET_GROUP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE A_ASSET_GROUP SET A_ASSET_GROUP_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE A_ASSET_GROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_ASSET_GROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_ASSET_GROUP_ACCT
ALTER TABLE A_ASSET_GROUP_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR));
UPDATE A_ASSET_GROUP_ACCT SET tmp_col_1_tmp=A_ASSET_GROUP_ACCT_UU,A_ASSET_GROUP_ACCT_UU=NULL,tmp_col_2_tmp=A_REVAL_CAL_METHOD,A_REVAL_CAL_METHOD=NULL;
ALTER TABLE A_ASSET_GROUP_ACCT MODIFY (A_ASSET_GROUP_ACCT_UU VARCHAR2(36 CHAR),A_REVAL_CAL_METHOD VARCHAR2(22 CHAR));
UPDATE A_ASSET_GROUP_ACCT SET A_ASSET_GROUP_ACCT_UU=tmp_col_1_tmp,A_REVAL_CAL_METHOD=tmp_col_2_tmp;
ALTER TABLE A_ASSET_GROUP_ACCT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_ASSET_GROUP_TRL
ALTER TABLE A_ASSET_GROUP_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_ASSET_GROUP_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE A_ASSET_GROUP_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE A_ASSET_GROUP_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE A_ASSET_GROUP_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE A_ASSET_GROUP_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_ASSET_GROUP_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table A_ASSET_INFO_FIN
ALTER TABLE A_ASSET_INFO_FIN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_FIN SET tmp_col_1_tmp=A_ASSET_INFO_FIN_UU,A_ASSET_INFO_FIN_UU=NULL,tmp_col_2_tmp=A_DUE_ON,A_DUE_ON=NULL,tmp_col_3_tmp=A_FINANCE_METH,A_FINANCE_METH=NULL,tmp_col_4_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE A_ASSET_INFO_FIN MODIFY (A_ASSET_INFO_FIN_UU VARCHAR2(36 CHAR),A_DUE_ON VARCHAR2(22 CHAR),A_FINANCE_METH VARCHAR2(2 CHAR),TEXTMSG VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_FIN SET A_ASSET_INFO_FIN_UU=tmp_col_1_tmp,A_DUE_ON=tmp_col_2_tmp,A_FINANCE_METH=tmp_col_3_tmp,TEXTMSG=tmp_col_4_tmp;
ALTER TABLE A_ASSET_INFO_FIN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_ASSET_INFO_INS
ALTER TABLE A_ASSET_INFO_INS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(100 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_INS SET tmp_col_1_tmp=A_ASSET_INFO_INS_UU,A_ASSET_INFO_INS_UU=NULL,tmp_col_2_tmp=A_INSURANCE_CO,A_INSURANCE_CO=NULL,tmp_col_3_tmp=A_POLICY_NO,A_POLICY_NO=NULL,tmp_col_4_tmp=TEXT,TEXT=NULL;
ALTER TABLE A_ASSET_INFO_INS MODIFY (A_ASSET_INFO_INS_UU VARCHAR2(36 CHAR),A_INSURANCE_CO VARCHAR2(22 CHAR),A_POLICY_NO VARCHAR2(100 CHAR),TEXT VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_INS SET A_ASSET_INFO_INS_UU=tmp_col_1_tmp,A_INSURANCE_CO=tmp_col_2_tmp,A_POLICY_NO=tmp_col_3_tmp,TEXT=tmp_col_4_tmp;
ALTER TABLE A_ASSET_INFO_INS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_ASSET_INFO_LIC
ALTER TABLE A_ASSET_INFO_LIC ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_LIC SET tmp_col_1_tmp=A_ASSET_INFO_LIC_UU,A_ASSET_INFO_LIC_UU=NULL,tmp_col_2_tmp=A_ISSUING_AGENCY,A_ISSUING_AGENCY=NULL,tmp_col_3_tmp=A_LICENSE_NO,A_LICENSE_NO=NULL,tmp_col_4_tmp=A_STATE,A_STATE=NULL,tmp_col_5_tmp=TEXT,TEXT=NULL;
ALTER TABLE A_ASSET_INFO_LIC MODIFY (A_ASSET_INFO_LIC_UU VARCHAR2(36 CHAR),A_ISSUING_AGENCY VARCHAR2(22 CHAR),A_LICENSE_NO VARCHAR2(120 CHAR),A_STATE VARCHAR2(60 CHAR),TEXT VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_LIC SET A_ASSET_INFO_LIC_UU=tmp_col_1_tmp,A_ISSUING_AGENCY=tmp_col_2_tmp,A_LICENSE_NO=tmp_col_3_tmp,A_STATE=tmp_col_4_tmp,TEXT=tmp_col_5_tmp;
ALTER TABLE A_ASSET_INFO_LIC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_ASSET_INFO_OTH
ALTER TABLE A_ASSET_INFO_OTH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(10 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(10 CHAR),tmp_col_8_tmp VARCHAR2(10 CHAR),tmp_col_9_tmp VARCHAR2(3 CHAR),tmp_col_10_tmp VARCHAR2(3 CHAR),tmp_col_11_tmp VARCHAR2(3 CHAR),tmp_col_12_tmp VARCHAR2(3 CHAR),tmp_col_13_tmp VARCHAR2(3 CHAR),tmp_col_14_tmp VARCHAR2(3 CHAR),tmp_col_15_tmp VARCHAR2(3 CHAR),tmp_col_16_tmp VARCHAR2(3 CHAR),tmp_col_17_tmp VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_OTH SET tmp_col_1_tmp=A_ASSET_INFO_OTH_UU,A_ASSET_INFO_OTH_UU=NULL,tmp_col_2_tmp=A_USER1,A_USER1=NULL,tmp_col_3_tmp=A_USER10,A_USER10=NULL,tmp_col_4_tmp=A_USER11,A_USER11=NULL,tmp_col_5_tmp=A_USER12,A_USER12=NULL,tmp_col_6_tmp=A_USER13,A_USER13=NULL,tmp_col_7_tmp=A_USER14,A_USER14=NULL,tmp_col_8_tmp=A_USER15,A_USER15=NULL,tmp_col_9_tmp=A_USER2,A_USER2=NULL,tmp_col_10_tmp=A_USER3,A_USER3=NULL,tmp_col_11_tmp=A_USER4,A_USER4=NULL,tmp_col_12_tmp=A_USER5,A_USER5=NULL,tmp_col_13_tmp=A_USER6,A_USER6=NULL,tmp_col_14_tmp=A_USER7,A_USER7=NULL,tmp_col_15_tmp=A_USER8,A_USER8=NULL,tmp_col_16_tmp=A_USER9,A_USER9=NULL,tmp_col_17_tmp=TEXT,TEXT=NULL;
ALTER TABLE A_ASSET_INFO_OTH MODIFY (A_ASSET_INFO_OTH_UU VARCHAR2(36 CHAR),A_USER1 VARCHAR2(3 CHAR),A_USER10 VARCHAR2(3 CHAR),A_USER11 VARCHAR2(10 CHAR),A_USER12 VARCHAR2(10 CHAR),A_USER13 VARCHAR2(10 CHAR),A_USER14 VARCHAR2(10 CHAR),A_USER15 VARCHAR2(10 CHAR),A_USER2 VARCHAR2(3 CHAR),A_USER3 VARCHAR2(3 CHAR),A_USER4 VARCHAR2(3 CHAR),A_USER5 VARCHAR2(3 CHAR),A_USER6 VARCHAR2(3 CHAR),A_USER7 VARCHAR2(3 CHAR),A_USER8 VARCHAR2(3 CHAR),A_USER9 VARCHAR2(3 CHAR),TEXT VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_OTH SET A_ASSET_INFO_OTH_UU=tmp_col_1_tmp,A_USER1=tmp_col_2_tmp,A_USER10=tmp_col_3_tmp,A_USER11=tmp_col_4_tmp,A_USER12=tmp_col_5_tmp,A_USER13=tmp_col_6_tmp,A_USER14=tmp_col_7_tmp,A_USER15=tmp_col_8_tmp,A_USER2=tmp_col_9_tmp,A_USER3=tmp_col_10_tmp,A_USER4=tmp_col_11_tmp,A_USER5=tmp_col_12_tmp,A_USER6=tmp_col_13_tmp,A_USER7=tmp_col_14_tmp,A_USER8=tmp_col_15_tmp,A_USER9=tmp_col_16_tmp,TEXT=tmp_col_17_tmp;
ALTER TABLE A_ASSET_INFO_OTH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp);

-- Processing table A_ASSET_INFO_TAX
ALTER TABLE A_ASSET_INFO_TAX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(22 CHAR),tmp_col_5_tmp VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_TAX SET tmp_col_1_tmp=A_ASSET_INFO_TAX_UU,A_ASSET_INFO_TAX_UU=NULL,tmp_col_2_tmp=A_FINANCE_METH,A_FINANCE_METH=NULL,tmp_col_3_tmp=A_STATE,A_STATE=NULL,tmp_col_4_tmp=A_TAX_ENTITY,A_TAX_ENTITY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE A_ASSET_INFO_TAX MODIFY (A_ASSET_INFO_TAX_UU VARCHAR2(36 CHAR),A_FINANCE_METH VARCHAR2(2 CHAR),A_STATE VARCHAR2(60 CHAR),A_TAX_ENTITY VARCHAR2(22 CHAR),TEXTMSG VARCHAR2(510 CHAR));
UPDATE A_ASSET_INFO_TAX SET A_ASSET_INFO_TAX_UU=tmp_col_1_tmp,A_FINANCE_METH=tmp_col_2_tmp,A_STATE=tmp_col_3_tmp,A_TAX_ENTITY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE A_ASSET_INFO_TAX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_ASSET_PRODUCT
ALTER TABLE A_ASSET_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE A_ASSET_PRODUCT SET tmp_col_1_tmp=A_ASSET_PRODUCT_UU,A_ASSET_PRODUCT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_ASSET_PRODUCT MODIFY (A_ASSET_PRODUCT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE A_ASSET_PRODUCT SET A_ASSET_PRODUCT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE A_ASSET_PRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_ASSET_RETIREMENT
ALTER TABLE A_ASSET_RETIREMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE A_ASSET_RETIREMENT SET tmp_col_1_tmp=A_ASSET_RETIREMENT_UU,A_ASSET_RETIREMENT_UU=NULL;
ALTER TABLE A_ASSET_RETIREMENT MODIFY (A_ASSET_RETIREMENT_UU VARCHAR2(36 CHAR));
UPDATE A_ASSET_RETIREMENT SET A_ASSET_RETIREMENT_UU=tmp_col_1_tmp;
ALTER TABLE A_ASSET_RETIREMENT DROP (tmp_col_1_tmp);

-- Processing table A_ASSET_REVAL
ALTER TABLE A_ASSET_REVAL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE A_ASSET_REVAL MODIFY (DOCSTATUS NVARCHAR2(2) NULL);
UPDATE A_ASSET_REVAL SET tmp_col_1_tmp=A_ASSET_REVAL_UU,A_ASSET_REVAL_UU=NULL,tmp_col_2_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_ASSET_REVAL MODIFY (A_ASSET_REVAL_UU VARCHAR2(36 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE A_ASSET_REVAL SET A_ASSET_REVAL_UU=tmp_col_1_tmp,DOCSTATUS=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE A_ASSET_REVAL MODIFY (DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'  NOT NULL);
ALTER TABLE A_ASSET_REVAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table A_ASSET_REVAL_ENTRY
ALTER TABLE A_ASSET_REVAL_ENTRY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(3 CHAR),tmp_col_5_tmp VARCHAR2(3 CHAR),tmp_col_6_tmp VARCHAR2(510 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_ASSET_REVAL_ENTRY MODIFY (A_REVAL_CAL_METHOD NVARCHAR2(3) NULL,A_REVAL_EFFECTIVE_DATE NVARCHAR2(2) NULL,A_REVAL_MULTIPLIER NVARCHAR2(3) NULL,A_REV_CODE NVARCHAR2(3) NULL,DESCRIPTION NVARCHAR2(510) NULL,DOCUMENTNO NVARCHAR2(60) NULL);
UPDATE A_ASSET_REVAL_ENTRY SET tmp_col_1_tmp=A_ASSET_REVAL_ENTRY_UU,A_ASSET_REVAL_ENTRY_UU=NULL,tmp_col_2_tmp=A_REVAL_CAL_METHOD,A_REVAL_CAL_METHOD=NULL,tmp_col_3_tmp=A_REVAL_EFFECTIVE_DATE,A_REVAL_EFFECTIVE_DATE=NULL,tmp_col_4_tmp=A_REVAL_MULTIPLIER,A_REVAL_MULTIPLIER=NULL,tmp_col_5_tmp=A_REV_CODE,A_REV_CODE=NULL,tmp_col_6_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_7_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_ASSET_REVAL_ENTRY MODIFY (A_ASSET_REVAL_ENTRY_UU VARCHAR2(36 CHAR),A_REVAL_CAL_METHOD VARCHAR2(3 CHAR),A_REVAL_EFFECTIVE_DATE VARCHAR2(2 CHAR),A_REVAL_MULTIPLIER VARCHAR2(3 CHAR),A_REV_CODE VARCHAR2(3 CHAR),DESCRIPTION VARCHAR2(510 CHAR),DOCUMENTNO VARCHAR2(60 CHAR));
UPDATE A_ASSET_REVAL_ENTRY SET A_ASSET_REVAL_ENTRY_UU=tmp_col_1_tmp,A_REVAL_CAL_METHOD=tmp_col_2_tmp,A_REVAL_EFFECTIVE_DATE=tmp_col_3_tmp,A_REVAL_MULTIPLIER=tmp_col_4_tmp,A_REV_CODE=tmp_col_5_tmp,DESCRIPTION=tmp_col_6_tmp,DOCUMENTNO=tmp_col_7_tmp;
ALTER TABLE A_ASSET_REVAL_ENTRY MODIFY (A_REVAL_CAL_METHOD VARCHAR2(3 CHAR) NOT NULL,A_REVAL_EFFECTIVE_DATE VARCHAR2(2 CHAR) NOT NULL,A_REVAL_MULTIPLIER VARCHAR2(3 CHAR) NOT NULL,A_REV_CODE VARCHAR2(3 CHAR) NOT NULL,DESCRIPTION VARCHAR2(510 CHAR) NOT NULL,DOCUMENTNO VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_ASSET_REVAL_ENTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table A_ASSET_REVAL_INDEX
ALTER TABLE A_ASSET_REVAL_INDEX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR));
ALTER TABLE A_ASSET_REVAL_INDEX MODIFY (A_REVAL_CODE NVARCHAR2(3) NULL,A_REVAL_MULTIPLIER NVARCHAR2(3) NULL);
UPDATE A_ASSET_REVAL_INDEX SET tmp_col_1_tmp=A_ASSET_REVAL_INDEX_UU,A_ASSET_REVAL_INDEX_UU=NULL,tmp_col_2_tmp=A_REVAL_CODE,A_REVAL_CODE=NULL,tmp_col_3_tmp=A_REVAL_MULTIPLIER,A_REVAL_MULTIPLIER=NULL;
ALTER TABLE A_ASSET_REVAL_INDEX MODIFY (A_ASSET_REVAL_INDEX_UU VARCHAR2(36 CHAR),A_REVAL_CODE VARCHAR2(3 CHAR),A_REVAL_MULTIPLIER VARCHAR2(3 CHAR));
UPDATE A_ASSET_REVAL_INDEX SET A_ASSET_REVAL_INDEX_UU=tmp_col_1_tmp,A_REVAL_CODE=tmp_col_2_tmp,A_REVAL_MULTIPLIER=tmp_col_3_tmp;
ALTER TABLE A_ASSET_REVAL_INDEX MODIFY (A_REVAL_CODE VARCHAR2(3 CHAR) NOT NULL,A_REVAL_MULTIPLIER VARCHAR2(3 CHAR) NOT NULL);
ALTER TABLE A_ASSET_REVAL_INDEX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table A_ASSET_SPLIT
ALTER TABLE A_ASSET_SPLIT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR));
ALTER TABLE A_ASSET_SPLIT MODIFY (A_SPLIT_TYPE NVARCHAR2(3) NULL);
UPDATE A_ASSET_SPLIT SET tmp_col_1_tmp=A_ASSET_SPLIT_UU,A_ASSET_SPLIT_UU=NULL,tmp_col_2_tmp=A_SPLIT_TYPE,A_SPLIT_TYPE=NULL;
ALTER TABLE A_ASSET_SPLIT MODIFY (A_ASSET_SPLIT_UU VARCHAR2(36 CHAR),A_SPLIT_TYPE VARCHAR2(3 CHAR));
UPDATE A_ASSET_SPLIT SET A_ASSET_SPLIT_UU=tmp_col_1_tmp,A_SPLIT_TYPE=tmp_col_2_tmp;
ALTER TABLE A_ASSET_SPLIT MODIFY (A_SPLIT_TYPE VARCHAR2(3 CHAR) NOT NULL);
ALTER TABLE A_ASSET_SPLIT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_ASSET_SPREAD
ALTER TABLE A_ASSET_SPREAD ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
UPDATE A_ASSET_SPREAD SET tmp_col_1_tmp=A_ASSET_SPREAD_TYPE,A_ASSET_SPREAD_TYPE=NULL,tmp_col_2_tmp=A_ASSET_SPREAD_UU,A_ASSET_SPREAD_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_ASSET_SPREAD MODIFY (A_ASSET_SPREAD_TYPE VARCHAR2(20 CHAR),A_ASSET_SPREAD_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE A_ASSET_SPREAD SET A_ASSET_SPREAD_TYPE=tmp_col_1_tmp,A_ASSET_SPREAD_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp;
ALTER TABLE A_ASSET_SPREAD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table A_ASSET_TRANSFER
ALTER TABLE A_ASSET_TRANSFER ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(3 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(2 CHAR),tmp_col_9_tmp VARCHAR2(30 CHAR));
ALTER TABLE A_ASSET_TRANSFER MODIFY (A_CAPVSEXP NVARCHAR2(3) NULL,DOCSTATUS NVARCHAR2(2) NULL);
UPDATE A_ASSET_TRANSFER SET tmp_col_1_tmp=A_ACCUMDEPRECIATION_ACCT_STR,A_ACCUMDEPRECIATION_ACCT_STR=NULL,tmp_col_2_tmp=A_ASSET_ACCT_STR,A_ASSET_ACCT_STR=NULL,tmp_col_3_tmp=A_ASSET_TRANSFER_UU,A_ASSET_TRANSFER_UU=NULL,tmp_col_4_tmp=A_CAPVSEXP,A_CAPVSEXP=NULL,tmp_col_5_tmp=A_DEPRECIATION_ACCT_STR,A_DEPRECIATION_ACCT_STR=NULL,tmp_col_6_tmp=A_DISPOSAL_LOSS_STR,A_DISPOSAL_LOSS_STR=NULL,tmp_col_7_tmp=A_DISPOSAL_REVENUE_STR,A_DISPOSAL_REVENUE_STR=NULL,tmp_col_8_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_9_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_ASSET_TRANSFER MODIFY (A_ACCUMDEPRECIATION_ACCT_STR VARCHAR2(40 CHAR),A_ASSET_ACCT_STR VARCHAR2(40 CHAR),A_ASSET_TRANSFER_UU VARCHAR2(36 CHAR),A_CAPVSEXP VARCHAR2(3 CHAR) DEFAULT 'Cap' ,A_DEPRECIATION_ACCT_STR VARCHAR2(40 CHAR),A_DISPOSAL_LOSS_STR VARCHAR2(40 CHAR),A_DISPOSAL_REVENUE_STR VARCHAR2(40 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE A_ASSET_TRANSFER SET A_ACCUMDEPRECIATION_ACCT_STR=tmp_col_1_tmp,A_ASSET_ACCT_STR=tmp_col_2_tmp,A_ASSET_TRANSFER_UU=tmp_col_3_tmp,A_CAPVSEXP=tmp_col_4_tmp,A_DEPRECIATION_ACCT_STR=tmp_col_5_tmp,A_DISPOSAL_LOSS_STR=tmp_col_6_tmp,A_DISPOSAL_REVENUE_STR=tmp_col_7_tmp,DOCSTATUS=tmp_col_8_tmp,DOCUMENTNO=tmp_col_9_tmp;
ALTER TABLE A_ASSET_TRANSFER MODIFY (A_CAPVSEXP VARCHAR2(3 CHAR) DEFAULT 'Cap'  NOT NULL,DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'	NOT NULL);
ALTER TABLE A_ASSET_TRANSFER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table A_ASSET_TYPE
ALTER TABLE A_ASSET_TYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(2 CHAR),tmp_col_5_tmp VARCHAR2(2 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR));
ALTER TABLE A_ASSET_TYPE MODIFY (ISDEPRECIABLE NVARCHAR2(2) NULL,ISINPOSESSION NVARCHAR2(2) NULL,ISOWNED NVARCHAR2(2) NULL,NAME NVARCHAR2(120) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE A_ASSET_TYPE SET tmp_col_1_tmp=A_ASSET_TYPE_UU,A_ASSET_TYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=ISDEPRECIABLE,ISDEPRECIABLE=NULL,tmp_col_4_tmp=ISINPOSESSION,ISINPOSESSION=NULL,tmp_col_5_tmp=ISOWNED,ISOWNED=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE A_ASSET_TYPE MODIFY (A_ASSET_TYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ISDEPRECIABLE VARCHAR2(2 CHAR) DEFAULT 'XX' ,ISINPOSESSION VARCHAR2(2 CHAR) DEFAULT 'XX' ,ISOWNED VARCHAR2(2 CHAR) DEFAULT 'XX' ,NAME VARCHAR2(120 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE A_ASSET_TYPE SET A_ASSET_TYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,ISDEPRECIABLE=tmp_col_3_tmp,ISINPOSESSION=tmp_col_4_tmp,ISOWNED=tmp_col_5_tmp,NAME=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE A_ASSET_TYPE MODIFY (ISDEPRECIABLE VARCHAR2(2 CHAR) DEFAULT 'XX'  NOT NULL,ISINPOSESSION VARCHAR2(2 CHAR) DEFAULT 'XX'  NOT NULL,ISOWNED VARCHAR2(2 CHAR) DEFAULT 'XX'  NOT NULL,NAME VARCHAR2(120 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE A_ASSET_TYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table A_ASSET_USE
ALTER TABLE A_ASSET_USE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE A_ASSET_USE SET tmp_col_1_tmp=A_ASSET_USE_UU,A_ASSET_USE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_ASSET_USE MODIFY (A_ASSET_USE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE A_ASSET_USE SET A_ASSET_USE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE A_ASSET_USE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_DEPRECIATION
ALTER TABLE A_DEPRECIATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(10 CHAR),tmp_col_3_tmp VARCHAR2(510 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
ALTER TABLE A_DEPRECIATION MODIFY (DEPRECIATIONTYPE NVARCHAR2(10) NULL,NAME NVARCHAR2(120) NULL);
UPDATE A_DEPRECIATION SET tmp_col_1_tmp=A_DEPRECIATION_UU,A_DEPRECIATION_UU=NULL,tmp_col_2_tmp=DEPRECIATIONTYPE,DEPRECIATIONTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=SCRIPT,SCRIPT=NULL,tmp_col_6_tmp=TEXT,TEXT=NULL;
ALTER TABLE A_DEPRECIATION MODIFY (A_DEPRECIATION_UU VARCHAR2(36 CHAR),DEPRECIATIONTYPE VARCHAR2(10 CHAR) DEFAULT NULL ,DESCRIPTION VARCHAR2(510 CHAR),NAME VARCHAR2(120 CHAR) DEFAULT NULL ,SCRIPT VARCHAR2(2000 CHAR),TEXT VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION SET A_DEPRECIATION_UU=tmp_col_1_tmp,DEPRECIATIONTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,SCRIPT=tmp_col_5_tmp,TEXT=tmp_col_6_tmp;
ALTER TABLE A_DEPRECIATION MODIFY (DEPRECIATIONTYPE VARCHAR2(10 CHAR) DEFAULT NULL  NOT NULL,NAME VARCHAR2(120 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE A_DEPRECIATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table A_DEPRECIATION_BUILD
ALTER TABLE A_DEPRECIATION_BUILD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE A_DEPRECIATION_BUILD SET tmp_col_1_tmp=A_DEPRECIATION_BUILD_UU,A_DEPRECIATION_BUILD_UU=NULL;
ALTER TABLE A_DEPRECIATION_BUILD MODIFY (A_DEPRECIATION_BUILD_UU VARCHAR2(36 CHAR));
UPDATE A_DEPRECIATION_BUILD SET A_DEPRECIATION_BUILD_UU=tmp_col_1_tmp;
ALTER TABLE A_DEPRECIATION_BUILD DROP (tmp_col_1_tmp);

-- Processing table A_DEPRECIATION_CONVENTION
ALTER TABLE A_DEPRECIATION_CONVENTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(10 CHAR),tmp_col_3_tmp VARCHAR2(510 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION_CONVENTION SET tmp_col_1_tmp=A_DEPRECIATION_CONVENTION_UU,A_DEPRECIATION_CONVENTION_UU=NULL,tmp_col_2_tmp=CONVENTIONTYPE,CONVENTIONTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE A_DEPRECIATION_CONVENTION MODIFY (A_DEPRECIATION_CONVENTION_UU VARCHAR2(36 CHAR),CONVENTIONTYPE VARCHAR2(10 CHAR),DESCRIPTION VARCHAR2(510 CHAR),NAME VARCHAR2(120 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION_CONVENTION SET A_DEPRECIATION_CONVENTION_UU=tmp_col_1_tmp,CONVENTIONTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE A_DEPRECIATION_CONVENTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_DEPRECIATION_ENTRY
ALTER TABLE A_DEPRECIATION_ENTRY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(510 CHAR),tmp_col_4_tmp VARCHAR2(2 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_DEPRECIATION_ENTRY MODIFY (DOCSTATUS NVARCHAR2(2) NULL,DOCUMENTNO NVARCHAR2(60) NULL);
UPDATE A_DEPRECIATION_ENTRY SET tmp_col_1_tmp=A_DEPRECIATION_ENTRY_UU,A_DEPRECIATION_ENTRY_UU=NULL,tmp_col_2_tmp=A_ENTRY_TYPE,A_ENTRY_TYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_5_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE A_DEPRECIATION_ENTRY MODIFY (A_DEPRECIATION_ENTRY_UU VARCHAR2(36 CHAR),A_ENTRY_TYPE VARCHAR2(3 CHAR),DESCRIPTION VARCHAR2(510 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(60 CHAR));
UPDATE A_DEPRECIATION_ENTRY SET A_DEPRECIATION_ENTRY_UU=tmp_col_1_tmp,A_ENTRY_TYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DOCSTATUS=tmp_col_4_tmp,DOCUMENTNO=tmp_col_5_tmp;
ALTER TABLE A_DEPRECIATION_ENTRY MODIFY (DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'  NOT NULL,DOCUMENTNO VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_DEPRECIATION_ENTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_DEPRECIATION_EXP
ALTER TABLE A_DEPRECIATION_EXP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
ALTER TABLE A_DEPRECIATION_EXP MODIFY (A_ENTRY_TYPE NVARCHAR2(3) NULL,DESCRIPTION NVARCHAR2(255) NULL);
UPDATE A_DEPRECIATION_EXP SET tmp_col_1_tmp=A_DEPRECIATION_EXP_UU,A_DEPRECIATION_EXP_UU=NULL,tmp_col_2_tmp=A_ENTRY_TYPE,A_ENTRY_TYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL;
ALTER TABLE A_DEPRECIATION_EXP MODIFY (A_DEPRECIATION_EXP_UU VARCHAR2(36 CHAR),A_ENTRY_TYPE VARCHAR2(3 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION_EXP SET A_DEPRECIATION_EXP_UU=tmp_col_1_tmp,A_ENTRY_TYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp;
ALTER TABLE A_DEPRECIATION_EXP MODIFY (A_ENTRY_TYPE VARCHAR2(3 CHAR) NOT NULL,DESCRIPTION VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE A_DEPRECIATION_EXP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_DEPRECIATION_FORECAST
ALTER TABLE A_DEPRECIATION_FORECAST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE A_DEPRECIATION_FORECAST SET tmp_col_1_tmp=A_DEPRECIATION_FORECAST_UU,A_DEPRECIATION_FORECAST_UU=NULL;
ALTER TABLE A_DEPRECIATION_FORECAST MODIFY (A_DEPRECIATION_FORECAST_UU VARCHAR2(36 CHAR));
UPDATE A_DEPRECIATION_FORECAST SET A_DEPRECIATION_FORECAST_UU=tmp_col_1_tmp;
ALTER TABLE A_DEPRECIATION_FORECAST DROP (tmp_col_1_tmp);

-- Processing table A_DEPRECIATION_METHOD
ALTER TABLE A_DEPRECIATION_METHOD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(10 CHAR),tmp_col_3_tmp VARCHAR2(510 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION_METHOD SET tmp_col_1_tmp=A_DEPRECIATION_METHOD_UU,A_DEPRECIATION_METHOD_UU=NULL,tmp_col_2_tmp=DEPRECIATIONTYPE,DEPRECIATIONTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=TEXT,TEXT=NULL;
ALTER TABLE A_DEPRECIATION_METHOD MODIFY (A_DEPRECIATION_METHOD_UU VARCHAR2(36 CHAR),DEPRECIATIONTYPE VARCHAR2(10 CHAR),DESCRIPTION VARCHAR2(510 CHAR),NAME VARCHAR2(120 CHAR),TEXT VARCHAR2(2000 CHAR));
UPDATE A_DEPRECIATION_METHOD SET A_DEPRECIATION_METHOD_UU=tmp_col_1_tmp,DEPRECIATIONTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,TEXT=tmp_col_5_tmp;
ALTER TABLE A_DEPRECIATION_METHOD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_DEPRECIATION_TABLE_DETAIL
ALTER TABLE A_DEPRECIATION_TABLE_DETAIL ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR));
ALTER TABLE A_DEPRECIATION_TABLE_DETAIL MODIFY (A_DEPRECIATION_TABLE_CODE NVARCHAR2(20) NULL);
UPDATE A_DEPRECIATION_TABLE_DETAIL SET tmp_col_1_tmp=A_DEPRECIATION_TABLE_CODE,A_DEPRECIATION_TABLE_CODE=NULL,tmp_col_2_tmp=A_DEPRECIATION_TABLE_DETAIL_UU,A_DEPRECIATION_TABLE_DETAIL_UU=NULL,tmp_col_3_tmp=A_TABLE_RATE_TYPE,A_TABLE_RATE_TYPE=NULL;
ALTER TABLE A_DEPRECIATION_TABLE_DETAIL MODIFY (A_DEPRECIATION_TABLE_CODE VARCHAR2(20 CHAR),A_DEPRECIATION_TABLE_DETAIL_UU VARCHAR2(36 CHAR),A_TABLE_RATE_TYPE VARCHAR2(2 CHAR) DEFAULT 'RT');
UPDATE A_DEPRECIATION_TABLE_DETAIL SET A_DEPRECIATION_TABLE_CODE=tmp_col_1_tmp,A_DEPRECIATION_TABLE_DETAIL_UU=tmp_col_2_tmp,A_TABLE_RATE_TYPE=tmp_col_3_tmp;
ALTER TABLE A_DEPRECIATION_TABLE_DETAIL MODIFY (A_DEPRECIATION_TABLE_CODE VARCHAR2(20 CHAR) NOT NULL);
ALTER TABLE A_DEPRECIATION_TABLE_DETAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table A_DEPRECIATION_TABLE_HEADER
ALTER TABLE A_DEPRECIATION_TABLE_HEADER ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(2 CHAR),tmp_col_5_tmp VARCHAR2(510 CHAR));
ALTER TABLE A_DEPRECIATION_TABLE_HEADER MODIFY (A_DEPRECIATION_TABLE_CODE NVARCHAR2(20) NULL,A_TABLE_RATE_TYPE NVARCHAR2(2) NULL,A_TERM NVARCHAR2(2) NULL,DESCRIPTION NVARCHAR2(510) NULL);
UPDATE A_DEPRECIATION_TABLE_HEADER SET tmp_col_1_tmp=A_DEPRECIATION_TABLE_CODE,A_DEPRECIATION_TABLE_CODE=NULL,tmp_col_2_tmp=A_DEPRECIATION_TABLE_HEADER_UU,A_DEPRECIATION_TABLE_HEADER_UU=NULL,tmp_col_3_tmp=A_TABLE_RATE_TYPE,A_TABLE_RATE_TYPE=NULL,tmp_col_4_tmp=A_TERM,A_TERM=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_DEPRECIATION_TABLE_HEADER MODIFY (A_DEPRECIATION_TABLE_CODE VARCHAR2(20 CHAR),A_DEPRECIATION_TABLE_HEADER_UU VARCHAR2(36 CHAR),A_TABLE_RATE_TYPE VARCHAR2(2 CHAR),A_TERM VARCHAR2(2 CHAR),DESCRIPTION VARCHAR2(510 CHAR));
UPDATE A_DEPRECIATION_TABLE_HEADER SET A_DEPRECIATION_TABLE_CODE=tmp_col_1_tmp,A_DEPRECIATION_TABLE_HEADER_UU=tmp_col_2_tmp,A_TABLE_RATE_TYPE=tmp_col_3_tmp,A_TERM=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp;
ALTER TABLE A_DEPRECIATION_TABLE_HEADER MODIFY (A_DEPRECIATION_TABLE_CODE VARCHAR2(20 CHAR) NOT NULL,A_TABLE_RATE_TYPE VARCHAR2(2 CHAR) NOT NULL,A_TERM VARCHAR2(2 CHAR) NOT NULL,DESCRIPTION VARCHAR2(510 CHAR) NOT NULL);
ALTER TABLE A_DEPRECIATION_TABLE_HEADER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table A_DEPRECIATION_WORKFILE
ALTER TABLE A_DEPRECIATION_WORKFILE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE A_DEPRECIATION_WORKFILE SET tmp_col_1_tmp=A_DEPRECIATION_WORKFILE_UU,A_DEPRECIATION_WORKFILE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_DEPRECIATION_WORKFILE MODIFY (A_DEPRECIATION_WORKFILE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE A_DEPRECIATION_WORKFILE SET A_DEPRECIATION_WORKFILE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE A_DEPRECIATION_WORKFILE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_FUNDINGMODE
ALTER TABLE A_FUNDINGMODE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR));
ALTER TABLE A_FUNDINGMODE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(30) NULL);
UPDATE A_FUNDINGMODE SET tmp_col_1_tmp=A_FUNDINGMODE_UU,A_FUNDINGMODE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE A_FUNDINGMODE MODIFY (A_FUNDINGMODE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(30 CHAR));
UPDATE A_FUNDINGMODE SET A_FUNDINGMODE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE A_FUNDINGMODE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE A_FUNDINGMODE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_FUNDINGMODE_ACCT
ALTER TABLE A_FUNDINGMODE_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE A_FUNDINGMODE_ACCT SET tmp_col_1_tmp=A_FUNDINGMODE_ACCT_UU,A_FUNDINGMODE_ACCT_UU=NULL;
ALTER TABLE A_FUNDINGMODE_ACCT MODIFY (A_FUNDINGMODE_ACCT_UU VARCHAR2(36 CHAR));
UPDATE A_FUNDINGMODE_ACCT SET A_FUNDINGMODE_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE A_FUNDINGMODE_ACCT DROP (tmp_col_1_tmp);

-- Processing table A_REGISTRATION
ALTER TABLE A_REGISTRATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(120 CHAR));
ALTER TABLE A_REGISTRATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE A_REGISTRATION SET tmp_col_1_tmp=A_REGISTRATION_UU,A_REGISTRATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=NOTE,NOTE=NULL,tmp_col_6_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_7_tmp=REMOTE_HOST,REMOTE_HOST=NULL;
ALTER TABLE A_REGISTRATION MODIFY (A_REGISTRATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),NOTE VARCHAR2(2000 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR));
UPDATE A_REGISTRATION SET A_REGISTRATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,NOTE=tmp_col_5_tmp,REMOTE_ADDR=tmp_col_6_tmp,REMOTE_HOST=tmp_col_7_tmp;
ALTER TABLE A_REGISTRATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_REGISTRATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table A_REGISTRATIONATTRIBUTE
ALTER TABLE A_REGISTRATIONATTRIBUTE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_REGISTRATIONATTRIBUTE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE A_REGISTRATIONATTRIBUTE SET tmp_col_1_tmp=A_REGISTRATIONATTRIBUTE_UU,A_REGISTRATIONATTRIBUTE_UU=NULL,tmp_col_2_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE A_REGISTRATIONATTRIBUTE MODIFY (A_REGISTRATIONATTRIBUTE_UU VARCHAR2(36 CHAR),COLUMNNAME VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE A_REGISTRATIONATTRIBUTE SET A_REGISTRATIONATTRIBUTE_UU=tmp_col_1_tmp,COLUMNNAME=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE A_REGISTRATIONATTRIBUTE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_REGISTRATIONATTRIBUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table A_REGISTRATIONPRODUCT
ALTER TABLE A_REGISTRATIONPRODUCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE A_REGISTRATIONPRODUCT SET tmp_col_1_tmp=A_REGISTRATIONPRODUCT_UU,A_REGISTRATIONPRODUCT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE A_REGISTRATIONPRODUCT MODIFY (A_REGISTRATIONPRODUCT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE A_REGISTRATIONPRODUCT SET A_REGISTRATIONPRODUCT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE A_REGISTRATIONPRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table A_REGISTRATIONVALUE
ALTER TABLE A_REGISTRATIONVALUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE A_REGISTRATIONVALUE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE A_REGISTRATIONVALUE SET tmp_col_1_tmp=A_REGISTRATIONVALUE_UU,A_REGISTRATIONVALUE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE A_REGISTRATIONVALUE MODIFY (A_REGISTRATIONVALUE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE A_REGISTRATIONVALUE SET A_REGISTRATIONVALUE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE A_REGISTRATIONVALUE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE A_REGISTRATIONVALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table B_BID
ALTER TABLE B_BID ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
ALTER TABLE B_BID MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_BID SET tmp_col_1_tmp=B_BID_UU,B_BID_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PRIVATENOTE,PRIVATENOTE=NULL,tmp_col_4_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE B_BID MODIFY (B_BID_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PRIVATENOTE VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE B_BID SET B_BID_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PRIVATENOTE=tmp_col_3_tmp,TEXTMSG=tmp_col_4_tmp;
ALTER TABLE B_BID MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_BID DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table B_BIDCOMMENT
ALTER TABLE B_BIDCOMMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE B_BIDCOMMENT MODIFY (TEXTMSG NVARCHAR2(2000) NULL);
UPDATE B_BIDCOMMENT SET tmp_col_1_tmp=B_BIDCOMMENT_UU,B_BIDCOMMENT_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE B_BIDCOMMENT MODIFY (B_BIDCOMMENT_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE B_BIDCOMMENT SET B_BIDCOMMENT_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp;
ALTER TABLE B_BIDCOMMENT MODIFY (TEXTMSG VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE B_BIDCOMMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table B_BUYER
ALTER TABLE B_BUYER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE B_BUYER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_BUYER SET tmp_col_1_tmp=B_BUYER_UU,B_BUYER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE B_BUYER MODIFY (B_BUYER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE B_BUYER SET B_BUYER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE B_BUYER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_BUYER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table B_BUYERFUNDS
ALTER TABLE B_BUYERFUNDS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE B_BUYERFUNDS SET tmp_col_1_tmp=B_BUYERFUNDS_UU,B_BUYERFUNDS_UU=NULL;
ALTER TABLE B_BUYERFUNDS MODIFY (B_BUYERFUNDS_UU VARCHAR2(36 CHAR));
UPDATE B_BUYERFUNDS SET B_BUYERFUNDS_UU=tmp_col_1_tmp;
ALTER TABLE B_BUYERFUNDS DROP (tmp_col_1_tmp);

-- Processing table B_OFFER
ALTER TABLE B_OFFER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
ALTER TABLE B_OFFER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_OFFER SET tmp_col_1_tmp=B_OFFER_UU,B_OFFER_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PRIVATENOTE,PRIVATENOTE=NULL,tmp_col_4_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE B_OFFER MODIFY (B_OFFER_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PRIVATENOTE VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE B_OFFER SET B_OFFER_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PRIVATENOTE=tmp_col_3_tmp,TEXTMSG=tmp_col_4_tmp;
ALTER TABLE B_OFFER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_OFFER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table B_SELLER
ALTER TABLE B_SELLER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE B_SELLER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_SELLER SET tmp_col_1_tmp=B_SELLER_UU,B_SELLER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE B_SELLER MODIFY (B_SELLER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE B_SELLER SET B_SELLER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE B_SELLER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_SELLER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table B_SELLERFUNDS
ALTER TABLE B_SELLERFUNDS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE B_SELLERFUNDS SET tmp_col_1_tmp=B_SELLERFUNDS_UU,B_SELLERFUNDS_UU=NULL;
ALTER TABLE B_SELLERFUNDS MODIFY (B_SELLERFUNDS_UU VARCHAR2(36 CHAR));
UPDATE B_SELLERFUNDS SET B_SELLERFUNDS_UU=tmp_col_1_tmp;
ALTER TABLE B_SELLERFUNDS DROP (tmp_col_1_tmp);

-- Processing table B_TOPIC
ALTER TABLE B_TOPIC ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE B_TOPIC MODIFY (DOCUMENTNO NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE B_TOPIC SET tmp_col_1_tmp=B_TOPIC_UU,B_TOPIC_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE B_TOPIC MODIFY (B_TOPIC_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),NAME VARCHAR2(60 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE B_TOPIC SET B_TOPIC_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,NAME=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE B_TOPIC MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_TOPIC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table B_TOPICCATEGORY
ALTER TABLE B_TOPICCATEGORY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE B_TOPICCATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_TOPICCATEGORY SET tmp_col_1_tmp=B_TOPICCATEGORY_UU,B_TOPICCATEGORY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE B_TOPICCATEGORY MODIFY (B_TOPICCATEGORY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE B_TOPICCATEGORY SET B_TOPICCATEGORY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE B_TOPICCATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_TOPICCATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table B_TOPICTYPE
ALTER TABLE B_TOPICTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE B_TOPICTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE B_TOPICTYPE SET tmp_col_1_tmp=B_TOPICTYPE_UU,B_TOPICTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE B_TOPICTYPE MODIFY (B_TOPICTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE B_TOPICTYPE SET B_TOPICTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE B_TOPICTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE B_TOPICTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_ACCESSCONTAINER
ALTER TABLE CM_ACCESSCONTAINER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSCONTAINER SET tmp_col_1_tmp=CM_ACCESSCONTAINER_UU,CM_ACCESSCONTAINER_UU=NULL;
ALTER TABLE CM_ACCESSCONTAINER MODIFY (CM_ACCESSCONTAINER_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSCONTAINER SET CM_ACCESSCONTAINER_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSCONTAINER DROP (tmp_col_1_tmp);

-- Processing table CM_ACCESSLISTBPGROUP
ALTER TABLE CM_ACCESSLISTBPGROUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSLISTBPGROUP SET tmp_col_1_tmp=CM_ACCESSLISTBPGROUP_UU,CM_ACCESSLISTBPGROUP_UU=NULL;
ALTER TABLE CM_ACCESSLISTBPGROUP MODIFY (CM_ACCESSLISTBPGROUP_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSLISTBPGROUP SET CM_ACCESSLISTBPGROUP_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSLISTBPGROUP DROP (tmp_col_1_tmp);

-- Processing table CM_ACCESSLISTROLE
ALTER TABLE CM_ACCESSLISTROLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSLISTROLE SET tmp_col_1_tmp=CM_ACCESSLISTROLE_UU,CM_ACCESSLISTROLE_UU=NULL;
ALTER TABLE CM_ACCESSLISTROLE MODIFY (CM_ACCESSLISTROLE_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSLISTROLE SET CM_ACCESSLISTROLE_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSLISTROLE DROP (tmp_col_1_tmp);

-- Processing table CM_ACCESSMEDIA
ALTER TABLE CM_ACCESSMEDIA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSMEDIA SET tmp_col_1_tmp=CM_ACCESSMEDIA_UU,CM_ACCESSMEDIA_UU=NULL;
ALTER TABLE CM_ACCESSMEDIA MODIFY (CM_ACCESSMEDIA_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSMEDIA SET CM_ACCESSMEDIA_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSMEDIA DROP (tmp_col_1_tmp);

-- Processing table CM_ACCESSNEWSCHANNEL
ALTER TABLE CM_ACCESSNEWSCHANNEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSNEWSCHANNEL SET tmp_col_1_tmp=CM_ACCESSNEWSCHANNEL_UU,CM_ACCESSNEWSCHANNEL_UU=NULL;
ALTER TABLE CM_ACCESSNEWSCHANNEL MODIFY (CM_ACCESSNEWSCHANNEL_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSNEWSCHANNEL SET CM_ACCESSNEWSCHANNEL_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSNEWSCHANNEL DROP (tmp_col_1_tmp);

-- Processing table CM_ACCESSPROFILE
ALTER TABLE CM_ACCESSPROFILE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_ACCESSPROFILE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_ACCESSPROFILE SET tmp_col_1_tmp=CM_ACCESSPROFILE_UU,CM_ACCESSPROFILE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_ACCESSPROFILE MODIFY (CM_ACCESSPROFILE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_ACCESSPROFILE SET CM_ACCESSPROFILE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_ACCESSPROFILE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_ACCESSPROFILE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_ACCESSSTAGE
ALTER TABLE CM_ACCESSSTAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_ACCESSSTAGE SET tmp_col_1_tmp=CM_ACCESSSTAGE_UU,CM_ACCESSSTAGE_UU=NULL;
ALTER TABLE CM_ACCESSSTAGE MODIFY (CM_ACCESSSTAGE_UU VARCHAR2(36 CHAR));
UPDATE CM_ACCESSSTAGE SET CM_ACCESSSTAGE_UU=tmp_col_1_tmp;
ALTER TABLE CM_ACCESSSTAGE DROP (tmp_col_1_tmp);

-- Processing table CM_AD
ALTER TABLE CM_AD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR));
ALTER TABLE CM_AD MODIFY (NAME NVARCHAR2(60) NULL,TARGET_FRAME NVARCHAR2(20) NULL);
UPDATE CM_AD SET tmp_col_1_tmp=CM_AD_UU,CM_AD_UU=NULL,tmp_col_2_tmp=CONTENTHTML,CONTENTHTML=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=TARGETURL,TARGETURL=NULL,tmp_col_7_tmp=TARGET_FRAME,TARGET_FRAME=NULL;
ALTER TABLE CM_AD MODIFY (CM_AD_UU VARCHAR2(36 CHAR),CONTENTHTML VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),TARGETURL VARCHAR2(120 CHAR),TARGET_FRAME VARCHAR2(20 CHAR));
UPDATE CM_AD SET CM_AD_UU=tmp_col_1_tmp,CONTENTHTML=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,TARGETURL=tmp_col_6_tmp,TARGET_FRAME=tmp_col_7_tmp;
ALTER TABLE CM_AD MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,TARGET_FRAME VARCHAR2(20 CHAR) NOT NULL);
ALTER TABLE CM_AD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table CM_AD_CAT
ALTER TABLE CM_AD_CAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_AD_CAT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_AD_CAT SET tmp_col_1_tmp=CM_AD_CAT_UU,CM_AD_CAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_AD_CAT MODIFY (CM_AD_CAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_AD_CAT SET CM_AD_CAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_AD_CAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_AD_CAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_BROADCASTSERVER
ALTER TABLE CM_BROADCASTSERVER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_BROADCASTSERVER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_BROADCASTSERVER SET tmp_col_1_tmp=CM_BROADCASTSERVER_UU,CM_BROADCASTSERVER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_BROADCASTSERVER MODIFY (CM_BROADCASTSERVER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_BROADCASTSERVER SET CM_BROADCASTSERVER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_BROADCASTSERVER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_BROADCASTSERVER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_CHAT
ALTER TABLE CM_CHAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
ALTER TABLE CM_CHAT MODIFY (DESCRIPTION NVARCHAR2(255) NULL);
UPDATE CM_CHAT SET tmp_col_1_tmp=CM_CHAT_UU,CM_CHAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE CM_CHAT MODIFY (CM_CHAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE CM_CHAT SET CM_CHAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE CM_CHAT MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE CM_CHAT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table CM_CHATENTRY
ALTER TABLE CM_CHATENTRY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE CM_CHATENTRY SET tmp_col_1_tmp=CM_CHATENTRY_UU,CM_CHATENTRY_UU=NULL,tmp_col_2_tmp=SUBJECT,SUBJECT=NULL;
ALTER TABLE CM_CHATENTRY MODIFY (CM_CHATENTRY_UU VARCHAR2(36 CHAR),SUBJECT VARCHAR2(255 CHAR));
UPDATE CM_CHATENTRY SET CM_CHATENTRY_UU=tmp_col_1_tmp,SUBJECT=tmp_col_2_tmp;
ALTER TABLE CM_CHATENTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table CM_CHATTYPE
ALTER TABLE CM_CHATTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CHATTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CHATTYPE SET tmp_col_1_tmp=CM_CHATTYPE_UU,CM_CHATTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE CM_CHATTYPE MODIFY (CM_CHATTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_CHATTYPE SET CM_CHATTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE CM_CHATTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CHATTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table CM_CHATTYPEUPDATE
ALTER TABLE CM_CHATTYPEUPDATE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_CHATTYPEUPDATE SET tmp_col_1_tmp=CM_CHATTYPEUPDATE_UU,CM_CHATTYPEUPDATE_UU=NULL;
ALTER TABLE CM_CHATTYPEUPDATE MODIFY (CM_CHATTYPEUPDATE_UU VARCHAR2(36 CHAR));
UPDATE CM_CHATTYPEUPDATE SET CM_CHATTYPEUPDATE_UU=tmp_col_1_tmp;
ALTER TABLE CM_CHATTYPEUPDATE DROP (tmp_col_1_tmp);

-- Processing table CM_CHATUPDATE
ALTER TABLE CM_CHATUPDATE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE CM_CHATUPDATE SET tmp_col_1_tmp=CM_CHATUPDATE_UU,CM_CHATUPDATE_UU=NULL;
ALTER TABLE CM_CHATUPDATE MODIFY (CM_CHATUPDATE_UU VARCHAR2(36 CHAR));
UPDATE CM_CHATUPDATE SET CM_CHATUPDATE_UU=tmp_col_1_tmp;
ALTER TABLE CM_CHATUPDATE DROP (tmp_col_1_tmp);

-- Processing table CM_CONTAINER
ALTER TABLE CM_CONTAINER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR),tmp_col_11_tmp VARCHAR2(2000 CHAR),tmp_col_12_tmp VARCHAR2(2000 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(120 CHAR),tmp_col_16_tmp VARCHAR2(2000 CHAR),tmp_col_17_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CONTAINER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CONTAINER SET tmp_col_1_tmp=CM_CONTAINER_UU,CM_CONTAINER_UU=NULL,tmp_col_2_tmp=CONTAINERLINKURL,CONTAINERLINKURL=NULL,tmp_col_3_tmp=CONTAINERXML,CONTAINERXML=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=META_AUTHOR,META_AUTHOR=NULL,tmp_col_7_tmp=META_CONTENT,META_CONTENT=NULL,tmp_col_8_tmp=META_COPYRIGHT,META_COPYRIGHT=NULL,tmp_col_9_tmp=META_DESCRIPTION,META_DESCRIPTION=NULL,tmp_col_10_tmp=META_KEYWORDS,META_KEYWORDS=NULL,tmp_col_11_tmp=META_PUBLISHER,META_PUBLISHER=NULL,tmp_col_12_tmp=META_ROBOTSTAG,META_ROBOTSTAG=NULL,tmp_col_13_tmp=NAME,NAME=NULL,tmp_col_14_tmp=NOTICE,NOTICE=NULL,tmp_col_15_tmp=RELATIVEURL,RELATIVEURL=NULL,tmp_col_16_tmp=STRUCTUREXML,STRUCTUREXML=NULL,tmp_col_17_tmp=TITLE,TITLE=NULL;
ALTER TABLE CM_CONTAINER MODIFY (CM_CONTAINER_UU VARCHAR2(36 CHAR),CONTAINERLINKURL VARCHAR2(60 CHAR),CONTAINERXML VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),META_AUTHOR VARCHAR2(2000 CHAR),META_CONTENT VARCHAR2(2000 CHAR),META_COPYRIGHT VARCHAR2(2000 CHAR),META_DESCRIPTION VARCHAR2(2000 CHAR),META_KEYWORDS VARCHAR2(2000 CHAR),META_PUBLISHER VARCHAR2(2000 CHAR),META_ROBOTSTAG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),NOTICE VARCHAR2(2000 CHAR),RELATIVEURL VARCHAR2(120 CHAR),STRUCTUREXML VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE CM_CONTAINER SET CM_CONTAINER_UU=tmp_col_1_tmp,CONTAINERLINKURL=tmp_col_2_tmp,CONTAINERXML=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,HELP=tmp_col_5_tmp,META_AUTHOR=tmp_col_6_tmp,META_CONTENT=tmp_col_7_tmp,META_COPYRIGHT=tmp_col_8_tmp,META_DESCRIPTION=tmp_col_9_tmp,META_KEYWORDS=tmp_col_10_tmp,META_PUBLISHER=tmp_col_11_tmp,META_ROBOTSTAG=tmp_col_12_tmp,NAME=tmp_col_13_tmp,NOTICE=tmp_col_14_tmp,RELATIVEURL=tmp_col_15_tmp,STRUCTUREXML=tmp_col_16_tmp,TITLE=tmp_col_17_tmp;
ALTER TABLE CM_CONTAINER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp);

-- Processing table CM_CONTAINERTTABLE
ALTER TABLE CM_CONTAINERTTABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE CM_CONTAINERTTABLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CONTAINERTTABLE SET tmp_col_1_tmp=CM_CONTAINERTTABLE_UU,CM_CONTAINERTTABLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_5_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE CM_CONTAINERTTABLE MODIFY (CM_CONTAINERTTABLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE CM_CONTAINERTTABLE SET CM_CONTAINERTTABLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,OTHERCLAUSE=tmp_col_4_tmp,WHERECLAUSE=tmp_col_5_tmp;
ALTER TABLE CM_CONTAINERTTABLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINERTTABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_CONTAINER_ELEMENT
ALTER TABLE CM_CONTAINER_ELEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CONTAINER_ELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CONTAINER_ELEMENT SET tmp_col_1_tmp=CM_CONTAINER_ELEMENT_UU,CM_CONTAINER_ELEMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_CONTAINER_ELEMENT MODIFY (CM_CONTAINER_ELEMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_CONTAINER_ELEMENT SET CM_CONTAINER_ELEMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_CONTAINER_ELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINER_ELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_CONTAINER_ELEMENT_TRL
ALTER TABLE CM_CONTAINER_ELEMENT_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CONTAINER_ELEMENT_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CONTAINER_ELEMENT_TRL SET tmp_col_1_tmp=CM_CONTAINER_ELEMENT_TRL_UU,CM_CONTAINER_ELEMENT_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_CONTAINER_ELEMENT_TRL MODIFY (CM_CONTAINER_ELEMENT_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_CONTAINER_ELEMENT_TRL SET CM_CONTAINER_ELEMENT_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_CONTAINER_ELEMENT_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINER_ELEMENT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_CONTAINER_TRL
ALTER TABLE CM_CONTAINER_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CONTAINER_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CONTAINER_TRL SET tmp_col_1_tmp=CM_CONTAINER_TRL_UU,CM_CONTAINER_TRL_UU=NULL,tmp_col_2_tmp=CONTAINERXML,CONTAINERXML=NULL,tmp_col_3_tmp=META_DESCRIPTION,META_DESCRIPTION=NULL,tmp_col_4_tmp=META_KEYWORDS,META_KEYWORDS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=STRUCTUREXML,STRUCTUREXML=NULL,tmp_col_7_tmp=TITLE,TITLE=NULL;
ALTER TABLE CM_CONTAINER_TRL MODIFY (CM_CONTAINER_TRL_UU VARCHAR2(36 CHAR),CONTAINERXML VARCHAR2(2000 CHAR),META_DESCRIPTION VARCHAR2(2000 CHAR),META_KEYWORDS VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),STRUCTUREXML VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE CM_CONTAINER_TRL SET CM_CONTAINER_TRL_UU=tmp_col_1_tmp,CONTAINERXML=tmp_col_2_tmp,META_DESCRIPTION=tmp_col_3_tmp,META_KEYWORDS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,STRUCTUREXML=tmp_col_6_tmp,TITLE=tmp_col_7_tmp;
ALTER TABLE CM_CONTAINER_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINER_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table CM_CONTAINER_URL
ALTER TABLE CM_CONTAINER_URL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE CM_CONTAINER_URL MODIFY (LAST_RESULT NVARCHAR2(2000) NULL);
UPDATE CM_CONTAINER_URL SET tmp_col_1_tmp=CM_CONTAINER_URL_UU,CM_CONTAINER_URL_UU=NULL,tmp_col_2_tmp=LAST_RESULT,LAST_RESULT=NULL;
ALTER TABLE CM_CONTAINER_URL MODIFY (CM_CONTAINER_URL_UU VARCHAR2(36 CHAR),LAST_RESULT VARCHAR2(2000 CHAR));
UPDATE CM_CONTAINER_URL SET CM_CONTAINER_URL_UU=tmp_col_1_tmp,LAST_RESULT=tmp_col_2_tmp;
ALTER TABLE CM_CONTAINER_URL MODIFY (LAST_RESULT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE CM_CONTAINER_URL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table CM_CSTAGE
ALTER TABLE CM_CSTAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR),tmp_col_11_tmp VARCHAR2(2000 CHAR),tmp_col_12_tmp VARCHAR2(2000 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(120 CHAR),tmp_col_16_tmp VARCHAR2(2000 CHAR),tmp_col_17_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CSTAGE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CSTAGE SET tmp_col_1_tmp=CM_CSTAGE_UU,CM_CSTAGE_UU=NULL,tmp_col_2_tmp=CONTAINERLINKURL,CONTAINERLINKURL=NULL,tmp_col_3_tmp=CONTAINERXML,CONTAINERXML=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=META_AUTHOR,META_AUTHOR=NULL,tmp_col_7_tmp=META_CONTENT,META_CONTENT=NULL,tmp_col_8_tmp=META_COPYRIGHT,META_COPYRIGHT=NULL,tmp_col_9_tmp=META_DESCRIPTION,META_DESCRIPTION=NULL,tmp_col_10_tmp=META_KEYWORDS,META_KEYWORDS=NULL,tmp_col_11_tmp=META_PUBLISHER,META_PUBLISHER=NULL,tmp_col_12_tmp=META_ROBOTSTAG,META_ROBOTSTAG=NULL,tmp_col_13_tmp=NAME,NAME=NULL,tmp_col_14_tmp=NOTICE,NOTICE=NULL,tmp_col_15_tmp=RELATIVEURL,RELATIVEURL=NULL,tmp_col_16_tmp=STRUCTUREXML,STRUCTUREXML=NULL,tmp_col_17_tmp=TITLE,TITLE=NULL;
ALTER TABLE CM_CSTAGE MODIFY (CM_CSTAGE_UU VARCHAR2(36 CHAR),CONTAINERLINKURL VARCHAR2(60 CHAR),CONTAINERXML VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),META_AUTHOR VARCHAR2(2000 CHAR),META_CONTENT VARCHAR2(2000 CHAR),META_COPYRIGHT VARCHAR2(2000 CHAR),META_DESCRIPTION VARCHAR2(2000 CHAR),META_KEYWORDS VARCHAR2(2000 CHAR),META_PUBLISHER VARCHAR2(2000 CHAR),META_ROBOTSTAG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),NOTICE VARCHAR2(2000 CHAR),RELATIVEURL VARCHAR2(120 CHAR),STRUCTUREXML VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE CM_CSTAGE SET CM_CSTAGE_UU=tmp_col_1_tmp,CONTAINERLINKURL=tmp_col_2_tmp,CONTAINERXML=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,HELP=tmp_col_5_tmp,META_AUTHOR=tmp_col_6_tmp,META_CONTENT=tmp_col_7_tmp,META_COPYRIGHT=tmp_col_8_tmp,META_DESCRIPTION=tmp_col_9_tmp,META_KEYWORDS=tmp_col_10_tmp,META_PUBLISHER=tmp_col_11_tmp,META_ROBOTSTAG=tmp_col_12_tmp,NAME=tmp_col_13_tmp,NOTICE=tmp_col_14_tmp,RELATIVEURL=tmp_col_15_tmp,STRUCTUREXML=tmp_col_16_tmp,TITLE=tmp_col_17_tmp;
ALTER TABLE CM_CSTAGE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CSTAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp);

-- Processing table CM_CSTAGETTABLE
ALTER TABLE CM_CSTAGETTABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE CM_CSTAGETTABLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CSTAGETTABLE SET tmp_col_1_tmp=CM_CSTAGETTABLE_UU,CM_CSTAGETTABLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_5_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE CM_CSTAGETTABLE MODIFY (CM_CSTAGETTABLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE CM_CSTAGETTABLE SET CM_CSTAGETTABLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,OTHERCLAUSE=tmp_col_4_tmp,WHERECLAUSE=tmp_col_5_tmp;
ALTER TABLE CM_CSTAGETTABLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CSTAGETTABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_CSTAGE_ELEMENT
ALTER TABLE CM_CSTAGE_ELEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CSTAGE_ELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CSTAGE_ELEMENT SET tmp_col_1_tmp=CM_CSTAGE_ELEMENT_UU,CM_CSTAGE_ELEMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_CSTAGE_ELEMENT MODIFY (CM_CSTAGE_ELEMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_CSTAGE_ELEMENT SET CM_CSTAGE_ELEMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_CSTAGE_ELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CSTAGE_ELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_CSTAGE_ELEMENT_TRL
ALTER TABLE CM_CSTAGE_ELEMENT_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CSTAGE_ELEMENT_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CSTAGE_ELEMENT_TRL SET tmp_col_1_tmp=CM_CSTAGE_ELEMENT_TRL_UU,CM_CSTAGE_ELEMENT_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_CSTAGE_ELEMENT_TRL MODIFY (CM_CSTAGE_ELEMENT_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_CSTAGE_ELEMENT_TRL SET CM_CSTAGE_ELEMENT_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_CSTAGE_ELEMENT_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CSTAGE_ELEMENT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_CSTAGE_TRL
ALTER TABLE CM_CSTAGE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_CSTAGE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_CSTAGE_TRL SET tmp_col_1_tmp=CM_CSTAGE_TRL_UU,CM_CSTAGE_TRL_UU=NULL,tmp_col_2_tmp=CONTAINERXML,CONTAINERXML=NULL,tmp_col_3_tmp=META_DESCRIPTION,META_DESCRIPTION=NULL,tmp_col_4_tmp=META_KEYWORDS,META_KEYWORDS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=STRUCTUREXML,STRUCTUREXML=NULL,tmp_col_7_tmp=TITLE,TITLE=NULL;
ALTER TABLE CM_CSTAGE_TRL MODIFY (CM_CSTAGE_TRL_UU VARCHAR2(36 CHAR),CONTAINERXML VARCHAR2(2000 CHAR),META_DESCRIPTION VARCHAR2(2000 CHAR),META_KEYWORDS VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),STRUCTUREXML VARCHAR2(2000 CHAR),TITLE VARCHAR2(60 CHAR));
UPDATE CM_CSTAGE_TRL SET CM_CSTAGE_TRL_UU=tmp_col_1_tmp,CONTAINERXML=tmp_col_2_tmp,META_DESCRIPTION=tmp_col_3_tmp,META_KEYWORDS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,STRUCTUREXML=tmp_col_6_tmp,TITLE=tmp_col_7_tmp;
ALTER TABLE CM_CSTAGE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_CSTAGE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table CM_MEDIA
ALTER TABLE CM_MEDIA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_MEDIA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_MEDIA SET tmp_col_1_tmp=CM_MEDIA_UU,CM_MEDIA_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE CM_MEDIA MODIFY (CM_MEDIA_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_MEDIA SET CM_MEDIA_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE CM_MEDIA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_MEDIA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table CM_MEDIADEPLOY
ALTER TABLE CM_MEDIADEPLOY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE CM_MEDIADEPLOY SET tmp_col_1_tmp=CM_MEDIADEPLOY_UU,CM_MEDIADEPLOY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE CM_MEDIADEPLOY MODIFY (CM_MEDIADEPLOY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE CM_MEDIADEPLOY SET CM_MEDIADEPLOY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE CM_MEDIADEPLOY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table CM_MEDIA_SERVER
ALTER TABLE CM_MEDIA_SERVER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR));
ALTER TABLE CM_MEDIA_SERVER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_MEDIA_SERVER SET tmp_col_1_tmp=CM_MEDIA_SERVER_UU,CM_MEDIA_SERVER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=URL,URL=NULL;
ALTER TABLE CM_MEDIA_SERVER MODIFY (CM_MEDIA_SERVER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),URL VARCHAR2(120 CHAR));
UPDATE CM_MEDIA_SERVER SET CM_MEDIA_SERVER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,URL=tmp_col_5_tmp;
ALTER TABLE CM_MEDIA_SERVER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_MEDIA_SERVER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_NEWSCHANNEL
ALTER TABLE CM_NEWSCHANNEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_NEWSCHANNEL MODIFY (DESCRIPTION NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE CM_NEWSCHANNEL SET tmp_col_1_tmp=CM_NEWSCHANNEL_UU,CM_NEWSCHANNEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=LINK,LINK=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE CM_NEWSCHANNEL MODIFY (CM_NEWSCHANNEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),LINK VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_NEWSCHANNEL SET CM_NEWSCHANNEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,LINK=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE CM_NEWSCHANNEL MODIFY (DESCRIPTION VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_NEWSCHANNEL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_NEWSITEM
ALTER TABLE CM_NEWSITEM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR));
UPDATE CM_NEWSITEM SET tmp_col_1_tmp=AUTHOR,AUTHOR=NULL,tmp_col_2_tmp=CM_NEWSITEM_UU,CM_NEWSITEM_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=LINKURL,LINKURL=NULL,tmp_col_5_tmp=TITLE,TITLE=NULL;
ALTER TABLE CM_NEWSITEM MODIFY (AUTHOR VARCHAR2(255 CHAR),CM_NEWSITEM_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),LINKURL VARCHAR2(120 CHAR),TITLE VARCHAR2(255 CHAR));
UPDATE CM_NEWSITEM SET AUTHOR=tmp_col_1_tmp,CM_NEWSITEM_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,LINKURL=tmp_col_4_tmp,TITLE=tmp_col_5_tmp;
ALTER TABLE CM_NEWSITEM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_TEMPLATE
ALTER TABLE CM_TEMPLATE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE CM_TEMPLATE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE CM_TEMPLATE SET tmp_col_1_tmp=CM_TEMPLATE_UU,CM_TEMPLATE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=ELEMENTS,ELEMENTS=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE CM_TEMPLATE MODIFY (CM_TEMPLATE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ELEMENTS VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE CM_TEMPLATE SET CM_TEMPLATE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,ELEMENTS=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE CM_TEMPLATE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE CM_TEMPLATE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table CM_TEMPLATETABLE
ALTER TABLE CM_TEMPLATETABLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE CM_TEMPLATETABLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_TEMPLATETABLE SET tmp_col_1_tmp=CM_TEMPLATETABLE_UU,CM_TEMPLATETABLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=OTHERCLAUSE,OTHERCLAUSE=NULL,tmp_col_5_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE CM_TEMPLATETABLE MODIFY (CM_TEMPLATETABLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),OTHERCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE CM_TEMPLATETABLE SET CM_TEMPLATETABLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,OTHERCLAUSE=tmp_col_4_tmp,WHERECLAUSE=tmp_col_5_tmp;
ALTER TABLE CM_TEMPLATETABLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_TEMPLATETABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_TEMPLATE_AD_CAT
ALTER TABLE CM_TEMPLATE_AD_CAT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_TEMPLATE_AD_CAT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_TEMPLATE_AD_CAT SET tmp_col_1_tmp=CM_TEMPLATE_AD_CAT_UU,CM_TEMPLATE_AD_CAT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE CM_TEMPLATE_AD_CAT MODIFY (CM_TEMPLATE_AD_CAT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_TEMPLATE_AD_CAT SET CM_TEMPLATE_AD_CAT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE CM_TEMPLATE_AD_CAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_TEMPLATE_AD_CAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table CM_WEBACCESSLOG
ALTER TABLE CM_WEBACCESSLOG ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(20 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(120 CHAR),tmp_col_9_tmp VARCHAR2(4 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR));
ALTER TABLE CM_WEBACCESSLOG MODIFY (PROTOCOL NVARCHAR2(20) NULL,REQUESTTYPE NVARCHAR2(4) NULL);
UPDATE CM_WEBACCESSLOG SET tmp_col_1_tmp=ACCEPTLANGUAGE,ACCEPTLANGUAGE=NULL,tmp_col_2_tmp=CM_WEBACCESSLOG_UU,CM_WEBACCESSLOG_UU=NULL,tmp_col_3_tmp=HYPHEN,HYPHEN=NULL,tmp_col_4_tmp=PAGEURL,PAGEURL=NULL,tmp_col_5_tmp=PROTOCOL,PROTOCOL=NULL,tmp_col_6_tmp=REFERRER,REFERRER=NULL,tmp_col_7_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_8_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_9_tmp=REQUESTTYPE,REQUESTTYPE=NULL,tmp_col_10_tmp=USERAGENT,USERAGENT=NULL,tmp_col_11_tmp=WEBSESSION,WEBSESSION=NULL;
ALTER TABLE CM_WEBACCESSLOG MODIFY (ACCEPTLANGUAGE VARCHAR2(60 CHAR),CM_WEBACCESSLOG_UU VARCHAR2(36 CHAR),HYPHEN VARCHAR2(20 CHAR),PAGEURL VARCHAR2(120 CHAR),PROTOCOL VARCHAR2(20 CHAR),REFERRER VARCHAR2(120 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR),REQUESTTYPE VARCHAR2(4 CHAR),USERAGENT VARCHAR2(255 CHAR),WEBSESSION VARCHAR2(40 CHAR));
UPDATE CM_WEBACCESSLOG SET ACCEPTLANGUAGE=tmp_col_1_tmp,CM_WEBACCESSLOG_UU=tmp_col_2_tmp,HYPHEN=tmp_col_3_tmp,PAGEURL=tmp_col_4_tmp,PROTOCOL=tmp_col_5_tmp,REFERRER=tmp_col_6_tmp,REMOTE_ADDR=tmp_col_7_tmp,REMOTE_HOST=tmp_col_8_tmp,REQUESTTYPE=tmp_col_9_tmp,USERAGENT=tmp_col_10_tmp,WEBSESSION=tmp_col_11_tmp;
ALTER TABLE CM_WEBACCESSLOG MODIFY (PROTOCOL VARCHAR2(20 CHAR) NOT NULL,REQUESTTYPE VARCHAR2(4 CHAR) NOT NULL);
ALTER TABLE CM_WEBACCESSLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp);

-- Processing table CM_WEBPROJECT
ALTER TABLE CM_WEBPROJECT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_WEBPROJECT MODIFY (META_AUTHOR NVARCHAR2(2000) NULL,META_CONTENT NVARCHAR2(2000) NULL,META_COPYRIGHT NVARCHAR2(2000) NULL,META_PUBLISHER NVARCHAR2(2000) NULL,META_ROBOTSTAG NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL);
UPDATE CM_WEBPROJECT SET tmp_col_1_tmp=CM_WEBPROJECT_UU,CM_WEBPROJECT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=META_AUTHOR,META_AUTHOR=NULL,tmp_col_5_tmp=META_CONTENT,META_CONTENT=NULL,tmp_col_6_tmp=META_COPYRIGHT,META_COPYRIGHT=NULL,tmp_col_7_tmp=META_PUBLISHER,META_PUBLISHER=NULL,tmp_col_8_tmp=META_ROBOTSTAG,META_ROBOTSTAG=NULL,tmp_col_9_tmp=NAME,NAME=NULL;
ALTER TABLE CM_WEBPROJECT MODIFY (CM_WEBPROJECT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),META_AUTHOR VARCHAR2(2000 CHAR),META_CONTENT VARCHAR2(2000 CHAR),META_COPYRIGHT VARCHAR2(2000 CHAR),META_PUBLISHER VARCHAR2(2000 CHAR),META_ROBOTSTAG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_WEBPROJECT SET CM_WEBPROJECT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,META_AUTHOR=tmp_col_4_tmp,META_CONTENT=tmp_col_5_tmp,META_COPYRIGHT=tmp_col_6_tmp,META_PUBLISHER=tmp_col_7_tmp,META_ROBOTSTAG=tmp_col_8_tmp,NAME=tmp_col_9_tmp;
ALTER TABLE CM_WEBPROJECT MODIFY (META_AUTHOR VARCHAR2(2000 CHAR) NOT NULL,META_CONTENT VARCHAR2(2000 CHAR) NOT NULL,META_COPYRIGHT VARCHAR2(2000 CHAR) NOT NULL,META_PUBLISHER VARCHAR2(2000 CHAR) NOT NULL,META_ROBOTSTAG VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_WEBPROJECT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table CM_WEBPROJECT_DOMAIN
ALTER TABLE CM_WEBPROJECT_DOMAIN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE CM_WEBPROJECT_DOMAIN MODIFY (FQDN NVARCHAR2(120) NULL,NAME NVARCHAR2(60) NULL);
UPDATE CM_WEBPROJECT_DOMAIN SET tmp_col_1_tmp=CM_WEBPROJECT_DOMAIN_UU,CM_WEBPROJECT_DOMAIN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FQDN,FQDN=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE CM_WEBPROJECT_DOMAIN MODIFY (CM_WEBPROJECT_DOMAIN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FQDN VARCHAR2(120 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE CM_WEBPROJECT_DOMAIN SET CM_WEBPROJECT_DOMAIN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FQDN=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE CM_WEBPROJECT_DOMAIN MODIFY (FQDN VARCHAR2(120 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_WEBPROJECT_DOMAIN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table CM_WIKITOKEN
ALTER TABLE CM_WIKITOKEN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
ALTER TABLE CM_WIKITOKEN MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE CM_WIKITOKEN SET tmp_col_1_tmp=CM_WIKITOKEN_UU,CM_WIKITOKEN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=MACRO,MACRO=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=SELECTCLAUSE,SELECTCLAUSE=NULL,tmp_col_6_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE CM_WIKITOKEN MODIFY (CM_WIKITOKEN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),MACRO VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),SELECTCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE CM_WIKITOKEN SET CM_WIKITOKEN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,MACRO=tmp_col_3_tmp,NAME=tmp_col_4_tmp,SELECTCLAUSE=tmp_col_5_tmp,WHERECLAUSE=tmp_col_6_tmp;
ALTER TABLE CM_WIKITOKEN MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE CM_WIKITOKEN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_1099BOX
ALTER TABLE C_1099BOX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_1099BOX MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_1099BOX SET tmp_col_1_tmp=C_1099BOX_UU,C_1099BOX_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_1099BOX MODIFY (C_1099BOX_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_1099BOX SET C_1099BOX_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_1099BOX MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_1099BOX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_ACCTPROCESSOR
ALTER TABLE C_ACCTPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ACCTPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_ACCTPROCESSOR SET tmp_col_1_tmp=C_ACCTPROCESSOR_UU,C_ACCTPROCESSOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_ACCTPROCESSOR MODIFY (C_ACCTPROCESSOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_ACCTPROCESSOR SET C_ACCTPROCESSOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_ACCTPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ACCTPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_ACCTPROCESSORLOG
ALTER TABLE C_ACCTPROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE C_ACCTPROCESSORLOG SET tmp_col_1_tmp=C_ACCTPROCESSORLOG_UU,C_ACCTPROCESSORLOG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE C_ACCTPROCESSORLOG MODIFY (C_ACCTPROCESSORLOG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE C_ACCTPROCESSORLOG SET C_ACCTPROCESSORLOG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE C_ACCTPROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_ACCTSCHEMA
ALTER TABLE C_ACCTSCHEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ACCTSCHEMA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_ACCTSCHEMA SET tmp_col_1_tmp=C_ACCTSCHEMA_UU,C_ACCTSCHEMA_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_ACCTSCHEMA MODIFY (C_ACCTSCHEMA_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_ACCTSCHEMA SET C_ACCTSCHEMA_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_ACCTSCHEMA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ACCTSCHEMA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_ACCTSCHEMA_DEFAULT
ALTER TABLE C_ACCTSCHEMA_DEFAULT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ACCTSCHEMA_DEFAULT SET tmp_col_1_tmp=C_ACCTSCHEMA_DEFAULT_UU,C_ACCTSCHEMA_DEFAULT_UU=NULL;
ALTER TABLE C_ACCTSCHEMA_DEFAULT MODIFY (C_ACCTSCHEMA_DEFAULT_UU VARCHAR2(36 CHAR));
UPDATE C_ACCTSCHEMA_DEFAULT SET C_ACCTSCHEMA_DEFAULT_UU=tmp_col_1_tmp;
ALTER TABLE C_ACCTSCHEMA_DEFAULT DROP (tmp_col_1_tmp);

-- Processing table C_ACCTSCHEMA_ELEMENT
ALTER TABLE C_ACCTSCHEMA_ELEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ACCTSCHEMA_ELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_ACCTSCHEMA_ELEMENT SET tmp_col_1_tmp=C_ACCTSCHEMA_ELEMENT_UU,C_ACCTSCHEMA_ELEMENT_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_ACCTSCHEMA_ELEMENT MODIFY (C_ACCTSCHEMA_ELEMENT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_ACCTSCHEMA_ELEMENT SET C_ACCTSCHEMA_ELEMENT_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_ACCTSCHEMA_ELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ACCTSCHEMA_ELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_ACCTSCHEMA_GL
ALTER TABLE C_ACCTSCHEMA_GL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ACCTSCHEMA_GL SET tmp_col_1_tmp=C_ACCTSCHEMA_GL_UU,C_ACCTSCHEMA_GL_UU=NULL;
ALTER TABLE C_ACCTSCHEMA_GL MODIFY (C_ACCTSCHEMA_GL_UU VARCHAR2(36 CHAR));
UPDATE C_ACCTSCHEMA_GL SET C_ACCTSCHEMA_GL_UU=tmp_col_1_tmp;
ALTER TABLE C_ACCTSCHEMA_GL DROP (tmp_col_1_tmp);

-- Processing table C_ACTIVITY
ALTER TABLE C_ACTIVITY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_ACTIVITY MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_ACTIVITY SET tmp_col_1_tmp=C_ACTIVITY_UU,C_ACTIVITY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_ACTIVITY MODIFY (C_ACTIVITY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_ACTIVITY SET C_ACTIVITY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_ACTIVITY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_ACTIVITY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_ACTIVITY_TRL
ALTER TABLE C_ACTIVITY_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ACTIVITY_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_ACTIVITY_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_ACTIVITY_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_ACTIVITY_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_ACTIVITY_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ACTIVITY_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_ADDRESSTRANSACTION
ALTER TABLE C_ADDRESSTRANSACTION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(36 CHAR),tmp_col_8_tmp VARCHAR2(10 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR));
UPDATE C_ADDRESSTRANSACTION SET tmp_col_1_tmp=ADDRESS1,ADDRESS1=NULL,tmp_col_2_tmp=ADDRESS2,ADDRESS2=NULL,tmp_col_3_tmp=ADDRESS3,ADDRESS3=NULL,tmp_col_4_tmp=ADDRESS4,ADDRESS4=NULL,tmp_col_5_tmp=CITY,CITY=NULL,tmp_col_6_tmp=COUNTRY,COUNTRY=NULL,tmp_col_7_tmp=C_ADDRESSTRANSACTION_UU,C_ADDRESSTRANSACTION_UU=NULL,tmp_col_8_tmp=POSTAL,POSTAL=NULL,tmp_col_9_tmp=REGION,REGION=NULL,tmp_col_10_tmp=RESULT,RESULT=NULL;
ALTER TABLE C_ADDRESSTRANSACTION MODIFY (ADDRESS1 VARCHAR2(60 CHAR),ADDRESS2 VARCHAR2(60 CHAR),ADDRESS3 VARCHAR2(60 CHAR),ADDRESS4 VARCHAR2(60 CHAR),CITY VARCHAR2(60 CHAR),COUNTRY VARCHAR2(60 CHAR),C_ADDRESSTRANSACTION_UU VARCHAR2(36 CHAR),POSTAL VARCHAR2(10 CHAR),REGION VARCHAR2(60 CHAR),RESULT VARCHAR2(2000 CHAR));
UPDATE C_ADDRESSTRANSACTION SET ADDRESS1=tmp_col_1_tmp,ADDRESS2=tmp_col_2_tmp,ADDRESS3=tmp_col_3_tmp,ADDRESS4=tmp_col_4_tmp,CITY=tmp_col_5_tmp,COUNTRY=tmp_col_6_tmp,C_ADDRESSTRANSACTION_UU=tmp_col_7_tmp,POSTAL=tmp_col_8_tmp,REGION=tmp_col_9_tmp,RESULT=tmp_col_10_tmp;
ALTER TABLE C_ADDRESSTRANSACTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table C_ADDRESSVALIDATION
ALTER TABLE C_ADDRESSVALIDATION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ADDRESSVALIDATION MODIFY (CONNECTIONPASSWORD NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL,USERID NVARCHAR2(60) NULL);
UPDATE C_ADDRESSVALIDATION SET tmp_col_1_tmp=CONNECTIONKEY,CONNECTIONKEY=NULL,tmp_col_2_tmp=CONNECTIONPASSWORD,CONNECTIONPASSWORD=NULL,tmp_col_3_tmp=C_ADDRESSVALIDATION_UU,C_ADDRESSVALIDATION_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=SHIPPERACCOUNT,SHIPPERACCOUNT=NULL,tmp_col_6_tmp=SHIPPERMETER,SHIPPERMETER=NULL,tmp_col_7_tmp=USERID,USERID=NULL;
ALTER TABLE C_ADDRESSVALIDATION MODIFY (CONNECTIONKEY VARCHAR2(60 CHAR),CONNECTIONPASSWORD VARCHAR2(60 CHAR),C_ADDRESSVALIDATION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),SHIPPERACCOUNT VARCHAR2(40 CHAR),SHIPPERMETER VARCHAR2(255 CHAR),USERID VARCHAR2(60 CHAR));
UPDATE C_ADDRESSVALIDATION SET CONNECTIONKEY=tmp_col_1_tmp,CONNECTIONPASSWORD=tmp_col_2_tmp,C_ADDRESSVALIDATION_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,SHIPPERACCOUNT=tmp_col_5_tmp,SHIPPERMETER=tmp_col_6_tmp,USERID=tmp_col_7_tmp;
ALTER TABLE C_ADDRESSVALIDATION MODIFY (CONNECTIONPASSWORD VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,USERID VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ADDRESSVALIDATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table C_ADDRESSVALIDATIONCFG
ALTER TABLE C_ADDRESSVALIDATIONCFG ADD (tmp_col_1_tmp VARCHAR2(100 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_ADDRESSVALIDATIONCFG MODIFY (HOSTADDRESS NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL);
UPDATE C_ADDRESSVALIDATIONCFG SET tmp_col_1_tmp=ADDRESSVALIDATIONCLASS,ADDRESSVALIDATIONCLASS=NULL,tmp_col_2_tmp=C_ADDRESSVALIDATIONCFG_UU,C_ADDRESSVALIDATIONCFG_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HOSTADDRESS,HOSTADDRESS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PROXYADDRESS,PROXYADDRESS=NULL,tmp_col_7_tmp=PROXYLOGON,PROXYLOGON=NULL,tmp_col_8_tmp=PROXYPASSWORD,PROXYPASSWORD=NULL,tmp_col_9_tmp=SERVICEPATH,SERVICEPATH=NULL;
ALTER TABLE C_ADDRESSVALIDATIONCFG MODIFY (ADDRESSVALIDATIONCLASS VARCHAR2(100 CHAR),C_ADDRESSVALIDATIONCFG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HOSTADDRESS VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),PROXYADDRESS VARCHAR2(60 CHAR),PROXYLOGON VARCHAR2(60 CHAR),PROXYPASSWORD VARCHAR2(60 CHAR),SERVICEPATH VARCHAR2(60 CHAR));
UPDATE C_ADDRESSVALIDATIONCFG SET ADDRESSVALIDATIONCLASS=tmp_col_1_tmp,C_ADDRESSVALIDATIONCFG_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HOSTADDRESS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PROXYADDRESS=tmp_col_6_tmp,PROXYLOGON=tmp_col_7_tmp,PROXYPASSWORD=tmp_col_8_tmp,SERVICEPATH=tmp_col_9_tmp;
ALTER TABLE C_ADDRESSVALIDATIONCFG MODIFY (HOSTADDRESS VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ADDRESSVALIDATIONCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table C_ALLOCATIONHDR
ALTER TABLE C_ALLOCATIONHDR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_ALLOCATIONHDR MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_ALLOCATIONHDR SET tmp_col_1_tmp=C_ALLOCATIONHDR_UU,C_ALLOCATIONHDR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_ALLOCATIONHDR MODIFY (C_ALLOCATIONHDR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_ALLOCATIONHDR SET C_ALLOCATIONHDR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_ALLOCATIONHDR MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_ALLOCATIONHDR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_ALLOCATIONLINE
ALTER TABLE C_ALLOCATIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ALLOCATIONLINE SET tmp_col_1_tmp=C_ALLOCATIONLINE_UU,C_ALLOCATIONLINE_UU=NULL;
ALTER TABLE C_ALLOCATIONLINE MODIFY (C_ALLOCATIONLINE_UU VARCHAR2(36 CHAR));
UPDATE C_ALLOCATIONLINE SET C_ALLOCATIONLINE_UU=tmp_col_1_tmp;
ALTER TABLE C_ALLOCATIONLINE DROP (tmp_col_1_tmp);

-- Processing table C_BANK
ALTER TABLE C_BANK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR));
ALTER TABLE C_BANK MODIFY (NAME NVARCHAR2(60) NULL,ROUTINGNO NVARCHAR2(20) NULL);
UPDATE C_BANK SET tmp_col_1_tmp=C_BANK_UU,C_BANK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=ROUTINGNO,ROUTINGNO=NULL,tmp_col_5_tmp=SWIFTCODE,SWIFTCODE=NULL;
ALTER TABLE C_BANK MODIFY (C_BANK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),ROUTINGNO VARCHAR2(20 CHAR),SWIFTCODE VARCHAR2(20 CHAR));
UPDATE C_BANK SET C_BANK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,ROUTINGNO=tmp_col_4_tmp,SWIFTCODE=tmp_col_5_tmp;
ALTER TABLE C_BANK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,ROUTINGNO VARCHAR2(20 CHAR) NOT NULL);
ALTER TABLE C_BANK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_BANKACCOUNT
ALTER TABLE C_BANKACCOUNT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_BANKACCOUNT MODIFY (ACCOUNTNO NVARCHAR2(20) NULL,NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_BANKACCOUNT SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=BBAN,BBAN=NULL,tmp_col_3_tmp=C_BANKACCOUNT_UU,C_BANKACCOUNT_UU=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=IBAN,IBAN=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PAYMENTEXPORTCLASS,PAYMENTEXPORTCLASS=NULL,tmp_col_8_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_BANKACCOUNT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),BBAN VARCHAR2(40 CHAR),C_BANKACCOUNT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),IBAN VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,PAYMENTEXPORTCLASS VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR) DEFAULT NULL );
UPDATE C_BANKACCOUNT SET ACCOUNTNO=tmp_col_1_tmp,BBAN=tmp_col_2_tmp,C_BANKACCOUNT_UU=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,IBAN=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PAYMENTEXPORTCLASS=tmp_col_7_tmp,VALUE=tmp_col_8_tmp;
ALTER TABLE C_BANKACCOUNT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL,VALUE VARCHAR2(40 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE C_BANKACCOUNT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table C_BANKACCOUNTDOC
ALTER TABLE C_BANKACCOUNTDOC ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BANKACCOUNTDOC MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_BANKACCOUNTDOC SET tmp_col_1_tmp=C_BANKACCOUNTDOC_UU,C_BANKACCOUNTDOC_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_BANKACCOUNTDOC MODIFY (C_BANKACCOUNTDOC_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_BANKACCOUNTDOC SET C_BANKACCOUNTDOC_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_BANKACCOUNTDOC MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BANKACCOUNTDOC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_BANKACCOUNT_ACCT
ALTER TABLE C_BANKACCOUNT_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_BANKACCOUNT_ACCT SET tmp_col_1_tmp=C_BANKACCOUNT_ACCT_UU,C_BANKACCOUNT_ACCT_UU=NULL;
ALTER TABLE C_BANKACCOUNT_ACCT MODIFY (C_BANKACCOUNT_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_BANKACCOUNT_ACCT SET C_BANKACCOUNT_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_BANKACCOUNT_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_BANKACCOUNT_PROCESSOR
ALTER TABLE C_BANKACCOUNT_PROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(100 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BANKACCOUNT_PROCESSOR MODIFY (PASSWORD NVARCHAR2(60) NULL,USERID NVARCHAR2(100) NULL);
UPDATE C_BANKACCOUNT_PROCESSOR SET tmp_col_1_tmp=C_BANKACCOUNT_PROCESSOR_UU,C_BANKACCOUNT_PROCESSOR_UU=NULL,tmp_col_2_tmp=PARTNERID,PARTNERID=NULL,tmp_col_3_tmp=PASSWORD,PASSWORD=NULL,tmp_col_4_tmp=USERID,USERID=NULL,tmp_col_5_tmp=VENDORID,VENDORID=NULL;
ALTER TABLE C_BANKACCOUNT_PROCESSOR MODIFY (C_BANKACCOUNT_PROCESSOR_UU VARCHAR2(36 CHAR),PARTNERID VARCHAR2(60 CHAR),PASSWORD VARCHAR2(60 CHAR) DEFAULT NULL ,USERID VARCHAR2(100 CHAR) DEFAULT NULL ,VENDORID VARCHAR2(60 CHAR));
UPDATE C_BANKACCOUNT_PROCESSOR SET C_BANKACCOUNT_PROCESSOR_UU=tmp_col_1_tmp,PARTNERID=tmp_col_2_tmp,PASSWORD=tmp_col_3_tmp,USERID=tmp_col_4_tmp,VENDORID=tmp_col_5_tmp;
ALTER TABLE C_BANKACCOUNT_PROCESSOR MODIFY (PASSWORD VARCHAR2(60 CHAR) DEFAULT NULL	NOT NULL,USERID VARCHAR2(100 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE C_BANKACCOUNT_PROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_BANKSTATEMENT
ALTER TABLE C_BANKSTATEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BANKSTATEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_BANKSTATEMENT SET tmp_col_1_tmp=C_BANKSTATEMENT_UU,C_BANKSTATEMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=EFTSTATEMENTREFERENCE,EFTSTATEMENTREFERENCE=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_BANKSTATEMENT MODIFY (C_BANKSTATEMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EFTSTATEMENTREFERENCE VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_BANKSTATEMENT SET C_BANKSTATEMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,EFTSTATEMENTREFERENCE=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_BANKSTATEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BANKSTATEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_BANKSTATEMENTLINE
ALTER TABLE C_BANKSTATEMENTLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(20 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR));
UPDATE C_BANKSTATEMENTLINE SET tmp_col_1_tmp=C_BANKSTATEMENTLINE_UU,C_BANKSTATEMENTLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=EFTCHECKNO,EFTCHECKNO=NULL,tmp_col_4_tmp=EFTCURRENCY,EFTCURRENCY=NULL,tmp_col_5_tmp=EFTMEMO,EFTMEMO=NULL,tmp_col_6_tmp=EFTPAYEE,EFTPAYEE=NULL,tmp_col_7_tmp=EFTPAYEEACCOUNT,EFTPAYEEACCOUNT=NULL,tmp_col_8_tmp=EFTREFERENCE,EFTREFERENCE=NULL,tmp_col_9_tmp=EFTTRXID,EFTTRXID=NULL,tmp_col_10_tmp=EFTTRXTYPE,EFTTRXTYPE=NULL,tmp_col_11_tmp=MEMO,MEMO=NULL,tmp_col_12_tmp=REFERENCENO,REFERENCENO=NULL;
ALTER TABLE C_BANKSTATEMENTLINE MODIFY (C_BANKSTATEMENTLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EFTCHECKNO VARCHAR2(20 CHAR),EFTCURRENCY VARCHAR2(20 CHAR),EFTMEMO VARCHAR2(2000 CHAR),EFTPAYEE VARCHAR2(255 CHAR),EFTPAYEEACCOUNT VARCHAR2(40 CHAR),EFTREFERENCE VARCHAR2(60 CHAR),EFTTRXID VARCHAR2(40 CHAR),EFTTRXTYPE VARCHAR2(20 CHAR),MEMO VARCHAR2(255 CHAR),REFERENCENO VARCHAR2(40 CHAR));
UPDATE C_BANKSTATEMENTLINE SET C_BANKSTATEMENTLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,EFTCHECKNO=tmp_col_3_tmp,EFTCURRENCY=tmp_col_4_tmp,EFTMEMO=tmp_col_5_tmp,EFTPAYEE=tmp_col_6_tmp,EFTPAYEEACCOUNT=tmp_col_7_tmp,EFTREFERENCE=tmp_col_8_tmp,EFTTRXID=tmp_col_9_tmp,EFTTRXTYPE=tmp_col_10_tmp,MEMO=tmp_col_11_tmp,REFERENCENO=tmp_col_12_tmp;
ALTER TABLE C_BANKSTATEMENTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp);

-- Processing table C_BANKSTATEMENTLOADER
ALTER TABLE C_BANKSTATEMENTLOADER ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(60 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BANKSTATEMENTLOADER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_BANKSTATEMENTLOADER SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=BRANCHID,BRANCHID=NULL,tmp_col_3_tmp=C_BANKSTATEMENTLOADER_UU,C_BANKSTATEMENTLOADER_UU=NULL,tmp_col_4_tmp=DATEFORMAT,DATEFORMAT=NULL,tmp_col_5_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_6_tmp=FILENAME,FILENAME=NULL,tmp_col_7_tmp=FINANCIALINSTITUTIONID,FINANCIALINSTITUTIONID=NULL,tmp_col_8_tmp=HOSTADDRESS,HOSTADDRESS=NULL,tmp_col_9_tmp=NAME,NAME=NULL,tmp_col_10_tmp=PASSWORD,PASSWORD=NULL,tmp_col_11_tmp=PIN,PIN=NULL,tmp_col_12_tmp=PROXYADDRESS,PROXYADDRESS=NULL,tmp_col_13_tmp=PROXYLOGON,PROXYLOGON=NULL,tmp_col_14_tmp=PROXYPASSWORD,PROXYPASSWORD=NULL,tmp_col_15_tmp=STMTLOADERCLASS,STMTLOADERCLASS=NULL,tmp_col_16_tmp=USERID,USERID=NULL;
ALTER TABLE C_BANKSTATEMENTLOADER MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),BRANCHID VARCHAR2(20 CHAR),C_BANKSTATEMENTLOADER_UU VARCHAR2(36 CHAR),DATEFORMAT VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FILENAME VARCHAR2(120 CHAR),FINANCIALINSTITUTIONID VARCHAR2(20 CHAR),HOSTADDRESS VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),PASSWORD VARCHAR2(60 CHAR),PIN VARCHAR2(20 CHAR),PROXYADDRESS VARCHAR2(60 CHAR),PROXYLOGON VARCHAR2(60 CHAR),PROXYPASSWORD VARCHAR2(60 CHAR),STMTLOADERCLASS VARCHAR2(60 CHAR),USERID VARCHAR2(60 CHAR));
UPDATE C_BANKSTATEMENTLOADER SET ACCOUNTNO=tmp_col_1_tmp,BRANCHID=tmp_col_2_tmp,C_BANKSTATEMENTLOADER_UU=tmp_col_3_tmp,DATEFORMAT=tmp_col_4_tmp,DESCRIPTION=tmp_col_5_tmp,FILENAME=tmp_col_6_tmp,FINANCIALINSTITUTIONID=tmp_col_7_tmp,HOSTADDRESS=tmp_col_8_tmp,NAME=tmp_col_9_tmp,PASSWORD=tmp_col_10_tmp,PIN=tmp_col_11_tmp,PROXYADDRESS=tmp_col_12_tmp,PROXYLOGON=tmp_col_13_tmp,PROXYPASSWORD=tmp_col_14_tmp,STMTLOADERCLASS=tmp_col_15_tmp,USERID=tmp_col_16_tmp;
ALTER TABLE C_BANKSTATEMENTLOADER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BANKSTATEMENTLOADER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp);

-- Processing table C_BANKSTATEMENTMATCHER
ALTER TABLE C_BANKSTATEMENTMATCHER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BANKSTATEMENTMATCHER MODIFY (CLASSNAME NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL);
UPDATE C_BANKSTATEMENTMATCHER SET tmp_col_1_tmp=CLASSNAME,CLASSNAME=NULL,tmp_col_2_tmp=C_BANKSTATEMENTMATCHER_UU,C_BANKSTATEMENTMATCHER_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_BANKSTATEMENTMATCHER MODIFY (CLASSNAME VARCHAR2(60 CHAR),C_BANKSTATEMENTMATCHER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_BANKSTATEMENTMATCHER SET CLASSNAME=tmp_col_1_tmp,C_BANKSTATEMENTMATCHER_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_BANKSTATEMENTMATCHER MODIFY (CLASSNAME VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BANKSTATEMENTMATCHER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_BPARTNER
ALTER TABLE C_BPARTNER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(120 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_BPARTNER MODIFY (NAME NVARCHAR2(120) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_BPARTNER SET tmp_col_1_tmp=CUSTOMERPROFILEID,CUSTOMERPROFILEID=NULL,tmp_col_2_tmp=C_BPARTNER_UU,C_BPARTNER_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=NAME2,NAME2=NULL,tmp_col_6_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_7_tmp=REFERENCENO,REFERENCENO=NULL,tmp_col_8_tmp=SO_DESCRIPTION,SO_DESCRIPTION=NULL,tmp_col_9_tmp=URL,URL=NULL,tmp_col_10_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_BPARTNER MODIFY (CUSTOMERPROFILEID VARCHAR2(60 CHAR),C_BPARTNER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR),NAME2 VARCHAR2(60 CHAR),POREFERENCE VARCHAR2(20 CHAR),REFERENCENO VARCHAR2(40 CHAR),SO_DESCRIPTION VARCHAR2(255 CHAR),URL VARCHAR2(120 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_BPARTNER SET CUSTOMERPROFILEID=tmp_col_1_tmp,C_BPARTNER_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp,NAME2=tmp_col_5_tmp,POREFERENCE=tmp_col_6_tmp,REFERENCENO=tmp_col_7_tmp,SO_DESCRIPTION=tmp_col_8_tmp,URL=tmp_col_9_tmp,VALUE=tmp_col_10_tmp;
ALTER TABLE C_BPARTNER MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_BPARTNER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table C_BPARTNER_LOCATION
ALTER TABLE C_BPARTNER_LOCATION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_BPARTNER_LOCATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_BPARTNER_LOCATION SET tmp_col_1_tmp=CUSTOMERADDRESSID,CUSTOMERADDRESSID=NULL,tmp_col_2_tmp=C_BPARTNER_LOCATION_UU,C_BPARTNER_LOCATION_UU=NULL,tmp_col_3_tmp=FAX,FAX=NULL,tmp_col_4_tmp=ISDN,ISDN=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PHONE,PHONE=NULL,tmp_col_7_tmp=PHONE2,PHONE2=NULL;
ALTER TABLE C_BPARTNER_LOCATION MODIFY (CUSTOMERADDRESSID VARCHAR2(60 CHAR),C_BPARTNER_LOCATION_UU VARCHAR2(36 CHAR),FAX VARCHAR2(40 CHAR),ISDN VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR),PHONE VARCHAR2(40 CHAR),PHONE2 VARCHAR2(40 CHAR));
UPDATE C_BPARTNER_LOCATION SET CUSTOMERADDRESSID=tmp_col_1_tmp,C_BPARTNER_LOCATION_UU=tmp_col_2_tmp,FAX=tmp_col_3_tmp,ISDN=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PHONE=tmp_col_6_tmp,PHONE2=tmp_col_7_tmp;
ALTER TABLE C_BPARTNER_LOCATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BPARTNER_LOCATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table C_BPARTNER_PRODUCT
ALTER TABLE C_BPARTNER_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(30 CHAR));
UPDATE C_BPARTNER_PRODUCT SET tmp_col_1_tmp=C_BPARTNER_PRODUCT_UU,C_BPARTNER_PRODUCT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=MANUFACTURER,MANUFACTURER=NULL,tmp_col_4_tmp=VENDORCATEGORY,VENDORCATEGORY=NULL,tmp_col_5_tmp=VENDORPRODUCTNO,VENDORPRODUCTNO=NULL;
ALTER TABLE C_BPARTNER_PRODUCT MODIFY (C_BPARTNER_PRODUCT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),MANUFACTURER VARCHAR2(30 CHAR),VENDORCATEGORY VARCHAR2(30 CHAR),VENDORPRODUCTNO VARCHAR2(30 CHAR));
UPDATE C_BPARTNER_PRODUCT SET C_BPARTNER_PRODUCT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,MANUFACTURER=tmp_col_3_tmp,VENDORCATEGORY=tmp_col_4_tmp,VENDORPRODUCTNO=tmp_col_5_tmp;
ALTER TABLE C_BPARTNER_PRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_BP_BANKACCOUNT
ALTER TABLE C_BP_BANKACCOUNT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(36 CHAR),tmp_col_14_tmp VARCHAR2(20 CHAR));
UPDATE C_BP_BANKACCOUNT SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=A_CITY,A_CITY=NULL,tmp_col_3_tmp=A_COUNTRY,A_COUNTRY=NULL,tmp_col_4_tmp=A_EMAIL,A_EMAIL=NULL,tmp_col_5_tmp=A_IDENT_DL,A_IDENT_DL=NULL,tmp_col_6_tmp=A_IDENT_SSN,A_IDENT_SSN=NULL,tmp_col_7_tmp=A_NAME,A_NAME=NULL,tmp_col_8_tmp=A_STATE,A_STATE=NULL,tmp_col_9_tmp=A_STREET,A_STREET=NULL,tmp_col_10_tmp=A_ZIP,A_ZIP=NULL,tmp_col_11_tmp=CREDITCARDNUMBER,CREDITCARDNUMBER=NULL,tmp_col_12_tmp=CUSTOMERPAYMENTPROFILEID,CUSTOMERPAYMENTPROFILEID=NULL,tmp_col_13_tmp=C_BP_BANKACCOUNT_UU,C_BP_BANKACCOUNT_UU=NULL,tmp_col_14_tmp=ROUTINGNO,ROUTINGNO=NULL;
ALTER TABLE C_BP_BANKACCOUNT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),A_CITY VARCHAR2(60 CHAR),A_COUNTRY VARCHAR2(40 CHAR),A_EMAIL VARCHAR2(60 CHAR),A_IDENT_DL VARCHAR2(20 CHAR),A_IDENT_SSN VARCHAR2(20 CHAR),A_NAME VARCHAR2(60 CHAR),A_STATE VARCHAR2(40 CHAR),A_STREET VARCHAR2(60 CHAR),A_ZIP VARCHAR2(20 CHAR),CREDITCARDNUMBER VARCHAR2(20 CHAR),CUSTOMERPAYMENTPROFILEID VARCHAR2(60 CHAR),C_BP_BANKACCOUNT_UU VARCHAR2(36 CHAR),ROUTINGNO VARCHAR2(20 CHAR));
UPDATE C_BP_BANKACCOUNT SET ACCOUNTNO=tmp_col_1_tmp,A_CITY=tmp_col_2_tmp,A_COUNTRY=tmp_col_3_tmp,A_EMAIL=tmp_col_4_tmp,A_IDENT_DL=tmp_col_5_tmp,A_IDENT_SSN=tmp_col_6_tmp,A_NAME=tmp_col_7_tmp,A_STATE=tmp_col_8_tmp,A_STREET=tmp_col_9_tmp,A_ZIP=tmp_col_10_tmp,CREDITCARDNUMBER=tmp_col_11_tmp,CUSTOMERPAYMENTPROFILEID=tmp_col_12_tmp,C_BP_BANKACCOUNT_UU=tmp_col_13_tmp,ROUTINGNO=tmp_col_14_tmp;
ALTER TABLE C_BP_BANKACCOUNT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp);

-- Processing table C_BP_CUSTOMER_ACCT
ALTER TABLE C_BP_CUSTOMER_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_BP_CUSTOMER_ACCT SET tmp_col_1_tmp=C_BP_CUSTOMER_ACCT_UU,C_BP_CUSTOMER_ACCT_UU=NULL;
ALTER TABLE C_BP_CUSTOMER_ACCT MODIFY (C_BP_CUSTOMER_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_BP_CUSTOMER_ACCT SET C_BP_CUSTOMER_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_BP_CUSTOMER_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_BP_EDI
ALTER TABLE C_BP_EDI ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BP_EDI MODIFY (CUSTOMERNO NVARCHAR2(20) NULL,EMAIL_ERROR_TO NVARCHAR2(60) NULL,EMAIL_INFO_TO NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL);
UPDATE C_BP_EDI SET tmp_col_1_tmp=CUSTOMERNO,CUSTOMERNO=NULL,tmp_col_2_tmp=C_BP_EDI_UU,C_BP_EDI_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=EMAIL_ERROR_TO,EMAIL_ERROR_TO=NULL,tmp_col_5_tmp=EMAIL_FROM,EMAIL_FROM=NULL,tmp_col_6_tmp=EMAIL_FROM_PWD,EMAIL_FROM_PWD=NULL,tmp_col_7_tmp=EMAIL_FROM_UID,EMAIL_FROM_UID=NULL,tmp_col_8_tmp=EMAIL_INFO_TO,EMAIL_INFO_TO=NULL,tmp_col_9_tmp=EMAIL_TO,EMAIL_TO=NULL,tmp_col_10_tmp=NAME,NAME=NULL;
ALTER TABLE C_BP_EDI MODIFY (CUSTOMERNO VARCHAR2(20 CHAR),C_BP_EDI_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EMAIL_ERROR_TO VARCHAR2(60 CHAR),EMAIL_FROM VARCHAR2(60 CHAR),EMAIL_FROM_PWD VARCHAR2(20 CHAR),EMAIL_FROM_UID VARCHAR2(20 CHAR),EMAIL_INFO_TO VARCHAR2(60 CHAR),EMAIL_TO VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_BP_EDI SET CUSTOMERNO=tmp_col_1_tmp,C_BP_EDI_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,EMAIL_ERROR_TO=tmp_col_4_tmp,EMAIL_FROM=tmp_col_5_tmp,EMAIL_FROM_PWD=tmp_col_6_tmp,EMAIL_FROM_UID=tmp_col_7_tmp,EMAIL_INFO_TO=tmp_col_8_tmp,EMAIL_TO=tmp_col_9_tmp,NAME=tmp_col_10_tmp;
ALTER TABLE C_BP_EDI MODIFY (CUSTOMERNO VARCHAR2(20 CHAR) NOT NULL,EMAIL_ERROR_TO VARCHAR2(60 CHAR) NOT NULL,EMAIL_INFO_TO VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BP_EDI DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table C_BP_EMPLOYEE_ACCT
ALTER TABLE C_BP_EMPLOYEE_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_BP_EMPLOYEE_ACCT SET tmp_col_1_tmp=C_BP_EMPLOYEE_ACCT_UU,C_BP_EMPLOYEE_ACCT_UU=NULL;
ALTER TABLE C_BP_EMPLOYEE_ACCT MODIFY (C_BP_EMPLOYEE_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_BP_EMPLOYEE_ACCT SET C_BP_EMPLOYEE_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_BP_EMPLOYEE_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_BP_GROUP
ALTER TABLE C_BP_GROUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_BP_GROUP MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_BP_GROUP SET tmp_col_1_tmp=C_BP_GROUP_UU,C_BP_GROUP_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_BP_GROUP MODIFY (C_BP_GROUP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_BP_GROUP SET C_BP_GROUP_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_BP_GROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_BP_GROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_BP_GROUP_ACCT
ALTER TABLE C_BP_GROUP_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_BP_GROUP_ACCT SET tmp_col_1_tmp=C_BP_GROUP_ACCT_UU,C_BP_GROUP_ACCT_UU=NULL;
ALTER TABLE C_BP_GROUP_ACCT MODIFY (C_BP_GROUP_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_BP_GROUP_ACCT SET C_BP_GROUP_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_BP_GROUP_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_BP_RELATION
ALTER TABLE C_BP_RELATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_BP_RELATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_BP_RELATION SET tmp_col_1_tmp=C_BP_RELATION_UU,C_BP_RELATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_BP_RELATION MODIFY (C_BP_RELATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_BP_RELATION SET C_BP_RELATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_BP_RELATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_BP_RELATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_BP_SHIPPINGACCT
ALTER TABLE C_BP_SHIPPINGACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE C_BP_SHIPPINGACCT SET tmp_col_1_tmp=C_BP_SHIPPINGACCT_UU,C_BP_SHIPPINGACCT_UU=NULL,tmp_col_2_tmp=DUTIESSHIPPERACCOUNT,DUTIESSHIPPERACCOUNT=NULL,tmp_col_3_tmp=SHIPPERACCOUNT,SHIPPERACCOUNT=NULL,tmp_col_4_tmp=SHIPPERMETER,SHIPPERMETER=NULL;
ALTER TABLE C_BP_SHIPPINGACCT MODIFY (C_BP_SHIPPINGACCT_UU VARCHAR2(36 CHAR),DUTIESSHIPPERACCOUNT VARCHAR2(40 CHAR),SHIPPERACCOUNT VARCHAR2(40 CHAR),SHIPPERMETER VARCHAR2(255 CHAR));
UPDATE C_BP_SHIPPINGACCT SET C_BP_SHIPPINGACCT_UU=tmp_col_1_tmp,DUTIESSHIPPERACCOUNT=tmp_col_2_tmp,SHIPPERACCOUNT=tmp_col_3_tmp,SHIPPERMETER=tmp_col_4_tmp;
ALTER TABLE C_BP_SHIPPINGACCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_BP_VENDOR_ACCT
ALTER TABLE C_BP_VENDOR_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_BP_VENDOR_ACCT SET tmp_col_1_tmp=C_BP_VENDOR_ACCT_UU,C_BP_VENDOR_ACCT_UU=NULL;
ALTER TABLE C_BP_VENDOR_ACCT MODIFY (C_BP_VENDOR_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_BP_VENDOR_ACCT SET C_BP_VENDOR_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_BP_VENDOR_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_BP_WITHHOLDING
ALTER TABLE C_BP_WITHHOLDING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR));
UPDATE C_BP_WITHHOLDING SET tmp_col_1_tmp=C_BP_WITHHOLDING_UU,C_BP_WITHHOLDING_UU=NULL,tmp_col_2_tmp=EXEMPTREASON,EXEMPTREASON=NULL;
ALTER TABLE C_BP_WITHHOLDING MODIFY (C_BP_WITHHOLDING_UU VARCHAR2(36 CHAR),EXEMPTREASON VARCHAR2(20 CHAR));
UPDATE C_BP_WITHHOLDING SET C_BP_WITHHOLDING_UU=tmp_col_1_tmp,EXEMPTREASON=tmp_col_2_tmp;
ALTER TABLE C_BP_WITHHOLDING DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_CALENDAR
ALTER TABLE C_CALENDAR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CALENDAR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CALENDAR SET tmp_col_1_tmp=C_CALENDAR_UU,C_CALENDAR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CALENDAR MODIFY (C_CALENDAR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CALENDAR SET C_CALENDAR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CALENDAR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CALENDAR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CAMPAIGN
ALTER TABLE C_CAMPAIGN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_CAMPAIGN MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_CAMPAIGN SET tmp_col_1_tmp=C_CAMPAIGN_UU,C_CAMPAIGN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_CAMPAIGN MODIFY (C_CAMPAIGN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_CAMPAIGN SET C_CAMPAIGN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_CAMPAIGN MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_CAMPAIGN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_CAMPAIGN_TRL
ALTER TABLE C_CAMPAIGN_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CAMPAIGN_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CAMPAIGN_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_CAMPAIGN_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CAMPAIGN_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_CAMPAIGN_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CAMPAIGN_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_CASH
ALTER TABLE C_CASH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CASH MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CASH SET tmp_col_1_tmp=C_CASH_UU,C_CASH_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CASH MODIFY (C_CASH_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CASH SET C_CASH_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CASH MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CASH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CASHBOOK
ALTER TABLE C_CASHBOOK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CASHBOOK MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CASHBOOK SET tmp_col_1_tmp=C_CASHBOOK_UU,C_CASHBOOK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CASHBOOK MODIFY (C_CASHBOOK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CASHBOOK SET C_CASHBOOK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CASHBOOK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CASHBOOK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CASHBOOK_ACCT
ALTER TABLE C_CASHBOOK_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CASHBOOK_ACCT SET tmp_col_1_tmp=C_CASHBOOK_ACCT_UU,C_CASHBOOK_ACCT_UU=NULL;
ALTER TABLE C_CASHBOOK_ACCT MODIFY (C_CASHBOOK_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_CASHBOOK_ACCT SET C_CASHBOOK_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_CASHBOOK_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_CASHLINE
ALTER TABLE C_CASHLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_CASHLINE SET tmp_col_1_tmp=C_CASHLINE_UU,C_CASHLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_CASHLINE MODIFY (C_CASHLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_CASHLINE SET C_CASHLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_CASHLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_CASHPLAN
ALTER TABLE C_CASHPLAN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_CASHPLAN MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_CASHPLAN SET tmp_col_1_tmp=C_CASHPLAN_UU,C_CASHPLAN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_CASHPLAN MODIFY (C_CASHPLAN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_CASHPLAN SET C_CASHPLAN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_CASHPLAN MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_CASHPLAN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CASHPLANLINE
ALTER TABLE C_CASHPLANLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
UPDATE C_CASHPLANLINE SET tmp_col_1_tmp=C_CASHPLANLINE_UU,C_CASHPLANLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CASHPLANLINE MODIFY (C_CASHPLANLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CASHPLANLINE SET C_CASHPLANLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CASHPLANLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CHANNEL
ALTER TABLE C_CHANNEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CHANNEL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CHANNEL SET tmp_col_1_tmp=C_CHANNEL_UU,C_CHANNEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CHANNEL MODIFY (C_CHANNEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CHANNEL SET C_CHANNEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CHANNEL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CHANNEL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CHARGE
ALTER TABLE C_CHARGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CHARGE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CHARGE SET tmp_col_1_tmp=C_CHARGE_UU,C_CHARGE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CHARGE MODIFY (C_CHARGE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CHARGE SET C_CHARGE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CHARGE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CHARGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CHARGETYPE
ALTER TABLE C_CHARGETYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_CHARGETYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_CHARGETYPE SET tmp_col_1_tmp=C_CHARGETYPE_UU,C_CHARGETYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_CHARGETYPE MODIFY (C_CHARGETYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_CHARGETYPE SET C_CHARGETYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_CHARGETYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_CHARGETYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_CHARGETYPE_DOCTYPE
ALTER TABLE C_CHARGETYPE_DOCTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CHARGETYPE_DOCTYPE SET tmp_col_1_tmp=C_CHARGETYPE_DOCTYPE_UU,C_CHARGETYPE_DOCTYPE_UU=NULL;
ALTER TABLE C_CHARGETYPE_DOCTYPE MODIFY (C_CHARGETYPE_DOCTYPE_UU VARCHAR2(36 CHAR));
UPDATE C_CHARGETYPE_DOCTYPE SET C_CHARGETYPE_DOCTYPE_UU=tmp_col_1_tmp;
ALTER TABLE C_CHARGETYPE_DOCTYPE DROP (tmp_col_1_tmp);

-- Processing table C_CHARGE_ACCT
ALTER TABLE C_CHARGE_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CHARGE_ACCT SET tmp_col_1_tmp=C_CHARGE_ACCT_UU,C_CHARGE_ACCT_UU=NULL;
ALTER TABLE C_CHARGE_ACCT MODIFY (C_CHARGE_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_CHARGE_ACCT SET C_CHARGE_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_CHARGE_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_CHARGE_TRL
ALTER TABLE C_CHARGE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CHARGE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CHARGE_TRL SET tmp_col_1_tmp=C_CHARGE_TRL_UU,C_CHARGE_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CHARGE_TRL MODIFY (C_CHARGE_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CHARGE_TRL SET C_CHARGE_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CHARGE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CHARGE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CITY
ALTER TABLE C_CITY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CITY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CITY SET tmp_col_1_tmp=C_CITY_UU,C_CITY_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_CITY MODIFY (C_CITY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CITY SET C_CITY_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_CITY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CITY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_COMMISSION
ALTER TABLE C_COMMISSION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_COMMISSION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_COMMISSION SET tmp_col_1_tmp=C_COMMISSION_UU,C_COMMISSION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_COMMISSION MODIFY (C_COMMISSION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_COMMISSION SET C_COMMISSION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_COMMISSION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_COMMISSION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_COMMISSIONAMT
ALTER TABLE C_COMMISSIONAMT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_COMMISSIONAMT SET tmp_col_1_tmp=C_COMMISSIONAMT_UU,C_COMMISSIONAMT_UU=NULL;
ALTER TABLE C_COMMISSIONAMT MODIFY (C_COMMISSIONAMT_UU VARCHAR2(36 CHAR));
UPDATE C_COMMISSIONAMT SET C_COMMISSIONAMT_UU=tmp_col_1_tmp;
ALTER TABLE C_COMMISSIONAMT DROP (tmp_col_1_tmp);

-- Processing table C_COMMISSIONDETAIL
ALTER TABLE C_COMMISSIONDETAIL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
UPDATE C_COMMISSIONDETAIL SET tmp_col_1_tmp=C_COMMISSIONDETAIL_UU,C_COMMISSIONDETAIL_UU=NULL,tmp_col_2_tmp=INFO,INFO=NULL,tmp_col_3_tmp=REFERENCE,REFERENCE=NULL;
ALTER TABLE C_COMMISSIONDETAIL MODIFY (C_COMMISSIONDETAIL_UU VARCHAR2(36 CHAR),INFO VARCHAR2(60 CHAR),REFERENCE VARCHAR2(60 CHAR));
UPDATE C_COMMISSIONDETAIL SET C_COMMISSIONDETAIL_UU=tmp_col_1_tmp,INFO=tmp_col_2_tmp,REFERENCE=tmp_col_3_tmp;
ALTER TABLE C_COMMISSIONDETAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_COMMISSIONLINE
ALTER TABLE C_COMMISSIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_COMMISSIONLINE SET tmp_col_1_tmp=C_COMMISSIONLINE_UU,C_COMMISSIONLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_COMMISSIONLINE MODIFY (C_COMMISSIONLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_COMMISSIONLINE SET C_COMMISSIONLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_COMMISSIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_COMMISSIONRUN
ALTER TABLE C_COMMISSIONRUN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_COMMISSIONRUN MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_COMMISSIONRUN SET tmp_col_1_tmp=C_COMMISSIONRUN_UU,C_COMMISSIONRUN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_COMMISSIONRUN MODIFY (C_COMMISSIONRUN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_COMMISSIONRUN SET C_COMMISSIONRUN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_COMMISSIONRUN MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_COMMISSIONRUN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CONTACTACTIVITY
ALTER TABLE C_CONTACTACTIVITY ADD (tmp_col_1_tmp VARCHAR2(10 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE C_CONTACTACTIVITY MODIFY (CONTACTACTIVITYTYPE NVARCHAR2(10) NULL,DESCRIPTION NVARCHAR2(255) NULL);
UPDATE C_CONTACTACTIVITY SET tmp_col_1_tmp=CONTACTACTIVITYTYPE,CONTACTACTIVITYTYPE=NULL,tmp_col_2_tmp=C_CONTACTACTIVITY_UU,C_CONTACTACTIVITY_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_CONTACTACTIVITY MODIFY (CONTACTACTIVITYTYPE VARCHAR2(10 CHAR),C_CONTACTACTIVITY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_CONTACTACTIVITY SET CONTACTACTIVITYTYPE=tmp_col_1_tmp,C_CONTACTACTIVITY_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp;
ALTER TABLE C_CONTACTACTIVITY MODIFY (CONTACTACTIVITYTYPE VARCHAR2(10 CHAR) NOT NULL,DESCRIPTION VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE C_CONTACTACTIVITY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CONVERSIONTYPE
ALTER TABLE C_CONVERSIONTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_CONVERSIONTYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_CONVERSIONTYPE SET tmp_col_1_tmp=C_CONVERSIONTYPE_UU,C_CONVERSIONTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_CONVERSIONTYPE MODIFY (C_CONVERSIONTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_CONVERSIONTYPE SET C_CONVERSIONTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_CONVERSIONTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_CONVERSIONTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_CONVERSION_RATE
ALTER TABLE C_CONVERSION_RATE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CONVERSION_RATE SET tmp_col_1_tmp=C_CONVERSION_RATE_UU,C_CONVERSION_RATE_UU=NULL;
ALTER TABLE C_CONVERSION_RATE MODIFY (C_CONVERSION_RATE_UU VARCHAR2(36 CHAR));
UPDATE C_CONVERSION_RATE SET C_CONVERSION_RATE_UU=tmp_col_1_tmp;
ALTER TABLE C_CONVERSION_RATE DROP (tmp_col_1_tmp);

-- Processing table C_COUNTRY
ALTER TABLE C_COUNTRY ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(20 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(255 CHAR),tmp_col_14_tmp VARCHAR2(255 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(255 CHAR),tmp_col_17_tmp VARCHAR2(255 CHAR),tmp_col_18_tmp VARCHAR2(255 CHAR),tmp_col_19_tmp VARCHAR2(255 CHAR),tmp_col_20_tmp VARCHAR2(255 CHAR),tmp_col_21_tmp VARCHAR2(255 CHAR),tmp_col_22_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_COUNTRY MODIFY (DISPLAYSEQUENCE NVARCHAR2(20) NULL,NAME NVARCHAR2(60) NULL);
UPDATE C_COUNTRY SET tmp_col_1_tmp=CAPTURESEQUENCE,CAPTURESEQUENCE=NULL,tmp_col_2_tmp=C_COUNTRY_UU,C_COUNTRY_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DISPLAYSEQUENCE,DISPLAYSEQUENCE=NULL,tmp_col_5_tmp=DISPLAYSEQUENCELOCAL,DISPLAYSEQUENCELOCAL=NULL,tmp_col_6_tmp=EXPRESSIONBANKACCOUNTNO,EXPRESSIONBANKACCOUNTNO=NULL,tmp_col_7_tmp=EXPRESSIONBANKROUTINGNO,EXPRESSIONBANKROUTINGNO=NULL,tmp_col_8_tmp=EXPRESSIONPHONE,EXPRESSIONPHONE=NULL,tmp_col_9_tmp=EXPRESSIONPOSTAL,EXPRESSIONPOSTAL=NULL,tmp_col_10_tmp=EXPRESSIONPOSTAL_ADD,EXPRESSIONPOSTAL_ADD=NULL,tmp_col_11_tmp=MEDIASIZE,MEDIASIZE=NULL,tmp_col_12_tmp=NAME,NAME=NULL,tmp_col_13_tmp=PLACEHOLDERADDRESS1,PLACEHOLDERADDRESS1=NULL,tmp_col_14_tmp=PLACEHOLDERADDRESS2,PLACEHOLDERADDRESS2=NULL,tmp_col_15_tmp=PLACEHOLDERADDRESS3,PLACEHOLDERADDRESS3=NULL,tmp_col_16_tmp=PLACEHOLDERADDRESS4,PLACEHOLDERADDRESS4=NULL,tmp_col_17_tmp=PLACEHOLDERADDRESS5,PLACEHOLDERADDRESS5=NULL,tmp_col_18_tmp=PLACEHOLDERCITY,PLACEHOLDERCITY=NULL,tmp_col_19_tmp=PLACEHOLDERCOMMENTS,PLACEHOLDERCOMMENTS=NULL,tmp_col_20_tmp=PLACEHOLDERPOSTAL,PLACEHOLDERPOSTAL=NULL,tmp_col_21_tmp=PLACEHOLDERPOSTAL_ADD,PLACEHOLDERPOSTAL_ADD=NULL,tmp_col_22_tmp=REGIONNAME,REGIONNAME=NULL;
ALTER TABLE C_COUNTRY MODIFY (CAPTURESEQUENCE VARCHAR2(60 CHAR),C_COUNTRY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DISPLAYSEQUENCE VARCHAR2(20 CHAR),DISPLAYSEQUENCELOCAL VARCHAR2(20 CHAR),EXPRESSIONBANKACCOUNTNO VARCHAR2(20 CHAR),EXPRESSIONBANKROUTINGNO VARCHAR2(20 CHAR),EXPRESSIONPHONE VARCHAR2(20 CHAR),EXPRESSIONPOSTAL VARCHAR2(20 CHAR),EXPRESSIONPOSTAL_ADD VARCHAR2(20 CHAR),MEDIASIZE VARCHAR2(40 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDERADDRESS1 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS2 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS3 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS4 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS5 VARCHAR2(255 CHAR),PLACEHOLDERCITY VARCHAR2(255 CHAR),PLACEHOLDERCOMMENTS VARCHAR2(255 CHAR),PLACEHOLDERPOSTAL VARCHAR2(255 CHAR),PLACEHOLDERPOSTAL_ADD VARCHAR2(255 CHAR),REGIONNAME VARCHAR2(60 CHAR));
UPDATE C_COUNTRY SET CAPTURESEQUENCE=tmp_col_1_tmp,C_COUNTRY_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DISPLAYSEQUENCE=tmp_col_4_tmp,DISPLAYSEQUENCELOCAL=tmp_col_5_tmp,EXPRESSIONBANKACCOUNTNO=tmp_col_6_tmp,EXPRESSIONBANKROUTINGNO=tmp_col_7_tmp,EXPRESSIONPHONE=tmp_col_8_tmp,EXPRESSIONPOSTAL=tmp_col_9_tmp,EXPRESSIONPOSTAL_ADD=tmp_col_10_tmp,MEDIASIZE=tmp_col_11_tmp,NAME=tmp_col_12_tmp,PLACEHOLDERADDRESS1=tmp_col_13_tmp,PLACEHOLDERADDRESS2=tmp_col_14_tmp,PLACEHOLDERADDRESS3=tmp_col_15_tmp,PLACEHOLDERADDRESS4=tmp_col_16_tmp,PLACEHOLDERADDRESS5=tmp_col_17_tmp,PLACEHOLDERCITY=tmp_col_18_tmp,PLACEHOLDERCOMMENTS=tmp_col_19_tmp,PLACEHOLDERPOSTAL=tmp_col_20_tmp,PLACEHOLDERPOSTAL_ADD=tmp_col_21_tmp,REGIONNAME=tmp_col_22_tmp;
ALTER TABLE C_COUNTRY MODIFY (DISPLAYSEQUENCE VARCHAR2(20 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_COUNTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp);

-- Processing table C_COUNTRY_TRL
ALTER TABLE C_COUNTRY_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_COUNTRY_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_COUNTRY_TRL SET tmp_col_1_tmp=C_COUNTRY_TRL_UU,C_COUNTRY_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PLACEHOLDERADDRESS1,PLACEHOLDERADDRESS1=NULL,tmp_col_5_tmp=PLACEHOLDERADDRESS2,PLACEHOLDERADDRESS2=NULL,tmp_col_6_tmp=PLACEHOLDERADDRESS3,PLACEHOLDERADDRESS3=NULL,tmp_col_7_tmp=PLACEHOLDERADDRESS4,PLACEHOLDERADDRESS4=NULL,tmp_col_8_tmp=PLACEHOLDERADDRESS5,PLACEHOLDERADDRESS5=NULL,tmp_col_9_tmp=PLACEHOLDERCITY,PLACEHOLDERCITY=NULL,tmp_col_10_tmp=PLACEHOLDERCOMMENTS,PLACEHOLDERCOMMENTS=NULL,tmp_col_11_tmp=PLACEHOLDERPOSTAL,PLACEHOLDERPOSTAL=NULL,tmp_col_12_tmp=PLACEHOLDERPOSTAL_ADD,PLACEHOLDERPOSTAL_ADD=NULL,tmp_col_13_tmp=REGIONNAME,REGIONNAME=NULL;
ALTER TABLE C_COUNTRY_TRL MODIFY (C_COUNTRY_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PLACEHOLDERADDRESS1 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS2 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS3 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS4 VARCHAR2(255 CHAR),PLACEHOLDERADDRESS5 VARCHAR2(255 CHAR),PLACEHOLDERCITY VARCHAR2(255 CHAR),PLACEHOLDERCOMMENTS VARCHAR2(255 CHAR),PLACEHOLDERPOSTAL VARCHAR2(255 CHAR),PLACEHOLDERPOSTAL_ADD VARCHAR2(255 CHAR),REGIONNAME VARCHAR2(60 CHAR));
UPDATE C_COUNTRY_TRL SET C_COUNTRY_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PLACEHOLDERADDRESS1=tmp_col_4_tmp,PLACEHOLDERADDRESS2=tmp_col_5_tmp,PLACEHOLDERADDRESS3=tmp_col_6_tmp,PLACEHOLDERADDRESS4=tmp_col_7_tmp,PLACEHOLDERADDRESS5=tmp_col_8_tmp,PLACEHOLDERCITY=tmp_col_9_tmp,PLACEHOLDERCOMMENTS=tmp_col_10_tmp,PLACEHOLDERPOSTAL=tmp_col_11_tmp,PLACEHOLDERPOSTAL_ADD=tmp_col_12_tmp,REGIONNAME=tmp_col_13_tmp;
ALTER TABLE C_COUNTRY_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_COUNTRY_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table C_CURRENCY
ALTER TABLE C_CURRENCY ADD (tmp_col_1_tmp VARCHAR2(10 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE C_CURRENCY MODIFY (DESCRIPTION NVARCHAR2(255) NULL);
UPDATE C_CURRENCY SET tmp_col_1_tmp=CURSYMBOL,CURSYMBOL=NULL,tmp_col_2_tmp=C_CURRENCY_UU,C_CURRENCY_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_CURRENCY MODIFY (CURSYMBOL VARCHAR2(10 CHAR),C_CURRENCY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_CURRENCY SET CURSYMBOL=tmp_col_1_tmp,C_CURRENCY_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp;
ALTER TABLE C_CURRENCY MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE C_CURRENCY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CURRENCY_ACCT
ALTER TABLE C_CURRENCY_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CURRENCY_ACCT SET tmp_col_1_tmp=C_CURRENCY_ACCT_UU,C_CURRENCY_ACCT_UU=NULL;
ALTER TABLE C_CURRENCY_ACCT MODIFY (C_CURRENCY_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_CURRENCY_ACCT SET C_CURRENCY_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_CURRENCY_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_CURRENCY_TRL
ALTER TABLE C_CURRENCY_TRL ADD (tmp_col_1_tmp VARCHAR2(10 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE C_CURRENCY_TRL MODIFY (DESCRIPTION NVARCHAR2(255) NULL);
UPDATE C_CURRENCY_TRL SET tmp_col_1_tmp=CURSYMBOL,CURSYMBOL=NULL,tmp_col_2_tmp=C_CURRENCY_TRL_UU,C_CURRENCY_TRL_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_CURRENCY_TRL MODIFY (CURSYMBOL VARCHAR2(10 CHAR),C_CURRENCY_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_CURRENCY_TRL SET CURSYMBOL=tmp_col_1_tmp,C_CURRENCY_TRL_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp;
ALTER TABLE C_CURRENCY_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE C_CURRENCY_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CYCLE
ALTER TABLE C_CYCLE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CYCLE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CYCLE SET tmp_col_1_tmp=C_CYCLE_UU,C_CYCLE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_CYCLE MODIFY (C_CYCLE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CYCLE SET C_CYCLE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_CYCLE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CYCLE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_CYCLEPHASE
ALTER TABLE C_CYCLEPHASE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_CYCLEPHASE SET tmp_col_1_tmp=C_CYCLEPHASE_UU,C_CYCLEPHASE_UU=NULL;
ALTER TABLE C_CYCLEPHASE MODIFY (C_CYCLEPHASE_UU VARCHAR2(36 CHAR));
UPDATE C_CYCLEPHASE SET C_CYCLEPHASE_UU=tmp_col_1_tmp;
ALTER TABLE C_CYCLEPHASE DROP (tmp_col_1_tmp);

-- Processing table C_CYCLESTEP
ALTER TABLE C_CYCLESTEP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_CYCLESTEP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_CYCLESTEP SET tmp_col_1_tmp=C_CYCLESTEP_UU,C_CYCLESTEP_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_CYCLESTEP MODIFY (C_CYCLESTEP_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_CYCLESTEP SET C_CYCLESTEP_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_CYCLESTEP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_CYCLESTEP DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_DEPOSITBATCH
ALTER TABLE C_DEPOSITBATCH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_DEPOSITBATCH MODIFY (DOCSTATUS NVARCHAR2(2) NULL,DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_DEPOSITBATCH SET tmp_col_1_tmp=C_DEPOSITBATCH_UU,C_DEPOSITBATCH_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_4_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_DEPOSITBATCH MODIFY (C_DEPOSITBATCH_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_DEPOSITBATCH SET C_DEPOSITBATCH_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCSTATUS=tmp_col_3_tmp,DOCUMENTNO=tmp_col_4_tmp;
ALTER TABLE C_DEPOSITBATCH MODIFY (DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'  NOT NULL,DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_DEPOSITBATCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_DEPOSITBATCHLINE
ALTER TABLE C_DEPOSITBATCHLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_DEPOSITBATCHLINE SET tmp_col_1_tmp=C_DEPOSITBATCHLINE_UU,C_DEPOSITBATCHLINE_UU=NULL;
ALTER TABLE C_DEPOSITBATCHLINE MODIFY (C_DEPOSITBATCHLINE_UU VARCHAR2(36 CHAR));
UPDATE C_DEPOSITBATCHLINE SET C_DEPOSITBATCHLINE_UU=tmp_col_1_tmp;
ALTER TABLE C_DEPOSITBATCHLINE DROP (tmp_col_1_tmp);

-- Processing table C_DOCTYPE
ALTER TABLE C_DOCTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DOCTYPE MODIFY (NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE C_DOCTYPE SET tmp_col_1_tmp=C_DOCTYPE_UU,C_DOCTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCSUBTYPEINV,DOCSUBTYPEINV=NULL,tmp_col_4_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE C_DOCTYPE MODIFY (C_DOCTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCSUBTYPEINV VARCHAR2(2 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE C_DOCTYPE SET C_DOCTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCSUBTYPEINV=tmp_col_3_tmp,DOCUMENTNOTE=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PRINTNAME=tmp_col_6_tmp;
ALTER TABLE C_DOCTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DOCTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_DOCTYPECOUNTER
ALTER TABLE C_DOCTYPECOUNTER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DOCTYPECOUNTER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_DOCTYPECOUNTER SET tmp_col_1_tmp=C_DOCTYPECOUNTER_UU,C_DOCTYPECOUNTER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_DOCTYPECOUNTER MODIFY (C_DOCTYPECOUNTER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_DOCTYPECOUNTER SET C_DOCTYPECOUNTER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_DOCTYPECOUNTER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DOCTYPECOUNTER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_DOCTYPE_TRL
ALTER TABLE C_DOCTYPE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DOCTYPE_TRL MODIFY (NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE C_DOCTYPE_TRL SET tmp_col_1_tmp=C_DOCTYPE_TRL_UU,C_DOCTYPE_TRL_UU=NULL,tmp_col_2_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE C_DOCTYPE_TRL MODIFY (C_DOCTYPE_TRL_UU VARCHAR2(36 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE C_DOCTYPE_TRL SET C_DOCTYPE_TRL_UU=tmp_col_1_tmp,DOCUMENTNOTE=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PRINTNAME=tmp_col_4_tmp;
ALTER TABLE C_DOCTYPE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DOCTYPE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_DUNNING
ALTER TABLE C_DUNNING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DUNNING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_DUNNING SET tmp_col_1_tmp=C_DUNNING_UU,C_DUNNING_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_DUNNING MODIFY (C_DUNNING_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_DUNNING SET C_DUNNING_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_DUNNING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DUNNING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_DUNNINGLEVEL
ALTER TABLE C_DUNNINGLEVEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DUNNINGLEVEL MODIFY (NAME NVARCHAR2(60) NULL,PRINTNAME NVARCHAR2(60) NULL);
UPDATE C_DUNNINGLEVEL SET tmp_col_1_tmp=C_DUNNINGLEVEL_UU,C_DUNNINGLEVEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=NOTE,NOTE=NULL,tmp_col_5_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE C_DUNNINGLEVEL MODIFY (C_DUNNINGLEVEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT 'x' ,NOTE VARCHAR2(2000 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE C_DUNNINGLEVEL SET C_DUNNINGLEVEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,NOTE=tmp_col_4_tmp,PRINTNAME=tmp_col_5_tmp;
ALTER TABLE C_DUNNINGLEVEL MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT 'x'  NOT NULL,PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DUNNINGLEVEL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_DUNNINGLEVEL_TRL
ALTER TABLE C_DUNNINGLEVEL_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_DUNNINGLEVEL_TRL MODIFY (PRINTNAME NVARCHAR2(60) NULL);
UPDATE C_DUNNINGLEVEL_TRL SET tmp_col_1_tmp=C_DUNNINGLEVEL_TRL_UU,C_DUNNINGLEVEL_TRL_UU=NULL,tmp_col_2_tmp=NOTE,NOTE=NULL,tmp_col_3_tmp=PRINTNAME,PRINTNAME=NULL;
ALTER TABLE C_DUNNINGLEVEL_TRL MODIFY (C_DUNNINGLEVEL_TRL_UU VARCHAR2(36 CHAR),NOTE VARCHAR2(2000 CHAR),PRINTNAME VARCHAR2(60 CHAR));
UPDATE C_DUNNINGLEVEL_TRL SET C_DUNNINGLEVEL_TRL_UU=tmp_col_1_tmp,NOTE=tmp_col_2_tmp,PRINTNAME=tmp_col_3_tmp;
ALTER TABLE C_DUNNINGLEVEL_TRL MODIFY (PRINTNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_DUNNINGLEVEL_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_DUNNINGRUN
ALTER TABLE C_DUNNINGRUN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_DUNNINGRUN SET tmp_col_1_tmp=C_DUNNINGRUN_UU,C_DUNNINGRUN_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_DUNNINGRUN MODIFY (C_DUNNINGRUN_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_DUNNINGRUN SET C_DUNNINGRUN_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_DUNNINGRUN DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_DUNNINGRUNENTRY
ALTER TABLE C_DUNNINGRUNENTRY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE C_DUNNINGRUNENTRY SET tmp_col_1_tmp=C_DUNNINGRUNENTRY_UU,C_DUNNINGRUNENTRY_UU=NULL,tmp_col_2_tmp=NOTE,NOTE=NULL;
ALTER TABLE C_DUNNINGRUNENTRY MODIFY (C_DUNNINGRUNENTRY_UU VARCHAR2(36 CHAR),NOTE VARCHAR2(2000 CHAR));
UPDATE C_DUNNINGRUNENTRY SET C_DUNNINGRUNENTRY_UU=tmp_col_1_tmp,NOTE=tmp_col_2_tmp;
ALTER TABLE C_DUNNINGRUNENTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_DUNNINGRUNLINE
ALTER TABLE C_DUNNINGRUNLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_DUNNINGRUNLINE SET tmp_col_1_tmp=C_DUNNINGRUNLINE_UU,C_DUNNINGRUNLINE_UU=NULL;
ALTER TABLE C_DUNNINGRUNLINE MODIFY (C_DUNNINGRUNLINE_UU VARCHAR2(36 CHAR));
UPDATE C_DUNNINGRUNLINE SET C_DUNNINGRUNLINE_UU=tmp_col_1_tmp;
ALTER TABLE C_DUNNINGRUNLINE DROP (tmp_col_1_tmp);

-- Processing table C_ELEMENT
ALTER TABLE C_ELEMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_ELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_ELEMENT SET tmp_col_1_tmp=C_ELEMENT_UU,C_ELEMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VFORMAT,VFORMAT=NULL;
ALTER TABLE C_ELEMENT MODIFY (C_ELEMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VFORMAT VARCHAR2(40 CHAR));
UPDATE C_ELEMENT SET C_ELEMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VFORMAT=tmp_col_4_tmp;
ALTER TABLE C_ELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_ELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_ELEMENTVALUE
ALTER TABLE C_ELEMENTVALUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_ELEMENTVALUE MODIFY (NAME NVARCHAR2(120) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_ELEMENTVALUE SET tmp_col_1_tmp=C_ELEMENTVALUE_UU,C_ELEMENTVALUE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_ELEMENTVALUE MODIFY (C_ELEMENTVALUE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_ELEMENTVALUE SET C_ELEMENTVALUE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_ELEMENTVALUE MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_ELEMENTVALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_ELEMENTVALUE_TRL
ALTER TABLE C_ELEMENTVALUE_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR));
ALTER TABLE C_ELEMENTVALUE_TRL MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE C_ELEMENTVALUE_TRL SET tmp_col_1_tmp=C_ELEMENTVALUE_TRL_UU,C_ELEMENTVALUE_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_ELEMENTVALUE_TRL MODIFY (C_ELEMENTVALUE_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR));
UPDATE C_ELEMENTVALUE_TRL SET C_ELEMENTVALUE_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_ELEMENTVALUE_TRL MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE C_ELEMENTVALUE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_GREETING
ALTER TABLE C_GREETING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_GREETING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_GREETING SET tmp_col_1_tmp=C_GREETING_UU,C_GREETING_UU=NULL,tmp_col_2_tmp=GREETING,GREETING=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_GREETING MODIFY (C_GREETING_UU VARCHAR2(36 CHAR),GREETING VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_GREETING SET C_GREETING_UU=tmp_col_1_tmp,GREETING=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_GREETING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_GREETING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_GREETING_TRL
ALTER TABLE C_GREETING_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_GREETING_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_GREETING_TRL SET tmp_col_1_tmp=C_GREETING_TRL_UU,C_GREETING_TRL_UU=NULL,tmp_col_2_tmp=GREETING,GREETING=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_GREETING_TRL MODIFY (C_GREETING_TRL_UU VARCHAR2(36 CHAR),GREETING VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_GREETING_TRL SET C_GREETING_TRL_UU=tmp_col_1_tmp,GREETING=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_GREETING_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_GREETING_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_INTERORG_ACCT
ALTER TABLE C_INTERORG_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_INTERORG_ACCT SET tmp_col_1_tmp=C_INTERORG_ACCT_UU,C_INTERORG_ACCT_UU=NULL;
ALTER TABLE C_INTERORG_ACCT MODIFY (C_INTERORG_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_INTERORG_ACCT SET C_INTERORG_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_INTERORG_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_INVOICE
ALTER TABLE C_INVOICE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR));
ALTER TABLE C_INVOICE MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_INVOICE SET tmp_col_1_tmp=C_INVOICE_UU,C_INVOICE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=POREFERENCE,POREFERENCE=NULL;
ALTER TABLE C_INVOICE MODIFY (C_INVOICE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),POREFERENCE VARCHAR2(20 CHAR));
UPDATE C_INVOICE SET C_INVOICE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,POREFERENCE=tmp_col_4_tmp;
ALTER TABLE C_INVOICE MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_INVOICE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_INVOICEBATCH
ALTER TABLE C_INVOICEBATCH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_INVOICEBATCH MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_INVOICEBATCH SET tmp_col_1_tmp=C_INVOICEBATCH_UU,C_INVOICEBATCH_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_INVOICEBATCH MODIFY (C_INVOICEBATCH_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_INVOICEBATCH SET C_INVOICEBATCH_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_INVOICEBATCH MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_INVOICEBATCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_INVOICEBATCHLINE
ALTER TABLE C_INVOICEBATCHLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_INVOICEBATCHLINE MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_INVOICEBATCHLINE SET tmp_col_1_tmp=C_INVOICEBATCHLINE_UU,C_INVOICEBATCHLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_INVOICEBATCHLINE MODIFY (C_INVOICEBATCHLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_INVOICEBATCHLINE SET C_INVOICEBATCHLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_INVOICEBATCHLINE MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_INVOICEBATCHLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_INVOICELINE
ALTER TABLE C_INVOICELINE ADD (tmp_col_1_tmp VARCHAR2(3 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
UPDATE C_INVOICELINE SET tmp_col_1_tmp=A_CAPVSEXP,A_CAPVSEXP=NULL,tmp_col_2_tmp=C_INVOICELINE_UU,C_INVOICELINE_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_INVOICELINE MODIFY (A_CAPVSEXP VARCHAR2(3 CHAR),C_INVOICELINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_INVOICELINE SET A_CAPVSEXP=tmp_col_1_tmp,C_INVOICELINE_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp;
ALTER TABLE C_INVOICELINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_INVOICEPAYSCHEDULE
ALTER TABLE C_INVOICEPAYSCHEDULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_INVOICEPAYSCHEDULE SET tmp_col_1_tmp=C_INVOICEPAYSCHEDULE_UU,C_INVOICEPAYSCHEDULE_UU=NULL;
ALTER TABLE C_INVOICEPAYSCHEDULE MODIFY (C_INVOICEPAYSCHEDULE_UU VARCHAR2(36 CHAR));
UPDATE C_INVOICEPAYSCHEDULE SET C_INVOICEPAYSCHEDULE_UU=tmp_col_1_tmp;
ALTER TABLE C_INVOICEPAYSCHEDULE DROP (tmp_col_1_tmp);

-- Processing table C_INVOICESCHEDULE
ALTER TABLE C_INVOICESCHEDULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_INVOICESCHEDULE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_INVOICESCHEDULE SET tmp_col_1_tmp=C_INVOICESCHEDULE_UU,C_INVOICESCHEDULE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_INVOICESCHEDULE MODIFY (C_INVOICESCHEDULE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_INVOICESCHEDULE SET C_INVOICESCHEDULE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_INVOICESCHEDULE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_INVOICESCHEDULE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_INVOICETAX
ALTER TABLE C_INVOICETAX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_INVOICETAX SET tmp_col_1_tmp=C_INVOICETAX_UU,C_INVOICETAX_UU=NULL;
ALTER TABLE C_INVOICETAX MODIFY (C_INVOICETAX_UU VARCHAR2(36 CHAR));
UPDATE C_INVOICETAX SET C_INVOICETAX_UU=tmp_col_1_tmp;
ALTER TABLE C_INVOICETAX DROP (tmp_col_1_tmp);

-- Processing table C_JOB
ALTER TABLE C_JOB ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_JOB MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_JOB SET tmp_col_1_tmp=C_JOB_UU,C_JOB_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_JOB MODIFY (C_JOB_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_JOB SET C_JOB_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_JOB MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_JOB DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_JOBASSIGNMENT
ALTER TABLE C_JOBASSIGNMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_JOBASSIGNMENT SET tmp_col_1_tmp=C_JOBASSIGNMENT_UU,C_JOBASSIGNMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_JOBASSIGNMENT MODIFY (C_JOBASSIGNMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_JOBASSIGNMENT SET C_JOBASSIGNMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_JOBASSIGNMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_JOBCATEGORY
ALTER TABLE C_JOBCATEGORY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_JOBCATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_JOBCATEGORY SET tmp_col_1_tmp=C_JOBCATEGORY_UU,C_JOBCATEGORY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_JOBCATEGORY MODIFY (C_JOBCATEGORY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_JOBCATEGORY SET C_JOBCATEGORY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_JOBCATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_JOBCATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_JOBREMUNERATION
ALTER TABLE C_JOBREMUNERATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_JOBREMUNERATION SET tmp_col_1_tmp=C_JOBREMUNERATION_UU,C_JOBREMUNERATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_JOBREMUNERATION MODIFY (C_JOBREMUNERATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_JOBREMUNERATION SET C_JOBREMUNERATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_JOBREMUNERATION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_LANDEDCOST
ALTER TABLE C_LANDEDCOST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_LANDEDCOST SET tmp_col_1_tmp=C_LANDEDCOST_UU,C_LANDEDCOST_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_LANDEDCOST MODIFY (C_LANDEDCOST_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_LANDEDCOST SET C_LANDEDCOST_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_LANDEDCOST DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_LANDEDCOSTALLOCATION
ALTER TABLE C_LANDEDCOSTALLOCATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_LANDEDCOSTALLOCATION SET tmp_col_1_tmp=C_LANDEDCOSTALLOCATION_UU,C_LANDEDCOSTALLOCATION_UU=NULL;
ALTER TABLE C_LANDEDCOSTALLOCATION MODIFY (C_LANDEDCOSTALLOCATION_UU VARCHAR2(36 CHAR));
UPDATE C_LANDEDCOSTALLOCATION SET C_LANDEDCOSTALLOCATION_UU=tmp_col_1_tmp;
ALTER TABLE C_LANDEDCOSTALLOCATION DROP (tmp_col_1_tmp);

-- Processing table C_LOCATION
ALTER TABLE C_LOCATION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(36 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR));
UPDATE C_LOCATION SET tmp_col_1_tmp=ADDRESS1,ADDRESS1=NULL,tmp_col_2_tmp=ADDRESS2,ADDRESS2=NULL,tmp_col_3_tmp=ADDRESS3,ADDRESS3=NULL,tmp_col_4_tmp=ADDRESS4,ADDRESS4=NULL,tmp_col_5_tmp=CITY,CITY=NULL,tmp_col_6_tmp=C_LOCATION_UU,C_LOCATION_UU=NULL,tmp_col_7_tmp=REGIONNAME,REGIONNAME=NULL,tmp_col_8_tmp=RESULT,RESULT=NULL;
ALTER TABLE C_LOCATION MODIFY (ADDRESS1 VARCHAR2(60 CHAR),ADDRESS2 VARCHAR2(60 CHAR),ADDRESS3 VARCHAR2(60 CHAR),ADDRESS4 VARCHAR2(60 CHAR),CITY VARCHAR2(60 CHAR),C_LOCATION_UU VARCHAR2(36 CHAR),REGIONNAME VARCHAR2(40 CHAR),RESULT VARCHAR2(2000 CHAR));
UPDATE C_LOCATION SET ADDRESS1=tmp_col_1_tmp,ADDRESS2=tmp_col_2_tmp,ADDRESS3=tmp_col_3_tmp,ADDRESS4=tmp_col_4_tmp,CITY=tmp_col_5_tmp,C_LOCATION_UU=tmp_col_6_tmp,REGIONNAME=tmp_col_7_tmp,RESULT=tmp_col_8_tmp;
ALTER TABLE C_LOCATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table C_NONBUSINESSDAY
ALTER TABLE C_NONBUSINESSDAY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE C_NONBUSINESSDAY SET tmp_col_1_tmp=C_NONBUSINESSDAY_UU,C_NONBUSINESSDAY_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_NONBUSINESSDAY MODIFY (C_NONBUSINESSDAY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_NONBUSINESSDAY SET C_NONBUSINESSDAY_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_NONBUSINESSDAY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_ONLINETRXHISTORY
ALTER TABLE C_ONLINETRXHISTORY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE C_ONLINETRXHISTORY SET tmp_col_1_tmp=C_ONLINETRXHISTORY_UU,C_ONLINETRXHISTORY_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE C_ONLINETRXHISTORY MODIFY (C_ONLINETRXHISTORY_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE C_ONLINETRXHISTORY SET C_ONLINETRXHISTORY_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp;
ALTER TABLE C_ONLINETRXHISTORY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_OPPORTUNITY
ALTER TABLE C_OPPORTUNITY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_OPPORTUNITY MODIFY (DOCUMENTNO NVARCHAR2(60) NULL);
UPDATE C_OPPORTUNITY SET tmp_col_1_tmp=C_OPPORTUNITY_UU,C_OPPORTUNITY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_OPPORTUNITY MODIFY (C_OPPORTUNITY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(60 CHAR));
UPDATE C_OPPORTUNITY SET C_OPPORTUNITY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp;
ALTER TABLE C_OPPORTUNITY MODIFY (DOCUMENTNO VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_OPPORTUNITY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_ORDER
ALTER TABLE C_ORDER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(30 CHAR));
ALTER TABLE C_ORDER MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_ORDER SET tmp_col_1_tmp=C_ORDER_UU,C_ORDER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=ORDERTYPE,ORDERTYPE=NULL,tmp_col_5_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_6_tmp=PROMOTIONCODE,PROMOTIONCODE=NULL;
ALTER TABLE C_ORDER MODIFY (C_ORDER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),ORDERTYPE VARCHAR2(510 CHAR),POREFERENCE VARCHAR2(20 CHAR),PROMOTIONCODE VARCHAR2(30 CHAR));
UPDATE C_ORDER SET C_ORDER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,ORDERTYPE=tmp_col_4_tmp,POREFERENCE=tmp_col_5_tmp,PROMOTIONCODE=tmp_col_6_tmp;
ALTER TABLE C_ORDER MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_ORDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_ORDERLANDEDCOST
ALTER TABLE C_ORDERLANDEDCOST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_ORDERLANDEDCOST SET tmp_col_1_tmp=C_ORDERLANDEDCOST_UU,C_ORDERLANDEDCOST_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_ORDERLANDEDCOST MODIFY (C_ORDERLANDEDCOST_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_ORDERLANDEDCOST SET C_ORDERLANDEDCOST_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_ORDERLANDEDCOST DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_ORDERLANDEDCOSTALLOCATION
ALTER TABLE C_ORDERLANDEDCOSTALLOCATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ORDERLANDEDCOSTALLOCATION SET tmp_col_1_tmp=C_ORDERLANDEDCOSTALLOCATION_UU,C_ORDERLANDEDCOSTALLOCATION_UU=NULL;
ALTER TABLE C_ORDERLANDEDCOSTALLOCATION MODIFY (C_ORDERLANDEDCOSTALLOCATION_UU VARCHAR2(36 CHAR));
UPDATE C_ORDERLANDEDCOSTALLOCATION SET C_ORDERLANDEDCOSTALLOCATION_UU=tmp_col_1_tmp;
ALTER TABLE C_ORDERLANDEDCOSTALLOCATION DROP (tmp_col_1_tmp);

-- Processing table C_ORDERLINE
ALTER TABLE C_ORDERLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_ORDERLINE SET tmp_col_1_tmp=C_ORDERLINE_UU,C_ORDERLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_ORDERLINE MODIFY (C_ORDERLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_ORDERLINE SET C_ORDERLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_ORDERLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_ORDERPAYSCHEDULE
ALTER TABLE C_ORDERPAYSCHEDULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ORDERPAYSCHEDULE SET tmp_col_1_tmp=C_ORDERPAYSCHEDULE_UU,C_ORDERPAYSCHEDULE_UU=NULL;
ALTER TABLE C_ORDERPAYSCHEDULE MODIFY (C_ORDERPAYSCHEDULE_UU VARCHAR2(36 CHAR));
UPDATE C_ORDERPAYSCHEDULE SET C_ORDERPAYSCHEDULE_UU=tmp_col_1_tmp;
ALTER TABLE C_ORDERPAYSCHEDULE DROP (tmp_col_1_tmp);

-- Processing table C_ORDERSOURCE
ALTER TABLE C_ORDERSOURCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_ORDERSOURCE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_ORDERSOURCE SET tmp_col_1_tmp=C_ORDERSOURCE_UU,C_ORDERSOURCE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_ORDERSOURCE MODIFY (C_ORDERSOURCE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_ORDERSOURCE SET C_ORDERSOURCE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_ORDERSOURCE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_ORDERSOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_ORDERTAX
ALTER TABLE C_ORDERTAX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_ORDERTAX SET tmp_col_1_tmp=C_ORDERTAX_UU,C_ORDERTAX_UU=NULL;
ALTER TABLE C_ORDERTAX MODIFY (C_ORDERTAX_UU VARCHAR2(36 CHAR));
UPDATE C_ORDERTAX SET C_ORDERTAX_UU=tmp_col_1_tmp;
ALTER TABLE C_ORDERTAX DROP (tmp_col_1_tmp);

-- Processing table C_ORGASSIGNMENT
ALTER TABLE C_ORGASSIGNMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_ORGASSIGNMENT SET tmp_col_1_tmp=C_ORGASSIGNMENT_UU,C_ORGASSIGNMENT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_ORGASSIGNMENT MODIFY (C_ORGASSIGNMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_ORGASSIGNMENT SET C_ORGASSIGNMENT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_ORGASSIGNMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PAYMENT
ALTER TABLE C_PAYMENT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(20 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(60 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(36 CHAR),tmp_col_17_tmp VARCHAR2(255 CHAR),tmp_col_18_tmp VARCHAR2(30 CHAR),tmp_col_19_tmp VARCHAR2(20 CHAR),tmp_col_20_tmp VARCHAR2(20 CHAR),tmp_col_21_tmp VARCHAR2(60 CHAR),tmp_col_22_tmp VARCHAR2(20 CHAR),tmp_col_23_tmp VARCHAR2(20 CHAR),tmp_col_24_tmp VARCHAR2(20 CHAR),tmp_col_25_tmp VARCHAR2(2000 CHAR),tmp_col_26_tmp VARCHAR2(20 CHAR),tmp_col_27_tmp VARCHAR2(20 CHAR),tmp_col_28_tmp VARCHAR2(60 CHAR),tmp_col_29_tmp VARCHAR2(20 CHAR),tmp_col_30_tmp VARCHAR2(255 CHAR),tmp_col_31_tmp VARCHAR2(20 CHAR));
ALTER TABLE C_PAYMENT MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE C_PAYMENT SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=A_CITY,A_CITY=NULL,tmp_col_3_tmp=A_COUNTRY,A_COUNTRY=NULL,tmp_col_4_tmp=A_EMAIL,A_EMAIL=NULL,tmp_col_5_tmp=A_IDENT_DL,A_IDENT_DL=NULL,tmp_col_6_tmp=A_IDENT_SSN,A_IDENT_SSN=NULL,tmp_col_7_tmp=A_NAME,A_NAME=NULL,tmp_col_8_tmp=A_STATE,A_STATE=NULL,tmp_col_9_tmp=A_STREET,A_STREET=NULL,tmp_col_10_tmp=A_ZIP,A_ZIP=NULL,tmp_col_11_tmp=CHECKNO,CHECKNO=NULL,tmp_col_12_tmp=CREDITCARDNUMBER,CREDITCARDNUMBER=NULL,tmp_col_13_tmp=CUSTOMERADDRESSID,CUSTOMERADDRESSID=NULL,tmp_col_14_tmp=CUSTOMERPAYMENTPROFILEID,CUSTOMERPAYMENTPROFILEID=NULL,tmp_col_15_tmp=CUSTOMERPROFILEID,CUSTOMERPROFILEID=NULL,tmp_col_16_tmp=C_PAYMENT_UU,C_PAYMENT_UU=NULL,tmp_col_17_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_18_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_19_tmp=MICR,MICR=NULL,tmp_col_20_tmp=ORIG_TRXID,ORIG_TRXID=NULL,tmp_col_21_tmp=PONUM,PONUM=NULL,tmp_col_22_tmp=ROUTINGNO,ROUTINGNO=NULL,tmp_col_23_tmp=R_AUTHCODE,R_AUTHCODE=NULL,tmp_col_24_tmp=R_AUTHCODE_DC,R_AUTHCODE_DC=NULL,tmp_col_25_tmp=R_INFO,R_INFO=NULL,tmp_col_26_tmp=R_PNREF,R_PNREF=NULL,tmp_col_27_tmp=R_PNREF_DC,R_PNREF_DC=NULL,tmp_col_28_tmp=R_RESPMSG,R_RESPMSG=NULL,tmp_col_29_tmp=R_RESULT,R_RESULT=NULL,tmp_col_30_tmp=R_VOIDMSG,R_VOIDMSG=NULL,tmp_col_31_tmp=VOICEAUTHCODE,VOICEAUTHCODE=NULL;
ALTER TABLE C_PAYMENT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),A_CITY VARCHAR2(60 CHAR),A_COUNTRY VARCHAR2(40 CHAR),A_EMAIL VARCHAR2(60 CHAR),A_IDENT_DL VARCHAR2(20 CHAR),A_IDENT_SSN VARCHAR2(20 CHAR),A_NAME VARCHAR2(60 CHAR),A_STATE VARCHAR2(40 CHAR),A_STREET VARCHAR2(60 CHAR),A_ZIP VARCHAR2(20 CHAR),CHECKNO VARCHAR2(20 CHAR),CREDITCARDNUMBER VARCHAR2(20 CHAR),CUSTOMERADDRESSID VARCHAR2(60 CHAR),CUSTOMERPAYMENTPROFILEID VARCHAR2(60 CHAR),CUSTOMERPROFILEID VARCHAR2(60 CHAR),C_PAYMENT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),MICR VARCHAR2(20 CHAR),ORIG_TRXID VARCHAR2(20 CHAR),PONUM VARCHAR2(60 CHAR),ROUTINGNO VARCHAR2(20 CHAR),R_AUTHCODE VARCHAR2(20 CHAR),R_AUTHCODE_DC VARCHAR2(20 CHAR),R_INFO VARCHAR2(2000 CHAR),R_PNREF VARCHAR2(20 CHAR),R_PNREF_DC VARCHAR2(20 CHAR),R_RESPMSG VARCHAR2(60 CHAR),R_RESULT VARCHAR2(20 CHAR),R_VOIDMSG VARCHAR2(255 CHAR),VOICEAUTHCODE VARCHAR2(20 CHAR));
UPDATE C_PAYMENT SET ACCOUNTNO=tmp_col_1_tmp,A_CITY=tmp_col_2_tmp,A_COUNTRY=tmp_col_3_tmp,A_EMAIL=tmp_col_4_tmp,A_IDENT_DL=tmp_col_5_tmp,A_IDENT_SSN=tmp_col_6_tmp,A_NAME=tmp_col_7_tmp,A_STATE=tmp_col_8_tmp,A_STREET=tmp_col_9_tmp,A_ZIP=tmp_col_10_tmp,CHECKNO=tmp_col_11_tmp,CREDITCARDNUMBER=tmp_col_12_tmp,CUSTOMERADDRESSID=tmp_col_13_tmp,CUSTOMERPAYMENTPROFILEID=tmp_col_14_tmp,CUSTOMERPROFILEID=tmp_col_15_tmp,C_PAYMENT_UU=tmp_col_16_tmp,DESCRIPTION=tmp_col_17_tmp,DOCUMENTNO=tmp_col_18_tmp,MICR=tmp_col_19_tmp,ORIG_TRXID=tmp_col_20_tmp,PONUM=tmp_col_21_tmp,ROUTINGNO=tmp_col_22_tmp,R_AUTHCODE=tmp_col_23_tmp,R_AUTHCODE_DC=tmp_col_24_tmp,R_INFO=tmp_col_25_tmp,R_PNREF=tmp_col_26_tmp,R_PNREF_DC=tmp_col_27_tmp,R_RESPMSG=tmp_col_28_tmp,R_RESULT=tmp_col_29_tmp,R_VOIDMSG=tmp_col_30_tmp,VOICEAUTHCODE=tmp_col_31_tmp;
ALTER TABLE C_PAYMENT MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE C_PAYMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp,tmp_col_25_tmp,tmp_col_26_tmp,tmp_col_27_tmp,tmp_col_28_tmp,tmp_col_29_tmp,tmp_col_30_tmp,tmp_col_31_tmp);

-- Processing table C_PAYMENTALLOCATE
ALTER TABLE C_PAYMENTALLOCATE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_PAYMENTALLOCATE SET tmp_col_1_tmp=C_PAYMENTALLOCATE_UU,C_PAYMENTALLOCATE_UU=NULL;
ALTER TABLE C_PAYMENTALLOCATE MODIFY (C_PAYMENTALLOCATE_UU VARCHAR2(36 CHAR));
UPDATE C_PAYMENTALLOCATE SET C_PAYMENTALLOCATE_UU=tmp_col_1_tmp;
ALTER TABLE C_PAYMENTALLOCATE DROP (tmp_col_1_tmp);

-- Processing table C_PAYMENTBATCH
ALTER TABLE C_PAYMENTBATCH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PAYMENTBATCH MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PAYMENTBATCH SET tmp_col_1_tmp=C_PAYMENTBATCH_UU,C_PAYMENTBATCH_UU=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_PAYMENTBATCH MODIFY (C_PAYMENTBATCH_UU VARCHAR2(36 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PAYMENTBATCH SET C_PAYMENTBATCH_UU=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_PAYMENTBATCH MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PAYMENTBATCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_PAYMENTPROCESSOR
ALTER TABLE C_PAYMENTPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PAYMENTPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PAYMENTPROCESSOR SET tmp_col_1_tmp=C_PAYMENTPROCESSOR_UU,C_PAYMENTPROCESSOR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HOSTADDRESS,HOSTADDRESS=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PAYPROCESSORCLASS,PAYPROCESSORCLASS=NULL,tmp_col_6_tmp=PROXYADDRESS,PROXYADDRESS=NULL,tmp_col_7_tmp=PROXYLOGON,PROXYLOGON=NULL,tmp_col_8_tmp=PROXYPASSWORD,PROXYPASSWORD=NULL;
ALTER TABLE C_PAYMENTPROCESSOR MODIFY (C_PAYMENTPROCESSOR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HOSTADDRESS VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),PAYPROCESSORCLASS VARCHAR2(60 CHAR),PROXYADDRESS VARCHAR2(60 CHAR),PROXYLOGON VARCHAR2(60 CHAR),PROXYPASSWORD VARCHAR2(60 CHAR));
UPDATE C_PAYMENTPROCESSOR SET C_PAYMENTPROCESSOR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HOSTADDRESS=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PAYPROCESSORCLASS=tmp_col_5_tmp,PROXYADDRESS=tmp_col_6_tmp,PROXYLOGON=tmp_col_7_tmp,PROXYPASSWORD=tmp_col_8_tmp;
ALTER TABLE C_PAYMENTPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PAYMENTPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table C_PAYMENTTERM
ALTER TABLE C_PAYMENTTERM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_PAYMENTTERM MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_PAYMENTTERM SET tmp_col_1_tmp=C_PAYMENTTERM_UU,C_PAYMENTTERM_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_PAYMENTTERM MODIFY (C_PAYMENTTERM_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_PAYMENTTERM SET C_PAYMENTTERM_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNOTE=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_PAYMENTTERM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_PAYMENTTERM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_PAYMENTTERM_TRL
ALTER TABLE C_PAYMENTTERM_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PAYMENTTERM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PAYMENTTERM_TRL SET tmp_col_1_tmp=C_PAYMENTTERM_TRL_UU,C_PAYMENTTERM_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_PAYMENTTERM_TRL MODIFY (C_PAYMENTTERM_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PAYMENTTERM_TRL SET C_PAYMENTTERM_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNOTE=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_PAYMENTTERM_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PAYMENTTERM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_PAYMENTTRANSACTION
ALTER TABLE C_PAYMENTTRANSACTION ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(20 CHAR),tmp_col_13_tmp VARCHAR2(4 CHAR),tmp_col_14_tmp VARCHAR2(60 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR),tmp_col_17_tmp VARCHAR2(36 CHAR),tmp_col_18_tmp VARCHAR2(255 CHAR),tmp_col_19_tmp VARCHAR2(20 CHAR),tmp_col_20_tmp VARCHAR2(20 CHAR),tmp_col_21_tmp VARCHAR2(60 CHAR),tmp_col_22_tmp VARCHAR2(20 CHAR),tmp_col_23_tmp VARCHAR2(20 CHAR),tmp_col_24_tmp VARCHAR2(2000 CHAR),tmp_col_25_tmp VARCHAR2(20 CHAR),tmp_col_26_tmp VARCHAR2(60 CHAR),tmp_col_27_tmp VARCHAR2(20 CHAR),tmp_col_28_tmp VARCHAR2(255 CHAR),tmp_col_29_tmp VARCHAR2(20 CHAR));
UPDATE C_PAYMENTTRANSACTION SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=A_CITY,A_CITY=NULL,tmp_col_3_tmp=A_COUNTRY,A_COUNTRY=NULL,tmp_col_4_tmp=A_EMAIL,A_EMAIL=NULL,tmp_col_5_tmp=A_IDENT_DL,A_IDENT_DL=NULL,tmp_col_6_tmp=A_IDENT_SSN,A_IDENT_SSN=NULL,tmp_col_7_tmp=A_NAME,A_NAME=NULL,tmp_col_8_tmp=A_STATE,A_STATE=NULL,tmp_col_9_tmp=A_STREET,A_STREET=NULL,tmp_col_10_tmp=A_ZIP,A_ZIP=NULL,tmp_col_11_tmp=CHECKNO,CHECKNO=NULL,tmp_col_12_tmp=CREDITCARDNUMBER,CREDITCARDNUMBER=NULL,tmp_col_13_tmp=CREDITCARDVV,CREDITCARDVV=NULL,tmp_col_14_tmp=CUSTOMERADDRESSID,CUSTOMERADDRESSID=NULL,tmp_col_15_tmp=CUSTOMERPAYMENTPROFILEID,CUSTOMERPAYMENTPROFILEID=NULL,tmp_col_16_tmp=CUSTOMERPROFILEID,CUSTOMERPROFILEID=NULL,tmp_col_17_tmp=C_PAYMENTTRANSACTION_UU,C_PAYMENTTRANSACTION_UU=NULL,tmp_col_18_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_19_tmp=MICR,MICR=NULL,tmp_col_20_tmp=ORIG_TRXID,ORIG_TRXID=NULL,tmp_col_21_tmp=PONUM,PONUM=NULL,tmp_col_22_tmp=ROUTINGNO,ROUTINGNO=NULL,tmp_col_23_tmp=R_AUTHCODE,R_AUTHCODE=NULL,tmp_col_24_tmp=R_INFO,R_INFO=NULL,tmp_col_25_tmp=R_PNREF,R_PNREF=NULL,tmp_col_26_tmp=R_RESPMSG,R_RESPMSG=NULL,tmp_col_27_tmp=R_RESULT,R_RESULT=NULL,tmp_col_28_tmp=R_VOIDMSG,R_VOIDMSG=NULL,tmp_col_29_tmp=VOICEAUTHCODE,VOICEAUTHCODE=NULL;
ALTER TABLE C_PAYMENTTRANSACTION MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),A_CITY VARCHAR2(60 CHAR),A_COUNTRY VARCHAR2(40 CHAR),A_EMAIL VARCHAR2(60 CHAR),A_IDENT_DL VARCHAR2(20 CHAR),A_IDENT_SSN VARCHAR2(20 CHAR),A_NAME VARCHAR2(60 CHAR),A_STATE VARCHAR2(40 CHAR),A_STREET VARCHAR2(60 CHAR),A_ZIP VARCHAR2(20 CHAR),CHECKNO VARCHAR2(20 CHAR),CREDITCARDNUMBER VARCHAR2(20 CHAR),CREDITCARDVV VARCHAR2(4 CHAR),CUSTOMERADDRESSID VARCHAR2(60 CHAR),CUSTOMERPAYMENTPROFILEID VARCHAR2(60 CHAR),CUSTOMERPROFILEID VARCHAR2(60 CHAR),C_PAYMENTTRANSACTION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),MICR VARCHAR2(20 CHAR),ORIG_TRXID VARCHAR2(20 CHAR),PONUM VARCHAR2(60 CHAR),ROUTINGNO VARCHAR2(20 CHAR),R_AUTHCODE VARCHAR2(20 CHAR),R_INFO VARCHAR2(2000 CHAR),R_PNREF VARCHAR2(20 CHAR),R_RESPMSG VARCHAR2(60 CHAR),R_RESULT VARCHAR2(20 CHAR),R_VOIDMSG VARCHAR2(255 CHAR),VOICEAUTHCODE VARCHAR2(20 CHAR));
UPDATE C_PAYMENTTRANSACTION SET ACCOUNTNO=tmp_col_1_tmp,A_CITY=tmp_col_2_tmp,A_COUNTRY=tmp_col_3_tmp,A_EMAIL=tmp_col_4_tmp,A_IDENT_DL=tmp_col_5_tmp,A_IDENT_SSN=tmp_col_6_tmp,A_NAME=tmp_col_7_tmp,A_STATE=tmp_col_8_tmp,A_STREET=tmp_col_9_tmp,A_ZIP=tmp_col_10_tmp,CHECKNO=tmp_col_11_tmp,CREDITCARDNUMBER=tmp_col_12_tmp,CREDITCARDVV=tmp_col_13_tmp,CUSTOMERADDRESSID=tmp_col_14_tmp,CUSTOMERPAYMENTPROFILEID=tmp_col_15_tmp,CUSTOMERPROFILEID=tmp_col_16_tmp,C_PAYMENTTRANSACTION_UU=tmp_col_17_tmp,DESCRIPTION=tmp_col_18_tmp,MICR=tmp_col_19_tmp,ORIG_TRXID=tmp_col_20_tmp,PONUM=tmp_col_21_tmp,ROUTINGNO=tmp_col_22_tmp,R_AUTHCODE=tmp_col_23_tmp,R_INFO=tmp_col_24_tmp,R_PNREF=tmp_col_25_tmp,R_RESPMSG=tmp_col_26_tmp,R_RESULT=tmp_col_27_tmp,R_VOIDMSG=tmp_col_28_tmp,VOICEAUTHCODE=tmp_col_29_tmp;
ALTER TABLE C_PAYMENTTRANSACTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp,tmp_col_25_tmp,tmp_col_26_tmp,tmp_col_27_tmp,tmp_col_28_tmp,tmp_col_29_tmp);

-- Processing table C_PAYSCHEDULE
ALTER TABLE C_PAYSCHEDULE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_PAYSCHEDULE SET tmp_col_1_tmp=C_PAYSCHEDULE_UU,C_PAYSCHEDULE_UU=NULL;
ALTER TABLE C_PAYSCHEDULE MODIFY (C_PAYSCHEDULE_UU VARCHAR2(36 CHAR));
UPDATE C_PAYSCHEDULE SET C_PAYSCHEDULE_UU=tmp_col_1_tmp;
ALTER TABLE C_PAYSCHEDULE DROP (tmp_col_1_tmp);

-- Processing table C_PAYSELECTION
ALTER TABLE C_PAYSELECTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR));
ALTER TABLE C_PAYSELECTION MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE C_PAYSELECTION SET tmp_col_1_tmp=C_PAYSELECTION_UU,C_PAYSELECTION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_PAYSELECTION MODIFY (C_PAYSELECTION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR));
UPDATE C_PAYSELECTION SET C_PAYSELECTION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_PAYSELECTION MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE C_PAYSELECTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_PAYSELECTIONCHECK
ALTER TABLE C_PAYSELECTIONCHECK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR));
UPDATE C_PAYSELECTIONCHECK SET tmp_col_1_tmp=C_PAYSELECTIONCHECK_UU,C_PAYSELECTIONCHECK_UU=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL;
ALTER TABLE C_PAYSELECTIONCHECK MODIFY (C_PAYSELECTIONCHECK_UU VARCHAR2(36 CHAR),DOCUMENTNO VARCHAR2(30 CHAR));
UPDATE C_PAYSELECTIONCHECK SET C_PAYSELECTIONCHECK_UU=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp;
ALTER TABLE C_PAYSELECTIONCHECK DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PAYSELECTIONLINE
ALTER TABLE C_PAYSELECTIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_PAYSELECTIONLINE SET tmp_col_1_tmp=C_PAYSELECTIONLINE_UU,C_PAYSELECTIONLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_PAYSELECTIONLINE MODIFY (C_PAYSELECTIONLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_PAYSELECTIONLINE SET C_PAYSELECTIONLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_PAYSELECTIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PERIOD
ALTER TABLE C_PERIOD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PERIOD MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PERIOD SET tmp_col_1_tmp=C_PERIOD_UU,C_PERIOD_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_PERIOD MODIFY (C_PERIOD_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PERIOD SET C_PERIOD_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_PERIOD MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PERIOD DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PERIODCONTROL
ALTER TABLE C_PERIODCONTROL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_PERIODCONTROL SET tmp_col_1_tmp=C_PERIODCONTROL_UU,C_PERIODCONTROL_UU=NULL;
ALTER TABLE C_PERIODCONTROL MODIFY (C_PERIODCONTROL_UU VARCHAR2(36 CHAR));
UPDATE C_PERIODCONTROL SET C_PERIODCONTROL_UU=tmp_col_1_tmp;
ALTER TABLE C_PERIODCONTROL DROP (tmp_col_1_tmp);

-- Processing table C_PHASE
ALTER TABLE C_PHASE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PHASE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PHASE SET tmp_col_1_tmp=C_PHASE_UU,C_PHASE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_PHASE MODIFY (C_PHASE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PHASE SET C_PHASE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_PHASE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PHASE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_POS
ALTER TABLE C_POS ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_POS MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_POS SET tmp_col_1_tmp=CASHDRAWER,CASHDRAWER=NULL,tmp_col_2_tmp=C_POS_UU,C_POS_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PRINTERNAME,PRINTERNAME=NULL;
ALTER TABLE C_POS MODIFY (CASHDRAWER VARCHAR2(120 CHAR),C_POS_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PRINTERNAME VARCHAR2(60 CHAR));
UPDATE C_POS SET CASHDRAWER=tmp_col_1_tmp,C_POS_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PRINTERNAME=tmp_col_6_tmp;
ALTER TABLE C_POS MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_POS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_POSKEY
ALTER TABLE C_POSKEY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(22 CHAR));
ALTER TABLE C_POSKEY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_POSKEY SET tmp_col_1_tmp=C_POSKEY_UU,C_POSKEY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=TEXT,TEXT=NULL;
ALTER TABLE C_POSKEY MODIFY (C_POSKEY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),TEXT VARCHAR2(22 CHAR));
UPDATE C_POSKEY SET C_POSKEY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,TEXT=tmp_col_4_tmp;
ALTER TABLE C_POSKEY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_POSKEY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_POSKEYLAYOUT
ALTER TABLE C_POSKEYLAYOUT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_POSKEYLAYOUT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_POSKEYLAYOUT SET tmp_col_1_tmp=C_POSKEYLAYOUT_UU,C_POSKEYLAYOUT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_POSKEYLAYOUT MODIFY (C_POSKEYLAYOUT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_POSKEYLAYOUT SET C_POSKEYLAYOUT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_POSKEYLAYOUT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_POSKEYLAYOUT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_POSPAYMENT
ALTER TABLE C_POSPAYMENT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(20 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(20 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR));
UPDATE C_POSPAYMENT SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=A_NAME,A_NAME=NULL,tmp_col_3_tmp=CHECKNO,CHECKNO=NULL,tmp_col_4_tmp=CREDITCARDNUMBER,CREDITCARDNUMBER=NULL,tmp_col_5_tmp=C_POSPAYMENT_UU,C_POSPAYMENT_UU=NULL,tmp_col_6_tmp=DEPOSITGROUP,DEPOSITGROUP=NULL,tmp_col_7_tmp=HELP,HELP=NULL,tmp_col_8_tmp=MICR,MICR=NULL,tmp_col_9_tmp=ROUTINGNO,ROUTINGNO=NULL,tmp_col_10_tmp=VOICEAUTHCODE,VOICEAUTHCODE=NULL;
ALTER TABLE C_POSPAYMENT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),A_NAME VARCHAR2(60 CHAR),CHECKNO VARCHAR2(20 CHAR),CREDITCARDNUMBER VARCHAR2(20 CHAR),C_POSPAYMENT_UU VARCHAR2(36 CHAR),DEPOSITGROUP VARCHAR2(20 CHAR),HELP VARCHAR2(2000 CHAR),MICR VARCHAR2(20 CHAR),ROUTINGNO VARCHAR2(20 CHAR),VOICEAUTHCODE VARCHAR2(20 CHAR));
UPDATE C_POSPAYMENT SET ACCOUNTNO=tmp_col_1_tmp,A_NAME=tmp_col_2_tmp,CHECKNO=tmp_col_3_tmp,CREDITCARDNUMBER=tmp_col_4_tmp,C_POSPAYMENT_UU=tmp_col_5_tmp,DEPOSITGROUP=tmp_col_6_tmp,HELP=tmp_col_7_tmp,MICR=tmp_col_8_tmp,ROUTINGNO=tmp_col_9_tmp,VOICEAUTHCODE=tmp_col_10_tmp;
ALTER TABLE C_POSPAYMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table C_POSTENDERTYPE
ALTER TABLE C_POSTENDERTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_POSTENDERTYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_POSTENDERTYPE SET tmp_col_1_tmp=C_POSTENDERTYPE_UU,C_POSTENDERTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_POSTENDERTYPE MODIFY (C_POSTENDERTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_POSTENDERTYPE SET C_POSTENDERTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_POSTENDERTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_POSTENDERTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_PROJECT
ALTER TABLE C_PROJECT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_PROJECT MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_PROJECT SET tmp_col_1_tmp=C_PROJECT_UU,C_PROJECT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=NOTE,NOTE=NULL,tmp_col_5_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_PROJECT MODIFY (C_PROJECT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),NOTE VARCHAR2(2000 CHAR),POREFERENCE VARCHAR2(20 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_PROJECT SET C_PROJECT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,NOTE=tmp_col_4_tmp,POREFERENCE=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE C_PROJECT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_PROJECT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_PROJECTISSUE
ALTER TABLE C_PROJECTISSUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_PROJECTISSUE SET tmp_col_1_tmp=C_PROJECTISSUE_UU,C_PROJECTISSUE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_PROJECTISSUE MODIFY (C_PROJECTISSUE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_PROJECTISSUE SET C_PROJECTISSUE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_PROJECTISSUE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PROJECTISSUEMA
ALTER TABLE C_PROJECTISSUEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_PROJECTISSUEMA SET tmp_col_1_tmp=C_PROJECTISSUEMA_UU,C_PROJECTISSUEMA_UU=NULL;
ALTER TABLE C_PROJECTISSUEMA MODIFY (C_PROJECTISSUEMA_UU VARCHAR2(36 CHAR));
UPDATE C_PROJECTISSUEMA SET C_PROJECTISSUEMA_UU=tmp_col_1_tmp;
ALTER TABLE C_PROJECTISSUEMA DROP (tmp_col_1_tmp);

-- Processing table C_PROJECTLINE
ALTER TABLE C_PROJECTLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_PROJECTLINE SET tmp_col_1_tmp=C_PROJECTLINE_UU,C_PROJECTLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_PROJECTLINE MODIFY (C_PROJECTLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_PROJECTLINE SET C_PROJECTLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_PROJECTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_PROJECTPHASE
ALTER TABLE C_PROJECTPHASE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PROJECTPHASE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PROJECTPHASE SET tmp_col_1_tmp=C_PROJECTPHASE_UU,C_PROJECTPHASE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_PROJECTPHASE MODIFY (C_PROJECTPHASE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PROJECTPHASE SET C_PROJECTPHASE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_PROJECTPHASE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PROJECTPHASE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_PROJECTTASK
ALTER TABLE C_PROJECTTASK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PROJECTTASK MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PROJECTTASK SET tmp_col_1_tmp=C_PROJECTTASK_UU,C_PROJECTTASK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_PROJECTTASK MODIFY (C_PROJECTTASK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PROJECTTASK SET C_PROJECTTASK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_PROJECTTASK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PROJECTTASK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_PROJECTTYPE
ALTER TABLE C_PROJECTTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_PROJECTTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_PROJECTTYPE SET tmp_col_1_tmp=C_PROJECTTYPE_UU,C_PROJECTTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_PROJECTTYPE MODIFY (C_PROJECTTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_PROJECTTYPE SET C_PROJECTTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_PROJECTTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_PROJECTTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_PROJECT_ACCT
ALTER TABLE C_PROJECT_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_PROJECT_ACCT SET tmp_col_1_tmp=C_PROJECT_ACCT_UU,C_PROJECT_ACCT_UU=NULL;
ALTER TABLE C_PROJECT_ACCT MODIFY (C_PROJECT_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_PROJECT_ACCT SET C_PROJECT_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_PROJECT_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_RECURRING
ALTER TABLE C_RECURRING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_RECURRING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_RECURRING SET tmp_col_1_tmp=C_RECURRING_UU,C_RECURRING_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_RECURRING MODIFY (C_RECURRING_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_RECURRING SET C_RECURRING_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_RECURRING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_RECURRING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_RECURRING_RUN
ALTER TABLE C_RECURRING_RUN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_RECURRING_RUN SET tmp_col_1_tmp=C_RECURRING_RUN_UU,C_RECURRING_RUN_UU=NULL;
ALTER TABLE C_RECURRING_RUN MODIFY (C_RECURRING_RUN_UU VARCHAR2(36 CHAR));
UPDATE C_RECURRING_RUN SET C_RECURRING_RUN_UU=tmp_col_1_tmp;
ALTER TABLE C_RECURRING_RUN DROP (tmp_col_1_tmp);

-- Processing table C_REGION
ALTER TABLE C_REGION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_REGION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_REGION SET tmp_col_1_tmp=C_REGION_UU,C_REGION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_REGION MODIFY (C_REGION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_REGION SET C_REGION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_REGION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_REGION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_REGION_TRL
ALTER TABLE C_REGION_TRL ADD (tmp_col_1_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_REGION_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_REGION_TRL SET tmp_col_1_tmp=NAME,NAME=NULL;
ALTER TABLE C_REGION_TRL MODIFY (NAME VARCHAR2(60 CHAR));
UPDATE C_REGION_TRL SET NAME=tmp_col_1_tmp;
ALTER TABLE C_REGION_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_REGION_TRL DROP (tmp_col_1_tmp);

-- Processing table C_REMUNERATION
ALTER TABLE C_REMUNERATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_REMUNERATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_REMUNERATION SET tmp_col_1_tmp=C_REMUNERATION_UU,C_REMUNERATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_REMUNERATION MODIFY (C_REMUNERATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_REMUNERATION SET C_REMUNERATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_REMUNERATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_REMUNERATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_REVENUERECOGNITION
ALTER TABLE C_REVENUERECOGNITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_REVENUERECOGNITION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_REVENUERECOGNITION SET tmp_col_1_tmp=C_REVENUERECOGNITION_UU,C_REVENUERECOGNITION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_REVENUERECOGNITION MODIFY (C_REVENUERECOGNITION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_REVENUERECOGNITION SET C_REVENUERECOGNITION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_REVENUERECOGNITION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_REVENUERECOGNITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_REVENUERECOGNITION_PLAN
ALTER TABLE C_REVENUERECOGNITION_PLAN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_REVENUERECOGNITION_PLAN SET tmp_col_1_tmp=C_REVENUERECOGNITION_PLAN_UU,C_REVENUERECOGNITION_PLAN_UU=NULL;
ALTER TABLE C_REVENUERECOGNITION_PLAN MODIFY (C_REVENUERECOGNITION_PLAN_UU VARCHAR2(36 CHAR));
UPDATE C_REVENUERECOGNITION_PLAN SET C_REVENUERECOGNITION_PLAN_UU=tmp_col_1_tmp;
ALTER TABLE C_REVENUERECOGNITION_PLAN DROP (tmp_col_1_tmp);

-- Processing table C_REVENUERECOGNITION_RUN
ALTER TABLE C_REVENUERECOGNITION_RUN ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_REVENUERECOGNITION_RUN SET tmp_col_1_tmp=C_REVENUERECOGNITION_RUN_UU,C_REVENUERECOGNITION_RUN_UU=NULL;
ALTER TABLE C_REVENUERECOGNITION_RUN MODIFY (C_REVENUERECOGNITION_RUN_UU VARCHAR2(36 CHAR));
UPDATE C_REVENUERECOGNITION_RUN SET C_REVENUERECOGNITION_RUN_UU=tmp_col_1_tmp;
ALTER TABLE C_REVENUERECOGNITION_RUN DROP (tmp_col_1_tmp);

-- Processing table C_RFQ
ALTER TABLE C_RFQ ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_RFQ MODIFY (DOCUMENTNO NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE C_RFQ SET tmp_col_1_tmp=C_RFQ_UU,C_RFQ_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE C_RFQ MODIFY (C_RFQ_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR) DEFAULT '.' ,HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_RFQ SET C_RFQ_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE C_RFQ MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) DEFAULT '.'  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_RFQ DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_RFQLINE
ALTER TABLE C_RFQLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE C_RFQLINE SET tmp_col_1_tmp=C_RFQLINE_UU,C_RFQLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL;
ALTER TABLE C_RFQLINE MODIFY (C_RFQLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE C_RFQLINE SET C_RFQLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp;
ALTER TABLE C_RFQLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_RFQLINEQTY
ALTER TABLE C_RFQLINEQTY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_RFQLINEQTY SET tmp_col_1_tmp=C_RFQLINEQTY_UU,C_RFQLINEQTY_UU=NULL;
ALTER TABLE C_RFQLINEQTY MODIFY (C_RFQLINEQTY_UU VARCHAR2(36 CHAR));
UPDATE C_RFQLINEQTY SET C_RFQLINEQTY_UU=tmp_col_1_tmp;
ALTER TABLE C_RFQLINEQTY DROP (tmp_col_1_tmp);

-- Processing table C_RFQRESPONSE
ALTER TABLE C_RFQRESPONSE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_RFQRESPONSE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_RFQRESPONSE SET tmp_col_1_tmp=C_RFQRESPONSE_UU,C_RFQRESPONSE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_RFQRESPONSE MODIFY (C_RFQRESPONSE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_RFQRESPONSE SET C_RFQRESPONSE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_RFQRESPONSE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_RFQRESPONSE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_RFQRESPONSELINE
ALTER TABLE C_RFQRESPONSELINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE C_RFQRESPONSELINE SET tmp_col_1_tmp=C_RFQRESPONSELINE_UU,C_RFQRESPONSELINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL;
ALTER TABLE C_RFQRESPONSELINE MODIFY (C_RFQRESPONSELINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE C_RFQRESPONSELINE SET C_RFQRESPONSELINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp;
ALTER TABLE C_RFQRESPONSELINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_RFQRESPONSELINEQTY
ALTER TABLE C_RFQRESPONSELINEQTY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_RFQRESPONSELINEQTY SET tmp_col_1_tmp=C_RFQRESPONSELINEQTY_UU,C_RFQRESPONSELINEQTY_UU=NULL;
ALTER TABLE C_RFQRESPONSELINEQTY MODIFY (C_RFQRESPONSELINEQTY_UU VARCHAR2(36 CHAR));
UPDATE C_RFQRESPONSELINEQTY SET C_RFQRESPONSELINEQTY_UU=tmp_col_1_tmp;
ALTER TABLE C_RFQRESPONSELINEQTY DROP (tmp_col_1_tmp);

-- Processing table C_RFQ_TOPIC
ALTER TABLE C_RFQ_TOPIC ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_RFQ_TOPIC MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_RFQ_TOPIC SET tmp_col_1_tmp=C_RFQ_TOPIC_UU,C_RFQ_TOPIC_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_RFQ_TOPIC MODIFY (C_RFQ_TOPIC_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_RFQ_TOPIC SET C_RFQ_TOPIC_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_RFQ_TOPIC MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_RFQ_TOPIC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_RFQ_TOPICSUBSCRIBER
ALTER TABLE C_RFQ_TOPICSUBSCRIBER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_RFQ_TOPICSUBSCRIBER SET tmp_col_1_tmp=C_RFQ_TOPICSUBSCRIBER_UU,C_RFQ_TOPICSUBSCRIBER_UU=NULL;
ALTER TABLE C_RFQ_TOPICSUBSCRIBER MODIFY (C_RFQ_TOPICSUBSCRIBER_UU VARCHAR2(36 CHAR));
UPDATE C_RFQ_TOPICSUBSCRIBER SET C_RFQ_TOPICSUBSCRIBER_UU=tmp_col_1_tmp;
ALTER TABLE C_RFQ_TOPICSUBSCRIBER DROP (tmp_col_1_tmp);

-- Processing table C_RFQ_TOPICSUBSCRIBERONLY
ALTER TABLE C_RFQ_TOPICSUBSCRIBERONLY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_RFQ_TOPICSUBSCRIBERONLY SET tmp_col_1_tmp=C_RFQ_TOPICSUBSCRIBERONLY_UU,C_RFQ_TOPICSUBSCRIBERONLY_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_RFQ_TOPICSUBSCRIBERONLY MODIFY (C_RFQ_TOPICSUBSCRIBERONLY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_RFQ_TOPICSUBSCRIBERONLY SET C_RFQ_TOPICSUBSCRIBERONLY_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_RFQ_TOPICSUBSCRIBERONLY DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SALESREGION
ALTER TABLE C_SALESREGION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_SALESREGION MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_SALESREGION SET tmp_col_1_tmp=C_SALESREGION_UU,C_SALESREGION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_SALESREGION MODIFY (C_SALESREGION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_SALESREGION SET C_SALESREGION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_SALESREGION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_SALESREGION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_SALESREGION_TRL
ALTER TABLE C_SALESREGION_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_SALESREGION_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_SALESREGION_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_SALESREGION_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_SALESREGION_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_SALESREGION_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_SALESREGION_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SALESSTAGE
ALTER TABLE C_SALESSTAGE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_SALESSTAGE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(60) NULL);
UPDATE C_SALESSTAGE SET tmp_col_1_tmp=C_SALESSTAGE_UU,C_SALESSTAGE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_SALESSTAGE MODIFY (C_SALESSTAGE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(60 CHAR));
UPDATE C_SALESSTAGE SET C_SALESSTAGE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE C_SALESSTAGE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_SALESSTAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_SALESSTAGE_TRL
ALTER TABLE C_SALESSTAGE_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_SALESSTAGE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_SALESSTAGE_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_SALESSTAGE_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_SALESSTAGE_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_SALESSTAGE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_SALESSTAGE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SERVICELEVEL
ALTER TABLE C_SERVICELEVEL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_SERVICELEVEL SET tmp_col_1_tmp=C_SERVICELEVEL_UU,C_SERVICELEVEL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_SERVICELEVEL MODIFY (C_SERVICELEVEL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_SERVICELEVEL SET C_SERVICELEVEL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_SERVICELEVEL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SERVICELEVELLINE
ALTER TABLE C_SERVICELEVELLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_SERVICELEVELLINE SET tmp_col_1_tmp=C_SERVICELEVELLINE_UU,C_SERVICELEVELLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_SERVICELEVELLINE MODIFY (C_SERVICELEVELLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_SERVICELEVELLINE SET C_SERVICELEVELLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_SERVICELEVELLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SUBACCT
ALTER TABLE C_SUBACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_SUBACCT MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_SUBACCT SET tmp_col_1_tmp=C_SUBACCT_UU,C_SUBACCT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_SUBACCT MODIFY (C_SUBACCT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_SUBACCT SET C_SUBACCT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_SUBACCT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_SUBACCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_SUBSCRIPTION
ALTER TABLE C_SUBSCRIPTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_SUBSCRIPTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_SUBSCRIPTION SET tmp_col_1_tmp=C_SUBSCRIPTION_UU,C_SUBSCRIPTION_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE C_SUBSCRIPTION MODIFY (C_SUBSCRIPTION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_SUBSCRIPTION SET C_SUBSCRIPTION_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE C_SUBSCRIPTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_SUBSCRIPTION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_SUBSCRIPTIONTYPE
ALTER TABLE C_SUBSCRIPTIONTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_SUBSCRIPTIONTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_SUBSCRIPTIONTYPE SET tmp_col_1_tmp=C_SUBSCRIPTIONTYPE_UU,C_SUBSCRIPTIONTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_SUBSCRIPTIONTYPE MODIFY (C_SUBSCRIPTIONTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_SUBSCRIPTIONTYPE SET C_SUBSCRIPTIONTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_SUBSCRIPTIONTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_SUBSCRIPTIONTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_SUBSCRIPTION_DELIVERY
ALTER TABLE C_SUBSCRIPTION_DELIVERY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_SUBSCRIPTION_DELIVERY SET tmp_col_1_tmp=C_SUBSCRIPTION_DELIVERY_UU,C_SUBSCRIPTION_DELIVERY_UU=NULL;
ALTER TABLE C_SUBSCRIPTION_DELIVERY MODIFY (C_SUBSCRIPTION_DELIVERY_UU VARCHAR2(36 CHAR));
UPDATE C_SUBSCRIPTION_DELIVERY SET C_SUBSCRIPTION_DELIVERY_UU=tmp_col_1_tmp;
ALTER TABLE C_SUBSCRIPTION_DELIVERY DROP (tmp_col_1_tmp);

-- Processing table C_TASK
ALTER TABLE C_TASK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_TASK MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TASK SET tmp_col_1_tmp=C_TASK_UU,C_TASK_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_TASK MODIFY (C_TASK_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_TASK SET C_TASK_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_TASK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TASK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_TAX
ALTER TABLE C_TAX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR));
ALTER TABLE C_TAX MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TAX SET tmp_col_1_tmp=C_TAX_UU,C_TAX_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=TAXINDICATOR,TAXINDICATOR=NULL;
ALTER TABLE C_TAX MODIFY (C_TAX_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),TAXINDICATOR VARCHAR2(10 CHAR));
UPDATE C_TAX SET C_TAX_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,TAXINDICATOR=tmp_col_4_tmp;
ALTER TABLE C_TAX MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TAX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_TAXBASE
ALTER TABLE C_TAXBASE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_TAXBASE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_TAXBASE SET tmp_col_1_tmp=C_TAXBASE_UU,C_TAXBASE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_TAXBASE MODIFY (C_TAXBASE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_TAXBASE SET C_TAXBASE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_TAXBASE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_TAXBASE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAXCATEGORY
ALTER TABLE C_TAXCATEGORY ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_TAXCATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TAXCATEGORY SET tmp_col_1_tmp=COMMODITYCODE,COMMODITYCODE=NULL,tmp_col_2_tmp=C_TAXCATEGORY_UU,C_TAXCATEGORY_UU=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE C_TAXCATEGORY MODIFY (COMMODITYCODE VARCHAR2(20 CHAR),C_TAXCATEGORY_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_TAXCATEGORY SET COMMODITYCODE=tmp_col_1_tmp,C_TAXCATEGORY_UU=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE C_TAXCATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TAXCATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_TAXCATEGORY_TRL
ALTER TABLE C_TAXCATEGORY_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_TAXCATEGORY_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TAXCATEGORY_TRL SET tmp_col_1_tmp=C_TAXCATEGORY_TRL_UU,C_TAXCATEGORY_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_TAXCATEGORY_TRL MODIFY (C_TAXCATEGORY_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_TAXCATEGORY_TRL SET C_TAXCATEGORY_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_TAXCATEGORY_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TAXCATEGORY_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_TAXDECLARATION
ALTER TABLE C_TAXDECLARATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_TAXDECLARATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TAXDECLARATION SET tmp_col_1_tmp=C_TAXDECLARATION_UU,C_TAXDECLARATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_TAXDECLARATION MODIFY (C_TAXDECLARATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_TAXDECLARATION SET C_TAXDECLARATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_TAXDECLARATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TAXDECLARATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_TAXDECLARATIONACCT
ALTER TABLE C_TAXDECLARATIONACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_TAXDECLARATIONACCT SET tmp_col_1_tmp=C_TAXDECLARATIONACCT_UU,C_TAXDECLARATIONACCT_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_TAXDECLARATIONACCT MODIFY (C_TAXDECLARATIONACCT_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_TAXDECLARATIONACCT SET C_TAXDECLARATIONACCT_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_TAXDECLARATIONACCT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_TAXDECLARATIONLINE
ALTER TABLE C_TAXDECLARATIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_TAXDECLARATIONLINE SET tmp_col_1_tmp=C_TAXDECLARATIONLINE_UU,C_TAXDECLARATIONLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_TAXDECLARATIONLINE MODIFY (C_TAXDECLARATIONLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_TAXDECLARATIONLINE SET C_TAXDECLARATIONLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_TAXDECLARATIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_TAXDEFINITION
ALTER TABLE C_TAXDEFINITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_TAXDEFINITION MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_TAXDEFINITION SET tmp_col_1_tmp=C_TAXDEFINITION_UU,C_TAXDEFINITION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_TAXDEFINITION MODIFY (C_TAXDEFINITION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_TAXDEFINITION SET C_TAXDEFINITION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_TAXDEFINITION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_TAXDEFINITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAXGROUP
ALTER TABLE C_TAXGROUP ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_TAXGROUP MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_TAXGROUP SET tmp_col_1_tmp=C_TAXGROUP_UU,C_TAXGROUP_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_TAXGROUP MODIFY (C_TAXGROUP_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_TAXGROUP SET C_TAXGROUP_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_TAXGROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_TAXGROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAXPOSTAL
ALTER TABLE C_TAXPOSTAL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_TAXPOSTAL SET tmp_col_1_tmp=C_TAXPOSTAL_UU,C_TAXPOSTAL_UU=NULL;
ALTER TABLE C_TAXPOSTAL MODIFY (C_TAXPOSTAL_UU VARCHAR2(36 CHAR));
UPDATE C_TAXPOSTAL SET C_TAXPOSTAL_UU=tmp_col_1_tmp;
ALTER TABLE C_TAXPOSTAL DROP (tmp_col_1_tmp);

-- Processing table C_TAXPROVIDER
ALTER TABLE C_TAXPROVIDER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR));
ALTER TABLE C_TAXPROVIDER MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE C_TAXPROVIDER SET tmp_col_1_tmp=ACCOUNT,ACCOUNT=NULL,tmp_col_2_tmp=COMPANYCODE,COMPANYCODE=NULL,tmp_col_3_tmp=C_TAXPROVIDER_UU,C_TAXPROVIDER_UU=NULL,tmp_col_4_tmp=LICENSE,LICENSE=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE C_TAXPROVIDER MODIFY (ACCOUNT VARCHAR2(60 CHAR),COMPANYCODE VARCHAR2(60 CHAR),C_TAXPROVIDER_UU VARCHAR2(36 CHAR),LICENSE VARCHAR2(60 CHAR),NAME VARCHAR2(120 CHAR));
UPDATE C_TAXPROVIDER SET ACCOUNT=tmp_col_1_tmp,COMPANYCODE=tmp_col_2_tmp,C_TAXPROVIDER_UU=tmp_col_3_tmp,LICENSE=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE C_TAXPROVIDER MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE C_TAXPROVIDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAXPROVIDERCFG
ALTER TABLE C_TAXPROVIDERCFG ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR));
ALTER TABLE C_TAXPROVIDERCFG MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE C_TAXPROVIDERCFG SET tmp_col_1_tmp=C_TAXPROVIDERCFG_UU,C_TAXPROVIDERCFG_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=TAXPROVIDERCLASS,TAXPROVIDERCLASS=NULL,tmp_col_5_tmp=URL,URL=NULL;
ALTER TABLE C_TAXPROVIDERCFG MODIFY (C_TAXPROVIDERCFG_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR),TAXPROVIDERCLASS VARCHAR2(60 CHAR),URL VARCHAR2(120 CHAR));
UPDATE C_TAXPROVIDERCFG SET C_TAXPROVIDERCFG_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,TAXPROVIDERCLASS=tmp_col_4_tmp,URL=tmp_col_5_tmp;
ALTER TABLE C_TAXPROVIDERCFG MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE C_TAXPROVIDERCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAXTYPE
ALTER TABLE C_TAXTYPE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE C_TAXTYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE C_TAXTYPE SET tmp_col_1_tmp=C_TAXTYPE_UU,C_TAXTYPE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE C_TAXTYPE MODIFY (C_TAXTYPE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE C_TAXTYPE SET C_TAXTYPE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE C_TAXTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE C_TAXTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table C_TAX_ACCT
ALTER TABLE C_TAX_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_TAX_ACCT SET tmp_col_1_tmp=C_TAX_ACCT_UU,C_TAX_ACCT_UU=NULL;
ALTER TABLE C_TAX_ACCT MODIFY (C_TAX_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_TAX_ACCT SET C_TAX_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_TAX_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_TAX_TRL
ALTER TABLE C_TAX_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR));
ALTER TABLE C_TAX_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_TAX_TRL SET tmp_col_1_tmp=C_TAX_TRL_UU,C_TAX_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=TAXINDICATOR,TAXINDICATOR=NULL;
ALTER TABLE C_TAX_TRL MODIFY (C_TAX_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),TAXINDICATOR VARCHAR2(10 CHAR));
UPDATE C_TAX_TRL SET C_TAX_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,TAXINDICATOR=tmp_col_4_tmp;
ALTER TABLE C_TAX_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_TAX_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_UOM
ALTER TABLE C_UOM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(2 CHAR),tmp_col_6_tmp VARCHAR2(4 CHAR));
ALTER TABLE C_UOM MODIFY (NAME NVARCHAR2(60) NULL,X12DE355 NVARCHAR2(4) NULL);
UPDATE C_UOM SET tmp_col_1_tmp=C_UOM_UU,C_UOM_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=UOMSYMBOL,UOMSYMBOL=NULL,tmp_col_5_tmp=UOMTYPE,UOMTYPE=NULL,tmp_col_6_tmp=X12DE355,X12DE355=NULL;
ALTER TABLE C_UOM MODIFY (C_UOM_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),UOMSYMBOL VARCHAR2(10 CHAR),UOMTYPE VARCHAR2(2 CHAR),X12DE355 VARCHAR2(4 CHAR));
UPDATE C_UOM SET C_UOM_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,UOMSYMBOL=tmp_col_4_tmp,UOMTYPE=tmp_col_5_tmp,X12DE355=tmp_col_6_tmp;
ALTER TABLE C_UOM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,X12DE355 VARCHAR2(4 CHAR) NOT NULL);
ALTER TABLE C_UOM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table C_UOM_CONVERSION
ALTER TABLE C_UOM_CONVERSION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_UOM_CONVERSION SET tmp_col_1_tmp=C_UOM_CONVERSION_UU,C_UOM_CONVERSION_UU=NULL;
ALTER TABLE C_UOM_CONVERSION MODIFY (C_UOM_CONVERSION_UU VARCHAR2(36 CHAR));
UPDATE C_UOM_CONVERSION SET C_UOM_CONVERSION_UU=tmp_col_1_tmp;
ALTER TABLE C_UOM_CONVERSION DROP (tmp_col_1_tmp);

-- Processing table C_UOM_TRL
ALTER TABLE C_UOM_TRL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR));
ALTER TABLE C_UOM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_UOM_TRL SET tmp_col_1_tmp=C_UOM_TRL_UU,C_UOM_TRL_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=UOMSYMBOL,UOMSYMBOL=NULL;
ALTER TABLE C_UOM_TRL MODIFY (C_UOM_TRL_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),UOMSYMBOL VARCHAR2(10 CHAR));
UPDATE C_UOM_TRL SET C_UOM_TRL_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,UOMSYMBOL=tmp_col_4_tmp;
ALTER TABLE C_UOM_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_UOM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_USERREMUNERATION
ALTER TABLE C_USERREMUNERATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_USERREMUNERATION SET tmp_col_1_tmp=C_USERREMUNERATION_UU,C_USERREMUNERATION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_USERREMUNERATION MODIFY (C_USERREMUNERATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_USERREMUNERATION SET C_USERREMUNERATION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_USERREMUNERATION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table C_VALIDCOMBINATION
ALTER TABLE C_VALIDCOMBINATION ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE C_VALIDCOMBINATION SET tmp_col_1_tmp=ALIAS,ALIAS=NULL,tmp_col_2_tmp=COMBINATION,COMBINATION=NULL,tmp_col_3_tmp=C_VALIDCOMBINATION_UU,C_VALIDCOMBINATION_UU=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_VALIDCOMBINATION MODIFY (ALIAS VARCHAR2(40 CHAR),COMBINATION VARCHAR2(60 CHAR),C_VALIDCOMBINATION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_VALIDCOMBINATION SET ALIAS=tmp_col_1_tmp,COMBINATION=tmp_col_2_tmp,C_VALIDCOMBINATION_UU=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp;
ALTER TABLE C_VALIDCOMBINATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table C_WITHHOLDING
ALTER TABLE C_WITHHOLDING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE C_WITHHOLDING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE C_WITHHOLDING SET tmp_col_1_tmp=C_WITHHOLDING_UU,C_WITHHOLDING_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE C_WITHHOLDING MODIFY (C_WITHHOLDING_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE C_WITHHOLDING SET C_WITHHOLDING_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE C_WITHHOLDING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE C_WITHHOLDING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table C_WITHHOLDING_ACCT
ALTER TABLE C_WITHHOLDING_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE C_WITHHOLDING_ACCT SET tmp_col_1_tmp=C_WITHHOLDING_ACCT_UU,C_WITHHOLDING_ACCT_UU=NULL;
ALTER TABLE C_WITHHOLDING_ACCT MODIFY (C_WITHHOLDING_ACCT_UU VARCHAR2(36 CHAR));
UPDATE C_WITHHOLDING_ACCT SET C_WITHHOLDING_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE C_WITHHOLDING_ACCT DROP (tmp_col_1_tmp);

-- Processing table C_YEAR
ALTER TABLE C_YEAR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE C_YEAR SET tmp_col_1_tmp=C_YEAR_UU,C_YEAR_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE C_YEAR MODIFY (C_YEAR_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE C_YEAR SET C_YEAR_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE C_YEAR DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table DD_NETWORKDISTRIBUTION
ALTER TABLE DD_NETWORKDISTRIBUTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(22 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(80 CHAR));
ALTER TABLE DD_NETWORKDISTRIBUTION MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(80) NULL);
UPDATE DD_NETWORKDISTRIBUTION SET tmp_col_1_tmp=DD_NETWORKDISTRIBUTION_UU,DD_NETWORKDISTRIBUTION_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=REVISION,REVISION=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE DD_NETWORKDISTRIBUTION MODIFY (DD_NETWORKDISTRIBUTION_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(22 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),REVISION VARCHAR2(10 CHAR),VALUE VARCHAR2(80 CHAR));
UPDATE DD_NETWORKDISTRIBUTION SET DD_NETWORKDISTRIBUTION_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,REVISION=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE DD_NETWORKDISTRIBUTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(80 CHAR) NOT NULL);
ALTER TABLE DD_NETWORKDISTRIBUTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table DD_NETWORKDISTRIBUTIONLINE
ALTER TABLE DD_NETWORKDISTRIBUTIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE DD_NETWORKDISTRIBUTIONLINE SET tmp_col_1_tmp=DD_NETWORKDISTRIBUTIONLINE_UU,DD_NETWORKDISTRIBUTIONLINE_UU=NULL;
ALTER TABLE DD_NETWORKDISTRIBUTIONLINE MODIFY (DD_NETWORKDISTRIBUTIONLINE_UU VARCHAR2(36 CHAR));
UPDATE DD_NETWORKDISTRIBUTIONLINE SET DD_NETWORKDISTRIBUTIONLINE_UU=tmp_col_1_tmp;
ALTER TABLE DD_NETWORKDISTRIBUTIONLINE DROP (tmp_col_1_tmp);

-- Processing table DD_ORDER
ALTER TABLE DD_ORDER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE DD_ORDER MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE DD_ORDER SET tmp_col_1_tmp=DD_ORDER_UU,DD_ORDER_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_5_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE DD_ORDER MODIFY (DD_ORDER_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),POREFERENCE VARCHAR2(20 CHAR),TRACKINGNO VARCHAR2(60 CHAR));
UPDATE DD_ORDER SET DD_ORDER_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,POREFERENCE=tmp_col_4_tmp,TRACKINGNO=tmp_col_5_tmp;
ALTER TABLE DD_ORDER MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE DD_ORDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table DD_ORDERLINE
ALTER TABLE DD_ORDERLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE DD_ORDERLINE SET tmp_col_1_tmp=DD_ORDERLINE_UU,DD_ORDERLINE_UU=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE DD_ORDERLINE MODIFY (DD_ORDERLINE_UU VARCHAR2(36 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE DD_ORDERLINE SET DD_ORDERLINE_UU=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE DD_ORDERLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table EXP_FORMAT
ALTER TABLE EXP_FORMAT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR));
ALTER TABLE EXP_FORMAT MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL,VERSION NVARCHAR2(40) NULL);
UPDATE EXP_FORMAT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=EXP_FORMAT_UU,EXP_FORMAT_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL,tmp_col_6_tmp=VERSION,VERSION=NULL,tmp_col_7_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE EXP_FORMAT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),EXP_FORMAT_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),VERSION VARCHAR2(40 CHAR),WHERECLAUSE VARCHAR2(255 CHAR));
UPDATE EXP_FORMAT SET DESCRIPTION=tmp_col_1_tmp,EXP_FORMAT_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp,VERSION=tmp_col_6_tmp,WHERECLAUSE=tmp_col_7_tmp;
ALTER TABLE EXP_FORMAT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL,VERSION VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE EXP_FORMAT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table EXP_FORMATLINE
ALTER TABLE EXP_FORMATLINE ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE EXP_FORMATLINE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE EXP_FORMATLINE SET tmp_col_1_tmp=DATEFORMAT,DATEFORMAT=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=EXP_FORMATLINE_UU,EXP_FORMATLINE_UU=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE EXP_FORMATLINE MODIFY (DATEFORMAT VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EXP_FORMATLINE_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE EXP_FORMATLINE SET DATEFORMAT=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,EXP_FORMATLINE_UU=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE EXP_FORMATLINE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE EXP_FORMATLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table EXP_PROCESSOR
ALTER TABLE EXP_PROCESSOR ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR));
ALTER TABLE EXP_PROCESSOR MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE EXP_PROCESSOR SET tmp_col_1_tmp=ACCOUNT,ACCOUNT=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=EXP_PROCESSOR_UU,EXP_PROCESSOR_UU=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=HOST,HOST=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PASSWORDINFO,PASSWORDINFO=NULL,tmp_col_8_tmp=VALUE,VALUE=NULL;
ALTER TABLE EXP_PROCESSOR MODIFY (ACCOUNT VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EXP_PROCESSOR_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),HOST VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PASSWORDINFO VARCHAR2(255 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE EXP_PROCESSOR SET ACCOUNT=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,EXP_PROCESSOR_UU=tmp_col_3_tmp,HELP=tmp_col_4_tmp,HOST=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PASSWORDINFO=tmp_col_7_tmp,VALUE=tmp_col_8_tmp;
ALTER TABLE EXP_PROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE EXP_PROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table EXP_PROCESSORPARAMETER
ALTER TABLE EXP_PROCESSORPARAMETER ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE EXP_PROCESSORPARAMETER MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE EXP_PROCESSORPARAMETER SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=EXP_PROCESSORPARAMETER_UU,EXP_PROCESSORPARAMETER_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PARAMETERVALUE,PARAMETERVALUE=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE EXP_PROCESSORPARAMETER MODIFY (DESCRIPTION VARCHAR2(255 CHAR),EXP_PROCESSORPARAMETER_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PARAMETERVALUE VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE EXP_PROCESSORPARAMETER SET DESCRIPTION=tmp_col_1_tmp,EXP_PROCESSORPARAMETER_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PARAMETERVALUE=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE EXP_PROCESSORPARAMETER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE EXP_PROCESSORPARAMETER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table EXP_PROCESSOR_TYPE
ALTER TABLE EXP_PROCESSOR_TYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE EXP_PROCESSOR_TYPE MODIFY (JAVACLASS NVARCHAR2(255) NULL,NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE EXP_PROCESSOR_TYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=EXP_PROCESSOR_TYPE_UU,EXP_PROCESSOR_TYPE_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=JAVACLASS,JAVACLASS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE EXP_PROCESSOR_TYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),EXP_PROCESSOR_TYPE_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),JAVACLASS VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE EXP_PROCESSOR_TYPE SET DESCRIPTION=tmp_col_1_tmp,EXP_PROCESSOR_TYPE_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,JAVACLASS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE EXP_PROCESSOR_TYPE MODIFY (JAVACLASS VARCHAR2(255 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE EXP_PROCESSOR_TYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table FACT_ACCT
ALTER TABLE FACT_ACCT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE FACT_ACCT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=FACT_ACCT_UU,FACT_ACCT_UU=NULL;
ALTER TABLE FACT_ACCT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),FACT_ACCT_UU VARCHAR2(36 CHAR));
UPDATE FACT_ACCT SET DESCRIPTION=tmp_col_1_tmp,FACT_ACCT_UU=tmp_col_2_tmp;
ALTER TABLE FACT_ACCT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table FACT_ACCT_SUMMARY
ALTER TABLE FACT_ACCT_SUMMARY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE FACT_ACCT_SUMMARY SET tmp_col_1_tmp=FACT_ACCT_SUMMARY_UU,FACT_ACCT_SUMMARY_UU=NULL;
ALTER TABLE FACT_ACCT_SUMMARY MODIFY (FACT_ACCT_SUMMARY_UU VARCHAR2(36 CHAR));
UPDATE FACT_ACCT_SUMMARY SET FACT_ACCT_SUMMARY_UU=tmp_col_1_tmp;
ALTER TABLE FACT_ACCT_SUMMARY DROP (tmp_col_1_tmp);

-- Processing table FACT_RECONCILIATION
ALTER TABLE FACT_RECONCILIATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE FACT_RECONCILIATION SET tmp_col_1_tmp=FACT_RECONCILIATION_UU,FACT_RECONCILIATION_UU=NULL,tmp_col_2_tmp=MATCHCODE,MATCHCODE=NULL;
ALTER TABLE FACT_RECONCILIATION MODIFY (FACT_RECONCILIATION_UU VARCHAR2(36 CHAR),MATCHCODE VARCHAR2(60 CHAR));
UPDATE FACT_RECONCILIATION SET FACT_RECONCILIATION_UU=tmp_col_1_tmp,MATCHCODE=tmp_col_2_tmp;
ALTER TABLE FACT_RECONCILIATION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table GL_BUDGET
ALTER TABLE GL_BUDGET ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_BUDGET MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_BUDGET SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_BUDGET_UU,GL_BUDGET_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE GL_BUDGET MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_BUDGET_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_BUDGET SET DESCRIPTION=tmp_col_1_tmp,GL_BUDGET_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE GL_BUDGET MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_BUDGET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table GL_BUDGETCONTROL
ALTER TABLE GL_BUDGETCONTROL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_BUDGETCONTROL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_BUDGETCONTROL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_BUDGETCONTROL_UU,GL_BUDGETCONTROL_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE GL_BUDGETCONTROL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_BUDGETCONTROL_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_BUDGETCONTROL SET DESCRIPTION=tmp_col_1_tmp,GL_BUDGETCONTROL_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE GL_BUDGETCONTROL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_BUDGETCONTROL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table GL_CATEGORY
ALTER TABLE GL_CATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_CATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_CATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_CATEGORY_UU,GL_CATEGORY_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE GL_CATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_CATEGORY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_CATEGORY SET DESCRIPTION=tmp_col_1_tmp,GL_CATEGORY_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE GL_CATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_CATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table GL_CATEGORY_TRL
ALTER TABLE GL_CATEGORY_TRL ADD (tmp_col_1_tmp VARCHAR2(60 CHAR));
UPDATE GL_CATEGORY_TRL SET tmp_col_1_tmp=NAME,NAME=NULL;
ALTER TABLE GL_CATEGORY_TRL MODIFY (NAME VARCHAR2(60 CHAR));
UPDATE GL_CATEGORY_TRL SET NAME=tmp_col_1_tmp;
ALTER TABLE GL_CATEGORY_TRL DROP (tmp_col_1_tmp);

-- Processing table GL_DISTRIBUTION
ALTER TABLE GL_DISTRIBUTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_DISTRIBUTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_DISTRIBUTION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_DISTRIBUTION_UU,GL_DISTRIBUTION_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE GL_DISTRIBUTION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_DISTRIBUTION_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_DISTRIBUTION SET DESCRIPTION=tmp_col_1_tmp,GL_DISTRIBUTION_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE GL_DISTRIBUTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_DISTRIBUTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table GL_DISTRIBUTIONLINE
ALTER TABLE GL_DISTRIBUTIONLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE GL_DISTRIBUTIONLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_DISTRIBUTIONLINE_UU,GL_DISTRIBUTIONLINE_UU=NULL;
ALTER TABLE GL_DISTRIBUTIONLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_DISTRIBUTIONLINE_UU VARCHAR2(36 CHAR));
UPDATE GL_DISTRIBUTIONLINE SET DESCRIPTION=tmp_col_1_tmp,GL_DISTRIBUTIONLINE_UU=tmp_col_2_tmp;
ALTER TABLE GL_DISTRIBUTIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table GL_FUND
ALTER TABLE GL_FUND ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_FUND MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_FUND SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_FUND_UU,GL_FUND_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE GL_FUND MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_FUND_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_FUND SET DESCRIPTION=tmp_col_1_tmp,GL_FUND_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE GL_FUND MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_FUND DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table GL_FUNDRESTRICTION
ALTER TABLE GL_FUNDRESTRICTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_FUNDRESTRICTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_FUNDRESTRICTION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_FUNDRESTRICTION_UU,GL_FUNDRESTRICTION_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE GL_FUNDRESTRICTION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_FUNDRESTRICTION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_FUNDRESTRICTION SET DESCRIPTION=tmp_col_1_tmp,GL_FUNDRESTRICTION_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE GL_FUNDRESTRICTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_FUNDRESTRICTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table GL_JOURNAL
ALTER TABLE GL_JOURNAL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE GL_JOURNAL MODIFY (DESCRIPTION NVARCHAR2(255) NULL,DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE GL_JOURNAL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=GL_JOURNAL_UU,GL_JOURNAL_UU=NULL;
ALTER TABLE GL_JOURNAL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),GL_JOURNAL_UU VARCHAR2(36 CHAR));
UPDATE GL_JOURNAL SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,GL_JOURNAL_UU=tmp_col_3_tmp;
ALTER TABLE GL_JOURNAL MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL,DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE GL_JOURNAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table GL_JOURNALBATCH
ALTER TABLE GL_JOURNALBATCH ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE GL_JOURNALBATCH MODIFY (DESCRIPTION NVARCHAR2(255) NULL,DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE GL_JOURNALBATCH SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=GL_JOURNALBATCH_UU,GL_JOURNALBATCH_UU=NULL;
ALTER TABLE GL_JOURNALBATCH MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),GL_JOURNALBATCH_UU VARCHAR2(36 CHAR));
UPDATE GL_JOURNALBATCH SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,GL_JOURNALBATCH_UU=tmp_col_3_tmp;
ALTER TABLE GL_JOURNALBATCH MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL,DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE GL_JOURNALBATCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table GL_JOURNALGENERATOR
ALTER TABLE GL_JOURNALGENERATOR ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE GL_JOURNALGENERATOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE GL_JOURNALGENERATOR SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_JOURNALGENERATOR_UU,GL_JOURNALGENERATOR_UU=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE GL_JOURNALGENERATOR MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_JOURNALGENERATOR_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE GL_JOURNALGENERATOR SET DESCRIPTION=tmp_col_1_tmp,GL_JOURNALGENERATOR_UU=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE GL_JOURNALGENERATOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE GL_JOURNALGENERATOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table GL_JOURNALGENERATORLINE
ALTER TABLE GL_JOURNALGENERATORLINE ADD (tmp_col_1_tmp VARCHAR2(100 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
UPDATE GL_JOURNALGENERATORLINE SET tmp_col_1_tmp=BPCOLUMN,BPCOLUMN=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=GL_JOURNALGENERATORLINE_UU,GL_JOURNALGENERATORLINE_UU=NULL,tmp_col_4_tmp=HELP,HELP=NULL;
ALTER TABLE GL_JOURNALGENERATORLINE MODIFY (BPCOLUMN VARCHAR2(100 CHAR),DESCRIPTION VARCHAR2(255 CHAR),GL_JOURNALGENERATORLINE_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE GL_JOURNALGENERATORLINE SET BPCOLUMN=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,GL_JOURNALGENERATORLINE_UU=tmp_col_3_tmp,HELP=tmp_col_4_tmp;
ALTER TABLE GL_JOURNALGENERATORLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table GL_JOURNALGENERATORSOURCE
ALTER TABLE GL_JOURNALGENERATORSOURCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
UPDATE GL_JOURNALGENERATORSOURCE SET tmp_col_1_tmp=GL_JOURNALGENERATORSOURCE_UU,GL_JOURNALGENERATORSOURCE_UU=NULL,tmp_col_2_tmp=HELP,HELP=NULL;
ALTER TABLE GL_JOURNALGENERATORSOURCE MODIFY (GL_JOURNALGENERATORSOURCE_UU VARCHAR2(36 CHAR),HELP VARCHAR2(2000 CHAR));
UPDATE GL_JOURNALGENERATORSOURCE SET GL_JOURNALGENERATORSOURCE_UU=tmp_col_1_tmp,HELP=tmp_col_2_tmp;
ALTER TABLE GL_JOURNALGENERATORSOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table GL_JOURNALLINE
ALTER TABLE GL_JOURNALLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE GL_JOURNALLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=GL_JOURNALLINE_UU,GL_JOURNALLINE_UU=NULL;
ALTER TABLE GL_JOURNALLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),GL_JOURNALLINE_UU VARCHAR2(36 CHAR));
UPDATE GL_JOURNALLINE SET DESCRIPTION=tmp_col_1_tmp,GL_JOURNALLINE_UU=tmp_col_2_tmp;
ALTER TABLE GL_JOURNALLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table HR_ATTRIBUTE
ALTER TABLE HR_ATTRIBUTE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
UPDATE HR_ATTRIBUTE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_ATTRIBUTE_UU,HR_ATTRIBUTE_UU=NULL,tmp_col_3_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE HR_ATTRIBUTE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_ATTRIBUTE_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(255 CHAR));
UPDATE HR_ATTRIBUTE SET DESCRIPTION=tmp_col_1_tmp,HR_ATTRIBUTE_UU=tmp_col_2_tmp,TEXTMSG=tmp_col_3_tmp;
ALTER TABLE HR_ATTRIBUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table HR_CONCEPT
ALTER TABLE HR_CONCEPT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_CONCEPT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_CONCEPT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_CONCEPT_UU,HR_CONCEPT_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_CONCEPT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_CONCEPT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_CONCEPT SET DESCRIPTION=tmp_col_1_tmp,HR_CONCEPT_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_CONCEPT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_CONCEPT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_CONCEPT_ACCT
ALTER TABLE HR_CONCEPT_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE HR_CONCEPT_ACCT SET tmp_col_1_tmp=HR_CONCEPT_ACCT_UU,HR_CONCEPT_ACCT_UU=NULL;
ALTER TABLE HR_CONCEPT_ACCT MODIFY (HR_CONCEPT_ACCT_UU VARCHAR2(36 CHAR));
UPDATE HR_CONCEPT_ACCT SET HR_CONCEPT_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE HR_CONCEPT_ACCT DROP (tmp_col_1_tmp);

-- Processing table HR_CONCEPT_CATEGORY
ALTER TABLE HR_CONCEPT_CATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_CONCEPT_CATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_CONCEPT_CATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_CONCEPT_CATEGORY_UU,HR_CONCEPT_CATEGORY_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_CONCEPT_CATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_CONCEPT_CATEGORY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_CONCEPT_CATEGORY SET DESCRIPTION=tmp_col_1_tmp,HR_CONCEPT_CATEGORY_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_CONCEPT_CATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_CONCEPT_CATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_CONTRACT
ALTER TABLE HR_CONTRACT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_CONTRACT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_CONTRACT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_CONTRACT_UU,HR_CONTRACT_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_CONTRACT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_CONTRACT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_CONTRACT SET DESCRIPTION=tmp_col_1_tmp,HR_CONTRACT_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_CONTRACT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_CONTRACT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_DEPARTMENT
ALTER TABLE HR_DEPARTMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_DEPARTMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_DEPARTMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_DEPARTMENT_UU,HR_DEPARTMENT_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_DEPARTMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_DEPARTMENT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_DEPARTMENT SET DESCRIPTION=tmp_col_1_tmp,HR_DEPARTMENT_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_DEPARTMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_DEPARTMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_EMPLOYEE
ALTER TABLE HR_EMPLOYEE ADD (tmp_col_1_tmp VARCHAR2(1 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(30 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR));
UPDATE HR_EMPLOYEE SET tmp_col_1_tmp=CODE,CODE=NULL,tmp_col_2_tmp=HR_EMPLOYEE_UU,HR_EMPLOYEE_UU=NULL,tmp_col_3_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=NAME2,NAME2=NULL,tmp_col_6_tmp=NATIONALCODE,NATIONALCODE=NULL,tmp_col_7_tmp=SSCODE,SSCODE=NULL;
ALTER TABLE HR_EMPLOYEE MODIFY (CODE VARCHAR2(1 CHAR),HR_EMPLOYEE_UU VARCHAR2(36 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(30 CHAR),NAME2 VARCHAR2(30 CHAR),NATIONALCODE VARCHAR2(60 CHAR),SSCODE VARCHAR2(60 CHAR));
UPDATE HR_EMPLOYEE SET CODE=tmp_col_1_tmp,HR_EMPLOYEE_UU=tmp_col_2_tmp,IMAGEURL=tmp_col_3_tmp,NAME=tmp_col_4_tmp,NAME2=tmp_col_5_tmp,NATIONALCODE=tmp_col_6_tmp,SSCODE=tmp_col_7_tmp;
ALTER TABLE HR_EMPLOYEE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table HR_JOB
ALTER TABLE HR_JOB ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_JOB MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_JOB SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_JOB_UU,HR_JOB_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_JOB MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_JOB_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_JOB SET DESCRIPTION=tmp_col_1_tmp,HR_JOB_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_JOB MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_JOB DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_LIST
ALTER TABLE HR_LIST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_LIST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_LIST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_LIST_UU,HR_LIST_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_LIST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_LIST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_LIST SET DESCRIPTION=tmp_col_1_tmp,HR_LIST_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_LIST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_LIST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_LISTLINE
ALTER TABLE HR_LISTLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE HR_LISTLINE SET tmp_col_1_tmp=HR_LISTLINE_UU,HR_LISTLINE_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE HR_LISTLINE MODIFY (HR_LISTLINE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE HR_LISTLINE SET HR_LISTLINE_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE HR_LISTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table HR_LISTTYPE
ALTER TABLE HR_LISTTYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_LISTTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_LISTTYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_LISTTYPE_UU,HR_LISTTYPE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_LISTTYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_LISTTYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_LISTTYPE SET DESCRIPTION=tmp_col_1_tmp,HR_LISTTYPE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_LISTTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_LISTTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_LISTVERSION
ALTER TABLE HR_LISTVERSION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE HR_LISTVERSION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_LISTVERSION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_LISTVERSION_UU,HR_LISTVERSION_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE HR_LISTVERSION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_LISTVERSION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE HR_LISTVERSION SET DESCRIPTION=tmp_col_1_tmp,HR_LISTVERSION_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE HR_LISTVERSION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_LISTVERSION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table HR_MOVEMENT
ALTER TABLE HR_MOVEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
UPDATE HR_MOVEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_MOVEMENT_UU,HR_MOVEMENT_UU=NULL,tmp_col_3_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE HR_MOVEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_MOVEMENT_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(255 CHAR));
UPDATE HR_MOVEMENT SET DESCRIPTION=tmp_col_1_tmp,HR_MOVEMENT_UU=tmp_col_2_tmp,TEXTMSG=tmp_col_3_tmp;
ALTER TABLE HR_MOVEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table HR_PAYROLL
ALTER TABLE HR_PAYROLL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE HR_PAYROLL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE HR_PAYROLL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_PAYROLL_UU,HR_PAYROLL_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE HR_PAYROLL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_PAYROLL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE HR_PAYROLL SET DESCRIPTION=tmp_col_1_tmp,HR_PAYROLL_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE HR_PAYROLL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_PAYROLL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table HR_PAYROLLCONCEPT
ALTER TABLE HR_PAYROLLCONCEPT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE HR_PAYROLLCONCEPT SET tmp_col_1_tmp=HR_PAYROLLCONCEPT_UU,HR_PAYROLLCONCEPT_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE HR_PAYROLLCONCEPT MODIFY (HR_PAYROLLCONCEPT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE HR_PAYROLLCONCEPT SET HR_PAYROLLCONCEPT_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE HR_PAYROLLCONCEPT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table HR_PERIOD
ALTER TABLE HR_PERIOD ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(1 CHAR),tmp_col_5_tmp VARCHAR2(1 CHAR),tmp_col_6_tmp VARCHAR2(1 CHAR));
ALTER TABLE HR_PERIOD MODIFY (NAME NVARCHAR2(40) NULL);
UPDATE HR_PERIOD SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HR_PERIOD_UU,HR_PERIOD_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PERIODACTION,PERIODACTION=NULL,tmp_col_5_tmp=PERIODSTATUS,PERIODSTATUS=NULL,tmp_col_6_tmp=PROCESSING,PROCESSING=NULL;
ALTER TABLE HR_PERIOD MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HR_PERIOD_UU VARCHAR2(36 CHAR),NAME VARCHAR2(40 CHAR),PERIODACTION VARCHAR2(1 CHAR),PERIODSTATUS VARCHAR2(1 CHAR),PROCESSING VARCHAR2(1 CHAR));
UPDATE HR_PERIOD SET DESCRIPTION=tmp_col_1_tmp,HR_PERIOD_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PERIODACTION=tmp_col_4_tmp,PERIODSTATUS=tmp_col_5_tmp,PROCESSING=tmp_col_6_tmp;
ALTER TABLE HR_PERIOD MODIFY (NAME VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE HR_PERIOD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table HR_PROCESS
ALTER TABLE HR_PROCESS ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(90 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE HR_PROCESS MODIFY (DOCSTATUS NVARCHAR2(2) NULL,NAME NVARCHAR2(60) NULL);
UPDATE HR_PROCESS SET tmp_col_1_tmp=COLUMNSQL,COLUMNSQL=NULL,tmp_col_2_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=HR_PROCESS_UU,HR_PROCESS_UU=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE HR_PROCESS MODIFY (COLUMNSQL VARCHAR2(255 CHAR),DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR' ,DOCUMENTNO VARCHAR2(90 CHAR),HR_PROCESS_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE HR_PROCESS SET COLUMNSQL=tmp_col_1_tmp,DOCSTATUS=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,HR_PROCESS_UU=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE HR_PROCESS MODIFY (DOCSTATUS VARCHAR2(2 CHAR) DEFAULT 'DR'  NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE HR_PROCESS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table HR_YEAR
ALTER TABLE HR_YEAR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE HR_YEAR SET tmp_col_1_tmp=HR_YEAR_UU,HR_YEAR_UU=NULL;
ALTER TABLE HR_YEAR MODIFY (HR_YEAR_UU VARCHAR2(36 CHAR));
UPDATE HR_YEAR SET HR_YEAR_UU=tmp_col_1_tmp;
ALTER TABLE HR_YEAR DROP (tmp_col_1_tmp);

-- Processing table IMP_PROCESSOR
ALTER TABLE IMP_PROCESSOR ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR));
ALTER TABLE IMP_PROCESSOR MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE IMP_PROCESSOR SET tmp_col_1_tmp=ACCOUNT,ACCOUNT=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=HOST,HOST=NULL,tmp_col_5_tmp=IMP_PROCESSOR_UU,IMP_PROCESSOR_UU=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PASSWORDINFO,PASSWORDINFO=NULL,tmp_col_8_tmp=VALUE,VALUE=NULL;
ALTER TABLE IMP_PROCESSOR MODIFY (ACCOUNT VARCHAR2(255 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),HOST VARCHAR2(255 CHAR),IMP_PROCESSOR_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PASSWORDINFO VARCHAR2(255 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE IMP_PROCESSOR SET ACCOUNT=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,HOST=tmp_col_4_tmp,IMP_PROCESSOR_UU=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PASSWORDINFO=tmp_col_7_tmp,VALUE=tmp_col_8_tmp;
ALTER TABLE IMP_PROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE IMP_PROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table IMP_PROCESSORLOG
ALTER TABLE IMP_PROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR));
UPDATE IMP_PROCESSORLOG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=IMP_PROCESSORLOG_UU,IMP_PROCESSORLOG_UU=NULL,tmp_col_4_tmp=REFERENCE,REFERENCE=NULL,tmp_col_5_tmp=SUMMARY,SUMMARY=NULL,tmp_col_6_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE IMP_PROCESSORLOG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),IMP_PROCESSORLOG_UU VARCHAR2(36 CHAR),REFERENCE VARCHAR2(60 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE IMP_PROCESSORLOG SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,IMP_PROCESSORLOG_UU=tmp_col_3_tmp,REFERENCE=tmp_col_4_tmp,SUMMARY=tmp_col_5_tmp,TEXTMSG=tmp_col_6_tmp;
ALTER TABLE IMP_PROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table IMP_PROCESSORPARAMETER
ALTER TABLE IMP_PROCESSORPARAMETER ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE IMP_PROCESSORPARAMETER MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE IMP_PROCESSORPARAMETER SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=IMP_PROCESSORPARAMETER_UU,IMP_PROCESSORPARAMETER_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PARAMETERVALUE,PARAMETERVALUE=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE IMP_PROCESSORPARAMETER MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),IMP_PROCESSORPARAMETER_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PARAMETERVALUE VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE IMP_PROCESSORPARAMETER SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,IMP_PROCESSORPARAMETER_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PARAMETERVALUE=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE IMP_PROCESSORPARAMETER MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE IMP_PROCESSORPARAMETER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table IMP_PROCESSOR_TYPE
ALTER TABLE IMP_PROCESSOR_TYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
ALTER TABLE IMP_PROCESSOR_TYPE MODIFY (JAVACLASS NVARCHAR2(255) NULL,NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE IMP_PROCESSOR_TYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=IMP_PROCESSOR_TYPE_UU,IMP_PROCESSOR_TYPE_UU=NULL,tmp_col_4_tmp=JAVACLASS,JAVACLASS=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE IMP_PROCESSOR_TYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),IMP_PROCESSOR_TYPE_UU VARCHAR2(36 CHAR),JAVACLASS VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE IMP_PROCESSOR_TYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,IMP_PROCESSOR_TYPE_UU=tmp_col_3_tmp,JAVACLASS=tmp_col_4_tmp,NAME=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE IMP_PROCESSOR_TYPE MODIFY (JAVACLASS VARCHAR2(255 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE IMP_PROCESSOR_TYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table I_ASSET
ALTER TABLE I_ASSET ADD (tmp_col_1_tmp VARCHAR2(2 CHAR),tmp_col_2_tmp VARCHAR2(3 CHAR),tmp_col_3_tmp VARCHAR2(510 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(10 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(20 CHAR));
UPDATE I_ASSET SET tmp_col_1_tmp=A_DEPRECIATION_MANUAL_PERIOD,A_DEPRECIATION_MANUAL_PERIOD=NULL,tmp_col_2_tmp=A_REVAL_CAL_METHOD,A_REVAL_CAL_METHOD=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=I_ASSET_UU,I_ASSET_UU=NULL,tmp_col_6_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_7_tmp=LOCATIONCOMMENT,LOCATIONCOMMENT=NULL,tmp_col_8_tmp=LOT,LOT=NULL,tmp_col_9_tmp=NAME,NAME=NULL,tmp_col_10_tmp=POSTINGTYPE,POSTINGTYPE=NULL,tmp_col_11_tmp=SERNO,SERNO=NULL,tmp_col_12_tmp=VALUE,VALUE=NULL,tmp_col_13_tmp=VERSIONNO,VERSIONNO=NULL;
ALTER TABLE I_ASSET MODIFY (A_DEPRECIATION_MANUAL_PERIOD VARCHAR2(2 CHAR),A_REVAL_CAL_METHOD VARCHAR2(3 CHAR),DESCRIPTION VARCHAR2(510 CHAR),HELP VARCHAR2(2000 CHAR),I_ASSET_UU VARCHAR2(36 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),LOCATIONCOMMENT VARCHAR2(255 CHAR),LOT VARCHAR2(20 CHAR),NAME VARCHAR2(60 CHAR),POSTINGTYPE VARCHAR2(10 CHAR),SERNO VARCHAR2(20 CHAR),VALUE VARCHAR2(40 CHAR),VERSIONNO VARCHAR2(20 CHAR));
UPDATE I_ASSET SET A_DEPRECIATION_MANUAL_PERIOD=tmp_col_1_tmp,A_REVAL_CAL_METHOD=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,I_ASSET_UU=tmp_col_5_tmp,I_ERRORMSG=tmp_col_6_tmp,LOCATIONCOMMENT=tmp_col_7_tmp,LOT=tmp_col_8_tmp,NAME=tmp_col_9_tmp,POSTINGTYPE=tmp_col_10_tmp,SERNO=tmp_col_11_tmp,VALUE=tmp_col_12_tmp,VERSIONNO=tmp_col_13_tmp;
ALTER TABLE I_ASSET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table I_BANKSTATEMENT
ALTER TABLE I_BANKSTATEMENT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(20 CHAR),tmp_col_14_tmp VARCHAR2(30 CHAR),tmp_col_15_tmp VARCHAR2(36 CHAR),tmp_col_16_tmp VARCHAR2(2000 CHAR),tmp_col_17_tmp VARCHAR2(255 CHAR),tmp_col_18_tmp VARCHAR2(255 CHAR),tmp_col_19_tmp VARCHAR2(60 CHAR),tmp_col_20_tmp VARCHAR2(30 CHAR),tmp_col_21_tmp VARCHAR2(40 CHAR),tmp_col_22_tmp VARCHAR2(20 CHAR));
UPDATE I_BANKSTATEMENT SET tmp_col_1_tmp=BANKACCOUNTNO,BANKACCOUNTNO=NULL,tmp_col_2_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_3_tmp=CHARGENAME,CHARGENAME=NULL,tmp_col_4_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_5_tmp=EFTCHECKNO,EFTCHECKNO=NULL,tmp_col_6_tmp=EFTCURRENCY,EFTCURRENCY=NULL,tmp_col_7_tmp=EFTMEMO,EFTMEMO=NULL,tmp_col_8_tmp=EFTPAYEE,EFTPAYEE=NULL,tmp_col_9_tmp=EFTPAYEEACCOUNT,EFTPAYEEACCOUNT=NULL,tmp_col_10_tmp=EFTREFERENCE,EFTREFERENCE=NULL,tmp_col_11_tmp=EFTSTATEMENTREFERENCE,EFTSTATEMENTREFERENCE=NULL,tmp_col_12_tmp=EFTTRXID,EFTTRXID=NULL,tmp_col_13_tmp=EFTTRXTYPE,EFTTRXTYPE=NULL,tmp_col_14_tmp=INVOICEDOCUMENTNO,INVOICEDOCUMENTNO=NULL,tmp_col_15_tmp=I_BANKSTATEMENT_UU,I_BANKSTATEMENT_UU=NULL,tmp_col_16_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_17_tmp=LINEDESCRIPTION,LINEDESCRIPTION=NULL,tmp_col_18_tmp=MEMO,MEMO=NULL,tmp_col_19_tmp=NAME,NAME=NULL,tmp_col_20_tmp=PAYMENTDOCUMENTNO,PAYMENTDOCUMENTNO=NULL,tmp_col_21_tmp=REFERENCENO,REFERENCENO=NULL,tmp_col_22_tmp=ROUTINGNO,ROUTINGNO=NULL;
ALTER TABLE I_BANKSTATEMENT MODIFY (BANKACCOUNTNO VARCHAR2(20 CHAR),BPARTNERVALUE VARCHAR2(40 CHAR),CHARGENAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EFTCHECKNO VARCHAR2(20 CHAR),EFTCURRENCY VARCHAR2(20 CHAR),EFTMEMO VARCHAR2(2000 CHAR),EFTPAYEE VARCHAR2(255 CHAR),EFTPAYEEACCOUNT VARCHAR2(40 CHAR),EFTREFERENCE VARCHAR2(60 CHAR),EFTSTATEMENTREFERENCE VARCHAR2(60 CHAR),EFTTRXID VARCHAR2(40 CHAR),EFTTRXTYPE VARCHAR2(20 CHAR),INVOICEDOCUMENTNO VARCHAR2(30 CHAR),I_BANKSTATEMENT_UU VARCHAR2(36 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),LINEDESCRIPTION VARCHAR2(255 CHAR),MEMO VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PAYMENTDOCUMENTNO VARCHAR2(30 CHAR),REFERENCENO VARCHAR2(40 CHAR),ROUTINGNO VARCHAR2(20 CHAR));
UPDATE I_BANKSTATEMENT SET BANKACCOUNTNO=tmp_col_1_tmp,BPARTNERVALUE=tmp_col_2_tmp,CHARGENAME=tmp_col_3_tmp,DESCRIPTION=tmp_col_4_tmp,EFTCHECKNO=tmp_col_5_tmp,EFTCURRENCY=tmp_col_6_tmp,EFTMEMO=tmp_col_7_tmp,EFTPAYEE=tmp_col_8_tmp,EFTPAYEEACCOUNT=tmp_col_9_tmp,EFTREFERENCE=tmp_col_10_tmp,EFTSTATEMENTREFERENCE=tmp_col_11_tmp,EFTTRXID=tmp_col_12_tmp,EFTTRXTYPE=tmp_col_13_tmp,INVOICEDOCUMENTNO=tmp_col_14_tmp,I_BANKSTATEMENT_UU=tmp_col_15_tmp,I_ERRORMSG=tmp_col_16_tmp,LINEDESCRIPTION=tmp_col_17_tmp,MEMO=tmp_col_18_tmp,NAME=tmp_col_19_tmp,PAYMENTDOCUMENTNO=tmp_col_20_tmp,REFERENCENO=tmp_col_21_tmp,ROUTINGNO=tmp_col_22_tmp;
ALTER TABLE I_BANKSTATEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp);

-- Processing table I_BPARTNER
ALTER TABLE I_BPARTNER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(36 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR),tmp_col_17_tmp VARCHAR2(20 CHAR),tmp_col_18_tmp VARCHAR2(40 CHAR),tmp_col_19_tmp VARCHAR2(40 CHAR),tmp_col_20_tmp VARCHAR2(60 CHAR),tmp_col_21_tmp VARCHAR2(40 CHAR),tmp_col_22_tmp VARCHAR2(40 CHAR));
UPDATE I_BPARTNER SET tmp_col_1_tmp=ADDRESS1,ADDRESS1=NULL,tmp_col_2_tmp=ADDRESS2,ADDRESS2=NULL,tmp_col_3_tmp=BPCONTACTGREETING,BPCONTACTGREETING=NULL,tmp_col_4_tmp=CITY,CITY=NULL,tmp_col_5_tmp=COMMENTS,COMMENTS=NULL,tmp_col_6_tmp=CONTACTDESCRIPTION,CONTACTDESCRIPTION=NULL,tmp_col_7_tmp=CONTACTNAME,CONTACTNAME=NULL,tmp_col_8_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_9_tmp=EMAIL,EMAIL=NULL,tmp_col_10_tmp=FAX,FAX=NULL,tmp_col_11_tmp=GROUPVALUE,GROUPVALUE=NULL,tmp_col_12_tmp=INTERESTAREANAME,INTERESTAREANAME=NULL,tmp_col_13_tmp=I_BPARTNER_UU,I_BPARTNER_UU=NULL,tmp_col_14_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_15_tmp=NAME,NAME=NULL,tmp_col_16_tmp=NAME2,NAME2=NULL,tmp_col_17_tmp=PASSWORD,PASSWORD=NULL,tmp_col_18_tmp=PHONE,PHONE=NULL,tmp_col_19_tmp=PHONE2,PHONE2=NULL,tmp_col_20_tmp=REGIONNAME,REGIONNAME=NULL,tmp_col_21_tmp=TITLE,TITLE=NULL,tmp_col_22_tmp=VALUE,VALUE=NULL;
ALTER TABLE I_BPARTNER MODIFY (ADDRESS1 VARCHAR2(60 CHAR),ADDRESS2 VARCHAR2(60 CHAR),BPCONTACTGREETING VARCHAR2(60 CHAR),CITY VARCHAR2(60 CHAR),COMMENTS VARCHAR2(2000 CHAR),CONTACTDESCRIPTION VARCHAR2(255 CHAR),CONTACTNAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),EMAIL VARCHAR2(60 CHAR),FAX VARCHAR2(40 CHAR),GROUPVALUE VARCHAR2(40 CHAR),INTERESTAREANAME VARCHAR2(40 CHAR),I_BPARTNER_UU VARCHAR2(36 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),NAME2 VARCHAR2(60 CHAR),PASSWORD VARCHAR2(20 CHAR),PHONE VARCHAR2(40 CHAR),PHONE2 VARCHAR2(40 CHAR),REGIONNAME VARCHAR2(60 CHAR),TITLE VARCHAR2(40 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE I_BPARTNER SET ADDRESS1=tmp_col_1_tmp,ADDRESS2=tmp_col_2_tmp,BPCONTACTGREETING=tmp_col_3_tmp,CITY=tmp_col_4_tmp,COMMENTS=tmp_col_5_tmp,CONTACTDESCRIPTION=tmp_col_6_tmp,CONTACTNAME=tmp_col_7_tmp,DESCRIPTION=tmp_col_8_tmp,EMAIL=tmp_col_9_tmp,FAX=tmp_col_10_tmp,GROUPVALUE=tmp_col_11_tmp,INTERESTAREANAME=tmp_col_12_tmp,I_BPARTNER_UU=tmp_col_13_tmp,I_ERRORMSG=tmp_col_14_tmp,NAME=tmp_col_15_tmp,NAME2=tmp_col_16_tmp,PASSWORD=tmp_col_17_tmp,PHONE=tmp_col_18_tmp,PHONE2=tmp_col_19_tmp,REGIONNAME=tmp_col_20_tmp,TITLE=tmp_col_21_tmp,VALUE=tmp_col_22_tmp;
ALTER TABLE I_BPARTNER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp);

-- Processing table I_CONVERSION_RATE
ALTER TABLE I_CONVERSION_RATE ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE I_CONVERSION_RATE SET tmp_col_1_tmp=CONVERSIONTYPEVALUE,CONVERSIONTYPEVALUE=NULL,tmp_col_2_tmp=I_CONVERSION_RATE_UU,I_CONVERSION_RATE_UU=NULL,tmp_col_3_tmp=I_ERRORMSG,I_ERRORMSG=NULL;
ALTER TABLE I_CONVERSION_RATE MODIFY (CONVERSIONTYPEVALUE VARCHAR2(40 CHAR),I_CONVERSION_RATE_UU VARCHAR2(36 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR));
UPDATE I_CONVERSION_RATE SET CONVERSIONTYPEVALUE=tmp_col_1_tmp,I_CONVERSION_RATE_UU=tmp_col_2_tmp,I_ERRORMSG=tmp_col_3_tmp;
ALTER TABLE I_CONVERSION_RATE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table I_ELEMENTVALUE
ALTER TABLE I_ELEMENTVALUE ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR));
UPDATE I_ELEMENTVALUE SET tmp_col_1_tmp=DEFAULT_ACCOUNT,DEFAULT_ACCOUNT=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=ELEMENTNAME,ELEMENTNAME=NULL,tmp_col_4_tmp=I_ELEMENTVALUE_UU,I_ELEMENTVALUE_UU=NULL,tmp_col_5_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PARENTVALUE,PARENTVALUE=NULL,tmp_col_8_tmp=VALUE,VALUE=NULL;
ALTER TABLE I_ELEMENTVALUE MODIFY (DEFAULT_ACCOUNT VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ELEMENTNAME VARCHAR2(60 CHAR),I_ELEMENTVALUE_UU VARCHAR2(36 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PARENTVALUE VARCHAR2(40 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE I_ELEMENTVALUE SET DEFAULT_ACCOUNT=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,ELEMENTNAME=tmp_col_3_tmp,I_ELEMENTVALUE_UU=tmp_col_4_tmp,I_ERRORMSG=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PARENTVALUE=tmp_col_7_tmp,VALUE=tmp_col_8_tmp;
ALTER TABLE I_ELEMENTVALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table I_FAJOURNAL
ALTER TABLE I_FAJOURNAL ADD (tmp_col_1_tmp VARCHAR2(80 CHAR),tmp_col_2_tmp VARCHAR2(120 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(80 CHAR),tmp_col_7_tmp VARCHAR2(120 CHAR),tmp_col_8_tmp VARCHAR2(80 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(510 CHAR),tmp_col_11_tmp VARCHAR2(120 CHAR),tmp_col_12_tmp VARCHAR2(1 CHAR),tmp_col_13_tmp VARCHAR2(3 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(36 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR),tmp_col_17_tmp VARCHAR2(40 CHAR),tmp_col_18_tmp VARCHAR2(40 CHAR),tmp_col_19_tmp VARCHAR2(40 CHAR),tmp_col_20_tmp VARCHAR2(40 CHAR),tmp_col_21_tmp VARCHAR2(30 CHAR),tmp_col_22_tmp VARCHAR2(30 CHAR));
UPDATE I_FAJOURNAL SET tmp_col_1_tmp=ACCOUNTVALUE,ACCOUNTVALUE=NULL,tmp_col_2_tmp=ACCTSCHEMANAME,ACCTSCHEMANAME=NULL,tmp_col_3_tmp=A_ENTRY_TYPE,A_ENTRY_TYPE=NULL,tmp_col_4_tmp=BATCHDESCRIPTION,BATCHDESCRIPTION=NULL,tmp_col_5_tmp=BATCHDOCUMENTNO,BATCHDOCUMENTNO=NULL,tmp_col_6_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_7_tmp=CATEGORYNAME,CATEGORYNAME=NULL,tmp_col_8_tmp=CLIENTVALUE,CLIENTVALUE=NULL,tmp_col_9_tmp=CONVERSIONTYPEVALUE,CONVERSIONTYPEVALUE=NULL,tmp_col_10_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_11_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_12_tmp=ISDEPRECIATED,ISDEPRECIATED=NULL,tmp_col_13_tmp=ISO_CODE,ISO_CODE=NULL,tmp_col_14_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_15_tmp=I_FAJOURNAL_UU,I_FAJOURNAL_UU=NULL,tmp_col_16_tmp=JOURNALDOCUMENTNO,JOURNALDOCUMENTNO=NULL,tmp_col_17_tmp=ORGTRXVALUE,ORGTRXVALUE=NULL,tmp_col_18_tmp=ORGVALUE,ORGVALUE=NULL,tmp_col_19_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_20_tmp=PROJECTVALUE,PROJECTVALUE=NULL,tmp_col_21_tmp=SKU,SKU=NULL,tmp_col_22_tmp=UPC,UPC=NULL;
ALTER TABLE I_FAJOURNAL MODIFY (ACCOUNTVALUE VARCHAR2(80 CHAR),ACCTSCHEMANAME VARCHAR2(120 CHAR),A_ENTRY_TYPE VARCHAR2(3 CHAR),BATCHDESCRIPTION VARCHAR2(510 CHAR),BATCHDOCUMENTNO VARCHAR2(60 CHAR),BPARTNERVALUE VARCHAR2(80 CHAR),CATEGORYNAME VARCHAR2(120 CHAR),CLIENTVALUE VARCHAR2(80 CHAR),CONVERSIONTYPEVALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(510 CHAR),DOCTYPENAME VARCHAR2(120 CHAR),ISDEPRECIATED VARCHAR2(1 CHAR),ISO_CODE VARCHAR2(3 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_FAJOURNAL_UU VARCHAR2(36 CHAR),JOURNALDOCUMENTNO VARCHAR2(60 CHAR),ORGTRXVALUE VARCHAR2(40 CHAR),ORGVALUE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),PROJECTVALUE VARCHAR2(40 CHAR),SKU VARCHAR2(30 CHAR),UPC VARCHAR2(30 CHAR));
UPDATE I_FAJOURNAL SET ACCOUNTVALUE=tmp_col_1_tmp,ACCTSCHEMANAME=tmp_col_2_tmp,A_ENTRY_TYPE=tmp_col_3_tmp,BATCHDESCRIPTION=tmp_col_4_tmp,BATCHDOCUMENTNO=tmp_col_5_tmp,BPARTNERVALUE=tmp_col_6_tmp,CATEGORYNAME=tmp_col_7_tmp,CLIENTVALUE=tmp_col_8_tmp,CONVERSIONTYPEVALUE=tmp_col_9_tmp,DESCRIPTION=tmp_col_10_tmp,DOCTYPENAME=tmp_col_11_tmp,ISDEPRECIATED=tmp_col_12_tmp,ISO_CODE=tmp_col_13_tmp,I_ERRORMSG=tmp_col_14_tmp,I_FAJOURNAL_UU=tmp_col_15_tmp,JOURNALDOCUMENTNO=tmp_col_16_tmp,ORGTRXVALUE=tmp_col_17_tmp,ORGVALUE=tmp_col_18_tmp,PRODUCTVALUE=tmp_col_19_tmp,PROJECTVALUE=tmp_col_20_tmp,SKU=tmp_col_21_tmp,UPC=tmp_col_22_tmp;
ALTER TABLE I_FAJOURNAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp);

-- Processing table I_FIXEDASSET
ALTER TABLE I_FIXEDASSET ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(2 CHAR),tmp_col_8_tmp VARCHAR2(30 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(36 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(120 CHAR),tmp_col_13_tmp VARCHAR2(40 CHAR),tmp_col_14_tmp VARCHAR2(10 CHAR));
ALTER TABLE I_FIXEDASSET MODIFY (DOCACTION NVARCHAR2(2) NULL);
UPDATE I_FIXEDASSET SET tmp_col_1_tmp=A_ASSET_CLASS_VALUE,A_ASSET_CLASS_VALUE=NULL,tmp_col_2_tmp=A_ASSET_GROUP_VALUE,A_ASSET_GROUP_VALUE=NULL,tmp_col_3_tmp=A_ASSET_TYPE_VALUE,A_ASSET_TYPE_VALUE=NULL,tmp_col_4_tmp=BPARTNER_VALUE,BPARTNER_VALUE=NULL,tmp_col_5_tmp=C_CITY_VALUE,C_CITY_VALUE=NULL,tmp_col_6_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_7_tmp=DOCACTION,DOCACTION=NULL,tmp_col_8_tmp=INVENTORYNO,INVENTORYNO=NULL,tmp_col_9_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_10_tmp=I_FIXEDASSET_UU,I_FIXEDASSET_UU=NULL,tmp_col_11_tmp=LOCATORVALUE,LOCATORVALUE=NULL,tmp_col_12_tmp=NAME,NAME=NULL,tmp_col_13_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_14_tmp=UOMSYMBOL,UOMSYMBOL=NULL;
ALTER TABLE I_FIXEDASSET MODIFY (A_ASSET_CLASS_VALUE VARCHAR2(40 CHAR),A_ASSET_GROUP_VALUE VARCHAR2(40 CHAR),A_ASSET_TYPE_VALUE VARCHAR2(40 CHAR),BPARTNER_VALUE VARCHAR2(40 CHAR),C_CITY_VALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCACTION VARCHAR2(2 CHAR) DEFAULT 'CO' ,INVENTORYNO VARCHAR2(30 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_FIXEDASSET_UU VARCHAR2(36 CHAR),LOCATORVALUE VARCHAR2(40 CHAR),NAME VARCHAR2(120 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),UOMSYMBOL VARCHAR2(10 CHAR));
UPDATE I_FIXEDASSET SET A_ASSET_CLASS_VALUE=tmp_col_1_tmp,A_ASSET_GROUP_VALUE=tmp_col_2_tmp,A_ASSET_TYPE_VALUE=tmp_col_3_tmp,BPARTNER_VALUE=tmp_col_4_tmp,C_CITY_VALUE=tmp_col_5_tmp,DESCRIPTION=tmp_col_6_tmp,DOCACTION=tmp_col_7_tmp,INVENTORYNO=tmp_col_8_tmp,I_ERRORMSG=tmp_col_9_tmp,I_FIXEDASSET_UU=tmp_col_10_tmp,LOCATORVALUE=tmp_col_11_tmp,NAME=tmp_col_12_tmp,PRODUCTVALUE=tmp_col_13_tmp,UOMSYMBOL=tmp_col_14_tmp;
ALTER TABLE I_FIXEDASSET MODIFY (DOCACTION VARCHAR2(2 CHAR) DEFAULT 'CO'  NOT NULL);
ALTER TABLE I_FIXEDASSET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp);

-- Processing table I_GLJOURNAL
ALTER TABLE I_GLJOURNAL ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(30 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(2000 CHAR),tmp_col_14_tmp VARCHAR2(36 CHAR),tmp_col_15_tmp VARCHAR2(30 CHAR),tmp_col_16_tmp VARCHAR2(40 CHAR),tmp_col_17_tmp VARCHAR2(40 CHAR),tmp_col_18_tmp VARCHAR2(40 CHAR),tmp_col_19_tmp VARCHAR2(40 CHAR),tmp_col_20_tmp VARCHAR2(40 CHAR));
UPDATE I_GLJOURNAL SET tmp_col_1_tmp=ACCOUNTVALUE,ACCOUNTVALUE=NULL,tmp_col_2_tmp=ACCTSCHEMANAME,ACCTSCHEMANAME=NULL,tmp_col_3_tmp=ACTIVITYVALUE,ACTIVITYVALUE=NULL,tmp_col_4_tmp=BATCHDESCRIPTION,BATCHDESCRIPTION=NULL,tmp_col_5_tmp=BATCHDOCUMENTNO,BATCHDOCUMENTNO=NULL,tmp_col_6_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_7_tmp=CAMPAIGNVALUE,CAMPAIGNVALUE=NULL,tmp_col_8_tmp=CATEGORYNAME,CATEGORYNAME=NULL,tmp_col_9_tmp=CLIENTVALUE,CLIENTVALUE=NULL,tmp_col_10_tmp=CONVERSIONTYPEVALUE,CONVERSIONTYPEVALUE=NULL,tmp_col_11_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_12_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_13_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_14_tmp=I_GLJOURNAL_UU,I_GLJOURNAL_UU=NULL,tmp_col_15_tmp=JOURNALDOCUMENTNO,JOURNALDOCUMENTNO=NULL,tmp_col_16_tmp=ORGTRXVALUE,ORGTRXVALUE=NULL,tmp_col_17_tmp=ORGVALUE,ORGVALUE=NULL,tmp_col_18_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_19_tmp=PROJECTVALUE,PROJECTVALUE=NULL,tmp_col_20_tmp=SALESREGIONVALUE,SALESREGIONVALUE=NULL;
ALTER TABLE I_GLJOURNAL MODIFY (ACCOUNTVALUE VARCHAR2(40 CHAR),ACCTSCHEMANAME VARCHAR2(60 CHAR),ACTIVITYVALUE VARCHAR2(40 CHAR),BATCHDESCRIPTION VARCHAR2(255 CHAR),BATCHDOCUMENTNO VARCHAR2(30 CHAR),BPARTNERVALUE VARCHAR2(40 CHAR),CAMPAIGNVALUE VARCHAR2(40 CHAR),CATEGORYNAME VARCHAR2(60 CHAR),CLIENTVALUE VARCHAR2(40 CHAR),CONVERSIONTYPEVALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCTYPENAME VARCHAR2(60 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_GLJOURNAL_UU VARCHAR2(36 CHAR),JOURNALDOCUMENTNO VARCHAR2(30 CHAR),ORGTRXVALUE VARCHAR2(40 CHAR),ORGVALUE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),PROJECTVALUE VARCHAR2(40 CHAR),SALESREGIONVALUE VARCHAR2(40 CHAR));
UPDATE I_GLJOURNAL SET ACCOUNTVALUE=tmp_col_1_tmp,ACCTSCHEMANAME=tmp_col_2_tmp,ACTIVITYVALUE=tmp_col_3_tmp,BATCHDESCRIPTION=tmp_col_4_tmp,BATCHDOCUMENTNO=tmp_col_5_tmp,BPARTNERVALUE=tmp_col_6_tmp,CAMPAIGNVALUE=tmp_col_7_tmp,CATEGORYNAME=tmp_col_8_tmp,CLIENTVALUE=tmp_col_9_tmp,CONVERSIONTYPEVALUE=tmp_col_10_tmp,DESCRIPTION=tmp_col_11_tmp,DOCTYPENAME=tmp_col_12_tmp,I_ERRORMSG=tmp_col_13_tmp,I_GLJOURNAL_UU=tmp_col_14_tmp,JOURNALDOCUMENTNO=tmp_col_15_tmp,ORGTRXVALUE=tmp_col_16_tmp,ORGVALUE=tmp_col_17_tmp,PRODUCTVALUE=tmp_col_18_tmp,PROJECTVALUE=tmp_col_19_tmp,SALESREGIONVALUE=tmp_col_20_tmp;
ALTER TABLE I_GLJOURNAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp);

-- Processing table I_HR_MOVEMENT
ALTER TABLE I_HR_MOVEMENT ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(1 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR));
ALTER TABLE I_HR_MOVEMENT MODIFY (I_ISIMPORTED NVARCHAR2(1) NULL);
UPDATE I_HR_MOVEMENT SET tmp_col_1_tmp=BPARTNER_VALUE,BPARTNER_VALUE=NULL,tmp_col_2_tmp=CONCEPTVALUE,CONCEPTVALUE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_5_tmp=I_HR_MOVEMENT_UU,I_HR_MOVEMENT_UU=NULL,tmp_col_6_tmp=I_ISIMPORTED,I_ISIMPORTED=NULL,tmp_col_7_tmp=PROCESSNAME,PROCESSNAME=NULL,tmp_col_8_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE I_HR_MOVEMENT MODIFY (BPARTNER_VALUE VARCHAR2(40 CHAR),CONCEPTVALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_HR_MOVEMENT_UU VARCHAR2(36 CHAR),I_ISIMPORTED VARCHAR2(1 CHAR) DEFAULT 'N' ,PROCESSNAME VARCHAR2(60 CHAR),TEXTMSG VARCHAR2(255 CHAR));
UPDATE I_HR_MOVEMENT SET BPARTNER_VALUE=tmp_col_1_tmp,CONCEPTVALUE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,I_ERRORMSG=tmp_col_4_tmp,I_HR_MOVEMENT_UU=tmp_col_5_tmp,I_ISIMPORTED=tmp_col_6_tmp,PROCESSNAME=tmp_col_7_tmp,TEXTMSG=tmp_col_8_tmp;
ALTER TABLE I_HR_MOVEMENT MODIFY (I_ISIMPORTED VARCHAR2(1 CHAR) DEFAULT 'N'	NOT NULL);
ALTER TABLE I_HR_MOVEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table I_INOUTLINECONFIRM
ALTER TABLE I_INOUTLINECONFIRM ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
UPDATE I_INOUTLINECONFIRM SET tmp_col_1_tmp=CONFIRMATIONNO,CONFIRMATIONNO=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_4_tmp=I_INOUTLINECONFIRM_UU,I_INOUTLINECONFIRM_UU=NULL;
ALTER TABLE I_INOUTLINECONFIRM MODIFY (CONFIRMATIONNO VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_INOUTLINECONFIRM_UU VARCHAR2(36 CHAR));
UPDATE I_INOUTLINECONFIRM SET CONFIRMATIONNO=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,I_ERRORMSG=tmp_col_3_tmp,I_INOUTLINECONFIRM_UU=tmp_col_4_tmp;
ALTER TABLE I_INOUTLINECONFIRM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table I_INVENTORY
ALTER TABLE I_INVENTORY ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR));
UPDATE I_INVENTORY SET tmp_col_1_tmp=CHARGENAME,CHARGENAME=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_4_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_5_tmp=I_INVENTORY_UU,I_INVENTORY_UU=NULL,tmp_col_6_tmp=LOCATORVALUE,LOCATORVALUE=NULL,tmp_col_7_tmp=LOT,LOT=NULL,tmp_col_8_tmp=SERNO,SERNO=NULL,tmp_col_9_tmp=VALUE,VALUE=NULL,tmp_col_10_tmp=WAREHOUSEVALUE,WAREHOUSEVALUE=NULL,tmp_col_11_tmp=X,X=NULL,tmp_col_12_tmp=Y,Y=NULL,tmp_col_13_tmp=Z,Z=NULL;
ALTER TABLE I_INVENTORY MODIFY (CHARGENAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCTYPENAME VARCHAR2(60 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_INVENTORY_UU VARCHAR2(36 CHAR),LOCATORVALUE VARCHAR2(40 CHAR),LOT VARCHAR2(20 CHAR),SERNO VARCHAR2(20 CHAR),VALUE VARCHAR2(40 CHAR),WAREHOUSEVALUE VARCHAR2(40 CHAR),X VARCHAR2(60 CHAR),Y VARCHAR2(60 CHAR),Z VARCHAR2(60 CHAR));
UPDATE I_INVENTORY SET CHARGENAME=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCTYPENAME=tmp_col_3_tmp,I_ERRORMSG=tmp_col_4_tmp,I_INVENTORY_UU=tmp_col_5_tmp,LOCATORVALUE=tmp_col_6_tmp,LOT=tmp_col_7_tmp,SERNO=tmp_col_8_tmp,VALUE=tmp_col_9_tmp,WAREHOUSEVALUE=tmp_col_10_tmp,X=tmp_col_11_tmp,Y=tmp_col_12_tmp,Z=tmp_col_13_tmp;
ALTER TABLE I_INVENTORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table I_INVOICE
ALTER TABLE I_INVOICE ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(30 CHAR),tmp_col_12_tmp VARCHAR2(60 CHAR),tmp_col_13_tmp VARCHAR2(2000 CHAR),tmp_col_14_tmp VARCHAR2(36 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR),tmp_col_17_tmp VARCHAR2(40 CHAR),tmp_col_18_tmp VARCHAR2(40 CHAR),tmp_col_19_tmp VARCHAR2(40 CHAR),tmp_col_20_tmp VARCHAR2(40 CHAR),tmp_col_21_tmp VARCHAR2(60 CHAR),tmp_col_22_tmp VARCHAR2(30 CHAR),tmp_col_23_tmp VARCHAR2(10 CHAR),tmp_col_24_tmp VARCHAR2(30 CHAR));
UPDATE I_INVOICE SET tmp_col_1_tmp=ACTIVITYVALUE,ACTIVITYVALUE=NULL,tmp_col_2_tmp=ADDRESS1,ADDRESS1=NULL,tmp_col_3_tmp=ADDRESS2,ADDRESS2=NULL,tmp_col_4_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_5_tmp=CHARGENAME,CHARGENAME=NULL,tmp_col_6_tmp=CITY,CITY=NULL,tmp_col_7_tmp=CONTACTNAME,CONTACTNAME=NULL,tmp_col_8_tmp=C_1099BOX_VALUE,C_1099BOX_VALUE=NULL,tmp_col_9_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_10_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_11_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_12_tmp=EMAIL,EMAIL=NULL,tmp_col_13_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_14_tmp=I_INVOICE_UU,I_INVOICE_UU=NULL,tmp_col_15_tmp=LINEDESCRIPTION,LINEDESCRIPTION=NULL,tmp_col_16_tmp=NAME,NAME=NULL,tmp_col_17_tmp=PAYMENTTERMVALUE,PAYMENTTERMVALUE=NULL,tmp_col_18_tmp=PHONE,PHONE=NULL,tmp_col_19_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_20_tmp=PROJECTVALUE,PROJECTVALUE=NULL,tmp_col_21_tmp=REGIONNAME,REGIONNAME=NULL,tmp_col_22_tmp=SKU,SKU=NULL,tmp_col_23_tmp=TAXINDICATOR,TAXINDICATOR=NULL,tmp_col_24_tmp=UPC,UPC=NULL;
ALTER TABLE I_INVOICE MODIFY (ACTIVITYVALUE VARCHAR2(40 CHAR),ADDRESS1 VARCHAR2(60 CHAR),ADDRESS2 VARCHAR2(60 CHAR),BPARTNERVALUE VARCHAR2(40 CHAR),CHARGENAME VARCHAR2(60 CHAR),CITY VARCHAR2(60 CHAR),CONTACTNAME VARCHAR2(60 CHAR),C_1099BOX_VALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCTYPENAME VARCHAR2(60 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),EMAIL VARCHAR2(60 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_INVOICE_UU VARCHAR2(36 CHAR),LINEDESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PAYMENTTERMVALUE VARCHAR2(40 CHAR),PHONE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),PROJECTVALUE VARCHAR2(40 CHAR),REGIONNAME VARCHAR2(60 CHAR),SKU VARCHAR2(30 CHAR),TAXINDICATOR VARCHAR2(10 CHAR),UPC VARCHAR2(30 CHAR));
UPDATE I_INVOICE SET ACTIVITYVALUE=tmp_col_1_tmp,ADDRESS1=tmp_col_2_tmp,ADDRESS2=tmp_col_3_tmp,BPARTNERVALUE=tmp_col_4_tmp,CHARGENAME=tmp_col_5_tmp,CITY=tmp_col_6_tmp,CONTACTNAME=tmp_col_7_tmp,C_1099BOX_VALUE=tmp_col_8_tmp,DESCRIPTION=tmp_col_9_tmp,DOCTYPENAME=tmp_col_10_tmp,DOCUMENTNO=tmp_col_11_tmp,EMAIL=tmp_col_12_tmp,I_ERRORMSG=tmp_col_13_tmp,I_INVOICE_UU=tmp_col_14_tmp,LINEDESCRIPTION=tmp_col_15_tmp,NAME=tmp_col_16_tmp,PAYMENTTERMVALUE=tmp_col_17_tmp,PHONE=tmp_col_18_tmp,PRODUCTVALUE=tmp_col_19_tmp,PROJECTVALUE=tmp_col_20_tmp,REGIONNAME=tmp_col_21_tmp,SKU=tmp_col_22_tmp,TAXINDICATOR=tmp_col_23_tmp,UPC=tmp_col_24_tmp;
ALTER TABLE I_INVOICE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp);

-- Processing table I_MOVEMENT
ALTER TABLE I_MOVEMENT ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(36 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(40 CHAR),tmp_col_14_tmp VARCHAR2(40 CHAR),tmp_col_15_tmp VARCHAR2(40 CHAR),tmp_col_16_tmp VARCHAR2(40 CHAR),tmp_col_17_tmp VARCHAR2(40 CHAR),tmp_col_18_tmp VARCHAR2(10 CHAR),tmp_col_19_tmp VARCHAR2(10 CHAR));
UPDATE I_MOVEMENT SET tmp_col_1_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_2_tmp=CAMPAIGNVALUE,CAMPAIGNVALUE=NULL,tmp_col_3_tmp=DELIVERYRULE,DELIVERYRULE=NULL,tmp_col_4_tmp=DELIVERYVIARULE,DELIVERYVIARULE=NULL,tmp_col_5_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_6_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_7_tmp=FREIGHTCOSTRULE,FREIGHTCOSTRULE=NULL,tmp_col_8_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_9_tmp=I_MOVEMENT_UU,I_MOVEMENT_UU=NULL,tmp_col_10_tmp=LOCATORTOVALUE,LOCATORTOVALUE=NULL,tmp_col_11_tmp=LOCATORVALUE,LOCATORVALUE=NULL,tmp_col_12_tmp=ORGTRXVALUE,ORGTRXVALUE=NULL,tmp_col_13_tmp=ORGVALUE,ORGVALUE=NULL,tmp_col_14_tmp=PRIORITYRULE,PRIORITYRULE=NULL,tmp_col_15_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_16_tmp=PROJECTVALUE,PROJECTVALUE=NULL,tmp_col_17_tmp=SHIPPERNAME,SHIPPERNAME=NULL,tmp_col_18_tmp=USER1_ID,USER1_ID=NULL,tmp_col_19_tmp=USER2_ID,USER2_ID=NULL;
ALTER TABLE I_MOVEMENT MODIFY (BPARTNERVALUE VARCHAR2(40 CHAR),CAMPAIGNVALUE VARCHAR2(40 CHAR),DELIVERYRULE VARCHAR2(40 CHAR),DELIVERYVIARULE VARCHAR2(40 CHAR),DOCTYPENAME VARCHAR2(40 CHAR),DOCUMENTNO VARCHAR2(40 CHAR),FREIGHTCOSTRULE VARCHAR2(40 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_MOVEMENT_UU VARCHAR2(36 CHAR),LOCATORTOVALUE VARCHAR2(40 CHAR),LOCATORVALUE VARCHAR2(40 CHAR),ORGTRXVALUE VARCHAR2(40 CHAR),ORGVALUE VARCHAR2(40 CHAR),PRIORITYRULE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),PROJECTVALUE VARCHAR2(40 CHAR),SHIPPERNAME VARCHAR2(40 CHAR),USER1_ID VARCHAR2(10 CHAR),USER2_ID VARCHAR2(10 CHAR));
UPDATE I_MOVEMENT SET BPARTNERVALUE=tmp_col_1_tmp,CAMPAIGNVALUE=tmp_col_2_tmp,DELIVERYRULE=tmp_col_3_tmp,DELIVERYVIARULE=tmp_col_4_tmp,DOCTYPENAME=tmp_col_5_tmp,DOCUMENTNO=tmp_col_6_tmp,FREIGHTCOSTRULE=tmp_col_7_tmp,I_ERRORMSG=tmp_col_8_tmp,I_MOVEMENT_UU=tmp_col_9_tmp,LOCATORTOVALUE=tmp_col_10_tmp,LOCATORVALUE=tmp_col_11_tmp,ORGTRXVALUE=tmp_col_12_tmp,ORGVALUE=tmp_col_13_tmp,PRIORITYRULE=tmp_col_14_tmp,PRODUCTVALUE=tmp_col_15_tmp,PROJECTVALUE=tmp_col_16_tmp,SHIPPERNAME=tmp_col_17_tmp,USER1_ID=tmp_col_18_tmp,USER2_ID=tmp_col_19_tmp;
ALTER TABLE I_MOVEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp);

-- Processing table I_ORDER
ALTER TABLE I_ORDER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(255 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(30 CHAR),tmp_col_11_tmp VARCHAR2(60 CHAR),tmp_col_12_tmp VARCHAR2(2000 CHAR),tmp_col_13_tmp VARCHAR2(36 CHAR),tmp_col_14_tmp VARCHAR2(255 CHAR),tmp_col_15_tmp VARCHAR2(60 CHAR),tmp_col_16_tmp VARCHAR2(40 CHAR),tmp_col_17_tmp VARCHAR2(40 CHAR),tmp_col_18_tmp VARCHAR2(40 CHAR),tmp_col_19_tmp VARCHAR2(60 CHAR),tmp_col_20_tmp VARCHAR2(30 CHAR),tmp_col_21_tmp VARCHAR2(10 CHAR),tmp_col_22_tmp VARCHAR2(30 CHAR));
UPDATE I_ORDER SET tmp_col_1_tmp=ADDRESS1,ADDRESS1=NULL,tmp_col_2_tmp=ADDRESS2,ADDRESS2=NULL,tmp_col_3_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_4_tmp=CHARGENAME,CHARGENAME=NULL,tmp_col_5_tmp=CITY,CITY=NULL,tmp_col_6_tmp=CONTACTNAME,CONTACTNAME=NULL,tmp_col_7_tmp=C_ORDERSOURCEVALUE,C_ORDERSOURCEVALUE=NULL,tmp_col_8_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_9_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_10_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_11_tmp=EMAIL,EMAIL=NULL,tmp_col_12_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_13_tmp=I_ORDER_UU,I_ORDER_UU=NULL,tmp_col_14_tmp=LINEDESCRIPTION,LINEDESCRIPTION=NULL,tmp_col_15_tmp=NAME,NAME=NULL,tmp_col_16_tmp=PAYMENTTERMVALUE,PAYMENTTERMVALUE=NULL,tmp_col_17_tmp=PHONE,PHONE=NULL,tmp_col_18_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_19_tmp=REGIONNAME,REGIONNAME=NULL,tmp_col_20_tmp=SKU,SKU=NULL,tmp_col_21_tmp=TAXINDICATOR,TAXINDICATOR=NULL,tmp_col_22_tmp=UPC,UPC=NULL;
ALTER TABLE I_ORDER MODIFY (ADDRESS1 VARCHAR2(60 CHAR),ADDRESS2 VARCHAR2(60 CHAR),BPARTNERVALUE VARCHAR2(40 CHAR),CHARGENAME VARCHAR2(60 CHAR),CITY VARCHAR2(60 CHAR),CONTACTNAME VARCHAR2(60 CHAR),C_ORDERSOURCEVALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCTYPENAME VARCHAR2(60 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),EMAIL VARCHAR2(60 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_ORDER_UU VARCHAR2(36 CHAR),LINEDESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PAYMENTTERMVALUE VARCHAR2(40 CHAR),PHONE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),REGIONNAME VARCHAR2(60 CHAR),SKU VARCHAR2(30 CHAR),TAXINDICATOR VARCHAR2(10 CHAR),UPC VARCHAR2(30 CHAR));
UPDATE I_ORDER SET ADDRESS1=tmp_col_1_tmp,ADDRESS2=tmp_col_2_tmp,BPARTNERVALUE=tmp_col_3_tmp,CHARGENAME=tmp_col_4_tmp,CITY=tmp_col_5_tmp,CONTACTNAME=tmp_col_6_tmp,C_ORDERSOURCEVALUE=tmp_col_7_tmp,DESCRIPTION=tmp_col_8_tmp,DOCTYPENAME=tmp_col_9_tmp,DOCUMENTNO=tmp_col_10_tmp,EMAIL=tmp_col_11_tmp,I_ERRORMSG=tmp_col_12_tmp,I_ORDER_UU=tmp_col_13_tmp,LINEDESCRIPTION=tmp_col_14_tmp,NAME=tmp_col_15_tmp,PAYMENTTERMVALUE=tmp_col_16_tmp,PHONE=tmp_col_17_tmp,PRODUCTVALUE=tmp_col_18_tmp,REGIONNAME=tmp_col_19_tmp,SKU=tmp_col_20_tmp,TAXINDICATOR=tmp_col_21_tmp,UPC=tmp_col_22_tmp;
ALTER TABLE I_ORDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp);

-- Processing table I_PAYMENT
ALTER TABLE I_PAYMENT ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(20 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR),tmp_col_10_tmp VARCHAR2(20 CHAR),tmp_col_11_tmp VARCHAR2(20 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(60 CHAR),tmp_col_14_tmp VARCHAR2(20 CHAR),tmp_col_15_tmp VARCHAR2(20 CHAR),tmp_col_16_tmp VARCHAR2(60 CHAR),tmp_col_17_tmp VARCHAR2(30 CHAR),tmp_col_18_tmp VARCHAR2(30 CHAR),tmp_col_19_tmp VARCHAR2(2000 CHAR),tmp_col_20_tmp VARCHAR2(36 CHAR),tmp_col_21_tmp VARCHAR2(20 CHAR),tmp_col_22_tmp VARCHAR2(20 CHAR),tmp_col_23_tmp VARCHAR2(60 CHAR),tmp_col_24_tmp VARCHAR2(20 CHAR),tmp_col_25_tmp VARCHAR2(20 CHAR),tmp_col_26_tmp VARCHAR2(2000 CHAR),tmp_col_27_tmp VARCHAR2(20 CHAR),tmp_col_28_tmp VARCHAR2(60 CHAR),tmp_col_29_tmp VARCHAR2(20 CHAR),tmp_col_30_tmp VARCHAR2(20 CHAR));
UPDATE I_PAYMENT SET tmp_col_1_tmp=ACCOUNTNO,ACCOUNTNO=NULL,tmp_col_2_tmp=A_CITY,A_CITY=NULL,tmp_col_3_tmp=A_COUNTRY,A_COUNTRY=NULL,tmp_col_4_tmp=A_EMAIL,A_EMAIL=NULL,tmp_col_5_tmp=A_IDENT_DL,A_IDENT_DL=NULL,tmp_col_6_tmp=A_IDENT_SSN,A_IDENT_SSN=NULL,tmp_col_7_tmp=A_NAME,A_NAME=NULL,tmp_col_8_tmp=A_STATE,A_STATE=NULL,tmp_col_9_tmp=A_STREET,A_STREET=NULL,tmp_col_10_tmp=A_ZIP,A_ZIP=NULL,tmp_col_11_tmp=BANKACCOUNTNO,BANKACCOUNTNO=NULL,tmp_col_12_tmp=BPARTNERVALUE,BPARTNERVALUE=NULL,tmp_col_13_tmp=CHARGENAME,CHARGENAME=NULL,tmp_col_14_tmp=CHECKNO,CHECKNO=NULL,tmp_col_15_tmp=CREDITCARDNUMBER,CREDITCARDNUMBER=NULL,tmp_col_16_tmp=DOCTYPENAME,DOCTYPENAME=NULL,tmp_col_17_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_18_tmp=INVOICEDOCUMENTNO,INVOICEDOCUMENTNO=NULL,tmp_col_19_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_20_tmp=I_PAYMENT_UU,I_PAYMENT_UU=NULL,tmp_col_21_tmp=MICR,MICR=NULL,tmp_col_22_tmp=ORIG_TRXID,ORIG_TRXID=NULL,tmp_col_23_tmp=PONUM,PONUM=NULL,tmp_col_24_tmp=ROUTINGNO,ROUTINGNO=NULL,tmp_col_25_tmp=R_AUTHCODE,R_AUTHCODE=NULL,tmp_col_26_tmp=R_INFO,R_INFO=NULL,tmp_col_27_tmp=R_PNREF,R_PNREF=NULL,tmp_col_28_tmp=R_RESPMSG,R_RESPMSG=NULL,tmp_col_29_tmp=R_RESULT,R_RESULT=NULL,tmp_col_30_tmp=VOICEAUTHCODE,VOICEAUTHCODE=NULL;
ALTER TABLE I_PAYMENT MODIFY (ACCOUNTNO VARCHAR2(20 CHAR),A_CITY VARCHAR2(60 CHAR),A_COUNTRY VARCHAR2(40 CHAR),A_EMAIL VARCHAR2(60 CHAR),A_IDENT_DL VARCHAR2(20 CHAR),A_IDENT_SSN VARCHAR2(20 CHAR),A_NAME VARCHAR2(60 CHAR),A_STATE VARCHAR2(40 CHAR),A_STREET VARCHAR2(60 CHAR),A_ZIP VARCHAR2(20 CHAR),BANKACCOUNTNO VARCHAR2(20 CHAR),BPARTNERVALUE VARCHAR2(40 CHAR),CHARGENAME VARCHAR2(60 CHAR),CHECKNO VARCHAR2(20 CHAR),CREDITCARDNUMBER VARCHAR2(20 CHAR),DOCTYPENAME VARCHAR2(60 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),INVOICEDOCUMENTNO VARCHAR2(30 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_PAYMENT_UU VARCHAR2(36 CHAR),MICR VARCHAR2(20 CHAR),ORIG_TRXID VARCHAR2(20 CHAR),PONUM VARCHAR2(60 CHAR),ROUTINGNO VARCHAR2(20 CHAR),R_AUTHCODE VARCHAR2(20 CHAR),R_INFO VARCHAR2(2000 CHAR),R_PNREF VARCHAR2(20 CHAR),R_RESPMSG VARCHAR2(60 CHAR),R_RESULT VARCHAR2(20 CHAR),VOICEAUTHCODE VARCHAR2(20 CHAR));
UPDATE I_PAYMENT SET ACCOUNTNO=tmp_col_1_tmp,A_CITY=tmp_col_2_tmp,A_COUNTRY=tmp_col_3_tmp,A_EMAIL=tmp_col_4_tmp,A_IDENT_DL=tmp_col_5_tmp,A_IDENT_SSN=tmp_col_6_tmp,A_NAME=tmp_col_7_tmp,A_STATE=tmp_col_8_tmp,A_STREET=tmp_col_9_tmp,A_ZIP=tmp_col_10_tmp,BANKACCOUNTNO=tmp_col_11_tmp,BPARTNERVALUE=tmp_col_12_tmp,CHARGENAME=tmp_col_13_tmp,CHECKNO=tmp_col_14_tmp,CREDITCARDNUMBER=tmp_col_15_tmp,DOCTYPENAME=tmp_col_16_tmp,DOCUMENTNO=tmp_col_17_tmp,INVOICEDOCUMENTNO=tmp_col_18_tmp,I_ERRORMSG=tmp_col_19_tmp,I_PAYMENT_UU=tmp_col_20_tmp,MICR=tmp_col_21_tmp,ORIG_TRXID=tmp_col_22_tmp,PONUM=tmp_col_23_tmp,ROUTINGNO=tmp_col_24_tmp,R_AUTHCODE=tmp_col_25_tmp,R_INFO=tmp_col_26_tmp,R_PNREF=tmp_col_27_tmp,R_RESPMSG=tmp_col_28_tmp,R_RESULT=tmp_col_29_tmp,VOICEAUTHCODE=tmp_col_30_tmp;
ALTER TABLE I_PAYMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp,tmp_col_21_tmp,tmp_col_22_tmp,tmp_col_23_tmp,tmp_col_24_tmp,tmp_col_25_tmp,tmp_col_26_tmp,tmp_col_27_tmp,tmp_col_28_tmp,tmp_col_29_tmp,tmp_col_30_tmp);

-- Processing table I_PRICELIST
ALTER TABLE I_PRICELIST ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(3 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(4 CHAR));
UPDATE I_PRICELIST SET tmp_col_1_tmp=BPARTNER_VALUE,BPARTNER_VALUE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=ISO_CODE,ISO_CODE=NULL,tmp_col_4_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_5_tmp=I_PRICELIST_UU,I_PRICELIST_UU=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_8_tmp=X12DE355,X12DE355=NULL;
ALTER TABLE I_PRICELIST MODIFY (BPARTNER_VALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),ISO_CODE VARCHAR2(3 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_PRICELIST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),X12DE355 VARCHAR2(4 CHAR));
UPDATE I_PRICELIST SET BPARTNER_VALUE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,ISO_CODE=tmp_col_3_tmp,I_ERRORMSG=tmp_col_4_tmp,I_PRICELIST_UU=tmp_col_5_tmp,NAME=tmp_col_6_tmp,PRODUCTVALUE=tmp_col_7_tmp,X12DE355=tmp_col_8_tmp;
ALTER TABLE I_PRICELIST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table I_PRODUCT
ALTER TABLE I_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(36 CHAR),tmp_col_9_tmp VARCHAR2(30 CHAR),tmp_col_10_tmp VARCHAR2(255 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(40 CHAR),tmp_col_13_tmp VARCHAR2(30 CHAR),tmp_col_14_tmp VARCHAR2(40 CHAR),tmp_col_15_tmp VARCHAR2(4 CHAR));
UPDATE I_PRODUCT SET tmp_col_1_tmp=BPARTNER_VALUE,BPARTNER_VALUE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DESCRIPTIONURL,DESCRIPTIONURL=NULL,tmp_col_4_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_5_tmp=HELP,HELP=NULL,tmp_col_6_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_7_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_8_tmp=I_PRODUCT_UU,I_PRODUCT_UU=NULL,tmp_col_9_tmp=MANUFACTURER,MANUFACTURER=NULL,tmp_col_10_tmp=NAME,NAME=NULL,tmp_col_11_tmp=PRODUCTCATEGORY_VALUE,PRODUCTCATEGORY_VALUE=NULL,tmp_col_12_tmp=VALUE,VALUE=NULL,tmp_col_13_tmp=VENDORCATEGORY,VENDORCATEGORY=NULL,tmp_col_14_tmp=VENDORPRODUCTNO,VENDORPRODUCTNO=NULL,tmp_col_15_tmp=X12DE355,X12DE355=NULL;
ALTER TABLE I_PRODUCT MODIFY (BPARTNER_VALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DESCRIPTIONURL VARCHAR2(120 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),IMAGEURL VARCHAR2(120 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_PRODUCT_UU VARCHAR2(36 CHAR),MANUFACTURER VARCHAR2(30 CHAR),NAME VARCHAR2(255 CHAR),PRODUCTCATEGORY_VALUE VARCHAR2(40 CHAR),VALUE VARCHAR2(40 CHAR),VENDORCATEGORY VARCHAR2(30 CHAR),VENDORPRODUCTNO VARCHAR2(40 CHAR),X12DE355 VARCHAR2(4 CHAR));
UPDATE I_PRODUCT SET BPARTNER_VALUE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DESCRIPTIONURL=tmp_col_3_tmp,DOCUMENTNOTE=tmp_col_4_tmp,HELP=tmp_col_5_tmp,IMAGEURL=tmp_col_6_tmp,I_ERRORMSG=tmp_col_7_tmp,I_PRODUCT_UU=tmp_col_8_tmp,MANUFACTURER=tmp_col_9_tmp,NAME=tmp_col_10_tmp,PRODUCTCATEGORY_VALUE=tmp_col_11_tmp,VALUE=tmp_col_12_tmp,VENDORCATEGORY=tmp_col_13_tmp,VENDORPRODUCTNO=tmp_col_14_tmp,X12DE355=tmp_col_15_tmp;
ALTER TABLE I_PRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp);

-- Processing table I_PRODUCTPLANNING
ALTER TABLE I_PRODUCTPLANNING ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(3 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(40 CHAR),tmp_col_9_tmp VARCHAR2(40 CHAR),tmp_col_10_tmp VARCHAR2(40 CHAR),tmp_col_11_tmp VARCHAR2(40 CHAR),tmp_col_12_tmp VARCHAR2(30 CHAR),tmp_col_13_tmp VARCHAR2(40 CHAR));
UPDATE I_PRODUCTPLANNING SET tmp_col_1_tmp=BPARTNER_VALUE,BPARTNER_VALUE=NULL,tmp_col_2_tmp=FORECASTVALUE,FORECASTVALUE=NULL,tmp_col_3_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_4_tmp=I_PRODUCTPLANNING_UU,I_PRODUCTPLANNING_UU=NULL,tmp_col_5_tmp=NETWORKDISTRIBUTIONVALUE,NETWORKDISTRIBUTIONVALUE=NULL,tmp_col_6_tmp=ORDER_POLICY,ORDER_POLICY=NULL,tmp_col_7_tmp=ORGVALUE,ORGVALUE=NULL,tmp_col_8_tmp=PLANNERVALUE,PLANNERVALUE=NULL,tmp_col_9_tmp=PRODUCTVALUE,PRODUCTVALUE=NULL,tmp_col_10_tmp=PRODUCT_BOM_VALUE,PRODUCT_BOM_VALUE=NULL,tmp_col_11_tmp=RESOURCEVALUE,RESOURCEVALUE=NULL,tmp_col_12_tmp=VENDORPRODUCTNO,VENDORPRODUCTNO=NULL,tmp_col_13_tmp=WAREHOUSEVALUE,WAREHOUSEVALUE=NULL;
ALTER TABLE I_PRODUCTPLANNING MODIFY (BPARTNER_VALUE VARCHAR2(40 CHAR),FORECASTVALUE VARCHAR2(40 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_PRODUCTPLANNING_UU VARCHAR2(36 CHAR),NETWORKDISTRIBUTIONVALUE VARCHAR2(40 CHAR),ORDER_POLICY VARCHAR2(3 CHAR),ORGVALUE VARCHAR2(40 CHAR),PLANNERVALUE VARCHAR2(40 CHAR),PRODUCTVALUE VARCHAR2(40 CHAR),PRODUCT_BOM_VALUE VARCHAR2(40 CHAR),RESOURCEVALUE VARCHAR2(40 CHAR),VENDORPRODUCTNO VARCHAR2(30 CHAR),WAREHOUSEVALUE VARCHAR2(40 CHAR));
UPDATE I_PRODUCTPLANNING SET BPARTNER_VALUE=tmp_col_1_tmp,FORECASTVALUE=tmp_col_2_tmp,I_ERRORMSG=tmp_col_3_tmp,I_PRODUCTPLANNING_UU=tmp_col_4_tmp,NETWORKDISTRIBUTIONVALUE=tmp_col_5_tmp,ORDER_POLICY=tmp_col_6_tmp,ORGVALUE=tmp_col_7_tmp,PLANNERVALUE=tmp_col_8_tmp,PRODUCTVALUE=tmp_col_9_tmp,PRODUCT_BOM_VALUE=tmp_col_10_tmp,RESOURCEVALUE=tmp_col_11_tmp,VENDORPRODUCTNO=tmp_col_12_tmp,WAREHOUSEVALUE=tmp_col_13_tmp;
ALTER TABLE I_PRODUCTPLANNING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table I_REPORTLINE
ALTER TABLE I_REPORTLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR));
UPDATE I_REPORTLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=ELEMENTVALUE,ELEMENTVALUE=NULL,tmp_col_3_tmp=I_ERRORMSG,I_ERRORMSG=NULL,tmp_col_4_tmp=I_REPORTLINE_UU,I_REPORTLINE_UU=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=REPORTLINESETNAME,REPORTLINESETNAME=NULL;
ALTER TABLE I_REPORTLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),ELEMENTVALUE VARCHAR2(40 CHAR),I_ERRORMSG VARCHAR2(2000 CHAR),I_REPORTLINE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),REPORTLINESETNAME VARCHAR2(60 CHAR));
UPDATE I_REPORTLINE SET DESCRIPTION=tmp_col_1_tmp,ELEMENTVALUE=tmp_col_2_tmp,I_ERRORMSG=tmp_col_3_tmp,I_REPORTLINE_UU=tmp_col_4_tmp,NAME=tmp_col_5_tmp,REPORTLINESETNAME=tmp_col_6_tmp;
ALTER TABLE I_REPORTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table K_CATEGORY
ALTER TABLE K_CATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_CATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE K_CATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=K_CATEGORY_UU,K_CATEGORY_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE K_CATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),K_CATEGORY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_CATEGORY SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,K_CATEGORY_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE K_CATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_CATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table K_CATEGORYVALUE
ALTER TABLE K_CATEGORYVALUE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_CATEGORYVALUE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE K_CATEGORYVALUE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=K_CATEGORYVALUE_UU,K_CATEGORYVALUE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE K_CATEGORYVALUE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),K_CATEGORYVALUE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_CATEGORYVALUE SET DESCRIPTION=tmp_col_1_tmp,K_CATEGORYVALUE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE K_CATEGORYVALUE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_CATEGORYVALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table K_COMMENT
ALTER TABLE K_COMMENT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE K_COMMENT MODIFY (TEXTMSG NVARCHAR2(2000) NULL);
UPDATE K_COMMENT SET tmp_col_1_tmp=K_COMMENT_UU,K_COMMENT_UU=NULL,tmp_col_2_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE K_COMMENT MODIFY (K_COMMENT_UU VARCHAR2(36 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE K_COMMENT SET K_COMMENT_UU=tmp_col_1_tmp,TEXTMSG=tmp_col_2_tmp;
ALTER TABLE K_COMMENT MODIFY (TEXTMSG VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE K_COMMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table K_ENTRY
ALTER TABLE K_ENTRY ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE K_ENTRY MODIFY (NAME NVARCHAR2(60) NULL,TEXTMSG NVARCHAR2(2000) NULL);
UPDATE K_ENTRY SET tmp_col_1_tmp=DESCRIPTIONURL,DESCRIPTIONURL=NULL,tmp_col_2_tmp=KEYWORDS,KEYWORDS=NULL,tmp_col_3_tmp=K_ENTRY_UU,K_ENTRY_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE K_ENTRY MODIFY (DESCRIPTIONURL VARCHAR2(120 CHAR),KEYWORDS VARCHAR2(255 CHAR),K_ENTRY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE K_ENTRY SET DESCRIPTIONURL=tmp_col_1_tmp,KEYWORDS=tmp_col_2_tmp,K_ENTRY_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE K_ENTRY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,TEXTMSG VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE K_ENTRY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table K_ENTRYCATEGORY
ALTER TABLE K_ENTRYCATEGORY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE K_ENTRYCATEGORY SET tmp_col_1_tmp=K_ENTRYCATEGORY_UU,K_ENTRYCATEGORY_UU=NULL;
ALTER TABLE K_ENTRYCATEGORY MODIFY (K_ENTRYCATEGORY_UU VARCHAR2(36 CHAR));
UPDATE K_ENTRYCATEGORY SET K_ENTRYCATEGORY_UU=tmp_col_1_tmp;
ALTER TABLE K_ENTRYCATEGORY DROP (tmp_col_1_tmp);

-- Processing table K_ENTRYRELATED
ALTER TABLE K_ENTRYRELATED ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE K_ENTRYRELATED SET tmp_col_1_tmp=K_ENTRYRELATED_UU,K_ENTRYRELATED_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE K_ENTRYRELATED MODIFY (K_ENTRYRELATED_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_ENTRYRELATED SET K_ENTRYRELATED_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE K_ENTRYRELATED DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table K_INDEX
ALTER TABLE K_INDEX ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE K_INDEX MODIFY (KEYWORD NVARCHAR2(255) NULL);
UPDATE K_INDEX SET tmp_col_1_tmp=EXCERPT,EXCERPT=NULL,tmp_col_2_tmp=KEYWORD,KEYWORD=NULL,tmp_col_3_tmp=K_INDEX_UU,K_INDEX_UU=NULL;
ALTER TABLE K_INDEX MODIFY (EXCERPT VARCHAR2(2000 CHAR),KEYWORD VARCHAR2(255 CHAR),K_INDEX_UU VARCHAR2(36 CHAR));
UPDATE K_INDEX SET EXCERPT=tmp_col_1_tmp,KEYWORD=tmp_col_2_tmp,K_INDEX_UU=tmp_col_3_tmp;
ALTER TABLE K_INDEX MODIFY (KEYWORD VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE K_INDEX DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table K_INDEXLOG
ALTER TABLE K_INDEXLOG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
ALTER TABLE K_INDEXLOG MODIFY (INDEXQUERY NVARCHAR2(255) NULL);
UPDATE K_INDEXLOG SET tmp_col_1_tmp=INDEXQUERY,INDEXQUERY=NULL,tmp_col_2_tmp=K_INDEXLOG_UU,K_INDEXLOG_UU=NULL;
ALTER TABLE K_INDEXLOG MODIFY (INDEXQUERY VARCHAR2(255 CHAR),K_INDEXLOG_UU VARCHAR2(36 CHAR));
UPDATE K_INDEXLOG SET INDEXQUERY=tmp_col_1_tmp,K_INDEXLOG_UU=tmp_col_2_tmp;
ALTER TABLE K_INDEXLOG MODIFY (INDEXQUERY VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE K_INDEXLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table K_INDEXSTOP
ALTER TABLE K_INDEXSTOP ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
ALTER TABLE K_INDEXSTOP MODIFY (KEYWORD NVARCHAR2(255) NULL);
UPDATE K_INDEXSTOP SET tmp_col_1_tmp=KEYWORD,KEYWORD=NULL,tmp_col_2_tmp=K_INDEXSTOP_UU,K_INDEXSTOP_UU=NULL;
ALTER TABLE K_INDEXSTOP MODIFY (KEYWORD VARCHAR2(255 CHAR),K_INDEXSTOP_UU VARCHAR2(36 CHAR));
UPDATE K_INDEXSTOP SET KEYWORD=tmp_col_1_tmp,K_INDEXSTOP_UU=tmp_col_2_tmp;
ALTER TABLE K_INDEXSTOP MODIFY (KEYWORD VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE K_INDEXSTOP DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table K_SOURCE
ALTER TABLE K_SOURCE ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_SOURCE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE K_SOURCE SET tmp_col_1_tmp=DESCRIPTIONURL,DESCRIPTIONURL=NULL,tmp_col_2_tmp=K_SOURCE_UU,K_SOURCE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE K_SOURCE MODIFY (DESCRIPTIONURL VARCHAR2(120 CHAR),K_SOURCE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_SOURCE SET DESCRIPTIONURL=tmp_col_1_tmp,K_SOURCE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE K_SOURCE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_SOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table K_SYNONYM
ALTER TABLE K_SYNONYM ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_SYNONYM MODIFY (NAME NVARCHAR2(60) NULL,SYNONYMNAME NVARCHAR2(60) NULL);
UPDATE K_SYNONYM SET tmp_col_1_tmp=K_SYNONYM_UU,K_SYNONYM_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=SYNONYMNAME,SYNONYMNAME=NULL;
ALTER TABLE K_SYNONYM MODIFY (K_SYNONYM_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),SYNONYMNAME VARCHAR2(60 CHAR));
UPDATE K_SYNONYM SET K_SYNONYM_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp,SYNONYMNAME=tmp_col_3_tmp;
ALTER TABLE K_SYNONYM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,SYNONYMNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_SYNONYM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table K_TOPIC
ALTER TABLE K_TOPIC ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_TOPIC MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE K_TOPIC SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=K_TOPIC_UU,K_TOPIC_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE K_TOPIC MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),K_TOPIC_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_TOPIC SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,K_TOPIC_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE K_TOPIC MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_TOPIC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table K_TYPE
ALTER TABLE K_TYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE K_TYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE K_TYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=K_TYPE_UU,K_TYPE_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE K_TYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),K_TYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE K_TYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,K_TYPE_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE K_TYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE K_TYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_ATTRIBUTE
ALTER TABLE M_ATTRIBUTE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_ATTRIBUTE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_ATTRIBUTE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_ATTRIBUTE_UU,M_ATTRIBUTE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_ATTRIBUTE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_ATTRIBUTE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_ATTRIBUTE SET DESCRIPTION=tmp_col_1_tmp,M_ATTRIBUTE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_ATTRIBUTE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_ATTRIBUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_ATTRIBUTEINSTANCE
ALTER TABLE M_ATTRIBUTEINSTANCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR));
UPDATE M_ATTRIBUTEINSTANCE SET tmp_col_1_tmp=M_ATTRIBUTEINSTANCE_UU,M_ATTRIBUTEINSTANCE_UU=NULL,tmp_col_2_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_ATTRIBUTEINSTANCE MODIFY (M_ATTRIBUTEINSTANCE_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_ATTRIBUTEINSTANCE SET M_ATTRIBUTEINSTANCE_UU=tmp_col_1_tmp,VALUE=tmp_col_2_tmp;
ALTER TABLE M_ATTRIBUTEINSTANCE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_ATTRIBUTESEARCH
ALTER TABLE M_ATTRIBUTESEARCH ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_ATTRIBUTESEARCH MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_ATTRIBUTESEARCH SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_ATTRIBUTESEARCH_UU,M_ATTRIBUTESEARCH_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_ATTRIBUTESEARCH MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_ATTRIBUTESEARCH_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_ATTRIBUTESEARCH SET DESCRIPTION=tmp_col_1_tmp,M_ATTRIBUTESEARCH_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_ATTRIBUTESEARCH MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_ATTRIBUTESEARCH DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_ATTRIBUTESET
ALTER TABLE M_ATTRIBUTESET ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_ATTRIBUTESET MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_ATTRIBUTESET SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_ATTRIBUTESET_UU,M_ATTRIBUTESET_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_ATTRIBUTESET MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_ATTRIBUTESET_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_ATTRIBUTESET SET DESCRIPTION=tmp_col_1_tmp,M_ATTRIBUTESET_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_ATTRIBUTESET MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_ATTRIBUTESET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_ATTRIBUTESETEXCLUDE
ALTER TABLE M_ATTRIBUTESETEXCLUDE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_ATTRIBUTESETEXCLUDE SET tmp_col_1_tmp=M_ATTRIBUTESETEXCLUDE_UU,M_ATTRIBUTESETEXCLUDE_UU=NULL;
ALTER TABLE M_ATTRIBUTESETEXCLUDE MODIFY (M_ATTRIBUTESETEXCLUDE_UU VARCHAR2(36 CHAR));
UPDATE M_ATTRIBUTESETEXCLUDE SET M_ATTRIBUTESETEXCLUDE_UU=tmp_col_1_tmp;
ALTER TABLE M_ATTRIBUTESETEXCLUDE DROP (tmp_col_1_tmp);

-- Processing table M_ATTRIBUTESETINSTANCE
ALTER TABLE M_ATTRIBUTESETINSTANCE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
UPDATE M_ATTRIBUTESETINSTANCE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=LOT,LOT=NULL,tmp_col_3_tmp=M_ATTRIBUTESETINSTANCE_UU,M_ATTRIBUTESETINSTANCE_UU=NULL,tmp_col_4_tmp=SERNO,SERNO=NULL;
ALTER TABLE M_ATTRIBUTESETINSTANCE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),LOT VARCHAR2(40 CHAR),M_ATTRIBUTESETINSTANCE_UU VARCHAR2(36 CHAR),SERNO VARCHAR2(40 CHAR));
UPDATE M_ATTRIBUTESETINSTANCE SET DESCRIPTION=tmp_col_1_tmp,LOT=tmp_col_2_tmp,M_ATTRIBUTESETINSTANCE_UU=tmp_col_3_tmp,SERNO=tmp_col_4_tmp;
ALTER TABLE M_ATTRIBUTESETINSTANCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_ATTRIBUTEUSE
ALTER TABLE M_ATTRIBUTEUSE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_ATTRIBUTEUSE SET tmp_col_1_tmp=M_ATTRIBUTEUSE_UU,M_ATTRIBUTEUSE_UU=NULL;
ALTER TABLE M_ATTRIBUTEUSE MODIFY (M_ATTRIBUTEUSE_UU VARCHAR2(36 CHAR));
UPDATE M_ATTRIBUTEUSE SET M_ATTRIBUTEUSE_UU=tmp_col_1_tmp;
ALTER TABLE M_ATTRIBUTEUSE DROP (tmp_col_1_tmp);

-- Processing table M_ATTRIBUTEVALUE
ALTER TABLE M_ATTRIBUTEVALUE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_ATTRIBUTEVALUE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_ATTRIBUTEVALUE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_ATTRIBUTEVALUE_UU,M_ATTRIBUTEVALUE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_ATTRIBUTEVALUE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_ATTRIBUTEVALUE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_ATTRIBUTEVALUE SET DESCRIPTION=tmp_col_1_tmp,M_ATTRIBUTEVALUE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE M_ATTRIBUTEVALUE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_ATTRIBUTEVALUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_BOM
ALTER TABLE M_BOM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_BOM MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_BOM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_BOM_UU,M_BOM_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_BOM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_BOM_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_BOM SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_BOM_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_BOM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_BOM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_BOMALTERNATIVE
ALTER TABLE M_BOMALTERNATIVE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_BOMALTERNATIVE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_BOMALTERNATIVE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_BOMALTERNATIVE_UU,M_BOMALTERNATIVE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_BOMALTERNATIVE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_BOMALTERNATIVE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_BOMALTERNATIVE SET DESCRIPTION=tmp_col_1_tmp,M_BOMALTERNATIVE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_BOMALTERNATIVE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_BOMALTERNATIVE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_BOMPRODUCT
ALTER TABLE M_BOMPRODUCT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE M_BOMPRODUCT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_BOMPRODUCT_UU,M_BOMPRODUCT_UU=NULL;
ALTER TABLE M_BOMPRODUCT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_BOMPRODUCT_UU VARCHAR2(36 CHAR));
UPDATE M_BOMPRODUCT SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_BOMPRODUCT_UU=tmp_col_3_tmp;
ALTER TABLE M_BOMPRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_BP_PRICE
ALTER TABLE M_BP_PRICE ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_BP_PRICE SET tmp_col_1_tmp=COMMENTS,COMMENTS=NULL,tmp_col_2_tmp=M_BP_PRICE_UU,M_BP_PRICE_UU=NULL;
ALTER TABLE M_BP_PRICE MODIFY (COMMENTS VARCHAR2(2000 CHAR),M_BP_PRICE_UU VARCHAR2(36 CHAR));
UPDATE M_BP_PRICE SET COMMENTS=tmp_col_1_tmp,M_BP_PRICE_UU=tmp_col_2_tmp;
ALTER TABLE M_BP_PRICE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_CHANGENOTICE
ALTER TABLE M_CHANGENOTICE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_CHANGENOTICE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_CHANGENOTICE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_CHANGENOTICE_UU,M_CHANGENOTICE_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_CHANGENOTICE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_CHANGENOTICE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_CHANGENOTICE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_CHANGENOTICE_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_CHANGENOTICE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_CHANGENOTICE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_CHANGEREQUEST
ALTER TABLE M_CHANGEREQUEST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_CHANGEREQUEST MODIFY (DOCUMENTNO NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE M_CHANGEREQUEST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=M_CHANGEREQUEST_UU,M_CHANGEREQUEST_UU=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE M_CHANGEREQUEST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),HELP VARCHAR2(2000 CHAR),M_CHANGEREQUEST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_CHANGEREQUEST SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,HELP=tmp_col_3_tmp,M_CHANGEREQUEST_UU=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE M_CHANGEREQUEST MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_CHANGEREQUEST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_COMMODITYSHIPMENT
ALTER TABLE M_COMMODITYSHIPMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_COMMODITYSHIPMENT MODIFY (HARMONIZEDCODE NVARCHAR2(30) NULL);
UPDATE M_COMMODITYSHIPMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=EXPORTLICENSENUM,EXPORTLICENSENUM=NULL,tmp_col_3_tmp=HARMONIZEDCODE,HARMONIZEDCODE=NULL,tmp_col_4_tmp=M_COMMODITYSHIPMENT_UU,M_COMMODITYSHIPMENT_UU=NULL;
ALTER TABLE M_COMMODITYSHIPMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),EXPORTLICENSENUM VARCHAR2(30 CHAR),HARMONIZEDCODE VARCHAR2(30 CHAR),M_COMMODITYSHIPMENT_UU VARCHAR2(36 CHAR));
UPDATE M_COMMODITYSHIPMENT SET DESCRIPTION=tmp_col_1_tmp,EXPORTLICENSENUM=tmp_col_2_tmp,HARMONIZEDCODE=tmp_col_3_tmp,M_COMMODITYSHIPMENT_UU=tmp_col_4_tmp;
ALTER TABLE M_COMMODITYSHIPMENT MODIFY (HARMONIZEDCODE VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_COMMODITYSHIPMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_COST
ALTER TABLE M_COST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_COST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_COST_UU,M_COST_UU=NULL;
ALTER TABLE M_COST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_COST_UU VARCHAR2(36 CHAR));
UPDATE M_COST SET DESCRIPTION=tmp_col_1_tmp,M_COST_UU=tmp_col_2_tmp;
ALTER TABLE M_COST DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_COSTDETAIL
ALTER TABLE M_COSTDETAIL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_COSTDETAIL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_COSTDETAIL_UU,M_COSTDETAIL_UU=NULL;
ALTER TABLE M_COSTDETAIL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_COSTDETAIL_UU VARCHAR2(36 CHAR));
UPDATE M_COSTDETAIL SET DESCRIPTION=tmp_col_1_tmp,M_COSTDETAIL_UU=tmp_col_2_tmp;
ALTER TABLE M_COSTDETAIL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_COSTELEMENT
ALTER TABLE M_COSTELEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_COSTELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_COSTELEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_COSTELEMENT_UU,M_COSTELEMENT_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_COSTELEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_COSTELEMENT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_COSTELEMENT SET DESCRIPTION=tmp_col_1_tmp,M_COSTELEMENT_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_COSTELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_COSTELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_COSTHISTORY
ALTER TABLE M_COSTHISTORY ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_COSTHISTORY MODIFY (M_COSTHISTORY_UU NVARCHAR2(36) NULL);
UPDATE M_COSTHISTORY SET tmp_col_1_tmp=M_COSTHISTORY_UU,M_COSTHISTORY_UU=NULL;
ALTER TABLE M_COSTHISTORY MODIFY (M_COSTHISTORY_UU VARCHAR2(36 CHAR));
UPDATE M_COSTHISTORY SET M_COSTHISTORY_UU=tmp_col_1_tmp;
ALTER TABLE M_COSTHISTORY MODIFY (M_COSTHISTORY_UU VARCHAR2(36 CHAR) NOT NULL);
ALTER TABLE M_COSTHISTORY DROP (tmp_col_1_tmp);

-- Processing table M_COSTQUEUE
ALTER TABLE M_COSTQUEUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_COSTQUEUE SET tmp_col_1_tmp=M_COSTQUEUE_UU,M_COSTQUEUE_UU=NULL;
ALTER TABLE M_COSTQUEUE MODIFY (M_COSTQUEUE_UU VARCHAR2(36 CHAR));
UPDATE M_COSTQUEUE SET M_COSTQUEUE_UU=tmp_col_1_tmp;
ALTER TABLE M_COSTQUEUE DROP (tmp_col_1_tmp);

-- Processing table M_COSTTYPE
ALTER TABLE M_COSTTYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_COSTTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_COSTTYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_COSTTYPE_UU,M_COSTTYPE_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_COSTTYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_COSTTYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_COSTTYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_COSTTYPE_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_COSTTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_COSTTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_DEMAND
ALTER TABLE M_DEMAND ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_DEMAND MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_DEMAND SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_DEMAND_UU,M_DEMAND_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_DEMAND MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_DEMAND_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_DEMAND SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_DEMAND_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_DEMAND MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_DEMAND DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_DEMANDDETAIL
ALTER TABLE M_DEMANDDETAIL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_DEMANDDETAIL SET tmp_col_1_tmp=M_DEMANDDETAIL_UU,M_DEMANDDETAIL_UU=NULL;
ALTER TABLE M_DEMANDDETAIL MODIFY (M_DEMANDDETAIL_UU VARCHAR2(36 CHAR));
UPDATE M_DEMANDDETAIL SET M_DEMANDDETAIL_UU=tmp_col_1_tmp;
ALTER TABLE M_DEMANDDETAIL DROP (tmp_col_1_tmp);

-- Processing table M_DEMANDLINE
ALTER TABLE M_DEMANDLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_DEMANDLINE SET tmp_col_1_tmp=M_DEMANDLINE_UU,M_DEMANDLINE_UU=NULL;
ALTER TABLE M_DEMANDLINE MODIFY (M_DEMANDLINE_UU VARCHAR2(36 CHAR));
UPDATE M_DEMANDLINE SET M_DEMANDLINE_UU=tmp_col_1_tmp;
ALTER TABLE M_DEMANDLINE DROP (tmp_col_1_tmp);

-- Processing table M_DISCOUNTSCHEMA
ALTER TABLE M_DISCOUNTSCHEMA ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR));
ALTER TABLE M_DISCOUNTSCHEMA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_DISCOUNTSCHEMA SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_DISCOUNTSCHEMA_UU,M_DISCOUNTSCHEMA_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=SCRIPT,SCRIPT=NULL;
ALTER TABLE M_DISCOUNTSCHEMA MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_DISCOUNTSCHEMA_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),SCRIPT VARCHAR2(2000 CHAR));
UPDATE M_DISCOUNTSCHEMA SET DESCRIPTION=tmp_col_1_tmp,M_DISCOUNTSCHEMA_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,SCRIPT=tmp_col_4_tmp;
ALTER TABLE M_DISCOUNTSCHEMA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_DISCOUNTSCHEMA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_DISCOUNTSCHEMABREAK
ALTER TABLE M_DISCOUNTSCHEMABREAK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_DISCOUNTSCHEMABREAK SET tmp_col_1_tmp=M_DISCOUNTSCHEMABREAK_UU,M_DISCOUNTSCHEMABREAK_UU=NULL;
ALTER TABLE M_DISCOUNTSCHEMABREAK MODIFY (M_DISCOUNTSCHEMABREAK_UU VARCHAR2(36 CHAR));
UPDATE M_DISCOUNTSCHEMABREAK SET M_DISCOUNTSCHEMABREAK_UU=tmp_col_1_tmp;
ALTER TABLE M_DISCOUNTSCHEMABREAK DROP (tmp_col_1_tmp);

-- Processing table M_DISCOUNTSCHEMALINE
ALTER TABLE M_DISCOUNTSCHEMALINE ADD (tmp_col_1_tmp VARCHAR2(12 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
UPDATE M_DISCOUNTSCHEMALINE SET tmp_col_1_tmp=CLASSIFICATION,CLASSIFICATION=NULL,tmp_col_2_tmp=GROUP1,GROUP1=NULL,tmp_col_3_tmp=GROUP2,GROUP2=NULL,tmp_col_4_tmp=M_DISCOUNTSCHEMALINE_UU,M_DISCOUNTSCHEMALINE_UU=NULL;
ALTER TABLE M_DISCOUNTSCHEMALINE MODIFY (CLASSIFICATION VARCHAR2(12 CHAR),GROUP1 VARCHAR2(255 CHAR),GROUP2 VARCHAR2(255 CHAR),M_DISCOUNTSCHEMALINE_UU VARCHAR2(36 CHAR));
UPDATE M_DISCOUNTSCHEMALINE SET CLASSIFICATION=tmp_col_1_tmp,GROUP1=tmp_col_2_tmp,GROUP2=tmp_col_3_tmp,M_DISCOUNTSCHEMALINE_UU=tmp_col_4_tmp;
ALTER TABLE M_DISCOUNTSCHEMALINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_DISTRIBUTIONLIST
ALTER TABLE M_DISTRIBUTIONLIST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_DISTRIBUTIONLIST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_DISTRIBUTIONLIST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_DISTRIBUTIONLIST_UU,M_DISTRIBUTIONLIST_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_DISTRIBUTIONLIST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_DISTRIBUTIONLIST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_DISTRIBUTIONLIST SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_DISTRIBUTIONLIST_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_DISTRIBUTIONLIST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_DISTRIBUTIONLIST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_DISTRIBUTIONLISTLINE
ALTER TABLE M_DISTRIBUTIONLISTLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_DISTRIBUTIONLISTLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_DISTRIBUTIONLISTLINE_UU,M_DISTRIBUTIONLISTLINE_UU=NULL;
ALTER TABLE M_DISTRIBUTIONLISTLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_DISTRIBUTIONLISTLINE_UU VARCHAR2(36 CHAR));
UPDATE M_DISTRIBUTIONLISTLINE SET DESCRIPTION=tmp_col_1_tmp,M_DISTRIBUTIONLISTLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_DISTRIBUTIONLISTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_DISTRIBUTIONRUN
ALTER TABLE M_DISTRIBUTIONRUN ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_DISTRIBUTIONRUN MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_DISTRIBUTIONRUN SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_DISTRIBUTIONRUN_UU,M_DISTRIBUTIONRUN_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_DISTRIBUTIONRUN MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_DISTRIBUTIONRUN_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_DISTRIBUTIONRUN SET DESCRIPTION=tmp_col_1_tmp,M_DISTRIBUTIONRUN_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_DISTRIBUTIONRUN MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_DISTRIBUTIONRUN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_DISTRIBUTIONRUNLINE
ALTER TABLE M_DISTRIBUTIONRUNLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_DISTRIBUTIONRUNLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_DISTRIBUTIONRUNLINE_UU,M_DISTRIBUTIONRUNLINE_UU=NULL;
ALTER TABLE M_DISTRIBUTIONRUNLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_DISTRIBUTIONRUNLINE_UU VARCHAR2(36 CHAR));
UPDATE M_DISTRIBUTIONRUNLINE SET DESCRIPTION=tmp_col_1_tmp,M_DISTRIBUTIONRUNLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_DISTRIBUTIONRUNLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_EDI
ALTER TABLE M_EDI ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR));
ALTER TABLE M_EDI MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_EDI SET tmp_col_1_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_2_tmp=REPLY_REMARKS,REPLY_REMARKS=NULL;
ALTER TABLE M_EDI MODIFY (DOCUMENTNO VARCHAR2(30 CHAR),REPLY_REMARKS VARCHAR2(2000 CHAR));
UPDATE M_EDI SET DOCUMENTNO=tmp_col_1_tmp,REPLY_REMARKS=tmp_col_2_tmp;
ALTER TABLE M_EDI MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_EDI DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_FORECAST
ALTER TABLE M_FORECAST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_FORECAST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_FORECAST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_FORECAST_UU,M_FORECAST_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_FORECAST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_FORECAST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_FORECAST SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_FORECAST_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_FORECAST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_FORECAST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_FORECASTLINE
ALTER TABLE M_FORECASTLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_FORECASTLINE SET tmp_col_1_tmp=M_FORECASTLINE_UU,M_FORECASTLINE_UU=NULL;
ALTER TABLE M_FORECASTLINE MODIFY (M_FORECASTLINE_UU VARCHAR2(36 CHAR));
UPDATE M_FORECASTLINE SET M_FORECASTLINE_UU=tmp_col_1_tmp;
ALTER TABLE M_FORECASTLINE DROP (tmp_col_1_tmp);

-- Processing table M_FREIGHT
ALTER TABLE M_FREIGHT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_FREIGHT SET tmp_col_1_tmp=M_FREIGHT_UU,M_FREIGHT_UU=NULL;
ALTER TABLE M_FREIGHT MODIFY (M_FREIGHT_UU VARCHAR2(36 CHAR));
UPDATE M_FREIGHT SET M_FREIGHT_UU=tmp_col_1_tmp;
ALTER TABLE M_FREIGHT DROP (tmp_col_1_tmp);

-- Processing table M_FREIGHTCATEGORY
ALTER TABLE M_FREIGHTCATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_FREIGHTCATEGORY MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_FREIGHTCATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_FREIGHTCATEGORY_UU,M_FREIGHTCATEGORY_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_FREIGHTCATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_FREIGHTCATEGORY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_FREIGHTCATEGORY SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_FREIGHTCATEGORY_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE M_FREIGHTCATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_FREIGHTCATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_INOUT
ALTER TABLE M_INOUT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(10 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(20 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_INOUT MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_INOUT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=FOB,FOB=NULL,tmp_col_4_tmp=FREIGHTCHARGES,FREIGHTCHARGES=NULL,tmp_col_5_tmp=M_INOUT_UU,M_INOUT_UU=NULL,tmp_col_6_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_7_tmp=SHIPPERACCOUNT,SHIPPERACCOUNT=NULL,tmp_col_8_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE M_INOUT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),FOB VARCHAR2(10 CHAR),FREIGHTCHARGES VARCHAR2(10 CHAR),M_INOUT_UU VARCHAR2(36 CHAR),POREFERENCE VARCHAR2(20 CHAR),SHIPPERACCOUNT VARCHAR2(40 CHAR),TRACKINGNO VARCHAR2(60 CHAR));
UPDATE M_INOUT SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,FOB=tmp_col_3_tmp,FREIGHTCHARGES=tmp_col_4_tmp,M_INOUT_UU=tmp_col_5_tmp,POREFERENCE=tmp_col_6_tmp,SHIPPERACCOUNT=tmp_col_7_tmp,TRACKINGNO=tmp_col_8_tmp;
ALTER TABLE M_INOUT MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_INOUT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table M_INOUTCONFIRM
ALTER TABLE M_INOUTCONFIRM ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_INOUTCONFIRM MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_INOUTCONFIRM SET tmp_col_1_tmp=CONFIRMATIONNO,CONFIRMATIONNO=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=M_INOUTCONFIRM_UU,M_INOUTCONFIRM_UU=NULL;
ALTER TABLE M_INOUTCONFIRM MODIFY (CONFIRMATIONNO VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_INOUTCONFIRM_UU VARCHAR2(36 CHAR));
UPDATE M_INOUTCONFIRM SET CONFIRMATIONNO=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,M_INOUTCONFIRM_UU=tmp_col_4_tmp;
ALTER TABLE M_INOUTCONFIRM MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_INOUTCONFIRM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_INOUTLINE
ALTER TABLE M_INOUTLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_INOUTLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_INOUTLINE_UU,M_INOUTLINE_UU=NULL;
ALTER TABLE M_INOUTLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_INOUTLINE_UU VARCHAR2(36 CHAR));
UPDATE M_INOUTLINE SET DESCRIPTION=tmp_col_1_tmp,M_INOUTLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_INOUTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_INOUTLINECONFIRM
ALTER TABLE M_INOUTLINECONFIRM ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE M_INOUTLINECONFIRM SET tmp_col_1_tmp=CONFIRMATIONNO,CONFIRMATIONNO=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=M_INOUTLINECONFIRM_UU,M_INOUTLINECONFIRM_UU=NULL;
ALTER TABLE M_INOUTLINECONFIRM MODIFY (CONFIRMATIONNO VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),M_INOUTLINECONFIRM_UU VARCHAR2(36 CHAR));
UPDATE M_INOUTLINECONFIRM SET CONFIRMATIONNO=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,M_INOUTLINECONFIRM_UU=tmp_col_3_tmp;
ALTER TABLE M_INOUTLINECONFIRM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_INOUTLINEMA
ALTER TABLE M_INOUTLINEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_INOUTLINEMA SET tmp_col_1_tmp=M_INOUTLINEMA_UU,M_INOUTLINEMA_UU=NULL;
ALTER TABLE M_INOUTLINEMA MODIFY (M_INOUTLINEMA_UU VARCHAR2(36 CHAR));
UPDATE M_INOUTLINEMA SET M_INOUTLINEMA_UU=tmp_col_1_tmp;
ALTER TABLE M_INOUTLINEMA DROP (tmp_col_1_tmp);

-- Processing table M_INVENTORY
ALTER TABLE M_INVENTORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_INVENTORY MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_INVENTORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_INVENTORY_UU,M_INVENTORY_UU=NULL;
ALTER TABLE M_INVENTORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_INVENTORY_UU VARCHAR2(36 CHAR));
UPDATE M_INVENTORY SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_INVENTORY_UU=tmp_col_3_tmp;
ALTER TABLE M_INVENTORY MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_INVENTORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_INVENTORYLINE
ALTER TABLE M_INVENTORYLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_INVENTORYLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_INVENTORYLINE_UU,M_INVENTORYLINE_UU=NULL;
ALTER TABLE M_INVENTORYLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_INVENTORYLINE_UU VARCHAR2(36 CHAR));
UPDATE M_INVENTORYLINE SET DESCRIPTION=tmp_col_1_tmp,M_INVENTORYLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_INVENTORYLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_INVENTORYLINEMA
ALTER TABLE M_INVENTORYLINEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_INVENTORYLINEMA SET tmp_col_1_tmp=M_INVENTORYLINEMA_UU,M_INVENTORYLINEMA_UU=NULL;
ALTER TABLE M_INVENTORYLINEMA MODIFY (M_INVENTORYLINEMA_UU VARCHAR2(36 CHAR));
UPDATE M_INVENTORYLINEMA SET M_INVENTORYLINEMA_UU=tmp_col_1_tmp;
ALTER TABLE M_INVENTORYLINEMA DROP (tmp_col_1_tmp);

-- Processing table M_LOCATOR
ALTER TABLE M_LOCATOR ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_LOCATOR MODIFY (VALUE NVARCHAR2(40) NULL);
UPDATE M_LOCATOR SET tmp_col_1_tmp=M_LOCATOR_UU,M_LOCATOR_UU=NULL,tmp_col_2_tmp=VALUE,VALUE=NULL,tmp_col_3_tmp=X,X=NULL,tmp_col_4_tmp=Y,Y=NULL,tmp_col_5_tmp=Z,Z=NULL;
ALTER TABLE M_LOCATOR MODIFY (M_LOCATOR_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR),X VARCHAR2(60 CHAR),Y VARCHAR2(60 CHAR),Z VARCHAR2(60 CHAR));
UPDATE M_LOCATOR SET M_LOCATOR_UU=tmp_col_1_tmp,VALUE=tmp_col_2_tmp,X=tmp_col_3_tmp,Y=tmp_col_4_tmp,Z=tmp_col_5_tmp;
ALTER TABLE M_LOCATOR MODIFY (VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_LOCATOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_LOT
ALTER TABLE M_LOT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_LOT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_LOT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_LOT_UU,M_LOT_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_LOT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_LOT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_LOT SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_LOT_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_LOT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_LOT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_LOTCTL
ALTER TABLE M_LOTCTL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(10 CHAR));
ALTER TABLE M_LOTCTL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_LOTCTL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_LOTCTL_UU,M_LOTCTL_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PREFIX,PREFIX=NULL,tmp_col_5_tmp=SUFFIX,SUFFIX=NULL;
ALTER TABLE M_LOTCTL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_LOTCTL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PREFIX VARCHAR2(10 CHAR),SUFFIX VARCHAR2(10 CHAR));
UPDATE M_LOTCTL SET DESCRIPTION=tmp_col_1_tmp,M_LOTCTL_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PREFIX=tmp_col_4_tmp,SUFFIX=tmp_col_5_tmp;
ALTER TABLE M_LOTCTL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_LOTCTL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_LOTCTLEXCLUDE
ALTER TABLE M_LOTCTLEXCLUDE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_LOTCTLEXCLUDE SET tmp_col_1_tmp=M_LOTCTLEXCLUDE_UU,M_LOTCTLEXCLUDE_UU=NULL;
ALTER TABLE M_LOTCTLEXCLUDE MODIFY (M_LOTCTLEXCLUDE_UU VARCHAR2(36 CHAR));
UPDATE M_LOTCTLEXCLUDE SET M_LOTCTLEXCLUDE_UU=tmp_col_1_tmp;
ALTER TABLE M_LOTCTLEXCLUDE DROP (tmp_col_1_tmp);

-- Processing table M_MATCHINV
ALTER TABLE M_MATCHINV ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE M_MATCHINV SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_MATCHINV_UU,M_MATCHINV_UU=NULL;
ALTER TABLE M_MATCHINV MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_MATCHINV_UU VARCHAR2(36 CHAR));
UPDATE M_MATCHINV SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_MATCHINV_UU=tmp_col_3_tmp;
ALTER TABLE M_MATCHINV DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_MATCHPO
ALTER TABLE M_MATCHPO ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE M_MATCHPO SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_MATCHPO_UU,M_MATCHPO_UU=NULL;
ALTER TABLE M_MATCHPO MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_MATCHPO_UU VARCHAR2(36 CHAR));
UPDATE M_MATCHPO SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_MATCHPO_UU=tmp_col_3_tmp;
ALTER TABLE M_MATCHPO DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_MOVEMENT
ALTER TABLE M_MOVEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(20 CHAR));
ALTER TABLE M_MOVEMENT MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_MOVEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_MOVEMENT_UU,M_MOVEMENT_UU=NULL,tmp_col_4_tmp=POREFERENCE,POREFERENCE=NULL;
ALTER TABLE M_MOVEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_MOVEMENT_UU VARCHAR2(36 CHAR),POREFERENCE VARCHAR2(20 CHAR));
UPDATE M_MOVEMENT SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_MOVEMENT_UU=tmp_col_3_tmp,POREFERENCE=tmp_col_4_tmp;
ALTER TABLE M_MOVEMENT MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_MOVEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_MOVEMENTCONFIRM
ALTER TABLE M_MOVEMENTCONFIRM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_MOVEMENTCONFIRM MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_MOVEMENTCONFIRM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_MOVEMENTCONFIRM_UU,M_MOVEMENTCONFIRM_UU=NULL;
ALTER TABLE M_MOVEMENTCONFIRM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_MOVEMENTCONFIRM_UU VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTCONFIRM SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_MOVEMENTCONFIRM_UU=tmp_col_3_tmp;
ALTER TABLE M_MOVEMENTCONFIRM MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_MOVEMENTCONFIRM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_MOVEMENTLINE
ALTER TABLE M_MOVEMENTLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_MOVEMENTLINE_UU,M_MOVEMENTLINE_UU=NULL;
ALTER TABLE M_MOVEMENTLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_MOVEMENTLINE_UU VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINE SET DESCRIPTION=tmp_col_1_tmp,M_MOVEMENTLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_MOVEMENTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_MOVEMENTLINECONFIRM
ALTER TABLE M_MOVEMENTLINECONFIRM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINECONFIRM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_MOVEMENTLINECONFIRM_UU,M_MOVEMENTLINECONFIRM_UU=NULL;
ALTER TABLE M_MOVEMENTLINECONFIRM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_MOVEMENTLINECONFIRM_UU VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINECONFIRM SET DESCRIPTION=tmp_col_1_tmp,M_MOVEMENTLINECONFIRM_UU=tmp_col_2_tmp;
ALTER TABLE M_MOVEMENTLINECONFIRM DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_MOVEMENTLINEMA
ALTER TABLE M_MOVEMENTLINEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINEMA SET tmp_col_1_tmp=M_MOVEMENTLINEMA_UU,M_MOVEMENTLINEMA_UU=NULL;
ALTER TABLE M_MOVEMENTLINEMA MODIFY (M_MOVEMENTLINEMA_UU VARCHAR2(36 CHAR));
UPDATE M_MOVEMENTLINEMA SET M_MOVEMENTLINEMA_UU=tmp_col_1_tmp;
ALTER TABLE M_MOVEMENTLINEMA DROP (tmp_col_1_tmp);

-- Processing table M_OPERATIONRESOURCE
ALTER TABLE M_OPERATIONRESOURCE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_OPERATIONRESOURCE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_OPERATIONRESOURCE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_OPERATIONRESOURCE_UU,M_OPERATIONRESOURCE_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_OPERATIONRESOURCE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_OPERATIONRESOURCE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_OPERATIONRESOURCE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_OPERATIONRESOURCE_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_OPERATIONRESOURCE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_OPERATIONRESOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PACKAGE
ALTER TABLE M_PACKAGE ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(30 CHAR),tmp_col_7_tmp VARCHAR2(30 CHAR),tmp_col_8_tmp VARCHAR2(36 CHAR),tmp_col_9_tmp VARCHAR2(255 CHAR),tmp_col_10_tmp VARCHAR2(2 CHAR),tmp_col_11_tmp VARCHAR2(2000 CHAR),tmp_col_12_tmp VARCHAR2(255 CHAR),tmp_col_13_tmp VARCHAR2(40 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(255 CHAR));
ALTER TABLE M_PACKAGE MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_PACKAGE SET tmp_col_1_tmp=DELIVERYCONFIRMATIONTYPE,DELIVERYCONFIRMATIONTYPE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=DOTHAZARDCLASSORDIVISION,DOTHAZARDCLASSORDIVISION=NULL,tmp_col_5_tmp=DUTIESSHIPPERACCOUNT,DUTIESSHIPPERACCOUNT=NULL,tmp_col_6_tmp=HOMEDELIVERYPREMIUMPHONE,HOMEDELIVERYPREMIUMPHONE=NULL,tmp_col_7_tmp=HOMEDELIVERYPREMIUMTYPE,HOMEDELIVERYPREMIUMTYPE=NULL,tmp_col_8_tmp=M_PACKAGE_UU,M_PACKAGE_UU=NULL,tmp_col_9_tmp=NOTIFICATIONMESSAGE,NOTIFICATIONMESSAGE=NULL,tmp_col_10_tmp=NOTIFICATIONTYPE,NOTIFICATIONTYPE=NULL,tmp_col_11_tmp=RATEINQUIRYMESSAGE,RATEINQUIRYMESSAGE=NULL,tmp_col_12_tmp=RECEIVEDINFO,RECEIVEDINFO=NULL,tmp_col_13_tmp=SHIPPERACCOUNT,SHIPPERACCOUNT=NULL,tmp_col_14_tmp=SHIPPINGRESPMESSAGE,SHIPPINGRESPMESSAGE=NULL,tmp_col_15_tmp=TRACKINGINFO,TRACKINGINFO=NULL,tmp_col_16_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE M_PACKAGE MODIFY (DELIVERYCONFIRMATIONTYPE VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),DOTHAZARDCLASSORDIVISION VARCHAR2(30 CHAR),DUTIESSHIPPERACCOUNT VARCHAR2(40 CHAR),HOMEDELIVERYPREMIUMPHONE VARCHAR2(30 CHAR),HOMEDELIVERYPREMIUMTYPE VARCHAR2(30 CHAR),M_PACKAGE_UU VARCHAR2(36 CHAR),NOTIFICATIONMESSAGE VARCHAR2(255 CHAR),NOTIFICATIONTYPE VARCHAR2(2 CHAR),RATEINQUIRYMESSAGE VARCHAR2(2000 CHAR),RECEIVEDINFO VARCHAR2(255 CHAR),SHIPPERACCOUNT VARCHAR2(40 CHAR),SHIPPINGRESPMESSAGE VARCHAR2(2000 CHAR),TRACKINGINFO VARCHAR2(255 CHAR),TRACKINGNO VARCHAR2(255 CHAR));
UPDATE M_PACKAGE SET DELIVERYCONFIRMATIONTYPE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,DOTHAZARDCLASSORDIVISION=tmp_col_4_tmp,DUTIESSHIPPERACCOUNT=tmp_col_5_tmp,HOMEDELIVERYPREMIUMPHONE=tmp_col_6_tmp,HOMEDELIVERYPREMIUMTYPE=tmp_col_7_tmp,M_PACKAGE_UU=tmp_col_8_tmp,NOTIFICATIONMESSAGE=tmp_col_9_tmp,NOTIFICATIONTYPE=tmp_col_10_tmp,RATEINQUIRYMESSAGE=tmp_col_11_tmp,RECEIVEDINFO=tmp_col_12_tmp,SHIPPERACCOUNT=tmp_col_13_tmp,SHIPPINGRESPMESSAGE=tmp_col_14_tmp,TRACKINGINFO=tmp_col_15_tmp,TRACKINGNO=tmp_col_16_tmp;
ALTER TABLE M_PACKAGE MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_PACKAGE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp);

-- Processing table M_PACKAGELINE
ALTER TABLE M_PACKAGELINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_PACKAGELINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PACKAGELINE_UU,M_PACKAGELINE_UU=NULL;
ALTER TABLE M_PACKAGELINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PACKAGELINE_UU VARCHAR2(36 CHAR));
UPDATE M_PACKAGELINE SET DESCRIPTION=tmp_col_1_tmp,M_PACKAGELINE_UU=tmp_col_2_tmp;
ALTER TABLE M_PACKAGELINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PACKAGEMPS
ALTER TABLE M_PACKAGEMPS ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE M_PACKAGEMPS SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=MASTERTRACKINGNO,MASTERTRACKINGNO=NULL,tmp_col_3_tmp=M_PACKAGEMPS_UU,M_PACKAGEMPS_UU=NULL,tmp_col_4_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE M_PACKAGEMPS MODIFY (DESCRIPTION VARCHAR2(255 CHAR),MASTERTRACKINGNO VARCHAR2(255 CHAR),M_PACKAGEMPS_UU VARCHAR2(36 CHAR),TRACKINGNO VARCHAR2(255 CHAR));
UPDATE M_PACKAGEMPS SET DESCRIPTION=tmp_col_1_tmp,MASTERTRACKINGNO=tmp_col_2_tmp,M_PACKAGEMPS_UU=tmp_col_3_tmp,TRACKINGNO=tmp_col_4_tmp;
ALTER TABLE M_PACKAGEMPS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PARTTYPE
ALTER TABLE M_PARTTYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR));
ALTER TABLE M_PARTTYPE MODIFY (NAME NVARCHAR2(255) NULL);
UPDATE M_PARTTYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PARTTYPE_UU,M_PARTTYPE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PARTTYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PARTTYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(255 CHAR));
UPDATE M_PARTTYPE SET DESCRIPTION=tmp_col_1_tmp,M_PARTTYPE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PARTTYPE MODIFY (NAME VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE M_PARTTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PERPETUALINV
ALTER TABLE M_PERPETUALINV ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PERPETUALINV MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PERPETUALINV SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PERPETUALINV_UU,M_PERPETUALINV_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PERPETUALINV MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PERPETUALINV_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PERPETUALINV SET DESCRIPTION=tmp_col_1_tmp,M_PERPETUALINV_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PERPETUALINV MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PERPETUALINV DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PRICELIST
ALTER TABLE M_PRICELIST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRICELIST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRICELIST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRICELIST_UU,M_PRICELIST_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRICELIST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRICELIST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRICELIST SET DESCRIPTION=tmp_col_1_tmp,M_PRICELIST_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PRICELIST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRICELIST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PRICELIST_TRL
ALTER TABLE M_PRICELIST_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRICELIST_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRICELIST_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRICELIST_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRICELIST_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_PRICELIST_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRICELIST_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRICELIST_VERSION
ALTER TABLE M_PRICELIST_VERSION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRICELIST_VERSION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRICELIST_VERSION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRICELIST_VERSION_UU,M_PRICELIST_VERSION_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRICELIST_VERSION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRICELIST_VERSION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRICELIST_VERSION SET DESCRIPTION=tmp_col_1_tmp,M_PRICELIST_VERSION_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PRICELIST_VERSION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRICELIST_VERSION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PRICELIST_VERSION_TRL
ALTER TABLE M_PRICELIST_VERSION_TRL ADD (tmp_col_1_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRICELIST_VERSION_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRICELIST_VERSION_TRL SET tmp_col_1_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRICELIST_VERSION_TRL MODIFY (NAME VARCHAR2(60 CHAR));
UPDATE M_PRICELIST_VERSION_TRL SET NAME=tmp_col_1_tmp;
ALTER TABLE M_PRICELIST_VERSION_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRICELIST_VERSION_TRL DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCT
ALTER TABLE M_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(12 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(120 CHAR),tmp_col_10_tmp VARCHAR2(36 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(510 CHAR),tmp_col_13_tmp VARCHAR2(20 CHAR));
ALTER TABLE M_PRODUCT MODIFY (NAME NVARCHAR2(255) NULL,VALUE NVARCHAR2(510) NULL);
UPDATE M_PRODUCT SET tmp_col_1_tmp=CLASSIFICATION,CLASSIFICATION=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DESCRIPTIONURL,DESCRIPTIONURL=NULL,tmp_col_4_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_5_tmp=DOWNLOADURL,DOWNLOADURL=NULL,tmp_col_6_tmp=GROUP1,GROUP1=NULL,tmp_col_7_tmp=GROUP2,GROUP2=NULL,tmp_col_8_tmp=HELP,HELP=NULL,tmp_col_9_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_10_tmp=M_PRODUCT_UU,M_PRODUCT_UU=NULL,tmp_col_11_tmp=NAME,NAME=NULL,tmp_col_12_tmp=VALUE,VALUE=NULL,tmp_col_13_tmp=VERSIONNO,VERSIONNO=NULL;
ALTER TABLE M_PRODUCT MODIFY (CLASSIFICATION VARCHAR2(12 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DESCRIPTIONURL VARCHAR2(120 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),DOWNLOADURL VARCHAR2(120 CHAR),GROUP1 VARCHAR2(255 CHAR),GROUP2 VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),IMAGEURL VARCHAR2(120 CHAR),M_PRODUCT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(255 CHAR) DEFAULT NULL ,VALUE VARCHAR2(510 CHAR),VERSIONNO VARCHAR2(20 CHAR));
UPDATE M_PRODUCT SET CLASSIFICATION=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DESCRIPTIONURL=tmp_col_3_tmp,DOCUMENTNOTE=tmp_col_4_tmp,DOWNLOADURL=tmp_col_5_tmp,GROUP1=tmp_col_6_tmp,GROUP2=tmp_col_7_tmp,HELP=tmp_col_8_tmp,IMAGEURL=tmp_col_9_tmp,M_PRODUCT_UU=tmp_col_10_tmp,NAME=tmp_col_11_tmp,VALUE=tmp_col_12_tmp,VERSIONNO=tmp_col_13_tmp;
ALTER TABLE M_PRODUCT MODIFY (NAME VARCHAR2(255 CHAR) DEFAULT NULL  NOT NULL,VALUE VARCHAR2(510 CHAR) NOT NULL);
ALTER TABLE M_PRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp);

-- Processing table M_PRODUCTDOWNLOAD
ALTER TABLE M_PRODUCTDOWNLOAD ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRODUCTDOWNLOAD MODIFY (DOWNLOADURL NVARCHAR2(120) NULL,NAME NVARCHAR2(60) NULL);
UPDATE M_PRODUCTDOWNLOAD SET tmp_col_1_tmp=DOWNLOADURL,DOWNLOADURL=NULL,tmp_col_2_tmp=M_PRODUCTDOWNLOAD_UU,M_PRODUCTDOWNLOAD_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRODUCTDOWNLOAD MODIFY (DOWNLOADURL VARCHAR2(120 CHAR),M_PRODUCTDOWNLOAD_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRODUCTDOWNLOAD SET DOWNLOADURL=tmp_col_1_tmp,M_PRODUCTDOWNLOAD_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PRODUCTDOWNLOAD MODIFY (DOWNLOADURL VARCHAR2(120 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRODUCTDOWNLOAD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PRODUCTION
ALTER TABLE M_PRODUCTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRODUCTION MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_PRODUCTION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=M_PRODUCTION_UU,M_PRODUCTION_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRODUCTION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),M_PRODUCTION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRODUCTION SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,M_PRODUCTION_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_PRODUCTION MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_PRODUCTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PRODUCTIONLINE
ALTER TABLE M_PRODUCTIONLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRODUCTIONLINE_UU,M_PRODUCTIONLINE_UU=NULL;
ALTER TABLE M_PRODUCTIONLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRODUCTIONLINE_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONLINE SET DESCRIPTION=tmp_col_1_tmp,M_PRODUCTIONLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_PRODUCTIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRODUCTIONLINEMA
ALTER TABLE M_PRODUCTIONLINEMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONLINEMA SET tmp_col_1_tmp=M_PRODUCTIONLINEMA_UU,M_PRODUCTIONLINEMA_UU=NULL;
ALTER TABLE M_PRODUCTIONLINEMA MODIFY (M_PRODUCTIONLINEMA_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONLINEMA SET M_PRODUCTIONLINEMA_UU=tmp_col_1_tmp;
ALTER TABLE M_PRODUCTIONLINEMA DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCTIONPLAN
ALTER TABLE M_PRODUCTIONPLAN ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONPLAN SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRODUCTIONPLAN_UU,M_PRODUCTIONPLAN_UU=NULL;
ALTER TABLE M_PRODUCTIONPLAN MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRODUCTIONPLAN_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCTIONPLAN SET DESCRIPTION=tmp_col_1_tmp,M_PRODUCTIONPLAN_UU=tmp_col_2_tmp;
ALTER TABLE M_PRODUCTIONPLAN DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRODUCTOPERATION
ALTER TABLE M_PRODUCTOPERATION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRODUCTOPERATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRODUCTOPERATION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_PRODUCTOPERATION_UU,M_PRODUCTOPERATION_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRODUCTOPERATION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_PRODUCTOPERATION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRODUCTOPERATION SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_PRODUCTOPERATION_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_PRODUCTOPERATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRODUCTOPERATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PRODUCTPRICE
ALTER TABLE M_PRODUCTPRICE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCTPRICE SET tmp_col_1_tmp=M_PRODUCTPRICE_UU,M_PRODUCTPRICE_UU=NULL;
ALTER TABLE M_PRODUCTPRICE MODIFY (M_PRODUCTPRICE_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCTPRICE SET M_PRODUCTPRICE_UU=tmp_col_1_tmp;
ALTER TABLE M_PRODUCTPRICE DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCTPRICEVENDORBREAK
ALTER TABLE M_PRODUCTPRICEVENDORBREAK ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCTPRICEVENDORBREAK SET tmp_col_1_tmp=M_PRODUCTPRICEVENDORBREAK_UU,M_PRODUCTPRICEVENDORBREAK_UU=NULL;
ALTER TABLE M_PRODUCTPRICEVENDORBREAK MODIFY (M_PRODUCTPRICEVENDORBREAK_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCTPRICEVENDORBREAK SET M_PRODUCTPRICEVENDORBREAK_UU=tmp_col_1_tmp;
ALTER TABLE M_PRODUCTPRICEVENDORBREAK DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCT_ACCT
ALTER TABLE M_PRODUCT_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_ACCT SET tmp_col_1_tmp=M_PRODUCT_ACCT_UU,M_PRODUCT_ACCT_UU=NULL;
ALTER TABLE M_PRODUCT_ACCT MODIFY (M_PRODUCT_ACCT_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_ACCT SET M_PRODUCT_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE M_PRODUCT_ACCT DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCT_BOM
ALTER TABLE M_PRODUCT_BOM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_BOM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRODUCT_BOM_UU,M_PRODUCT_BOM_UU=NULL;
ALTER TABLE M_PRODUCT_BOM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRODUCT_BOM_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_BOM SET DESCRIPTION=tmp_col_1_tmp,M_PRODUCT_BOM_UU=tmp_col_2_tmp;
ALTER TABLE M_PRODUCT_BOM DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRODUCT_CATEGORY
ALTER TABLE M_PRODUCT_CATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_PRODUCT_CATEGORY MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_PRODUCT_CATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PRODUCT_CATEGORY_UU,M_PRODUCT_CATEGORY_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_PRODUCT_CATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PRODUCT_CATEGORY_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_PRODUCT_CATEGORY SET DESCRIPTION=tmp_col_1_tmp,M_PRODUCT_CATEGORY_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE M_PRODUCT_CATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_PRODUCT_CATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PRODUCT_CATEGORY_ACCT
ALTER TABLE M_PRODUCT_CATEGORY_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_CATEGORY_ACCT SET tmp_col_1_tmp=M_PRODUCT_CATEGORY_ACCT_UU,M_PRODUCT_CATEGORY_ACCT_UU=NULL;
ALTER TABLE M_PRODUCT_CATEGORY_ACCT MODIFY (M_PRODUCT_CATEGORY_ACCT_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_CATEGORY_ACCT SET M_PRODUCT_CATEGORY_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE M_PRODUCT_CATEGORY_ACCT DROP (tmp_col_1_tmp);

-- Processing table M_PRODUCT_CATEGORY_TRL
ALTER TABLE M_PRODUCT_CATEGORY_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PRODUCT_CATEGORY_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PRODUCT_CATEGORY_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRODUCT_CATEGORY_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PRODUCT_CATEGORY_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_PRODUCT_CATEGORY_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PRODUCT_CATEGORY_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRODUCT_PO
ALTER TABLE M_PRODUCT_PO ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_PRODUCT_PO MODIFY (VENDORPRODUCTNO NVARCHAR2(40) NULL);
UPDATE M_PRODUCT_PO SET tmp_col_1_tmp=M_PRODUCT_PO_UU,M_PRODUCT_PO_UU=NULL,tmp_col_2_tmp=UPC,UPC=NULL,tmp_col_3_tmp=VENDORPRODUCTNO,VENDORPRODUCTNO=NULL;
ALTER TABLE M_PRODUCT_PO MODIFY (M_PRODUCT_PO_UU VARCHAR2(36 CHAR),UPC VARCHAR2(20 CHAR),VENDORPRODUCTNO VARCHAR2(40 CHAR));
UPDATE M_PRODUCT_PO SET M_PRODUCT_PO_UU=tmp_col_1_tmp,UPC=tmp_col_2_tmp,VENDORPRODUCTNO=tmp_col_3_tmp;
ALTER TABLE M_PRODUCT_PO MODIFY (VENDORPRODUCTNO VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_PRODUCT_PO DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PRODUCT_QUALITYTEST
ALTER TABLE M_PRODUCT_QUALITYTEST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_PRODUCT_QUALITYTEST MODIFY (EXPECTEDRESULT NVARCHAR2(255) NULL);
UPDATE M_PRODUCT_QUALITYTEST SET tmp_col_1_tmp=EXPECTEDRESULT,EXPECTEDRESULT=NULL,tmp_col_2_tmp=M_PRODUCT_QUALITYTEST_UU,M_PRODUCT_QUALITYTEST_UU=NULL;
ALTER TABLE M_PRODUCT_QUALITYTEST MODIFY (EXPECTEDRESULT VARCHAR2(255 CHAR),M_PRODUCT_QUALITYTEST_UU VARCHAR2(36 CHAR));
UPDATE M_PRODUCT_QUALITYTEST SET EXPECTEDRESULT=tmp_col_1_tmp,M_PRODUCT_QUALITYTEST_UU=tmp_col_2_tmp;
ALTER TABLE M_PRODUCT_QUALITYTEST MODIFY (EXPECTEDRESULT VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE M_PRODUCT_QUALITYTEST DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PRODUCT_TRL
ALTER TABLE M_PRODUCT_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
ALTER TABLE M_PRODUCT_TRL MODIFY (NAME NVARCHAR2(255) NULL);
UPDATE M_PRODUCT_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_3_tmp=M_PRODUCT_TRL_UU,M_PRODUCT_TRL_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_PRODUCT_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),M_PRODUCT_TRL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(255 CHAR) DEFAULT NULL );
UPDATE M_PRODUCT_TRL SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNOTE=tmp_col_2_tmp,M_PRODUCT_TRL_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_PRODUCT_TRL MODIFY (NAME VARCHAR2(255 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE M_PRODUCT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_PROMOTION
ALTER TABLE M_PROMOTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PROMOTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PROMOTION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PROMOTION_UU,M_PROMOTION_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PROMOTION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PROMOTION_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PROMOTION SET DESCRIPTION=tmp_col_1_tmp,M_PROMOTION_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PROMOTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PROMOTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PROMOTIONDISTRIBUTION
ALTER TABLE M_PROMOTIONDISTRIBUTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR));
ALTER TABLE M_PROMOTIONDISTRIBUTION MODIFY (OPERATION NVARCHAR2(2) NULL);
UPDATE M_PROMOTIONDISTRIBUTION SET tmp_col_1_tmp=M_PROMOTIONDISTRIBUTION_UU,M_PROMOTIONDISTRIBUTION_UU=NULL,tmp_col_2_tmp=OPERATION,OPERATION=NULL;
ALTER TABLE M_PROMOTIONDISTRIBUTION MODIFY (M_PROMOTIONDISTRIBUTION_UU VARCHAR2(36 CHAR),OPERATION VARCHAR2(2 CHAR));
UPDATE M_PROMOTIONDISTRIBUTION SET M_PROMOTIONDISTRIBUTION_UU=tmp_col_1_tmp,OPERATION=tmp_col_2_tmp;
ALTER TABLE M_PROMOTIONDISTRIBUTION MODIFY (OPERATION VARCHAR2(2 CHAR) NOT NULL);
ALTER TABLE M_PROMOTIONDISTRIBUTION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PROMOTIONGROUP
ALTER TABLE M_PROMOTIONGROUP ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_PROMOTIONGROUP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_PROMOTIONGROUP SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_PROMOTIONGROUP_UU,M_PROMOTIONGROUP_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_PROMOTIONGROUP MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_PROMOTIONGROUP_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_PROMOTIONGROUP SET DESCRIPTION=tmp_col_1_tmp,M_PROMOTIONGROUP_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_PROMOTIONGROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_PROMOTIONGROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_PROMOTIONGROUPLINE
ALTER TABLE M_PROMOTIONGROUPLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONGROUPLINE SET tmp_col_1_tmp=M_PROMOTIONGROUPLINE_UU,M_PROMOTIONGROUPLINE_UU=NULL;
ALTER TABLE M_PROMOTIONGROUPLINE MODIFY (M_PROMOTIONGROUPLINE_UU VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONGROUPLINE SET M_PROMOTIONGROUPLINE_UU=tmp_col_1_tmp;
ALTER TABLE M_PROMOTIONGROUPLINE DROP (tmp_col_1_tmp);

-- Processing table M_PROMOTIONLINE
ALTER TABLE M_PROMOTIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONLINE SET tmp_col_1_tmp=M_PROMOTIONLINE_UU,M_PROMOTIONLINE_UU=NULL;
ALTER TABLE M_PROMOTIONLINE MODIFY (M_PROMOTIONLINE_UU VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONLINE SET M_PROMOTIONLINE_UU=tmp_col_1_tmp;
ALTER TABLE M_PROMOTIONLINE DROP (tmp_col_1_tmp);

-- Processing table M_PROMOTIONPRECONDITION
ALTER TABLE M_PROMOTIONPRECONDITION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR));
UPDATE M_PROMOTIONPRECONDITION SET tmp_col_1_tmp=M_PROMOTIONPRECONDITION_UU,M_PROMOTIONPRECONDITION_UU=NULL,tmp_col_2_tmp=PROMOTIONCODE,PROMOTIONCODE=NULL;
ALTER TABLE M_PROMOTIONPRECONDITION MODIFY (M_PROMOTIONPRECONDITION_UU VARCHAR2(36 CHAR),PROMOTIONCODE VARCHAR2(30 CHAR));
UPDATE M_PROMOTIONPRECONDITION SET M_PROMOTIONPRECONDITION_UU=tmp_col_1_tmp,PROMOTIONCODE=tmp_col_2_tmp;
ALTER TABLE M_PROMOTIONPRECONDITION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_PROMOTIONREWARD
ALTER TABLE M_PROMOTIONREWARD ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONREWARD SET tmp_col_1_tmp=M_PROMOTIONREWARD_UU,M_PROMOTIONREWARD_UU=NULL;
ALTER TABLE M_PROMOTIONREWARD MODIFY (M_PROMOTIONREWARD_UU VARCHAR2(36 CHAR));
UPDATE M_PROMOTIONREWARD SET M_PROMOTIONREWARD_UU=tmp_col_1_tmp;
ALTER TABLE M_PROMOTIONREWARD DROP (tmp_col_1_tmp);

-- Processing table M_QUALITYTEST
ALTER TABLE M_QUALITYTEST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_QUALITYTEST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_QUALITYTEST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_QUALITYTEST_UU,M_QUALITYTEST_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_QUALITYTEST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_QUALITYTEST_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_QUALITYTEST SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_QUALITYTEST_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_QUALITYTEST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_QUALITYTEST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_QUALITYTESTRESULT
ALTER TABLE M_QUALITYTESTRESULT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE M_QUALITYTESTRESULT SET tmp_col_1_tmp=M_QUALITYTESTRESULT_UU,M_QUALITYTESTRESULT_UU=NULL,tmp_col_2_tmp=RESULT,RESULT=NULL;
ALTER TABLE M_QUALITYTESTRESULT MODIFY (M_QUALITYTESTRESULT_UU VARCHAR2(36 CHAR),RESULT VARCHAR2(255 CHAR));
UPDATE M_QUALITYTESTRESULT SET M_QUALITYTESTRESULT_UU=tmp_col_1_tmp,RESULT=tmp_col_2_tmp;
ALTER TABLE M_QUALITYTESTRESULT DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_RELATEDPRODUCT
ALTER TABLE M_RELATEDPRODUCT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_RELATEDPRODUCT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_RELATEDPRODUCT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_RELATEDPRODUCT_UU,M_RELATEDPRODUCT_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_RELATEDPRODUCT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_RELATEDPRODUCT_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_RELATEDPRODUCT SET DESCRIPTION=tmp_col_1_tmp,M_RELATEDPRODUCT_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_RELATEDPRODUCT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_RELATEDPRODUCT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_REPLENISH
ALTER TABLE M_REPLENISH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_REPLENISH SET tmp_col_1_tmp=M_REPLENISH_UU,M_REPLENISH_UU=NULL;
ALTER TABLE M_REPLENISH MODIFY (M_REPLENISH_UU VARCHAR2(36 CHAR));
UPDATE M_REPLENISH SET M_REPLENISH_UU=tmp_col_1_tmp;
ALTER TABLE M_REPLENISH DROP (tmp_col_1_tmp);

-- Processing table M_REQUISITION
ALTER TABLE M_REQUISITION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE M_REQUISITION MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE M_REQUISITION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=M_REQUISITION_UU,M_REQUISITION_UU=NULL;
ALTER TABLE M_REQUISITION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),HELP VARCHAR2(2000 CHAR),M_REQUISITION_UU VARCHAR2(36 CHAR));
UPDATE M_REQUISITION SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,HELP=tmp_col_3_tmp,M_REQUISITION_UU=tmp_col_4_tmp;
ALTER TABLE M_REQUISITION MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE M_REQUISITION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_REQUISITIONLINE
ALTER TABLE M_REQUISITIONLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_REQUISITIONLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_REQUISITIONLINE_UU,M_REQUISITIONLINE_UU=NULL;
ALTER TABLE M_REQUISITIONLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_REQUISITIONLINE_UU VARCHAR2(36 CHAR));
UPDATE M_REQUISITIONLINE SET DESCRIPTION=tmp_col_1_tmp,M_REQUISITIONLINE_UU=tmp_col_2_tmp;
ALTER TABLE M_REQUISITIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_RMA
ALTER TABLE M_RMA ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_RMA MODIFY (DOCUMENTNO NVARCHAR2(30) NULL,NAME NVARCHAR2(60) NULL);
UPDATE M_RMA SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=M_RMA_UU,M_RMA_UU=NULL,tmp_col_5_tmp=NAME,NAME=NULL;
ALTER TABLE M_RMA MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),HELP VARCHAR2(2000 CHAR),M_RMA_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_RMA SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,HELP=tmp_col_3_tmp,M_RMA_UU=tmp_col_4_tmp,NAME=tmp_col_5_tmp;
ALTER TABLE M_RMA MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_RMA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_RMALINE
ALTER TABLE M_RMALINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE M_RMALINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_RMALINE_UU,M_RMALINE_UU=NULL;
ALTER TABLE M_RMALINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_RMALINE_UU VARCHAR2(36 CHAR));
UPDATE M_RMALINE SET DESCRIPTION=tmp_col_1_tmp,M_RMALINE_UU=tmp_col_2_tmp;
ALTER TABLE M_RMALINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_RMATAX
ALTER TABLE M_RMATAX ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_RMATAX SET tmp_col_1_tmp=M_RMATAX_UU,M_RMATAX_UU=NULL;
ALTER TABLE M_RMATAX MODIFY (M_RMATAX_UU VARCHAR2(36 CHAR));
UPDATE M_RMATAX SET M_RMATAX_UU=tmp_col_1_tmp;
ALTER TABLE M_RMATAX DROP (tmp_col_1_tmp);

-- Processing table M_RMATYPE
ALTER TABLE M_RMATYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_RMATYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_RMATYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=M_RMATYPE_UU,M_RMATYPE_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL;
ALTER TABLE M_RMATYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),M_RMATYPE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_RMATYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,M_RMATYPE_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp;
ALTER TABLE M_RMATYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_RMATYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_SERNOCTL
ALTER TABLE M_SERNOCTL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(10 CHAR),tmp_col_5_tmp VARCHAR2(10 CHAR));
ALTER TABLE M_SERNOCTL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SERNOCTL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SERNOCTL_UU,M_SERNOCTL_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PREFIX,PREFIX=NULL,tmp_col_5_tmp=SUFFIX,SUFFIX=NULL;
ALTER TABLE M_SERNOCTL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SERNOCTL_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PREFIX VARCHAR2(10 CHAR),SUFFIX VARCHAR2(10 CHAR));
UPDATE M_SERNOCTL SET DESCRIPTION=tmp_col_1_tmp,M_SERNOCTL_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PREFIX=tmp_col_4_tmp,SUFFIX=tmp_col_5_tmp;
ALTER TABLE M_SERNOCTL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_SERNOCTL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_SERNOCTLEXCLUDE
ALTER TABLE M_SERNOCTLEXCLUDE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_SERNOCTLEXCLUDE SET tmp_col_1_tmp=M_SERNOCTLEXCLUDE_UU,M_SERNOCTLEXCLUDE_UU=NULL;
ALTER TABLE M_SERNOCTLEXCLUDE MODIFY (M_SERNOCTLEXCLUDE_UU VARCHAR2(36 CHAR));
UPDATE M_SERNOCTLEXCLUDE SET M_SERNOCTLEXCLUDE_UU=tmp_col_1_tmp;
ALTER TABLE M_SERNOCTLEXCLUDE DROP (tmp_col_1_tmp);

-- Processing table M_SHIPPER
ALTER TABLE M_SHIPPER ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPER MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPER SET tmp_col_1_tmp=M_SHIPPER_UU,M_SHIPPER_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_SHIPPER MODIFY (M_SHIPPER_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL );
UPDATE M_SHIPPER SET M_SHIPPER_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_SHIPPER MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE M_SHIPPER DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_SHIPPERCFG
ALTER TABLE M_SHIPPERCFG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR));
ALTER TABLE M_SHIPPERCFG MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPERCFG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SHIPPERCFG_UU,M_SHIPPERCFG_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=SHIPPINGSERVICECODE,SHIPPINGSERVICECODE=NULL,tmp_col_5_tmp=TRACKINGURL,TRACKINGURL=NULL;
ALTER TABLE M_SHIPPERCFG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SHIPPERCFG_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),SHIPPINGSERVICECODE VARCHAR2(40 CHAR),TRACKINGURL VARCHAR2(120 CHAR));
UPDATE M_SHIPPERCFG SET DESCRIPTION=tmp_col_1_tmp,M_SHIPPERCFG_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,SHIPPINGSERVICECODE=tmp_col_4_tmp,TRACKINGURL=tmp_col_5_tmp;
ALTER TABLE M_SHIPPERCFG MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_SHIPPERCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_SHIPPERLABELS
ALTER TABLE M_SHIPPERLABELS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPERLABELS MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPERLABELS SET tmp_col_1_tmp=M_SHIPPERLABELS_UU,M_SHIPPERLABELS_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_SHIPPERLABELS MODIFY (M_SHIPPERLABELS_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL );
UPDATE M_SHIPPERLABELS SET M_SHIPPERLABELS_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_SHIPPERLABELS MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE M_SHIPPERLABELS DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_SHIPPERLABELSCFG
ALTER TABLE M_SHIPPERLABELSCFG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_SHIPPERLABELSCFG MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_SHIPPERLABELSCFG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SHIPPERLABELSCFG_UU,M_SHIPPERLABELSCFG_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_SHIPPERLABELSCFG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SHIPPERLABELSCFG_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_SHIPPERLABELSCFG SET DESCRIPTION=tmp_col_1_tmp,M_SHIPPERLABELSCFG_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE M_SHIPPERLABELSCFG MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_SHIPPERLABELSCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_SHIPPERPACKAGING
ALTER TABLE M_SHIPPERPACKAGING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPERPACKAGING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPERPACKAGING SET tmp_col_1_tmp=M_SHIPPERPACKAGING_UU,M_SHIPPERPACKAGING_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_SHIPPERPACKAGING MODIFY (M_SHIPPERPACKAGING_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL );
UPDATE M_SHIPPERPACKAGING SET M_SHIPPERPACKAGING_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_SHIPPERPACKAGING MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE M_SHIPPERPACKAGING DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_SHIPPERPACKAGINGCFG
ALTER TABLE M_SHIPPERPACKAGINGCFG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_SHIPPERPACKAGINGCFG MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_SHIPPERPACKAGINGCFG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SHIPPERPACKAGINGCFG_UU,M_SHIPPERPACKAGINGCFG_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_SHIPPERPACKAGINGCFG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SHIPPERPACKAGINGCFG_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_SHIPPERPACKAGINGCFG SET DESCRIPTION=tmp_col_1_tmp,M_SHIPPERPACKAGINGCFG_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE M_SHIPPERPACKAGINGCFG MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_SHIPPERPACKAGINGCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_SHIPPERPICKUPTYPES
ALTER TABLE M_SHIPPERPICKUPTYPES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPERPICKUPTYPES MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPERPICKUPTYPES SET tmp_col_1_tmp=M_SHIPPERPICKUPTYPES_UU,M_SHIPPERPICKUPTYPES_UU=NULL,tmp_col_2_tmp=NAME,NAME=NULL;
ALTER TABLE M_SHIPPERPICKUPTYPES MODIFY (M_SHIPPERPICKUPTYPES_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL );
UPDATE M_SHIPPERPICKUPTYPES SET M_SHIPPERPICKUPTYPES_UU=tmp_col_1_tmp,NAME=tmp_col_2_tmp;
ALTER TABLE M_SHIPPERPICKUPTYPES MODIFY (NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE M_SHIPPERPICKUPTYPES DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table M_SHIPPERPICKUPTYPESCFG
ALTER TABLE M_SHIPPERPICKUPTYPESCFG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_SHIPPERPICKUPTYPESCFG MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_SHIPPERPICKUPTYPESCFG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SHIPPERPICKUPTYPESCFG_UU,M_SHIPPERPICKUPTYPESCFG_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_SHIPPERPICKUPTYPESCFG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SHIPPERPICKUPTYPESCFG_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_SHIPPERPICKUPTYPESCFG SET DESCRIPTION=tmp_col_1_tmp,M_SHIPPERPICKUPTYPESCFG_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE M_SHIPPERPICKUPTYPESCFG MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_SHIPPERPICKUPTYPESCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_SHIPPINGPROCESSOR
ALTER TABLE M_SHIPPINGPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPINGPROCESSOR MODIFY (CONNECTIONPASSWORD NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL,USERID NVARCHAR2(60) NULL);
UPDATE M_SHIPPINGPROCESSOR SET tmp_col_1_tmp=CONNECTIONKEY,CONNECTIONKEY=NULL,tmp_col_2_tmp=CONNECTIONPASSWORD,CONNECTIONPASSWORD=NULL,tmp_col_3_tmp=M_SHIPPINGPROCESSOR_UU,M_SHIPPINGPROCESSOR_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=USERID,USERID=NULL;
ALTER TABLE M_SHIPPINGPROCESSOR MODIFY (CONNECTIONKEY VARCHAR2(60 CHAR),CONNECTIONPASSWORD VARCHAR2(60 CHAR),M_SHIPPINGPROCESSOR_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR) DEFAULT NULL ,USERID VARCHAR2(60 CHAR));
UPDATE M_SHIPPINGPROCESSOR SET CONNECTIONKEY=tmp_col_1_tmp,CONNECTIONPASSWORD=tmp_col_2_tmp,M_SHIPPINGPROCESSOR_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,USERID=tmp_col_5_tmp;
ALTER TABLE M_SHIPPINGPROCESSOR MODIFY (CONNECTIONPASSWORD VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) DEFAULT NULL  NOT NULL,USERID VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_SHIPPINGPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_SHIPPINGPROCESSORCFG
ALTER TABLE M_SHIPPINGPROCESSORCFG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(60 CHAR));
ALTER TABLE M_SHIPPINGPROCESSORCFG MODIFY (HOSTADDRESS NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL);
UPDATE M_SHIPPINGPROCESSORCFG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HOSTADDRESS,HOSTADDRESS=NULL,tmp_col_3_tmp=M_SHIPPINGPROCESSORCFG_UU,M_SHIPPINGPROCESSORCFG_UU=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PROXYADDRESS,PROXYADDRESS=NULL,tmp_col_6_tmp=PROXYLOGON,PROXYLOGON=NULL,tmp_col_7_tmp=PROXYPASSWORD,PROXYPASSWORD=NULL,tmp_col_8_tmp=SERVICEPATH,SERVICEPATH=NULL,tmp_col_9_tmp=SHIPPINGPROCESSORCLASS,SHIPPINGPROCESSORCLASS=NULL;
ALTER TABLE M_SHIPPINGPROCESSORCFG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HOSTADDRESS VARCHAR2(60 CHAR),M_SHIPPINGPROCESSORCFG_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),PROXYADDRESS VARCHAR2(60 CHAR),PROXYLOGON VARCHAR2(60 CHAR),PROXYPASSWORD VARCHAR2(60 CHAR),SERVICEPATH VARCHAR2(60 CHAR),SHIPPINGPROCESSORCLASS VARCHAR2(60 CHAR));
UPDATE M_SHIPPINGPROCESSORCFG SET DESCRIPTION=tmp_col_1_tmp,HOSTADDRESS=tmp_col_2_tmp,M_SHIPPINGPROCESSORCFG_UU=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PROXYADDRESS=tmp_col_5_tmp,PROXYLOGON=tmp_col_6_tmp,PROXYPASSWORD=tmp_col_7_tmp,SERVICEPATH=tmp_col_8_tmp,SHIPPINGPROCESSORCLASS=tmp_col_9_tmp;
ALTER TABLE M_SHIPPINGPROCESSORCFG MODIFY (HOSTADDRESS VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE M_SHIPPINGPROCESSORCFG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp);

-- Processing table M_SHIPPINGTRANSACTION
ALTER TABLE M_SHIPPINGTRANSACTION ADD (tmp_col_1_tmp VARCHAR2(2 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(30 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(10 CHAR),tmp_col_8_tmp VARCHAR2(30 CHAR),tmp_col_9_tmp VARCHAR2(30 CHAR),tmp_col_10_tmp VARCHAR2(36 CHAR),tmp_col_11_tmp VARCHAR2(255 CHAR),tmp_col_12_tmp VARCHAR2(2 CHAR),tmp_col_13_tmp VARCHAR2(30 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(255 CHAR),tmp_col_16_tmp VARCHAR2(40 CHAR),tmp_col_17_tmp VARCHAR2(2000 CHAR),tmp_col_18_tmp VARCHAR2(255 CHAR),tmp_col_19_tmp VARCHAR2(255 CHAR));
ALTER TABLE M_SHIPPINGTRANSACTION MODIFY (ACTION NVARCHAR2(2) NULL);
UPDATE M_SHIPPINGTRANSACTION SET tmp_col_1_tmp=ACTION,ACTION=NULL,tmp_col_2_tmp=DELIVERYCONFIRMATIONTYPE,DELIVERYCONFIRMATIONTYPE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=DOTHAZARDCLASSORDIVISION,DOTHAZARDCLASSORDIVISION=NULL,tmp_col_5_tmp=DUTIESSHIPPERACCOUNT,DUTIESSHIPPERACCOUNT=NULL,tmp_col_6_tmp=FOB,FOB=NULL,tmp_col_7_tmp=FREIGHTCHARGES,FREIGHTCHARGES=NULL,tmp_col_8_tmp=HOMEDELIVERYPREMIUMPHONE,HOMEDELIVERYPREMIUMPHONE=NULL,tmp_col_9_tmp=HOMEDELIVERYPREMIUMTYPE,HOMEDELIVERYPREMIUMTYPE=NULL,tmp_col_10_tmp=M_SHIPPINGTRANSACTION_UU,M_SHIPPINGTRANSACTION_UU=NULL,tmp_col_11_tmp=NOTIFICATIONMESSAGE,NOTIFICATIONMESSAGE=NULL,tmp_col_12_tmp=NOTIFICATIONTYPE,NOTIFICATIONTYPE=NULL,tmp_col_13_tmp=POREFERENCE,POREFERENCE=NULL,tmp_col_14_tmp=RATEINQUIRYMESSAGE,RATEINQUIRYMESSAGE=NULL,tmp_col_15_tmp=RECEIVEDINFO,RECEIVEDINFO=NULL,tmp_col_16_tmp=SHIPPERACCOUNT,SHIPPERACCOUNT=NULL,tmp_col_17_tmp=SHIPPINGRESPMESSAGE,SHIPPINGRESPMESSAGE=NULL,tmp_col_18_tmp=TRACKINGINFO,TRACKINGINFO=NULL,tmp_col_19_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE M_SHIPPINGTRANSACTION MODIFY (ACTION VARCHAR2(2 CHAR),DELIVERYCONFIRMATIONTYPE VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOTHAZARDCLASSORDIVISION VARCHAR2(30 CHAR),DUTIESSHIPPERACCOUNT VARCHAR2(40 CHAR),FOB VARCHAR2(10 CHAR),FREIGHTCHARGES VARCHAR2(10 CHAR),HOMEDELIVERYPREMIUMPHONE VARCHAR2(30 CHAR),HOMEDELIVERYPREMIUMTYPE VARCHAR2(30 CHAR),M_SHIPPINGTRANSACTION_UU VARCHAR2(36 CHAR),NOTIFICATIONMESSAGE VARCHAR2(255 CHAR),NOTIFICATIONTYPE VARCHAR2(2 CHAR),POREFERENCE VARCHAR2(30 CHAR),RATEINQUIRYMESSAGE VARCHAR2(2000 CHAR),RECEIVEDINFO VARCHAR2(255 CHAR),SHIPPERACCOUNT VARCHAR2(40 CHAR),SHIPPINGRESPMESSAGE VARCHAR2(2000 CHAR),TRACKINGINFO VARCHAR2(255 CHAR),TRACKINGNO VARCHAR2(255 CHAR));
UPDATE M_SHIPPINGTRANSACTION SET ACTION=tmp_col_1_tmp,DELIVERYCONFIRMATIONTYPE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,DOTHAZARDCLASSORDIVISION=tmp_col_4_tmp,DUTIESSHIPPERACCOUNT=tmp_col_5_tmp,FOB=tmp_col_6_tmp,FREIGHTCHARGES=tmp_col_7_tmp,HOMEDELIVERYPREMIUMPHONE=tmp_col_8_tmp,HOMEDELIVERYPREMIUMTYPE=tmp_col_9_tmp,M_SHIPPINGTRANSACTION_UU=tmp_col_10_tmp,NOTIFICATIONMESSAGE=tmp_col_11_tmp,NOTIFICATIONTYPE=tmp_col_12_tmp,POREFERENCE=tmp_col_13_tmp,RATEINQUIRYMESSAGE=tmp_col_14_tmp,RECEIVEDINFO=tmp_col_15_tmp,SHIPPERACCOUNT=tmp_col_16_tmp,SHIPPINGRESPMESSAGE=tmp_col_17_tmp,TRACKINGINFO=tmp_col_18_tmp,TRACKINGNO=tmp_col_19_tmp;
ALTER TABLE M_SHIPPINGTRANSACTION MODIFY (ACTION VARCHAR2(2 CHAR) NOT NULL);
ALTER TABLE M_SHIPPINGTRANSACTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp);

-- Processing table M_SHIPPINGTRANSACTIONLINE
ALTER TABLE M_SHIPPINGTRANSACTIONLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR));
UPDATE M_SHIPPINGTRANSACTIONLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=MASTERTRACKINGNO,MASTERTRACKINGNO=NULL,tmp_col_3_tmp=M_SHIPPINGTRANSACTIONLINE_UU,M_SHIPPINGTRANSACTIONLINE_UU=NULL,tmp_col_4_tmp=TRACKINGNO,TRACKINGNO=NULL;
ALTER TABLE M_SHIPPINGTRANSACTIONLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),MASTERTRACKINGNO VARCHAR2(255 CHAR),M_SHIPPINGTRANSACTIONLINE_UU VARCHAR2(36 CHAR),TRACKINGNO VARCHAR2(255 CHAR));
UPDATE M_SHIPPINGTRANSACTIONLINE SET DESCRIPTION=tmp_col_1_tmp,MASTERTRACKINGNO=tmp_col_2_tmp,M_SHIPPINGTRANSACTIONLINE_UU=tmp_col_3_tmp,TRACKINGNO=tmp_col_4_tmp;
ALTER TABLE M_SHIPPINGTRANSACTIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table M_STORAGEONHAND
ALTER TABLE M_STORAGEONHAND ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_STORAGEONHAND SET tmp_col_1_tmp=M_STORAGEONHAND_UU,M_STORAGEONHAND_UU=NULL;
ALTER TABLE M_STORAGEONHAND MODIFY (M_STORAGEONHAND_UU VARCHAR2(36 CHAR));
UPDATE M_STORAGEONHAND SET M_STORAGEONHAND_UU=tmp_col_1_tmp;
ALTER TABLE M_STORAGEONHAND DROP (tmp_col_1_tmp);

-- Processing table M_STORAGERESERVATION
ALTER TABLE M_STORAGERESERVATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_STORAGERESERVATION SET tmp_col_1_tmp=M_STORAGERESERVATION_UU,M_STORAGERESERVATION_UU=NULL;
ALTER TABLE M_STORAGERESERVATION MODIFY (M_STORAGERESERVATION_UU VARCHAR2(36 CHAR));
UPDATE M_STORAGERESERVATION SET M_STORAGERESERVATION_UU=tmp_col_1_tmp;
ALTER TABLE M_STORAGERESERVATION DROP (tmp_col_1_tmp);

-- Processing table M_SUBSTITUTE
ALTER TABLE M_SUBSTITUTE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
UPDATE M_SUBSTITUTE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_SUBSTITUTE_UU,M_SUBSTITUTE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL;
ALTER TABLE M_SUBSTITUTE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_SUBSTITUTE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR));
UPDATE M_SUBSTITUTE SET DESCRIPTION=tmp_col_1_tmp,M_SUBSTITUTE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp;
ALTER TABLE M_SUBSTITUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table M_TRANSACTION
ALTER TABLE M_TRANSACTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_TRANSACTION SET tmp_col_1_tmp=M_TRANSACTION_UU,M_TRANSACTION_UU=NULL;
ALTER TABLE M_TRANSACTION MODIFY (M_TRANSACTION_UU VARCHAR2(36 CHAR));
UPDATE M_TRANSACTION SET M_TRANSACTION_UU=tmp_col_1_tmp;
ALTER TABLE M_TRANSACTION DROP (tmp_col_1_tmp);

-- Processing table M_TRANSACTIONALLOCATION
ALTER TABLE M_TRANSACTIONALLOCATION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_TRANSACTIONALLOCATION SET tmp_col_1_tmp=M_TRANSACTIONALLOCATION_UU,M_TRANSACTIONALLOCATION_UU=NULL;
ALTER TABLE M_TRANSACTIONALLOCATION MODIFY (M_TRANSACTIONALLOCATION_UU VARCHAR2(36 CHAR));
UPDATE M_TRANSACTIONALLOCATION SET M_TRANSACTIONALLOCATION_UU=tmp_col_1_tmp;
ALTER TABLE M_TRANSACTIONALLOCATION DROP (tmp_col_1_tmp);

-- Processing table M_WAREHOUSE
ALTER TABLE M_WAREHOUSE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE M_WAREHOUSE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE M_WAREHOUSE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=M_WAREHOUSE_UU,M_WAREHOUSE_UU=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=REPLENISHMENTCLASS,REPLENISHMENTCLASS=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE M_WAREHOUSE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),M_WAREHOUSE_UU VARCHAR2(36 CHAR),NAME VARCHAR2(60 CHAR),REPLENISHMENTCLASS VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE M_WAREHOUSE SET DESCRIPTION=tmp_col_1_tmp,M_WAREHOUSE_UU=tmp_col_2_tmp,NAME=tmp_col_3_tmp,REPLENISHMENTCLASS=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE M_WAREHOUSE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE M_WAREHOUSE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table M_WAREHOUSE_ACCT
ALTER TABLE M_WAREHOUSE_ACCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE M_WAREHOUSE_ACCT SET tmp_col_1_tmp=M_WAREHOUSE_ACCT_UU,M_WAREHOUSE_ACCT_UU=NULL;
ALTER TABLE M_WAREHOUSE_ACCT MODIFY (M_WAREHOUSE_ACCT_UU VARCHAR2(36 CHAR));
UPDATE M_WAREHOUSE_ACCT SET M_WAREHOUSE_ACCT_UU=tmp_col_1_tmp;
ALTER TABLE M_WAREHOUSE_ACCT DROP (tmp_col_1_tmp);

-- Processing table PA_ACHIEVEMENT
ALTER TABLE PA_ACHIEVEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_ACHIEVEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_ACHIEVEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=NOTE,NOTE=NULL,tmp_col_4_tmp=PA_ACHIEVEMENT_UU,PA_ACHIEVEMENT_UU=NULL;
ALTER TABLE PA_ACHIEVEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),NOTE VARCHAR2(2000 CHAR),PA_ACHIEVEMENT_UU VARCHAR2(36 CHAR));
UPDATE PA_ACHIEVEMENT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,NOTE=tmp_col_3_tmp,PA_ACHIEVEMENT_UU=tmp_col_4_tmp;
ALTER TABLE PA_ACHIEVEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_ACHIEVEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PA_BENCHMARK
ALTER TABLE PA_BENCHMARK ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_BENCHMARK MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_BENCHMARK SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PA_BENCHMARK_UU,PA_BENCHMARK_UU=NULL;
ALTER TABLE PA_BENCHMARK MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_BENCHMARK_UU VARCHAR2(36 CHAR));
UPDATE PA_BENCHMARK SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PA_BENCHMARK_UU=tmp_col_4_tmp;
ALTER TABLE PA_BENCHMARK MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_BENCHMARK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PA_BENCHMARKDATA
ALTER TABLE PA_BENCHMARKDATA ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_BENCHMARKDATA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_BENCHMARKDATA SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_BENCHMARKDATA_UU,PA_BENCHMARKDATA_UU=NULL;
ALTER TABLE PA_BENCHMARKDATA MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_BENCHMARKDATA_UU VARCHAR2(36 CHAR));
UPDATE PA_BENCHMARKDATA SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_BENCHMARKDATA_UU=tmp_col_3_tmp;
ALTER TABLE PA_BENCHMARKDATA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_BENCHMARKDATA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_COLORSCHEMA
ALTER TABLE PA_COLORSCHEMA ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_COLORSCHEMA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_COLORSCHEMA SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_COLORSCHEMA_UU,PA_COLORSCHEMA_UU=NULL;
ALTER TABLE PA_COLORSCHEMA MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_COLORSCHEMA_UU VARCHAR2(36 CHAR));
UPDATE PA_COLORSCHEMA SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_COLORSCHEMA_UU=tmp_col_3_tmp;
ALTER TABLE PA_COLORSCHEMA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_COLORSCHEMA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_DASHBOARDCONTENT
ALTER TABLE PA_DASHBOARDCONTENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(120 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(255 CHAR));
ALTER TABLE PA_DASHBOARDCONTENT MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE PA_DASHBOARDCONTENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_DASHBOARDCONTENT_UU,PA_DASHBOARDCONTENT_UU=NULL,tmp_col_4_tmp=PROCESSPARAMETERS,PROCESSPARAMETERS=NULL,tmp_col_5_tmp=ZULFILEPATH,ZULFILEPATH=NULL;
ALTER TABLE PA_DASHBOARDCONTENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR),PA_DASHBOARDCONTENT_UU VARCHAR2(36 CHAR),PROCESSPARAMETERS VARCHAR2(2000 CHAR),ZULFILEPATH VARCHAR2(255 CHAR));
UPDATE PA_DASHBOARDCONTENT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_DASHBOARDCONTENT_UU=tmp_col_3_tmp,PROCESSPARAMETERS=tmp_col_4_tmp,ZULFILEPATH=tmp_col_5_tmp;
ALTER TABLE PA_DASHBOARDCONTENT MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE PA_DASHBOARDCONTENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PA_DASHBOARDCONTENT_ACCESS
ALTER TABLE PA_DASHBOARDCONTENT_ACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PA_DASHBOARDCONTENT_ACCESS SET tmp_col_1_tmp=PA_DASHBOARDCONTENT_ACCESS_UU,PA_DASHBOARDCONTENT_ACCESS_UU=NULL;
ALTER TABLE PA_DASHBOARDCONTENT_ACCESS MODIFY (PA_DASHBOARDCONTENT_ACCESS_UU VARCHAR2(36 CHAR));
UPDATE PA_DASHBOARDCONTENT_ACCESS SET PA_DASHBOARDCONTENT_ACCESS_UU=tmp_col_1_tmp;
ALTER TABLE PA_DASHBOARDCONTENT_ACCESS DROP (tmp_col_1_tmp);

-- Processing table PA_DASHBOARDCONTENT_TRL
ALTER TABLE PA_DASHBOARDCONTENT_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(120 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_DASHBOARDCONTENT_TRL MODIFY (NAME NVARCHAR2(120) NULL);
UPDATE PA_DASHBOARDCONTENT_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_DASHBOARDCONTENT_TRL_UU,PA_DASHBOARDCONTENT_TRL_UU=NULL;
ALTER TABLE PA_DASHBOARDCONTENT_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(120 CHAR),PA_DASHBOARDCONTENT_TRL_UU VARCHAR2(36 CHAR));
UPDATE PA_DASHBOARDCONTENT_TRL SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_DASHBOARDCONTENT_TRL_UU=tmp_col_3_tmp;
ALTER TABLE PA_DASHBOARDCONTENT_TRL MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE PA_DASHBOARDCONTENT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_DASHBOARDPREFERENCE
ALTER TABLE PA_DASHBOARDPREFERENCE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PA_DASHBOARDPREFERENCE SET tmp_col_1_tmp=PA_DASHBOARDPREFERENCE_UU,PA_DASHBOARDPREFERENCE_UU=NULL;
ALTER TABLE PA_DASHBOARDPREFERENCE MODIFY (PA_DASHBOARDPREFERENCE_UU VARCHAR2(36 CHAR));
UPDATE PA_DASHBOARDPREFERENCE SET PA_DASHBOARDPREFERENCE_UU=tmp_col_1_tmp;
ALTER TABLE PA_DASHBOARDPREFERENCE DROP (tmp_col_1_tmp);

-- Processing table PA_GOAL
ALTER TABLE PA_GOAL ADD (tmp_col_1_tmp VARCHAR2(2 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_GOAL MODIFY (CHARTTYPE NVARCHAR2(2) NULL,NAME NVARCHAR2(60) NULL);
UPDATE PA_GOAL SET tmp_col_1_tmp=CHARTTYPE,CHARTTYPE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=NOTE,NOTE=NULL,tmp_col_5_tmp=PA_GOAL_UU,PA_GOAL_UU=NULL;
ALTER TABLE PA_GOAL MODIFY (CHARTTYPE VARCHAR2(2 CHAR) DEFAULT 'BC' ,DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),NOTE VARCHAR2(2000 CHAR),PA_GOAL_UU VARCHAR2(36 CHAR));
UPDATE PA_GOAL SET CHARTTYPE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,NAME=tmp_col_3_tmp,NOTE=tmp_col_4_tmp,PA_GOAL_UU=tmp_col_5_tmp;
ALTER TABLE PA_GOAL MODIFY (CHARTTYPE VARCHAR2(2 CHAR) DEFAULT 'BC'	NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_GOAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PA_GOALRESTRICTION
ALTER TABLE PA_GOALRESTRICTION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_GOALRESTRICTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_GOALRESTRICTION SET tmp_col_1_tmp=NAME,NAME=NULL,tmp_col_2_tmp=PA_GOALRESTRICTION_UU,PA_GOALRESTRICTION_UU=NULL;
ALTER TABLE PA_GOALRESTRICTION MODIFY (NAME VARCHAR2(60 CHAR),PA_GOALRESTRICTION_UU VARCHAR2(36 CHAR));
UPDATE PA_GOALRESTRICTION SET NAME=tmp_col_1_tmp,PA_GOALRESTRICTION_UU=tmp_col_2_tmp;
ALTER TABLE PA_GOALRESTRICTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_GOALRESTRICTION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table PA_HIERARCHY
ALTER TABLE PA_HIERARCHY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_HIERARCHY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_HIERARCHY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PA_HIERARCHY_UU,PA_HIERARCHY_UU=NULL;
ALTER TABLE PA_HIERARCHY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_HIERARCHY_UU VARCHAR2(36 CHAR));
UPDATE PA_HIERARCHY SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PA_HIERARCHY_UU=tmp_col_4_tmp;
ALTER TABLE PA_HIERARCHY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_HIERARCHY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PA_MEASURE
ALTER TABLE PA_MEASURE ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_MEASURE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_MEASURE SET tmp_col_1_tmp=CALCULATIONCLASS,CALCULATIONCLASS=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=MANUALNOTE,MANUALNOTE=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PA_MEASURE_UU,PA_MEASURE_UU=NULL;
ALTER TABLE PA_MEASURE MODIFY (CALCULATIONCLASS VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),MANUALNOTE VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_MEASURE_UU VARCHAR2(36 CHAR));
UPDATE PA_MEASURE SET CALCULATIONCLASS=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,MANUALNOTE=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PA_MEASURE_UU=tmp_col_5_tmp;
ALTER TABLE PA_MEASURE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_MEASURE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PA_MEASURECALC
ALTER TABLE PA_MEASURECALC ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(36 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(2000 CHAR));
ALTER TABLE PA_MEASURECALC MODIFY (DATECOLUMN NVARCHAR2(60) NULL,KEYCOLUMN NVARCHAR2(60) NULL,NAME NVARCHAR2(60) NULL,SELECTCLAUSE NVARCHAR2(2000) NULL,WHERECLAUSE NVARCHAR2(2000) NULL);
UPDATE PA_MEASURECALC SET tmp_col_1_tmp=BPARTNERCOLUMN,BPARTNERCOLUMN=NULL,tmp_col_2_tmp=DATECOLUMN,DATECOLUMN=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=KEYCOLUMN,KEYCOLUMN=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=ORGCOLUMN,ORGCOLUMN=NULL,tmp_col_7_tmp=PA_MEASURECALC_UU,PA_MEASURECALC_UU=NULL,tmp_col_8_tmp=PRODUCTCOLUMN,PRODUCTCOLUMN=NULL,tmp_col_9_tmp=SELECTCLAUSE,SELECTCLAUSE=NULL,tmp_col_10_tmp=WHERECLAUSE,WHERECLAUSE=NULL;
ALTER TABLE PA_MEASURECALC MODIFY (BPARTNERCOLUMN VARCHAR2(60 CHAR),DATECOLUMN VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),KEYCOLUMN VARCHAR2(60 CHAR),NAME VARCHAR2(60 CHAR),ORGCOLUMN VARCHAR2(60 CHAR),PA_MEASURECALC_UU VARCHAR2(36 CHAR),PRODUCTCOLUMN VARCHAR2(60 CHAR),SELECTCLAUSE VARCHAR2(2000 CHAR),WHERECLAUSE VARCHAR2(2000 CHAR));
UPDATE PA_MEASURECALC SET BPARTNERCOLUMN=tmp_col_1_tmp,DATECOLUMN=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,KEYCOLUMN=tmp_col_4_tmp,NAME=tmp_col_5_tmp,ORGCOLUMN=tmp_col_6_tmp,PA_MEASURECALC_UU=tmp_col_7_tmp,PRODUCTCOLUMN=tmp_col_8_tmp,SELECTCLAUSE=tmp_col_9_tmp,WHERECLAUSE=tmp_col_10_tmp;
ALTER TABLE PA_MEASURECALC MODIFY (DATECOLUMN VARCHAR2(60 CHAR) NOT NULL,KEYCOLUMN VARCHAR2(60 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,SELECTCLAUSE VARCHAR2(2000 CHAR) NOT NULL,WHERECLAUSE VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE PA_MEASURECALC DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table PA_RATIO
ALTER TABLE PA_RATIO ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_RATIO MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_RATIO SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PA_RATIO_UU,PA_RATIO_UU=NULL;
ALTER TABLE PA_RATIO MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_RATIO_UU VARCHAR2(36 CHAR));
UPDATE PA_RATIO SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PA_RATIO_UU=tmp_col_4_tmp;
ALTER TABLE PA_RATIO MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_RATIO DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PA_RATIOELEMENT
ALTER TABLE PA_RATIOELEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_RATIOELEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_RATIOELEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_RATIOELEMENT_UU,PA_RATIOELEMENT_UU=NULL;
ALTER TABLE PA_RATIOELEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_RATIOELEMENT_UU VARCHAR2(36 CHAR));
UPDATE PA_RATIOELEMENT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_RATIOELEMENT_UU=tmp_col_3_tmp;
ALTER TABLE PA_RATIOELEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_RATIOELEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORT
ALTER TABLE PA_REPORT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_REPORT_UU,PA_REPORT_UU=NULL;
ALTER TABLE PA_REPORT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_REPORT_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_REPORT_UU=tmp_col_3_tmp;
ALTER TABLE PA_REPORT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORTCOLUMN
ALTER TABLE PA_REPORTCOLUMN ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(512 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORTCOLUMN MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORTCOLUMN SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=FORMATPATTERN,FORMATPATTERN=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=OPER_2_LINENAME,OPER_2_LINENAME=NULL,tmp_col_5_tmp=PA_REPORTCOLUMN_UU,PA_REPORTCOLUMN_UU=NULL;
ALTER TABLE PA_REPORTCOLUMN MODIFY (DESCRIPTION VARCHAR2(255 CHAR),FORMATPATTERN VARCHAR2(22 CHAR),NAME VARCHAR2(60 CHAR),OPER_2_LINENAME VARCHAR2(512 CHAR),PA_REPORTCOLUMN_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTCOLUMN SET DESCRIPTION=tmp_col_1_tmp,FORMATPATTERN=tmp_col_2_tmp,NAME=tmp_col_3_tmp,OPER_2_LINENAME=tmp_col_4_tmp,PA_REPORTCOLUMN_UU=tmp_col_5_tmp;
ALTER TABLE PA_REPORTCOLUMN MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORTCOLUMN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PA_REPORTCOLUMNSET
ALTER TABLE PA_REPORTCOLUMNSET ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORTCOLUMNSET MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORTCOLUMNSET SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_REPORTCOLUMNSET_UU,PA_REPORTCOLUMNSET_UU=NULL;
ALTER TABLE PA_REPORTCOLUMNSET MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_REPORTCOLUMNSET_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTCOLUMNSET SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_REPORTCOLUMNSET_UU=tmp_col_3_tmp;
ALTER TABLE PA_REPORTCOLUMNSET MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORTCOLUMNSET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORTCUBE
ALTER TABLE PA_REPORTCUBE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORTCUBE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORTCUBE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_REPORTCUBE_UU,PA_REPORTCUBE_UU=NULL;
ALTER TABLE PA_REPORTCUBE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_REPORTCUBE_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTCUBE SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_REPORTCUBE_UU=tmp_col_3_tmp;
ALTER TABLE PA_REPORTCUBE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORTCUBE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORTLINE
ALTER TABLE PA_REPORTLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORTLINE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORTLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_REPORTLINE_UU,PA_REPORTLINE_UU=NULL;
ALTER TABLE PA_REPORTLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_REPORTLINE_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTLINE SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_REPORTLINE_UU=tmp_col_3_tmp;
ALTER TABLE PA_REPORTLINE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORTLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORTLINESET
ALTER TABLE PA_REPORTLINESET ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_REPORTLINESET MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_REPORTLINESET SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PA_REPORTLINESET_UU,PA_REPORTLINESET_UU=NULL;
ALTER TABLE PA_REPORTLINESET MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PA_REPORTLINESET_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTLINESET SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PA_REPORTLINESET_UU=tmp_col_3_tmp;
ALTER TABLE PA_REPORTLINESET MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_REPORTLINESET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PA_REPORTSOURCE
ALTER TABLE PA_REPORTSOURCE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE PA_REPORTSOURCE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=PA_REPORTSOURCE_UU,PA_REPORTSOURCE_UU=NULL;
ALTER TABLE PA_REPORTSOURCE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),PA_REPORTSOURCE_UU VARCHAR2(36 CHAR));
UPDATE PA_REPORTSOURCE SET DESCRIPTION=tmp_col_1_tmp,PA_REPORTSOURCE_UU=tmp_col_2_tmp;
ALTER TABLE PA_REPORTSOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table PA_SLA_CRITERIA
ALTER TABLE PA_SLA_CRITERIA ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_SLA_CRITERIA MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_SLA_CRITERIA SET tmp_col_1_tmp=CLASSNAME,CLASSNAME=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PA_SLA_CRITERIA_UU,PA_SLA_CRITERIA_UU=NULL;
ALTER TABLE PA_SLA_CRITERIA MODIFY (CLASSNAME VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_SLA_CRITERIA_UU VARCHAR2(36 CHAR));
UPDATE PA_SLA_CRITERIA SET CLASSNAME=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PA_SLA_CRITERIA_UU=tmp_col_5_tmp;
ALTER TABLE PA_SLA_CRITERIA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_SLA_CRITERIA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PA_SLA_GOAL
ALTER TABLE PA_SLA_GOAL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PA_SLA_GOAL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PA_SLA_GOAL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PA_SLA_GOAL_UU,PA_SLA_GOAL_UU=NULL;
ALTER TABLE PA_SLA_GOAL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PA_SLA_GOAL_UU VARCHAR2(36 CHAR));
UPDATE PA_SLA_GOAL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PA_SLA_GOAL_UU=tmp_col_4_tmp;
ALTER TABLE PA_SLA_GOAL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PA_SLA_GOAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PA_SLA_MEASURE
ALTER TABLE PA_SLA_MEASURE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE PA_SLA_MEASURE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=PA_SLA_MEASURE_UU,PA_SLA_MEASURE_UU=NULL;
ALTER TABLE PA_SLA_MEASURE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),PA_SLA_MEASURE_UU VARCHAR2(36 CHAR));
UPDATE PA_SLA_MEASURE SET DESCRIPTION=tmp_col_1_tmp,PA_SLA_MEASURE_UU=tmp_col_2_tmp;
ALTER TABLE PA_SLA_MEASURE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table PP_COST_COLLECTOR
ALTER TABLE PP_COST_COLLECTOR ADD (tmp_col_1_tmp VARCHAR2(3 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PP_COST_COLLECTOR MODIFY (COSTCOLLECTORTYPE NVARCHAR2(3) NULL,DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE PP_COST_COLLECTOR SET tmp_col_1_tmp=COSTCOLLECTORTYPE,COSTCOLLECTORTYPE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=PP_COST_COLLECTOR_UU,PP_COST_COLLECTOR_UU=NULL;
ALTER TABLE PP_COST_COLLECTOR MODIFY (COSTCOLLECTORTYPE VARCHAR2(3 CHAR) DEFAULT NULL ,DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR) DEFAULT NULL ,PP_COST_COLLECTOR_UU VARCHAR2(36 CHAR));
UPDATE PP_COST_COLLECTOR SET COSTCOLLECTORTYPE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,PP_COST_COLLECTOR_UU=tmp_col_4_tmp;
ALTER TABLE PP_COST_COLLECTOR MODIFY (COSTCOLLECTORTYPE VARCHAR2(3 CHAR) DEFAULT NULL  NOT NULL,DOCUMENTNO VARCHAR2(30 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE PP_COST_COLLECTOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PP_COST_COLLECTORMA
ALTER TABLE PP_COST_COLLECTORMA ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_COST_COLLECTORMA SET tmp_col_1_tmp=PP_COST_COLLECTORMA_UU,PP_COST_COLLECTORMA_UU=NULL;
ALTER TABLE PP_COST_COLLECTORMA MODIFY (PP_COST_COLLECTORMA_UU VARCHAR2(36 CHAR));
UPDATE PP_COST_COLLECTORMA SET PP_COST_COLLECTORMA_UU=tmp_col_1_tmp;
ALTER TABLE PP_COST_COLLECTORMA DROP (tmp_col_1_tmp);

-- Processing table PP_MRP
ALTER TABLE PP_MRP ADD (tmp_col_1_tmp VARCHAR2(1020 CHAR),tmp_col_2_tmp VARCHAR2(2 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(3 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(80 CHAR));
ALTER TABLE PP_MRP MODIFY (VALUE NVARCHAR2(80) NULL);
UPDATE PP_MRP SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCSTATUS,DOCSTATUS=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=ORDERTYPE,ORDERTYPE=NULL,tmp_col_5_tmp=PP_MRP_UU,PP_MRP_UU=NULL,tmp_col_6_tmp=PRIORITY,PRIORITY=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE PP_MRP MODIFY (DESCRIPTION VARCHAR2(1020 CHAR),DOCSTATUS VARCHAR2(2 CHAR),NAME VARCHAR2(120 CHAR),ORDERTYPE VARCHAR2(3 CHAR),PP_MRP_UU VARCHAR2(36 CHAR),PRIORITY VARCHAR2(10 CHAR),VALUE VARCHAR2(80 CHAR));
UPDATE PP_MRP SET DESCRIPTION=tmp_col_1_tmp,DOCSTATUS=tmp_col_2_tmp,NAME=tmp_col_3_tmp,ORDERTYPE=tmp_col_4_tmp,PP_MRP_UU=tmp_col_5_tmp,PRIORITY=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE PP_MRP MODIFY (VALUE VARCHAR2(80 CHAR) NOT NULL);
ALTER TABLE PP_MRP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_ORDER
ALTER TABLE PP_ORDER ADD (tmp_col_1_tmp VARCHAR2(510 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(20 CHAR),tmp_col_4_tmp VARCHAR2(1 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(1 CHAR),tmp_col_7_tmp VARCHAR2(20 CHAR));
ALTER TABLE PP_ORDER MODIFY (DOCUMENTNO NVARCHAR2(60) NULL);
UPDATE PP_ORDER SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=LOT,LOT=NULL,tmp_col_4_tmp=ORDERTYPE,ORDERTYPE=NULL,tmp_col_5_tmp=PP_ORDER_UU,PP_ORDER_UU=NULL,tmp_col_6_tmp=SCHEDULETYPE,SCHEDULETYPE=NULL,tmp_col_7_tmp=SERNO,SERNO=NULL;
ALTER TABLE PP_ORDER MODIFY (DESCRIPTION VARCHAR2(510 CHAR),DOCUMENTNO VARCHAR2(60 CHAR),LOT VARCHAR2(20 CHAR),ORDERTYPE VARCHAR2(1 CHAR),PP_ORDER_UU VARCHAR2(36 CHAR),SCHEDULETYPE VARCHAR2(1 CHAR) DEFAULT 'D',SERNO VARCHAR2(20 CHAR));
UPDATE PP_ORDER SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,LOT=tmp_col_3_tmp,ORDERTYPE=tmp_col_4_tmp,PP_ORDER_UU=tmp_col_5_tmp,SCHEDULETYPE=tmp_col_6_tmp,SERNO=tmp_col_7_tmp;
ALTER TABLE PP_ORDER MODIFY (DOCUMENTNO VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_ORDER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_ORDER_BOM
ALTER TABLE PP_ORDER_BOM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(80 CHAR));
ALTER TABLE PP_ORDER_BOM MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(80) NULL);
UPDATE PP_ORDER_BOM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PP_ORDER_BOM_UU,PP_ORDER_BOM_UU=NULL,tmp_col_6_tmp=REVISION,REVISION=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE PP_ORDER_BOM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(20 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_BOM_UU VARCHAR2(36 CHAR),REVISION VARCHAR2(10 CHAR),VALUE VARCHAR2(80 CHAR));
UPDATE PP_ORDER_BOM SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PP_ORDER_BOM_UU=tmp_col_5_tmp,REVISION=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE PP_ORDER_BOM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(80 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_BOM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_ORDER_BOMLINE
ALTER TABLE PP_ORDER_BOMLINE ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
UPDATE PP_ORDER_BOMLINE SET tmp_col_1_tmp=BACKFLUSHGROUP,BACKFLUSHGROUP=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FEATURE,FEATURE=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=PP_ORDER_BOMLINE_UU,PP_ORDER_BOMLINE_UU=NULL;
ALTER TABLE PP_ORDER_BOMLINE MODIFY (BACKFLUSHGROUP VARCHAR2(30 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FEATURE VARCHAR2(30 CHAR),HELP VARCHAR2(2000 CHAR),PP_ORDER_BOMLINE_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_BOMLINE SET BACKFLUSHGROUP=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FEATURE=tmp_col_3_tmp,HELP=tmp_col_4_tmp,PP_ORDER_BOMLINE_UU=tmp_col_5_tmp;
ALTER TABLE PP_ORDER_BOMLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PP_ORDER_BOMLINE_TRL
ALTER TABLE PP_ORDER_BOMLINE_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE PP_ORDER_BOMLINE_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=PP_ORDER_BOMLINE_TRL_UU,PP_ORDER_BOMLINE_TRL_UU=NULL;
ALTER TABLE PP_ORDER_BOMLINE_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),PP_ORDER_BOMLINE_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_BOMLINE_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,PP_ORDER_BOMLINE_TRL_UU=tmp_col_3_tmp;
ALTER TABLE PP_ORDER_BOMLINE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PP_ORDER_BOM_TRL
ALTER TABLE PP_ORDER_BOM_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PP_ORDER_BOM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PP_ORDER_BOM_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PP_ORDER_BOM_TRL_UU,PP_ORDER_BOM_TRL_UU=NULL;
ALTER TABLE PP_ORDER_BOM_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_BOM_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_BOM_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PP_ORDER_BOM_TRL_UU=tmp_col_4_tmp;
ALTER TABLE PP_ORDER_BOM_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_BOM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PP_ORDER_COST
ALTER TABLE PP_ORDER_COST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_ORDER_COST SET tmp_col_1_tmp=PP_ORDER_COST_UU,PP_ORDER_COST_UU=NULL;
ALTER TABLE PP_ORDER_COST MODIFY (PP_ORDER_COST_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_COST SET PP_ORDER_COST_UU=tmp_col_1_tmp;
ALTER TABLE PP_ORDER_COST DROP (tmp_col_1_tmp);

-- Processing table PP_ORDER_NODE
ALTER TABLE PP_ORDER_NODE ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(36 CHAR),tmp_col_7_tmp VARCHAR2(40 CHAR));
ALTER TABLE PP_ORDER_NODE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE PP_ORDER_NODE SET tmp_col_1_tmp=ATTRIBUTENAME,ATTRIBUTENAME=NULL,tmp_col_2_tmp=ATTRIBUTEVALUE,ATTRIBUTEVALUE=NULL,tmp_col_3_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PP_ORDER_NODE_UU,PP_ORDER_NODE_UU=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE PP_ORDER_NODE MODIFY (ATTRIBUTENAME VARCHAR2(60 CHAR),ATTRIBUTEVALUE VARCHAR2(60 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_NODE_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE PP_ORDER_NODE SET ATTRIBUTENAME=tmp_col_1_tmp,ATTRIBUTEVALUE=tmp_col_2_tmp,DESCRIPTION=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PP_ORDER_NODE_UU=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE PP_ORDER_NODE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_NODE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_ORDER_NODENEXT
ALTER TABLE PP_ORDER_NODENEXT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE PP_ORDER_NODENEXT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=PP_ORDER_NODENEXT_UU,PP_ORDER_NODENEXT_UU=NULL,tmp_col_3_tmp=TRANSITIONCODE,TRANSITIONCODE=NULL;
ALTER TABLE PP_ORDER_NODENEXT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),PP_ORDER_NODENEXT_UU VARCHAR2(36 CHAR),TRANSITIONCODE VARCHAR2(2000 CHAR));
UPDATE PP_ORDER_NODENEXT SET DESCRIPTION=tmp_col_1_tmp,PP_ORDER_NODENEXT_UU=tmp_col_2_tmp,TRANSITIONCODE=tmp_col_3_tmp;
ALTER TABLE PP_ORDER_NODENEXT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PP_ORDER_NODE_ASSET
ALTER TABLE PP_ORDER_NODE_ASSET ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_ORDER_NODE_ASSET SET tmp_col_1_tmp=PP_ORDER_NODE_ASSET_UU,PP_ORDER_NODE_ASSET_UU=NULL;
ALTER TABLE PP_ORDER_NODE_ASSET MODIFY (PP_ORDER_NODE_ASSET_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_NODE_ASSET SET PP_ORDER_NODE_ASSET_UU=tmp_col_1_tmp;
ALTER TABLE PP_ORDER_NODE_ASSET DROP (tmp_col_1_tmp);

-- Processing table PP_ORDER_NODE_PRODUCT
ALTER TABLE PP_ORDER_NODE_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_ORDER_NODE_PRODUCT SET tmp_col_1_tmp=PP_ORDER_NODE_PRODUCT_UU,PP_ORDER_NODE_PRODUCT_UU=NULL;
ALTER TABLE PP_ORDER_NODE_PRODUCT MODIFY (PP_ORDER_NODE_PRODUCT_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_NODE_PRODUCT SET PP_ORDER_NODE_PRODUCT_UU=tmp_col_1_tmp;
ALTER TABLE PP_ORDER_NODE_PRODUCT DROP (tmp_col_1_tmp);

-- Processing table PP_ORDER_NODE_TRL
ALTER TABLE PP_ORDER_NODE_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PP_ORDER_NODE_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PP_ORDER_NODE_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PP_ORDER_NODE_TRL_UU,PP_ORDER_NODE_TRL_UU=NULL;
ALTER TABLE PP_ORDER_NODE_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_NODE_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_NODE_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PP_ORDER_NODE_TRL_UU=tmp_col_4_tmp;
ALTER TABLE PP_ORDER_NODE_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_NODE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PP_ORDER_WORKFLOW
ALTER TABLE PP_ORDER_WORKFLOW ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(32 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(36 CHAR),tmp_col_7_tmp VARCHAR2(240 CHAR));
ALTER TABLE PP_ORDER_WORKFLOW MODIFY (AUTHOR NVARCHAR2(20) NULL,NAME NVARCHAR2(60) NULL);
UPDATE PP_ORDER_WORKFLOW SET tmp_col_1_tmp=AUTHOR,AUTHOR=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=PP_ORDER_WORKFLOW_UU,PP_ORDER_WORKFLOW_UU=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE PP_ORDER_WORKFLOW MODIFY (AUTHOR VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(32 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_WORKFLOW_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(240 CHAR));
UPDATE PP_ORDER_WORKFLOW SET AUTHOR=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,DOCUMENTNO=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,PP_ORDER_WORKFLOW_UU=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE PP_ORDER_WORKFLOW MODIFY (AUTHOR VARCHAR2(20 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_WORKFLOW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_ORDER_WORKFLOW_TRL
ALTER TABLE PP_ORDER_WORKFLOW_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PP_ORDER_WORKFLOW_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PP_ORDER_WORKFLOW_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PP_ORDER_WORKFLOW_TRL_UU,PP_ORDER_WORKFLOW_TRL_UU=NULL;
ALTER TABLE PP_ORDER_WORKFLOW_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_ORDER_WORKFLOW_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_ORDER_WORKFLOW_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PP_ORDER_WORKFLOW_TRL_UU=tmp_col_4_tmp;
ALTER TABLE PP_ORDER_WORKFLOW_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_ORDER_WORKFLOW_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PP_PRODUCT_BOM
ALTER TABLE PP_PRODUCT_BOM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(10 CHAR),tmp_col_7_tmp VARCHAR2(80 CHAR));
ALTER TABLE PP_PRODUCT_BOM MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(80) NULL);
UPDATE PP_PRODUCT_BOM SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=PP_PRODUCT_BOM_UU,PP_PRODUCT_BOM_UU=NULL,tmp_col_6_tmp=REVISION,REVISION=NULL,tmp_col_7_tmp=VALUE,VALUE=NULL;
ALTER TABLE PP_PRODUCT_BOM MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(22 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_PRODUCT_BOM_UU VARCHAR2(36 CHAR),REVISION VARCHAR2(10 CHAR),VALUE VARCHAR2(80 CHAR));
UPDATE PP_PRODUCT_BOM SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,HELP=tmp_col_3_tmp,NAME=tmp_col_4_tmp,PP_PRODUCT_BOM_UU=tmp_col_5_tmp,REVISION=tmp_col_6_tmp,VALUE=tmp_col_7_tmp;
ALTER TABLE PP_PRODUCT_BOM MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(80 CHAR) NOT NULL);
ALTER TABLE PP_PRODUCT_BOM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table PP_PRODUCT_BOMLINE
ALTER TABLE PP_PRODUCT_BOMLINE ADD (tmp_col_1_tmp VARCHAR2(20 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(30 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_BOMLINE SET tmp_col_1_tmp=BACKFLUSHGROUP,BACKFLUSHGROUP=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=FEATURE,FEATURE=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=PP_PRODUCT_BOMLINE_UU,PP_PRODUCT_BOMLINE_UU=NULL;
ALTER TABLE PP_PRODUCT_BOMLINE MODIFY (BACKFLUSHGROUP VARCHAR2(20 CHAR),DESCRIPTION VARCHAR2(255 CHAR),FEATURE VARCHAR2(30 CHAR),HELP VARCHAR2(2000 CHAR),PP_PRODUCT_BOMLINE_UU VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_BOMLINE SET BACKFLUSHGROUP=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,FEATURE=tmp_col_3_tmp,HELP=tmp_col_4_tmp,PP_PRODUCT_BOMLINE_UU=tmp_col_5_tmp;
ALTER TABLE PP_PRODUCT_BOMLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table PP_PRODUCT_BOMLINE_TRL
ALTER TABLE PP_PRODUCT_BOMLINE_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_BOMLINE_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=PP_PRODUCT_BOMLINE_TRL_UU,PP_PRODUCT_BOMLINE_TRL_UU=NULL;
ALTER TABLE PP_PRODUCT_BOMLINE_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),PP_PRODUCT_BOMLINE_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_BOMLINE_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,PP_PRODUCT_BOMLINE_TRL_UU=tmp_col_3_tmp;
ALTER TABLE PP_PRODUCT_BOMLINE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table PP_PRODUCT_BOM_TRL
ALTER TABLE PP_PRODUCT_BOM_TRL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE PP_PRODUCT_BOM_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE PP_PRODUCT_BOM_TRL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PP_PRODUCT_BOM_TRL_UU,PP_PRODUCT_BOM_TRL_UU=NULL;
ALTER TABLE PP_PRODUCT_BOM_TRL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PP_PRODUCT_BOM_TRL_UU VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_BOM_TRL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PP_PRODUCT_BOM_TRL_UU=tmp_col_4_tmp;
ALTER TABLE PP_PRODUCT_BOM_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE PP_PRODUCT_BOM_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table PP_PRODUCT_PLANNING
ALTER TABLE PP_PRODUCT_PLANNING ADD (tmp_col_1_tmp VARCHAR2(3 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_PLANNING SET tmp_col_1_tmp=ORDER_POLICY,ORDER_POLICY=NULL,tmp_col_2_tmp=PP_PRODUCT_PLANNING_UU,PP_PRODUCT_PLANNING_UU=NULL;
ALTER TABLE PP_PRODUCT_PLANNING MODIFY (ORDER_POLICY VARCHAR2(3 CHAR),PP_PRODUCT_PLANNING_UU VARCHAR2(36 CHAR));
UPDATE PP_PRODUCT_PLANNING SET ORDER_POLICY=tmp_col_1_tmp,PP_PRODUCT_PLANNING_UU=tmp_col_2_tmp;
ALTER TABLE PP_PRODUCT_PLANNING DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table PP_WF_NODE_ASSET
ALTER TABLE PP_WF_NODE_ASSET ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_WF_NODE_ASSET SET tmp_col_1_tmp=PP_WF_NODE_ASSET_UU,PP_WF_NODE_ASSET_UU=NULL;
ALTER TABLE PP_WF_NODE_ASSET MODIFY (PP_WF_NODE_ASSET_UU VARCHAR2(36 CHAR));
UPDATE PP_WF_NODE_ASSET SET PP_WF_NODE_ASSET_UU=tmp_col_1_tmp;
ALTER TABLE PP_WF_NODE_ASSET DROP (tmp_col_1_tmp);

-- Processing table PP_WF_NODE_PRODUCT
ALTER TABLE PP_WF_NODE_PRODUCT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE PP_WF_NODE_PRODUCT SET tmp_col_1_tmp=PP_WF_NODE_PRODUCT_UU,PP_WF_NODE_PRODUCT_UU=NULL;
ALTER TABLE PP_WF_NODE_PRODUCT MODIFY (PP_WF_NODE_PRODUCT_UU VARCHAR2(36 CHAR));
UPDATE PP_WF_NODE_PRODUCT SET PP_WF_NODE_PRODUCT_UU=tmp_col_1_tmp;
ALTER TABLE PP_WF_NODE_PRODUCT DROP (tmp_col_1_tmp);

-- Processing table QM_SPECIFICATION
ALTER TABLE QM_SPECIFICATION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
UPDATE QM_SPECIFICATION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=QM_SPECIFICATION_UU,QM_SPECIFICATION_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE QM_SPECIFICATION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),QM_SPECIFICATION_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE QM_SPECIFICATION SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,QM_SPECIFICATION_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE QM_SPECIFICATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table QM_SPECIFICATIONLINE
ALTER TABLE QM_SPECIFICATIONLINE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR),tmp_col_2_tmp VARCHAR2(22 CHAR),tmp_col_3_tmp VARCHAR2(40 CHAR));
UPDATE QM_SPECIFICATIONLINE SET tmp_col_1_tmp=QM_SPECIFICATIONLINE_UU,QM_SPECIFICATIONLINE_UU=NULL,tmp_col_2_tmp=VALIDFROM,VALIDFROM=NULL,tmp_col_3_tmp=VALUE,VALUE=NULL;
ALTER TABLE QM_SPECIFICATIONLINE MODIFY (QM_SPECIFICATIONLINE_UU VARCHAR2(36 CHAR),VALIDFROM VARCHAR2(22 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE QM_SPECIFICATIONLINE SET QM_SPECIFICATIONLINE_UU=tmp_col_1_tmp,VALIDFROM=tmp_col_2_tmp,VALUE=tmp_col_3_tmp;
ALTER TABLE QM_SPECIFICATIONLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_CATEGORY
ALTER TABLE R_CATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_CATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_CATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_CATEGORY_UU,R_CATEGORY_UU=NULL;
ALTER TABLE R_CATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_CATEGORY_UU VARCHAR2(36 CHAR));
UPDATE R_CATEGORY SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_CATEGORY_UU=tmp_col_4_tmp;
ALTER TABLE R_CATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_CATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_CATEGORYUPDATES
ALTER TABLE R_CATEGORYUPDATES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE R_CATEGORYUPDATES SET tmp_col_1_tmp=R_CATEGORYUPDATES_UU,R_CATEGORYUPDATES_UU=NULL;
ALTER TABLE R_CATEGORYUPDATES MODIFY (R_CATEGORYUPDATES_UU VARCHAR2(36 CHAR));
UPDATE R_CATEGORYUPDATES SET R_CATEGORYUPDATES_UU=tmp_col_1_tmp;
ALTER TABLE R_CATEGORYUPDATES DROP (tmp_col_1_tmp);

-- Processing table R_CONTACTINTEREST
ALTER TABLE R_CONTACTINTEREST ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE R_CONTACTINTEREST SET tmp_col_1_tmp=R_CONTACTINTEREST_UU,R_CONTACTINTEREST_UU=NULL;
ALTER TABLE R_CONTACTINTEREST MODIFY (R_CONTACTINTEREST_UU VARCHAR2(36 CHAR));
UPDATE R_CONTACTINTEREST SET R_CONTACTINTEREST_UU=tmp_col_1_tmp;
ALTER TABLE R_CONTACTINTEREST DROP (tmp_col_1_tmp);

-- Processing table R_GROUP
ALTER TABLE R_GROUP ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_GROUP MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_GROUP SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_GROUP_UU,R_GROUP_UU=NULL;
ALTER TABLE R_GROUP MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_GROUP_UU VARCHAR2(36 CHAR));
UPDATE R_GROUP SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_GROUP_UU=tmp_col_4_tmp;
ALTER TABLE R_GROUP MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_GROUP DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_GROUPUPDATES
ALTER TABLE R_GROUPUPDATES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE R_GROUPUPDATES SET tmp_col_1_tmp=R_GROUPUPDATES_UU,R_GROUPUPDATES_UU=NULL;
ALTER TABLE R_GROUPUPDATES MODIFY (R_GROUPUPDATES_UU VARCHAR2(36 CHAR));
UPDATE R_GROUPUPDATES SET R_GROUPUPDATES_UU=tmp_col_1_tmp;
ALTER TABLE R_GROUPUPDATES DROP (tmp_col_1_tmp);

-- Processing table R_INTERESTAREA
ALTER TABLE R_INTERESTAREA ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE R_INTERESTAREA MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE R_INTERESTAREA SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=R_INTERESTAREA_UU,R_INTERESTAREA_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE R_INTERESTAREA MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),R_INTERESTAREA_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR) DEFAULT NULL );
UPDATE R_INTERESTAREA SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,R_INTERESTAREA_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE R_INTERESTAREA MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) DEFAULT NULL  NOT NULL);
ALTER TABLE R_INTERESTAREA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_ISSUEKNOWN
ALTER TABLE R_ISSUEKNOWN ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(10 CHAR),tmp_col_6_tmp VARCHAR2(36 CHAR),tmp_col_7_tmp VARCHAR2(60 CHAR),tmp_col_8_tmp VARCHAR2(60 CHAR));
ALTER TABLE R_ISSUEKNOWN MODIFY (ISSUESUMMARY NVARCHAR2(255) NULL,RELEASENO NVARCHAR2(10) NULL);
UPDATE R_ISSUEKNOWN SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=ISSUESTATUS,ISSUESTATUS=NULL,tmp_col_3_tmp=ISSUESUMMARY,ISSUESUMMARY=NULL,tmp_col_4_tmp=LOGGERNAME,LOGGERNAME=NULL,tmp_col_5_tmp=RELEASENO,RELEASENO=NULL,tmp_col_6_tmp=R_ISSUEKNOWN_UU,R_ISSUEKNOWN_UU=NULL,tmp_col_7_tmp=SOURCECLASSNAME,SOURCECLASSNAME=NULL,tmp_col_8_tmp=SOURCEMETHODNAME,SOURCEMETHODNAME=NULL;
ALTER TABLE R_ISSUEKNOWN MODIFY (DESCRIPTION VARCHAR2(255 CHAR),ISSUESTATUS VARCHAR2(2000 CHAR),ISSUESUMMARY VARCHAR2(255 CHAR),LOGGERNAME VARCHAR2(60 CHAR),RELEASENO VARCHAR2(10 CHAR),R_ISSUEKNOWN_UU VARCHAR2(36 CHAR),SOURCECLASSNAME VARCHAR2(60 CHAR),SOURCEMETHODNAME VARCHAR2(60 CHAR));
UPDATE R_ISSUEKNOWN SET DESCRIPTION=tmp_col_1_tmp,ISSUESTATUS=tmp_col_2_tmp,ISSUESUMMARY=tmp_col_3_tmp,LOGGERNAME=tmp_col_4_tmp,RELEASENO=tmp_col_5_tmp,R_ISSUEKNOWN_UU=tmp_col_6_tmp,SOURCECLASSNAME=tmp_col_7_tmp,SOURCEMETHODNAME=tmp_col_8_tmp;
ALTER TABLE R_ISSUEKNOWN MODIFY (ISSUESUMMARY VARCHAR2(255 CHAR) NOT NULL,RELEASENO VARCHAR2(10 CHAR) NOT NULL);
ALTER TABLE R_ISSUEKNOWN DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table R_ISSUEPROJECT
ALTER TABLE R_ISSUEPROJECT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR));
ALTER TABLE R_ISSUEPROJECT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_ISSUEPROJECT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PROFILEINFO,PROFILEINFO=NULL,tmp_col_4_tmp=R_ISSUEPROJECT_UU,R_ISSUEPROJECT_UU=NULL,tmp_col_5_tmp=STATISTICSINFO,STATISTICSINFO=NULL;
ALTER TABLE R_ISSUEPROJECT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PROFILEINFO VARCHAR2(60 CHAR),R_ISSUEPROJECT_UU VARCHAR2(36 CHAR),STATISTICSINFO VARCHAR2(60 CHAR));
UPDATE R_ISSUEPROJECT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PROFILEINFO=tmp_col_3_tmp,R_ISSUEPROJECT_UU=tmp_col_4_tmp,STATISTICSINFO=tmp_col_5_tmp;
ALTER TABLE R_ISSUEPROJECT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_ISSUEPROJECT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_ISSUERECOMMENDATION
ALTER TABLE R_ISSUERECOMMENDATION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_ISSUERECOMMENDATION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_ISSUERECOMMENDATION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_ISSUERECOMMENDATION_UU,R_ISSUERECOMMENDATION_UU=NULL;
ALTER TABLE R_ISSUERECOMMENDATION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_ISSUERECOMMENDATION_UU VARCHAR2(36 CHAR));
UPDATE R_ISSUERECOMMENDATION SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_ISSUERECOMMENDATION_UU=tmp_col_4_tmp;
ALTER TABLE R_ISSUERECOMMENDATION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_ISSUERECOMMENDATION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_ISSUESOURCE
ALTER TABLE R_ISSUESOURCE ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR));
UPDATE R_ISSUESOURCE SET tmp_col_1_tmp=PROFILEINFO,PROFILEINFO=NULL,tmp_col_2_tmp=STATISTICSINFO,STATISTICSINFO=NULL;
ALTER TABLE R_ISSUESOURCE MODIFY (PROFILEINFO VARCHAR2(60 CHAR),STATISTICSINFO VARCHAR2(60 CHAR));
UPDATE R_ISSUESOURCE SET PROFILEINFO=tmp_col_1_tmp,STATISTICSINFO=tmp_col_2_tmp;
ALTER TABLE R_ISSUESOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table R_ISSUESTATUS
ALTER TABLE R_ISSUESTATUS ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_ISSUESTATUS MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_ISSUESTATUS SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=R_ISSUESTATUS_UU,R_ISSUESTATUS_UU=NULL;
ALTER TABLE R_ISSUESTATUS MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),R_ISSUESTATUS_UU VARCHAR2(36 CHAR));
UPDATE R_ISSUESTATUS SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,R_ISSUESTATUS_UU=tmp_col_3_tmp;
ALTER TABLE R_ISSUESTATUS MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_ISSUESTATUS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_ISSUESYSTEM
ALTER TABLE R_ISSUESYSTEM ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR));
ALTER TABLE R_ISSUESYSTEM MODIFY (DBADDRESS NVARCHAR2(255) NULL);
UPDATE R_ISSUESYSTEM SET tmp_col_1_tmp=DBADDRESS,DBADDRESS=NULL,tmp_col_2_tmp=PROFILEINFO,PROFILEINFO=NULL,tmp_col_3_tmp=R_ISSUESYSTEM_UU,R_ISSUESYSTEM_UU=NULL,tmp_col_4_tmp=STATISTICSINFO,STATISTICSINFO=NULL;
ALTER TABLE R_ISSUESYSTEM MODIFY (DBADDRESS VARCHAR2(255 CHAR),PROFILEINFO VARCHAR2(60 CHAR),R_ISSUESYSTEM_UU VARCHAR2(36 CHAR),STATISTICSINFO VARCHAR2(60 CHAR));
UPDATE R_ISSUESYSTEM SET DBADDRESS=tmp_col_1_tmp,PROFILEINFO=tmp_col_2_tmp,R_ISSUESYSTEM_UU=tmp_col_3_tmp,STATISTICSINFO=tmp_col_4_tmp;
ALTER TABLE R_ISSUESYSTEM MODIFY (DBADDRESS VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE R_ISSUESYSTEM DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_ISSUEUSER
ALTER TABLE R_ISSUEUSER ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR));
ALTER TABLE R_ISSUEUSER MODIFY (USERNAME NVARCHAR2(60) NULL);
UPDATE R_ISSUEUSER SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=R_ISSUEUSER_UU,R_ISSUEUSER_UU=NULL,tmp_col_3_tmp=USERNAME,USERNAME=NULL;
ALTER TABLE R_ISSUEUSER MODIFY (DESCRIPTION VARCHAR2(255 CHAR),R_ISSUEUSER_UU VARCHAR2(36 CHAR),USERNAME VARCHAR2(60 CHAR));
UPDATE R_ISSUEUSER SET DESCRIPTION=tmp_col_1_tmp,R_ISSUEUSER_UU=tmp_col_2_tmp,USERNAME=tmp_col_3_tmp;
ALTER TABLE R_ISSUEUSER MODIFY (USERNAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_ISSUEUSER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_MAILTEXT
ALTER TABLE R_MAILTEXT ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_MAILTEXT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_MAILTEXT SET tmp_col_1_tmp=MAILHEADER,MAILHEADER=NULL,tmp_col_2_tmp=MAILTEXT2,MAILTEXT2=NULL,tmp_col_3_tmp=MAILTEXT3,MAILTEXT3=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=R_MAILTEXT_UU,R_MAILTEXT_UU=NULL;
ALTER TABLE R_MAILTEXT MODIFY (MAILHEADER VARCHAR2(2000 CHAR),MAILTEXT2 VARCHAR2(2000 CHAR),MAILTEXT3 VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_MAILTEXT_UU VARCHAR2(36 CHAR));
UPDATE R_MAILTEXT SET MAILHEADER=tmp_col_1_tmp,MAILTEXT2=tmp_col_2_tmp,MAILTEXT3=tmp_col_3_tmp,NAME=tmp_col_4_tmp,R_MAILTEXT_UU=tmp_col_5_tmp;
ALTER TABLE R_MAILTEXT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_MAILTEXT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_MAILTEXT_TRL
ALTER TABLE R_MAILTEXT_TRL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_MAILTEXT_TRL MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_MAILTEXT_TRL SET tmp_col_1_tmp=MAILHEADER,MAILHEADER=NULL,tmp_col_2_tmp=MAILTEXT2,MAILTEXT2=NULL,tmp_col_3_tmp=MAILTEXT3,MAILTEXT3=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=R_MAILTEXT_TRL_UU,R_MAILTEXT_TRL_UU=NULL;
ALTER TABLE R_MAILTEXT_TRL MODIFY (MAILHEADER VARCHAR2(2000 CHAR),MAILTEXT2 VARCHAR2(2000 CHAR),MAILTEXT3 VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_MAILTEXT_TRL_UU VARCHAR2(36 CHAR));
UPDATE R_MAILTEXT_TRL SET MAILHEADER=tmp_col_1_tmp,MAILTEXT2=tmp_col_2_tmp,MAILTEXT3=tmp_col_3_tmp,NAME=tmp_col_4_tmp,R_MAILTEXT_TRL_UU=tmp_col_5_tmp;
ALTER TABLE R_MAILTEXT_TRL MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_MAILTEXT_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_REQUEST
ALTER TABLE R_REQUEST ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
ALTER TABLE R_REQUEST MODIFY (DOCUMENTNO NVARCHAR2(30) NULL,SUMMARY NVARCHAR2(2000) NULL);
UPDATE R_REQUEST SET tmp_col_1_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_2_tmp=LASTRESULT,LASTRESULT=NULL,tmp_col_3_tmp=RESULT,RESULT=NULL,tmp_col_4_tmp=R_REQUEST_UU,R_REQUEST_UU=NULL,tmp_col_5_tmp=SUMMARY,SUMMARY=NULL;
ALTER TABLE R_REQUEST MODIFY (DOCUMENTNO VARCHAR2(30 CHAR),LASTRESULT VARCHAR2(2000 CHAR),RESULT VARCHAR2(2000 CHAR),R_REQUEST_UU VARCHAR2(36 CHAR),SUMMARY VARCHAR2(2000 CHAR));
UPDATE R_REQUEST SET DOCUMENTNO=tmp_col_1_tmp,LASTRESULT=tmp_col_2_tmp,RESULT=tmp_col_3_tmp,R_REQUEST_UU=tmp_col_4_tmp,SUMMARY=tmp_col_5_tmp;
ALTER TABLE R_REQUEST MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL,SUMMARY VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE R_REQUEST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_REQUESTACTION
ALTER TABLE R_REQUESTACTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR));
UPDATE R_REQUESTACTION SET tmp_col_1_tmp=NULLCOLUMNS,NULLCOLUMNS=NULL,tmp_col_2_tmp=R_REQUESTACTION_UU,R_REQUESTACTION_UU=NULL,tmp_col_3_tmp=SUMMARY,SUMMARY=NULL;
ALTER TABLE R_REQUESTACTION MODIFY (NULLCOLUMNS VARCHAR2(255 CHAR),R_REQUESTACTION_UU VARCHAR2(36 CHAR),SUMMARY VARCHAR2(2000 CHAR));
UPDATE R_REQUESTACTION SET NULLCOLUMNS=tmp_col_1_tmp,R_REQUESTACTION_UU=tmp_col_2_tmp,SUMMARY=tmp_col_3_tmp;
ALTER TABLE R_REQUESTACTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_REQUESTPROCESSOR
ALTER TABLE R_REQUESTPROCESSOR ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_REQUESTPROCESSOR MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_REQUESTPROCESSOR SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=R_REQUESTPROCESSOR_UU,R_REQUESTPROCESSOR_UU=NULL;
ALTER TABLE R_REQUESTPROCESSOR MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),R_REQUESTPROCESSOR_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTPROCESSOR SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,R_REQUESTPROCESSOR_UU=tmp_col_3_tmp;
ALTER TABLE R_REQUESTPROCESSOR MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_REQUESTPROCESSOR DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_REQUESTPROCESSORLOG
ALTER TABLE R_REQUESTPROCESSORLOG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR));
UPDATE R_REQUESTPROCESSORLOG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=REFERENCE,REFERENCE=NULL,tmp_col_3_tmp=R_REQUESTPROCESSORLOG_UU,R_REQUESTPROCESSORLOG_UU=NULL,tmp_col_4_tmp=SUMMARY,SUMMARY=NULL,tmp_col_5_tmp=TEXTMSG,TEXTMSG=NULL;
ALTER TABLE R_REQUESTPROCESSORLOG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),REFERENCE VARCHAR2(60 CHAR),R_REQUESTPROCESSORLOG_UU VARCHAR2(36 CHAR),SUMMARY VARCHAR2(2000 CHAR),TEXTMSG VARCHAR2(2000 CHAR));
UPDATE R_REQUESTPROCESSORLOG SET DESCRIPTION=tmp_col_1_tmp,REFERENCE=tmp_col_2_tmp,R_REQUESTPROCESSORLOG_UU=tmp_col_3_tmp,SUMMARY=tmp_col_4_tmp,TEXTMSG=tmp_col_5_tmp;
ALTER TABLE R_REQUESTPROCESSORLOG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_REQUESTPROCESSOR_ROUTE
ALTER TABLE R_REQUESTPROCESSOR_ROUTE ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE R_REQUESTPROCESSOR_ROUTE SET tmp_col_1_tmp=KEYWORD,KEYWORD=NULL,tmp_col_2_tmp=R_REQUESTPROCESSOR_ROUTE_UU,R_REQUESTPROCESSOR_ROUTE_UU=NULL;
ALTER TABLE R_REQUESTPROCESSOR_ROUTE MODIFY (KEYWORD VARCHAR2(60 CHAR),R_REQUESTPROCESSOR_ROUTE_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTPROCESSOR_ROUTE SET KEYWORD=tmp_col_1_tmp,R_REQUESTPROCESSOR_ROUTE_UU=tmp_col_2_tmp;
ALTER TABLE R_REQUESTPROCESSOR_ROUTE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table R_REQUESTTYPE
ALTER TABLE R_REQUESTTYPE ADD (tmp_col_1_tmp VARCHAR2(7 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(7 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_REQUESTTYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_REQUESTTYPE SET tmp_col_1_tmp=CONTENTCOLOR,CONTENTCOLOR=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HEADERCOLOR,HEADERCOLOR=NULL,tmp_col_4_tmp=NAME,NAME=NULL,tmp_col_5_tmp=R_REQUESTTYPE_UU,R_REQUESTTYPE_UU=NULL;
ALTER TABLE R_REQUESTTYPE MODIFY (CONTENTCOLOR VARCHAR2(7 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HEADERCOLOR VARCHAR2(7 CHAR),NAME VARCHAR2(60 CHAR),R_REQUESTTYPE_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTTYPE SET CONTENTCOLOR=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HEADERCOLOR=tmp_col_3_tmp,NAME=tmp_col_4_tmp,R_REQUESTTYPE_UU=tmp_col_5_tmp;
ALTER TABLE R_REQUESTTYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_REQUESTTYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_REQUESTTYPEUPDATES
ALTER TABLE R_REQUESTTYPEUPDATES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE R_REQUESTTYPEUPDATES SET tmp_col_1_tmp=R_REQUESTTYPEUPDATES_UU,R_REQUESTTYPEUPDATES_UU=NULL;
ALTER TABLE R_REQUESTTYPEUPDATES MODIFY (R_REQUESTTYPEUPDATES_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTTYPEUPDATES SET R_REQUESTTYPEUPDATES_UU=tmp_col_1_tmp;
ALTER TABLE R_REQUESTTYPEUPDATES DROP (tmp_col_1_tmp);

-- Processing table R_REQUESTUPDATE
ALTER TABLE R_REQUESTUPDATE ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE R_REQUESTUPDATE SET tmp_col_1_tmp=RESULT,RESULT=NULL,tmp_col_2_tmp=R_REQUESTUPDATE_UU,R_REQUESTUPDATE_UU=NULL;
ALTER TABLE R_REQUESTUPDATE MODIFY (RESULT VARCHAR2(2000 CHAR),R_REQUESTUPDATE_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTUPDATE SET RESULT=tmp_col_1_tmp,R_REQUESTUPDATE_UU=tmp_col_2_tmp;
ALTER TABLE R_REQUESTUPDATE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table R_REQUESTUPDATES
ALTER TABLE R_REQUESTUPDATES ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE R_REQUESTUPDATES SET tmp_col_1_tmp=R_REQUESTUPDATES_UU,R_REQUESTUPDATES_UU=NULL;
ALTER TABLE R_REQUESTUPDATES MODIFY (R_REQUESTUPDATES_UU VARCHAR2(36 CHAR));
UPDATE R_REQUESTUPDATES SET R_REQUESTUPDATES_UU=tmp_col_1_tmp;
ALTER TABLE R_REQUESTUPDATES DROP (tmp_col_1_tmp);

-- Processing table R_RESOLUTION
ALTER TABLE R_RESOLUTION ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_RESOLUTION MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_RESOLUTION SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_RESOLUTION_UU,R_RESOLUTION_UU=NULL;
ALTER TABLE R_RESOLUTION MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_RESOLUTION_UU VARCHAR2(36 CHAR));
UPDATE R_RESOLUTION SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_RESOLUTION_UU=tmp_col_4_tmp;
ALTER TABLE R_RESOLUTION MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_RESOLUTION DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table R_STANDARDRESPONSE
ALTER TABLE R_STANDARDRESPONSE ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_STANDARDRESPONSE MODIFY (NAME NVARCHAR2(60) NULL,RESPONSETEXT NVARCHAR2(2000) NULL);
UPDATE R_STANDARDRESPONSE SET tmp_col_1_tmp=NAME,NAME=NULL,tmp_col_2_tmp=RESPONSETEXT,RESPONSETEXT=NULL,tmp_col_3_tmp=R_STANDARDRESPONSE_UU,R_STANDARDRESPONSE_UU=NULL;
ALTER TABLE R_STANDARDRESPONSE MODIFY (NAME VARCHAR2(60 CHAR),RESPONSETEXT VARCHAR2(2000 CHAR),R_STANDARDRESPONSE_UU VARCHAR2(36 CHAR));
UPDATE R_STANDARDRESPONSE SET NAME=tmp_col_1_tmp,RESPONSETEXT=tmp_col_2_tmp,R_STANDARDRESPONSE_UU=tmp_col_3_tmp;
ALTER TABLE R_STANDARDRESPONSE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,RESPONSETEXT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE R_STANDARDRESPONSE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table R_STATUS
ALTER TABLE R_STATUS ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR),tmp_col_5_tmp VARCHAR2(40 CHAR));
ALTER TABLE R_STATUS MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE R_STATUS SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_STATUS_UU,R_STATUS_UU=NULL,tmp_col_5_tmp=VALUE,VALUE=NULL;
ALTER TABLE R_STATUS MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_STATUS_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE R_STATUS SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_STATUS_UU=tmp_col_4_tmp,VALUE=tmp_col_5_tmp;
ALTER TABLE R_STATUS MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE R_STATUS DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table R_STATUSCATEGORY
ALTER TABLE R_STATUSCATEGORY ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE R_STATUSCATEGORY MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE R_STATUSCATEGORY SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=R_STATUSCATEGORY_UU,R_STATUSCATEGORY_UU=NULL;
ALTER TABLE R_STATUSCATEGORY MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),R_STATUSCATEGORY_UU VARCHAR2(36 CHAR));
UPDATE R_STATUSCATEGORY SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,R_STATUSCATEGORY_UU=tmp_col_4_tmp;
ALTER TABLE R_STATUSCATEGORY MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE R_STATUSCATEGORY DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table S_EXPENSETYPE
ALTER TABLE S_EXPENSETYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE S_EXPENSETYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE S_EXPENSETYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=S_EXPENSETYPE_UU,S_EXPENSETYPE_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE S_EXPENSETYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),S_EXPENSETYPE_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE S_EXPENSETYPE SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,S_EXPENSETYPE_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE S_EXPENSETYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE S_EXPENSETYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table S_RESOURCE
ALTER TABLE S_RESOURCE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE S_RESOURCE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE S_RESOURCE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=S_RESOURCE_UU,S_RESOURCE_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE S_RESOURCE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),S_RESOURCE_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE S_RESOURCE SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,S_RESOURCE_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE S_RESOURCE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE S_RESOURCE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table S_RESOURCEASSIGNMENT
ALTER TABLE S_RESOURCEASSIGNMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE S_RESOURCEASSIGNMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE S_RESOURCEASSIGNMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=S_RESOURCEASSIGNMENT_UU,S_RESOURCEASSIGNMENT_UU=NULL;
ALTER TABLE S_RESOURCEASSIGNMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),S_RESOURCEASSIGNMENT_UU VARCHAR2(36 CHAR));
UPDATE S_RESOURCEASSIGNMENT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,S_RESOURCEASSIGNMENT_UU=tmp_col_3_tmp;
ALTER TABLE S_RESOURCEASSIGNMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE S_RESOURCEASSIGNMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table S_RESOURCETYPE
ALTER TABLE S_RESOURCETYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE S_RESOURCETYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE S_RESOURCETYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=S_RESOURCETYPE_UU,S_RESOURCETYPE_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE S_RESOURCETYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),S_RESOURCETYPE_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE S_RESOURCETYPE SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,S_RESOURCETYPE_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE S_RESOURCETYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE S_RESOURCETYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table S_RESOURCEUNAVAILABLE
ALTER TABLE S_RESOURCEUNAVAILABLE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE S_RESOURCEUNAVAILABLE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=S_RESOURCEUNAVAILABLE_UU,S_RESOURCEUNAVAILABLE_UU=NULL;
ALTER TABLE S_RESOURCEUNAVAILABLE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),S_RESOURCEUNAVAILABLE_UU VARCHAR2(36 CHAR));
UPDATE S_RESOURCEUNAVAILABLE SET DESCRIPTION=tmp_col_1_tmp,S_RESOURCEUNAVAILABLE_UU=tmp_col_2_tmp;
ALTER TABLE S_RESOURCEUNAVAILABLE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table S_TIMEEXPENSE
ALTER TABLE S_TIMEEXPENSE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(30 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE S_TIMEEXPENSE MODIFY (DOCUMENTNO NVARCHAR2(30) NULL);
UPDATE S_TIMEEXPENSE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_3_tmp=S_TIMEEXPENSE_UU,S_TIMEEXPENSE_UU=NULL;
ALTER TABLE S_TIMEEXPENSE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(30 CHAR),S_TIMEEXPENSE_UU VARCHAR2(36 CHAR));
UPDATE S_TIMEEXPENSE SET DESCRIPTION=tmp_col_1_tmp,DOCUMENTNO=tmp_col_2_tmp,S_TIMEEXPENSE_UU=tmp_col_3_tmp;
ALTER TABLE S_TIMEEXPENSE MODIFY (DOCUMENTNO VARCHAR2(30 CHAR) NOT NULL);
ALTER TABLE S_TIMEEXPENSE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table S_TIMEEXPENSELINE
ALTER TABLE S_TIMEEXPENSELINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE S_TIMEEXPENSELINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NOTE,NOTE=NULL,tmp_col_3_tmp=S_TIMEEXPENSELINE_UU,S_TIMEEXPENSELINE_UU=NULL;
ALTER TABLE S_TIMEEXPENSELINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NOTE VARCHAR2(255 CHAR),S_TIMEEXPENSELINE_UU VARCHAR2(36 CHAR));
UPDATE S_TIMEEXPENSELINE SET DESCRIPTION=tmp_col_1_tmp,NOTE=tmp_col_2_tmp,S_TIMEEXPENSELINE_UU=tmp_col_3_tmp;
ALTER TABLE S_TIMEEXPENSELINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table S_TIMETYPE
ALTER TABLE S_TIMETYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE S_TIMETYPE MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE S_TIMETYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=S_TIMETYPE_UU,S_TIMETYPE_UU=NULL;
ALTER TABLE S_TIMETYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),S_TIMETYPE_UU VARCHAR2(36 CHAR));
UPDATE S_TIMETYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,S_TIMETYPE_UU=tmp_col_4_tmp;
ALTER TABLE S_TIMETYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE S_TIMETYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table S_TRAINING
ALTER TABLE S_TRAINING ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(120 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(36 CHAR));
ALTER TABLE S_TRAINING MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE S_TRAINING SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=DESCRIPTIONURL,DESCRIPTIONURL=NULL,tmp_col_3_tmp=DOCUMENTNOTE,DOCUMENTNOTE=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_6_tmp=NAME,NAME=NULL,tmp_col_7_tmp=S_TRAINING_UU,S_TRAINING_UU=NULL;
ALTER TABLE S_TRAINING MODIFY (DESCRIPTION VARCHAR2(255 CHAR),DESCRIPTIONURL VARCHAR2(120 CHAR),DOCUMENTNOTE VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR),S_TRAINING_UU VARCHAR2(36 CHAR));
UPDATE S_TRAINING SET DESCRIPTION=tmp_col_1_tmp,DESCRIPTIONURL=tmp_col_2_tmp,DOCUMENTNOTE=tmp_col_3_tmp,HELP=tmp_col_4_tmp,IMAGEURL=tmp_col_5_tmp,NAME=tmp_col_6_tmp,S_TRAINING_UU=tmp_col_7_tmp;
ALTER TABLE S_TRAINING MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE S_TRAINING DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table S_TRAINING_CLASS
ALTER TABLE S_TRAINING_CLASS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE S_TRAINING_CLASS SET tmp_col_1_tmp=S_TRAINING_CLASS_UU,S_TRAINING_CLASS_UU=NULL;
ALTER TABLE S_TRAINING_CLASS MODIFY (S_TRAINING_CLASS_UU VARCHAR2(36 CHAR));
UPDATE S_TRAINING_CLASS SET S_TRAINING_CLASS_UU=tmp_col_1_tmp;
ALTER TABLE S_TRAINING_CLASS DROP (tmp_col_1_tmp);

-- Processing table TEST
ALTER TABLE TEST ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE TEST MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE TEST SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=TEST_UU,TEST_UU=NULL;
ALTER TABLE TEST MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),TEST_UU VARCHAR2(36 CHAR));
UPDATE TEST SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,TEST_UU=tmp_col_4_tmp;
ALTER TABLE TEST MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE TEST DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table T_1099EXTRACT
ALTER TABLE T_1099EXTRACT ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(20 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR));
ALTER TABLE T_1099EXTRACT MODIFY (NAME NVARCHAR2(120) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE T_1099EXTRACT SET tmp_col_1_tmp=NAME,NAME=NULL,tmp_col_2_tmp=TAXID,TAXID=NULL,tmp_col_3_tmp=T_1099EXTRACT_UU,T_1099EXTRACT_UU=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL;
ALTER TABLE T_1099EXTRACT MODIFY (NAME VARCHAR2(120 CHAR),TAXID VARCHAR2(20 CHAR),T_1099EXTRACT_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE T_1099EXTRACT SET NAME=tmp_col_1_tmp,TAXID=tmp_col_2_tmp,T_1099EXTRACT_UU=tmp_col_3_tmp,VALUE=tmp_col_4_tmp;
ALTER TABLE T_1099EXTRACT MODIFY (NAME VARCHAR2(120 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE T_1099EXTRACT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table T_AGING
ALTER TABLE T_AGING ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_AGING SET tmp_col_1_tmp=T_AGING_UU,T_AGING_UU=NULL;
ALTER TABLE T_AGING MODIFY (T_AGING_UU VARCHAR2(36 CHAR));
UPDATE T_AGING SET T_AGING_UU=tmp_col_1_tmp;
ALTER TABLE T_AGING DROP (tmp_col_1_tmp);

-- Processing table T_BANKREGISTER
ALTER TABLE T_BANKREGISTER ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(255 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
UPDATE T_BANKREGISTER SET tmp_col_1_tmp=ACCOUNT,ACCOUNT=NULL,tmp_col_2_tmp=BANKNAME,BANKNAME=NULL,tmp_col_3_tmp=BPARTNER,BPARTNER=NULL,tmp_col_4_tmp=DOCUMENTNO,DOCUMENTNO=NULL,tmp_col_5_tmp=T_BANKREGISTER_UU,T_BANKREGISTER_UU=NULL;
ALTER TABLE T_BANKREGISTER MODIFY (ACCOUNT VARCHAR2(255 CHAR),BANKNAME VARCHAR2(255 CHAR),BPARTNER VARCHAR2(255 CHAR),DOCUMENTNO VARCHAR2(255 CHAR),T_BANKREGISTER_UU VARCHAR2(36 CHAR));
UPDATE T_BANKREGISTER SET ACCOUNT=tmp_col_1_tmp,BANKNAME=tmp_col_2_tmp,BPARTNER=tmp_col_3_tmp,DOCUMENTNO=tmp_col_4_tmp,T_BANKREGISTER_UU=tmp_col_5_tmp;
ALTER TABLE T_BANKREGISTER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table T_BOMLINE
ALTER TABLE T_BOMLINE ADD (tmp_col_1_tmp VARCHAR2(250 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE T_BOMLINE SET tmp_col_1_tmp=LEVELS,LEVELS=NULL,tmp_col_2_tmp=T_BOMLINE_UU,T_BOMLINE_UU=NULL;
ALTER TABLE T_BOMLINE MODIFY (LEVELS VARCHAR2(250 CHAR),T_BOMLINE_UU VARCHAR2(36 CHAR));
UPDATE T_BOMLINE SET LEVELS=tmp_col_1_tmp,T_BOMLINE_UU=tmp_col_2_tmp;
ALTER TABLE T_BOMLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table T_BOM_INDENTED
ALTER TABLE T_BOM_INDENTED ADD (tmp_col_1_tmp VARCHAR2(250 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE T_BOM_INDENTED SET tmp_col_1_tmp=LEVELS,LEVELS=NULL,tmp_col_2_tmp=T_BOM_INDENTED_UU,T_BOM_INDENTED_UU=NULL;
ALTER TABLE T_BOM_INDENTED MODIFY (LEVELS VARCHAR2(250 CHAR),T_BOM_INDENTED_UU VARCHAR2(36 CHAR));
UPDATE T_BOM_INDENTED SET LEVELS=tmp_col_1_tmp,T_BOM_INDENTED_UU=tmp_col_2_tmp;
ALTER TABLE T_BOM_INDENTED DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table T_CASHFLOW
ALTER TABLE T_CASHFLOW ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE T_CASHFLOW SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=T_CASHFLOW_UU,T_CASHFLOW_UU=NULL;
ALTER TABLE T_CASHFLOW MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),T_CASHFLOW_UU VARCHAR2(36 CHAR));
UPDATE T_CASHFLOW SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,T_CASHFLOW_UU=tmp_col_3_tmp;
ALTER TABLE T_CASHFLOW DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table T_DISTRIBUTIONRUNDETAIL
ALTER TABLE T_DISTRIBUTIONRUNDETAIL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_DISTRIBUTIONRUNDETAIL SET tmp_col_1_tmp=T_DISTRIBUTIONRUNDETAIL_UU,T_DISTRIBUTIONRUNDETAIL_UU=NULL;
ALTER TABLE T_DISTRIBUTIONRUNDETAIL MODIFY (T_DISTRIBUTIONRUNDETAIL_UU VARCHAR2(36 CHAR));
UPDATE T_DISTRIBUTIONRUNDETAIL SET T_DISTRIBUTIONRUNDETAIL_UU=tmp_col_1_tmp;
ALTER TABLE T_DISTRIBUTIONRUNDETAIL DROP (tmp_col_1_tmp);

-- Processing table T_INVENTORYVALUE
ALTER TABLE T_INVENTORYVALUE ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_INVENTORYVALUE SET tmp_col_1_tmp=T_INVENTORYVALUE_UU,T_INVENTORYVALUE_UU=NULL;
ALTER TABLE T_INVENTORYVALUE MODIFY (T_INVENTORYVALUE_UU VARCHAR2(36 CHAR));
UPDATE T_INVENTORYVALUE SET T_INVENTORYVALUE_UU=tmp_col_1_tmp;
ALTER TABLE T_INVENTORYVALUE DROP (tmp_col_1_tmp);

-- Processing table T_INVOICEGL
ALTER TABLE T_INVOICEGL ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_INVOICEGL SET tmp_col_1_tmp=T_INVOICEGL_UU,T_INVOICEGL_UU=NULL;
ALTER TABLE T_INVOICEGL MODIFY (T_INVOICEGL_UU VARCHAR2(36 CHAR));
UPDATE T_INVOICEGL SET T_INVOICEGL_UU=tmp_col_1_tmp;
ALTER TABLE T_INVOICEGL DROP (tmp_col_1_tmp);

-- Processing table T_MRP_CRP
ALTER TABLE T_MRP_CRP ADD (tmp_col_1_tmp VARCHAR2(50 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE T_MRP_CRP SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=T_MRP_CRP_UU,T_MRP_CRP_UU=NULL;
ALTER TABLE T_MRP_CRP MODIFY (DESCRIPTION VARCHAR2(50 CHAR),T_MRP_CRP_UU VARCHAR2(36 CHAR));
UPDATE T_MRP_CRP SET DESCRIPTION=tmp_col_1_tmp,T_MRP_CRP_UU=tmp_col_2_tmp;
ALTER TABLE T_MRP_CRP DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table T_RECONCILIATION
ALTER TABLE T_RECONCILIATION ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(36 CHAR));
UPDATE T_RECONCILIATION SET tmp_col_1_tmp=MATCHCODE,MATCHCODE=NULL,tmp_col_2_tmp=T_RECONCILIATION_UU,T_RECONCILIATION_UU=NULL;
ALTER TABLE T_RECONCILIATION MODIFY (MATCHCODE VARCHAR2(60 CHAR),T_RECONCILIATION_UU VARCHAR2(36 CHAR));
UPDATE T_RECONCILIATION SET MATCHCODE=tmp_col_1_tmp,T_RECONCILIATION_UU=tmp_col_2_tmp;
ALTER TABLE T_RECONCILIATION DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table T_REPLENISH
ALTER TABLE T_REPLENISH ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_REPLENISH SET tmp_col_1_tmp=T_REPLENISH_UU,T_REPLENISH_UU=NULL;
ALTER TABLE T_REPLENISH MODIFY (T_REPLENISH_UU VARCHAR2(36 CHAR));
UPDATE T_REPLENISH SET T_REPLENISH_UU=tmp_col_1_tmp;
ALTER TABLE T_REPLENISH DROP (tmp_col_1_tmp);

-- Processing table T_REPORT
ALTER TABLE T_REPORT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE T_REPORT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=T_REPORT_UU,T_REPORT_UU=NULL;
ALTER TABLE T_REPORT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),T_REPORT_UU VARCHAR2(36 CHAR));
UPDATE T_REPORT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,T_REPORT_UU=tmp_col_3_tmp;
ALTER TABLE T_REPORT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table T_REPORTSTATEMENT
ALTER TABLE T_REPORTSTATEMENT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE T_REPORTSTATEMENT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=T_REPORTSTATEMENT_UU,T_REPORTSTATEMENT_UU=NULL;
ALTER TABLE T_REPORTSTATEMENT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),T_REPORTSTATEMENT_UU VARCHAR2(36 CHAR));
UPDATE T_REPORTSTATEMENT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,T_REPORTSTATEMENT_UU=tmp_col_3_tmp;
ALTER TABLE T_REPORTSTATEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table T_SPOOL
ALTER TABLE T_SPOOL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR));
ALTER TABLE T_SPOOL MODIFY (MSGTEXT NVARCHAR2(2000) NULL);
UPDATE T_SPOOL SET tmp_col_1_tmp=MSGTEXT,MSGTEXT=NULL;
ALTER TABLE T_SPOOL MODIFY (MSGTEXT VARCHAR2(2000 CHAR));
UPDATE T_SPOOL SET MSGTEXT=tmp_col_1_tmp;
ALTER TABLE T_SPOOL MODIFY (MSGTEXT VARCHAR2(2000 CHAR) NOT NULL);
ALTER TABLE T_SPOOL DROP (tmp_col_1_tmp);

-- Processing table T_TRANSACTION
ALTER TABLE T_TRANSACTION ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE T_TRANSACTION SET tmp_col_1_tmp=T_TRANSACTION_UU,T_TRANSACTION_UU=NULL;
ALTER TABLE T_TRANSACTION MODIFY (T_TRANSACTION_UU VARCHAR2(36 CHAR));
UPDATE T_TRANSACTION SET T_TRANSACTION_UU=tmp_col_1_tmp;
ALTER TABLE T_TRANSACTION DROP (tmp_col_1_tmp);

-- Processing table T_TRIALBALANCE
ALTER TABLE T_TRIALBALANCE ADD (tmp_col_1_tmp VARCHAR2(40 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR));
UPDATE T_TRIALBALANCE SET tmp_col_1_tmp=ACCOUNTVALUE,ACCOUNTVALUE=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL;
ALTER TABLE T_TRIALBALANCE MODIFY (ACCOUNTVALUE VARCHAR2(40 CHAR),DESCRIPTION VARCHAR2(255 CHAR));
UPDATE T_TRIALBALANCE SET ACCOUNTVALUE=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp;
ALTER TABLE T_TRIALBALANCE DROP (tmp_col_1_tmp,tmp_col_2_tmp);

-- Processing table U_BLACKLISTCHEQUE
ALTER TABLE U_BLACKLISTCHEQUE ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(120 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE U_BLACKLISTCHEQUE MODIFY (BANKNAME NVARCHAR2(120) NULL,CHEQUENO NVARCHAR2(120) NULL);
UPDATE U_BLACKLISTCHEQUE SET tmp_col_1_tmp=BANKNAME,BANKNAME=NULL,tmp_col_2_tmp=CHEQUENO,CHEQUENO=NULL,tmp_col_3_tmp=U_BLACKLISTCHEQUE_UU,U_BLACKLISTCHEQUE_UU=NULL;
ALTER TABLE U_BLACKLISTCHEQUE MODIFY (BANKNAME VARCHAR2(120 CHAR),CHEQUENO VARCHAR2(120 CHAR),U_BLACKLISTCHEQUE_UU VARCHAR2(36 CHAR));
UPDATE U_BLACKLISTCHEQUE SET BANKNAME=tmp_col_1_tmp,CHEQUENO=tmp_col_2_tmp,U_BLACKLISTCHEQUE_UU=tmp_col_3_tmp;
ALTER TABLE U_BLACKLISTCHEQUE MODIFY (BANKNAME VARCHAR2(120 CHAR) NOT NULL,CHEQUENO VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE U_BLACKLISTCHEQUE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table U_POSTERMINAL
ALTER TABLE U_POSTERMINAL ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR),tmp_col_6_tmp VARCHAR2(40 CHAR));
UPDATE U_POSTERMINAL SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=PRINTERNAME,PRINTERNAME=NULL,tmp_col_5_tmp=U_POSTERMINAL_UU,U_POSTERMINAL_UU=NULL,tmp_col_6_tmp=VALUE,VALUE=NULL;
ALTER TABLE U_POSTERMINAL MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),PRINTERNAME VARCHAR2(60 CHAR),U_POSTERMINAL_UU VARCHAR2(36 CHAR),VALUE VARCHAR2(40 CHAR));
UPDATE U_POSTERMINAL SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,PRINTERNAME=tmp_col_4_tmp,U_POSTERMINAL_UU=tmp_col_5_tmp,VALUE=tmp_col_6_tmp;
ALTER TABLE U_POSTERMINAL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp);

-- Processing table U_ROLEMENU
ALTER TABLE U_ROLEMENU ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE U_ROLEMENU SET tmp_col_1_tmp=U_ROLEMENU_UU,U_ROLEMENU_UU=NULL;
ALTER TABLE U_ROLEMENU MODIFY (U_ROLEMENU_UU VARCHAR2(36 CHAR));
UPDATE U_ROLEMENU SET U_ROLEMENU_UU=tmp_col_1_tmp;
ALTER TABLE U_ROLEMENU DROP (tmp_col_1_tmp);

-- Processing table U_WEBMENU
ALTER TABLE U_WEBMENU ADD (tmp_col_1_tmp VARCHAR2(120 CHAR),tmp_col_2_tmp VARCHAR2(200 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(510 CHAR),tmp_col_5_tmp VARCHAR2(510 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(120 CHAR),tmp_col_8_tmp VARCHAR2(36 CHAR));
ALTER TABLE U_WEBMENU MODIFY (MENULINK NVARCHAR2(510) NULL,MODULE NVARCHAR2(120) NULL,NAME NVARCHAR2(120) NULL);
UPDATE U_WEBMENU SET tmp_col_1_tmp=CATEGORY,CATEGORY=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=IMAGELINK,IMAGELINK=NULL,tmp_col_5_tmp=MENULINK,MENULINK=NULL,tmp_col_6_tmp=MODULE,MODULE=NULL,tmp_col_7_tmp=NAME,NAME=NULL,tmp_col_8_tmp=U_WEBMENU_UU,U_WEBMENU_UU=NULL;
ALTER TABLE U_WEBMENU MODIFY (CATEGORY VARCHAR2(120 CHAR),DESCRIPTION VARCHAR2(200 CHAR),HELP VARCHAR2(2000 CHAR),IMAGELINK VARCHAR2(510 CHAR),MENULINK VARCHAR2(510 CHAR),MODULE VARCHAR2(120 CHAR),NAME VARCHAR2(120 CHAR),U_WEBMENU_UU VARCHAR2(36 CHAR));
UPDATE U_WEBMENU SET CATEGORY=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,IMAGELINK=tmp_col_4_tmp,MENULINK=tmp_col_5_tmp,MODULE=tmp_col_6_tmp,NAME=tmp_col_7_tmp,U_WEBMENU_UU=tmp_col_8_tmp;
ALTER TABLE U_WEBMENU MODIFY (MENULINK VARCHAR2(510 CHAR) NOT NULL,MODULE VARCHAR2(120 CHAR) NOT NULL,NAME VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE U_WEBMENU DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table U_WEB_PROPERTIES
ALTER TABLE U_WEB_PROPERTIES ADD (tmp_col_1_tmp VARCHAR2(240 CHAR),tmp_col_2_tmp VARCHAR2(240 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE U_WEB_PROPERTIES MODIFY (U_KEY NVARCHAR2(240) NULL,U_VALUE NVARCHAR2(240) NULL);
UPDATE U_WEB_PROPERTIES SET tmp_col_1_tmp=U_KEY,U_KEY=NULL,tmp_col_2_tmp=U_VALUE,U_VALUE=NULL,tmp_col_3_tmp=U_WEB_PROPERTIES_UU,U_WEB_PROPERTIES_UU=NULL;
ALTER TABLE U_WEB_PROPERTIES MODIFY (U_KEY VARCHAR2(240 CHAR),U_VALUE VARCHAR2(240 CHAR),U_WEB_PROPERTIES_UU VARCHAR2(36 CHAR));
UPDATE U_WEB_PROPERTIES SET U_KEY=tmp_col_1_tmp,U_VALUE=tmp_col_2_tmp,U_WEB_PROPERTIES_UU=tmp_col_3_tmp;
ALTER TABLE U_WEB_PROPERTIES MODIFY (U_KEY VARCHAR2(240 CHAR) NOT NULL,U_VALUE VARCHAR2(240 CHAR) NOT NULL);
ALTER TABLE U_WEB_PROPERTIES DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table WS_WEBSERVICE
ALTER TABLE WS_WEBSERVICE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE WS_WEBSERVICE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE WS_WEBSERVICE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL,tmp_col_5_tmp=WS_WEBSERVICE_UU,WS_WEBSERVICE_UU=NULL;
ALTER TABLE WS_WEBSERVICE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),WS_WEBSERVICE_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp,WS_WEBSERVICE_UU=tmp_col_5_tmp;
ALTER TABLE WS_WEBSERVICE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE WS_WEBSERVICE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table WS_WEBSERVICEFIELDINPUT
ALTER TABLE WS_WEBSERVICEFIELDINPUT ADD (tmp_col_1_tmp VARCHAR2(30 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICEFIELDINPUT SET tmp_col_1_tmp=COLUMNNAME,COLUMNNAME=NULL,tmp_col_2_tmp=IDENTIFIERLOGIC,IDENTIFIERLOGIC=NULL,tmp_col_3_tmp=WS_WEBSERVICEFIELDINPUT_UU,WS_WEBSERVICEFIELDINPUT_UU=NULL;
ALTER TABLE WS_WEBSERVICEFIELDINPUT MODIFY (COLUMNNAME VARCHAR2(30 CHAR),IDENTIFIERLOGIC VARCHAR2(2000 CHAR),WS_WEBSERVICEFIELDINPUT_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICEFIELDINPUT SET COLUMNNAME=tmp_col_1_tmp,IDENTIFIERLOGIC=tmp_col_2_tmp,WS_WEBSERVICEFIELDINPUT_UU=tmp_col_3_tmp;
ALTER TABLE WS_WEBSERVICEFIELDINPUT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table WS_WEBSERVICEFIELDOUTPUT
ALTER TABLE WS_WEBSERVICEFIELDOUTPUT ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICEFIELDOUTPUT SET tmp_col_1_tmp=WS_WEBSERVICEFIELDOUTPUT_UU,WS_WEBSERVICEFIELDOUTPUT_UU=NULL;
ALTER TABLE WS_WEBSERVICEFIELDOUTPUT MODIFY (WS_WEBSERVICEFIELDOUTPUT_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICEFIELDOUTPUT SET WS_WEBSERVICEFIELDOUTPUT_UU=tmp_col_1_tmp;
ALTER TABLE WS_WEBSERVICEFIELDOUTPUT DROP (tmp_col_1_tmp);

-- Processing table WS_WEBSERVICEMETHOD
ALTER TABLE WS_WEBSERVICEMETHOD ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE WS_WEBSERVICEMETHOD MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE WS_WEBSERVICEMETHOD SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL,tmp_col_5_tmp=WS_WEBSERVICEMETHOD_UU,WS_WEBSERVICEMETHOD_UU=NULL;
ALTER TABLE WS_WEBSERVICEMETHOD MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),WS_WEBSERVICEMETHOD_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICEMETHOD SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp,WS_WEBSERVICEMETHOD_UU=tmp_col_5_tmp;
ALTER TABLE WS_WEBSERVICEMETHOD MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE WS_WEBSERVICEMETHOD DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table WS_WEBSERVICETYPE
ALTER TABLE WS_WEBSERVICETYPE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(60 CHAR),tmp_col_4_tmp VARCHAR2(40 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE WS_WEBSERVICETYPE MODIFY (NAME NVARCHAR2(60) NULL,VALUE NVARCHAR2(40) NULL);
UPDATE WS_WEBSERVICETYPE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=HELP,HELP=NULL,tmp_col_3_tmp=NAME,NAME=NULL,tmp_col_4_tmp=VALUE,VALUE=NULL,tmp_col_5_tmp=WS_WEBSERVICETYPE_UU,WS_WEBSERVICETYPE_UU=NULL;
ALTER TABLE WS_WEBSERVICETYPE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),VALUE VARCHAR2(40 CHAR),WS_WEBSERVICETYPE_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICETYPE SET DESCRIPTION=tmp_col_1_tmp,HELP=tmp_col_2_tmp,NAME=tmp_col_3_tmp,VALUE=tmp_col_4_tmp,WS_WEBSERVICETYPE_UU=tmp_col_5_tmp;
ALTER TABLE WS_WEBSERVICETYPE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,VALUE VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE WS_WEBSERVICETYPE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table WS_WEBSERVICETYPEACCESS
ALTER TABLE WS_WEBSERVICETYPEACCESS ADD (tmp_col_1_tmp VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICETYPEACCESS SET tmp_col_1_tmp=WS_WEBSERVICETYPEACCESS_UU,WS_WEBSERVICETYPEACCESS_UU=NULL;
ALTER TABLE WS_WEBSERVICETYPEACCESS MODIFY (WS_WEBSERVICETYPEACCESS_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICETYPEACCESS SET WS_WEBSERVICETYPEACCESS_UU=tmp_col_1_tmp;
ALTER TABLE WS_WEBSERVICETYPEACCESS DROP (tmp_col_1_tmp);

-- Processing table WS_WEBSERVICE_PARA
ALTER TABLE WS_WEBSERVICE_PARA ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICE_PARA SET tmp_col_1_tmp=CONSTANTVALUE,CONSTANTVALUE=NULL,tmp_col_2_tmp=PARAMETERNAME,PARAMETERNAME=NULL,tmp_col_3_tmp=WS_WEBSERVICE_PARA_UU,WS_WEBSERVICE_PARA_UU=NULL;
ALTER TABLE WS_WEBSERVICE_PARA MODIFY (CONSTANTVALUE VARCHAR2(2000 CHAR),PARAMETERNAME VARCHAR2(60 CHAR),WS_WEBSERVICE_PARA_UU VARCHAR2(36 CHAR));
UPDATE WS_WEBSERVICE_PARA SET CONSTANTVALUE=tmp_col_1_tmp,PARAMETERNAME=tmp_col_2_tmp,WS_WEBSERVICE_PARA_UU=tmp_col_3_tmp;
ALTER TABLE WS_WEBSERVICE_PARA DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table W_ADVERTISEMENT
ALTER TABLE W_ADVERTISEMENT ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(255 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_ADVERTISEMENT MODIFY (NAME NVARCHAR2(60) NULL);
UPDATE W_ADVERTISEMENT SET tmp_col_1_tmp=ADTEXT,ADTEXT=NULL,tmp_col_2_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_3_tmp=HELP,HELP=NULL,tmp_col_4_tmp=IMAGEURL,IMAGEURL=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=WEBPARAM1,WEBPARAM1=NULL,tmp_col_7_tmp=WEBPARAM2,WEBPARAM2=NULL,tmp_col_8_tmp=WEBPARAM3,WEBPARAM3=NULL,tmp_col_9_tmp=WEBPARAM4,WEBPARAM4=NULL,tmp_col_10_tmp=W_ADVERTISEMENT_UU,W_ADVERTISEMENT_UU=NULL;
ALTER TABLE W_ADVERTISEMENT MODIFY (ADTEXT VARCHAR2(2000 CHAR),DESCRIPTION VARCHAR2(255 CHAR),HELP VARCHAR2(2000 CHAR),IMAGEURL VARCHAR2(120 CHAR),NAME VARCHAR2(60 CHAR),WEBPARAM1 VARCHAR2(2000 CHAR),WEBPARAM2 VARCHAR2(2000 CHAR),WEBPARAM3 VARCHAR2(2000 CHAR),WEBPARAM4 VARCHAR2(2000 CHAR),W_ADVERTISEMENT_UU VARCHAR2(36 CHAR));
UPDATE W_ADVERTISEMENT SET ADTEXT=tmp_col_1_tmp,DESCRIPTION=tmp_col_2_tmp,HELP=tmp_col_3_tmp,IMAGEURL=tmp_col_4_tmp,NAME=tmp_col_5_tmp,WEBPARAM1=tmp_col_6_tmp,WEBPARAM2=tmp_col_7_tmp,WEBPARAM3=tmp_col_8_tmp,WEBPARAM4=tmp_col_9_tmp,W_ADVERTISEMENT_UU=tmp_col_10_tmp;
ALTER TABLE W_ADVERTISEMENT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE W_ADVERTISEMENT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Processing table W_BASKET
ALTER TABLE W_BASKET ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_BASKET MODIFY (SESSION_ID NVARCHAR2(60) NULL);
UPDATE W_BASKET SET tmp_col_1_tmp=EMAIL,EMAIL=NULL,tmp_col_2_tmp=SESSION_ID,SESSION_ID=NULL,tmp_col_3_tmp=W_BASKET_UU,W_BASKET_UU=NULL;
ALTER TABLE W_BASKET MODIFY (EMAIL VARCHAR2(60 CHAR),SESSION_ID VARCHAR2(60 CHAR),W_BASKET_UU VARCHAR2(36 CHAR));
UPDATE W_BASKET SET EMAIL=tmp_col_1_tmp,SESSION_ID=tmp_col_2_tmp,W_BASKET_UU=tmp_col_3_tmp;
ALTER TABLE W_BASKET MODIFY (SESSION_ID VARCHAR2(60 CHAR) NOT NULL);
ALTER TABLE W_BASKET DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table W_BASKETLINE
ALTER TABLE W_BASKETLINE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(40 CHAR),tmp_col_3_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_BASKETLINE MODIFY (DESCRIPTION NVARCHAR2(255) NULL,PRODUCT NVARCHAR2(40) NULL);
UPDATE W_BASKETLINE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=PRODUCT,PRODUCT=NULL,tmp_col_3_tmp=W_BASKETLINE_UU,W_BASKETLINE_UU=NULL;
ALTER TABLE W_BASKETLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),PRODUCT VARCHAR2(40 CHAR),W_BASKETLINE_UU VARCHAR2(36 CHAR));
UPDATE W_BASKETLINE SET DESCRIPTION=tmp_col_1_tmp,PRODUCT=tmp_col_2_tmp,W_BASKETLINE_UU=tmp_col_3_tmp;
ALTER TABLE W_BASKETLINE MODIFY (DESCRIPTION VARCHAR2(255 CHAR) NOT NULL,PRODUCT VARCHAR2(40 CHAR) NOT NULL);
ALTER TABLE W_BASKETLINE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp);

-- Processing table W_CLICK
ALTER TABLE W_CLICK ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(60 CHAR),tmp_col_5_tmp VARCHAR2(120 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(36 CHAR));
UPDATE W_CLICK SET tmp_col_1_tmp=ACCEPTLANGUAGE,ACCEPTLANGUAGE=NULL,tmp_col_2_tmp=EMAIL,EMAIL=NULL,tmp_col_3_tmp=REFERRER,REFERRER=NULL,tmp_col_4_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_5_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_6_tmp=TARGETURL,TARGETURL=NULL,tmp_col_7_tmp=USERAGENT,USERAGENT=NULL,tmp_col_8_tmp=W_CLICK_UU,W_CLICK_UU=NULL;
ALTER TABLE W_CLICK MODIFY (ACCEPTLANGUAGE VARCHAR2(60 CHAR),EMAIL VARCHAR2(60 CHAR),REFERRER VARCHAR2(120 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR),TARGETURL VARCHAR2(120 CHAR),USERAGENT VARCHAR2(255 CHAR),W_CLICK_UU VARCHAR2(36 CHAR));
UPDATE W_CLICK SET ACCEPTLANGUAGE=tmp_col_1_tmp,EMAIL=tmp_col_2_tmp,REFERRER=tmp_col_3_tmp,REMOTE_ADDR=tmp_col_4_tmp,REMOTE_HOST=tmp_col_5_tmp,TARGETURL=tmp_col_6_tmp,USERAGENT=tmp_col_7_tmp,W_CLICK_UU=tmp_col_8_tmp;
ALTER TABLE W_CLICK DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table W_CLICKCOUNT
ALTER TABLE W_CLICKCOUNT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_CLICKCOUNT MODIFY (NAME NVARCHAR2(60) NULL,TARGETURL NVARCHAR2(120) NULL);
UPDATE W_CLICKCOUNT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=TARGETURL,TARGETURL=NULL,tmp_col_4_tmp=W_CLICKCOUNT_UU,W_CLICKCOUNT_UU=NULL;
ALTER TABLE W_CLICKCOUNT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),TARGETURL VARCHAR2(120 CHAR),W_CLICKCOUNT_UU VARCHAR2(36 CHAR));
UPDATE W_CLICKCOUNT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,TARGETURL=tmp_col_3_tmp,W_CLICKCOUNT_UU=tmp_col_4_tmp;
ALTER TABLE W_CLICKCOUNT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,TARGETURL VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE W_CLICKCOUNT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table W_COUNTER
ALTER TABLE W_COUNTER ADD (tmp_col_1_tmp VARCHAR2(60 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(120 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(120 CHAR),tmp_col_7_tmp VARCHAR2(255 CHAR),tmp_col_8_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_COUNTER MODIFY (PAGEURL NVARCHAR2(120) NULL);
UPDATE W_COUNTER SET tmp_col_1_tmp=ACCEPTLANGUAGE,ACCEPTLANGUAGE=NULL,tmp_col_2_tmp=EMAIL,EMAIL=NULL,tmp_col_3_tmp=PAGEURL,PAGEURL=NULL,tmp_col_4_tmp=REFERRER,REFERRER=NULL,tmp_col_5_tmp=REMOTE_ADDR,REMOTE_ADDR=NULL,tmp_col_6_tmp=REMOTE_HOST,REMOTE_HOST=NULL,tmp_col_7_tmp=USERAGENT,USERAGENT=NULL,tmp_col_8_tmp=W_COUNTER_UU,W_COUNTER_UU=NULL;
ALTER TABLE W_COUNTER MODIFY (ACCEPTLANGUAGE VARCHAR2(60 CHAR),EMAIL VARCHAR2(60 CHAR),PAGEURL VARCHAR2(120 CHAR),REFERRER VARCHAR2(120 CHAR),REMOTE_ADDR VARCHAR2(60 CHAR),REMOTE_HOST VARCHAR2(120 CHAR),USERAGENT VARCHAR2(255 CHAR),W_COUNTER_UU VARCHAR2(36 CHAR));
UPDATE W_COUNTER SET ACCEPTLANGUAGE=tmp_col_1_tmp,EMAIL=tmp_col_2_tmp,PAGEURL=tmp_col_3_tmp,REFERRER=tmp_col_4_tmp,REMOTE_ADDR=tmp_col_5_tmp,REMOTE_HOST=tmp_col_6_tmp,USERAGENT=tmp_col_7_tmp,W_COUNTER_UU=tmp_col_8_tmp;
ALTER TABLE W_COUNTER MODIFY (PAGEURL VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE W_COUNTER DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp);

-- Processing table W_COUNTERCOUNT
ALTER TABLE W_COUNTERCOUNT ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(60 CHAR),tmp_col_3_tmp VARCHAR2(120 CHAR),tmp_col_4_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_COUNTERCOUNT MODIFY (NAME NVARCHAR2(60) NULL,PAGEURL NVARCHAR2(120) NULL);
UPDATE W_COUNTERCOUNT SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=NAME,NAME=NULL,tmp_col_3_tmp=PAGEURL,PAGEURL=NULL,tmp_col_4_tmp=W_COUNTERCOUNT_UU,W_COUNTERCOUNT_UU=NULL;
ALTER TABLE W_COUNTERCOUNT MODIFY (DESCRIPTION VARCHAR2(255 CHAR),NAME VARCHAR2(60 CHAR),PAGEURL VARCHAR2(120 CHAR),W_COUNTERCOUNT_UU VARCHAR2(36 CHAR));
UPDATE W_COUNTERCOUNT SET DESCRIPTION=tmp_col_1_tmp,NAME=tmp_col_2_tmp,PAGEURL=tmp_col_3_tmp,W_COUNTERCOUNT_UU=tmp_col_4_tmp;
ALTER TABLE W_COUNTERCOUNT MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,PAGEURL VARCHAR2(120 CHAR) NOT NULL);
ALTER TABLE W_COUNTERCOUNT DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp);

-- Processing table W_MAILMSG
ALTER TABLE W_MAILMSG ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(255 CHAR),tmp_col_7_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_MAILMSG MODIFY (MESSAGE NVARCHAR2(2000) NULL,NAME NVARCHAR2(60) NULL,SUBJECT NVARCHAR2(255) NULL);
UPDATE W_MAILMSG SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=MESSAGE,MESSAGE=NULL,tmp_col_3_tmp=MESSAGE2,MESSAGE2=NULL,tmp_col_4_tmp=MESSAGE3,MESSAGE3=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=SUBJECT,SUBJECT=NULL,tmp_col_7_tmp=W_MAILMSG_UU,W_MAILMSG_UU=NULL;
ALTER TABLE W_MAILMSG MODIFY (DESCRIPTION VARCHAR2(255 CHAR),MESSAGE VARCHAR2(2000 CHAR),MESSAGE2 VARCHAR2(2000 CHAR),MESSAGE3 VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),SUBJECT VARCHAR2(255 CHAR),W_MAILMSG_UU VARCHAR2(36 CHAR));
UPDATE W_MAILMSG SET DESCRIPTION=tmp_col_1_tmp,MESSAGE=tmp_col_2_tmp,MESSAGE2=tmp_col_3_tmp,MESSAGE3=tmp_col_4_tmp,NAME=tmp_col_5_tmp,SUBJECT=tmp_col_6_tmp,W_MAILMSG_UU=tmp_col_7_tmp;
ALTER TABLE W_MAILMSG MODIFY (MESSAGE VARCHAR2(2000 CHAR) NOT NULL,NAME VARCHAR2(60 CHAR) NOT NULL,SUBJECT VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE W_MAILMSG DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp);

-- Processing table W_MAILMSG_TRL
ALTER TABLE W_MAILMSG_TRL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(255 CHAR),tmp_col_5_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_MAILMSG_TRL MODIFY (MESSAGE NVARCHAR2(2000) NULL,SUBJECT NVARCHAR2(255) NULL);
UPDATE W_MAILMSG_TRL SET tmp_col_1_tmp=MESSAGE,MESSAGE=NULL,tmp_col_2_tmp=MESSAGE2,MESSAGE2=NULL,tmp_col_3_tmp=MESSAGE3,MESSAGE3=NULL,tmp_col_4_tmp=SUBJECT,SUBJECT=NULL,tmp_col_5_tmp=W_MAILMSG_TRL_UU,W_MAILMSG_TRL_UU=NULL;
ALTER TABLE W_MAILMSG_TRL MODIFY (MESSAGE VARCHAR2(2000 CHAR),MESSAGE2 VARCHAR2(2000 CHAR),MESSAGE3 VARCHAR2(2000 CHAR),SUBJECT VARCHAR2(255 CHAR),W_MAILMSG_TRL_UU VARCHAR2(36 CHAR));
UPDATE W_MAILMSG_TRL SET MESSAGE=tmp_col_1_tmp,MESSAGE2=tmp_col_2_tmp,MESSAGE3=tmp_col_3_tmp,SUBJECT=tmp_col_4_tmp,W_MAILMSG_TRL_UU=tmp_col_5_tmp;
ALTER TABLE W_MAILMSG_TRL MODIFY (MESSAGE VARCHAR2(2000 CHAR) NOT NULL,SUBJECT VARCHAR2(255 CHAR) NOT NULL);
ALTER TABLE W_MAILMSG_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp);

-- Processing table W_STORE
ALTER TABLE W_STORE ADD (tmp_col_1_tmp VARCHAR2(255 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(60 CHAR),tmp_col_6_tmp VARCHAR2(60 CHAR),tmp_col_7_tmp VARCHAR2(120 CHAR),tmp_col_8_tmp VARCHAR2(20 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(60 CHAR),tmp_col_11_tmp VARCHAR2(2000 CHAR),tmp_col_12_tmp VARCHAR2(2000 CHAR),tmp_col_13_tmp VARCHAR2(2000 CHAR),tmp_col_14_tmp VARCHAR2(2000 CHAR),tmp_col_15_tmp VARCHAR2(2000 CHAR),tmp_col_16_tmp VARCHAR2(2000 CHAR),tmp_col_17_tmp VARCHAR2(60 CHAR),tmp_col_18_tmp VARCHAR2(60 CHAR),tmp_col_19_tmp VARCHAR2(20 CHAR),tmp_col_20_tmp VARCHAR2(36 CHAR));
ALTER TABLE W_STORE MODIFY (NAME NVARCHAR2(60) NULL,URL NVARCHAR2(120) NULL,WEBCONTEXT NVARCHAR2(20) NULL);
UPDATE W_STORE SET tmp_col_1_tmp=DESCRIPTION,DESCRIPTION=NULL,tmp_col_2_tmp=EMAILFOOTER,EMAILFOOTER=NULL,tmp_col_3_tmp=EMAILHEADER,EMAILHEADER=NULL,tmp_col_4_tmp=HELP,HELP=NULL,tmp_col_5_tmp=NAME,NAME=NULL,tmp_col_6_tmp=STYLESHEET,STYLESHEET=NULL,tmp_col_7_tmp=URL,URL=NULL,tmp_col_8_tmp=WEBCONTEXT,WEBCONTEXT=NULL,tmp_col_9_tmp=WEBINFO,WEBINFO=NULL,tmp_col_10_tmp=WEBORDEREMAIL,WEBORDEREMAIL=NULL,tmp_col_11_tmp=WEBPARAM1,WEBPARAM1=NULL,tmp_col_12_tmp=WEBPARAM2,WEBPARAM2=NULL,tmp_col_13_tmp=WEBPARAM3,WEBPARAM3=NULL,tmp_col_14_tmp=WEBPARAM4,WEBPARAM4=NULL,tmp_col_15_tmp=WEBPARAM5,WEBPARAM5=NULL,tmp_col_16_tmp=WEBPARAM6,WEBPARAM6=NULL,tmp_col_17_tmp=WSTOREEMAIL,WSTOREEMAIL=NULL,tmp_col_18_tmp=WSTOREUSER,WSTOREUSER=NULL,tmp_col_19_tmp=WSTOREUSERPW,WSTOREUSERPW=NULL,tmp_col_20_tmp=W_STORE_UU,W_STORE_UU=NULL;
ALTER TABLE W_STORE MODIFY (DESCRIPTION VARCHAR2(255 CHAR),EMAILFOOTER VARCHAR2(2000 CHAR),EMAILHEADER VARCHAR2(2000 CHAR),HELP VARCHAR2(2000 CHAR),NAME VARCHAR2(60 CHAR),STYLESHEET VARCHAR2(60 CHAR),URL VARCHAR2(120 CHAR) DEFAULT 'http://localhost' ,WEBCONTEXT VARCHAR2(20 CHAR),WEBINFO VARCHAR2(2000 CHAR),WEBORDEREMAIL VARCHAR2(60 CHAR),WEBPARAM1 VARCHAR2(2000 CHAR),WEBPARAM2 VARCHAR2(2000 CHAR),WEBPARAM3 VARCHAR2(2000 CHAR),WEBPARAM4 VARCHAR2(2000 CHAR),WEBPARAM5 VARCHAR2(2000 CHAR),WEBPARAM6 VARCHAR2(2000 CHAR),WSTOREEMAIL VARCHAR2(60 CHAR),WSTOREUSER VARCHAR2(60 CHAR),WSTOREUSERPW VARCHAR2(20 CHAR),W_STORE_UU VARCHAR2(36 CHAR));
UPDATE W_STORE SET DESCRIPTION=tmp_col_1_tmp,EMAILFOOTER=tmp_col_2_tmp,EMAILHEADER=tmp_col_3_tmp,HELP=tmp_col_4_tmp,NAME=tmp_col_5_tmp,STYLESHEET=tmp_col_6_tmp,URL=tmp_col_7_tmp,WEBCONTEXT=tmp_col_8_tmp,WEBINFO=tmp_col_9_tmp,WEBORDEREMAIL=tmp_col_10_tmp,WEBPARAM1=tmp_col_11_tmp,WEBPARAM2=tmp_col_12_tmp,WEBPARAM3=tmp_col_13_tmp,WEBPARAM4=tmp_col_14_tmp,WEBPARAM5=tmp_col_15_tmp,WEBPARAM6=tmp_col_16_tmp,WSTOREEMAIL=tmp_col_17_tmp,WSTOREUSER=tmp_col_18_tmp,WSTOREUSERPW=tmp_col_19_tmp,W_STORE_UU=tmp_col_20_tmp;
ALTER TABLE W_STORE MODIFY (NAME VARCHAR2(60 CHAR) NOT NULL,URL VARCHAR2(120 CHAR) DEFAULT 'http://localhost'  NOT NULL,WEBCONTEXT VARCHAR2(20 CHAR) NOT NULL);
ALTER TABLE W_STORE DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp,tmp_col_11_tmp,tmp_col_12_tmp,tmp_col_13_tmp,tmp_col_14_tmp,tmp_col_15_tmp,tmp_col_16_tmp,tmp_col_17_tmp,tmp_col_18_tmp,tmp_col_19_tmp,tmp_col_20_tmp);

-- Processing table W_STORE_TRL
ALTER TABLE W_STORE_TRL ADD (tmp_col_1_tmp VARCHAR2(2000 CHAR),tmp_col_2_tmp VARCHAR2(2000 CHAR),tmp_col_3_tmp VARCHAR2(2000 CHAR),tmp_col_4_tmp VARCHAR2(2000 CHAR),tmp_col_5_tmp VARCHAR2(2000 CHAR),tmp_col_6_tmp VARCHAR2(2000 CHAR),tmp_col_7_tmp VARCHAR2(2000 CHAR),tmp_col_8_tmp VARCHAR2(2000 CHAR),tmp_col_9_tmp VARCHAR2(2000 CHAR),tmp_col_10_tmp VARCHAR2(36 CHAR));
UPDATE W_STORE_TRL SET tmp_col_1_tmp=EMAILFOOTER,EMAILFOOTER=NULL,tmp_col_2_tmp=EMAILHEADER,EMAILHEADER=NULL,tmp_col_3_tmp=WEBINFO,WEBINFO=NULL,tmp_col_4_tmp=WEBPARAM1,WEBPARAM1=NULL,tmp_col_5_tmp=WEBPARAM2,WEBPARAM2=NULL,tmp_col_6_tmp=WEBPARAM3,WEBPARAM3=NULL,tmp_col_7_tmp=WEBPARAM4,WEBPARAM4=NULL,tmp_col_8_tmp=WEBPARAM5,WEBPARAM5=NULL,tmp_col_9_tmp=WEBPARAM6,WEBPARAM6=NULL,tmp_col_10_tmp=W_STORE_TRL_UU,W_STORE_TRL_UU=NULL;
ALTER TABLE W_STORE_TRL MODIFY (EMAILFOOTER VARCHAR2(2000 CHAR),EMAILHEADER VARCHAR2(2000 CHAR),WEBINFO VARCHAR2(2000 CHAR),WEBPARAM1 VARCHAR2(2000 CHAR),WEBPARAM2 VARCHAR2(2000 CHAR),WEBPARAM3 VARCHAR2(2000 CHAR),WEBPARAM4 VARCHAR2(2000 CHAR),WEBPARAM5 VARCHAR2(2000 CHAR),WEBPARAM6 VARCHAR2(2000 CHAR),W_STORE_TRL_UU VARCHAR2(36 CHAR));
UPDATE W_STORE_TRL SET EMAILFOOTER=tmp_col_1_tmp,EMAILHEADER=tmp_col_2_tmp,WEBINFO=tmp_col_3_tmp,WEBPARAM1=tmp_col_4_tmp,WEBPARAM2=tmp_col_5_tmp,WEBPARAM3=tmp_col_6_tmp,WEBPARAM4=tmp_col_7_tmp,WEBPARAM5=tmp_col_8_tmp,WEBPARAM6=tmp_col_9_tmp,W_STORE_TRL_UU=tmp_col_10_tmp;
ALTER TABLE W_STORE_TRL DROP (tmp_col_1_tmp,tmp_col_2_tmp,tmp_col_3_tmp,tmp_col_4_tmp,tmp_col_5_tmp,tmp_col_6_tmp,tmp_col_7_tmp,tmp_col_8_tmp,tmp_col_9_tmp,tmp_col_10_tmp);

-- Recreating the dropped indexes
CREATE UNIQUE INDEX AD_COLUMN_FKCONSTRAINTNAME ON AD_COLUMN(UPPER(FKCONSTRAINTNAME));
CREATE UNIQUE INDEX AD_COLUMN_NAME ON AD_COLUMN(AD_TABLE_ID,UPPER(COLUMNNAME));
CREATE UNIQUE INDEX AD_ELEMENT_UPPERCOLUMNNAME ON AD_ELEMENT(UPPER(COLUMNNAME));
CREATE UNIQUE INDEX AD_IMPFORMAT_NAME ON AD_IMPFORMAT(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_INFOWINDOW_UNIQUE_NAME ON AD_INFOWINDOW(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_ORG_VALUE ON AD_ORG(AD_CLIENT_ID,VALUE);
ALTER TABLE AD_PACKAGE_UUID_MAP ADD CONSTRAINT AD_PACKAGE_UUID_MAP_CTST_IDX UNIQUE (AD_CLIENT_ID,AD_TABLE_ID,SOURCE_UUID,TARGET_UUID) USING INDEX;
CREATE UNIQUE INDEX AD_PREFERENCE_ATTRIBUTE ON AD_PREFERENCE(PREFERENCEFOR,AD_INFOWINDOW_ID,AD_PROCESS_ID,AD_CLIENT_ID,AD_ORG_ID,AD_WINDOW_ID,AD_USER_ID,ATTRIBUTE);
CREATE UNIQUE INDEX AD_PRINTCOLOR_NAME ON AD_PRINTCOLOR(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_PRINTFONT_NAME ON AD_PRINTFONT(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_PRINTFORMAT_NAME ON AD_PRINTFORMAT(AD_CLIENT_ID,AD_TABLE_ID,NAME);
CREATE UNIQUE INDEX AD_PRINTPAPER_NAME ON AD_PRINTPAPER(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_REF_LIST_NAME ON AD_REF_LIST(AD_REFERENCE_ID,NAME);
CREATE UNIQUE INDEX AD_REF_LIST_VALUE ON AD_REF_LIST(AD_REFERENCE_ID,VALUE);
ALTER TABLE AD_REPLICATIONSTRATEGY ADD CONSTRAINT AD_REPLICATIONSTRATEGY_VALUE UNIQUE (AD_CLIENT_ID,VALUE) USING INDEX;
ALTER TABLE AD_SEQUENCE_AUDIT ADD CONSTRAINT AD_SEQUENCE_AUDIT_KEY PRIMARY KEY (AD_SEQUENCE_ID,DOCUMENTNO) USING INDEX;
CREATE UNIQUE INDEX AD_SYSCONFIG_ORG_NAME ON AD_SYSCONFIG(AD_CLIENT_ID,AD_ORG_ID,NAME);
CREATE UNIQUE INDEX AD_TABLE_NAME ON AD_TABLE(UPPER(TABLENAME));
CREATE UNIQUE INDEX AD_TABLEINDEX_NAME ON AD_TABLEINDEX(UPPER(NAME));
CREATE UNIQUE INDEX AD_TASK_NAME ON AD_TASK(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_TREE_NAME ON AD_TREE(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_WINDOW_NAME ON AD_WINDOW(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX AD_WORKFLOW_NAME ON AD_WORKFLOW(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX ASP_CLIENTEXCEPTION_UNQ ON ASP_CLIENTEXCEPTION(AD_CLIENT_ID,COALESCE(AD_FIELD_ID,0),COALESCE(AD_FORM_ID,0),COALESCE(AD_PROCESS_ID,0),COALESCE(AD_PROCESS_PARA_ID,0),COALESCE(AD_TAB_ID,0),COALESCE(AD_TASK_ID,0),COALESCE(AD_WORKFLOW_ID,0),COALESCE(AD_WF_NODE_ID,0),COALESCE(AD_WINDOW_ID,0));
CREATE UNIQUE INDEX CM_CSTAGE_ELEMENT_NAME ON CM_CSTAGE_ELEMENT(CM_CSTAGE_ID,NAME);
CREATE UNIQUE INDEX C_ACCTSCHEMA_NAME ON C_ACCTSCHEMA(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_ACTIVITY_VALUE ON C_ACTIVITY(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_BPARTNER_VALUE ON C_BPARTNER(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_BP_GROUP_VALUE ON C_BP_GROUP(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_CALENDAR_NAME ON C_CALENDAR(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_CAMPAIGN_VALUE ON C_CAMPAIGN(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_CHANNEL_NAME ON C_CHANNEL(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_CHARGE_NAME ON C_CHARGE(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_CYCLE_NAME ON C_CYCLE(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_DOCTYPE_NAME ON C_DOCTYPE(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_ELEMENT_NAME ON C_ELEMENT(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_ELEMENTVALUE_VALUE ON C_ELEMENTVALUE(C_ELEMENT_ID,VALUE);
CREATE UNIQUE INDEX C_INVOICE_DOCUMENTNO ON C_INVOICE(DOCUMENTNO,C_DOCTYPE_ID,C_BPARTNER_ID);
CREATE UNIQUE INDEX C_INVOICE_DOCUMENTNO_TARGET ON C_INVOICE(C_BPARTNER_ID,DOCUMENTNO,C_DOCTYPETARGET_ID);
CREATE UNIQUE INDEX C_ORDER_DOCUMENTNO ON C_ORDER(DOCUMENTNO,C_DOCTYPE_ID,C_BPARTNER_ID);
CREATE UNIQUE INDEX CORDERSOURCE_VALUE ON C_ORDERSOURCE(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_PAYMENTTERM_NAME ON C_PAYMENTTERM(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_PROJECT_VALUE ON C_PROJECT(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_REGION_NAME ON C_REGION(C_COUNTRY_ID,NAME);
CREATE UNIQUE INDEX C_SALESREGION_VALUE ON C_SALESREGION(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX C_TAX_NAME ON C_TAX(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_TAXCATEGORY_NAME ON C_TAXCATEGORY(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_UOM_NAME ON C_UOM(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX C_UOM_CONVERSION_PRODUCT ON C_UOM_CONVERSION(C_UOM_ID,C_UOM_TO_ID,COALESCE(M_PRODUCT_ID,(-1)));
CREATE INDEX FACT_ACCT_TRUNC_DATEACCT ON FACT_ACCT(TRUNC(DATEACCT));
CREATE UNIQUE INDEX GL_BUDGET_NAME ON GL_BUDGET(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX GL_CATEGORY_NAME ON GL_CATEGORY(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX GL_JOURNAL_DOCNO ON GL_JOURNAL(AD_ORG_ID,C_PERIOD_ID,DOCUMENTNO);
CREATE UNIQUE INDEX GL_JOURNALBATCH_DOCNO ON GL_JOURNALBATCH(AD_ORG_ID,C_PERIOD_ID,DOCUMENTNO);
CREATE UNIQUE INDEX HR_CONTRACT_VALUE ON HR_CONTRACT(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX HR_DEPARTMENT_VALUE ON HR_DEPARTMENT(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX HR_JOB_VALUE ON HR_JOB(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX M_EDI_TRX ON M_EDI(C_BP_EDI_ID,DOCUMENTNO,LINE);
ALTER TABLE M_FREIGHTCATEGORY ADD CONSTRAINT M_FREIGHTCAT_VALUE UNIQUE (AD_CLIENT_ID,VALUE) USING INDEX;
CREATE UNIQUE INDEX M_LOCATION_WHERE ON M_LOCATOR(M_WAREHOUSE_ID,X,Y,Z);
CREATE UNIQUE INDEX M_PRICELIST_NAME ON M_PRICELIST(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX M_PRODUCT_VALUE ON M_PRODUCT(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX M_PRODUCTPRICEVENDORBREAK_UNQ ON M_PRODUCTPRICEVENDORBREAK(M_PRODUCT_ID,COALESCE(C_BPARTNER_ID,(-1)),M_PRICELIST_VERSION_ID,BREAKVALUE);
CREATE UNIQUE INDEX M_PRODUCT_CATEGORY_VALUE ON M_PRODUCT_CATEGORY(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX M_PRODUCT_PO_VENDORPRODNO ON M_PRODUCT_PO(C_BPARTNER_ID,VENDORPRODUCTNO);
ALTER TABLE M_SHIPPERCFG ADD CONSTRAINT X_SHIPPER_UNIQUE_COLUMNS UNIQUE (AD_CLIENT_ID,AD_ORG_ID,NAME) USING INDEX;
ALTER TABLE M_SHIPPERLABELSCFG ADD CONSTRAINT X_SHIPPERLABELS_UNIQUE_COLUMNS UNIQUE (M_SHIPPERCFG_ID,VALUE) USING INDEX;
ALTER TABLE M_SHIPPERPACKAGINGCFG ADD CONSTRAINT X_SHIPPERPACK_UNIQUE_COLUMNS UNIQUE (M_SHIPPERCFG_ID,VALUE) USING INDEX;
ALTER TABLE M_SHIPPERPICKUPTYPESCFG ADD CONSTRAINT X_SHIPPERPICKT_UNIQUE_COLUMNS UNIQUE (M_SHIPPERCFG_ID,VALUE) USING INDEX;
ALTER TABLE M_SHIPPINGPROCESSORCFG ADD CONSTRAINT X_SHIPPINGPROC_UNIQUE_COLUMNS UNIQUE (AD_CLIENT_ID,AD_ORG_ID,NAME) USING INDEX;
CREATE UNIQUE INDEX M_WAREHOUSE_NAME ON M_WAREHOUSE(AD_CLIENT_ID,NAME);
CREATE UNIQUE INDEX PPPRODUCTBOMUNIQUE ON PP_PRODUCT_BOM(AD_CLIENT_ID,VALUE);
CREATE UNIQUE INDEX R_KNOWNISSUE_ALT ON R_ISSUEKNOWN(ISSUESUMMARY,RELEASENO,SOURCECLASSNAME,SOURCEMETHODNAME,LOGGERNAME,LINENO);
CREATE UNIQUE INDEX R_ISSUEUSER_EMAIL ON R_ISSUEUSER(USERNAME,AD_CLIENT_ID);
ALTER TABLE U_POSTERMINAL ADD CONSTRAINT U_POSTERMINAL_VALUE UNIQUE (AD_CLIENT_ID,VALUE) USING INDEX;
CREATE UNIQUE INDEX WS_WEBSERVICETYPE_VALUE_IDX ON WS_WEBSERVICETYPE(VALUE,AD_CLIENT_ID);
CREATE UNIQUE INDEX W_CLICKCOUNT_TARGETURL ON W_CLICKCOUNT(AD_CLIENT_ID,TARGETURL);
CREATE UNIQUE INDEX W_COUNTERCOUNT_PAGEURL ON W_COUNTERCOUNT(AD_CLIENT_ID,PAGEURL);

-- Recompiling views affected
ALTER VIEW AD_ALLCLIENTS_V COMPILE;
ALTER VIEW AD_ALLROLES_V COMPILE;
ALTER VIEW AD_ALLUSERROLES_V COMPILE;
ALTER VIEW AD_ALLUSERS_V COMPILE;
ALTER VIEW AD_CHANGELOG_V COMPILE;
ALTER VIEW AD_FIELD_V COMPILE;
ALTER VIEW AD_FIELD_VT COMPILE;
ALTER VIEW AD_ORG_V COMPILE;
ALTER VIEW AD_SESSIONINFO_V COMPILE;
ALTER VIEW AD_TAB_V COMPILE;
ALTER VIEW AD_TAB_VT COMPILE;
ALTER VIEW AD_USER_ROLES_V COMPILE;
ALTER VIEW AD_WINDOW_VT COMPILE;
ALTER VIEW C_DUNNING_HEADER_V COMPILE;
ALTER VIEW C_DUNNING_HEADER_VT COMPILE;
ALTER VIEW C_DUNNING_LINE_V COMPILE;
ALTER VIEW C_DUNNING_LINE_VT COMPILE;
ALTER VIEW C_INVOICELINE_V COMPILE;
ALTER VIEW C_INVOICE_CANDIDATE_V COMPILE;
ALTER VIEW C_INVOICE_HEADER_V COMPILE;
ALTER VIEW C_INVOICE_HEADER_VT COMPILE;
ALTER VIEW C_INVOICE_LINETAX_V COMPILE;
ALTER VIEW C_INVOICE_LINETAX_VT COMPILE;
ALTER VIEW C_INVOICE_V COMPILE;
ALTER VIEW C_INVOICE_V1 COMPILE;
ALTER VIEW C_ORDER_HEADER_V COMPILE;
ALTER VIEW C_ORDER_HEADER_VT COMPILE;
ALTER VIEW C_ORDER_LINETAX_V COMPILE;
ALTER VIEW C_ORDER_LINETAX_VT COMPILE;
ALTER VIEW C_PAYMENT_V COMPILE;
ALTER VIEW C_PAYSELECTION_CHECK_V COMPILE;
ALTER VIEW C_PAYSELECTION_CHECK_VT COMPILE;
ALTER VIEW C_PAYSELECTION_REMITTANCE_V COMPILE;
ALTER VIEW C_PAYSELECTION_REMITTANCE_VT COMPILE;
ALTER VIEW C_PROJECT_DETAILS_V COMPILE;
ALTER VIEW C_PROJECT_DETAILS_VT COMPILE;
ALTER VIEW C_PROJECT_HEADER_V COMPILE;
ALTER VIEW C_PROJECT_HEADER_VT COMPILE;
ALTER VIEW C_RFQRESPONSELINEQTY_V COMPILE;
ALTER VIEW C_RFQRESPONSELINEQTY_VT COMPILE;
ALTER VIEW C_RFQRESPONSELINE_V COMPILE;
ALTER VIEW C_RFQRESPONSELINE_VT COMPILE;
ALTER VIEW C_RFQRESPONSE_V COMPILE;
ALTER VIEW C_RFQRESPONSE_VT COMPILE;
ALTER VIEW C_SALESDASHBOARD COMPILE;
ALTER VIEW DD_ORDER_HEADER_V COMPILE;
ALTER VIEW DD_ORDER_HEADER_VT COMPILE;
ALTER VIEW GL_JOURNALLINE_ACCT_V COMPILE;
ALTER VIEW M_COSTMOVEMENT_V COMPILE;
ALTER VIEW M_INOUTCONFIRM_V COMPILE;
ALTER VIEW M_INOUTCONFIRM_VT COMPILE;
ALTER VIEW M_INOUTLINEMA_RETURNED COMPILE;
ALTER VIEW M_INOUT_CANDIDATE_V COMPILE;
ALTER VIEW M_INOUT_HEADER_V COMPILE;
ALTER VIEW M_INOUT_HEADER_VT COMPILE;
ALTER VIEW M_INOUT_LINECONFIRM_V COMPILE;
ALTER VIEW M_INOUT_LINECONFIRM_VT COMPILE;
ALTER VIEW M_INOUT_LINE_V COMPILE;
ALTER VIEW M_INOUT_LINE_VT COMPILE;
ALTER VIEW M_MOVEMENT_CANDIDATE_V COMPILE;
ALTER VIEW M_PACKAGELINES_AVAIL_V COMPILE;
ALTER VIEW M_PRODUCT_STOCK_V COMPILE;
ALTER VIEW M_PRODUCT_SUBSTITUTERELATED_V COMPILE;
ALTER VIEW M_STORAGE COMPILE;
ALTER VIEW PP_ORDER_BOMLINE_V COMPILE;
ALTER VIEW PP_ORDER_BOMLINE_VT COMPILE;
ALTER VIEW PP_ORDER_BOM_HEADER_V COMPILE;
ALTER VIEW PP_ORDER_BOM_HEADER_VT COMPILE;
ALTER VIEW PP_ORDER_HEADER_V COMPILE;
ALTER VIEW PP_ORDER_HEADER_VT COMPILE;
ALTER VIEW PP_ORDER_NODE_V COMPILE;
ALTER VIEW PP_ORDER_NODE_VT COMPILE;
ALTER VIEW PP_ORDER_WORKFLOW_HEADER_V COMPILE;
ALTER VIEW PP_ORDER_WORKFLOW_HEADER_VT COMPILE;
ALTER VIEW PP_PRODUCT_BOMLINE_V COMPILE;
ALTER VIEW PP_PRODUCT_BOMLINE_VT COMPILE;
ALTER VIEW RV_ALLOCATION COMPILE;
ALTER VIEW RV_ASSET_CUSTOMER COMPILE;
ALTER VIEW RV_ASSET_DELIVERY COMPILE;
ALTER VIEW RV_ASSET_SUMMONTH COMPILE;
ALTER VIEW RV_BPARTNER COMPILE;
ALTER VIEW RV_BPARTNEROPEN COMPILE;
ALTER VIEW RV_CASH_DETAIL COMPILE;
ALTER VIEW RV_CLICK_MONTH COMPILE;
ALTER VIEW RV_CLICK_UNPROCESSED COMPILE;
ALTER VIEW RV_COMMISSIONRUNDETAIL COMPILE;
ALTER VIEW RV_COST COMPILE;
ALTER VIEW RV_COSTDETAIL COMPILE;
ALTER VIEW RV_COSTSUMMARY COMPILE;
ALTER VIEW RV_C_INVOICE COMPILE;
ALTER VIEW RV_C_INVOICELINE COMPILE;
ALTER VIEW RV_C_INVOICETAX COMPILE;
ALTER VIEW RV_C_RFQRESPONSE COMPILE;
ALTER VIEW RV_C_RFQ_UNANSWERED COMPILE;
ALTER VIEW RV_DD_ORDERDETAIL COMPILE;
ALTER VIEW RV_FACT_ACCT COMPILE;
ALTER VIEW RV_FACT_ADAXA COMPILE;
ALTER VIEW RV_FACT_SIMPLE COMPILE;
ALTER VIEW RV_INOUTCONFIRM COMPILE;
ALTER VIEW RV_INOUTDETAILS COMPILE;
ALTER VIEW RV_INOUTLINECONFIRM COMPILE;
ALTER VIEW RV_M_FORECAST COMPILE;
ALTER VIEW RV_M_FORECAST_PERIOD COMPILE;
ALTER VIEW RV_M_PRODUCT_WHEREUSED_V COMPILE;
ALTER VIEW RV_M_REQUISITION COMPILE;
ALTER VIEW RV_M_TRANSACTION COMPILE;
ALTER VIEW RV_OPENITEM COMPILE;
ALTER VIEW RV_OPENITEMTODATE COMPILE;
ALTER VIEW RV_ORDERDETAIL COMPILE;
ALTER VIEW RV_PAYMENT COMPILE;
ALTER VIEW RV_PP_MRP COMPILE;
ALTER VIEW RV_PP_OPERATION_ACTIVITY COMPILE;
ALTER VIEW RV_PP_ORDER COMPILE;
ALTER VIEW RV_PP_ORDER_RECEIPT_ISSUE COMPILE;
ALTER VIEW RV_PP_ORDER_STORAGE COMPILE;
ALTER VIEW RV_PP_ORDER_TRANSACTIONS COMPILE;
ALTER VIEW RV_PP_ORDER_WORKFLOW COMPILE;
ALTER VIEW RV_PP_PRODUCT_BOMLINE COMPILE;
ALTER VIEW RV_PRINTFORMATDETAIL COMPILE;
ALTER VIEW RV_PROJECTCYCLE COMPILE;
ALTER VIEW RV_PROJECTLINEISSUE COMPILE;
ALTER VIEW RV_STORAGE COMPILE;
ALTER VIEW RV_STORAGE_PER_PRODUCT COMPILE;
ALTER VIEW RV_TRANSACTION COMPILE;
ALTER VIEW RV_T_1099EXTRACT COMPILE;
ALTER VIEW RV_UNPOSTED COMPILE;
ALTER VIEW RV_UNPROCESSED COMPILE;
ALTER VIEW RV_WAREHOUSEPRICE COMPILE;
ALTER VIEW R_REQUEST_V COMPILE;
ALTER VIEW T_BOMLINE_COSTS COMPILE;
ALTER VIEW T_INVOICEGL_V COMPILE;
ALTER VIEW T_RV_RECONCILIATION COMPILE;

SELECT register_migration_script('202008040100_IDEMPIERE-3862.sql') FROM dual
;
