/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SQLStatementElementHandler
extends AbstractElementHandler {
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        block33: {
            String elementValue = element.getElementValue();
            this.log.info(elementValue);
            String DBType = this.getStringValue(element, "DBType");
            String sql = this.getStringValue(element, "statement");
            if (sql.endsWith(";") && !sql.toLowerCase().endsWith("end;")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)sql, (boolean)false);
            Savepoint savepoint = null;
            int count = 0;
            CPreparedStatement pstmt = null;
            X_AD_Package_Imp_Detail impDetail = null;
            impDetail = this.createImportDetail(ctx, element.qName, "", 0);
            try {
                try {
                    String[] words;
                    String table;
                    String tableName;
                    Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)true);
                    savepoint = trx.setSavepoint(null);
                    pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                    if (DBType.equals("ALL")) {
                        count = pstmt.executeUpdate();
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("Executed SQL Statement: " + this.getStringValue(element, "statement") + " ReturnValue=" + count);
                        }
                    } else if (DB.isOracle() && DBType.equals("Oracle")) {
                        count = pstmt.executeUpdate();
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("Executed SQL Statement for Oracle: " + this.getStringValue(element, "statement") + " ReturnValue=" + count);
                        }
                    } else if (DB.isPostgreSQL() && (DBType.equals("Postgres") || DBType.equals("PostgreSQL"))) {
                        Statement stmt = null;
                        try {
                            stmt = pstmt.getConnection().createStatement();
                            count = stmt.executeUpdate(sql);
                            if (this.log.isLoggable(Level.INFO)) {
                                this.log.info("Executed SQL Statement for PostgreSQL: " + this.getStringValue(element, "statement") + " ReturnValue=" + count);
                            }
                        }
                        finally {
                            DB.close((Statement)stmt);
                            stmt = null;
                        }
                    }
                    this.logImportDetail(ctx, impDetail, 1, "SQLStatement", count, "Execute", sql, String.valueOf(count));
                    ctx.packIn.getNotifier().addSuccessLine("-> " + sql);
                    if (sql.toLowerCase().startsWith("delete from ") && !Util.isEmpty((String)(tableName = DB.getSQLValueString(null, (String)"SELECT TableName FROM AD_Table WHERE LOWER(TableName)=?", (Object[])new Object[]{(table = (words = sql.split("[ \r\n]"))[2]).toLowerCase()})))) {
                        CacheMgt.get().reset(tableName);
                    }
                }
                catch (Exception e) {
                    if (savepoint != null) {
                        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)false);
                        try {
                            if (trx.getConnection() != null) {
                                trx.getConnection().rollback(savepoint);
                            }
                        }
                        catch (SQLException sQLException) {
                            trx.rollback();
                        }
                        savepoint = null;
                    }
                    ctx.packIn.getNotifier().addFailureLine("SQL statement failed but ignored, error (" + e.getLocalizedMessage() + "): ");
                    this.logImportDetail(ctx, impDetail, 0, "SQLStatement", -1, "Execute", sql, e.getLocalizedMessage());
                    ctx.packIn.getNotifier().addFailureLine("-> " + sql);
                    this.log.log(Level.SEVERE, "SQLStatement", (Throwable)e);
                    DB.close((Statement)pstmt);
                    pstmt = null;
                    if (savepoint != null) {
                        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)false);
                        try {
                            trx.releaseSavepoint(savepoint);
                        }
                        catch (SQLException sQLException) {
                            if (DB.isPostgreSQL()) {
                                trx.commit();
                            }
                        }
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                block34: {
                    DB.close(pstmt);
                    pstmt = null;
                    if (savepoint != null) {
                        Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)false);
                        try {
                            trx.releaseSavepoint(savepoint);
                        }
                        catch (SQLException sQLException) {
                            if (!DB.isPostgreSQL()) break block34;
                            trx.commit();
                        }
                    }
                }
                throw throwable;
            }
            DB.close((Statement)pstmt);
            pstmt = null;
            if (savepoint != null) {
                Trx trx = Trx.get((String)this.getTrxName(ctx), (boolean)false);
                try {
                    trx.releaseSavepoint(savepoint);
                }
                catch (SQLException sQLException) {
                    if (!DB.isPostgreSQL()) break block33;
                    trx.commit();
                }
            }
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String SQLStatement = Env.getContext((Properties)ctx.ctx, (String)"SQLStatement");
        String DBType = Env.getContext((Properties)ctx.ctx, (String)"DBType");
        AttributesImpl atts = new AttributesImpl();
        this.addTypeName(atts, "custom");
        document.startElement("", "", "SQLStatement", atts);
        this.createSQLStatmentBinding(document, SQLStatement, DBType);
        document.endElement("", "", "SQLStatement");
    }

    private void createSQLStatmentBinding(TransformerHandler document, String sqlStatement, String DBType) throws SAXException {
        document.startElement("", "", "DBType", new AttributesImpl());
        char[] contents = DBType.toCharArray();
        document.characters(contents, 0, contents.length);
        document.endElement("", "", "DBType");
        document.startElement("", "", "statement", new AttributesImpl());
        contents = sqlStatement.toCharArray();
        document.startCDATA();
        document.characters(contents, 0, contents.length);
        document.endCDATA();
        document.endElement("", "", "statement");
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int field) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        Env.setContext((Properties)packout.getCtx().ctx, (String)"SQLStatement", (String)((String)detail.getProperty("SQLStatement")));
        Env.setContext((Properties)packout.getCtx().ctx, (String)"DBType", (String)((String)detail.getProperty("DBType")));
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("SQLStatement");
        packout.getCtx().ctx.remove("DBType");
    }
}

