/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.adempiere.base.Core;
import org.compiere.util.CCache;
import org.compiere.util.CacheMgt;
import org.compiere.util.GetCacheInfoCallable;
import org.idempiere.distributed.IClusterMember;
import org.idempiere.distributed.IClusterService;

public class CacheInfo
implements Serializable {
    private static final long serialVersionUID = -9069013908523249394L;
    private String name;
    private String tableName;
    private int size;
    private int expireMinutes;
    private int maxSize;
    private boolean distributed;
    private InetAddress nodeAddress;
    private String nodeId;
    private long hit;
    private long miss;

    public CacheInfo(CCache<?, ?> cache) {
        this.name = cache.getName();
        this.tableName = cache.getTableName();
        this.size = cache.size();
        this.expireMinutes = cache.getExpireMinutes();
        this.maxSize = cache.getMaxSize();
        this.distributed = cache.isDistributed();
        this.hit = cache.getHit();
        this.miss = cache.getMiss();
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getSize() {
        return this.size;
    }

    public int getExpireMinutes() {
        return this.expireMinutes;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public InetAddress getNodeAddress() {
        return this.nodeAddress;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public long getHit() {
        return this.hit;
    }

    public long getMiss() {
        return this.miss;
    }

    public static List<CacheInfo> getCacheInfos(boolean sortByName) {
        IClusterService service = Core.getClusterService();
        if (service != null && service.getMembers().size() > 1) {
            ArrayList<CacheInfo> instances = new ArrayList<CacheInfo>();
            GetCacheInfoCallable callable = new GetCacheInfoCallable();
            Map<IClusterMember, Future<List<CacheInfo>>> futureMap = service.execute(callable, service.getMembers());
            if (futureMap != null) {
                try {
                    Set<Map.Entry<IClusterMember, Future<List<CacheInfo>>>> results = futureMap.entrySet();
                    for (Map.Entry<IClusterMember, Future<List<CacheInfo>>> f : results) {
                        List<CacheInfo> response = f.getValue().get();
                        if (response == null || response.size() <= 0) continue;
                        response.forEach(e -> {
                            e.setNodeId(((IClusterMember)f.getKey()).getId());
                            e.setNodeAddress(((IClusterMember)f.getKey()).getAddress());
                            instances.add((CacheInfo)e);
                        });
                    }
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2.getMessage(), e2);
                }
                catch (ExecutionException e3) {
                    throw new RuntimeException(e3.getMessage(), e3);
                }
            }
            if (sortByName) {
                Collections.sort(instances, new Comparator<CacheInfo>(){

                    @Override
                    public int compare(CacheInfo o1, CacheInfo o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            return instances;
        }
        List<CacheInfo> instances = CacheMgt.get().getCacheInfos();
        if (sortByName) {
            Collections.sort(instances, new Comparator<CacheInfo>(){

                @Override
                public int compare(CacheInfo o1, CacheInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return instances;
    }

    private void setNodeAddress(InetAddress address) {
        this.nodeAddress = address;
    }

    private void setNodeId(String id) {
        this.nodeId = id;
    }
}

