/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import org.compiere.model.MColumn;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.Page;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public class PrintDataEvaluatee
implements Evaluatee {
    private PrintData m_data;
    private Page m_page;

    public PrintDataEvaluatee(Page page, PrintData data) {
        this.m_data = data;
        this.m_page = page;
    }

    @Override
    public String get_ValueAsString(String variableName) {
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(new PrintDataDataProvider(this.m_page, this.m_data));
        return evaluatee.get_ValueAsString(variableName);
    }

    public static boolean hasPageLogic(String displayLogic) {
        if (Util.isEmpty(displayLogic, true)) {
            return false;
        }
        return displayLogic.contains("@*Page");
    }

    public static class PrintDataDataProvider
    implements DefaultEvaluatee.DataProvider {
        private Page m_page;
        private PrintData m_data;

        public PrintDataDataProvider(Page page, PrintData data) {
            this.m_page = page;
            this.m_data = data;
        }

        @Override
        public Object getValue(String columnName) {
            if ("*Page".equals(columnName)) {
                return this.m_page != null ? String.valueOf(this.m_page.getPageNo()) : "1";
            }
            if ("*PageCount".equals(columnName)) {
                return this.m_page != null ? String.valueOf(this.m_page.getPageCount()) : "1";
            }
            Object obj = this.m_data.getNode(columnName);
            if (obj == null || !(obj instanceof PrintDataElement)) {
                return "";
            }
            PrintDataElement data = (PrintDataElement)obj;
            if (data.isNull()) {
                return "";
            }
            if (data.getValue() instanceof Boolean) {
                return (Boolean)data.getValue() != false ? "Y" : "N";
            }
            return data.getValueAsString();
        }

        @Override
        public Object getProperty(String propertyName) {
            return null;
        }

        @Override
        public MColumn getColumn(String columnName) {
            MColumn column = null;
            String tableName = this.m_data.getTableName();
            if (!Util.isEmpty(tableName)) {
                column = MColumn.get(this.m_data.getCtx(), tableName, columnName);
            }
            return column;
        }

        @Override
        public String getTrxName() {
            return null;
        }
    }
}

