/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MQuery;
import org.compiere.print.layout.Page;
import org.compiere.print.layout.PrintDataEvaluatee;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;

public class HeaderFooter {
    private Properties m_ctx;
    private ArrayList<PrintElement> m_elements = new ArrayList();
    private PrintElement[] m_pe = null;
    private Page m_currentPage;

    public HeaderFooter(Properties ctx) {
        this.m_ctx = ctx;
    }

    public void addElement(PrintElement element) {
        if (element != null) {
            this.m_elements.add(element);
        }
        this.m_pe = null;
    }

    public PrintElement[] getElements() {
        if (this.m_pe == null) {
            this.m_pe = new PrintElement[this.m_elements.size()];
            this.m_elements.toArray(this.m_pe);
        }
        return this.m_pe;
    }

    public void paint(Graphics2D g2D, Rectangle bounds, boolean isView) {
        Point pageStart = new Point(bounds.getLocation());
        this.getElements();
        int i2 = 0;
        while (i2 < this.m_pe.length) {
            PrintDataEvaluatee evaluatee;
            boolean display;
            if (this.m_currentPage == null || Util.isEmpty(this.m_pe[i2].getPageLogic(), true) || this.m_pe[i2].getPrintData() == null || this.m_pe[i2].getRowIndex() < 0 || (display = Evaluator.evaluateLogic(evaluatee = new PrintDataEvaluatee(this.m_currentPage, this.m_pe[i2].getPrintData()), this.m_pe[i2].getPageLogic()))) {
                this.m_pe[i2].paint(g2D, 0, pageStart, this.m_ctx, isView);
            }
            ++i2;
        }
    }

    public MQuery getDrillDown(Point relativePoint) {
        MQuery retValue = null;
        int i2 = 0;
        while (i2 < this.m_elements.size() && retValue == null) {
            PrintElement element = this.m_elements.get(i2);
            retValue = element.getDrillDown(relativePoint, 1);
            ++i2;
        }
        return retValue;
    }

    public void setCurrentPage(Page page) {
        this.m_currentPage = page;
    }
}

