/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.ServerContext;
import org.compiere.Adempiere;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.MSort;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class GridTable
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = 3948220810042370826L;
    protected static final String SORTED_DSE_EVENT = "Sorted";
    public static final int DEFAULT_GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS = 30;
    public static final int DEFAULT_GRIDTABLE_COUNT_TIMEOUT_IN_SECONDS = 1;
    public static final String LOAD_TIMEOUT_ERROR_MESSAGE = "GridTabLoadTimeoutError";
    public static final String DATA_REFRESH_MESSAGE = "Refreshed";
    public static final String DATA_UPDATE_COPIED_MESSAGE = "UpdateCopied";
    public static final String DATA_INSERTED_MESSAGE = "Inserted";
    public static final String DATA_IGNORED_MESSAGE = "Ignored";
    public static final String DATA_SAVED_MESSAGE = "Saved";
    private static CLogger log = CLogger.getCLogger(GridTable.class);
    private Properties m_ctx;
    private int m_AD_Table_ID;
    private String m_tableName = "";
    private int m_WindowNo;
    private int m_TabNo;
    private boolean m_withAccessControl;
    private boolean m_readOnly = true;
    private boolean m_deleteable = true;
    private boolean m_virtual;
    public static final String CTX_KeyColumnName = "KeyColumnName";
    private int m_rowCount = 0;
    private boolean m_rowCountTimeout = false;
    private boolean m_rowLoadTimeout = false;
    private boolean m_changed = false;
    private int m_rowChanged = -1;
    private boolean m_inserting = false;
    private int m_newRow = -1;
    private boolean m_open = false;
    @Deprecated
    private boolean m_compareDB = true;
    private volatile ArrayList<Object[]> m_buffer = new ArrayList(100);
    private volatile ArrayList<MSort> m_sort = new ArrayList(100);
    private volatile Map<Integer, Object[]> m_virtualBuffer = new HashMap<Integer, Object[]>(100);
    private Object[] m_rowData = null;
    private Object[] m_oldValue = null;
    private Loader m_loader = null;
    private ArrayList<GridField> m_fields = new ArrayList(30);
    private ArrayList<Object> m_parameterSELECT = new ArrayList(5);
    private ArrayList<Object> m_parameterWHERE = new ArrayList(5);
    private String m_SQL;
    private String m_SQL_Count;
    private String m_SQL_Select;
    private String m_whereClause = "2=3";
    private boolean m_onlyCurrentRows = false;
    private int m_onlyCurrentDays = 1;
    private String m_orderClause = "";
    private int m_maxRows = 0;
    private int m_indexKeyColumn = -1;
    private int m_indexUUIDColumn = -1;
    private int m_indexColorColumn = -1;
    private int m_indexProcessedColumn = -1;
    private int m_indexActiveColumn = -1;
    private int m_indexClientColumn = -1;
    private int m_indexOrgColumn = -1;
    private VetoableChangeSupport m_vetoableChangeSupport = new VetoableChangeSupport(this);
    private Future<?> m_loaderFuture;
    public static final String PROPERTY = "MTable-RowSave";
    private static final Integer NEW_ROW_ID = -1;
    private static final int DEFAULT_FETCH_SIZE = 200;
    private int m_lastSortColumnIndex = -1;
    private boolean m_lastSortedAscending = true;
    public static final char SAVE_OK = 'O';
    public static final char SAVE_ERROR = 'E';
    public static final char SAVE_ACCESS = 'A';
    public static final char SAVE_MANDATORY = 'M';
    public static final char SAVE_ABORT = 'U';
    private boolean m_importing = false;
    private String m_trxName = null;
    private int m_currentRow = -1;

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl) {
        this(ctx, AD_Table_ID, TableName, WindowNo, TabNo, withAccessControl, false);
    }

    public GridTable(Properties ctx, int AD_Table_ID, String TableName, int WindowNo, int TabNo, boolean withAccessControl, boolean virtual) {
        if (log.isLoggable(Level.INFO)) {
            log.info(TableName);
        }
        this.m_ctx = ctx;
        this.m_AD_Table_ID = AD_Table_ID;
        this.setTableName(TableName);
        this.m_WindowNo = WindowNo;
        this.m_TabNo = TabNo;
        this.m_withAccessControl = withAccessControl;
        this.m_virtual = virtual;
    }

    public void setTableName(String newTableName) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return;
        }
        if (newTableName == null || newTableName.length() == 0) {
            return;
        }
        this.m_tableName = newTableName;
    }

    public String getTableName() {
        return this.m_tableName;
    }

    public boolean setSelectWhereClause(String newWhereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored");
            return false;
        }
        this.m_whereClause = newWhereClause;
        this.m_onlyCurrentRows = onlyCurrentRows;
        this.m_onlyCurrentDays = onlyCurrentDays;
        if (this.m_whereClause == null) {
            this.m_whereClause = "";
        }
        return true;
    }

    public String getSelectWhereClause() {
        return this.m_whereClause;
    }

    public boolean isOnlyCurrentRowsDisplayed() {
        return !this.m_onlyCurrentRows;
    }

    public void setOrderClause(String newOrderClause) {
        this.m_orderClause = newOrderClause;
        if (this.m_orderClause == null) {
            this.m_orderClause = "";
        }
    }

    public String getOrderClause() {
        return this.m_orderClause;
    }

    private String createSelectSql() {
        if (this.m_fields.size() == 0 || this.m_tableName == null || this.m_tableName.equals("")) {
            return "";
        }
        StringBuilder select = new StringBuilder("SELECT ");
        int i = 0;
        while (i < this.m_fields.size()) {
            GridField field;
            if (i > 0) {
                select.append(",");
            }
            select.append((field = this.m_fields.get(i)).isVirtualColumn() ? field.getColumnSQL(true) : DB.getDatabase().quoteColumnName(field.getColumnSQL(true)));
            ++i;
        }
        select.append(" FROM ").append(this.m_tableName);
        this.m_SQL_Select = select.toString();
        this.m_SQL_Count = "SELECT COUNT(*) FROM " + this.m_tableName;
        int parentTabNo = this.getParentTabNo();
        String parentKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, "_TabInfo_KeyColumnName", true);
        String valueKey = null;
        String currKey = null;
        if (parentKey != null && parentKey.length() > 0) {
            valueKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentTabNo, parentKey, true);
            currKey = Env.getContext(this.m_ctx, this.m_WindowNo, parentKey);
            if (currKey == null) {
                currKey = new String("");
            }
            if (valueKey != null && valueKey.length() > 0 && parentKey != null && parentKey.length() > 0 && !currKey.equals(valueKey)) {
                Env.setContext(this.m_ctx, this.m_WindowNo, parentKey, valueKey);
            }
        }
        StringBuilder where = new StringBuilder("");
        if (this.m_whereClause.length() > 0) {
            where.append(" WHERE (");
            if (this.m_whereClause.indexOf(64) == -1) {
                where.append(this.m_whereClause);
            } else {
                String context = Env.parseContext(this.m_ctx, this.m_WindowNo, this.m_whereClause, false);
                if (context != null && context.trim().length() > 0) {
                    where.append(context);
                } else {
                    log.log(Level.WARNING, "Failed to parse where clause. whereClause=" + this.m_whereClause);
                    where.append(" 1 = 2 ");
                }
            }
            where.append(")");
        }
        if (this.m_onlyCurrentRows && this.m_TabNo == 0) {
            if (where.toString().indexOf(" WHERE ") == -1) {
                where.append(" WHERE ");
            } else {
                where.append(" AND ");
            }
            where.append("(Processed='N' OR Updated>");
            where.append("getDate()-1");
            where.append(")");
        }
        this.m_SQL = this.m_SQL_Select + where.toString();
        this.m_SQL_Count = String.valueOf(this.m_SQL_Count) + where.toString();
        if (this.m_withAccessControl) {
            this.m_SQL = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL, this.m_tableName, true, false);
            this.m_SQL_Count = MRole.getDefault(this.m_ctx, false).addAccessSQL(this.m_SQL_Count, this.m_tableName, true, false);
        }
        if (!this.m_orderClause.equals("")) {
            this.m_SQL = String.valueOf(this.m_SQL) + " ORDER BY " + this.m_orderClause;
        }
        if (this.m_maxRows > 0 && DB.getDatabase().isPagingSupported()) {
            this.m_SQL = DB.getDatabase().addPagingSQL(this.m_SQL, 1, this.m_maxRows + 1);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_SQL_Count);
        }
        Env.setContext(this.m_ctx, this.m_WindowNo, this.m_TabNo, "_TabInfo_SQL", this.m_SQL);
        return this.m_SQL;
    }

    public void addField(GridField field) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("(" + this.m_tableName + ") - " + field.getColumnName());
        }
        if (this.m_open) {
            log.log(Level.SEVERE, "Table already open - ignored: " + field.getColumnName());
            return;
        }
        if (!MRole.getDefault(this.m_ctx, false).isColumnAccess(this.m_AD_Table_ID, field.getAD_Column_ID(), true)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No Column Access " + field.getColumnName());
            }
            return;
        }
        if (field.isKey()) {
            this.m_indexKeyColumn = this.m_fields.size();
        } else if (field.isUUID()) {
            this.m_indexUUIDColumn = this.m_fields.size();
        }
        if (field.getColumnName().equals("IsActive")) {
            this.m_indexActiveColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("Processed")) {
            this.m_indexProcessedColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Client_ID")) {
            this.m_indexClientColumn = this.m_fields.size();
        } else if (field.getColumnName().equals("AD_Org_ID")) {
            this.m_indexOrgColumn = this.m_fields.size();
        }
        this.m_fields.add(field);
    }

    @Override
    public String getColumnName(int index) {
        if (index < 0 || index > this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return "";
        }
        GridField field = this.m_fields.get(index);
        return field.getColumnName();
    }

    @Override
    public int findColumn(String columnName) {
        int i = 0;
        while (i < this.m_fields.size()) {
            GridField field = this.m_fields.get(i);
            if (columnName.equals(field.getColumnName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            log.log(Level.SEVERE, "Invalid index=" + index);
            return null;
        }
        GridField field = this.m_fields.get(index);
        return DisplayType.getClass(field.getDisplayType(), false);
    }

    public void setParameterSELECT(int index, Object parameter) {
        if (index >= this.m_parameterSELECT.size()) {
            this.m_parameterSELECT.add(parameter);
        } else {
            this.m_parameterSELECT.set(index, parameter);
        }
    }

    public void setParameterWHERE(int index, Object parameter) {
        if (index >= this.m_parameterWHERE.size()) {
            this.m_parameterWHERE.add(parameter);
        } else {
            this.m_parameterWHERE.set(index, parameter);
        }
    }

    public GridField getField(int index) {
        if (index < 0 || index >= this.m_fields.size()) {
            return null;
        }
        return this.m_fields.get(index);
    }

    protected GridField getField(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        int cols = this.m_fields.size();
        int i = 0;
        while (i < cols) {
            GridField field = this.m_fields.get(i);
            if (identifier.equalsIgnoreCase(field.getColumnName())) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public GridField[] getFields() {
        GridField[] retValue = new GridField[this.m_fields.size()];
        this.m_fields.toArray(retValue);
        return retValue;
    }

    public boolean open(int maxRows) {
        if (log.isLoggable(Level.INFO)) {
            log.info("MaxRows=" + maxRows);
        }
        this.m_maxRows = maxRows;
        if (this.m_open) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("already open");
            }
            this.dataRefreshAll();
            return true;
        }
        if (this.m_virtual) {
            this.verifyVirtual();
        }
        this.createSelectSql();
        if (this.m_SQL == null || this.m_SQL.equals("")) {
            log.log(Level.SEVERE, "No SQL");
            return false;
        }
        if (!this.m_open) {
            this.m_open = true;
        }
        this.m_loader = new Loader();
        this.m_loaderFuture = null;
        this.m_rowCount = this.m_loader.open(maxRows);
        if (this.m_virtual) {
            this.m_buffer = null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
        } else {
            this.m_buffer = new ArrayList(this.m_rowCount + 10);
        }
        this.m_sort = new ArrayList(this.m_rowCount + 10);
        if (this.m_rowCount > 0 || this.m_rowCountTimeout) {
            this.m_loader.setContext(ServerContext.getCurrentInstance());
            this.m_loaderFuture = Adempiere.getThreadPoolExecutor().submit(this.m_loader);
        } else {
            this.m_loader.close();
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        return true;
    }

    private void verifyVirtual() {
        if (this.m_indexKeyColumn == -1) {
            this.m_virtual = false;
            return;
        }
        GridField[] fields = this.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isKey() && i != this.m_indexKeyColumn) {
                this.m_virtual = false;
                return;
            }
            ++i;
        }
    }

    public void loadComplete() {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            try {
                this.m_loaderFuture.get();
            }
            catch (Exception ie) {
                log.log(Level.SEVERE, "Interrupted", ie);
            }
        }
        int i = 0;
        while (i < this.m_fields.size()) {
            GridField field = this.m_fields.get(i);
            field.lookupLoadComplete();
            ++i;
        }
    }

    public boolean isLoading() {
        return this.m_loaderFuture != null && !this.m_loaderFuture.isDone();
    }

    public void waitLoading(long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (timeout > 0L) {
                this.m_loaderFuture.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                this.m_loaderFuture.get();
            }
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void close(boolean finalCall) {
        if (!this.m_open) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("final=" + finalCall);
        }
        if (finalCall) {
            DataStatusListener[] evl = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
            int i = 0;
            while (i < evl.length) {
                this.listenerList.remove(DataStatusListener.class, evl[i]);
                ++i;
            }
            TableModelListener[] ev2 = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
            int i2 = 0;
            while (i2 < ev2.length) {
                this.listenerList.remove(TableModelListener.class, ev2[i2]);
                ++i2;
            }
            VetoableChangeListener[] vcl = this.m_vetoableChangeSupport.getVetoableChangeListeners();
            int i3 = 0;
            while (i3 < vcl.length) {
                this.m_vetoableChangeSupport.removeVetoableChangeListener(vcl[i3]);
                ++i3;
            }
        }
        while (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Interrupting Loader ...");
            }
            this.m_loaderFuture.cancel(true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
            this.m_loaderFuture = null;
        }
        if (!this.m_inserting) {
            this.dataSave(false);
        }
        if (this.m_buffer != null) {
            this.m_buffer.clear();
        }
        if (this.m_sort != null) {
            this.m_sort.clear();
        }
        if (this.m_virtualBuffer != null) {
            this.m_virtualBuffer.clear();
        }
        if (finalCall) {
            this.dispose();
            this.m_buffer = null;
            this.m_sort = null;
            this.m_virtualBuffer = null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("");
        }
        this.m_open = false;
    }

    private void dispose() {
        int i = 0;
        while (i < this.m_fields.size()) {
            this.m_fields.get(i).dispose();
            ++i;
        }
        this.m_fields.clear();
        this.m_fields = null;
        this.m_vetoableChangeSupport = null;
        this.m_parameterSELECT.clear();
        this.m_parameterSELECT = null;
        this.m_parameterWHERE.clear();
        this.m_parameterWHERE = null;
        this.m_buffer = null;
        this.m_virtualBuffer = null;
        this.m_sort = null;
        this.m_rowData = null;
        this.m_oldValue = null;
        this.m_loader = null;
        this.m_loaderFuture = null;
    }

    @Override
    public int getColumnCount() {
        return this.m_fields.size();
    }

    public int getFieldCount() {
        return this.m_fields.size();
    }

    @Override
    public int getRowCount() {
        return this.m_rowCount;
    }

    public void setColorColumn(String columnName) {
        this.m_indexColorColumn = this.findColumn(columnName);
    }

    public int getColorCode(int row) {
        if (this.m_indexColorColumn == -1) {
            return 0;
        }
        Object data = this.getValueAt(row, this.m_indexColorColumn);
        if (data == null || !(data instanceof BigDecimal)) {
            return 0;
        }
        BigDecimal bd = (BigDecimal)data;
        return bd.signum();
    }

    public void sort(int col, boolean ascending) {
        MSort currentRow;
        MSort changedRow;
        boolean isSameSortEntries;
        if (log.isLoggable(Level.INFO)) {
            log.info("#" + col + " " + ascending);
        }
        if (col < 0) {
            return;
        }
        if (this.getRowCount() == 0) {
            return;
        }
        GridField field = this.getField(col);
        if (field.getGridTab().isQuickForm()) {
            this.dataIgnore();
        }
        boolean bl = isSameSortEntries = col == this.m_lastSortColumnIndex && ascending == this.m_lastSortedAscending;
        if (!isSameSortEntries) {
            this.m_lastSortColumnIndex = col;
            this.m_lastSortedAscending = ascending;
        }
        MSort mSort = changedRow = this.m_rowChanged >= 0 ? this.m_sort.get(this.m_rowChanged) : null;
        if (this.m_rowChanged == this.m_newRow) {
            changedRow = null;
        }
        Object[] changedRowData = changedRow != null ? this.getDataAtRow(this.m_rowChanged) : null;
        MSort newRow = this.m_newRow >= 0 ? this.m_sort.get(this.m_newRow) : null;
        MSort mSort2 = currentRow = this.m_currentRow >= 0 && this.m_currentRow < this.m_sort.size() ? this.m_sort.get(this.m_currentRow) : null;
        if (field.getDisplayType() == 26) {
            return;
        }
        boolean isLookup = DisplayType.isLookup(field.getDisplayType());
        boolean isASI = 35 == field.getDisplayType();
        int i = 0;
        while (i < this.m_sort.size()) {
            MSort sort = this.m_sort.get(i);
            Object[] rowData = this.getDataAtRow(i);
            sort.data = rowData[col] == null ? null : (isLookup || isASI ? field.getLookup().getDisplay(rowData[col]) : rowData[col]);
            ++i;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(field.toString() + " #" + this.m_sort.size());
        }
        MSort sort = new MSort(0, null);
        sort.setSortAsc(ascending);
        Collections.sort(this.m_sort, sort);
        if (this.m_virtual) {
            Object[] newRowData = newRow != null ? this.m_virtualBuffer.get(NEW_ROW_ID) : null;
            this.m_virtualBuffer.clear();
            if (newRow != null) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRowData);
            }
            if (changedRow != null) {
                int i2 = 0;
                while (i2 < this.m_sort.size()) {
                    if (this.m_sort.get(i2) == changedRow) {
                        this.m_rowChanged = i2;
                        this.m_virtualBuffer.put(changedRow.index, changedRowData);
                        break;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.m_sort.size()) {
                this.m_sort.get((int)i3).data = null;
                if (newRow != null && this.m_sort.get(i3) == newRow) {
                    if (this.m_rowChanged == this.m_newRow) {
                        this.m_rowChanged = i3;
                    }
                    this.m_newRow = i3;
                }
                if (currentRow != null && this.m_sort.get(i3) == currentRow) {
                    this.m_currentRow = i3;
                }
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < this.m_sort.size()) {
                if (newRow != null && this.m_sort.get(i4) == newRow) {
                    if (this.m_rowChanged == this.m_newRow) {
                        this.m_rowChanged = i4;
                    }
                    this.m_newRow = i4;
                }
                if (currentRow != null && this.m_sort.get(i4) == currentRow) {
                    this.m_currentRow = i4;
                }
                ++i4;
            }
        }
        if (!isSameSortEntries) {
            this.fireDataStatusIEvent(SORTED_DSE_EVENT, "#" + this.m_sort.size());
            this.fireTableDataChanged();
        }
    }

    public int getKeyID(int row) {
        if (this.m_indexKeyColumn != -1) {
            Integer ii;
            block4: {
                try {
                    ii = (Integer)this.getValueAt(row, this.m_indexKeyColumn);
                    if (ii != null) break block4;
                    return -1;
                }
                catch (Exception exception) {
                    return -1;
                }
            }
            return ii;
        }
        return -1;
    }

    public String getKeyUUID(int row) {
        if (this.m_indexUUIDColumn != -1) {
            String ii;
            block4: {
                try {
                    ii = (String)this.getValueAt(row, this.m_indexUUIDColumn);
                    if (ii != null) break block4;
                    return null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return ii;
        }
        return null;
    }

    public UUID getUUID(int row) {
        String keyUUID = this.getKeyUUID(row);
        if (keyUUID != null) {
            return UUID.fromString(keyUUID);
        }
        return null;
    }

    public String getKeyColumnName() {
        if (this.m_indexKeyColumn != -1) {
            return this.getColumnName(this.m_indexKeyColumn);
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (!this.m_open || row < 0 || col < 0 || row >= this.m_rowCount) {
            return null;
        }
        this.waitLoadingForRow(row);
        if (row >= this.m_sort.size()) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null || col > rowData.length) {
            return null;
        }
        return rowData[col];
    }

    public void waitLoadingForRow(int row) {
        Exception savedEx;
        int loops = 0;
        int timeout = MSysConfig.getIntValue("GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS", 30, Env.getAD_Client_ID(Env.getCtx()));
        while (row >= this.m_sort.size() && this.m_loaderFuture != null && !this.m_loaderFuture.isDone() && loops < timeout) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Waiting for loader row=" + row + ", size=" + this.m_sort.size());
            }
            try {
                this.m_loaderFuture.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {}
            ++loops;
        }
        if (this.m_sort.size() == 0 && (savedEx = CLogger.retrieveException()) != null) {
            throw new IllegalStateException(savedEx);
        }
        if (row == 0 && this.m_sort.size() == 0 && this.m_rowCountTimeout && !this.m_rowLoadTimeout) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "FindZeroRecords"));
        }
        if (row >= this.m_sort.size()) {
            log.warning("Reached " + timeout + " seconds timeout loading row " + (row + 1) + " for SQL=" + this.m_SQL);
            this.m_rowCount = this.m_sort.size();
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), LOAD_TIMEOUT_ERROR_MESSAGE));
        }
    }

    private Object[] getDataAtRow(int row) {
        return this.getDataAtRow(row, true);
    }

    private Object[] getDataAtRow(int row, boolean fetchIfNotFound) {
        this.waitLoadingForRow(row);
        MSort sort = this.m_sort.get(row);
        Object[] rowData = null;
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index) && fetchIfNotFound) {
                this.fillBuffer(row, 200);
            }
            rowData = this.m_virtualBuffer.get(sort.index);
        } else {
            rowData = this.m_buffer.get(sort.index);
        }
        return rowData;
    }

    private void setDataAtRow(int row, Object[] rowData) {
        MSort sort = this.m_sort.get(row);
        if (this.m_virtual) {
            if (sort.index != NEW_ROW_ID && !this.m_virtualBuffer.containsKey(sort.index)) {
                this.fillBuffer(row, 200);
            }
            this.m_virtualBuffer.put(sort.index, rowData);
        } else {
            this.m_buffer.set(sort.index, rowData);
        }
    }

    private void fillBuffer(int start, int fetchSize) {
        block17: {
            if (start > 0 && start + fetchSize >= this.m_sort.size() && (start -= fetchSize - (this.m_sort.size() - start)) < 0) {
                start = 0;
            }
            StringBuilder sql = new StringBuilder();
            sql.append(this.m_SQL_Select).append(" WHERE ").append(this.getKeyColumnName()).append(" IN (");
            LinkedHashMap<Integer, Integer> rowmap = new LinkedHashMap<Integer, Integer>(200);
            int count = 0;
            int i = start;
            while (i < start + fetchSize && i < this.m_sort.size()) {
                if (this.m_sort.get((int)i).index != NEW_ROW_ID) {
                    if (count > 0) {
                        sql.append(",");
                    }
                    sql.append(this.m_sort.get((int)i).index);
                    rowmap.put(this.m_sort.get((int)i).index, i);
                    ++count;
                }
                ++i;
            }
            sql.append(")");
            Object[] newRow = this.m_virtualBuffer.get(NEW_ROW_ID);
            Object[] changedRow = this.m_rowChanged >= 0 ? this.getDataAtRow(this.m_rowChanged, false) : null;
            this.m_virtualBuffer = new HashMap<Integer, Object[]>(210);
            if (newRow != null && newRow.length > 0) {
                this.m_virtualBuffer.put(NEW_ROW_ID, newRow);
            }
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            this.m_rowLoadTimeout = false;
            try {
                try {
                    stmt = DB.prepareStatement(sql.toString(), null);
                    int timeout = MSysConfig.getIntValue("GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS", 30, Env.getAD_Client_ID(Env.getCtx()));
                    if (timeout > 0) {
                        stmt.setQueryTimeout(timeout);
                    }
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Object[] data = this.readData(rs);
                        rowmap.remove(data[this.m_indexKeyColumn]);
                        this.m_virtualBuffer.put((Integer)data[this.m_indexKeyColumn], data);
                    }
                    if (!rowmap.isEmpty()) {
                        ArrayList<Integer> toremove = new ArrayList<Integer>();
                        for (Map.Entry entry : rowmap.entrySet()) {
                            toremove.add((Integer)entry.getValue());
                        }
                        Collections.reverse(toremove);
                        for (Integer row : toremove) {
                            this.m_sort.remove(row);
                        }
                    }
                    if (changedRow != null && changedRow.length > 0 && changedRow[this.m_indexKeyColumn] != null && (Integer)changedRow[this.m_indexKeyColumn] > 0) {
                        this.m_virtualBuffer.put((Integer)changedRow[this.m_indexKeyColumn], changedRow);
                    }
                }
                catch (SQLException e) {
                    if (DB.getDatabase().isQueryTimeout(e)) {
                        this.m_rowLoadTimeout = true;
                    }
                    log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    DB.close(rs, stmt);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                throw throwable;
            }
            DB.close(rs, stmt);
        }
    }

    public void setChanged(boolean changed) {
        if (!this.m_open || this.m_readOnly) {
            return;
        }
        this.m_changed = changed;
        if (!changed) {
            this.m_rowChanged = -1;
        }
    }

    @Override
    public final void setValueAt(Object value, int row, int col) {
        this.setValueAt(value, row, col, false, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force) {
        this.setValueAt(value, row, col, force, false);
    }

    public final void setValueAt(Object value, int row, int col, boolean force, boolean isInitEdit) {
        if (!this.m_open || this.m_readOnly || row < 0 || col < 0 || this.m_rowCount == 0 || row >= this.m_rowCount) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("r=" + row + " c=" + col + " - R/O=" + this.m_readOnly + ", Rows=" + this.m_rowCount + " - Ignored");
            }
            return;
        }
        this.dataSave(row, false);
        Object oldValue = this.getValueAt(row, col);
        if (!(force || isInitEdit || this.isValueChanged(oldValue, value))) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("r=" + row + " c=" + col + " - New=" + String.valueOf(value) + "==Old=" + String.valueOf(oldValue) + " - Ignored");
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("r=" + row + " c=" + col + " = " + String.valueOf(value) + " (" + String.valueOf(oldValue) + ")");
        }
        this.m_oldValue = new Object[3];
        this.m_oldValue[0] = row;
        this.m_oldValue[1] = col;
        this.m_oldValue[2] = oldValue;
        Object[] rowData = this.getDataAtRow(row);
        this.m_rowChanged = row;
        if (this.m_rowData == null) {
            int size = this.m_fields.size();
            this.m_rowData = new Object[size];
            int i = 0;
            while (i < size) {
                this.m_rowData[i] = rowData[i];
                ++i;
            }
        }
        rowData[col] = value;
        this.setDataAtRow(row, rowData);
        this.fireTableCellUpdated(row, col);
        GridField field = this.getField(col);
        field.setValue(value, this.m_inserting);
        DataStatusEvent evt = this.createDSE();
        evt.setIsInitEdit(isInitEdit);
        evt.setChangedColumn(col, field.getColumnName());
        this.fireDataStatusChanged(evt);
    }

    public Object getOldValue(int row, int col) {
        if (this.m_oldValue == null) {
            return null;
        }
        if ((Integer)this.m_oldValue[0] == row && (Integer)this.m_oldValue[1] == col) {
            return this.m_oldValue[2];
        }
        return null;
    }

    public boolean needSave(boolean onlyRealChange) {
        return this.needSave(this.m_rowChanged, onlyRealChange);
    }

    public boolean needSave() {
        return this.needSave(this.m_rowChanged, false);
    }

    public boolean needSave(int newRow) {
        return this.needSave(newRow, false);
    }

    public boolean needSave(int newRow, boolean onlyRealChange) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        }
        if (!this.m_changed && this.m_rowChanged == -1) {
            return false;
        }
        if (this.m_changed && this.m_rowChanged == -1 && onlyRealChange) {
            return false;
        }
        return newRow != this.m_rowChanged;
    }

    public boolean dataSave(int newRow, boolean manualCmd) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + newRow + ", Changed=" + this.m_rowChanged + "/" + this.m_changed);
        }
        if (!this.m_changed && this.m_rowChanged == -1) {
            return true;
        }
        if (newRow == this.m_rowChanged) {
            return true;
        }
        return this.dataSave(manualCmd) == 'O';
    }

    public char dataSave(boolean manualCmd) {
        if (!this.m_open) {
            log.warning("Error - Open=" + this.m_open);
            return 'E';
        }
        if (this.m_rowChanged == -1) {
            if (log.isLoggable(Level.CONFIG)) {
                log.config("NoNeed - Changed=" + this.m_changed + ", Row=" + this.m_rowChanged);
            }
            if (!manualCmd) {
                return 'O';
            }
        }
        if (this.m_rowData == null) {
            this.m_rowChanged = -1;
            if (log.isLoggable(Level.FINE)) {
                log.fine("No Changes");
            }
            return 'E';
        }
        if (this.m_readOnly) {
            if (log.isLoggable(Level.WARNING)) {
                log.warning("IsReadOnly - ignored");
            }
            this.dataIgnore();
            return 'A';
        }
        if (this.m_rowChanged == -1) {
            if (this.m_newRow != -1) {
                this.m_rowChanged = this.m_newRow;
            } else {
                this.fireDataStatusEEvent("SaveErrorNoChange", "", true);
                return 'E';
            }
        }
        int[] co = this.getClientOrg(this.m_rowChanged);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        if (!MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, true)) {
            this.fireDataStatusEEvent(CLogger.retrieveError());
            this.dataIgnore();
            return 'A';
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Row=" + this.m_rowChanged);
        }
        try {
            if (!manualCmd) {
                this.m_vetoableChangeSupport.fireVetoableChange(PROPERTY, -1, this.m_rowChanged);
            }
        }
        catch (PropertyVetoException pve) {
            log.warning(pve.getMessage());
            return 'U';
        }
        Object[] rowData = this.getDataAtRow(this.m_rowChanged);
        String missingColumns = this.getMandatory(rowData);
        if (missingColumns.length() != 0) {
            this.fireDataStatusEEvent("FillMandatory", missingColumns + "\n", true);
            return 'M';
        }
        int Record_ID = 0;
        if (!this.m_inserting) {
            Record_ID = this.getKeyID(this.m_rowChanged);
        }
        try {
            return this.dataSavePO(Record_ID);
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException) {
                log.warning(this.m_tableName + " - " + e.getLocalizedMessage());
            } else {
                log.log(Level.SEVERE, "Persistency Issue - " + this.m_tableName + ": " + e.getLocalizedMessage(), e);
                log.saveError("Error", e.getLocalizedMessage());
            }
            return 'E';
        }
    }

    private char dataSavePO(int Record_ID) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ID=" + Record_ID);
        }
        Object[] rowData = this.getDataAtRow(this.m_rowChanged);
        MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
        PO po = null;
        if (!this.m_importing) {
            this.m_trxName = null;
        }
        if (Record_ID != -1) {
            if (Record_ID == 0 && !this.m_inserting && MTable.isZeroIDTable(table2.getTableName())) {
                String uuidFromZeroID = table2.getUUIDFromZeroID();
                po = table2.getPOByUU(uuidFromZeroID, this.m_trxName);
            } else {
                po = table2.getPO(Record_ID, this.m_trxName);
            }
        } else {
            po = table2.getPO(this.getWhereClause(rowData), this.m_trxName);
        }
        if (po == null) {
            throw new ClassNotFoundException("No Persistent Object");
        }
        if (!po.is_new() && this.hasChanged(po)) {
            String adMessage = "CurrentRecordModified";
            String msg = Msg.getMsg(Env.getCtx(), adMessage);
            this.fireDataStatusEEvent(adMessage, msg, true);
            return 'E';
        }
        int size = this.m_fields.size();
        int col = 0;
        while (col < size) {
            GridField field = this.m_fields.get(col);
            if (!field.isVirtualColumn()) {
                String columnName = field.getColumnName();
                Object value = rowData[col];
                Object oldValue = this.m_rowData[col];
                if (field.getDisplayType() != 26 && (oldValue != null || value != null) && (this.m_inserting || this.isValueChanged(oldValue, value))) {
                    int poIndex = po.get_ColumnIndex(columnName);
                    if (poIndex < 0) {
                        po.set_CustomColumn(columnName, value);
                    } else {
                        Object dbValue = po.get_Value(poIndex);
                        if (this.m_inserting || !this.m_compareDB || oldValue == null && dbValue == null || oldValue != null && oldValue.equals(dbValue) || value == null && dbValue == null || value != null && value.equals(dbValue) || oldValue != null && dbValue != null && oldValue.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue) || value != null && dbValue != null && value.getClass().equals(byte[].class) && dbValue.getClass().equals(byte[].class) && Arrays.equals((byte[])oldValue, (byte[])dbValue)) {
                            if (!po.set_ValueNoCheck(columnName, value)) {
                                ValueNamePair lastError = CLogger.retrieveError();
                                if (lastError != null) {
                                    String adMessage = lastError.getValue();
                                    String adMessageArgument = lastError.getName().trim();
                                    StringBuilder info = new StringBuilder(adMessageArgument);
                                    if (!adMessageArgument.endsWith(";")) {
                                        info.append(";");
                                    }
                                    info.append(field.getHeader());
                                    this.fireDataStatusEEvent(adMessage, info.toString(), true);
                                } else {
                                    this.fireDataStatusEEvent("Set value failed", field.getHeader(), true);
                                }
                                return 'E';
                            }
                        } else {
                            String msg = columnName + "= " + String.valueOf(oldValue) + (String)(oldValue == null ? "" : "(" + oldValue.getClass().getName() + ")") + " != DB: " + String.valueOf(dbValue) + (String)(dbValue == null ? "" : "(" + dbValue.getClass().getName() + ")") + " -> New: " + String.valueOf(value) + (String)(value == null ? "" : "(" + value.getClass().getName() + ")");
                            this.dataRefresh(this.m_rowChanged);
                            this.fireDataStatusEEvent("SaveErrorDataChanged", msg, true);
                            return 'E';
                        }
                    }
                }
            }
            ++col;
        }
        if (!po.save()) {
            String msg = "SaveError";
            Object info = "";
            ValueNamePair ppE = CLogger.retrieveError();
            if (ppE != null) {
                msg = ppE.getValue();
                info = ppE.getName();
                if ("DBExecuteError".equals(msg)) {
                    info = "DBExecuteError:" + (String)info;
                }
            }
            this.fireDataStatusEEvent(msg, (String)info, true);
            return 'E';
        }
        if (this.m_virtual && po.get_ID() > 0) {
            MSort sort = this.m_sort.get(this.m_rowChanged);
            int oldid = sort.index;
            if (oldid != po.get_ID()) {
                sort.index = po.get_ID();
                Object[] data = this.m_virtualBuffer.remove(oldid);
                data[this.m_indexKeyColumn] = sort.index;
                this.m_virtualBuffer.put(sort.index, data);
            }
        }
        String whereClause = po.get_WhereClause(true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Reading ... " + whereClause);
        }
        StringBuilder refreshSQL = new StringBuilder(this.m_SQL_Select).append(" WHERE ").append(whereClause);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(refreshSQL.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Object[] rowDataDB = this.readData(rs);
                    this.setDataAtRow(this.m_rowChanged, rowDataDB);
                    this.fireTableRowsUpdated(this.m_rowChanged, this.m_rowChanged);
                }
            }
            catch (SQLException e) {
                String msg = "SaveError";
                log.log(Level.SEVERE, refreshSQL.toString(), e);
                this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return 'E';
            }
        }
        catch (Throwable dbValue) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw dbValue;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.m_rowData = null;
        this.m_changed = false;
        this.m_compareDB = true;
        this.m_rowChanged = -1;
        this.m_newRow = -1;
        this.m_inserting = false;
        ValueNamePair pp = CLogger.retrieveWarning();
        if (pp != null) {
            String msg = pp.getValue();
            info = pp.getName();
            this.fireDataStatusEEvent(msg, info, false);
        } else {
            pp = CLogger.retrieveInfo();
            String msg = DATA_SAVED_MESSAGE;
            info = "";
            if (pp != null) {
                msg = pp.getValue();
                info = pp.getName();
            }
            this.fireDataStatusIEvent(msg, info);
        }
        log.config("fini");
        return 'O';
    }

    private String getWhereClause(Object[] rowData) {
        int size = this.m_fields.size();
        StringBuilder singleRowWHERE = null;
        StringBuilder singleRowUUWHERE = null;
        StringBuilder multiRowWHERE = null;
        String tableName = this.getTableName();
        int uidColumn = -1;
        int col = 0;
        while (col < size) {
            Object value;
            GridField field = this.m_fields.get(col);
            String columnName = field.getColumnName();
            if (field.isKey()) {
                value = rowData[col];
                if (value == null) {
                    log.log(Level.WARNING, "PK data is null - " + columnName);
                    return null;
                }
                if (columnName.endsWith("_ID")) {
                    singleRowWHERE = new StringBuilder(tableName).append(".").append(columnName).append("=").append(value);
                    break;
                }
                singleRowWHERE = new StringBuilder(tableName).append(".").append(columnName).append("=").append(DB.TO_STRING(value.toString()));
                break;
            }
            if (field.isParentColumn()) {
                value = rowData[col];
                if (value == null) {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "FK data is null - " + columnName);
                    }
                } else {
                    if (multiRowWHERE == null) {
                        multiRowWHERE = new StringBuilder();
                    } else {
                        multiRowWHERE.append(" AND ");
                    }
                    if (columnName.endsWith("_ID")) {
                        multiRowWHERE.append(tableName).append(".").append(columnName).append("=").append(value);
                    } else if (value instanceof Timestamp) {
                        multiRowWHERE.append(tableName).append(".").append(columnName).append("=").append(DB.TO_DATE((Timestamp)value, false));
                    } else {
                        multiRowWHERE.append(tableName).append(".").append(columnName).append("=").append(DB.TO_STRING(value.toString()));
                    }
                }
            } else if (columnName.equals(PO.getUUIDColumnName(tableName))) {
                uidColumn = col;
            }
            ++col;
        }
        if (singleRowWHERE != null) {
            return singleRowWHERE.toString();
        }
        if (multiRowWHERE != null) {
            return multiRowWHERE.toString();
        }
        if (uidColumn >= 0) {
            Object value = rowData[uidColumn];
            if (value == null && multiRowWHERE == null) {
                log.log(Level.WARNING, "UUID data is null - " + uidColumn);
                return null;
            }
            singleRowUUWHERE = new StringBuilder(tableName).append(".").append(PO.getUUIDColumnName(tableName)).append("=").append(DB.TO_STRING(value.toString()));
        }
        if (singleRowUUWHERE != null) {
            return singleRowUUWHERE.toString();
        }
        log.log(Level.WARNING, "No key Found");
        return null;
    }

    private String getMandatory(Object[] rowData) {
        StringBuilder sb = new StringBuilder();
        int size = this.m_fields.size();
        int i = 0;
        while (i < size) {
            GridField field = this.m_fields.get(i);
            if (field.isMandatory(true)) {
                if (rowData[i] == null || rowData[i].toString().length() == 0) {
                    field.setInserting(true);
                    field.setError(true);
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(field.getHeader());
                } else {
                    field.setError(false);
                }
            }
            ++i;
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.toString();
    }

    public boolean isNeedSaveAndMandatoryFill() {
        Object[] rowData;
        String missingColumns;
        if (!this.m_open) {
            return false;
        }
        if (this.m_rowChanged == -1) {
            return false;
        }
        if (this.m_rowData == null) {
            return false;
        }
        if (this.m_readOnly) {
            return false;
        }
        if (this.m_rowChanged == -1) {
            if (this.m_newRow != -1) {
                this.m_rowChanged = this.m_newRow;
            } else {
                return false;
            }
        }
        return (missingColumns = this.getMandatory(rowData = this.getDataAtRow(this.m_rowChanged))).length() == 0;
    }

    public boolean dataNew(int currentRow, boolean copyCurrent) {
        MSort newSort;
        if (log.isLoggable(Level.INFO)) {
            log.info("Current=" + currentRow + ", Copy=" + copyCurrent);
        }
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotInsert", "", true);
            return false;
        }
        this.dataSave(-2, false);
        this.m_inserting = true;
        int size = this.m_fields.size();
        this.m_rowData = new Object[size];
        Object[] rowData = new Object[size];
        this.m_changed = true;
        this.m_compareDB = true;
        this.m_newRow = currentRow + 1;
        if (this.m_sort.size() < this.m_newRow) {
            this.m_newRow = this.m_sort.size();
        }
        MSort mSort = newSort = this.m_virtual ? new MSort(NEW_ROW_ID, null) : new MSort(this.m_sort.size(), null);
        if (this.m_virtual) {
            this.m_virtualBuffer.put(NEW_ROW_ID, rowData);
        } else {
            this.m_buffer.add(rowData);
        }
        this.m_sort.add(this.m_newRow, newSort);
        ++this.m_rowCount;
        if (copyCurrent) {
            boolean hasDocTypeTargetField = this.getField("C_DocTypeTarget_ID") != null;
            Object[] origData = this.getDataAtRow(currentRow);
            int i = 0;
            while (i < size) {
                GridField field = this.m_fields.get(i);
                MColumn column = null;
                if (field.getAD_Column_ID() > 0) {
                    column = MColumn.get(this.m_ctx, field.getAD_Column_ID());
                }
                if (!field.isVirtualColumn()) {
                    if (field.isKey() || column != null && column.isUUIDColumn() || column != null && column.isStandardColumn() && !column.getColumnName().equals("AD_Org_ID") || hasDocTypeTargetField && field.getColumnName().equals("C_DocType_ID") || !field.isAllowCopy()) {
                        value = field.getDefault();
                        field.setValue(value, this.m_inserting);
                        field.validateValueNoDirect();
                        rowData[i] = field.getValue();
                    } else {
                        value = origData[i];
                        field.setValue(value, this.m_inserting);
                        field.validateValueNoDirect();
                        rowData[i] = field.getValue();
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                GridField field = this.m_fields.get(i);
                if (field.getGridTab() != null) {
                    String key = field.getVO().WindowNo + "|" + field.getVO().TabNo + "|" + field.getVO().ColumnName;
                    field.getVO().ctx.remove(key);
                }
                Object value = field.getDefault();
                field.setValue(value, this.m_inserting);
                field.validateValueNoDirect();
                rowData[i] = field.getValue();
                ++i;
            }
        }
        this.m_rowChanged = -1;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Current=" + currentRow + ", New=" + this.m_newRow);
        }
        this.fireTableRowsInserted(this.m_newRow, this.m_newRow);
        this.fireDataStatusIEvent(copyCurrent ? DATA_UPDATE_COPIED_MESSAGE : DATA_INSERTED_MESSAGE, "");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Current=" + currentRow + ", New=" + this.m_newRow + " - complete");
        }
        return true;
    }

    public boolean dataDelete(int row) {
        Boolean processed;
        if (log.isLoggable(Level.INFO)) {
            log.info("Row=" + row);
        }
        if (row < 0) {
            return false;
        }
        if (this.m_readOnly) {
            this.fireDataStatusEEvent("AccessCannotDelete", "", true);
            return false;
        }
        if (!this.m_deleteable) {
            this.fireDataStatusEEvent("AccessNotDeleteable", "", true);
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && !this.m_tableName.startsWith("I_") && (processed = (Boolean)this.getValueAt(row, this.m_indexProcessedColumn)) != null && processed.booleanValue()) {
            this.fireDataStatusEEvent("CannotDeleteTrx", "", true);
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        if (!MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, 0, true)) {
            this.fireDataStatusEEvent("AccessCannotDelete", "", true);
            return false;
        }
        MSort sort = this.m_sort.get(row);
        Object[] rowData = this.getDataAtRow(row);
        PO po = this.getPO(row);
        if (po != null) {
            boolean ok = false;
            try {
                ok = po.delete(false);
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Delete", t);
            }
            if (!ok) {
                ValueNamePair vp = CLogger.retrieveError();
                if (vp != null && !Util.isEmpty(vp.getValue()) && !Util.isEmpty(vp.getName())) {
                    this.fireDataStatusEEvent(vp);
                } else {
                    this.fireDataStatusEEvent("DeleteError", "", true);
                }
                return false;
            }
        } else {
            StringBuilder sql = new StringBuilder("DELETE FROM ");
            sql.append(this.m_tableName).append(" WHERE ").append(this.getWhereClause(rowData));
            int no = 0;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), 1005, 1008, null);
                    no = pstmt.executeUpdate();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    String msg = "DeleteError";
                    String dbMsg = DBException.getDefaultDBExceptionMessage(e);
                    if (!Util.isEmpty(dbMsg)) {
                        msg = dbMsg;
                    }
                    this.fireDataStatusEEvent(msg, e.getLocalizedMessage(), true);
                    DB.close(pstmt);
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                pstmt = null;
                throw throwable;
            }
            DB.close(pstmt);
            pstmt = null;
            if (no != 1) {
                log.log(Level.SEVERE, "Number of deleted rows = " + no);
                return false;
            }
        }
        if (this.m_virtual) {
            this.m_virtualBuffer.remove(sort.index);
        } else {
            this.m_buffer.remove(sort.index);
        }
        --this.m_rowCount;
        this.m_sort.remove(row);
        if (!this.m_virtual) {
            int i = 0;
            while (i < this.m_sort.size()) {
                MSort ptr = this.m_sort.get(i);
                if (ptr.index > sort.index) {
                    --ptr.index;
                }
                ++i;
            }
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.fireTableRowsDeleted(row, row);
        this.fireDataStatusIEvent("Deleted", "");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Row=" + row + " complete");
        }
        return true;
    }

    public void dataIgnore() {
        if (!this.m_inserting && !this.m_changed && this.m_rowChanged < 0) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Nothing to ignore");
            }
            this.m_newRow = -1;
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Inserting=" + this.m_inserting);
        }
        if (this.m_inserting) {
            MSort sort = this.m_sort.get(this.m_newRow);
            if (this.m_virtual) {
                this.m_virtualBuffer.remove(NEW_ROW_ID);
            } else {
                this.m_buffer.remove(sort.index);
            }
            --this.m_rowCount;
            this.m_sort.remove(this.m_newRow);
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
            this.fireTableRowsDeleted(this.m_newRow, this.m_newRow);
        } else {
            if (this.m_rowData != null) {
                this.setDataAtRow(this.m_rowChanged, this.m_rowData);
            }
            this.m_changed = false;
            this.m_rowData = null;
            this.m_rowChanged = -1;
            this.m_inserting = false;
        }
        this.m_newRow = -1;
        this.fireDataStatusIEvent(DATA_IGNORED_MESSAGE, "");
    }

    public void dataRefresh(int row) {
        this.dataRefresh(row, true);
    }

    public String getWhereClause(int row) {
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return null;
        }
        Object[] rowData = this.getDataAtRow(row);
        if (rowData == null) {
            return null;
        }
        String where = this.getWhereClause(rowData);
        return where;
    }

    public void dataRefresh(int row, boolean fireStatusEvent) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Row=" + row);
        }
        if (row < 0 || this.m_sort.size() == 0 || this.m_inserting) {
            return;
        }
        Object[] rowData = this.getDataAtRow(row);
        this.dataIgnore();
        String where = this.getWhereClause(rowData);
        if (where == null || where.length() == 0) {
            where = "1=2";
        }
        String sql = this.m_SQL_Select + " WHERE " + where;
        Object[] rowDataDB = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rowDataDB = this.readData(rs);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                this.fireTableRowsUpdated(row, row);
                this.fireDataStatusEEvent("RefreshError", sql, true);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (rowDataDB != null) {
            this.setDataAtRow(row, rowDataDB);
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        this.fireTableRowsUpdated(row, row);
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public void dataRefreshAll() {
        this.dataRefreshAll(true);
    }

    public void dataRefreshAll(boolean fireStatusEvent) {
        this.dataRefreshAll(fireStatusEvent, -1);
    }

    public void dataRefreshAll(boolean fireStatusEvent, int rowToRetained) {
        this.m_inserting = false;
        this.dataIgnore();
        String retainedWhere = null;
        if (rowToRetained >= 0) {
            retainedWhere = this.getWhereClause(rowToRetained);
        }
        this.close(false);
        if (retainedWhere != null) {
            StringBuilder orRetainedWhere;
            if (this.m_whereClause != null && this.m_whereClause.trim().length() > 0 && !this.m_whereClause.contains((orRetainedWhere = new StringBuilder(") OR (").append(retainedWhere).append(")) ")).toString())) {
                this.m_whereClause = "((" + this.m_whereClause + orRetainedWhere.toString();
            }
            this.open(this.m_maxRows);
        } else {
            this.open(this.m_maxRows);
        }
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        if (this.m_lastSortColumnIndex >= 0) {
            this.loadComplete();
            this.sort(this.m_lastSortColumnIndex, this.m_lastSortedAscending);
        }
        this.fireTableDataChanged();
        if (fireStatusEvent) {
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
    }

    public boolean dataRequery(String whereClause, boolean onlyCurrentRows, int onlyCurrentDays, boolean fireEvents) {
        if (log.isLoggable(Level.INFO)) {
            log.info(whereClause + "; OnlyCurrent=" + onlyCurrentRows);
        }
        this.close(false);
        this.m_onlyCurrentDays = onlyCurrentDays;
        this.setSelectWhereClause(whereClause, onlyCurrentRows, this.m_onlyCurrentDays);
        this.open(this.m_maxRows);
        this.m_rowData = null;
        this.m_changed = false;
        this.m_rowChanged = -1;
        this.m_inserting = false;
        if (this.m_lastSortColumnIndex >= 0) {
            this.loadComplete();
            this.sort(this.m_lastSortColumnIndex, this.m_lastSortedAscending);
        }
        if (fireEvents) {
            this.fireTableDataChanged();
            this.fireDataStatusIEvent(DATA_REFRESH_MESSAGE, "");
        }
        return true;
    }

    public boolean dataRequery(String whereClause, boolean onlyCurrentRows, int onlyCurrentDays) {
        return this.dataRequery(whereClause, onlyCurrentRows, onlyCurrentDays, true);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.m_readOnly) {
            return false;
        }
        if (col == this.m_indexKeyColumn) {
            return false;
        }
        if (col < 0 && col >= this.m_fields.size()) {
            return false;
        }
        if (col == this.m_indexActiveColumn && this.m_indexProcessedColumn == -1) {
            return true;
        }
        if (!this.isRowEditable(row)) {
            return false;
        }
        return this.m_fields.get(col).isEditable(false);
    }

    public boolean isRowEditable(int row) {
        Object processed;
        Object value;
        if (this.m_readOnly || row < 0) {
            return false;
        }
        if (this.m_indexActiveColumn > 0 && ((value = this.getValueAt(row, this.m_indexActiveColumn)) instanceof Boolean ? (Boolean)value == false : "N".equals(value))) {
            return false;
        }
        if (this.m_indexProcessedColumn > 0 && ((processed = this.getValueAt(row, this.m_indexProcessedColumn)) instanceof Boolean ? (Boolean)processed != false : "Y".equals(processed))) {
            return false;
        }
        int[] co = this.getClientOrg(row);
        int AD_Client_ID = co[0];
        int AD_Org_ID = co[1];
        int Record_ID = this.getKeyID(row);
        return MRole.getDefault(this.m_ctx, false).canUpdate(AD_Client_ID, AD_Org_ID, this.m_AD_Table_ID, Record_ID, false);
    }

    private int[] getClientOrg(int row) {
        Integer ii;
        Integer ii2;
        int AD_Client_ID = -1;
        if (this.m_indexClientColumn != -1 && (ii2 = (Integer)this.getValueAt(row, this.m_indexClientColumn)) != null) {
            AD_Client_ID = ii2;
        }
        int AD_Org_ID = 0;
        if (this.m_indexOrgColumn != -1 && (ii = (Integer)this.getValueAt(row, this.m_indexOrgColumn)) != null) {
            AD_Org_ID = ii;
        }
        return new int[]{AD_Client_ID, AD_Org_ID};
    }

    public void setReadOnly(boolean value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("ReadOnly=" + value);
        }
        this.m_readOnly = value;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    public boolean isInserting() {
        return this.m_inserting;
    }

    @Deprecated
    public void setCompareDB(boolean compareDB) {
        this.m_compareDB = compareDB;
    }

    @Deprecated
    public boolean getCompareDB() {
        return this.m_compareDB;
    }

    public void setDeleteable(boolean value) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleteable=" + value);
        }
        this.m_deleteable = value;
    }

    private Object[] readData(ResultSet rs) {
        int size = this.m_fields.size();
        Object[] rowData = new Object[size];
        String columnName = null;
        int displayType = 0;
        try {
            int j = 0;
            while (j < size) {
                GridField field = this.m_fields.get(j);
                columnName = field.getColumnName();
                displayType = field.getDisplayType();
                if (displayType == 11 || DisplayType.isID(displayType) && !columnName.equals("EntityType") && !columnName.equals("AD_Language")) {
                    rowData[j] = rs.getInt(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    }
                } else if (DisplayType.isNumeric(displayType)) {
                    rowData[j] = rs.getBigDecimal(j + 1);
                } else if (DisplayType.isDate(displayType)) {
                    rowData[j] = rs.getTimestamp(j + 1);
                } else if (displayType == 26) {
                    rowData[j] = null;
                } else if (displayType == 20) {
                    String str = rs.getString(j + 1);
                    if (field.isEncryptedColumn()) {
                        str = (String)this.decrypt(str, this.getAD_Client_ID(rs));
                    }
                    rowData[j] = "Y".equals(str);
                } else if (DisplayType.isLOB(displayType)) {
                    Object value = rs.getObject(j + 1);
                    if (rs.wasNull()) {
                        rowData[j] = null;
                    } else if (value instanceof Clob) {
                        lob = (Clob)value;
                        length = lob.length();
                        rowData[j] = lob.getSubString(1L, (int)length);
                    } else if (value instanceof Blob) {
                        lob = (Blob)value;
                        length = lob.length();
                        rowData[j] = lob.getBytes(1L, (int)length);
                    } else if (value instanceof String) {
                        rowData[j] = value;
                    } else if (value instanceof byte[]) {
                        rowData[j] = value;
                    }
                } else {
                    rowData[j] = rs.getString(j + 1);
                }
                if (field.isEncryptedColumn() && displayType != 20) {
                    rowData[j] = this.decrypt(rowData[j], this.getAD_Client_ID(rs));
                }
                ++j;
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, columnName + ", DT=" + displayType, e);
        }
        return rowData;
    }

    private Object decrypt(Object yy, int AD_Client_ID) {
        if (yy == null) {
            return null;
        }
        return SecureEngine.decrypt(yy, AD_Client_ID);
    }

    private int getAD_Client_ID(ResultSet rs) {
        int AD_Client_ID = -1;
        try {
            AD_Client_ID = rs.getInt("AD_Client_ID");
            if (rs.wasNull()) {
                AD_Client_ID = -1;
            }
        }
        catch (SQLException sQLException) {
            AD_Client_ID = -1;
        }
        if (AD_Client_ID == -1) {
            AD_Client_ID = this.getAD_Client_ID();
        }
        return AD_Client_ID;
    }

    private int getAD_Client_ID() {
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        GridField field = this.getField("AD_Client_ID");
        if (field != null && field.getValue() != null) {
            AD_Client_ID = ((Number)field.getValue()).intValue();
        }
        return AD_Client_ID;
    }

    public synchronized void removeDataStatusListener(DataStatusListener l) {
        this.listenerList.remove(DataStatusListener.class, l);
    }

    public synchronized void addDataStatusListener(DataStatusListener l) {
        this.listenerList.add(DataStatusListener.class, l);
    }

    private void fireDataStatusChanged(DataStatusEvent e) {
        DataStatusListener[] listeners = (DataStatusListener[])this.listenerList.getListeners(DataStatusListener.class);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].dataStatusChanged(e);
            ++i;
        }
    }

    private DataStatusEvent createDSE() {
        boolean changed = this.m_changed;
        if (this.m_rowChanged != -1) {
            changed = true;
        }
        DataStatusEvent dse = new DataStatusEvent(this, this.m_rowCount, changed, Env.isAutoCommit(this.m_ctx, this.m_WindowNo), this.m_inserting);
        dse.AD_Table_ID = this.m_AD_Table_ID;
        dse.Record_ID = null;
        return dse;
    }

    protected void fireDataStatusIEvent(String AD_Message, String info) {
        DataStatusEvent e = this.createDSE();
        e.setInfo(AD_Message, info, false, false);
        if (SORTED_DSE_EVENT.equals(AD_Message) && this.m_currentRow >= 0) {
            e.setCurrentRow(this.m_currentRow);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(String AD_Message, String info, boolean isError) {
        DataStatusEvent e = this.createDSE();
        if (info != null && info.startsWith("DBExecuteError:")) {
            String newinfo;
            int nl = info.indexOf("\n");
            String firstline = nl > 0 ? info.substring(0, nl) : info;
            if (firstline.equals(newinfo = Msg.getMsg(this.m_ctx, firstline))) {
                newinfo = info.substring(15);
            }
            e.setInfo(AD_Message, newinfo, isError, !isError);
        } else {
            e.setInfo(AD_Message, info, isError, !isError);
        }
        if (isError) {
            log.saveWarning(AD_Message, info);
        }
        this.fireDataStatusChanged(e);
    }

    protected void fireDataStatusEEvent(ValueNamePair errorLog) {
        if (errorLog != null) {
            this.fireDataStatusEEvent(errorLog.getValue(), errorLog.getName(), true);
        }
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener l) {
        this.m_vetoableChangeSupport.addVetoableChangeListener(l);
    }

    protected void fireVetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        this.m_vetoableChangeSupport.fireVetoableChange(e);
    }

    public String toString() {
        return "MTable[" + this.m_tableName + ",WindowNo=" + this.m_WindowNo + ",Tab=" + this.m_TabNo + "]";
    }

    public int getNewRow() {
        return this.m_newRow;
    }

    protected void setFieldVFormat(String identifier, String strNewFormat) {
        int cols = this.m_fields.size();
        int i = 0;
        while (i < cols) {
            GridField field = this.m_fields.get(i);
            if (identifier.equalsIgnoreCase(field.getColumnName())) {
                field.setVFormat(strNewFormat);
                this.m_fields.set(i, field);
                break;
            }
            ++i;
        }
    }

    public boolean hasChanged(int row) {
        if (this.getKeyID(row) > 0) {
            int colUpdated = this.findColumn("Updated");
            int colProcessed = this.findColumn("Processed");
            boolean hasUpdated = colUpdated >= 0;
            boolean hasProcessed = colProcessed >= 0;
            String columns = null;
            if (hasUpdated && hasProcessed) {
                columns = new String("Updated, Processed");
            } else if (hasUpdated) {
                columns = new String("Updated");
            } else if (hasProcessed) {
                columns = new String("Processed");
            } else {
                return false;
            }
            if (this.findColumn(this.m_tableName + "_ID") == -1) {
                return false;
            }
            Timestamp dbUpdated = null;
            String dbProcessedS = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            String sql = "SELECT " + columns + " FROM " + this.m_tableName + " WHERE " + this.m_tableName + "_ID=?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getKeyID(row));
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        int idx = 1;
                        if (hasUpdated) {
                            dbUpdated = rs.getTimestamp(idx++);
                        }
                        if (hasProcessed) {
                            dbProcessedS = rs.getString(idx++);
                        }
                    } else if (log.isLoggable(Level.INFO)) {
                        log.info("No Value " + sql);
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sql);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (hasUpdated) {
                Timestamp memUpdated = null;
                memUpdated = (Timestamp)this.getOldValue(row, colUpdated);
                if (memUpdated == null) {
                    memUpdated = (Timestamp)this.getValueAt(row, colUpdated);
                }
                if (memUpdated != null && !memUpdated.equals(dbUpdated)) {
                    return true;
                }
            }
            if (hasProcessed) {
                Boolean memProcessed = null;
                memProcessed = (Boolean)this.getOldValue(row, colProcessed);
                if (memProcessed == null) {
                    if (this.getValueAt(row, colProcessed) instanceof Boolean) {
                        memProcessed = (Boolean)this.getValueAt(row, colProcessed);
                    } else if (this.getValueAt(row, colProcessed) instanceof String) {
                        memProcessed = Boolean.valueOf((String)this.getValueAt(row, colProcessed));
                    }
                }
                Boolean dbProcessed = Boolean.TRUE;
                if (!dbProcessedS.equals("Y")) {
                    dbProcessed = Boolean.FALSE;
                }
                if (memProcessed != null && !memProcessed.equals(dbProcessed)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasChanged(PO po) {
        boolean hasProcessed;
        if (this.m_rowChanged < 0) {
            return false;
        }
        int colUpdated = this.findColumn("Updated");
        int colProcessed = this.findColumn("Processed");
        boolean hasUpdated = colUpdated >= 0;
        boolean bl = hasProcessed = colProcessed >= 0;
        if (!hasUpdated && !hasProcessed) {
            return false;
        }
        Timestamp dbUpdated = (Timestamp)po.get_Value("Updated");
        if (hasUpdated) {
            Timestamp memUpdated = null;
            memUpdated = (Timestamp)this.getOldValue(this.m_rowChanged, colUpdated);
            if (memUpdated == null) {
                memUpdated = (Timestamp)this.getValueAt(this.m_rowChanged, colUpdated);
            }
            if (memUpdated != null && !memUpdated.equals(dbUpdated)) {
                return true;
            }
        }
        if (hasProcessed) {
            Boolean memProcessed = null;
            memProcessed = (Boolean)this.getOldValue(this.m_rowChanged, colProcessed);
            if (memProcessed == null) {
                if (this.getValueAt(this.m_rowChanged, colProcessed) instanceof Boolean) {
                    memProcessed = (Boolean)this.getValueAt(this.m_rowChanged, colProcessed);
                } else if (this.getValueAt(this.m_rowChanged, colProcessed) instanceof String) {
                    memProcessed = Boolean.valueOf((String)this.getValueAt(this.m_rowChanged, colProcessed));
                }
            }
            Boolean dbProcessed = po.get_ValueAsBoolean("Processed");
            if (memProcessed != null && !memProcessed.equals(dbProcessed)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int getParentTabNo() {
        tabNo = this.m_TabNo;
        currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, tabNo, "_TabInfo_TabLevel");
        parentLevel = currentLevel - 1;
        if (parentLevel >= 0) ** GOTO lbl8
        return tabNo;
lbl-1000:
        // 1 sources

        {
            currentLevel = Env.getContextAsInt(this.m_ctx, this.m_WindowNo, --tabNo, "_TabInfo_TabLevel");
            if (tabNo == 0) break;
lbl8:
            // 2 sources

            ** while (parentLevel != currentLevel)
        }
lbl9:
        // 2 sources

        return tabNo;
    }

    public int getTabNo() {
        return this.m_TabNo;
    }

    private boolean isNotNullAndIsEmpty(Object value) {
        return value != null && value instanceof String && value.toString().equals("");
    }

    private boolean isValueChanged(Object oldValue, Object value) {
        boolean bChanged;
        if (this.isNotNullAndIsEmpty(oldValue)) {
            oldValue = null;
        }
        if (this.isNotNullAndIsEmpty(value)) {
            value = null;
        }
        boolean bl = bChanged = oldValue == null && value != null || oldValue != null && value == null;
        if (!bChanged && oldValue != null) {
            if (oldValue.getClass().equals(value.getClass())) {
                bChanged = oldValue instanceof Comparable ? ((Comparable)oldValue).compareTo(value) != 0 : !oldValue.equals(value);
            } else if (value != null) {
                bChanged = !oldValue.toString().equals(value.toString());
            }
        }
        return bChanged;
    }

    public PO getPO(int row) {
        MTable table2 = MTable.get(this.m_ctx, this.m_AD_Table_ID);
        PO po = null;
        int Record_ID = this.getKeyID(row);
        if (Record_ID != -1) {
            if (Record_ID == 0 && MTable.isZeroIDTable(table2.getTableName())) {
                String uuidFromZeroID = table2.getUUIDFromZeroID();
                po = table2.getPOByUU(uuidFromZeroID, this.m_trxName);
            } else {
                po = table2.getPO(Record_ID, this.m_trxName);
            }
        } else {
            po = table2.getPO(this.getWhereClause(this.getDataAtRow(row)), this.m_trxName);
        }
        return po;
    }

    public void setImportingMode(boolean importing, String trxName) {
        this.m_importing = importing;
        this.m_trxName = trxName;
    }

    public boolean isImporting() {
        return this.m_importing;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public void resetCacheSortState() {
        this.m_lastSortColumnIndex = -1;
        this.m_lastSortedAscending = true;
    }

    public int getKeyColumnIndex() {
        return this.m_indexKeyColumn;
    }

    public int getRowChanged() {
        return this.m_rowChanged;
    }

    public void reset() {
        if (this.m_buffer != null) {
            this.m_buffer.clear();
        }
        this.m_changed = false;
        this.m_rowChanged = -1;
        if (this.m_sort != null) {
            this.m_sort.clear();
        }
        if (this.m_virtualBuffer != null) {
            this.m_virtualBuffer.clear();
        }
        this.m_rowCount = 0;
        this.m_rowData = null;
        this.m_oldValue = null;
        this.m_inserting = false;
        this.m_lastSortColumnIndex = -1;
        this.m_lastSortedAscending = false;
    }

    protected void setCurrentRow(int m_currentRow) {
        this.m_currentRow = m_currentRow;
    }

    protected class Loader
    implements Serializable,
    Runnable {
        private static final long serialVersionUID = -6866671239509705988L;
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;
        private Trx trx = null;
        private Properties m_context = null;
        private int maxRows;
        private int rows;

        public void setContext(Properties context) {
            this.m_context = context;
        }

        protected int open(int maxRows) {
            this.maxRows = maxRows;
            this.rows = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            GridTable.this.m_rowCountTimeout = false;
            try {
                pstmt = DB.prepareStatement(GridTable.this.m_SQL_Count, GridTable.this.get_TrxName());
                this.setParameter(pstmt, true);
                int timeout = MSysConfig.getIntValue("GRIDTABLE_INITIAL_COUNT_TIMEOUT_IN_SECONDS", 1, Env.getAD_Client_ID(Env.getCtx()));
                if (timeout > 0) {
                    pstmt.setQueryTimeout(timeout);
                }
                if ((rs = pstmt.executeQuery()).next()) {
                    this.rows = rs.getInt(1);
                }
            }
            catch (SQLException e0) {
                if (DB.getDatabase().isQueryTimeout(e0)) {
                    GridTable.this.m_rowCountTimeout = true;
                    DB.close(rs, pstmt);
                    return 0;
                }
                try {
                    throw new DBException(e0);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            StringBuilder info = new StringBuilder("Rows=");
            info.append(this.rows);
            if (this.rows == 0) {
                info.append(" - ").append(GridTable.this.m_SQL_Count);
            }
            if (maxRows > 0 && this.rows > maxRows) {
                info.append(" - MaxRows=").append(maxRows);
                this.rows = maxRows;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(info.toString());
            }
            return this.rows;
        }

        private void openResultSet() {
            String trxName = GridTable.this.get_TrxName();
            if (trxName == null) {
                trxName = GridTable.this.m_virtual ? Trx.createTrxName("Loader") : null;
                Trx trx = this.trx = trxName != null ? Trx.get(trxName, true) : null;
                if (this.trx != null) {
                    this.trx.setDisplayName(this.getClass().getName() + "_openResultSet");
                }
            }
            try {
                this.m_pstmt = DB.prepareStatement(GridTable.this.m_SQL, trxName);
                if (GridTable.this.m_virtual) {
                    this.m_pstmt.setFetchSize(100);
                }
                this.setParameter(this.m_pstmt, false);
                int timeout = MSysConfig.getIntValue("GRIDTABLE_LOAD_TIMEOUT_IN_SECONDS", 30, Env.getAD_Client_ID(Env.getCtx()));
                if (timeout > 0) {
                    this.m_pstmt.setQueryTimeout(timeout);
                }
                this.m_rs = this.m_pstmt.executeQuery();
            }
            catch (SQLException e) {
                if (DB.getDatabase().isQueryTimeout(e)) {
                    GridTable.this.m_rowLoadTimeout = true;
                    throw new AdempiereException(Msg.getMsg(Env.getCtx(), GridTable.LOAD_TIMEOUT_ERROR_MESSAGE), e);
                }
                log.saveError(e.getLocalizedMessage(), e);
                throw new DBException(e);
            }
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
            if (this.trx != null) {
                this.trx.close();
                this.trx = null;
            }
        }

        @Override
        public void run() {
            try {
                if (this.m_context != null) {
                    ServerContext.setCurrentInstance(this.m_context);
                }
                this.doRun();
            }
            finally {
                if (this.m_context != null) {
                    ServerContext.dispose();
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void doRun() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 5[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void setParameter(PreparedStatement pstmt, boolean countSQL) {
            if (GridTable.this.m_parameterSELECT.size() == 0 && GridTable.this.m_parameterWHERE.size() == 0) {
                return;
            }
            try {
                Integer ii;
                Object para;
                int pos = 1;
                int i = 0;
                while (!countSQL && i < GridTable.this.m_parameterSELECT.size()) {
                    para = GridTable.this.m_parameterSELECT.get(i);
                    if (para != null && log.isLoggable(Level.FINE)) {
                        log.fine("Select " + i + "=" + String.valueOf(para));
                    }
                    if (para != null) {
                        if (para instanceof Integer) {
                            ii = (Integer)para;
                            pstmt.setInt(pos++, ii);
                        } else if (para instanceof BigDecimal) {
                            pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        } else {
                            pstmt.setString(pos++, para.toString());
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < GridTable.this.m_parameterWHERE.size()) {
                    para = GridTable.this.m_parameterWHERE.get(i);
                    if (para != null && log.isLoggable(Level.FINE)) {
                        log.fine("Where " + i + "=" + String.valueOf(para));
                    }
                    if (para != null) {
                        if (para instanceof Integer) {
                            ii = (Integer)para;
                            pstmt.setInt(pos++, ii);
                        } else if (para instanceof BigDecimal) {
                            pstmt.setBigDecimal(pos++, (BigDecimal)para);
                        } else {
                            pstmt.setString(pos++, para.toString());
                        }
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "parameter", e);
            }
        }
    }
}

