/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MUserDefTab;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Util;

public class GridTabVO
implements Evaluatee,
Serializable {
    private static final long serialVersionUID = 8781340605954851838L;
    private static final CCache<String, ArrayList<GridFieldVO>> s_gridFieldCache = new CCache("AD_Field", "GridFieldVO Cache", 100, 0, false, 0);
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID;
    public int TabNo;
    public int AD_Tab_ID;
    public String AD_Tab_UU;
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public boolean IsSingleRow = false;
    public boolean IsReadOnly = false;
    public boolean IsInsertRecord = true;
    public boolean HasTree = false;
    public String TreeDisplayedOn = "";
    public int MaxQueryRecords = 0;
    public int AD_Table_ID;
    public String AD_Table_UU;
    public int AD_Column_ID = 0;
    public int Parent_Column_ID = 0;
    public String TableName;
    public boolean IsView = false;
    public String AccessLevel;
    public boolean IsSecurityEnabled = false;
    public boolean IsDeleteable = false;
    public boolean IsHighVolume = false;
    public boolean IsAllowAdvancedLookup = false;
    public boolean IsLookupOnlySelection = false;
    public int AD_Process_ID = 0;
    public String AD_Process_UU;
    public String CommitWarning;
    public String WhereClause;
    public String OrderByClause;
    public String ReadOnlyLogic;
    public String DisplayLogic;
    public int TabLevel = 0;
    public int AD_Image_ID = 0;
    public int Included_Tab_ID = 0;
    public String ReplicationType = "L";
    public String EntityType = null;
    public boolean IsSortTab = false;
    public int AD_ColumnSortOrder_ID = 0;
    public int AD_ColumnSortYesNo_ID = 0;
    public boolean onlyCurrentRows = true;
    public int onlyCurrentDays = 0;
    public String AD_TabType = null;
    public boolean IsTranslationTab = false;
    public boolean IsAdvancedTab = false;
    public boolean IsInfoTab = false;
    private ArrayList<GridFieldVO> Fields = null;
    private boolean initFields = false;
    public String deleteConfirmationLogic = null;

    public static GridTabVO create(GridWindowVO wVO, int TabNo, ResultSet rs, boolean isRO, boolean onlyCurrentRows) {
        if (CLogger.get().isLoggable(Level.CONFIG)) {
            CLogger.get().config("#" + TabNo);
        }
        GridTabVO vo = new GridTabVO(wVO.ctx, wVO.WindowNo);
        vo.AD_Window_ID = wVO.AD_Window_ID;
        vo.TabNo = TabNo;
        if (!GridTabVO.loadTabDetails(vo, rs)) {
            return null;
        }
        if (isRO) {
            if (CLogger.get().isLoggable(Level.FINE)) {
                CLogger.get().fine("Tab is ReadOnly");
            }
            vo.IsReadOnly = true;
        }
        vo.onlyCurrentRows = onlyCurrentRows;
        if (vo.IsSortTab) {
            vo.Fields = new ArrayList();
        }
        return vo;
    }

    private static boolean loadTabDetails(GridTabVO vo, ResultSet rs) {
        try {
            vo.AD_Tab_ID = rs.getInt("AD_Tab_ID");
            vo.AD_Tab_UU = rs.getString("AD_Tab_UU");
            MTab tab = MTab.get(vo.AD_Tab_ID);
            vo.Name = rs.getString("Name");
            if (tab != null && !Util.isEmpty(tab.getDeleteConfirmationLogic())) {
                vo.deleteConfirmationLogic = tab.getDeleteConfirmationLogic();
            }
            vo.IsTranslationTab = rs.getString("IsTranslationTab").equals("Y");
            vo.TableName = rs.getString("TableName");
            vo.IsAdvancedTab = rs.getString("IsAdvancedTab").equals("Y");
            vo.IsInfoTab = rs.getString("IsInfoTab").equals("Y");
            vo.DisplayLogic = rs.getString("DisplayLogic");
            vo.AccessLevel = rs.getString("AccessLevel");
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            vo.AD_Table_UU = rs.getString("AD_Table_UU");
            if (rs.getString("IsReadOnly").equals("Y")) {
                vo.IsReadOnly = true;
            }
            vo.ReadOnlyLogic = rs.getString("ReadOnlyLogic");
            if (rs.getString("IsInsertRecord").equals("N")) {
                vo.IsInsertRecord = false;
            }
            vo.Description = rs.getString("Description");
            if (vo.Description == null) {
                vo.Description = "";
            }
            vo.Help = rs.getString("Help");
            if (vo.Help == null) {
                vo.Help = "";
            }
            if (rs.getString("IsSingleRow").equals("Y")) {
                vo.IsSingleRow = true;
            }
            if (rs.getString("HasTree").equals("Y")) {
                vo.HasTree = true;
            }
            vo.TreeDisplayedOn = rs.getString("TreeDisplayedOn");
            vo.MaxQueryRecords = rs.getInt("MaxQueryRecords");
            vo.AD_Table_ID = rs.getInt("AD_Table_ID");
            vo.TableName = rs.getString("TableName");
            if (rs.getString("IsView").equals("Y")) {
                vo.IsView = true;
            }
            vo.AD_Column_ID = rs.getInt("AD_Column_ID");
            vo.Parent_Column_ID = rs.getInt("Parent_Column_ID");
            if (rs.getString("IsSecurityEnabled").equals("Y")) {
                vo.IsSecurityEnabled = true;
            }
            if (rs.getString("IsDeleteable").equals("Y")) {
                vo.IsDeleteable = true;
            }
            if (rs.getString("IsHighVolume").equals("Y")) {
                vo.IsHighVolume = true;
            }
            if (rs.getString("IsLookupOnlySelection").equals("Y")) {
                vo.IsLookupOnlySelection = true;
            }
            if (rs.getString("IsAllowAdvancedLookup").equals("Y")) {
                vo.IsAllowAdvancedLookup = true;
            }
            vo.CommitWarning = rs.getString("CommitWarning");
            if (vo.CommitWarning == null) {
                vo.CommitWarning = "";
            }
            vo.WhereClause = rs.getString("WhereClause");
            if (vo.WhereClause == null) {
                vo.WhereClause = "";
            }
            if (vo.WhereClause.indexOf("=null") > 0) {
                vo.WhereClause = vo.WhereClause.replaceAll("=null", " IS NULL ");
            }
            if (vo.WhereClause.trim().length() > 0) {
                vo.WhereClause = "(" + vo.WhereClause + ")";
            }
            vo.EntityType = rs.getString("EntityType");
            vo.OrderByClause = rs.getString("OrderByClause");
            if (vo.OrderByClause == null) {
                vo.OrderByClause = "";
            }
            vo.AD_Process_ID = rs.getInt("AD_Process_ID");
            if (rs.wasNull()) {
                vo.AD_Process_ID = 0;
            }
            vo.AD_Image_ID = rs.getInt("AD_Image_ID");
            if (rs.wasNull()) {
                vo.AD_Image_ID = 0;
            }
            vo.Included_Tab_ID = rs.getInt("Included_Tab_ID");
            if (rs.wasNull()) {
                vo.Included_Tab_ID = 0;
            }
            vo.TabLevel = rs.getInt("TabLevel");
            if (rs.wasNull()) {
                vo.TabLevel = 0;
            }
            vo.IsSortTab = rs.getString("IsSortTab").equals("Y");
            if (vo.IsSortTab) {
                vo.AD_ColumnSortOrder_ID = rs.getInt("AD_ColumnSortOrder_ID");
                vo.AD_ColumnSortYesNo_ID = rs.getInt("AD_ColumnSortYesNo_ID");
            }
            vo.AD_TabType = rs.getString("AD_TabType");
            try {
                int index = rs.findColumn("ReplicationType");
                vo.ReplicationType = rs.getString(index);
                if ("R".equals(vo.ReplicationType)) {
                    vo.IsReadOnly = true;
                }
            }
            catch (Exception exception) {}
        }
        catch (SQLException ex) {
            CLogger.get().log(Level.SEVERE, "", ex);
            return false;
        }
        return true;
    }

    public static boolean checkAccessAndShowPreference(GridTabVO vo, MRole role) {
        if (!GridTabVO.checkShowTranslation(vo)) {
            return false;
        }
        if (!GridTabVO.checkShowAdvanced(vo)) {
            return false;
        }
        if (!GridTabVO.checkShowAccounting(vo)) {
            return false;
        }
        if (!GridTabVO.checkAccessLevel(vo, role)) {
            return false;
        }
        return GridTabVO.checkTableAccess(vo, role);
    }

    private static boolean checkShowTranslation(GridTabVO vo) {
        boolean showTrl = "Y".equals(Env.getContext(vo.ctx, "#ShowTrl"));
        if (vo.IsTranslationTab) {
            if (!Env.isBaseTranslation(vo.TableName) && !Env.isMultiLingualDocument(vo.ctx)) {
                showTrl = false;
            }
            if (!showTrl) {
                if (CLogger.get().isLoggable(Level.CONFIG)) {
                    CLogger.get().config("TrlTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + "=" + vo.Name + ", Table=" + vo.TableName + ", BaseTrl=" + Env.isBaseTranslation(vo.TableName) + ", MultiLingual=" + Env.isMultiLingualDocument(vo.ctx));
                }
                return false;
            }
        }
        return true;
    }

    private static boolean checkShowAdvanced(GridTabVO vo) {
        boolean showAdvanced = "Y".equals(Env.getContext(vo.ctx, "#ShowAdvanced"));
        if (!showAdvanced && vo.IsAdvancedTab) {
            if (CLogger.get().isLoggable(Level.CONFIG)) {
                CLogger.get().config("AdvancedTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            }
            return false;
        }
        return true;
    }

    private static boolean checkShowAccounting(GridTabVO vo) {
        boolean showAcct = "Y".equals(Env.getContext(vo.ctx, "#ShowAcct"));
        if (!showAcct && vo.IsInfoTab) {
            if (CLogger.get().isLoggable(Level.FINE)) {
                CLogger.get().fine("AcctTab Not displayed - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            }
            return false;
        }
        return true;
    }

    private static boolean checkAccessLevel(GridTabVO vo, MRole role) {
        if (!role.canView(vo.ctx, vo.AccessLevel)) {
            if (CLogger.get().isLoggable(Level.FINE)) {
                CLogger.get().fine("No Role Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            }
            return false;
        }
        return true;
    }

    private static boolean checkTableAccess(GridTabVO vo, MRole role) {
        if (!role.isTableAccess(vo.AD_Table_ID, true)) {
            if (CLogger.get().isLoggable(Level.CONFIG)) {
                CLogger.get().config("No Table Access - AD_Tab_ID=" + vo.AD_Tab_ID + " " + vo.Name);
            }
            return false;
        }
        return true;
    }

    public static void updateContext(GridTabVO vo) {
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_ID", String.valueOf(vo.AD_Tab_ID));
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AD_Tab_UU", vo.AD_Tab_UU);
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_Name", vo.Name);
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_AccessLevel", vo.AccessLevel);
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsLookupOnlySelection", vo.IsLookupOnlySelection);
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsAllowAdvancedLookup", vo.IsAllowAdvancedLookup);
        Env.setContext(vo.ctx, vo.WindowNo, vo.TabNo, "_TabInfo_IsSortTab", vo.IsSortTab ? "Y" : "N");
    }

    public static void loadUserDefTab(GridTabVO vo) {
        MUserDefTab userDef = MUserDefTab.get(vo.ctx, vo.AD_Tab_ID, vo.AD_Window_ID);
        if (userDef != null) {
            if (!Util.isEmpty(userDef.getName())) {
                vo.Name = userDef.getName();
            }
            if (!Util.isEmpty(userDef.getDeleteConfirmationLogic())) {
                vo.deleteConfirmationLogic = userDef.getDeleteConfirmationLogic();
            }
            if (userDef.getDisplayLogic() != null) {
                vo.DisplayLogic = userDef.getDisplayLogic();
            }
            if (userDef.getIsReadOnly() != null) {
                vo.IsReadOnly = "Y".equals(userDef.getIsReadOnly());
            }
            if (userDef.getReadOnlyLogic() != null) {
                vo.ReadOnlyLogic = userDef.getReadOnlyLogic();
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
            if (userDef.getIsSingleRow() != null) {
                vo.IsSingleRow = "Y".equals(userDef.getIsSingleRow());
            }
            if (!Util.isEmpty(userDef.getIsHighVolume())) {
                vo.IsHighVolume = "Y".equals(userDef.getIsHighVolume());
            }
            if (userDef.getIsLookupOnlySelection() != null) {
                vo.IsLookupOnlySelection = "Y".equals(userDef.getIsLookupOnlySelection());
            }
            if (userDef.getIsAllowAdvancedLookup() != null) {
                vo.IsAllowAdvancedLookup = "Y".equals(userDef.getIsAllowAdvancedLookup());
            }
            if (userDef.getWhereClause() != null && !userDef.getWhereClause().trim().isEmpty()) {
                if (vo.WhereClause.trim().length() > 0) {
                    vo.WhereClause = String.valueOf(vo.WhereClause) + " AND ";
                }
                vo.WhereClause = String.valueOf(vo.WhereClause) + " (" + userDef.getWhereClause() + ")";
            }
            if (userDef.getOrderByClause() != null && !userDef.getOrderByClause().trim().isEmpty()) {
                vo.OrderByClause = userDef.getOrderByClause();
            }
            if (userDef.getAD_Process_ID() > 0) {
                vo.AD_Process_ID = userDef.getAD_Process_ID();
            }
        }
    }

    private static boolean createFields(GridTabVO mTabVO) {
        mTabVO.Fields = new ArrayList();
        String sql = GridFieldVO.getSQL(mTabVO.ctx);
        String cacheKey = sql + "|" + mTabVO.AD_Tab_ID;
        ArrayList<GridFieldVO> cache = s_gridFieldCache.get(cacheKey);
        if (cache != null) {
            for (GridFieldVO gvo : cache) {
                GridFieldVO clone = gvo.clone(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly);
                mTabVO.Fields.add(clone.afterCreate());
            }
        } else {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    cache = new ArrayList();
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, mTabVO.AD_Tab_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        GridFieldVO voF = GridFieldVO.createFromResultSet(mTabVO.ctx, mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly, rs);
                        if (voF == null) continue;
                        cache.add(voF.clone(Env.getCtx(), mTabVO.WindowNo, mTabVO.TabNo, mTabVO.AD_Window_ID, mTabVO.AD_Tab_ID, mTabVO.IsReadOnly));
                        mTabVO.Fields.add(voF.afterCreate());
                    }
                    if (!cache.isEmpty()) {
                        s_gridFieldCache.put(cacheKey, cache);
                    }
                }
                catch (Exception e) {
                    CLogger.get().log(Level.SEVERE, "", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        Collections.sort(mTabVO.Fields, new GridFieldVO.SeqNoComparator());
        mTabVO.initFields = true;
        return mTabVO.Fields.size() != 0;
    }

    protected static String getSQL(Properties ctx) {
        StringBuilder sql;
        MClient client = MClient.get(ctx);
        String ASPFilter = "";
        if (client.isUseASP()) {
            StringBuilder stringBuilder = new StringBuilder().append("     AND (   AD_Tab_ID IN ( ").append("              SELECT t.AD_Tab_ID ").append("                FROM ASP_Tab t, ASP_Window w, ASP_Level l, ASP_ClientLevel cl ").append("               WHERE w.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND cl.AD_Client_ID = ").append(client.getAD_Client_ID()).append("                 AND cl.ASP_Level_ID = l.ASP_Level_ID ").append("                 AND t.ASP_Window_ID = w.ASP_Window_ID ").append("                 AND t.IsActive = 'Y' ").append("                 AND w.IsActive = 'Y' ").append("                 AND l.IsActive = 'Y' ").append("                 AND cl.IsActive = 'Y' ").append("                 AND t.ASP_Status = 'S') ").append("        OR AD_Tab_ID IN ( ").append("              SELECT AD_Tab_ID ").append("                FROM ASP_ClientException ce ").append("               WHERE ce.AD_Client_ID = ").append(client.getAD_Client_ID()).append("                 AND ce.IsActive = 'Y' ").append("                 AND ce.AD_Tab_ID IS NOT NULL ").append("                 AND ce.AD_Field_ID IS NULL ").append("                 AND ce.ASP_Status = 'S') ").append("       ) ").append("   AND AD_Tab_ID NOT IN ( ").append("          SELECT AD_Tab_ID ").append("            FROM ASP_ClientException ce ").append("           WHERE ce.AD_Client_ID = ").append(client.getAD_Client_ID()).append("             AND ce.IsActive = 'Y' ").append("             AND ce.AD_Tab_ID IS NOT NULL ").append("             AND ce.AD_Field_ID IS NULL ").append("             AND ce.ASP_Status = 'H')");
            ASPFilter = stringBuilder.toString();
        }
        MRole role = MRole.getDefault(ctx, false);
        String advancedFilter = " AND IsAdvancedTab='N' ";
        if (!Env.isBaseLanguage(ctx, "AD_Window")) {
            sql = new StringBuilder("SELECT * FROM AD_Tab_vt WHERE AD_Window_ID=?");
            sql.append(" AND AD_Language='" + Env.getAD_Language(ctx) + "'").append(ASPFilter);
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY SeqNo");
        } else {
            sql = new StringBuilder("SELECT * FROM AD_Tab_v WHERE AD_Window_ID=?");
            sql.append(ASPFilter);
            if (!role.isAccessAdvanced()) {
                sql.append(advancedFilter);
            }
            sql.append(" ORDER BY SeqNo");
        }
        return sql.toString();
    }

    private GridTabVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public ArrayList<GridFieldVO> getFields() {
        if (!this.initFields) {
            GridTabVO.createFields(this);
        }
        return this.Fields;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        if (this.Fields != null) {
            int i = 0;
            while (i < this.Fields.size()) {
                GridFieldVO field = this.Fields.get(i);
                field.setCtx(newCtx);
                ++i;
            }
        }
    }

    @Override
    public String get_ValueAsString(String variableName) {
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(null, this.WindowNo, -1, false, false);
        return evaluatee.get_ValueAsString(this.ctx, variableName);
    }

    protected GridTabVO clone(Properties Ctx, int windowNo) {
        GridTabVO clone = new GridTabVO(Ctx, windowNo);
        clone.AD_Window_ID = this.AD_Window_ID;
        clone.TabNo = this.TabNo;
        clone.AD_Tab_ID = this.AD_Tab_ID;
        clone.AD_Tab_UU = this.AD_Tab_UU;
        clone.Name = this.Name;
        clone.Description = this.Description;
        clone.Help = this.Help;
        clone.IsSingleRow = this.IsSingleRow;
        clone.IsReadOnly = this.IsReadOnly;
        clone.IsInsertRecord = this.IsInsertRecord;
        clone.HasTree = this.HasTree;
        clone.TreeDisplayedOn = this.TreeDisplayedOn;
        clone.MaxQueryRecords = this.MaxQueryRecords;
        clone.AD_Table_ID = this.AD_Table_ID;
        clone.AD_Column_ID = this.AD_Column_ID;
        clone.Parent_Column_ID = this.Parent_Column_ID;
        clone.TableName = this.TableName;
        clone.IsView = this.IsView;
        clone.AccessLevel = this.AccessLevel;
        clone.IsSecurityEnabled = this.IsSecurityEnabled;
        clone.IsDeleteable = this.IsDeleteable;
        clone.IsHighVolume = this.IsHighVolume;
        clone.IsLookupOnlySelection = this.IsLookupOnlySelection;
        clone.IsAllowAdvancedLookup = this.IsAllowAdvancedLookup;
        clone.AD_Process_ID = this.AD_Process_ID;
        clone.CommitWarning = this.CommitWarning;
        clone.WhereClause = this.WhereClause;
        clone.OrderByClause = this.OrderByClause;
        clone.ReadOnlyLogic = this.ReadOnlyLogic;
        clone.DisplayLogic = this.DisplayLogic;
        clone.TabLevel = this.TabLevel;
        clone.AD_Image_ID = this.AD_Image_ID;
        clone.Included_Tab_ID = this.Included_Tab_ID;
        clone.ReplicationType = this.ReplicationType;
        clone.deleteConfirmationLogic = this.deleteConfirmationLogic;
        clone.EntityType = this.EntityType;
        clone.IsSortTab = this.IsSortTab;
        clone.AD_ColumnSortOrder_ID = this.AD_ColumnSortOrder_ID;
        clone.AD_ColumnSortYesNo_ID = this.AD_ColumnSortYesNo_ID;
        clone.IsAdvancedTab = this.IsAdvancedTab;
        clone.IsInfoTab = this.IsInfoTab;
        clone.IsTranslationTab = this.IsTranslationTab;
        clone.onlyCurrentRows = true;
        clone.onlyCurrentDays = 0;
        clone.AD_TabType = this.AD_TabType;
        clone.Fields = null;
        return clone;
    }

    public boolean isInitFields() {
        return this.initFields;
    }
}

