/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.compiere.db.CConnection;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.dbPort.Convert;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;

public interface AdempiereDatabase {
    public static final int LOCK_TIME_OUT = 60;
    public static final int MAX_OBJECT_NAME_LENGTH = 63;
    public static final int CMD_CREATE_USER = 0;
    public static final int CMD_CREATE_DATABASE = 1;
    public static final int CMD_DROP_DATABASE = 2;

    public String getName();

    public String getDescription();

    public Driver getDriver() throws SQLException;

    public int getStandardPort();

    public String getConnectionURL(CConnection var1);

    public String getConnectionURL(String var1, int var2, String var3, String var4);

    public String getConnectionURL(String var1, String var2);

    public String getCatalog();

    public String getSchema();

    public boolean supportsBLOB();

    public String toString();

    public String convertStatement(String var1);

    public boolean isSupported(String var1);

    public String getConstraintType(Connection var1, String var2, String var3);

    public String getAlternativeSQL(int var1, String var2, String var3);

    public String getSystemUser();

    public String getSystemDatabase(String var1);

    public String TO_DATE(Timestamp var1, boolean var2);

    public String TO_CHAR(String var1, int var2, String var3);

    public String TO_NUMBER(BigDecimal var1, int var2);

    public String TO_JSON(String var1);

    public String getJSONCast();

    public int getNextID(String var1, String var2);

    public int getNextID(String var1);

    public boolean createSequence(String var1, int var2, int var3, int var4, int var5, String var6);

    public String[] getCommands(int var1);

    public Connection getCachedConnection(CConnection var1, boolean var2, int var3) throws Exception;

    public Connection getDriverConnection(CConnection var1) throws SQLException;

    public Connection getDriverConnection(String var1, String var2, String var3) throws SQLException;

    public DataSource getDataSource(CConnection var1);

    public String getStatus();

    public void close();

    public Convert getConvert();

    public boolean isQueryTimeoutSupported();

    public boolean isPagingSupported();

    public String addPagingSQL(String var1, int var2, int var3);

    public boolean forUpdate(PO var1, int var2);

    public String getNameOfUniqueConstraintError(Exception var1);

    public String getForeignKeyConstraint(Exception var1);

    public String subsetClauseForCSV(String var1, String var2);

    public String intersectClauseForCSV(String var1, String var2);

    public String intersectClauseForCSV(String var1, String var2, boolean var3);

    default public String quoteColumnName(String columnName) {
        return columnName;
    }

    default public boolean isNativeMode() {
        return true;
    }

    public String getNumericDataType();

    public String getCharacterDataType();

    public String getVarcharDataType();

    default public String getVarcharLengthSuffix() {
        return "";
    }

    public String getBlobDataType();

    public String getClobDataType();

    public String getJsonDataType();

    public String getTimestampDataType();

    public String getTimestampWithTimezoneDataType();

    default public String getSQLCreate(MTable table2) {
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(table2.getTableName()).append(" (");
        StringBuilder constraints = new StringBuilder();
        MColumn[] columns = table2.getColumns(true);
        boolean columnAdded = false;
        int i2 = 0;
        while (i2 < columns.length) {
            MColumn column = columns[i2];
            String colSQL = column.getSQLDDL();
            if (colSQL != null) {
                if (columnAdded) {
                    sb.append(", ");
                } else {
                    columnAdded = true;
                }
                sb.append(column.getSQLDDL());
                String constraint = column.getConstraint(table2.getTableName());
                if (constraint != null && constraint.length() > 0) {
                    constraints.append(", ").append(constraint);
                }
            }
            ++i2;
        }
        sb.append((CharSequence)constraints).append(")");
        return sb.toString();
    }

    public String TO_Blob(byte[] var1);

    public String getSQLDDL(MColumn var1);

    public String getSQLAdd(MTable var1, MColumn var2);

    public String getSQLModify(MTable var1, MColumn var2, boolean var3);

    default public boolean isQueryTimeout(SQLException ex) {
        return ex instanceof SQLTimeoutException;
    }

    default public ITablePartitionService getTablePartitionService() {
        return null;
    }
}

