/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public abstract class AbstractModelFactory
implements IModelFactory {
    private static final CLogger s_log = CLogger.getCLogger(AbstractModelFactory.class);

    @Override
    public PO getPO(String tableName, int Record_ID, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, Record_ID, trxName);
    }

    public static PO getPO(Class<?> clazz, String tableName, int Record_ID, String trxName) {
        if (clazz == null) {
            return null;
        }
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        if (table2 != null && table2.isUUIDKeyTable()) {
            if (Record_ID == 0) {
                return AbstractModelFactory.getPO(clazz, tableName, "", trxName);
            }
            return null;
        }
        boolean errorLogged = false;
        try {
            Exception ce = null;
            Object[] arguments = null;
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class);
                arguments = new Object[]{Env.getCtx(), Record_ID, trxName};
            }
            catch (Exception e) {
                ce = e;
            }
            if (constructor == null) {
                try {
                    constructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class, String[].class);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Env.getCtx();
                    objectArray[1] = Record_ID;
                    objectArray[2] = trxName;
                    arguments = objectArray;
                }
                catch (Exception e) {
                    ce = e;
                }
            }
            if (constructor == null && ce != null) {
                String msg = ce.getMessage();
                if (msg == null) {
                    msg = ce.toString();
                }
                s_log.warning("No transaction Constructor for " + String.valueOf(clazz) + " (" + msg + ")");
            }
            PO po = constructor != null ? (PO)constructor.newInstance(arguments) : null;
            return po;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                s_log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + String.valueOf(clazz), t);
                errorLogged = true;
                if (t instanceof Exception) {
                    s_log.saveError("Error", (Exception)e.getCause());
                } else {
                    s_log.saveError("Error", "Table=" + tableName + ",Class=" + String.valueOf(clazz));
                }
            } else {
                s_log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + String.valueOf(clazz), e);
                errorLogged = true;
                s_log.saveError("Error", "Table=" + tableName + ",Class=" + String.valueOf(clazz));
            }
            if (!errorLogged) {
                s_log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName + ", Record_ID=" + Record_ID);
            }
            return null;
        }
    }

    @Override
    public PO getPO(String tableName, String Record_UU, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, Record_UU, trxName);
    }

    public static PO getPO(Class<?> clazz, String tableName, String Record_UU, String trxName) {
        if (clazz == null) {
            return null;
        }
        boolean errorLogged = false;
        try {
            Exception ce = null;
            Object[] arguments = null;
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class, String.class, String.class);
                arguments = new Object[]{Env.getCtx(), Record_UU, trxName};
            }
            catch (Exception e) {
                ce = e;
            }
            if (constructor == null) {
                try {
                    constructor = clazz.getDeclaredConstructor(Properties.class, String.class, String.class, String[].class);
                    Object[] objectArray = new Object[4];
                    objectArray[0] = Env.getCtx();
                    objectArray[1] = Record_UU;
                    objectArray[2] = trxName;
                    arguments = objectArray;
                }
                catch (Exception e) {
                    ce = e;
                }
            }
            if (constructor == null && ce != null) {
                String msg = ce.getMessage();
                if (msg == null) {
                    msg = ce.toString();
                }
                s_log.warning("No transaction Constructor for " + String.valueOf(clazz) + " (" + msg + ")");
            }
            PO po = constructor != null ? (PO)constructor.newInstance(arguments) : null;
            return po;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                s_log.log(Level.SEVERE, "(uuid) - Table=" + tableName + ",Class=" + String.valueOf(clazz), t);
                errorLogged = true;
                if (t instanceof Exception) {
                    s_log.saveError("Error", (Exception)e.getCause());
                } else {
                    s_log.saveError("Error", "Table=" + tableName + ",Class=" + String.valueOf(clazz));
                }
            } else {
                s_log.log(Level.SEVERE, "(uuid) - Table=" + tableName + ",Class=" + String.valueOf(clazz), e);
                errorLogged = true;
                s_log.saveError("Error", "Table=" + tableName + ",Class=" + String.valueOf(clazz));
            }
            if (!errorLogged) {
                s_log.log(Level.SEVERE, "(uuid) - Not found - Table=" + tableName + ", Record_UU=" + Record_UU);
            }
            return null;
        }
    }

    @Override
    public PO getPO(String tableName, ResultSet rs, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, rs, trxName);
    }

    public static PO getPO(Class<?> clazz, String tableName, ResultSet rs, String trxName) {
        if (clazz == null) {
            return null;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
            PO po = (PO)constructor.newInstance(Env.getCtx(), rs, trxName);
            return po;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "(rs) - Table=" + tableName + ",Class=" + String.valueOf(clazz), e);
            errorLogged = true;
            s_log.saveError("Error", "Table=" + tableName + ",Class=" + String.valueOf(clazz));
            if (!errorLogged) {
                s_log.log(Level.SEVERE, "(rs) - Not found - Table=" + tableName);
            }
            return null;
        }
    }
}

