/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink.internal;

import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.LinkSpanImpl;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.Scanners;

public class EmailScanner
implements Scanner {
    private final boolean domainMustHaveDot;

    public EmailScanner(boolean domainMustHaveDot) {
        this.domainMustHaveDot = domainMustHaveDot;
    }

    @Override
    public LinkSpan scan(CharSequence input, int triggerIndex, int rewindIndex) {
        int beforeAt = triggerIndex - 1;
        int first = this.findFirst(input, beforeAt, rewindIndex);
        if (first == -1) {
            return null;
        }
        int afterAt = triggerIndex + 1;
        int last = this.findLast(input, afterAt);
        if (last == -1) {
            return null;
        }
        return new LinkSpanImpl(LinkType.EMAIL, first, last + 1);
    }

    private int findFirst(CharSequence input, int beginIndex, int rewindIndex) {
        int first = -1;
        boolean atomBoundary = true;
        for (int i = beginIndex; i >= rewindIndex; --i) {
            char c = input.charAt(i);
            if (this.localAtomAllowed(c)) {
                first = i;
                atomBoundary = false;
                continue;
            }
            if (c != '.' || atomBoundary) break;
            atomBoundary = true;
        }
        return first;
    }

    private int findLast(CharSequence input, int beginIndex) {
        boolean firstInSubDomain = true;
        boolean canEndSubDomain = false;
        int firstDot = -1;
        int last = -1;
        for (int i = beginIndex; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (firstInSubDomain) {
                if (!this.subDomainAllowed(c)) break;
                last = i;
                firstInSubDomain = false;
                canEndSubDomain = true;
                continue;
            }
            if (c == '.') {
                if (!canEndSubDomain) break;
                firstInSubDomain = true;
                if (firstDot != -1) continue;
                firstDot = i;
                continue;
            }
            if (c == '-') {
                canEndSubDomain = false;
                continue;
            }
            if (!this.subDomainAllowed(c)) break;
            last = i;
            canEndSubDomain = true;
        }
        if (this.domainMustHaveDot && (firstDot == -1 || firstDot > last)) {
            return -1;
        }
        return last;
    }

    private boolean localAtomAllowed(char c) {
        if (Scanners.isAlnum(c) || Scanners.isNonAscii(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '?': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean subDomainAllowed(char c) {
        return Scanners.isAlnum(c) || Scanners.isNonAscii(c);
    }
}

