DROP VIEW c_dunning_header_v;

CREATE OR REPLACE VIEW c_dunning_header_v AS 
SELECT dr.ad_client_id,
    dr.ad_org_id,
    dr.isactive,
    dr.created,
    dr.createdby,
    dr.updated,
    dr.updatedby,
    'en_US'::character varying       AS ad_language,
    dr.c_dunningrun_id,
    dre.c_dunningrunentry_id,
    dr.dunningdate,
    dl.printname,
    dl.note                          AS documentnote,
    dre.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    dre.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    bpg.greeting                     AS bpgreeting,
    bp.name,
    bp.name2,
    bpcg.greeting                    AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    l.postal || l.postal_add         AS postal,
    dre.amt,
    dre.qty,
    dre.note,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    dr.c_dunning_id,
    dr.c_dunninglevel_id             AS c_dunningrun_c_dunninglevel_id,
    dr.description                   AS c_dunningrun_description,
    dr.processed,
    dr.processing,
    dr.sendit,
    dre.ad_org_id                    AS c_dunningrunentry_ad_org_id,
    dre.ad_user_id,
    dre.c_bpartner_location_id,
    dre.c_currency_id,
    dre.c_dunninglevel_id            AS c_dunrunentry_c_dunlevel_id,
    dre.created                      AS c_dunningrunentry_created,
    dre.createdby                    AS c_dunningrunentry_createdby,
    dre.isactive                     AS c_dunningrunentry_isactive,
    dre.processed                    AS c_dunningrunentry_processed,
    dre.updated                      AS c_dunningrunentry_updated,
    dre.updatedby                    AS c_dunningrunentry_updatedby,
    dl.ad_org_id                     AS c_dunninglevel_ad_org_id,
    dl.c_dunning_id                  AS c_dunninglevel_c_dunning_id,
    dl.chargefee,
    dl.chargeinterest,
    dl.c_paymentterm_id,
    dl.daysafterdue,
    dl.daysbetweendunning,
    dl.description                   AS c_dunninglevel_description,
    dl.dunning_printformat_id,
    dl.feeamt,
    dl.interestpercent,
    dl.invoicecollectiontype,
    dl.isactive                      AS c_dunninglevel_isactive,
    dl.issetcreditstop,
    dl.issetpaymentterm,
    dl.isshowalldue,
    dl.isshownotdue,
    dl.isstatement,
    dl.name                          AS c_dunninglevel_name,
    bp.acqusitioncost                AS c_bpartner_acqusitioncost,
    bp.actuallifetimevalue           AS c_bpartner_actuallifetimevalue,
    bp.ad_language                   AS c_bpartner_ad_language,
    bp.ad_orgbp_id                   AS c_bpartner_ad_orgbp_id,
    bp.ad_org_id                     AS c_bpartner_ad_org_id,
    bp.bpartner_parent_id            AS c_bpartner_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bpartner_c_bp_group_id,
    bp.c_greeting_id                 AS c_bpartner_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bpartner_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bpartner_c_paymentterm_id,
    bp.created                       AS c_bpartner_created,
    bp.createdby                     AS c_bpartner_createdby,
    bp.c_taxgroup_id                 AS c_bpartner_c_taxgroup_id,
    bp.deliveryrule                  AS c_bpartner_deliveryrule,
    bp.deliveryviarule               AS c_bpartner_deliveryviarule,
    bp.description                   AS c_bpartner_description,
    bp.dunninggrace                  AS c_bpartner_dunninggrace,
    bp.firstsale                     AS c_bpartner_firstsale,
    bp.flatdiscount                  AS c_bpartner_flatdiscount,
    bp.freightcostrule               AS c_bpartner_freightcostrule,
    bp.invoicerule                   AS c_bpartner_invoicerule,
    bp.isactive                      AS c_bpartner_isactive,
    bp.iscustomer                    AS c_bpartner_iscustomer,
    bp.isdiscountprinted             AS c_bpartner_isdiscountprinted,
    bp.isemployee                    AS c_bpartner_isemployee,
    bp.ismanufacturer                AS c_bpartner_ismanufacturer,
    bp.isonetime                     AS c_bpartner_isonetime,
    bp.ispotaxexempt                 AS c_bpartner_ispotaxexempt,
    bp.isprospect                    AS c_bpartner_isprospect,
    bp.issalesrep                    AS c_bpartner_issalesrep,
    bp.issummary                     AS c_bpartner_issummary,
    bp.istaxexempt                   AS c_bpartner_istaxexempt,
    bp.isvendor                      AS c_bpartner_isvendor,
    bp.logo_id                       AS c_bpartner_logo_id,
    bp.m_discountschema_id           AS c_bpartner_m_discountschema_id,
    bp.m_pricelist_id                AS c_bpartner_m_pricelist_id,
    bp.naics                         AS c_bpartner_naics,
    bp.numberemployees               AS c_bpartner_numberemployees,
    bp.paymentrule                   AS c_bpartner_paymentrule,
    bp.paymentrulepo                 AS c_bpartner_paymentrulepo,
    bp.po_discountschema_id          AS c_bpartnerpo_discountschema_id,
    bp.po_paymentterm_id             AS c_bpartner_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bpartner_po_pricelist_id,
    bp.poreference                   AS c_bpartner_poreference,
    bp.potentiallifetimevalue        AS c_bpartner_potentiallifetimev,
    bp.rating                        AS c_bpartner_rating,
    bp.salesrep_id                   AS c_bpartner_salesrep_id,
    bp.salesvolume                   AS c_bpartner_salesvolume,
    bp.sendemail                     AS c_bpartner_sendemail,
    bp.shareofcustomer               AS c_bpartner_shareofcustomer,
    bp.shelflifeminpct               AS c_bpartner_shelflifeminpct,
    bp.so_creditlimit                AS c_bpartner_so_creditlimit,
    bp.socreditstatus                AS c_bpartner_socreditstatus,
    bp.so_creditused                 AS c_bpartner_so_creditused,
    bp.so_description                AS c_bpartner_so_description,
    bp.totalopenbalance              AS c_bpartner_totalopenbalance,
    bp.updated                       AS c_bpartner_updated,
    bp.updatedby                     AS c_bpartner_updatedby,
    bp.url                           AS c_bpartner_url,
    bpg.ad_org_id                    AS c_bpartner_greeting_ad_org_id,
    bpg.isactive                     AS c_bpartner_greeting_isactive,
    bpg.isfirstnameonly              AS c_bpartner_greeting_isfirstna,
    bpg.name                         AS c_bpartner_greeting_name,
    bpl.ad_org_id                    AS c_bpartner_location_ad_org_id,
    bpl.created                      AS c_bpartner_location_created,
    bpl.createdby                    AS c_bpartner_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bpartner_location_fax,
    bpl.isactive                     AS c_bpartner_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bpartner_location_name,
    bpl.phone                        AS c_bpartner_location_phone,
    bpl.phone2                       AS c_bpartner_location_phone2,
    bpl.updated                      AS c_bpartner_location_updated,
    bpl.updatedby                    AS c_bpartner_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.postal_add,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.name                         AS ad_user_name,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcg.ad_org_id                   AS c_user_greeting_ad_org_id,
    bpcg.isactive                    AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfirstnameon,
    bpcg.name                        AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bpartner_acqusitionc,
    ubp.actuallifetimevalue          AS salesrep_bpartner_actuallifet,
    ubp.ad_language                  AS salesrep_bpartner_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bpartner_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bpartner_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bpartner_bp_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_invoiceschedule_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bpartner_created,
    ubp.createdby                    AS salesrep_bpartner_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bpartner_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bpartner_deliveryvia,
    ubp.description                  AS salesrep_bpartner_description,
    ubp.dunninggrace                 AS salesrep_bpartner_dunninggrace,
    ubp.firstsale                    AS salesrep_bpartner_firstsale,
    ubp.flatdiscount                 AS salesrep_bpartner_flatdiscount,
    ubp.freightcostrule              AS salesrep_bpartner_freightcost,
    ubp.invoicerule                  AS salesrep_bpartner_invoicerule,
    ubp.isactive                     AS salesrep_bpartner_isactive,
    ubp.iscustomer                   AS salesrep_bpartner_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bpartner_isdiscountp,
    ubp.isemployee                   AS salesrep_bpartner_isemployee,
    ubp.ismanufacturer               AS salesrep_bpartner_ismanufactu,
    ubp.isonetime                    AS salesrep_bpartner_isonetime,
    ubp.ispotaxexempt                AS salesrep_bpartner_ispotaxexem,
    ubp.isprospect                   AS salesrep_bpartner_isprospect,
    ubp.issalesrep                   AS salesrep_bpartner_issalesrep,
    ubp.issummary                    AS salesrep_bpartner_issummary,
    ubp.istaxexempt                  AS salesrep_bpartner_istaxexempt,
    ubp.isvendor                     AS salesrep_bpartner_isvendor,
    ubp.logo_id                      AS salesrep_bpartner_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_mdiscountschema_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bpartner_naics,
    ubp.numberemployees              AS salesrep_bpartner_numberemplo,
    ubp.paymentrule                  AS salesrep_bpartner_paymentrule,
    ubp.paymentrulepo                AS salesrep_bpartner_paymentrupo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountscm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bpartner_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bpartner_potentialli,
    ubp.rating                       AS salesrep_bpartner_rating,
    ubp.salesrep_id                  AS salesrep_bpartner_salesrep_id,
    ubp.salesvolume                  AS salesrep_bpartner_salesvolume,
    ubp.sendemail                    AS salesrep_bpartner_sendemail,
    ubp.shareofcustomer              AS salesrep_bpartner_shareofcust,
    ubp.shelflifeminpct              AS salesrep_bpartner_shelflifemi,
    ubp.so_creditlimit               AS salesrep_bpartner_so_creditli,
    ubp.socreditstatus               AS salesrep_bpartner_socreditsta,
    ubp.so_creditused                AS salesrep_bpartner_so_creditus,
    ubp.so_description               AS salesrep_bpartner_so_descript,
    ubp.totalopenbalance             AS salesrep_bpartner_totalopenba,
    ubp.updated                      AS salesrep_bpartner_updated,
    ubp.updatedby                    AS salesrep_bpartner_updatedby,
    ubp.url                          AS salesrep_bpartner_url 
FROM c_dunningrun dr 
        JOIN c_dunningrunentry dre 
        ON dr.c_dunningrun_id = dre.c_dunningrun_id 
        JOIN c_dunninglevel dl 
        ON dre.c_dunninglevel_id = dl.c_dunninglevel_id 
        JOIN c_bpartner bp 
        ON dre.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        JOIN c_bpartner_location bpl 
        ON dre.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON dre.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        JOIN ad_orginfo oi 
        ON dr.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON dr.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON dre.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id
;

DROP VIEW c_dunning_header_vt;

CREATE OR REPLACE VIEW c_dunning_header_vt AS 
SELECT dr.ad_client_id,
    dr.ad_org_id,
    dr.isactive,
    dr.created,
    dr.createdby,
    dr.updated,
    dr.updatedby,
    dlt.ad_language,
    dr.c_dunningrun_id,
    dre.c_dunningrunentry_id,
    dr.dunningdate,
    dlt.printname,
    dlt.note                         AS documentnote,
    dre.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    dre.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    l.postal || l.postal_add         AS postal,
    dre.amt,
    dre.qty,
    dre.note,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    dr.c_dunning_id,
    dr.c_dunninglevel_id             AS c_dunningrun_c_dunninglevel_id,
    dr.description                   AS c_dunningrun_description,
    dr.processed,
    dr.processing,
    dr.sendit,
    dre.ad_org_id                    AS c_dunningrunentry_ad_org_id,
    dre.ad_user_id,
    dre.c_bpartner_location_id,
    dre.c_currency_id,
    dre.c_dunninglevel_id            AS c_dunrunentry_c_dunlevel_id,
    dre.created                      AS c_dunningrunentry_created,
    dre.createdby                    AS c_dunningrunentry_createdby,
    dre.isactive                     AS c_dunningrunentry_isactive,
    dre.processed                    AS c_dunningrunentry_processed,
    dre.updated                      AS c_dunningrunentry_updated,
    dre.updatedby                    AS c_dunningrunentry_updatedby,
    dl.ad_org_id                     AS c_dunninglevel_ad_org_id,
    dl.c_dunning_id                  AS c_dunninglevel_c_dunning_id,
    dl.chargefee,
    dl.chargeinterest,
    dl.c_paymentterm_id,
    dl.daysafterdue,
    dl.daysbetweendunning,
    dl.description                   AS c_dunninglevel_description,
    dl.dunning_printformat_id,
    dl.feeamt,
    dl.interestpercent,
    dl.invoicecollectiontype,
    dl.isactive                      AS c_dunninglevel_isactive,
    dl.issetcreditstop,
    dl.issetpaymentterm,
    dl.isshowalldue,
    dl.isshownotdue,
    dl.isstatement,
    dl.name                          AS c_dunninglevel_name,
    bp.acqusitioncost                AS c_bpartner_acqusitioncost,
    bp.actuallifetimevalue           AS c_bpartner_actuallifetimevalue,
    bp.ad_language                   AS c_bpartner_ad_language,
    bp.ad_orgbp_id                   AS c_bpartner_ad_orgbp_id,
    bp.ad_org_id                     AS c_bpartner_ad_org_id,
    bp.bpartner_parent_id            AS c_bpartner_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bpartner_c_bp_group_id,
    bp.c_greeting_id                 AS c_bpartner_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bpartner_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bpartner_c_paymentterm_id,
    bp.created                       AS c_bpartner_created,
    bp.createdby                     AS c_bpartner_createdby,
    bp.c_taxgroup_id                 AS c_bpartner_c_taxgroup_id,
    bp.deliveryrule                  AS c_bpartner_deliveryrule,
    bp.deliveryviarule               AS c_bpartner_deliveryviarule,
    bp.description                   AS c_bpartner_description,
    bp.dunninggrace                  AS c_bpartner_dunninggrace,
    bp.firstsale                     AS c_bpartner_firstsale,
    bp.flatdiscount                  AS c_bpartner_flatdiscount,
    bp.freightcostrule               AS c_bpartner_freightcostrule,
    bp.invoicerule                   AS c_bpartner_invoicerule,
    bp.isactive                      AS c_bpartner_isactive,
    bp.iscustomer                    AS c_bpartner_iscustomer,
    bp.isdiscountprinted             AS c_bpartner_isdiscountprinted,
    bp.isemployee                    AS c_bpartner_isemployee,
    bp.ismanufacturer                AS c_bpartner_ismanufacturer,
    bp.isonetime                     AS c_bpartner_isonetime,
    bp.ispotaxexempt                 AS c_bpartner_ispotaxexempt,
    bp.isprospect                    AS c_bpartner_isprospect,
    bp.issalesrep                    AS c_bpartner_issalesrep,
    bp.issummary                     AS c_bpartner_issummary,
    bp.istaxexempt                   AS c_bpartner_istaxexempt,
    bp.isvendor                      AS c_bpartner_isvendor,
    bp.logo_id                       AS c_bpartner_logo_id,
    bp.m_discountschema_id           AS c_bpartner_m_discountschema_id,
    bp.m_pricelist_id                AS c_bpartner_m_pricelist_id,
    bp.naics                         AS c_bpartner_naics,
    bp.numberemployees               AS c_bpartner_numberemployees,
    bp.paymentrule                   AS c_bpartner_paymentrule,
    bp.paymentrulepo                 AS c_bpartner_paymentrulepo,
    bp.po_discountschema_id          AS c_bpartnerpo_discountschema_id,
    bp.po_paymentterm_id             AS c_bpartner_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bpartner_po_pricelist_id,
    bp.poreference                   AS c_bpartner_poreference,
    bp.potentiallifetimevalue        AS c_bpartner_potentiallifetimev,
    bp.rating                        AS c_bpartner_rating,
    bp.salesrep_id                   AS c_bpartner_salesrep_id,
    bp.salesvolume                   AS c_bpartner_salesvolume,
    bp.sendemail                     AS c_bpartner_sendemail,
    bp.shareofcustomer               AS c_bpartner_shareofcustomer,
    bp.shelflifeminpct               AS c_bpartner_shelflifeminpct,
    bp.so_creditlimit                AS c_bpartner_so_creditlimit,
    bp.socreditstatus                AS c_bpartner_socreditstatus,
    bp.so_creditused                 AS c_bpartner_so_creditused,
    bp.so_description                AS c_bpartner_so_description,
    bp.totalopenbalance              AS c_bpartner_totalopenbalance,
    bp.updated                       AS c_bpartner_updated,
    bp.updatedby                     AS c_bpartner_updatedby,
    bp.url                           AS c_bpartner_url,
    bpgt.ad_org_id                   AS c_bpartner_greeting_ad_org_id,
    bpgt.isactive                    AS c_bpartner_greeting_isactive,
    bpg.isfirstnameonly              AS c_bpartner_greeting_isfirstna,
    bpgt.name                        AS c_bpartner_greeting_name,
    bpl.ad_org_id                    AS c_bpartner_location_ad_org_id,
    bpl.created                      AS c_bpartner_location_created,
    bpl.createdby                    AS c_bpartner_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bpartner_location_fax,
    bpl.isactive                     AS c_bpartner_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bpartner_location_name,
    bpl.phone                        AS c_bpartner_location_phone,
    bpl.phone2                       AS c_bpartner_location_phone2,
    bpl.updated                      AS c_bpartner_location_updated,
    bpl.updatedby                    AS c_bpartner_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.postal_add,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.name                         AS ad_user_name,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.ad_org_id                  AS c_user_greeting_ad_org_id,
    bpcgt.isactive                   AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfirstnameon,
    bpcgt.name                       AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bpartner_acqusitionc,
    ubp.actuallifetimevalue          AS salesrep_bpartner_actuallifet,
    ubp.ad_language                  AS salesrep_bpartner_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bpartner_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bpartner_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bpartner_bp_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_invoiceschedule_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bpartner_created,
    ubp.createdby                    AS salesrep_bpartner_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bpartner_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bpartner_deliveryvia,
    ubp.description                  AS salesrep_bpartner_description,
    ubp.dunninggrace                 AS salesrep_bpartner_dunninggrace,
    ubp.firstsale                    AS salesrep_bpartner_firstsale,
    ubp.flatdiscount                 AS salesrep_bpartner_flatdiscount,
    ubp.freightcostrule              AS salesrep_bpartner_freightcost,
    ubp.invoicerule                  AS salesrep_bpartner_invoicerule,
    ubp.isactive                     AS salesrep_bpartner_isactive,
    ubp.iscustomer                   AS salesrep_bpartner_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bpartner_isdiscountp,
    ubp.isemployee                   AS salesrep_bpartner_isemployee,
    ubp.ismanufacturer               AS salesrep_bpartner_ismanufactu,
    ubp.isonetime                    AS salesrep_bpartner_isonetime,
    ubp.ispotaxexempt                AS salesrep_bpartner_ispotaxexem,
    ubp.isprospect                   AS salesrep_bpartner_isprospect,
    ubp.issalesrep                   AS salesrep_bpartner_issalesrep,
    ubp.issummary                    AS salesrep_bpartner_issummary,
    ubp.istaxexempt                  AS salesrep_bpartner_istaxexempt,
    ubp.isvendor                     AS salesrep_bpartner_isvendor,
    ubp.logo_id                      AS salesrep_bpartner_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_mdiscountschema_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bpartner_naics,
    ubp.numberemployees              AS salesrep_bpartner_numberemplo,
    ubp.paymentrule                  AS salesrep_bpartner_paymentrule,
    ubp.paymentrulepo                AS salesrep_bpartner_paymentrupo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountscm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bpartner_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bpartner_potentialli,
    ubp.rating                       AS salesrep_bpartner_rating,
    ubp.salesrep_id                  AS salesrep_bpartner_salesrep_id,
    ubp.salesvolume                  AS salesrep_bpartner_salesvolume,
    ubp.sendemail                    AS salesrep_bpartner_sendemail,
    ubp.shareofcustomer              AS salesrep_bpartner_shareofcust,
    ubp.shelflifeminpct              AS salesrep_bpartner_shelflifemi,
    ubp.so_creditlimit               AS salesrep_bpartner_so_creditli,
    ubp.socreditstatus               AS salesrep_bpartner_socreditsta,
    ubp.so_creditused                AS salesrep_bpartner_so_creditus,
    ubp.so_description               AS salesrep_bpartner_so_descript,
    ubp.totalopenbalance             AS salesrep_bpartner_totalopenba,
    ubp.updated                      AS salesrep_bpartner_updated,
    ubp.updatedby                    AS salesrep_bpartner_updatedby,
    ubp.url                          AS salesrep_bpartner_url 
FROM c_dunningrun dr 
        JOIN c_dunningrunentry dre 
        ON dr.c_dunningrun_id = dre.c_dunningrun_id 
        JOIN c_dunninglevel dl 
        ON dre.c_dunninglevel_id = dl.c_dunninglevel_id 
        JOIN c_dunninglevel_trl dlt 
        ON dl.c_dunninglevel_id = dlt.c_dunninglevel_id 
        JOIN c_bpartner bp 
        ON dre.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id AND dlt.ad_language = bpgt.ad_language 
        JOIN c_bpartner_location bpl 
        ON dre.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON dre.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id AND dlt.ad_language = bpcgt.ad_language 
        JOIN ad_orginfo oi 
        ON dr.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON dr.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON dre.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id
;

DROP VIEW c_dunning_line_v;

CREATE OR REPLACE VIEW c_dunning_line_v AS 
SELECT drl.ad_client_id,
    drl.ad_org_id,
    drl.isactive,
    drl.created,
    drl.createdby,
    drl.updated,
    drl.updatedby,
    'en_US'::character varying                             AS ad_language,
    drl.c_dunningrunline_id,
    drl.c_dunningrunentry_id,
    drl.amt,
    drl.convertedamt,
    drl.daysdue,
    drl.timesdunned,
    drl.interestamt,
    drl.feeamt,
    drl.totalamt,
    drl.c_invoice_id,
    COALESCE(i.issotrx, p.isreceipt)                       AS issotrx,
    COALESCE(i.documentno, p.documentno)                   AS documentno,
    COALESCE(i.docstatus, p.docstatus)                     AS docstatus,
    COALESCE(i.dateinvoiced, p.datetrx)                    AS datetrx,
    COALESCE(i.c_doctype_id, p.c_doctype_id)               AS c_doctype_id,
    COALESCE(dt.printname, dtp.printname)                  AS documenttype,
    COALESCE(i.description, p.description)                 AS description,
    COALESCE(i.c_currency_id, p.c_currency_id)             AS c_currency_id,
    COALESCE(i.c_campaign_id, p.c_campaign_id)             AS c_campaign_id,
    COALESCE(i.c_project_id, p.c_project_id)               AS c_project_id,
    COALESCE(i.c_activity_id, p.c_activity_id)             AS c_activity_id,
    COALESCE(i.user1_id, p.user1_id)                       AS user1_id,
    COALESCE(i.user2_id, p.user2_id)                       AS user2_id,
    COALESCE(i.dateacct, p.dateacct)                       AS dateacct,
    COALESCE(i.c_conversiontype_id, p.c_conversiontype_id) AS c_conversiontype_id,
    COALESCE(i.ad_orgtrx_id, p.ad_orgtrx_id)               AS ad_orgtrx_id,
    i.poreference,
    i.dateordered,
    i.dateinvoiced,
    i.isindispute,
    pt.name                                                AS paymentterm,
    i.c_charge_id,
    i.chargeamt,
    i.totallines,
    i.grandtotal,
    i.grandtotal                                           AS amtinwords,
    i.m_pricelist_id,
    i.ispaid,
    p.isallocated,
    p.tendertype,
    p.discountamt,
    drl.c_invoicepayschedule_id,
    drl.c_payment_id,
    drl.isindispute                                        AS c_dunningrunline_isindispute,
    drl.openamt,
    drl.processed                                          AS c_dunningrunline_processed,
    i.ad_org_id                                            AS c_invoice_ad_org_id,
    i.ad_user_id,
    i.c_bpartner_id                                        AS c_invoice_c_bpartner_id,
    i.c_bpartner_location_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.c_order_id                                           AS c_invoice_c_order_id,
    i.c_payment_id                                         AS c_invoice_c_payment_id,
    i.created                                              AS c_invoice_created,
    i.createdby                                            AS c_invoice_createdby,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isactive                                             AS c_invoice_isactive,
    i.isapproved                                           AS c_invoice_isapproved,
    i.isdiscountprinted,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice                                        AS c_invoice_isselfservice,
    i.istaxincluded,
    i.istransferred,
    i.m_rma_id,
    i.paymentrule,
    i.posted                                               AS c_invoice_posted,
    i.processedon                                          AS c_invoice_processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id                                          AS c_invoice_reversal_id,
    i.salesrep_id,
    i.sendemail,
    i.updated                                              AS c_invoice_updated,
    i.updatedby                                            AS c_invoice_updatedby,
    pt.ad_org_id                                           AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id,
    pt.description                                         AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.documentnote,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    pt.isactive                                            AS c_paymentterm_isactive,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                                               AS c_paymentterm_value,
    p.a_city,
    p.a_country,
    p.ad_org_id                                            AS c_payment_ad_org_id,
    p.a_email,
    p.a_ident_dl,
    p.a_name,
    p.a_state,
    p.a_street,
    p.a_zip,
    p.c_bpartner_id                                        AS c_payment_c_bpartner_id,
    p.c_charge_id                                          AS c_payment_c_charge_id,
    p.chargeamt                                            AS c_payment_chargeamt,
    p.checkno,
    p.c_invoice_id                                         AS c_payment_c_invoice_id,
    p.c_order_id                                           AS c_payment_c_order_id,
    p.c_paymentbatch_id,
    p.created                                              AS c_payment_created,
    p.createdby                                            AS c_payment_createdby,
    p.isactive                                             AS c_payment_isactive,
    p.isapproved,
    p.isdelayedcapture,
    p.isonline,
    p.isoverunderpayment,
    p.isprepayment,
    p.isreconciled,
    p.isselfservice                                        AS c_payment_isselfservice,
    p.micr,
    p.orig_trxid,
    p.overunderamt,
    p.payamt,
    p.ponum,
    p.posted                                               AS c_payment_posted,
    p.processed                                            AS c_payment_processed,
    p.processedon                                          AS c_payment_processedon,
    p.r_authcode,
    p.r_authcode_dc,
    p.r_avsaddr,
    p.r_avszip,
    p.r_cvv2match,
    p.ref_payment_id,
    p.reversal_id                                          AS c_payment_reversal_id,
    p.r_info,
    p.routingno,
    p.r_pnref,
    p.r_pnref_dc,
    p.r_respmsg,
    p.r_result,
    p.swipe,
    p.taxamt,
    p.trxtype,
    p.updated                                              AS c_payment_updated,
    p.updatedby                                            AS c_payment_updatedby,
    p.voiceauthcode,
    p.writeoffamt 
FROM c_dunningrunline drl 
        LEFT JOIN c_invoice i 
        ON drl.c_invoice_id = i.c_invoice_id 
        LEFT JOIN c_doctype dt 
        ON i.c_doctype_id = dt.c_doctype_id 
        LEFT JOIN c_paymentterm pt 
        ON i.c_paymentterm_id = pt.c_paymentterm_id 
        LEFT JOIN c_payment p 
        ON drl.c_payment_id = p.c_payment_id 
        LEFT JOIN c_doctype dtp 
        ON p.c_doctype_id = dtp.c_doctype_id
;

DROP VIEW c_dunning_line_vt;

CREATE OR REPLACE VIEW c_dunning_line_vt AS 
SELECT drl.ad_client_id,
    drl.ad_org_id,
    drl.isactive,
    drl.created,
    drl.createdby,
    drl.updated,
    drl.updatedby,
    COALESCE(dt.ad_language, dtp.ad_language)              AS ad_language,
    drl.c_dunningrunline_id,
    drl.c_dunningrunentry_id,
    drl.amt,
    drl.convertedamt,
    drl.daysdue,
    drl.timesdunned,
    drl.interestamt,
    drl.feeamt,
    drl.totalamt,
    drl.c_invoice_id,
    COALESCE(i.issotrx, p.isreceipt)                       AS issotrx,
    COALESCE(i.documentno, p.documentno)                   AS documentno,
    COALESCE(i.docstatus, p.docstatus)                     AS docstatus,
    COALESCE(i.dateinvoiced, p.datetrx)                    AS datetrx,
    COALESCE(i.c_doctype_id, p.c_doctype_id)               AS c_doctype_id,
    COALESCE(dt.printname, dtp.printname)                  AS documenttype,
    COALESCE(i.description, p.description)                 AS description,
    COALESCE(i.c_currency_id, p.c_currency_id)             AS c_currency_id,
    COALESCE(i.c_campaign_id, p.c_campaign_id)             AS c_campaign_id,
    COALESCE(i.c_project_id, p.c_project_id)               AS c_project_id,
    COALESCE(i.c_activity_id, p.c_activity_id)             AS c_activity_id,
    COALESCE(i.user1_id, p.user1_id)                       AS user1_id,
    COALESCE(i.user2_id, p.user2_id)                       AS user2_id,
    COALESCE(i.dateacct, p.dateacct)                       AS dateacct,
    COALESCE(i.c_conversiontype_id, p.c_conversiontype_id) AS c_conversiontype_id,
    COALESCE(i.ad_orgtrx_id, p.ad_orgtrx_id)               AS ad_orgtrx_id,
    i.poreference,
    i.dateordered,
    i.dateinvoiced,
    i.isindispute,
    ptt.name                                               AS paymentterm,
    i.c_charge_id,
    i.chargeamt,
    i.totallines,
    i.grandtotal,
    i.grandtotal                                           AS amtinwords,
    i.m_pricelist_id,
    i.ispaid,
    p.isallocated,
    p.tendertype,
    p.discountamt,
    drl.c_invoicepayschedule_id,
    drl.c_payment_id,
    drl.isindispute                                        AS c_dunningrunline_isindispute,
    drl.openamt,
    drl.processed                                          AS c_dunningrunline_processed,
    i.ad_org_id                                            AS c_invoice_ad_org_id,
    i.ad_user_id,
    i.c_bpartner_id                                        AS c_invoice_c_bpartner_id,
    i.c_bpartner_location_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.c_order_id                                           AS c_invoice_c_order_id,
    i.c_payment_id                                         AS c_invoice_c_payment_id,
    i.created                                              AS c_invoice_created,
    i.createdby                                            AS c_invoice_createdby,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isactive                                             AS c_invoice_isactive,
    i.isapproved                                           AS c_invoice_isapproved,
    i.isdiscountprinted,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice                                        AS c_invoice_isselfservice,
    i.istaxincluded,
    i.istransferred,
    i.m_rma_id,
    i.paymentrule,
    i.posted                                               AS c_invoice_posted,
    i.processedon                                          AS c_invoice_processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id                                          AS c_invoice_reversal_id,
    i.salesrep_id,
    i.sendemail,
    i.updated                                              AS c_invoice_updated,
    i.updatedby                                            AS c_invoice_updatedby,
    ptt.ad_org_id                                          AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id,
    ptt.description                                        AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    ptt.documentnote,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    ptt.isactive                                           AS c_paymentterm_isactive,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                                               AS c_paymentterm_value,
    p.a_city,
    p.a_country,
    p.ad_org_id                                            AS c_payment_ad_org_id,
    p.a_email,
    p.a_ident_dl,
    p.a_name,
    p.a_state,
    p.a_street,
    p.a_zip,
    p.c_bpartner_id                                        AS c_payment_c_bpartner_id,
    p.c_charge_id                                          AS c_payment_c_charge_id,
    p.chargeamt                                            AS c_payment_chargeamt,
    p.checkno,
    p.c_invoice_id                                         AS c_payment_c_invoice_id,
    p.c_order_id                                           AS c_payment_c_order_id,
    p.c_paymentbatch_id,
    p.created                                              AS c_payment_created,
    p.createdby                                            AS c_payment_createdby,
    p.isactive                                             AS c_payment_isactive,
    p.isapproved,
    p.isdelayedcapture,
    p.isonline,
    p.isoverunderpayment,
    p.isprepayment,
    p.isreconciled,
    p.isselfservice                                        AS c_payment_isselfservice,
    p.micr,
    p.orig_trxid,
    p.overunderamt,
    p.payamt,
    p.ponum,
    p.posted                                               AS c_payment_posted,
    p.processed                                            AS c_payment_processed,
    p.processedon                                          AS c_payment_processedon,
    p.r_authcode,
    p.r_authcode_dc,
    p.r_avsaddr,
    p.r_avszip,
    p.r_cvv2match,
    p.ref_payment_id,
    p.reversal_id                                          AS c_payment_reversal_id,
    p.r_info,
    p.routingno,
    p.r_pnref,
    p.r_pnref_dc,
    p.r_respmsg,
    p.r_result,
    p.swipe,
    p.taxamt,
    p.trxtype,
    p.updated                                              AS c_payment_updated,
    p.updatedby                                            AS c_payment_updatedby,
    p.voiceauthcode,
    p.writeoffamt 
FROM c_dunningrunline drl 
        LEFT JOIN c_invoice i 
        ON drl.c_invoice_id = i.c_invoice_id 
        LEFT JOIN c_doctype_trl dt 
        ON i.c_doctype_id = dt.c_doctype_id 
        LEFT JOIN c_paymentterm pt 
        ON i.c_paymentterm_id = pt.c_paymentterm_id 
        LEFT JOIN c_paymentterm_trl ptt 
        ON i.c_paymentterm_id = ptt.c_paymentterm_id AND ptt.ad_language = dt.ad_language 
        LEFT JOIN c_payment p 
        ON drl.c_payment_id = p.c_payment_id 
        LEFT JOIN c_doctype_trl dtp 
        ON p.c_doctype_id = dtp.c_doctype_id 
WHERE COALESCE(dt.ad_language, dtp.ad_language) = COALESCE(dtp.ad_language, dt.ad_language)
;

DROP VIEW c_invoice_header_v;

CREATE OR REPLACE VIEW c_invoice_header_v AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    'en_US'::character varying       AS ad_language,
    i.c_invoice_id,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.c_doctype_id,
    i.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    i.c_order_id,
    i.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    i.dateinvoiced,
    bpg.greeting                     AS bpgreeting,
    bp.name,
    bp.name2,
    bpcg.greeting                    AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    l.postal || l.postal_add         AS postal,
    i.description,
    i.poreference,
    i.dateordered,
    i.c_currency_id,
    pt.name                          AS paymentterm,
    pt.documentnote                  AS paymenttermnote,
    i.c_charge_id,
    i.chargeamt,
    i.totallines,
    i.grandtotal,
    i.grandtotal                     AS amtinwords,
    i.m_pricelist_id,
    i.istaxincluded,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ispaid,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    i.ad_orgtrx_id                   AS c_invoice_ad_orgtrx_id,
    i.ad_user_id,
    i.c_bpartner_location_id,
    i.c_conversiontype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.c_payment_id,
    i.dateacct,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice                  AS c_invoice_isselfservice,
    i.istransferred,
    i.m_rma_id,
    i.paymentrule,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.user1_id,
    i.user2_id,
    pt.ad_org_id                     AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id,
    pt.description                   AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    pt.isactive                      AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS c_paymentterm_value,
    bp.acqusitioncost                AS bp_acqusitioncost,
    bp.actuallifetimevalue           AS bp_actuallifetimevalue,
    bp.ad_language                   AS bp_ad_language,
    bp.ad_orgbp_id                   AS bp_ad_orgbp_id,
    bp.ad_org_id                     AS bp_ad_org_id,
    bp.bpartner_parent_id            AS bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS bp_c_bp_group_id,
    bp.c_dunning_id                  AS bp_c_dunning_id,
    bp.c_greeting_id                 AS bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS bp_c_paymentterm_id,
    bp.created                       AS bp_created,
    bp.createdby                     AS bp_createdby,
    bp.c_taxgroup_id                 AS bp_c_taxgroup_id,
    bp.deliveryrule                  AS bp_deliveryrule,
    bp.deliveryviarule               AS bp_deliveryviarule,
    bp.description                   AS bp_description,
    bp.dunninggrace                  AS bp_dunninggrace,
    bp.firstsale                     AS bp_firstsale,
    bp.flatdiscount                  AS bp_flatdiscount,
    bp.freightcostrule               AS bp_freightcostrule,
    bp.invoicerule                   AS bp_invoicerule,
    bp.isactive                      AS bp_isactive,
    bp.iscustomer                    AS bp_iscustomer,
    bp.isdiscountprinted             AS bp_isdiscountprinted,
    bp.isemployee                    AS bp_isemployee,
    bp.ismanufacturer                AS bp_ismanufacturer,
    bp.isonetime                     AS bp_isonetime,
    bp.ispotaxexempt                 AS bp_ispotaxexempt,
    bp.isprospect                    AS bp_isprospect,
    bp.issalesrep                    AS bp_issalesrep,
    bp.issummary                     AS bp_issummary,
    bp.istaxexempt                   AS bp_istaxexempt,
    bp.isvendor                      AS bp_isvendor,
    bp.logo_id                       AS bp_logo_id,
    bp.m_discountschema_id           AS bp_m_discountschema_id,
    bp.m_pricelist_id                AS bp_m_pricelist_id,
    bp.naics                         AS bp_naics,
    bp.numberemployees               AS bp_numberemployees,
    bp.paymentrule                   AS bp_paymentrule,
    bp.paymentrulepo                 AS bp_paymentrulepo,
    bp.po_discountschema_id          AS bp_po_discountschema_id,
    bp.po_paymentterm_id             AS bp_po_paymentterm_id,
    bp.po_pricelist_id               AS bp_po_pricelist_id,
    bp.poreference                   AS bp_poreference,
    bp.potentiallifetimevalue        AS bp_potentiallifetimevalue,
    bp.rating                        AS bp_rating,
    bp.salesrep_id                   AS bp_salesrep_id,
    bp.salesvolume                   AS bp_salesvolume,
    bp.sendemail                     AS bp_sendemail,
    bp.shareofcustomer               AS bp_shareofcustomer,
    bp.shelflifeminpct               AS bp_shelflifeminpct,
    bp.so_creditlimit                AS bp_so_creditlimit,
    bp.socreditstatus                AS bp_socreditstatus,
    bp.so_creditused                 AS bp_so_creditused,
    bp.so_description                AS bp_so_description,
    bp.totalopenbalance              AS bp_totalopenbalance,
    bp.updated                       AS bp_updated,
    bp.updatedby                     AS bp_updatedby,
    bp.url                           AS bp_url,
    bpg.isactive                     AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpg.name                         AS c_greeting_name,
    bpl.ad_org_id                    AS bp_location_ad_org_id,
    bpl.c_bpartner_id                AS bp_location_c_bpartner_id,
    bpl.created                      AS bp_location_created,
    bpl.createdby                    AS bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS bp_location_fax,
    bpl.isactive                     AS bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS bp_location_name,
    bpl.phone                        AS bp_location_phone,
    bpl.phone2                       AS bp_location_phone2,
    bpl.updated                      AS bp_location_updated,
    bpl.updatedby                    AS bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcg.isactive                    AS user_greeting_isactive,
    bpcg.isfirstnameonly             AS user_greeting_isfirstnameonly,
    bpcg.name                        AS user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS bpartner_acqusitioncost,
    ubp.actuallifetimevalue          AS bpartner_actuallifetimevalue,
    ubp.ad_language                  AS bpartner_ad_language,
    ubp.ad_orgbp_id                  AS bpartner_ad_orgbp_id,
    ubp.ad_org_id                    AS bpartner_ad_org_id,
    ubp.bpartner_parent_id           AS bpartner_bpartner_parent_id,
    ubp.c_bp_group_id                AS bpartner_c_bp_group_id,
    ubp.c_dunning_id                 AS bpartner_c_dunning_id,
    ubp.c_greeting_id                AS bpartner_c_greeting_id,
    ubp.c_invoiceschedule_id         AS bpartner_c_invoiceschedule_id,
    ubp.c_paymentterm_id             AS bpartner_c_paymentterm_id,
    ubp.created                      AS bpartner_created,
    ubp.createdby                    AS bpartner_createdby,
    ubp.c_taxgroup_id                AS bpartner_c_taxgroup_id,
    ubp.deliveryrule                 AS bpartner_deliveryrule,
    ubp.deliveryviarule              AS bpartner_deliveryviarule,
    ubp.description                  AS bpartner_description,
    ubp.dunninggrace                 AS bpartner_dunninggrace,
    ubp.duns                         AS bpartner_duns,
    ubp.firstsale                    AS bpartner_firstsale,
    ubp.flatdiscount                 AS bpartner_flatdiscount,
    ubp.freightcostrule              AS bpartner_freightcostrule,
    ubp.invoicerule                  AS bpartner_invoicerule,
    ubp.isactive                     AS bpartner_isactive,
    ubp.iscustomer                   AS bpartner_iscustomer,
    ubp.isdiscountprinted            AS bpartner_isdiscountprinted,
    ubp.isemployee                   AS bpartner_isemployee,
    ubp.ismanufacturer               AS bpartner_ismanufacturer,
    ubp.isonetime                    AS bpartner_isonetime,
    ubp.ispotaxexempt                AS bpartner_ispotaxexempt,
    ubp.isprospect                   AS bpartner_isprospect,
    ubp.issalesrep                   AS bpartner_issalesrep,
    ubp.issummary                    AS bpartner_issummary,
    ubp.istaxexempt                  AS bpartner_istaxexempt,
    ubp.isvendor                     AS bpartner_isvendor,
    ubp.logo_id                      AS bpartner_logo_id,
    ubp.m_discountschema_id          AS bpartner_m_discountschema_id,
    ubp.m_pricelist_id               AS bpartner_m_pricelist_id,
    ubp.naics                        AS bpartner_naics,
    ubp.name2                        AS bpartner_name2,
    ubp.numberemployees              AS bpartner_numberemployees,
    ubp.paymentrule                  AS bpartner_paymentrule,
    ubp.paymentrulepo                AS bpartner_paymentrulepo,
    ubp.po_discountschema_id         AS bpartner_po_discountschema_id,
    ubp.po_paymentterm_id            AS bpartner_po_paymentterm_id,
    ubp.po_pricelist_id              AS bpartner_po_pricelist_id,
    ubp.poreference                  AS bpartner_poreference,
    ubp.potentiallifetimevalue       AS bpartner_potentiallifetimeval,
    ubp.rating                       AS bpartner_rating,
    ubp.referenceno                  AS bpartner_referenceno,
    ubp.salesrep_id                  AS bpartner_salesrep_id,
    ubp.salesvolume                  AS bpartner_salesvolume,
    ubp.sendemail                    AS bpartner_sendemail,
    ubp.shareofcustomer              AS bpartner_shareofcustomer,
    ubp.shelflifeminpct              AS bpartner_shelflifeminpct,
    ubp.so_creditlimit               AS bpartner_so_creditlimit,
    ubp.socreditstatus               AS bpartner_socreditstatus,
    ubp.so_creditused                AS bpartner_so_creditused,
    ubp.so_description               AS bpartner_so_description,
    ubp.taxid                        AS bpartner_taxid,
    ubp.totalopenbalance             AS bpartner_totalopenbalance,
    ubp.updated                      AS bpartner_updated,
    ubp.updatedby                    AS bpartner_updatedby,
    ubp.url                          AS bpartner_url,
    ubp.value                        AS bpartner_value 
FROM c_invoice i 
        JOIN c_doctype dt 
        ON i.c_doctype_id = dt.c_doctype_id 
        JOIN c_paymentterm pt 
        ON i.c_paymentterm_id = pt.c_paymentterm_id 
        JOIN c_bpartner bp 
        ON i.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        JOIN c_bpartner_location bpl 
        ON i.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON i.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        JOIN ad_orginfo oi 
        ON i.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON i.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON i.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id
;

DROP VIEW c_invoice_header_vt;

CREATE OR REPLACE VIEW c_invoice_header_vt AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    dt.ad_language,
    i.c_invoice_id,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.c_doctype_id,
    i.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    i.c_order_id,
    i.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    i.dateinvoiced,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    l.postal || l.postal_add         AS postal,
    i.description,
    i.poreference,
    i.dateordered,
    i.c_currency_id,
    ptt.name                         AS paymentterm,
    ptt.documentnote                 AS paymenttermnote,
    i.c_charge_id,
    i.chargeamt,
    i.totallines,
    i.grandtotal,
    i.grandtotal                     AS amtinwords,
    i.m_pricelist_id,
    i.istaxincluded,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ispaid,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    i.ad_orgtrx_id                   AS c_invoice_ad_orgtrx_id,
    i.ad_user_id,
    i.c_bpartner_location_id,
    i.c_conversiontype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.c_payment_id,
    i.dateacct,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice                  AS c_invoice_isselfservice,
    i.istransferred,
    i.m_rma_id,
    i.paymentrule,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.user1_id,
    i.user2_id,
    ptt.ad_org_id                    AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id,
    ptt.description                  AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    ptt.isactive                     AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS c_paymentterm_value,
    bp.acqusitioncost                AS bp_acqusitioncost,
    bp.actuallifetimevalue           AS bp_actuallifetimevalue,
    bp.ad_language                   AS bp_ad_language,
    bp.ad_orgbp_id                   AS bp_ad_orgbp_id,
    bp.ad_org_id                     AS bp_ad_org_id,
    bp.bpartner_parent_id            AS bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS bp_c_bp_group_id,
    bp.c_dunning_id                  AS bp_c_dunning_id,
    bp.c_greeting_id                 AS bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS bp_c_paymentterm_id,
    bp.created                       AS bp_created,
    bp.createdby                     AS bp_createdby,
    bp.c_taxgroup_id                 AS bp_c_taxgroup_id,
    bp.deliveryrule                  AS bp_deliveryrule,
    bp.deliveryviarule               AS bp_deliveryviarule,
    bp.description                   AS bp_description,
    bp.dunninggrace                  AS bp_dunninggrace,
    bp.firstsale                     AS bp_firstsale,
    bp.flatdiscount                  AS bp_flatdiscount,
    bp.freightcostrule               AS bp_freightcostrule,
    bp.invoicerule                   AS bp_invoicerule,
    bp.isactive                      AS bp_isactive,
    bp.iscustomer                    AS bp_iscustomer,
    bp.isdiscountprinted             AS bp_isdiscountprinted,
    bp.isemployee                    AS bp_isemployee,
    bp.ismanufacturer                AS bp_ismanufacturer,
    bp.isonetime                     AS bp_isonetime,
    bp.ispotaxexempt                 AS bp_ispotaxexempt,
    bp.isprospect                    AS bp_isprospect,
    bp.issalesrep                    AS bp_issalesrep,
    bp.issummary                     AS bp_issummary,
    bp.istaxexempt                   AS bp_istaxexempt,
    bp.isvendor                      AS bp_isvendor,
    bp.logo_id                       AS bp_logo_id,
    bp.m_discountschema_id           AS bp_m_discountschema_id,
    bp.m_pricelist_id                AS bp_m_pricelist_id,
    bp.naics                         AS bp_naics,
    bp.numberemployees               AS bp_numberemployees,
    bp.paymentrule                   AS bp_paymentrule,
    bp.paymentrulepo                 AS bp_paymentrulepo,
    bp.po_discountschema_id          AS bp_po_discountschema_id,
    bp.po_paymentterm_id             AS bp_po_paymentterm_id,
    bp.po_pricelist_id               AS bp_po_pricelist_id,
    bp.poreference                   AS bp_poreference,
    bp.potentiallifetimevalue        AS bp_potentiallifetimevalue,
    bp.rating                        AS bp_rating,
    bp.salesrep_id                   AS bp_salesrep_id,
    bp.salesvolume                   AS bp_salesvolume,
    bp.sendemail                     AS bp_sendemail,
    bp.shareofcustomer               AS bp_shareofcustomer,
    bp.shelflifeminpct               AS bp_shelflifeminpct,
    bp.so_creditlimit                AS bp_so_creditlimit,
    bp.socreditstatus                AS bp_socreditstatus,
    bp.so_creditused                 AS bp_so_creditused,
    bp.so_description                AS bp_so_description,
    bp.totalopenbalance              AS bp_totalopenbalance,
    bp.updated                       AS bp_updated,
    bp.updatedby                     AS bp_updatedby,
    bp.url                           AS bp_url,
    bpgt.isactive                    AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                        AS c_greeting_name,
    bpl.ad_org_id                    AS bp_location_ad_org_id,
    bpl.c_bpartner_id                AS bp_location_c_bpartner_id,
    bpl.created                      AS bp_location_created,
    bpl.createdby                    AS bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS bp_location_fax,
    bpl.isactive                     AS bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS bp_location_name,
    bpl.phone                        AS bp_location_phone,
    bpl.phone2                       AS bp_location_phone2,
    bpl.updated                      AS bp_location_updated,
    bpl.updatedby                    AS bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.isactive                   AS user_greeting_isactive,
    bpcg.isfirstnameonly             AS user_greeting_isfirstnameonly,
    bpcgt.name                       AS user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS bpartner_acqusitioncost,
    ubp.actuallifetimevalue          AS bpartner_actuallifetimevalue,
    ubp.ad_language                  AS bpartner_ad_language,
    ubp.ad_orgbp_id                  AS bpartner_ad_orgbp_id,
    ubp.ad_org_id                    AS bpartner_ad_org_id,
    ubp.bpartner_parent_id           AS bpartner_bpartner_parent_id,
    ubp.c_bp_group_id                AS bpartner_c_bp_group_id,
    ubp.c_dunning_id                 AS bpartner_c_dunning_id,
    ubp.c_greeting_id                AS bpartner_c_greeting_id,
    ubp.c_invoiceschedule_id         AS bpartner_c_invoiceschedule_id,
    ubp.c_paymentterm_id             AS bpartner_c_paymentterm_id,
    ubp.created                      AS bpartner_created,
    ubp.createdby                    AS bpartner_createdby,
    ubp.c_taxgroup_id                AS bpartner_c_taxgroup_id,
    ubp.deliveryrule                 AS bpartner_deliveryrule,
    ubp.deliveryviarule              AS bpartner_deliveryviarule,
    ubp.description                  AS bpartner_description,
    ubp.dunninggrace                 AS bpartner_dunninggrace,
    ubp.duns                         AS bpartner_duns,
    ubp.firstsale                    AS bpartner_firstsale,
    ubp.flatdiscount                 AS bpartner_flatdiscount,
    ubp.freightcostrule              AS bpartner_freightcostrule,
    ubp.invoicerule                  AS bpartner_invoicerule,
    ubp.isactive                     AS bpartner_isactive,
    ubp.iscustomer                   AS bpartner_iscustomer,
    ubp.isdiscountprinted            AS bpartner_isdiscountprinted,
    ubp.isemployee                   AS bpartner_isemployee,
    ubp.ismanufacturer               AS bpartner_ismanufacturer,
    ubp.isonetime                    AS bpartner_isonetime,
    ubp.ispotaxexempt                AS bpartner_ispotaxexempt,
    ubp.isprospect                   AS bpartner_isprospect,
    ubp.issalesrep                   AS bpartner_issalesrep,
    ubp.issummary                    AS bpartner_issummary,
    ubp.istaxexempt                  AS bpartner_istaxexempt,
    ubp.isvendor                     AS bpartner_isvendor,
    ubp.logo_id                      AS bpartner_logo_id,
    ubp.m_discountschema_id          AS bpartner_m_discountschema_id,
    ubp.m_pricelist_id               AS bpartner_m_pricelist_id,
    ubp.naics                        AS bpartner_naics,
    ubp.name2                        AS bpartner_name2,
    ubp.numberemployees              AS bpartner_numberemployees,
    ubp.paymentrule                  AS bpartner_paymentrule,
    ubp.paymentrulepo                AS bpartner_paymentrulepo,
    ubp.po_discountschema_id         AS bpartner_po_discountschema_id,
    ubp.po_paymentterm_id            AS bpartner_po_paymentterm_id,
    ubp.po_pricelist_id              AS bpartner_po_pricelist_id,
    ubp.poreference                  AS bpartner_poreference,
    ubp.potentiallifetimevalue       AS bpartner_potentiallifetimeval,
    ubp.rating                       AS bpartner_rating,
    ubp.referenceno                  AS bpartner_referenceno,
    ubp.salesrep_id                  AS bpartner_salesrep_id,
    ubp.salesvolume                  AS bpartner_salesvolume,
    ubp.sendemail                    AS bpartner_sendemail,
    ubp.shareofcustomer              AS bpartner_shareofcustomer,
    ubp.shelflifeminpct              AS bpartner_shelflifeminpct,
    ubp.so_creditlimit               AS bpartner_so_creditlimit,
    ubp.socreditstatus               AS bpartner_socreditstatus,
    ubp.so_creditused                AS bpartner_so_creditused,
    ubp.so_description               AS bpartner_so_description,
    ubp.taxid                        AS bpartner_taxid,
    ubp.totalopenbalance             AS bpartner_totalopenbalance,
    ubp.updated                      AS bpartner_updated,
    ubp.updatedby                    AS bpartner_updatedby,
    ubp.url                          AS bpartner_url,
    ubp.value                        AS bpartner_value 
FROM c_invoice i 
        JOIN c_doctype_trl dt 
        ON i.c_doctype_id = dt.c_doctype_id 
        JOIN c_paymentterm pt 
        ON i.c_paymentterm_id = pt.c_paymentterm_id 
        JOIN c_paymentterm_trl ptt 
        ON i.c_paymentterm_id = ptt.c_paymentterm_id AND dt.ad_language = ptt.ad_language 
        JOIN c_bpartner bp 
        ON i.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id AND dt.ad_language = bpgt.ad_language 
        JOIN c_bpartner_location bpl 
        ON i.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON i.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id AND dt.ad_language = bpcgt.ad_language 
        JOIN ad_orginfo oi 
        ON i.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON i.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON i.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id
;

DROP VIEW c_invoice_linetax_v;

CREATE OR REPLACE VIEW c_invoice_linetax_v AS 
    (
        ( ( SELECT il.ad_client_id,
                il.ad_org_id,
                il.isactive,
                il.created,
                il.createdby,
                il.updated,
                il.updatedby,
                'en_US'                               AS ad_language,
                il.c_invoice_id,
                il.c_invoiceline_id,
                il.c_tax_id,
                il.taxamt,
                il.linetotalamt,
                t.taxindicator,
                il.line,
                p.m_product_id,
                CASE WHEN il.qtyinvoiced <> 0 OR il.m_product_id IS NOT NULL THEN il.qtyinvoiced ELSE NULL END                               AS qtyinvoiced,
                CASE WHEN il.qtyentered <> 0 OR il.m_product_id IS NOT NULL THEN il.qtyentered ELSE NULL END                               AS qtyentered,
                CASE WHEN il.qtyentered <> 0 OR il.m_product_id IS NOT NULL THEN uom.uomsymbol ELSE NULL END                               AS uomsymbol,
                COALESCE(c.name, (p.name || COALESCE(productattribute(il.m_attributesetinstance_id), '')), il.description)  AS name,
                CASE WHEN COALESCE(c.name, p.name) IS NOT NULL THEN il.description ELSE NULL END                               AS description,
                p.documentnote,
                p.upc,
                p.sku,
                COALESCE(pp.vendorproductno, p.value) AS productvalue,
                ra.description                        AS resourcedescription,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist <> 0 THEN il.pricelist ELSE NULL END                               AS pricelist,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist <> 0 AND il.qtyentered <> 0 THEN il.pricelist * il.qtyinvoiced / il.qtyentered ELSE NULL END                               AS 
                priceenteredlist,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist > il.priceactual AND il.pricelist <> 0 THEN (il.pricelist - il.priceactual) / il.pricelist * 100 ELSE NULL END                               
                AS discount,
                CASE WHEN il.priceactual <> 0 OR il.m_product_id IS NOT NULL THEN il.priceactual ELSE NULL END                               AS priceactual,
                CASE WHEN il.priceentered <> 0 OR il.m_product_id IS NOT NULL THEN il.priceentered ELSE NULL END                               AS priceentered,
                CASE WHEN il.linenetamt <> 0 OR il.m_product_id IS NOT NULL THEN il.linenetamt ELSE NULL END                               AS linenetamt,
                il.m_attributesetinstance_id,
                asi.m_attributeset_id,
                asi.serno,
                asi.lot,
                asi.m_lot_id,
                asi.guaranteedate,
                p.description                         AS productdescription,
                p.imageurl,
                il.c_campaign_id,
                il.c_project_id,
                il.c_activity_id,
                il.c_projectphase_id,
                il.c_projecttask_id,
                il.ad_orgtrx_id                       AS c_invoiceline_ad_orgtrx_id,
                il.a_processed,
                il.c_charge_id,
                il.c_orderline_id,
                il.c_uom_id,
                il.isdescription,
                il.isprinted                          AS c_invoiceline_isprinted,
                il.m_inoutline_id,
                il.m_rmaline_id,
                il.pricelimit,
                il.processed                          AS c_invoiceline_processed,
                il.ref_invoiceline_id,
                il.rramt,
                il.rrstartdate,
                il.s_resourceassignment_id,
                il.user1_id                           AS c_invoiceline_user1_id,
                il.user2_id                           AS c_invoiceline_user2_id,
                uom.ad_org_id                         AS c_uom_ad_org_id,
                uom.costingprecision,
                uom.description                       AS c_uom_description,
                uom.isactive                          AS c_uom_isactive,
                uom.isdefault                         AS c_uom_isdefault,
                uom.name                              AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                i.ad_org_id                           AS c_invoice_ad_org_id,
                i.ad_orgtrx_id                        AS c_invoice_ad_orgtrx_id,
                i.ad_user_id                          AS c_invoice_ad_user_id,
                i.c_activity_id                       AS c_invoice_c_activity_id,
                i.c_bpartner_id                       AS c_invoice_c_bpartner_id,
                i.c_bpartner_location_id,
                i.c_campaign_id                       AS c_invoice_c_campaign_id,
                i.c_charge_id                         AS c_invoice_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.c_dunninglevel_id,
                i.chargeamt                           AS c_invoice_chargeamt,
                i.c_order_id,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_project_id                        AS c_invoice_c_project_id,
                i.created                             AS c_invoice_created,
                i.createdby                           AS c_invoice_createdby,
                i.dateacct,
                i.dateinvoiced,
                i.dateordered,
                i.dateprinted,
                i.description                         AS c_invoice_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dunninggrace,
                i.generateto,
                i.grandtotal,
                i.invoicecollectiontype,
                i.isactive                            AS c_invoice_isactive,
                i.isapproved,
                i.isdiscountprinted,
                i.isindispute,
                i.ispaid,
                i.ispayschedulevalid,
                i.isprinted                           AS c_invoice_isprinted,
                i.isselfservice                       AS c_invoice_isselfservice,
                i.issotrx,
                i.istaxincluded                       AS c_invoice_istaxincluded,
                i.istransferred,
                i.m_pricelist_id,
                i.m_rma_id,
                i.paymentrule,
                i.poreference,
                i.posted,
                i.processedon,
                i.processing,
                i.ref_invoice_id,
                i.reversal_id,
                i.salesrep_id,
                i.sendemail,
                i.totallines,
                i.updated                             AS c_invoice_updated,
                i.updatedby                           AS c_invoice_updatedby,
                i.user1_id                            AS c_invoice_user1_id,
                i.user2_id                            AS c_invoice_user2_id,
                t.ad_org_id                           AS c_tax_ad_org_id,
                t.ad_rule_id,
                t.c_country_id,
                t.c_region_id,
                t.c_taxcategory_id                    AS c_tax_c_taxcategory_id,
                t.description                         AS c_tax_description,
                t.isactive                            AS c_tax_isactive,
                t.isdefault                           AS c_tax_isdefault,
                t.isdocumentlevel,
                t.issalestax,
                t.issummary                           AS c_tax_issummary,
                t.istaxexempt,
                t.name                                AS c_tax_name,
                t.parent_tax_id,
                t.rate,
                t.requirestaxcertificate,
                t.sopotype,
                t.to_country_id,
                t.to_region_id,
                t.validfrom,
                p.ad_org_id                           AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                            AS m_product_copyfrom,
                p.created                             AS m_product_created,
                p.createdby                           AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id                    AS m_product_c_taxcategory_id,
                p.descriptionurl,
                p.discontinued,
                p.discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                p.isactive                            AS m_product_isactive,
                p.isbom,
                p.isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice                       AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                           AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id                   AS m_product_m_attributeset_id,
                p.m_attributesetinstance_id           AS m_product_m_asi_id,
                p.m_freightcategory_id,
                p.m_locator_id,
                p.m_product_category_id               AS m_product_m_prod_category_id,
                p.processing                          AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id                         AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id                       AS m_product_s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                p.updated                             AS m_product_updated,
                p.updatedby                           AS m_product_updatedby,
                p.versionno,
                p.volume,
                p.weight,
                c.ad_org_id                           AS c_charge_ad_org_id,
                c.c_bpartner_id                       AS c_charge_c_bpartner_id,
                c.c_chargetype_id,
                c.chargeamt                           AS c_charge_chargeamt,
                c.c_taxcategory_id                    AS c_charge_c_taxcategory_id,
                c.description                         AS c_charge_description,
                c.isactive                            AS c_charge_isactive,
                c.issamecurrency,
                c.issametax,
                c.istaxincluded                       AS c_charge_istaxincluded,
                pp.ad_org_id                          AS c_bp_product_ad_org_id,
                pp.c_bpartner_id                      AS c_bp_product_c_bpartner_id,
                pp.created                            AS c_bp_product_created,
                pp.createdby                          AS c_bp_product_createdby,
                pp.description                        AS c_bp_product_description,
                pp.isactive                           AS c_bp_product_isactive,
                pp.ismanufacturer,
                pp.manufacturer,
                pp.qualityrating,
                pp.shelflifemindays,
                pp.shelflifeminpct,
                pp.updated                            AS c_bp_product_updated,
                pp.updatedby                          AS c_bp_product_updatedby,
                pp.vendorcategory,
                ra.ad_org_id                          AS s_rassignment_ad_org_id,
                ra.assigndatefrom,
                ra.assigndateto,
                ra.created                            AS s_rassignment_created,
                ra.createdby                          AS s_rassignment_createby,
                ra.isactive                           AS s_rassignment_isactive,
                ra.isconfirmed,
                ra.name                               AS s_rassignment_name,
                ra.qty                                AS s_rassignment_qty,
                ra.s_resource_id                      AS s_rassignment_s_resource_id,
                ra.updated                            AS s_rassignment_updated,
                ra.updatedby                          AS s_rassignment_updatedby,
                asi.ad_org_id                         AS m_asi_ad_org_id,
                asi.created                           AS m_asi_created,
                asi.createdby                         AS m_asi_createdby,
                asi.description                       AS m_asi_description,
                asi.isactive                          AS m_asi_isactive,
                asi.updated                           AS m_asi_updated,
                asi.updatedby                         AS m_asi_updatedby 
            FROM c_invoiceline il 
                JOIN c_uom uom 
                ON il.c_uom_id = uom.c_uom_id 
                JOIN c_invoice i 
                ON il.c_invoice_id = i.c_invoice_id 
                LEFT JOIN c_tax t 
                ON il.c_tax_id = t.c_tax_id 
                LEFT JOIN m_product p 
                ON il.m_product_id = p.m_product_id 
                LEFT JOIN c_charge c 
                ON il.c_charge_id = c.c_charge_id 
                LEFT JOIN c_bpartner_product pp 
                ON il.m_product_id = pp.m_product_id AND i.c_bpartner_id = pp.c_bpartner_id 
                LEFT JOIN s_resourceassignment ra 
                ON il.s_resourceassignment_id = ra.s_resourceassignment_id 
                LEFT JOIN m_attributesetinstance asi 
                ON il.m_attributesetinstance_id = asi.m_attributesetinstance_id 
                UNION SELECT il.ad_client_id,
                        il.ad_org_id,
                        il.isactive,
                        il.created,
                        il.createdby,
                        il.updated,
                        il.updatedby,
                        'en_US'                     AS ad_language,
                        il.c_invoice_id,
                        il.c_invoiceline_id,
                        il.c_tax_id,
                        il.taxamt,
                        il.linetotalamt,
                        t.taxindicator,
                        il.line + bl.line / 100     AS line,
                        p.m_product_id,
                        CASE WHEN bl.isqtypercentage = 'N' THEN il.qtyinvoiced * bl.qtybom ELSE il.qtyinvoiced * (bl.qtybatch / 100) END                     AS qtyinvoiced,
                        CASE WHEN bl.isqtypercentage = 'N' THEN il.qtyentered * bl.qtybom ELSE il.qtyentered * (bl.qtybatch / 100) END                     AS qtyentered,
                        uom.uomsymbol,
                        p.name,
                        b.description,
                        p.documentnote,
                        p.upc,
                        p.sku,
                        p.value                     AS productvalue,
                        NULL                        AS resourcedescription,
                        NULL                        AS pricelist,
                        NULL                        AS priceenteredlist,
                        NULL                        AS discount,
                        NULL                        AS priceactual,
                        NULL                        AS priceentered,
                        NULL                        AS linenetamt,
                        il.m_attributesetinstance_id,
                        asi.m_attributeset_id,
                        asi.serno,
                        asi.lot,
                        asi.m_lot_id,
                        asi.guaranteedate,
                        p.description               AS productdescription,
                        p.imageurl,
                        il.c_campaign_id,
                        il.c_project_id,
                        il.c_activity_id,
                        il.c_projectphase_id,
                        il.c_projecttask_id,
                        il.ad_orgtrx_id             AS c_invoiceline_ad_orgtrx_id,
                        il.a_processed,
                        il.c_charge_id,
                        il.c_orderline_id,
                        il.c_uom_id,
                        il.isdescription,
                        il.isprinted                AS c_invoiceline_isprinted,
                        il.m_inoutline_id,
                        il.m_rmaline_id,
                        il.pricelimit,
                        il.processed                AS c_invoiceline_processed,
                        il.ref_invoiceline_id,
                        il.rramt,
                        il.rrstartdate,
                        il.s_resourceassignment_id,
                        il.user1_id                 AS c_invoiceline_user1_id,
                        il.user2_id                 AS c_invoiceline_user2_id,
                        uom.ad_org_id               AS c_uom_ad_org_id,
                        uom.costingprecision,
                        uom.description             AS c_uom_description,
                        uom.isactive                AS c_uom_isactive,
                        uom.isdefault               AS c_uom_isdefault,
                        uom.name                    AS c_uom_name,
                        uom.stdprecision,
                        uom.uomtype,
                        uom.x12de355,
                        NULL                        AS c_invoice_ad_org_id,
                        NULL                        AS c_invoice_ad_orgtrx_id,
                        NULL                        AS c_invoice_ad_user_id,
                        NULL                        AS c_invoice_c_activity_id,
                        NULL                        AS c_invoice_c_bpartner_id,
                        NULL                        AS c_bpartner_location_id,
                        NULL                        AS c_invoice_c_campaign_id,
                        NULL                        AS c_invoice_c_charge_id,
                        NULL                        AS c_conversiontype_id,
                        NULL                        AS c_currency_id,
                        NULL                        AS c_doctype_id,
                        NULL                        AS c_doctypetarget_id,
                        NULL                        AS c_dunninglevel_id,
                        NULL                        AS c_invoice_chargeamt,
                        NULL                        AS c_order_id,
                        NULL                        AS c_payment_id,
                        NULL                        AS c_paymentterm_id,
                        NULL                        AS c_invoice_c_project_id,
                        NULL                        AS c_invoice_created,
                        NULL                        AS c_invoice_createdby,
                        NULL                        AS dateacct,
                        NULL                        AS dateinvoiced,
                        NULL                        AS dateordered,
                        NULL                        AS dateprinted,
                        NULL                        AS c_invoice_description,
                        NULL                        AS docaction,
                        NULL                        AS docstatus,
                        NULL                        AS documentno,
                        NULL                        AS dunninggrace,
                        NULL                        AS generateto,
                        NULL                        AS grandtotal,
                        NULL                        AS invoicecollectiontype,
                        NULL                        AS c_invoice_isactive,
                        NULL                        AS isapproved,
                        NULL                        AS isdiscountprinted,
                        NULL                        AS isindispute,
                        NULL                        AS ispaid,
                        NULL                        AS ispayschedulevalid,
                        NULL                        AS c_invoice_isprinted,
                        NULL                        AS c_invoice_isselfservice,
                        NULL                        AS issotrx,
                        NULL                        AS c_invoice_istaxincluded,
                        NULL                        AS istransferred,
                        NULL                        AS m_pricelist_id,
                        NULL                        AS m_rma_id,
                        NULL                        AS paymentrule,
                        NULL                        AS poreference,
                        NULL                        AS posted,
                        NULL                        AS processedon,
                        NULL                        AS processing,
                        NULL                        AS ref_invoice_id,
                        NULL                        AS reversal_id,
                        NULL                        AS salesrep_id,
                        NULL                        AS sendemail,
                        NULL                        AS totallines,
                        NULL                        AS c_invoice_updated,
                        NULL                        AS c_invoice_updatedby,
                        NULL                        AS c_invoice_user1_id,
                        NULL                        AS c_invoice_user2_id,
                        t.ad_org_id                 AS c_tax_ad_org_id,
                        t.ad_rule_id,
                        t.c_country_id,
                        t.c_region_id,
                        t.c_taxcategory_id          AS c_tax_c_taxcategory_id,
                        t.description               AS c_tax_description,
                        t.isactive                  AS c_tax_isactive,
                        t.isdefault                 AS c_tax_isdefault,
                        t.isdocumentlevel,
                        t.issalestax,
                        t.issummary                 AS c_tax_issummary,
                        t.istaxexempt,
                        t.name                      AS c_tax_name,
                        t.parent_tax_id,
                        t.rate,
                        t.requirestaxcertificate,
                        t.sopotype,
                        t.to_country_id,
                        t.to_region_id,
                        t.validfrom,
                        p.ad_org_id                 AS m_product_ad_org_id,
                        p.classification,
                        p.copyfrom                  AS m_product_copyfrom,
                        p.created                   AS m_product_created,
                        p.createdby                 AS m_product_createdby,
                        p.c_revenuerecognition_id,
                        p.c_subscriptiontype_id,
                        p.c_taxcategory_id          AS m_product_c_taxcategory_id,
                        p.descriptionurl,
                        p.discontinued,
                        p.discontinuedat,
                        p.group1,
                        p.group2,
                        p.guaranteedays,
                        p.guaranteedaysmin,
                        p.help,
                        p.isactive                  AS m_product_isactive,
                        p.isbom,
                        p.isdropship,
                        p.isexcludeautodelivery,
                        p.isinvoiceprintdetails,
                        p.ispicklistprintdetails,
                        p.ispurchased,
                        p.isselfservice             AS m_product_isselfservice,
                        p.issold,
                        p.isstocked,
                        p.issummary                 AS m_product_issummary,
                        p.isverified,
                        p.iswebstorefeatured,
                        p.lowlevel,
                        p.m_attributeset_id         AS m_product_m_attributeset_id,
                        p.m_attributesetinstance_id AS m_product_m_asi_id,
                        p.m_freightcategory_id,
                        p.m_locator_id,
                        p.m_product_category_id     AS m_product_m_prod_category_id,
                        p.processing                AS m_product_processing,
                        p.producttype,
                        p.r_mailtext_id,
                        p.salesrep_id               AS m_product_salesrep_id,
                        p.s_expensetype_id,
                        p.shelfdepth,
                        p.shelfheight,
                        p.shelfwidth,
                        p.s_resource_id             AS m_product_s_resource_id,
                        p.unitsperpack,
                        p.unitsperpallet,
                        p.updated                   AS m_product_updated,
                        p.updatedby                 AS m_product_updatedby,
                        p.versionno,
                        p.volume,
                        p.weight,
                        NULL                        AS c_charge_ad_org_id,
                        NULL                        AS c_charge_c_bpartner_id,
                        NULL                        AS c_chargetype_id,
                        NULL                        AS c_charge_chargeamt,
                        NULL                        AS c_charge_c_taxcategory_id,
                        NULL                        AS c_charge_description,
                        NULL                        AS c_charge_isactive,
                        NULL                        AS issamecurrency,
                        NULL                        AS issametax,
                        NULL                        AS c_charge_istaxincluded,
                        NULL                        AS c_bp_product_ad_org_id,
                        NULL                        AS c_bp_product_c_bpartner_id,
                        NULL                        AS c_bp_product_created,
                        NULL                        AS c_bp_product_createdby,
                        NULL                        AS c_bp_product_description,
                        NULL                        AS c_bp_product_isactive,
                        NULL                        AS ismanufacturer,
                        NULL                        AS manufacturer,
                        NULL                        AS qualityrating,
                        NULL                        AS shelflifemindays,
                        NULL                        AS shelflifeminpct,
                        NULL                        AS c_bp_product_updated,
                        NULL                        AS c_bp_product_updatedby,
                        NULL                        AS vendorcategory,
                        NULL                        AS s_rassignment_ad_org_id,
                        NULL                        AS assigndatefrom,
                        NULL                        AS assigndateto,
                        NULL                        AS s_rassignment_created,
                        NULL                        AS s_rassignment_createby,
                        NULL                        AS s_rassignment_isactive,
                        NULL                        AS isconfirmed,
                        NULL                        AS s_rassignment_name,
                        NULL                        AS s_rassignment_qty,
                        NULL                        AS s_rassignment_s_resource_id,
                        NULL                        AS s_rassignment_updated,
                        NULL                        AS s_rassignment_updatedby,
                        asi.ad_org_id               AS m_asi_ad_org_id,
                        asi.created                 AS m_asi_created,
                        asi.createdby               AS m_asi_createdby,
                        asi.description             AS m_asi_description,
                        asi.isactive                AS m_asi_isactive,
                        asi.updated                 AS m_asi_updated,
                        asi.updatedby               AS m_asi_updatedby 
                    FROM pp_product_bom b 
                        JOIN c_invoiceline il 
                        ON b.m_product_id = il.m_product_id 
                        JOIN m_product bp 
                        ON bp.m_product_id = il.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.isinvoiceprintdetails = 'Y' 
                        JOIN pp_product_bomline bl 
                        ON bl.pp_product_bom_id = b.pp_product_bom_id 
                        JOIN m_product p 
                        ON bl.m_product_id = p.m_product_id 
                        JOIN c_uom uom 
                        ON p.c_uom_id = uom.c_uom_id 
                        LEFT JOIN c_tax t 
                        ON il.c_tax_id = t.c_tax_id 
                        LEFT JOIN m_attributesetinstance asi 
                        ON il.m_attributesetinstance_id = asi.m_attributesetinstance_id) 
        UNION   SELECT il.ad_client_id,
                    il.ad_org_id,
                    il.isactive,
                    il.created,
                    il.createdby,
                    il.updated,
                    il.updatedby,
                    'en_US'         AS ad_language,
                    il.c_invoice_id,
                    il.c_invoiceline_id,
                    NULL            AS c_tax_id,
                    NULL            AS taxamt,
                    NULL            AS linetotalamt,
                    NULL            AS taxindicator,
                    il.line,
                    NULL            AS m_product_id,
                    NULL            AS qtyinvoiced,
                    NULL            AS qtyentered,
                    NULL            AS uomsymbol,
                    il.description  AS name,
                    NULL            AS description,
                    NULL            AS documentnote,
                    NULL            AS upc,
                    NULL            AS sku,
                    NULL            AS productvalue,
                    NULL            AS resourcedescription,
                    NULL            AS pricelist,
                    NULL            AS priceenteredlist,
                    NULL            AS discount,
                    NULL            AS priceactual,
                    NULL            AS priceentered,
                    NULL            AS linenetamt,
                    NULL            AS m_attributesetinstance_id,
                    NULL            AS m_attributeset_id,
                    NULL            AS serno,
                    NULL            AS lot,
                    NULL            AS m_lot_id,
                    NULL            AS guaranteedate,
                    NULL            AS productdescription,
                    NULL            AS imageurl,
                    NULL            AS c_campaign_id,
                    NULL            AS c_project_id,
                    NULL            AS c_activity_id,
                    NULL            AS c_projectphase_id,
                    NULL            AS c_projecttask_id,
                    il.ad_orgtrx_id AS c_invoiceline_ad_orgtrx_id,
                    il.a_processed,
                    il.c_charge_id,
                    il.c_orderline_id,
                    il.c_uom_id,
                    il.isdescription,
                    il.isprinted    AS c_invoiceline_isprinted,
                    il.m_inoutline_id,
                    il.m_rmaline_id,
                    il.pricelimit,
                    il.processed    AS c_invoiceline_processed,
                    il.ref_invoiceline_id,
                    il.rramt,
                    il.rrstartdate,
                    il.s_resourceassignment_id,
                    il.user1_id     AS c_invoiceline_user1_id,
                    il.user2_id     AS c_invoiceline_user2_id,
                    NULL            AS c_uom_ad_org_id,
                    NULL            AS costingprecision,
                    NULL            AS c_uom_description,
                    NULL            AS c_uom_isactive,
                    NULL            AS c_uom_isdefault,
                    NULL            AS c_uom_name,
                    NULL            AS stdprecision,
                    NULL            AS uomtype,
                    NULL            AS x12de355,
                    NULL            AS c_invoice_ad_org_id,
                    NULL            AS c_invoice_ad_orgtrx_id,
                    NULL            AS c_invoice_ad_user_id,
                    NULL            AS c_invoice_c_activity_id,
                    NULL            AS c_invoice_c_bpartner_id,
                    NULL            AS c_bpartner_location_id,
                    NULL            AS c_invoice_c_campaign_id,
                    NULL            AS c_invoice_c_charge_id,
                    NULL            AS c_conversiontype_id,
                    NULL            AS c_currency_id,
                    NULL            AS c_doctype_id,
                    NULL            AS c_doctypetarget_id,
                    NULL            AS c_dunninglevel_id,
                    NULL            AS c_invoice_chargeamt,
                    NULL            AS c_order_id,
                    NULL            AS c_payment_id,
                    NULL            AS c_paymentterm_id,
                    NULL            AS c_invoice_c_project_id,
                    NULL            AS c_invoice_created,
                    NULL            AS c_invoice_createdby,
                    NULL            AS dateacct,
                    NULL            AS dateinvoiced,
                    NULL            AS dateordered,
                    NULL            AS dateprinted,
                    NULL            AS c_invoice_description,
                    NULL            AS docaction,
                    NULL            AS docstatus,
                    NULL            AS documentno,
                    NULL            AS dunninggrace,
                    NULL            AS generateto,
                    NULL            AS grandtotal,
                    NULL            AS invoicecollectiontype,
                    NULL            AS c_invoice_isactive,
                    NULL            AS isapproved,
                    NULL            AS isdiscountprinted,
                    NULL            AS isindispute,
                    NULL            AS ispaid,
                    NULL            AS ispayschedulevalid,
                    NULL            AS c_invoice_isprinted,
                    NULL            AS c_invoice_isselfservice,
                    NULL            AS issotrx,
                    NULL            AS c_invoice_istaxincluded,
                    NULL            AS istransferred,
                    NULL            AS m_pricelist_id,
                    NULL            AS m_rma_id,
                    NULL            AS paymentrule,
                    NULL            AS poreference,
                    NULL            AS posted,
                    NULL            AS processedon,
                    NULL            AS processing,
                    NULL            AS ref_invoice_id,
                    NULL            AS reversal_id,
                    NULL            AS salesrep_id,
                    NULL            AS sendemail,
                    NULL            AS totallines,
                    NULL            AS c_invoice_updated,
                    NULL            AS c_invoice_updatedby,
                    NULL            AS c_invoice_user1_id,
                    NULL            AS c_invoice_user2_id,
                    NULL            AS c_tax_ad_org_id,
                    NULL            AS ad_rule_id,
                    NULL            AS c_country_id,
                    NULL            AS c_region_id,
                    NULL            AS c_tax_c_taxcategory_id,
                    NULL            AS c_tax_description,
                    NULL            AS c_tax_isactive,
                    NULL            AS c_tax_isdefault,
                    NULL            AS isdocumentlevel,
                    NULL            AS issalestax,
                    NULL            AS c_tax_issummary,
                    NULL            AS istaxexempt,
                    NULL            AS c_tax_name,
                    NULL            AS parent_tax_id,
                    NULL            AS rate,
                    NULL            AS requirestaxcertificate,
                    NULL            AS sopotype,
                    NULL            AS to_country_id,
                    NULL            AS to_region_id,
                    NULL            AS validfrom,
                    NULL            AS m_product_ad_org_id,
                    NULL            AS classification,
                    NULL            AS m_product_copyfrom,
                    NULL            AS m_product_created,
                    NULL            AS m_product_createdby,
                    NULL            AS c_revenuerecognition_id,
                    NULL            AS c_subscriptiontype_id,
                    NULL            AS m_product_c_taxcategory_id,
                    NULL            AS descriptionurl,
                    NULL            AS discontinued,
                    NULL            AS discontinuedat,
                    NULL            AS group1,
                    NULL            AS group2,
                    NULL            AS guaranteedays,
                    NULL            AS guaranteedaysmin,
                    NULL            AS help,
                    NULL            AS m_product_isactive,
                    NULL            AS isbom,
                    NULL            AS isdropship,
                    NULL            AS isexcludeautodelivery,
                    NULL            AS isinvoiceprintdetails,
                    NULL            AS ispicklistprintdetails,
                    NULL            AS ispurchased,
                    NULL            AS m_product_isselfservice,
                    NULL            AS issold,
                    NULL            AS isstocked,
                    NULL            AS m_product_issummary,
                    NULL            AS isverified,
                    NULL            AS iswebstorefeatured,
                    NULL            AS lowlevel,
                    NULL            AS m_product_m_attributeset_id,
                    NULL            AS m_product_m_asi_id,
                    NULL            AS m_freightcategory_id,
                    NULL            AS m_locator_id,
                    NULL            AS m_product_m_prod_category_id,
                    NULL            AS m_product_processing,
                    NULL            AS producttype,
                    NULL            AS r_mailtext_id,
                    NULL            AS m_product_salesrep_id,
                    NULL            AS s_expensetype_id,
                    NULL            AS shelfdepth,
                    NULL            AS shelfheight,
                    NULL            AS shelfwidth,
                    NULL            AS m_product_s_resource_id,
                    NULL            AS unitsperpack,
                    NULL            AS unitsperpallet,
                    NULL            AS m_product_updated,
                    NULL            AS m_product_updatedby,
                    NULL            AS versionno,
                    NULL            AS volume,
                    NULL            AS weight,
                    NULL            AS c_charge_ad_org_id,
                    NULL            AS c_charge_c_bpartner_id,
                    NULL            AS c_chargetype_id,
                    NULL            AS c_charge_chargeamt,
                    NULL            AS c_charge_c_taxcategory_id,
                    NULL            AS c_charge_description,
                    NULL            AS c_charge_isactive,
                    NULL            AS issamecurrency,
                    NULL            AS issametax,
                    NULL            AS c_charge_istaxincluded,
                    NULL            AS c_bp_product_ad_org_id,
                    NULL            AS c_bp_product_c_bpartner_id,
                    NULL            AS c_bp_product_created,
                    NULL            AS c_bp_product_createdby,
                    NULL            AS c_bp_product_description,
                    NULL            AS c_bp_product_isactive,
                    NULL            AS ismanufacturer,
                    NULL            AS manufacturer,
                    NULL            AS qualityrating,
                    NULL            AS shelflifemindays,
                    NULL            AS shelflifeminpct,
                    NULL            AS c_bp_product_updated,
                    NULL            AS c_bp_product_updatedby,
                    NULL            AS vendorcategory,
                    NULL            AS s_rassignment_ad_org_id,
                    NULL            AS assigndatefrom,
                    NULL            AS assigndateto,
                    NULL            AS s_rassignment_created,
                    NULL            AS s_rassignment_createby,
                    NULL            AS s_rassignment_isactive,
                    NULL            AS isconfirmed,
                    NULL            AS s_rassignment_name,
                    NULL            AS s_rassignment_qty,
                    NULL            AS s_rassignment_s_resource_id,
                    NULL            AS s_rassignment_updated,
                    NULL            AS s_rassignment_updatedby,
                    NULL            AS m_asi_ad_org_id,
                    NULL            AS m_asi_created,
                    NULL            AS m_asi_createdby,
                    NULL            AS m_asi_description,
                    NULL            AS m_asi_isactive,
                    NULL            AS m_asi_updated,
                    NULL            AS m_asi_updatedby 
                FROM c_invoiceline il 
                WHERE il.c_uom_id IS NULL) 
    UNION   SELECT i.ad_client_id,
                i.ad_org_id,
                i.isactive,
                i.created,
                i.createdby,
                i.updated,
                i.updatedby,
                'en_US'         AS ad_language,
                i.c_invoice_id,
                NULL            AS c_invoiceline_id,
                NULL            AS c_tax_id,
                NULL            AS taxamt,
                NULL            AS linetotalamt,
                NULL            AS taxindicator,
                999998          AS line,
                NULL            AS m_product_id,
                NULL            AS qtyinvoiced,
                NULL            AS qtyentered,
                NULL            AS uomsymbol,
                NULL            AS name,
                NULL            AS description,
                NULL            AS documentnote,
                NULL            AS upc,
                NULL            AS sku,
                NULL            AS productvalue,
                NULL            AS resourcedescription,
                NULL            AS pricelist,
                NULL            AS priceenteredlist,
                NULL            AS discount,
                NULL            AS priceactual,
                NULL            AS priceentered,
                NULL            AS linenetamt,
                NULL            AS m_attributesetinstance_id,
                NULL            AS m_attributeset_id,
                NULL            AS serno,
                NULL            AS lot,
                NULL            AS m_lot_id,
                NULL            AS guaranteedate,
                NULL            AS productdescription,
                NULL            AS imageurl,
                NULL            AS c_campaign_id,
                NULL            AS c_project_id,
                NULL            AS c_activity_id,
                NULL            AS c_projectphase_id,
                NULL            AS c_projecttask_id,
                NULL            AS c_invoiceline_ad_orgtrx_id,
                NULL            AS a_processed,
                NULL            AS c_charge_id,
                NULL            AS c_orderline_id,
                NULL            AS c_uom_id,
                NULL            AS isdescription,
                NULL            AS c_invoiceline_isprinted,
                NULL            AS m_inoutline_id,
                NULL            AS m_rmaline_id,
                NULL            AS pricelimit,
                NULL            AS c_invoiceline_processed,
                NULL            AS ref_invoiceline_id,
                NULL            AS rramt,
                NULL            AS rrstartdate,
                NULL            AS s_resourceassignment_id,
                NULL            AS c_invoiceline_user1_id,
                NULL            AS c_invoiceline_user2_id,
                NULL            AS c_uom_ad_org_id,
                NULL            AS costingprecision,
                NULL            AS c_uom_description,
                NULL            AS c_uom_isactive,
                NULL            AS c_uom_isdefault,
                NULL            AS c_uom_name,
                NULL            AS stdprecision,
                NULL            AS uomtype,
                NULL            AS x12de355,
                i.ad_org_id     AS c_invoice_ad_org_id,
                i.ad_orgtrx_id  AS c_invoice_ad_orgtrx_id,
                i.ad_user_id    AS c_invoice_ad_user_id,
                i.c_activity_id AS c_invoice_c_activity_id,
                i.c_bpartner_id AS c_invoice_c_bpartner_id,
                i.c_bpartner_location_id,
                i.c_campaign_id AS c_invoice_c_campaign_id,
                i.c_charge_id   AS c_invoice_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.c_dunninglevel_id,
                i.chargeamt     AS c_invoice_chargeamt,
                i.c_order_id,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_project_id  AS c_invoice_c_project_id,
                i.created       AS c_invoice_created,
                i.createdby     AS c_invoice_createdby,
                i.dateacct,
                i.dateinvoiced,
                i.dateordered,
                i.dateprinted,
                i.description   AS c_invoice_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dunninggrace,
                i.generateto,
                i.grandtotal,
                i.invoicecollectiontype,
                i.isactive      AS c_invoice_isactive,
                i.isapproved,
                i.isdiscountprinted,
                i.isindispute,
                i.ispaid,
                i.ispayschedulevalid,
                i.isprinted     AS c_invoice_isprinted,
                i.isselfservice AS c_invoice_isselfservice,
                i.issotrx,
                i.istaxincluded AS c_invoice_istaxincluded,
                i.istransferred,
                i.m_pricelist_id,
                i.m_rma_id,
                i.paymentrule,
                i.poreference,
                i.posted,
                i.processedon,
                i.processing,
                i.ref_invoice_id,
                i.reversal_id,
                i.salesrep_id,
                i.sendemail,
                i.totallines,
                i.updated       AS c_invoice_updated,
                i.updatedby     AS c_invoice_updatedby,
                i.user1_id      AS c_invoice_user1_id,
                i.user2_id      AS c_invoice_user2_id,
                NULL            AS c_tax_ad_org_id,
                NULL            AS ad_rule_id,
                NULL            AS c_country_id,
                NULL            AS c_region_id,
                NULL            AS c_tax_c_taxcategory_id,
                NULL            AS c_tax_description,
                NULL            AS c_tax_isactive,
                NULL            AS c_tax_isdefault,
                NULL            AS isdocumentlevel,
                NULL            AS issalestax,
                NULL            AS c_tax_issummary,
                NULL            AS istaxexempt,
                NULL            AS c_tax_name,
                NULL            AS parent_tax_id,
                NULL            AS rate,
                NULL            AS requirestaxcertificate,
                NULL            AS sopotype,
                NULL            AS to_country_id,
                NULL            AS to_region_id,
                NULL            AS validfrom,
                NULL            AS m_product_ad_org_id,
                NULL            AS classification,
                NULL            AS m_product_copyfrom,
                NULL            AS m_product_created,
                NULL            AS m_product_createdby,
                NULL            AS c_revenuerecognition_id,
                NULL            AS c_subscriptiontype_id,
                NULL            AS m_product_c_taxcategory_id,
                NULL            AS descriptionurl,
                NULL            AS discontinued,
                NULL            AS discontinuedat,
                NULL            AS group1,
                NULL            AS group2,
                NULL            AS guaranteedays,
                NULL            AS guaranteedaysmin,
                NULL            AS help,
                NULL            AS m_product_isactive,
                NULL            AS isbom,
                NULL            AS isdropship,
                NULL            AS isexcludeautodelivery,
                NULL            AS isinvoiceprintdetails,
                NULL            AS ispicklistprintdetails,
                NULL            AS ispurchased,
                NULL            AS m_product_isselfservice,
                NULL            AS issold,
                NULL            AS isstocked,
                NULL            AS m_product_issummary,
                NULL            AS isverified,
                NULL            AS iswebstorefeatured,
                NULL            AS lowlevel,
                NULL            AS m_product_m_attributeset_id,
                NULL            AS m_product_m_asi_id,
                NULL            AS m_freightcategory_id,
                NULL            AS m_locator_id,
                NULL            AS m_product_m_prod_category_id,
                NULL            AS m_product_processing,
                NULL            AS producttype,
                NULL            AS r_mailtext_id,
                NULL            AS m_product_salesrep_id,
                NULL            AS s_expensetype_id,
                NULL            AS shelfdepth,
                NULL            AS shelfheight,
                NULL            AS shelfwidth,
                NULL            AS m_product_s_resource_id,
                NULL            AS unitsperpack,
                NULL            AS unitsperpallet,
                NULL            AS m_product_updated,
                NULL            AS m_product_updatedby,
                NULL            AS versionno,
                NULL            AS volume,
                NULL            AS weight,
                NULL            AS c_charge_ad_org_id,
                NULL            AS c_charge_c_bpartner_id,
                NULL            AS c_chargetype_id,
                NULL            AS c_charge_chargeamt,
                NULL            AS c_charge_c_taxcategory_id,
                NULL            AS c_charge_description,
                NULL            AS c_charge_isactive,
                NULL            AS issamecurrency,
                NULL            AS issametax,
                NULL            AS c_charge_istaxincluded,
                NULL            AS c_bp_product_ad_org_id,
                NULL            AS c_bp_product_c_bpartner_id,
                NULL            AS c_bp_product_created,
                NULL            AS c_bp_product_createdby,
                NULL            AS c_bp_product_description,
                NULL            AS c_bp_product_isactive,
                NULL            AS ismanufacturer,
                NULL            AS manufacturer,
                NULL            AS qualityrating,
                NULL            AS shelflifemindays,
                NULL            AS shelflifeminpct,
                NULL            AS c_bp_product_updated,
                NULL            AS c_bp_product_updatedby,
                NULL            AS vendorcategory,
                NULL            AS s_rassignment_ad_org_id,
                NULL            AS assigndatefrom,
                NULL            AS assigndateto,
                NULL            AS s_rassignment_created,
                NULL            AS s_rassignment_createby,
                NULL            AS s_rassignment_isactive,
                NULL            AS isconfirmed,
                NULL            AS s_rassignment_name,
                NULL            AS s_rassignment_qty,
                NULL            AS s_rassignment_s_resource_id,
                NULL            AS s_rassignment_updated,
                NULL            AS s_rassignment_updatedby,
                NULL            AS m_asi_ad_org_id,
                NULL            AS m_asi_created,
                NULL            AS m_asi_createdby,
                NULL            AS m_asi_description,
                NULL            AS m_asi_isactive,
                NULL            AS m_asi_updated,
                NULL            AS m_asi_updatedby 
            FROM c_invoice i
            )
UNION 
SELECT it.ad_client_id,
    it.ad_org_id,
    it.isactive,
    it.created,
    it.createdby,
    it.updated,
    it.updatedby,
    'en_US' AS ad_language,
    it.c_invoice_id,
    NULL    AS c_invoiceline_id,
    it.c_tax_id,
    NULL    AS taxamt,
    NULL    AS linetotalamt,
    t.taxindicator,
    999999  AS line,
    NULL    AS m_product_id,
    NULL    AS qtyinvoiced,
    NULL    AS qtyentered,
    NULL    AS uomsymbol,
    t.name,
    NULL    AS description,
    NULL    AS documentnote,
    NULL    AS upc,
    NULL    AS sku,
    NULL    AS productvalue,
    NULL    AS resourcedescription,
    NULL    AS pricelist,
    NULL    AS priceenteredlist,
    NULL    AS discount,
    CASE WHEN it.istaxincluded = 'Y' THEN it.taxamt ELSE it.taxbaseamt END AS priceactual,
    CASE WHEN it.istaxincluded = 'Y' THEN it.taxamt ELSE it.taxbaseamt END AS priceentered,
    CASE WHEN it.istaxincluded = 'Y' THEN NULL ELSE it.taxamt END AS linenetamt,
    NULL    AS m_attributesetinstance_id,
    NULL    AS m_attributeset_id,
    NULL    AS serno,
    NULL    AS lot,
    NULL    AS m_lot_id,
    NULL    AS guaranteedate,
    NULL    AS productdescription,
    NULL    AS imageurl,
    NULL    AS c_campaign_id,
    NULL    AS c_project_id,
    NULL    AS c_activity_id,
    NULL    AS c_projectphase_id,
    NULL    AS c_projecttask_id,
    NULL    AS c_invoiceline_ad_orgtrx_id,
    NULL    AS a_processed,
    NULL    AS c_charge_id,
    NULL    AS c_orderline_id,
    NULL    AS c_uom_id,
    NULL    AS isdescription,
    NULL    AS c_invoiceline_isprinted,
    NULL    AS m_inoutline_id,
    NULL    AS m_rmaline_id,
    NULL    AS pricelimit,
    NULL    AS c_invoiceline_processed,
    NULL    AS ref_invoiceline_id,
    NULL    AS rramt,
    NULL    AS rrstartdate,
    NULL    AS s_resourceassignment_id,
    NULL    AS c_invoiceline_user1_id,
    NULL    AS c_invoiceline_user2_id,
    NULL    AS c_uom_ad_org_id,
    NULL    AS costingprecision,
    NULL    AS c_uom_description,
    NULL    AS c_uom_isactive,
    NULL    AS c_uom_isdefault,
    NULL    AS c_uom_name,
    NULL    AS stdprecision,
    NULL    AS uomtype,
    NULL    AS x12de355,
    NULL    AS c_invoice_ad_org_id,
    NULL    AS c_invoice_ad_orgtrx_id,
    NULL    AS c_invoice_ad_user_id,
    NULL    AS c_invoice_c_activity_id,
    NULL    AS c_invoice_c_bpartner_id,
    NULL    AS c_bpartner_location_id,
    NULL    AS c_invoice_c_campaign_id,
    NULL    AS c_invoice_c_charge_id,
    NULL    AS c_conversiontype_id,
    NULL    AS c_currency_id,
    NULL    AS c_doctype_id,
    NULL    AS c_doctypetarget_id,
    NULL    AS c_dunninglevel_id,
    NULL    AS c_invoice_chargeamt,
    NULL    AS c_order_id,
    NULL    AS c_payment_id,
    NULL    AS c_paymentterm_id,
    NULL    AS c_invoice_c_project_id,
    NULL    AS c_invoice_created,
    NULL    AS c_invoice_createdby,
    NULL    AS dateacct,
    NULL    AS dateinvoiced,
    NULL    AS dateordered,
    NULL    AS dateprinted,
    NULL    AS c_invoice_description,
    NULL    AS docaction,
    NULL    AS docstatus,
    NULL    AS documentno,
    NULL    AS dunninggrace,
    NULL    AS generateto,
    NULL    AS grandtotal,
    NULL    AS invoicecollectiontype,
    NULL    AS c_invoice_isactive,
    NULL    AS isapproved,
    NULL    AS isdiscountprinted,
    NULL    AS isindispute,
    NULL    AS ispaid,
    NULL    AS ispayschedulevalid,
    NULL    AS c_invoice_isprinted,
    NULL    AS c_invoice_isselfservice,
    NULL    AS issotrx,
    NULL    AS c_invoice_istaxincluded,
    NULL    AS istransferred,
    NULL    AS m_pricelist_id,
    NULL    AS m_rma_id,
    NULL    AS paymentrule,
    NULL    AS poreference,
    NULL    AS posted,
    NULL    AS processedon,
    NULL    AS processing,
    NULL    AS ref_invoice_id,
    NULL    AS reversal_id,
    NULL    AS salesrep_id,
    NULL    AS sendemail,
    NULL    AS totallines,
    NULL    AS c_invoice_updated,
    NULL    AS c_invoice_updatedby,
    NULL    AS c_invoice_user1_id,
    NULL    AS c_invoice_user2_id,
    NULL    AS c_tax_ad_org_id,
    NULL    AS ad_rule_id,
    NULL    AS c_country_id,
    NULL    AS c_region_id,
    NULL    AS c_tax_c_taxcategory_id,
    NULL    AS c_tax_description,
    NULL    AS c_tax_isactive,
    NULL    AS c_tax_isdefault,
    NULL    AS isdocumentlevel,
    NULL    AS issalestax,
    NULL    AS c_tax_issummary,
    NULL    AS istaxexempt,
    NULL    AS c_tax_name,
    NULL    AS parent_tax_id,
    NULL    AS rate,
    NULL    AS requirestaxcertificate,
    NULL    AS sopotype,
    NULL    AS to_country_id,
    NULL    AS to_region_id,
    NULL    AS validfrom,
    NULL    AS m_product_ad_org_id,
    NULL    AS classification,
    NULL    AS m_product_copyfrom,
    NULL    AS m_product_created,
    NULL    AS m_product_createdby,
    NULL    AS c_revenuerecognition_id,
    NULL    AS c_subscriptiontype_id,
    NULL    AS m_product_c_taxcategory_id,
    NULL    AS descriptionurl,
    NULL    AS discontinued,
    NULL    AS discontinuedat,
    NULL    AS group1,
    NULL    AS group2,
    NULL    AS guaranteedays,
    NULL    AS guaranteedaysmin,
    NULL    AS help,
    NULL    AS m_product_isactive,
    NULL    AS isbom,
    NULL    AS isdropship,
    NULL    AS isexcludeautodelivery,
    NULL    AS isinvoiceprintdetails,
    NULL    AS ispicklistprintdetails,
    NULL    AS ispurchased,
    NULL    AS m_product_isselfservice,
    NULL    AS issold,
    NULL    AS isstocked,
    NULL    AS m_product_issummary,
    NULL    AS isverified,
    NULL    AS iswebstorefeatured,
    NULL    AS lowlevel,
    NULL    AS m_product_m_attributeset_id,
    NULL    AS m_product_m_asi_id,
    NULL    AS m_freightcategory_id,
    NULL    AS m_locator_id,
    NULL    AS m_product_m_prod_category_id,
    NULL    AS m_product_processing,
    NULL    AS producttype,
    NULL    AS r_mailtext_id,
    NULL    AS m_product_salesrep_id,
    NULL    AS s_expensetype_id,
    NULL    AS shelfdepth,
    NULL    AS shelfheight,
    NULL    AS shelfwidth,
    NULL    AS m_product_s_resource_id,
    NULL    AS unitsperpack,
    NULL    AS unitsperpallet,
    NULL    AS m_product_updated,
    NULL    AS m_product_updatedby,
    NULL    AS versionno,
    NULL    AS volume,
    NULL    AS weight,
    NULL    AS c_charge_ad_org_id,
    NULL    AS c_charge_c_bpartner_id,
    NULL    AS c_chargetype_id,
    NULL    AS c_charge_chargeamt,
    NULL    AS c_charge_c_taxcategory_id,
    NULL    AS c_charge_description,
    NULL    AS c_charge_isactive,
    NULL    AS issamecurrency,
    NULL    AS issametax,
    NULL    AS c_charge_istaxincluded,
    NULL    AS c_bp_product_ad_org_id,
    NULL    AS c_bp_product_c_bpartner_id,
    NULL    AS c_bp_product_created,
    NULL    AS c_bp_product_createdby,
    NULL    AS c_bp_product_description,
    NULL    AS c_bp_product_isactive,
    NULL    AS ismanufacturer,
    NULL    AS manufacturer,
    NULL    AS qualityrating,
    NULL    AS shelflifemindays,
    NULL    AS shelflifeminpct,
    NULL    AS c_bp_product_updated,
    NULL    AS c_bp_product_updatedby,
    NULL    AS vendorcategory,
    NULL    AS s_rassignment_ad_org_id,
    NULL    AS assigndatefrom,
    NULL    AS assigndateto,
    NULL    AS s_rassignment_created,
    NULL    AS s_rassignment_createby,
    NULL    AS s_rassignment_isactive,
    NULL    AS isconfirmed,
    NULL    AS s_rassignment_name,
    NULL    AS s_rassignment_qty,
    NULL    AS s_rassignment_s_resource_id,
    NULL    AS s_rassignment_updated,
    NULL    AS s_rassignment_updatedby,
    NULL    AS m_asi_ad_org_id,
    NULL    AS m_asi_created,
    NULL    AS m_asi_createdby,
    NULL    AS m_asi_description,
    NULL    AS m_asi_isactive,
    NULL    AS m_asi_updated,
    NULL    AS m_asi_updatedby 
FROM c_invoicetax it 
        JOIN c_tax t 
        ON it.c_tax_id = t.c_tax_id
;

DROP VIEW c_invoice_linetax_vt;

CREATE OR REPLACE VIEW c_invoice_linetax_vt AS 
    (
        ( ( SELECT il.ad_client_id,
                il.ad_org_id,
                il.isactive,
                il.created,
                il.createdby,
                il.updated,
                il.updatedby,
                uomt.ad_language,
                il.c_invoice_id,
                il.c_invoiceline_id,
                il.c_tax_id,
                il.taxamt,
                il.linetotalamt,
                tt.taxindicator,
                il.line,
                pt.m_product_id,
                CASE WHEN il.qtyinvoiced <> 0 OR il.m_product_id IS NOT NULL THEN il.qtyinvoiced ELSE NULL END                               AS qtyinvoiced,
                CASE WHEN il.qtyentered <> 0 OR il.m_product_id IS NOT NULL THEN il.qtyentered ELSE NULL END                               AS qtyentered,
                CASE WHEN il.qtyentered <> 0 OR il.m_product_id IS NOT NULL THEN uomt.uomsymbol ELSE NULL END                               AS uomsymbol,
                COALESCE(ct.name, (pt.name || COALESCE(productattribute(il.m_attributesetinstance_id), '')), il.description) AS name,
                CASE WHEN COALESCE(ct.name, pt.name) IS NOT NULL THEN il.description ELSE NULL END                               AS description,
                pt.documentnote,
                p.upc,
                p.sku,
                COALESCE(pp.vendorproductno, p.value) AS productvalue,
                ra.description                        AS resourcedescription,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist <> 0 THEN il.pricelist ELSE NULL END                               AS pricelist,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist <> 0 AND il.qtyentered <> 0 THEN il.pricelist * il.qtyinvoiced / il.qtyentered ELSE NULL END                               AS 
                priceenteredlist,
                CASE WHEN i.isdiscountprinted = 'Y' AND il.pricelist > il.priceactual AND il.pricelist <> 0 THEN (il.pricelist - il.priceactual) / il.pricelist * 100 ELSE NULL END                               
                AS discount,
                CASE WHEN il.priceactual <> 0 OR il.m_product_id IS NOT NULL THEN il.priceactual ELSE NULL END                               AS priceactual,
                CASE WHEN il.priceentered <> 0 OR il.m_product_id IS NOT NULL THEN il.priceentered ELSE NULL END                               AS priceentered,
                CASE WHEN il.linenetamt <> 0 OR il.m_product_id IS NOT NULL THEN il.linenetamt ELSE NULL END                               AS linenetamt,
                il.m_attributesetinstance_id,
                asi.m_attributeset_id,
                asi.serno,
                asi.lot,
                asi.m_lot_id,
                asi.guaranteedate,
                pt.description                        AS productdescription,
                p.imageurl,
                il.c_campaign_id,
                il.c_project_id,
                il.c_activity_id,
                il.c_projectphase_id,
                il.c_projecttask_id,
                il.ad_orgtrx_id                       AS c_invoiceline_ad_orgtrx_id,
                il.a_processed,
                il.c_charge_id,
                il.c_orderline_id,
                il.c_uom_id,
                il.isdescription,
                il.isprinted                          AS c_invoiceline_isprinted,
                il.m_inoutline_id,
                il.m_rmaline_id,
                il.pricelimit,
                il.processed                          AS c_invoiceline_processed,
                il.ref_invoiceline_id,
                il.rramt,
                il.rrstartdate,
                il.s_resourceassignment_id,
                il.user1_id                           AS c_invoiceline_user1_id,
                il.user2_id                           AS c_invoiceline_user2_id,
                uomt.ad_org_id                        AS c_uom_ad_org_id,
                uom.costingprecision,
                uomt.description                      AS c_uom_description,
                uomt.isactive                         AS c_uom_isactive,
                uom.isdefault                         AS c_uom_isdefault,
                uomt.name                             AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                i.ad_org_id                           AS c_invoice_ad_org_id,
                i.ad_orgtrx_id                        AS c_invoice_ad_orgtrx_id,
                i.ad_user_id                          AS c_invoice_ad_user_id,
                i.c_activity_id                       AS c_invoice_c_activity_id,
                i.c_bpartner_id                       AS c_invoice_c_bpartner_id,
                i.c_bpartner_location_id,
                i.c_campaign_id                       AS c_invoice_c_campaign_id,
                i.c_charge_id                         AS c_invoice_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.c_dunninglevel_id,
                i.chargeamt                           AS c_invoice_chargeamt,
                i.c_order_id,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_project_id                        AS c_invoice_c_project_id,
                i.created                             AS c_invoice_created,
                i.createdby                           AS c_invoice_createdby,
                i.dateacct,
                i.dateinvoiced,
                i.dateordered,
                i.dateprinted,
                i.description                         AS c_invoice_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dunninggrace,
                i.generateto,
                i.grandtotal,
                i.invoicecollectiontype,
                i.isactive                            AS c_invoice_isactive,
                i.isapproved,
                i.isdiscountprinted,
                i.isindispute,
                i.ispaid,
                i.ispayschedulevalid,
                i.isprinted                           AS c_invoice_isprinted,
                i.isselfservice                       AS c_invoice_isselfservice,
                i.issotrx,
                i.istaxincluded                       AS c_invoice_istaxincluded,
                i.istransferred,
                i.m_pricelist_id,
                i.m_rma_id,
                i.paymentrule,
                i.poreference,
                i.posted,
                i.processedon,
                i.processing,
                i.ref_invoice_id,
                i.reversal_id,
                i.salesrep_id,
                i.sendemail,
                i.totallines,
                i.updated                             AS c_invoice_updated,
                i.updatedby                           AS c_invoice_updatedby,
                i.user1_id                            AS c_invoice_user1_id,
                i.user2_id                            AS c_invoice_user2_id,
                tt.ad_org_id                          AS c_tax_ad_org_id,
                t.ad_rule_id,
                t.c_country_id,
                t.c_region_id,
                t.c_taxcategory_id                    AS c_tax_c_taxcategory_id,
                tt.description                        AS c_tax_description,
                tt.isactive                           AS c_tax_isactive,
                t.isdefault                           AS c_tax_isdefault,
                t.isdocumentlevel,
                t.issalestax,
                t.issummary                           AS c_tax_issummary,
                t.istaxexempt,
                tt.name                               AS c_tax_name,
                t.parent_tax_id,
                t.rate,
                t.requirestaxcertificate,
                t.sopotype,
                t.to_country_id,
                t.to_region_id,
                t.validfrom,
                pt.ad_org_id                          AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                            AS m_product_copyfrom,
                pt.created                            AS m_product_created,
                pt.createdby                          AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id                    AS m_product_c_taxcategory_id,
                p.descriptionurl,
                p.discontinued,
                p.discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                pt.isactive                           AS m_product_isactive,
                p.isbom,
                p.isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice                       AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                           AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id                   AS m_product_m_attributeset_id,
                p.m_attributesetinstance_id           AS m_product_m_asi_id,
                p.m_freightcategory_id,
                p.m_locator_id,
                p.m_product_category_id               AS m_product_m_prod_category_id,
                p.processing                          AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id                         AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id                       AS m_product_s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                pt.updated                            AS m_product_updated,
                pt.updatedby                          AS m_product_updatedby,
                p.versionno,
                p.volume,
                p.weight,
                ct.ad_org_id                          AS c_charge_ad_org_id,
                c.c_bpartner_id                       AS c_charge_c_bpartner_id,
                c.c_chargetype_id,
                c.chargeamt                           AS c_charge_chargeamt,
                c.c_taxcategory_id                    AS c_charge_c_taxcategory_id,
                ct.description                        AS c_charge_description,
                ct.isactive                           AS c_charge_isactive,
                c.issamecurrency,
                c.issametax,
                c.istaxincluded                       AS c_charge_istaxincluded,
                pp.ad_org_id                          AS c_bp_product_ad_org_id,
                pp.c_bpartner_id                      AS c_bp_product_c_bpartner_id,
                pp.created                            AS c_bp_product_created,
                pp.createdby                          AS c_bp_product_createdby,
                pp.description                        AS c_bp_product_description,
                pp.isactive                           AS c_bp_product_isactive,
                pp.ismanufacturer,
                pp.manufacturer,
                pp.qualityrating,
                pp.shelflifemindays,
                pp.shelflifeminpct,
                pp.updated                            AS c_bp_product_updated,
                pp.updatedby                          AS c_bp_product_updatedby,
                pp.vendorcategory,
                ra.ad_org_id                          AS s_rassignment_ad_org_id,
                ra.assigndatefrom,
                ra.assigndateto,
                ra.created                            AS s_rassignment_created,
                ra.createdby                          AS s_rassignment_createby,
                ra.isactive                           AS s_rassignment_isactive,
                ra.isconfirmed,
                ra.name                               AS s_rassignment_name,
                ra.qty                                AS s_rassignment_qty,
                ra.s_resource_id                      AS s_rassignment_s_resource_id,
                ra.updated                            AS s_rassignment_updated,
                ra.updatedby                          AS s_rassignment_updatedby,
                asi.ad_org_id                         AS m_asi_ad_org_id,
                asi.created                           AS m_asi_created,
                asi.createdby                         AS m_asi_createdby,
                asi.description                       AS m_asi_description,
                asi.isactive                          AS m_asi_isactive,
                asi.updated                           AS m_asi_updated,
                asi.updatedby                         AS m_asi_updatedby 
            FROM c_invoiceline il 
                JOIN c_uom uom 
                ON il.c_uom_id = uom.c_uom_id 
                JOIN c_uom_trl uomt 
                ON il.c_uom_id = uomt.c_uom_id 
                JOIN c_invoice i 
                ON il.c_invoice_id = i.c_invoice_id 
                LEFT JOIN c_tax t 
                ON il.c_tax_id = t.c_tax_id 
                LEFT JOIN c_tax_trl tt 
                ON il.c_tax_id = tt.c_tax_id AND uomt.ad_language = tt.ad_language 
                LEFT JOIN m_product p 
                ON il.m_product_id = p.m_product_id 
                LEFT JOIN c_charge c 
                ON il.c_charge_id = c.c_charge_id 
                LEFT JOIN c_charge_trl ct 
                ON il.c_charge_id = ct.c_charge_id 
                LEFT JOIN c_bpartner_product pp 
                ON il.m_product_id = pp.m_product_id AND i.c_bpartner_id = pp.c_bpartner_id 
                LEFT JOIN m_product_trl pt 
                ON il.m_product_id = pt.m_product_id AND uomt.ad_language = pt.ad_language 
                LEFT JOIN s_resourceassignment ra 
                ON il.s_resourceassignment_id = ra.s_resourceassignment_id 
                LEFT JOIN m_attributesetinstance asi 
                ON il.m_attributesetinstance_id = asi.m_attributesetinstance_id 
                UNION SELECT il.ad_client_id,
                        il.ad_org_id,
                        il.isactive,
                        il.created,
                        il.createdby,
                        il.updated,
                        il.updatedby,
                        uomt.ad_language,
                        il.c_invoice_id,
                        il.c_invoiceline_id,
                        il.c_tax_id,
                        il.taxamt,
                        il.linetotalamt,
                        tt.taxindicator,
                        il.line + bl.line / 100                   AS line,
                        pt.m_product_id,
                        CASE WHEN bl.isqtypercentage = 'N' THEN il.qtyinvoiced * bl.qtybom ELSE il.qtyinvoiced * (bl.qtybatch / 100) END                                   AS qtyinvoiced,
                        CASE WHEN bl.isqtypercentage = 'N' THEN il.qtyentered * bl.qtybom ELSE il.qtyentered * (bl.qtybatch / 100) END                                   AS qtyentered,
                        uomt.uomsymbol,
                        COALESCE(pt.name, p.name)                 AS name,
                        b.description,
                        COALESCE(pt.documentnote, p.documentnote) AS documentnote,
                        p.upc,
                        p.sku,
                        p.value                                   AS productvalue,
                        NULL                                      AS resourcedescription,
                        NULL                                      AS pricelist,
                        NULL                                      AS priceenteredlist,
                        NULL                                      AS discount,
                        NULL                                      AS priceactual,
                        NULL                                      AS priceentered,
                        NULL                                      AS linenetamt,
                        il.m_attributesetinstance_id,
                        asi.m_attributeset_id,
                        asi.serno,
                        asi.lot,
                        asi.m_lot_id,
                        asi.guaranteedate,
                        pt.description                            AS productdescription,
                        p.imageurl,
                        il.c_campaign_id,
                        il.c_project_id,
                        il.c_activity_id,
                        il.c_projectphase_id,
                        il.c_projecttask_id,
                        il.ad_orgtrx_id                           AS c_invoiceline_ad_orgtrx_id,
                        il.a_processed,
                        il.c_charge_id,
                        il.c_orderline_id,
                        il.c_uom_id,
                        il.isdescription,
                        il.isprinted                              AS c_invoiceline_isprinted,
                        il.m_inoutline_id,
                        il.m_rmaline_id,
                        il.pricelimit,
                        il.processed                              AS c_invoiceline_processed,
                        il.ref_invoiceline_id,
                        il.rramt,
                        il.rrstartdate,
                        il.s_resourceassignment_id,
                        il.user1_id                               AS c_invoiceline_user1_id,
                        il.user2_id                               AS c_invoiceline_user2_id,
                        uomt.ad_org_id                            AS c_uom_ad_org_id,
                        uom.costingprecision,
                        uomt.description                          AS c_uom_description,
                        uomt.isactive                             AS c_uom_isactive,
                        uom.isdefault                             AS c_uom_isdefault,
                        uomt.name                                 AS c_uom_name,
                        uom.stdprecision,
                        uom.uomtype,
                        uom.x12de355,
                        NULL                                      AS c_invoice_ad_org_id,
                        NULL                                      AS c_invoice_ad_orgtrx_id,
                        NULL                                      AS c_invoice_ad_user_id,
                        NULL                                      AS c_invoice_c_activity_id,
                        NULL                                      AS c_invoice_c_bpartner_id,
                        NULL                                      AS c_bpartner_location_id,
                        NULL                                      AS c_invoice_c_campaign_id,
                        NULL                                      AS c_invoice_c_charge_id,
                        NULL                                      AS c_conversiontype_id,
                        NULL                                      AS c_currency_id,
                        NULL                                      AS c_doctype_id,
                        NULL                                      AS c_doctypetarget_id,
                        NULL                                      AS c_dunninglevel_id,
                        NULL                                      AS c_invoice_chargeamt,
                        NULL                                      AS c_order_id,
                        NULL                                      AS c_payment_id,
                        NULL                                      AS c_paymentterm_id,
                        NULL                                      AS c_invoice_c_project_id,
                        NULL                                      AS c_invoice_created,
                        NULL                                      AS c_invoice_createdby,
                        NULL                                      AS dateacct,
                        NULL                                      AS dateinvoiced,
                        NULL                                      AS dateordered,
                        NULL                                      AS dateprinted,
                        NULL                                      AS c_invoice_description,
                        NULL                                      AS docaction,
                        NULL                                      AS docstatus,
                        NULL                                      AS documentno,
                        NULL                                      AS dunninggrace,
                        NULL                                      AS generateto,
                        NULL                                      AS grandtotal,
                        NULL                                      AS invoicecollectiontype,
                        NULL                                      AS c_invoice_isactive,
                        NULL                                      AS isapproved,
                        NULL                                      AS isdiscountprinted,
                        NULL                                      AS isindispute,
                        NULL                                      AS ispaid,
                        NULL                                      AS ispayschedulevalid,
                        NULL                                      AS c_invoice_isprinted,
                        NULL                                      AS c_invoice_isselfservice,
                        NULL                                      AS issotrx,
                        NULL                                      AS c_invoice_istaxincluded,
                        NULL                                      AS istransferred,
                        NULL                                      AS m_pricelist_id,
                        NULL                                      AS m_rma_id,
                        NULL                                      AS paymentrule,
                        NULL                                      AS poreference,
                        NULL                                      AS posted,
                        NULL                                      AS processedon,
                        NULL                                      AS processing,
                        NULL                                      AS ref_invoice_id,
                        NULL                                      AS reversal_id,
                        NULL                                      AS salesrep_id,
                        NULL                                      AS sendemail,
                        NULL                                      AS totallines,
                        NULL                                      AS c_invoice_updated,
                        NULL                                      AS c_invoice_updatedby,
                        NULL                                      AS c_invoice_user1_id,
                        NULL                                      AS c_invoice_user2_id,
                        tt.ad_org_id                              AS c_tax_ad_org_id,
                        t.ad_rule_id,
                        t.c_country_id,
                        t.c_region_id,
                        t.c_taxcategory_id                        AS c_tax_c_taxcategory_id,
                        tt.description                            AS c_tax_description,
                        tt.isactive                               AS c_tax_isactive,
                        t.isdefault                               AS c_tax_isdefault,
                        t.isdocumentlevel,
                        t.issalestax,
                        t.issummary                               AS c_tax_issummary,
                        t.istaxexempt,
                        tt.name                                   AS c_tax_name,
                        t.parent_tax_id,
                        t.rate,
                        t.requirestaxcertificate,
                        t.sopotype,
                        t.to_country_id,
                        t.to_region_id,
                        t.validfrom,
                        pt.ad_org_id                              AS m_product_ad_org_id,
                        p.classification,
                        p.copyfrom                                AS m_product_copyfrom,
                        pt.created                                AS m_product_created,
                        pt.createdby                              AS m_product_createdby,
                        p.c_revenuerecognition_id,
                        p.c_subscriptiontype_id,
                        p.c_taxcategory_id                        AS m_product_c_taxcategory_id,
                        p.descriptionurl,
                        p.discontinued,
                        p.discontinuedat,
                        p.group1,
                        p.group2,
                        p.guaranteedays,
                        p.guaranteedaysmin,
                        p.help,
                        pt.isactive                               AS m_product_isactive,
                        p.isbom,
                        p.isdropship,
                        p.isexcludeautodelivery,
                        p.isinvoiceprintdetails,
                        p.ispicklistprintdetails,
                        p.ispurchased,
                        p.isselfservice                           AS m_product_isselfservice,
                        p.issold,
                        p.isstocked,
                        p.issummary                               AS m_product_issummary,
                        p.isverified,
                        p.iswebstorefeatured,
                        p.lowlevel,
                        p.m_attributeset_id                       AS m_product_m_attributeset_id,
                        p.m_attributesetinstance_id               AS m_product_m_asi_id,
                        p.m_freightcategory_id,
                        p.m_locator_id,
                        p.m_product_category_id                   AS m_product_m_prod_category_id,
                        p.processing                              AS m_product_processing,
                        p.producttype,
                        p.r_mailtext_id,
                        p.salesrep_id                             AS m_product_salesrep_id,
                        p.s_expensetype_id,
                        p.shelfdepth,
                        p.shelfheight,
                        p.shelfwidth,
                        p.s_resource_id                           AS m_product_s_resource_id,
                        p.unitsperpack,
                        p.unitsperpallet,
                        p.updated                                 AS m_product_updated,
                        p.updatedby                               AS m_product_updatedby,
                        p.versionno,
                        p.volume,
                        p.weight,
                        NULL                                      AS c_charge_ad_org_id,
                        NULL                                      AS c_charge_c_bpartner_id,
                        NULL                                      AS c_chargetype_id,
                        NULL                                      AS c_charge_chargeamt,
                        NULL                                      AS c_charge_c_taxcategory_id,
                        NULL                                      AS c_charge_description,
                        NULL                                      AS c_charge_isactive,
                        NULL                                      AS issamecurrency,
                        NULL                                      AS issametax,
                        NULL                                      AS c_charge_istaxincluded,
                        NULL                                      AS c_bp_product_ad_org_id,
                        NULL                                      AS c_bp_product_c_bpartner_id,
                        NULL                                      AS c_bp_product_created,
                        NULL                                      AS c_bp_product_createdby,
                        NULL                                      AS c_bp_product_description,
                        NULL                                      AS c_bp_product_isactive,
                        NULL                                      AS ismanufacturer,
                        NULL                                      AS manufacturer,
                        NULL                                      AS qualityrating,
                        NULL                                      AS shelflifemindays,
                        NULL                                      AS shelflifeminpct,
                        NULL                                      AS c_bp_product_updated,
                        NULL                                      AS c_bp_product_updatedby,
                        NULL                                      AS vendorcategory,
                        NULL                                      AS s_rassignment_ad_org_id,
                        NULL                                      AS assigndatefrom,
                        NULL                                      AS assigndateto,
                        NULL                                      AS s_rassignment_created,
                        NULL                                      AS s_rassignment_createby,
                        NULL                                      AS s_rassignment_isactive,
                        NULL                                      AS isconfirmed,
                        NULL                                      AS s_rassignment_name,
                        NULL                                      AS s_rassignment_qty,
                        NULL                                      AS s_rassignment_s_resource_id,
                        NULL                                      AS s_rassignment_updated,
                        NULL                                      AS s_rassignment_updatedby,
                        asi.ad_org_id                             AS m_asi_ad_org_id,
                        asi.created                               AS m_asi_created,
                        asi.createdby                             AS m_asi_createdby,
                        asi.description                           AS m_asi_description,
                        asi.isactive                              AS m_asi_isactive,
                        asi.updated                               AS m_asi_updated,
                        asi.updatedby                             AS m_asi_updatedby 
                    FROM pp_product_bom b 
                        JOIN c_invoiceline il 
                        ON b.m_product_id = il.m_product_id 
                        JOIN m_product bp 
                        ON bp.m_product_id = il.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.isinvoiceprintdetails = 'Y' 
                        JOIN pp_product_bomline bl 
                        ON bl.pp_product_bom_id = b.pp_product_bom_id 
                        JOIN m_product p 
                        ON bl.m_product_id = p.m_product_id 
                        JOIN c_uom uom 
                        ON p.c_uom_id = uom.c_uom_id 
                        JOIN c_uom_trl uomt 
                        ON p.c_uom_id = uomt.c_uom_id 
                        JOIN m_product_trl pt 
                        ON bl.m_product_id = pt.m_product_id AND uomt.ad_language = pt.ad_language 
                        LEFT JOIN c_tax t 
                        ON il.c_tax_id = t.c_tax_id 
                        LEFT JOIN c_tax_trl tt 
                        ON il.c_tax_id = tt.c_tax_id AND uomt.ad_language = tt.ad_language 
                        LEFT JOIN m_attributesetinstance asi 
                        ON il.m_attributesetinstance_id = asi.m_attributesetinstance_id) 
        UNION   SELECT il.ad_client_id,
                    il.ad_org_id,
                    il.isactive,
                    il.created,
                    il.createdby,
                    il.updated,
                    il.updatedby,
                    l.ad_language,
                    il.c_invoice_id,
                    il.c_invoiceline_id,
                    NULL            AS c_tax_id,
                    NULL            AS taxamt,
                    NULL            AS linetotalamt,
                    NULL            AS taxindicator,
                    il.line,
                    NULL            AS m_product_id,
                    NULL            AS qtyinvoiced,
                    NULL            AS qtyentered,
                    NULL            AS uomsymbol,
                    il.description  AS name,
                    NULL            AS description,
                    NULL            AS documentnote,
                    NULL            AS upc,
                    NULL            AS sku,
                    NULL            AS productvalue,
                    NULL            AS resourcedescription,
                    NULL            AS pricelist,
                    NULL            AS priceenteredlist,
                    NULL            AS discount,
                    NULL            AS priceactual,
                    NULL            AS priceentered,
                    NULL            AS linenetamt,
                    NULL            AS m_attributesetinstance_id,
                    NULL            AS m_attributeset_id,
                    NULL            AS serno,
                    NULL            AS lot,
                    NULL            AS m_lot_id,
                    NULL            AS guaranteedate,
                    NULL            AS productdescription,
                    NULL            AS imageurl,
                    NULL            AS c_campaign_id,
                    NULL            AS c_project_id,
                    NULL            AS c_activity_id,
                    NULL            AS c_projectphase_id,
                    NULL            AS c_projecttask_id,
                    il.ad_orgtrx_id AS c_invoiceline_ad_orgtrx_id,
                    il.a_processed,
                    il.c_charge_id,
                    il.c_orderline_id,
                    il.c_uom_id,
                    il.isdescription,
                    il.isprinted    AS c_invoiceline_isprinted,
                    il.m_inoutline_id,
                    il.m_rmaline_id,
                    il.pricelimit,
                    il.processed    AS c_invoiceline_processed,
                    il.ref_invoiceline_id,
                    il.rramt,
                    il.rrstartdate,
                    il.s_resourceassignment_id,
                    il.user1_id     AS c_invoiceline_user1_id,
                    il.user2_id     AS c_invoiceline_user2_id,
                    NULL            AS c_uom_ad_org_id,
                    NULL            AS costingprecision,
                    NULL            AS c_uom_description,
                    NULL            AS c_uom_isactive,
                    NULL            AS c_uom_isdefault,
                    NULL            AS c_uom_name,
                    NULL            AS stdprecision,
                    NULL            AS uomtype,
                    NULL            AS x12de355,
                    NULL            AS c_invoice_ad_org_id,
                    NULL            AS c_invoice_ad_orgtrx_id,
                    NULL            AS c_invoice_ad_user_id,
                    NULL            AS c_invoice_c_activity_id,
                    NULL            AS c_invoice_c_bpartner_id,
                    NULL            AS c_bpartner_location_id,
                    NULL            AS c_invoice_c_campaign_id,
                    NULL            AS c_invoice_c_charge_id,
                    NULL            AS c_conversiontype_id,
                    NULL            AS c_currency_id,
                    NULL            AS c_doctype_id,
                    NULL            AS c_doctypetarget_id,
                    NULL            AS c_dunninglevel_id,
                    NULL            AS c_invoice_chargeamt,
                    NULL            AS c_order_id,
                    NULL            AS c_payment_id,
                    NULL            AS c_paymentterm_id,
                    NULL            AS c_invoice_c_project_id,
                    NULL            AS c_invoice_created,
                    NULL            AS c_invoice_createdby,
                    NULL            AS dateacct,
                    NULL            AS dateinvoiced,
                    NULL            AS dateordered,
                    NULL            AS dateprinted,
                    NULL            AS c_invoice_description,
                    NULL            AS docaction,
                    NULL            AS docstatus,
                    NULL            AS documentno,
                    NULL            AS dunninggrace,
                    NULL            AS generateto,
                    NULL            AS grandtotal,
                    NULL            AS invoicecollectiontype,
                    NULL            AS c_invoice_isactive,
                    NULL            AS isapproved,
                    NULL            AS isdiscountprinted,
                    NULL            AS isindispute,
                    NULL            AS ispaid,
                    NULL            AS ispayschedulevalid,
                    NULL            AS c_invoice_isprinted,
                    NULL            AS c_invoice_isselfservice,
                    NULL            AS issotrx,
                    NULL            AS c_invoice_istaxincluded,
                    NULL            AS istransferred,
                    NULL            AS m_pricelist_id,
                    NULL            AS m_rma_id,
                    NULL            AS paymentrule,
                    NULL            AS poreference,
                    NULL            AS posted,
                    NULL            AS processedon,
                    NULL            AS processing,
                    NULL            AS ref_invoice_id,
                    NULL            AS reversal_id,
                    NULL            AS salesrep_id,
                    NULL            AS sendemail,
                    NULL            AS totallines,
                    NULL            AS c_invoice_updated,
                    NULL            AS c_invoice_updatedby,
                    NULL            AS c_invoice_user1_id,
                    NULL            AS c_invoice_user2_id,
                    NULL            AS c_tax_ad_org_id,
                    NULL            AS ad_rule_id,
                    NULL            AS c_country_id,
                    NULL            AS c_region_id,
                    NULL            AS c_tax_c_taxcategory_id,
                    NULL            AS c_tax_description,
                    NULL            AS c_tax_isactive,
                    NULL            AS c_tax_isdefault,
                    NULL            AS isdocumentlevel,
                    NULL            AS issalestax,
                    NULL            AS c_tax_issummary,
                    NULL            AS istaxexempt,
                    NULL            AS c_tax_name,
                    NULL            AS parent_tax_id,
                    NULL            AS rate,
                    NULL            AS requirestaxcertificate,
                    NULL            AS sopotype,
                    NULL            AS to_country_id,
                    NULL            AS to_region_id,
                    NULL            AS validfrom,
                    NULL            AS m_product_ad_org_id,
                    NULL            AS classification,
                    NULL            AS m_product_copyfrom,
                    NULL            AS m_product_created,
                    NULL            AS m_product_createdby,
                    NULL            AS c_revenuerecognition_id,
                    NULL            AS c_subscriptiontype_id,
                    NULL            AS m_product_c_taxcategory_id,
                    NULL            AS descriptionurl,
                    NULL            AS discontinued,
                    NULL            AS discontinuedat,
                    NULL            AS group1,
                    NULL            AS group2,
                    NULL            AS guaranteedays,
                    NULL            AS guaranteedaysmin,
                    NULL            AS help,
                    NULL            AS m_product_isactive,
                    NULL            AS isbom,
                    NULL            AS isdropship,
                    NULL            AS isexcludeautodelivery,
                    NULL            AS isinvoiceprintdetails,
                    NULL            AS ispicklistprintdetails,
                    NULL            AS ispurchased,
                    NULL            AS m_product_isselfservice,
                    NULL            AS issold,
                    NULL            AS isstocked,
                    NULL            AS m_product_issummary,
                    NULL            AS isverified,
                    NULL            AS iswebstorefeatured,
                    NULL            AS lowlevel,
                    NULL            AS m_product_m_attributeset_id,
                    NULL            AS m_product_m_asi_id,
                    NULL            AS m_freightcategory_id,
                    NULL            AS m_locator_id,
                    NULL            AS m_product_m_prod_category_id,
                    NULL            AS m_product_processing,
                    NULL            AS producttype,
                    NULL            AS r_mailtext_id,
                    NULL            AS m_product_salesrep_id,
                    NULL            AS s_expensetype_id,
                    NULL            AS shelfdepth,
                    NULL            AS shelfheight,
                    NULL            AS shelfwidth,
                    NULL            AS m_product_s_resource_id,
                    NULL            AS unitsperpack,
                    NULL            AS unitsperpallet,
                    NULL            AS m_product_updated,
                    NULL            AS m_product_updatedby,
                    NULL            AS versionno,
                    NULL            AS volume,
                    NULL            AS weight,
                    NULL            AS c_charge_ad_org_id,
                    NULL            AS c_charge_c_bpartner_id,
                    NULL            AS c_chargetype_id,
                    NULL            AS c_charge_chargeamt,
                    NULL            AS c_charge_c_taxcategory_id,
                    NULL            AS c_charge_description,
                    NULL            AS c_charge_isactive,
                    NULL            AS issamecurrency,
                    NULL            AS issametax,
                    NULL            AS c_charge_istaxincluded,
                    NULL            AS c_bp_product_ad_org_id,
                    NULL            AS c_bp_product_c_bpartner_id,
                    NULL            AS c_bp_product_created,
                    NULL            AS c_bp_product_createdby,
                    NULL            AS c_bp_product_description,
                    NULL            AS c_bp_product_isactive,
                    NULL            AS ismanufacturer,
                    NULL            AS manufacturer,
                    NULL            AS qualityrating,
                    NULL            AS shelflifemindays,
                    NULL            AS shelflifeminpct,
                    NULL            AS c_bp_product_updated,
                    NULL            AS c_bp_product_updatedby,
                    NULL            AS vendorcategory,
                    NULL            AS s_rassignment_ad_org_id,
                    NULL            AS assigndatefrom,
                    NULL            AS assigndateto,
                    NULL            AS s_rassignment_created,
                    NULL            AS s_rassignment_createby,
                    NULL            AS s_rassignment_isactive,
                    NULL            AS isconfirmed,
                    NULL            AS s_rassignment_name,
                    NULL            AS s_rassignment_qty,
                    NULL            AS s_rassignment_s_resource_id,
                    NULL            AS s_rassignment_updated,
                    NULL            AS s_rassignment_updatedby,
                    NULL            AS m_asi_ad_org_id,
                    NULL            AS m_asi_created,
                    NULL            AS m_asi_createdby,
                    NULL            AS m_asi_description,
                    NULL            AS m_asi_isactive,
                    NULL            AS m_asi_updated,
                    NULL            AS m_asi_updatedby 
                FROM c_invoiceline il,
                    ad_language l 
                WHERE il.c_uom_id IS NULL AND l.isbaselanguage = 'N' AND l.issystemlanguage = 'Y') 
    UNION   SELECT i.ad_client_id,
                i.ad_org_id,
                i.isactive,
                i.created,
                i.createdby,
                i.updated,
                i.updatedby,
                l.ad_language,
                i.c_invoice_id,
                NULL            AS c_invoiceline_id,
                NULL            AS c_tax_id,
                NULL            AS taxamt,
                NULL            AS linetotalamt,
                NULL            AS taxindicator,
                999998          AS line,
                NULL            AS m_product_id,
                NULL            AS qtyinvoiced,
                NULL            AS qtyentered,
                NULL            AS uomsymbol,
                NULL            AS name,
                NULL            AS description,
                NULL            AS documentnote,
                NULL            AS upc,
                NULL            AS sku,
                NULL            AS productvalue,
                NULL            AS resourcedescription,
                NULL            AS pricelist,
                NULL            AS priceenteredlist,
                NULL            AS discount,
                NULL            AS priceactual,
                NULL            AS priceentered,
                NULL            AS linenetamt,
                NULL            AS m_attributesetinstance_id,
                NULL            AS m_attributeset_id,
                NULL            AS serno,
                NULL            AS lot,
                NULL            AS m_lot_id,
                NULL            AS guaranteedate,
                NULL            AS productdescription,
                NULL            AS imageurl,
                NULL            AS c_campaign_id,
                NULL            AS c_project_id,
                NULL            AS c_activity_id,
                NULL            AS c_projectphase_id,
                NULL            AS c_projecttask_id,
                NULL            AS c_invoiceline_ad_orgtrx_id,
                NULL            AS a_processed,
                NULL            AS c_charge_id,
                NULL            AS c_orderline_id,
                NULL            AS c_uom_id,
                NULL            AS isdescription,
                NULL            AS c_invoiceline_isprinted,
                NULL            AS m_inoutline_id,
                NULL            AS m_rmaline_id,
                NULL            AS pricelimit,
                NULL            AS c_invoiceline_processed,
                NULL            AS ref_invoiceline_id,
                NULL            AS rramt,
                NULL            AS rrstartdate,
                NULL            AS s_resourceassignment_id,
                NULL            AS c_invoiceline_user1_id,
                NULL            AS c_invoiceline_user2_id,
                NULL            AS c_uom_ad_org_id,
                NULL            AS costingprecision,
                NULL            AS c_uom_description,
                NULL            AS c_uom_isactive,
                NULL            AS c_uom_isdefault,
                NULL            AS c_uom_name,
                NULL            AS stdprecision,
                NULL            AS uomtype,
                NULL            AS x12de355,
                i.ad_org_id     AS c_invoice_ad_org_id,
                i.ad_orgtrx_id  AS c_invoice_ad_orgtrx_id,
                i.ad_user_id    AS c_invoice_ad_user_id,
                i.c_activity_id AS c_invoice_c_activity_id,
                i.c_bpartner_id AS c_invoice_c_bpartner_id,
                i.c_bpartner_location_id,
                i.c_campaign_id AS c_invoice_c_campaign_id,
                i.c_charge_id   AS c_invoice_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.c_dunninglevel_id,
                i.chargeamt     AS c_invoice_chargeamt,
                i.c_order_id,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_project_id  AS c_invoice_c_project_id,
                i.created       AS c_invoice_created,
                i.createdby     AS c_invoice_createdby,
                i.dateacct,
                i.dateinvoiced,
                i.dateordered,
                i.dateprinted,
                i.description   AS c_invoice_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dunninggrace,
                i.generateto,
                i.grandtotal,
                i.invoicecollectiontype,
                i.isactive      AS c_invoice_isactive,
                i.isapproved,
                i.isdiscountprinted,
                i.isindispute,
                i.ispaid,
                i.ispayschedulevalid,
                i.isprinted     AS c_invoice_isprinted,
                i.isselfservice AS c_invoice_isselfservice,
                i.issotrx,
                i.istaxincluded AS c_invoice_istaxincluded,
                i.istransferred,
                i.m_pricelist_id,
                i.m_rma_id,
                i.paymentrule,
                i.poreference,
                i.posted,
                i.processedon,
                i.processing,
                i.ref_invoice_id,
                i.reversal_id,
                i.salesrep_id,
                i.sendemail,
                i.totallines,
                i.updated       AS c_invoice_updated,
                i.updatedby     AS c_invoice_updatedby,
                i.user1_id      AS c_invoice_user1_id,
                i.user2_id      AS c_invoice_user2_id,
                NULL            AS c_tax_ad_org_id,
                NULL            AS ad_rule_id,
                NULL            AS c_country_id,
                NULL            AS c_region_id,
                NULL            AS c_tax_c_taxcategory_id,
                NULL            AS c_tax_description,
                NULL            AS c_tax_isactive,
                NULL            AS c_tax_isdefault,
                NULL            AS isdocumentlevel,
                NULL            AS issalestax,
                NULL            AS c_tax_issummary,
                NULL            AS istaxexempt,
                NULL            AS c_tax_name,
                NULL            AS parent_tax_id,
                NULL            AS rate,
                NULL            AS requirestaxcertificate,
                NULL            AS sopotype,
                NULL            AS to_country_id,
                NULL            AS to_region_id,
                NULL            AS validfrom,
                NULL            AS m_product_ad_org_id,
                NULL            AS classification,
                NULL            AS m_product_copyfrom,
                NULL            AS m_product_created,
                NULL            AS m_product_createdby,
                NULL            AS c_revenuerecognition_id,
                NULL            AS c_subscriptiontype_id,
                NULL            AS m_product_c_taxcategory_id,
                NULL            AS descriptionurl,
                NULL            AS discontinued,
                NULL            AS discontinuedat,
                NULL            AS group1,
                NULL            AS group2,
                NULL            AS guaranteedays,
                NULL            AS guaranteedaysmin,
                NULL            AS help,
                NULL            AS m_product_isactive,
                NULL            AS isbom,
                NULL            AS isdropship,
                NULL            AS isexcludeautodelivery,
                NULL            AS isinvoiceprintdetails,
                NULL            AS ispicklistprintdetails,
                NULL            AS ispurchased,
                NULL            AS m_product_isselfservice,
                NULL            AS issold,
                NULL            AS isstocked,
                NULL            AS m_product_issummary,
                NULL            AS isverified,
                NULL            AS iswebstorefeatured,
                NULL            AS lowlevel,
                NULL            AS m_product_m_attributeset_id,
                NULL            AS m_product_m_asi_id,
                NULL            AS m_freightcategory_id,
                NULL            AS m_locator_id,
                NULL            AS m_product_m_prod_category_id,
                NULL            AS m_product_processing,
                NULL            AS producttype,
                NULL            AS r_mailtext_id,
                NULL            AS m_product_salesrep_id,
                NULL            AS s_expensetype_id,
                NULL            AS shelfdepth,
                NULL            AS shelfheight,
                NULL            AS shelfwidth,
                NULL            AS m_product_s_resource_id,
                NULL            AS unitsperpack,
                NULL            AS unitsperpallet,
                NULL            AS m_product_updated,
                NULL            AS m_product_updatedby,
                NULL            AS versionno,
                NULL            AS volume,
                NULL            AS weight,
                NULL            AS c_charge_ad_org_id,
                NULL            AS c_charge_c_bpartner_id,
                NULL            AS c_chargetype_id,
                NULL            AS c_charge_chargeamt,
                NULL            AS c_charge_c_taxcategory_id,
                NULL            AS c_charge_description,
                NULL            AS c_charge_isactive,
                NULL            AS issamecurrency,
                NULL            AS issametax,
                NULL            AS c_charge_istaxincluded,
                NULL            AS c_bp_product_ad_org_id,
                NULL            AS c_bp_product_c_bpartner_id,
                NULL            AS c_bp_product_created,
                NULL            AS c_bp_product_createdby,
                NULL            AS c_bp_product_description,
                NULL            AS c_bp_product_isactive,
                NULL            AS ismanufacturer,
                NULL            AS manufacturer,
                NULL            AS qualityrating,
                NULL            AS shelflifemindays,
                NULL            AS shelflifeminpct,
                NULL            AS c_bp_product_updated,
                NULL            AS c_bp_product_updatedby,
                NULL            AS vendorcategory,
                NULL            AS s_rassignment_ad_org_id,
                NULL            AS assigndatefrom,
                NULL            AS assigndateto,
                NULL            AS s_rassignment_created,
                NULL            AS s_rassignment_createby,
                NULL            AS s_rassignment_isactive,
                NULL            AS isconfirmed,
                NULL            AS s_rassignment_name,
                NULL            AS s_rassignment_qty,
                NULL            AS s_rassignment_s_resource_id,
                NULL            AS s_rassignment_updated,
                NULL            AS s_rassignment_updatedby,
                NULL            AS m_asi_ad_org_id,
                NULL            AS m_asi_created,
                NULL            AS m_asi_createdby,
                NULL            AS m_asi_description,
                NULL            AS m_asi_isactive,
                NULL            AS m_asi_updated,
                NULL            AS m_asi_updatedby 
            FROM c_invoice i,
                ad_language l 
            WHERE l.isbaselanguage = 'N' AND l.issystemlanguage = 'Y'
            )
UNION 
SELECT it.ad_client_id,
    it.ad_org_id,
    it.isactive,
    it.created,
    it.createdby,
    it.updated,
    it.updatedby,
    tt.ad_language,
    it.c_invoice_id,
    NULL    AS c_invoiceline_id,
    it.c_tax_id,
    NULL    AS taxamt,
    NULL    AS linetotalamt,
    tt.taxindicator,
    999999  AS line,
    NULL    AS m_product_id,
    NULL    AS qtyinvoiced,
    NULL    AS qtyentered,
    NULL    AS uomsymbol,
    tt.name,
    NULL    AS description,
    NULL    AS documentnote,
    NULL    AS upc,
    NULL    AS sku,
    NULL    AS productvalue,
    NULL    AS resourcedescription,
    NULL    AS pricelist,
    NULL    AS priceenteredlist,
    NULL    AS discount,
    CASE WHEN it.istaxincluded = 'Y' THEN it.taxamt ELSE it.taxbaseamt END AS priceactual,
    CASE WHEN it.istaxincluded = 'Y' THEN it.taxamt ELSE it.taxbaseamt END AS priceentered,
    CASE WHEN it.istaxincluded = 'Y' THEN NULL ELSE it.taxamt END AS linenetamt,
    NULL    AS m_attributesetinstance_id,
    NULL    AS m_attributeset_id,
    NULL    AS serno,
    NULL    AS lot,
    NULL    AS m_lot_id,
    NULL    AS guaranteedate,
    NULL    AS productdescription,
    NULL    AS imageurl,
    NULL    AS c_campaign_id,
    NULL    AS c_project_id,
    NULL    AS c_activity_id,
    NULL    AS c_projectphase_id,
    NULL    AS c_projecttask_id,
    NULL    AS c_invoiceline_ad_orgtrx_id,
    NULL    AS a_processed,
    NULL    AS c_charge_id,
    NULL    AS c_orderline_id,
    NULL    AS c_uom_id,
    NULL    AS isdescription,
    NULL    AS c_invoiceline_isprinted,
    NULL    AS m_inoutline_id,
    NULL    AS m_rmaline_id,
    NULL    AS pricelimit,
    NULL    AS c_invoiceline_processed,
    NULL    AS ref_invoiceline_id,
    NULL    AS rramt,
    NULL    AS rrstartdate,
    NULL    AS s_resourceassignment_id,
    NULL    AS c_invoiceline_user1_id,
    NULL    AS c_invoiceline_user2_id,
    NULL    AS c_uom_ad_org_id,
    NULL    AS costingprecision,
    NULL    AS c_uom_description,
    NULL    AS c_uom_isactive,
    NULL    AS c_uom_isdefault,
    NULL    AS c_uom_name,
    NULL    AS stdprecision,
    NULL    AS uomtype,
    NULL    AS x12de355,
    NULL    AS c_invoice_ad_org_id,
    NULL    AS c_invoice_ad_orgtrx_id,
    NULL    AS c_invoice_ad_user_id,
    NULL    AS c_invoice_c_activity_id,
    NULL    AS c_invoice_c_bpartner_id,
    NULL    AS c_bpartner_location_id,
    NULL    AS c_invoice_c_campaign_id,
    NULL    AS c_invoice_c_charge_id,
    NULL    AS c_conversiontype_id,
    NULL    AS c_currency_id,
    NULL    AS c_doctype_id,
    NULL    AS c_doctypetarget_id,
    NULL    AS c_dunninglevel_id,
    NULL    AS c_invoice_chargeamt,
    NULL    AS c_order_id,
    NULL    AS c_payment_id,
    NULL    AS c_paymentterm_id,
    NULL    AS c_invoice_c_project_id,
    NULL    AS c_invoice_created,
    NULL    AS c_invoice_createdby,
    NULL    AS dateacct,
    NULL    AS dateinvoiced,
    NULL    AS dateordered,
    NULL    AS dateprinted,
    NULL    AS c_invoice_description,
    NULL    AS docaction,
    NULL    AS docstatus,
    NULL    AS documentno,
    NULL    AS dunninggrace,
    NULL    AS generateto,
    NULL    AS grandtotal,
    NULL    AS invoicecollectiontype,
    NULL    AS c_invoice_isactive,
    NULL    AS isapproved,
    NULL    AS isdiscountprinted,
    NULL    AS isindispute,
    NULL    AS ispaid,
    NULL    AS ispayschedulevalid,
    NULL    AS c_invoice_isprinted,
    NULL    AS c_invoice_isselfservice,
    NULL    AS issotrx,
    NULL    AS c_invoice_istaxincluded,
    NULL    AS istransferred,
    NULL    AS m_pricelist_id,
    NULL    AS m_rma_id,
    NULL    AS paymentrule,
    NULL    AS poreference,
    NULL    AS posted,
    NULL    AS processedon,
    NULL    AS processing,
    NULL    AS ref_invoice_id,
    NULL    AS reversal_id,
    NULL    AS salesrep_id,
    NULL    AS sendemail,
    NULL    AS totallines,
    NULL    AS c_invoice_updated,
    NULL    AS c_invoice_updatedby,
    NULL    AS c_invoice_user1_id,
    NULL    AS c_invoice_user2_id,
    NULL    AS c_tax_ad_org_id,
    NULL    AS ad_rule_id,
    NULL    AS c_country_id,
    NULL    AS c_region_id,
    NULL    AS c_tax_c_taxcategory_id,
    NULL    AS c_tax_description,
    NULL    AS c_tax_isactive,
    NULL    AS c_tax_isdefault,
    NULL    AS isdocumentlevel,
    NULL    AS issalestax,
    NULL    AS c_tax_issummary,
    NULL    AS istaxexempt,
    NULL    AS c_tax_name,
    NULL    AS parent_tax_id,
    NULL    AS rate,
    NULL    AS requirestaxcertificate,
    NULL    AS sopotype,
    NULL    AS to_country_id,
    NULL    AS to_region_id,
    NULL    AS validfrom,
    NULL    AS m_product_ad_org_id,
    NULL    AS classification,
    NULL    AS m_product_copyfrom,
    NULL    AS m_product_created,
    NULL    AS m_product_createdby,
    NULL    AS c_revenuerecognition_id,
    NULL    AS c_subscriptiontype_id,
    NULL    AS m_product_c_taxcategory_id,
    NULL    AS descriptionurl,
    NULL    AS discontinued,
    NULL    AS discontinuedat,
    NULL    AS group1,
    NULL    AS group2,
    NULL    AS guaranteedays,
    NULL    AS guaranteedaysmin,
    NULL    AS help,
    NULL    AS m_product_isactive,
    NULL    AS isbom,
    NULL    AS isdropship,
    NULL    AS isexcludeautodelivery,
    NULL    AS isinvoiceprintdetails,
    NULL    AS ispicklistprintdetails,
    NULL    AS ispurchased,
    NULL    AS m_product_isselfservice,
    NULL    AS issold,
    NULL    AS isstocked,
    NULL    AS m_product_issummary,
    NULL    AS isverified,
    NULL    AS iswebstorefeatured,
    NULL    AS lowlevel,
    NULL    AS m_product_m_attributeset_id,
    NULL    AS m_product_m_asi_id,
    NULL    AS m_freightcategory_id,
    NULL    AS m_locator_id,
    NULL    AS m_product_m_prod_category_id,
    NULL    AS m_product_processing,
    NULL    AS producttype,
    NULL    AS r_mailtext_id,
    NULL    AS m_product_salesrep_id,
    NULL    AS s_expensetype_id,
    NULL    AS shelfdepth,
    NULL    AS shelfheight,
    NULL    AS shelfwidth,
    NULL    AS m_product_s_resource_id,
    NULL    AS unitsperpack,
    NULL    AS unitsperpallet,
    NULL    AS m_product_updated,
    NULL    AS m_product_updatedby,
    NULL    AS versionno,
    NULL    AS volume,
    NULL    AS weight,
    NULL    AS c_charge_ad_org_id,
    NULL    AS c_charge_c_bpartner_id,
    NULL    AS c_chargetype_id,
    NULL    AS c_charge_chargeamt,
    NULL    AS c_charge_c_taxcategory_id,
    NULL    AS c_charge_description,
    NULL    AS c_charge_isactive,
    NULL    AS issamecurrency,
    NULL    AS issametax,
    NULL    AS c_charge_istaxincluded,
    NULL    AS c_bp_product_ad_org_id,
    NULL    AS c_bp_product_c_bpartner_id,
    NULL    AS c_bp_product_created,
    NULL    AS c_bp_product_createdby,
    NULL    AS c_bp_product_description,
    NULL    AS c_bp_product_isactive,
    NULL    AS ismanufacturer,
    NULL    AS manufacturer,
    NULL    AS qualityrating,
    NULL    AS shelflifemindays,
    NULL    AS shelflifeminpct,
    NULL    AS c_bp_product_updated,
    NULL    AS c_bp_product_updatedby,
    NULL    AS vendorcategory,
    NULL    AS s_rassignment_ad_org_id,
    NULL    AS assigndatefrom,
    NULL    AS assigndateto,
    NULL    AS s_rassignment_created,
    NULL    AS s_rassignment_createby,
    NULL    AS s_rassignment_isactive,
    NULL    AS isconfirmed,
    NULL    AS s_rassignment_name,
    NULL    AS s_rassignment_qty,
    NULL    AS s_rassignment_s_resource_id,
    NULL    AS s_rassignment_updated,
    NULL    AS s_rassignment_updatedby,
    NULL    AS m_asi_ad_org_id,
    NULL    AS m_asi_created,
    NULL    AS m_asi_createdby,
    NULL    AS m_asi_description,
    NULL    AS m_asi_isactive,
    NULL    AS m_asi_updated,
    NULL    AS m_asi_updatedby 
FROM c_invoicetax it 
        JOIN c_tax_trl tt 
        ON it.c_tax_id = tt.c_tax_id
;

CREATE OR REPLACE VIEW c_invoice_v AS 
SELECT i.c_invoice_id,
    i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.docaction,
    i.processing,
    i.processed,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_order_id,
    i.description,
    i.isapproved,
    i.istransferred,
    i.salesrep_id,
    i.dateinvoiced,
    i.dateprinted,
    i.dateacct,
    i.c_bpartner_id,
    i.c_bpartner_location_id,
    i.ad_user_id,
    i.poreference,
    i.dateordered,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.paymentrule,
    i.c_paymentterm_id,
    i.c_charge_id,
    i.m_pricelist_id,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.isprinted,
    i.isdiscountprinted,
    i.ispaid,
    i.isindispute,
    i.ispayschedulevalid,
    NULL                                                   AS c_invoicepayschedule_id,
    i.invoicecollectiontype,
    i.dunninggrace,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.chargeamt * (-1) ELSE i.chargeamt END                                                AS chargeamt,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.totallines * (-1) ELSE i.totallines END                                                AS totallines,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.grandtotal * (-1) ELSE i.grandtotal END                                                AS grandtotal,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN (-1.0) ELSE 1.0 END                                                AS multiplier,
    CASE WHEN charat(d.docbasetype, 2) = 'P' THEN (-1.0) ELSE 1.0 END                                                AS multiplierap,
    d.docbasetype,
    paymenttermduedate(i.c_paymentterm_id, i.dateinvoiced) AS duedate,
    i.ad_orgtrx_id,
    i.c_payment_id,
    i.isselfservice,
    i.posted,
    i.processedon,
    i.reversal_id 
FROM c_invoice i 
        JOIN c_doctype d 
        ON i.c_doctype_id = d.c_doctype_id 
WHERE i.ispayschedulevalid <> 'Y' 
UNION 
SELECT i.c_invoice_id,
    i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.docaction,
    i.processing,
    i.processed,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_order_id,
    i.description,
    i.isapproved,
    i.istransferred,
    i.salesrep_id,
    i.dateinvoiced,
    i.dateprinted,
    i.dateacct,
    i.c_bpartner_id,
    i.c_bpartner_location_id,
    i.ad_user_id,
    i.poreference,
    i.dateordered,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.paymentrule,
    i.c_paymentterm_id,
    i.c_charge_id,
    i.m_pricelist_id,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.isprinted,
    i.isdiscountprinted,
    i.ispaid,
    i.isindispute,
    i.ispayschedulevalid,
    ips.c_invoicepayschedule_id,
    i.invoicecollectiontype,
    i.dunninggrace,
    NULL    AS chargeamt,
    NULL    AS totallines,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN ips.dueamt * (-1) ELSE ips.dueamt END AS grandtotal,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN (-1) ELSE 1 END AS multiplier,
    CASE WHEN charat(d.docbasetype, 2) = 'P' THEN (-1) ELSE 1 END AS multiplierap,
    d.docbasetype,
    ips.duedate,
    i.ad_orgtrx_id,
    i.c_payment_id,
    i.isselfservice,
    i.posted,
    i.processedon,
    i.reversal_id 
FROM c_invoice i 
        JOIN c_doctype d 
        ON i.c_doctype_id = d.c_doctype_id 
        JOIN c_invoicepayschedule ips 
        ON i.c_invoice_id = ips.c_invoice_id 
WHERE i.ispayschedulevalid = 'Y' AND ips.isvalid = 'Y'
;

DROP VIEW c_order_header_v;

CREATE OR REPLACE VIEW c_order_header_v AS 
SELECT o.ad_client_id,
    o.ad_org_id,
    o.isactive,
    o.created,
    o.createdby,
    o.updated,
    o.updatedby,
    'en_US'::character varying       AS ad_language,
    o.c_order_id,
    o.issotrx,
    o.documentno,
    o.docstatus,
    o.c_doctype_id,
    o.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    o.m_warehouse_id,
    wh.c_location_id                 AS warehouse_location_id,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    o.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    o.dateordered,
    o.datepromised,
    bpg.greeting                     AS bpgreeting,
    bp.name,
    bp.name2,
    bpcg.greeting                    AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    l.postal || l.postal_add         AS postal,
    bp.referenceno,
    o.bill_bpartner_id,
    o.bill_location_id,
    o.bill_user_id,
    bbp.value                        AS bill_bpvalue,
    bbp.taxid                        AS bill_bptaxid,
    bbp.name                         AS bill_name,
    bbp.name2                        AS bill_name2,
    bbpc.title                       AS bill_title,
    bbpc.phone                       AS bill_phone,
    NULLIF(bbpc.name, bbp.name)      AS bill_contactname,
    bbpl.c_location_id               AS bill_c_location_id,
    o.description,
    o.poreference,
    o.c_currency_id,
    pt.name                          AS paymentterm,
    pt.documentnote                  AS paymenttermnote,
    o.c_charge_id,
    o.chargeamt,
    o.totallines,
    o.grandtotal,
    o.grandtotal                     AS amtinwords,
    o.m_pricelist_id,
    o.istaxincluded,
    o.volume,
    o.weight,
    o.c_campaign_id,
    o.c_project_id,
    o.c_activity_id,
    o.m_shipper_id,
    o.deliveryrule,
    o.deliveryviarule,
    o.priorityrule,
    o.invoicerule,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    o.ad_orgtrx_id,
    o.ad_user_id,
    o.amountrefunded,
    o.amounttendered,
    o.c_bpartner_location_id,
    o.c_cashline_id,
    o.c_cashplanline_id,
    o.c_conversiontype_id,
    o.c_doctypetarget_id,
    o.copyfrom,
    o.c_payment_id,
    o.c_paymentterm_id,
    o.c_pos_id,
    o.dateacct,
    o.dateprinted,
    o.docaction,
    o.dropship_bpartner_id,
    o.dropship_location_id,
    o.dropship_user_id,
    o.freightamt,
    o.freightcostrule,
    o.isapproved,
    o.iscreditapproved,
    o.isdelivered,
    o.isdiscountprinted,
    o.isdropship,
    o.isinvoiced,
    o.ispayschedulevalid,
    o.isprinted,
    o.isselected,
    o.isselfservice,
    o.istransferred,
    o.link_order_id,
    o.m_freightcategory_id,
    o.ordertype,
    o.pay_bpartner_id,
    o.pay_location_id,
    o.paymentrule,
    o.posted,
    o.processed,
    o.processedon,
    o.promotioncode,
    o.ref_order_id,
    o.sendemail,
    o.user1_id,
    o.user2_id,
    wh.ad_org_id                     AS m_warehouse_ad_org_id,
    wh.description                   AS m_warehouse_description,
    wh.isactive                      AS m_warehouse_isactive,
    wh.isdisallownegativeinv,
    wh.isintransit,
    wh.m_warehousesource_id,
    wh.name                          AS m_warehouse_name,
    wh.replenishmentclass,
    wh.separator,
    wh.value                         AS m_warehouse_value,
    pt.ad_org_id                     AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.description                   AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    pt.isactive                      AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS m_paymentterm_value,
    bp.acqusitioncost                AS bp_acqusitioncost,
    bp.actuallifetimevalue           AS bp_actuallifetimevalue,
    bp.ad_language                   AS bp_ad_language,
    bp.ad_orgbp_id                   AS bp_ad_orgbp_id,
    bp.ad_org_id                     AS bp_ad_org_id,
    bp.bpartner_parent_id            AS bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS bp_c_bp_group_id,
    bp.c_dunning_id                  AS bp_c_dunning_id,
    bp.c_greeting_id                 AS bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS bp_c_paymentterm_id,
    bp.created                       AS bp_created,
    bp.createdby                     AS bp_createdby,
    bp.c_taxgroup_id                 AS bp_c_taxgroup_id,
    bp.deliveryrule                  AS bp_deliveryrule,
    bp.deliveryviarule               AS bp_deliveryviarule,
    bp.description                   AS bp_description,
    bp.dunninggrace                  AS bp_dunninggrace,
    bp.firstsale                     AS bp_firstsale,
    bp.flatdiscount                  AS bp_flatdiscount,
    bp.freightcostrule               AS bp_freightcostrule,
    bp.invoicerule                   AS bp_invoicerule,
    bp.isactive                      AS bp_isactive,
    bp.iscustomer                    AS bp_iscustomer,
    bp.isdiscountprinted             AS bp_isdiscountprinted,
    bp.isemployee                    AS bp_isemployee,
    bp.ismanufacturer                AS bp_ismanufacturer,
    bp.isonetime                     AS bp_isonetime,
    bp.ispotaxexempt                 AS bp_ispotaxexempt,
    bp.isprospect                    AS bp_isprospect,
    bp.issalesrep                    AS bp_issalesrep,
    bp.issummary                     AS bp_issummary,
    bp.istaxexempt                   AS bp_istaxexempt,
    bp.isvendor                      AS bp_isvendor,
    bp.logo_id                       AS bp_logo_id,
    bp.m_discountschema_id           AS bp_m_discountschema_id,
    bp.m_pricelist_id                AS bp_m_pricelist_id,
    bp.numberemployees               AS bp_numberemployees,
    bp.paymentrule                   AS bp_paymentrule,
    bp.paymentrulepo                 AS bp_paymentrulepo,
    bp.po_discountschema_id          AS bp_po_discountschema_id,
    bp.po_paymentterm_id             AS bp_po_paymentterm_id,
    bp.po_pricelist_id               AS bp_po_pricelist_id,
    bp.poreference                   AS bp_poreference,
    bp.potentiallifetimevalue        AS bp_potentiallifetimevalue,
    bp.rating                        AS bp_rating,
    bp.salesrep_id                   AS bp_salesrep_id,
    bp.salesvolume                   AS bp_salesvolume,
    bp.sendemail                     AS bp_sendemail,
    bp.shareofcustomer               AS bp_shareofcustomer,
    bp.shelflifeminpct               AS bp_shelflifeminpct,
    bp.so_creditlimit                AS bp_so_creditlimit,
    bp.socreditstatus                AS bp_socreditstatus,
    bp.so_creditused                 AS bp_so_creditused,
    bp.so_description                AS bp_so_description,
    bp.totalopenbalance              AS bp_totalopenbalance,
    bp.updated                       AS bp_updated,
    bp.updatedby                     AS bp_updatedby,
    bp.url                           AS bp_url,
    bpg.ad_org_id                    AS c_greeting_ad_org_id,
    bpg.isactive                     AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpg.name                         AS c_greeting_name,
    bpl.ad_org_id                    AS bp_location_ad_org_id,
    bpl.c_bpartner_id                AS bp_location_c_bpartner_id,
    bpl.created                      AS bp_location_created,
    bpl.createdby                    AS bp_location_createdby,
    bpl.c_salesregion_id             AS bp_location_c_salesregion_id,
    bpl.fax                          AS bp_location_fax,
    bpl.isactive                     AS bp_location_isactive,
    bpl.isbillto                     AS bp_location_isbillto,
    bpl.isdn                         AS bp_location_isdn,
    bpl.ispayfrom                    AS bp_location_ispayfrom,
    bpl.isremitto                    AS bp_location_isremitto,
    bpl.isshipto                     AS bp_location_isshipto,
    bpl.name                         AS bp_location_name,
    bpl.phone                        AS bp_location_phone,
    bpl.phone2                       AS bp_location_phone2,
    bpl.updated                      AS bp_location_updated,
    bpl.updatedby                    AS bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcg.ad_org_id                   AS c_user_greeting_ad_org_id,
    bpcg.isactive                    AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcg.name                        AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bp_acqusitioncost,
    ubp.actuallifetimevalue          AS salesrep_bp_actuallifetimeval,
    ubp.ad_language                  AS salesrep_bp_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bp_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bp_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bp_bpartner_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_dunning_id                 AS salesrep_bp_c_dunning_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_c_invoicesched_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bp_created,
    ubp.createdby                    AS salesrep_bp_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bp_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bp_deliveryviarule,
    ubp.description                  AS salesrep_bp_description,
    ubp.dunninggrace                 AS salesrep_bp_dunninggrace,
    ubp.duns                         AS salesrep_bp_duns,
    ubp.firstsale                    AS salesrep_bp_firstsale,
    ubp.flatdiscount                 AS salesrep_bp_flatdiscount,
    ubp.freightcostrule              AS salesrep_bp_freightcostrule,
    ubp.invoicerule                  AS salesrep_bp_invoicerule,
    ubp.isactive                     AS salesrep_bp_isactive,
    ubp.iscustomer                   AS salesrep_bp_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bp_isdiscountprinted,
    ubp.isemployee                   AS salesrep_bp_isemployee,
    ubp.ismanufacturer               AS salesrep_bp_ismanufacturer,
    ubp.isonetime                    AS salesrep_bp_isonetime,
    ubp.ispotaxexempt                AS salesrep_bp_ispotaxexempt,
    ubp.isprospect                   AS salesrep_bp_isprospect,
    ubp.issalesrep                   AS salesrep_bp_issalesrep,
    ubp.issummary                    AS salesrep_bp_issummary,
    ubp.istaxexempt                  AS salesrep_bp_istaxexempt,
    ubp.isvendor                     AS salesrep_bp_isvendor,
    ubp.logo_id                      AS salesrep_bp_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_m_discountschm_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bp_naics,
    ubp.name2                        AS salesrep_bp_name2,
    ubp.numberemployees              AS salesrep_bp_numberemployees,
    ubp.paymentrule                  AS salesrep_bp_paymentrule,
    ubp.paymentrulepo                AS salesrep_bp_paymentrulepo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountschm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bp_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bp_potentiallifetime,
    ubp.rating                       AS salesrep_bp_rating,
    ubp.referenceno                  AS salesrep_bp_referenceno,
    ubp.salesrep_id                  AS salesrep_bp_salesrep_id,
    ubp.salesvolume                  AS salesrep_bp_salesvolume,
    ubp.sendemail                    AS salesrep_bp_sendemail,
    ubp.shareofcustomer              AS salesrep_bp_shareofcustomer,
    ubp.shelflifeminpct              AS salesrep_bp_shelflifeminpct,
    ubp.so_creditlimit               AS salesrep_bp_so_creditlimit,
    ubp.socreditstatus               AS salesrep_bp_socreditstatus,
    ubp.so_creditused                AS salesrep_bp_so_creditused,
    ubp.so_description               AS salesrep_bp_so_description,
    ubp.taxid                        AS salesrep_bp_taxid,
    ubp.totalopenbalance             AS salesrep_bp_totalopenbalance,
    ubp.updated                      AS salesrep_bp_updated,
    ubp.updatedby                    AS salesrep_bp_updatedby,
    ubp.url                          AS salesrep_bp_url,
    ubp.value                        AS salesrep_bp_value,
    bbp.acqusitioncost               AS bill_bp_acqusitioncost,
    bbp.actuallifetimevalue          AS bill_bp_actuallifetimevalue,
    bbp.ad_language                  AS bill_bp_ad_language,
    bbp.ad_orgbp_id                  AS bill_bp_ad_orgbp_id,
    bbp.ad_org_id                    AS bill_bp_ad_org_id,
    bbp.bpartner_parent_id           AS bill_bp_bpartner_parent_id,
    bbp.c_bp_group_id                AS bill_bp_c_bp_group_id,
    bbp.c_dunning_id                 AS bill_bp_c_dunning_id,
    bbp.c_greeting_id                AS bill_bp_c_greeting_id,
    bbp.c_invoiceschedule_id         AS bill_bp_c_invoiceschedule_id,
    bbp.c_paymentterm_id             AS bill_bp_c_paymentterm_id,
    bbp.created                      AS bill_bp_created,
    bbp.createdby                    AS bill_bp_createdby,
    bbp.c_taxgroup_id                AS bill_bp_c_taxgroup_id,
    bbp.deliveryrule                 AS bill_bp_deliveryrule,
    bbp.deliveryviarule              AS bill_bp_deliveryviarule,
    bbp.description                  AS bill_bp_description,
    bbp.dunninggrace                 AS bill_bp_dunninggrace,
    bbp.duns                         AS bill_bp_duns,
    bbp.firstsale                    AS bill_bp_firstsale,
    bbp.flatdiscount                 AS bill_bp_flatdiscount,
    bbp.freightcostrule              AS bill_bp_freightcostrule,
    bbp.invoicerule                  AS bill_bp_invoicerule,
    bbp.isactive                     AS bill_bp_isactive,
    bbp.iscustomer                   AS bill_bp_iscustomer,
    bbp.isdiscountprinted            AS bill_bp_isdiscountprinted,
    bbp.isemployee                   AS bill_bp_isemployee,
    bbp.ismanufacturer               AS bill_bp_ismanufacturer,
    bbp.isonetime                    AS bill_bp_isonetime,
    bbp.ispotaxexempt                AS bill_bp_ispotaxexempt,
    bbp.isprospect                   AS bill_bp_isprospect,
    bbp.issalesrep                   AS bill_bp_issalesrep,
    bbp.issummary                    AS bill_bp_issummary,
    bbp.istaxexempt                  AS bill_bp_istaxexempt,
    bbp.isvendor                     AS bill_bp_isvendor,
    bbp.logo_id                      AS bill_bp_logo_id,
    bbp.m_discountschema_id          AS bill_bp_m_discountschema_id,
    bbp.m_pricelist_id               AS bill_bp_m_pricelist_id,
    bbp.naics                        AS bill_bp_naics,
    bbp.numberemployees              AS bill_bp_numberemployees,
    bbp.paymentrule                  AS bill_bp_paymentrule,
    bbp.paymentrulepo                AS bill_bp_paymentrulepo,
    bbp.po_discountschema_id         AS bill_bp_po_discountschema_id,
    bbp.po_paymentterm_id            AS bill_bp_po_paymentterm_id,
    bbp.po_pricelist_id              AS bill_bp_po_pricelist_id,
    bbp.poreference                  AS bill_bp_poreference,
    bbp.potentiallifetimevalue       AS bill_bp_potentiallifetimevalue,
    bbp.rating                       AS bill_bp_rating,
    bbp.referenceno                  AS bill_bp_referenceno,
    bbp.salesrep_id                  AS bill_bp_salesrep_id,
    bbp.salesvolume                  AS bill_bp_salesvolume,
    bbp.sendemail                    AS bill_bp_sendemail,
    bbp.shareofcustomer              AS bill_bp_shareofcustomer,
    bbp.shelflifeminpct              AS bill_bp_shelflifeminpct,
    bbp.so_creditlimit               AS bill_bp_so_creditlimit,
    bbp.socreditstatus               AS bill_bp_socreditstatus,
    bbp.so_creditused                AS bill_bp_so_creditused,
    bbp.so_description               AS bill_bp_so_description,
    bbp.totalopenbalance             AS bill_bp_totalopenbalance,
    bbp.updated                      AS bill_bp_updated,
    bbp.updatedby                    AS bill_bp_updatedby,
    bbp.url                          AS bill_bp_url,
    bbpl.ad_org_id                   AS bill_bp_location_ad_org_id,
    bbpl.c_bpartner_id               AS bill_bp_location_c_bpartner_id,
    bbpl.created                     AS bill_bp_location_created,
    bbpl.createdby                   AS bill_bp_location_createdby,
    bbpl.c_salesregion_id            AS bill_bp_location_c_salesreg_id,
    bbpl.fax                         AS bill_bp_location_fax,
    bbpl.isactive                    AS bill_bp_location_isactive,
    bbpl.isbillto                    AS bill_bp_location_isbillto,
    bbpl.isdn                        AS bill_bp_location_isdn,
    bbpl.ispayfrom                   AS bill_bp_location_ispayfrom,
    bbpl.isremitto                   AS bill_bp_location_isremitto,
    bbpl.isshipto                    AS bill_bp_location_isshipto,
    bbpl.name                        AS bill_bp_location_name,
    bbpl.phone                       AS bill_bp_location_phone,
    bbpl.phone2                      AS bill_bp_location_phone2,
    bbpl.updated                     AS bill_bp_location_updated,
    bbpl.updatedby                   AS bill_bp_location_updatedby,
    bbpc.ad_org_id                   AS bill_user_ad_org_id,
    bbpc.ad_orgtrx_id                AS bill_user_ad_orgtrx_id,
    bbpc.birthday                    AS bill_user_ad_birthday,
    bbpc.c_bpartner_id               AS bill_user_c_bpartner_id,
    bbpc.c_bpartner_location_id      AS bill_user_c_bp_location_id,
    bbpc.c_greeting_id               AS bill_user_c_greeting_id,
    bbpc.comments                    AS bill_user_comments,
    bbpc.created                     AS bill_user_created,
    bbpc.createdby                   AS bill_user_createdby,
    bbpc.description                 AS bill_user_description,
    bbpc.email                       AS bill_user_email,
    bbpc.fax                         AS bill_user_fax,
    bbpc.isactive                    AS bill_user_isactive,
    bbpc.lastcontact                 AS bill_user_lastcontact,
    bbpc.lastresult                  AS bill_user_lastresult,
    bbpc.phone2                      AS bill_user_phone2,
    bbpc.supervisor_id               AS bill_user_supervisor_id,
    bbpc.updated                     AS bill_user_updated,
    bbpc.updatedby                   AS bill_user_updatedby,
    bbpc.value                       AS bill_user_value 
FROM c_order o 
        JOIN c_doctype dt 
        ON o.c_doctype_id = dt.c_doctype_id 
        JOIN m_warehouse wh 
        ON o.m_warehouse_id = wh.m_warehouse_id 
        JOIN c_paymentterm pt 
        ON o.c_paymentterm_id = pt.c_paymentterm_id 
        JOIN c_bpartner bp 
        ON o.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        JOIN c_bpartner_location bpl 
        ON o.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON o.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        JOIN ad_orginfo oi 
        ON o.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON o.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON o.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id 
        JOIN c_bpartner bbp 
        ON o.bill_bpartner_id = bbp.c_bpartner_id 
        JOIN c_bpartner_location bbpl 
        ON o.bill_location_id = bbpl.c_bpartner_location_id 
        LEFT JOIN ad_user bbpc 
        ON o.bill_user_id = bbpc.ad_user_id
;

DROP VIEW c_order_header_vt;

CREATE OR REPLACE VIEW c_order_header_vt AS 
SELECT o.ad_client_id,
    o.ad_org_id,
    o.isactive,
    o.created,
    o.createdby,
    o.updated,
    o.updatedby,
    dt.ad_language,
    o.c_order_id,
    o.issotrx,
    o.documentno,
    o.docstatus,
    o.c_doctype_id,
    o.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    o.m_warehouse_id,
    wh.c_location_id                 AS warehouse_location_id,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    o.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    o.dateordered,
    o.datepromised,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    l.postal || l.postal_add         AS postal,
    bp.referenceno,
    o.bill_bpartner_id,
    o.bill_location_id,
    o.bill_user_id,
    bbp.value                        AS bill_bpvalue,
    bbp.taxid                        AS bill_bptaxid,
    bbp.name                         AS bill_name,
    bbp.name2                        AS bill_name2,
    bbpc.title                       AS bill_title,
    bbpc.phone                       AS bill_phone,
    NULLIF(bbpc.name, bbp.name)      AS bill_contactname,
    bbpl.c_location_id               AS bill_c_location_id,
    o.description,
    o.poreference,
    o.c_currency_id,
    ptt.name                         AS paymentterm,
    ptt.documentnote                 AS paymenttermnote,
    o.c_charge_id,
    o.chargeamt,
    o.totallines,
    o.grandtotal,
    o.grandtotal                     AS amtinwords,
    o.m_pricelist_id,
    o.istaxincluded,
    o.volume,
    o.weight,
    o.c_campaign_id,
    o.c_project_id,
    o.c_activity_id,
    o.m_shipper_id,
    o.deliveryrule,
    o.deliveryviarule,
    o.priorityrule,
    o.invoicerule,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    o.ad_orgtrx_id,
    o.ad_user_id,
    o.amountrefunded,
    o.amounttendered,
    o.c_bpartner_location_id,
    o.c_cashline_id,
    o.c_cashplanline_id,
    o.c_conversiontype_id,
    o.c_doctypetarget_id,
    o.copyfrom,
    o.c_payment_id,
    o.c_paymentterm_id,
    o.c_pos_id,
    o.dateacct,
    o.dateprinted,
    o.docaction,
    o.dropship_bpartner_id,
    o.dropship_location_id,
    o.dropship_user_id,
    o.freightamt,
    o.freightcostrule,
    o.isapproved,
    o.iscreditapproved,
    o.isdelivered,
    o.isdiscountprinted,
    o.isdropship,
    o.isinvoiced,
    o.ispayschedulevalid,
    o.isprinted,
    o.isselected,
    o.isselfservice,
    o.istransferred,
    o.link_order_id,
    o.m_freightcategory_id,
    o.ordertype,
    o.pay_bpartner_id,
    o.pay_location_id,
    o.paymentrule,
    o.posted,
    o.processed,
    o.processedon,
    o.promotioncode,
    o.ref_order_id,
    o.sendemail,
    o.user1_id,
    o.user2_id,
    wh.ad_org_id                     AS m_warehouse_ad_org_id,
    wh.description                   AS m_warehouse_description,
    wh.isactive                      AS m_warehouse_isactive,
    wh.isdisallownegativeinv,
    wh.isintransit,
    wh.m_warehousesource_id,
    wh.name                          AS m_warehouse_name,
    wh.replenishmentclass,
    wh.separator,
    wh.value                         AS m_warehouse_value,
    ptt.ad_org_id                    AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    ptt.description                  AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    ptt.isactive                     AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS m_paymentterm_value,
    bp.acqusitioncost                AS bp_acqusitioncost,
    bp.actuallifetimevalue           AS bp_actuallifetimevalue,
    bp.ad_language                   AS bp_ad_language,
    bp.ad_orgbp_id                   AS bp_ad_orgbp_id,
    bp.ad_org_id                     AS bp_ad_org_id,
    bp.bpartner_parent_id            AS bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS bp_c_bp_group_id,
    bp.c_dunning_id                  AS bp_c_dunning_id,
    bp.c_greeting_id                 AS bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS bp_c_paymentterm_id,
    bp.created                       AS bp_created,
    bp.createdby                     AS bp_createdby,
    bp.c_taxgroup_id                 AS bp_c_taxgroup_id,
    bp.deliveryrule                  AS bp_deliveryrule,
    bp.deliveryviarule               AS bp_deliveryviarule,
    bp.description                   AS bp_description,
    bp.dunninggrace                  AS bp_dunninggrace,
    bp.firstsale                     AS bp_firstsale,
    bp.flatdiscount                  AS bp_flatdiscount,
    bp.freightcostrule               AS bp_freightcostrule,
    bp.invoicerule                   AS bp_invoicerule,
    bp.isactive                      AS bp_isactive,
    bp.iscustomer                    AS bp_iscustomer,
    bp.isdiscountprinted             AS bp_isdiscountprinted,
    bp.isemployee                    AS bp_isemployee,
    bp.ismanufacturer                AS bp_ismanufacturer,
    bp.isonetime                     AS bp_isonetime,
    bp.ispotaxexempt                 AS bp_ispotaxexempt,
    bp.isprospect                    AS bp_isprospect,
    bp.issalesrep                    AS bp_issalesrep,
    bp.issummary                     AS bp_issummary,
    bp.istaxexempt                   AS bp_istaxexempt,
    bp.isvendor                      AS bp_isvendor,
    bp.logo_id                       AS bp_logo_id,
    bp.m_discountschema_id           AS bp_m_discountschema_id,
    bp.m_pricelist_id                AS bp_m_pricelist_id,
    bp.numberemployees               AS bp_numberemployees,
    bp.paymentrule                   AS bp_paymentrule,
    bp.paymentrulepo                 AS bp_paymentrulepo,
    bp.po_discountschema_id          AS bp_po_discountschema_id,
    bp.po_paymentterm_id             AS bp_po_paymentterm_id,
    bp.po_pricelist_id               AS bp_po_pricelist_id,
    bp.poreference                   AS bp_poreference,
    bp.potentiallifetimevalue        AS bp_potentiallifetimevalue,
    bp.rating                        AS bp_rating,
    bp.salesrep_id                   AS bp_salesrep_id,
    bp.salesvolume                   AS bp_salesvolume,
    bp.sendemail                     AS bp_sendemail,
    bp.shareofcustomer               AS bp_shareofcustomer,
    bp.shelflifeminpct               AS bp_shelflifeminpct,
    bp.so_creditlimit                AS bp_so_creditlimit,
    bp.socreditstatus                AS bp_socreditstatus,
    bp.so_creditused                 AS bp_so_creditused,
    bp.so_description                AS bp_so_description,
    bp.totalopenbalance              AS bp_totalopenbalance,
    bp.updated                       AS bp_updated,
    bp.updatedby                     AS bp_updatedby,
    bp.url                           AS bp_url,
    bpgt.ad_org_id                   AS c_greeting_ad_org_id,
    bpgt.isactive                    AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                        AS c_greeting_name,
    bpl.ad_org_id                    AS bp_location_ad_org_id,
    bpl.c_bpartner_id                AS bp_location_c_bpartner_id,
    bpl.created                      AS bp_location_created,
    bpl.createdby                    AS bp_location_createdby,
    bpl.c_salesregion_id             AS bp_location_c_salesregion_id,
    bpl.fax                          AS bp_location_fax,
    bpl.isactive                     AS bp_location_isactive,
    bpl.isbillto                     AS bp_location_isbillto,
    bpl.isdn                         AS bp_location_isdn,
    bpl.ispayfrom                    AS bp_location_ispayfrom,
    bpl.isremitto                    AS bp_location_isremitto,
    bpl.isshipto                     AS bp_location_isshipto,
    bpl.name                         AS bp_location_name,
    bpl.phone                        AS bp_location_phone,
    bpl.phone2                       AS bp_location_phone2,
    bpl.updated                      AS bp_location_updated,
    bpl.updatedby                    AS bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.ad_org_id                  AS c_user_greeting_ad_org_id,
    bpcgt.isactive                   AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcgt.name                       AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bp_acqusitioncost,
    ubp.actuallifetimevalue          AS salesrep_bp_actuallifetimeval,
    ubp.ad_language                  AS salesrep_bp_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bp_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bp_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bp_bpartner_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_dunning_id                 AS salesrep_bp_c_dunning_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_c_invoicesched_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bp_created,
    ubp.createdby                    AS salesrep_bp_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bp_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bp_deliveryviarule,
    ubp.description                  AS salesrep_bp_description,
    ubp.dunninggrace                 AS salesrep_bp_dunninggrace,
    ubp.duns                         AS salesrep_bp_duns,
    ubp.firstsale                    AS salesrep_bp_firstsale,
    ubp.flatdiscount                 AS salesrep_bp_flatdiscount,
    ubp.freightcostrule              AS salesrep_bp_freightcostrule,
    ubp.invoicerule                  AS salesrep_bp_invoicerule,
    ubp.isactive                     AS salesrep_bp_isactive,
    ubp.iscustomer                   AS salesrep_bp_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bp_isdiscountprinted,
    ubp.isemployee                   AS salesrep_bp_isemployee,
    ubp.ismanufacturer               AS salesrep_bp_ismanufacturer,
    ubp.isonetime                    AS salesrep_bp_isonetime,
    ubp.ispotaxexempt                AS salesrep_bp_ispotaxexempt,
    ubp.isprospect                   AS salesrep_bp_isprospect,
    ubp.issalesrep                   AS salesrep_bp_issalesrep,
    ubp.issummary                    AS salesrep_bp_issummary,
    ubp.istaxexempt                  AS salesrep_bp_istaxexempt,
    ubp.isvendor                     AS salesrep_bp_isvendor,
    ubp.logo_id                      AS salesrep_bp_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_m_discountschm_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bp_naics,
    ubp.name2                        AS salesrep_bp_name2,
    ubp.numberemployees              AS salesrep_bp_numberemployees,
    ubp.paymentrule                  AS salesrep_bp_paymentrule,
    ubp.paymentrulepo                AS salesrep_bp_paymentrulepo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountsch_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bp_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bp_potentiallifetime,
    ubp.rating                       AS salesrep_bp_rating,
    ubp.referenceno                  AS salesrep_bp_referenceno,
    ubp.salesrep_id                  AS salesrep_bp_salesrep_id,
    ubp.salesvolume                  AS salesrep_bp_salesvolume,
    ubp.sendemail                    AS salesrep_bp_sendemail,
    ubp.shareofcustomer              AS salesrep_bp_shareofcustomer,
    ubp.shelflifeminpct              AS salesrep_bp_shelflifeminpct,
    ubp.so_creditlimit               AS salesrep_bp_so_creditlimit,
    ubp.socreditstatus               AS salesrep_bp_socreditstatus,
    ubp.so_creditused                AS salesrep_bp_so_creditused,
    ubp.so_description               AS salesrep_bp_so_description,
    ubp.taxid                        AS salesrep_bp_taxid,
    ubp.totalopenbalance             AS salesrep_bp_totalopenbalance,
    ubp.updated                      AS salesrep_bp_updated,
    ubp.updatedby                    AS salesrep_bp_updatedby,
    ubp.url                          AS salesrep_bp_url,
    ubp.value                        AS salesrep_bp_value,
    bbp.acqusitioncost               AS bill_bp_acqusitioncost,
    bbp.actuallifetimevalue          AS bill_bp_actuallifetimevalue,
    bbp.ad_language                  AS bill_bp_ad_language,
    bbp.ad_orgbp_id                  AS bill_bp_ad_orgbp_id,
    bbp.ad_org_id                    AS bill_bp_ad_org_id,
    bbp.bpartner_parent_id           AS bill_bp_bpartner_parent_id,
    bbp.c_bp_group_id                AS bill_bp_c_bp_group_id,
    bbp.c_dunning_id                 AS bill_bp_c_dunning_id,
    bbp.c_greeting_id                AS bill_bp_c_greeting_id,
    bbp.c_invoiceschedule_id         AS bill_bp_c_invoiceschedule_id,
    bbp.c_paymentterm_id             AS bill_bp_c_paymentterm_id,
    bbp.created                      AS bill_bp_created,
    bbp.createdby                    AS bill_bp_createdby,
    bbp.c_taxgroup_id                AS bill_bp_c_taxgroup_id,
    bbp.deliveryrule                 AS bill_bp_deliveryrule,
    bbp.deliveryviarule              AS bill_bp_deliveryviarule,
    bbp.description                  AS bill_bp_description,
    bbp.dunninggrace                 AS bill_bp_dunninggrace,
    bbp.duns                         AS bill_bp_duns,
    bbp.firstsale                    AS bill_bp_firstsale,
    bbp.flatdiscount                 AS bill_bp_flatdiscount,
    bbp.freightcostrule              AS bill_bp_freightcostrule,
    bbp.invoicerule                  AS bill_bp_invoicerule,
    bbp.isactive                     AS bill_bp_isactive,
    bbp.iscustomer                   AS bill_bp_iscustomer,
    bbp.isdiscountprinted            AS bill_bp_isdiscountprinted,
    bbp.isemployee                   AS bill_bp_isemployee,
    bbp.ismanufacturer               AS bill_bp_ismanufacturer,
    bbp.isonetime                    AS bill_bp_isonetime,
    bbp.ispotaxexempt                AS bill_bp_ispotaxexempt,
    bbp.isprospect                   AS bill_bp_isprospect,
    bbp.issalesrep                   AS bill_bp_issalesrep,
    bbp.issummary                    AS bill_bp_issummary,
    bbp.istaxexempt                  AS bill_bp_istaxexempt,
    bbp.isvendor                     AS bill_bp_isvendor,
    bbp.logo_id                      AS bill_bp_logo_id,
    bbp.m_discountschema_id          AS bill_bp_m_discountschema_id,
    bbp.m_pricelist_id               AS bill_bp_m_pricelist_id,
    bbp.naics                        AS bill_bp_naics,
    bbp.numberemployees              AS bill_bp_numberemployees,
    bbp.paymentrule                  AS bill_bp_paymentrule,
    bbp.paymentrulepo                AS bill_bp_paymentrulepo,
    bbp.po_discountschema_id         AS bill_bp_po_discountschema_id,
    bbp.po_paymentterm_id            AS bill_bp_po_paymentterm_id,
    bbp.po_pricelist_id              AS bill_bp_po_pricelist_id,
    bbp.poreference                  AS bill_bp_poreference,
    bbp.potentiallifetimevalue       AS bill_bp_potentiallifetimevalue,
    bbp.rating                       AS bill_bp_rating,
    bbp.referenceno                  AS bill_bp_referenceno,
    bbp.salesrep_id                  AS bill_bp_salesrep_id,
    bbp.salesvolume                  AS bill_bp_salesvolume,
    bbp.sendemail                    AS bill_bp_sendemail,
    bbp.shareofcustomer              AS bill_bp_shareofcustomer,
    bbp.shelflifeminpct              AS bill_bp_shelflifeminpct,
    bbp.so_creditlimit               AS bill_bp_so_creditlimit,
    bbp.socreditstatus               AS bill_bp_socreditstatus,
    bbp.so_creditused                AS bill_bp_so_creditused,
    bbp.so_description               AS bill_bp_so_description,
    bbp.totalopenbalance             AS bill_bp_totalopenbalance,
    bbp.updated                      AS bill_bp_updated,
    bbp.updatedby                    AS bill_bp_updatedby,
    bbp.url                          AS bill_bp_url,
    bbpl.ad_org_id                   AS bill_bp_location_ad_org_id,
    bbpl.c_bpartner_id               AS bill_bp_location_c_bpartner_id,
    bbpl.created                     AS bill_bp_location_created,
    bbpl.createdby                   AS bill_bp_location_createdby,
    bbpl.c_salesregion_id            AS bill_bp_location_c_salesreg_id,
    bbpl.fax                         AS bill_bp_location_fax,
    bbpl.isactive                    AS bill_bp_location_isactive,
    bbpl.isbillto                    AS bill_bp_location_isbillto,
    bbpl.isdn                        AS bill_bp_location_isdn,
    bbpl.ispayfrom                   AS bill_bp_location_ispayfrom,
    bbpl.isremitto                   AS bill_bp_location_isremitto,
    bbpl.isshipto                    AS bill_bp_location_isshipto,
    bbpl.name                        AS bill_bp_location_name,
    bbpl.phone                       AS bill_bp_location_phone,
    bbpl.phone2                      AS bill_bp_location_phone2,
    bbpl.updated                     AS bill_bp_location_updated,
    bbpl.updatedby                   AS bill_bp_location_updatedby,
    bbpc.ad_org_id                   AS bill_user_ad_org_id,
    bbpc.ad_orgtrx_id                AS bill_user_ad_orgtrx_id,
    bbpc.birthday                    AS bill_user_ad_birthday,
    bbpc.c_bpartner_id               AS bill_user_c_bpartner_id,
    bbpc.c_bpartner_location_id      AS bill_user_c_bp_location_id,
    bbpc.c_greeting_id               AS bill_user_c_greeting_id,
    bbpc.comments                    AS bill_user_comments,
    bbpc.created                     AS bill_user_created,
    bbpc.createdby                   AS bill_user_createdby,
    bbpc.description                 AS bill_user_description,
    bbpc.email                       AS bill_user_email,
    bbpc.fax                         AS bill_user_fax,
    bbpc.isactive                    AS bill_user_isactive,
    bbpc.lastcontact                 AS bill_user_lastcontact,
    bbpc.lastresult                  AS bill_user_lastresult,
    bbpc.phone2                      AS bill_user_phone2,
    bbpc.supervisor_id               AS bill_user_supervisor_id,
    bbpc.updated                     AS bill_user_updated,
    bbpc.updatedby                   AS bill_user_updatedby,
    bbpc.value                       AS bill_user_value 
FROM c_order o 
        JOIN c_doctype_trl dt 
        ON o.c_doctype_id = dt.c_doctype_id 
        JOIN m_warehouse wh 
        ON o.m_warehouse_id = wh.m_warehouse_id 
        JOIN c_paymentterm pt 
        ON o.c_paymentterm_id = pt.c_paymentterm_id 
        JOIN c_paymentterm_trl ptt 
        ON o.c_paymentterm_id = ptt.c_paymentterm_id AND dt.ad_language = ptt.ad_language 
        JOIN c_bpartner bp 
        ON o.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id AND dt.ad_language = bpgt.ad_language 
        JOIN c_bpartner_location bpl 
        ON o.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON o.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id AND dt.ad_language = bpcgt.ad_language 
        JOIN ad_orginfo oi 
        ON o.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON o.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_user u 
        ON o.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id 
        JOIN c_bpartner bbp 
        ON o.bill_bpartner_id = bbp.c_bpartner_id 
        JOIN c_bpartner_location bbpl 
        ON o.bill_location_id = bbpl.c_bpartner_location_id 
        LEFT JOIN ad_user bbpc 
        ON o.bill_user_id = bbpc.ad_user_id
;

DROP VIEW c_order_linetax_v;

CREATE OR REPLACE VIEW c_order_linetax_v AS 
    (
        (   SELECT ol.ad_client_id,
                ol.ad_org_id,
                ol.isactive,
                ol.created,
                ol.createdby,
                ol.updated,
                ol.updatedby,
                'en_US'                               AS ad_language,
                ol.c_order_id,
                ol.c_orderline_id,
                ol.c_tax_id,
                t.taxindicator,
                ol.c_bpartner_id,
                ol.c_bpartner_location_id,
                bp.name                               AS bpname,
                bpl.c_location_id,
                ol.line,
                p.m_product_id,
                po.vendorproductno,
                CASE WHEN ol.qtyordered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.qtyordered ELSE NULL END                               AS qtyordered,
                CASE WHEN ol.qtyentered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.qtyentered ELSE NULL END                               AS qtyentered,
                CASE WHEN ol.qtyentered <> 0 OR ol.m_product_id IS NOT NULL THEN uom.uomsymbol ELSE NULL END                               AS uomsymbol,
                COALESCE(c.name, (p.name || productattribute(ol.m_attributesetinstance_id)), ol.description)  AS name,
                CASE WHEN COALESCE(c.name, p.name) IS NOT NULL THEN ol.description ELSE NULL END                               AS description,
                p.documentnote,
                p.upc,
                p.sku,
                COALESCE(pp.vendorproductno, p.value) AS productvalue,
                ra.description                        AS resourcedescription,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist <> 0 THEN ol.pricelist ELSE NULL END                               AS pricelist,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist <> 0 AND ol.qtyentered <> 0 THEN ol.pricelist * ol.qtyordered / ol.qtyentered ELSE NULL END                               AS 
                priceenteredlist,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist > ol.priceactual AND ol.pricelist <> 0 THEN (ol.pricelist - ol.priceactual) / ol.pricelist * 100 ELSE NULL END                               
                AS discount,
                CASE WHEN ol.priceactual <> 0 OR ol.m_product_id IS NOT NULL THEN ol.priceactual ELSE NULL END                               AS priceactual,
                CASE WHEN ol.priceentered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.priceentered ELSE NULL END                               AS priceentered,
                CASE WHEN ol.linenetamt <> 0 OR ol.m_product_id IS NOT NULL THEN ol.linenetamt ELSE NULL END                               AS linenetamt,
                p.description                         AS productdescription,
                p.imageurl,
                ol.c_campaign_id,
                ol.c_project_id,
                ol.c_activity_id,
                ol.c_projectphase_id,
                ol.c_projecttask_id,
                ol.ad_orgtrx_id                       AS c_orderline_ad_orgtrx_id,
                ol.c_charge_id                        AS c_orderline_c_charge_id,
                ol.c_currency_id                      AS c_orderline_c_currency_id,
                ol.c_uom_id,
                ol.datedelivered,
                ol.dateinvoiced,
                ol.dateordered,
                ol.datepromised                       AS c_orderline_datepromised,
                ol.freightamt                         AS c_orderline_freightamt,
                ol.isdescription,
                ol.link_orderline_id,
                ol.m_promotion_id,
                ol.m_shipper_id                       AS c_orderline_m_shipper_id,
                ol.m_warehouse_id                     AS c_orderline_m_warehouse_id,
                ol.pricecost,
                ol.pricelimit,
                ol.processed                          AS c_orderline_processed,
                ol.qtydelivered,
                ol.qtyinvoiced,
                ol.qtylostsales,
                ol.qtyreserved,
                ol.ref_orderline_id,
                ol.rramt,
                ol.rrstartdate,
                ol.s_resourceassignment_id,
                ol.user1_id                           AS c_orderline_user1_id,
                ol.user2_id                           AS c_orderline_user2_id,
                uom.ad_org_id                         AS c_uom_ad_org_id,
                uom.costingprecision,
                uom.description                       AS c_uom_description,
                uom.isactive                          AS c_uom_isactive,
                uom.isdefault,
                uom.name                              AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                i.ad_org_id                           AS c_order_ad_org_id,
                i.ad_orgtrx_id                        AS c_order_ad_orgtrx_id,
                i.ad_user_id,
                i.amountrefunded,
                i.amounttendered,
                i.bill_bpartner_id,
                i.bill_location_id,
                i.bill_user_id,
                i.c_activity_id                       AS c_order_c_activity_id,
                i.c_bpartner_id                       AS c_order_c_bpartner_id,
                i.c_campaign_id                       AS c_order_c_campaign_id,
                i.c_cashline_id,
                i.c_cashplanline_id,
                i.c_charge_id                         AS c_order_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id                       AS c_order_c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.chargeamt,
                i.copyfrom,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_pos_id,
                i.c_project_id                        AS c_order_c_project_id,
                i.created                             AS c_order_created,
                i.createdby                           AS c_order_createdby,
                i.dateacct,
                i.dateprinted,
                i.datepromised                        AS c_order_datepromised,
                i.deliveryrule,
                i.deliveryviarule,
                i.description                         AS c_order_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dropship_bpartner_id,
                i.dropship_location_id,
                i.dropship_user_id,
                i.freightamt                          AS c_order_freightamt,
                i.freightcostrule,
                i.grandtotal,
                i.invoicerule,
                i.isactive                            AS c_order_isactive,
                i.isapproved,
                i.iscreditapproved,
                i.isdelivered,
                i.isdiscountprinted                   AS c_order_isdiscountprinted,
                i.isdropship                          AS c_order_isdropship,
                i.isinvoiced,
                i.ispayschedulevalid,
                i.isprinted,
                i.isselected,
                i.isselfservice                       AS c_order_isselfservice,
                i.issotrx,
                i.istaxincluded,
                i.istransferred,
                i.link_order_id,
                i.m_freightcategory_id                AS c_order_m_freightcategory_id,
                i.m_pricelist_id                      AS c_order_m_pricelist_id,
                i.m_shipper_id                        AS c_order_m_shipper_id,
                i.m_warehouse_id                      AS c_order_m_warehouse_id,
                i.ordertype,
                i.pay_bpartner_id,
                i.pay_location_id,
                i.paymentrule                         AS c_order_paymentrule,
                i.poreference,
                i.posted,
                i.priorityrule,
                i.processed                           AS c_order_processed,
                i.processedon,
                i.promotioncode,
                i.ref_order_id,
                i.salesrep_id,
                i.sendemail                           AS c_order_sendemail,
                i.totallines,
                i.updated                             AS c_order_updated,
                i.updatedby                           AS c_order_updatedby,
                i.user1_id                            AS c_order_user1_id,
                i.user2_id                            AS c_order_user2_id,
                i.volume                              AS c_order_volume,
                i.weight                              AS c_order_weight,
                p.ad_org_id                           AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                            AS m_product_copyfrom,
                p.created                             AS m_product_created,
                p.createdby                           AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id,
                p.c_uom_id                            AS m_product_c_uom_id,
                p.descriptionurl,
                p.discontinued                        AS m_product_discontinued,
                p.discontinuedat                      AS m_product_discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                p.isactive                            AS m_product_isactive,
                p.isbom,
                p.isdropship                          AS m_product_isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice                       AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                           AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id,
                p.m_attributesetinstance_id,
                p.m_freightcategory_id                AS m_product_m_freightcategory_id,
                p.m_locator_id,
                p.m_product_category_id               AS m_product_product_category_id,
                p.processing                          AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id                         AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                p.updated                             AS m_product_updated,
                p.updatedby                           AS m_product_updatedby,
                p.versionno,
                p.volume                              AS m_product_volume,
                p.weight                              AS m_product_weight,
                po.ad_org_id                          AS m_product_po_ad_org_id,
                po.c_bpartner_id                      AS m_product_po_c_bpartner_id,
                po.c_currency_id                      AS m_product_po_c_currency_id,
                po.costperorder,
                po.created                            AS m_product_po_created,
                po.createdby                          AS m_product_po_createdby,
                po.c_uom_id                           AS m_product_po_c_uom_id,
                po.deliverytime_actual,
                po.deliverytime_promised,
                po.discontinued                       AS m_product_po_discontinued,
                po.discontinuedat                     AS m_product_po_discontinuedat,
                po.isactive                           AS m_product_po_isactive,
                po.iscurrentvendor,
                po.manufacturer                       AS m_product_po_manufacturer,
                po.m_product_id                       AS m_product_po_m_product_id,
                po.order_min,
                po.order_pack,
                po.priceeffective,
                po.pricelastinv,
                po.pricelastpo,
                po.pricelist                          AS m_product_po_pricelist,
                po.pricepo,
                po.qualityrating                      AS m_product_po_qualityrating,
                po.royaltyamt,
                po.upc                                AS m_product_po_upc,
                po.updated                            AS m_product_po_updated,
                po.updatedby                          AS m_product_po_updatedby,
                po.vendorcategory                     AS m_product_po_vendorcategory,
                ra.ad_org_id                          AS s_resourceassignment_ad_org_id,
                ra.assigndatefrom,
                ra.assigndateto,
                ra.created                            AS s_resourceassignment_created,
                ra.createdby                          AS s_resourceassignment_createby,
                ra.isactive                           AS s_resourceassignment_isactive,
                ra.isconfirmed,
                ra.name                               AS s_resourceassignment_name,
                ra.qty                                AS s_resourceassignment_qty,
                ra.s_resource_id                      AS s_resourceassignment_s_resour,
                ra.updated                            AS s_resourceassignment_updated,
                ra.updatedby                          AS s_resourceassignment_updatedby,
                c.ad_org_id                           AS c_charge_c_org_id,
                c.c_bpartner_id                       AS c_charge_c_bpartner_id,
                c.c_chargetype_id,
                c.chargeamt                           AS c_charge_chargeamt,
                c.c_taxcategory_id                    AS c_charge_c_taxcategory_id,
                c.description                         AS c_charge_description,
                c.isactive                            AS c_charge_isactive,
                c.issamecurrency,
                c.issametax,
                c.istaxincluded                       AS c_charge_istaxincluded,
                pp.ad_org_id                          AS c_bpartner_product_ad_org_id,
                pp.c_bpartner_id                      AS c_bp_product_c_bpartner_id,
                pp.created                            AS c_bpartner_product_created,
                pp.createdby                          AS c_bpartner_product_createdby,
                pp.description                        AS c_bpartner_product_description,
                pp.isactive                           AS c_bpartner_product_isactive,
                pp.ismanufacturer,
                pp.manufacturer                       AS c_bpartner_product_manufactur,
                pp.qualityrating                      AS c_bpartner_product_qualityrat,
                pp.shelflifemindays,
                pp.shelflifeminpct                    AS c_bpartner_product_shelflifem,
                pp.updated                            AS c_bpartner_product_updated,
                pp.updatedby                          AS c_bpartner_product_updatedby,
                pp.vendorcategory                     AS c_bpartner_product_vendorcate,
                bp.acqusitioncost,
                bp.actuallifetimevalue,
                bp.ad_language                        AS c_bpartner_ad_language,
                bp.ad_orgbp_id,
                bp.ad_org_id                          AS c_bpartner_ad_org_id,
                bp.bpartner_parent_id,
                bp.c_bp_group_id,
                bp.c_dunning_id,
                bp.c_greeting_id,
                bp.c_invoiceschedule_id,
                bp.c_paymentterm_id                   AS c_bpartner_c_paymentterm_id,
                bp.created                            AS c_bpartner_created,
                bp.createdby                          AS c_bpartner_createdby,
                bp.c_taxgroup_id                      AS c_bpartner_c_taxgroup_id,
                bp.deliveryrule                       AS c_bpartner_deliveryrule,
                bp.deliveryviarule                    AS c_bpartner_deliveryviarule,
                bp.description                        AS c_bpartner_description,
                bp.dunninggrace                       AS c_bpartner_dunninggrace,
                bp.duns,
                bp.firstsale                          AS c_bpartner_firstsale,
                bp.flatdiscount                       AS c_bpartner_flatdiscount,
                bp.freightcostrule                    AS c_bpartner_freightcostrule,
                bp.invoicerule                        AS c_bpartner_invoicerule,
                bp.isactive                           AS c_bpartner_isactive,
                bp.iscustomer,
                bp.isdiscountprinted                  AS c_bpartner_isdiscountprinted,
                bp.isemployee                         AS c_bpartner_isemployee,
                bp.ismanufacturer                     AS c_bpartner_ismanufacturer,
                bp.isonetime,
                bp.ispotaxexempt,
                bp.isprospect,
                bp.issalesrep,
                bp.issummary                          AS c_bpartner_issummary,
                bp.istaxexempt                        AS c_bpartner_istaxexempt,
                bp.isvendor,
                bp.logo_id,
                bp.m_discountschema_id,
                bp.m_pricelist_id                     AS c_bpartner_m_pricelist_id,
                bp.naics,
                bp.name                               AS c_bpartner_name,
                bp.name2                              AS c_bpartner_name2,
                bp.numberemployees,
                bp.paymentrule                        AS c_bpartner_paymentrule,
                bp.paymentrulepo,
                bp.po_discountschema_id,
                bp.po_paymentterm_id,
                bp.po_pricelist_id,
                bp.poreference                        AS c_bpartner_poreference,
                bp.potentiallifetimevalue,
                bp.rating                             AS c_bpartner_rating,
                bp.referenceno                        AS c_bpartner_referenceno,
                bp.salesrep_id                        AS c_bpartner_salesrep_id,
                bp.salesvolume,
                bp.sendemail                          AS c_bpartner_sendemail,
                bp.shareofcustomer,
                bp.shelflifeminpct                    AS c_bpartner_shelflifeminpct,
                bp.so_creditlimit,
                bp.socreditstatus,
                bp.so_creditused,
                bp.so_description,
                bp.taxid                              AS c_bpartner_taxid,
                bp.totalopenbalance,
                bp.updated                            AS c_bpartner_updated,
                bp.updatedby                          AS c_bpartner_updatedby,
                bp.url                                AS c_bpartner_url,
                bp.value                              AS c_bpartner_value,
                bpl.ad_org_id                         AS c_bpartner_location_ad_org_id,
                bpl.c_bpartner_id                     AS c_bpartner_location_c_bpartne,
                bpl.created                           AS c_bpartner_location_created,
                bpl.createdby                         AS c_bpartner_location_createdby,
                bpl.c_salesregion_id,
                bpl.fax                               AS c_bpartner_location_fax,
                bpl.isactive                          AS c_bpartner_location_isactive,
                bpl.isbillto,
                bpl.isdn,
                bpl.ispayfrom,
                bpl.isremitto,
                bpl.isshipto,
                bpl.name                              AS c_bpartner_location_name,
                bpl.phone                             AS c_bpartner_location_phone,
                bpl.phone2                            AS c_bpartner_location_phone2,
                bpl.updated                           AS c_bpartner_location_updated,
                bpl.updatedby                         AS c_bpartner_location_updatedby,
                t.ad_org_id                           AS c_tax_ad_org_id,
                t.ad_rule_id,
                t.c_country_id,
                t.c_region_id,
                t.c_taxcategory_id                    AS c_tax_c_taxcategory_id,
                t.description                         AS c_tax_description,
                t.isactive                            AS c_tax_isactive,
                t.isdefault                           AS c_tax_isdefault,
                t.isdocumentlevel,
                t.issalestax,
                t.issummary                           AS c_tax_issummary,
                t.istaxexempt                         AS c_tax_istaxexempt,
                t.name                                AS c_tax_name,
                t.parent_tax_id,
                t.rate,
                t.requirestaxcertificate,
                t.sopotype,
                t.to_country_id,
                t.to_region_id                        AS c_tax_to_region_id,
                t.validfrom 
            FROM c_orderline ol 
                JOIN c_uom uom 
                ON ol.c_uom_id = uom.c_uom_id 
                JOIN c_order i 
                ON ol.c_order_id = i.c_order_id 
                LEFT JOIN m_product p 
                ON ol.m_product_id = p.m_product_id 
                LEFT JOIN m_product_po po 
                ON p.m_product_id = po.m_product_id AND i.c_bpartner_id = po.c_bpartner_id 
                LEFT JOIN s_resourceassignment ra 
                ON ol.s_resourceassignment_id = ra.s_resourceassignment_id 
                LEFT JOIN c_charge c 
                ON ol.c_charge_id = c.c_charge_id 
                LEFT JOIN c_bpartner_product pp 
                ON ol.m_product_id = pp.m_product_id AND i.c_bpartner_id = pp.c_bpartner_id 
                JOIN c_bpartner bp 
                ON ol.c_bpartner_id = bp.c_bpartner_id 
                JOIN c_bpartner_location bpl 
                ON ol.c_bpartner_location_id = bpl.c_bpartner_location_id 
                LEFT JOIN c_tax t 
                ON ol.c_tax_id = t.c_tax_id 
                UNION SELECT ol.ad_client_id,
                        ol.ad_org_id,
                        ol.isactive,
                        ol.created,
                        ol.createdby,
                        ol.updated,
                        ol.updatedby,
                        'en_US'                 AS ad_language,
                        ol.c_order_id,
                        ol.c_orderline_id,
                        ol.c_tax_id,
                        NULL                    AS taxindicator,
                        NULL                    AS c_bpartner_id,
                        NULL                    AS c_bpartner_location_id,
                        NULL                    AS bpname,
                        NULL                    AS c_location_id,
                        ol.line + bl.line / 100 AS line,
                        p.m_product_id,
                        po.vendorproductno,
                        CASE WHEN bl.isqtypercentage = 'N' THEN ol.qtyordered * bl.qtybom ELSE ol.qtyordered * (bl.qtybatch / 100) END                 AS qtyordered,
                        CASE WHEN bl.isqtypercentage = 'N' THEN ol.qtyentered * bl.qtybom ELSE ol.qtyentered * (bl.qtybatch / 100) END                 AS qtyentered,
                        uom.uomsymbol,
                        p.name,
                        bl.description,
                        p.documentnote,
                        p.upc,
                        p.sku,
                        p.value                 AS productvalue,
                        NULL                    AS resourcedescription,
                        NULL                    AS pricelist,
                        NULL                    AS priceenteredlist,
                        NULL                    AS discount,
                        NULL                    AS priceactual,
                        NULL                    AS priceentered,
                        NULL                    AS linenetamt,
                        p.description           AS productdescription,
                        p.imageurl,
                        ol.c_campaign_id,
                        ol.c_project_id,
                        ol.c_activity_id,
                        ol.c_projectphase_id,
                        ol.c_projecttask_id,
                        ol.ad_orgtrx_id         AS c_orderline_ad_orgtrx_id,
                        ol.c_charge_id          AS c_orderline_c_charge_id,
                        ol.c_currency_id        AS c_orderline_c_currency_id,
                        ol.c_uom_id,
                        ol.datedelivered,
                        ol.dateinvoiced,
                        ol.dateordered,
                        ol.datepromised         AS c_orderline_datepromised,
                        ol.freightamt           AS c_orderline_freightamt,
                        ol.isdescription,
                        ol.link_orderline_id,
                        ol.m_promotion_id,
                        ol.m_shipper_id         AS c_orderline_m_shipper_id,
                        ol.m_warehouse_id       AS c_orderline_m_warehouse_id,
                        ol.pricecost,
                        ol.pricelimit,
                        ol.processed            AS c_orderline_processed,
                        ol.qtydelivered,
                        ol.qtyinvoiced,
                        ol.qtylostsales,
                        ol.qtyreserved,
                        ol.ref_orderline_id,
                        ol.rramt,
                        ol.rrstartdate,
                        ol.s_resourceassignment_id,
                        ol.user1_id             AS c_orderline_user1_id,
                        ol.user2_id             AS c_orderline_user2_id,
                        uom.ad_org_id           AS c_uom_ad_org_id,
                        uom.costingprecision,
                        uom.description         AS c_uom_description,
                        uom.isactive            AS c_uom_isactive,
                        uom.isdefault,
                        uom.name                AS c_uom_name,
                        uom.stdprecision,
                        uom.uomtype,
                        uom.x12de355,
                        i.ad_org_id             AS c_order_ad_org_id,
                        i.ad_orgtrx_id          AS c_order_ad_orgtrx_id,
                        i.ad_user_id,
                        i.amountrefunded,
                        i.amounttendered,
                        i.bill_bpartner_id,
                        i.bill_location_id,
                        i.bill_user_id,
                        i.c_activity_id         AS c_order_c_activity_id,
                        i.c_bpartner_id         AS c_order_c_bpartner_id,
                        i.c_campaign_id         AS c_order_c_campaign_id,
                        i.c_cashline_id,
                        i.c_cashplanline_id,
                        i.c_charge_id           AS c_order_c_charge_id,
                        i.c_conversiontype_id,
                        i.c_currency_id         AS c_order_c_currency_id,
                        i.c_doctype_id,
                        i.c_doctypetarget_id,
                        i.chargeamt,
                        i.copyfrom,
                        i.c_payment_id,
                        i.c_paymentterm_id,
                        i.c_pos_id,
                        i.c_project_id          AS c_order_c_project_id,
                        i.created               AS c_order_created,
                        i.createdby             AS c_order_createdby,
                        i.dateacct,
                        i.dateprinted,
                        i.datepromised          AS c_order_datepromised,
                        i.deliveryrule,
                        i.deliveryviarule,
                        i.description           AS c_order_description,
                        i.docaction,
                        i.docstatus,
                        i.documentno,
                        i.dropship_bpartner_id,
                        i.dropship_location_id,
                        i.dropship_user_id,
                        i.freightamt            AS c_order_freightamt,
                        i.freightcostrule,
                        i.grandtotal,
                        i.invoicerule,
                        i.isactive              AS c_order_isactive,
                        i.isapproved,
                        i.iscreditapproved,
                        i.isdelivered,
                        i.isdiscountprinted     AS c_order_isdiscountprinted,
                        i.isdropship            AS c_order_isdropship,
                        i.isinvoiced,
                        i.ispayschedulevalid,
                        i.isprinted,
                        i.isselected,
                        i.isselfservice         AS c_order_isselfservice,
                        i.issotrx,
                        i.istaxincluded,
                        i.istransferred,
                        i.link_order_id,
                        i.m_freightcategory_id  AS c_order_m_freightcategory_id,
                        i.m_pricelist_id        AS c_order_m_pricelist_id,
                        i.m_shipper_id          AS c_order_m_shipper_id,
                        i.m_warehouse_id        AS c_order_m_warehouse_id,
                        i.ordertype,
                        i.pay_bpartner_id,
                        i.pay_location_id,
                        i.paymentrule           AS c_order_paymentrule,
                        i.poreference,
                        i.posted,
                        i.priorityrule,
                        i.processed             AS c_order_processed,
                        i.processedon,
                        i.promotioncode,
                        i.ref_order_id,
                        i.salesrep_id,
                        i.sendemail             AS c_order_sendemail,
                        i.totallines,
                        i.updated               AS c_order_updated,
                        i.updatedby             AS c_order_updatedby,
                        i.user1_id              AS c_order_user1_id,
                        i.user2_id              AS c_order_user2_id,
                        i.volume                AS c_order_volume,
                        i.weight                AS c_order_weight,
                        p.ad_org_id             AS m_product_ad_org_id,
                        p.classification,
                        p.copyfrom              AS m_product_copyfrom,
                        p.created               AS m_product_created,
                        p.createdby             AS m_product_createdby,
                        p.c_revenuerecognition_id,
                        p.c_subscriptiontype_id,
                        p.c_taxcategory_id,
                        p.c_uom_id              AS m_product_c_uom_id,
                        p.descriptionurl,
                        p.discontinued          AS m_product_discontinued,
                        p.discontinuedat        AS m_product_discontinuedat,
                        p.group1,
                        p.group2,
                        p.guaranteedays,
                        p.guaranteedaysmin,
                        p.help,
                        p.isactive              AS m_product_isactive,
                        p.isbom,
                        p.isdropship            AS m_product_isdropship,
                        p.isexcludeautodelivery,
                        p.isinvoiceprintdetails,
                        p.ispicklistprintdetails,
                        p.ispurchased,
                        p.isselfservice         AS m_product_isselfservice,
                        p.issold,
                        p.isstocked,
                        p.issummary             AS m_product_issummary,
                        p.isverified,
                        p.iswebstorefeatured,
                        p.lowlevel,
                        p.m_attributeset_id,
                        p.m_attributesetinstance_id,
                        p.m_freightcategory_id  AS m_product_m_freightcategory_id,
                        p.m_locator_id,
                        p.m_product_category_id AS m_product_product_category_id,
                        p.processing            AS m_product_processing,
                        p.producttype,
                        p.r_mailtext_id,
                        p.salesrep_id           AS m_product_salesrep_id,
                        p.s_expensetype_id,
                        p.shelfdepth,
                        p.shelfheight,
                        p.shelfwidth,
                        p.s_resource_id,
                        p.unitsperpack,
                        p.unitsperpallet,
                        p.updated               AS m_product_updated,
                        p.updatedby             AS m_product_updatedby,
                        p.versionno,
                        p.volume                AS m_product_volume,
                        p.weight                AS m_product_weight,
                        po.ad_org_id            AS m_product_po_ad_org_id,
                        po.c_bpartner_id        AS m_product_po_c_bpartner_id,
                        po.c_currency_id        AS m_product_po_c_currency_id,
                        po.costperorder,
                        po.created              AS m_product_po_created,
                        po.createdby            AS m_product_po_createdby,
                        po.c_uom_id             AS m_product_po_c_uom_id,
                        po.deliverytime_actual,
                        po.deliverytime_promised,
                        po.discontinued         AS m_product_po_discontinued,
                        po.discontinuedat       AS m_product_po_discontinuedat,
                        po.isactive             AS m_product_po_isactive,
                        po.iscurrentvendor,
                        po.manufacturer         AS m_product_po_manufacturer,
                        po.m_product_id         AS m_product_po_m_product_id,
                        po.order_min,
                        po.order_pack,
                        po.priceeffective,
                        po.pricelastinv,
                        po.pricelastpo,
                        po.pricelist            AS m_product_po_pricelist,
                        po.pricepo,
                        po.qualityrating        AS m_product_po_qualityrating,
                        po.royaltyamt,
                        po.upc                  AS m_product_po_upc,
                        po.updated              AS m_product_po_updated,
                        po.updatedby            AS m_product_po_updatedby,
                        po.vendorcategory       AS m_product_po_vendorcategory,
                        NULL                    AS s_resourceassignment_ad_org_id,
                        NULL                    AS assigndatefrom,
                        NULL                    AS assigndateto,
                        NULL                    AS s_resourceassignment_created,
                        NULL                    AS s_resourceassignment_createby,
                        NULL                    AS s_resourceassignment_isactive,
                        NULL                    AS isconfirmed,
                        NULL                    AS s_resourceassignment_name,
                        NULL                    AS s_resourceassignment_qty,
                        NULL                    AS s_resourceassignment_s_resour,
                        NULL                    AS s_resourceassignment_updated,
                        NULL                    AS s_resourceassignment_updatedby,
                        NULL                    AS c_charge_c_org_id,
                        NULL                    AS c_charge_c_bpartner_id,
                        NULL                    AS c_chargetype_id,
                        NULL                    AS c_charge_chargeamt,
                        NULL                    AS c_charge_c_taxcategory_id,
                        NULL                    AS c_charge_description,
                        NULL                    AS c_charge_isactive,
                        NULL                    AS issamecurrency,
                        NULL                    AS issametax,
                        NULL                    AS c_charge_istaxincluded,
                        NULL                    AS c_bpartner_product_ad_org_id,
                        NULL                    AS c_bp_product_c_bpartner_id,
                        NULL                    AS c_bpartner_product_created,
                        NULL                    AS c_bpartner_product_createdby,
                        NULL                    AS c_bpartner_product_description,
                        NULL                    AS c_bpartner_product_isactive,
                        NULL                    AS ismanufacturer,
                        NULL                    AS c_bpartner_product_manufactur,
                        NULL                    AS c_bpartner_product_qualityrat,
                        NULL                    AS shelflifemindays,
                        NULL                    AS c_bpartner_product_shelflifem,
                        NULL                    AS c_bpartner_product_updated,
                        NULL                    AS c_bpartner_product_updatedby,
                        NULL                    AS c_bpartner_product_vendorcate,
                        NULL                    AS acqusitioncost,
                        NULL                    AS actuallifetimevalue,
                        NULL                    AS c_bpartner_ad_language,
                        NULL                    AS ad_orgbp_id,
                        NULL                    AS c_bpartner_ad_org_id,
                        NULL                    AS bpartner_parent_id,
                        NULL                    AS c_bp_group_id,
                        NULL                    AS c_dunning_id,
                        NULL                    AS c_greeting_id,
                        NULL                    AS c_invoiceschedule_id,
                        NULL                    AS c_bpartner_c_paymentterm_id,
                        NULL                    AS c_bpartner_created,
                        NULL                    AS c_bpartner_createdby,
                        NULL                    AS c_bpartner_c_taxgroup_id,
                        NULL                    AS c_bpartner_deliveryrule,
                        NULL                    AS c_bpartner_deliveryviarule,
                        NULL                    AS c_bpartner_description,
                        NULL                    AS c_bpartner_dunninggrace,
                        NULL                    AS duns,
                        NULL                    AS c_bpartner_firstsale,
                        NULL                    AS c_bpartner_flatdiscount,
                        NULL                    AS c_bpartner_freightcostrule,
                        NULL                    AS c_bpartner_invoicerule,
                        NULL                    AS c_bpartner_isactive,
                        NULL                    AS iscustomer,
                        NULL                    AS c_bpartner_isdiscountprinted,
                        NULL                    AS c_bpartner_isemployee,
                        NULL                    AS c_bpartner_ismanufacturer,
                        NULL                    AS isonetime,
                        NULL                    AS ispotaxexempt,
                        NULL                    AS isprospect,
                        NULL                    AS issalesrep,
                        NULL                    AS c_bpartner_issummary,
                        NULL                    AS c_bpartner_istaxexempt,
                        NULL                    AS isvendor,
                        NULL                    AS logo_id,
                        NULL                    AS m_discountschema_id,
                        NULL                    AS c_bpartner_m_pricelist_id,
                        NULL                    AS naics,
                        NULL                    AS c_bpartner_name,
                        NULL                    AS c_bpartner_name2,
                        NULL                    AS numberemployees,
                        NULL                    AS c_bpartner_paymentrule,
                        NULL                    AS paymentrulepo,
                        NULL                    AS po_discountschema_id,
                        NULL                    AS po_paymentterm_id,
                        NULL                    AS po_pricelist_id,
                        NULL                    AS c_bpartner_poreference,
                        NULL                    AS potentiallifetimevalue,
                        NULL                    AS c_bpartner_rating,
                        NULL                    AS c_bpartner_referenceno,
                        NULL                    AS c_bpartner_salesrep_id,
                        NULL                    AS salesvolume,
                        NULL                    AS c_bpartner_sendemail,
                        NULL                    AS shareofcustomer,
                        NULL                    AS c_bpartner_shelflifeminpct,
                        NULL                    AS so_creditlimit,
                        NULL                    AS socreditstatus,
                        NULL                    AS so_creditused,
                        NULL                    AS so_description,
                        NULL                    AS c_bpartner_taxid,
                        NULL                    AS totalopenbalance,
                        NULL                    AS c_bpartner_updated,
                        NULL                    AS c_bpartner_updatedby,
                        NULL                    AS c_bpartner_url,
                        NULL                    AS c_bpartner_value,
                        NULL                    AS c_bpartner_location_ad_org_id,
                        NULL                    AS c_bpartner_location_c_bpartne,
                        NULL                    AS c_bpartner_location_created,
                        NULL                    AS c_bpartner_location_createdby,
                        NULL                    AS c_salesregion_id,
                        NULL                    AS c_bpartner_location_fax,
                        NULL                    AS c_bpartner_location_isactive,
                        NULL                    AS isbillto,
                        NULL                    AS isdn,
                        NULL                    AS ispayfrom,
                        NULL                    AS isremitto,
                        NULL                    AS isshipto,
                        NULL                    AS c_bpartner_location_name,
                        NULL                    AS c_bpartner_location_phone,
                        NULL                    AS c_bpartner_location_phone2,
                        NULL                    AS c_bpartner_location_updated,
                        NULL                    AS c_bpartner_location_updatedby,
                        NULL                    AS c_tax_ad_org_id,
                        NULL                    AS ad_rule_id,
                        NULL                    AS c_country_id,
                        NULL                    AS c_region_id,
                        NULL                    AS c_tax_c_taxcategory_id,
                        NULL                    AS c_tax_description,
                        NULL                    AS c_tax_isactive,
                        NULL                    AS c_tax_isdefault,
                        NULL                    AS isdocumentlevel,
                        NULL                    AS issalestax,
                        NULL                    AS c_tax_issummary,
                        NULL                    AS c_tax_istaxexempt,
                        NULL                    AS c_tax_name,
                        NULL                    AS parent_tax_id,
                        NULL                    AS rate,
                        NULL                    AS requirestaxcertificate,
                        NULL                    AS sopotype,
                        NULL                    AS to_country_id,
                        NULL                    AS c_tax_to_region_id,
                        NULL                    AS validfrom 
                    FROM pp_product_bom b 
                        JOIN c_orderline ol 
                        ON b.m_product_id = ol.m_product_id 
                        JOIN c_order i 
                        ON ol.c_order_id = i.c_order_id 
                        JOIN m_product bp 
                        ON bp.m_product_id = ol.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.isinvoiceprintdetails = 'Y' 
                        JOIN pp_product_bomline bl 
                        ON bl.pp_product_bom_id = b.pp_product_bom_id 
                        JOIN m_product p 
                        ON p.m_product_id = bl.m_product_id 
                        LEFT JOIN m_product_po po 
                        ON p.m_product_id = po.m_product_id AND i.c_bpartner_id = po.c_bpartner_id 
                        JOIN c_uom uom 
                        ON p.c_uom_id = uom.c_uom_id) 
    UNION   SELECT i.ad_client_id,
                i.ad_org_id,
                i.isactive,
                i.created,
                i.createdby,
                i.updated,
                i.updatedby,
                'en_US'                AS ad_language,
                i.c_order_id,
                NULL                   AS c_orderline_id,
                NULL                   AS c_tax_id,
                NULL                   AS taxindicator,
                NULL                   AS c_bpartner_id,
                NULL                   AS c_bpartner_location_id,
                NULL                   AS bpname,
                NULL                   AS c_location_id,
                NULL                   AS line,
                NULL                   AS m_product_id,
                NULL                   AS vendorproductno,
                NULL                   AS qtyordered,
                NULL                   AS qtyentered,
                NULL                   AS uomsymbol,
                NULL                   AS name,
                NULL                   AS description,
                NULL                   AS documentnote,
                NULL                   AS upc,
                NULL                   AS sku,
                NULL                   AS productvalue,
                NULL                   AS resourcedescription,
                NULL                   AS pricelist,
                NULL                   AS priceenteredlist,
                NULL                   AS discount,
                NULL                   AS priceactual,
                NULL                   AS priceentered,
                NULL                   AS linenetamt,
                NULL                   AS productdescription,
                NULL                   AS imageurl,
                NULL                   AS c_campaign_id,
                NULL                   AS c_project_id,
                NULL                   AS c_activity_id,
                NULL                   AS c_projectphase_id,
                NULL                   AS c_projecttask_id,
                NULL                   AS c_orderline_ad_orgtrx_id,
                NULL                   AS c_orderline_c_charge_id,
                NULL                   AS c_orderline_c_currency_id,
                NULL                   AS c_uom_id,
                NULL                   AS datedelivered,
                NULL                   AS dateinvoiced,
                NULL                   AS dateordered,
                NULL                   AS c_orderline_datepromised,
                NULL                   AS c_orderline_freightamt,
                NULL                   AS isdescription,
                NULL                   AS link_orderline_id,
                NULL                   AS m_promotion_id,
                NULL                   AS c_orderline_m_shipper_id,
                NULL                   AS c_orderline_m_warehouse_id,
                NULL                   AS pricecost,
                NULL                   AS pricelimit,
                NULL                   AS c_orderline_processed,
                NULL                   AS qtydelivered,
                NULL                   AS qtyinvoiced,
                NULL                   AS qtylostsales,
                NULL                   AS qtyreserved,
                NULL                   AS ref_orderline_id,
                NULL                   AS rramt,
                NULL                   AS rrstartdate,
                NULL                   AS s_resourceassignment_id,
                NULL                   AS c_orderline_user1_id,
                NULL                   AS c_orderline_user2_id,
                NULL                   AS c_uom_ad_org_id,
                NULL                   AS costingprecision,
                NULL                   AS c_uom_description,
                NULL                   AS c_uom_isactive,
                NULL                   AS isdefault,
                NULL                   AS c_uom_name,
                NULL                   AS stdprecision,
                NULL                   AS uomtype,
                NULL                   AS x12de355,
                i.ad_org_id            AS c_order_ad_org_id,
                i.ad_orgtrx_id         AS c_order_ad_orgtrx_id,
                i.ad_user_id,
                i.amountrefunded,
                i.amounttendered,
                i.bill_bpartner_id,
                i.bill_location_id,
                i.bill_user_id,
                i.c_activity_id        AS c_order_c_activity_id,
                i.c_bpartner_id        AS c_order_c_bpartner_id,
                i.c_campaign_id        AS c_order_c_campaign_id,
                i.c_cashline_id,
                i.c_cashplanline_id,
                i.c_charge_id          AS c_order_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id        AS c_order_c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.chargeamt,
                i.copyfrom,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_pos_id,
                i.c_project_id         AS c_order_c_project_id,
                i.created              AS c_order_created,
                i.createdby            AS c_order_createdby,
                i.dateacct,
                i.dateprinted,
                i.datepromised         AS c_order_datepromised,
                i.deliveryrule,
                i.deliveryviarule,
                i.description          AS c_order_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dropship_bpartner_id,
                i.dropship_location_id,
                i.dropship_user_id,
                i.freightamt           AS c_order_freightamt,
                i.freightcostrule,
                i.grandtotal,
                i.invoicerule,
                i.isactive             AS c_order_isactive,
                i.isapproved,
                i.iscreditapproved,
                i.isdelivered,
                i.isdiscountprinted    AS c_order_isdiscountprinted,
                i.isdropship           AS c_order_isdropship,
                i.isinvoiced,
                i.ispayschedulevalid,
                i.isprinted,
                i.isselected,
                i.isselfservice        AS c_order_isselfservice,
                i.issotrx,
                i.istaxincluded,
                i.istransferred,
                i.link_order_id,
                i.m_freightcategory_id AS c_order_m_freightcategory_id,
                i.m_pricelist_id       AS c_order_m_pricelist_id,
                i.m_shipper_id         AS c_order_m_shipper_id,
                i.m_warehouse_id       AS c_order_m_warehouse_id,
                i.ordertype,
                i.pay_bpartner_id,
                i.pay_location_id,
                i.paymentrule          AS c_order_paymentrule,
                i.poreference,
                i.posted,
                i.priorityrule,
                i.processed            AS c_order_processed,
                i.processedon,
                i.promotioncode,
                i.ref_order_id,
                i.salesrep_id,
                i.sendemail            AS c_order_sendemail,
                i.totallines,
                i.updated              AS c_order_updated,
                i.updatedby            AS c_order_updatedby,
                i.user1_id             AS c_order_user1_id,
                i.user2_id             AS c_order_user2_id,
                i.volume               AS c_order_volume,
                i.weight               AS c_order_weight,
                NULL                   AS m_product_ad_org_id,
                NULL                   AS classification,
                NULL                   AS m_product_copyfrom,
                NULL                   AS m_product_created,
                NULL                   AS m_product_createdby,
                NULL                   AS c_revenuerecognition_id,
                NULL                   AS c_subscriptiontype_id,
                NULL                   AS c_taxcategory_id,
                NULL                   AS m_product_c_uom_id,
                NULL                   AS descriptionurl,
                NULL                   AS m_product_discontinued,
                NULL                   AS m_product_discontinuedat,
                NULL                   AS group1,
                NULL                   AS group2,
                NULL                   AS guaranteedays,
                NULL                   AS guaranteedaysmin,
                NULL                   AS help,
                NULL                   AS m_product_isactive,
                NULL                   AS isbom,
                NULL                   AS m_product_isdropship,
                NULL                   AS isexcludeautodelivery,
                NULL                   AS isinvoiceprintdetails,
                NULL                   AS ispicklistprintdetails,
                NULL                   AS ispurchased,
                NULL                   AS m_product_isselfservice,
                NULL                   AS issold,
                NULL                   AS isstocked,
                NULL                   AS m_product_issummary,
                NULL                   AS isverified,
                NULL                   AS iswebstorefeatured,
                NULL                   AS lowlevel,
                NULL                   AS m_attributeset_id,
                NULL                   AS m_attributesetinstance_id,
                NULL                   AS m_product_m_freightcategory_id,
                NULL                   AS m_locator_id,
                NULL                   AS m_product_product_category_id,
                NULL                   AS m_product_processing,
                NULL                   AS producttype,
                NULL                   AS r_mailtext_id,
                NULL                   AS m_product_salesrep_id,
                NULL                   AS s_expensetype_id,
                NULL                   AS shelfdepth,
                NULL                   AS shelfheight,
                NULL                   AS shelfwidth,
                NULL                   AS s_resource_id,
                NULL                   AS unitsperpack,
                NULL                   AS unitsperpallet,
                NULL                   AS m_product_updated,
                NULL                   AS m_product_updatedby,
                NULL                   AS versionno,
                NULL                   AS m_product_volume,
                NULL                   AS m_product_weight,
                NULL                   AS m_product_po_ad_org_id,
                NULL                   AS m_product_po_c_bpartner_id,
                NULL                   AS m_product_po_c_currency_id,
                NULL                   AS costperorder,
                NULL                   AS m_product_po_created,
                NULL                   AS m_product_po_createdby,
                NULL                   AS m_product_po_c_uom_id,
                NULL                   AS deliverytime_actual,
                NULL                   AS deliverytime_promised,
                NULL                   AS m_product_po_discontinued,
                NULL                   AS m_product_po_discontinuedat,
                NULL                   AS m_product_po_isactive,
                NULL                   AS iscurrentvendor,
                NULL                   AS m_product_po_manufacturer,
                NULL                   AS m_product_po_m_product_id,
                NULL                   AS order_min,
                NULL                   AS order_pack,
                NULL                   AS priceeffective,
                NULL                   AS pricelastinv,
                NULL                   AS pricelastpo,
                NULL                   AS m_product_po_pricelist,
                NULL                   AS pricepo,
                NULL                   AS m_product_po_qualityrating,
                NULL                   AS royaltyamt,
                NULL                   AS m_product_po_upc,
                NULL                   AS m_product_po_updated,
                NULL                   AS m_product_po_updatedby,
                NULL                   AS m_product_po_vendorcategory,
                NULL                   AS s_resourceassignment_ad_org_id,
                NULL                   AS assigndatefrom,
                NULL                   AS assigndateto,
                NULL                   AS s_resourceassignment_created,
                NULL                   AS s_resourceassignment_createby,
                NULL                   AS s_resourceassignment_isactive,
                NULL                   AS isconfirmed,
                NULL                   AS s_resourceassignment_name,
                NULL                   AS s_resourceassignment_qty,
                NULL                   AS s_resourceassignment_s_resour,
                NULL                   AS s_resourceassignment_updated,
                NULL                   AS s_resourceassignment_updatedby,
                NULL                   AS c_charge_c_org_id,
                NULL                   AS c_charge_c_bpartner_id,
                NULL                   AS c_chargetype_id,
                NULL                   AS c_charge_chargeamt,
                NULL                   AS c_charge_c_taxcategory_id,
                NULL                   AS c_charge_description,
                NULL                   AS c_charge_isactive,
                NULL                   AS issamecurrency,
                NULL                   AS issametax,
                NULL                   AS c_charge_istaxincluded,
                NULL                   AS c_bpartner_product_ad_org_id,
                NULL                   AS c_bp_product_c_bpartner_id,
                NULL                   AS c_bpartner_product_created,
                NULL                   AS c_bpartner_product_createdby,
                NULL                   AS c_bpartner_product_description,
                NULL                   AS c_bpartner_product_isactive,
                NULL                   AS ismanufacturer,
                NULL                   AS c_bpartner_product_manufactur,
                NULL                   AS c_bpartner_product_qualityrat,
                NULL                   AS shelflifemindays,
                NULL                   AS c_bpartner_product_shelflifem,
                NULL                   AS c_bpartner_product_updated,
                NULL                   AS c_bpartner_product_updatedby,
                NULL                   AS c_bpartner_product_vendorcate,
                NULL                   AS acqusitioncost,
                NULL                   AS actuallifetimevalue,
                NULL                   AS c_bpartner_ad_language,
                NULL                   AS ad_orgbp_id,
                NULL                   AS c_bpartner_ad_org_id,
                NULL                   AS bpartner_parent_id,
                NULL                   AS c_bp_group_id,
                NULL                   AS c_dunning_id,
                NULL                   AS c_greeting_id,
                NULL                   AS c_invoiceschedule_id,
                NULL                   AS c_bpartner_c_paymentterm_id,
                NULL                   AS c_bpartner_created,
                NULL                   AS c_bpartner_createdby,
                NULL                   AS c_bpartner_c_taxgroup_id,
                NULL                   AS c_bpartner_deliveryrule,
                NULL                   AS c_bpartner_deliveryviarule,
                NULL                   AS c_bpartner_description,
                NULL                   AS c_bpartner_dunninggrace,
                NULL                   AS duns,
                NULL                   AS c_bpartner_firstsale,
                NULL                   AS c_bpartner_flatdiscount,
                NULL                   AS c_bpartner_freightcostrule,
                NULL                   AS c_bpartner_invoicerule,
                NULL                   AS c_bpartner_isactive,
                NULL                   AS iscustomer,
                NULL                   AS c_bpartner_isdiscountprinted,
                NULL                   AS c_bpartner_isemployee,
                NULL                   AS c_bpartner_ismanufacturer,
                NULL                   AS isonetime,
                NULL                   AS ispotaxexempt,
                NULL                   AS isprospect,
                NULL                   AS issalesrep,
                NULL                   AS c_bpartner_issummary,
                NULL                   AS c_bpartner_istaxexempt,
                NULL                   AS isvendor,
                NULL                   AS logo_id,
                NULL                   AS m_discountschema_id,
                NULL                   AS c_bpartner_m_pricelist_id,
                NULL                   AS naics,
                NULL                   AS c_bpartner_name,
                NULL                   AS c_bpartner_name2,
                NULL                   AS numberemployees,
                NULL                   AS c_bpartner_paymentrule,
                NULL                   AS paymentrulepo,
                NULL                   AS po_discountschema_id,
                NULL                   AS po_paymentterm_id,
                NULL                   AS po_pricelist_id,
                NULL                   AS c_bpartner_poreference,
                NULL                   AS potentiallifetimevalue,
                NULL                   AS c_bpartner_rating,
                NULL                   AS c_bpartner_referenceno,
                NULL                   AS c_bpartner_salesrep_id,
                NULL                   AS salesvolume,
                NULL                   AS c_bpartner_sendemail,
                NULL                   AS shareofcustomer,
                NULL                   AS c_bpartner_shelflifeminpct,
                NULL                   AS so_creditlimit,
                NULL                   AS socreditstatus,
                NULL                   AS so_creditused,
                NULL                   AS so_description,
                NULL                   AS c_bpartner_taxid,
                NULL                   AS totalopenbalance,
                NULL                   AS c_bpartner_updated,
                NULL                   AS c_bpartner_updatedby,
                NULL                   AS c_bpartner_url,
                NULL                   AS c_bpartner_value,
                NULL                   AS c_bpartner_location_ad_org_id,
                NULL                   AS c_bpartner_location_c_bpartne,
                NULL                   AS c_bpartner_location_created,
                NULL                   AS c_bpartner_location_createdby,
                NULL                   AS c_salesregion_id,
                NULL                   AS c_bpartner_location_fax,
                NULL                   AS c_bpartner_location_isactive,
                NULL                   AS isbillto,
                NULL                   AS isdn,
                NULL                   AS ispayfrom,
                NULL                   AS isremitto,
                NULL                   AS isshipto,
                NULL                   AS c_bpartner_location_name,
                NULL                   AS c_bpartner_location_phone,
                NULL                   AS c_bpartner_location_phone2,
                NULL                   AS c_bpartner_location_updated,
                NULL                   AS c_bpartner_location_updatedby,
                NULL                   AS c_tax_ad_org_id,
                NULL                   AS ad_rule_id,
                NULL                   AS c_country_id,
                NULL                   AS c_region_id,
                NULL                   AS c_tax_c_taxcategory_id,
                NULL                   AS c_tax_description,
                NULL                   AS c_tax_isactive,
                NULL                   AS c_tax_isdefault,
                NULL                   AS isdocumentlevel,
                NULL                   AS issalestax,
                NULL                   AS c_tax_issummary,
                NULL                   AS c_tax_istaxexempt,
                NULL                   AS c_tax_name,
                NULL                   AS parent_tax_id,
                NULL                   AS rate,
                NULL                   AS requirestaxcertificate,
                NULL                   AS sopotype,
                NULL                   AS to_country_id,
                NULL                   AS c_tax_to_region_id,
                NULL                   AS validfrom 
            FROM c_order i
            )
UNION 
SELECT ot.ad_client_id,
    ot.ad_org_id,
    ot.isactive,
    ot.created,
    ot.createdby,
    ot.updated,
    ot.updatedby,
    'en_US' AS ad_language,
    ot.c_order_id,
    NULL    AS c_orderline_id,
    ot.c_tax_id,
    t.taxindicator,
    NULL    AS c_bpartner_id,
    NULL    AS c_bpartner_location_id,
    NULL    AS bpname,
    NULL    AS c_location_id,
    NULL    AS line,
    NULL    AS m_product_id,
    NULL    AS vendorproductno,
    NULL    AS qtyordered,
    NULL    AS qtyentered,
    NULL    AS uomsymbol,
    t.name,
    NULL    AS description,
    NULL    AS documentnote,
    NULL    AS upc,
    NULL    AS sku,
    NULL    AS productvalue,
    NULL    AS resourcedescription,
    NULL    AS pricelist,
    NULL    AS priceenteredlist,
    NULL    AS discount,
    CASE WHEN ot.istaxincluded = 'Y' THEN ot.taxamt ELSE ot.taxbaseamt END AS priceactual,
    CASE WHEN ot.istaxincluded = 'Y' THEN ot.taxamt ELSE ot.taxbaseamt END AS priceentered,
    CASE WHEN ot.istaxincluded = 'Y' THEN NULL ELSE ot.taxamt END AS linenetamt,
    NULL    AS productdescription,
    NULL    AS imageurl,
    NULL    AS c_campaign_id,
    NULL    AS c_project_id,
    NULL    AS c_activity_id,
    NULL    AS c_projectphase_id,
    NULL    AS c_projecttask_id,
    NULL    AS c_orderline_ad_orgtrx_id,
    NULL    AS c_orderline_c_charge_id,
    NULL    AS c_orderline_c_currency_id,
    NULL    AS c_uom_id,
    NULL    AS datedelivered,
    NULL    AS dateinvoiced,
    NULL    AS dateordered,
    NULL    AS c_orderline_datepromised,
    NULL    AS c_orderline_freightamt,
    NULL    AS isdescription,
    NULL    AS link_orderline_id,
    NULL    AS m_promotion_id,
    NULL    AS c_orderline_m_shipper_id,
    NULL    AS c_orderline_m_warehouse_id,
    NULL    AS pricecost,
    NULL    AS pricelimit,
    NULL    AS c_orderline_processed,
    NULL    AS qtydelivered,
    NULL    AS qtyinvoiced,
    NULL    AS qtylostsales,
    NULL    AS qtyreserved,
    NULL    AS ref_orderline_id,
    NULL    AS rramt,
    NULL    AS rrstartdate,
    NULL    AS s_resourceassignment_id,
    NULL    AS c_orderline_user1_id,
    NULL    AS c_orderline_user2_id,
    NULL    AS c_uom_ad_org_id,
    NULL    AS costingprecision,
    NULL    AS c_uom_description,
    NULL    AS c_uom_isactive,
    NULL    AS isdefault,
    NULL    AS c_uom_name,
    NULL    AS stdprecision,
    NULL    AS uomtype,
    NULL    AS x12de355,
    NULL    AS c_order_ad_org_id,
    NULL    AS c_order_ad_orgtrx_id,
    NULL    AS ad_user_id,
    NULL    AS amountrefunded,
    NULL    AS amounttendered,
    NULL    AS bill_bpartner_id,
    NULL    AS bill_location_id,
    NULL    AS bill_user_id,
    NULL    AS c_order_c_activity_id,
    NULL    AS c_order_c_bpartner_id,
    NULL    AS c_order_c_campaign_id,
    NULL    AS c_cashline_id,
    NULL    AS c_cashplanline_id,
    NULL    AS c_order_c_charge_id,
    NULL    AS c_conversiontype_id,
    NULL    AS c_order_c_currency_id,
    NULL    AS c_doctype_id,
    NULL    AS c_doctypetarget_id,
    NULL    AS chargeamt,
    NULL    AS copyfrom,
    NULL    AS c_payment_id,
    NULL    AS c_paymentterm_id,
    NULL    AS c_pos_id,
    NULL    AS c_order_c_project_id,
    NULL    AS c_order_created,
    NULL    AS c_order_createdby,
    NULL    AS dateacct,
    NULL    AS dateprinted,
    NULL    AS c_order_datepromised,
    NULL    AS deliveryrule,
    NULL    AS deliveryviarule,
    NULL    AS c_order_description,
    NULL    AS docaction,
    NULL    AS docstatus,
    NULL    AS documentno,
    NULL    AS dropship_bpartner_id,
    NULL    AS dropship_location_id,
    NULL    AS dropship_user_id,
    NULL    AS c_order_freightamt,
    NULL    AS freightcostrule,
    NULL    AS grandtotal,
    NULL    AS invoicerule,
    NULL    AS c_order_isactive,
    NULL    AS isapproved,
    NULL    AS iscreditapproved,
    NULL    AS isdelivered,
    NULL    AS c_order_isdiscountprinted,
    NULL    AS c_order_isdropship,
    NULL    AS isinvoiced,
    NULL    AS ispayschedulevalid,
    NULL    AS isprinted,
    NULL    AS isselected,
    NULL    AS c_order_isselfservice,
    NULL    AS issotrx,
    NULL    AS istaxincluded,
    NULL    AS istransferred,
    NULL    AS link_order_id,
    NULL    AS c_order_m_freightcategory_id,
    NULL    AS c_order_m_pricelist_id,
    NULL    AS c_order_m_shipper_id,
    NULL    AS c_order_m_warehouse_id,
    NULL    AS ordertype,
    NULL    AS pay_bpartner_id,
    NULL    AS pay_location_id,
    NULL    AS c_order_paymentrule,
    NULL    AS poreference,
    NULL    AS posted,
    NULL    AS priorityrule,
    NULL    AS c_order_processed,
    NULL    AS processedon,
    NULL    AS promotioncode,
    NULL    AS ref_order_id,
    NULL    AS salesrep_id,
    NULL    AS c_order_sendemail,
    NULL    AS totallines,
    NULL    AS c_order_updated,
    NULL    AS c_order_updatedby,
    NULL    AS c_order_user1_id,
    NULL    AS c_order_user2_id,
    NULL    AS c_order_volume,
    NULL    AS c_order_weight,
    NULL    AS m_product_ad_org_id,
    NULL    AS classification,
    NULL    AS m_product_copyfrom,
    NULL    AS m_product_created,
    NULL    AS m_product_createdby,
    NULL    AS c_revenuerecognition_id,
    NULL    AS c_subscriptiontype_id,
    NULL    AS c_taxcategory_id,
    NULL    AS m_product_c_uom_id,
    NULL    AS descriptionurl,
    NULL    AS m_product_discontinued,
    NULL    AS m_product_discontinuedat,
    NULL    AS group1,
    NULL    AS group2,
    NULL    AS guaranteedays,
    NULL    AS guaranteedaysmin,
    NULL    AS help,
    NULL    AS m_product_isactive,
    NULL    AS isbom,
    NULL    AS m_product_isdropship,
    NULL    AS isexcludeautodelivery,
    NULL    AS isinvoiceprintdetails,
    NULL    AS ispicklistprintdetails,
    NULL    AS ispurchased,
    NULL    AS m_product_isselfservice,
    NULL    AS issold,
    NULL    AS isstocked,
    NULL    AS m_product_issummary,
    NULL    AS isverified,
    NULL    AS iswebstorefeatured,
    NULL    AS lowlevel,
    NULL    AS m_attributeset_id,
    NULL    AS m_attributesetinstance_id,
    NULL    AS m_product_m_freightcategory_id,
    NULL    AS m_locator_id,
    NULL    AS m_product_product_category_id,
    NULL    AS m_product_processing,
    NULL    AS producttype,
    NULL    AS r_mailtext_id,
    NULL    AS m_product_salesrep_id,
    NULL    AS s_expensetype_id,
    NULL    AS shelfdepth,
    NULL    AS shelfheight,
    NULL    AS shelfwidth,
    NULL    AS s_resource_id,
    NULL    AS unitsperpack,
    NULL    AS unitsperpallet,
    NULL    AS m_product_updated,
    NULL    AS m_product_updatedby,
    NULL    AS versionno,
    NULL    AS m_product_volume,
    NULL    AS m_product_weight,
    NULL    AS m_product_po_ad_org_id,
    NULL    AS m_product_po_c_bpartner_id,
    NULL    AS m_product_po_c_currency_id,
    NULL    AS costperorder,
    NULL    AS m_product_po_created,
    NULL    AS m_product_po_createdby,
    NULL    AS m_product_po_c_uom_id,
    NULL    AS deliverytime_actual,
    NULL    AS deliverytime_promised,
    NULL    AS m_product_po_discontinued,
    NULL    AS m_product_po_discontinuedat,
    NULL    AS m_product_po_isactive,
    NULL    AS iscurrentvendor,
    NULL    AS m_product_po_manufacturer,
    NULL    AS m_product_po_m_product_id,
    NULL    AS order_min,
    NULL    AS order_pack,
    NULL    AS priceeffective,
    NULL    AS pricelastinv,
    NULL    AS pricelastpo,
    NULL    AS m_product_po_pricelist,
    NULL    AS pricepo,
    NULL    AS m_product_po_qualityrating,
    NULL    AS royaltyamt,
    NULL    AS m_product_po_upc,
    NULL    AS m_product_po_updated,
    NULL    AS m_product_po_updatedby,
    NULL    AS m_product_po_vendorcategory,
    NULL    AS s_resourceassignment_ad_org_id,
    NULL    AS assigndatefrom,
    NULL    AS assigndateto,
    NULL    AS s_resourceassignment_created,
    NULL    AS s_resourceassignment_createby,
    NULL    AS s_resourceassignment_isactive,
    NULL    AS isconfirmed,
    NULL    AS s_resourceassignment_name,
    NULL    AS s_resourceassignment_qty,
    NULL    AS s_resourceassignment_s_resour,
    NULL    AS s_resourceassignment_updated,
    NULL    AS s_resourceassignment_updatedby,
    NULL    AS c_charge_c_org_id,
    NULL    AS c_charge_c_bpartner_id,
    NULL    AS c_chargetype_id,
    NULL    AS c_charge_chargeamt,
    NULL    AS c_charge_c_taxcategory_id,
    NULL    AS c_charge_description,
    NULL    AS c_charge_isactive,
    NULL    AS issamecurrency,
    NULL    AS issametax,
    NULL    AS c_charge_istaxincluded,
    NULL    AS c_bpartner_product_ad_org_id,
    NULL    AS c_bp_product_c_bpartner_id,
    NULL    AS c_bpartner_product_created,
    NULL    AS c_bpartner_product_createdby,
    NULL    AS c_bpartner_product_description,
    NULL    AS c_bpartner_product_isactive,
    NULL    AS ismanufacturer,
    NULL    AS c_bpartner_product_manufactur,
    NULL    AS c_bpartner_product_qualityrat,
    NULL    AS shelflifemindays,
    NULL    AS c_bpartner_product_shelflifem,
    NULL    AS c_bpartner_product_updated,
    NULL    AS c_bpartner_product_updatedby,
    NULL    AS c_bpartner_product_vendorcate,
    NULL    AS acqusitioncost,
    NULL    AS actuallifetimevalue,
    NULL    AS c_bpartner_ad_language,
    NULL    AS ad_orgbp_id,
    NULL    AS c_bpartner_ad_org_id,
    NULL    AS bpartner_parent_id,
    NULL    AS c_bp_group_id,
    NULL    AS c_dunning_id,
    NULL    AS c_greeting_id,
    NULL    AS c_invoiceschedule_id,
    NULL    AS c_bpartner_c_paymentterm_id,
    NULL    AS c_bpartner_created,
    NULL    AS c_bpartner_createdby,
    NULL    AS c_bpartner_c_taxgroup_id,
    NULL    AS c_bpartner_deliveryrule,
    NULL    AS c_bpartner_deliveryviarule,
    NULL    AS c_bpartner_description,
    NULL    AS c_bpartner_dunninggrace,
    NULL    AS duns,
    NULL    AS c_bpartner_firstsale,
    NULL    AS c_bpartner_flatdiscount,
    NULL    AS c_bpartner_freightcostrule,
    NULL    AS c_bpartner_invoicerule,
    NULL    AS c_bpartner_isactive,
    NULL    AS iscustomer,
    NULL    AS c_bpartner_isdiscountprinted,
    NULL    AS c_bpartner_isemployee,
    NULL    AS c_bpartner_ismanufacturer,
    NULL    AS isonetime,
    NULL    AS ispotaxexempt,
    NULL    AS isprospect,
    NULL    AS issalesrep,
    NULL    AS c_bpartner_issummary,
    NULL    AS c_bpartner_istaxexempt,
    NULL    AS isvendor,
    NULL    AS logo_id,
    NULL    AS m_discountschema_id,
    NULL    AS c_bpartner_m_pricelist_id,
    NULL    AS naics,
    NULL    AS c_bpartner_name,
    NULL    AS c_bpartner_name2,
    NULL    AS numberemployees,
    NULL    AS c_bpartner_paymentrule,
    NULL    AS paymentrulepo,
    NULL    AS po_discountschema_id,
    NULL    AS po_paymentterm_id,
    NULL    AS po_pricelist_id,
    NULL    AS c_bpartner_poreference,
    NULL    AS potentiallifetimevalue,
    NULL    AS c_bpartner_rating,
    NULL    AS c_bpartner_referenceno,
    NULL    AS c_bpartner_salesrep_id,
    NULL    AS salesvolume,
    NULL    AS c_bpartner_sendemail,
    NULL    AS shareofcustomer,
    NULL    AS c_bpartner_shelflifeminpct,
    NULL    AS so_creditlimit,
    NULL    AS socreditstatus,
    NULL    AS so_creditused,
    NULL    AS so_description,
    NULL    AS c_bpartner_taxid,
    NULL    AS totalopenbalance,
    NULL    AS c_bpartner_updated,
    NULL    AS c_bpartner_updatedby,
    NULL    AS c_bpartner_url,
    NULL    AS c_bpartner_value,
    NULL    AS c_bpartner_location_ad_org_id,
    NULL    AS c_bpartner_location_c_bpartne,
    NULL    AS c_bpartner_location_created,
    NULL    AS c_bpartner_location_createdby,
    NULL    AS c_salesregion_id,
    NULL    AS c_bpartner_location_fax,
    NULL    AS c_bpartner_location_isactive,
    NULL    AS isbillto,
    NULL    AS isdn,
    NULL    AS ispayfrom,
    NULL    AS isremitto,
    NULL    AS isshipto,
    NULL    AS c_bpartner_location_name,
    NULL    AS c_bpartner_location_phone,
    NULL    AS c_bpartner_location_phone2,
    NULL    AS c_bpartner_location_updated,
    NULL    AS c_bpartner_location_updatedby,
    NULL    AS c_tax_ad_org_id,
    NULL    AS ad_rule_id,
    NULL    AS c_country_id,
    NULL    AS c_region_id,
    NULL    AS c_tax_c_taxcategory_id,
    NULL    AS c_tax_description,
    NULL    AS c_tax_isactive,
    NULL    AS c_tax_isdefault,
    NULL    AS isdocumentlevel,
    NULL    AS issalestax,
    NULL    AS c_tax_issummary,
    NULL    AS c_tax_istaxexempt,
    NULL    AS c_tax_name,
    NULL    AS parent_tax_id,
    NULL    AS rate,
    NULL    AS requirestaxcertificate,
    NULL    AS sopotype,
    NULL    AS to_country_id,
    NULL    AS c_tax_to_region_id,
    NULL    AS validfrom 
FROM c_ordertax ot 
        JOIN c_tax t 
        ON ot.c_tax_id = t.c_tax_id
;

DROP VIEW c_order_linetax_vt;

CREATE OR REPLACE VIEW c_order_linetax_vt AS 
    (
        (   SELECT ol.ad_client_id,
                ol.ad_org_id,
                ol.isactive,
                ol.created,
                ol.createdby,
                ol.updated,
                ol.updatedby,
                uomt.ad_language,
                ol.c_order_id,
                ol.c_orderline_id,
                ol.c_tax_id,
                tt.taxindicator,
                ol.c_bpartner_id,
                ol.c_bpartner_location_id,
                bp.name                                   AS bpname,
                bpl.c_location_id,
                ol.line,
                pt.m_product_id,
                po.vendorproductno,
                CASE WHEN ol.qtyordered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.qtyordered ELSE NULL END                                   AS qtyordered,
                CASE WHEN ol.qtyentered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.qtyentered ELSE NULL END                                   AS qtyentered,
                CASE WHEN ol.qtyentered <> 0 OR ol.m_product_id IS NOT NULL THEN uomt.uomsymbol ELSE NULL END                                   AS uomsymbol,
                COALESCE(ct.name, (COALESCE(pt.name, p.name) || productattribute(ol.m_attributesetinstance_id)), ol.description)     AS name,
                CASE WHEN COALESCE(ct.name, pt.name, p.name) IS NOT NULL THEN ol.description ELSE NULL END                                   AS description,
                COALESCE(pt.documentnote, p.documentnote) AS documentnote,
                p.upc,
                p.sku,
                COALESCE(pp.vendorproductno, p.value)     AS productvalue,
                ra.description                            AS resourcedescription,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist <> 0 THEN ol.pricelist ELSE NULL END                                   AS pricelist,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist <> 0 AND ol.qtyentered <> 0 THEN ol.pricelist * ol.qtyordered / ol.qtyentered ELSE NULL END                                   AS 
                priceenteredlist,
                CASE WHEN i.isdiscountprinted = 'Y' AND ol.pricelist > ol.priceactual AND ol.pricelist <> 0 THEN (ol.pricelist - ol.priceactual) / ol.pricelist * 100 ELSE NULL END                                   
                AS discount,
                CASE WHEN ol.priceactual <> 0 OR ol.m_product_id IS NOT NULL THEN ol.priceactual ELSE NULL END                                   AS priceactual,
                CASE WHEN ol.priceentered <> 0 OR ol.m_product_id IS NOT NULL THEN ol.priceentered ELSE NULL END                                   AS priceentered,
                CASE WHEN ol.linenetamt <> 0 OR ol.m_product_id IS NOT NULL THEN ol.linenetamt ELSE NULL END                                   AS linenetamt,
                pt.description                            AS productdescription,
                p.imageurl,
                ol.c_campaign_id,
                ol.c_project_id,
                ol.c_activity_id,
                ol.c_projectphase_id,
                ol.c_projecttask_id,
                ol.ad_orgtrx_id                           AS c_orderline_ad_orgtrx_id,
                ol.c_charge_id                            AS c_orderline_c_charge_id,
                ol.c_currency_id                          AS c_orderline_c_currency_id,
                ol.c_uom_id,
                ol.datedelivered,
                ol.dateinvoiced,
                ol.dateordered,
                ol.datepromised                           AS c_orderline_datepromised,
                ol.freightamt                             AS c_orderline_freightamt,
                ol.isdescription,
                ol.link_orderline_id,
                ol.m_promotion_id,
                ol.m_shipper_id                           AS c_orderline_m_shipper_id,
                ol.m_warehouse_id                         AS c_orderline_m_warehouse_id,
                ol.pricecost,
                ol.pricelimit,
                ol.processed                              AS c_orderline_processed,
                ol.qtydelivered,
                ol.qtyinvoiced,
                ol.qtylostsales,
                ol.qtyreserved,
                ol.ref_orderline_id,
                ol.rramt,
                ol.rrstartdate,
                ol.s_resourceassignment_id,
                ol.user1_id                               AS c_orderline_user1_id,
                ol.user2_id                               AS c_orderline_user2_id,
                uomt.ad_org_id                            AS c_uom_ad_org_id,
                uom.costingprecision,
                uomt.description                          AS c_uom_description,
                uomt.isactive                             AS c_uom_isactive,
                uom.isdefault,
                uomt.name                                 AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                i.ad_org_id                               AS c_order_ad_org_id,
                i.ad_orgtrx_id                            AS c_order_ad_orgtrx_id,
                i.ad_user_id,
                i.amountrefunded,
                i.amounttendered,
                i.bill_bpartner_id,
                i.bill_location_id,
                i.bill_user_id,
                i.c_activity_id                           AS c_order_c_activity_id,
                i.c_bpartner_id                           AS c_order_c_bpartner_id,
                i.c_campaign_id                           AS c_order_c_campaign_id,
                i.c_cashline_id,
                i.c_cashplanline_id,
                i.c_charge_id                             AS c_order_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id                           AS c_order_c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.chargeamt,
                i.copyfrom,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_pos_id,
                i.c_project_id                            AS c_order_c_project_id,
                i.created                                 AS c_order_created,
                i.createdby                               AS c_order_createdby,
                i.dateacct,
                i.dateprinted,
                i.datepromised                            AS c_order_datepromised,
                i.deliveryrule,
                i.deliveryviarule,
                i.description                             AS c_order_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dropship_bpartner_id,
                i.dropship_location_id,
                i.dropship_user_id,
                i.freightamt                              AS c_order_freightamt,
                i.freightcostrule,
                i.grandtotal,
                i.invoicerule,
                i.isactive                                AS c_order_isactive,
                i.isapproved,
                i.iscreditapproved,
                i.isdelivered,
                i.isdiscountprinted                       AS c_order_isdiscountprinted,
                i.isdropship                              AS c_order_isdropship,
                i.isinvoiced,
                i.ispayschedulevalid,
                i.isprinted,
                i.isselected,
                i.isselfservice                           AS c_order_isselfservice,
                i.issotrx,
                i.istaxincluded,
                i.istransferred,
                i.link_order_id,
                i.m_freightcategory_id                    AS c_order_m_freightcategory_id,
                i.m_pricelist_id                          AS c_order_m_pricelist_id,
                i.m_shipper_id                            AS c_order_m_shipper_id,
                i.m_warehouse_id                          AS c_order_m_warehouse_id,
                i.ordertype,
                i.pay_bpartner_id,
                i.pay_location_id,
                i.paymentrule                             AS c_order_paymentrule,
                i.poreference,
                i.posted,
                i.priorityrule,
                i.processed                               AS c_order_processed,
                i.processedon,
                i.promotioncode,
                i.ref_order_id,
                i.salesrep_id,
                i.sendemail                               AS c_order_sendemail,
                i.totallines,
                i.updated                                 AS c_order_updated,
                i.updatedby                               AS c_order_updatedby,
                i.user1_id                                AS c_order_user1_id,
                i.user2_id                                AS c_order_user2_id,
                i.volume                                  AS c_order_volume,
                i.weight                                  AS c_order_weight,
                pt.ad_org_id                              AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                                AS m_product_copyfrom,
                pt.created                                AS m_product_created,
                pt.createdby                              AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id,
                p.c_uom_id                                AS m_product_c_uom_id,
                p.descriptionurl,
                p.discontinued                            AS m_product_discontinued,
                p.discontinuedat                          AS m_product_discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                pt.isactive                               AS m_product_isactive,
                p.isbom,
                p.isdropship                              AS m_product_isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice                           AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                               AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id,
                p.m_attributesetinstance_id,
                p.m_freightcategory_id                    AS m_product_m_freightcategory_id,
                p.m_locator_id,
                p.m_product_category_id                   AS m_product_product_category_id,
                p.processing                              AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id                             AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                pt.updated                                AS m_product_updated,
                pt.updatedby                              AS m_product_updatedby,
                p.versionno,
                p.volume                                  AS m_product_volume,
                p.weight                                  AS m_product_weight,
                po.ad_org_id                              AS m_product_po_ad_org_id,
                po.c_bpartner_id                          AS m_product_po_c_bpartner_id,
                po.c_currency_id                          AS m_product_po_c_currency_id,
                po.costperorder,
                po.created                                AS m_product_po_created,
                po.createdby                              AS m_product_po_createdby,
                po.c_uom_id                               AS m_product_po_c_uom_id,
                po.deliverytime_actual,
                po.deliverytime_promised,
                po.discontinued                           AS m_product_po_discontinued,
                po.discontinuedat                         AS m_product_po_discontinuedat,
                po.isactive                               AS m_product_po_isactive,
                po.iscurrentvendor,
                po.manufacturer                           AS m_product_po_manufacturer,
                po.m_product_id                           AS m_product_po_m_product_id,
                po.order_min,
                po.order_pack,
                po.priceeffective,
                po.pricelastinv,
                po.pricelastpo,
                po.pricelist                              AS m_product_po_pricelist,
                po.pricepo,
                po.qualityrating                          AS m_product_po_qualityrating,
                po.royaltyamt,
                po.upc                                    AS m_product_po_upc,
                po.updated                                AS m_product_po_updated,
                po.updatedby                              AS m_product_po_updatedby,
                po.vendorcategory                         AS m_product_po_vendorcategory,
                ra.ad_org_id                              AS s_resourceassignment_ad_org_id,
                ra.assigndatefrom,
                ra.assigndateto,
                ra.created                                AS s_resourceassignment_created,
                ra.createdby                              AS s_resourceassignment_createby,
                ra.isactive                               AS s_resourceassignment_isactive,
                ra.isconfirmed,
                ra.name                                   AS s_resourceassignment_name,
                ra.qty                                    AS s_resourceassignment_qty,
                ra.s_resource_id                          AS s_resourceassignment_s_resour,
                ra.updated                                AS s_resourceassignment_updated,
                ra.updatedby                              AS s_resourceassignment_updatedby,
                ct.ad_org_id                              AS c_charge_c_org_id,
                c.c_bpartner_id                           AS c_charge_c_bpartner_id,
                c.c_chargetype_id,
                c.chargeamt                               AS c_charge_chargeamt,
                c.c_taxcategory_id                        AS c_charge_c_taxcategory_id,
                c.description                             AS c_charge_description,
                ct.isactive                               AS c_charge_isactive,
                c.issamecurrency,
                c.issametax,
                c.istaxincluded                           AS c_charge_istaxincluded,
                pp.ad_org_id                              AS c_bpartner_product_ad_org_id,
                pp.c_bpartner_id                          AS c_bp_product_c_bpartner_id,
                pp.created                                AS c_bpartner_product_created,
                pp.createdby                              AS c_bpartner_product_createdby,
                pp.description                            AS c_bpartner_product_descriptio,
                pp.isactive                               AS c_bpartner_product_isactive,
                pp.ismanufacturer,
                pp.manufacturer                           AS c_bpartner_product_manufactur,
                pp.qualityrating                          AS c_bpartner_product_qualityrat,
                pp.shelflifemindays,
                pp.shelflifeminpct                        AS c_bpartner_product_shelflifem,
                pp.updated                                AS c_bpartner_product_updated,
                pp.updatedby                              AS c_bpartner_product_updatedby,
                pp.vendorcategory                         AS c_bpartner_product_vendorcate,
                bp.acqusitioncost,
                bp.actuallifetimevalue,
                bp.ad_language                            AS c_bpartner_ad_language,
                bp.ad_orgbp_id,
                bp.ad_org_id                              AS c_bpartner_ad_org_id,
                bp.bpartner_parent_id,
                bp.c_bp_group_id,
                bp.c_dunning_id,
                bp.c_greeting_id,
                bp.c_invoiceschedule_id,
                bp.c_paymentterm_id                       AS c_bpartner_c_paymentterm_id,
                bp.created                                AS c_bpartner_created,
                bp.createdby                              AS c_bpartner_createdby,
                bp.c_taxgroup_id                          AS c_bpartner_c_taxgroup_id,
                bp.deliveryrule                           AS c_bpartner_deliveryrule,
                bp.deliveryviarule                        AS c_bpartner_deliveryviarule,
                bp.description                            AS c_bpartner_description,
                bp.dunninggrace                           AS c_bpartner_dunninggrace,
                bp.duns,
                bp.firstsale                              AS c_bpartner_firstsale,
                bp.flatdiscount                           AS c_bpartner_flatdiscount,
                bp.freightcostrule                        AS c_bpartner_freightcostrule,
                bp.invoicerule                            AS c_bpartner_invoicerule,
                bp.isactive                               AS c_bpartner_isactive,
                bp.iscustomer,
                bp.isdiscountprinted                      AS c_bpartner_isdiscountprinted,
                bp.isemployee                             AS c_bpartner_isemployee,
                bp.ismanufacturer                         AS c_bpartner_ismanufacturer,
                bp.isonetime,
                bp.ispotaxexempt,
                bp.isprospect,
                bp.issalesrep,
                bp.issummary                              AS c_bpartner_issummary,
                bp.istaxexempt                            AS c_bpartner_istaxexempt,
                bp.isvendor,
                bp.logo_id,
                bp.m_discountschema_id,
                bp.m_pricelist_id                         AS c_bpartner_m_pricelist_id,
                bp.naics,
                bp.name                                   AS c_bpartner_name,
                bp.name2                                  AS c_bpartner_name2,
                bp.numberemployees,
                bp.paymentrule                            AS c_bpartner_paymentrule,
                bp.paymentrulepo,
                bp.po_discountschema_id,
                bp.po_paymentterm_id,
                bp.po_pricelist_id,
                bp.poreference                            AS c_bpartner_poreference,
                bp.potentiallifetimevalue,
                bp.rating                                 AS c_bpartner_rating,
                bp.referenceno                            AS c_bpartner_referenceno,
                bp.salesrep_id                            AS c_bpartner_salesrep_id,
                bp.salesvolume,
                bp.sendemail                              AS c_bpartner_sendemail,
                bp.shareofcustomer,
                bp.shelflifeminpct                        AS c_bpartner_shelflifeminpct,
                bp.so_creditlimit,
                bp.socreditstatus,
                bp.so_creditused,
                bp.so_description,
                bp.taxid                                  AS c_bpartner_taxid,
                bp.totalopenbalance,
                bp.updated                                AS c_bpartner_updated,
                bp.updatedby                              AS c_bpartner_updatedby,
                bp.url                                    AS c_bpartner_url,
                bp.value                                  AS c_bpartner_value,
                bpl.ad_org_id                             AS c_bpartner_location_ad_org_id,
                bpl.c_bpartner_id                         AS c_bpartner_location_c_bpartne,
                bpl.created                               AS c_bpartner_location_created,
                bpl.createdby                             AS c_bpartner_location_createdby,
                bpl.c_salesregion_id,
                bpl.fax                                   AS c_bpartner_location_fax,
                bpl.isactive                              AS c_bpartner_location_isactive,
                bpl.isbillto,
                bpl.isdn,
                bpl.ispayfrom,
                bpl.isremitto,
                bpl.isshipto,
                bpl.name                                  AS c_bpartner_location_name,
                bpl.phone                                 AS c_bpartner_location_phone,
                bpl.phone2                                AS c_bpartner_location_phone2,
                bpl.updated                               AS c_bpartner_location_updated,
                bpl.updatedby                             AS c_bpartner_location_updatedby,
                tt.ad_org_id                              AS c_tax_ad_org_id,
                t.ad_rule_id,
                t.c_country_id,
                t.c_region_id,
                t.c_taxcategory_id                        AS c_tax_c_taxcategory_id,
                tt.description                            AS c_tax_description,
                tt.isactive                               AS c_tax_isactive,
                t.isdefault                               AS c_tax_isdefault,
                t.isdocumentlevel,
                t.issalestax,
                t.issummary                               AS c_tax_issummary,
                t.istaxexempt                             AS c_tax_istaxexempt,
                tt.name                                   AS c_tax_name,
                t.parent_tax_id,
                t.rate,
                t.requirestaxcertificate,
                t.sopotype,
                t.to_country_id,
                t.to_region_id                            AS c_tax_to_region_id,
                t.validfrom 
            FROM c_orderline ol 
                JOIN c_uom uom 
                ON ol.c_uom_id = uom.c_uom_id 
                JOIN c_uom_trl uomt 
                ON ol.c_uom_id = uomt.c_uom_id 
                JOIN c_order i 
                ON ol.c_order_id = i.c_order_id 
                LEFT JOIN m_product p 
                ON ol.m_product_id = p.m_product_id 
                LEFT JOIN m_product_trl pt 
                ON ol.m_product_id = pt.m_product_id AND uomt.ad_language = pt.ad_language 
                LEFT JOIN m_product_po po 
                ON p.m_product_id = po.m_product_id AND i.c_bpartner_id = po.c_bpartner_id 
                LEFT JOIN s_resourceassignment ra 
                ON ol.s_resourceassignment_id = ra.s_resourceassignment_id 
                LEFT JOIN c_charge c 
                ON ol.c_charge_id = c.c_charge_id 
                LEFT JOIN c_charge_trl ct 
                ON ol.c_charge_id = ct.c_charge_id AND uomt.ad_language = ct.ad_language 
                LEFT JOIN c_bpartner_product pp 
                ON ol.m_product_id = pp.m_product_id AND i.c_bpartner_id = pp.c_bpartner_id 
                JOIN c_bpartner bp 
                ON ol.c_bpartner_id = bp.c_bpartner_id 
                JOIN c_bpartner_location bpl 
                ON ol.c_bpartner_location_id = bpl.c_bpartner_location_id 
                LEFT JOIN c_tax t 
                ON ol.c_tax_id = t.c_tax_id 
                LEFT JOIN c_tax_trl tt 
                ON ol.c_tax_id = tt.c_tax_id AND uomt.ad_language = tt.ad_language 
                UNION SELECT ol.ad_client_id,
                        ol.ad_org_id,
                        ol.isactive,
                        ol.created,
                        ol.createdby,
                        ol.updated,
                        ol.updatedby,
                        uomt.ad_language,
                        ol.c_order_id,
                        ol.c_orderline_id,
                        ol.c_tax_id,
                        NULL                    AS taxindicator,
                        NULL                    AS c_bpartner_id,
                        NULL                    AS c_bpartner_location_id,
                        NULL                    AS bpname,
                        NULL                    AS c_location_id,
                        ol.line + bl.line / 100 AS line,
                        pt.m_product_id,
                        po.vendorproductno,
                        CASE WHEN bl.isqtypercentage = 'N' THEN ol.qtyordered * bl.qtybom ELSE ol.qtyordered * (bl.qtybatch / 100) END                 AS qtyordered,
                        CASE WHEN bl.isqtypercentage = 'N' THEN ol.qtyentered * bl.qtybom ELSE ol.qtyentered * (bl.qtybatch / 100) END                 AS qtyentered,
                        uomt.uomsymbol,
                        pt.name,
                        bl.description,
                        pt.documentnote,
                        p.upc,
                        p.sku,
                        p.value                 AS productvalue,
                        NULL                    AS resourcedescription,
                        NULL                    AS pricelist,
                        NULL                    AS priceenteredlist,
                        NULL                    AS discount,
                        NULL                    AS priceactual,
                        NULL                    AS priceentered,
                        NULL                    AS linenetamt,
                        pt.description          AS productdescription,
                        p.imageurl,
                        ol.c_campaign_id,
                        ol.c_project_id,
                        ol.c_activity_id,
                        ol.c_projectphase_id,
                        ol.c_projecttask_id,
                        ol.ad_orgtrx_id         AS c_orderline_ad_orgtrx_id,
                        ol.c_charge_id          AS c_orderline_c_charge_id,
                        ol.c_currency_id        AS c_orderline_c_currency_id,
                        ol.c_uom_id,
                        ol.datedelivered,
                        ol.dateinvoiced,
                        ol.dateordered,
                        ol.datepromised         AS c_orderline_datepromised,
                        ol.freightamt           AS c_orderline_freightamt,
                        ol.isdescription,
                        ol.link_orderline_id,
                        ol.m_promotion_id,
                        ol.m_shipper_id         AS c_orderline_m_shipper_id,
                        ol.m_warehouse_id       AS c_orderline_m_warehouse_id,
                        ol.pricecost,
                        ol.pricelimit,
                        ol.processed            AS c_orderline_processed,
                        ol.qtydelivered,
                        ol.qtyinvoiced,
                        ol.qtylostsales,
                        ol.qtyreserved,
                        ol.ref_orderline_id,
                        ol.rramt,
                        ol.rrstartdate,
                        ol.s_resourceassignment_id,
                        ol.user1_id             AS c_orderline_user1_id,
                        ol.user2_id             AS c_orderline_user2_id,
                        uomt.ad_org_id          AS c_uom_ad_org_id,
                        uom.costingprecision,
                        uom.description         AS c_uom_description,
                        uomt.isactive           AS c_uom_isactive,
                        uom.isdefault,
                        uomt.name               AS c_uom_name,
                        uom.stdprecision,
                        uom.uomtype,
                        uom.x12de355,
                        i.ad_org_id             AS c_order_ad_org_id,
                        i.ad_orgtrx_id          AS c_order_ad_orgtrx_id,
                        i.ad_user_id,
                        i.amountrefunded,
                        i.amounttendered,
                        i.bill_bpartner_id,
                        i.bill_location_id,
                        i.bill_user_id,
                        i.c_activity_id         AS c_order_c_activity_id,
                        i.c_bpartner_id         AS c_order_c_bpartner_id,
                        i.c_campaign_id         AS c_order_c_campaign_id,
                        i.c_cashline_id,
                        i.c_cashplanline_id,
                        i.c_charge_id           AS c_order_c_charge_id,
                        i.c_conversiontype_id,
                        i.c_currency_id         AS c_order_c_currency_id,
                        i.c_doctype_id,
                        i.c_doctypetarget_id,
                        i.chargeamt,
                        i.copyfrom,
                        i.c_payment_id,
                        i.c_paymentterm_id,
                        i.c_pos_id,
                        i.c_project_id          AS c_order_c_project_id,
                        i.created               AS c_order_created,
                        i.createdby             AS c_order_createdby,
                        i.dateacct,
                        i.dateprinted,
                        i.datepromised          AS c_order_datepromised,
                        i.deliveryrule,
                        i.deliveryviarule,
                        i.description           AS c_order_description,
                        i.docaction,
                        i.docstatus,
                        i.documentno,
                        i.dropship_bpartner_id,
                        i.dropship_location_id,
                        i.dropship_user_id,
                        i.freightamt            AS c_order_freightamt,
                        i.freightcostrule,
                        i.grandtotal,
                        i.invoicerule,
                        i.isactive              AS c_order_isactive,
                        i.isapproved,
                        i.iscreditapproved,
                        i.isdelivered,
                        i.isdiscountprinted     AS c_order_isdiscountprinted,
                        i.isdropship            AS c_order_isdropship,
                        i.isinvoiced,
                        i.ispayschedulevalid,
                        i.isprinted,
                        i.isselected,
                        i.isselfservice         AS c_order_isselfservice,
                        i.issotrx,
                        i.istaxincluded,
                        i.istransferred,
                        i.link_order_id,
                        i.m_freightcategory_id  AS c_order_m_freightcategory_id,
                        i.m_pricelist_id        AS c_order_m_pricelist_id,
                        i.m_shipper_id          AS c_order_m_shipper_id,
                        i.m_warehouse_id        AS c_order_m_warehouse_id,
                        i.ordertype,
                        i.pay_bpartner_id,
                        i.pay_location_id,
                        i.paymentrule           AS c_order_paymentrule,
                        i.poreference,
                        i.posted,
                        i.priorityrule,
                        i.processed             AS c_order_processed,
                        i.processedon,
                        i.promotioncode,
                        i.ref_order_id,
                        i.salesrep_id,
                        i.sendemail             AS c_order_sendemail,
                        i.totallines,
                        i.updated               AS c_order_updated,
                        i.updatedby             AS c_order_updatedby,
                        i.user1_id              AS c_order_user1_id,
                        i.user2_id              AS c_order_user2_id,
                        i.volume                AS c_order_volume,
                        i.weight                AS c_order_weight,
                        pt.ad_org_id            AS m_product_ad_org_id,
                        p.classification,
                        p.copyfrom              AS m_product_copyfrom,
                        pt.created              AS m_product_created,
                        pt.createdby            AS m_product_createdby,
                        p.c_revenuerecognition_id,
                        p.c_subscriptiontype_id,
                        p.c_taxcategory_id,
                        p.c_uom_id              AS m_product_c_uom_id,
                        p.descriptionurl,
                        p.discontinued          AS m_product_discontinued,
                        p.discontinuedat        AS m_product_discontinuedat,
                        p.group1,
                        p.group2,
                        p.guaranteedays,
                        p.guaranteedaysmin,
                        p.help,
                        pt.isactive             AS m_product_isactive,
                        p.isbom,
                        p.isdropship            AS m_product_isdropship,
                        p.isexcludeautodelivery,
                        p.isinvoiceprintdetails,
                        p.ispicklistprintdetails,
                        p.ispurchased,
                        p.isselfservice         AS m_product_isselfservice,
                        p.issold,
                        p.isstocked,
                        p.issummary             AS m_product_issummary,
                        p.isverified,
                        p.iswebstorefeatured,
                        p.lowlevel,
                        p.m_attributeset_id,
                        p.m_attributesetinstance_id,
                        p.m_freightcategory_id  AS m_product_m_freightcategory_id,
                        p.m_locator_id,
                        p.m_product_category_id AS m_product_product_category_id,
                        p.processing            AS m_product_processing,
                        p.producttype,
                        p.r_mailtext_id,
                        p.salesrep_id           AS m_product_salesrep_id,
                        p.s_expensetype_id,
                        p.shelfdepth,
                        p.shelfheight,
                        p.shelfwidth,
                        p.s_resource_id,
                        p.unitsperpack,
                        p.unitsperpallet,
                        p.updated               AS m_product_updated,
                        p.updatedby             AS m_product_updatedby,
                        p.versionno,
                        p.volume                AS m_product_volume,
                        p.weight                AS m_product_weight,
                        po.ad_org_id            AS m_product_po_ad_org_id,
                        po.c_bpartner_id        AS m_product_po_c_bpartner_id,
                        po.c_currency_id        AS m_product_po_c_currency_id,
                        po.costperorder,
                        po.created              AS m_product_po_created,
                        po.createdby            AS m_product_po_createdby,
                        po.c_uom_id             AS m_product_po_c_uom_id,
                        po.deliverytime_actual,
                        po.deliverytime_promised,
                        po.discontinued         AS m_product_po_discontinued,
                        po.discontinuedat       AS m_product_po_discontinuedat,
                        po.isactive             AS m_product_po_isactive,
                        po.iscurrentvendor,
                        po.manufacturer         AS m_product_po_manufacturer,
                        po.m_product_id         AS m_product_po_m_product_id,
                        po.order_min,
                        po.order_pack,
                        po.priceeffective,
                        po.pricelastinv,
                        po.pricelastpo,
                        po.pricelist            AS m_product_po_pricelist,
                        po.pricepo,
                        po.qualityrating        AS m_product_po_qualityrating,
                        po.royaltyamt,
                        po.upc                  AS m_product_po_upc,
                        po.updated              AS m_product_po_updated,
                        po.updatedby            AS m_product_po_updatedby,
                        po.vendorcategory       AS m_product_po_vendorcategory,
                        NULL                    AS s_resourceassignment_ad_org_id,
                        NULL                    AS assigndatefrom,
                        NULL                    AS assigndateto,
                        NULL                    AS s_resourceassignment_created,
                        NULL                    AS s_resourceassignment_createby,
                        NULL                    AS s_resourceassignment_isactive,
                        NULL                    AS isconfirmed,
                        NULL                    AS s_resourceassignment_name,
                        NULL                    AS s_resourceassignment_qty,
                        NULL                    AS s_resourceassignment_s_resour,
                        NULL                    AS s_resourceassignment_updated,
                        NULL                    AS s_resourceassignment_updatedby,
                        NULL                    AS c_charge_c_org_id,
                        NULL                    AS c_charge_c_bpartner_id,
                        NULL                    AS c_chargetype_id,
                        NULL                    AS c_charge_chargeamt,
                        NULL                    AS c_charge_c_taxcategory_id,
                        NULL                    AS c_charge_description,
                        NULL                    AS c_charge_isactive,
                        NULL                    AS issamecurrency,
                        NULL                    AS issametax,
                        NULL                    AS c_charge_istaxincluded,
                        NULL                    AS c_bpartner_product_ad_org_id,
                        NULL                    AS c_bp_product_c_bpartner_id,
                        NULL                    AS c_bpartner_product_created,
                        NULL                    AS c_bpartner_product_createdby,
                        NULL                    AS c_bpartner_product_descriptio,
                        NULL                    AS c_bpartner_product_isactive,
                        NULL                    AS ismanufacturer,
                        NULL                    AS c_bpartner_product_manufactur,
                        NULL                    AS c_bpartner_product_qualityrat,
                        NULL                    AS shelflifemindays,
                        NULL                    AS c_bpartner_product_shelflifem,
                        NULL                    AS c_bpartner_product_updated,
                        NULL                    AS c_bpartner_product_updatedby,
                        NULL                    AS c_bpartner_product_vendorcate,
                        NULL                    AS acqusitioncost,
                        NULL                    AS actuallifetimevalue,
                        NULL                    AS c_bpartner_ad_language,
                        NULL                    AS ad_orgbp_id,
                        NULL                    AS c_bpartner_ad_org_id,
                        NULL                    AS bpartner_parent_id,
                        NULL                    AS c_bp_group_id,
                        NULL                    AS c_dunning_id,
                        NULL                    AS c_greeting_id,
                        NULL                    AS c_invoiceschedule_id,
                        NULL                    AS c_bpartner_c_paymentterm_id,
                        NULL                    AS c_bpartner_created,
                        NULL                    AS c_bpartner_createdby,
                        NULL                    AS c_bpartner_c_taxgroup_id,
                        NULL                    AS c_bpartner_deliveryrule,
                        NULL                    AS c_bpartner_deliveryviarule,
                        NULL                    AS c_bpartner_description,
                        NULL                    AS c_bpartner_dunninggrace,
                        NULL                    AS duns,
                        NULL                    AS c_bpartner_firstsale,
                        NULL                    AS c_bpartner_flatdiscount,
                        NULL                    AS c_bpartner_freightcostrule,
                        NULL                    AS c_bpartner_invoicerule,
                        NULL                    AS c_bpartner_isactive,
                        NULL                    AS iscustomer,
                        NULL                    AS c_bpartner_isdiscountprinted,
                        NULL                    AS c_bpartner_isemployee,
                        NULL                    AS c_bpartner_ismanufacturer,
                        NULL                    AS isonetime,
                        NULL                    AS ispotaxexempt,
                        NULL                    AS isprospect,
                        NULL                    AS issalesrep,
                        NULL                    AS c_bpartner_issummary,
                        NULL                    AS c_bpartner_istaxexempt,
                        NULL                    AS isvendor,
                        NULL                    AS logo_id,
                        NULL                    AS m_discountschema_id,
                        NULL                    AS c_bpartner_m_pricelist_id,
                        NULL                    AS naics,
                        NULL                    AS c_bpartner_name,
                        NULL                    AS c_bpartner_name2,
                        NULL                    AS numberemployees,
                        NULL                    AS c_bpartner_paymentrule,
                        NULL                    AS paymentrulepo,
                        NULL                    AS po_discountschema_id,
                        NULL                    AS po_paymentterm_id,
                        NULL                    AS po_pricelist_id,
                        NULL                    AS c_bpartner_poreference,
                        NULL                    AS potentiallifetimevalue,
                        NULL                    AS c_bpartner_rating,
                        NULL                    AS c_bpartner_referenceno,
                        NULL                    AS c_bpartner_salesrep_id,
                        NULL                    AS salesvolume,
                        NULL                    AS c_bpartner_sendemail,
                        NULL                    AS shareofcustomer,
                        NULL                    AS c_bpartner_shelflifeminpct,
                        NULL                    AS so_creditlimit,
                        NULL                    AS socreditstatus,
                        NULL                    AS so_creditused,
                        NULL                    AS so_description,
                        NULL                    AS c_bpartner_taxid,
                        NULL                    AS totalopenbalance,
                        NULL                    AS c_bpartner_updated,
                        NULL                    AS c_bpartner_updatedby,
                        NULL                    AS c_bpartner_url,
                        NULL                    AS c_bpartner_value,
                        NULL                    AS c_bpartner_location_ad_org_id,
                        NULL                    AS c_bpartner_location_c_bpartne,
                        NULL                    AS c_bpartner_location_created,
                        NULL                    AS c_bpartner_location_createdby,
                        NULL                    AS c_salesregion_id,
                        NULL                    AS c_bpartner_location_fax,
                        NULL                    AS c_bpartner_location_isactive,
                        NULL                    AS isbillto,
                        NULL                    AS isdn,
                        NULL                    AS ispayfrom,
                        NULL                    AS isremitto,
                        NULL                    AS isshipto,
                        NULL                    AS c_bpartner_location_name,
                        NULL                    AS c_bpartner_location_phone,
                        NULL                    AS c_bpartner_location_phone2,
                        NULL                    AS c_bpartner_location_updated,
                        NULL                    AS c_bpartner_location_updatedby,
                        NULL                    AS c_tax_ad_org_id,
                        NULL                    AS ad_rule_id,
                        NULL                    AS c_country_id,
                        NULL                    AS c_region_id,
                        NULL                    AS c_tax_c_taxcategory_id,
                        NULL                    AS c_tax_description,
                        NULL                    AS c_tax_isactive,
                        NULL                    AS c_tax_isdefault,
                        NULL                    AS isdocumentlevel,
                        NULL                    AS issalestax,
                        NULL                    AS c_tax_issummary,
                        NULL                    AS c_tax_istaxexempt,
                        NULL                    AS c_tax_name,
                        NULL                    AS parent_tax_id,
                        NULL                    AS rate,
                        NULL                    AS requirestaxcertificate,
                        NULL                    AS sopotype,
                        NULL                    AS to_country_id,
                        NULL                    AS c_tax_to_region_id,
                        NULL                    AS validfrom 
                    FROM pp_product_bom b 
                        JOIN c_orderline ol 
                        ON b.m_product_id = ol.m_product_id 
                        JOIN c_order i 
                        ON ol.c_order_id = i.c_order_id 
                        JOIN m_product bp 
                        ON bp.m_product_id = ol.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.isinvoiceprintdetails = 'Y' 
                        JOIN pp_product_bomline bl 
                        ON bl.pp_product_bom_id = b.pp_product_bom_id 
                        JOIN m_product p 
                        ON p.m_product_id = bl.m_product_id 
                        LEFT JOIN m_product_po po 
                        ON p.m_product_id = po.m_product_id AND i.c_bpartner_id = po.c_bpartner_id 
                        JOIN c_uom uom 
                        ON ol.c_uom_id = uom.c_uom_id 
                        JOIN c_uom_trl uomt 
                        ON p.c_uom_id = uomt.c_uom_id 
                        JOIN m_product_trl pt 
                        ON pt.m_product_id = bl.m_product_id AND uomt.ad_language = pt.ad_language) 
    UNION   SELECT i.ad_client_id,
                i.ad_org_id,
                i.isactive,
                i.created,
                i.createdby,
                i.updated,
                i.updatedby,
                'en_US'::character varying(6) AS ad_language,
                i.c_order_id,
                NULL                          AS c_orderline_id,
                NULL                          AS c_tax_id,
                NULL                          AS taxindicator,
                NULL                          AS c_bpartner_id,
                NULL                          AS c_bpartner_location_id,
                NULL                          AS bpname,
                NULL                          AS c_location_id,
                NULL                          AS line,
                NULL                          AS m_product_id,
                NULL                          AS vendorproductno,
                NULL                          AS qtyordered,
                NULL                          AS qtyentered,
                NULL                          AS uomsymbol,
                NULL                          AS name,
                NULL                          AS description,
                NULL                          AS documentnote,
                NULL                          AS upc,
                NULL                          AS sku,
                NULL                          AS productvalue,
                NULL                          AS resourcedescription,
                NULL                          AS pricelist,
                NULL                          AS priceenteredlist,
                NULL                          AS discount,
                NULL                          AS priceactual,
                NULL                          AS priceentered,
                NULL                          AS linenetamt,
                NULL                          AS productdescription,
                NULL                          AS imageurl,
                NULL                          AS c_campaign_id,
                NULL                          AS c_project_id,
                NULL                          AS c_activity_id,
                NULL                          AS c_projectphase_id,
                NULL                          AS c_projecttask_id,
                NULL                          AS c_orderline_ad_orgtrx_id,
                NULL                          AS c_orderline_c_charge_id,
                NULL                          AS c_orderline_c_currency_id,
                NULL                          AS c_uom_id,
                NULL                          AS datedelivered,
                NULL                          AS dateinvoiced,
                NULL                          AS dateordered,
                NULL                          AS c_orderline_datepromised,
                NULL                          AS c_orderline_freightamt,
                NULL                          AS isdescription,
                NULL                          AS link_orderline_id,
                NULL                          AS m_promotion_id,
                NULL                          AS c_orderline_m_shipper_id,
                NULL                          AS c_orderline_m_warehouse_id,
                NULL                          AS pricecost,
                NULL                          AS pricelimit,
                NULL                          AS c_orderline_processed,
                NULL                          AS qtydelivered,
                NULL                          AS qtyinvoiced,
                NULL                          AS qtylostsales,
                NULL                          AS qtyreserved,
                NULL                          AS ref_orderline_id,
                NULL                          AS rramt,
                NULL                          AS rrstartdate,
                NULL                          AS s_resourceassignment_id,
                NULL                          AS c_orderline_user1_id,
                NULL                          AS c_orderline_user2_id,
                NULL                          AS c_uom_ad_org_id,
                NULL                          AS costingprecision,
                NULL                          AS c_uom_description,
                NULL                          AS c_uom_isactive,
                NULL                          AS isdefault,
                NULL                          AS c_uom_name,
                NULL                          AS stdprecision,
                NULL                          AS uomtype,
                NULL                          AS x12de355,
                i.ad_org_id                   AS c_order_ad_org_id,
                i.ad_orgtrx_id                AS c_order_ad_orgtrx_id,
                i.ad_user_id,
                i.amountrefunded,
                i.amounttendered,
                i.bill_bpartner_id,
                i.bill_location_id,
                i.bill_user_id,
                i.c_activity_id               AS c_order_c_activity_id,
                i.c_bpartner_id               AS c_order_c_bpartner_id,
                i.c_campaign_id               AS c_order_c_campaign_id,
                i.c_cashline_id,
                i.c_cashplanline_id,
                i.c_charge_id                 AS c_order_c_charge_id,
                i.c_conversiontype_id,
                i.c_currency_id               AS c_order_c_currency_id,
                i.c_doctype_id,
                i.c_doctypetarget_id,
                i.chargeamt,
                i.copyfrom,
                i.c_payment_id,
                i.c_paymentterm_id,
                i.c_pos_id,
                i.c_project_id                AS c_order_c_project_id,
                i.created                     AS c_order_created,
                i.createdby                   AS c_order_createdby,
                i.dateacct,
                i.dateprinted,
                i.datepromised                AS c_order_datepromised,
                i.deliveryrule,
                i.deliveryviarule,
                i.description                 AS c_order_description,
                i.docaction,
                i.docstatus,
                i.documentno,
                i.dropship_bpartner_id,
                i.dropship_location_id,
                i.dropship_user_id,
                i.freightamt                  AS c_order_freightamt,
                i.freightcostrule,
                i.grandtotal,
                i.invoicerule,
                i.isactive                    AS c_order_isactive,
                i.isapproved,
                i.iscreditapproved,
                i.isdelivered,
                i.isdiscountprinted           AS c_order_isdiscountprinted,
                i.isdropship                  AS c_order_isdropship,
                i.isinvoiced,
                i.ispayschedulevalid,
                i.isprinted,
                i.isselected,
                i.isselfservice               AS c_order_isselfservice,
                i.issotrx,
                i.istaxincluded,
                i.istransferred,
                i.link_order_id,
                i.m_freightcategory_id        AS c_order_m_freightcategory_id,
                i.m_pricelist_id              AS c_order_m_pricelist_id,
                i.m_shipper_id                AS c_order_m_shipper_id,
                i.m_warehouse_id              AS c_order_m_warehouse_id,
                i.ordertype,
                i.pay_bpartner_id,
                i.pay_location_id,
                i.paymentrule                 AS c_order_paymentrule,
                i.poreference,
                i.posted,
                i.priorityrule,
                i.processed                   AS c_order_processed,
                i.processedon,
                i.promotioncode,
                i.ref_order_id,
                i.salesrep_id,
                i.sendemail                   AS c_order_sendemail,
                i.totallines,
                i.updated                     AS c_order_updated,
                i.updatedby                   AS c_order_updatedby,
                i.user1_id                    AS c_order_user1_id,
                i.user2_id                    AS c_order_user2_id,
                i.volume                      AS c_order_volume,
                i.weight                      AS c_order_weight,
                NULL                          AS m_product_ad_org_id,
                NULL                          AS classification,
                NULL                          AS m_product_copyfrom,
                NULL                          AS m_product_created,
                NULL                          AS m_product_createdby,
                NULL                          AS c_revenuerecognition_id,
                NULL                          AS c_subscriptiontype_id,
                NULL                          AS c_taxcategory_id,
                NULL                          AS m_product_c_uom_id,
                NULL                          AS descriptionurl,
                NULL                          AS m_product_discontinued,
                NULL                          AS m_product_discontinuedat,
                NULL                          AS group1,
                NULL                          AS group2,
                NULL                          AS guaranteedays,
                NULL                          AS guaranteedaysmin,
                NULL                          AS help,
                NULL                          AS m_product_isactive,
                NULL                          AS isbom,
                NULL                          AS m_product_isdropship,
                NULL                          AS isexcludeautodelivery,
                NULL                          AS isinvoiceprintdetails,
                NULL                          AS ispicklistprintdetails,
                NULL                          AS ispurchased,
                NULL                          AS m_product_isselfservice,
                NULL                          AS issold,
                NULL                          AS isstocked,
                NULL                          AS m_product_issummary,
                NULL                          AS isverified,
                NULL                          AS iswebstorefeatured,
                NULL                          AS lowlevel,
                NULL                          AS m_attributeset_id,
                NULL                          AS m_attributesetinstance_id,
                NULL                          AS m_product_m_freightcategory_id,
                NULL                          AS m_locator_id,
                NULL                          AS m_product_product_category_id,
                NULL                          AS m_product_processing,
                NULL                          AS producttype,
                NULL                          AS r_mailtext_id,
                NULL                          AS m_product_salesrep_id,
                NULL                          AS s_expensetype_id,
                NULL                          AS shelfdepth,
                NULL                          AS shelfheight,
                NULL                          AS shelfwidth,
                NULL                          AS s_resource_id,
                NULL                          AS unitsperpack,
                NULL                          AS unitsperpallet,
                NULL                          AS m_product_updated,
                NULL                          AS m_product_updatedby,
                NULL                          AS versionno,
                NULL                          AS m_product_volume,
                NULL                          AS m_product_weight,
                NULL                          AS m_product_po_ad_org_id,
                NULL                          AS m_product_po_c_bpartner_id,
                NULL                          AS m_product_po_c_currency_id,
                NULL                          AS costperorder,
                NULL                          AS m_product_po_created,
                NULL                          AS m_product_po_createdby,
                NULL                          AS m_product_po_c_uom_id,
                NULL                          AS deliverytime_actual,
                NULL                          AS deliverytime_promised,
                NULL                          AS m_product_po_discontinued,
                NULL                          AS m_product_po_discontinuedat,
                NULL                          AS m_product_po_isactive,
                NULL                          AS iscurrentvendor,
                NULL                          AS m_product_po_manufacturer,
                NULL                          AS m_product_po_m_product_id,
                NULL                          AS order_min,
                NULL                          AS order_pack,
                NULL                          AS priceeffective,
                NULL                          AS pricelastinv,
                NULL                          AS pricelastpo,
                NULL                          AS m_product_po_pricelist,
                NULL                          AS pricepo,
                NULL                          AS m_product_po_qualityrating,
                NULL                          AS royaltyamt,
                NULL                          AS m_product_po_upc,
                NULL                          AS m_product_po_updated,
                NULL                          AS m_product_po_updatedby,
                NULL                          AS m_product_po_vendorcategory,
                NULL                          AS s_resourceassignment_ad_org_id,
                NULL                          AS assigndatefrom,
                NULL                          AS assigndateto,
                NULL                          AS s_resourceassignment_created,
                NULL                          AS s_resourceassignment_createby,
                NULL                          AS s_resourceassignment_isactive,
                NULL                          AS isconfirmed,
                NULL                          AS s_resourceassignment_name,
                NULL                          AS s_resourceassignment_qty,
                NULL                          AS s_resourceassignment_s_resour,
                NULL                          AS s_resourceassignment_updated,
                NULL                          AS s_resourceassignment_updatedby,
                NULL                          AS c_charge_c_org_id,
                NULL                          AS c_charge_c_bpartner_id,
                NULL                          AS c_chargetype_id,
                NULL                          AS c_charge_chargeamt,
                NULL                          AS c_charge_c_taxcategory_id,
                NULL                          AS c_charge_description,
                NULL                          AS c_charge_isactive,
                NULL                          AS issamecurrency,
                NULL                          AS issametax,
                NULL                          AS c_charge_istaxincluded,
                NULL                          AS c_bpartner_product_ad_org_id,
                NULL                          AS c_bp_product_c_bpartner_id,
                NULL                          AS c_bpartner_product_created,
                NULL                          AS c_bpartner_product_createdby,
                NULL                          AS c_bpartner_product_descriptio,
                NULL                          AS c_bpartner_product_isactive,
                NULL                          AS ismanufacturer,
                NULL                          AS c_bpartner_product_manufactur,
                NULL                          AS c_bpartner_product_qualityrat,
                NULL                          AS shelflifemindays,
                NULL                          AS c_bpartner_product_shelflifem,
                NULL                          AS c_bpartner_product_updated,
                NULL                          AS c_bpartner_product_updatedby,
                NULL                          AS c_bpartner_product_vendorcate,
                NULL                          AS acqusitioncost,
                NULL                          AS actuallifetimevalue,
                NULL                          AS c_bpartner_ad_language,
                NULL                          AS ad_orgbp_id,
                NULL                          AS c_bpartner_ad_org_id,
                NULL                          AS bpartner_parent_id,
                NULL                          AS c_bp_group_id,
                NULL                          AS c_dunning_id,
                NULL                          AS c_greeting_id,
                NULL                          AS c_invoiceschedule_id,
                NULL                          AS c_bpartner_c_paymentterm_id,
                NULL                          AS c_bpartner_created,
                NULL                          AS c_bpartner_createdby,
                NULL                          AS c_bpartner_c_taxgroup_id,
                NULL                          AS c_bpartner_deliveryrule,
                NULL                          AS c_bpartner_deliveryviarule,
                NULL                          AS c_bpartner_description,
                NULL                          AS c_bpartner_dunninggrace,
                NULL                          AS duns,
                NULL                          AS c_bpartner_firstsale,
                NULL                          AS c_bpartner_flatdiscount,
                NULL                          AS c_bpartner_freightcostrule,
                NULL                          AS c_bpartner_invoicerule,
                NULL                          AS c_bpartner_isactive,
                NULL                          AS iscustomer,
                NULL                          AS c_bpartner_isdiscountprinted,
                NULL                          AS c_bpartner_isemployee,
                NULL                          AS c_bpartner_ismanufacturer,
                NULL                          AS isonetime,
                NULL                          AS ispotaxexempt,
                NULL                          AS isprospect,
                NULL                          AS issalesrep,
                NULL                          AS c_bpartner_issummary,
                NULL                          AS c_bpartner_istaxexempt,
                NULL                          AS isvendor,
                NULL                          AS logo_id,
                NULL                          AS m_discountschema_id,
                NULL                          AS c_bpartner_m_pricelist_id,
                NULL                          AS naics,
                NULL                          AS c_bpartner_name,
                NULL                          AS c_bpartner_name2,
                NULL                          AS numberemployees,
                NULL                          AS c_bpartner_paymentrule,
                NULL                          AS paymentrulepo,
                NULL                          AS po_discountschema_id,
                NULL                          AS po_paymentterm_id,
                NULL                          AS po_pricelist_id,
                NULL                          AS c_bpartner_poreference,
                NULL                          AS potentiallifetimevalue,
                NULL                          AS c_bpartner_rating,
                NULL                          AS c_bpartner_referenceno,
                NULL                          AS c_bpartner_salesrep_id,
                NULL                          AS salesvolume,
                NULL                          AS c_bpartner_sendemail,
                NULL                          AS shareofcustomer,
                NULL                          AS c_bpartner_shelflifeminpct,
                NULL                          AS so_creditlimit,
                NULL                          AS socreditstatus,
                NULL                          AS so_creditused,
                NULL                          AS so_description,
                NULL                          AS c_bpartner_taxid,
                NULL                          AS totalopenbalance,
                NULL                          AS c_bpartner_updated,
                NULL                          AS c_bpartner_updatedby,
                NULL                          AS c_bpartner_url,
                NULL                          AS c_bpartner_value,
                NULL                          AS c_bpartner_location_ad_org_id,
                NULL                          AS c_bpartner_location_c_bpartne,
                NULL                          AS c_bpartner_location_created,
                NULL                          AS c_bpartner_location_createdby,
                NULL                          AS c_salesregion_id,
                NULL                          AS c_bpartner_location_fax,
                NULL                          AS c_bpartner_location_isactive,
                NULL                          AS isbillto,
                NULL                          AS isdn,
                NULL                          AS ispayfrom,
                NULL                          AS isremitto,
                NULL                          AS isshipto,
                NULL                          AS c_bpartner_location_name,
                NULL                          AS c_bpartner_location_phone,
                NULL                          AS c_bpartner_location_phone2,
                NULL                          AS c_bpartner_location_updated,
                NULL                          AS c_bpartner_location_updatedby,
                NULL                          AS c_tax_ad_org_id,
                NULL                          AS ad_rule_id,
                NULL                          AS c_country_id,
                NULL                          AS c_region_id,
                NULL                          AS c_tax_c_taxcategory_id,
                NULL                          AS c_tax_description,
                NULL                          AS c_tax_isactive,
                NULL                          AS c_tax_isdefault,
                NULL                          AS isdocumentlevel,
                NULL                          AS issalestax,
                NULL                          AS c_tax_issummary,
                NULL                          AS c_tax_istaxexempt,
                NULL                          AS c_tax_name,
                NULL                          AS parent_tax_id,
                NULL                          AS rate,
                NULL                          AS requirestaxcertificate,
                NULL                          AS sopotype,
                NULL                          AS to_country_id,
                NULL                          AS c_tax_to_region_id,
                NULL                          AS validfrom 
            FROM c_order i
            )
UNION 
SELECT ot.ad_client_id,
    ot.ad_org_id,
    ot.isactive,
    ot.created,
    ot.createdby,
    ot.updated,
    ot.updatedby,
    'en_US'::character varying(6) AS ad_language,
    ot.c_order_id,
    NULL                          AS c_orderline_id,
    ot.c_tax_id,
    tt.taxindicator,
    NULL                          AS c_bpartner_id,
    NULL                          AS c_bpartner_location_id,
    NULL                          AS bpname,
    NULL                          AS c_location_id,
    NULL                          AS line,
    NULL                          AS m_product_id,
    NULL                          AS vendorproductno,
    NULL                          AS qtyordered,
    NULL                          AS qtyentered,
    NULL                          AS uomsymbol,
    tt.name,
    NULL                          AS description,
    NULL                          AS documentnote,
    NULL                          AS upc,
    NULL                          AS sku,
    NULL                          AS productvalue,
    NULL                          AS resourcedescription,
    NULL                          AS pricelist,
    NULL                          AS priceenteredlist,
    NULL                          AS discount,
    CASE WHEN ot.istaxincluded = 'Y' THEN ot.taxamt ELSE ot.taxbaseamt END                       AS priceactual,
    CASE WHEN ot.istaxincluded = 'Y' THEN ot.taxamt ELSE ot.taxbaseamt END                       AS priceentered,
    CASE WHEN ot.istaxincluded = 'Y' THEN NULL ELSE ot.taxamt END                       AS linenetamt,
    NULL                          AS productdescription,
    NULL                          AS imageurl,
    NULL                          AS c_campaign_id,
    NULL                          AS c_project_id,
    NULL                          AS c_activity_id,
    NULL                          AS c_projectphase_id,
    NULL                          AS c_projecttask_id,
    NULL                          AS c_orderline_ad_orgtrx_id,
    NULL                          AS c_orderline_c_charge_id,
    NULL                          AS c_orderline_c_currency_id,
    NULL                          AS c_uom_id,
    NULL                          AS datedelivered,
    NULL                          AS dateinvoiced,
    NULL                          AS dateordered,
    NULL                          AS c_orderline_datepromised,
    NULL                          AS c_orderline_freightamt,
    NULL                          AS isdescription,
    NULL                          AS link_orderline_id,
    NULL                          AS m_promotion_id,
    NULL                          AS c_orderline_m_shipper_id,
    NULL                          AS c_orderline_m_warehouse_id,
    NULL                          AS pricecost,
    NULL                          AS pricelimit,
    NULL                          AS c_orderline_processed,
    NULL                          AS qtydelivered,
    NULL                          AS qtyinvoiced,
    NULL                          AS qtylostsales,
    NULL                          AS qtyreserved,
    NULL                          AS ref_orderline_id,
    NULL                          AS rramt,
    NULL                          AS rrstartdate,
    NULL                          AS s_resourceassignment_id,
    NULL                          AS c_orderline_user1_id,
    NULL                          AS c_orderline_user2_id,
    NULL                          AS c_uom_ad_org_id,
    NULL                          AS costingprecision,
    NULL                          AS c_uom_description,
    NULL                          AS c_uom_isactive,
    NULL                          AS isdefault,
    NULL                          AS c_uom_name,
    NULL                          AS stdprecision,
    NULL                          AS uomtype,
    NULL                          AS x12de355,
    NULL                          AS c_order_ad_org_id,
    NULL                          AS c_order_ad_orgtrx_id,
    NULL                          AS ad_user_id,
    NULL                          AS amountrefunded,
    NULL                          AS amounttendered,
    NULL                          AS bill_bpartner_id,
    NULL                          AS bill_location_id,
    NULL                          AS bill_user_id,
    NULL                          AS c_order_c_activity_id,
    NULL                          AS c_order_c_bpartner_id,
    NULL                          AS c_order_c_campaign_id,
    NULL                          AS c_cashline_id,
    NULL                          AS c_cashplanline_id,
    NULL                          AS c_order_c_charge_id,
    NULL                          AS c_conversiontype_id,
    NULL                          AS c_order_c_currency_id,
    NULL                          AS c_doctype_id,
    NULL                          AS c_doctypetarget_id,
    NULL                          AS chargeamt,
    NULL                          AS copyfrom,
    NULL                          AS c_payment_id,
    NULL                          AS c_paymentterm_id,
    NULL                          AS c_pos_id,
    NULL                          AS c_order_c_project_id,
    NULL                          AS c_order_created,
    NULL                          AS c_order_createdby,
    NULL                          AS dateacct,
    NULL                          AS dateprinted,
    NULL                          AS c_order_datepromised,
    NULL                          AS deliveryrule,
    NULL                          AS deliveryviarule,
    NULL                          AS c_order_description,
    NULL                          AS docaction,
    NULL                          AS docstatus,
    NULL                          AS documentno,
    NULL                          AS dropship_bpartner_id,
    NULL                          AS dropship_location_id,
    NULL                          AS dropship_user_id,
    NULL                          AS c_order_freightamt,
    NULL                          AS freightcostrule,
    NULL                          AS grandtotal,
    NULL                          AS invoicerule,
    NULL                          AS c_order_isactive,
    NULL                          AS isapproved,
    NULL                          AS iscreditapproved,
    NULL                          AS isdelivered,
    NULL                          AS c_order_isdiscountprinted,
    NULL                          AS c_order_isdropship,
    NULL                          AS isinvoiced,
    NULL                          AS ispayschedulevalid,
    NULL                          AS isprinted,
    NULL                          AS isselected,
    NULL                          AS c_order_isselfservice,
    NULL                          AS issotrx,
    NULL                          AS istaxincluded,
    NULL                          AS istransferred,
    NULL                          AS link_order_id,
    NULL                          AS c_order_m_freightcategory_id,
    NULL                          AS c_order_m_pricelist_id,
    NULL                          AS c_order_m_shipper_id,
    NULL                          AS c_order_m_warehouse_id,
    NULL                          AS ordertype,
    NULL                          AS pay_bpartner_id,
    NULL                          AS pay_location_id,
    NULL                          AS c_order_paymentrule,
    NULL                          AS poreference,
    NULL                          AS posted,
    NULL                          AS priorityrule,
    NULL                          AS c_order_processed,
    NULL                          AS processedon,
    NULL                          AS promotioncode,
    NULL                          AS ref_order_id,
    NULL                          AS salesrep_id,
    NULL                          AS c_order_sendemail,
    NULL                          AS totallines,
    NULL                          AS c_order_updated,
    NULL                          AS c_order_updatedby,
    NULL                          AS c_order_user1_id,
    NULL                          AS c_order_user2_id,
    NULL                          AS c_order_volume,
    NULL                          AS c_order_weight,
    NULL                          AS m_product_ad_org_id,
    NULL                          AS classification,
    NULL                          AS m_product_copyfrom,
    NULL                          AS m_product_created,
    NULL                          AS m_product_createdby,
    NULL                          AS c_revenuerecognition_id,
    NULL                          AS c_subscriptiontype_id,
    NULL                          AS c_taxcategory_id,
    NULL                          AS m_product_c_uom_id,
    NULL                          AS descriptionurl,
    NULL                          AS m_product_discontinued,
    NULL                          AS m_product_discontinuedat,
    NULL                          AS group1,
    NULL                          AS group2,
    NULL                          AS guaranteedays,
    NULL                          AS guaranteedaysmin,
    NULL                          AS help,
    NULL                          AS m_product_isactive,
    NULL                          AS isbom,
    NULL                          AS m_product_isdropship,
    NULL                          AS isexcludeautodelivery,
    NULL                          AS isinvoiceprintdetails,
    NULL                          AS ispicklistprintdetails,
    NULL                          AS ispurchased,
    NULL                          AS m_product_isselfservice,
    NULL                          AS issold,
    NULL                          AS isstocked,
    NULL                          AS m_product_issummary,
    NULL                          AS isverified,
    NULL                          AS iswebstorefeatured,
    NULL                          AS lowlevel,
    NULL                          AS m_attributeset_id,
    NULL                          AS m_attributesetinstance_id,
    NULL                          AS m_product_m_freightcategory_id,
    NULL                          AS m_locator_id,
    NULL                          AS m_product_product_category_id,
    NULL                          AS m_product_processing,
    NULL                          AS producttype,
    NULL                          AS r_mailtext_id,
    NULL                          AS m_product_salesrep_id,
    NULL                          AS s_expensetype_id,
    NULL                          AS shelfdepth,
    NULL                          AS shelfheight,
    NULL                          AS shelfwidth,
    NULL                          AS s_resource_id,
    NULL                          AS unitsperpack,
    NULL                          AS unitsperpallet,
    NULL                          AS m_product_updated,
    NULL                          AS m_product_updatedby,
    NULL                          AS versionno,
    NULL                          AS m_product_volume,
    NULL                          AS m_product_weight,
    NULL                          AS m_product_po_ad_org_id,
    NULL                          AS m_product_po_c_bpartner_id,
    NULL                          AS m_product_po_c_currency_id,
    NULL                          AS costperorder,
    NULL                          AS m_product_po_created,
    NULL                          AS m_product_po_createdby,
    NULL                          AS m_product_po_c_uom_id,
    NULL                          AS deliverytime_actual,
    NULL                          AS deliverytime_promised,
    NULL                          AS m_product_po_discontinued,
    NULL                          AS m_product_po_discontinuedat,
    NULL                          AS m_product_po_isactive,
    NULL                          AS iscurrentvendor,
    NULL                          AS m_product_po_manufacturer,
    NULL                          AS m_product_po_m_product_id,
    NULL                          AS order_min,
    NULL                          AS order_pack,
    NULL                          AS priceeffective,
    NULL                          AS pricelastinv,
    NULL                          AS pricelastpo,
    NULL                          AS m_product_po_pricelist,
    NULL                          AS pricepo,
    NULL                          AS m_product_po_qualityrating,
    NULL                          AS royaltyamt,
    NULL                          AS m_product_po_upc,
    NULL                          AS m_product_po_updated,
    NULL                          AS m_product_po_updatedby,
    NULL                          AS m_product_po_vendorcategory,
    NULL                          AS s_resourceassignment_ad_org_id,
    NULL                          AS assigndatefrom,
    NULL                          AS assigndateto,
    NULL                          AS s_resourceassignment_created,
    NULL                          AS s_resourceassignment_createby,
    NULL                          AS s_resourceassignment_isactive,
    NULL                          AS isconfirmed,
    NULL                          AS s_resourceassignment_name,
    NULL                          AS s_resourceassignment_qty,
    NULL                          AS s_resourceassignment_s_resour,
    NULL                          AS s_resourceassignment_updated,
    NULL                          AS s_resourceassignment_updatedby,
    NULL                          AS c_charge_c_org_id,
    NULL                          AS c_charge_c_bpartner_id,
    NULL                          AS c_chargetype_id,
    NULL                          AS c_charge_chargeamt,
    NULL                          AS c_charge_c_taxcategory_id,
    NULL                          AS c_charge_description,
    NULL                          AS c_charge_isactive,
    NULL                          AS issamecurrency,
    NULL                          AS issametax,
    NULL                          AS c_charge_istaxincluded,
    NULL                          AS c_bpartner_product_ad_org_id,
    NULL                          AS c_bp_product_c_bpartner_id,
    NULL                          AS c_bpartner_product_created,
    NULL                          AS c_bpartner_product_createdby,
    NULL                          AS c_bpartner_product_descriptio,
    NULL                          AS c_bpartner_product_isactive,
    NULL                          AS ismanufacturer,
    NULL                          AS c_bpartner_product_manufactur,
    NULL                          AS c_bpartner_product_qualityrat,
    NULL                          AS shelflifemindays,
    NULL                          AS c_bpartner_product_shelflifem,
    NULL                          AS c_bpartner_product_updated,
    NULL                          AS c_bpartner_product_updatedby,
    NULL                          AS c_bpartner_product_vendorcate,
    NULL                          AS acqusitioncost,
    NULL                          AS actuallifetimevalue,
    NULL                          AS c_bpartner_ad_language,
    NULL                          AS ad_orgbp_id,
    NULL                          AS c_bpartner_ad_org_id,
    NULL                          AS bpartner_parent_id,
    NULL                          AS c_bp_group_id,
    NULL                          AS c_dunning_id,
    NULL                          AS c_greeting_id,
    NULL                          AS c_invoiceschedule_id,
    NULL                          AS c_bpartner_c_paymentterm_id,
    NULL                          AS c_bpartner_created,
    NULL                          AS c_bpartner_createdby,
    NULL                          AS c_bpartner_c_taxgroup_id,
    NULL                          AS c_bpartner_deliveryrule,
    NULL                          AS c_bpartner_deliveryviarule,
    NULL                          AS c_bpartner_description,
    NULL                          AS c_bpartner_dunninggrace,
    NULL                          AS duns,
    NULL                          AS c_bpartner_firstsale,
    NULL                          AS c_bpartner_flatdiscount,
    NULL                          AS c_bpartner_freightcostrule,
    NULL                          AS c_bpartner_invoicerule,
    NULL                          AS c_bpartner_isactive,
    NULL                          AS iscustomer,
    NULL                          AS c_bpartner_isdiscountprinted,
    NULL                          AS c_bpartner_isemployee,
    NULL                          AS c_bpartner_ismanufacturer,
    NULL                          AS isonetime,
    NULL                          AS ispotaxexempt,
    NULL                          AS isprospect,
    NULL                          AS issalesrep,
    NULL                          AS c_bpartner_issummary,
    NULL                          AS c_bpartner_istaxexempt,
    NULL                          AS isvendor,
    NULL                          AS logo_id,
    NULL                          AS m_discountschema_id,
    NULL                          AS c_bpartner_m_pricelist_id,
    NULL                          AS naics,
    NULL                          AS c_bpartner_name,
    NULL                          AS c_bpartner_name2,
    NULL                          AS numberemployees,
    NULL                          AS c_bpartner_paymentrule,
    NULL                          AS paymentrulepo,
    NULL                          AS po_discountschema_id,
    NULL                          AS po_paymentterm_id,
    NULL                          AS po_pricelist_id,
    NULL                          AS c_bpartner_poreference,
    NULL                          AS potentiallifetimevalue,
    NULL                          AS c_bpartner_rating,
    NULL                          AS c_bpartner_referenceno,
    NULL                          AS c_bpartner_salesrep_id,
    NULL                          AS salesvolume,
    NULL                          AS c_bpartner_sendemail,
    NULL                          AS shareofcustomer,
    NULL                          AS c_bpartner_shelflifeminpct,
    NULL                          AS so_creditlimit,
    NULL                          AS socreditstatus,
    NULL                          AS so_creditused,
    NULL                          AS so_description,
    NULL                          AS c_bpartner_taxid,
    NULL                          AS totalopenbalance,
    NULL                          AS c_bpartner_updated,
    NULL                          AS c_bpartner_updatedby,
    NULL                          AS c_bpartner_url,
    NULL                          AS c_bpartner_value,
    NULL                          AS c_bpartner_location_ad_org_id,
    NULL                          AS c_bpartner_location_c_bpartne,
    NULL                          AS c_bpartner_location_created,
    NULL                          AS c_bpartner_location_createdby,
    NULL                          AS c_salesregion_id,
    NULL                          AS c_bpartner_location_fax,
    NULL                          AS c_bpartner_location_isactive,
    NULL                          AS isbillto,
    NULL                          AS isdn,
    NULL                          AS ispayfrom,
    NULL                          AS isremitto,
    NULL                          AS isshipto,
    NULL                          AS c_bpartner_location_name,
    NULL                          AS c_bpartner_location_phone,
    NULL                          AS c_bpartner_location_phone2,
    NULL                          AS c_bpartner_location_updated,
    NULL                          AS c_bpartner_location_updatedby,
    NULL                          AS c_tax_ad_org_id,
    NULL                          AS ad_rule_id,
    NULL                          AS c_country_id,
    NULL                          AS c_region_id,
    NULL                          AS c_tax_c_taxcategory_id,
    NULL                          AS c_tax_description,
    NULL                          AS c_tax_isactive,
    NULL                          AS c_tax_isdefault,
    NULL                          AS isdocumentlevel,
    NULL                          AS issalestax,
    NULL                          AS c_tax_issummary,
    NULL                          AS c_tax_istaxexempt,
    NULL                          AS c_tax_name,
    NULL                          AS parent_tax_id,
    NULL                          AS rate,
    NULL                          AS requirestaxcertificate,
    NULL                          AS sopotype,
    NULL                          AS to_country_id,
    NULL                          AS c_tax_to_region_id,
    NULL                          AS validfrom 
FROM c_ordertax ot 
        JOIN c_tax_trl tt 
        ON ot.c_tax_id = tt.c_tax_id
;

CREATE OR REPLACE VIEW c_payment_v AS 
SELECT c_payment.c_payment_id,
    c_payment.ad_client_id,
    c_payment.ad_org_id,
    c_payment.isactive,
    c_payment.created,
    c_payment.createdby,
    c_payment.updated,
    c_payment.updatedby,
    c_payment.documentno,
    c_payment.datetrx,
    c_payment.isreceipt,
    c_payment.c_doctype_id,
    c_payment.trxtype,
    c_payment.c_bankaccount_id,
    c_payment.c_bpartner_id,
    c_payment.c_invoice_id,
    c_payment.c_bp_bankaccount_id,
    c_payment.c_paymentbatch_id,
    c_payment.tendertype,
    c_payment.creditcardtype,
    c_payment.creditcardnumber,
    c_payment.creditcardvv,
    c_payment.creditcardexpmm,
    c_payment.creditcardexpyy,
    c_payment.micr,
    c_payment.routingno,
    c_payment.accountno,
    c_payment.checkno,
    c_payment.a_name,
    c_payment.a_street,
    c_payment.a_city,
    c_payment.a_state,
    c_payment.a_zip,
    c_payment.a_ident_dl,
    c_payment.a_ident_ssn,
    c_payment.a_email,
    c_payment.voiceauthcode,
    c_payment.orig_trxid,
    c_payment.ponum,
    c_payment.c_currency_id,
    c_payment.c_conversiontype_id,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.payamt ELSE c_payment.payamt * (-1) END AS payamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.discountamt ELSE c_payment.discountamt * (-1) END AS discountamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.writeoffamt ELSE c_payment.writeoffamt * (-1) END AS writeoffamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.taxamt ELSE c_payment.taxamt * (-1) END AS taxamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.overunderamt ELSE c_payment.overunderamt * (-1) END AS overunderamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN 1 ELSE (-1) END AS multiplierap,
    c_payment.isoverunderpayment,
    c_payment.isapproved,
    c_payment.r_pnref,
    c_payment.r_result,
    c_payment.r_respmsg,
    c_payment.r_authcode,
    c_payment.r_avsaddr,
    c_payment.r_avszip,
    c_payment.r_info,
    c_payment.processing,
    c_payment.oprocessing,
    c_payment.docstatus,
    c_payment.docaction,
    c_payment.isprepayment,
    c_payment.c_charge_id,
    c_payment.isreconciled,
    c_payment.isallocated,
    c_payment.isonline,
    c_payment.processed,
    c_payment.posted,
    c_payment.c_campaign_id,
    c_payment.c_project_id,
    c_payment.c_activity_id,
    c_payment.ad_orgtrx_id,
    c_payment.chargeamt,
    c_payment.c_order_id,
    c_payment.dateacct,
    c_payment.description,
    c_payment.isselfservice,
    c_payment.processedon,
    c_payment.reversal_id 
FROM c_payment
;

DROP VIEW c_payselection_check_v;

CREATE OR REPLACE VIEW c_payselection_check_v AS 
SELECT psc.ad_client_id,
    psc.ad_org_id,
    'en_US'::character varying              AS ad_language,
    psc.c_payselection_id,
    psc.c_payselectioncheck_id,
    oi.c_location_id                        AS org_location_id,
    oi.taxid,
    p.c_doctype_id,
    bp.c_bpartner_id,
    bp.value                                AS bpvalue,
    bp.taxid                                AS bptaxid,
    bp.naics,
    bp.duns,
    bpg.greeting                            AS bpgreeting,
    bp.name,
    bp.name2,
    bpartnerremitlocation(bp.c_bpartner_id) AS c_location_id,
    bp.referenceno,
    bp.poreference,
    ps.paydate,
    psc.payamt,
    psc.payamt                              AS amtinwords,
    psc.qty,
    psc.paymentrule,
    psc.documentno,
    COALESCE(oi.logo_id, ci.logo_id)        AS logo_id,
    dt.printname                            AS documenttype,
    dt.documentnote                         AS documenttypenote,
    p.description,
    ba.description                          AS bankaccountdescription,
    psc.c_bp_bankaccount_id,
    psc.c_payment_id,
    psc.created                             AS c_payselectioncheck_created,
    psc.createdby                           AS c_payselectioncheck_createdby,
    psc.discountamt                         AS c_payselectioncheck_discamt,
    psc.isactive                            AS c_payselectioncheck_isactive,
    psc.isgenerateddraft,
    psc.isprinted,
    psc.isreceipt,
    psc.processed,
    psc.updated                             AS c_payselectioncheck_updated,
    psc.updatedby                           AS c_payselectioncheck_updatedby,
    ps.ad_org_id                            AS c_payselection_ad_org_id,
    ps.c_bankaccount_id                     AS c_paysel_c_bankaccount_id,
    ps.created                              AS c_payselection_created,
    ps.createdby                            AS c_payselection_createdby,
    ps.description                          AS c_payselection_description,
    ps.isactive                             AS c_payselection_isactive,
    ps.isapproved                           AS c_payselection_isapproved,
    ps.name                                 AS c_payselection_name,
    ps.processed                            AS c_payselection_processed,
    ps.totalamt,
    ps.updated                              AS c_payselection_updated,
    ps.updatedby                            AS c_payselection_updatedby,
    p.a_city,
    p.a_country,
    p.ad_org_id                             AS c_payment_ad_org_id,
    p.a_email,
    p.a_ident_dl,
    p.a_name,
    p.a_state,
    p.a_street,
    p.a_zip,
    p.c_activity_id,
    p.c_bpartner_id                         AS c_payment_c_bpartner_id,
    p.c_campaign_id,
    p.c_charge_id                           AS c_payment_c_charge_id,
    p.c_conversiontype_id,
    p.c_currency_id,
    p.chargeamt                             AS c_payment_chargeamt,
    p.checkno,
    p.c_invoice_id                          AS c_payment_c_invoice_id,
    p.c_order_id                            AS c_payment_c_order_id,
    p.c_paymentbatch_id,
    p.c_project_id,
    p.created                               AS c_payment_created,
    p.createdby                             AS c_payment_createdby,
    p.dateacct,
    p.datetrx,
    p.discountamt                           AS c_payment_discountamt,
    p.docstatus,
    p.documentno                            AS c_payment_documentno,
    p.isactive                              AS c_payment_isactive,
    p.isallocated,
    p.isapproved,
    p.isdelayedcapture,
    p.isonline,
    p.isoverunderpayment,
    p.isprepayment,
    p.isreconciled,
    p.isselfservice                         AS c_payment_isselfservice,
    p.micr,
    p.orig_trxid,
    p.overunderamt,
    p.payamt                                AS c_payment_payamt,
    p.ponum,
    p.posted                                AS c_payment_posted,
    p.processed                             AS c_payment_processed,
    p.processedon                           AS c_payment_processedon,
    p.r_authcode,
    p.r_authcode_dc,
    p.r_avsaddr,
    p.r_avszip,
    p.r_cvv2match,
    p.ref_payment_id,
    p.reversal_id                           AS c_payment_reversal_id,
    p.r_info,
    p.routingno,
    p.r_pnref,
    p.r_pnref_dc,
    p.r_respmsg,
    p.r_result,
    p.swipe,
    p.taxamt,
    p.tendertype,
    p.trxtype,
    p.updated                               AS c_payment_updated,
    p.updatedby                             AS c_payment_updatedby,
    p.user1_id,
    p.user2_id,
    p.voiceauthcode,
    p.writeoffamt,
    bp.acqusitioncost                       AS c_bp_acqusitioncost,
    bp.actuallifetimevalue                  AS c_bp_actuallifetimevalue,
    bp.ad_language                          AS c_bp_ad_language,
    bp.ad_orgbp_id                          AS c_bp_ad_orgbp_id,
    bp.ad_org_id                            AS c_bp_ad_org_id,
    bp.bpartner_parent_id                   AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                        AS c_bp_c_bp_group_id,
    bp.c_dunning_id                         AS c_bp_c_dunning_id,
    bp.c_greeting_id                        AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id                 AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id                     AS c_bp_c_paymentterm_id,
    bp.created                              AS c_bp_created,
    bp.createdby                            AS c_bp_createdby,
    bp.c_taxgroup_id                        AS c_bp_c_taxgroup_id,
    bp.deliveryrule                         AS c_bp_deliveryrule,
    bp.deliveryviarule                      AS c_bp_deliveryviarule,
    bp.description                          AS c_bp_description,
    bp.dunninggrace                         AS c_bp_dunninggrace,
    bp.firstsale                            AS c_bp_firstsale,
    bp.flatdiscount                         AS c_bp_flatdiscount,
    bp.freightcostrule                      AS c_bp_freightcostrule,
    bp.invoicerule                          AS c_bp_invoicerule,
    bp.isactive                             AS c_bp_isactive,
    bp.iscustomer                           AS c_bp_iscustomer,
    bp.isdiscountprinted                    AS c_bp_isdiscountprinted,
    bp.isemployee                           AS c_bp_isemployee,
    bp.ismanufacturer                       AS c_bp_ismanufacturer,
    bp.isonetime                            AS c_bp_isonetime,
    bp.ispotaxexempt                        AS c_bp_ispotaxexempt,
    bp.isprospect                           AS c_bp_isprospect,
    bp.issalesrep                           AS c_bp_issalesrep,
    bp.issummary                            AS c_bp_issummary,
    bp.istaxexempt                          AS c_bp_istaxexempt,
    bp.isvendor                             AS c_bp_isvendor,
    bp.logo_id                              AS c_bp_logo_id,
    bp.m_discountschema_id                  AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                       AS c_bp_m_pricelist_id,
    bp.numberemployees                      AS c_bp_numberemployees,
    bp.paymentrule                          AS c_bp_paymentrule,
    bp.paymentrulepo                        AS c_bp_paymentrulepo,
    bp.po_discountschema_id                 AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id                    AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id                      AS c_bp_po_pricelist_id,
    bp.potentiallifetimevalue               AS c_bp_potentiallifetimevalue,
    bp.rating                               AS c_bp_rating,
    bp.salesrep_id                          AS c_bp_salesrep_id,
    bp.salesvolume                          AS c_bp_salesvolume,
    bp.sendemail                            AS c_bp_sendemail,
    bp.shareofcustomer                      AS c_bp_shareofcustomer,
    bp.shelflifeminpct                      AS c_bp_shelflifeminpct,
    bp.so_creditlimit                       AS c_bp_so_creditlimit,
    bp.socreditstatus                       AS c_bp_socreditstatus,
    bp.so_creditused                        AS c_bp_so_creditused,
    bp.so_description                       AS c_bp_so_description,
    bp.totalopenbalance                     AS c_bp_totalopenbalance,
    bp.updated                              AS c_bp_updated,
    bp.updatedby                            AS c_bp_updatedby,
    bp.url                                  AS c_bp_url,
    bpg.ad_org_id                           AS c_greeting_ad_org_id,
    bpg.isactive                            AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpg.name                                AS c_greeting_name,
    oi.ad_org_id                            AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                              AS ad_orginfo_created,
    oi.createdby                            AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                                 AS ad_orginfo_duns,
    oi.email                                AS ad_orginfo_email,
    oi.fax                                  AS ad_orginfo_fax,
    oi.isactive                             AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                                AS ad_orginfo_phone,
    oi.phone2                               AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                              AS ad_orginfo_updated,
    oi.updatedby                            AS ad_orginfo_updatedby 
FROM c_payselectioncheck psc 
        JOIN c_payselection ps 
        ON psc.c_payselection_id = ps.c_payselection_id 
        LEFT JOIN c_payment p 
        ON psc.c_payment_id = p.c_payment_id 
        LEFT JOIN c_bankaccount ba 
        ON p.c_bankaccount_id = ba.c_bankaccount_id 
        LEFT JOIN c_doctype dt 
        ON p.c_doctype_id = dt.c_doctype_id 
        JOIN c_bpartner bp 
        ON psc.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        JOIN ad_orginfo oi 
        ON psc.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON psc.ad_client_id = ci.ad_client_id
;

DROP VIEW c_payselection_check_vt;

CREATE OR REPLACE VIEW c_payselection_check_vt AS 
SELECT psc.ad_client_id,
    psc.ad_org_id,
    l.ad_language,
    psc.c_payselection_id,
    psc.c_payselectioncheck_id,
    oi.c_location_id                        AS org_location_id,
    oi.taxid,
    p.c_doctype_id,
    bp.c_bpartner_id,
    bp.value                                AS bpvalue,
    bp.taxid                                AS bptaxid,
    bp.naics,
    bp.duns,
    bpgt.greeting                           AS bpgreeting,
    bp.name,
    bp.name2,
    bpartnerremitlocation(bp.c_bpartner_id) AS c_location_id,
    bp.referenceno,
    bp.poreference,
    ps.paydate,
    psc.payamt,
    psc.payamt                              AS amtinwords,
    psc.qty,
    psc.paymentrule,
    psc.documentno,
    COALESCE(oi.logo_id, ci.logo_id)        AS logo_id,
    dt.printname                            AS documenttype,
    dt.documentnote                         AS documenttypenote,
    p.description,
    ba.description                          AS bankaccountdescription,
    psc.c_bp_bankaccount_id,
    psc.c_payment_id,
    psc.created                             AS c_payselectioncheck_created,
    psc.createdby                           AS c_payselectioncheck_createdby,
    psc.discountamt                         AS c_payselectioncheck_discamt,
    psc.isactive                            AS c_payselectioncheck_isactive,
    psc.isgenerateddraft,
    psc.isprinted,
    psc.isreceipt,
    psc.processed,
    psc.updated                             AS c_payselectioncheck_updated,
    psc.updatedby                           AS c_payselectioncheck_updatedby,
    ps.ad_org_id                            AS c_payselection_ad_org_id,
    ps.c_bankaccount_id                     AS c_paysel_c_bankaccount_id,
    ps.created                              AS c_payselection_created,
    ps.createdby                            AS c_payselection_createdby,
    ps.description                          AS c_payselection_description,
    ps.isactive                             AS c_payselection_isactive,
    ps.isapproved                           AS c_payselection_isapproved,
    ps.name                                 AS c_payselection_name,
    ps.processed                            AS c_payselection_processed,
    ps.totalamt,
    ps.updated                              AS c_payselection_updated,
    ps.updatedby                            AS c_payselection_updatedby,
    p.a_city,
    p.a_country,
    p.ad_org_id                             AS c_payment_ad_org_id,
    p.a_email,
    p.a_ident_dl,
    p.a_name,
    p.a_state,
    p.a_street,
    p.a_zip,
    p.c_activity_id,
    p.c_bpartner_id                         AS c_payment_c_bpartner_id,
    p.c_campaign_id,
    p.c_charge_id                           AS c_payment_c_charge_id,
    p.c_conversiontype_id,
    p.c_currency_id,
    p.chargeamt                             AS c_payment_chargeamt,
    p.checkno,
    p.c_invoice_id                          AS c_payment_c_invoice_id,
    p.c_order_id                            AS c_payment_c_order_id,
    p.c_paymentbatch_id,
    p.c_project_id,
    p.created                               AS c_payment_created,
    p.createdby                             AS c_payment_createdby,
    p.dateacct,
    p.datetrx,
    p.discountamt                           AS c_payment_discountamt,
    p.docstatus,
    p.documentno                            AS c_payment_documentno,
    p.isactive                              AS c_payment_isactive,
    p.isallocated,
    p.isapproved,
    p.isdelayedcapture,
    p.isonline,
    p.isoverunderpayment,
    p.isprepayment,
    p.isreconciled,
    p.isselfservice                         AS c_payment_isselfservice,
    p.micr,
    p.orig_trxid,
    p.overunderamt,
    p.payamt                                AS c_payment_payamt,
    p.ponum,
    p.posted                                AS c_payment_posted,
    p.processed                             AS c_payment_processed,
    p.processedon                           AS c_payment_processedon,
    p.r_authcode,
    p.r_authcode_dc,
    p.r_avsaddr,
    p.r_avszip,
    p.r_cvv2match,
    p.ref_payment_id,
    p.reversal_id                           AS c_payment_reversal_id,
    p.r_info,
    p.routingno,
    p.r_pnref,
    p.r_pnref_dc,
    p.r_respmsg,
    p.r_result,
    p.swipe,
    p.taxamt,
    p.tendertype,
    p.trxtype,
    p.updated                               AS c_payment_updated,
    p.updatedby                             AS c_payment_updatedby,
    p.user1_id,
    p.user2_id,
    p.voiceauthcode,
    p.writeoffamt,
    bp.acqusitioncost                       AS c_bp_acqusitioncost,
    bp.actuallifetimevalue                  AS c_bp_actuallifetimevalue,
    bp.ad_language                          AS c_bp_ad_language,
    bp.ad_orgbp_id                          AS c_bp_ad_orgbp_id,
    bp.ad_org_id                            AS c_bp_ad_org_id,
    bp.bpartner_parent_id                   AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                        AS c_bp_c_bp_group_id,
    bp.c_dunning_id                         AS c_bp_c_dunning_id,
    bp.c_greeting_id                        AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id                 AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id                     AS c_bp_c_paymentterm_id,
    bp.created                              AS c_bp_created,
    bp.createdby                            AS c_bp_createdby,
    bp.c_taxgroup_id                        AS c_bp_c_taxgroup_id,
    bp.deliveryrule                         AS c_bp_deliveryrule,
    bp.deliveryviarule                      AS c_bp_deliveryviarule,
    bp.description                          AS c_bp_description,
    bp.dunninggrace                         AS c_bp_dunninggrace,
    bp.firstsale                            AS c_bp_firstsale,
    bp.flatdiscount                         AS c_bp_flatdiscount,
    bp.freightcostrule                      AS c_bp_freightcostrule,
    bp.invoicerule                          AS c_bp_invoicerule,
    bp.isactive                             AS c_bp_isactive,
    bp.iscustomer                           AS c_bp_iscustomer,
    bp.isdiscountprinted                    AS c_bp_isdiscountprinted,
    bp.isemployee                           AS c_bp_isemployee,
    bp.ismanufacturer                       AS c_bp_ismanufacturer,
    bp.isonetime                            AS c_bp_isonetime,
    bp.ispotaxexempt                        AS c_bp_ispotaxexempt,
    bp.isprospect                           AS c_bp_isprospect,
    bp.issalesrep                           AS c_bp_issalesrep,
    bp.issummary                            AS c_bp_issummary,
    bp.istaxexempt                          AS c_bp_istaxexempt,
    bp.isvendor                             AS c_bp_isvendor,
    bp.logo_id                              AS c_bp_logo_id,
    bp.m_discountschema_id                  AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                       AS c_bp_m_pricelist_id,
    bp.numberemployees                      AS c_bp_numberemployees,
    bp.paymentrule                          AS c_bp_paymentrule,
    bp.paymentrulepo                        AS c_bp_paymentrulepo,
    bp.po_discountschema_id                 AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id                    AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id                      AS c_bp_po_pricelist_id,
    bp.potentiallifetimevalue               AS c_bp_potentiallifetimevalue,
    bp.rating                               AS c_bp_rating,
    bp.salesrep_id                          AS c_bp_salesrep_id,
    bp.salesvolume                          AS c_bp_salesvolume,
    bp.sendemail                            AS c_bp_sendemail,
    bp.shareofcustomer                      AS c_bp_shareofcustomer,
    bp.shelflifeminpct                      AS c_bp_shelflifeminpct,
    bp.so_creditlimit                       AS c_bp_so_creditlimit,
    bp.socreditstatus                       AS c_bp_socreditstatus,
    bp.so_creditused                        AS c_bp_so_creditused,
    bp.so_description                       AS c_bp_so_description,
    bp.totalopenbalance                     AS c_bp_totalopenbalance,
    bp.updated                              AS c_bp_updated,
    bp.updatedby                            AS c_bp_updatedby,
    bp.url                                  AS c_bp_url,
    bpgt.ad_org_id                          AS c_greeting_ad_org_id,
    bpgt.isactive                           AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                               AS c_greeting_name,
    oi.ad_org_id                            AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                              AS ad_orginfo_created,
    oi.createdby                            AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                                 AS ad_orginfo_duns,
    oi.email                                AS ad_orginfo_email,
    oi.fax                                  AS ad_orginfo_fax,
    oi.isactive                             AS ad_orginfo_isactive,
    oi.m_warehouse_id,
    oi.parent_org_id,
    oi.phone                                AS ad_orginfo_phone,
    oi.phone2                               AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                              AS ad_orginfo_updated,
    oi.updatedby                            AS ad_orginfo_updatedby 
FROM c_payselectioncheck psc 
        JOIN c_payselection ps 
        ON psc.c_payselection_id = ps.c_payselection_id 
        LEFT JOIN c_payment p 
        ON psc.c_payment_id = p.c_payment_id 
        LEFT JOIN c_bankaccount ba 
        ON p.c_bankaccount_id = ba.c_bankaccount_id 
        LEFT JOIN c_doctype_trl dt 
        ON p.c_doctype_id = dt.c_doctype_id 
        JOIN c_bpartner bp 
        ON psc.c_bpartner_id = bp.c_bpartner_id 
        JOIN ad_orginfo oi 
        ON psc.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON psc.ad_client_id = ci.ad_client_id 
        LEFT JOIN ad_language l 
        ON l.issystemlanguage = 'Y' 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id AND bpgt.ad_language = l.ad_language
;

DROP VIEW c_payselection_remittance_v;

CREATE OR REPLACE VIEW c_payselection_remittance_v AS 
SELECT psl.ad_client_id,
    psl.ad_org_id,
    'en_US'::character varying AS ad_language,
    psl.c_payselection_id,
    psl.c_payselectionline_id,
    psl.c_payselectioncheck_id,
    psl.paymentrule,
    psl.line,
    psl.openamt,
    psl.payamt,
    psl.discountamt,
    psl.differenceamt,
    i.c_bpartner_id,
    i.documentno,
    i.dateinvoiced,
    i.grandtotal,
    i.grandtotal               AS amtinwords,
    psl.c_invoice_id,
    psl.created                AS c_payselectionline_created,
    psl.createdby              AS c_payselectionline_createdby,
    psl.description            AS c_payselectionline_description,
    psl.isactive               AS c_payselectionline_isactive,
    psl.ismanual,
    psl.issotrx                AS c_payselectionline_issotrx,
    psl.processed,
    psl.updated                AS c_payselectionline_updated,
    psl.updatedby              AS c_payselectionline_updatedby,
    i.ad_org_id                AS c_invoice_ad_org_id,
    i.ad_orgtrx_id,
    i.ad_user_id,
    i.c_activity_id,
    i.c_bpartner_location_id,
    i.c_campaign_id,
    i.c_charge_id,
    i.c_conversiontype_id,
    i.c_currency_id,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.c_paymentterm_id,
    i.c_project_id,
    i.created                  AS c_invoice_created,
    i.createdby                AS c_invoice_createdby,
    i.dateacct,
    i.dateordered,
    i.dateprinted,
    i.description              AS c_invoice_description,
    i.docaction,
    i.docstatus,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isactive                 AS c_invoice_isactive,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice            AS c_invoice_isselfservice,
    i.issotrx                  AS c_invoice_issotrx,
    i.istaxincluded,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule              AS c_invoice_paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.totallines,
    i.updated                  AS c_invoice_updated,
    i.updatedby                AS c_invoice_updatedby,
    i.user1_id,
    i.user2_id 
FROM c_payselectionline psl 
        JOIN c_invoice i 
        ON psl.c_invoice_id = i.c_invoice_id
;

DROP VIEW c_payselection_remittance_vt;

CREATE OR REPLACE VIEW c_payselection_remittance_vt AS 
SELECT psl.ad_client_id,
    psl.ad_org_id,
    l.ad_language,
    psl.c_payselection_id,
    psl.c_payselectionline_id,
    psl.c_payselectioncheck_id,
    psl.paymentrule,
    psl.line,
    psl.openamt,
    psl.payamt,
    psl.discountamt,
    psl.differenceamt,
    i.c_bpartner_id,
    i.documentno,
    i.dateinvoiced,
    i.grandtotal,
    i.grandtotal    AS amtinwords,
    psl.c_invoice_id,
    psl.created     AS c_payselectionline_created,
    psl.createdby   AS c_payselectionline_createdby,
    psl.description AS c_payselectionline_description,
    psl.isactive    AS c_payselectionline_isactive,
    psl.ismanual,
    psl.issotrx     AS c_payselectionline_issotrx,
    psl.processed,
    psl.updated     AS c_payselectionline_updated,
    psl.updatedby   AS c_payselectionline_updatedby,
    i.ad_org_id     AS c_invoice_ad_org_id,
    i.ad_orgtrx_id,
    i.ad_user_id,
    i.c_activity_id,
    i.c_bpartner_location_id,
    i.c_campaign_id,
    i.c_charge_id,
    i.c_conversiontype_id,
    i.c_currency_id,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.c_paymentterm_id,
    i.c_project_id,
    i.created       AS c_invoice_created,
    i.createdby     AS c_invoice_createdby,
    i.dateacct,
    i.dateordered,
    i.dateprinted,
    i.description   AS c_invoice_description,
    i.docaction,
    i.docstatus,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isactive      AS c_invoice_isactive,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice AS c_invoice_isselfservice,
    i.issotrx       AS c_invoice_issotrx,
    i.istaxincluded,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule   AS c_invoice_paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.totallines,
    i.updated       AS c_invoice_updated,
    i.updatedby     AS c_invoice_updatedby,
    i.user1_id,
    i.user2_id 
FROM c_payselectionline psl 
        JOIN c_invoice i 
        ON psl.c_invoice_id = i.c_invoice_id 
        JOIN ad_language l 
        ON l.issystemlanguage = 'Y'
;

DROP VIEW c_project_details_v;

CREATE OR REPLACE VIEW c_project_details_v AS 
SELECT pl.ad_client_id,
    pl.ad_org_id,
    pl.isactive,
    pl.created,
    pl.createdby,
    pl.updated,
    pl.updatedby,
    'en_US'::character varying       AS ad_language,
    pj.c_project_id,
    pl.c_projectline_id,
    pl.line,
    pl.plannedqty,
    pl.plannedprice,
    pl.plannedamt,
    pl.plannedmarginamt,
    pl.committedamt,
    pl.m_product_id,
    COALESCE(p.name, pl.description) AS name,
    CASE WHEN p.name IS NOT NULL THEN pl.description ELSE NULL END                          AS description,
    p.documentnote,
    p.upc,
    p.sku,
    p.value                          AS productvalue,
    pl.m_product_category_id,
    pl.invoicedamt,
    pl.invoicedqty,
    pl.committedqty,
    pl.c_order_id,
    pl.c_orderpo_id,
    pl.c_projectissue_id,
    pl.c_projectphase_id,
    pl.c_projecttask_id,
    pl.dopricing,
    pl.isprinted,
    pl.processed                     AS c_projectline_processed,
    pj.ad_org_id                     AS c_project_ad_org_id,
    pj.ad_user_id,
    pj.c_bpartner_id,
    pj.c_bpartner_location_id,
    pj.c_bpartnersr_id,
    pj.c_campaign_id,
    pj.c_currency_id,
    pj.committedamt                  AS c_project_committedamt,
    pj.committedqty                  AS c_project_committedqty,
    pj.copyfrom                      AS c_project_copyfrom,
    pj.c_paymentterm_id,
    pj.c_phase_id,
    pj.c_projecttype_id,
    pj.created                       AS c_project_created,
    pj.createdby                     AS c_project_createdby,
    pj.datecontract,
    pj.datefinish,
    pj.description                   AS c_project_description,
    pj.generateto,
    pj.invoicedamt                   AS c_project_invoicedamt,
    pj.invoicedqty                   AS c_project_invoicedqty,
    pj.isactive                      AS c_project_isactive,
    pj.iscommitceiling,
    pj.iscommitment,
    pj.issummary                     AS c_project_issummary,
    pj.m_pricelist_version_id,
    pj.m_warehouse_id,
    pj.name                          AS c_project_name,
    pj.note                          AS c_project_note,
    pj.plannedamt                    AS c_project_plannedamt,
    pj.plannedmarginamt              AS c_project_plannedmarginamt,
    pj.plannedqty                    AS c_project_plannedqty,
    pj.poreference,
    pj.processed                     AS c_project_processed,
    pj.processing                    AS c_project_processing,
    pj.projectbalanceamt,
    pj.projectcategory,
    pj.projectlinelevel,
    pj.projinvoicerule,
    pj.salesrep_id                   AS c_project_salesrep_id,
    pj.updated                       AS c_project_updated,
    pj.updatedby                     AS c_project_updatedby,
    pj.value                         AS c_project_value,
    p.ad_org_id                      AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                       AS m_product_copyfrom,
    p.created                        AS m_product_created,
    p.createdby                      AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id,
    p.description                    AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                       AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                      AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id,
    p.m_attributesetinstance_id,
    p.m_freightcategory_id,
    p.m_locator_id,
    p.m_product_category_id          AS m_product_m_prod_category_id,
    p.m_product_id                   AS m_product_m_product_id,
    p.processing                     AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                    AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                        AS m_product_updated,
    p.updatedby                      AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight 
FROM c_projectline pl 
        JOIN c_project pj 
        ON pl.c_project_id = pj.c_project_id 
        LEFT JOIN m_product p 
        ON pl.m_product_id = p.m_product_id 
WHERE pl.isprinted = 'Y'
;

DROP VIEW c_project_details_vt;

CREATE OR REPLACE VIEW c_project_details_vt AS 
SELECT pl.ad_client_id,
    pl.ad_org_id,
    pl.isactive,
    pl.created,
    pl.createdby,
    pl.updated,
    pl.updatedby,
    l.ad_language,
    pj.c_project_id,
    pl.c_projectline_id,
    pl.line,
    pl.plannedqty,
    pl.plannedprice,
    pl.plannedamt,
    pl.plannedmarginamt,
    pl.committedamt,
    pl.m_product_id,
    COALESCE(pt.name, pl.description) AS name,
    CASE WHEN pt.name IS NOT NULL THEN pl.description ELSE NULL END                           AS description,
    pt.documentnote,
    p.upc,
    p.sku,
    p.value                           AS productvalue,
    pl.m_product_category_id,
    pl.invoicedamt,
    pl.invoicedqty,
    pl.committedqty,
    pl.c_order_id,
    pl.c_orderpo_id,
    pl.c_projectissue_id,
    pl.c_projectphase_id,
    pl.c_projecttask_id,
    pl.dopricing,
    pl.isprinted,
    pl.processed                      AS c_projectline_processed,
    pj.ad_org_id                      AS c_project_ad_org_id,
    pj.ad_user_id,
    pj.c_bpartner_id,
    pj.c_bpartner_location_id,
    pj.c_bpartnersr_id,
    pj.c_campaign_id,
    pj.c_currency_id,
    pj.committedamt                   AS c_project_committedamt,
    pj.committedqty                   AS c_project_committedqty,
    pj.copyfrom                       AS c_project_copyfrom,
    pj.c_paymentterm_id,
    pj.c_phase_id,
    pj.c_projecttype_id,
    pj.created                        AS c_project_created,
    pj.createdby                      AS c_project_createdby,
    pj.datecontract,
    pj.datefinish,
    pj.description                    AS c_project_description,
    pj.generateto,
    pj.invoicedamt                    AS c_project_invoicedamt,
    pj.invoicedqty                    AS c_project_invoicedqty,
    pj.isactive                       AS c_project_isactive,
    pj.iscommitceiling,
    pj.iscommitment,
    pj.issummary                      AS c_project_issummary,
    pj.m_pricelist_version_id,
    pj.m_warehouse_id,
    pj.name                           AS c_project_name,
    pj.note                           AS c_project_note,
    pj.plannedamt                     AS c_project_plannedamt,
    pj.plannedmarginamt               AS c_project_plannedmarginamt,
    pj.plannedqty                     AS c_project_plannedqty,
    pj.poreference,
    pj.processed                      AS c_project_processed,
    pj.processing                     AS c_project_processing,
    pj.projectbalanceamt,
    pj.projectcategory,
    pj.projectlinelevel,
    pj.projinvoicerule,
    pj.salesrep_id                    AS c_project_salesrep_id,
    pj.updated                        AS c_project_updated,
    pj.updatedby                      AS c_project_updatedby,
    pj.value                          AS c_project_value,
    pt.ad_org_id                      AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                        AS m_product_copyfrom,
    pt.created                        AS m_product_created,
    pt.createdby                      AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id,
    pt.description                    AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    pt.isactive                       AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                       AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id,
    p.m_attributesetinstance_id,
    p.m_freightcategory_id,
    p.m_locator_id,
    p.m_product_category_id           AS m_product_m_prod_category_id,
    p.m_product_id                    AS m_product_m_product_id,
    p.processing                      AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                     AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                         AS m_product_updated,
    p.updatedby                       AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight 
FROM c_projectline pl 
        JOIN c_project pj 
        ON pl.c_project_id = pj.c_project_id 
        LEFT JOIN m_product p 
        ON pl.m_product_id = p.m_product_id 
        LEFT JOIN m_product_trl pt 
        ON pl.m_product_id = pt.m_product_id 
        JOIN ad_language l 
        ON l.issystemlanguage = 'Y' 
WHERE pl.isprinted = 'Y'
;

DROP VIEW c_project_header_v;

CREATE OR REPLACE VIEW c_project_header_v AS 
SELECT p.ad_client_id,
    p.ad_org_id,
    p.isactive,
    p.created,
    p.createdby,
    p.updated,
    p.updatedby,
    'en_US'::character varying       AS ad_language,
    p.c_project_id,
    p.value,
    p.name                           AS projectname,
    p.description,
    p.note,
    p.issummary,
    p.projectcategory,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    p.c_projecttype_id,
    pjt.name                         AS projecttypename,
    p.c_phase_id,
    pjp.name                         AS projectphasename,
    p.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    p.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    bpg.greeting                     AS bpgreeting,
    bp.name,
    bp.name2,
    bpcg.greeting                    AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    pt.name                          AS paymentterm,
    pt.documentnote                  AS paymenttermnote,
    p.poreference,
    p.c_currency_id,
    p.m_pricelist_version_id,
    p.c_campaign_id,
    p.plannedamt,
    p.plannedqty,
    p.plannedmarginamt,
    p.invoicedamt,
    p.invoicedqty,
    p.projectbalanceamt,
    p.iscommitment,
    p.committedamt,
    p.committedqty,
    p.datecontract,
    p.datefinish,
    p.iscommitceiling,
    p.m_warehouse_id,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    p.ad_user_id,
    p.c_bpartner_location_id,
    p.copyfrom,
    p.c_paymentterm_id               AS c_project_c_paymentterm_id,
    p.generateto,
    p.processed                      AS c_project_processed,
    p.processing                     AS c_project_processing,
    p.projectlinelevel,
    p.projinvoicerule,
    bp.acqusitioncost                AS c_bp_acqusitioncost,
    bp.actuallifetimevalue           AS c_bp_actuallifetimevalue,
    bp.ad_language                   AS c_bp_ad_language,
    bp.ad_orgbp_id                   AS c_bp_ad_orgbp_id,
    bp.ad_org_id                     AS c_bp_ad_org_id,
    bp.bpartner_parent_id            AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bp_c_bp_group_id,
    bp.c_dunning_id                  AS c_bp_c_dunning_id,
    bp.c_greeting_id                 AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bp_c_paymentterm_id,
    bp.created                       AS c_bp_created,
    bp.createdby                     AS c_bp_createdby,
    bp.c_taxgroup_id                 AS c_bp_c_taxgroup_id,
    bp.deliveryrule                  AS c_bp_deliveryrule,
    bp.deliveryviarule               AS c_bp_deliveryviarule,
    bp.description                   AS c_bp_description,
    bp.dunninggrace                  AS c_bp_dunninggrace,
    bp.firstsale                     AS c_bp_firstsale,
    bp.flatdiscount                  AS c_bp_flatdiscount,
    bp.freightcostrule               AS c_bp_freightcostrule,
    bp.invoicerule                   AS c_bp_invoicerule,
    bp.isactive                      AS c_bp_isactive,
    bp.iscustomer                    AS c_bp_iscustomer,
    bp.isdiscountprinted             AS c_bp_isdiscountprinted,
    bp.isemployee                    AS c_bp_isemployee,
    bp.ismanufacturer                AS c_bp_ismanufacturer,
    bp.isonetime                     AS c_bp_isonetime,
    bp.ispotaxexempt                 AS c_bp_ispotaxexempt,
    bp.isprospect                    AS c_bp_isprospect,
    bp.issalesrep                    AS c_bp_issalesrep,
    bp.issummary                     AS c_bp_issummary,
    bp.istaxexempt                   AS c_bp_istaxexempt,
    bp.isvendor                      AS c_bp_isvendor,
    bp.logo_id                       AS c_bp_logo_id,
    bp.m_discountschema_id           AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                AS c_bp_m_pricelist_id,
    bp.numberemployees               AS c_bp_numberemployees,
    bp.paymentrule                   AS c_bp_paymentrule,
    bp.paymentrulepo                 AS c_bp_paymentrulepo,
    bp.po_discountschema_id          AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id             AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bp_po_pricelist_id,
    bp.poreference                   AS c_bp_poreference,
    bp.potentiallifetimevalue        AS c_bp_potentiallifetimevalue,
    bp.rating                        AS c_bp_rating,
    bp.salesrep_id                   AS c_bp_salesrep_id,
    bp.salesvolume                   AS c_bp_salesvolume,
    bp.sendemail                     AS c_bp_sendemail,
    bp.shareofcustomer               AS c_bp_shareofcustomer,
    bp.shelflifeminpct               AS c_bp_shelflifeminpct,
    bp.so_creditlimit                AS c_bp_so_creditlimit,
    bp.socreditstatus                AS c_bp_socreditstatus,
    bp.so_creditused                 AS c_bp_so_creditused,
    bp.so_description                AS c_bp_so_description,
    bp.totalopenbalance              AS c_bp_totalopenbalance,
    bp.updated                       AS c_bp_updated,
    bp.updatedby                     AS c_bp_updatedby,
    bp.url                           AS c_bp_url,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    pjt.ad_org_id                    AS c_projecttype_ad_org_id,
    pjt.description                  AS c_projecttype_description,
    pjt.help                         AS c_projecttype_help,
    pjt.isactive                     AS c_projecttype_isactive,
    pjt.projectcategory              AS c_projecttype_projectcategory,
    pjp.ad_org_id                    AS c_phase_ad_org_id,
    pjp.c_phase_id                   AS c_phase_c_phase_id,
    pjp.c_projecttype_id             AS c_phase_c_projecttype_id,
    pjp.description                  AS c_phase_description,
    pjp.help                         AS c_phase_help,
    pjp.isactive                     AS c_phase_isactive,
    pjp.m_product_id                 AS c_phase_m_product_id,
    pjp.seqno                        AS c_phase_seqno,
    pjp.standardqty,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bp_acqusitioncost,
    ubp.actuallifetimevalue          AS salesrep_bp_actuallifevalue,
    ubp.ad_language                  AS salesrep_bp_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bp_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bp_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bp_bpartner_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_dunning_id                 AS salesrep_bp_c_dunning_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_c_invoicesched_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bp_created,
    ubp.createdby                    AS salesrep_bp_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bp_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bp_deliveryviarule,
    ubp.description                  AS salesrep_bp_description,
    ubp.dunninggrace                 AS salesrep_bp_dunninggrace,
    ubp.duns                         AS salesrep_bp_duns,
    ubp.firstsale                    AS salesrep_bp_firstsale,
    ubp.flatdiscount                 AS salesrep_bp_flatdiscount,
    ubp.freightcostrule              AS salesrep_bp_freightcostrule,
    ubp.invoicerule                  AS salesrep_bp_invoicerule,
    ubp.isactive                     AS salesrep_bp_isactive,
    ubp.iscustomer                   AS salesrep_bp_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bp_isdiscountprinted,
    ubp.isemployee                   AS salesrep_bp_isemployee,
    ubp.ismanufacturer               AS salesrep_bp_ismanufacturer,
    ubp.isonetime                    AS salesrep_bp_isonetime,
    ubp.ispotaxexempt                AS salesrep_bp_ispotaxexempt,
    ubp.isprospect                   AS salesrep_bp_isprospect,
    ubp.issalesrep                   AS salesrep_bp_issalesrep,
    ubp.issummary                    AS salesrep_bp_issummary,
    ubp.istaxexempt                  AS salesrep_bp_istaxexempt,
    ubp.isvendor                     AS salesrep_bp_isvendor,
    ubp.logo_id                      AS salesrep_bp_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_m_discountschm_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bp_naics,
    ubp.name2                        AS salesrep_bp_name2,
    ubp.numberemployees              AS salesrep_bp_numberemployees,
    ubp.paymentrule                  AS salesrep_bp_paymentrule,
    ubp.paymentrulepo                AS salesrep_bp_paymentrulepo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountschm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bp_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bp_potentiallifevalue,
    ubp.rating                       AS salesrep_bp_rating,
    ubp.referenceno                  AS salesrep_bp_referenceno,
    ubp.salesrep_id                  AS salesrep_bp_salesrep_id,
    ubp.salesvolume                  AS salesrep_bp_salesvolume,
    ubp.sendemail                    AS salesrep_bp_sendemail,
    ubp.shareofcustomer              AS salesrep_bp_shareofcustomer,
    ubp.shelflifeminpct              AS salesrep_bp_shelflifeminpct,
    ubp.so_creditlimit               AS salesrep_bp_so_creditlimit,
    ubp.socreditstatus               AS salesrep_bp_socreditstatus,
    ubp.so_creditused                AS salesrep_bp_so_creditused,
    ubp.so_description               AS salesrep_bp_so_description,
    ubp.taxid                        AS salesrep_bp_taxid,
    ubp.totalopenbalance             AS salesrep_bp_totalopenbalance,
    ubp.updated                      AS salesrep_bp_updated,
    ubp.updatedby                    AS salesrep_bp_updatedby,
    ubp.url                          AS salesrep_bp_url,
    ubp.value                        AS salesrep_bp_value,
    bpg.ad_org_id                    AS c_greeting_ad_org_id,
    bpg.isactive                     AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpg.name                         AS c_greeting_name,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcg.ad_org_id                   AS c_user_greeting_ad_org_id,
    bpcg.c_greeting_id               AS c_user_greeting_c_greeting_id,
    bpcg.isactive                    AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcg.name                        AS c_user_greeting_name,
    bpl.ad_org_id                    AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id                AS c_bp_location_c_bpartner_id,
    bpl.created                      AS c_bp_location_created,
    bpl.createdby                    AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bp_location_fax,
    bpl.isactive                     AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bp_location_name,
    bpl.phone                        AS c_bp_location_phone,
    bpl.phone2                       AS c_bp_location_phone2,
    bpl.updated                      AS c_bp_location_updated,
    bpl.updatedby                    AS c_bp_location_updatedby,
    pt.ad_org_id                     AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id              AS c_paymentterm_c_paymentterm_id,
    pt.description                   AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    pt.isactive                      AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS c_paymentterm_value 
FROM c_project p 
        LEFT JOIN c_bpartner bp 
        ON p.c_bpartner_id = bp.c_bpartner_id 
        JOIN ad_orginfo oi 
        ON p.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON p.ad_client_id = ci.ad_client_id 
        LEFT JOIN c_projecttype pjt 
        ON p.c_projecttype_id = pjt.c_projecttype_id 
        LEFT JOIN c_phase pjp 
        ON p.c_phase_id = pjp.c_phase_id 
        LEFT JOIN ad_user u 
        ON p.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN ad_user bpc 
        ON p.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_bpartner_location bpl 
        ON p.c_bpartner_location_id = bpl.c_bpartner_location_id 
        LEFT JOIN c_paymentterm pt 
        ON p.c_paymentterm_id = pt.c_paymentterm_id
;

DROP VIEW c_project_header_vt;

CREATE OR REPLACE VIEW c_project_header_vt AS 
SELECT p.ad_client_id,
    p.ad_org_id,
    p.isactive,
    p.created,
    p.createdby,
    p.updated,
    p.updatedby,
    ptt.ad_language,
    p.c_project_id,
    p.value,
    p.name                           AS projectname,
    p.description,
    p.note,
    p.issummary,
    p.projectcategory,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    p.c_projecttype_id,
    pjt.name                         AS projecttypename,
    p.c_phase_id,
    pjp.name                         AS projectphasename,
    p.salesrep_id,
    COALESCE(ubp.name, u.name)       AS salesrep_name,
    p.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    bp.referenceno,
    ptt.name                         AS paymentterm,
    ptt.documentnote                 AS paymenttermnote,
    p.poreference,
    p.c_currency_id,
    p.m_pricelist_version_id,
    p.c_campaign_id,
    p.plannedamt,
    p.plannedqty,
    p.plannedmarginamt,
    p.invoicedamt,
    p.invoicedqty,
    p.projectbalanceamt,
    p.iscommitment,
    p.committedamt,
    p.committedqty,
    p.datecontract,
    p.datefinish,
    p.iscommitceiling,
    p.m_warehouse_id,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    p.ad_user_id,
    p.c_bpartner_location_id,
    p.copyfrom,
    p.c_paymentterm_id               AS c_project_c_paymentterm_id,
    p.generateto,
    p.processed                      AS c_project_processed,
    p.processing                     AS c_project_processing,
    p.projectlinelevel,
    p.projinvoicerule,
    bp.acqusitioncost                AS c_bp_acqusitioncost,
    bp.actuallifetimevalue           AS c_bp_actuallifetimevalue,
    bp.ad_language                   AS c_bp_ad_language,
    bp.ad_orgbp_id                   AS c_bp_ad_orgbp_id,
    bp.ad_org_id                     AS c_bp_ad_org_id,
    bp.bpartner_parent_id            AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bp_c_bp_group_id,
    bp.c_dunning_id                  AS c_bp_c_dunning_id,
    bp.c_greeting_id                 AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bp_c_paymentterm_id,
    bp.created                       AS c_bp_created,
    bp.createdby                     AS c_bp_createdby,
    bp.c_taxgroup_id                 AS c_bp_c_taxgroup_id,
    bp.deliveryrule                  AS c_bp_deliveryrule,
    bp.deliveryviarule               AS c_bp_deliveryviarule,
    bp.description                   AS c_bp_description,
    bp.dunninggrace                  AS c_bp_dunninggrace,
    bp.firstsale                     AS c_bp_firstsale,
    bp.flatdiscount                  AS c_bp_flatdiscount,
    bp.freightcostrule               AS c_bp_freightcostrule,
    bp.invoicerule                   AS c_bp_invoicerule,
    bp.isactive                      AS c_bp_isactive,
    bp.iscustomer                    AS c_bp_iscustomer,
    bp.isdiscountprinted             AS c_bp_isdiscountprinted,
    bp.isemployee                    AS c_bp_isemployee,
    bp.ismanufacturer                AS c_bp_ismanufacturer,
    bp.isonetime                     AS c_bp_isonetime,
    bp.ispotaxexempt                 AS c_bp_ispotaxexempt,
    bp.isprospect                    AS c_bp_isprospect,
    bp.issalesrep                    AS c_bp_issalesrep,
    bp.issummary                     AS c_bp_issummary,
    bp.istaxexempt                   AS c_bp_istaxexempt,
    bp.isvendor                      AS c_bp_isvendor,
    bp.logo_id                       AS c_bp_logo_id,
    bp.m_discountschema_id           AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                AS c_bp_m_pricelist_id,
    bp.numberemployees               AS c_bp_numberemployees,
    bp.paymentrule                   AS c_bp_paymentrule,
    bp.paymentrulepo                 AS c_bp_paymentrulepo,
    bp.po_discountschema_id          AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id             AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bp_po_pricelist_id,
    bp.poreference                   AS c_bp_poreference,
    bp.potentiallifetimevalue        AS c_bp_potentiallifetimevalue,
    bp.rating                        AS c_bp_rating,
    bp.salesrep_id                   AS c_bp_salesrep_id,
    bp.salesvolume                   AS c_bp_salesvolume,
    bp.sendemail                     AS c_bp_sendemail,
    bp.shareofcustomer               AS c_bp_shareofcustomer,
    bp.shelflifeminpct               AS c_bp_shelflifeminpct,
    bp.so_creditlimit                AS c_bp_so_creditlimit,
    bp.socreditstatus                AS c_bp_socreditstatus,
    bp.so_creditused                 AS c_bp_so_creditused,
    bp.so_description                AS c_bp_so_description,
    bp.totalopenbalance              AS c_bp_totalopenbalance,
    bp.updated                       AS c_bp_updated,
    bp.updatedby                     AS c_bp_updatedby,
    bp.url                           AS c_bp_url,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    pjt.ad_org_id                    AS c_projecttype_ad_org_id,
    pjt.description                  AS c_projecttype_description,
    pjt.help                         AS c_projecttype_help,
    pjt.isactive                     AS c_projecttype_isactive,
    pjt.projectcategory              AS c_projecttype_projectcategory,
    pjp.ad_org_id                    AS c_phase_ad_org_id,
    pjp.c_phase_id                   AS c_phase_c_phase_id,
    pjp.c_projecttype_id             AS c_phase_c_projecttype_id,
    pjp.description                  AS c_phase_description,
    pjp.help                         AS c_phase_help,
    pjp.isactive                     AS c_phase_isactive,
    pjp.m_product_id                 AS c_phase_m_product_id,
    pjp.seqno                        AS c_phase_seqno,
    pjp.standardqty,
    u.ad_org_id                      AS salesrep_ad_org_id,
    u.ad_orgtrx_id                   AS salesrep_ad_orgtrx_id,
    u.birthday                       AS salesrep_ad_birthday,
    u.c_bpartner_id                  AS salesrep_c_bpartner_id,
    u.c_bpartner_location_id         AS salesrep_c_bp_location_id,
    u.c_greeting_id                  AS salesrep_c_greeting_id,
    u.comments                       AS salesrep_comments,
    u.created                        AS salesrep_created,
    u.createdby                      AS salesrep_createdby,
    u.description                    AS salesrep_description,
    u.email                          AS salesrep_email,
    u.fax                            AS salesrep_fax,
    u.isactive                       AS salesrep_isactive,
    u.lastcontact                    AS salesrep_lastcontact,
    u.lastresult                     AS salesrep_lastresult,
    u.phone                          AS salesrep_phone,
    u.phone2                         AS salesrep_phone2,
    u.supervisor_id                  AS salesrep_supervisor_id,
    u.title                          AS salesrep_title,
    u.updated                        AS salesrep_updated,
    u.updatedby                      AS salesrep_updatedby,
    u.value                          AS salesrep_value,
    ubp.acqusitioncost               AS salesrep_bp_acqusitioncost,
    ubp.actuallifetimevalue          AS salesrep_bp_actuallifevalue,
    ubp.ad_language                  AS salesrep_bp_ad_language,
    ubp.ad_orgbp_id                  AS salesrep_bp_ad_orgbp_id,
    ubp.ad_org_id                    AS salesrep_bp_ad_org_id,
    ubp.bpartner_parent_id           AS salesrep_bp_bpartner_parent_id,
    ubp.c_bp_group_id                AS salesrep_bp_c_bp_group_id,
    ubp.c_dunning_id                 AS salesrep_bp_c_dunning_id,
    ubp.c_greeting_id                AS salesrep_bp_c_greeting_id,
    ubp.c_invoiceschedule_id         AS salesrep_bp_c_invoicesched_id,
    ubp.c_paymentterm_id             AS salesrep_bp_c_paymentterm_id,
    ubp.created                      AS salesrep_bp_created,
    ubp.createdby                    AS salesrep_bp_createdby,
    ubp.c_taxgroup_id                AS salesrep_bp_c_taxgroup_id,
    ubp.deliveryrule                 AS salesrep_bp_deliveryrule,
    ubp.deliveryviarule              AS salesrep_bp_deliveryviarule,
    ubp.description                  AS salesrep_bp_description,
    ubp.dunninggrace                 AS salesrep_bp_dunninggrace,
    ubp.duns                         AS salesrep_bp_duns,
    ubp.firstsale                    AS salesrep_bp_firstsale,
    ubp.flatdiscount                 AS salesrep_bp_flatdiscount,
    ubp.freightcostrule              AS salesrep_bp_freightcostrule,
    ubp.invoicerule                  AS salesrep_bp_invoicerule,
    ubp.isactive                     AS salesrep_bp_isactive,
    ubp.iscustomer                   AS salesrep_bp_iscustomer,
    ubp.isdiscountprinted            AS salesrep_bp_isdiscountprinted,
    ubp.isemployee                   AS salesrep_bp_isemployee,
    ubp.ismanufacturer               AS salesrep_bp_ismanufacturer,
    ubp.isonetime                    AS salesrep_bp_isonetime,
    ubp.ispotaxexempt                AS salesrep_bp_ispotaxexempt,
    ubp.isprospect                   AS salesrep_bp_isprospect,
    ubp.issalesrep                   AS salesrep_bp_issalesrep,
    ubp.issummary                    AS salesrep_bp_issummary,
    ubp.istaxexempt                  AS salesrep_bp_istaxexempt,
    ubp.isvendor                     AS salesrep_bp_isvendor,
    ubp.logo_id                      AS salesrep_bp_logo_id,
    ubp.m_discountschema_id          AS salesrep_bp_m_discountschm_id,
    ubp.m_pricelist_id               AS salesrep_bp_m_pricelist_id,
    ubp.naics                        AS salesrep_bp_naics,
    ubp.name2                        AS salesrep_bp_name2,
    ubp.numberemployees              AS salesrep_bp_numberemployees,
    ubp.paymentrule                  AS salesrep_bp_paymentrule,
    ubp.paymentrulepo                AS salesrep_bp_paymentrulepo,
    ubp.po_discountschema_id         AS salesrep_bp_po_discountschm_id,
    ubp.po_paymentterm_id            AS salesrep_bp_po_paymentterm_id,
    ubp.po_pricelist_id              AS salesrep_bp_po_pricelist_id,
    ubp.poreference                  AS salesrep_bp_poreference,
    ubp.potentiallifetimevalue       AS salesrep_bp_potentiallifevalue,
    ubp.rating                       AS salesrep_bp_rating,
    ubp.referenceno                  AS salesrep_bp_referenceno,
    ubp.salesrep_id                  AS salesrep_bp_salesrep_id,
    ubp.salesvolume                  AS salesrep_bp_salesvolume,
    ubp.sendemail                    AS salesrep_bp_sendemail,
    ubp.shareofcustomer              AS salesrep_bp_shareofcustomer,
    ubp.shelflifeminpct              AS salesrep_bp_shelflifeminpct,
    ubp.so_creditlimit               AS salesrep_bp_so_creditlimit,
    ubp.socreditstatus               AS salesrep_bp_socreditstatus,
    ubp.so_creditused                AS salesrep_bp_so_creditused,
    ubp.so_description               AS salesrep_bp_so_description,
    ubp.taxid                        AS salesrep_bp_taxid,
    ubp.totalopenbalance             AS salesrep_bp_totalopenbalance,
    ubp.updated                      AS salesrep_bp_updated,
    ubp.updatedby                    AS salesrep_bp_updatedby,
    ubp.url                          AS salesrep_bp_url,
    ubp.value                        AS salesrep_bp_value,
    bpgt.ad_org_id                   AS c_greeting_ad_org_id,
    bpgt.isactive                    AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                        AS c_greeting_name,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.ad_org_id                  AS c_user_greeting_ad_org_id,
    bpcgt.c_greeting_id              AS c_user_greeting_c_greeting_id,
    bpcgt.isactive                   AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcgt.name                       AS c_user_greeting_name,
    bpl.ad_org_id                    AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id                AS c_bp_location_c_bpartner_id,
    bpl.created                      AS c_bp_location_created,
    bpl.createdby                    AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bp_location_fax,
    bpl.isactive                     AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bp_location_name,
    bpl.phone                        AS c_bp_location_phone,
    bpl.phone2                       AS c_bp_location_phone2,
    bpl.updated                      AS c_bp_location_updated,
    bpl.updatedby                    AS c_bp_location_updatedby,
    ptt.ad_org_id                    AS c_paymentterm_ad_org_id,
    pt.afterdelivery,
    pt.c_paymentterm_id              AS c_paymentterm_c_paymentterm_id,
    ptt.description                  AS c_paymentterm_description,
    pt.discount,
    pt.discount2,
    pt.discountdays,
    pt.discountdays2,
    pt.fixmonthcutoff,
    pt.fixmonthday,
    pt.fixmonthoffset,
    pt.gracedays,
    ptt.isactive                     AS c_paymentterm_isactive,
    pt.isdefault,
    pt.isduefixed,
    pt.isnextbusinessday,
    pt.isvalid,
    pt.netday,
    pt.netdays,
    pt.paymenttermusage,
    pt.value                         AS c_paymentterm_value 
FROM c_project p 
        LEFT JOIN c_bpartner bp 
        ON p.c_bpartner_id = bp.c_bpartner_id 
        JOIN ad_orginfo oi 
        ON p.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON p.ad_client_id = ci.ad_client_id 
        LEFT JOIN c_paymentterm pt 
        ON p.c_paymentterm_id = pt.c_paymentterm_id 
        LEFT JOIN c_paymentterm_trl ptt 
        ON p.c_paymentterm_id = ptt.c_paymentterm_id 
        LEFT JOIN c_projecttype pjt 
        ON p.c_projecttype_id = pjt.c_projecttype_id 
        LEFT JOIN c_phase pjp 
        ON p.c_phase_id = pjp.c_phase_id 
        LEFT JOIN ad_user u 
        ON p.salesrep_id = u.ad_user_id 
        LEFT JOIN c_bpartner ubp 
        ON u.c_bpartner_id = ubp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id 
        LEFT JOIN ad_user bpc 
        ON p.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id 
        LEFT JOIN c_bpartner_location bpl 
        ON p.c_bpartner_location_id = bpl.c_bpartner_location_id
;

DROP VIEW m_inout_header_v;

CREATE OR REPLACE VIEW m_inout_header_v AS 
SELECT io.ad_client_id,
    io.ad_org_id,
    io.isactive,
    io.created,
    io.createdby,
    io.updated,
    io.updatedby,
    'en_US'::character varying       AS ad_language,
    io.m_inout_id,
    io.issotrx,
    io.documentno,
    io.docstatus,
    io.c_doctype_id,
    io.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    io.m_warehouse_id,
    wh.c_location_id                 AS warehouse_location_id,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    io.c_order_id,
    io.movementdate,
    io.movementtype,
    bpg.greeting                     AS bpgreeting,
    bp.name,
    bp.name2,
    bpcg.greeting                    AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    l.postal || l.postal_add         AS postal,
    bp.referenceno,
    io.description,
    io.poreference,
    io.dateordered,
    io.volume,
    io.weight,
    io.m_shipper_id,
    io.deliveryrule,
    io.deliveryviarule,
    io.priorityrule,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    io.ad_orgtrx_id,
    io.ad_user_id,
    io.c_activity_id,
    io.c_bpartner_location_id,
    io.c_campaign_id,
    io.c_charge_id,
    io.chargeamt,
    io.c_invoice_id,
    io.c_project_id,
    io.createconfirm,
    io.createfrom,
    io.createpackage,
    io.dateacct,
    io.dateprinted,
    io.datereceived,
    io.docaction,
    io.dropship_bpartner_id,
    io.dropship_location_id,
    io.dropship_user_id,
    io.freightamt,
    io.freightcostrule,
    io.generateto,
    io.isapproved,
    io.isdropship,
    io.isindispute,
    io.isintransit                   AS m_inout_isintransit,
    io.isprinted,
    io.m_rma_id,
    io.nopackages,
    io.pickdate,
    io.posted,
    io.processed,
    io.processedon,
    io.processing,
    io.ref_inout_id,
    io.reversal_id,
    io.salesrep_id                   AS m_inout_salesrep_id,
    io.sendemail,
    io.shipdate,
    io.trackingno,
    io.user1_id,
    io.user2_id,
    bp.acqusitioncost                AS c_bp_acqusitioncost,
    bp.actuallifetimevalue           AS c_bp_actuallifetimevalue,
    bp.ad_language                   AS c_bp_ad_language,
    bp.ad_orgbp_id                   AS c_bp_ad_orgbp_id,
    bp.ad_org_id                     AS c_bp_ad_org_id,
    bp.bpartner_parent_id            AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bp_c_bp_group_id,
    bp.c_dunning_id                  AS c_bp_c_dunning_id,
    bp.c_greeting_id                 AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bp_c_paymentterm_id,
    bp.created                       AS c_bp_created,
    bp.createdby                     AS c_bp_createdby,
    bp.c_taxgroup_id                 AS c_bp_c_taxgroup_id,
    bp.deliveryrule                  AS c_bp_deliveryrule,
    bp.deliveryviarule               AS c_bp_deliveryviarule,
    bp.description                   AS c_bp_description,
    bp.dunninggrace                  AS c_bp_dunninggrace,
    bp.firstsale                     AS c_bp_firstsale,
    bp.flatdiscount                  AS c_bp_flatdiscount,
    bp.freightcostrule               AS c_bp_freightcostrule,
    bp.invoicerule                   AS c_bp_invoicerule,
    bp.isactive                      AS c_bp_isactive,
    bp.iscustomer                    AS c_bp_iscustomer,
    bp.isdiscountprinted             AS c_bp_isdiscountprinted,
    bp.isemployee                    AS c_bp_isemployee,
    bp.ismanufacturer                AS c_bp_ismanufacturer,
    bp.isonetime                     AS c_bp_isonetime,
    bp.ispotaxexempt                 AS c_bp_ispotaxexempt,
    bp.isprospect                    AS c_bp_isprospect,
    bp.issalesrep                    AS c_bp_issalesrep,
    bp.issummary                     AS c_bp_issummary,
    bp.istaxexempt                   AS c_bp_istaxexempt,
    bp.isvendor                      AS c_bp_isvendor,
    bp.logo_id                       AS c_bp_logo_id,
    bp.m_discountschema_id           AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                AS c_bp_m_pricelist_id,
    bp.numberemployees               AS c_bp_numberemployees,
    bp.paymentrule                   AS c_bp_paymentrule,
    bp.paymentrulepo                 AS c_bp_paymentrulepo,
    bp.po_discountschema_id          AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id             AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bp_po_pricelist_id,
    bp.poreference                   AS c_bp_poreference,
    bp.potentiallifetimevalue        AS c_bp_potentiallifetimevalue,
    bp.rating                        AS c_bp_rating,
    bp.salesrep_id                   AS c_bp_salesrep_id,
    bp.salesvolume                   AS c_bp_salesvolume,
    bp.sendemail                     AS c_bp_sendemail,
    bp.shareofcustomer               AS c_bp_shareofcustomer,
    bp.shelflifeminpct               AS c_bp_shelflifeminpct,
    bp.so_creditlimit                AS c_bp_so_creditlimit,
    bp.socreditstatus                AS c_bp_socreditstatus,
    bp.so_creditused                 AS c_bp_so_creditused,
    bp.so_description                AS c_bp_so_description,
    bp.totalopenbalance              AS c_bp_totalopenbalance,
    bp.updated                       AS c_bp_updated,
    bp.updatedby                     AS c_bp_updatedby,
    bp.url                           AS c_bp_url,
    bpg.ad_org_id                    AS c_greeting_ad_org_id,
    bpg.isactive                     AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpg.name                         AS c_greeting_name,
    bpl.ad_org_id                    AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id                AS c_bp_location_c_bpartner_id,
    bpl.created                      AS c_bp_location_created,
    bpl.createdby                    AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bp_location_fax,
    bpl.isactive                     AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bp_location_name,
    bpl.phone                        AS c_bp_location_phone,
    bpl.phone2                       AS c_bp_location_phone2,
    bpl.updated                      AS c_bp_location_updated,
    bpl.updatedby                    AS c_bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcg.ad_org_id                   AS c_user_greeting_ad_org_id,
    bpcg.isactive                    AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcg.name                        AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    wh.ad_org_id                     AS m_warehouse_ad_org_id,
    wh.description                   AS m_warehouse_description,
    wh.isactive                      AS m_warehouse__isactive,
    wh.isdisallownegativeinv,
    wh.isintransit                   AS m_warehouse_isintransit,
    wh.m_warehousesource_id,
    wh.name                          AS m_warehouse_name,
    wh.replenishmentclass,
    wh.separator,
    wh.value                         AS m_warehouse_value 
FROM m_inout io 
        JOIN c_doctype dt 
        ON io.c_doctype_id = dt.c_doctype_id 
        JOIN c_bpartner bp 
        ON io.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        JOIN c_bpartner_location bpl 
        ON io.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON io.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        JOIN ad_orginfo oi 
        ON io.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON io.ad_client_id = ci.ad_client_id 
        JOIN m_warehouse wh 
        ON io.m_warehouse_id = wh.m_warehouse_id
;

DROP VIEW m_inout_header_vt;

CREATE OR REPLACE VIEW m_inout_header_vt AS 
SELECT io.ad_client_id,
    io.ad_org_id,
    io.isactive,
    io.created,
    io.createdby,
    io.updated,
    io.updatedby,
    dt.ad_language,
    io.m_inout_id,
    io.issotrx,
    io.documentno,
    io.docstatus,
    io.c_doctype_id,
    io.c_bpartner_id,
    bp.value                         AS bpvalue,
    bp.taxid                         AS bptaxid,
    bp.naics,
    bp.duns,
    oi.c_location_id                 AS org_location_id,
    oi.taxid,
    io.m_warehouse_id,
    wh.c_location_id                 AS warehouse_location_id,
    dt.printname                     AS documenttype,
    dt.documentnote                  AS documenttypenote,
    io.c_order_id,
    io.movementdate,
    io.movementtype,
    bpgt.greeting                    AS bpgreeting,
    bp.name,
    bp.name2,
    bpcgt.greeting                   AS bpcontactgreeting,
    bpc.title,
    bpc.phone,
    NULLIF(bpc.name, bp.name)        AS contactname,
    bpl.c_location_id,
    l.postal || l.postal_add         AS postal,
    bp.referenceno,
    io.description,
    io.poreference,
    io.dateordered,
    io.volume,
    io.weight,
    io.m_shipper_id,
    io.deliveryrule,
    io.deliveryviarule,
    io.priorityrule,
    COALESCE(oi.logo_id, ci.logo_id) AS logo_id,
    io.ad_orgtrx_id,
    io.ad_user_id,
    io.c_activity_id,
    io.c_bpartner_location_id,
    io.c_campaign_id,
    io.c_charge_id,
    io.chargeamt,
    io.c_invoice_id,
    io.c_project_id,
    io.createconfirm,
    io.createfrom,
    io.createpackage,
    io.dateacct,
    io.dateprinted,
    io.datereceived,
    io.docaction,
    io.dropship_bpartner_id,
    io.dropship_location_id,
    io.dropship_user_id,
    io.freightamt,
    io.freightcostrule,
    io.generateto,
    io.isapproved,
    io.isdropship,
    io.isindispute,
    io.isintransit                   AS m_inout_isintransit,
    io.isprinted,
    io.m_rma_id,
    io.nopackages,
    io.pickdate,
    io.posted,
    io.processed,
    io.processedon,
    io.processing,
    io.ref_inout_id,
    io.reversal_id,
    io.salesrep_id                   AS m_inout_salesrep_id,
    io.sendemail,
    io.shipdate,
    io.trackingno,
    io.user1_id,
    io.user2_id,
    bp.acqusitioncost                AS c_bp_acqusitioncost,
    bp.actuallifetimevalue           AS c_bp_actuallifetimevalue,
    bp.ad_language                   AS c_bp_ad_language,
    bp.ad_orgbp_id                   AS c_bp_ad_orgbp_id,
    bp.ad_org_id                     AS c_bp_ad_org_id,
    bp.bpartner_parent_id            AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id                 AS c_bp_c_bp_group_id,
    bp.c_dunning_id                  AS c_bp_c_dunning_id,
    bp.c_greeting_id                 AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id          AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id              AS c_bp_c_paymentterm_id,
    bp.created                       AS c_bp_created,
    bp.createdby                     AS c_bp_createdby,
    bp.c_taxgroup_id                 AS c_bp_c_taxgroup_id,
    bp.deliveryrule                  AS c_bp_deliveryrule,
    bp.deliveryviarule               AS c_bp_deliveryviarule,
    bp.description                   AS c_bp_description,
    bp.dunninggrace                  AS c_bp_dunninggrace,
    bp.firstsale                     AS c_bp_firstsale,
    bp.flatdiscount                  AS c_bp_flatdiscount,
    bp.freightcostrule               AS c_bp_freightcostrule,
    bp.invoicerule                   AS c_bp_invoicerule,
    bp.isactive                      AS c_bp_isactive,
    bp.iscustomer                    AS c_bp_iscustomer,
    bp.isdiscountprinted             AS c_bp_isdiscountprinted,
    bp.isemployee                    AS c_bp_isemployee,
    bp.ismanufacturer                AS c_bp_ismanufacturer,
    bp.isonetime                     AS c_bp_isonetime,
    bp.ispotaxexempt                 AS c_bp_ispotaxexempt,
    bp.isprospect                    AS c_bp_isprospect,
    bp.issalesrep                    AS c_bp_issalesrep,
    bp.issummary                     AS c_bp_issummary,
    bp.istaxexempt                   AS c_bp_istaxexempt,
    bp.isvendor                      AS c_bp_isvendor,
    bp.logo_id                       AS c_bp_logo_id,
    bp.m_discountschema_id           AS c_bp_m_discountschema_id,
    bp.m_pricelist_id                AS c_bp_m_pricelist_id,
    bp.numberemployees               AS c_bp_numberemployees,
    bp.paymentrule                   AS c_bp_paymentrule,
    bp.paymentrulepo                 AS c_bp_paymentrulepo,
    bp.po_discountschema_id          AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id             AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id               AS c_bp_po_pricelist_id,
    bp.poreference                   AS c_bp_poreference,
    bp.potentiallifetimevalue        AS c_bp_potentiallifetimevalue,
    bp.rating                        AS c_bp_rating,
    bp.salesrep_id                   AS c_bp_salesrep_id,
    bp.salesvolume                   AS c_bp_salesvolume,
    bp.sendemail                     AS c_bp_sendemail,
    bp.shareofcustomer               AS c_bp_shareofcustomer,
    bp.shelflifeminpct               AS c_bp_shelflifeminpct,
    bp.so_creditlimit                AS c_bp_so_creditlimit,
    bp.socreditstatus                AS c_bp_socreditstatus,
    bp.so_creditused                 AS c_bp_so_creditused,
    bp.so_description                AS c_bp_so_description,
    bp.totalopenbalance              AS c_bp_totalopenbalance,
    bp.updated                       AS c_bp_updated,
    bp.updatedby                     AS c_bp_updatedby,
    bp.url                           AS c_bp_url,
    bpgt.ad_org_id                   AS c_greeting_ad_org_id,
    bpgt.isactive                    AS c_greeting_isactive,
    bpg.isfirstnameonly,
    bpgt.name                        AS c_greeting_name,
    bpl.ad_org_id                    AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id                AS c_bp_location_c_bpartner_id,
    bpl.created                      AS c_bp_location_created,
    bpl.createdby                    AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                          AS c_bp_location_fax,
    bpl.isactive                     AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                         AS c_bp_location_name,
    bpl.phone                        AS c_bp_location_phone,
    bpl.phone2                       AS c_bp_location_phone2,
    bpl.updated                      AS c_bp_location_updated,
    bpl.updatedby                    AS c_bp_location_updatedby,
    l.address1,
    l.address2,
    l.address3,
    l.address4,
    l.ad_org_id                      AS c_location_ad_org_id,
    l.c_city_id,
    l.c_country_id,
    l.city,
    l.created                        AS c_location_created,
    l.createdby                      AS c_location_createdby,
    l.c_region_id,
    l.isactive                       AS c_location_isactive,
    l.regionname,
    l.updated                        AS c_location_updated,
    l.updatedby                      AS c_location_updatedby,
    bpc.ad_org_id                    AS ad_user_ad_org_id,
    bpc.ad_orgtrx_id                 AS ad_user_ad_ad_orgtrx_id,
    bpc.birthday                     AS ad_user_ad_birthday,
    bpc.c_bpartner_id                AS ad_user_c_bpartner_id,
    bpc.c_bpartner_location_id       AS ad_user_c_bpartner_location_id,
    bpc.c_greeting_id                AS ad_user_c_greeting_id,
    bpc.comments                     AS ad_user_comments,
    bpc.created                      AS ad_user_created,
    bpc.createdby                    AS ad_user_createdby,
    bpc.description                  AS ad_user_description,
    bpc.email                        AS ad_user_email,
    bpc.fax                          AS ad_user_fax,
    bpc.isactive                     AS ad_user_isactive,
    bpc.lastcontact                  AS ad_user_lastcontact,
    bpc.lastresult                   AS ad_user_lastresult,
    bpc.phone2                       AS ad_user_phone2,
    bpc.supervisor_id                AS ad_user_supervisor_id,
    bpc.updated                      AS ad_user_updated,
    bpc.updatedby                    AS ad_user_updatedby,
    bpc.value                        AS ad_user_value,
    bpcgt.ad_org_id                  AS c_user_greeting_ad_org_id,
    bpcgt.isactive                   AS c_user_greeting_isactive,
    bpcg.isfirstnameonly             AS c_user_greeting_isfnameonly,
    bpcgt.name                       AS c_user_greeting_name,
    oi.ad_org_id                     AS ad_orginfo_ad_org_id,
    oi.ad_orgtype_id,
    oi.c_calendar_id,
    oi.created                       AS ad_orginfo_created,
    oi.createdby                     AS ad_orginfo_createdby,
    oi.dropship_warehouse_id,
    oi.duns                          AS ad_orginfo_duns,
    oi.email                         AS ad_orginfo_email,
    oi.fax                           AS ad_orginfo_fax,
    oi.isactive                      AS ad_orginfo_isactive,
    oi.m_warehouse_id                AS ad_orginfo_m_warehouse_id,
    oi.parent_org_id,
    oi.phone                         AS ad_orginfo_phone,
    oi.phone2                        AS ad_orginfo_phone2,
    oi.receiptfootermsg,
    oi.supervisor_id,
    oi.updated                       AS ad_orginfo_updated,
    oi.updatedby                     AS ad_orginfo_updatedby,
    wh.ad_org_id                     AS m_warehouse_ad_org_id,
    wh.description                   AS m_warehouse_description,
    wh.isactive                      AS m_warehouse__isactive,
    wh.isdisallownegativeinv,
    wh.isintransit                   AS m_warehouse_isintransit,
    wh.m_warehousesource_id,
    wh.name                          AS m_warehouse_name,
    wh.replenishmentclass,
    wh.separator,
    wh.value                         AS m_warehouse_value 
FROM m_inout io 
        JOIN c_doctype_trl dt 
        ON io.c_doctype_id = dt.c_doctype_id 
        JOIN c_bpartner bp 
        ON io.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN c_greeting bpg 
        ON bp.c_greeting_id = bpg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpgt 
        ON bp.c_greeting_id = bpgt.c_greeting_id AND dt.ad_language = bpgt.ad_language 
        JOIN c_bpartner_location bpl 
        ON io.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location l 
        ON bpl.c_location_id = l.c_location_id 
        LEFT JOIN ad_user bpc 
        ON io.ad_user_id = bpc.ad_user_id 
        LEFT JOIN c_greeting bpcg 
        ON bpc.c_greeting_id = bpcg.c_greeting_id 
        LEFT JOIN c_greeting_trl bpcgt 
        ON bpc.c_greeting_id = bpcgt.c_greeting_id AND dt.ad_language = bpcgt.ad_language 
        JOIN ad_orginfo oi 
        ON io.ad_org_id = oi.ad_org_id 
        JOIN ad_clientinfo ci 
        ON io.ad_client_id = ci.ad_client_id 
        JOIN m_warehouse wh 
        ON io.m_warehouse_id = wh.m_warehouse_id
;

DROP VIEW m_inout_line_v;

CREATE OR REPLACE VIEW m_inout_line_v AS 
SELECT iol.ad_client_id,
    iol.ad_org_id,
    iol.isactive,
    iol.created,
    iol.createdby,
    iol.updated,
    iol.updatedby,
    'en_US'                                                                                      AS ad_language,
    iol.m_inout_id,
    iol.m_inoutline_id,
    iol.line,
    p.m_product_id,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN iol.movementqty ELSE NULL END                                                                                      AS 
    movementqty,
    CASE WHEN iol.qtyentered <> 0 OR iol.m_product_id IS NOT NULL THEN iol.qtyentered ELSE NULL END                                                                                      AS qtyentered,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN uom.uomsymbol ELSE NULL END                                                                                      AS uomsymbol,
    ol.qtyordered,
    ol.qtydelivered,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN ol.qtyordered - ol.qtydelivered ELSE NULL END                                                                                      
    AS qtybackordered,
    COALESCE(p.name || productattribute(iol.m_attributesetinstance_id), c.name, iol.description) AS name,
    CASE WHEN COALESCE(c.name, p.name) IS NOT NULL THEN iol.description ELSE NULL END                                                                                      AS description,
    p.documentnote,
    p.upc,
    p.sku,
    p.value                                                                                      AS productvalue,
    iol.m_locator_id,
    l.m_warehouse_id,
    l.x,
    l.y,
    l.z,
    iol.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.serno,
    asi.lot,
    asi.m_lot_id,
    asi.guaranteedate,
    p.description                                                                                AS productdescription,
    p.imageurl,
    iol.c_campaign_id,
    iol.c_project_id,
    iol.c_activity_id,
    iol.c_projectphase_id,
    iol.c_projecttask_id,
    iol.ad_orgtrx_id,
    iol.c_charge_id,
    iol.confirmedqty,
    iol.c_orderline_id,
    iol.c_uom_id                                                                                 AS m_inoutline_c_uom_id,
    iol.isdescription                                                                            AS m_inoutline_isdescription,
    iol.isinvoiced,
    iol.m_rmaline_id,
    iol.pickedqty,
    iol.processed                                                                                AS m_inoutline_processed,
    iol.ref_inoutline_id,
    iol.reversalline_id,
    iol.scrappedqty,
    iol.targetqty,
    iol.user1_id                                                                                 AS m_inoutline_user1_id,
    iol.user2_id                                                                                 AS m_inoutline_user2_id,
    p.ad_org_id                                                                                  AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                                                                                   AS m_product_copyfrom,
    p.created                                                                                    AS m_product_created,
    p.createdby                                                                                  AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id                                                                           AS m_product_c_taxcategory_id,
    p.c_uom_id                                                                                   AS m_product_c_uom_id,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.isactive                                                                                   AS m_product_isactive,
    p.isbom,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice                                                                              AS m_product_isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                                                                  AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                                                          AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id                                                                  AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                                                                               AS m_product_m_locator_id,
    p.m_product_category_id                                                                      AS m_product_m_prod_category_id,
    p.processing                                                                                 AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                                                                AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id                                                                              AS m_product_s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                                                    AS m_product_updated,
    p.updatedby                                                                                  AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    uom.ad_org_id                                                                                AS c_uom_ad_org_id,
    uom.costingprecision,
    uom.description                                                                              AS c_uom_description,
    uom.isactive                                                                                 AS c_uom_isactive,
    uom.isdefault                                                                                AS c_uom_isdefault,
    uom.name                                                                                     AS c_uom_name,
    uom.stdprecision,
    uom.uomtype,
    uom.x12de355,
    asi.ad_org_id                                                                                AS m_asi_ad_org_id,
    asi.created                                                                                  AS m_asi_created,
    asi.createdby                                                                                AS m_asi_createdby,
    asi.description                                                                              AS m_asi_description,
    asi.isactive                                                                                 AS m_asi_isactive,
    asi.updated                                                                                  AS m_asi_updated,
    asi.updatedby                                                                                AS m_asi_updatedby,
    l.ad_org_id                                                                                  AS m_locator_ad_org_id,
    l.isactive                                                                                   AS m_locator_isactive,
    l.isdefault,
    l.priorityno,
    l.value                                                                                      AS m_locator_value,
    ol.ad_org_id                                                                                 AS c_orderline_ad_org_id,
    ol.ad_orgtrx_id                                                                              AS c_orderline_ad_orgtrx_id,
    ol.c_activity_id                                                                             AS c_orderline_c_activity_id,
    ol.c_bpartner_id                                                                             AS c_orderline_c_bpartner_id,
    ol.c_bpartner_location_id                                                                    AS c_orderline_c_bp_location_id,
    ol.c_charge_id                                                                               AS c_orderline_c_charge_id,
    ol.c_currency_id                                                                             AS c_orderline_c_currency_id,
    ol.c_order_id,
    ol.c_project_id                                                                              AS c_orderline_c_project_id,
    ol.c_projectphase_id                                                                         AS c_orderline_c_projectphase_id,
    ol.c_projecttask_id                                                                          AS c_orderline_c_projecttask_id,
    ol.created                                                                                   AS c_orderline_created,
    ol.createdby                                                                                 AS c_orderline_createdby,
    ol.c_tax_id                                                                                  AS c_orderline_c_tax_id,
    ol.c_uom_id                                                                                  AS c_orderline_c_uom_id,
    ol.datedelivered,
    ol.dateinvoiced,
    ol.dateordered,
    ol.datepromised                                                                              AS c_orderline_datepromised,
    ol.description                                                                               AS c_orderline_description,
    ol.discount,
    ol.freightamt                                                                                AS c_orderline_freightamt,
    ol.isactive                                                                                  AS c_orderline_isactive,
    ol.isdescription                                                                             AS c_orderline_isdescription,
    ol.line                                                                                      AS c_orderline_line,
    ol.linenetamt,
    ol.link_orderline_id,
    ol.m_attributesetinstance_id                                                                 AS c_orderline_m_asi_id,
    ol.m_product_id                                                                              AS c_orderline_m_product_id,
    ol.m_promotion_id,
    ol.m_shipper_id                                                                              AS c_orderline_m_shipper_id,
    ol.m_warehouse_id                                                                            AS c_orderline_warehouse_id,
    ol.priceactual,
    ol.pricecost,
    ol.priceentered,
    ol.pricelimit,
    ol.pricelist,
    ol.processed                                                                                 AS c_orderline_processed,
    ol.qtyentered                                                                                AS c_orderline_qtyentered,
    ol.qtyinvoiced,
    ol.qtylostsales,
    ol.qtyreserved,
    ol.ref_orderline_id,
    ol.rramt,
    ol.rrstartdate,
    ol.s_resourceassignment_id,
    ol.updated                                                                                   AS c_orderline_updated,
    ol.updatedby                                                                                 AS c_orderline_updatedby,
    ol.user1_id                                                                                  AS c_orderline_user1_id,
    ol.user2_id                                                                                  AS c_orderline_user2_id,
    c.ad_org_id                                                                                  AS c_charge_c_org_id,
    c.c_bpartner_id                                                                              AS c_charge_c_bpartner_id,
    c.c_chargetype_id,
    c.chargeamt                                                                                  AS c_charge_chargeamt,
    c.c_taxcategory_id                                                                           AS c_charge_c_taxcategory_id,
    c.description                                                                                AS c_charge_description,
    c.isactive                                                                                   AS c_charge_isactive,
    c.issamecurrency,
    c.issametax,
    c.istaxincluded                                                                              AS c_charge_istaxincluded 
FROM m_inoutline iol 
        JOIN c_uom uom 
        ON iol.c_uom_id = uom.c_uom_id 
        LEFT JOIN m_product p 
        ON iol.m_product_id = p.m_product_id 
        LEFT JOIN m_attributesetinstance asi 
        ON iol.m_attributesetinstance_id = asi.m_attributesetinstance_id 
        LEFT JOIN m_locator l 
        ON iol.m_locator_id = l.m_locator_id 
        LEFT JOIN c_orderline ol 
        ON iol.c_orderline_id = ol.c_orderline_id 
        LEFT JOIN c_charge c 
        ON iol.c_charge_id = c.c_charge_id 
        UNION SELECT iol.ad_client_id,
                iol.ad_org_id,
                iol.isactive,
                iol.created,
                iol.createdby,
                iol.updated,
                iol.updatedby,
                'en_US'                     AS ad_language,
                iol.m_inout_id,
                iol.m_inoutline_id,
                iol.line + bl.line / 100    AS line,
                p.m_product_id,
                CASE WHEN bl.isqtypercentage = 'N' THEN iol.movementqty * bl.qtybom ELSE iol.movementqty * (bl.qtybatch / 100) END                     AS movementqty,
                CASE WHEN bl.isqtypercentage = 'N' THEN iol.qtyentered * bl.qtybom ELSE iol.qtyentered * (bl.qtybatch / 100) END                     AS qtyentered,
                uom.uomsymbol,
                NULL                        AS qtyordered,
                NULL                        AS qtydelivered,
                NULL                        AS qtybackordered,
                p.name,
                b.description,
                p.documentnote,
                p.upc,
                p.sku,
                p.value                     AS productvalue,
                iol.m_locator_id,
                l.m_warehouse_id,
                l.x,
                l.y,
                l.z,
                iol.m_attributesetinstance_id,
                asi.m_attributeset_id,
                asi.serno,
                asi.lot,
                asi.m_lot_id,
                asi.guaranteedate,
                p.description               AS productdescription,
                p.imageurl,
                iol.c_campaign_id,
                iol.c_project_id,
                iol.c_activity_id,
                iol.c_projectphase_id,
                iol.c_projecttask_id,
                iol.ad_orgtrx_id,
                iol.c_charge_id,
                iol.confirmedqty,
                iol.c_orderline_id,
                iol.c_uom_id                AS m_inoutline_c_uom_id,
                iol.isdescription           AS m_inoutline_isdescription,
                iol.isinvoiced,
                iol.m_rmaline_id,
                iol.pickedqty,
                iol.processed               AS m_inoutline_processed,
                iol.ref_inoutline_id,
                iol.reversalline_id,
                iol.scrappedqty,
                iol.targetqty,
                iol.user1_id                AS m_inoutline_user1_id,
                iol.user2_id                AS m_inoutline_user2_id,
                p.ad_org_id                 AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                  AS m_product_copyfrom,
                p.created                   AS m_product_created,
                p.createdby                 AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id          AS m_product_c_taxcategory_id,
                p.c_uom_id                  AS m_product_c_uom_id,
                p.descriptionurl,
                p.discontinued,
                p.discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                p.isactive                  AS m_product_isactive,
                p.isbom,
                p.isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice             AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                 AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id         AS m_product_m_attributeset_id,
                p.m_attributesetinstance_id AS m_product_m_asi_id,
                p.m_freightcategory_id,
                p.m_locator_id              AS m_product_m_locator_id,
                p.m_product_category_id     AS m_product_m_prod_category_id,
                p.processing                AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id               AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id             AS m_product_s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                p.updated                   AS m_product_updated,
                p.updatedby                 AS m_product_updatedby,
                p.versionno,
                p.volume,
                p.weight,
                uom.ad_org_id               AS c_uom_ad_org_id,
                uom.costingprecision,
                uom.description             AS c_uom_description,
                uom.isactive                AS c_uom_isactive,
                uom.isdefault               AS c_uom_isdefault,
                uom.name                    AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                asi.ad_org_id               AS m_asi_ad_org_id,
                asi.created                 AS m_asi_created,
                asi.createdby               AS m_asi_createdby,
                asi.description             AS m_asi_description,
                asi.isactive                AS m_asi_isactive,
                asi.updated                 AS m_asi_updated,
                asi.updatedby               AS m_asi_updatedby,
                l.ad_org_id                 AS m_locator_ad_org_id,
                l.isactive                  AS m_locator_isactive,
                l.isdefault,
                l.priorityno,
                l.value                     AS m_locator_value,
                NULL                        AS c_orderline_ad_org_id,
                NULL                        AS c_orderline_ad_orgtrx_id,
                NULL                        AS c_orderline_c_activity_id,
                NULL                        AS c_orderline_c_bpartner_id,
                NULL                        AS c_orderline_c_bp_location_id,
                NULL                        AS c_orderline_c_charge_id,
                NULL                        AS c_orderline_c_currency_id,
                NULL                        AS c_order_id,
                NULL                        AS c_orderline_c_project_id,
                NULL                        AS c_orderline_c_projectphase_id,
                NULL                        AS c_orderline_c_projecttask_id,
                NULL                        AS c_orderline_created,
                NULL                        AS c_orderline_createdby,
                NULL                        AS c_orderline_c_tax_id,
                NULL                        AS c_orderline_c_uom_id,
                NULL                        AS datedelivered,
                NULL                        AS dateinvoiced,
                NULL                        AS dateordered,
                NULL                        AS c_orderline_datepromised,
                NULL                        AS c_orderline_description,
                NULL                        AS discount,
                NULL                        AS c_orderline_freightamt,
                NULL                        AS c_orderline_isactive,
                NULL                        AS c_orderline_isdescription,
                NULL                        AS c_orderline_line,
                NULL                        AS linenetamt,
                NULL                        AS link_orderline_id,
                NULL                        AS c_orderline_m_asi_id,
                NULL                        AS c_orderline_m_product_id,
                NULL                        AS m_promotion_id,
                NULL                        AS c_orderline_m_shipper_id,
                NULL                        AS c_orderline_warehouse_id,
                NULL                        AS priceactual,
                NULL                        AS pricecost,
                NULL                        AS priceentered,
                NULL                        AS pricelimit,
                NULL                        AS pricelist,
                NULL                        AS c_orderline_processed,
                NULL                        AS c_orderline_qtyentered,
                NULL                        AS qtyinvoiced,
                NULL                        AS qtylostsales,
                NULL                        AS qtyreserved,
                NULL                        AS ref_orderline_id,
                NULL                        AS rramt,
                NULL                        AS rrstartdate,
                NULL                        AS s_resourceassignment_id,
                NULL                        AS c_orderline_updated,
                NULL                        AS c_orderline_updatedby,
                NULL                        AS c_orderline_user1_id,
                NULL                        AS c_orderline_user2_id,
                NULL                        AS c_charge_c_org_id,
                NULL                        AS c_charge_c_bpartner_id,
                NULL                        AS c_chargetype_id,
                NULL                        AS c_charge_chargeamt,
                NULL                        AS c_charge_c_taxcategory_id,
                NULL                        AS c_charge_description,
                NULL                        AS c_charge_isactive,
                NULL                        AS issamecurrency,
                NULL                        AS issametax,
                NULL                        AS c_charge_istaxincluded 
            FROM pp_product_bom b 
                JOIN m_inoutline iol 
                ON b.m_product_id = iol.m_product_id 
                JOIN m_product bp 
                ON bp.m_product_id = iol.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.ispicklistprintdetails = 'Y' 
                JOIN pp_product_bomline bl 
                ON bl.pp_product_bom_id = b.pp_product_bom_id 
                JOIN m_product p 
                ON bl.m_product_id = p.m_product_id 
                JOIN c_uom uom 
                ON p.c_uom_id = uom.c_uom_id 
                LEFT JOIN m_attributesetinstance asi 
                ON iol.m_attributesetinstance_id = asi.m_attributesetinstance_id 
                LEFT JOIN m_locator l 
                ON iol.m_locator_id = l.m_locator_id
;

DROP VIEW m_inout_line_vt;

CREATE OR REPLACE VIEW m_inout_line_vt AS 
SELECT iol.ad_client_id,
    iol.ad_org_id,
    iol.isactive,
    iol.created,
    iol.createdby,
    iol.updated,
    iol.updatedby,
    uomt.ad_language,
    iol.m_inout_id,
    iol.m_inoutline_id,
    iol.line,
    pt.m_product_id,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN iol.movementqty ELSE NULL END                                                                                        AS 
    movementqty,
    CASE WHEN iol.qtyentered <> 0 OR iol.m_product_id IS NOT NULL THEN iol.qtyentered ELSE NULL END                                                                                        AS qtyentered
    ,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN uomt.uomsymbol ELSE NULL END                                                                                        AS uomsymbol
    ,
    ol.qtyordered,
    ol.qtydelivered,
    CASE WHEN iol.movementqty <> 0 OR iol.m_product_id IS NOT NULL THEN ol.qtyordered - ol.qtydelivered ELSE NULL END                                                                                        
    AS qtybackordered,
    COALESCE(pt.name || productattribute(iol.m_attributesetinstance_id), ct.name, iol.description) AS name,
    CASE WHEN COALESCE(ct.name, pt.name) IS NOT NULL THEN iol.description ELSE NULL END                                                                                        AS description,
    pt.documentnote,
    p.upc,
    p.sku,
    p.value                                                                                        AS productvalue,
    iol.m_locator_id,
    l.m_warehouse_id,
    l.x,
    l.y,
    l.z,
    iol.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.serno,
    asi.lot,
    asi.m_lot_id,
    asi.guaranteedate,
    pt.description                                                                                 AS productdescription,
    p.imageurl,
    iol.c_campaign_id,
    iol.c_project_id,
    iol.c_activity_id,
    iol.c_projectphase_id,
    iol.c_projecttask_id,
    iol.ad_orgtrx_id,
    iol.c_charge_id,
    iol.confirmedqty,
    iol.c_orderline_id,
    iol.c_uom_id                                                                                   AS m_inoutline_c_uom_id,
    iol.isdescription                                                                              AS m_inoutline_isdescription,
    iol.isinvoiced,
    iol.m_rmaline_id,
    iol.pickedqty,
    iol.processed                                                                                  AS m_inoutline_processed,
    iol.ref_inoutline_id,
    iol.reversalline_id,
    iol.scrappedqty,
    iol.targetqty,
    iol.user1_id                                                                                   AS m_inoutline_user1_id,
    iol.user2_id                                                                                   AS m_inoutline_user2_id,
    pt.ad_org_id                                                                                   AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                                                                                     AS m_product_copyfrom,
    pt.created                                                                                     AS m_product_created,
    pt.createdby                                                                                   AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id                                                                             AS m_product_c_taxcategory_id,
    p.c_uom_id                                                                                     AS m_product_c_uom_id,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    pt.isactive                                                                                    AS m_product_isactive,
    p.isbom,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice                                                                                AS m_product_isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                                                                    AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                                                            AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id                                                                    AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                                                                                 AS m_product_m_locator_id,
    p.m_product_category_id                                                                        AS m_product_m_prod_category_id,
    p.processing                                                                                   AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                                                                  AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id                                                                                AS m_product_s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                                                      AS m_product_updated,
    p.updatedby                                                                                    AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    uomt.ad_org_id                                                                                 AS c_uom_ad_org_id,
    uom.costingprecision,
    uomt.description                                                                               AS c_uom_description,
    uomt.isactive                                                                                  AS c_uom_isactive,
    uom.isdefault                                                                                  AS c_uom_isdefault,
    uomt.name                                                                                      AS c_uom_name,
    uom.stdprecision,
    uom.uomtype,
    uom.x12de355,
    asi.ad_org_id                                                                                  AS m_asi_ad_org_id,
    asi.created                                                                                    AS m_asi_created,
    asi.createdby                                                                                  AS m_asi_createdby,
    asi.description                                                                                AS m_asi_description,
    asi.isactive                                                                                   AS m_asi_isactive,
    asi.updated                                                                                    AS m_asi_updated,
    asi.updatedby                                                                                  AS m_asi_updatedby,
    l.ad_org_id                                                                                    AS m_locator_ad_org_id,
    l.isactive                                                                                     AS m_locator_isactive,
    l.isdefault,
    l.priorityno,
    l.value                                                                                        AS m_locator_value,
    ol.ad_org_id                                                                                   AS c_orderline_ad_org_id,
    ol.ad_orgtrx_id                                                                                AS c_orderline_ad_orgtrx_id,
    ol.c_activity_id                                                                               AS c_orderline_c_activity_id,
    ol.c_bpartner_id                                                                               AS c_orderline_c_bpartner_id,
    ol.c_bpartner_location_id                                                                      AS c_orderline_c_bp_location_id,
    ol.c_charge_id                                                                                 AS c_orderline_c_charge_id,
    ol.c_currency_id                                                                               AS c_orderline_c_currency_id,
    ol.c_order_id,
    ol.c_project_id                                                                                AS c_orderline_c_project_id,
    ol.c_projectphase_id                                                                           AS c_orderline_c_projectphase_id,
    ol.c_projecttask_id                                                                            AS c_orderline_c_projecttask_id,
    ol.created                                                                                     AS c_orderline_created,
    ol.createdby                                                                                   AS c_orderline_createdby,
    ol.c_tax_id                                                                                    AS c_orderline_c_tax_id,
    ol.c_uom_id                                                                                    AS c_orderline_c_uom_id,
    ol.datedelivered,
    ol.dateinvoiced,
    ol.dateordered,
    ol.datepromised                                                                                AS c_orderline_datepromised,
    ol.description                                                                                 AS c_orderline_description,
    ol.discount,
    ol.freightamt                                                                                  AS c_orderline_freightamt,
    ol.isactive                                                                                    AS c_orderline_isactive,
    ol.isdescription                                                                               AS c_orderline_isdescription,
    ol.line                                                                                        AS c_orderline_line,
    ol.linenetamt,
    ol.link_orderline_id,
    ol.m_attributesetinstance_id                                                                   AS c_orderline_m_asi_id,
    ol.m_product_id                                                                                AS c_orderline_m_product_id,
    ol.m_promotion_id,
    ol.m_shipper_id                                                                                AS c_orderline_m_shipper_id,
    ol.m_warehouse_id                                                                              AS c_orderline_warehouse_id,
    ol.priceactual,
    ol.pricecost,
    ol.priceentered,
    ol.pricelimit,
    ol.pricelist,
    ol.processed                                                                                   AS c_orderline_processed,
    ol.qtyentered                                                                                  AS c_orderline_qtyentered,
    ol.qtyinvoiced,
    ol.qtylostsales,
    ol.qtyreserved,
    ol.ref_orderline_id,
    ol.rramt,
    ol.rrstartdate,
    ol.s_resourceassignment_id,
    ol.updated                                                                                     AS c_orderline_updated,
    ol.updatedby                                                                                   AS c_orderline_updatedby,
    ol.user1_id                                                                                    AS c_orderline_user1_id,
    ol.user2_id                                                                                    AS c_orderline_user2_id,
    ct.ad_org_id                                                                                   AS c_charge_c_org_id,
    c.c_bpartner_id                                                                                AS c_charge_c_bpartner_id,
    c.c_chargetype_id,
    c.chargeamt                                                                                    AS c_charge_chargeamt,
    c.c_taxcategory_id                                                                             AS c_charge_c_taxcategory_id,
    ct.description                                                                                 AS c_charge_description,
    ct.isactive                                                                                    AS c_charge_isactive,
    c.issamecurrency,
    c.issametax,
    c.istaxincluded                                                                                AS c_charge_istaxincluded 
FROM m_inoutline iol 
        JOIN c_uom uom 
        ON iol.c_uom_id = uom.c_uom_id 
        JOIN c_uom_trl uomt 
        ON iol.c_uom_id = uomt.c_uom_id 
        LEFT JOIN m_product p 
        ON iol.m_product_id = p.m_product_id 
        LEFT JOIN m_product_trl pt 
        ON iol.m_product_id = pt.m_product_id AND uomt.ad_language = pt.ad_language 
        LEFT JOIN m_attributesetinstance asi 
        ON iol.m_attributesetinstance_id = asi.m_attributesetinstance_id 
        LEFT JOIN m_locator l 
        ON iol.m_locator_id = l.m_locator_id 
        LEFT JOIN c_orderline ol 
        ON iol.c_orderline_id = ol.c_orderline_id 
        LEFT JOIN c_charge c 
        ON iol.c_charge_id = c.c_charge_id 
        LEFT JOIN c_charge_trl ct 
        ON iol.c_charge_id = ct.c_charge_id 
        UNION SELECT iol.ad_client_id,
                iol.ad_org_id,
                iol.isactive,
                iol.created,
                iol.createdby,
                iol.updated,
                iol.updatedby,
                uomt.ad_language,
                iol.m_inout_id,
                iol.m_inoutline_id,
                iol.line + bl.line / 100    AS line,
                pt.m_product_id,
                CASE WHEN bl.isqtypercentage = 'N' THEN iol.movementqty * bl.qtybom ELSE iol.movementqty * (bl.qtybatch / 100) END                     AS movementqty,
                CASE WHEN bl.isqtypercentage = 'N' THEN iol.qtyentered * bl.qtybom ELSE iol.qtyentered * (bl.qtybatch / 100) END                     AS qtyentered,
                uomt.uomsymbol,
                NULL                        AS qtyordered,
                NULL                        AS qtydelivered,
                NULL                        AS qtybackordered,
                pt.name,
                b.description,
                pt.documentnote,
                p.upc,
                p.sku,
                p.value                     AS productvalue,
                iol.m_locator_id,
                l.m_warehouse_id,
                l.x,
                l.y,
                l.z,
                iol.m_attributesetinstance_id,
                asi.m_attributeset_id,
                asi.serno,
                asi.lot,
                asi.m_lot_id,
                asi.guaranteedate,
                pt.description              AS productdescription,
                p.imageurl,
                iol.c_campaign_id,
                iol.c_project_id,
                iol.c_activity_id,
                iol.c_projectphase_id,
                iol.c_projecttask_id,
                iol.ad_orgtrx_id,
                iol.c_charge_id,
                iol.confirmedqty,
                iol.c_orderline_id,
                iol.c_uom_id                AS m_inoutline_c_uom_id,
                iol.isdescription           AS m_inoutline_isdescription,
                iol.isinvoiced,
                iol.m_rmaline_id,
                iol.pickedqty,
                iol.processed               AS m_inoutline_processed,
                iol.ref_inoutline_id,
                iol.reversalline_id,
                iol.scrappedqty,
                iol.targetqty,
                iol.user1_id                AS m_inoutline_user1_id,
                iol.user2_id                AS m_inoutline_user2_id,
                pt.ad_org_id                AS m_product_ad_org_id,
                p.classification,
                p.copyfrom                  AS m_product_copyfrom,
                pt.created                  AS m_product_created,
                pt.createdby                AS m_product_createdby,
                p.c_revenuerecognition_id,
                p.c_subscriptiontype_id,
                p.c_taxcategory_id          AS m_product_c_taxcategory_id,
                p.c_uom_id                  AS m_product_c_uom_id,
                p.descriptionurl,
                p.discontinued,
                p.discontinuedat,
                p.group1,
                p.group2,
                p.guaranteedays,
                p.guaranteedaysmin,
                p.help,
                pt.isactive                 AS m_product_isactive,
                p.isbom,
                p.isdropship,
                p.isexcludeautodelivery,
                p.isinvoiceprintdetails,
                p.ispicklistprintdetails,
                p.ispurchased,
                p.isselfservice             AS m_product_isselfservice,
                p.issold,
                p.isstocked,
                p.issummary                 AS m_product_issummary,
                p.isverified,
                p.iswebstorefeatured,
                p.lowlevel,
                p.m_attributeset_id         AS m_product_m_attributeset_id,
                p.m_attributesetinstance_id AS m_product_m_asi_id,
                p.m_freightcategory_id,
                p.m_locator_id              AS m_product_m_locator_id,
                p.m_product_category_id     AS m_product_m_prod_category_id,
                p.processing                AS m_product_processing,
                p.producttype,
                p.r_mailtext_id,
                p.salesrep_id               AS m_product_salesrep_id,
                p.s_expensetype_id,
                p.shelfdepth,
                p.shelfheight,
                p.shelfwidth,
                p.s_resource_id             AS m_product_s_resource_id,
                p.unitsperpack,
                p.unitsperpallet,
                pt.updated                  AS m_product_updated,
                pt.updatedby                AS m_product_updatedby,
                p.versionno,
                p.volume,
                p.weight,
                uomt.ad_org_id              AS c_uom_ad_org_id,
                uom.costingprecision,
                uomt.description            AS c_uom_description,
                uomt.isactive               AS c_uom_isactive,
                uom.isdefault               AS c_uom_isdefault,
                uomt.name                   AS c_uom_name,
                uom.stdprecision,
                uom.uomtype,
                uom.x12de355,
                asi.ad_org_id               AS m_asi_ad_org_id,
                asi.created                 AS m_asi_created,
                asi.createdby               AS m_asi_createdby,
                asi.description             AS m_asi_description,
                asi.isactive                AS m_asi_isactive,
                asi.updated                 AS m_asi_updated,
                asi.updatedby               AS m_asi_updatedby,
                l.ad_org_id                 AS m_locator_ad_org_id,
                l.isactive                  AS m_locator_isactive,
                l.isdefault,
                l.priorityno,
                l.value                     AS m_locator_value,
                NULL                        AS c_orderline_ad_org_id,
                NULL                        AS c_orderline_ad_orgtrx_id,
                NULL                        AS c_orderline_c_activity_id,
                NULL                        AS c_orderline_c_bpartner_id,
                NULL                        AS c_orderline_c_bp_location_id,
                NULL                        AS c_orderline_c_charge_id,
                NULL                        AS c_orderline_c_currency_id,
                NULL                        AS c_order_id,
                NULL                        AS c_orderline_c_project_id,
                NULL                        AS c_orderline_c_projectphase_id,
                NULL                        AS c_orderline_c_projecttask_id,
                NULL                        AS c_orderline_created,
                NULL                        AS c_orderline_createdby,
                NULL                        AS c_orderline_c_tax_id,
                NULL                        AS c_orderline_c_uom_id,
                NULL                        AS datedelivered,
                NULL                        AS dateinvoiced,
                NULL                        AS dateordered,
                NULL                        AS c_orderline_datepromised,
                NULL                        AS c_orderline_description,
                NULL                        AS discount,
                NULL                        AS c_orderline_freightamt,
                NULL                        AS c_orderline_isactive,
                NULL                        AS c_orderline_isdescription,
                NULL                        AS c_orderline_line,
                NULL                        AS linenetamt,
                NULL                        AS link_orderline_id,
                NULL                        AS c_orderline_m_asi_id,
                NULL                        AS c_orderline_m_product_id,
                NULL                        AS m_promotion_id,
                NULL                        AS c_orderline_m_shipper_id,
                NULL                        AS c_orderline_warehouse_id,
                NULL                        AS priceactual,
                NULL                        AS pricecost,
                NULL                        AS priceentered,
                NULL                        AS pricelimit,
                NULL                        AS pricelist,
                NULL                        AS c_orderline_processed,
                NULL                        AS c_orderline_qtyentered,
                NULL                        AS qtyinvoiced,
                NULL                        AS qtylostsales,
                NULL                        AS qtyreserved,
                NULL                        AS ref_orderline_id,
                NULL                        AS rramt,
                NULL                        AS rrstartdate,
                NULL                        AS s_resourceassignment_id,
                NULL                        AS c_orderline_updated,
                NULL                        AS c_orderline_updatedby,
                NULL                        AS c_orderline_user1_id,
                NULL                        AS c_orderline_user2_id,
                NULL                        AS c_charge_c_org_id,
                NULL                        AS c_charge_c_bpartner_id,
                NULL                        AS c_chargetype_id,
                NULL                        AS c_charge_chargeamt,
                NULL                        AS c_charge_c_taxcategory_id,
                NULL                        AS c_charge_description,
                NULL                        AS c_charge_isactive,
                NULL                        AS issamecurrency,
                NULL                        AS issametax,
                NULL                        AS c_charge_istaxincluded 
            FROM pp_product_bom b 
                JOIN m_inoutline iol 
                ON b.m_product_id = iol.m_product_id 
                JOIN m_product bp 
                ON bp.m_product_id = iol.m_product_id AND bp.isbom = 'Y' AND bp.isverified = 'Y' AND bp.ispicklistprintdetails = 'Y' 
                JOIN pp_product_bomline bl 
                ON bl.pp_product_bom_id = b.pp_product_bom_id 
                JOIN m_product p 
                ON bl.m_product_id = p.m_product_id 
                JOIN c_uom uom 
                ON iol.c_uom_id = uom.c_uom_id 
                JOIN c_uom_trl uomt 
                ON p.c_uom_id = uomt.c_uom_id 
                JOIN m_product_trl pt 
                ON bl.m_product_id = pt.m_product_id AND uomt.ad_language = pt.ad_language 
                LEFT JOIN m_attributesetinstance asi 
                ON iol.m_attributesetinstance_id = asi.m_attributesetinstance_id 
                LEFT JOIN m_locator l 
                ON iol.m_locator_id = l.m_locator_id
;

DROP VIEW rv_allocation;

CREATE OR REPLACE VIEW rv_allocation AS 
SELECT h.c_allocationhdr_id,
    h.ad_client_id,
    h.ad_org_id,
    h.isactive,
    h.created,
    h.createdby,
    h.updated,
    h.updatedby,
    h.documentno,
    h.description,
    h.datetrx,
    h.dateacct,
    h.c_currency_id,
    h.approvalamt,
    h.ismanual,
    h.docstatus,
    h.docaction,
    h.processed,
    l.c_allocationline_id,
    l.c_invoice_id,
    l.c_bpartner_id,
    l.c_order_id,
    l.c_payment_id,
    l.c_cashline_id,
    l.amount,
    l.discountamt,
    l.writeoffamt,
    l.overunderamt,
    h.isapproved,
    h.posted,
    l.ad_org_id AS c_allocationline_ad_org_id,
    l.created   AS c_allocationline_created,
    l.createdby AS c_allocationline_createdby,
    l.datetrx   AS c_allocationline_datetrx,
    l.isactive  AS c_allocationline_isactive,
    l.ismanual  AS c_allocationline_ismanual,
    l.updated   AS c_allocationline_updated,
    l.updatedby AS c_allocationline_updatedby 
FROM c_allocationhdr h 
        JOIN c_allocationline l 
        ON h.c_allocationhdr_id = l.c_allocationhdr_id
;

DROP VIEW rv_bpartner;

CREATE OR REPLACE VIEW rv_bpartner AS 
SELECT bp.ad_client_id,
    bp.ad_org_id,
    bp.isactive,
    bp.created,
    bp.createdby,
    bp.updated,
    bp.updatedby,
    bp.c_bpartner_id,
    bp.value,
    bp.name,
    bp.name2,
    bp.description,
    bp.issummary,
    bp.c_bp_group_id,
    bp.isonetime,
    bp.isprospect,
    bp.isvendor,
    bp.iscustomer,
    bp.isemployee,
    bp.issalesrep,
    bp.referenceno,
    bp.duns,
    bp.url,
    bp.ad_language,
    bp.taxid,
    bp.istaxexempt,
    bp.c_invoiceschedule_id,
    bp.rating,
    bp.salesvolume,
    bp.numberemployees,
    bp.naics,
    bp.firstsale,
    bp.acqusitioncost,
    bp.potentiallifetimevalue,
    bp.actuallifetimevalue,
    bp.shareofcustomer,
    bp.paymentrule,
    bp.so_creditlimit,
    bp.so_creditused,
    bp.so_creditused - bp.so_creditlimit AS so_creditavailable,
    bp.c_paymentterm_id,
    bp.m_pricelist_id,
    bp.m_discountschema_id,
    bp.c_dunning_id,
    bp.isdiscountprinted,
    bp.so_description,
    bp.poreference,
    bp.paymentrulepo,
    bp.po_pricelist_id,
    bp.po_discountschema_id,
    bp.po_paymentterm_id,
    bp.documentcopies,
    bp.c_greeting_id,
    bp.invoicerule,
    bp.deliveryrule,
    bp.freightcostrule,
    bp.deliveryviarule,
    bp.salesrep_id,
    bp.sendemail,
    bp.bpartner_parent_id,
    bp.invoice_printformat_id,
    bp.socreditstatus,
    bp.shelflifeminpct,
    bp.ad_orgbp_id,
    bp.flatdiscount,
    bp.totalopenbalance,
    c.ad_user_id,
    c.name                               AS contactname,
    c.description                        AS contactdescription,
    c.email,
    c.supervisor_id,
    c.emailuser,
    c.c_greeting_id                      AS bpcontactgreeting,
    c.title,
    c.comments,
    c.phone,
    c.phone2,
    c.fax,
    c.lastcontact,
    c.lastresult,
    c.birthday,
    c.ad_orgtrx_id,
    c.emailverify,
    c.ldapuser,
    c.emailverifydate,
    c.notificationtype,
    l.c_bpartner_location_id,
    a.postal,
    a.city,
    a.address1,
    a.address2,
    a.address3,
    a.c_region_id,
    COALESCE(r.name, a.regionname)       AS regionname,
    a.c_country_id,
    cc.name                              AS countryname,
    bp.c_taxgroup_id                     AS c_bp_c_taxgroup_id,
    bp.dunninggrace                      AS c_bp_dunninggrace,
    bp.ismanufacturer                    AS c_bp_ismanufacturer,
    bp.ispotaxexempt                     AS c_bp_ispotaxexempt,
    bp.logo_id                           AS c_bp_logo_id,
    l.ad_org_id                          AS c_bp_location_ad_org_id,
    l.c_bpartner_id                      AS c_bp_location_c_bpartner_id,
    l.c_location_id                      AS c_bp_location_c_location_id,
    l.created                            AS c_bp_location_created,
    l.createdby                          AS c_bp_location_createdby,
    l.c_salesregion_id                   AS c_bp_location_salesregion_id,
    l.fax                                AS c_bp_location_fax,
    l.isactive                           AS c_bp_location_isactive,
    l.isbillto                           AS c_bp_location_isbillto,
    l.isdn                               AS c_bp_location_isdn,
    l.ispayfrom                          AS c_bp_location_ispayfrom,
    l.isremitto                          AS c_bp_location_isremitto,
    l.isshipto                           AS c_bp_location_isshipto,
    l.name                               AS c_bp_location_name,
    l.phone                              AS c_bp_location_phone,
    l.phone2                             AS c_bp_location_phone2,
    l.updated                            AS c_bp_location_updated,
    l.updatedby                          AS c_bp_location_updatedby,
    c.ad_org_id                          AS ad_user_ad_org_id,
    c.c_bpartner_id                      AS ad_user_c_bpartner_id,
    c.c_bpartner_location_id             AS ad_user_c_bpartner_location_id,
    c.created                            AS ad_user_created,
    c.createdby                          AS ad_user_createdby,
    c.isactive                           AS ad_user_isactive,
    c.updated                            AS ad_user_updated,
    c.updatedby                          AS ad_user_updatedby,
    c.value                              AS ad_user_value,
    a.address4,
    a.ad_org_id                          AS c_location_ad_org_id,
    a.c_city_id,
    a.c_location_id,
    a.created                            AS c_location_created,
    a.createdby                          AS c_location_createdby,
    a.isactive                           AS c_location_isactive,
    a.postal_add,
    a.updated                            AS c_location_updated,
    a.updatedby                          AS c_location_updatedby,
    r.ad_org_id                          AS c_region_ad_org_id,
    r.c_country_id                       AS c_region_c_country_id,
    r.description                        AS c_region_description,
    r.isactive                           AS c_region_isactive,
    r.isdefault,
    cc.ad_language                       AS c_country_ad_language,
    cc.c_currency_id                     AS c_country_c_currency_id,
    cc.countrycode,
    cc.description                       AS c_country_description,
    cc.isactive                          AS c_country_isactive 
FROM c_bpartner bp 
        LEFT JOIN c_bpartner_location l 
        ON bp.c_bpartner_id = l.c_bpartner_id AND l.isactive = 'Y' 
        LEFT JOIN ad_user c 
        ON bp.c_bpartner_id = c.c_bpartner_id AND (c.c_bpartner_location_id IS NULL OR c.c_bpartner_location_id = l.c_bpartner_location_id) AND c.isactive = 'Y' 
        LEFT JOIN c_location a 
        ON l.c_location_id = a.c_location_id 
        LEFT JOIN c_region r 
        ON a.c_region_id = r.c_region_id 
        JOIN c_country cc 
        ON a.c_country_id = cc.c_country_id
;

DROP VIEW rv_bpartneropen;

CREATE OR REPLACE VIEW rv_bpartneropen AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.c_bpartner_id,
    i.c_currency_id,
    i.grandtotal * i.multiplierap                                                                                    AS amt,
    invoiceopen(i.c_invoice_id, i.c_invoicepayschedule_id) * i.multiplierap                                          AS openamt,
    i.dateinvoiced                                                                                                   AS datedoc,
    COALESCE(daysbetween(getdate(), ips.duedate), paymenttermduedays(i.c_paymentterm_id, i.dateinvoiced, getdate())) AS daysdue,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ad_orgtrx_id,
    i.c_charge_id,
    i.c_conversiontype_id,
    i.c_doctype_id,
    i.chargeamt,
    i.c_invoice_id,
    i.c_order_id,
    i.c_payment_id,
    i.dateacct,
    i.description,
    i.docstatus,
    i.documentno,
    i.isapproved,
    i.isselfservice,
    i.posted,
    i.processedon,
    i.reversal_id 
FROM c_invoice_v i 
        LEFT JOIN c_invoicepayschedule ips 
        ON i.c_invoicepayschedule_id = ips.c_invoicepayschedule_id 
WHERE i.ispaid = 'N' AND i.docstatus IN ('CO',
    'CL') 
UNION 
SELECT p.ad_client_id,
    p.ad_org_id,
    p.isactive,
    p.created,
    p.createdby,
    p.updated,
    p.updatedby,
    p.c_bpartner_id,
    p.c_currency_id,
    p.payamt * p.multiplierap * (-1)                         AS amt,
    paymentavailable(p.c_payment_id) * p.multiplierap * (-1) AS openamt,
    p.datetrx                                                AS datedoc,
    NULL                                                     AS daysdue,
    p.c_campaign_id,
    p.c_project_id,
    p.c_activity_id,
    p.ad_orgtrx_id,
    p.c_charge_id,
    p.c_conversiontype_id,
    p.c_doctype_id,
    p.chargeamt,
    p.c_invoice_id,
    p.c_order_id,
    p.c_payment_id,
    p.dateacct,
    p.description,
    p.docstatus,
    p.documentno,
    p.isapproved,
    p.isselfservice,
    p.posted,
    p.processedon,
    p.reversal_id 
FROM c_payment_v p 
WHERE p.isallocated = 'N' AND p.c_bpartner_id IS NOT NULL AND p.docstatus IN ('CO',
    'CL')
;

DROP VIEW rv_commissionrundetail;

CREATE OR REPLACE VIEW rv_commissionrundetail AS 
SELECT cr.ad_client_id,
    cr.ad_org_id,
    cr.isactive,
    cr.created,
    cr.createdby,
    cr.updated,
    cr.updatedby,
    cr.c_commissionrun_id,
    cr.documentno,
    cr.description,
    cr.startdate,
    cr.grandtotal,
    cr.processed,
    c.c_commission_id,
    c.c_bpartner_id                                              AS commission_bpartner_id,
    ca.c_commissionamt_id,
    ca.convertedamt                                              AS commissionconvertedamt,
    ca.actualqty                                                 AS commissionqty,
    ca.commissionamt,
    cd.c_commissiondetail_id,
    cd.reference,
    cd.c_orderline_id,
    cd.c_invoiceline_id,
    cd.info,
    cd.c_currency_id,
    cd.actualamt,
    cd.convertedamt,
    cd.actualqty,
    i.documentno                                                 AS invoicedocumentno,
    COALESCE(i.dateinvoiced, o.dateordered)                      AS datedoc,
    COALESCE(il.m_product_id, ol.m_product_id)                   AS m_product_id,
    COALESCE(i.c_bpartner_id, o.c_bpartner_id)                   AS c_bpartner_id,
    COALESCE(i.c_bpartner_location_id, o.c_bpartner_location_id) AS c_bpartner_location_id,
    COALESCE(i.ad_user_id, o.ad_user_id)                         AS ad_user_id,
    COALESCE(i.c_doctype_id, o.c_doctype_id)                     AS c_doctype_id,
    cr.processing                                                AS c_commisionrun_processing,
    c.ad_org_id                                                  AS c_commission_ad_org_id,
    c.c_currency_id                                              AS c_commission_c_currency_id,
    c.created                                                    AS c_commission_created,
    c.createdby                                                  AS c_commission_createdby,
    c.createfrom,
    c.datelastrun,
    c.description                                                AS c_commission_description,
    c.docbasistype,
    c.frequencytype,
    c.isactive                                                   AS c_commission_isactive,
    c.listdetails,
    c.name                                                       AS c_commission_name,
    c.updated                                                    AS c_commission_updated,
    c.updatedby                                                  AS c_commission_updatedby,
    ca.ad_org_id                                                 AS c_commissionamt_ad_org_id,
    ca.c_commissionline_id,
    ca.created                                                   AS c_commmissionamt_created,
    ca.createdby                                                 AS c_commmissionamt_createdby,
    ca.isactive                                                  AS c_commmissionamt_isactive,
    ca.updated                                                   AS c_commmissionamt_updated,
    ca.updatedby                                                 AS c_commssionamt_updatedby,
    cd.ad_org_id                                                 AS c_commissiondetail_ad_org_id,
    cd.created                                                   AS c_commissiondetail_created,
    cd.createdby                                                 AS c_commissiondetail_createdby,
    cd.isactive                                                  AS c_commossiondetail_isactive,
    cd.updated                                                   AS c_commissiondetail_updated,
    cd.updatedby                                                 AS c_commissiondetail_updatedby,
    ol.ad_org_id                                                 AS c_orderline_ad_org_id,
    ol.ad_orgtrx_id                                              AS c_orderline_ad_orgtrx_id,
    ol.c_activity_id                                             AS c_orderline_c_activity_id,
    ol.c_bpartner_id                                             AS c_orderline_c_bpartner_id,
    ol.c_bpartner_location_id                                    AS c_orderline_c_bp_location_id,
    ol.c_campaign_id                                             AS c_orderline_c_campaign_id,
    ol.c_charge_id                                               AS c_orderline_c_charge_id,
    ol.c_currency_id                                             AS c_orderline_c_currency_id,
    ol.c_order_id                                                AS c_orderline_c_order_id,
    ol.c_project_id                                              AS c_orderline_c_project_id,
    ol.c_projectphase_id                                         AS c_orderline_c_projectphase_id,
    ol.c_projecttask_id                                          AS c_orderline_c_projecttask_id,
    ol.created                                                   AS c_orderline_created,
    ol.createdby                                                 AS c_orderline_createdby,
    ol.c_tax_id                                                  AS c_orderline_c_tax_id,
    ol.c_uom_id                                                  AS c_orderline_c_uom_id,
    ol.datedelivered,
    ol.dateinvoiced,
    ol.dateordered,
    ol.datepromised,
    ol.description                                               AS c_orderline_description,
    ol.discount,
    ol.freightamt,
    ol.isactive                                                  AS c_orderline_isactive,
    ol.isdescription,
    ol.line                                                      AS c_orderline_line,
    ol.linenetamt                                                AS c_orderline_linenetamt,
    ol.link_orderline_id,
    ol.m_attributesetinstance_id                                 AS c_orderline_m_asi_id,
    ol.m_promotion_id,
    ol.m_shipper_id                                              AS c_orderline_m_shipper_id,
    ol.m_warehouse_id                                            AS c_orderline_m_warehouse_id,
    ol.priceactual                                               AS c_orderline_priceactual,
    ol.pricecost,
    ol.priceentered                                              AS c_orderline_priceentered,
    ol.pricelist                                                 AS c_orderline_pricelist,
    ol.processed                                                 AS c_orderline_processed,
    ol.qtydelivered,
    ol.qtyentered,
    ol.qtyinvoiced                                               AS c_orderline_qtyinvoiced,
    ol.qtylostsales,
    ol.qtyordered,
    ol.qtyreserved,
    ol.ref_orderline_id                                          AS c_orderline_ref_orderline_id,
    ol.rramt                                                     AS c_orderline_rramt,
    ol.rrstartdate                                               AS c_orderline_rrstartsate,
    ol.s_resourceassignment_id                                   AS c_orderline_s_rassignment_id,
    ol.updated                                                   AS c_orderline_updated,
    ol.updatedby                                                 AS c_orderline_updatedby,
    ol.user1_id                                                  AS c_orderline_user1_id,
    ol.user2_id                                                  AS c_orderline_user2_id,
    il.ad_org_id                                                 AS c_inviceline_ad_org_id,
    il.ad_orgtrx_id                                              AS c_invoiceline_ad_orgtrx_id,
    il.a_processed,
    il.c_activity_id                                             AS c_invoiceline_c_activity_id,
    il.c_campaign_id                                             AS c_invoiceline_c_campaign_id,
    il.c_charge_id                                               AS c_invoiceline_c_charge_id,
    il.c_invoice_id,
    il.c_orderline_id                                            AS c_invoiceline_c_orderline_id,
    il.c_project_id                                              AS c_invoiceline_c_project_id,
    il.c_projectphase_id                                         AS c_invoiceline_c_projphase_id,
    il.c_projecttask_id                                          AS c_invoiceline_c_projecttask_id,
    il.created                                                   AS c_invoiceline_created,
    il.createdby                                                 AS c_invoiceline_createdby,
    il.c_tax_id                                                  AS c_invoiceline_c_tax_id,
    il.c_uom_id                                                  AS c_invoiceline_c_uom_id,
    il.description                                               AS c_invoiceline_description,
    il.isactive                                                  AS c_invoiceline_isactive,
    il.isdescription                                             AS c_invoiceline_isdescription,
    il.isprinted,
    il.line                                                      AS c_invoiceline_line,
    il.linenetamt                                                AS c_invoiceline_linenetamt,
    il.linetotalamt                                              AS c_invoiceline_linetotalamt,
    il.m_attributesetinstance_id                                 AS c_invoiceline_m_asi_id,
    il.m_inoutline_id,
    il.m_rmaline_id                                              AS c_invoiceline_m_rmaline_id,
    il.priceactual                                               AS c_invoiceline_priceactual,
    il.priceentered                                              AS c_invoiceline_priceentered,
    il.pricelimit                                                AS c_invoiceline_pricelimit,
    il.pricelist                                                 AS c_invoiceline_pricelist,
    il.processed                                                 AS c_invoiceline_processed,
    il.qtyentered                                                AS c_invoiceline_qtyentered,
    il.qtyinvoiced                                               AS c_invoiceline_qtyinvoiced,
    il.ref_invoiceline_id                                        AS c_invoiceline_ref_invline_id,
    il.rramt                                                     AS c_invoiceline_rramt,
    il.rrstartdate                                               AS c_invoiceline_rrstartdate,
    il.s_resourceassignment_id                                   AS c_invoiceline_s_rassignment_id,
    il.taxamt                                                    AS c_invoiceline_taxamt,
    il.updated                                                   AS c_invoiceline_updated,
    il.updatedby                                                 AS c_invoiceline_updatedby,
    il.user1_id                                                  AS c_invoiceline_user1_id,
    il.user2_id                                                  AS c_invoiceline_user2_id,
    o.ad_org_id                                                  AS c_order_ad_org_id,
    o.ad_orgtrx_id                                               AS c_order_ad_orgtrx_id,
    o.ad_user_id                                                 AS c_order_ad_user_id,
    o.amountrefunded,
    o.amounttendered,
    o.bill_bpartner_id,
    o.bill_location_id,
    o.bill_user_id,
    o.c_activity_id,
    o.c_campaign_id                                              AS c_order_c_campaign_id,
    o.c_cashline_id,
    o.c_cashplanline_id,
    o.c_charge_id,
    o.c_conversiontype_id,
    o.c_currency_id                                              AS c_order_c_currency_id,
    o.c_doctypetarget_id,
    o.chargeamt                                                  AS c_order_chargeamt,
    o.copyfrom                                                   AS c_order_copyfrom,
    o.c_order_id                                                 AS c_order_c_order_id,
    o.c_payment_id                                               AS c_order_c_payment_id,
    o.c_paymentterm_id                                           AS c_order_paymentterm_id,
    o.c_pos_id,
    o.c_project_id                                               AS c_order_c_project_id,
    o.created                                                    AS c_order_created,
    o.createdby                                                  AS c_order_createdby,
    o.dateacct                                                   AS c_order_dateacct,
    o.dateprinted                                                AS c_order_dateprinted,
    o.datepromised                                               AS c_order_datepromised,
    o.deliveryrule                                               AS c_order_deliveryrule,
    o.deliveryviarule                                            AS c_order_deliveryviarule,
    o.description                                                AS c_order_description,
    o.docaction                                                  AS c_order_docaction,
    o.docstatus                                                  AS c_order_docstatus,
    o.documentno                                                 AS c_order_documentno,
    o.dropship_bpartner_id,
    o.dropship_location_id,
    o.dropship_user_id,
    o.freightamt                                                 AS c_order_freightamt,
    o.freightcostrule                                            AS c_order_freightcostrule,
    o.grandtotal                                                 AS c_order_grandtotal,
    o.invoicerule,
    o.isactive                                                   AS c_order_isactive,
    o.isapproved,
    o.iscreditapproved,
    o.isdelivered,
    o.isdiscountprinted,
    o.isdropship,
    o.isinvoiced,
    o.ispayschedulevalid,
    o.isprinted                                                  AS c_order_isprinted,
    o.isselected                                                 AS c_order_isselected,
    o.isselfservice                                              AS c_order_isselfservice,
    o.issotrx                                                    AS c_order_issotrx,
    o.istaxincluded                                              AS c_order_istaxincluded,
    o.istransferred,
    o.link_order_id,
    o.m_freightcategory_id,
    o.m_pricelist_id,
    o.m_shipper_id                                               AS c_order_m_shipper_id,
    o.m_warehouse_id                                             AS c_order_m_warehouse_id,
    o.ordertype,
    o.pay_bpartner_id,
    o.pay_location_id,
    o.paymentrule,
    o.poreference,
    o.posted                                                     AS c_order_posted,
    o.priorityrule,
    o.processed                                                  AS c_order_processed,
    o.processedon                                                AS c_order_processedon,
    o.promotioncode,
    o.ref_order_id                                               AS c_order_ref_order_id,
    o.sendemail                                                  AS c_order_sendemail,
    o.totallines                                                 AS c_order_totallines,
    o.user1_id                                                   AS c_order_user1_id,
    o.user2_id                                                   AS c_order_user2_id,
    i.ad_org_id                                                  AS c_invoice_ad_org_id,
    i.ad_orgtrx_id                                               AS c_invoice_ad_orgtrx_id,
    i.c_activity_id                                              AS c_invoice_c_activity_id,
    i.c_campaign_id                                              AS c_invoice_c_campaign_id,
    i.c_charge_id                                                AS c_invoice_c_charge_id,
    i.c_conversiontype_id                                        AS c_invoice_c_conversiontype_id,
    i.c_currency_id                                              AS c_invoice_c_currency_id,
    i.c_doctypetarget_id                                         AS c_invoice_c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt                                                  AS c_invoice_chargeamt,
    i.c_invoice_id                                               AS c_invoice_c_invoice_id,
    i.c_order_id                                                 AS c_invoice_c_order_id,
    i.c_payment_id                                               AS c_invoice_c_payment_id,
    i.c_paymentterm_id                                           AS c_invoice_c_paymentterm_id,
    i.c_project_id                                               AS c_invoice_c_project_id,
    i.created                                                    AS c_invoice_created,
    i.createdby                                                  AS c_invoice_createdby,
    i.dateacct                                                   AS c_invoice_dateacct,
    i.dateordered                                                AS c_invoice_dateordered,
    i.dateprinted                                                AS c_invoice_dateprinted,
    i.description                                                AS c_invoice_description,
    i.docaction                                                  AS c_invoice_docaction,
    i.docstatus                                                  AS c_invoice_docstatus,
    i.dunninggrace                                               AS c_invoice_dunninggrace,
    i.generateto,
    i.grandtotal                                                 AS c_invoice_grandtotal,
    i.invoicecollectiontype,
    i.isactive                                                   AS c_invoice_isactive,
    i.isapproved                                                 AS c_invoice_isapproved,
    i.isdiscountprinted                                          AS c_invoice_isdiscountprinted,
    i.isindispute                                                AS c_invoice_isindispute,
    i.ispayschedulevalid                                         AS c_invoice_ispayschedulevalid,
    i.isprinted                                                  AS c_invoice_isprinted,
    i.isselfservice                                              AS c_invoice_isselfservice,
    i.issotrx                                                    AS c_invoice_issotrx,
    i.istaxincluded                                              AS c_invoice_istaxincluded,
    i.istransferred                                              AS c_invoice_istransferred,
    i.m_pricelist_id                                             AS c_invoice_m_pricelist_id,
    i.m_rma_id                                                   AS c_invoice_m_rma_id,
    i.paymentrule                                                AS c_invoice_paymentrule,
    i.poreference                                                AS c_invoice_poreference,
    i.posted                                                     AS c_invoice_posted,
    i.processedon                                                AS c_invoice_processedon,
    i.processing                                                 AS c_invoice_processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.salesrep_id                                                AS c_invoice_salesrep_id,
    i.sendemail                                                  AS c_invoice_sendemail,
    i.totallines                                                 AS c_invoice_totallines,
    i.updated                                                    AS c_invoice_updated,
    i.updatedby                                                  AS c_invoice_updatedby,
    i.user1_id                                                   AS c_invoice_user1_id,
    i.user2_id                                                   AS c_invoice_user2_id 
FROM c_commissionrun cr 
        JOIN c_commission c 
        ON cr.c_commission_id = c.c_commission_id 
        JOIN c_commissionamt ca 
        ON cr.c_commissionrun_id = ca.c_commissionrun_id 
        JOIN c_commissiondetail cd 
        ON ca.c_commissionamt_id = cd.c_commissionamt_id 
        LEFT JOIN c_orderline ol 
        ON cd.c_orderline_id = ol.c_orderline_id 
        LEFT JOIN c_invoiceline il 
        ON cd.c_invoiceline_id = il.c_invoiceline_id 
        LEFT JOIN c_order o 
        ON ol.c_order_id = o.c_order_id 
        LEFT JOIN c_invoice i 
        ON il.c_invoice_id = i.c_invoice_id
;

DROP VIEW rv_cost;

CREATE OR REPLACE VIEW rv_cost AS 
SELECT c.ad_client_id,
    c.ad_org_id,
    c.isactive,
    c.created,
    c.createdby,
    c.updated,
    c.updatedby,
    p.m_product_id,
    p.value,
    p.name,
    p.upc,
    p.isbom,
    p.producttype,
    p.m_product_category_id,
    c.m_costtype_id,
    ce.m_costelement_id,
    ce.costelementtype,
    ce.costingmethod,
    ce.iscalculated,
    acct.c_acctschema_id,
    acct.c_currency_id,
    c.currentcostprice,
    c.futurecostprice,
    c.description,
    c.currentcostpricell,
    c.futurecostpricell,
    c.iscostfrozen,
    c.cumulatedamt,
    c.cumulatedqty,
    c.currentqty,
    c.m_attributesetinstance_id,
    c.percent,
    p.ad_org_id                 AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                  AS m_product_copyfrom,
    p.created                   AS m_product_created,
    p.createdby                 AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id,
    p.description               AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                  AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                 AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id         AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id AS m_product_m_attributesetinsta,
    p.m_freightcategory_id,
    p.m_locator_id,
    p.processing                AS m_product_processing,
    p.r_mailtext_id,
    p.salesrep_id               AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.sku,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                   AS m_product_updated,
    p.updatedby                 AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    ce.ad_org_id                AS m_costelement_ad_org_id,
    ce.description              AS m_costelement_description,
    ce.isactive                 AS m_costelement_isactive,
    ce.name                     AS m_costelement_name,
    acct.ad_org_id              AS c_acctschema_ad_org_id,
    acct.description            AS c_acctschema_description,
    acct.name                   AS c_acctschema_name 
FROM m_cost c 
        JOIN m_product p 
        ON c.m_product_id = p.m_product_id 
        JOIN m_costelement ce 
        ON c.m_costelement_id = ce.m_costelement_id 
        JOIN c_acctschema acct 
        ON c.c_acctschema_id = acct.c_acctschema_id
;

DROP VIEW rv_costdetail;

CREATE OR REPLACE VIEW rv_costdetail AS 
SELECT c.ad_client_id,
    c.ad_org_id,
    c.isactive,
    c.created,
    c.createdby,
    c.updated,
    c.updatedby,
    p.m_product_id,
    p.value,
    p.name,
    p.upc,
    p.isbom,
    p.producttype,
    p.m_product_category_id,
    c.m_inoutline_id,
    c.c_invoiceline_id,
    asi.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.lot,
    asi.serno,
    acct.c_acctschema_id,
    acct.c_currency_id,
    c.amt,
    c.qty,
    c.description,
    c.processed,
    c.c_orderline_id,
    c.c_projectissue_id,
    c.cumulatedamt,
    c.cumulatedqty,
    c.currentcostprice,
    c.currentqty,
    c.deltaamt,
    c.deltaqty,
    c.issotrx,
    c.m_costdetail_id,
    c.m_costelement_id,
    c.m_inventoryline_id,
    c.m_movementline_id,
    c.m_productionline_id,
    c.pp_cost_collector_id,
    p.ad_org_id                 AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                  AS m_product_copyfrom,
    p.created                   AS m_product_created,
    p.createdby                 AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id,
    p.description               AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                  AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                 AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id         AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id,
    p.processing                AS m_product_processing,
    p.r_mailtext_id,
    p.salesrep_id               AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.sku,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                   AS m_product_updated,
    p.updatedby                 AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    acct.ad_org_id              AS c_acctschema_ad_org_id,
    acct.description            AS c_acctschema_description,
    acct.name                   AS c_acctschema_name,
    asi.ad_org_id               AS m_asi_ad_org_id,
    asi.created                 AS m_asi_created,
    asi.createdby               AS m_asi_createdby,
    asi.description             AS m_asi_description,
    asi.guaranteedate,
    asi.isactive                AS m_asi_isactive,
    asi.m_lot_id,
    asi.updated                 AS m_asi_updated,
    asi.updatedby               AS m_asi_updatedby 
FROM m_costdetail c 
        JOIN m_product p 
        ON c.m_product_id = p.m_product_id 
        JOIN c_acctschema acct 
        ON c.c_acctschema_id = acct.c_acctschema_id 
        JOIN m_attributesetinstance asi 
        ON c.m_attributesetinstance_id = asi.m_attributesetinstance_id
;

CREATE OR REPLACE VIEW rv_c_invoice AS 
SELECT i.c_invoice_id,
    i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.docaction,
    i.isprinted,
    i.isdiscountprinted,
    i.processing,
    i.processed,
    i.istransferred,
    i.ispaid,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_order_id,
    i.description,
    i.isapproved,
    i.salesrep_id,
    i.dateinvoiced,
    i.dateprinted,
    i.dateacct,
    i.c_bpartner_id,
    i.c_bpartner_location_id,
    i.ad_user_id,
    b.c_bp_group_id,
    i.poreference,
    i.dateordered,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.paymentrule,
    i.c_paymentterm_id,
    i.m_pricelist_id,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ispayschedulevalid,
    i.invoicecollectiontype,
    loc.c_country_id,
    loc.c_region_id,
    loc.postal,
    loc.city,
    i.c_charge_id,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.chargeamt * (-1) ELSE i.chargeamt END                  AS chargeamt,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.totallines * (-1) ELSE i.totallines END                  AS totallines,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN i.grandtotal * (-1) ELSE i.grandtotal END                  AS grandtotal,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN (-1) ELSE 1 END                  AS multiplier,
    i.ad_orgtrx_id           AS c_invoice_ad_orgtrx_id,
    i.c_conversiontype_id    AS c_invoice_c_conversiontype_id,
    i.c_dunninglevel_id,
    i.c_payment_id,
    i.dateordered            AS c_invoice_dateordered,
    i.dunninggrace,
    i.generateto,
    i.isindispute,
    i.ispayschedulevalid     AS c_invoice_ispayschedulevalid,
    i.isselfservice          AS c_invoice_isselfservice,
    i.istaxincluded,
    i.m_rma_id,
    i.posted,
    i.processedon,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.user1_id,
    i.user2_id,
    b.acqusitioncost         AS c_bp_acqusitioncost,
    b.actuallifetimevalue    AS c_bp_actuallifetimevalue,
    b.ad_language            AS c_bp_ad_language,
    b.ad_orgbp_id            AS c_bp_ad_orgbp_id,
    b.ad_org_id              AS c_bp_ad_org_id,
    b.bpartner_parent_id     AS c_bp_bpartner_parent_id,
    b.c_dunning_id           AS c_bp_c_dunning_id,
    b.c_greeting_id          AS c_bp_c_greeting_id,
    b.c_invoiceschedule_id   AS c_bp_c_invoiceschedule_id,
    b.c_paymentterm_id       AS c_bp_c_paymentterm_id,
    b.created                AS c_bp_created,
    b.createdby              AS c_bp_createdby,
    b.c_taxgroup_id          AS c_bp_c_taxgroup_id,
    b.deliveryrule           AS c_bp_deliveryrule,
    b.deliveryviarule        AS c_bp_deliveryviarule,
    b.description            AS c_bp_description,
    b.dunninggrace           AS c_bp_dunninggrace,
    b.duns                   AS c_bp_duns,
    b.firstsale              AS c_bp_firstsale,
    b.flatdiscount           AS c_bp_flatdiscount,
    b.freightcostrule        AS c_bp_freightcostrule,
    b.invoicerule            AS c_bp_invoicerule,
    b.isactive               AS c_bp_isactive,
    b.iscustomer             AS c_bp_iscustomer,
    b.isdiscountprinted      AS c_bp_isdiscountprinted,
    b.isemployee             AS c_bp_isemployee,
    b.ismanufacturer         AS c_bp_ismanufacturer,
    b.isonetime              AS c_bp_isonetime,
    b.ispotaxexempt          AS c_bp_ispotaxexempt,
    b.isprospect             AS c_bp_isprospect,
    b.issalesrep             AS c_bp_issalesrep,
    b.issummary              AS c_bp_issummary,
    b.istaxexempt            AS c_bp_istaxexempt,
    b.isvendor               AS c_bp_isvendor,
    b.logo_id                AS c_bp_logo_id,
    b.m_discountschema_id    AS c_bp_m_discountschema_id,
    b.m_pricelist_id         AS c_bp_m_pricelist_id,
    b.naics                  AS c_bp_naics,
    b.name                   AS c_bp_name,
    b.name2                  AS c_bp_name2,
    b.numberemployees        AS c_bp_numberemployees,
    b.paymentrule            AS c_bp_paymentrule,
    b.paymentrulepo          AS c_bp_paymentrulepo,
    b.po_discountschema_id   AS c_bp_po_discountschema_id,
    b.po_paymentterm_id      AS c_bp_po_paymentterm_id,
    b.po_pricelist_id        AS c_bp_po_pricelist_id,
    b.poreference            AS c_bp_poreference,
    b.potentiallifetimevalue AS c_bp_potentiallifetimevalue,
    b.rating                 AS c_bp_rating,
    b.referenceno            AS c_bp_referenceno,
    b.salesrep_id            AS c_bp_salesrep_id,
    b.salesvolume            AS c_bp_salesvolume,
    b.sendemail              AS c_bp_sendemail,
    b.shareofcustomer        AS c_bp_shareofcustomer,
    b.shelflifeminpct        AS c_bp_shelflifeminpct,
    b.so_creditlimit         AS c_bp_so_creditlimit,
    b.socreditstatus         AS c_bp_socreditstatus,
    b.so_creditused          AS c_bp_so_creditused,
    b.so_description         AS c_bp_so_description,
    b.taxid,
    b.totalopenbalance       AS c_bp_totalopenbalance,
    b.updated                AS c_bp_updated,
    b.updatedby              AS c_bp_updatedby,
    b.url                    AS c_bp_url,
    b.value                  AS c_bp_value,
    bpl.ad_org_id            AS c_bp_location_ad_org_id,
    bpl.c_bpartner_id        AS c_bp_location_c_bpartner_id,
    bpl.c_location_id        AS c_bp_location_c_location_id,
    bpl.created              AS c_bp_location_created,
    bpl.createdby            AS c_bp_location_createdby,
    bpl.c_salesregion_id,
    bpl.fax                  AS c_bp_location_fax,
    bpl.isactive             AS c_bp_location_isactive,
    bpl.isbillto,
    bpl.isdn,
    bpl.ispayfrom,
    bpl.isremitto,
    bpl.isshipto,
    bpl.name                 AS c_bp_location_name,
    bpl.phone                AS c_bp_location_phone,
    bpl.phone2               AS c_bp_location_phone2,
    bpl.updated              AS c_bp_location_updated,
    bpl.updatedby            AS c_bp_location_updatedby,
    loc.address1,
    loc.address2,
    loc.address3,
    loc.address4,
    loc.ad_org_id            AS c_location_ad_org_id,
    loc.c_city_id,
    loc.created              AS c_location_created,
    loc.createdby            AS c_location_createdby,
    loc.isactive             AS c_location_isactive,
    loc.postal_add,
    loc.regionname,
    loc.updated              AS c_location_updated,
    loc.updatedby            AS c_location_updatedby 
FROM c_invoice i 
        JOIN c_doctype d 
        ON i.c_doctype_id = d.c_doctype_id 
        JOIN c_bpartner b 
        ON i.c_bpartner_id = b.c_bpartner_id 
        JOIN c_bpartner_location bpl 
        ON i.c_bpartner_location_id = bpl.c_bpartner_location_id 
        JOIN c_location loc 
        ON bpl.c_location_id = loc.c_location_id
;

CREATE OR REPLACE VIEW rv_c_invoiceline AS 
SELECT il.ad_client_id,
    il.ad_org_id,
    il.isactive,
    il.created,
    il.createdby,
    il.updated,
    il.updatedby,
    il.c_invoiceline_id,
    i.c_invoice_id,
    i.salesrep_id,
    i.c_bpartner_id,
    i.c_bp_group_id,
    il.m_product_id,
    p.m_product_category_id,
    i.dateinvoiced,
    i.dateacct,
    i.issotrx,
    i.c_doctype_id,
    i.docstatus,
    i.ispaid,
    il.c_campaign_id,
    il.c_project_id,
    il.c_activity_id,
    il.c_projectphase_id,
    il.c_projecttask_id,
    il.qtyinvoiced * i.multiplier                                          AS qtyinvoiced,
    il.qtyentered * i.multiplier                                           AS qtyentered,
    il.m_attributesetinstance_id,
    productattribute(il.m_attributesetinstance_id)                         AS productattribute,
    pasi.m_attributeset_id,
    pasi.m_lot_id,
    pasi.guaranteedate,
    pasi.lot,
    pasi.serno,
    il.pricelist,
    il.priceactual,
    il.pricelimit,
    il.priceentered,
    CASE WHEN il.pricelist = 0 THEN 0 ELSE round((il.pricelist - il.priceactual) / il.pricelist * 100, 2) END                                                                AS discount,
    CASE WHEN il.pricelimit = 0 THEN 0 ELSE round((il.priceactual - il.pricelimit) / il.pricelimit * 100, 2) END                                                                AS margin,
    CASE WHEN il.pricelimit = 0 THEN 0 ELSE (il.priceactual - il.pricelimit) * il.qtyinvoiced END                                                                AS marginamt,
    round(i.multiplier * il.linenetamt, 2)                                 AS linenetamt,
    round(i.multiplier * il.pricelist * il.qtyinvoiced, 2)                 AS linelistamt,
    CASE WHEN COALESCE(il.pricelimit, 0) = 0 THEN round(i.multiplier * il.linenetamt, 2) ELSE round(i.multiplier * il.pricelimit * il.qtyinvoiced, 2) END                                                                
    AS linelimitamt,
    round(i.multiplier * il.pricelist * il.qtyinvoiced - il.linenetamt, 2) AS linediscountamt,
    CASE WHEN COALESCE(il.pricelimit, 0) = 0 THEN 0 ELSE round(i.multiplier * il.linenetamt - il.pricelimit * il.qtyinvoiced, 2) END                                                                AS 
    lineoverlimitamt,
    il.ad_orgtrx_id,
    il.a_processed,
    il.c_charge_id,
    il.c_orderline_id,
    il.c_tax_id,
    il.c_uom_id                                                            AS c_invoiceline_c_uom_id,
    il.description                                                         AS c_invoiceline_description,
    il.isdescription,
    il.isprinted,
    il.line,
    il.linenetamt                                                          AS c_invoiceline_linenetamt,
    il.linetotalamt,
    il.m_inoutline_id,
    il.m_rmaline_id,
    il.processed,
    il.ref_invoiceline_id,
    il.rramt,
    il.rrstartdate,
    il.s_resourceassignment_id,
    il.taxamt,
    il.user1_id,
    il.user2_id,
    p.ad_org_id                                                            AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                                                             AS m_product_copyfrom,
    p.created                                                              AS m_product_created,
    p.createdby                                                            AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id                                                             AS m_productline_c_uom_id,
    p.description                                                          AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                                                             AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                                            AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                                    AS m_product_m_attributeset_id,
    p.m_freightcategory_id,
    p.m_locator_id,
    p.m_product_id                                                         AS m_product_m_product_id,
    p.processing                                                           AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                                          AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.sku,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                              AS m_product_updated,
    p.updatedby                                                            AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    pasi.ad_org_id                                                         AS m_asi_ad_org_id,
    pasi.created                                                           AS m_attributesetinstance_created,
    pasi.createdby                                                         AS m_asi_createdby,
    pasi.description                                                       AS m_asi_description,
    pasi.isactive                                                          AS m_attributesetinstance_isacti,
    pasi.serno                                                             AS m_attributesetinstance_serno,
    pasi.updated                                                           AS m_attributesetinstance_updated,
    pasi.updatedby                                                         AS m_asi_updatedby 
FROM rv_c_invoice i 
        JOIN c_invoiceline il 
        ON i.c_invoice_id = il.c_invoice_id 
        LEFT JOIN m_product p 
        ON il.m_product_id = p.m_product_id 
        LEFT JOIN m_attributesetinstance pasi 
        ON il.m_attributesetinstance_id = pasi.m_attributesetinstance_id
;

DROP VIEW rv_c_invoicetax;

CREATE OR REPLACE VIEW rv_c_invoicetax AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    t.created,
    t.createdby,
    t.updated,
    t.updatedby,
    t.c_tax_id,
    i.c_invoice_id,
    i.c_doctype_id,
    i.c_bpartner_id,
    bp.taxid,
    bp.istaxexempt,
    i.dateacct,
    i.dateinvoiced,
    i.issotrx,
    i.documentno,
    i.ispaid,
    i.c_currency_id,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN t.taxbaseamt * (-1) ELSE t.taxbaseamt END                 AS taxbaseamt,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN t.taxamt * (-1) ELSE t.taxamt END                 AS taxamt,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN (t.taxbaseamt + t.taxamt) * (-1) ELSE t.taxbaseamt + t.taxamt END                 AS taxlinetotal,
    CASE WHEN charat(d.docbasetype, 3) = 'C' THEN (-1) ELSE 1 END                 AS multiplier,
    t.ad_org_id             AS c_invoicetax_ad_org_id,
    t.isactive              AS c_invoicetax_isactive,
    t.istaxincluded         AS c_invoicetax_istaxincluded,
    t.processed             AS c_invoicetax_processed,
    i.ad_orgtrx_id          AS c_invoice_ad_orgtrx_id,
    i.ad_user_id,
    i.c_bpartner_location_id,
    i.c_activity_id,
    i.c_campaign_id,
    i.c_charge_id,
    i.c_conversiontype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_order_id,
    i.c_payment_id,
    i.c_paymentterm_id      AS c_invoice_c_paymentterm_id,
    i.created               AS c_invoice_created,
    i.createdby             AS c_invoice_createdby,
    i.dateprinted,
    i.description           AS c_invoice_description,
    i.docaction,
    i.docstatus,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispayschedulevalid,
    i.isprinted,
    i.isselfservice         AS c_invoice_isselfservice,
    i.istaxincluded         AS c_invoice_istaxincluded,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule,
    i.poreference           AS c_invoice_poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.salesrep_id,
    i.sendemail,
    i.totallines,
    i.updated               AS c_invoice_updated,
    i.updatedby             AS c_invoice_updatedby,
    i.user1_id,
    i.user2_id,
    bp.acqusitioncost       AS c_bp_acqusitioncost,
    bp.actuallifetimevalue  AS c_bp_actuallifetimevalue,
    bp.ad_language          AS c_bp_ad_language,
    bp.ad_orgbp_id          AS c_bp_ad_orgbp_id,
    bp.ad_org_id            AS c_bp_ad_org_id,
    bp.bpartner_parent_id   AS c_bp_bpartner_parent_id,
    bp.c_bp_group_id        AS c_bp_c_bp_group_id,
    bp.c_dunning_id         AS c_bp_c_dunning_id,
    bp.c_greeting_id        AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id     AS c_bp_c_paymentterm_id,
    bp.created              AS c_bp_created,
    bp.createdby            AS c_bp_createdby,
    bp.c_taxgroup_id        AS c_bp_c_taxgroup_id,
    bp.deliveryrule         AS c_bp_deliveryrule,
    bp.deliveryviarule      AS c_bp_deliveryviarule,
    bp.description          AS c_bp_description,
    bp.dunninggrace         AS c_bp_dunninggrace,
    bp.duns,
    bp.firstsale            AS c_bp_firstsale,
    bp.flatdiscount         AS c_bp_flatdiscount,
    bp.freightcostrule      AS c_bp_freightcostrule,
    bp.invoicerule          AS c_bp_invoicerule,
    bp.isactive             AS c_bp_isactive,
    bp.iscustomer           AS c_bp_iscustomer,
    bp.isdiscountprinted    AS c_bp_isdiscountprinted,
    bp.isemployee           AS c_bp_isemployee,
    bp.ismanufacturer       AS c_bp_ismanufacturer,
    bp.isonetime            AS c_bp_isonetime,
    bp.ispotaxexempt        AS c_bp_ispotaxexempt,
    bp.isprospect           AS c_bp_isprospect,
    bp.issalesrep           AS c_bp_issalesrep,
    bp.issummary            AS c_bp_issummary,
    bp.isvendor,
    bp.logo_id              AS c_bp_logo_id,
    bp.m_discountschema_id,
    bp.m_pricelist_id       AS c_bp_m_pricelist_id,
    bp.naics,
    bp.name                 AS c_bp_name,
    bp.name2                AS c_bp_name2,
    bp.numberemployees,
    bp.paymentrule          AS c_bp_paymentrule,
    bp.paymentrulepo        AS c_bp_paymentrulepo,
    bp.po_discountschema_id,
    bp.po_paymentterm_id,
    bp.po_pricelist_id,
    bp.poreference          AS c_bp_poreference,
    bp.potentiallifetimevalue,
    bp.rating               AS c_bp_rating,
    bp.salesrep_id          AS c_bp_salesrep_id,
    bp.salesvolume,
    bp.sendemail            AS c_bp_sendemail,
    bp.shareofcustomer,
    bp.shelflifeminpct,
    bp.so_creditlimit,
    bp.socreditstatus,
    bp.so_creditused,
    bp.so_description,
    bp.totalopenbalance     AS c_bp_totalopenbalance,
    bp.updated              AS c_bp_updated,
    bp.updatedby            AS c_bp_updatedby,
    bp.url                  AS c_bp_url,
    bp.value                AS c_bp_value 
FROM c_invoicetax t 
        JOIN c_invoice i 
        ON t.c_invoice_id = i.c_invoice_id 
        JOIN c_doctype d 
        ON i.c_doctype_id = d.c_doctype_id 
        JOIN c_bpartner bp 
        ON i.c_bpartner_id = bp.c_bpartner_id
;

CREATE OR REPLACE VIEW rv_fact_acct AS 
SELECT f.ad_client_id,
    f.ad_org_id,
    f.isactive,
    f.created,
    f.createdby,
    f.updated,
    f.updatedby,
    f.fact_acct_id,
    f.c_acctschema_id,
    f.account_id,
    f.datetrx,
    f.dateacct,
    f.c_period_id,
    f.ad_table_id,
    f.record_id,
    f.line_id,
    f.gl_category_id,
    f.gl_budget_id,
    f.c_tax_id,
    f.m_locator_id,
    f.postingtype,
    f.c_currency_id,
    f.amtsourcedr,
    f.amtsourcecr,
    f.amtsourcedr - f.amtsourcecr AS amtsource,
    f.amtacctdr,
    f.amtacctcr,
    f.amtacctdr - f.amtacctcr     AS amtacct,
    CASE WHEN (f.amtsourcedr - f.amtsourcecr) = 0 THEN 0 ELSE (f.amtacctdr - f.amtacctcr) / (f.amtsourcedr - f.amtsourcecr) END                       AS rate,
    f.c_uom_id,
    f.qty,
    f.m_product_id,
    f.c_bpartner_id,
    f.ad_orgtrx_id,
    f.c_locfrom_id,
    f.c_locto_id,
    f.c_salesregion_id,
    f.c_project_id,
    f.c_campaign_id,
    f.c_activity_id,
    f.user1_id,
    f.user2_id,
    f.a_asset_id,
    f.description,
    o.value                       AS orgvalue,
    o.name                        AS orgname,
    ev.value                      AS accountvalue,
    ev.name,
    ev.accounttype,
    bp.value                      AS bpartnervalue,
    bp.name                       AS bpname,
    bp.c_bp_group_id,
    p.value                       AS productvalue,
    p.name                        AS productname,
    p.upc,
    p.m_product_category_id,
    f.c_projectphase_id,
    f.c_projecttask_id,
    f.c_subacct_id,
    f.userelement1_id,
    f.userelement2_id,
    o.description                 AS ad_org_description,
    o.isactive                    AS ad_org_isactive,
    ev.ad_org_id                  AS c_elementvalue_ad_org_id,
    ev.c_bankaccount_id,
    ev.c_currency_id              AS c_elementvalue_c_currency_id,
    ev.c_element_id,
    ev.c_elementvalue_id,
    ev.description                AS c_elementvalue_description,
    ev.isactive                   AS c_elementvalue_isactive,
    ev.isbankaccount,
    ev.isforeigncurrency,
    ev.issummary                  AS c_elementvalue_issummary,
    bp.acqusitioncost             AS c_bp_acqusitioncost,
    bp.actuallifetimevalue        AS c_bp_actuallifetimevalue,
    bp.ad_language                AS c_bp_ad_language,
    bp.ad_orgbp_id                AS c_bp_ad_orgbp_id,
    bp.ad_org_id                  AS c_bp_ad_org_id,
    bp.bpartner_parent_id         AS c_bp_bpartner_parent_id,
    bp.c_dunning_id               AS c_bp_c_dunning_id,
    bp.c_greeting_id              AS c_bp_c_greeting_id,
    bp.c_invoiceschedule_id       AS c_bp_c_invoiceschedule_id,
    bp.c_paymentterm_id           AS c_bp_c_paymentterm_id,
    bp.created                    AS c_bp_created,
    bp.createdby                  AS c_bp_createdby,
    bp.c_taxgroup_id              AS c_bp_c_taxgroup_id,
    bp.deliveryrule               AS c_bp_deliveryrule,
    bp.deliveryviarule            AS c_bp_deliveryviarule,
    bp.description                AS c_bp_description,
    bp.dunninggrace               AS c_bp_dunninggrace,
    bp.duns,
    bp.firstsale                  AS c_bp_firstsale,
    bp.flatdiscount               AS c_bp_flatdiscount,
    bp.freightcostrule            AS c_bp_freightcostrule,
    bp.invoicerule                AS c_bp_invoicerule,
    bp.isactive                   AS c_bp_isactive,
    bp.iscustomer                 AS c_bp_iscustomer,
    bp.isdiscountprinted          AS c_bp_isdiscountprinted,
    bp.isemployee                 AS c_bp_isemployee,
    bp.ismanufacturer             AS c_bp_ismanufacturer,
    bp.isonetime                  AS c_bp_isonetime,
    bp.ispotaxexempt              AS c_bp_ispotaxexempt,
    bp.isprospect                 AS c_bp_isprospect,
    bp.issalesrep                 AS c_bp_issalesrep,
    bp.issummary                  AS c_bp_issummary,
    bp.istaxexempt                AS c_bp_istaxexempt,
    bp.isvendor                   AS c_bp_isvendor,
    bp.logo_id                    AS c_bp_logo_id,
    bp.m_discountschema_id        AS c_bp_m_discountschema_id,
    bp.m_pricelist_id             AS c_bp_m_pricelist_id,
    bp.naics,
    bp.name2                      AS c_bp_name2,
    bp.numberemployees            AS c_bp_numberemployees,
    bp.paymentrule                AS c_bp_paymentrule,
    bp.paymentrulepo              AS c_bp_paymentrulepo,
    bp.po_discountschema_id       AS c_bp_po_discountschema_id,
    bp.po_paymentterm_id          AS c_bp_po_paymentterm_id,
    bp.po_pricelist_id            AS c_bp_po_pricelist_id,
    bp.poreference                AS c_bp_poreference,
    bp.potentiallifetimevalue     AS c_bp_potentiallifetimevalue,
    bp.rating                     AS c_bp_rating,
    bp.referenceno,
    bp.salesrep_id                AS c_bp_salesrep_id,
    bp.salesvolume                AS c_bp_salesvolume,
    bp.sendemail                  AS c_bp_sendemail,
    bp.shareofcustomer            AS c_bp_shareofcustomer,
    bp.shelflifeminpct            AS c_bp_shelflifeminpct,
    bp.so_creditlimit             AS c_bp_so_creditlimit,
    bp.socreditstatus             AS c_bp_socreditstatus,
    bp.so_creditused              AS c_bp_so_creditused,
    bp.so_description             AS c_bp_so_description,
    bp.taxid,
    bp.totalopenbalance           AS c_bp_totalopenbalance,
    bp.updated                    AS c_bp_updated,
    bp.updatedby                  AS c_bp_updatedby,
    bp.url                        AS c_bp_url,
    p.ad_org_id                   AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                    AS m_product_copyfrom,
    p.created                     AS m_product_created,
    p.createdby                   AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id                    AS m_product_c_uom_id,
    p.description                 AS m_product_description,
    p.descriptionurl,
    p.discontinued,
    p.discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                    AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                   AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id           AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id   AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                AS m_product_m_locator_id,
    p.processing                  AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                 AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.sku,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                     AS m_product_updated,
    p.updatedby                   AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight 
FROM fact_acct f 
        JOIN ad_org o 
        ON f.ad_org_id = o.ad_org_id 
        JOIN c_elementvalue ev 
        ON f.account_id = ev.c_elementvalue_id 
        LEFT JOIN c_bpartner bp 
        ON f.c_bpartner_id = bp.c_bpartner_id 
        LEFT JOIN m_product p 
        ON f.m_product_id = p.m_product_id
;

DROP VIEW rv_inoutdetails;

CREATE OR REPLACE VIEW rv_inoutdetails AS 
SELECT h.ad_client_id,
    h.ad_org_id,
    l.isactive,
    l.created,
    l.createdby,
    l.updated,
    l.updatedby,
    h.m_inout_id,
    h.issotrx,
    h.documentno,
    h.docaction,
    h.docstatus,
    h.posted,
    h.processed,
    h.c_doctype_id,
    h.description,
    h.c_order_id,
    h.dateordered,
    h.movementtype,
    h.movementdate,
    h.dateacct,
    h.c_bpartner_id,
    h.c_bpartner_location_id,
    h.ad_user_id,
    h.salesrep_id,
    h.m_warehouse_id,
    h.poreference,
    h.deliveryrule,
    h.freightcostrule,
    h.freightamt,
    h.deliveryviarule,
    h.m_shipper_id,
    h.priorityrule,
    h.dateprinted,
    h.nopackages,
    h.pickdate,
    h.shipdate,
    h.trackingno,
    h.ad_orgtrx_id,
    h.c_project_id,
    h.c_campaign_id,
    h.c_activity_id,
    h.user1_id,
    h.user2_id,
    h.datereceived,
    h.isapproved,
    h.isindispute,
    l.m_inoutline_id,
    l.line,
    l.description                                 AS linedescription,
    l.c_orderline_id,
    l.m_locator_id,
    l.m_product_id,
    l.c_uom_id,
    l.m_attributesetinstance_id,
    productattribute(l.m_attributesetinstance_id) AS productattribute,
    pasi.m_attributeset_id,
    pasi.m_lot_id,
    pasi.guaranteedate,
    pasi.lot,
    pasi.serno,
    l.movementqty,
    l.qtyentered,
    l.isdescription,
    l.confirmedqty,
    l.pickedqty,
    l.scrappedqty,
    l.targetqty,
    loc.value                                     AS locatorvalue,
    loc.x,
    loc.y,
    loc.z,
    h.c_charge_id                                 AS m_inout_c_charge_id,
    h.chargeamt,
    h.c_invoice_id                                AS m_inout_c_invoice_id,
    h.createconfirm,
    h.created                                     AS m_inout_created,
    h.createdby                                   AS m_inout_createdby,
    h.createfrom,
    h.createpackage,
    h.dropship_bpartner_id,
    h.dropship_location_id,
    h.dropship_user_id,
    h.generateto,
    h.isactive                                    AS m_inout_isactive,
    h.isdropship,
    h.isintransit,
    h.isprinted,
    h.m_rma_id,
    h.processedon,
    h.processing,
    h.ref_inout_id,
    h.reversal_id,
    h.sendemail,
    h.updated                                     AS m_inout_updated,
    h.updatedby                                   AS m_inout_updatedby,
    h.volume,
    h.weight,
    l.ad_org_id                                   AS m_inoutline_ad_org_id,
    l.ad_orgtrx_id                                AS m_inoutline_ad_orgtrx_id,
    l.c_activity_id                               AS m_inoutline_c_activity_id,
    l.c_campaign_id                               AS m_inoutline_c_campaign_id,
    l.c_charge_id                                 AS m_inoutline_c_charge_id,
    l.c_project_id                                AS m_inoutline_c_project_id,
    l.c_projectphase_id,
    l.c_projecttask_id,
    l.isinvoiced,
    l.m_rmaline_id,
    l.processed                                   AS m_inoutline_processed,
    l.ref_inoutline_id,
    l.reversalline_id,
    l.user1_id                                    AS m_inoutline_user1_id,
    l.user2_id                                    AS m_inoutline_user2_id,
    loc.ad_org_id                                 AS m_locator_ad_org_id,
    loc.isactive                                  AS m_locator_isactive,
    loc.isdefault,
    loc.m_warehouse_id                            AS m_locator_m_warehouse_id,
    loc.priorityno,
    pasi.ad_org_id                                AS m_asi_ad_org_id,
    pasi.created                                  AS m_asi_created,
    pasi.createdby                                AS m_asi_createdby,
    pasi.description                              AS m_asi_description,
    pasi.isactive                                 AS m_asi_isactive,
    pasi.updated                                  AS m_asi_updated,
    pasi.updatedby                                AS m_asi_updatedby 
FROM m_inout h 
        JOIN m_inoutline l 
        ON h.m_inout_id = l.m_inout_id 
        LEFT JOIN m_locator loc 
        ON l.m_locator_id = loc.m_locator_id 
        LEFT JOIN m_attributesetinstance pasi 
        ON l.m_attributesetinstance_id = pasi.m_attributesetinstance_id
;

DROP VIEW rv_m_transaction;

CREATE OR REPLACE VIEW rv_m_transaction AS 
SELECT t.ad_client_id,
    t.ad_org_id,
    t.movementdate,
    t.movementqty,
    t.m_product_id,
    t.m_locator_id,
    t.m_attributesetinstance_id,
    p.m_product_category_id,
    p.value,
    po.c_bpartner_id,
    po.pricepo,
    po.pricelastpo,
    po.pricelist,
    t.c_projectissue_id,
    t.created                   AS m_transaction_created,
    t.createdby                 AS m_transaction_createdby,
    t.isactive                  AS m_transaction_isactive,
    t.m_inoutline_id,
    t.movementtype,
    t.m_productionline_id,
    t.m_transaction_id,
    t.pp_cost_collector_id,
    t.updated                   AS m_transation_updated,
    t.updatedby                 AS m_transation_updatedby,
    p.ad_org_id                 AS m_product_ad_org_id,
    p.classification,
    p.copyfrom                  AS m_product_copyfrom,
    p.created                   AS m_product_created,
    p.createdby                 AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.c_uom_id                  AS m_product_c_uom_id,
    p.description               AS m_product_description,
    p.descriptionurl,
    p.discontinued              AS m_product_discontinued,
    p.discontinuedat            AS m_product_discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                  AS m_product_isactive,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                 AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id         AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id              AS m_product_m_locator_id,
    p.name                      AS m_product_name,
    p.processing                AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id               AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.sku,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.upc                       AS m_product_upc,
    p.updated                   AS m_product_updated,
    p.updatedby                 AS m_product_updatedby,
    p.versionno,
    p.volume,
    p.weight,
    po.ad_org_id                AS m_product_po_ad_org_id,
    po.c_currency_id            AS m_product_po_c_currency_id,
    po.costperorder,
    po.created                  AS m_product_po_created,
    po.createdby                AS m_product_po_createdby,
    po.c_uom_id                 AS m_product_po_c_uom_id,
    po.deliverytime_actual,
    po.deliverytime_promised,
    po.discontinued             AS m_product_po_discontinued,
    po.discontinuedat           AS m_product_po_discontinuedat,
    po.isactive                 AS m_product_po_isactive,
    po.iscurrentvendor,
    po.manufacturer,
    po.m_product_id             AS m_product_po_m_product_id,
    po.order_min,
    po.order_pack,
    po.priceeffective,
    po.pricelastinv,
    po.qualityrating,
    po.royaltyamt,
    po.upc                      AS m_product_po_upc,
    po.updated                  AS m_product_po_updated,
    po.updatedby                AS m_product_po_updatedby,
    po.vendorcategory,
    po.vendorproductno 
FROM m_transaction t 
        JOIN m_product p 
        ON t.m_product_id = p.m_product_id 
        JOIN m_product_po po 
        ON t.m_product_id = po.m_product_id 
WHERE po.iscurrentvendor = 'Y'
;

DROP VIEW rv_openitem;

CREATE OR REPLACE VIEW rv_openitem AS 
SELECT i.ad_org_id,
    i.ad_client_id,
    i.documentno,
    i.c_invoice_id,
    i.c_order_id,
    i.c_bpartner_id,
    i.issotrx,
    i.dateinvoiced,
    i.dateacct,
    p.netdays,
    paymenttermduedate(i.c_paymentterm_id, i.dateinvoiced)            AS duedate,
    paymenttermduedays(i.c_paymentterm_id, i.dateinvoiced, getdate()) AS daysdue,
    adddays(i.dateinvoiced, p.discountdays)                           AS discountdate,
    round(i.grandtotal * p.discount / 100, 2)                         AS discountamt,
    i.grandtotal,
    invoicepaid(i.c_invoice_id, i.c_currency_id, 1)                   AS paidamt,
    invoiceopen(i.c_invoice_id, 0)                                    AS openamt,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.c_paymentterm_id,
    i.ispayschedulevalid,
    NULL                                                              AS c_invoicepayschedule_id,
    i.invoicecollectiontype,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.c_invoice_ad_orgtrx_id                                          AS ad_orgtrx_id,
    i.ad_user_id,
    i.c_bpartner_location_id,
    i.c_charge_id,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.created,
    i.createdby,
    i.dateordered,
    i.dateprinted,
    i.description,
    i.docaction,
    i.docstatus,
    i.dunninggrace,
    i.generateto,
    i.isactive,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispaid,
    i.isprinted,
    i.c_invoice_isselfservice                                         AS isselfservice,
    i.istaxincluded,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.salesrep_id,
    i.sendemail,
    i.totallines,
    i.updated,
    i.updatedby,
    i.user1_id,
    i.user2_id 
FROM rv_c_invoice i 
        JOIN c_paymentterm p 
        ON i.c_paymentterm_id = p.c_paymentterm_id 
WHERE invoiceopen(i.c_invoice_id, 0) <> 0 AND i.ispayschedulevalid <> 'Y' AND i.docstatus IN ('CO',
    'CL') 
UNION 
SELECT i.ad_org_id,
    i.ad_client_id,
    i.documentno,
    i.c_invoice_id,
    i.c_order_id,
    i.c_bpartner_id,
    i.issotrx,
    i.dateinvoiced,
    i.dateacct,
    daysbetween(ips.duedate, i.dateinvoiced)                 AS netdays,
    ips.duedate,
    daysbetween(getdate(), ips.duedate)                      AS daysdue,
    ips.discountdate,
    ips.discountamt,
    ips.dueamt                                               AS grandtotal,
    invoicepaid(i.c_invoice_id, i.c_currency_id, 1)          AS paidamt,
    invoiceopen(i.c_invoice_id, ips.c_invoicepayschedule_id) AS openamt,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.c_paymentterm_id,
    i.ispayschedulevalid,
    ips.c_invoicepayschedule_id,
    i.invoicecollectiontype,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.c_invoice_ad_orgtrx_id                                 AS ad_orgtrx_id,
    i.ad_user_id,
    i.c_bpartner_location_id,
    i.c_charge_id,
    i.c_doctype_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.created,
    i.createdby,
    i.dateordered,
    i.dateprinted,
    i.description,
    i.docaction,
    i.docstatus,
    i.dunninggrace,
    i.generateto,
    i.isactive,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispaid,
    i.isprinted,
    i.c_invoice_isselfservice                                AS isselfservice,
    i.istaxincluded,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.salesrep_id,
    i.sendemail,
    i.totallines,
    i.updated,
    i.updatedby,
    i.user1_id,
    i.user2_id 
FROM rv_c_invoice i 
        JOIN c_invoicepayschedule ips 
        ON i.c_invoice_id = ips.c_invoice_id 
WHERE invoiceopen(i.c_invoice_id, ips.c_invoicepayschedule_id) <> 0 AND i.ispayschedulevalid = 'Y' AND i.docstatus IN ('CO',
    'CL') AND ips.isvalid = 'Y'
;

DROP VIEW rv_orderdetail;

CREATE OR REPLACE VIEW rv_orderdetail AS 
SELECT l.ad_client_id,
    l.ad_org_id,
    l.isactive,
    l.created,
    l.createdby,
    l.updated,
    l.updatedby,
    o.c_order_id,
    o.docstatus,
    o.docaction,
    o.c_doctype_id,
    o.isapproved,
    o.iscreditapproved,
    o.salesrep_id,
    o.bill_bpartner_id,
    o.bill_location_id,
    o.bill_user_id,
    o.isdropship,
    l.c_bpartner_id,
    l.c_bpartner_location_id,
    o.ad_user_id,
    o.poreference,
    o.c_currency_id,
    o.issotrx,
    l.c_campaign_id,
    l.c_project_id,
    l.c_activity_id,
    l.c_projectphase_id,
    l.c_projecttask_id,
    l.c_orderline_id,
    l.dateordered,
    l.datepromised,
    l.m_product_id,
    l.m_warehouse_id,
    l.m_attributesetinstance_id,
    productattribute(l.m_attributesetinstance_id)  AS productattribute,
    pasi.m_attributeset_id,
    pasi.m_lot_id,
    pasi.guaranteedate,
    pasi.lot,
    pasi.serno,
    l.c_uom_id,
    l.qtyentered,
    l.qtyordered,
    l.qtyreserved,
    l.qtydelivered,
    l.qtyinvoiced,
    l.priceactual,
    l.priceentered,
    l.qtyordered - l.qtydelivered                  AS qtytodeliver,
    l.qtyordered - l.qtyinvoiced                   AS qtytoinvoice,
    (l.qtyordered - l.qtyinvoiced) * l.priceactual AS netamttoinvoice,
    l.qtylostsales,
    l.qtylostsales * l.priceactual                 AS amtlostsales,
    CASE WHEN l.pricelist = 0 THEN 0 ELSE round((l.pricelist - l.priceactual) / l.pricelist * 100, 2) END                                        AS discount,
    CASE WHEN l.pricelimit = 0 THEN 0 ELSE round((l.priceactual - l.pricelimit) / l.pricelimit * 100, 2) END                                        AS margin,
    CASE WHEN l.pricelimit = 0 THEN 0 ELSE (l.priceactual - l.pricelimit) * l.qtydelivered END                                        AS marginamt,
    o.ad_org_id                                    AS c_order_ad_org_id,
    o.ad_orgtrx_id                                 AS c_order_ad_orgtrx_id,
    o.amountrefunded,
    o.amounttendered,
    o.c_activity_id                                AS c_order_c_activity_id,
    o.c_bpartner_id                                AS c_order_c_bpartner_id,
    o.c_bpartner_location_id                       AS c_order_c_bpartner_location_i,
    o.c_campaign_id                                AS c_order_c_compaign_id,
    o.c_cashline_id,
    o.c_cashplanline_id,
    o.c_charge_id                                  AS c_order_c_charge_id,
    o.c_conversiontype_id,
    o.c_doctypetarget_id,
    o.chargeamt,
    o.copyfrom,
    o.c_payment_id,
    o.c_paymentterm_id,
    o.c_pos_id,
    o.c_project_id                                 AS c_order_c_project_id,
    o.created                                      AS c_order_created,
    o.createdby                                    AS c_order_createdby,
    o.dateacct,
    o.dateordered                                  AS c_order_dateordered,
    o.dateprinted,
    o.datepromised                                 AS c_order_datepromised,
    o.deliveryrule,
    o.deliveryviarule,
    o.description                                  AS c_order_description,
    o.documentno,
    o.dropship_bpartner_id,
    o.dropship_location_id,
    o.dropship_user_id,
    o.freightamt                                   AS c_order_freightamt,
    o.freightcostrule,
    o.grandtotal,
    o.invoicerule,
    o.isactive                                     AS c_order_isactive,
    o.isdelivered,
    o.isdiscountprinted,
    o.isinvoiced,
    o.ispayschedulevalid,
    o.isprinted,
    o.isselected,
    o.isselfservice,
    o.istaxincluded,
    o.istransferred,
    o.link_order_id,
    o.m_freightcategory_id,
    o.m_pricelist_id,
    o.m_shipper_id                                 AS c_order_m_shipper_id,
    o.m_warehouse_id                               AS c_order_m_warehouse_id,
    o.ordertype,
    o.pay_bpartner_id,
    o.pay_location_id,
    o.paymentrule,
    o.posted,
    o.priorityrule,
    o.processed                                    AS c_order_processed,
    o.processedon,
    o.promotioncode,
    o.ref_order_id,
    o.sendemail,
    o.totallines,
    o.updated                                      AS c_order_updated,
    o.updatedby                                    AS c_order_updatedby,
    o.user1_id                                     AS c_order_user1_id,
    o.user2_id                                     AS c_order_user2_id,
    o.volume,
    o.weight,
    l.ad_orgtrx_id                                 AS c_orderline_ad_orgtrx_id,
    l.c_charge_id                                  AS c_orderline_c_charge_id,
    l.c_currency_id                                AS c_orderline_c_currency_id,
    l.c_tax_id,
    l.datedelivered,
    l.dateinvoiced,
    l.description                                  AS c_orderline_description,
    l.discount                                     AS c_orderline_discount,
    l.freightamt                                   AS c_orderline_freightamt,
    l.isdescription,
    l.line,
    l.linenetamt,
    l.link_orderline_id,
    l.m_promotion_id,
    l.m_shipper_id                                 AS c_orderline_m_shipper_id,
    l.pricecost,
    l.pricelimit,
    l.pricelist,
    l.processed                                    AS c_orderline_processed,
    l.ref_orderline_id,
    l.rramt,
    l.rrstartdate,
    l.s_resourceassignment_id,
    l.user1_id                                     AS c_orderline_user1_id,
    l.user2_id                                     AS c_orderline_user2_id,
    pasi.ad_org_id                                 AS m_asi_ad_org_id,
    pasi.created                                   AS m_asi_created,
    pasi.createdby                                 AS m_asi_createdby,
    pasi.description                               AS m_asi_description,
    pasi.isactive                                  AS m_asi_isactive,
    pasi.updated                                   AS m_asi_updated,
    pasi.updatedby                                 AS m_asi_updatedby 
FROM c_order o 
        JOIN c_orderline l 
        ON o.c_order_id = l.c_order_id 
        LEFT JOIN m_attributesetinstance pasi 
        ON l.m_attributesetinstance_id = pasi.m_attributesetinstance_id
;

DROP VIEW rv_payment;

CREATE OR REPLACE VIEW rv_payment AS 
SELECT c_payment.c_payment_id,
    c_payment.ad_client_id,
    c_payment.ad_org_id,
    c_payment.isactive,
    c_payment.created,
    c_payment.createdby,
    c_payment.updated,
    c_payment.updatedby,
    c_payment.documentno,
    c_payment.datetrx,
    c_payment.isreceipt,
    c_payment.c_doctype_id,
    c_payment.trxtype,
    c_payment.c_bankaccount_id,
    c_payment.c_bpartner_id,
    c_payment.c_invoice_id,
    c_payment.c_bp_bankaccount_id,
    c_payment.c_paymentbatch_id,
    c_payment.tendertype,
    c_payment.creditcardtype,
    c_payment.creditcardnumber,
    c_payment.creditcardvv,
    c_payment.creditcardexpmm,
    c_payment.creditcardexpyy,
    c_payment.micr,
    c_payment.routingno,
    c_payment.accountno,
    c_payment.checkno,
    c_payment.a_name,
    c_payment.a_street,
    c_payment.a_city,
    c_payment.a_state,
    c_payment.a_zip,
    c_payment.a_ident_dl,
    c_payment.a_ident_ssn,
    c_payment.a_email,
    c_payment.voiceauthcode,
    c_payment.orig_trxid,
    c_payment.ponum,
    c_payment.c_currency_id,
    c_payment.c_conversiontype_id,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.payamt ELSE c_payment.payamt * (-1) END                                                           AS payamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.discountamt ELSE c_payment.discountamt * (-1) END                                                           AS discountamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.writeoffamt ELSE c_payment.writeoffamt * (-1) END                                                           AS writeoffamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.taxamt ELSE c_payment.taxamt * (-1) END                                                           AS taxamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN c_payment.overunderamt ELSE c_payment.overunderamt * (-1) END                                                           AS overunderamt,
    CASE c_payment.isreceipt WHEN 'Y' THEN 1 ELSE (-1) END                                                           AS multiplierap,
    paymentallocated(c_payment.c_payment_id, c_payment.c_currency_id) AS allocatedamt,
    paymentavailable(c_payment.c_payment_id)                          AS availableamt,
    c_payment.isoverunderpayment,
    c_payment.isapproved,
    c_payment.r_pnref,
    c_payment.r_result,
    c_payment.r_respmsg,
    c_payment.r_authcode,
    c_payment.r_avsaddr,
    c_payment.r_avszip,
    c_payment.r_info,
    c_payment.processing,
    c_payment.oprocessing,
    c_payment.docstatus,
    c_payment.docaction,
    c_payment.isprepayment,
    c_payment.c_charge_id,
    c_payment.isreconciled,
    c_payment.isallocated,
    c_payment.isonline,
    c_payment.processed,
    c_payment.posted,
    c_payment.c_campaign_id,
    c_payment.c_project_id,
    c_payment.c_activity_id,
    c_payment.a_country,
    c_payment.ad_orgtrx_id,
    c_payment.chargeamt,
    c_payment.c_order_id,
    c_payment.dateacct,
    c_payment.description,
    c_payment.isdelayedcapture,
    c_payment.isselfservice,
    c_payment.processedon,
    c_payment.r_authcode_dc,
    c_payment.r_cvv2match,
    c_payment.ref_payment_id,
    c_payment.reversal_id,
    c_payment.r_pnref_dc,
    c_payment.swipe,
    c_payment.user1_id,
    c_payment.user2_id 
FROM c_payment
;

CREATE OR REPLACE VIEW rv_storage AS 
SELECT s.ad_client_id,
    s.ad_org_id,
    s.m_product_id,
    p.value,
    p.name,
    p.description,
    p.upc,
    p.sku,
    p.c_uom_id,
    p.m_product_category_id,
    p.classification,
    p.weight,
    p.volume,
    p.versionno,
    p.guaranteedays,
    p.guaranteedaysmin,
    s.m_locator_id,
    l.m_warehouse_id,
    l.x,
    l.y,
    l.z,
    s.qtyonhand,
    s.qtyreserved,
    s.qtyonhand - s.qtyreserved                                    AS qtyavailable,
    s.qtyordered,
    s.datelastinventory,
    s.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.serno,
    asi.lot,
    asi.m_lot_id,
    asi.guaranteedate,
    daysbetween(asi.guaranteedate, getdate())                      AS shelflifedays,
    daysbetween(asi.guaranteedate, getdate()) - p.guaranteedaysmin AS goodfordays,
    CASE WHEN COALESCE(p.guaranteedays, 0) > 0 THEN round(daysbetween(asi.guaranteedate, getdate()) / p.guaranteedays * 100, 0) ELSE NULL END                                                        AS 
    shelfliferemainingpct,
    s.isactive                                                     AS m_storage_isactive,
    s.updated                                                      AS m_storage_updated,
    s.updatedby                                                    AS m_storage_updatedby,
    l.ad_org_id                                                    AS m_locator_ad_org_id,
    l.isactive                                                     AS m_locator_isactive,
    l.isdefault,
    l.priorityno,
    l.value                                                        AS m_locator_value,
    p.ad_org_id                                                    AS m_product_ad_org_id,
    p.copyfrom                                                     AS m_product_copyfrom,
    p.created                                                      AS m_product_created,
    p.createdby                                                    AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.descriptionurl,
    p.discontinued                                                 AS m_product_discontinued,
    p.discontinuedat                                               AS m_product_discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.help,
    p.imageurl,
    p.isactive                                                     AS m_product_isactive,
    p.isbom,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                                    AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                            AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id                                    AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                                                 AS m_product_m_locator_id,
    p.processing                                                   AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                                  AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                      AS m_product_updated,
    p.updatedby                                                    AS m_product_updatedby,
    asi.ad_org_id                                                  AS m_asi_ad_org_id,
    asi.created                                                    AS m_asi_created,
    asi.createdby                                                  AS m_asi_createdby,
    asi.description                                                AS m_asi_description,
    asi.isactive                                                   AS m_asi_isactive,
    asi.updated                                                    AS m_asi_updated,
    asi.updatedby                                                  AS m_asi_updatedby 
FROM m_storage s 
        JOIN m_locator l 
        ON s.m_locator_id = l.m_locator_id 
        JOIN m_product p 
        ON s.m_product_id = p.m_product_id 
        LEFT JOIN m_attributesetinstance asi 
        ON s.m_attributesetinstance_id = asi.m_attributesetinstance_id
;

DROP VIEW rv_transaction;

CREATE OR REPLACE VIEW rv_transaction AS 
SELECT t.m_transaction_id,
    t.ad_client_id,
    t.ad_org_id,
    t.movementtype,
    t.movementdate,
    t.movementqty,
    t.m_attributesetinstance_id,
    asi.m_attributeset_id,
    asi.serno,
    asi.lot,
    asi.m_lot_id,
    asi.guaranteedate,
    t.m_product_id,
    p.value,
    p.name,
    p.description,
    p.upc,
    p.sku,
    p.c_uom_id,
    p.m_product_category_id,
    p.classification,
    p.weight,
    p.volume,
    p.versionno,
    t.m_locator_id,
    l.m_warehouse_id,
    l.x,
    l.y,
    l.z,
    t.m_inventoryline_id,
    il.m_inventory_id,
    t.m_movementline_id,
    ml.m_movement_id,
    t.m_inoutline_id,
    iol.m_inout_id,
    t.m_productionline_id,
    prdl.m_productionplan_id,
    prdp.m_production_id,
    t.c_projectissue_id,
    pjl.c_project_id,
    COALESCE(il.line, ml.line, iol.line, prdl.line, pjl.line) AS line,
    t.created                                                 AS m_transaction_created,
    t.createdby                                               AS m_transaction_createdby,
    t.isactive                                                AS m_transaction_isactive,
    t.pp_cost_collector_id,
    t.updated                                                 AS m_transaction_updated,
    t.updatedby                                               AS m_transction_updatedby,
    l.ad_org_id                                               AS m_locator_ad_org_id,
    l.isactive                                                AS m_locator_isactive,
    l.isdefault,
    l.priorityno,
    l.value                                                   AS m_locator_value,
    p.ad_org_id                                               AS m_product_ad_org_id,
    p.copyfrom                                                AS m_product_copyfrom,
    p.created                                                 AS m_product_created,
    p.createdby                                               AS m_product_createdby,
    p.c_revenuerecognition_id,
    p.c_subscriptiontype_id,
    p.c_taxcategory_id,
    p.descriptionurl,
    p.discontinued                                            AS m_product_discontinued,
    p.discontinuedat                                          AS m_product_discontinuedat,
    p.documentnote,
    p.group1,
    p.group2,
    p.guaranteedays,
    p.guaranteedaysmin,
    p.help,
    p.imageurl,
    p.isactive                                                AS m_product_isactive,
    p.isbom,
    p.isdropship,
    p.isexcludeautodelivery,
    p.isinvoiceprintdetails,
    p.ispicklistprintdetails,
    p.ispurchased,
    p.isselfservice,
    p.issold,
    p.isstocked,
    p.issummary                                               AS m_product_issummary,
    p.isverified,
    p.iswebstorefeatured,
    p.lowlevel,
    p.m_attributeset_id                                       AS m_product_m_attributeset_id,
    p.m_attributesetinstance_id                               AS m_product_m_asi_id,
    p.m_freightcategory_id,
    p.m_locator_id                                            AS m_product_m_locator_id,
    p.processing                                              AS m_product_processing,
    p.producttype,
    p.r_mailtext_id,
    p.salesrep_id                                             AS m_product_salesrep_id,
    p.s_expensetype_id,
    p.shelfdepth,
    p.shelfheight,
    p.shelfwidth,
    p.s_resource_id,
    p.unitsperpack,
    p.unitsperpallet,
    p.updated                                                 AS m_product_updated,
    p.updatedby                                               AS m_product_updatedby,
    il.ad_org_id                                              AS m_inventoryline_ad_org_id,
    il.c_charge_id                                            AS m_inventoryline_c_charge_id,
    il.created                                                AS m_inventoryline_created,
    il.createdby                                              AS m_inventoryline_createdby,
    il.description                                            AS m_inventoryline_description,
    il.inventorytype,
    il.isactive                                               AS m_inventoryline_isactive,
    il.m_attributesetinstance_id                              AS m_inventoryline_m_asi_id,
    il.m_locator_id                                           AS m_inventoryline_m_locator_id,
    il.m_product_id                                           AS m_inventoryline_m_product_id,
    il.processed                                              AS m_inventoryline_processed,
    il.qtybook,
    il.qtycount,
    il.qtycsv,
    il.qtyinternaluse,
    il.reversalline_id                                        AS m_inventoryline_revline_id,
    il.updated                                                AS m_inventoryline_updated,
    il.updatedby                                              AS m_inventoryline_updatedby,
    ml.ad_org_id                                              AS m_movementline_ad_org_id,
    ml.confirmedqty                                           AS m_movementline_confirmedqty,
    ml.created                                                AS m_movementline_created,
    ml.createdby                                              AS m_movementline_createdby,
    ml.dd_orderline_id,
    ml.description                                            AS m_movementline_description,
    ml.isactive                                               AS m_movementline_isactive,
    ml.m_attributesetinstance_id                              AS m_movementline_m_asi_id,
    ml.m_attributesetinstanceto_id,
    ml.m_locator_id                                           AS m_movementline_m_locator_id,
    ml.m_locatorto_id,
    ml.movementqty                                            AS m_movementline_movementqty,
    ml.m_product_id                                           AS m_movementline_m_product_id,
    ml.processed                                              AS m_movementline_processed,
    ml.reversalline_id                                        AS m_movementline_reversalline_i,
    ml.scrappedqty                                            AS m_movementline_scrappedqty,
    ml.targetqty                                              AS m_movementline_targetqty,
    ml.updated                                                AS m_movementline_updated,
    ml.updatedby                                              AS m_movementline_updatedby,
    iol.ad_org_id                                             AS m_inoutline_ad_org_id,
    iol.ad_orgtrx_id                                          AS m_inoutline_ad_orgtrx_id,
    iol.c_activity_id                                         AS m_inoutline_c_activity_id,
    iol.c_campaign_id                                         AS m_inoutline_c_campaign_id,
    iol.c_charge_id                                           AS m_inoutline_c_charge_id,
    iol.confirmedqty                                          AS m_inoutline_confirmedqty,
    iol.c_orderline_id                                        AS m_inoutline_c_orderline_id,
    iol.c_project_id                                          AS m_inoutline_c_project_id,
    iol.c_projectphase_id,
    iol.c_projecttask_id,
    iol.created                                               AS m_inoutline_created,
    iol.createdby                                             AS m_inoutline_createdby,
    iol.c_uom_id                                              AS m_inoutline_c_uom_id,
    iol.description                                           AS m_inoutline_description,
    iol.isactive                                              AS m_inoutline_isactive,
    iol.isdescription,
    iol.isinvoiced,
    iol.line                                                  AS m_inoutline_line,
    iol.m_attributesetinstance_id                             AS m_inoutline_m_asi_id,
    iol.m_inout_id                                            AS m_inoutline_m_inout_id,
    iol.movementqty                                           AS m_inoutline_movementqty,
    iol.m_product_id                                          AS m_inoutline_m_product_id,
    iol.m_rmaline_id                                          AS m_inoutline_m_rmaline_id,
    iol.pickedqty                                             AS m_inoutline_pickedqty,
    iol.processed                                             AS m_inoutline_processed,
    iol.qtyentered                                            AS m_inoutline_qtyentered,
    iol.ref_inoutline_id,
    iol.reversalline_id                                       AS m_inoutline_reversalline_id,
    iol.scrappedqty                                           AS m_inoutline_scrappedqty,
    iol.targetqty                                             AS m_inoutline_targetqty,
    iol.updated                                               AS m_inoutline_updated,
    iol.updatedby                                             AS m_inoutline_updatedby,
    iol.user1_id                                              AS m_inoutline_user1_id,
    iol.user2_id                                              AS m_inoutline_user2_id,
    prdl.ad_org_id                                            AS m_productionline_ad_org_id,
    prdl.created                                              AS m_productionline_created,
    prdl.createdby                                            AS m_productionline_createdby,
    prdl.description                                          AS m_productionline_description,
    prdl.isactive                                             AS m_productionline_isactive,
    prdl.m_attributesetinstance_id                            AS m_productionline_m_asi_id,
    prdl.m_locator_id                                         AS m_productionline_m_locator_id,
    prdl.movementqty                                          AS m_productionline_movementqty,
    prdl.m_product_id                                         AS m_productionline_m_product_id,
    prdl.m_productionline_id                                  AS m_productionl_m_productionl_id,
    prdl.processed                                            AS m_productionline_processed,
    prdl.updated                                              AS m_productionline_updated,
    prdl.updatedby                                            AS m_productionline_updatedby,
    prdp.ad_org_id                                            AS m_productionplan_ad_org_id,
    prdp.created                                              AS m_productionplan_created,
    prdp.createdby                                            AS m_productionplan_createdby,
    prdp.description                                          AS m_productionplan_description,
    prdp.isactive                                             AS m_productionplan_isactive,
    prdp.line                                                 AS m_productionplan_line,
    prdp.m_locator_id                                         AS m_productionplan_m_locator_id,
    prdp.m_product_id                                         AS m_productionplan_m_product_id,
    prdp.processed                                            AS m_productionplan_processed,
    prdp.productionqty                                        AS m_productionplan_productionqt,
    prdp.updated                                              AS m_productionplan_updated,
    prdp.updatedby                                            AS m_productionplan_updatedby,
    pjl.ad_org_id                                             AS c_prjctissue_ad_org_id,
    pjl.c_projectissue_id                                     AS c_prjctissue_c_projectissue_id,
    pjl.created                                               AS c_prjctissue_created,
    pjl.createdby                                             AS c_prjctissue_createdby,
    pjl.description                                           AS c_prjctissue_description,
    pjl.isactive                                              AS c_prjctissue_isactive,
    pjl.m_attributesetinstance_id                             AS c_prjctissue_m_asi_id,
    pjl.m_inoutline_id                                        AS c_prjctissue_m_inoutline_id,
    pjl.m_locator_id                                          AS c_prjctissue_m_locator_id,
    pjl.movementdate                                          AS c_prjctissue_movementdate,
    pjl.movementqty                                           AS c_prjctissue_movementqty,
    pjl.m_product_id                                          AS c_prjctissue_m_product_id,
    pjl.posted                                                AS c_prjctissue_posted,
    pjl.processed                                             AS c_prjctissue_processed,
    pjl.processedon                                           AS c_prjctissue_processedon,
    pjl.processing                                            AS c_prjctissue_processing,
    pjl.s_timeexpenseline_id                                  AS c_prjctissue_s_timeexpline_id,
    pjl.updated                                               AS c_prjctissue_updated,
    pjl.updatedby                                             AS c_prjctissue_updatedby 
FROM m_transaction t 
        JOIN m_locator l 
        ON t.m_locator_id = l.m_locator_id 
        JOIN m_product p 
        ON t.m_product_id = p.m_product_id 
        LEFT JOIN m_attributesetinstance asi 
        ON t.m_attributesetinstance_id = asi.m_attributesetinstance_id 
        LEFT JOIN m_inventoryline il 
        ON t.m_inventoryline_id = il.m_inventoryline_id 
        LEFT JOIN m_movementline ml 
        ON t.m_movementline_id = ml.m_movementline_id 
        LEFT JOIN m_inoutline iol 
        ON t.m_inoutline_id = iol.m_inoutline_id 
        LEFT JOIN m_productionline prdl 
        ON t.m_productionline_id = prdl.m_productionline_id 
        LEFT JOIN m_productionplan prdp 
        ON prdl.m_productionplan_id = prdp.m_productionplan_id 
        LEFT JOIN c_projectissue pjl 
        ON t.c_projectissue_id = pjl.c_projectissue_id
;

DROP VIEW t_invoicegl_v;

CREATE OR REPLACE VIEW t_invoicegl_v AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.c_invoice_id,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.c_doctype_id,
    i.c_order_id,
    i.description,
    i.salesrep_id,
    i.dateinvoiced,
    i.dateacct,
    i.c_paymentterm_id,
    i.c_bpartner_id,
    i.c_bpartner_location_id,
    i.ad_user_id,
    i.isselfservice,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.grandtotal,
    i.istaxincluded,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ad_orgtrx_id,
    i.user1_id,
    i.user2_id,
    fa.c_locfrom_id,
    fa.c_locto_id,
    fa.c_salesregion_id,
    fa.fact_acct_id,
    fa.c_acctschema_id,
    fa.account_id,
    fa.c_period_id,
    fa.gl_category_id,
    fa.gl_budget_id,
    fa.c_tax_id,
    fa.m_locator_id,
    fa.postingtype,
    fa.amtsourcedr,
    fa.amtsourcecr,
    fa.amtacctdr,
    fa.amtacctcr,
    fa.c_uom_id,
    fa.qty,
    gl.ad_pinstance_id,
    gl.apar,
    gl.openamt,
    gl.percent,
    gl.amtrevaldr,
    gl.amtrevalcr,
    gl.datereval,
    gl.c_conversiontypereval_id,
    gl.amtsourcebalance,
    gl.amtacctbalance,
    gl.c_doctypereval_id,
    gl.amtrevaldrdiff,
    gl.amtrevalcrdiff,
    gl.isallcurrencies,
    fa.amtacctdr * gl.percent / 100                  AS amtacctopendr,
    fa.amtacctcr * gl.percent / 100                  AS amtacctopencr,
    (fa.amtacctdr - fa.amtacctcr) * gl.percent / 100 AS amtacctopenbalance,
    gl.ad_org_id                                     AS t_invoicegl_ad_org_id,
    gl.c_invoice_id                                  AS t_invoicegl_c_invoice_id,
    gl.created                                       AS t_invoicegl_created,
    gl.createdby                                     AS t_invoicegl_createdby,
    gl.grandtotal                                    AS t_invoicegl_grandtotal,
    gl.isactive                                      AS t_invoicegl_isactive,
    gl.updated                                       AS t_invoicegl_updated,
    gl.updatedby                                     AS t_invoicegl_updatedby,
    i.c_charge_id                                    AS c_invoice_c_charge_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.dateordered,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispaid,
    i.ispayschedulevalid,
    i.isprinted,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.totallines,
    fa.a_asset_id,
    fa.ad_org_id                                     AS fact_acct_ad_org_id,
    fa.ad_orgtrx_id                                  AS fact_acct_ad_orgtrx_id,
    fa.ad_table_id                                   AS fact_acct_ad_table_id,
    fa.c_activity_id                                 AS fact_acct_c_activity_id,
    fa.c_bpartner_id                                 AS fact_acct_c_bpartner_id,
    fa.c_campaign_id                                 AS fact_acct_c_campaign_id,
    fa.c_currency_id                                 AS fact_acct_c_currency_id,
    fa.c_subacct_id,
    fa.dateacct                                      AS fact_acct_dateacct,
    fa.datetrx,
    fa.description                                   AS fact_acct_description,
    fa.isactive                                      AS fact_acct_isactive,
    fa.line_id,
    fa.m_product_id                                  AS fact_acct_m_product_id,
    fa.record_id,
    fa.updated                                       AS fact_acct_updated,
    fa.updatedby                                     AS fact_acct_updatedby,
    fa.user1_id                                      AS fact_acct_user1_id,
    fa.user2_id                                      AS fact_acct_user2_id,
    fa.userelement1_id,
    fa.userelement2_id 
FROM t_invoicegl gl 
        JOIN c_invoice i 
        ON gl.c_invoice_id = i.c_invoice_id 
        JOIN fact_acct fa 
        ON gl.fact_acct_id = fa.fact_acct_id
;

DROP VIEW t_invoicegl_vt;

CREATE OR REPLACE VIEW t_invoicegl_vt AS 
SELECT i.ad_client_id,
    i.ad_org_id,
    i.isactive,
    i.created,
    i.createdby,
    i.updated,
    i.updatedby,
    i.c_invoice_id,
    i.issotrx,
    i.documentno,
    i.docstatus,
    i.c_doctype_id,
    i.c_order_id,
    i.description,
    i.salesrep_id,
    i.dateinvoiced,
    i.dateacct,
    i.c_paymentterm_id,
    i.c_bpartner_id,
    i.c_bpartner_location_id,
    i.ad_user_id,
    i.isselfservice,
    i.c_currency_id,
    i.c_conversiontype_id,
    i.grandtotal,
    i.istaxincluded,
    i.c_campaign_id,
    i.c_project_id,
    i.c_activity_id,
    i.ad_orgtrx_id,
    i.user1_id,
    i.user2_id,
    fa.c_locfrom_id,
    fa.c_locto_id,
    fa.c_salesregion_id,
    fa.fact_acct_id,
    fa.c_acctschema_id,
    fa.account_id,
    fa.c_period_id,
    fa.gl_category_id,
    fa.gl_budget_id,
    fa.c_tax_id,
    fa.m_locator_id,
    fa.postingtype,
    fa.amtsourcedr,
    fa.amtsourcecr,
    fa.amtacctdr,
    fa.amtacctcr,
    fa.c_uom_id,
    fa.qty,
    gl.ad_pinstance_id,
    gl.apar,
    gl.openamt,
    gl.percent,
    gl.amtrevaldr,
    gl.amtrevalcr,
    gl.datereval,
    gl.c_conversiontypereval_id,
    gl.amtsourcebalance,
    gl.amtacctbalance,
    gl.c_doctypereval_id,
    gl.amtrevaldrdiff,
    gl.amtrevalcrdiff,
    gl.isallcurrencies,
    fa.amtacctdr * gl.percent / 100                  AS amtacctopendr,
    fa.amtacctcr * gl.percent / 100                  AS amtacctopencr,
    (fa.amtacctdr - fa.amtacctcr) * gl.percent / 100 AS amtacctopenbalance,
    gl.ad_org_id                                     AS t_invoicegl_ad_org_id,
    gl.c_invoice_id                                  AS t_invoicegl_c_invoice_id,
    gl.created                                       AS t_invoicegl_created,
    gl.createdby                                     AS t_invoicegl_createdby,
    gl.grandtotal                                    AS t_invoicegl_grandtotal,
    gl.isactive                                      AS t_invoicegl_isactive,
    gl.updated                                       AS t_invoicegl_updated,
    gl.updatedby                                     AS t_invoicegl_updatedby,
    i.c_charge_id                                    AS c_invoice_c_charge_id,
    i.c_doctypetarget_id,
    i.c_dunninglevel_id,
    i.chargeamt,
    i.c_payment_id,
    i.dateordered,
    i.dateprinted,
    i.docaction,
    i.dunninggrace,
    i.generateto,
    i.invoicecollectiontype,
    i.isapproved,
    i.isdiscountprinted,
    i.isindispute,
    i.ispaid,
    i.ispayschedulevalid,
    i.isprinted,
    i.istransferred,
    i.m_pricelist_id,
    i.m_rma_id,
    i.paymentrule,
    i.poreference,
    i.posted,
    i.processedon,
    i.processing,
    i.ref_invoice_id,
    i.reversal_id,
    i.sendemail,
    i.totallines,
    fa.a_asset_id,
    fa.ad_org_id                                     AS fact_acct_ad_org_id,
    fa.ad_orgtrx_id                                  AS fact_acct_ad_orgtrx_id,
    fa.ad_table_id                                   AS fact_acct_ad_table_id,
    fa.c_activity_id                                 AS fact_acct_c_activity_id,
    fa.c_bpartner_id                                 AS fact_acct_c_bpartner_id,
    fa.c_campaign_id                                 AS fact_acct_c_campaign_id,
    fa.c_currency_id                                 AS fact_acct_c_currency_id,
    fa.c_subacct_id,
    fa.dateacct                                      AS fact_acct_dateacct,
    fa.datetrx,
    fa.description                                   AS fact_acct_description,
    fa.isactive                                      AS fact_acct_isactive,
    fa.line_id,
    fa.m_product_id                                  AS fact_acct_m_product_id,
    fa.record_id,
    fa.updated                                       AS fact_acct_updated,
    fa.updatedby                                     AS fact_acct_updatedby,
    fa.user1_id                                      AS fact_acct_user1_id,
    fa.user2_id                                      AS fact_acct_user2_id,
    fa.userelement1_id,
    fa.userelement2_id 
FROM t_invoicegl gl 
        JOIN c_invoice i 
        ON gl.c_invoice_id = i.c_invoice_id 
        JOIN fact_acct fa 
        ON gl.fact_acct_id = fa.fact_acct_id
;

SELECT register_migration_script('201303191127_TICKET-1001025.sql') FROM dual
;
