-- Oracle Changes

ALTER TABLE C_Invoice ADD M_RMA_ID NUMBER(10, 0) DEFAULT NULL;

ALTER TABLE C_InvoiceLine ADD M_RMALine_ID NUMBER(10,0) DEFAULT NULL;

ALTER TABLE M_InOut ADD M_RMA_ID NUMBER(10,0) DEFAULT NULL;

ALTER TABLE M_InOutLine ADD M_RMALine_ID NUMBER(10,0) DEFAULT NULL;

ALTER TABLE M_RMA ADD IsSOTrx CHAR(1) DEFAULT 'Y' CHECK (IsSOTrx IN ('Y', 'N')) NOT NULL;

ALTER TABLE M_RMA RENAME COLUMN M_InOut_ID TO InOut_ID;

ALTER TABLE M_RMA ADD GenerateTo CHAR(1) DEFAULT NULL;

ALTER TABLE M_RMALine ADD Amt NUMBER(22,2);

ALTER TABLE M_RMALine ADD C_Charge_ID NUMBER(10,0);

ALTER TABLE M_RMALine ADD Line NUMBER(10,0) DEFAULT 0 NOT NULL;

ALTER TABLE M_RMALine ADD LineNetAmt NUMBER(22,2);

ALTER TABLE M_RMALine ADD QtyDelivered NUMBER(22,2);

ALTER TABLE M_RMALine MODIFY M_InOutLine_ID NUMBER(10,0) NULL;


-- Constraints

ALTER TABLE C_Invoice ADD CONSTRAINT mrma_cinvoice FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE C_InvoiceLine ADD CONSTRAINT mrmaline_cinvoiceline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);

ALTER TABLE M_InOut ADD CONSTRAINT mrma_minout FOREIGN KEY (M_RMA_ID) REFERENCES M_RMA (M_RMA_ID);

ALTER TABLE M_InOutLine ADD CONSTRAINT mrmaline_minoutline FOREIGN KEY (M_RMALine_ID) REFERENCES M_RMALine (M_RMALine_ID);
