/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.gmaps;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.zkoss.gmaps.LatLng;
import org.zkoss.gmaps.LatLngBounds;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.json.parser.JSONParser;
import org.zkoss.json.parser.ParseException;
import org.zkoss.zk.ui.UiException;

public class GmapsUtil {
    private static String GOOGLE_WEB_SERVICE_GEOCODE_JSON = "https://maps.googleapis.com/maps/api/geocode/json?";

    public static int[] latlngToXy(double lat, double lng, int zoomLevel) {
        if (lat > 90.0 || lat < -90.0) {
            throw new UiException("latitude must be in the range of -90 degree ~ 90 degree");
        }
        if (lng > 180.0 || lng < -180.0) {
            throw new UiException("longitude must be in the range of -180 degree ~ 180 degree");
        }
        if (lat > 89.2) {
            lat = 89.2;
        } else if (lat < -89.2) {
            lat = -89.2;
        }
        int[] out = new int[2];
        int base = 256 << zoomLevel;
        int zero = base >> 1;
        out[0] = (int)((double)base * lng / 360.0) + zero;
        out[1] = zero - (int)Math.round(Math.log(Math.tan(0.7853981633974483 + 0.5 * lat * Math.PI / 180.0)) * (double)zero / Math.PI);
        return out;
    }

    public static double[] xyToLatlng(int x, int y, int zoomLevel) {
        int base = 256 << zoomLevel;
        int zero = base >> 1;
        double[] out = new double[2];
        out[1] = (double)(x - zero) * 360.0 / (double)base;
        if (out[1] > 180.0) {
            out[1] = out[1] - 360.0;
        } else if (out[1] < -180.0) {
            out[1] = out[1] + 360.0;
        }
        out[0] = Math.atan(Math.exp((double)(zero - y) * Math.PI / (double)zero)) * 360.0 / Math.PI - 90.0;
        return out;
    }

    public static double[] getBounds(double lat, double lng, int width, int height, int zoomLevel) {
        int eastx;
        int base = 256 << zoomLevel;
        int[] centerxy = GmapsUtil.latlngToXy(lat, lng, zoomLevel);
        int westx = centerxy[0] - width / 2;
        if (westx < 0) {
            westx = 0;
        }
        if ((eastx = westx + width) > base) {
            eastx = base;
        }
        int northy = centerxy[1] - height / 2;
        int southy = northy + height;
        double[] sw = GmapsUtil.xyToLatlng(westx, southy, zoomLevel);
        double[] ne = GmapsUtil.xyToLatlng(eastx, northy, zoomLevel);
        double[] out = new double[]{sw[0], sw[1], ne[0], ne[1]};
        return out;
    }

    public static LatLngBounds getBounds(LatLng latLng, int width, int height, int zoomLevel) {
        int eastx;
        int base = 256 << zoomLevel;
        int[] centerxy = GmapsUtil.latlngToXy(latLng.getLatitude(), latLng.getLongitude(), zoomLevel);
        int westx = centerxy[0] - width / 2;
        if (westx < 0) {
            westx = 0;
        }
        if ((eastx = westx + width) > base) {
            eastx = base;
        }
        int northy = centerxy[1] - height / 2;
        int southy = northy + height;
        double[] sw = GmapsUtil.xyToLatlng(westx, southy, zoomLevel);
        double[] ne = GmapsUtil.xyToLatlng(eastx, northy, zoomLevel);
        double[] out = new double[]{sw[0], sw[1], ne[0], ne[1]};
        return new LatLngBounds(new LatLng(sw[0], sw[1]), new LatLng(ne[0], ne[1]));
    }

    public static StringBuilder getGeocodeJsonResult(String address, boolean sensor, String language, String apiKey) throws ParseException, UnsupportedEncodingException, MalformedURLException, IOException {
        String path = GOOGLE_WEB_SERVICE_GEOCODE_JSON + "address=" + URLEncoder.encode(address, "UTF-8") + "&sensor=" + sensor + "&language=" + language + (apiKey != null ? "&key=" + apiKey : "");
        StringBuilder sb = GmapsUtil.getResponse(path);
        return sb;
    }

    public static StringBuilder getGeocodeJsonResult(double lat, double lng, boolean sensor, String language, String apiKey) throws ParseException, UnsupportedEncodingException, MalformedURLException, IOException {
        String path = GOOGLE_WEB_SERVICE_GEOCODE_JSON + "latlng=" + lat + "," + lng + "&sensor=" + sensor + "&language=" + language + (apiKey != null ? "&key=" + apiKey : "");
        StringBuilder sb = GmapsUtil.getResponse(path);
        return sb;
    }

    public static double[] getLatlngByAddress(String address, boolean sensor, String language, String apiKey) throws ParseException, UnsupportedEncodingException, MalformedURLException, IOException {
        StringBuilder sb = GmapsUtil.getGeocodeJsonResult(address, sensor, language, apiKey);
        double[] latlng = new double[2];
        JSONArray results = (JSONArray)((JSONObject)new JSONParser().parse(sb.toString())).get((Object)"results");
        JSONObject location = (JSONObject)((JSONObject)((JSONObject)results.get(0)).get((Object)"geometry")).get((Object)"location");
        latlng[0] = (Double)location.get((Object)"lat");
        latlng[1] = (Double)location.get((Object)"lng");
        return latlng;
    }

    public static double[] getBoundsByAddress(String address, boolean sensor, String language, String apiKey) throws ParseException, UnsupportedEncodingException, MalformedURLException, IOException {
        StringBuilder sb = GmapsUtil.getGeocodeJsonResult(address, sensor, language, apiKey);
        double[] bounds = new double[4];
        JSONArray results = (JSONArray)((JSONObject)new JSONParser().parse(sb.toString())).get((Object)"results");
        JSONObject boundsInfo = (JSONObject)((JSONObject)((JSONObject)results.get(0)).get((Object)"geometry")).get((Object)"bounds");
        bounds[0] = (Double)((JSONObject)boundsInfo.get((Object)"southwest")).get((Object)"lat");
        bounds[1] = (Double)((JSONObject)boundsInfo.get((Object)"southwest")).get((Object)"lng");
        bounds[2] = (Double)((JSONObject)boundsInfo.get((Object)"northeast")).get((Object)"lat");
        bounds[3] = (Double)((JSONObject)boundsInfo.get((Object)"northeast")).get((Object)"lng");
        return bounds;
    }

    public static String getAddressByLatlng(double lat, double lng, boolean sensor, String language, String apiKey) throws ParseException, UnsupportedEncodingException, MalformedURLException, IOException {
        StringBuilder sb = GmapsUtil.getGeocodeJsonResult(lat, lng, sensor, language, apiKey);
        String address = null;
        JSONArray results = (JSONArray)((JSONObject)new JSONParser().parse(sb.toString())).get((Object)"results");
        address = (String)((JSONObject)results.get(1)).get((Object)"formatted_address");
        return address;
    }

    private static StringBuilder getResponse(String path) throws MalformedURLException, IOException {
        URL url = new URL(path);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-agent", "Mozilla/5.0");
        conn.setRequestProperty("Accept-Charset", "UTF-8");
        conn.setReadTimeout(10000);
        conn.connect();
        int status = conn.getResponseCode();
        switch (status) {
            case 504: {
                break;
            }
            case 403: {
                break;
            }
            case 500: {
                break;
            }
            case 404: {
                break;
            }
            case 200: {
                int ch;
                InputStreamReader reader = new InputStreamReader(conn.getInputStream(), "UTF-8");
                StringBuilder sb = new StringBuilder("");
                while ((ch = reader.read()) != -1) {
                    sb.append((char)ch);
                }
                return sb;
            }
        }
        return null;
    }
}

