/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;

public class JRQueryExecuter {
    private JRQuery query = null;
    private Map<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
    private Map<String, Object> parameterValues = null;
    private String queryString = "";
    private List<String> parameterNames = new ArrayList<String>();

    protected JRQueryExecuter(JRQuery query, Map<String, JRParameter> parameters, Map<String, Object> values) {
        this.query = query;
        this.parametersMap = parameters;
        this.parameterValues = values;
        this.parseQuery();
    }

    public static PreparedStatement getStatement(JRQuery query, Map<String, JRParameter> parameters, Map<String, Object> values, Connection conn) throws JRException {
        PreparedStatement pstmt = null;
        if (conn != null) {
            JRQueryExecuter queryExecuter = new JRQueryExecuter(query, parameters, values);
            pstmt = queryExecuter.getStatement(conn);
        }
        return pstmt;
    }

    private void parseQuery() {
        JRQueryChunk[] chunks;
        this.queryString = "";
        this.parameterNames = new ArrayList<String>();
        if (this.query != null && (chunks = this.query.getChunks()) != null && chunks.length > 0) {
            StringBuilder sbuffer = new StringBuilder();
            JRQueryChunk chunk = null;
            int i = 0;
            while (i < chunks.length) {
                chunk = chunks[i];
                switch (chunk.getType()) {
                    case 3: {
                        String parameterName = chunk.getText();
                        Object parameterValue = this.parameterValues.get(parameterName);
                        sbuffer.append(String.valueOf(parameterValue));
                        break;
                    }
                    case 2: {
                        sbuffer.append("?");
                        this.parameterNames.add(chunk.getText());
                        break;
                    }
                    default: {
                        sbuffer.append(chunk.getText());
                    }
                }
                ++i;
            }
            this.queryString = sbuffer.toString();
        }
    }

    private PreparedStatement getStatement(Connection conn) throws JRException {
        PreparedStatement pstmt = null;
        if (this.queryString != null && this.queryString.trim().length() > 0) {
            try {
                pstmt = conn.prepareStatement(this.queryString);
                if (this.parameterNames != null && this.parameterNames.size() > 0) {
                    JRParameter parameter = null;
                    String parameterName = null;
                    Class clazz = null;
                    Object parameterValue = null;
                    int i = 0;
                    while (i < this.parameterNames.size()) {
                        parameterName = this.parameterNames.get(i);
                        parameter = this.parametersMap.get(parameterName);
                        clazz = parameter.getValueClass();
                        parameterValue = this.parameterValues.get(parameterName);
                        if (clazz.equals(Object.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 2000);
                            } else {
                                pstmt.setObject(i + 1, parameterValue);
                            }
                        } else if (clazz.equals(Boolean.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, -7);
                            } else {
                                pstmt.setBoolean(i + 1, (Boolean)parameterValue);
                            }
                        } else if (clazz.equals(Byte.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, -6);
                            } else {
                                pstmt.setByte(i + 1, (Byte)parameterValue);
                            }
                        } else if (clazz.equals(Double.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 8);
                            } else {
                                pstmt.setDouble(i + 1, (Double)parameterValue);
                            }
                        } else if (clazz.equals(Float.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 6);
                            } else {
                                pstmt.setFloat(i + 1, ((Float)parameterValue).floatValue());
                            }
                        } else if (clazz.equals(Integer.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 4);
                            } else {
                                pstmt.setInt(i + 1, (Integer)parameterValue);
                            }
                        } else if (clazz.equals(Long.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, -5);
                            } else {
                                pstmt.setLong(i + 1, (Long)parameterValue);
                            }
                        } else if (clazz.equals(Short.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 5);
                            } else {
                                pstmt.setShort(i + 1, (Short)parameterValue);
                            }
                        } else if (clazz.equals(BigDecimal.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 3);
                            } else {
                                pstmt.setBigDecimal(i + 1, (BigDecimal)parameterValue);
                            }
                        } else if (clazz.equals(String.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 12);
                            } else {
                                pstmt.setString(i + 1, parameterValue.toString());
                            }
                        } else if (clazz.equals(java.util.Date.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 91);
                            } else {
                                pstmt.setDate(i + 1, new Date(((java.util.Date)parameterValue).getTime()));
                            }
                        } else if (clazz.equals(Timestamp.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 93);
                            } else {
                                pstmt.setTimestamp(i + 1, (Timestamp)parameterValue);
                            }
                        } else if (clazz.equals(Time.class)) {
                            if (parameterValue == null) {
                                pstmt.setNull(i + 1, 92);
                            } else {
                                pstmt.setTime(i + 1, (Time)parameterValue);
                            }
                        } else {
                            throw new JRException("Parameter type not supported in query : " + parameterName + " class " + clazz.getName());
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                throw new JRException("Error preparing statement for executing the report query : \n\n" + this.queryString + "\n\n", (Throwable)e);
            }
        }
        return pstmt;
    }
}

