/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import org.adempiere.base.Core;
import org.adempiere.base.markdown.IMarkdownRenderer;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MarkdownTest
extends AbstractTestCase {
    @Test
    public void TestRenderToHtml() {
        IMarkdownRenderer service = Core.getMarkdownRenderer();
        Assertions.assertNotNull((Object)service, (String)"Fail to get markdown renderer service instance");
        String html = service.renderToHtml("# Heading level 1");
        Assertions.assertEquals((Object)"<h1>Heading level 1</h1>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("I just love **bold text**");
        Assertions.assertEquals((Object)"I just love <strong>bold text</strong>", (Object)html, (String)"Unexpected render to html output");
        html = service.renderToHtml("My favorite search engine is [Duck Duck Go](https://duckduckgo.com)");
        Assertions.assertEquals((Object)"My favorite search engine is <a href=\"https://duckduckgo.com\" target=\"_blank\" onclick=\"event.stopPropagation()\">Duck Duck Go</a>", (Object)html, (String)"Unexpected render to html output");
        String table = "| Month | Name |\n| -------- | ------- |\n| 1 | January |";
        html = service.renderToHtml(table);
        String expected = "<table>\n<thead>\n<tr>\n<th>Month</th>\n<th>Name</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td>1</td>\n<td>January</td>\n</tr>\n</tbody>\n</table>";
        Assertions.assertEquals((Object)expected, (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("Auto link **https://idempiere.org/**");
        Assertions.assertEquals((Object)"Auto link <strong><a href=\"https://idempiere.org/\" target=\"_blank\" onclick=\"event.stopPropagation()\">https://idempiere.org/</a></strong>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("No Auto link **https://idempiere.org/**", false);
        Assertions.assertEquals((Object)"No Auto link <strong>https://idempiere.org/</strong>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("Auto link **test@idempiere.org**");
        Assertions.assertEquals((Object)"Auto link <strong><a href=\"mailto:test@idempiere.org\" target=\"_blank\" onclick=\"event.stopPropagation()\">test@idempiere.org</a></strong>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("No Auto link **test@idempiere.org**", false);
        Assertions.assertEquals((Object)"No Auto link <strong>test@idempiere.org</strong>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("<div>Inside HTML **block**</div>");
        Assertions.assertEquals((Object)"<div>Inside HTML **block**</div>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("<div>Inside HTML <#md>**block**</#md></div>");
        Assertions.assertEquals((Object)"<div>Inside HTML <strong>block</strong></div>", (Object)html.trim(), (String)"Unexpected render to html output");
        html = service.renderToHtml("Zoom [BP](javascript:directZoom(\"C_BPartner_ID\",100))");
        Assertions.assertEquals((Object)"Zoom <a href=\"javascript:directZoom(&quot;C_BPartner_ID&quot;,100)\" onclick=\"event.stopPropagation()\">BP</a>", (Object)html.trim(), (String)"Unexpected render to html output");
    }
}

