/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;

public class MDiscountSchemaTest
extends AbstractTestCase {
    @Test
    @Order(value=1)
    public void testPercentageDiscount() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MULCH.id));
        line1.setQty(new BigDecimal("100"));
        line1.setDatePromised(today);
        line1.saveEx();
        MDiscountSchema schema = new MDiscountSchema(Env.getCtx(), DictionaryIDs.M_DiscountSchema.FIVE_PERCENT_DISCOUNT.id, this.getTrxName());
        MDiscountSchemaBreak[] breaks = schema.getBreaks(false);
        Assertions.assertTrue((breaks.length > 0 ? 1 : 0) != 0, (String)"No discount schema breaks");
        MPriceList priceList = MPriceList.get((int)order.getM_PriceList_ID());
        MPriceListVersion priceListVersion = priceList.getPriceListVersion(order.getDateOrdered());
        MProductPrice[] productPrice = priceListVersion.getProductPrice(" AND M_Product_ID=" + DictionaryIDs.M_Product.MULCH.id);
        Assertions.assertEquals((int)1, (int)productPrice.length, (String)"Unexpected number of ProductPrice record");
        BigDecimal discounted = MDiscountSchema.calculateDiscountedPrice((BigDecimal)productPrice[0].getPriceStd(), (BigDecimal)breaks[0].getBreakDiscount());
        Assertions.assertEquals((Object)discounted.setScale(2, RoundingMode.HALF_UP), (Object)line1.getPriceActual().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Order Line price");
    }

    @Test
    @Order(value=2)
    public void testFixedPriceDiscount() {
        BigDecimal fixedPrice = new BigDecimal("1.00");
        MDiscountSchema schema = new MDiscountSchema(Env.getCtx(), DictionaryIDs.M_DiscountSchema.FIVE_PERCENT_DISCOUNT.id, this.getTrxName());
        MDiscountSchemaBreak discountBreak = null;
        try {
            discountBreak = new MDiscountSchemaBreak(Env.getCtx(), 0, null);
            discountBreak.setM_DiscountSchema_ID(schema.getM_DiscountSchema_ID());
            discountBreak.setBreakDiscount(new BigDecimal("0.00"));
            discountBreak.setBreakValue(new BigDecimal("10"));
            discountBreak.setFixedPrice(fixedPrice);
            discountBreak.setM_Product_ID(DictionaryIDs.M_Product.MULCH.id);
            discountBreak.setIsBPartnerFlatDiscount(false);
            discountBreak.setIsActive(true);
            discountBreak.setSeqNo(20);
            discountBreak.saveEx();
            CacheMgt.get().reset("M_DiscountSchema", schema.get_ID());
            MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
            order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id));
            order.setC_DocTypeTarget_ID("SO");
            order.setDeliveryRule("O");
            order.setDocStatus("DR");
            order.setDocAction("CO");
            Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
            order.setDatePromised(today);
            order.saveEx();
            MOrderLine line1 = new MOrderLine(order);
            line1.setLine(10);
            line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MULCH.id));
            line1.setQty(new BigDecimal("10"));
            line1.setDatePromised(today);
            line1.saveEx();
            Assertions.assertEquals((Object)fixedPrice, (Object)line1.getPriceActual().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Order Line price");
        }
        finally {
            this.rollback();
            if (discountBreak != null && discountBreak.get_ID() > 0) {
                discountBreak.deleteEx(true);
            }
        }
    }
}

