/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromDepositBatch;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBankAccount;
import org.compiere.model.MDepositBatch;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MPayment;
import org.compiere.model.MQuery;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromDepositBatchFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromDepositBatch() {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_DocType_ID(true);
        payment.setC_BPartner_ID(DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        payment.setTenderType("D");
        int C_BankAccount_ID = DB.getSQLValueEx((String)this.getTrxName(), (String)"SELECT C_BankAccount_ID FROM C_BankAccount WHERE IsActive='Y' AND AD_Client_ID=? AND IsDefault='Y' ORDER BY C_BankAccount_ID", (Object[])new Object[]{this.getAD_Client_ID()});
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        int C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        payment.setC_Currency_ID(C_Currency_ID);
        payment.setPayAmt(new BigDecimal("10.00"));
        payment.saveEx();
        MBankAccount bankAccount = MBankAccount.get((int)C_BankAccount_ID);
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        payment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)payment.getDocStatus(), (String)"Unexpected document status");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MDepositBatch batch = new MDepositBatch(Env.getCtx(), 0, this.getTrxName());
        batch.setC_BankAccount_ID(C_BankAccount_ID);
        batch.setC_DocType_ID(payment.getC_DocType_ID());
        batch.setDateDeposit(today);
        batch.setDateAcct(today);
        batch.setDateDoc(today);
        batch.setC_Currency_ID(bankAccount.getC_Currency_ID());
        batch.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)200031);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Payments into batch");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("C_DepositBatch");
        query.addRestriction("C_DepositBatch_ID", "=", batch.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)batch.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong record id");
        CreateFromDepositBatchImpl form = new CreateFromDepositBatchImpl(gridTab);
        form.setTrxName(this.getTrxName());
        Timestamp dateFrom = TimeUtil.addDays((Timestamp)today, (int)-1);
        Timestamp dateTo = TimeUtil.addDays((Timestamp)today, (int)1);
        form.loadPayments(C_BankAccount_ID, null, null, dateFrom, dateTo, null, null, payment.getC_DocType_ID(), null, null, C_Currency_ID);
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 2);
            if (pp.getKey() == payment.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find payment record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        batch.load(this.getTrxName(), new String[0]);
        MDepositBatchLine[] lines = batch.getLines();
        Assertions.assertNotNull((Object)lines, (String)"Null deposit batch line");
        Assertions.assertEquals((int)1, (int)lines.length, (String)"Unexpected number of batch lines");
        Assertions.assertEquals((int)payment.get_ID(), (int)lines[0].getC_Payment_ID());
    }

    private static class CreateFromDepositBatchImpl
    extends CreateFromDepositBatch {
        private MiniTableImpl minitable = null;

        public CreateFromDepositBatchImpl(GridTab mTab) {
            super(mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return this;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public void loadPayments(Integer BankAccount, Integer BPartner, String DocumentNo, Timestamp DateFrom, Timestamp DateTo, BigDecimal AmtFrom, BigDecimal AmtTo, Integer DocType, String TenderType, String AuthCode, Integer C_Currency_ID) {
            Vector datas = super.getBankAccountData(BankAccount, BPartner, DocumentNo, DateFrom, DateTo, AmtFrom, AmtTo, DocType, TenderType, AuthCode, C_Currency_ID);
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

