/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.util.Vector;
import org.compiere.apps.form.Charge;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.idempiere.test.AbstractTestCase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChargeFormTest
extends AbstractTestCase {
    @Test
    public void testCreateNewAccontAndCharge() {
        Charge charge = new Charge();
        charge.setTrxName(this.getTrxName());
        String value = "testCreateNewAccontAndCharge";
        String name = "testCreateNewAccontAndCharge";
        int elementValueId = charge.createElementValue(value, name, true);
        Assertions.assertTrue((elementValueId > 0 ? 1 : 0) != 0, (String)"Failed to create new account element record");
        int chargeId = charge.createCharge(name, elementValueId);
        Assertions.assertTrue((chargeId > 0 ? 1 : 0) != 0, (String)"Failed to create new Charge record");
    }

    @Test
    public void testCreateChargeFromAccount() {
        Charge charge = new Charge();
        charge.setTrxName(this.getTrxName());
        MiniTableImpl minitable = new MiniTableImpl();
        Vector columns = charge.getColumnNames();
        for (String column : columns) {
            minitable.addColumn(column);
        }
        charge.setColumnClass((IMiniTable)minitable);
        Vector accounts = charge.getData();
        Assertions.assertTrue((accounts.size() > 0 ? 1 : 0) != 0, (String)"Failed to retrieve account element records");
        int i = 0;
        while (i < accounts.size()) {
            minitable.setRowCount(i + 1);
            Vector account = (Vector)accounts.get(i);
            int j = 0;
            while (j < account.size()) {
                minitable.setValueAt(account.get(j), i, j);
                ++j;
            }
            ++i;
        }
        Assertions.assertEquals((int)accounts.size(), (int)minitable.getRowCount(), (String)"Error populating mini table");
        charge.createAccount((IMiniTable)minitable);
        String created = charge.getCreatedAccountNames();
        Assertions.assertTrue((created == null || created.length() == 0 ? 1 : 0) != 0, (String)"Unexpected create of charge record");
        minitable.setValueAt((Object)Boolean.TRUE, 0, Charge.EColumn.SELECT.index());
        minitable.setValueAt((Object)Boolean.TRUE, 1, Charge.EColumn.SELECT.index());
        charge.createAccount((IMiniTable)minitable);
        created = charge.getCreatedAccountNames();
        Assertions.assertTrue((created != null && created.length() > 0 ? 1 : 0) != 0, (String)"Failed to create Charge record from Account Element ");
        String[] splited = created.split("[,]");
        Assertions.assertEquals((int)2, (int)splited.length, (String)"Unexpected number of charge records created");
        Assertions.assertFalse((boolean)((Boolean)minitable.getValueAt(0, Charge.EColumn.SELECT.index())), (String)"Selection of first row not reset after create");
        Assertions.assertFalse((boolean)((Boolean)minitable.getValueAt(1, Charge.EColumn.SELECT.index())), (String)"Selection of second row not reset after create");
    }
}

