/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.compiere.apps.form.Allocation;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AllocationFormTest
extends AbstractTestCase {
    @Test
    public void testInvoiceAllocation1() {
        KeyNamePair knp;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MInvoice invoice = this.createCustomerInvoice(today, today, bpartner.getC_BPartner_ID(), DictionaryIDs.C_PaymentTerm.IMMEDIATE.id, DictionaryIDs.C_Tax.EXEMPT.id, Env.ONEHUNDRED);
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
        MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
        Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
        MPayment payment = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), today, usd.getC_Currency_ID(), 0, Env.ONEHUNDRED);
        pi = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        MiniTableImpl paymentTable = new MiniTableImpl();
        MiniTableImpl invoiceTable = new MiniTableImpl();
        boolean multiCurrency = false;
        Allocation allocation = new Allocation();
        allocation.setC_BPartner_ID(bpartner.get_ID());
        allocation.setC_Currency_ID(usd.get_ID());
        Vector paymentColumns = allocation.getPaymentColumnNames(multiCurrency);
        for (String column : paymentColumns) {
            paymentTable.addColumn(column);
        }
        allocation.setPaymentColumnClass((IMiniTable)paymentTable, multiCurrency);
        Vector invoiceColumns = allocation.getInvoiceColumnNames(multiCurrency);
        for (String column : invoiceColumns) {
            invoiceTable.addColumn(column);
        }
        allocation.setInvoiceColumnClass((IMiniTable)invoiceTable, multiCurrency);
        Vector paymentDatas = allocation.getPaymentData(multiCurrency, today, this.getTrxName());
        this.loadTable((IMiniTable)paymentTable, paymentDatas);
        Assertions.assertTrue((paymentTable.getRowCount() >= 1 ? 1 : 0) != 0, (String)"Failed to retrieve unallocated payment data");
        Vector invoiceDatas = allocation.getInvoiceData(multiCurrency, today, this.getTrxName());
        this.loadTable((IMiniTable)invoiceTable, invoiceDatas);
        Assertions.assertTrue((invoiceTable.getRowCount() >= 1 ? 1 : 0) != 0, (String)"Failed to retrieve unpaided invoice data");
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        int i = 0;
        while (i < paymentTable.getRowCount()) {
            knp = (KeyNamePair)paymentTable.getValueAt(i, 2);
            if (knp.getKey() == payment.get_ID()) {
                paymentTable.setValueAt((Object)Boolean.TRUE, i, 0);
                paymentTable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((paymentTable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to locate open payment created");
        allocation.writeOff(paymentTable.getSelectedRow(), 0, false, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, false);
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        Assertions.assertEquals((Object)payment.getPayAmt().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getPaymentAppliedTotal().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Payment Applied Total");
        Assertions.assertEquals((Object)payment.getPayAmt().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getTotalDifference().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Total Applied Difference");
        i = 0;
        while (i < invoiceTable.getRowCount()) {
            knp = (KeyNamePair)invoiceTable.getValueAt(i, 2);
            if (knp.getKey() == invoice.get_ID()) {
                invoiceTable.setValueAt((Object)Boolean.TRUE, i, 0);
                invoiceTable.setSelectedRow(i);
                invoiceTable.setValueAt((Object)new BigDecimal("0.00"), i, 5);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((invoiceTable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to locate open invoice created");
        allocation.writeOff(invoiceTable.getSelectedRow(), 0, true, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, false);
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getInvoiceAppliedTotal().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Invoice Applied Total");
        Assertions.assertEquals((Object)new BigDecimal("0.00"), (Object)allocation.getTotalDifference().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Total Applied Difference");
        Assertions.assertTrue((boolean)allocation.isOkToAllocate(), (String)("Invoice and payment applied total is different: " + allocation.getTotalDifference().toPlainString()));
        MAllocationHdr allocationHdr = allocation.saveData(0, today, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, this.getTrxName());
        Assertions.assertNotNull((Object)allocationHdr, (String)"Failed to create allocation header");
    }

    @Test
    public void testInvoiceAllocation2() {
        KeyNamePair knp;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        MInvoice invoice = this.createCustomerInvoice(today, today, bpartner.getC_BPartner_ID(), DictionaryIDs.C_PaymentTerm.IMMEDIATE.id, DictionaryIDs.C_Tax.EXEMPT.id, Env.ONEHUNDRED);
        ProcessInfo pi = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        MCurrency usd = MCurrency.get((int)DictionaryIDs.C_Currency.USD.id);
        String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
        MBankAccount ba = (MBankAccount)new Query(Env.getCtx(), "C_BankAccount", whereClause, this.getTrxName()).setParameters(new Object[]{Env.getAD_Org_ID((Properties)Env.getCtx()), usd.getC_Currency_ID()}).setOrderBy("IsDefault DESC").first();
        Assertions.assertTrue((ba != null ? 1 : 0) != 0, (String)"@NoAccountOrgCurrency@");
        MPayment payment = this.createReceiptPayment(bpartner.getC_BPartner_ID(), ba.getC_BankAccount_ID(), today, usd.getC_Currency_ID(), 0, Env.ONEHUNDRED);
        pi = MWorkflow.runDocumentActionWorkflow((PO)payment, (String)"CO");
        Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
        MiniTableImpl paymentTable = new MiniTableImpl();
        MiniTableImpl invoiceTable = new MiniTableImpl();
        boolean multiCurrency = true;
        Allocation allocation = new Allocation();
        allocation.setC_BPartner_ID(bpartner.get_ID());
        allocation.setC_Currency_ID(usd.get_ID());
        Vector paymentColumns = allocation.getPaymentColumnNames(multiCurrency);
        for (String column : paymentColumns) {
            paymentTable.addColumn(column);
        }
        allocation.setPaymentColumnClass((IMiniTable)paymentTable, multiCurrency);
        Vector invoiceColumns = allocation.getInvoiceColumnNames(multiCurrency);
        for (String column : invoiceColumns) {
            invoiceTable.addColumn(column);
        }
        allocation.setInvoiceColumnClass((IMiniTable)invoiceTable, multiCurrency);
        Vector paymentDatas = allocation.getPaymentData(multiCurrency, today, this.getTrxName());
        this.loadTable((IMiniTable)paymentTable, paymentDatas);
        Assertions.assertTrue((paymentTable.getRowCount() >= 1 ? 1 : 0) != 0, (String)"Failed to retrieve unallocated payment data");
        Vector invoiceDatas = allocation.getInvoiceData(multiCurrency, today, this.getTrxName());
        this.loadTable((IMiniTable)invoiceTable, invoiceDatas);
        Assertions.assertTrue((invoiceTable.getRowCount() >= 1 ? 1 : 0) != 0, (String)"Failed to retrieve unpaided invoice data");
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        int i = 0;
        while (i < paymentTable.getRowCount()) {
            knp = (KeyNamePair)paymentTable.getValueAt(i, 2);
            if (knp.getKey() == payment.get_ID()) {
                paymentTable.setValueAt((Object)Boolean.TRUE, i, 0);
                paymentTable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((paymentTable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to locate open payment created");
        allocation.writeOff(paymentTable.getSelectedRow(), 0, false, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, false);
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        Assertions.assertEquals((Object)payment.getPayAmt().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getPaymentAppliedTotal().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Payment Applied Total");
        Assertions.assertEquals((Object)payment.getPayAmt().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getTotalDifference().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Total Applied Difference");
        i = 0;
        while (i < invoiceTable.getRowCount()) {
            knp = (KeyNamePair)invoiceTable.getValueAt(i, 2);
            if (knp.getKey() == invoice.get_ID()) {
                invoiceTable.setValueAt((Object)Boolean.TRUE, i, 0);
                invoiceTable.setSelectedRow(i);
                invoiceTable.setValueAt((Object)new BigDecimal("0.00"), i, 7);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((invoiceTable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to locate open invoice created");
        allocation.writeOff(invoiceTable.getSelectedRow(), 0, true, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, false);
        allocation.calculate((IMiniTable)paymentTable, (IMiniTable)invoiceTable, multiCurrency);
        Assertions.assertEquals((Object)invoice.getGrandTotal().setScale(2, RoundingMode.HALF_UP), (Object)allocation.getInvoiceAppliedTotal().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Invoice Applied Total");
        Assertions.assertEquals((Object)new BigDecimal("0.00"), (Object)allocation.getTotalDifference().setScale(2, RoundingMode.HALF_UP), (String)"Unexpected Total Applied Difference");
        Assertions.assertTrue((boolean)allocation.isOkToAllocate(), (String)("Invoice and payment applied total is different: " + allocation.getTotalDifference().toPlainString()));
        MAllocationHdr allocationHdr = allocation.saveData(0, today, (IMiniTable)paymentTable, (IMiniTable)invoiceTable, this.getTrxName());
        Assertions.assertNotNull((Object)allocationHdr, (String)"Failed to create allocation header");
    }

    private void loadTable(IMiniTable miniTable, Vector<Vector<Object>> datas) {
        int row = 0;
        for (Vector<Object> data : datas) {
            miniTable.setRowCount(row + 1);
            int column = 0;
            for (Object value : data) {
                miniTable.setValueAt(value, row, column);
                ++column;
            }
            ++row;
        }
    }

    private MPayment createReceiptPayment(int C_BPartner_ID, int C_BankAccount_ID, Timestamp date, int C_Currency_ID, int C_ConversionType_ID, BigDecimal payAmt) {
        MPayment payment = new MPayment(Env.getCtx(), 0, this.getTrxName());
        payment.setC_BankAccount_ID(C_BankAccount_ID);
        payment.setC_DocType_ID(true);
        payment.setDateTrx(date);
        payment.setDateAcct(date);
        payment.setC_BPartner_ID(C_BPartner_ID);
        payment.setPayAmt(payAmt);
        payment.setC_Currency_ID(C_Currency_ID);
        payment.setC_ConversionType_ID(C_ConversionType_ID);
        payment.setTenderType("K");
        payment.setDocStatus("DR");
        payment.setDocAction("CO");
        payment.saveEx();
        return payment;
    }

    private MInvoice createCustomerInvoice(Timestamp dateinvoiced, Timestamp dateacct, int bpartnerid, int payterm, int taxid, BigDecimal totallines) {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setC_DocType_ID(DictionaryIDs.C_DocType.AR_INVOICE.id);
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_BPartner_ID(bpartnerid);
        invoice.setDateInvoiced(dateinvoiced);
        invoice.setDateAcct(dateacct);
        invoice.setC_PaymentTerm_ID(payterm);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(DictionaryIDs.C_Charge.FREIGHT.id);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(totallines);
        line1.setC_Tax_ID(taxid);
        line1.saveEx();
        return invoice;
    }
}

