/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.IAddressValidationFactory;
import org.adempiere.base.IBankStatementLoaderFactory;
import org.adempiere.base.IBankStatementMatcherFactory;
import org.adempiere.base.IModelValidatorFactory;
import org.adempiere.base.IPaymentExporterFactory;
import org.adempiere.base.IPaymentProcessorFactory;
import org.adempiere.base.IReplenishFactory;
import org.adempiere.base.IShipmentProcessorFactory;
import org.adempiere.base.ITaxProviderFactory;
import org.adempiere.base.MappedByNameFactory;
import org.adempiere.model.IAddressValidation;
import org.adempiere.model.IShipmentProcessor;
import org.adempiere.model.ITaxProvider;
import org.adempiere.model.MFreightShipmentProcessor;
import org.adempiere.model.MShipperFacade;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.impexp.BankStatementMatchInfo;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.model.MAddressTransaction;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MBankStatementLoader;
import org.compiere.model.MClient;
import org.compiere.model.MShipper;
import org.compiere.model.MTable;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.PaymentInterface;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.StandardTaxProvider;
import org.compiere.model.X_C_AddressValidationCfg;
import org.compiere.model.X_C_TaxProviderCfg;
import org.compiere.model.X_I_BankStatement;
import org.compiere.model.X_T_Replenish;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.GenericPaymentExport;
import org.compiere.util.PaymentExport;
import org.compiere.util.ReplenishInterface;
import org.idempiere.fa.service.api.DepreciationDTO;
import org.idempiere.fa.service.api.DepreciationFactoryLookupDTO;
import org.idempiere.fa.service.api.IDepreciationMethod;
import org.idempiere.fa.service.api.IDepreciationMethodFactory;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.TestActivator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class MappedByNameFactoryTest
extends AbstractTestCase {
    @Test
    public void testModelValidatorFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IModelValidatorFactory.class, (Object)new MyModelValidatorFactory(), properties);
        ModelValidator validator = Core.getModelValidator((String)MyModelValidator.class.getName());
        Assertions.assertNotNull((Object)validator);
        Assertions.assertTrue((boolean)(validator instanceof MyModelValidator), (String)("validator not instanceof MyModelValidator. validator=" + validator.getClass().getName()));
    }

    @Test
    public void testPaymentProcessorFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        ServiceRegistration registration = bc.registerService(IPaymentProcessorFactory.class, (Object)new MyPaymentProcessFactory(), properties);
        CacheMgt.get().reset("_IPaymentProcessorFactory_Cache");
        PaymentInterface mp = null;
        Query query = new Query(Env.getCtx(), "C_BankAccount_Processor", MTable.getUUIDColumnName((String)"C_BankAccount_Processor") + "=?", null);
        MBankAccountProcessor mbap = (MBankAccountProcessor)query.setParameters(new Object[]{"f4a64026-bf68-4c8c-b238-8cdf006aae04"}).first();
        PaymentProcessor pp = Core.getPaymentProcessor((MBankAccountProcessor)mbap, mp);
        Assertions.assertNotNull((Object)pp);
        Assertions.assertTrue((boolean)(pp instanceof MyPaymentProcessor), (String)("pp not instanceof MyPaymentProcessor. pp=" + pp.getClass().getName()));
        registration.unregister();
    }

    @Test
    public void testBankStatementLoaderFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IBankStatementLoaderFactory.class, (Object)new MyBankStatementLoaderFactory(), properties);
        BankStatementLoaderInterface loader = Core.getBankStatementLoader((String)MyBankStatementLoader.class.getName());
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyBankStatementLoader), (String)("loader not instanceof MyBankStatementLoader. loader=" + loader.getClass().getName()));
    }

    @Test
    public void testBankStatementMatcherFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IBankStatementMatcherFactory.class, (Object)new MyBankStatementMatcherFactory(), properties);
        BankStatementMatcherInterface loader = Core.getBankStatementMatcher((String)MyBankStatementMatcher.class.getName());
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyBankStatementMatcher), (String)("loader not instanceof MyBankStatementMatcher. loader=" + loader.getClass().getName()));
    }

    @Test
    public void testShipmentProcessorFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        ServiceRegistration sr = bc.registerService(IShipmentProcessorFactory.class, (Object)new MyShipmentProcessorFactory(), properties);
        CacheMgt.get().reset("_IShipmentProcessorFactory_Cache");
        MShipper shipper = new MShipper(Env.getCtx(), 100, this.getTrxName());
        MShipperFacade sf = new MShipperFacade(shipper);
        IShipmentProcessor loader = Core.getShipmentProcessor((MShipperFacade)sf);
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyShipmentProcessor), (String)("loader not instanceof MyShipmentProcessor. loader=" + loader.getClass().getName()));
        sr.unregister();
    }

    @Test
    public void testAddressVallidationFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        ServiceRegistration sr = bc.registerService(IAddressValidationFactory.class, (Object)new MyAddressValidationFactory(), properties);
        X_C_AddressValidationCfg cfg = new X_C_AddressValidationCfg(Env.getCtx(), 0, this.getTrxName());
        cfg.setAddressValidationClass(MyAddressValidation.class.getName());
        cfg.setHostAddress("localhost");
        cfg.setHostPort(8080);
        cfg.setName("testAddressVallidation cfg");
        cfg.saveEx();
        MAddressValidation adv = new MAddressValidation(Env.getCtx(), 0, this.getTrxName());
        adv.setC_AddressValidationCfg_ID(cfg.get_ID());
        adv.setUserID("test");
        adv.setConnectionPassword("test01");
        adv.setSeqNo(10);
        adv.setName("testAddressVallidation");
        IAddressValidation loader = Core.getAddressValidation((MAddressValidation)adv);
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyAddressValidation), (String)("loader not instanceof MyAddressValidation. loader=" + loader.getClass().getName()));
        sr.unregister();
    }

    @Test
    public void testTaxProviderFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        ServiceRegistration sr = bc.registerService(ITaxProviderFactory.class, (Object)new MyTaxProviderFactory(), properties);
        X_C_TaxProviderCfg cfg = new X_C_TaxProviderCfg(Env.getCtx(), 0, this.getTrxName());
        cfg.setName("testTaxProviderFactory cfg");
        cfg.setTaxProviderClass("MyTaxProvider");
        cfg.saveEx();
        MTaxProvider tp = new MTaxProvider(Env.getCtx(), 0, this.getTrxName());
        tp.setName("testTaxProviderFactory");
        tp.setC_TaxProviderCfg_ID(cfg.get_ID());
        tp.saveEx();
        ITaxProvider loader = Core.getTaxProvider((MTaxProvider)tp);
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyTaxProvider), (String)("loader not instanceof MyTaxProvider. loader=" + loader.getClass().getName()));
        sr.unregister();
    }

    @Test
    public void testReplenishFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IReplenishFactory.class, (Object)new MyReplenishInterfaceFactory(), properties);
        ReplenishInterface loader = Core.getReplenish((String)MyReplenishInterface.class.getName());
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyReplenishInterface), (String)("loader not instanceof MyReplenishInterface. loader=" + loader.getClass().getName()));
    }

    @Test
    public void testPaymentExporterFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IPaymentExporterFactory.class, (Object)new MyPaymentExportFactory(), properties);
        PaymentExport loader = Core.getPaymentExporter((String)MyPaymentExport.class.getName());
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyPaymentExport), (String)("loader not instanceof MyPaymentExport loader=" + loader.getClass().getName()));
    }

    @Test
    public void testDepreciationMethodFactory() {
        BundleContext bc = TestActivator.context;
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        ((Dictionary)properties).put("service.ranking", 1);
        bc.registerService(IDepreciationMethodFactory.class, (Object)new MyDepreciationMethodFactory(), properties);
        DepreciationFactoryLookupDTO dto = new DepreciationFactoryLookupDTO();
        dto.depreciationType = "MyDepreciationMethod";
        IDepreciationMethod loader = Core.getDepreciationMethod((DepreciationFactoryLookupDTO)dto);
        Assertions.assertNotNull((Object)loader);
        Assertions.assertTrue((boolean)(loader instanceof MyDepreciationMethod), (String)("loader not instanceof MyDepreciationMethod. loader=" + loader.getClass().getName()));
    }

    private static final class MyAddressValidation
    implements IAddressValidation {
        private MyAddressValidation() {
        }

        public boolean onlineValidate(Properties ctx, MAddressTransaction addressTransaction, String trxName) {
            return false;
        }
    }

    private static final class MyAddressValidationFactory
    extends MappedByNameFactory<IAddressValidation>
    implements IAddressValidationFactory {
        public MyAddressValidationFactory() {
            this.addMapping(MyAddressValidation.class.getName(), () -> new MyAddressValidation());
        }

        public IAddressValidation newAddressValidationInstance(String className) {
            return (IAddressValidation)this.newInstance(className);
        }
    }

    private static final class MyBankStatementLoader
    implements BankStatementLoaderInterface {
        private MyBankStatementLoader() {
        }

        public boolean init(MBankStatementLoader controller) {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public boolean loadLines() {
            return false;
        }

        public String getLastErrorMessage() {
            return null;
        }

        public String getLastErrorDescription() {
            return null;
        }

        public Timestamp getDateLastRun() {
            return null;
        }

        public String getRoutingNo() {
            return null;
        }

        public String getBankAccountNo() {
            return null;
        }

        public String getIBAN() {
            return null;
        }

        public String getStatementReference() {
            return null;
        }

        public Timestamp getStatementDate() {
            return null;
        }

        public String getTrxID() {
            return null;
        }

        public String getReference() {
            return null;
        }

        public String getCheckNo() {
            return null;
        }

        public String getPayeeName() {
            return null;
        }

        public String getPayeeAccountNo() {
            return null;
        }

        public Timestamp getStatementLineDate() {
            return null;
        }

        public Timestamp getValutaDate() {
            return null;
        }

        public String getTrxType() {
            return null;
        }

        public boolean getIsReversal() {
            return false;
        }

        public String getCurrency() {
            return null;
        }

        public BigDecimal getStmtAmt() {
            return null;
        }

        public BigDecimal getTrxAmt() {
            return null;
        }

        public BigDecimal getInterestAmt() {
            return null;
        }

        public String getMemo() {
            return null;
        }

        public String getChargeName() {
            return null;
        }

        public BigDecimal getChargeAmt() {
            return null;
        }
    }

    private static final class MyBankStatementLoaderFactory
    extends MappedByNameFactory<BankStatementLoaderInterface>
    implements IBankStatementLoaderFactory {
        public MyBankStatementLoaderFactory() {
            this.addMapping(MyBankStatementLoader.class.getName(), () -> new MyBankStatementLoader());
        }

        public BankStatementLoaderInterface newBankStatementLoaderInstance(String className) {
            return (BankStatementLoaderInterface)this.newInstance(className);
        }
    }

    private static final class MyBankStatementMatcher
    implements BankStatementMatcherInterface {
        private MyBankStatementMatcher() {
        }

        public BankStatementMatchInfo findMatch(MBankStatementLine bsl) {
            return null;
        }

        public BankStatementMatchInfo findMatch(X_I_BankStatement ibs) {
            return null;
        }
    }

    private static final class MyBankStatementMatcherFactory
    extends MappedByNameFactory<BankStatementMatcherInterface>
    implements IBankStatementMatcherFactory {
        public MyBankStatementMatcherFactory() {
            this.addMapping(MyBankStatementMatcher.class.getName(), () -> new MyBankStatementMatcher());
        }

        public BankStatementMatcherInterface newBankStatementMatcherInstance(String className) {
            return (BankStatementMatcherInterface)this.newInstance(className);
        }
    }

    private static final class MyDepreciationMethod
    implements IDepreciationMethod {
        private MyDepreciationMethod() {
        }

        public BigDecimal caclulateDepreciation(DepreciationDTO depreciationDTO) {
            return null;
        }

        public long getCountPeriod(DepreciationDTO depreciationDTO) {
            return 0L;
        }

        public boolean isPeriodAdjustment() {
            return false;
        }
    }

    private static final class MyDepreciationMethodFactory
    extends MappedByNameFactory<IDepreciationMethod>
    implements IDepreciationMethodFactory {
        public MyDepreciationMethodFactory() {
            this.addMapping("MyDepreciationMethod", () -> new MyDepreciationMethod());
        }

        public IDepreciationMethod getDepreciationMethod(DepreciationFactoryLookupDTO factoryLookupDTO) {
            return (IDepreciationMethod)this.newInstance(factoryLookupDTO.depreciationType);
        }
    }

    private static final class MyModelValidator
    implements ModelValidator {
        private MyModelValidator() {
        }

        public void initialize(ModelValidationEngine engine, MClient client) {
        }

        public int getAD_Client_ID() {
            return 0;
        }

        public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
            return null;
        }

        public String modelChange(PO po, int type) throws Exception {
            return null;
        }

        public String docValidate(PO po, int timing) {
            return null;
        }
    }

    private static final class MyModelValidatorFactory
    extends MappedByNameFactory<ModelValidator>
    implements IModelValidatorFactory {
        public MyModelValidatorFactory() {
            this.addMapping(MyModelValidator.class.getName(), () -> new MyModelValidator());
        }

        public ModelValidator newModelValidatorInstance(String className) {
            return (ModelValidator)this.newInstance(className);
        }
    }

    private static final class MyPaymentExport
    extends GenericPaymentExport {
        private MyPaymentExport() {
        }
    }

    private static final class MyPaymentExportFactory
    extends MappedByNameFactory<PaymentExport>
    implements IPaymentExporterFactory {
        public MyPaymentExportFactory() {
            this.addMapping(MyPaymentExport.class.getName(), () -> new MyPaymentExport());
        }

        public PaymentExport newPaymentExporterInstance(String className) {
            return (PaymentExport)this.newInstance(className);
        }
    }

    private static final class MyPaymentProcessFactory
    extends MappedByNameFactory<PaymentProcessor>
    implements IPaymentProcessorFactory {
        public MyPaymentProcessFactory() {
            this.addMapping("org.compiere.model.PP_PayFlowPro", () -> new MyPaymentProcessor());
        }

        public PaymentProcessor newPaymentProcessorInstance(String className) {
            return (PaymentProcessor)this.newInstance(className);
        }
    }

    private static final class MyPaymentProcessor
    extends PaymentProcessor {
        private MyPaymentProcessor() {
        }

        public boolean processCC() throws IllegalArgumentException {
            return false;
        }

        public boolean isProcessedOK() {
            return false;
        }
    }

    private static final class MyReplenishInterface
    implements ReplenishInterface {
        private MyReplenishInterface() {
        }

        public BigDecimal getQtyToOrder(MWarehouse wh, X_T_Replenish replenish) {
            return null;
        }
    }

    private static final class MyReplenishInterfaceFactory
    extends MappedByNameFactory<MyReplenishInterface>
    implements IReplenishFactory {
        public MyReplenishInterfaceFactory() {
            this.addMapping(MyReplenishInterface.class.getName(), () -> new MyReplenishInterface());
        }

        public ReplenishInterface newReplenishInstance(String className) {
            return (ReplenishInterface)this.newInstance(className);
        }
    }

    private static final class MyShipmentProcessor
    extends MFreightShipmentProcessor {
        private MyShipmentProcessor() {
        }
    }

    private static final class MyShipmentProcessorFactory
    extends MappedByNameFactory<IShipmentProcessor>
    implements IShipmentProcessorFactory {
        public MyShipmentProcessorFactory() {
            this.addMapping("org.adempiere.model.MFreightShipmentProcessor", () -> new MyShipmentProcessor());
        }

        public IShipmentProcessor newShipmentProcessorInstance(String className) {
            return (IShipmentProcessor)this.newInstance(className);
        }
    }

    private static final class MyTaxProvider
    extends StandardTaxProvider {
        private MyTaxProvider() {
        }
    }

    private static final class MyTaxProviderFactory
    extends MappedByNameFactory<ITaxProvider>
    implements ITaxProviderFactory {
        public MyTaxProviderFactory() {
            this.addMapping("MyTaxProvider", () -> new MyTaxProvider());
        }

        public ITaxProvider newTaxProviderInstance(String className) {
            return (ITaxProvider)this.newInstance(className);
        }
    }
}

