/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.eevolution.model.MPPProductBOMLine;
import org.idempiere.apps.form.BOMDrop;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BOMDropFormTest
extends AbstractTestCase {
    @Test
    public void testDropToOrder() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        order.setBPartner(bp);
        order.setC_DocTypeTarget_ID("SO");
        order.saveEx();
        BOMDrop bomDrop = new BOMDrop();
        KeyNamePair[] orders = bomDrop.getDraftOrders(this.getTrxName());
        boolean found = false;
        KeyNamePair[] keyNamePairArray = orders;
        int n = orders.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair knp = keyNamePairArray[n2];
            if (knp.getKey() == order.get_ID()) {
                found = true;
                break;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)found, (String)"Failed to retrieve open draft order");
        MProduct product = MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id);
        MPPProductBOMLine[] bomLines = bomDrop.getBOMLine(product);
        Assertions.assertTrue((bomLines.length > 0 ? 1 : 0) != 0, (String)("Failed to retrieve BOM lines for " + product.toString()));
        ArrayList selectedItems = new ArrayList();
        ArrayList selectedParent = new ArrayList();
        HashMap variantMap = new HashMap();
        bomDrop.addBOMLines(product, new BigDecimal("1"), b -> {
            String key;
            MProduct component = b.getProductBOMLine().getProduct();
            if ("VA".equals(b.getBOMType())) {
                if (variantMap.containsKey(b.getBOMLevel())) {
                    return;
                }
                variantMap.put(b.getBOMLevel(), component.get_ID());
            } else if (variantMap.containsKey(b.getBOMLevel())) {
                variantMap.remove(b.getBOMLevel());
            }
            if (b.getBOMLevel() > 0 && !selectedParent.contains(key = b.getParentProduct().get_ID() + "_" + (b.getBOMLevel() - 1))) {
                return;
            }
            if (component.isBOM() && component.isVerified()) {
                key = component.get_ID() + "_" + b.getBOMLevel();
                selectedParent.add(key);
                return;
            }
            BOMDrop.SelectedItem si = new BOMDrop.SelectedItem(component.get_ID(), b.getLineQty());
            selectedItems.add(si);
        });
        Assertions.assertEquals((int)8, (int)selectedItems.size(), (String)"Unexpected number of components");
        int priceListId = order.getM_PriceList_ID();
        MPriceListVersion priceListVersion = MPriceList.get((int)priceListId).getPriceListVersion(null);
        for (BOMDrop.SelectedItem selectedItem : selectedItems) {
            MProductPrice pp = MProductPrice.get((Properties)Env.getCtx(), (int)priceListVersion.get_ID(), (int)selectedItem.getM_Product_ID(), (String)this.getTrxName());
            if (pp != null) continue;
            pp = new MProductPrice(Env.getCtx(), 0, this.getTrxName());
            pp.setM_PriceList_Version_ID(priceListVersion.get_ID());
            pp.setM_Product_ID(selectedItem.getM_Product_ID());
            pp.setPrices(new BigDecimal("1"), new BigDecimal("1"), BigDecimal.ZERO);
            pp.saveEx();
        }
        bomDrop.saveOrderLines(order.getC_Order_ID(), selectedItems, this.getTrxName());
        order.load(this.getTrxName(), new String[0]);
        MOrderLine[] orderLines = order.getLines(true, null);
        Assertions.assertEquals((int)selectedItems.size(), (int)orderLines.length, (String)"Unexpected number of order lines");
    }

    @Test
    public void testDropToInvoice() {
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        invoice.setBPartner(bp);
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.saveEx();
        BOMDrop bomDrop = new BOMDrop();
        KeyNamePair[] invoices = bomDrop.getDraftInvoices(this.getTrxName());
        boolean found = false;
        KeyNamePair[] keyNamePairArray = invoices;
        int n = invoices.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair knp = keyNamePairArray[n2];
            if (knp.getKey() == invoice.get_ID()) {
                found = true;
                break;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)found, (String)"Failed to retrieve open draft invoice");
        MProduct product = MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id);
        MPPProductBOMLine[] bomLines = bomDrop.getBOMLine(product);
        Assertions.assertTrue((bomLines.length > 0 ? 1 : 0) != 0, (String)("Failed to retrieve BOM lines for " + product.toString()));
        ArrayList selectedItems = new ArrayList();
        ArrayList selectedParent = new ArrayList();
        HashMap variantMap = new HashMap();
        bomDrop.addBOMLines(product, new BigDecimal("1"), b -> {
            String key;
            MProduct component = b.getProductBOMLine().getProduct();
            if ("VA".equals(b.getBOMType())) {
                if (variantMap.containsKey(b.getBOMLevel())) {
                    return;
                }
                variantMap.put(b.getBOMLevel(), component.get_ID());
            } else if (variantMap.containsKey(b.getBOMLevel())) {
                variantMap.remove(b.getBOMLevel());
            }
            if (b.getBOMLevel() > 0 && !selectedParent.contains(key = b.getParentProduct().get_ID() + "_" + (b.getBOMLevel() - 1))) {
                return;
            }
            if (component.isBOM() && component.isVerified()) {
                key = component.get_ID() + "_" + b.getBOMLevel();
                selectedParent.add(key);
                return;
            }
            BOMDrop.SelectedItem si = new BOMDrop.SelectedItem(component.get_ID(), b.getLineQty());
            selectedItems.add(si);
        });
        Assertions.assertEquals((int)8, (int)selectedItems.size(), (String)"Unexpected number of components");
        bomDrop.saveInvoiceLines(invoice.get_ID(), selectedItems, this.getTrxName());
        invoice.load(this.getTrxName(), new String[0]);
        MInvoiceLine[] invoiceLines = invoice.getLines(true);
        Assertions.assertEquals((int)selectedItems.size(), (int)invoiceLines.length, (String)"Unexpected number of invoice lines");
    }

    @Test
    public void testDropToProject() {
        MProject project = new MProject(Env.getCtx(), 0, this.getTrxName());
        MBPartner bp = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        project.setC_BPartner_ID(bp.get_ID());
        project.setName("testDropToProject");
        project.setC_Currency_ID(DictionaryIDs.C_Currency.USD.id);
        project.saveEx();
        BOMDrop bomDrop = new BOMDrop();
        KeyNamePair[] projects = bomDrop.getNonServiceProjects(this.getTrxName());
        boolean found = false;
        KeyNamePair[] keyNamePairArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair knp = keyNamePairArray[n2];
            if (knp.getKey() == project.get_ID()) {
                found = true;
                break;
            }
            ++n2;
        }
        Assertions.assertTrue((boolean)found, (String)"Failed to retrieve open non service project");
        MProduct product = MProduct.get((int)DictionaryIDs.M_Product.P_CHAIR.id);
        MPPProductBOMLine[] bomLines = bomDrop.getBOMLine(product);
        Assertions.assertTrue((bomLines.length > 0 ? 1 : 0) != 0, (String)("Failed to retrieve BOM lines for " + product.toString()));
        ArrayList selectedItems = new ArrayList();
        ArrayList selectedParent = new ArrayList();
        HashMap variantMap = new HashMap();
        bomDrop.addBOMLines(product, new BigDecimal("1"), b -> {
            String key;
            MProduct component = b.getProductBOMLine().getProduct();
            if ("VA".equals(b.getBOMType())) {
                if (variantMap.containsKey(b.getBOMLevel())) {
                    return;
                }
                variantMap.put(b.getBOMLevel(), component.get_ID());
            } else if (variantMap.containsKey(b.getBOMLevel())) {
                variantMap.remove(b.getBOMLevel());
            }
            if (b.getBOMLevel() > 0 && !selectedParent.contains(key = b.getParentProduct().get_ID() + "_" + (b.getBOMLevel() - 1))) {
                return;
            }
            if (component.isBOM() && component.isVerified()) {
                key = component.get_ID() + "_" + b.getBOMLevel();
                selectedParent.add(key);
                return;
            }
            BOMDrop.SelectedItem si = new BOMDrop.SelectedItem(component.get_ID(), b.getLineQty());
            selectedItems.add(si);
        });
        Assertions.assertEquals((int)8, (int)selectedItems.size(), (String)"Unexpected number of components");
        bomDrop.saveProjectLines(project.get_ID(), selectedItems, this.getTrxName());
        project.load(this.getTrxName(), new String[0]);
        MProjectLine[] projectLines = project.getLines();
        Assertions.assertEquals((int)selectedItems.size(), (int)projectLines.length, (String)"Unexpected number of project lines");
    }
}

