/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.tablepartition.process;

import java.util.List;
import java.util.Properties;
import org.adempiere.base.annotation.Process;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.tablepartition.TablePartitionTask;

@Process
public class CreatePartition
extends SvrProcess {
    private int p_record_ID = 0;
    private String p_partitioningMethod = null;
    private String p_tableName = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PartitioningMethod")) {
                    this.p_partitioningMethod = para[i].getParameterAsString();
                } else if (name.equals("TableName")) {
                    this.p_tableName = para[i].getParameterAsString();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_record_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        ITablePartitionService service = DB.getDatabase().getTablePartitionService();
        if (service == null) {
            return "@Error@ " + Msg.getMsg((Properties)this.getCtx(), (String)"DBAdapterNoTablePartitionSupport");
        }
        int successCount = 0;
        int errorCount = 0;
        if (this.p_record_ID > 0) {
            MTable table = new MTable(Env.getCtx(), this.p_record_ID, null);
            TablePartitionTask tp = new TablePartitionTask(table, this.getProcessInfo(), service);
            boolean success = tp.executeTask();
            if (success) {
                ++successCount;
            } else {
                ++errorCount;
            }
        } else {
            Object whereClause = "IsPartition='Y' AND IsView='N'";
            if (this.p_tableName != null) {
                whereClause = (String)whereClause + " AND TableName LIKE '" + this.p_tableName + "'";
            }
            List tables = new Query(this.getCtx(), "AD_Table", (String)whereClause, null).setOnlyActiveRecords(true).setOrderBy("TableName").list();
            for (MTable table : tables) {
                List partitionKeyColumns = table.getPartitionKeyColumns(true);
                if (partitionKeyColumns.isEmpty() || this.p_partitioningMethod != null && !this.p_partitioningMethod.equals(((MColumn)partitionKeyColumns.get(0)).getPartitioningMethod())) continue;
                TablePartitionTask tp = new TablePartitionTask(table, this.getProcessInfo(), service);
                boolean success = tp.executeTask();
                if (success) {
                    ++successCount;
                    continue;
                }
                ++errorCount;
            }
        }
        return Msg.getMsg((Properties)Env.getCtx(), (String)"Updated") + ": " + successCount + ", " + Msg.getMsg((Properties)Env.getCtx(), (String)"Error") + errorCount;
    }
}

