/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.core.search.matching.VariablePattern;
import org.eclipse.jdt.internal.core.util.Util;

public class LocalVariablePattern
extends VariablePattern {
    LocalVariable localVariable;

    public LocalVariablePattern(LocalVariable localVariable, int limitTo, int matchRule) {
        super(512, localVariable.getElementName().toCharArray(), limitTo, matchRule);
        this.localVariable = localVariable;
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        Object documentPath;
        Object relativePath;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.localVariable.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.localVariable.getAncestor(7);
            relativePath = type.getFullyQualifiedName('$').replace('.', '/') + ".class";
            IModuleDescription md = root.getModuleDescription();
            if (md != null) {
                String module = md.getElementName();
                documentPath = String.valueOf(root.getPath()) + "|" + module + "|" + (String)relativePath;
            } else {
                documentPath = String.valueOf(root.getPath()) + "|" + (String)relativePath;
            }
        } else {
            IPath path = this.localVariable.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet((String)relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch((String)documentPath, this, participant, access) : scope.encloses((String)documentPath) && !requestor.acceptIndexMatch((String)documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor progressMonitor) {
        this.findIndexMatches(index, requestor, participant, scope, progressMonitor);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            output.append("LocalVarReferencePattern: ");
        }
        output.append(this.localVariable.toStringWithAncestors());
        return super.print(output);
    }
}

