/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.paranamer;

import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.zkoss.bind.paranamer.Paranamer;

public class CachingParanamer
implements Paranamer {
    private final Paranamer delegate;
    private final Map<AccessibleObject, String[]> methodCache = this.makeMethodCache();

    protected Map<AccessibleObject, String[]> makeMethodCache() {
        return Collections.synchronizedMap(new WeakHashMap());
    }

    public CachingParanamer(Paranamer delegate) {
        this.delegate = delegate;
    }

    @Override
    public String[] lookupParameterNames(AccessibleObject methodOrConstructor) {
        return this.lookupParameterNames(methodOrConstructor, true);
    }

    @Override
    public String[] lookupParameterNames(AccessibleObject methodOrCtor, boolean throwExceptionIfMissing) {
        String[] names = this.methodCache.get(methodOrCtor);
        if (names == null) {
            names = this.delegate.lookupParameterNames(methodOrCtor, throwExceptionIfMissing);
            this.methodCache.put(methodOrCtor, names);
        }
        return names;
    }

    public static class WithoutWeakReferences
    extends CachingParanamer {
        public WithoutWeakReferences(Paranamer delegate) {
            super(delegate);
        }

        @Override
        protected Map<AccessibleObject, String[]> makeMethodCache() {
            return new ConcurrentHashMap<AccessibleObject, String[]>();
        }
    }
}

