/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Generics;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Event;

public class SelectEvent<T extends Component, E>
extends Event {
    private final Set<T> _selectedItems;
    private final Set<T> _prevSelectedItems;
    private final Set<T> _unselectedItems;
    private final Set<E> _prevSelectedObjects;
    private final Set<E> _selectedObjects;
    private final Set<E> _unselectedObjects;
    private final T _ref;
    private final int _keys;
    public static final int ALT_KEY = 1;
    public static final int CTRL_KEY = 2;
    public static final int SHIFT_KEY = 4;

    public static final <T extends Component, E> SelectEvent<T, E> getSelectEvent(AuRequest request) {
        return SelectEvent.getSelectEvent(request, null);
    }

    public static final <T extends Component, E> SelectEvent<T, E> getSelectEvent(AuRequest request, SelectedObjectHandler<T> handler) {
        Map<String, Object> data = request.getData();
        Desktop desktop = request.getDesktop();
        List sitems = Generics.cast((List)((List)data.get("items")));
        Set items = AuRequests.convertToItems(desktop, sitems);
        Set<T> prevSelectedItems = handler == null ? null : handler.getPreviousSelectedItems();
        Set<T> unselectedItems = handler == null ? null : handler.getUnselectedItems();
        Set<Object> prevSelectedObjects = handler == null ? null : handler.getPreviousSelectedObjects();
        Set<Object> unselectedObjects = handler == null ? null : handler.getUnselectedObjects();
        Set<Object> objs = handler == null ? null : handler.getObjects(items);
        return new SelectEvent<Component, Object>(request.getCommand(), request.getComponent(), items, prevSelectedItems, unselectedItems, objs, prevSelectedObjects, unselectedObjects, desktop.getComponentByUuidIfAny((String)data.get("reference")), null, AuRequests.parseKeys(data));
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems) {
        this(name, target, selectedItems, null, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref) {
        this(name, target, selectedItems, ref, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref, int keys) {
        this(name, target, selectedItems, null, null, null, null, null, ref, null, keys);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, Set<T> previousSelectedItems, Set<T> unselectedItems, Set<E> selectedObjects, Set<E> prevSelectedObjects, Set<E> unselectedObjects, T ref, Object data, int keys) {
        super(name, target, data);
        this._selectedItems = selectedItems != null ? selectedItems : Collections.emptySet();
        this._prevSelectedItems = previousSelectedItems != null ? previousSelectedItems : Collections.emptySet();
        this._unselectedItems = unselectedItems != null ? unselectedItems : Collections.emptySet();
        this._selectedObjects = selectedObjects != null ? selectedObjects : Collections.emptySet();
        this._prevSelectedObjects = prevSelectedObjects != null ? prevSelectedObjects : Collections.emptySet();
        this._unselectedObjects = unselectedObjects != null ? unselectedObjects : Collections.emptySet();
        this._ref = ref;
        this._keys = keys;
    }

    public final Set<T> getSelectedItems() {
        return this._selectedItems;
    }

    public final Set<T> getPreviousSelectedItems() {
        return this._prevSelectedItems;
    }

    public final Set<E> getPreviousSelectedObjects() {
        return this._prevSelectedObjects;
    }

    public final Set<T> getUnselectedItems() {
        return this._unselectedItems;
    }

    public final Set<E> getUnselectedObjects() {
        return this._unselectedObjects;
    }

    public final Set<E> getSelectedObjects() {
        return this._selectedObjects;
    }

    public T getReference() {
        return this._ref;
    }

    public final int getKeys() {
        return this._keys;
    }

    public static interface SelectedObjectHandler<T extends Component> {
        public Set<Object> getObjects(Set<T> var1);

        public Set<T> getPreviousSelectedItems();

        public Set<T> getUnselectedItems();

        public Set<Object> getPreviousSelectedObjects();

        public Set<Object> getUnselectedObjects();
    }
}

