/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.impl.AbstractAutoFilterAdv;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.util.Validations;
import io.keikai.range.impl.FilterRowInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;

public class AutoFilterImpl
extends AbstractAutoFilterAdv {
    private static final long serialVersionUID = 1L;
    private final CellRegion _region;
    private final TreeMap<Integer, SAutoFilter.NFilterColumn> _columns;
    private Map<Integer, List<FilterRowInfo>> orderedRowInfosMap;
    private Map<Integer, Integer> filterTypes;

    public AutoFilterImpl(CellRegion region) {
        this._region = region;
        this._columns = new TreeMap();
        this.orderedRowInfosMap = new HashMap<Integer, List<FilterRowInfo>>();
        this.filterTypes = new HashMap<Integer, Integer>();
    }

    @Override
    public CellRegion getRegion() {
        return this._region;
    }

    @Override
    public Collection<SAutoFilter.NFilterColumn> getFilterColumns() {
        return Collections.unmodifiableCollection(this._columns.values());
    }

    @Override
    public SAutoFilter.NFilterColumn getFilterColumn(int index, boolean create) {
        SAutoFilter.NFilterColumn col = this._columns.get(index);
        if (col == null && create) {
            int s = this._region.getLastColumn() - this._region.getColumn() + 1;
            if (index >= s) {
                throw new IllegalStateException("the column index " + index + " >= " + s);
            }
            col = new AbstractAutoFilterAdv.FilterColumnImpl(index);
            this._columns.put(index, col);
        }
        return col;
    }

    @Override
    public void clearFilterColumn(int index) {
        this._columns.remove(index);
    }

    @Override
    public void clearFilterColumns() {
        this._columns.clear();
    }

    @Override
    public void renameSheet(SBook book, String oldName, String newName) {
        Validations.argNotNull(oldName);
        Validations.argNotNull(newName);
        if (oldName.equals(newName)) {
            return;
        }
        String bookName = book.getBookName();
        ObjectRefImpl dependent = new ObjectRefImpl(bookName, oldName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.clearDependents(dependent);
        dependent = new ObjectRefImpl(bookName, newName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        if (this._region != null) {
            RefImpl dummy = new RefImpl(bookName, newName, this._region.row, this._region.column, this._region.lastRow, this._region.lastColumn);
            dt.add(dependent, dummy);
        }
    }

    AutoFilterImpl cloneAutoFilterImpl() {
        return this.cloneAutofilterImpl(null);
    }

    AutoFilterImpl cloneAutofilterImpl(SBook book) {
        AutoFilterImpl tgt = new AutoFilterImpl(new CellRegion(this._region.row, this._region.column, this._region.lastRow, this._region.lastColumn));
        for (SAutoFilter.NFilterColumn value : this._columns.values()) {
            AbstractAutoFilterAdv.FilterColumnImpl srccol = (AbstractAutoFilterAdv.FilterColumnImpl)value;
            AbstractAutoFilterAdv.FilterColumnImpl tgtcol = srccol.cloneFilterColumnImpl(book);
            tgt._columns.put(tgtcol.getIndex(), tgtcol);
        }
        return tgt;
    }

    @Override
    public boolean isFiltered() {
        for (SAutoFilter.NFilterColumn value : this._columns.values()) {
            if (!value.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public void putFilterColumn(int index, SAutoFilter.NFilterColumn filterColumn) {
        this._columns.put(index, filterColumn);
    }

    public void setCachedSet(int index, SortedSet<FilterRowInfo> orderedRowInfos) {
        this.orderedRowInfosMap.put(index, (List<FilterRowInfo>)(orderedRowInfos == null ? null : new ArrayList<FilterRowInfo>(orderedRowInfos)));
    }

    public List<FilterRowInfo> getCachedSet(int index) {
        return this.orderedRowInfosMap.get(index);
    }

    public void setFilterType(int index, int type) {
        this.filterTypes.put(index, type);
    }

    public int getFilterType(int index) {
        return this.filterTypes.get(index);
    }
}

