

(function () {
	var ROWINC = 40,
		COLINC = 60,
		TIMEOUT = 100;
	
	function _autoScroll (sheet, ctrl) {
		var dir = ctrl.dir;
		if (dir && dir.length > 0) {
			var fn = function () {
				_autoScroll(sheet, ctrl);
			};
			setTimeout(fn, zss.AutoScrollCtrl.TIMEOUT);
		} else
			return;
		
		var spcmp = sheet.sp.comp,
			rowoff = coloff = 0;
		if (dir.indexOf("t") > -1)
			rowoff = -ROWINC;
		else if (dir.indexOf("b") > -1)
			rowoff = ROWINC;
	
		if (dir.indexOf("l") > -1)
			coloff = -COLINC;
		else if(dir.indexOf("r") > -1)
			coloff = COLINC;
		
		if (! (ctrl.dironly == zss.AutoScrollCtrl.COLONLY))
			spcmp.scrollTop += rowoff;
				
		if (! (ctrl.dironly == zss.AutoScrollCtrl.ROWONLY) && rowoff == 0 ){
			
			
			
			spcmp.scrollLeft += coloff;
	}
}

zss.AutoScrollCtrl = zk.$extends(zk.Object, {
	$init: function (sheet, dir, dironly) {
		this.$supers('$init', arguments);
		this.sheet = sheet;
		this.dir = dir;
		this.dironly = dironly;
		_autoScroll(sheet, this);
	},
	cleanup: function () {
		this.dir = "";
	},
	setDir: function(dir){
		this.dir = dir;
	},
	getDir: function(){
		return this.dir;
	}
}, {
	ROWONLY: 1,
	COLONLY: 2
});
})();