/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl.hazelcastdataconnection;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class HazelcastDataConnectionConfigLoader {
    private static final ILogger LOGGER = Logger.getLogger(HazelcastDataConnectionConfigLoader.class);

    public DataConnectionConfig load(DataConnectionConfig dataConnectionConfig) {
        DataConnectionConfig loadedConfig = new DataConnectionConfig(dataConnectionConfig);
        if (this.loadConfig(loadedConfig, "client_xml_path", "client_xml")) {
            return loadedConfig;
        }
        this.loadConfig(loadedConfig, "client_yml_path", "client_yml");
        return loadedConfig;
    }

    private boolean loadConfig(DataConnectionConfig dataConnectionConfig, String property, String propertyKey) {
        boolean result = false;
        String filePath = dataConnectionConfig.getProperty(property);
        if (!StringUtil.isNullOrEmpty(filePath)) {
            String fileContent = this.readFileContent(filePath);
            dataConnectionConfig.setProperty(propertyKey, fileContent);
            LOGGER.info("Successfully read file: " + filePath);
            result = true;
        }
        return result;
    }

    private String readFileContent(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            throw new HazelcastException("Unable to read file :" + filePath);
        }
    }
}

