/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.ElementAttributes;
import org.apache.ecs.GenericElement;
import org.apache.ecs.Printable;
import org.apache.ecs.StringElement;

public class ConcreteElement
extends ElementAttributes
implements Cloneable {
    private static final long serialVersionUID = -6348409634468876553L;
    public static final String NBSP = "&nbsp;";
    private Hashtable<String, Element> registry = new Hashtable(4);
    private Vector<String> registryList = new Vector(2);

    public ConcreteElement getElement(String element) {
        if (this.registry.containsKey(element)) {
            return (ConcreteElement)this.registry.get(element);
        }
        return null;
    }

    @Override
    public Element addElementToRegistry(Element element) {
        if (element == null) {
            return this;
        }
        int hc = element.hashCode();
        String s2 = Integer.toString(hc);
        this.addElementToRegistry(s2, element);
        return this;
    }

    public Element addElementToRegistry(String hashcode, Element element) {
        if (hashcode == null || element == null) {
            return this;
        }
        element.setFilterState(this.getFilterState());
        if (ECSDefaults.getDefaultPrettyPrint() != element.getPrettyPrint()) {
            element.setPrettyPrint(this.getPrettyPrint());
        }
        this.registry.put(hashcode, element);
        if (!this.registryList.contains(hashcode)) {
            this.registryList.addElement(hashcode);
        }
        return this;
    }

    public Element addElementToRegistry(Element element, boolean filter) {
        if (element == null) {
            return this;
        }
        this.setFilterState(filter);
        this.addElementToRegistry(Integer.toString(element.hashCode()), element);
        return this;
    }

    public Element addElementToRegistry(String hashcode, Element element, boolean filter) {
        if (hashcode == null) {
            return this;
        }
        this.setFilterState(filter);
        this.addElementToRegistry(hashcode, element);
        return this;
    }

    public Element addElementToRegistry(String value, boolean filter) {
        if (value == null) {
            return this;
        }
        this.setFilterState(filter);
        this.addElementToRegistry(Integer.toString(value.hashCode()), value);
        return this;
    }

    public Element addElementToRegistry(String hashcode, String value, boolean filter) {
        if (hashcode == null) {
            return this;
        }
        this.setFilterState(filter);
        this.addElementToRegistry(hashcode, value);
        return this;
    }

    @Override
    public Element addElementToRegistry(String value) {
        if (value == null) {
            return this;
        }
        this.addElementToRegistry(new StringElement(value));
        return this;
    }

    public Element addElementToRegistry(String hashcode, String value) {
        if (hashcode == null) {
            return this;
        }
        StringElement se = new StringElement(value);
        se.setFilterState(this.getFilterState());
        se.setFilter(this.getFilter());
        se.setPrettyPrint(this.getPrettyPrint());
        this.addElementToRegistry(hashcode, se);
        return this;
    }

    @Override
    public Element removeElementFromRegistry(Element element) {
        this.removeElementFromRegistry(Integer.toString(element.hashCode()));
        return this;
    }

    @Override
    public Element removeElementFromRegistry(String hashcode) {
        this.registry.remove(hashcode);
        this.registryList.removeElement(hashcode);
        return this;
    }

    @Override
    public boolean registryHasElement(Element element) {
        return this.registry.contains(element);
    }

    public Enumeration<String> keys() {
        return this.registryList.elements();
    }

    public Enumeration<Element> elements() {
        return this.registry.elements();
    }

    @Override
    public boolean registryHasElement(String hashcode) {
        return this.registry.containsKey(hashcode);
    }

    @Override
    public void output(OutputStream out) {
        boolean prettyPrint = this.getPrettyPrint();
        int tabLevel = this.getTabLevel();
        try {
            if (this.registry.size() == 0) {
                if (prettyPrint && this instanceof Printable && tabLevel > 0) {
                    this.putTabs(tabLevel, out);
                }
                super.output(out);
            } else {
                if (prettyPrint && this instanceof Printable && tabLevel > 0) {
                    this.putTabs(tabLevel, out);
                }
                out.write(this.createStartTag().getBytes());
                if (this.getTagText() != null) {
                    out.write(this.getTagText().getBytes());
                }
                Enumeration<String> en = this.registryList.elements();
                while (en.hasMoreElements()) {
                    Element obj = this.registry.get(en.nextElement());
                    if (obj instanceof GenericElement) {
                        Element e = obj;
                        if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                            out.write(10);
                            e.setTabLevel(tabLevel + 1);
                        }
                        e.output(out);
                        continue;
                    }
                    if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                        out.write(10);
                        this.putTabs(tabLevel + 1, out);
                    }
                    String string = obj.toString();
                    out.write(string.getBytes());
                }
                if (this.getNeedClosingTag()) {
                    if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                        out.write(10);
                        if (tabLevel > 0) {
                            this.putTabs(tabLevel, out);
                        }
                    }
                    out.write(this.createEndTag().getBytes());
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(new PrintWriter(out));
        }
    }

    public void output(Writer out) {
        this.output(new PrintWriter(out));
    }

    @Override
    public void output(PrintWriter out) {
        boolean prettyPrint = this.getPrettyPrint();
        int tabLevel = this.getTabLevel();
        if (this.registry.size() == 0) {
            if (prettyPrint && this instanceof Printable && tabLevel > 0) {
                this.putTabs(tabLevel, out);
            }
            super.output(out);
        } else {
            if (prettyPrint && this instanceof Printable && tabLevel > 0) {
                this.putTabs(tabLevel, out);
            }
            out.write(this.createStartTag());
            if (this.getTagText() != null) {
                out.write(this.getTagText());
            }
            Enumeration<String> en = this.registryList.elements();
            while (en.hasMoreElements()) {
                Element obj = this.registry.get(en.nextElement());
                if (obj instanceof GenericElement) {
                    Element e = obj;
                    if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                        out.write(10);
                        e.setTabLevel(tabLevel + 1);
                    }
                    e.output(out);
                    continue;
                }
                if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                    out.write(10);
                    this.putTabs(tabLevel + 1, out);
                }
                String string = obj.toString();
                if (this.getFilterState()) {
                    out.write(this.getFilter().process(string));
                    continue;
                }
                out.write(string);
            }
            if (this.getNeedClosingTag()) {
                if (prettyPrint && this instanceof Printable && this.getNeedLineBreak()) {
                    out.write(10);
                    if (tabLevel > 0) {
                        this.putTabs(tabLevel, out);
                    }
                }
                out.write(this.createEndTag());
            }
        }
    }

    public Object clone() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(this);
            out.close();
            ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream in = new ObjectInputStream(bin);
            Object clone = in.readObject();
            in.close();
            return clone;
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalError(cnfe.toString());
        }
        catch (StreamCorruptedException sce) {
            throw new InternalError(sce.toString());
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }
}

