/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.Widget;

public final class MoveAction
extends WidgetAction.LockedAdapter {
    private MoveStrategy strategy;
    private MoveProvider provider;
    private Widget movingWidget = null;
    private Point dragSceneLocation = null;
    private Point originalSceneLocation = null;
    private Point initialMouseLocation = null;

    public MoveAction(MoveStrategy strategy, MoveProvider provider) {
        this.strategy = strategy;
        this.provider = provider;
    }

    @Override
    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (event.getButton() == 1 && event.getClickCount() == 1) {
            this.movingWidget = widget;
            this.initialMouseLocation = event.getPoint();
            this.originalSceneLocation = this.provider.getOriginalLocation(widget);
            if (this.originalSceneLocation == null) {
                this.originalSceneLocation = new Point();
            }
            this.dragSceneLocation = widget.convertLocalToScene(event.getPoint());
            this.provider.movementStarted(widget);
            return WidgetAction.State.createLocked(widget, this);
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        boolean state = this.initialMouseLocation != null && this.initialMouseLocation.equals(event.getPoint()) ? true : this.move(widget, event.getPoint());
        if (state) {
            this.movingWidget = null;
            this.dragSceneLocation = null;
            this.originalSceneLocation = null;
            this.initialMouseLocation = null;
            this.provider.movementFinished(widget);
        }
        return state ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        return this.move(widget, event.getPoint()) ? WidgetAction.State.createLocked(widget, this) : WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return false;
        }
        this.initialMouseLocation = null;
        newLocation = widget.convertLocalToScene(newLocation);
        Point location = new Point(this.originalSceneLocation.x + newLocation.x - this.dragSceneLocation.x, this.originalSceneLocation.y + newLocation.y - this.dragSceneLocation.y);
        this.provider.setNewLocation(widget, this.strategy.locationSuggested(widget, this.originalSceneLocation, location));
        return true;
    }
}

