/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.adempiere.eclipse.equinox.http.servlet.DefaultHttpContext;
import org.adempiere.eclipse.equinox.http.servlet.HttpServiceProxyFactory;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class HttpServiceProxy
implements HttpService,
ExtendedHttpService {
    private Bundle bundle;
    private Map<Filter, ExtendedHttpService> filterMap = new HashMap<Filter, ExtendedHttpService>();
    private HttpServiceProxyFactory factory;
    private List<FilterEntry> filters = new ArrayList<FilterEntry>();
    private List<ServletEntry> servlets = new ArrayList<ServletEntry>();
    private List<ResourceEntry> resources = new ArrayList<ResourceEntry>();

    public HttpServiceProxy(Bundle bundle, HttpServiceProxyFactory httpServiceProxyFactory) {
        this.bundle = bundle;
        this.factory = httpServiceProxyFactory;
    }

    public void registerFilter(String alias, Filter filter, Dictionary<String, String> initparams, HttpContext context) throws ServletException, NamespaceException {
        String httpContextClass = context != null ? context.getClass().getName() : DefaultHttpContext.class.getName();
        HttpService delegate = this.factory.getHttpServiceDelegate(this.bundle, httpContextClass);
        if (delegate != null && delegate instanceof ExtendedHttpService) {
            ((ExtendedHttpService)delegate).registerFilter(alias, filter, initparams, context);
            this.filterMap.put(filter, (ExtendedHttpService)delegate);
        } else {
            this.filters.add(new FilterEntry(alias, filter, initparams, context));
        }
    }

    public void unregisterFilter(Filter filter) {
        ExtendedHttpService service = this.filterMap.get(filter);
        if (service != null) {
            service.unregisterFilter(filter);
        }
    }

    public void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext context) throws ServletException, NamespaceException {
        String httpContextClass = context != null ? context.getClass().getName() : DefaultHttpContext.class.getName();
        HttpService delegate = this.factory.getHttpServiceDelegate(this.bundle, httpContextClass);
        if (delegate != null) {
            delegate.registerServlet(alias, servlet, initparams, context);
        } else {
            this.servlets.add(new ServletEntry(alias, servlet, initparams, context));
        }
    }

    public void registerResources(String alias, String name, HttpContext context) throws NamespaceException {
        String httpContextClass = context != null ? context.getClass().getName() : DefaultHttpContext.class.getName();
        HttpService delegate = this.factory.getHttpServiceDelegate(this.bundle, httpContextClass);
        if (delegate != null) {
            delegate.registerResources(alias, name, context);
        } else {
            this.resources.add(new ResourceEntry(alias, name, context));
        }
    }

    protected void processPendingRegistration(String httpContext) throws ServletException, NamespaceException {
        ArrayList<Entry> list;
        if (!this.filters.isEmpty()) {
            list = new ArrayList<Entry>();
            list.addAll(this.filters);
            this.filters.clear();
            for (Entry e : list) {
                if (e.getHttpContext().equals(httpContext)) {
                    this.registerFilter(((FilterEntry)e).alias, ((FilterEntry)e).filter, ((FilterEntry)e).initparams, ((FilterEntry)e).context);
                    continue;
                }
                this.filters.add((FilterEntry)e);
            }
        }
        if (!this.servlets.isEmpty()) {
            list = new ArrayList();
            list.addAll(this.servlets);
            this.servlets.clear();
            for (Entry e : list) {
                if (e.getHttpContext().equals(httpContext)) {
                    this.registerServlet(((ServletEntry)e).alias, ((ServletEntry)e).servlet, ((ServletEntry)e).initparams, ((ServletEntry)e).context);
                    continue;
                }
                this.servlets.add((ServletEntry)e);
            }
        }
        if (!this.resources.isEmpty()) {
            list = new ArrayList();
            list.addAll(this.resources);
            this.resources.clear();
            for (Entry e : list) {
                if (e.getHttpContext().equals(httpContext)) {
                    this.registerResources(((ResourceEntry)e).alias, ((ResourceEntry)e).name, ((ResourceEntry)e).context);
                    continue;
                }
                this.resources.add((ResourceEntry)e);
            }
        }
    }

    public void unregister(String alias) {
    }

    public HttpContext createDefaultHttpContext() {
        return new DefaultHttpContext(this.bundle);
    }

    class Entry {
        protected HttpContext context;

        protected Entry(HttpContext context) {
            this.context = context;
        }

        protected String getHttpContext() {
            return this.context != null ? this.context.getClass().getName() : DefaultHttpContext.class.getName();
        }
    }

    class FilterEntry
    extends Entry {
        protected String alias;
        protected Filter filter;
        protected Dictionary<String, String> initparams;

        protected FilterEntry(String alias, Filter filter, Dictionary<String, String> initparams, HttpContext context) {
            super(context);
            this.alias = alias;
            this.filter = filter;
            this.initparams = initparams;
        }
    }

    class ResourceEntry
    extends Entry {
        protected String alias;
        protected String name;

        protected ResourceEntry(String alias, String name, HttpContext context) {
            super(context);
            this.alias = alias;
            this.name = name;
        }
    }

    class ServletEntry
    extends Entry {
        protected String alias;
        protected Servlet servlet;
        protected Dictionary<?, ?> initparams;

        protected ServletEntry(String alias, Servlet servlet, Dictionary<?, ?> initparams, HttpContext context) {
            super(context);
            this.alias = alias;
            this.servlet = servlet;
            this.initparams = initparams;
            this.context = context;
        }
    }
}

