/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.MViewComponent;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class CopyComponentsFromView
extends SvrProcess {
    private int p_target_AD_Table_ID = 0;
    private int p_source_AD_Table_ID = 0;
    private int m_count = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Table_ID")) {
                    this.p_source_AD_Table_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_target_AD_Table_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MTable targetTable;
        MViewComponent[] targetViewComponents;
        if (this.p_target_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_target_AD_Table_ID);
        }
        if (this.p_source_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_source_AD_Table_ID);
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Source AD_Table_ID=" + this.p_source_AD_Table_ID + ", Target AD_Table_ID=" + this.p_target_AD_Table_ID);
        }
        if ((targetViewComponents = (targetTable = new MTable(this.getCtx(), this.p_target_AD_Table_ID, this.get_TrxName())).getViewComponent(true)).length > 0) {
            throw new AdempiereSystemError(Msg.getMsg((Properties)Env.getCtx(), (String)"ErrorCopyView"));
        }
        MTable sourceTable = new MTable(this.getCtx(), this.p_source_AD_Table_ID, this.get_TrxName());
        MViewComponent[] sourceViewComponents = sourceTable.getViewComponent(true);
        int i = 0;
        while (i < sourceViewComponents.length) {
            MViewComponent viewComponentTarget = new MViewComponent(targetTable);
            PO.copyValues((PO)sourceViewComponents[i], (PO)viewComponentTarget);
            viewComponentTarget.setAD_Table_ID(targetTable.getAD_Table_ID());
            viewComponentTarget.setEntityType(targetTable.getEntityType());
            viewComponentTarget.setIsActive(sourceViewComponents[i].isActive());
            viewComponentTarget.saveEx(this.get_TrxName());
            this.copyViewColumns(sourceViewComponents[i], viewComponentTarget);
            ++this.m_count;
            ++i;
        }
        return "#" + this.m_count;
    }

    public void copyViewColumns(MViewComponent sourceComponent, MViewComponent targetComponent) {
        MViewColumn[] sourceColumns = sourceComponent.getColumns(true);
        int i = 0;
        while (i < sourceColumns.length) {
            MViewColumn columnTarget = new MViewColumn(targetComponent);
            PO.copyValues((PO)sourceColumns[i], (PO)columnTarget);
            columnTarget.setAD_ViewComponent_ID(targetComponent.getAD_ViewComponent_ID());
            columnTarget.setEntityType(targetComponent.getEntityType());
            columnTarget.setIsActive(sourceColumns[i].isActive());
            columnTarget.saveEx(this.get_TrxName());
            ++i;
        }
    }
}

