/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.keikai.view;

import io.keikai.api.Importer;
import io.keikai.api.Importers;
import io.keikai.api.model.Book;
import io.keikai.ui.AuxAction;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionHandler;
import io.keikai.ui.UserActionManager;
import io.keikai.ui.impl.DefaultUserActionManagerCtrl;
import org.idempiere.keikai.view.Helper;
import org.idempiere.keikai.view.SaveBookHandler;
import org.idempiere.ui.zk.media.IMediaView;
import org.zkoss.util.media.AMedia;
import org.zkoss.zk.ui.Component;

public class ExcelMediaView
implements IMediaView {
    public static final ExcelMediaView INSTANCE = new ExcelMediaView();

    private ExcelMediaView() {
    }

    public Component renderMediaView(Component container, AMedia media, boolean readOnly) {
        Book book;
        Spreadsheet spreadsheet = new Spreadsheet();
        if (!readOnly) {
            spreadsheet.setShowFormulabar(true);
            spreadsheet.setShowContextMenu(true);
        }
        spreadsheet.setShowToolbar(true);
        spreadsheet.setHeight("100%");
        spreadsheet.setWidth("100%");
        container.appendChild((Component)spreadsheet);
        Importer importer = Importers.getImporter();
        try {
            book = importer.imports(media.getStreamData(), media.getName());
        }
        catch (Exception e) {
            container.removeChild((Component)spreadsheet);
            throw new RuntimeException(e.getMessage(), e);
        }
        spreadsheet.setBook(book);
        if (readOnly) {
            Helper.protectSheet(book.getSheetAt(0));
        }
        Helper.customizeToolbar(container, readOnly);
        UserActionManager actionManager = spreadsheet.getUserActionManager();
        actionManager.registerHandler(DefaultUserActionManagerCtrl.Category.AUXACTION.getName(), AuxAction.SAVE_BOOK.getAction(), (UserActionHandler)new SaveBookHandler());
        return spreadsheet;
    }
}

