/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.ChartInfo;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.ZssChartX;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFDrawing;

public class XSSFChartX
implements ZssChartX {
    private XSSFDrawing _patriarch;
    private String _name;
    private XSSFChart _chart;
    private String _chartId;

    public XSSFChartX(XSSFDrawing patriarch, XSSFClientAnchor anchor, String name, String chartId) {
        this._patriarch = patriarch;
        this._chart = this.getXSSFChart1(chartId);
        this._name = name;
        this._chartId = chartId;
        this._chart.setClientAnchor(anchor);
    }

    @Override
    public ClientAnchor getPreferredSize() {
        return this._chart.getPreferredSize();
    }

    private XSSFChart getXSSFChart1(String chartId) {
        for (POIXMLDocumentPart part : this._patriarch.getRelations()) {
            if (!(part instanceof XSSFChart) || !part.getPackageRelationship().getId().equals(chartId)) continue;
            return (XSSFChart)part;
        }
        return null;
    }

    @Override
    public ChartInfo getChartInfo() {
        return null;
    }

    @Override
    public Chart getChart() {
        return this._chart;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void renameSheet(String oldname, String newname) {
        this.renameSheet1(oldname, newname);
    }

    private void renameSheet1(String oldname, String newname) {
        this._chart.renameSheet(oldname, newname);
    }

    @Override
    public String getChartId() {
        return this._chartId;
    }

    @Override
    public void setClientAnchor(ClientAnchor newanchor) {
        this._chart.setClientAnchor(newanchor);
    }
}

