/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.common;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public class XFPropColor {
    private static final BitField fValidRGBA = BitFieldFactory.getInstance(1);
    private static final BitField xclrType = BitFieldFactory.getInstance(254);
    private byte bits;
    private byte icv;
    private int nTintShade;
    private int dwRgba;

    public XFPropColor(RecordInputStream in) {
        this.bits = in.readByte();
        this.icv = in.readByte();
        this.nTintShade = in.readShort() & 0xFFFF;
        this.dwRgba = in.readInt();
    }

    public XFPropColor(int bits, int icv, int nTintShade, int dwRgba) {
        this.bits = (byte)bits;
        this.icv = (byte)icv;
        this.nTintShade = nTintShade;
        this.dwRgba = dwRgba;
    }

    public int getIcv() {
        return this.icv & 0xFF;
    }

    public void setIcv(int icv) {
        this.icv = (byte)icv;
    }

    public boolean isValidRGBA() {
        return fValidRGBA.isSet(this.bits);
    }

    public void setValidRGBA(boolean flag) {
        this.bits = fValidRGBA.setByteBoolean(this.bits, flag);
    }

    public int getTintShade() {
        return this.nTintShade;
    }

    public void setTintShade(int shade) {
        this.nTintShade = shade;
    }

    public int getXclrType() {
        return xclrType.getValue(this.bits);
    }

    public void setXclrType(int xclrType0) {
        this.bits = (byte)xclrType.setValue(this.bits, xclrType0);
    }

    public int getRgba() {
        return this.dwRgba;
    }

    public void setRgba(int rgba) {
        this.dwRgba = rgba;
    }

    public int getDataSize() {
        return 8;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.bits);
        out.writeByte(this.icv);
        out.writeShort(this.nTintShade);
        out.writeInt(this.dwRgba);
    }

    public void appendString(StringBuffer sb, String prefix) {
        sb.append(prefix).append("[XFPROPCOLOR]").append("\n");
        sb.append(prefix).append("    .bits        = ").append(HexDump.byteToHex(this.bits)).append("\n");
        sb.append(prefix).append("        .fValidaRGBA = ").append(this.isValidRGBA()).append("\n");
        sb.append(prefix).append("        .xclrType    = ").append(HexDump.byteToHex(this.getXclrType())).append("\n");
        sb.append(prefix).append("    .icv         = ").append(HexDump.byteToHex(this.icv)).append("\n");
        sb.append(prefix).append("    .nTintShade  = ").append(HexDump.intToHex(this.nTintShade)).append("\n");
        sb.append(prefix).append("    .dwRgba      = ").append(HexDump.intToHex(this.dwRgba)).append("\n");
        sb.append(prefix).append("[/XFPROPCOLOR]").append("\n");
    }
}

