/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.record.chart;

import org.zkoss.poi.hssf.record.RecordInputStream;
import org.zkoss.poi.hssf.record.StandardRecord;
import org.zkoss.poi.util.BitField;
import org.zkoss.poi.util.BitFieldFactory;
import org.zkoss.poi.util.HexDump;
import org.zkoss.poi.util.LittleEndianOutput;

public final class Chart3DRecord
extends StandardRecord {
    public static final short sid = 4154;
    private short field_1_anRot;
    private short field_2_anElev;
    private short field_3_pcDist;
    private short field_4_pcHeight;
    private short field_5_depth;
    private short field_6_gap;
    private short field_7_formatFlags;
    private static final BitField perspective = BitFieldFactory.getInstance(1);
    private static final BitField cluster = BitFieldFactory.getInstance(2);
    private static final BitField scaling = BitFieldFactory.getInstance(4);
    private static final BitField notpie = BitFieldFactory.getInstance(16);
    private static final BitField wall2d = BitFieldFactory.getInstance(32);

    public Chart3DRecord() {
    }

    public Chart3DRecord(RecordInputStream in) {
        this.field_1_anRot = in.readShort();
        this.field_2_anElev = in.readShort();
        this.field_3_pcDist = in.readShort();
        this.field_4_pcHeight = in.readShort();
        this.field_5_depth = in.readShort();
        this.field_6_gap = in.readShort();
        this.field_7_formatFlags = in.readShort();
    }

    @Override
    protected int getDataSize() {
        return 14;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[CHART3D]\n");
        buffer.append("    .anRot          = ").append("0x").append(HexDump.toHex(this.field_1_anRot)).append(" (").append(this.field_1_anRot).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .anElev         = ").append("0x").append(HexDump.toHex(this.field_2_anElev)).append(" (").append(this.field_2_anElev).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .pcDist         = ").append("0x").append(HexDump.toHex(this.field_3_pcDist)).append(" (").append(this.field_3_pcDist).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .pcHeight       = ").append("0x").append(HexDump.toHex(this.field_4_pcHeight)).append(" (").append(this.field_4_pcHeight).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .depth          = ").append("0x").append(HexDump.toHex(this.field_5_depth)).append(" (").append(this.field_5_depth).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .gap            = ").append("0x").append(HexDump.toHex(this.field_6_gap)).append(" (").append(this.field_6_gap).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .formatFlags    = ").append("0x").append(HexDump.toHex(this.field_7_formatFlags)).append(" (").append(this.field_7_formatFlags).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .perspective       = ").append(this.isPerspective()).append('\n');
        buffer.append("         .cluster           = ").append(this.isCluster()).append('\n');
        buffer.append("         .3dscaling         = ").append(this.isScaling()).append('\n');
        buffer.append("         .notpie            = ").append(this.isNotPie()).append('\n');
        buffer.append("         .walls2d           = ").append(this.isWalls2D()).append('\n');
        buffer.append("[/CHART3D]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.field_1_anRot);
        out.writeShort(this.field_2_anElev);
        out.writeShort(this.field_3_pcDist);
        out.writeShort(this.field_4_pcHeight);
        out.writeShort(this.field_5_depth);
        out.writeShort(this.field_6_gap);
        out.writeShort(this.field_7_formatFlags);
    }

    @Override
    public short getSid() {
        return 4154;
    }

    @Override
    public Object clone() {
        Chart3DRecord rec = new Chart3DRecord();
        rec.field_1_anRot = this.field_1_anRot;
        rec.field_2_anElev = this.field_2_anElev;
        rec.field_3_pcDist = this.field_3_pcDist;
        rec.field_4_pcHeight = this.field_4_pcHeight;
        rec.field_5_depth = this.field_5_depth;
        rec.field_6_gap = this.field_6_gap;
        rec.field_7_formatFlags = this.field_7_formatFlags;
        return rec;
    }

    public short getFormatFlags() {
        return this.field_7_formatFlags;
    }

    public void setFormatFlags(short field_6_formatFlags) {
        this.field_7_formatFlags = field_6_formatFlags;
    }

    public short getAnRot() {
        return this.field_1_anRot;
    }

    public void setAnRot(short field_1_anRot) {
        this.field_1_anRot = field_1_anRot;
    }

    public short getAnElev() {
        return this.field_2_anElev;
    }

    public void setAnElev(short field_2_anElev) {
        this.field_2_anElev = field_2_anElev;
    }

    public void setDist(short field_3_pcDist) {
        this.field_3_pcDist = field_3_pcDist;
    }

    public short getDist() {
        return this.field_3_pcDist;
    }

    public void setHeight(short field_4_pcHeight) {
        this.field_4_pcHeight = field_4_pcHeight;
    }

    public short getHeight() {
        return this.field_4_pcHeight;
    }

    public void setDepth(short field_5_depth) {
        this.field_5_depth = field_5_depth;
    }

    public short getDepth() {
        return this.field_5_depth;
    }

    public void setGap(short field_6_gap) {
        this.field_6_gap = field_6_gap;
    }

    public short getGap() {
        return this.field_6_gap;
    }

    public void setPerspective(boolean value) {
        this.field_7_formatFlags = perspective.setShortBoolean(this.field_7_formatFlags, value);
    }

    public boolean isPerspective() {
        return perspective.isSet(this.field_7_formatFlags);
    }

    public void setCluster(boolean value) {
        this.field_7_formatFlags = cluster.setShortBoolean(this.field_7_formatFlags, value);
    }

    public boolean isCluster() {
        return cluster.isSet(this.field_7_formatFlags);
    }

    public void setScaling(boolean value) {
        this.field_7_formatFlags = scaling.setShortBoolean(this.field_7_formatFlags, value);
    }

    public boolean isScaling() {
        return scaling.isSet(this.field_7_formatFlags);
    }

    public void setNotPie(boolean value) {
        this.field_7_formatFlags = notpie.setShortBoolean(this.field_7_formatFlags, value);
    }

    public boolean isNotPie() {
        return notpie.isSet(this.field_7_formatFlags);
    }

    public void setWalls2D(boolean value) {
        this.field_7_formatFlags = wall2d.setShortBoolean(this.field_7_formatFlags, value);
    }

    public boolean isWalls2D() {
        return wall2d.isSet(this.field_7_formatFlags);
    }
}

