/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.IllegalFormulaException;
import io.keikai.model.CellRegion;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColumn;
import io.keikai.model.SHyperlink;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ReserveUtil {
    public static final int RESERVE_CONTENT = 1;
    public static final int RESERVE_STYLE = 2;
    public static final int RESERVE_MERGE = 4;
    public static final int RESERVE_ALL = 7;

    public static ReservedResult reserve(SSheet sheet, int row, int column, int lastRow, int lastColumn, int reserveType) {
        ReservedResult result;
        boolean reserveContent = false;
        boolean reserveStyle = false;
        boolean reserveMerge = false;
        if ((reserveType & 1) != 0) {
            reserveContent = true;
        }
        if ((reserveType & 2) != 0) {
            reserveStyle = true;
        }
        if ((reserveType & 4) != 0) {
            reserveMerge = true;
        }
        if ((result = new ReservedResult(sheet, row, column, lastRow, lastColumn, reserveType)).isWholeSheet()) {
            ReserveUtil.reserveWholeSheet(result, reserveContent, reserveStyle);
        } else if (result.isWholeRow()) {
            ReserveUtil.reserveWholeRow(result, reserveContent, reserveStyle);
        } else if (result.isWholeColumn()) {
            ReserveUtil.reserveWholeColumn(result, reserveContent, reserveStyle);
        } else {
            ReserveUtil.reserveCell(result, reserveContent, reserveStyle);
        }
        if (reserveMerge) {
            result.setMergeInfo(ReserveUtil.reserveMergeInfo(sheet, row, column, lastRow, lastColumn));
        }
        return result;
    }

    private static void reserveCell(ReservedResult result, boolean reserveContent, boolean reserveStyle) {
        SSheet sheet = result.getSheet();
        TreeMap<Integer, ReservedRow> reservedRows = new TreeMap<Integer, ReservedRow>();
        for (int r = result.getRow(); r <= result.getLastRow(); ++r) {
            SRow row = sheet.getRow(r);
            if (row.isNull() && !reserveStyle) continue;
            ReservedRow reservedRow = new ReservedRow(r);
            reservedRows.put(r, reservedRow);
            for (int c = result.getColumn(); c <= result.getLastColumn(); ++c) {
                SCell cell = sheet.getCell(r, c);
                if (cell.isNull() && !reserveStyle) continue;
                ReservedCell rcell = new ReservedCell(c);
                reservedRow.addCell(rcell);
                if (reserveContent) {
                    ReservedCellContent content = ReservedCellContent.reserve(cell);
                    rcell.setContent(content);
                }
                if (!reserveStyle) continue;
                SCellStyle style = cell.getCellStyle(true);
                rcell.setStyle(style);
            }
        }
        result.setRowsInfo(reservedRows);
    }

    private static void reserveWholeColumn(ReservedResult result, boolean reserveContent, boolean reserveStyle) {
        SSheet sheet = result.getSheet();
        TreeMap<Integer, ReservedRow> reservedRows = new TreeMap<Integer, ReservedRow>();
        for (int r = result.getRow(); r <= result.getLastRow(); ++r) {
            SRow row = sheet.getRow(r);
            if (row.isNull() && !reserveStyle) continue;
            ReservedRow reservedRow = new ReservedRow(r);
            reservedRows.put(r, reservedRow);
            if (reserveStyle) {
                SCellStyle style = row.getCellStyle(true);
                reservedRow.setStyle(style);
                reservedRow.setCustomHeight(row.isCustomHeight());
                reservedRow.setHeight(row.getHeight());
            }
            HashSet<Integer> cellProcessed = new HashSet<Integer>();
            Iterator cellIter = sheet.getCellIterator(r);
            while (cellIter.hasNext()) {
                SCell cell = (SCell)cellIter.next();
                ReservedCell rcell = new ReservedCell(cell.getColumnIndex());
                reservedRow.addCell(rcell);
                if (reserveContent) {
                    ReservedCellContent content = ReservedCellContent.reserve(cell);
                    rcell.setContent(content);
                }
                if (reserveStyle) {
                    SCellStyle style = cell.getCellStyle(true);
                    rcell.setStyle(style);
                }
                cellProcessed.add(cell.getColumnIndex());
            }
            if (!reserveStyle) continue;
            Iterator columns = sheet.getColumnIterator();
            while (columns.hasNext()) {
                SColumn column = (SColumn)columns.next();
                if (cellProcessed.contains(column.getIndex()) || column.getCellStyle(true) == null) continue;
                SCell cell = sheet.getCell(r, column.getIndex());
                ReservedCell rcell = new ReservedCell(cell.getColumnIndex());
                reservedRow.addCell(rcell);
                SCellStyle style = cell.getCellStyle(true);
                rcell.setStyle(style);
            }
        }
        result.setRowsInfo(reservedRows);
    }

    private static void reserveWholeRow(ReservedResult result, boolean reserveContent, boolean reserveStyle) {
        SSheet sheet = result.getSheet();
        HashMap<Integer, ReservedColumn> reservedColumns = new HashMap<Integer, ReservedColumn>();
        if (reserveStyle) {
            for (int c = result.getColumn(); c <= result.getLastColumn(); ++c) {
                SColumn col = sheet.getColumn(c);
                ReservedColumn reservedColumn = new ReservedColumn(col.getIndex());
                reservedColumns.put(col.getIndex(), reservedColumn);
                SCellStyle style = col.getCellStyle(true);
                reservedColumn.setStyle(style);
                reservedColumn.setCustomWidth(col.isCustomWidth());
                reservedColumn.setWidth(col.getWidth());
            }
        }
        TreeMap<Integer, ReservedRow> reservedRows = new TreeMap<Integer, ReservedRow>();
        Iterator rowIter = sheet.getRowIterator();
        while (rowIter.hasNext()) {
            SRow row = (SRow)rowIter.next();
            int r = row.getIndex();
            ReservedRow reservedRow = new ReservedRow(r);
            reservedRows.put(r, reservedRow);
            for (int c = result.getColumn(); c <= result.getLastColumn(); ++c) {
                SCell cell = sheet.getCell(r, c);
                if (cell.isNull() && !reserveStyle) continue;
                ReservedCell rcell = new ReservedCell(cell.getColumnIndex());
                reservedRow.addCell(rcell);
                if (reserveContent) {
                    ReservedCellContent content = ReservedCellContent.reserve(cell);
                    rcell.setContent(content);
                }
                if (!reserveStyle) continue;
                SCellStyle style = cell.getCellStyle(true);
                rcell.setStyle(style);
            }
        }
        result.setRowsInfo(reservedRows);
        result.setColumnsInfo(reservedColumns);
    }

    private static void reserveWholeSheet(ReservedResult result, boolean reserveContent, boolean reserveStyle) {
        SSheet sheet = result.getSheet();
        HashMap<Integer, ReservedColumn> reservedColumns = new HashMap<Integer, ReservedColumn>();
        Iterator colIter = sheet.getColumnIterator();
        while (reserveStyle && colIter.hasNext()) {
            SColumn col = (SColumn)colIter.next();
            ReservedColumn reservedColumn = new ReservedColumn(col.getIndex());
            reservedColumns.put(col.getIndex(), reservedColumn);
            SCellStyle style = col.getCellStyle(true);
            reservedColumn.setStyle(style);
            reservedColumn.setCustomWidth(col.isCustomWidth());
            reservedColumn.setWidth(col.getWidth());
        }
        TreeMap<Integer, ReservedRow> reservedRows = new TreeMap<Integer, ReservedRow>();
        Iterator rowIter = sheet.getRowIterator();
        while (rowIter.hasNext()) {
            SRow row = (SRow)rowIter.next();
            int r = row.getIndex();
            ReservedRow reservedRow = new ReservedRow(r);
            reservedRows.put(r, reservedRow);
            if (reserveStyle) {
                SCellStyle style = row.getCellStyle(true);
                reservedRow.setStyle(style);
                reservedRow.setCustomHeight(row.isCustomHeight());
                reservedRow.setHeight(row.getHeight());
            }
            for (int c = result.getColumn(); c <= result.getLastColumn(); ++c) {
                SCell cell = sheet.getCell(r, c);
                if (cell.isNull() && !reserveStyle) continue;
                ReservedCell rcell = new ReservedCell(cell.getColumnIndex());
                reservedRow.addCell(rcell);
                if (reserveContent) {
                    ReservedCellContent content = ReservedCellContent.reserve(cell);
                    rcell.setContent(content);
                }
                if (!reserveStyle) continue;
                SCellStyle style = cell.getCellStyle(true);
                rcell.setStyle(style);
            }
        }
        result.setRowsInfo(reservedRows);
        result.setColumnsInfo(reservedColumns);
    }

    public static CellRegion[] reserveMergeInfo(SSheet sheet, int row, int column, int lastRow, int lastColumn) {
        ArrayList array = new ArrayList();
        CellRegion cur = new CellRegion(row, column, lastRow, lastColumn);
        array.addAll(sheet.getOverlapsMergedRegions(cur, false));
        return array.size() == 0 ? null : array.toArray(new CellRegion[array.size()]);
    }

    public static class ReservedCellContent
    implements Serializable {
        private static final long serialVersionUID = 8802989924793650560L;
        SCell.CellType _type;
        String _editText;
        Object _value;
        SHyperlink _link;

        public ReservedCellContent(SCell.CellType type) {
            this._type = type;
        }

        public void apply(SRange range) {
            SCell cell = range.getSheet().getCell(range.getRow(), range.getColumn());
            if (this._link != null) {
                cell.setupHyperlink(this._link.getType(), this._link.getAddress(), this._link.getLabel());
            }
            if (SCell.CellType.FORMULA.equals((Object)this._type)) {
                try {
                    range.setEditText(this._editText);
                }
                catch (IllegalFormulaException illegalFormulaException) {}
            } else {
                range.setValue(this._value);
            }
        }

        public static ReservedCellContent reserve(SCell cell) {
            SCell.CellType type = cell.getType();
            if (cell.isNull() || SCell.CellType.BLANK.equals((Object)type)) {
                return null;
            }
            ReservedCellContent cc = new ReservedCellContent(cell.getType());
            if (SCell.CellType.FORMULA.equals((Object)type)) {
                cc._editText = SRanges.range((SSheet)cell.getSheet(), (int)cell.getRowIndex(), (int)cell.getColumnIndex()).getEditText();
            } else {
                cc._value = cell.getValue();
            }
            cc._link = cell.getHyperlink();
            return cc;
        }
    }

    public static class ReservedCell
    implements Serializable {
        private static final long serialVersionUID = 9009281980152721331L;
        private SCellStyle _style;
        private ReservedCellContent _content;
        int _columnIdx;

        public ReservedCell(int columnIdx) {
            this._columnIdx = columnIdx;
        }

        public int getColumnIndex() {
            return this._columnIdx;
        }

        public ReservedCellContent getContent() {
            return this._content;
        }

        public void setContent(ReservedCellContent content) {
            this._content = content;
        }

        public SCellStyle getStyle() {
            return this._style;
        }

        public void setStyle(SCellStyle style) {
            this._style = style;
        }
    }

    public static class ReservedRow
    implements Serializable {
        private static final long serialVersionUID = 8447463993307217267L;
        private int _index;
        private Map<Integer, ReservedCell> cells;
        private SCellStyle _style;
        private int _height;
        private boolean _customHeight;

        public ReservedRow(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        public void addCell(ReservedCell cell) {
            if (this.cells == null) {
                this.cells = new TreeMap<Integer, ReservedCell>();
            }
            this.cells.put(cell.getColumnIndex(), cell);
        }

        public Collection<ReservedCell> getReservedCells() {
            return this.cells == null ? Collections.EMPTY_SET : this.cells.values();
        }

        public SCellStyle getStyle() {
            return this._style;
        }

        public void setStyle(SCellStyle style) {
            this._style = style;
        }

        public int getHeight() {
            return this._height;
        }

        public void setHeight(int height) {
            this._height = height;
        }

        public boolean isCustomHegiht() {
            return this._customHeight;
        }

        public void setCustomHeight(boolean custom) {
            this._customHeight = custom;
        }
    }

    public static class ReservedColumn
    implements Serializable {
        private static final long serialVersionUID = 47651964378902990L;
        private int _index;
        private SCellStyle _style;
        private int _width;
        private boolean _customWidth;

        public ReservedColumn(int index) {
            this._index = index;
        }

        public int getIndex() {
            return this._index;
        }

        public SCellStyle getStyle() {
            return this._style;
        }

        public void setStyle(SCellStyle style) {
            this._style = style;
        }

        public int getWidth() {
            return this._width;
        }

        public void setWidth(int width) {
            this._width = width;
        }

        public boolean isCustomWidth() {
            return this._customWidth;
        }

        public void setCustomWidth(boolean custom) {
            this._customWidth = custom;
        }
    }

    public static class ReservedResult
    implements Serializable {
        private static final long serialVersionUID = -2246554370978004481L;
        private final int _reserveType;
        private final SSheet _sheet;
        private Map<Integer, ReservedRow> _rows = null;
        private Map<Integer, ReservedColumn> _columns = null;
        private CellRegion[] _mergeInfo;
        private final int _row;
        private final int _column;
        private final int _lastRow;
        private final int _lastColumn;
        private boolean _wholeRow;
        private boolean _wholeColumn;

        public ReservedResult(SSheet sheet, int row, int column, int lastRow, int lastColumn, int reserveType) {
            this._sheet = sheet;
            this._row = row;
            this._column = column;
            this._lastRow = lastRow;
            this._lastColumn = lastColumn;
            this._reserveType = reserveType;
            this._wholeRow = this._row <= 0 && this._lastRow >= this._sheet.getBook().getMaxRowIndex();
            this._wholeColumn = this._column <= 0 && this._lastColumn >= this._sheet.getBook().getMaxColumnIndex();
        }

        public boolean isWholeSheet() {
            return this.isWholeRow() && this.isWholeColumn();
        }

        public boolean isWholeRow() {
            return this._wholeRow;
        }

        public boolean isWholeColumn() {
            return this._wholeColumn;
        }

        public SSheet getSheet() {
            return this._sheet;
        }

        public int getRow() {
            return this._row;
        }

        public int getColumn() {
            return this._column;
        }

        public int getLastRow() {
            return this._lastRow;
        }

        public int getLastColumn() {
            return this._lastColumn;
        }

        public CellRegion[] getMergeInfo() {
            return this._mergeInfo;
        }

        public void setMergeInfo(CellRegion[] mergeInfo) {
            this._mergeInfo = mergeInfo;
        }

        public void setRowsInfo(Map<Integer, ReservedRow> rows) {
            this._rows = rows;
        }

        public void setColumnsInfo(Map<Integer, ReservedColumn> columns) {
            this._columns = columns;
        }

        public Map<Integer, ReservedRow> getRows() {
            return this._rows;
        }

        public void restore() {
            SRange tempRange;
            CellRegion[] curMergeInfo;
            boolean reserveContent = false;
            boolean reserveStyle = false;
            boolean reserveMerge = false;
            if ((this._reserveType & 1) != 0) {
                reserveContent = true;
            }
            if ((this._reserveType & 2) != 0) {
                reserveStyle = true;
            }
            if ((this._reserveType & 4) != 0) {
                reserveMerge = true;
            }
            if (reserveMerge && (curMergeInfo = ReserveUtil.reserveMergeInfo(this._sheet, this._row, this._column, this._lastRow, this._lastColumn)) != null) {
                for (Object rect : curMergeInfo) {
                    tempRange = SRanges.range((SSheet)this._sheet, (CellRegion)rect);
                    tempRange.unmerge();
                }
            }
            SRange targetRange = SRanges.range((SSheet)this._sheet, (int)this._row, (int)this._column, (int)this._lastRow, (int)this._lastColumn);
            if (reserveContent) {
                targetRange.clearContents();
            }
            if (reserveStyle && (this.isWholeRow() || this.isWholeColumn())) {
                targetRange.clearCellStyles();
            }
            if (reserveStyle && this.isWholeRow() && this._columns != null) {
                for (ReservedColumn rcol : this._columns.values()) {
                    SColumn column = this._sheet.getColumn(rcol.getIndex());
                    column.setCellStyle(rcol.getStyle());
                    column.setCustomWidth(rcol.isCustomWidth());
                    column.setWidth(rcol.getWidth());
                }
            }
            if (this._rows != null) {
                for (ReservedRow rrow : this._rows.values()) {
                    if (reserveStyle && this.isWholeColumn()) {
                        SRow row = this._sheet.getRow(rrow.getIndex());
                        row.setCellStyle(rrow.getStyle());
                        row.setCustomHeight(rrow.isCustomHegiht());
                        row.setHeight(rrow.getHeight());
                    }
                    for (ReservedCell rcell : rrow.getReservedCells()) {
                        SCell cell = this._sheet.getCell(rrow.getIndex(), rcell.getColumnIndex());
                        if (reserveContent) {
                            tempRange = SRanges.range((SSheet)this._sheet, (int)rrow.getIndex(), (int)rcell.getColumnIndex());
                            ReservedCellContent data = rcell.getContent();
                            if (data != null) {
                                data.apply(tempRange);
                            }
                        }
                        if (!reserveStyle) continue;
                        SCellStyle style = rcell.getStyle();
                        cell.setCellStyle(style);
                    }
                }
            }
            if (reserveStyle) {
                targetRange.notifyChange();
            }
            if (reserveMerge && this._mergeInfo != null) {
                for (Object rect : this._mergeInfo) {
                    tempRange = SRanges.range((SSheet)this._sheet, (CellRegion)rect);
                    tempRange.merge(false);
                }
            }
        }
    }
}

